<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_coursemanager', language 'sr_lt', version '5.0'.
 *
 * @package     report_coursemanager
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admin_course_managerinfo'] = '<p>Ova stranica daje pristup alatu za Moodle administratore. Za podešavanja\'Menadžera kurseva\', idite na Dodaci > Izveštaji > Menadžer kurseva.</p>';
$string['admin_files_distribution_info'] = '<p>Ovaj alat daje izveštaj o različitim komponentama u skladištu datoteka i ukupnoj veličini za svaku od komponenti.</p>';
$string['admin_no_teacher_courses_info'] = '<p>Ovaj alat navodi sve kurseve na kojima nijedan korisnik nije upisan kao predavač i eventualno ih premešta u kategoriju \'Otpaci\' ako je to potrebno.</p>';
$string['admin_orphan_submissions_info'] = '<p>Napušteni predati radovi su datoteke koje su predali polaznici, koji više nisu upisani na kurs.
 <b>Te datoteke su za predavače nevidljive i mogu se videti samo ako se polaznici ponovo upišu na kurs.</b> Ukoliko se svake godine koriste isti zadaci bez resetovanja, ove skrivene datoteke
 mogu zauzeti veliki prostor u vašam moodledata direktorijumu.<br />
 Ovaj alat može obrisati ove skrivene datoteke <b>bez brisanja datoteka koje su predali studenti koji su još uvek upisani na kurs.<b></p>';
$string['admin_stats_info'] = '<p>Ova stranica prikazuje statistiku koja je uglavnom zasnovana na izveštajima koje daju dodatak Menadžera kurseva. Takođe, stranica pruža statistiku i o nekoliko aspekata koji se tiču funkcija Menadžera kurseva, kao što su kursevi bez predavača ili kursevi u kategoriji \'Otpaci\'.</p>';
$string['adminnoteachercoursesnote'] = '<ul class="alert alert-info"><li>Informacije o veličini kursa i broju aktivnosti se ne izračunavaju u realnom vremenu.</li>
<li>Informacije o poslednjem zapisu predavača zasnivaju se na polju edulevel u tabeli baze podataka logstore. Izmenjena ovlašćenja mogu da iskrive ovaj rezultat.</li></ul>';
$string['adminnoteachercoursesweight'] = '<ul class="alert alert-warning"> Zadatak za izračunavanje veličine je aktiviran. Kursevi za koje veličina još nije izračunata neće se pojaviti na ovom spisku. Ako je potrebno, pokrenite zadatak ručno ili sačekajte sledeće pokretanje krona.';
$string['advices_for_course'] = 'preporuke';
$string['aggregationaverage'] = 'prosek';
$string['aggregationboth'] = 'i prosek i medijana';
$string['aggregationchoice'] = 'Izaberite način za poređenje veličine kursa';
$string['aggregationchoice_desc'] = 'Ako je omogućeno poređenje veličine kursa, ono može biti bazirano na prosečnoj veličini ili vrednosti medijane.';
$string['aggregationmedian'] = 'medijana';
$string['all_courses'] = 'Svi kursevi';
$string['button_delete_cohort_confirm'] = 'Poništi upis kohorti';
$string['button_move_confirm'] = 'Potvrdi brisanje';
$string['button_restore_confirm'] = 'Potvrdi restauraciju kursa';
$string['button_save_course'] = 'Rezervna kopija kursa';
$string['button_save_questionbank'] = 'Rezervna kopija banke pitanja';
$string['capability_problem'] = 'Nemate ovlašćenje da vidite ovu stranicu.';
$string['category_bin'] = 'Kategorija za otpatke';
$string['category_bin_desc'] = 'Ako predavač obriše kurs preko kontrolnog panela, on se premešta u ovu kategoriju pre nego što ga administrator definitivno ne obriše.';
$string['closereportmodal'] = 'Zatvori prozor';
$string['collapse_show_report'] = 'Prikaži izveštaj';
$string['comment'] = 'Preporuke';
$string['configmenuactions'] = 'Meni sa akcijama';
$string['configmenuactions_desc'] = 'Izaberite akcije koje će biti prikazane u meniju sa akcijama na kontrolnom panelu.';
$string['configtitle'] = 'Podešavanja\'Menadžera kurseva\'';
$string['confirm_cohort_unenrolled_message'] = 'Sve kohorte su ispisane sa kursa.';
$string['confirm_cohort_unenrolled_title'] = 'Kohorte obrisane';
$string['confirm_course_deleted_message'] = 'Kurs je premešten u kategoriju \'Otpaci\' i kasnije će ga obrisati administrator';
$string['confirm_course_deleted_title'] = 'Kurs obrisan';
$string['confirm_course_restored_message'] = 'Kurs je izmešten iz kategorije \'Otpaci\'. Imajte na umu da je restaurirani kurs još uvek skriven za polaznike, pa shodno tome razmislite o promeni podešavanja ako je potrebno.';
$string['confirm_course_restored_title'] = 'Kurs restauriran';
$string['course_alert_empty'] = 'Ovaj kurs nema sadržaja, osim eventualno izvornog foruma. Razmislite o brisanju ovog kursa ako se više ne koristi.<br /><b>{$a->delete_link}</b>';
$string['course_alert_heavy'] = 'Ukupna veličina datoteka na ovom kursu je zapravo <b>{$a->size}</b>. Razmislite o sortiranju datoteka ili resetovanju ovog kursa.<br /><b>{$a->heavy_link}</b';
$string['course_alert_no_student'] = '<b>Nijedan polaznik nije upisan na ovaj kurs</b>. Razmislite o brisanju ovog kursa ako se više ne koristi.<br /><b>{$a->delete_link}</b>';
$string['course_alert_no_visit_student'] = 'Nijedan polaznik nije posetio ovaj kurs više od {$a->no_teacher_time} dana. Razmislite o brisanju ovog kursa ako se više ne koristi.<br /><b>{$a->delete_link} | {$a->reset_link}</b>';
$string['course_alert_no_visit_teacher'] = 'Nijedan predavač nije posetio ovaj kurs više od {$a->no_teacher_time} dana. Razmislite o brisanju ovog kursa ako se više ne koristi.<br /><b>{$a->delete_link}</b>';
$string['course_alert_orphan_submissions'] = 'Ovaj kurs sadrži zadatke sa nevidljivim predatim radovima, koje su postavili ispisani polaznici. Molimo razmislite o resetovanju ovog kursa ako možete.';
$string['course_cohort_unenrolled'] = 'Kohorte ispisane';
$string['course_dashboard_viewed'] = 'Kontrolni panel predavača posećen';
$string['course_files_viewed'] = 'Stranica sa izveštajem o datotekama je posećena';
$string['course_global_reset'] = 'Kurs je resetovan pomoću funkcije Menadžera kurseva';
$string['course_restored'] = 'Kurs je izmešten iz kategorije \'Otpaci\' i restauriran.';
$string['course_state_hidden'] = 'Sakriveno';
$string['course_state_trash'] = 'Za brisanje';
$string['course_state_visible'] = 'Vidljivo';
$string['course_trash_moved'] = 'Kurs je premešten u kategoriju \'Otpaci\'';
$string['coursemanager:admintools'] = 'Korićenje administratorske alatke u sekciji Izveštaj';
$string['coursemanager:viewreport'] = 'Pregled izveštaja na kursu ako je omogućeno';
$string['coursesize'] = 'Veličina kursa';
$string['dashboardsettingsheading'] = 'Podešavanja kontrolnog panela';
$string['delete_already_moved'] = 'Ovaj kurs je već u kategoriju \'Otpaci\'';
$string['delete_cohort_confirm'] = 'Ova funkcija će ispisati sa vašeg kursa sve kohorte.<br />
Imajte na umu da će ispisivanje članova kohorte sa kursa učiniti da nestanu neki podaci kao što su npr. poruke na forumima, <b> ali ne i pokušaji rešavanja testa ili predati radovi</b>.
Razmislite o mogućnostu da iskoristite funkcije resetovanja za brisanje ličnih podataka.
<p class="alert alert-primary"><i class="fa fa-question-circle-o"></i> <b> NAPOMENA:</b> u zavisnosti od broja kohorti koje treba ispisati, ovaj proces može potrajati.</p>';
$string['delete_period'] = 'Vremenska naznaka za brisanje kursa';
$string['delete_period_desc'] = 'Ove informacije daju približan vremenski period potreban za brisanje kursa iz kategorije \'Otpaci\'.
 Možete napisati nešto poput "početkom jula" ili "na kraju godine". Ova informacija će biti prikazane u e-pošti kada predavač obriše kurs kao i na stranici za brisanje kursa.';
$string['delete_send_mail'] = 'Uloge koje treba sačuvati prilikom brisanja kursa';
$string['delete_send_mail_desc'] = 'Izaberite uloge koje će biti obaveštene e-poštom kada se kurs obriše';
$string['delete_several_teachers'] = '<h4><i class="fa fa-exclamation-triangle"></i> UPOZORENJE: NA OVOM KURSU IMA VIŠE PREDAVAČA!</h4>
Ako ovi predavači nisu obavešteni, uradite to sada.<br/>Brisanje kursa će poslati <b>automatsko obaveštenje e-poštom svakom predavaču na ovom kursu</b> kao upozorenje.<br /><br />
<h5>Ostali predavači na ovom kursu:</h5>';
$string['delete_wish'] = 'Šta želite da uradite?';
$string['deletecoursewithoutteachersconfirm'] = 'Da li želite da premestite ovaj kurs u kategoriju \'Otpaci\'?';
$string['deleteorphans'] = 'Obrišite napuštene predate radove';
$string['deleteorphansubmissionsconfirm'] = 'Da li želite da obrišete napuštene predate radove u ovom zadatku? Ova akcija je nepovratna.';
$string['empty_course_alert'] = '<b>Prazan kurs.</b>Ovaj kurs sadrži samo izvorni forum. Ako nije planirano dodavanje sadržaja, razmislite o brisanju ovog kursa.';
$string['empty_files_course'] = 'Izgleda da ovaj kurs još uvek ne sadrži datoteke.';
$string['empty_settings'] = 'Neka podešavanja nedostaju za ovaj dodatak; obratite se svom Moodle administratoru';
$string['empty_student_alert'] = '<b>Nijedan student nije upisan</b><br />Nema korisnika koji su upisani na ovaj kurs kao polaznici. Ako se kurs više ne koristi, razmislite o brisanju!';
$string['emptytablenoteacherincourses'] = 'Nema rezultata: svi kursevi imaju predavača';
$string['enableactioncohorts'] = 'Link ka odjavi iz kohorti';
$string['enableactioncoursefiles'] = 'Link ka stranici sa datotekama kursa';
$string['enableactionparams'] = 'Link ka podešavanjima kursa';
$string['enableactionreset'] = 'Link ka pojednostavljenom resetovanju kursa';
$string['enablecolumncohorts'] = 'Prikaži kolonu \'Kohorte\'';
$string['enablecolumncohorts_desc'] = 'Ako je polje označeno, biće prikazana ljkolonu koja sadrži broj kohorti upisanih na kurs.';
$string['enablecolumncomparison'] = 'Prikaži kolonu za poređenje';
$string['enablecolumncomparison_desc'] = 'Ako je polje označeno, biće prikazana kolona gde se veličina svakog kursa upoređuje sa drugim kursevima. Možete birati između medijane ili prosečne vrednosti.';
$string['enablecolumncoursesize'] = 'Prikaži kolonu \'Veličina kursa\'';
$string['enablecolumncoursesize_desc'] = 'Ako je polje označeno, biće prikazana kolona koja pokazuje ukupnu veličinu datoteka na kursu.';
$string['enablecolumnstudents'] = 'Prikaži kolonu \'Polaznici\'';
$string['enablecolumnstudents_desc'] = 'Ako je polje označeno, biće prikazana kolona koja sadrži broj polaznika upisanih na kurs.';
$string['enablecolumnteachers'] = 'Prikaži kolonu \'Predavači\'';
$string['enablecolumnteachers_desc'] = 'Ako je polje označeno, biće prikazana kolona koja sadrži broj predavača upisanih na kurs.';
$string['enablecoursecontenttask'] = 'Aktivirajte izveštaje o praznim ili velikim kursevima';
$string['enablecoursecontenttask_desc'] = 'Ako je označeno, biće aktiviran automatizovani zadatak za otkrivanje velikih ili kurseva bez sadržaja.';
$string['enablemailing'] = 'Aktivirajte slanje izveštaja e-poštom';
$string['enablemailing_desc'] = 'Ako je označeno, biće aktiviran automatizovani zadatak za slanje izveštaja e-poštom. Podrazumevana periodičnost je svakih 30 dana.';
$string['enableorphanstask'] = 'Aktivirajte izveštaj o napuštenim predatim radovima';
$string['enableorphanstask_desc'] = 'Ako je označeno, biće aktiviran automatizovani zadatak za otkrivanje Zadataka sa napuštenim datotekama.';
$string['enablestudentstask'] = 'Aktivirajte izveštaje o posetama i upisima polaznika';
$string['enablestudentstask_desc'] = 'Ako je označeno, biće aktiviran automatizovani zadatak za otkrivanje kurseva bez polaznika ili bez skorašnjih poseta polaznika kursu.';
$string['enableteacherstask'] = 'Aktivirajte izveštaje o posetama i upisima predavača';
$string['enableteacherstask_desc'] = 'Ako je označeno, biće aktiviran automatizovani zadatak za otkrivanje kurseva bez predavača ili bez skorašnjih poseta predavača kursu.';
$string['error_category'] = 'Izabrana je pogrešna kategorija';
$string['filesdistributiontablecomponent'] = 'Kompoenenta';
$string['filesdistributiontotalfiles'] = 'Broj datoteka';
$string['filesdistributiontotalweight'] = 'Ukupna veličina datoteka u MB';
$string['global_chart'] = 'Distribucija veličine datoteka po aktivnostima';
$string['head_average_help'] = 'Ovo kolona upoređuje veličinu svakog kursa sa izračunatom prosečnom veličinom kursa:
<ul>
<li><i class=\'fa fa-arrow-circle-down text-success\'></i> ukazuje da je veličina ovog kursa veća od prosečne ;</li>
<li><i class=\'fa fa-arrow-circle-up text-danger\'></i> ukazuje da je veličina ovog kursa manja od prosečne ;</li>
<li><i class=\'fa fa-question-circle text-info\'></i> ukazuje da je veličina ovog kursa 0 ili da još uvek nije izračunata.</li>
</ul>';
$string['head_median_help'] = 'Ovo kolona upoređuje veličinu svakog kursa sa izračunatom medijanom kursa:
<ul>
<li><i class=\'fa fa-arrow-circle-down text-success\'></i> ukazuje da je veličina ovog kursa veća od medijane ;</li>
<li><i class=\'fa fa-arrow-circle-up text-danger\'></i> ukazuje da je veličina ovog kursa manja od medijane ;</li>
<li><i class=\'fa fa-question-circle text-info\'></i> ukazuje da je veličina ovog kursa 0 ili da još uvek nije izračunata.</li>
</ul>';
$string['heavy_course'] = 'Veliki kursevi';
$string['last_access_multiple_teacher_alert'] = '<b>Nema posete predavača poslednja/ih {$a->limit_visit} meseca/i.</b><br /> Nijedan predavač već duže vreme nije posetio ovaj kurs. Ako ga ne koristi nijedan predavač, razmislite o njegovom brisanju!';
$string['last_access_student'] = 'Ograničenje za poslednji pristup polaznika (u danima)';
$string['last_access_student_alert'] = '<b>Nema posete polaznika poslednja/ih {$a->limit_visit} meseca/i.</b><br /> Nijedan polaznik već duže vreme nije posetio ovaj kurs. Ako je potrebno, obrišite ga.';
$string['last_access_student_desc'] = 'Broj dana od kada polaznik nije posetio kurs';
$string['last_access_teacher'] = 'Ograničenje za poslednji pristup predavača (u danima)';
$string['last_access_teacher_desc'] = 'Broj dana od kada predavač nije posetio kurs';
$string['last_access_unique_teacher_alert'] = '<b>Niste posetili ovaj kurs {$a->limit_visit} meseci.</b><br />Vi ste jedini predavač na ovom kursu. Ako ga više ne koristite, razmislite o brisanju.';
$string['mail_message_delete_main_teacher'] = 'Poštovani/а,<br />
Kurs {$a->course} je prebačen u kategoriju \'Otpaci\' pre nego što bude kompletno obrisan {$a->delete_period}. Pre konačnog brisanja, još uvek možete pristupiti ovom kursu ukoliko želite da preuzmete podatke.<br />
Ako želite da povratite ovaj kurs, premestite ga iz kategorije \'Otpaci\' na kontrolnom panelu Menadžera kurseva.
NAPOMENA: {$a->count_teacher} - ovaj broj predavača bio je upisan na ovaj kurs. Poslata im je e-poruka sa upozorenjem da ste obrisali kurs. Kako su i oni predavači, imaju mogućnost da povrate kurs ili podatke u njemu, ukoliko je potrebno.';
$string['mail_message_delete_oneteacher'] = 'Poštovani/а,<br />
Kurs {$a->course} je prebačen u kategoriju \'Otpaci\' pre nego što bude kompletno obrisan {$a->delete_period}. Pre konačnog brisanja, još uvek možete pristupiti ovom kursu ukoliko želite da preuzmete podatke.<br />
Ako želite da povratite ovaj kurs, premestite ga iz kategorije \'Otpaci\' na kontrolnom panelu Menadžera kurseva.';
$string['mail_message_delete_other_teacher'] = 'Poštovani/а,<br />
Korisnik {$a->deleter} je prebacio kurs {$a->course} u kategoriju \'Otpaci\' pre nego što on bude kompletno obrisan {$a->delete_period}. Pre konačnog brisanja, još uvek možete pristupiti ovom kursu ukoliko želite da preuzmete podatke.<br />
Ako želite da povratite ovaj kurs, premestite ga iz kategorije \'Otpaci\' na kontrolnom panelu Menadžera kurseva.';
$string['mail_subject_delete'] = 'Obrisan je kursa - {$a->course}';
$string['mailingddescreportempty'] = 'Ovi kursevi nemaju nikakv sadržaj, eventualno osim izvornog Moodle foruma.';
$string['mailingddescreportheavy'] = 'Čini se da je ukupna veličina datoteka u ovom kursu velika. Kliknite na naziv kursa kako biste videli izveštaj o datotekama.';
$string['mailingddescreportnostudent'] = 'Nema studenata upisanih na ove kurseve.';
$string['mailingddescreportnovisitstudent'] = 'Studenti već duže vreme nisu posećivali ove kurseve.';
$string['mailingddescreportnovisitteacher'] = 'Predavači, uključujući i vas, već duže vreme nisu posećivali ove kurseve';
$string['mailingddescreportorphansubmissions'] = 'Neki zadaci na ovim kursevima imaju skrivene predate radove koje su postavili ispisani polaznici. Ove datoteke mogu biti veoma velike i zauzimati veliki prostor.';
$string['mailingheading'] = 'Predavači šalju e-poštu';
$string['mailingintro'] = '<p> Poštovani/a %userfirstname%,</p>
<p>Menadžer kurseva predstavlja skupa alata koji pomažu predavačima da upravljaju svojim kursevima koristeći proračunate izveštaje. Ova e-poruka rezimira ove izveštaje i ukazuje na kurseve kod kojih se javljaju problemi.</p>
<p><b>Ovi izveštaji imaju svrhu samo da vašu pažnju usmere na određene aspekte upravljanja vašim kursevima, kao i da vam daju primer dobre prakse u korišćenju Moodlea</b></p>
<p>Za više informacija posetite svoj lični <a href="%coursemanagerlink%">Kontrolni panel Menadžera kurseva</a>';
$string['mailingintro_setting'] = 'Sadržaj e-pošte';
$string['mailingintro_setting_desc'] = 'Uvod u izveštaj koji se šalje e-poštom.<br>
Možete koristiti sledeće promenljive:<br>
%userfirstname% : ime korisnika<br>
%userlastname% : prezime korisnika<br>
%coursemanagerlink% : link Menadžera kurseva';
$string['mailingoutro'] = 'Za više informacija o ovim izveštajima, obratite se Moodle administratoru ili službu za podršku.';
$string['mailingoutro_setting'] = 'Završetak e-poruke';
$string['mailingoutro_setting_desc'] = 'Kraj sadržaja izveštaja koji se šalje poštom.';
$string['mailingtask'] = 'Slanje izveštaja Menadžera kurseva e-poštom za predavače';
$string['mailingtitle'] = 'Menadžer kurseva - Izveštaji o vašim kursevima';
$string['mailingtitle_setting'] = 'Tema e-poruke';
$string['mailingtitle_setting_desc'] = 'Tema poruke koja se šalje predavačima.';
$string['menucoursefilesinfo'] = 'Pogledaj datoteke na kursu';
$string['menucourseparameters'] = 'Podešavanja kursa';
$string['menudeletecourse'] = 'Obriši kurs';
$string['menuenrolcohorts'] = 'Dodaj kohorte';
$string['menureset'] = 'Resetuj kurs';
$string['menurestorecourse'] = 'Restauriraj kurs';
$string['menuunenrolcohorts'] = 'Grupno ispisavanje kohorti';
$string['more_information'] = 'Više informacija';
$string['move_confirm'] = '<div class="alert alert-danger"><h5>Pažljivo pročitajte pre brisanja</h5></div>
<p><b>Ova stranica vam omogućava da kurs koji više ne koristite premestite u kategoriju \'Otpaci\'.</b><br/>Ako bude potvrđeno, ovaj kurs će biti premešten u određenu kategoriju i skriven za polaznike. Zatim će ga obrisati Moodle administrator <b>{$a->delete_period}</b>.</p>
<p> Pre brisanja, još uvek možete pristupiti ovom kursu ili ga povratiti ako je to potrebno. Upotebite komandu za restauraciju kursa na kontrolnom panelu Menadžer kurseva.</p>
<p> Pre brisanja razmislite o kreiranju rezervne kopije važnih datoteka ili banke pitanja. Ti podaci se ne mogu preuzeti nakon potpunog brisanja.';
$string['navbarlink'] = 'Dodajte link ka kontrolnom panelu u navigacionoj traci';
$string['navbarlink_desc'] = 'Ako je označeno, dodaje ikonicu u navigacionu traku pored obaveštenja.';
$string['no_advices'] = '<b>Nema konkretnih izveštaja.</b><br />Čestitamo, ovaj kurs izgleda ok!';
$string['no_cohort'] = '<p class="alert alert-info">Nijedna kohorta nije upisana na ovaj kurs!</p>';
$string['no_content'] = 'Prazni kursevi';
$string['no_course_to_show'] = '<h2>Nema kurseva</h2>Niste upisani na kurseve sa ulogom predavača.';
$string['no_student'] = 'Nijedan student nije upisan';
$string['no_visit_student'] = 'Nema poseta polaznika';
$string['no_visit_teacher'] = 'Nema poseta predavača';
$string['noassign'] = 'Nema zadataka na ovoj Moodle instanci.';
$string['number_of_files'] = 'Broj datoteka';
$string['ok'] = 'Nema izveštaja';
$string['orphan_submissions_alert'] = '<b>Napušteni predati radovi</b><br />Ovaj kurs ima {$a->assigns} Zadat(a)ka sa {$a->filescount} datoteke /ka koje su predali trenutno ispisani polaznici. Ove datoteke zauzimaju {$a->filesize} Mo (мегаоктета). Razmotrite mogućnost da resetujete ili obrišete ove aktivnosti.';
$string['orphan_submissions_button'] = 'Napušteni predati radovi';
$string['otherteacherroledashboard'] = 'Druge uloge predavača';
$string['otherteacherroledashboard_desc'] = 'Definiše druge uloge predavača koje treba uzeti u obzir (kao npr. predavač bez uređivačkih prava), na nalogu predavača na kontrolnom panelu, kao i posetama predavača kursu.';
$string['plugin'] = 'Vrsta aktivnosti';
$string['pluginname'] = 'Menadžer kurseva';
$string['privacy:no_data_reason'] = 'Dodatak \'Menadžer kurseva\' ne čuva nikakve lične podatke. On samo proračunava izveštaje proučavanjem sadržaja kurseva (podešavanja, upisani polaznici i predavači, broj aktivnosti...).';
$string['reportsheading'] = 'Izveštaji';
$string['reportssettingsheading'] = 'Podešavanja za izračunavanje izveštaja';
$string['reset_info'] = '<p class="alert alert-success"><i class="fa fa-info-circle"></i> Resetovanja može da obriše lične podatke polaznika na vašem kursu.
 <b>Ono ne briše vaše datoteke ili aktivnosti</b></p>
<p>Resetovanjem će biti obrisani:<ul>
<li><b>podaci o završetku aktivnosti</b> ;</li>
<li><b>ocene u dnevniku ocena </b> ;</li>
<li><b>grupe i grupisanja</b> ;</li>
<li><b>predati radovi u okviru aktivnosti Zadatak</b> ;</li>
<li><b>poruke na forumima</b> ;</li>
<li><b>pokušaji rešavanja testa</b> ;</li>
<li><b> upisane kohorte </b> (<span class="text-danger"><b>УПОЗОРЕЊЕ</b>: izvršavanje ove funkcije može potrajati dugo ako kurs ima mnogo polaznika!).</span></li></ul></p>
<p>Drugi podaci neće biti obrisani.</p>
<p>Ako želite da uspostavite početne vrednosti drugih aktivnosti, koristite <a href="/course/view.php?id="><b>funkciju resetovanja na vašem kursu</b></a>.<br /></p>
<h5 class="alert alert-primary"><i class="fa fa-question-circle-o"></i> <b> Šta želite da uradite?</b></h5>';
$string['reset_result'] = '<p><b>Kurs je resetovan.</b></p>
<p><b> Podsetnik </b>: nijedna datoteka ili aktivnosti nisu obrisani. Ako želite da resetujete sve ili druge aktivnosti, koristite funkciju resetovanja na kursu.</p>';
$string['restore_already_moved'] = 'Ovaj kurs nije u kategoriji \'Otpaci\'!';
$string['restore_confirm'] = '<p>Ova stranica će preuzeti kurs iz kategorije \'Otpaci\' i restaurirati ga u drugu kategoriju.</p>
<p class="alert alert-info"><i class="fa fa-info-circle"></i> NAPOMENA : nemojte restaurirati ovaj kurs u kategoriju <b>"{$a->trash_category}"</b> : ova kategorija je rezervisana za kurseve koji će biti obrisani <b>{$a->delete_period}</b>.</p>';
$string['runcleanreportstask'] = 'Čistač izveštaja Menadžera kurseva';
$string['runcoursecontentreporttask'] = 'Izveštaj menadžera kurseva za velike i prazne kurseve';
$string['runorphansubmissionstask'] = 'Izveštaj Menadžera kurseva za napuštene predate radove';
$string['runreportstask'] = 'Izračunavanje izveštaja za Menadžera kurseva';
$string['runstudentvisitreporttask'] = 'Izveštaj Menadžera kurseva za posete polaznika i kurseve bez polaznika';
$string['runteachervisitreporttask'] = 'Izveštaj Menadžera kurseva za posete predavača i kurseve bez predavača';
$string['see_advices'] = 'Rezime izveštaja';
$string['select_restore_category'] = 'Izaberite kategoriju u koju se kurs premešta';
$string['show_report_in_course'] = 'Prikaz izveštaja na kursu';
$string['show_report_in_course_choices_collapse'] = 'Meni sa klizačem pod menijem administratora kursa';
$string['show_report_in_course_choices_none'] = 'Ne prikazujte izveštaje na kursu';
$string['show_report_in_course_choices_popover'] = 'Ikonice pored naslova kursa';
$string['show_report_in_course_desc'] = 'Definiše mesto na kursu gde će se izveštaji biti prikazani';
$string['size'] = 'Veličina u MB';
$string['stats_count_courses'] = 'Broj kurseva';
$string['stats_count_courses_desc'] = 'Broj kurseva na Moodle instanci.';
$string['stats_count_courses_trash'] = 'Kursevi u kategoriji \'Otpaci\'';
$string['stats_count_courses_trash_desc'] = 'Broj kurseva u kategoriji \'Otpaci\' Menadžera kurseva';
$string['stats_count_courses_without_students'] = 'Kursevi bez polaznika';
$string['stats_count_courses_without_students_desc'] = 'Broj kurseva bez korisnika koji su upisani kao polaznici.';
$string['stats_count_courses_without_teachers'] = 'Kursevi bez predavača';
$string['stats_count_courses_without_teachers_desc'] = 'Broj kurseva bez korisnika upisanih sa ulogom predavača.';
$string['stats_count_courses_without_visit_students'] = 'Kursevi bez poseta polaznika';
$string['stats_count_courses_without_visit_students_desc'] = 'Broj kurseva bez posete polaznika u poslednjih {$a->lastaccessstudents} dana.';
$string['stats_count_courses_without_visit_teachers'] = 'Kursevi bez poseta predavača';
$string['stats_count_courses_without_visit_teachers_desc'] = 'Broj kurseva bez posete predavača u poslednjih {$a->lastaccessstudents} dana.';
$string['stats_empty_courses'] = 'Prazni kursevi';
$string['stats_empty_courses_desc'] = 'Broj kurseva koji od aktivnosti imaju samo izvorni forum.';
$string['stats_files_orphan_submissions'] = 'Ukupan broj datoteka napuštenih predatih radova';
$string['stats_files_orphan_submissions_desc'] = 'Broj datoteka koje se smatraju predatim radovima koji pripadaju neupisanim korisnicima.';
$string['stats_heaviest_course'] = 'Najveći kurs';
$string['stats_heaviest_course_desc'] = 'Najveći kurs na ovoj Moodle instanci, prema izveštajima Menadžera kurseva.';
$string['stats_heavy_courses'] = 'Veliki kursevi';
$string['stats_heavy_courses_desc'] = 'Kursevi koji su veći od {$a->totalfilesizethreshold} MB. Ovaj prag je definisan u podešavanjima Menadžera kurseva.';
$string['stats_title_contents'] = 'Sadržaj i veličina kurseva';
$string['stats_title_courses'] = 'Statistika kurseva';
$string['stats_title_enrolls_visits'] = 'Upisi na kursevima i posete';
$string['stats_weight_courses_orphan_submissions'] = 'Veličina napuštenih predatih radova';
$string['stats_weight_courses_orphan_submissions_desc'] = 'Укупна величина датотеке за напуштене предате радове';
$string['stats_weight_courses_trash'] = 'Ukupna veličina kurseva u kategorji \'Otpaci\'';
$string['stats_weight_courses_trash_desc'] = 'Ukupna veličina datoteka aktivnosti iz kurseva u kategoriji \'Otpaci\' Menadžera kurseva.';
$string['studentrolereport'] = 'Uloga polaznika na kursevima';
$string['studentrolereport_desc'] = 'Definiše ulogu polaznika za izračunavanje izveštaja. Podrazumevana uloga je Moodle polaznik.';
$string['table_actions'] = 'Akcije';
$string['table_assign_name'] = 'Naziv zadatka';
$string['table_course_name'] = 'Naziv kursa';
$string['table_course_state'] = 'Vidljivost';
$string['table_enrolled_cohorts'] = 'Kohorte';
$string['table_enrolled_students'] = 'Polaznici';
$string['table_enrolled_teachers'] = 'Predavači';
$string['table_files_count'] = 'Broj skrivenih datoteka';
$string['table_files_weight'] = 'Ukupna veličina datoteka';
$string['table_recommendation'] = 'Izveštaji';
$string['table_size_comparison_average'] = 'Poređenje - prosečna veličina kursa';
$string['table_size_comparison_median'] = 'Poređenje - medijana veličine kursa';
$string['table_tool_description'] = '<p>Opis</p>';
$string['table_tool_name'] = '<p>Alat</p>';
$string['tablecountenrolledstudents'] = 'Polaznici';
$string['tablecountmodules'] = 'Broj aktivnosti';
$string['tablecourseweight'] = 'Veličina kursa';
$string['tablehascontents'] = 'Broj sadržaja';
$string['tablelastaccess'] = 'Poslednji pristup kursu';
$string['tablelastteacher'] = 'Poslednji aktivni predavač';
$string['tablelastteacherlog'] = 'Poslednji zapis o aktivnosti predavača';
$string['teacherroledashboard'] = 'Uloga predavača na kursevima';
$string['teacherroledashboard_desc'] = 'Definiše ulogu predavača koja može da prikaže spisak kurseva na kontrolnom panelu Menadžera kurseva. Podrazumevana uloga je Moodle predavač.';
$string['text_filter'] = 'Unesite nekoliko znakova naziva kursa';
$string['text_link_delete'] = 'Obriši kurs';
$string['text_link_reset'] = 'Resetuj kurs';
$string['title'] = 'Menadžer kurseva za predavače';
$string['title_admin_files_distribution'] = '<b>Distribucija datoteke po komponenti</b>';
$string['title_admin_no_teacher_courses'] = '<b>Upravljanje kursevima bez predavača</b>';
$string['title_admin_orphan_submissions'] = '<b>Upravljanje napuštenim predatim radovima</b>';
$string['title_admin_stats'] = '<b>Statistika</b>';
$string['title_delete_cohort_confirm'] = 'Poništi upis kohorti';
$string['title_move_confirm'] = 'Brisanje kursa';
$string['title_restore_confirm'] = 'Restauriraj kurs';
$string['total_filesize_alert'] = '<b>Ovaj kurs je veliк.</b><br />Pogledajte<a href="course_files.php?courseid={$a->courseid}">izveštaj o datotekama kursa</a> kako biste videli najveće datoteke.';
$string['total_filesize_threshold'] = 'Maksimalna veličina kursa (MB)';
$string['total_filesize_threshold_desc'] = 'Ako ukupna veličina datoteka premašuje ovo ograničenje, izveštaj će biti izračunat za predmetne kurseve.';
$string['totalsize'] = 'Ukupna veličina datoteka :';
$string['trash'] = 'Ovaj kurs je u kategoriji za obrisane kurseve.';
$string['trashsettingsheading'] = 'Podešavanja za kategoriju \'Otpaci\' i za brisanje kurseva';
$string['unique_filesize_threshold'] = 'Maksimalna veličina datoteke (MB)';
$string['unique_filesize_threshold_desc'] = 'Ako veličina datoteke premašuje ovo ograničenje, ona će biti prikazana na spisku velikih datoteka u izveštaju o svim datotekama na kursu.';
$string['unknown'] = 'Nepoznato';
$string['warn_big_files'] = 'Ove datoteke su <b>veoma velike</b> :';
$string['warn_big_files_help'] = 'Ako je veličina datoteke važna, razmislite o sledećim opcijama:
<ul>
<li>arhivirajte (”zipujete”) datoteku;</li>
<li>ako postoje slike, pokušajte da smanjite njihove rezolucije;</li>
<li> koristite eksterni repozitorijum ako možete.</li>
<li></li>
</ul>';
$string['warn_heavy_assign'] = 'Ovi zadaci imaju veoma velike datoteke :';
$string['warn_heavy_assign_help'] = '<b>Pripazite na ove zadatke</b> i razmislite o njihovom resetovanju ili brisanju kada se više ne budu koristili.';
$string['warn_orphans'] = 'Ovi zadaci sadrže<b>napuštene predate radove</b> :';
$string['warn_orphans_help'] = '<p>Datoteke kojue su predali ispisani polaznici su još uvek ovde.</p>
<p> Molimo vas da razmotrite mogućnost: <ul>
<li>brisanja zadataka sa napuštenim predatim radovima;</li>
<li>restovanja aktivnosti ili celog kursa.</li></ul></p>';
$string['warn_recyclebin'] = '<p class="alert alert-info"><i class="fa fa-info-circle"></i> <b>Imajte na umu</b> da je korpa za otpatke aktivirana na Moodleu. Obrisane datoteke biće uključeni u ovaj grafikon sve dok predavač ne isprazni korpu za otpatke.</p>';
$string['warn_videos'] = 'Te datoteke su <b>video klipovi</b>, razmislite o tome da ih premestite:';
$string['warn_videos_help'] = 'Video klipovi mogu biti veoma veliki. Ako možete, otpremite ih na neki od veb servisa namenjenih video snimcima (WebTV, YouTube...).';
$string['warntextcategorytrash'] = 'UPOZORENJE : Ovu kategoriju Menadžer kurseva koristi kao mesto za otpatke. Očekuje se da će svi kursevi u ovoj kategoriji kasnije biti obrisani. Ako želite da zadržite svoj kurs, premestite ga u drugu kategoriju.';
$string['warntextcoursetrash'] = 'UPOZORENJE: ovaj kurs je u kategoriji \'Otpaci\' i biće obrisan kasnije. Premestite ga u drugu kategoriju pomoću alatke za upravljanje kursevima ako želite da ga zadržite.';
$string['watchedfilessize'] = 'Ukupna veličina najgledanijih datoteka:';
$string['watchedfilessizedetails'] = 'Ove datoteke potiču iz najčešće korišćenih aktivnosti: Zadatak, Resurs, Forum, Direktorijum i Multimedijalni natpis.';
$string['weight_not_calculated'] = 'Veličina datoteke još nije izračunata';
