<?php
/*
This file is part of miniBB. miniBB is free discussion forums/message board software, supplied with no warranties.
Check COPYING file for more details.
Copyright (C) 2020 Paul Puzyrev. www.minibb.com
Latest File Update: 2023-02-28
*/
if (!defined('INCLUDED776')) die ('Fatal error.');

include ($pathToFiles.'bb_codes.php');

//--------------->
if(!function_exists('customized_conversion')){
function customized_conversion($str) {

$newStr=$str;

$searchArr=array();
$replaceArr=array();

//apostrophes ISO/UTF
$searchArr[]='&#8216;'; $replaceArr[]="'";
$searchArr[]='&#8217;'; $replaceArr[]="'";
$searchArr[]=chr(226).chr(128).chr(152); $replaceArr[]="'";
$searchArr[]=chr(226).chr(128).chr(153); $replaceArr[]="'";

//quotes ISO/UTF
$searchArr[]='&#8220;'; $replaceArr[]='"';
$searchArr[]='&#8221;'; $replaceArr[]='"';
$searchArr[]=chr(226).chr(128).chr(156); $replaceArr[]='"';
$searchArr[]=chr(226).chr(128).chr(157); $replaceArr[]='"';

//middot ISO/UTF
$searchArr[]='&#8226;'; $replaceArr[]='&middot;';
$searchArr[]=chr(226).chr(128).chr(162); $replaceArr[]='&middot;';

//three dots ISO/UTF
$searchArr[]='&#8230;'; $replaceArr[]='...';
$searchArr[]=chr(226).chr(128).chr(166); $replaceArr[]='...';

//trademark
$searchArr[]=chr(226).chr(132).chr(162); $replaceArr[]='&trade;';

//baseline apostrophe ISO/UTF
$searchArr[]='&#8218;'; $replaceArr[]="'";
$searchArr[]=chr(226).chr(128).chr(154); $replaceArr[]="'";

//baseline quote
$searchArr[]='&#8222;'; $replaceArr[]='"';
$searchArr[]=chr(226).chr(128).chr(158); $replaceArr[]='"';

//euro
$searchArr[]='&#8364;'; $replaceArr[]='&euro;';
$searchArr[]=chr(226).chr(130).chr(172); $replaceArr[]='&euro;';

//pound - FF/IE UTF
$searchArr[]=chr(194).chr(163); $replaceArr[]='&pound;';
//$searchArr[]=chr(163); $replaceArr[]='&pound;';

//
$searchArr[]=chr(194).chr(176); $replaceArr[]='&deg;';
//$searchArr[]=''; $replaceArr[]='&deg;';

//Right-To-Left Override
$searchArr[]='&#8238;'; $replaceArr[]='';

//&mdash;
if(isset($GLOBALS['enableDash'])) {
$searchArr[]=' - '; $replaceArr[]=' '.$GLOBALS['enableDash'].' ';
$searchArr[]=' '.chr(150).' '; $replaceArr[]=' '.$GLOBALS['enableDash'].' ';
$searchArr[]=chr(10).'- '; $replaceArr[]=chr(10).$GLOBALS['enableDash'].' ';
}

if(isset($GLOBALS['enableDash'])) $sp=' '; else $sp='';
$newStr=str_replace($searchArr, $replaceArr, $sp.$newStr);

/*
$searchArr=array();
for($i=130;$i<=156;$i++){
$searchArr[]=chr($i);
}
$replaceArr=array(',', 'NLG', '"', '...', '**', '***', '^', 'o/oo', 'S', '<', 'OE', '', 'Z', '', '', "'", "'", '"', '"', '&middot;', '-', '--', '~', '&reg;', 's', '>', 'oe');
*/
//$newStr=str_replace($searchArr, $replaceArr, $newStr);

return $newStr;
}
}

//--------------->
function wrapText($wrap, $fragment){

if(strlen_unicode($fragment)<=$wrap) return $fragment;
else{

//if(!isset($GLOBALS['chunkStr'])) $chunkStr='<wbr>'; else 
$chunkStr=$GLOBALS['chunkStr'];
//if(!isset($GLOBALS['splitExpression'])) $splitExpression='//u'; else 
$splitExpression=$GLOBALS['splitExpression'];

$s='';
$isTag=FALSE;
$isAmp=FALSE;

$cntSplit=0;

$str=preg_split($splitExpression, $fragment, 0, PREG_SPLIT_NO_EMPTY);

if(is_array($str)){

foreach($str as $i=>$char){

$skipCnt=FALSE;

if($char=='<') { $isTag=TRUE; }
if($isTag and $char=='>') { $isTag=FALSE; $skipCnt=TRUE; }

if($char=='&') { $isAmp=TRUE; }

if($isAmp and $char==';') {
$isAmp=FALSE;
}

//echo $cntSplit.' -- '.$char.' -- '.ord($char).'<br>';
$s.=$char;

if(!$isTag and !$isAmp) {

if(ord($char)==32 or ord($char)==13 or ord($char)==10) $cntSplit=0;

if(!$skipCnt) $cntSplit++;

if($cntSplit==$wrap) {

//echo $cntSplit.' -- <font color="blue">'.htmlspecialchars($chunkStr).'</font><br>';
$s.=$chunkStr;
$cntSplit=0;

}

}

}

if(substr($s, -strlen($chunkStr))==$chunkStr) $s=substr($s, 0, strlen($s)-strlen($chunkStr));

$s=str_replace($chunkStr.$GLOBALS['brtag'], $GLOBALS['brtag'], $s);

//$s=str_replace(array($chunkStr.$GLOBALS['brtag'], ']'.$chunkStr, '.'.$chunkStr), array($GLOBALS['brtag'], ']'.$GLOBALS['brtag'], '.'.$GLOBALS['brtag']), $s);

}

return $s;
}
}

//--------------->
function urlMaker($text){

/*
Only alphanumerics [0-9a-zA-Z], the special characters "$-_.+!*'()," [not including the quotes and # - ed], and reserved characters used for their reserved purposes may be used unencoded within a URL. http://www.rfc-editor.org/rfc/rfc1738.txt
*/

//[0-9a-zA-Z$-_.+!*'(),&=\#~]

$patterns=array('#(^|[ \n]|/>)'.str_replace('.', '\\.', $GLOBALS['main_url']).'([^<> \[\]\n\r]*)#i');
$replacements=array('\\1<a href="'.$GLOBALS['main_url'].'\\2" target="_blank">'.$GLOBALS['main_url'].'\\2</a>');

if($GLOBALS['tUrl']!=$GLOBALS['main_url']){

$patterns[]='#(^|[ \n]|/>)'.str_replace('.', '\\.', $GLOBALS['tUrl']).'([^<> \[\]\n\r]*)#i';
$replacements[]='\\1<a href="'.$GLOBALS['tUrl'].'\\2" target="_blank">'.$GLOBALS['tUrl'].'\\2</a>';

}

if(substr(strtolower($GLOBALS['main_url']), 0, 11)=='http://www.' or substr(strtolower($GLOBALS['main_url']), 0, 12)=='https://www.') {

$patterns[]='#(^|[ \n]|/>)www\.'.str_replace(array('http://www.', 'https://www.', '.'), array('', '', '\\.'), strtolower($GLOBALS['main_url'])).'([^<> \[\]\n\r]*)#i';
$replacements[]='\\1<a href="'.$GLOBALS['main_url'].'\\2" target="_blank">www.'.str_replace(array('http://www.', 'https://www.'), '', strtolower($GLOBALS['main_url'])).'\\2</a>';

}

if($GLOBALS['tUrl']!=$GLOBALS['main_url']){

if(substr(strtolower($GLOBALS['tUrl']), 0, 11)=='http://www.' or substr(strtolower($GLOBALS['tUrl']), 0, 12)=='https://www.') {

$patterns[]='#(^|[ \n]|/>)www\.'.str_replace(array('http://www.', 'https://www.', '.'), array('', '', '\\.'), strtolower($GLOBALS['tUrl'])).'([^<> \[\]\n\r]*)#i';
$replacements[]='\\1<a href="'.$GLOBALS['tUrl'].'\\2" target="_blank">www.'.str_replace(array('http://www.', 'https://www.'), '', strtolower($GLOBALS['tUrl'])).'\\2</a>';

}

}

if($GLOBALS['allowHyperlinks']==0  or $GLOBALS['user_id']==1 or ($GLOBALS['user_id']>1 and isset($GLOBALS['user_num_posts']) and $GLOBALS['user_num_posts']>=$GLOBALS['allowHyperlinks'])){

$patterns=array_merge($patterns, array("#(^|[ \n]|/>)(https|http|ftp)://([^<> \[\]\n\r]+)#i", "#(^|[ \n]|/>)ftp\.([^<> \[\]\n\r]+)#i", "#(^|[ \n]|/>)www\.([^<> \[\]\n\r]+)#i"));

$replacements=array_merge($replacements, array('\\1<a href="\\2://\\3" target="_blank"'.$GLOBALS['relFollowUrl'].'>\\2://\\3</a>', '\\1<a href="ftp://ftp.\\2" target="_blank"'.$GLOBALS['relFollowUrl'].'>ftp.\\2</a>', '\\1<a href="http://www.\\2" target="_blank"'.$GLOBALS['relFollowUrl'].'>www.\\2</a>'));

}

$ret=preg_replace($patterns, $replacements, $text);

if(preg_match("#<a href=\"(.+?)[.,\-:;?!]+\"#i", $ret)) {
$ret=preg_replace("#<a href=\"(.+?)[.,\-:;?!]+\"(.+?)>(.+?)</a>#is", '<a href="\\1"\\2>\\3</a>', $ret);
}

if(preg_match("#<a href=\"(.+?)/[\)\]/]+\"#i", $ret)) {
$ret=preg_replace("#<a href=\"(.+?)/([\)\]/]+)\"(.+?)>(.+?)</a>#is", '<a href="\\1/"\\3>\\1/</a>\\2', $ret);
}

return $ret;
}

//--------------->
function convert_entities($text){

$search=array('&amp;nbsp;', '&amp;iexcl;', '&amp;cent;', '&amp;pound;', '&amp;curren;', '&amp;yen;', '&amp;brvbar;', '&amp;sect;', '&amp;uml;', '&amp;copy;', '&amp;ordf;', '&amp;laquo;', '&amp;not;', '&amp;shy;', '&amp;reg;', '&amp;macr;', '&amp;deg;', '&amp;plusmn;', '&amp;sup2;', '&amp;sup3;', '&amp;acute;', '&amp;micro;', '&amp;para;', '&amp;middot;', '&amp;cedil;', '&amp;sup1;', '&amp;ordm;', '&amp;raquo;', '&amp;frac14;', '&amp;frac12;', '&amp;frac34;', '&amp;iquest;', '&amp;Agrave;', '&amp;Aacute;', '&amp;Acirc;', '&amp;Atilde;', '&amp;Auml;', '&amp;Aring;', '&amp;AElig;', '&amp;Ccedil;', '&amp;Egrave;', '&amp;Eacute;', '&amp;Ecirc;', '&amp;Euml;', '&amp;Igrave;', '&amp;Iacute;', '&amp;Icirc;', '&amp;Iuml;', '&amp;ETH;', '&amp;Ntilde;', '&amp;Ograve;', '&amp;Oacute;', '&amp;Ocirc;', '&amp;Otilde;', '&amp;Ouml;', '&amp;times;', '&amp;Oslash;', '&amp;Ugrave;', '&amp;Uacute;', '&amp;Ucirc;', '&amp;Uuml;', '&amp;Yacute;', '&amp;THORN;', '&amp;szlig;', '&amp;agrave;', '&amp;aacute;', '&amp;acirc;', '&amp;atilde;', '&amp;auml;', '&amp;aring;', '&amp;aelig;', '&amp;ccedil;', '&amp;egrave;', '&amp;eacute;', '&amp;ecirc;', '&amp;euml;', '&amp;igrave;', '&amp;iacute;', '&amp;icirc;', '&amp;iuml;', '&amp;eth;', '&amp;ntilde;', '&amp;ograve;', '&amp;oacute;', '&amp;ocirc;', '&amp;otilde;', '&amp;ouml;', '&amp;divide;', '&amp;oslash;', '&amp;ugrave;', '&amp;uacute;', '&amp;ucirc;', '&amp;uuml;', '&amp;yacute;', '&amp;thorn;', '&amp;yuml;', '&amp;euro;', '&amp;trade;', '&amp;ndash;', '&amp;mdash;', '&amp;thinsp;', '&amp;ensp;', '&amp;emsp;');

$replace=array(' ', '&#161;', '&#162;', '&#163;', '&#164;', '&#165;', '&#166;', '&#167;', '&#168;', '&#169;', '&#170;', '&#171;', '&#172;', '&#173;', '&#174;', '&#175;', '&#176;', '&#177;', '&#178;', '&#179;', '&#180;', '&#181;', '&#182;', '&#183;', '&#184;', '&#185;', '&#186;', '&#187;', '&#188;', '&#189;', '&#190;', '&#191;', '&#192;', '&#193;', '&#194;', '&#195;', '&#196;', '&#197;', '&#198;', '&#199;', '&#200;', '&#201;', '&#202;', '&#203;', '&#204;', '&#205;', '&#206;', '&#207;', '&#208;', '&#209;', '&#210;', '&#211;', '&#212;', '&#213;', '&#214;', '&#215;', '&#216;', '&#217;', '&#218;', '&#219;', '&#220;', '&#221;', '&#222;', '&#223;', '&#224;', '&#225;', '&#226;', '&#227;', '&#228;', '&#229;', '&#230;', '&#231;', '&#232;', '&#233;', '&#234;', '&#235;', '&#236;', '&#237;', '&#238;', '&#239;', '&#240;', '&#241;', '&#242;', '&#243;', '&#244;', '&#245;', '&#246;', '&#247;', '&#248;', '&#249;', '&#250;', '&#251;', '&#252;', '&#253;', '&#254;', '&#255;', '&#128;', '&#8482;', '&ndash;', '&mdash;', '&thinsp;', '&ensp;', '&emsp;');

return str_replace($search, $replace, $text);

}

//--------------->
function replaceQuotes($text, $q) {
$openTag=FALSE;
$foundQuote=FALSE;
$newText='';

for($i=0; $i<strlen($text); $i++){

$cc=$text[$i];

if($cc=='<') { $openTag=TRUE; $newText.=$cc; }
elseif($cc=='>') { $openTag=FALSE; $newText.=$cc; }
elseif($cc=='"'){
if(!$openTag) {
if(!$foundQuote) { $newText.=$q[0]; $foundQuote=TRUE; } else { $newText.=$q[1]; $foundQuote=FALSE; }
}
else $newText.='"';
}
else $newText.=$cc;

}

return $newText;
}

//--------------->
function textFilter($text,$size,$wrap,$urls,$bbcodes,$eofs,$admin,$shorten=0){

if($size and strlen_unicode($text)>$size) {
$text=substr_unicode($text, 0, $size);
if ($shorten>0 and strlen_unicode($text)>$shorten) $text=substr_unicode($text,0,$shorten);

if(substr_count($text, '&')>0){
/* Avoid special symbols extract */
$tmpArr=explode ('&', $text);
$last=sizeof($tmpArr)-1;
if ($last>0) {
if (substr_count($tmpArr[$last], ';')==0) array_pop($tmpArr);
$text=implode ('&', $tmpArr);
}
}

}

if(isset($GLOBALS['replaceQuotes']) and sizeof($GLOBALS['replaceQuotes'])==2){
$text=replaceQuotes($text, $GLOBALS['replaceQuotes']);
}

/*
for($i=0; $i<strlen($text); $i++){
echo $text[$i].' '.ord($text[$i]).'<br>';
}
exit;
*/

//echo $text.'+++++++++++';exit;
$text=customized_conversion($text);
//echo $text.'-----------';exit;
$text=addslashes($text);
//echo $text; exit;

if(($admin==1 or (isset($GLOBALS['isMod']) and $GLOBALS['isMod']==1)) and isset($GLOBALS['adminHTML']) and $GLOBALS['adminHTML']) $text=trim($text);
else $text=operate_string($text);

$text=str_replace(array('\&#039;', '\&quot;', chr(92).chr(92).chr(92).chr(92), chr(92).chr(92), '$'), array('&#039;', '&quot;', '&#92;&#92;', '&#92;', '&#036;'), $text);

$text=preg_replace("/&amp;#([0-9]);/", '&#\\1;', $text);

$text=convert_entities($text);

//if(isset($GLOBALS['l_meta']) and substr_count(strtolower($GLOBALS['l_meta']), 'utf-8')==0) $text=str_replace(array('', '', '', '', ''), array('&quot;', '&quot;', '&#039;', '&#039;', '...'), $text);

//if(substr_count($text, '&#9')>0) $text=preg_replace("@&#9[0-9]{2,};@", '', $text);

if(isset($GLOBALS['smartLinking']) and $GLOBALS['smartLinking'] and function_exists('smartLink')) $text=smartLink($text);

if (!$bbcodes) {
$text=enCodeBB($text, $admin);
$text=str_replace('><img src=','> <img src=',$text);
}

if($urls and !$bbcodes) {
$text=urlMaker($text);
}

$text=wrapText($wrap,$text);

$sce=FALSE; if(isset($GLOBALS['simpleCodes'])) foreach($GLOBALS['simpleCodes'] as $e) { if(substr_count($text, $e)>0) { $sce=TRUE; break; } }
if(trim(strip_tags($text))=='' and !$sce) return '';

if($eofs and !isset($GLOBALS['disableLineBreaks'])){
$text=str_replace("\r\n", "\n", $text);
$text=str_replace("\r", "\n", $text);
$text=preg_replace("#[\n]{3,}#", "\n\n", $text);
$text=str_replace("\n", $GLOBALS['brtag'], $text);
}
while(substr($text,-1)==chr(92)) $text=substr($text,0,strlen($text)-1);

return $text;
}

//--------------->
function usernameFilter($posterName){

if(strlen_unicode($posterName)>$GLOBALS['viewUnameLngLim']){
if(substr_count($posterName, ' ')==0 and substr_count($posterName, $GLOBALS['chunkStr'])==0) $posterName=wrapText($GLOBALS['viewUnameLngLim'], $posterName);
else{
$pn=explode(' ', $posterName);
foreach($pn as $key=>$uf){
if(strlen_unicode($pn[$key])>$GLOBALS['viewUnameLngLim']) $pn[$key]==wrapText($GLOBALS['viewUnameLngLim'], $pn[$key]);
}
$posterName=implode(' ', $pn);
}
}

return $posterName;
}


//--------------->
function convEnt($str){
return strip_tags(str_replace(array('<br />', '<br>', '&#039;', '&quot;', '&amp;', '&#036;', '&lt;', '&gt;'), array("\n", "\n", "'", '"', '&', '$', '<', '>'), $str));
}

?>