<?php
return [
    'backend' => [
        'frontName' => '[[admin_folder]]'
    ],
    'cache' => [
        'graphql' => [
            'id_salt' => '[[graphql_id_salt]]'
        ],
        'frontend' => [
            'default' => [
                'id_prefix' => '[[id_prefix]]'
            ],
            'page_cache' => [
                'id_prefix' => '[[id_prefix]]'
            ]
        ],
        'allow_parallel_generation' => false
    ],
    'remote_storage' => [
        'driver' => 'file'
    ],
    'queue' => [
        'consumers_wait_for_messages' => 1
    ],
    'crypt' => [
        'key' => '[[key]]'
    ],
    'db' => [
        'table_prefix' => '[[dbprefix]]',
        'connection' => [
            'default' => [
                'host' => '[[softdbhost]]',
                'dbname' => '[[softdb]]',
                'username' => '[[softdbuser]]',
                'password' => '[[softdbpass]]',
                'model' => 'mysql4',
                'engine' => 'innodb',
                'initStatements' => 'SET NAMES utf8;',
                'active' => '1',
                'driver_options' => [
                    1014 => false
                ]
            ]
        ]
    ],
    'resource' => [
        'default_setup' => [
            'connection' => 'default'
        ]
    ],
    'x-frame-options' => 'SAMEORIGIN',
    'MAGE_MODE' => 'default',
    'session' => [
        'save' => 'db'
    ],
    'lock' => [
        'provider' => 'db'
    ],
    'directories' => [
        'document_root_is_pub' => true
    ],
    'cache_types' => [
        'config' => 1,
        'layout' => 1,
        'block_html' => 1,
        'collections' => 1,
        'reflection' => 1,
        'db_ddl' => 1,
        'compiled_config' => 1,
        'eav' => 1,
        'customer_notification' => 1,
        'config_integration' => 1,
        'config_integration_api' => 1,
        'full_page' => 1,
        'config_webservice' => 1,
        'translate' => 1
    ],
    'downloadable_domains' => [
        '[[domhost]]'
    ],
    'install' => [
        'date' => '[[_instime]]'
    ]
];
