<?php
 /**
 * Jamroom Support Center module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: support
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrSupport_support($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();

    jrCore_page_include_admin_menu();
    if (isset($_post['skin'])) {
        // skin "Help and Support"
        jrCore_page_skin_tabs($_post['skin'], 'support');
    }
    else {
        jrCore_page_admin_tabs($_post['module'], 'support');
    }
    jrCore_get_form_notice();

    // Make sure we got a good JR Network email address
    if (!isset($_conf['jrSupport_support_email']) || !jrCore_checktype($_conf['jrSupport_support_email'], 'email')) {

        // See if we can grab it from the Marketplace
        if (jrCore_module_is_active('jrMarket')) {
            $_mkt = jrMarket_get_active_release_system();
            if ($_mkt && is_array($_mkt) && isset($_mkt['system_email']) && jrCore_checktype($_mkt['system_email'], 'email')) {
                jrCore_set_setting_value('jrSupport', 'support_email', $_mkt['system_email']);
            }
            jrCore_delete_config_cache();
        }
        jrCore_page_banner('Help and Support');
    }
    else {
        // Setup our module jumper
        $_mds = array();
        foreach ($_mods as $mod_dir => $_info) {
            if (jrCore_module_is_active($mod_dir)) {
                $_mds[] = $mod_dir;
            }
        }
        $temp = jrCore_get_module_jumper('module_jumper', $_post['module'], "jrCore_window_location('{$_conf['jrCore_base_url']}/'+ $(this).val() + '/support')", $_mds);
        jrCore_page_banner('Help and Support', $temp);
    }

    if (isset($_post['skin'])) {
        $_mta = jrCore_skin_meta_data($_post['skin']);
        $_rp  = array(
            'skin' => $_post['skin'],
            'icon' => jrCore_get_skin_icon_html($_post['skin'], 164)
        );
        $ttl  = $_mta['title'];
        jrCore_page_title("Help - " . $_mta['title']);
    }
    else {
        if (!jrCore_module_is_active($_post['module'])) {
            jrCore_page_notice('error', 'Module is not active');
        }
        $_rp = array(
            'module' => $_post['module'],
            'icon'   => jrCore_get_module_icon_html($_post['module'], 164)
        );
        $ttl = $_mods["{$_post['module']}"]['module_name'];
    }
    $html = jrCore_parse_template('support.tpl', $_rp, 'jrSupport');
    jrCore_page_custom($html);
    jrCore_page_title("Help - " . $ttl);
    jrCore_page_display();
}
