<?php
 /**
 * Jamroom Marketplace module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: system_archive
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMarket_system_archive($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrMarket');
    jrCore_page_banner('release archive');
    jrCore_get_form_notice();

    // First - get all old module releases
    $show = false;
    $_old = array();
    $_fil = glob(APP_DIR . '/modules/*-release-*');
    if (is_array($_fil)) {

        foreach ($_fil as $file) {
            $mod = basename($file);
            $mod = substr($mod, 0, strpos($mod, '-release-'));
            $ver = explode('-', $file);
            $ver = end($ver);
            if (!empty($ver) && version_compare($ver, $_mods[$mod]['module_version']) == -1) {
                if (!isset($_old[$mod])) {
                    $_old[$mod] = $ver;
                }
                elseif (version_compare($ver, $_old[$mod]) > 0) {
                    $_old[$mod] = $ver;
                }
            }
        }

        if (count($_old) > 0) {
            $dat             = array();
            $dat[1]['title'] = '';
            $dat[1]['width'] = '2%';
            $dat[2]['title'] = 'module';
            $dat[2]['width'] = '53%';
            $dat[3]['title'] = 'your version';
            $dat[3]['width'] = '15%';
            $dat[4]['title'] = 'previous version';
            $dat[4]['width'] = '15%';
            $dat[5]['title'] = 'restore';
            $dat[5]['width'] = '5%';
            jrCore_page_table_header($dat);

            foreach ($_old as $mod => $ver) {
                $dat             = array();
                $dat[1]['title'] = jrCore_get_module_icon_html($mod, 32);
                $dat[2]['title'] = $_mods[$mod]['module_name'];
                $dat[3]['title'] = $_mods[$mod]['module_version'];
                $dat[3]['class'] = 'center';
                $dat[4]['title'] = $ver;
                $dat[4]['class'] = 'center';
                $dat[5]['title'] = jrCore_page_button("r{$mod}{$ver}", 'restore', "jrCore_confirm('Restore older version?', 'WARNING! Restoring could cause your system to no longer function properly', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/restore_item/module/{$mod}/{$ver}') } )");
                jrCore_page_table_row($dat);
            }
            jrCore_page_table_footer();
            $show = true;
        }
    }

    // Next - the skins
    $_old = array();
    $_fil = glob(APP_DIR . '/skins/*-release-*');
    $_mta = array();
    if (is_array($_fil)) {

        foreach ($_fil as $file) {
            $mod = basename($file);
            $mod = substr($mod, 0, strpos($mod, '-release-'));
            $ver = explode('-', $file);
            $ver = end($ver);
            if (!isset($_mta[$mod])) {
                $_mta[$mod] = jrCore_skin_meta_data($mod);
            }
            if (!empty($ver) && isset($_mta[$mod]['version']) && version_compare($ver, $_mta[$mod]['version']) == -1) {
                $_old[$mod] = $ver;
            }
        }

        if (count($_old) > 0) {
            $dat             = array();
            $dat[1]['title'] = '';
            $dat[1]['width'] = '2%';
            $dat[2]['title'] = 'skin';
            $dat[2]['width'] = '53%';
            $dat[3]['title'] = 'your version';
            $dat[3]['width'] = '15%';
            $dat[4]['title'] = 'archive version';
            $dat[4]['width'] = '15%';
            $dat[5]['title'] = 'restore';
            $dat[5]['width'] = '5%';
            jrCore_page_table_header($dat);

            foreach ($_old as $mod => $ver) {
                $dat             = array();
                $dat[1]['title'] = jrCore_get_module_icon_html($mod, 32);
                $dat[2]['title'] = $_mta[$mod]['name'];
                $dat[3]['title'] = $_mta[$mod]['version'];
                $dat[3]['class'] = 'center';
                $dat[4]['title'] = $ver;
                $dat[4]['class'] = 'center';
                $dat[5]['title'] = jrCore_page_button("r[$mod}{$ver}", 'restore', "jrCore_confirm('Restore older version?', 'WARNING! Restoring could cause your system to no longer function properly', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/restore_item/skin/{$mod}/{$ver}') } )");
                jrCore_page_table_row($dat);
            }
            jrCore_page_table_footer();
            $show = true;
        }
    }
    if (!$show) {
        jrCore_set_form_notice('success', 'There are no archived versions of modules or skins');
        jrCore_get_form_notice();
    }
    jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools");
    jrCore_page_display();
}
