<?php
 /**
 * Jamroom Marketplace module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: purchase
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMarket_purchase($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_validate_location_url();

    $_to_check = array('price', 'market_id');
    foreach ($_to_check as $chk) {
        if (!isset($_post[$chk])) {
            $_rs = array('error' => 'Invalid post data received - please try again');
            jrCore_json_response($_rs);
        }
    }
    switch ($_post['type']) {
        case 'module':
        case 'skin':
        case 'bundle':
            break;
        default:
            $_rs = array('error' => 'Invalid Type received - must be one of module,skin,bundle');
            jrCore_json_response($_rs);
            break;
    }
    if (!$_mkt = jrMarket_get_active_release_system()) {
        $_rs = array('error' => 'There are no active Marketplace Systems configured where you can purchase Marketplace items');
        jrCore_json_response($_rs);
    }
    $_dt = array(
        'token'     => (isset($_post['token'])) ? $_post['token'] : '',  // Only on first time purchase
        'sysid'     => $_mkt['system_code'],
        'type'      => $_post['type'],
        'item'      => $_post['item'],
        'market_id' => $_post['market_id'],
        'price'     => $_post['price'],
        'host'      => jrCore_url_encode_string($_conf['jrCore_base_url'])
    );
    $_rs = jrCore_load_url("{$_mkt['system_url']}/networkmarket/purchase", $_dt, 'POST', jrMarket_get_port(), null, null, true, 60);
    if ($_rs && strpos($_rs, '{') === 0) {
        $_rs = json_decode($_rs, true);
        if ($_rs && isset($_rs['error'])) {
            $_rs = array('error' => $_rs['error']);
        }
        if ($_post['type'] == 'bundle') {
            // The license string can come in REALLY long here - we need to save
            // it off to a temp key and pass that key as the license
            $_tm = jrCore_url_decode_string($_rs['license']);
            $key = md5(microtime() . mt_rand());
            jrCore_set_temp_value('jrMarket', $key, $_tm);
            $_rs['license'] = $key;
        }
        jrCore_json_response($_rs);
    }
    $_rs = array('error' => 'Unable to complete purchase - please try again');
    jrCore_json_response($_rs);
}
