<?php
 /**
 * Jamroom Email Support module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: test_email_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMailer_test_email_save($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_master_only();
    jrCore_form_validate($_post);

    // Get our active mailer sub system and send email
    $smtp = jrCore_get_active_email_system();
    if (!empty($_queue['_options']['active_email_system'])) {
        $smtp = $_queue['_options']['active_email_system'];
    }
    $func = "_{$smtp}_send_email";
    if (function_exists($func)) {

        $_option = array(
            'subject'   => jrCore_strip_emoji($_post['subject'], false),
            'message'   => $_post['message'],
            'from'      => jrCore_get_config_value('jrMailer', 'from_email', $_SERVER['SERVER_ADMIN']),
            'from_name' => jrCore_get_config_value('jrMailer', 'from_name', null),
        );
        if (jrCore_get_config_value('jrMailer', 'send_as_html', 'on') == 'on') {
            $_option['send_as_html'] = true;
            $_option['message']      = "<b>{$_option['message']}</b><br><br>HTML notifications are <i>enabled</i>";
        }
        $numsent = $func($_post['email'], array(), $_conf, $_option);
        if ($numsent !== false) {
            if (is_numeric($numsent) && $numsent > 0) {
                sleep(1);
                jrCore_set_form_notice('success', 'The test email was successfully sent');
                jrCore_form_result();
            }
        }
        jrCore_set_form_notice('error', 'An error was encountered sending the test email - check activity log');
    }
    else {
        jrCore_set_form_notice('error', "active email system function: {$func} is not defined");
    }
    jrCore_form_result();
}
