<?php
 /**
 * Jamroom Geo Location module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * config
 */
function jrGeo_config()
{
    // Active
    $_opt = array(
        'local'   => 'Geo Location Database file v2 - default',
        'old'     => 'Geo Location Database file v1 - deprecated',
        'apilite' => 'MaxMind Free GeoLite2 API - requires MaxMind API key',
        'api'     => 'MaxMind Paid GeoIP Precision API - requires MaxMind API key'
    );
    $_tmp = array(
        'name'     => 'active',
        'type'     => 'select',
        'options'  => $_opt,
        'default'  => 'local',
        'validate' => 'not_empty',
        'label'    => 'Active Location Service',
        'help'     => 'Select the GeoIP service that should be the active service for IP Address requests.',
        'order'    => 1
    );
    jrCore_register_setting('jrGeo', $_tmp);

    // Google API Key
    $_tmp = array(
        'name'     => 'google_api_key',
        'type'     => 'text',
        'default'  => '',
        'validate' => 'not_empty',
        'label'    => 'Google Maps API Key',
        'help'     => 'Enter your Google Maps API Key.<br><br>For more information on Google Maps, including pricing and how to get an API Key, make sure and visit the Get API Key section of the Google Developer Documentation:<br><br><a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank" rel="noreferrer noopener"><u>How to get a Google Maps API Key</u></a>',
        'order'    => 2
    );
    jrCore_register_setting('jrGeo', $_tmp);

    // ZIP Search display
    $_opt = array(
        'miles'      => 'Miles',
        'kilometers' => 'Kilometers'
    );
    $_tmp = array(
        'name'     => 'zip_display',
        'type'     => 'select',
        'options'  => $_opt,
        'default'  => 'miles',
        'validate' => 'not_empty',
        'label'    => 'ZIP Search Format',
        'help'     => 'Select the distance format that will be used in a ZIP Code radius search',
        'order'    => 3
    );
    jrCore_register_setting('jrGeo', $_tmp);

    // User ID
    $_tmp = array(
        'name'     => 'user_id',
        'type'     => 'text',
        'default'  => '',
        'validate' => 'not_empty',
        'label'    => 'MaxMind Account ID',
        'help'     => 'This is your MaxMind Account ID found in the &quot;My License Key&quot; section of your MaxMind Account',
        'section'  => 'MaxMind',
        'order'    => 10
    );
    jrCore_register_setting('jrGeo', $_tmp);

    // License Key
    $_tmp = array(
        'name'     => 'license_key',
        'type'     => 'text',
        'default'  => '',
        'validate' => 'not_empty',
        'label'    => 'MaxMind License Key',
        'help'     => 'This is your MaxMind License Key found in the &quot;My License Key&quot; section of your MaxMind Account',
        'section'  => 'MaxMind',
        'order'    => 11
    );
    jrCore_register_setting('jrGeo', $_tmp);

    // Make sure placeholder fields are set
    $_ch = jrGeo_get_available_database_info();
    foreach ($_ch as $c) {
        $_tmp = array(
            'name'     => $c[0],
            'default'  => '0',
            'type'     => 'hidden',
            'required' => 'on',
            'validate' => 'number_nn',
            'label'    => $c[1] . ' Key Field',
            'help'     => 'this hidden field keeps track of the Geo database time - do not modify by hand.'
        );
        jrCore_register_setting('jrGeo', $_tmp);
    }

    return true;
}
