<?php
 /**
 * Jamroom Favicon Creator module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: browse
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrFavicon_browse($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrFavicon', 'browse');
    jrCore_page_banner('Favicon Browser');
    jrCore_get_form_notice();

    $dat             = array();
    $dat[1]['title'] = 'favicon';
    $dat[1]['width'] = '30%';
    $dat[2]['title'] = 'created';
    $dat[2]['width'] = '25%';
    $dat[3]['title'] = 'size';
    $dat[3]['width'] = '25%';
    $dat[4]['title'] = 'active';
    $dat[4]['width'] = '5%';
    $dat[5]['title'] = 'delete';
    $dat[5]['width'] = '5%';
    $dat[6]['title'] = 'rebuild';
    $dat[6]['width'] = '5%';
    $dat[7]['title'] = 'download';
    $dat[7]['width'] = '5%';
    jrCore_page_table_header($dat);

    $page = 1;
    if (!empty($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
        $page = (int) $_post['p'];
    }
    $_rt = array(
        'order_by'            => array('_item_id' => 'desc'),
        'no_cache'            => true,
        'skip_all_checks'     => true,
        'use_total_row_count' => true,
        'pagebreak'           => jrCore_get_pager_rows(),
        'page'                => $page
    );
    $_rt = jrCore_db_search_items('jrFavicon', $_rt);

    // Get existing favicons
    if ($_rt && is_array($_rt) && !empty($_rt['_items'])) {
        $active = jrCore_get_config_value('jrFavicon', 'active', 0);
        foreach ($_rt['_items'] as $k => $v) {
            $fid             = (int) $v['_item_id'];
            $_im             = array(
                'crop'   => 'square',
                'width'  => 32,
                'height' => 32,
                'alt'    => 'icon',
                'title'  => $v['icon_image_name'],
                'item'   => $v
            );
            $dat[1]['title'] = jrImage_get_image_src('jrFavicon', 'icon_image', $fid, 'small', $_im);
            $dat[1]['class'] = 'center';
            $dat[2]['title'] = jrCore_format_time($v['_created']);
            $dat[2]['class'] = 'center';
            $dat[3]['title'] = jrCore_format_size($v['icon_image_size']);
            $dat[3]['class'] = 'center';
            if ($active == $fid) {
                $dat[4]['title'] = jrCore_get_option_image('pass');
                $dat[5]['title'] = jrCore_page_button("delete-{$k}", 'delete', 'disabled');
                $dat[6]['title'] = jrCore_page_button("rebuild-{$k}", 'rebuild', "jrCore_window_location('" . jrCore_get_base_url() . "/{$_post['module_url']}/active_save/id={$fid}')");
            }
            else {
                $dat[4]['title'] = jrCore_page_button("active-{$k}", 'activate', "jrCore_window_location('" . jrCore_get_base_url() . "/{$_post['module_url']}/active_save/id={$fid}')");
                $dat[5]['title'] = jrCore_page_button("delete-{$k}", 'delete', "jrCore_confirm('','Are you sure you want to delete this favicon?',function(){ jrCore_window_location('" . jrCore_get_base_url() . "/{$_post['module_url']}/delete_save/id={$fid}')})");
                $dat[6]['title'] = jrCore_page_button("rebuild-{$k}", 'rebuild', 'disabled');
            }
            $dat[4]['class'] = 'center';
            $dat[5]['class'] = 'center';
            $dat[6]['class'] = 'center';
            $dat[7]['title'] = jrCore_page_button("l{$k}", 'download', "jrCore_window_location('" . jrCore_get_base_url() . "/{$_post['module_url']}/download/icon_image/{$fid}/favicon')");
            $dat[7]['class'] = 'center';
            jrCore_page_table_row($dat);
        }
    }
    else {
        $dat             = array();
        $dat[1]['title'] = "<p>no favicon images have been uploaded yet - upload a new image below.</p>";
        $dat[1]['class'] = 'center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();

    // Form init
    $_tmp = array(
        'submit_value'     => 'create new favicon',
        'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    // Image
    $_tmp = array(
        'name'     => 'icon_image',
        'label'    => 'PNG image',
        'sublabel' => 'recommended 512 x 512',
        'help'     => 'Upload a PNG image that will be used to create the favicon.ico file',
        'type'     => 'image',
        'text'     => 'select image',
        'allowed'  => 'png',
        'section'  => 'Upload a new Favicon PNG image',
        'required' => false
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
