<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: upload_file
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_upload_file($_post, $_user, $_conf)
{
    // Upload progress
    jrUser_session_require_login();
    if (!isset($_post['upload_token']) || !jrCore_checktype($_post['upload_token'], 'md5')) {
        jrCore_db_close();
        exit; // OK
    }

    // Bring in meter backend
    require_once APP_DIR . '/modules/jrCore/contrib/meter/server.php';

    // We will get our "max_size" and "extensions" values on the post - we have to
    // hash with the core unique string and ensure it has not been tampered with
    if (empty($_post['access_key']) || !jrCore_checktype($_post['access_key'], 'md5')) {
        jrCore_json_response(array('error' => 'invalid access key'), true, true, false);
    }

    // Verify access key
    $md5 = jrCore_get_config_value('jrCore', 'unique_string', '');
    $md5 = md5($md5 . $_post['extensions'] . $_post['max_size']);
    if ($md5 != $_post['access_key']) {
        jrCore_json_response(array('error' => 'invalid access key (2)'), true, true, false);
    }

    $max = (int) $_post['max_size'];
    $ext = explode(',', $_post['extensions']);
    $mtr = new qqFileUploader($ext, jrCore_get_max_allowed_upload($max));

    $dir = jrCore_get_upload_temp_directory($_post['upload_token']);
    if (!is_dir($dir)) {
        jrCore_create_directory($dir);
    }
    $res = $mtr->handleUpload($dir . '/');
    jrCore_json_response($res, true, true, false);
}
