<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: template_reset_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_template_reset_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_validate_location_url();

    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'Invalid template_id - please try again');
        jrCore_form_result();
    }

    // Get info about this template first so we can reset
    $tbl = jrCore_db_table_name('jrCore', 'template');
    $req = "SELECT template_name, template_module FROM {$tbl} WHERE template_id = '{$_post['id']}'";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!isset($_rt) || !is_array($_rt)) {
        jrCore_set_form_notice('error', 'Invalid template_id - please try again');
        jrCore_form_result();
    }
    $req = "DELETE FROM {$tbl} WHERE template_id = '{$_post['id']}' LIMIT 1";
    $cnt = jrCore_db_query($req, 'COUNT');
    if ($cnt === 1) {
        jrCore_get_template_file($_rt['template_name'], $_rt['template_module'], 'reset');
        jrCore_set_form_notice('success', 'The template has been reset to use the default version');
    }
    else {
        jrCore_set_form_notice('error', 'An error was encountered deleting the modified template from the database - please try again');
    }
    $url = jrCore_get_local_referrer();
    if ($url && strpos($url, '/hl=')) {
        $url = jrCore_strip_url_params($url, array('hl'));
        jrCore_location($url);
    }
    if (strpos($url, '/id=')) {
        $url = jrCore_strip_url_params($url, array('id'));
        jrCore_location($url . "/template={$_rt['template_name']}");
    }
    jrCore_location($url);
}
