<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: template_compare_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_template_compare_save($_post, $_user, $_conf)
{
    jrUser_master_only();

    if (!isset($_post['template_body']) || strlen(trim($_post['template_body'])) === 0) {
        jrCore_set_form_notice('error', 'The received template content was empty - please try again');
        jrCore_form_result();
    }

    // See if we are doing a skin or module
    $mod = (isset($_post['skin'])) ? $_post['skin'] : $_post['module'];

    // We need to test this template and make sure it does not cause any Smarty errors
    $err = jrCore_test_template_for_errors($mod, $_post['template_body']);
    if ($err && strpos($err, 'error') === 0) {
        jrCore_set_user_session_key('template_body_save', $_post['template_body']);
        jrCore_set_form_notice('error', substr($err, 7), false);
    }

    $tbl = jrCore_db_table_name('jrCore', 'template');
    // See if we are updating a DB template or first time file
    if (isset($_post['template_id']) && jrCore_checktype($_post['template_id'], 'number_nz')) {
        // Make sure we have a valid template
        $req = "SELECT * FROM {$tbl} WHERE template_id = '{$_post['template_id']}'";
        $_rt = jrCore_db_query($req, 'SINGLE');
        if (!$_rt || !is_array($_rt)) {
            jrCore_set_user_session_key('template_body_save', $_post['template_body']);
            jrCore_set_form_notice('error', 'Invalid template_id - please try again');
            jrCore_form_result();
        }
        $req = "UPDATE {$tbl} SET
                  template_updated = UNIX_TIMESTAMP(),
                  template_user    = '" . jrCore_db_escape($_user['user_name']) . "',
                  template_body    = '" . jrCore_db_escape($_post['template_body']) . "'
                 WHERE template_id = '{$_post['template_id']}'";
        $cnt = jrCore_db_query($req, 'COUNT');
        // Reset the template cache
        jrCore_get_template_file($_rt['template_name'], $mod, 'reset');
        $hl = $_rt['template_name'];
    }
    else {
        if (empty($_post['template_name'])) {
            jrCore_set_user_session_key('template_body_save', $_post['template_body']);
            jrCore_set_form_notice('error', 'Invalid template_name - please try again');
            jrCore_form_result();
        }
        $hl = $_post['template_name'];
        // See if we already exist - this can happen when the user FIRST modifies the template
        // and does not leave the screen, and modifies again
        $nam = jrCore_db_escape($_post['template_name']);
        $mod = jrCore_db_escape($mod);
        $req = "INSERT INTO {$tbl} (template_created,template_updated,template_user,template_active,template_name,template_module,template_body)
                VALUES(UNIX_TIMESTAMP(),UNIX_TIMESTAMP(),'" . jrCore_db_escape($_user['user_name']) . "','0','{$nam}','{$mod}','" . jrCore_db_escape($_post['template_body']) . "')";
        $tid = jrCore_db_query($req, 'INSERT_ID');
        if ($tid && jrCore_checktype($tid, 'number_nz')) {
            $cnt = 1;
            // Reset the template cache
            jrCore_get_template_file($_post['template_name'], $mod, 'reset');
        }
    }
    if (isset($cnt) && $cnt === 1) {
        jrCore_set_form_notice('success', 'The template has been successfully updated');
    }
    else {
        jrCore_set_form_notice('error', 'An error was encountered saving the template update - please try again');
    }
    jrCore_form_delete_session();
    if (isset($_post['skin'])) {
        jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/skin_admin/templates/skin={$_post['skin']}/hl={$hl}"); // skin
    }
    else {
        jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/templates/hl={$hl}"); // module
    }

}
