<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: skin_menu_move_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_skin_menu_move_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_validate_location_url();

    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid menu_id - please try again');
        jrCore_location('referrer');
    }
    if (!isset($_post['top']) || !jrCore_checktype($_post['top'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid top id - please try again');
        jrCore_location('referrer');
    }
    $pid = (int) $_post['id'];
    $tid = (int) $_post['top'];
    $tbl = jrCore_db_table_name('jrCore', 'menu');
    $req = "SELECT * FROM {$tbl} WHERE menu_id IN('{$pid}','{$tid}')";
    $_rt = jrCore_db_query($req, 'menu_id');
    if (isset($_rt) && is_array($_rt)) {
        if (!isset($_rt[$pid])) {
            jrCore_set_form_notice('error', 'invalid menu_id - please try again');
            jrCore_location('referrer');
        }
        if (!isset($_rt[$tid])) {
            jrCore_set_form_notice('error', 'invalid top id - please try again');
            jrCore_location('referrer');
        }
        // Move Up
        if ($_rt[$pid]['menu_order'] == $_rt[$tid]['menu_order']) {
            $ord = $_rt[$tid]['menu_order'] - 1;
        }
        else {
            $ord = $_rt[$tid]['menu_order'];
        }
        $req = "UPDATE {$tbl} SET menu_order = '{$ord}' WHERE menu_id = '{$pid}' LIMIT 1";
        jrCore_db_query($req);

        $ord = $_rt[$pid]['menu_order'];
        $req = "UPDATE {$tbl} SET menu_order = '{$ord}' WHERE menu_id = '{$tid}' LIMIT 1";
        jrCore_db_query($req);
    }
    jrCore_delete_all_cache_entries();
    jrCore_location('referrer');
    return true;
}
