<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: skin_menu_modify_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_skin_menu_modify_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid menu_id - please try again');
        jrCore_form_result();
    }
    $tbl = jrCore_db_table_name('jrCore', 'menu');
    $req = "SELECT * FROM {$tbl} WHERE menu_id = '{$_post['id']}' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!isset($_rt) || !is_array($_rt)) {
        jrCore_set_form_notice('error', 'invalid menu_id - please try again');
        jrCore_form_result();
    }

    // Update...
    $cat = jrCore_db_escape($_post['menu_category']);
    $act = '';
    if (isset($_rt['menu_module']) && $_rt['menu_module'] == 'CustomEntry') {
        $sav = jrCore_db_escape($_post['menu_action']);
        $act = "menu_unique = '{$sav}',menu_action = '{$sav}',";

        // Make sure we are unique...
        $req = "SELECT * FROM {$tbl} WHERE menu_module = 'CustomEntry' AND menu_category = '{$cat}' AND menu_action = '{$sav}' AND menu_id != '{$_post['id']}' LIMIT 1";
        $_ex = jrCore_db_query($req, 'SINGLE');
        if ($_ex && is_array($_ex)) {
            jrCore_set_form_notice('error', 'There is already a menu entry using the Category and Linked URL - please enter something different');
            jrCore_form_result();
        }
    }
    $req = "UPDATE {$tbl} SET
              menu_label    = '" . jrCore_db_escape($_post['menu_label']) . "',{$act}
              menu_category = '{$cat}',
              menu_groups   = '" . jrCore_db_escape(implode(',', $_post['menu_groups'])) . "',
              menu_active   = '" . jrCore_db_escape($_post['menu_active']) . "'
             WHERE menu_id = '{$_post['id']}' LIMIT 1";
    $cnt = jrCore_db_query($req, 'COUNT');
    if ($cnt !== 1) {
        jrCore_set_form_notice('error', 'Error updating menu entry in the database - please try again');
    }
    else {
        jrCore_set_form_notice('success', 'The menu entry was successfully updated');
        jrCore_form_delete_session();
    }
    jrCore_form_result();
}
