<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: skin_menu_modify
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_skin_menu_modify($_post, $_user, $_conf)
{
    jrUser_master_only();
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid menu_id - please try again');
        jrCore_location('referrer');
    }
    // Get info
    $tbl = jrCore_db_table_name('jrCore', 'menu');
    $req = "SELECT * FROM {$tbl}";
    $_me = jrCore_db_query($req, 'NUMERIC');

    $_rt = array();
    $_ct = array();
    foreach ($_me as $_v) {
        if (isset($_v['menu_id']) && $_v['menu_id'] == $_post['id']) {
            $_rt = $_v;
        }
        if (isset($_v['menu_category']) && strlen($_v['menu_category']) > 0) {
            $_ct["{$_v['menu_category']}"] = $_v['menu_category'];
        }
    }
    if (!isset($_rt) || !is_array($_rt)) {
        jrCore_set_form_notice('error', 'invalid menu_id - please try again');
        jrCore_location('referrer');
    }

    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrCore');
    jrCore_page_banner('modify menu entry');

    $_tmp = array(
        'submit_value'     => 'save changes',
        'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/skin_menu",
        'values'           => $_rt,
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    // ID
    $_tmp = array(
        'name'  => 'id',
        'type'  => 'hidden',
        'value' => $_post['id']
    );
    jrCore_form_field_create($_tmp);

    // Label
    if (isset($_rt['menu_label']) && jrCore_checktype($_rt['menu_label'], 'number_nz')) {
        $murl = jrCore_get_module_url($_rt['menu_module']);
        $html = jrCore_page_button('lang-id-link', "{$_rt['menu_label']} - Change in Language Strings", "jrCore_window_location('{$_conf['jrCore_base_url']}/{$murl}/admin/language?id={$_rt['menu_label']}')");
        jrCore_page_custom($html, 'label');
    }
    else {
        $_tmp = array(
            'name'     => 'menu_label',
            'label'    => 'label',
            'help'     => 'This is the text that will appear as the label for the menu entry.<br><br><strong>Note:</strong> You can enter a language index ID here to use a language entry in place of a text label.',
            'type'     => 'text',
            'validate' => 'printable',
            'required' => true
        );
        jrCore_form_field_create($_tmp);
    }

    // Category
    $_tmp = array(
        'name'     => 'menu_category',
        'label'    => 'category',
        'help'     => 'If your skin menu supports grouping menu entries into categories, you can enter the category for this link here.',
        'type'     => 'select_and_text',
        'options'  => $_ct,
        'validate' => 'printable'
    );
    jrCore_form_field_create($_tmp);

    // URL
    if (isset($_rt['menu_module']) && $_rt['menu_module'] == 'CustomEntry') {
        $_pt = array();
        if (jrCore_module_is_active('jrPage')) {
            $_sp = array(
                'search'        => array(
                    'page_location = 0'
                ),
                'return_keys'   => array('_item_id', 'page_title', 'page_title_url'),
                'order_by'      => array(
                    'page_title' => 'asc'
                ),
                'skip_triggers' => true,
                'limit'         => 250
            );
            $_pg = jrCore_db_search_items('jrPage', $_sp);
            if ($_pg && is_array($_pg) && isset($_pg['_items'])) {
                $purl = jrCore_get_module_url('jrPage');
                foreach ($_pg['_items'] as $_page) {
                    $_pt["{$purl}/{$_page['_item_id']}/{$_page['page_title_url']}"] = $_page['page_title'];
                }
            }
            // If we have a custom URL, insert int
            if (isset($_rt['menu_action']) && strlen($_rt['menu_action']) > 0 && !isset($_pt["{$_rt['menu_action']}"])) {
                $_pt["{$_rt['menu_action']}"] = $_rt['menu_action'];
            }
        }
        if (count($_pt) > 0) {
            $_tmp = array(
                'name'     => 'menu_action',
                'label'    => 'linked URL',
                'help'     => 'This is the page or module/view that will be loaded when the menu item is clicked on',
                'type'     => 'select_and_text',
                'options'  => $_pt,
                'validate' => 'printable',
                'required' => true
            );
            jrCore_form_field_create($_tmp);
        }
        else {
            $_tmp = array(
                'name'     => 'menu_action',
                'label'    => 'linked URL',
                'help'     => 'This is the module/view that will be loaded when the menu item is clicked on',
                'type'     => 'text',
                'validate' => 'printable',
                'required' => true
            );
            jrCore_form_field_create($_tmp);
        }
    }

    // Group
    $_grp = array(
        'all'     => 'Everyone',
        'master'  => 'Master Admins',
        'admin'   => 'Admin Users',
        'power'   => 'Power Users',
        'multi'   => 'Multi Profile Users',
        'user'    => 'Users Only (logged in)',
        'visitor' => 'Visitors Only (not logged in)'
    );
    $_qt  = jrProfile_get_quotas();
    if (isset($_qt) && is_array($_qt)) {
        foreach ($_qt as $qid => $qname) {
            $_grp[$qid] = "Quota: {$qname}";
        }
    }
    $size = 12;
    if (count($_grp) < 12) {
        $size = count($_grp);
    }
    $_tmp = array(
        'name'     => 'menu_groups',
        'label'    => 'visible to',
        'sublabel' => 'select multiple',
        'help'     => 'Select the group(s) of users that will be able to see this menu entry.',
        'type'     => 'select_multiple',
        'options'  => $_grp,
        'required' => true,
        'size'     => $size
    );
    jrCore_form_field_create($_tmp);

    $_tmp = array(
        'name'     => 'menu_active',
        'label'    => 'active',
        'help'     => 'Is this menu entry active?',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'default'  => 'on',
        'required' => true
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
