<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: restore_recycle_bin_item
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_restore_recycle_bin_item($_post, $_user, $_conf)
{
    jrUser_admin_only();
    jrCore_validate_location_url();
    @ini_set('max_execution_time', 7200); // 2 hours max
    @ini_set('memory_limit', '1024M');

    // Must get a good recycle bin id
    if (strpos($_post['id'], ',')) {
        if ($_rids = explode(',', $_post['id'])) {
            foreach ($_rids as $k => $v) {
                if (!jrCore_checktype($v, 'number_nz')) {
                    jrCore_set_form_notice('error', 'invalid recycle bin id - please try again');
                    jrCore_location('referrer');
                }
                $_rids[$k] = (int) $v;
            }
        }
    }
    else {
        if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
            jrCore_set_form_notice('error', 'invalid recycle bin id - please try again (2)');
            jrCore_location('referrer');
        }
        $_rids = array(intval($_post['id']));
    }

    // Make sure items exist
    $tbl = jrCore_db_table_name('jrCore', 'recycle');
    $req = "SELECT r_id, r_profile_id, r_module, r_table, r_item_id FROM {$tbl} WHERE r_id IN(" . implode(',', $_rids) . ') ORDER BY r_id ASC';
    $_rt = jrCore_db_query($req, 'NUMERIC');
    if (!$_rt || !is_array($_rt)) {
        jrCore_set_form_notice('error', 'invalid recycle bin id - please try again (3)');
        jrCore_location('referrer');
    }

    $_up = array();
    foreach ($_rt as $v) {
        $rid = (int) $v['r_id'];
        $rst = false;
        if (!empty($v['r_table'])) {
            // If r_table is not empty it means this is a non-DS table row
            if (jrCore_restore_recycle_bin_table_row($rid)) {
                $rst = true;
            }
        }
        else {
            if (jrCore_restore_recycle_bin_item($rid)) {
                $rst = true;
            }
        }
        if ($rst) {
            $pid       = (int) $v['r_profile_id'];
            $_up[$pid] = $pid;
            jrProfile_reset_cache($pid, $v['r_module']);
        }
    }
    if (count($_up) > 0) {
        jrCore_queue_create('jrProfile', 'update_profile_disk_usage', array('profile_ids' => $_up));
        jrCore_set_form_notice('success', 'The selected items were successfully restored');
        jrCore_logger('INF', jrCore_number_format(count($_up)) . " recycle bin items were successfully restored");
    }
    else {
        jrCore_set_form_notice('error', 'An error was encountered restoring the selected items - please try again');
    }
    $url = jrCore_get_local_referrer();
    if (strpos($url, 'item_content')) {
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/dashboard/recycle_bin");
    }
    jrCore_location('referrer');
}
