<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: pending_item_delete
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_pending_item_delete($_post, $_user, $_conf)
{
    jrUser_admin_only();
    jrCore_validate_location_url();

    if (!isset($_post['id']) || strlen($_post['id']) === 0) {
        jrCore_set_form_notice('error', 'Invalid item id');
        jrCore_location('referrer');
    }
    $tbl = jrCore_db_table_name('jrCore', 'pending');
    // See if we are doing ONE or multiple
    if (isset($_post['id']) && jrCore_checktype($_post['id'], 'number_nz')) {
        // We are only doing ONE item - this will be the _item_id for the ITEM
        $title = 'item has';
        $req   = "SELECT * FROM {$tbl} WHERE pending_module = '" . jrCore_db_escape($_post['_1']) . "' AND pending_id = " . intval($_post['id']) . ' LIMIT 1';
    }
    else {
        // We are doing MULTIPLE - this will be the pending_id from the pending table!
        $_todo = explode(',', $_post['id']);
        foreach ($_todo as $i) {
            if (!jrCore_checktype($i, 'number_nz')) {
                jrCore_set_form_notice('error', 'Invalid pending id');
            }
        }
        $title = 'items have';
        $req   = "SELECT * FROM {$tbl} WHERE pending_module = '" . jrCore_db_escape($_post['_1']) . "' AND pending_id IN(" . implode(',', $_todo) . ')';
    }
    $_rt = jrCore_db_query($req, 'NUMERIC');
    if (!$_rt || !is_array($_rt)) {
        jrCore_set_form_notice('error', 'Invalid pending id - data not found');
    }
    $mod = $_rt[0]['pending_module'];
    $_dl = array();
    $_di = array();
    foreach ($_rt as $v) {
        $_dl[] = (int) $v['pending_id'];
        $_di[] = (int) $v['pending_item_id'];
        if (!empty($v['pending_linked_item_module']) && !empty($v['pending_linked_item_id'])) {
            jrCore_db_delete_item($v['pending_linked_item_module'], $v['pending_linked_item_id']);
        }
    }
    $_it = jrCore_db_get_multiple_items($mod, $_di, null, false, '_item_id');

    foreach ($_rt as $v) {
        // Trigger reject pending event
        $_args = array(
            'module'   => $v['pending_module'],
            '_item_id' => $v['pending_item_id'],
            '_item'    => $_it["{$v['pending_item_id']}"]
        );
        jrCore_trigger_event('jrCore', 'delete_pending_item', $v, $_args);
    }

    // Remove items
    jrCore_db_delete_multiple_items($mod, $_di);
    jrCore_db_delete_pending_item_ids_cache($mod);

    // Remove from pending table
    $tbl = jrCore_db_table_name('jrCore', 'pending');
    $req = "DELETE FROM {$tbl} WHERE pending_id IN(" . implode(',', $_dl) . ')';
    jrCore_db_query($req);

    // See if we are deleting from a media item's page or the dashboard
    jrCore_logger('INF', "core: successfully deleted " . count($_rt) . " pending items", $_rt);
    $url = jrCore_get_local_referrer();
    if (strpos($url, 'dashboard')) {
        jrCore_set_form_notice('success', "The pending {$title} been deleted");
    }
    // We're coming in from an individual item's page - redirect to index
    jrCore_set_form_notice('success', 'The pending item(s) were successfully deleted');
    jrCore_location(jrCore_get_base_url() . "/" . jrCore_get_module_url('jrCore') . "/dashboard/pending/m={$mod}");
}
