<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: log_debug
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_log_debug($_post, $_user, $_conf)
{
    jrUser_admin_only();
    jrCore_page_set_meta_header_only();
    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'number_nz')) {
        jrCore_notice_page('error', 'invalid log_debug id');
    }
    $lid    = intval($_post['_1']);
    $button = jrCore_page_button('close', 'close', 'self.close();');
    jrCore_page_banner('Activity Log #' . $lid, $button);
    $tbl = jrCore_db_get_archive_table_for_unique_id('jrCore', 'log', $lid);
    $tbd = jrCore_db_table_name('jrCore', 'log_debug_data');
    $req = "SELECT *, UNCOMPRESS(d.log_data) AS log_data
              FROM {$tbl} l
         LEFT JOIN {$tbd} d ON (d.log_log_id = l.log_id)
             WHERE l.log_id = {$lid}";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (empty($_rt['log_log_id'])) {
        // Do we have the old log data?
        $tbd = jrCore_db_table_name('jrCore', 'log_debug');
        $req = "SELECT * FROM {$tbd} WHERE log_log_id = {$lid}";
        $_ld = jrCore_db_query($req, 'SINGLE');
        if (is_array($_ld)) {
            $_rt = array_merge($_rt, $_ld);
        }
    }

    $dat             = array();
    $dat[1]['title'] = 'Key';
    $dat[1]['width'] = '10%';
    $dat[2]['title'] = 'Value';
    $dat[2]['width'] = '90%';
    jrCore_page_table_header($dat);

    $pid = '-';
    if (strpos($_rt['log_text'], '%') === 0) {
        preg_match('/^%([0-9]*)%/', $_rt['log_text'], $m);
        if (!empty($m[1])) {
            $pid             = (int) $m[1];
            $_rt['log_text'] = substr($_rt['log_text'], strpos($_rt['log_text'], '%:') + 2);
        }
    }

    $dat             = array();
    $dat[1]['title'] = 'Message';
    $dat[1]['class'] = 'right';
    $dat[2]['title'] = jrCore_entity_string($_rt['log_text']);
    $dat[2]['class'] = "log-{$_rt['log_priority']} word-break";
    jrCore_page_table_row($dat);

    $dat             = array();
    $dat[1]['title'] = 'Date';
    $dat[1]['class'] = 'right';
    $dat[2]['title'] = jrCore_format_time($_rt['log_created']);
    jrCore_page_table_row($dat);

    $dat             = array();
    $dat[1]['title'] = 'IP&nbsp;Address';
    $dat[1]['class'] = 'right';
    $dat[2]['title'] = $_rt['log_ip'];
    jrCore_page_table_row($dat);

    $dat             = array();
    $dat[1]['title'] = 'PID';
    $dat[1]['class'] = 'right';
    $dat[2]['title'] = $pid;
    jrCore_page_table_row($dat);

    $dat             = array();
    $dat[1]['title'] = 'URL';
    $dat[1]['class'] = 'right';
    $dat[2]['title'] = $_rt['log_url'];
    $dat[2]['class'] = 'word-break';
    jrCore_page_table_row($dat);

    $dat             = array();
    $dat[1]['title'] = 'Memory';
    $dat[1]['class'] = 'right';
    $dat[2]['title'] = jrCore_format_size($_rt['log_memory']);
    jrCore_page_table_row($dat);

    $dat             = array();
    $dat[1]['title'] = 'Data';
    $dat[1]['class'] = 'right';
    if (strpos(' ' . $_rt['log_data'], '<html') && !strpos($_rt['log_data'], '[_uri] =>')) {
        // we have HTML in our debug - we want to show it if we can
        $dat[2]['title'] = '<iframe class="core-log-iframe" src="' . jrCore_get_base_url() . '/' . $_post['module_url'] . '/load_log_debug/id=' . intval($_rt['log_log_id']) . '"></iframe>';
        $dat[2]['class'] = '" style="padding:0';
    }
    else {
        $dat[2]['title'] = '<div class="fixed-width">' . str_replace(',', ', ', jrCore_entity_string($_rt['log_data'])) . '</div>';
    }
    jrCore_page_table_row($dat);
    jrCore_page_table_footer();
    jrCore_page_close_button();
    jrCore_page_title("Log Entry ID #{$lid}");
    jrCore_page_display();
}
