<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: js
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_js($_post, $_user, $_conf)
{
    global $_urls;
    // http://site.com/core/js/audio/jrAudio_jplayer_dark.js
    // http://site.com/core/js/core/tinymce/tinymce.js
    // http://site.com/core/js/core/tinymce/themes/silver/theme.min.js
    if (!isset($_post['_1']) || ($_post['_1'] != 'skin' && !isset($_urls["{$_post['_1']}"]))) {
        jrCore_notice('Error', "invalid module or skin");
    }
    if (!isset($_post['_2']) || strlen($_post['_2']) === 0) {
        jrCore_notice('Error', "invalid javascript file");
    }
    if ($_post['_1'] == 'skin') {
        $dir = 'skins/' . jrCore_get_config_value('jrCore', 'active_skin', 'jrElastic2');
    }
    else {
        $dir = 'modules/' . $_urls["{$_post['_1']}"];
    }

    // If _3 is not empty it means we are serving from /contrib
    $file = false;
    if (!empty($_post['_3'])) {
        if (strpos($_post['_uri'], '..')) {
            jrCore_notice('Error', 'invalid javascript file');
        }
        $idx = 2;
        $_pt = array();
        while (true) {
            if (!empty($_post["_{$idx}"])) {
                $_pt[] = $_post["_{$idx}"];
            }
            else {
                break;
            }
            $idx++;
        }
        if (count($_pt) > 0) {
            $file = APP_DIR . "/{$dir}/" . implode('/', $_pt);
        }
        else {
            jrCore_notice('Error', 'required file not found');
        }
    }
    else {
        $file = APP_DIR . "/{$dir}/js/{$_post['_2']}";
    }

    jrCore_start_timer('filesystem');
    if (!$file || !is_file($file)) {
        jrCore_stop_timer('filesystem');
        jrCore_notice('Error', 'required file not found (2)');
    }
    if (!$tim = filectime($file)) {
        jrCore_stop_timer('filesystem');
        jrCore_notice('Error', 'required file not found (3)');
    }
    jrCore_stop_timer('filesystem');
    if (jrCore_file_extension($file) != 'js') {
        jrCore_notice('Error', 'invalid javascript file (2)');
    }

    $exp = (time() + 8640000);
    jrCore_set_custom_header('Last-Modified: ' . gmdate('r', $tim));
    jrCore_set_custom_header('Content-Disposition: inline; filename="' . basename($file) . '"');
    jrCore_set_custom_header('Content-Type: application/javascript');
    jrCore_set_custom_header('Cache-Control: must-revalidate');
    jrCore_set_custom_header('Expires: ' . gmdate('D, d M Y H:i:s \G\M\T', $exp));

    $ifs = false;
    if (!empty($_SERVER['HTTP_IF_MODIFIED_SINCE'])) {
        $ifs = $_SERVER['HTTP_IF_MODIFIED_SINCE'];
    }
    elseif (function_exists('getenv')) {
        $ifs = getenv('HTTP_IF_MODIFIED_SINCE');
    }
    if ($ifs && strtotime($ifs) == $tim) {
        // We have not been modified since the browser requested the file
        jrCore_set_custom_header('HTTP/1.1 304 Not Modified');
        jrCore_send_response_and_detach();
    }
    // Fall through - send out file
    $file = jrCore_file_get_contents($file);
    jrCore_send_response_and_detach($file);
}
