<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: item_display_order_update
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_item_display_order_update($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    if (!isset($_post['m']) || !jrCore_module_is_active($_post['m'])) {
        return jrCore_json_response(array('error', 'Invalid module'));
    }
    // Make sure the requested module has a registered DS
    $pfx = jrCore_db_get_prefix($_post['m']);
    if (!$pfx) {
        return jrCore_json_response(array('error', 'Invalid module - module does not use a DataStore'));
    }
    // Make sure this module has registered for item_order
    $_md = jrCore_get_registered_module_features('jrCore', 'item_order_support');
    if (!isset($_md["{$_post['m']}"])) {
        return jrCore_json_response(array('error', 'Invalid module - module is not registered for item_order support'));
    }

    // Get our items that are being re-ordered and make sure
    // the calling user has access to them
    if (!jrUser_is_admin()) {
        $_rt = jrCore_db_get_multiple_items($_post['m'], $_post['iid']);
        if (!isset($_rt) || !is_array($_rt)) {
            return jrCore_json_response(array('error', 'unable to retrieve item entries from DataStore'));
        }
        foreach ($_rt as $_v) {
            if (!jrUser_can_edit_item($_v)) {
                return jrCore_json_response(array('error', 'permission denied'));
            }
        }
    }

    // Looks good - set item order
    $_ids = array();
    foreach ($_post['iid'] as $ord => $iid) {
        $_ids[$iid] = $ord;
    }
    jrCore_db_set_display_order($_post['m'], $_ids);

    $pid = (int) $_user['user_active_profile_id'];
    jrProfile_reset_cache($pid, $_post['m']);
    jrUser_reset_cache($_user['_user_id'], $_post['m']);
    jrCore_delete_cache('jrCore', "display_order_for_profile_id_{$pid}", false, false);

    $_ln = jrUser_load_lang_strings();
    return jrCore_json_response(array('success' => $_ln['jrCore'][86]));
}
