<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: debug_log
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_debug_log($_post, $_user, $_conf)
{
    jrUser_admin_only();
    jrCore_page_dashboard_tabs('activity');
    jrCore_master_log_tabs('debug');

    $max_size = 1;  // in megabytes
    $clear    = null;
    $out      = "<div class=\"center\"><p>No Debug Log entries at this time</p></div>";
    if (is_file(APP_DIR . "/data/logs/debug_log")) {
        // How big is our debug log?
        $out = '<div id="debug_log">';
        if (filesize(APP_DIR . "/data/logs/debug_log") > ($max_size * 1048576)) {
            // we're only going to grab the first 2mb
            if ($f = fopen(APP_DIR . "/data/logs/debug_log", 'rb')) {
                $out .= jrCore_entity_string(fread($f, ($max_size * 1048576)));
                fclose($f);
                $out .= "\n\n(file has been truncated to fit here - to see full file download it via FTP)";
            }
        }
        else {
            $out .= jrCore_entity_string(jrCore_file_get_contents(APP_DIR . "/data/logs/debug_log"));
        }
        $out .= '</div>';
        if (jrUser_is_master()) {
            $clear = jrCore_page_button('clear', 'Delete Debug Log', "jrCore_confirm('Delete the Debug Log?', '', function(){ jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/debug_log_delete') } );");
        }
    }
    jrCore_page_banner('Debug Log', $clear);
    jrCore_page_custom($out);
    jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools");
    jrCore_page_display();
}
