<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * lib/util.php unit tests
 */
function test_jrCore_template()
{
    // What library file are we testing?
    jrUnitTest_add_coverage_file(APP_DIR . "/modules/jrCore/lib/skin.php");

    $_rep = array(
        'foreach'   => array(
            10 => 'Ten',
            20 => 'Twenty',
            30 => 'Thirty'
        ),
        'value1'    => 'Value One',
        'truefalse' => true,
        'lorem'     => ' Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam feugiat ligula porttitor ipsum molestie, eget convallis tortor facilisis. Pellentesque ornare sagittis eleifend. Donec pretium sem elementum, vulputate risus vel, mollis sem. Ut varius consequat sapien, sed accumsan orci vulputate ornare. In viverra, nisl vitae condimentum porta, urna ex facilisis risus, et ultricies est ipsum eget nulla. Maecenas vitae suscipit lacus, quis tempor libero. Morbi id dapibus elit.

Suspendisse fringilla congue quam, non aliquam quam accumsan dignissim. Mauris molestie orci sed cursus scelerisque. Vestibulum aliquet, eros eget dictum tristique, mi odio efficitur justo, non luctus orci augue sed libero. Fusce convallis semper dui, vitae aliquam velit eleifend nec. Curabitur ac enim diam. Praesent lectus justo, congue a pretium sit amet, egestas varius augue. Fusce non lobortis purus, sit amet bibendum orci. Suspendisse ligula velit, varius nec maximus tempor, tincidunt eu lorem. Morbi pharetra ac dui ut accumsan. Vestibulum sodales elit nec turpis mattis, sit amet fermentum lacus mollis. Pellentesque nec augue eget nunc tempor commodo. Pellentesque sed eros non erat sagittis laoreet sit amet ut felis. Donec porta ultricies mi, vitae molestie lorem facilisis finibus. Etiam vel tincidunt velit.'
    );
    jrUnitTest_init_test('Parse Template');
    if (!jrCore_parse_template('unit_test.tpl', $_rep, 'jrCore', true)) {
        jrUnitTest_exit_with_error('error parsing unit_test.tpl');
    }

}
