<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * lib/smarty.php Unit tests
 */
function test_jrCore_smarty()
{
    global $_conf;

    // What library file are we testing?
    jrUnitTest_add_coverage_file(APP_DIR . "/modules/jrCore/lib/smarty.php");

    // These tests are here for running the Profiler
    $_tpl = glob(APP_DIR . '/modules/jrCore/templates/*.tpl');
    if ($_tpl && is_array($_tpl)) {
        foreach ($_tpl as $template) {
            if (strpos(' ' . file_get_contents($template), '{jrCore_include')) {
                // Unit testing breaks on jrCore_include - skip
                continue;
            }
            $mod = basename(dirname(dirname($template)));
            $tpl = basename($template);
            jrUnitTest_init_test('Parse Template: ' . $mod .'/'. $tpl);
            if (!jrCore_parse_template($tpl, $_conf, $mod, true)) {
                jrUnitTest_exit_with_error('error parsing template: ' . $mod .'/'. $tpl);
            }
        }
    }

    // Test skin templates
    if ($skin = jrCore_get_config_value('jrCore', 'active_skin', 'jrElastic2')) {
        $_tpl = glob(APP_DIR . "/skins/{$skin}/*.tpl");
        if ($_tpl && is_array($_tpl)) {
            foreach ($_tpl as $template) {
                if (strpos(' ' . file_get_contents($template), '{jrCore_include')) {
                    // Unit testing breaks on jrCore_include - skip
                    continue;
                }
                $tpl = basename($template);
                jrUnitTest_init_test('Parse Skin Template: ' . $tpl);
                if (!jrCore_parse_template($tpl, $_conf, $skin, true)) {
                    jrUnitTest_exit_with_error('error parsing template: ' . $skin . '/' . $tpl);
                }
            }
        }
    }

}
