<?php
/**
 * Country specific Phone Number formatter
 * @copyright 2003-2022 Talldude Networks, LLC.
 * @author Brian Johnson <brian [at] jamroom [dot] net>
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * Return the COUNTRY CODE for this country plugin
 * @return string
 */
function jrCore_plugin_format_phone_number_US_country_code()
{
    return '1-';
}

/**
 * Format a phone number specific for a country
 * @param string $string Phone Number to format
 * @return string
 */
function jrCore_plugin_format_phone_number_US($string)
{
    // Format as 000-000-0000
    $_parts = array();
    $length = strlen("{$string}");
    if ($length >= 11 && strpos("{$string}", '1') === 0) {
        // This number already INCLUDES the country code - remove
        $string = substr("{$string}", 1);
        $length--;
    }
    if ($length === 7) {
        $_parts[] = '000';
        $_parts[] = substr($string, -7, 3);
        $_parts[] = substr($string, -4, 4);
    }
    elseif ($length === 8) {
        $_parts[] = '00' . substr($string, -8, 1);
        $_parts[] = substr($string, -7, 3);
        $_parts[] = substr($string, -4, 4);
    }
    elseif ($length === 9) {
        $_parts[] = '0' . substr($string, -9, 2);
        $_parts[] = substr($string, -7, 3);
        $_parts[] = substr($string, -4, 4);
    }
    else {
        $_parts[] = substr($string, -10, 3);
        $_parts[] = substr($string, -7, 3);
        $_parts[] = substr($string, -4, 4);
    }
    return implode('-', $_parts);
}

