<?php
 /**
 * Jamroom Blog module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrBlog_create_save($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();
    jrCore_form_validate($_post);
    jrUser_check_quota_access('jrBlog');

    // Get our posted data - the jrCore_form_get_save_data function will
    // return just those fields that were presented in the form.
    $_rt = jrCore_form_get_save_data('jrBlog', 'create', $_post);

    // Add in our SEO URL names
    $_rt['blog_title_url']    = jrCore_url_string($_rt['blog_title']);
    $_rt['blog_category_url'] = jrCore_url_string($_rt['blog_category']);
    //check for a 'read more'
    $_rt['blog_readmore'] = (strpos($_rt['blog_text'], '<!-- pagebreak -->')) ? 1 : 0;

    // $bid will be the INSERT_ID (_item_id) of the created item
    $bid = jrCore_db_create_item('jrBlog', $_rt);
    if (!$bid) {
        jrCore_set_form_notice('error', 12);
        jrCore_form_result();
    }
    // Save any uploaded media files added in by our
    jrCore_save_all_media_files('jrBlog', 'create', $_user['user_active_profile_id'], $bid);

    // Add to Actions if publish date not in the future
    if (!isset($_rt['blog_publish_date']) || $_rt['blog_publish_date'] < time() + 3600) {
        jrCore_run_module_function('jrAction_save', 'create', 'jrBlog', $bid);
    }

    jrCore_form_delete_session();
    jrProfile_reset_cache();
    jrUser_reset_cache($_user['_user_id'], 'jrBlog');

    // redirect to the actual blog page, not the update page.
    jrCore_form_result("{$_conf['jrCore_base_url']}/{$_user['profile_url']}/{$_post['module_url']}/{$bid}/{$_rt['blog_title_url']}");
}
