<?php
 /**
 * Jamroom Banned Items module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: item_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrBanned_item_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_validate_location_url();

    // See what we are adding
    switch ($_post['ban_type']) {
        case 'ip':
            $val = 'printable';
            // Make sure we are not blocking our own IP
            if (isset($_post['ban_value']) && ($_post['ban_value'] == jrCore_get_ip() || strpos(' ' . jrCore_get_ip(), $_post['ban_value']))) {
                jrCore_set_form_notice('error', 'That rule would ban your IP address!');
                jrCore_location('referrer');
            }
            break;
        case 'name':
        case 'word':
            $val = 'printable';
            break;
        case 'email':
            $val = 'string';
            break;
        default:
            if (!jrBanned_is_valid_ban_type($_post['ban_type'])) {
                jrCore_set_form_notice('error', 'Invalid Ban Type');
                jrCore_location('referrer');
                return true;
            }
            $val = 'not_empty';
            break;
    }
    if (!isset($_post['ban_value']) || !jrCore_checktype($_post['ban_value'], $val)) {
        $err = jrCore_checktype(null, $val, true);
        jrCore_set_form_notice('error', 'You have entered an invalid item value - please enter ' . $err);
        jrCore_location('referrer');
    }
    $_post['ban_partial'] = (isset($_post['ban_partial']) && $_post['ban_partial'] == 'on') ? 'on' : 'off';

    $tbl = jrCore_db_table_name('jrBanned', 'banned');
    $req = "INSERT INTO {$tbl} (ban_updated, ban_type, ban_value, ban_partial)
            VALUES (UNIX_TIMESTAMP(),'" . jrCore_db_escape($_post['ban_type']) . "','" . jrCore_db_escape($_post['ban_value']) . "','" . $_post['ban_partial'] . "')
            ON DUPLICATE KEY UPDATE ban_updated = UNIX_TIMESTAMP()";
    jrCore_db_query($req);

    // Reset caches
    $key = "jrbanned_config_{$_post['ban_type']}";
    jrCore_delete_flag($key);
    jrCore_delete_local_cache_key($key);
    jrCore_delete_cache('jrBanned', $key, false, false);

    // Trigger our creation
    jrCore_trigger_event('jrBanned', 'banned_item_create', $_post);

    jrCore_set_form_notice('success', 'The Banned Item has been successfully created');
    jrCore_location('referrer');
    return true;
}
