<?php
 /**
 * Jamroom Timeline module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: share_msg
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAction_share_msg($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_check_quota_access('jrAction');

    if (!isset($_post['_1']) || !jrCore_module_is_active($_post['_1'])) {
        return 'error: invalid module';
    }
    if (!isset($_post['_2']) || !jrCore_checktype($_post['_2'], 'number_nz')) {
        return 'error: invalid item_id';
    }
    $_temp            = $_post;
    $_temp['module']  = $_post['_1'];
    $_temp['item_id'] = (int) $_post['_2'];

    // Does this module have a custom template?
    $_temp['template'] = false;
    if (is_file(APP_DIR . "/modules/{$_post['_1']}/templates/item_share.tpl")) {
        $_temp['template'] = 'item_share.tpl';
    }

    // Remove our list buttons for the share modal
    if ($_tmp = jrCore_get_flag('jrcore_register_module_feature')) {
        unset($_tmp['jrCore']['item_list_button']);
        jrCore_set_flag('jrcore_register_module_feature', $_tmp);
    }

    return jrCore_parse_template('item_share_modal.tpl', $_temp, 'jrAction');
}
