<?php
 /**
 * Jamroom Timeline module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: share
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAction_share($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_check_quota_access('jrAction');
    jrCore_validate_location_url();

    // Must get a module
    if (!isset($_post['_1']) || !jrCore_module_is_active($_post['_1'])) {
        jrCore_notice_page('error', 'Invalid module received - please try again');
    }
    $mod = $_post['_1'];

    // We should get a valid action ID
    if (!isset($_post['_2']) || !jrCore_checktype($_post['_2'], 'number_nz')) {
        jrCore_notice_page('error', 'Invalid action_id received - please try again');
    }
    $iid = (int) $_post['_2'];

    // Are we sharing an item or a timeline entry?
    $pid = jrUser_get_profile_home_key('_profile_id');
    if ($mod == 'jrAction') {

        // We are sharing a Timeline entry
        $_rt = jrCore_db_get_item('jrAction', $iid);
        if (!$_rt || !is_array($_rt)) {
            jrCore_notice_page('error', 'Invalid item_id received - no data found');
        }

        // Make sure we have not ALREADY shared this
        if ($aid = jrAction_get_user_share_id('jrAction', $iid, $_user['_user_id'])) {
            // We have already shared this item - redirect to the action item detail page
            jrCore_location("{$_conf['jrCore_base_url']}/{$_user['profile_url']}/{$_post['module_url']}/" . $aid);
        }

        // add in the share text if present
        $txt = '';
        if (isset($_post['share_text']) && strlen($_post['share_text']) > 0) {
            $txt = $_post['share_text'] . "\n";
        }
        $url = jrCore_get_module_url('jrAction');
        $url = "{$_conf['jrCore_base_url']}/{$_rt['profile_url']}/{$url}/{$iid}";

        // Copy it
        $_nw = array(
            'action_text'          => $txt,
            'action_shared_url'    => $url,
            'action_module'        => 'jrAction',
            'action_shared'        => (int) $_rt['_profile_id'],
            'action_original_item' => "jrAction:{$iid}:create"
        );

        $aid = jrCore_db_create_item('jrAction', $_nw, array('_profile_id' => $pid));
        if (!$aid) {
            jrCore_notice_page('error', 'unable to share action!');
        }

        // Save hashes in share text
        if (isset($_post['share_text']) && strlen($_post['share_text']) > 0) {
            jrAction_save_hash_tags($aid, $_post['share_text']);
        }

        // Add user_id to item action_shared_by field
        $_sb = array();
        if (isset($_rt['action_shared_by'])) {
            $_sb = explode(',', $_rt['action_shared_by']);
        }
        if (count($_sb) > 0) {
            foreach ($_sb as $k => $v) {
                if (!is_numeric($v)) {
                    unset($_sb[$k]);
                }
                else {
                    $_sb[$k] = (int) $v;
                }
            }
        }
        $_sb[] = (int) $_user['_user_id'];
        $_up   = array(
            'action_shared_by' => implode(',', $_sb)
        );
        jrCore_db_update_item('jrAction', $_rt['_item_id'], $_up, null, false, true, false);

        // Save Share
        jrAction_save_user_share('jrAction', $iid, $_user['_user_id'], $aid);

        // Increment shared key for profile of item being shared
        jrCore_db_increment_key('jrProfile', $_rt['_profile_id'], 'profile_jrAction_shared_item_count', 1);

        // Notifications
        $_uids   = array($_user['_user_id'] => $_user['_user_id']);
        $_owners = jrProfile_get_owner_info($_rt['_profile_id']);
        if ($_owners && is_array($_owners)) {
            $_rp = array(
                'action_user' => $_user,
                'action_url'  => jrCore_get_local_referrer()
            );
            list($sub, $msg) = jrCore_parse_email_templates('jrAction', 'share', $_rp);
            foreach ($_owners as $_o) {
                if ($_o['_user_id'] != $_user['_user_id']) {
                    jrUser_notify($_o['_user_id'], 0, 'jrAction', 'share', $sub, $msg);
                    $_uids["{$_o['_user_id']}"] = $_o['_user_id'];
                }
            }
        }

        // Reset caches
        jrProfile_reset_cache($pid, 'jrAction');
        jrUser_reset_cache($_uids, 'jrAction');

        // allow redirection by modules
        $_data = array(
            'url' => "{$_conf['jrCore_base_url']}/{$_user['profile_url']}/{$_post['module_url']}"
        );
        $_data = jrCore_trigger_event('jrAction', 'action_redirect', $_data, $_post);
        if ($_data['url'] != $url) {
            jrCore_location($_data['url']);
        }

        // If this is an admin user, redirect back to their home time line
        if (jrUser_is_admin()) {
            $url = jrUser_get_profile_home_key('profile_url');
            jrCore_location("{$_conf['jrCore_base_url']}/{$url}/{$_post['module_url']}");
        }
        $url = jrCore_get_local_referrer();
        // Is this a mapped URL?
        if (strpos($url, $_conf['jrCore_base_url']) !== 0) {
            $url = jrCore_strip_url_params($url, array('p'));
            jrCore_location($url);
        }

        jrCore_location("{$_conf['jrCore_base_url']}/{$_user['profile_url']}/{$_post['module_url']}");
    }

    // Fall through - We are sharing an item - we're going to simply create a URL
    // Share to our timeline that can be picked up by the Media URL Scanner
    $_it = jrCore_db_get_item($mod, $iid);
    if (!$_it || !is_array($_it)) {
        jrCore_notice_page('error', 'Invalid item_id received - no data found');
    }

    $url = jrCore_get_module_url($mod);
    $pfx = jrCore_db_get_prefix($mod);
    $ttl = '';
    if (isset($_it["{$pfx}_title_url"])) {
        $ttl = '/' . $_it["{$pfx}_title_url"];
    }
    $url = "{$_conf['jrCore_base_url']}/{$_it['profile_url']}/{$url}/{$iid}{$ttl}";

    // Make sure we have not ALREADY shared this
    if (jrAction_get_user_share_id($mod, $iid, $_user['_user_id'])) {
        // We have already shared this item - redirect to the action item detail page
        jrCore_location($url);
    }

    $txt = '';
    if (!empty($_post['share_text'])) {
        $txt = $_post['share_text'] . "\n";
    }

    $_rt = array(
        'action_text'          => $txt,
        'action_shared_url'    => $url,
        'action_module'        => 'jrAction',
        'action_shared'        => $_it['_profile_id'],
        'action_original_item' => "{$mod}:{$iid}:create"
    );
    $_cr = array(
        '_profile_id' => $pid
    );
    $aid = jrCore_db_create_item('jrAction', $_rt, $_cr);
    if (!$aid) {
        jrCore_notice_page('error', 'unable to create new activity entry - please try again');
    }

    // Save hashes
    if (!empty($_post['share_text'])) {
        jrAction_save_hash_tags($aid, $_post['share_text']);
    }

    // Save Share
    jrAction_save_user_share($mod, $iid, $_user['_user_id'], $aid);

    // Send out our Action Created trigger
    $_args = array(
        '_item_id'    => $aid,
        '_user_id'    => $_user['_user_id'],
        '_profile_id' => $pid
    );
    jrCore_trigger_event('jrAction', 'create', $_rt, $_args);

    jrCore_db_increment_key($mod, $iid, "{$pfx}_share_count", 1);

    // Increment shared key for profile of item being shared as long as we're not sharing our own item
    if ($_it['_profile_id'] !== $pid) {
        jrCore_db_increment_key('jrProfile', $_it['_profile_id'], 'profile_jrAction_shared_item_count', 1);
    }

    jrProfile_reset_cache($pid, 'jrAction');
    jrUser_reset_cache($_user['_user_id'], 'jrAction');
    jrCore_location(jrCore_get_local_referrer());
}
