<?php
 /**
 * Jamroom Timeline module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: quick_share_form
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAction_quick_share_form($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_check_quota_access('jrAction');
    if (!isset($_post['function'])) {
        $_rs = array('error' => 'invalid quick share function');
        jrCore_json_response($_rs);
    }
    $func = $_post['function'];
    if (!function_exists($func)) {
        $_rs = array('error' => 'invalid quick share function - function does not exist');
        jrCore_json_response($_rs);
    }

    // Get modules supporting Quick Share
    $ttl = '';
    $_tm = jrCore_get_registered_module_features('jrAction', 'quick_share');
    if ($_tm && is_array($_tm)) {
        $_ln = jrUser_load_lang_strings();
        foreach ($_tm as $mod => $_inf) {
            foreach ($_inf as $function => $_config) {
                if ($function == $func) {
                    if (isset($_config['title']) && jrCore_checktype($_config['title'], 'number_nz')) {
                        $_config['title'] = $_ln[$mod]["{$_config['title']}"];
                    }
                    $ttl = $_config['title'];
                    break;
                }
            }
        }
    }
    if (strlen($ttl) > 0) {
        $_rs = array(
            'html'  => $func($_post, $_user, $_conf),
            'title' => $ttl
        );
        jrCore_json_response($_rs, true, false);
    }
    $_rs = array('error' => 'invalid quick share function - function is not registered');
    jrCore_json_response($_rs);
}
