<?php
 /**
 * Jamroom Timeline module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: delete
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAction_delete($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();
    jrUser_check_quota_access('jrAction');
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_notice_page('error', 'Invalid item id');
    }
    $_rt = jrCore_db_get_item('jrAction', $_post['id'], SKIP_TRIGGERS);
    if (!$_rt || !is_array($_rt)) {
        jrCore_notice_page('error', 'Invalid item id');
    }
    // Make sure the calling user has permissions to remove this action
    if (!jrUser_can_edit_item($_rt)) {
        jrUser_not_authorized();
    }
    jrCore_db_delete_item('jrAction', $_post['id']);

    // If we are deleting a SHARED entry, we have to update the original item so it no longer thinks we shared it
    if (!empty($_rt['action_original_item'])) {
        list($mod, $iid,) = explode(':', $_rt['action_original_item'], 3);
        if ($mod == 'jrAction' && jrCore_checktype($iid, 'number_nz')) {
            $_oi = jrCore_db_get_item('jrAction', $iid, SKIP_TRIGGERS);
            if ($_oi && is_array($_oi) && isset($_oi['action_shared_by'])) {
                $_tm = explode(',', $_oi['action_shared_by']);
                if ($_tm && is_array($_tm)) {
                    foreach ($_tm as $k => $v) {
                        if ($v == $_rt['_user_id']) {
                            unset($_tm[$k]);
                        }
                    }
                    jrCore_db_update_item('jrAction', $iid, array('action_shared_by' => implode(',', $_tm)));
                    jrProfile_reset_cache($_oi['_profile_id'], 'jrAction');
                }
            }
        }
    }
    jrProfile_reset_cache($_rt['_profile_id'], 'jrAction');
    jrUser_reset_cache($_user['_user_id'], 'jrAction');

    // See where we came from
    $url = jrCore_get_local_referrer();
    if (strpos($url, "{$_post['module_url']}/{$_post['id']}")) {
        jrCore_location("{$_conf['jrCore_base_url']}/{$_user['profile_url']}");
    }
    jrCore_location('referrer');
}
