<?php
 /**
 * Jamroom Timeline module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAction_create_save($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();
    jrUser_check_quota_access('jrAction');
    if (!jrUser_is_admin() && isset($_user['quota_jrAction_can_post']) && $_user['quota_jrAction_can_post'] != 'on') {
        jrUser_not_authorized();
    }

    // Must get a posted function
    if (!isset($_post['jrAction_function'])) {
        $_rs = array('error' => 'invalid action function');
        jrCore_json_response($_rs);
    }

    // Check for banned words..
    if (jrCore_module_is_active('jrBanned') && $ban = jrCore_run_module_function('jrBanned_is_banned', 'word', $_post['action_text'])) {
        $_ln = jrUser_load_lang_strings();
        $_rs = array('error' => "{$_ln['jrCore'][67]} " . strip_tags($ban));
        jrCore_json_response($_rs);
    }

    $fnd = false;
    $_tm = jrCore_get_registered_module_features('jrAction', 'quick_share');
    if ($_tm && is_array($_tm)) {
        foreach ($_tm as $mod => $_inf) {
            foreach ($_inf as $function => $_config) {
                if ($function == $_post['jrAction_function']) {
                    $fnd = $mod;
                    break 2;
                }
            }
        }
    }
    if (!$fnd) {
        // Function is not registered
        $_rs = array('error' => 'invalid action function - function not found');
        jrCore_json_response($_rs);
    }
    if ($_post['jrAction_function'] == 'jrAction_quick_share_status_update') {
        // Is editor turned on?
        if (isset($_post['action_text_editor_contents'])) {
            $_post['action_text'] = $_post['action_text_editor_contents'];
        }
    }
    else {
        unset($_post['action_text']);
    }

    // Pass off to save function
    $func = "{$_post['jrAction_function']}_save";
    if (!function_exists($func)) {
        // Save function does not exist
        $_rs = array('error' => 'invalid action function - save function not found');
        jrCore_json_response($_rs);
    }

    // @note: We will received the _item_id of the action item created
    if ($aid = $func($_post, $_user, $_conf)) {
        // If we get a missing value from the SAVE function it will start with FIELD
        if (strpos($aid, 'FIELD:') === 0) {
            $_rs = array('field' => trim(substr($aid, 7)));
            jrCore_json_response($_rs);
        }
        // If we get an error from a SAVE function it will start with ERROR:
        elseif (strpos($aid, 'ERROR:') === 0) {
            $_rs = array('error' => substr($aid, 7));
            jrCore_json_response($_rs);
        }
        elseif (!jrCore_checktype($aid, 'number_nz')) {
            // We encountered an ERROR
            jrCore_logger('MAJ', "action: invalid _item_id returned from registered action feature: {$func}");
            // @note: we will fall through here and redirect to the profile's timeline
        }
        else {
            // We need to see if this item was created as PENDING
            if (!$_rt = jrCore_db_get_item('jrAction', $aid, true, true)) {
                // We were not actually created
                $_rs = array('error' => 'Unable to save timeline entry - please try again');
                jrCore_json_response($_rs);
            }
        }

        // Success - reset caches
        $profile_url = jrUser_get_profile_home_key('profile_url');
        if (isset($_user['user_active_profile_id']) && jrCore_checktype($_user['user_active_profile_id'], 'number_nz')) {
            jrProfile_reset_cache($_user['user_active_profile_id'], 'jrAction');
            $pid = jrUser_get_profile_home_key('_profile_id');
            if ($_user['user_active_profile_id'] != $pid) {
                $profile_url = jrCore_db_get_item_key('jrProfile', $_user['user_active_profile_id'], 'profile_url');
                jrProfile_reset_cache($_user['user_active_profile_id'], 'jrAction');
            }
        }
        jrUser_reset_cache($_user['_user_id'], 'jrAction');
        jrCore_form_delete_session();

        // @note: if we are PENDING then we need to redirect to the actual timeline detail page so they see it
        if (!empty($_rt['action_pending']) && $_rt['action_pending'] == 1) {
            $url = jrCore_get_module_url('jrAction');
            $url = "{$_conf['jrCore_base_url']}/{$profile_url}/{$url}/{$aid}";
        }
        else {
            $url = "{$_conf['jrCore_base_url']}/{$profile_url}";
        }

        // allow redirection by modules
        $_data = array('url' => $url);
        $_data = jrCore_trigger_event('jrAction', 'action_redirect', $_data, $_post);
        if ($_data['url'] != $url) {
            $url = $_data['url'];
        }
        $_rs = array('success' => 1, 'url' => $url);
    }
    else {
        $_rs = array('error', 'an internal error has occured - please try again');
    }
    jrCore_json_response($_rs);
}
