<?php
/************************************************************
 * InfiniteWP Admin panel									*
 * Copyright (c) 2012 Revmakx								*
 * www.revmakx.com											*
 *															*
 ************************************************************/
 
function checkUpdateV3($force=false, $checkForUpdate=true){
	$currentTime = time();
	$updateLastChecked = getOption('updateLastCheckV3');
	if(!$force){
		$updateCheckInterval = 86400;//86400 => 1 day in seconds
	
		if(stripos(APP_VERSION, 'beta') !== false) $updateCheckInterval = (60 * 60 * 4);//60 * 60 * 4 every 4 hrs. betaClientPlugin update notification comes via checkUpdate

		if( ($currentTime - $updateLastChecked) < $updateCheckInterval ){
			return getCachedUpdateDetailsV3();
		}
	}
	
	if(!$checkForUpdate){
		return false;
	}
	
	$updateLastTried = getOption('updateLastTryV3');
	if(!$force && $updateLastTried > 0 && $updateLastChecked > 0 && ($currentTime - $updateLastTried) < 600){//auto checkUpdate after 600 secs
		return false;
	}
	if(!$force && $updateLastTried > 0 && ($currentTime - $updateLastTried) <= 10){//no new checkUpdate within 10 secs of last try
		return getCachedUpdateDetailsV3();
	}
	updateOption('updateLastTryV3', $currentTime);

	$URL = getOption('serviceURL').'checkUpdateV3.php';	
	$URL .= '?appVersion='.APP_VERSION.'&appInstallHash='.APP_INSTALL_HASH.'&installedHash='.getInstalledHashV3().'&installedHashV2='.getOldInstalledHash();
	
	$installedEmail = getOption('installedEmail');
	if(!empty($installedEmail)){
		$URL .= '&installedEmail='.urlencode($installedEmail);
	}
	
	$partnerHost = getOption('partnerHost');
	if(!empty($partnerHost)){
		$URL .= '&partnerHost='.urlencode($partnerHost);
	}
	
	//$installedAddons = getInstalledAddons();
	$addonDetails = Reg::get('addonDetails');
	if(!empty($addonDetails)){
		foreach($addonDetails as $addonSlug => $addon){
			$URL .=  '&checkAddonsUpdate['.$addonSlug.']='.$addon['version'];		
		}
	}
	$currentGeneralSettings = Reg::get('settings');
	if($currentGeneralSettings['participateBeta'] == 1){
		// $URL .= '&participateBeta=1';
	}	
	if($force){
		$URL .= '&force=1';
	}
    if(defined('DEV_UPDATE')) {
		$URL .= '&devUpdate='.DEV_UPDATE;
    }
    $isV3Installed = getOption('V3Installed');
    if (!empty($isV3Installed)) {
    	$URL .='&V3Installed=1';
    }

    if(defined('IWP_TRIAL_PANEL')) {
		$URL .= '&trailPanel='.IWP_TRIAL_PANEL;
    }

    if (defined('APP_V3')) {
    	$URL .='&isFromV3='.APP_V3;
    }
	
	$suiteDetails = unserialize(getOption('suiteDetailsV3'));
	if(empty($suiteDetails) and !is_array($suiteDetails)) {
		$cancelMessageFlag='';
		$addonSuiteMiniActivity='';
	} else {
		$cancelMessageFlag=$suiteDetails['cancelMessageFlag'];
		$addonSuiteMiniActivity=(isset($suiteDetails['addonSuiteMiniActivity']) && $suiteDetails['addonSuiteMiniActivity']!='')?$suiteDetails['addonSuiteMiniActivity']:'';
	}
	$siteCount = DB::getField("?:sites", "count(*)", "type = 'normal'");
	$URL .='&siteCount='.$siteCount;
	$URL .= '&cancelMessageFlag='.$cancelMessageFlag.'&addonSuiteMiniActivity='.$addonSuiteMiniActivity;
	
	$temp = doCall($URL, '', $timeout=30);
	list($result, , , $curlInfo) = $temp;
	$result = getServiceResponseToArray($result);//from 2.0.8 follows <IWPHEADER><IWPHEADEREND> wrap in return value	
	$curlErrors = new curlErrors($curlInfo);
	if(!$curlErrors->isOk()){
		return $curlErrors->getErrorDetails();
	}
	
	if(empty($result)){
		//response error
		return false;
	}
	
	setHook('updateCheck', $result);
	if (!empty($result['addonsHTML'])) {
		updateOption('addonsHTMLV3', $result['addonsHTML']);
	}
	if (!empty($result['illegalHTML'])) {
		updateOption('addonsIllegalHTMLV3', $result['illegalHTML']);
	}
	if (!empty($result['limitAddSiteHTML'])) {
		updateOption('addSiteHTMLV3', $result['limitAddSiteHTML']);
	}
	if (!empty($result['pricePlanDetails'])) {
		updateOption('pricingPlanTypes', serialize($result['pricePlanDetails']));
	}

	if(!empty($result['updateNotificationDynamicContent'])){
		updateOption('updateNotificationDynamicContent', $result['updateNotificationDynamicContent']);
	}
	if (!empty($result['supportDocs'])) {
		updateOption("supportDocs", $result['supportDocs']);
		updateOption("isShowSupportDocs", $result['isShowSupportDocs']);
		updateOption("isShowSupportSearch", $result['isShowSupportSearch']);
	}
	updateOption('updateLastCheckV3', $currentTime);
	
	if(isset($result['registerd'])){
		updateAppRegisteredV3($result['registerd']);
	}

	if(!empty($result['commonRetryErrorCode'])){
		updateOption('commonRetryErrorCode', $result['commonRetryErrorCode']);
	}
	
	if(isset($result['clientPluginBetaUpdate'])){
		updateOption('clientPluginBetaUpdate', serialize($result['clientPluginBetaUpdate']));
	}
        if(isset($result['checkClientUpdate'])){
		updateOption('clientPluginUpdate', serialize($result['checkClientUpdate']));
	}

	if(isset($result['iwpCronInvited'])){
            $isInvitedEarlier = getOption('iwpCronInvited');
            if(!$isInvitedEarlier){
                updateOption('iwpCrontInvitedNotificationReq', true);
            }
            $iwpCronInvited = $result['iwpCronInvited'];
            updateOption('iwpCronInvited', $iwpCronInvited);
	}

	if(isset($result['mark'])){ //codeSprint
		dispatchMark($result['mark']);
	}

	if(isset($result['addons'])){
		processCheckAddonsUpdateV3($result['addons']);
	}
	if(isset($result['freeAddons'])){
		processCheckFreeAddonsUpdateV3($result['freeAddons']);
	}

	if(isset($result['promos'])){
		updateOption('promos', serialize($result['promos']));
	}

	if (!empty($result['servicePopupNotification'])) {
		processServicePopupNotification($result['servicePopupNotification']);
	}
	if (!empty($result['truncateServicePopup'])) {
		DB::doQuery('TRUNCATE TABLE ?:popup_notification');
	}
	if($result['V3CheckUpdate'] == 'noUpdate'){
		updateOption('V3UpdateAvailable', '');
		return false;
	}
	else{
		updateOption('V3UpdateAvailable', serialize($result['V3CheckUpdate']));
		return $result['V3CheckUpdate'];
	}
}

function getCachedUpdateDetailsV3(){
	$updateAvailable = getOption('V3UpdateAvailable');
	if(!empty($updateAvailable)){
		$updateAvailable = @unserialize($updateAvailable);
		if($updateAvailable == 'noUpdate'){
			return false;
		}
		return $updateAvailable;
	}
	return false;
}

function getOldInstalledHash(){
	return sha1(rtrim(APP_DOMAIN_PATH_V2,"/")."/".'|--|'.APP_ROOT_V2);
}

function getInstalledHashV3(){
	return sha1(rtrim(APP_DOMAIN_PATH,"/")."/".'|--|'.APP_ROOT);
}

function processAppUpdateV3New(){
	$updateAvailable = checkUpdateV3(false, false);
	if(empty($updateAvailable)){
		return false;	
	}
	
	$newVersion = $updateAvailable['newVersion'];
	
	$optionVer['action'] = 'updated';
	$optionVer['actionTime'] = time();
	$optionVer['prevVer'] = APP_VERSION;
	$optionVer['newVer'] = $newVersion;
	$optionVer['slug'] = 'IWPAdminPanel';
	
	if(version_compare(APP_VERSION, $newVersion) !== -1){
		return false;
	}
	
	$updateDetails = $updateAvailable['updateDetails'][$newVersion];
	
	if(!empty($updateDetails['downloadLink']) && !empty($updateDetails['fileMD5'])){
		
		$updateZip = getTempName('appUpdate.zip');
	
		appUpdateMsgV3('Downloading package..');
		
		$isDone = downloadURL($updateDetails['downloadLink'], $updateZip);		
		
		if(!$isDone){ //download failed
			appUpdateMsgV3('Download Failed.', true);
			appUpdateMsgV3("Install this constant in IWP config.php file and try again <br> define('PANEL_UPDATE_SSL_VERIFY', true);", true);
			return false;
		}
				
		if(md5_file($updateZip) != $updateDetails['fileMD5']){
			appUpdateMsgV3('File MD5 mismatch(damaged package).', true);
			return false;	
		}
		
		if(!initFileSystem()){
			appUpdateMsgV3('Unable to initiate file system.', true);
			return false;
		}
		
		$unPackResult = unPackToWorkingDir($updateZip);
		if(!empty($unPackResult) && is_array($unPackResult)){
			$source = $unPackResult['source'];
			$remoteSource = $unPackResult['remoteSource'];
		}
		else{
			return false;	
		}
		
		$destination = APP_ROOT;
		if(!copyToRequiredDir($source, $remoteSource, $destination)){
			return false;	
		}
		
		appUpdateMsgV3('Finalizing update..');	
		if(file_exists(APP_ROOT.'/updateFinalize_v'.$newVersion.'.php')){
			//$updateAvailable variable should be live inside the following file
			include(APP_ROOT.'/updateFinalize_v'.$newVersion.'.php');//run the update file
			
			if($GLOBALS['updateFinalizeStatus'] === true || $updateFinalizeStatus === true){
				
				@unlink($updateZip);
				updateOption('V3UpdateAvailable', '');
				updateOption('lastPanelUpdatedV3', time());
				appUpdateMsgV3('Updated successfully.', false);
				manipulateOption('versionLogs', $optionVer);
				return true;
			}
			else{
				appUpdateMsgV3('Update failed.', true);
			}
		}
		else{
			//updateFinalize file not found	
			appUpdateMsgV3('Update finalizing file missing.', true);
		}
		@unlink($updateZip);
		return false;	
	}
}

function appUpdateMsgV3($msg, $isError=0){
	echo '<br>'.$msg;
	if($isError === true){
		?>
        <br />Try again by refreshing the panel or contact <a href="mailto:help@infinitewp.com">help@infinitewp.com</a>
         <script>
		window.parent.$("#updates_centre_cont .btn_loadingDiv").remove();
		</script>
		<?php
	}
	elseif($isError === false){
		?>
        <script>
		window.parent.$("#updates_centre_cont .btn_loadingDiv").remove();
		window.parent.$(".updateActionBtn").attr({'btnaction':'reload','target':'_parent', 'href':'<?php echo APP_URL; ?>'}).text('Reload App').removeClass('disabled');
		window.parent.$("#updates_centre_cont_V3 .btn_loadingDiv").remove();
		window.parent.$(".updateActionBtnV3").attr({'btnaction':'reload','target':'_parent', 'href':'<?php echo trim(APP_URL, "/")."/v3"; ?>'}).text('Reload App').removeClass('disabled');
		</script>
		<?php
	}
	?>
	<script>
	window.scrollTo(0, document.body.scrollHeight);
	</script>
    <?php
	ob_flush();
	flush();
}

function checkUserLoggedInAndRedirectV3(){
	//check session, if not logged in redirect to login page
	if(!defined('USER_SESSION_NOT_REQUIRED') && !defined('IS_EXECUTE_FILE')){
		if(!checkUserLoggedInV3()){
			echo jsonEncoder(array('logout' => true));
			exit;
		}
	}
}

function checkUserLoggedInV3(){
	
	$return = false;
        $userCookie = manageCookies::cookieGet('userCookie');
        if($userCookie!='') {
            list($userEmail,$userSlat, $accessLevel) = explode('||', $userCookie);
            $userEmail = filterParameters($userEmail);
            if($userEmail!='' && $userSlat!='') {
            		$where = array(
			      		'query' =>  "email = ':email'" ,
			      		'params' => array(
			               ':email'=>trim($userEmail)
           				)
        			);
                    $userInfo = DB::getRow("?:users", "userID,email,password, accessLevel", $where );
                    
                    $GLOBALS['userID'] = $userInfo['userID'];
                    $GLOBALS['email'] = strtolower($userInfo['email']);
                    $stringtoSalt = $GLOBALS['email'].$userInfo['password'];
                    if(!empty($stringtoSalt)){
                        $dbSlat = md5($GLOBALS['email'].$userInfo['password']);
                        if($userSlat==$dbSlat && (empty($accessLevel) || $accessLevel === $userInfo['accessLevel'])) {
                            $return = true;
                        }
                    }
            }
        }
   

	if($return == false){
		userLogoutV3();
	}
	return $return;
}

function userLogoutV3($userRequest=false){
	$authCookieInfo = manageCookies::cookieGet('authCookieInfo');
	if (empty($authCookieInfo)) {
		manageCookies::cookieAllUnset();
	}
	if($userRequest){
		$successMsg = 'logout';
		if(!defined('IS_AJAX_FILE')){
			header('Location: login.php?successMsg='.$successMsg);
			exit;
		}
	}else{
		if(!defined('IS_AJAX_FILE')){
				header('Location: login.php');
				exit;
		}
	}
}

function getLogginUserPic(){
	$gravURL = "https://www.gravatar.com/avatar/" . md5( strtolower( trim( $GLOBALS['email'] ) ) );
	return $gravURL;
}

function loadActiveAddonsV3(){
	
	$suiteDetails = unserialize(getOption('suiteDetailsV3'));
	
	if(empty($suiteDetails) and !is_array($suiteDetails)) $addonSuiteMiniActivity='';
	else $addonSuiteMiniActivity=$suiteDetails['addonSuiteMiniActivity'];
	if(panelRequestManagerV3::checkIsAddonPlanLimitExceededV3('addonSuiteLimitExceededIllegally') && panelRequestManagerV3::getAddonSuitePlanActivityV3()=='installed') {
		Reg::set('addonSuiteLimitExceededIllegally', 1);
		Reg::set('addonSuiteLimitExceededAttempt', 1);
	} else {
		Reg::set('addonSuiteLimitExceededIllegally', 0);
		Reg::set('addonSuiteLimitExceededAttempt', 0);
	}
	
	$activeAddons = DB::getArray("?:addons_v3", "slug, status, addon", "1");
        
        if(userStatus() != 'admin'){
		userAddonsAccess($activeAddons);
	}
	$installedAddons = @unserialize(getOption('updateAddonsAvailableV3'));
	$installedFreeAddons = getOption('updateFreeAddonsAvailableV3');
	if (!empty($installedFreeAddons)) {
		$installedFreeAddons = @unserialize($installedFreeAddons);
	}
	$newAddons = getNewAddonsAvailableV3();
	$newFreeAddons = getNewFreeAddonsAvailableV3();
	$purchasedAddons = array();
        
	if(!empty($installedAddons)){ $purchasedAddons = array_merge($purchasedAddons, array_keys($installedAddons));  }
	if(!empty($installedFreeAddons)){ $purchasedAddons = array_merge($purchasedAddons, array_keys($installedFreeAddons)); } 
	if(!empty($newAddons)){ $purchasedAddons = array_merge($purchasedAddons, array_keys($newAddons));  }
	if(!empty($newFreeAddons)){ $purchasedAddons = array_merge($purchasedAddons, array_keys($newFreeAddons));  }
	Reg::set('purchasedAddons', $purchasedAddons);
	$uninstallAddons = $uninstall = $activeLoadedAddonsSlugs = $allPurchasedAddonsNameAndSlug = array();
	foreach($activeAddons as $key => $addon){
		if(!in_array($addon['slug'], $purchasedAddons)){
			$uninstall[] = $addon['slug'];
			$uninstallAddons[]['slug'] = $addon['slug'];
		}
		if($addon['status'] == 'active'){
			
			$allPurchasedAddonsNameAndSlug[$addon['slug']] = $addon['addon'];
			
			if(Reg::get('addonSuiteLimitExceededIllegally') && Reg::get('addonSuiteLimitExceededAttempt')) {
				$activeLoadedAddonsSlugs[$addon['slug']] = array('slug' => $addon['slug']);
			} else {
				//if(file_exists(APP_ROOT.'/addons/'.$addon['slug'].'/addon.'.$addon['slug'].'.php')){
				@include_once(getAppRoot().'/addons/'.$addon['slug'].'/addon.'.$addon['slug'].'.php');
					
				if(method_exists('addon'.ucfirst($addon['slug']),'init')){
					call_user_func(array('addon'.ucfirst($addon['slug']),'init'));
					$activeLoadedAddonsSlugs[$addon['slug']] = array('slug' => $addon['slug']);
				} else{//file not found deactivate the addon
					unset($activeAddons[$key]);
					//DB::delete("?:addons", "slug='".$addon['slug']."'");
					//addNotification($type='E', $title='Addon file missing', $message='The "'.$addon['addon'].'" addon has been removed, since a file is missing.', $state='U', $callbackOnClose='', $callbackReference='');
				}				
			}
		}
	}
	if(!empty($uninstallAddons) && $addonSuiteMiniActivity!='cancelled'){
		addNotification($type='E', $title='Addon error', $message='Addon(s) are not legitimate.', $state='U', $callbackOnClose='', $callbackReference='');
		uninstallAddonsV3($uninstallAddons);
	}
	regSetInstalledAddonsDetails($activeLoadedAddonsSlugs);
	Reg::set('allPurchasedAddonsNameAndSlug', $allPurchasedAddonsNameAndSlug);
	//Reg::set('activeAddons', $activeLoadedAddonsSlugs);
}

function getInstalledAddonsV3($withUpdates=false){
	$addons = DB::getArray("?:addons_v3", "*", "1", 'slug');
        
        if(empty($addons)){
		return array();
	}
	foreach($addons as $slug => $addon){
		$addons[$slug]['version'] = getAddonVersion($slug);	
		unset($addons[$slug]['validityExpires']);//dont trust the data saved in app db so unsetting
	}
	
	if($withUpdates){
		$updateAddonsAvailable = @unserialize(getOption('updateAddonsAvailableV3'));
			
		if(!empty($updateAddonsAvailable)){
			foreach($updateAddonsAvailable as $slug => $updateAddon){
				if(!empty($addons[$slug])){
					if(!empty($updateAddon['updateAvailable'])){			
						$addons[$slug]['updateAvailable'] = $updateAddon['updateAvailable'];				
					}
					//$addons[$slug]['isValidityExpired'] = $updateAddon['isValidityExpired'];//calculate isValidityExpired instead of getting from IWP Service(why? it can show less accurate data, because 24hrs once app check for update and get these data
					$addons[$slug]['validityExpires'] = $updateAddon['validityExpires'];
					$addons[$slug]['datePurchased'] = $updateAddon['datePurchased'];
					
					
					$addons[$slug]['isValidityExpired'] = false;
					if($addons[$slug]['validityExpires'] < time()){
						$addons[$slug]['isValidityExpired'] = true;
					}
					
					//isLifetime is used in addon/view.tpl.php
					$addons[$slug]['isLifetime'] = false;
					if( ($addons[$slug]['validityExpires']-$addons[$slug]['datePurchased']) > (86400 * 365 * 20)){
						$addons[$slug]['isLifetime'] = true;
					}
					$validTill = getValidTill($addons[$slug]);
					if($addons[$slug]['isLifetime'] == true){
						$addons[$slug]['validTillAddon'] = "Lifetime"; 
					} else if($validTill['class']!='gp_over') { 
						$addons[$slug]['validTillAddon'] = date("M d, Y",$addons[$slug]['validityExpires']); 
					} else { 
						// $addons[$slug]['validTillAddon'] = 'Expired';
						$addons[$slug]['validTillAddon'] = date("M d, Y",$addons[$slug]['validityExpires']); 
						
					} 
				}
			}
		}

		$updateAddonsAvailable = @unserialize(getOption('updateFreeAddonsAvailableV3'));

		if(!empty($updateAddonsAvailable)){
			foreach($updateAddonsAvailable as $slug => $updateAddon){
				if(!empty($addons[$slug])){
					if(!empty($updateAddon['updateAvailable'])){			
						$addons[$slug]['updateAvailable'] = $updateAddon['updateAvailable'];				
					}
		
				}
			}
		}
	}
	
	return $addons;
}

function updateAppRegisteredV3($user){//$user => username or email registered with IWP Site
	// if (!empty($user)) {
	// 	deleteOption('infinitewpAccountCredentials');
	// }
	updateOption('appRegisteredUserV3', $user);
}

function processCheckAddonsUpdateV3($addonsUpdate){
	//get updates
	updateOption('updateAddonsAvailableV3', serialize($addonsUpdate['updateAddonsV3']));
	updateOption('newAddonsAvailableV3', serialize($addonsUpdate['newAddonsV3']));
	updateOption('promoAddons', serialize($addonsUpdate['promoAddons']));
	updateOption('suiteDetailsV3', serialize($addonsUpdate['suiteDetailsV3']));
	
	// addRenewalAlertNotification($addonsUpdate);
}

function processCheckFreeAddonsUpdateV3($addonsUpdate){
	//get updates
	updateOption('updateFreeAddonsAvailableV3', serialize($addonsUpdate['updateAddons']));
	updateOption('newFreeAddonsAvailableV3', serialize($addonsUpdate['newAddons']));
}

function getNewAddonsAvailableV3(){
	$addon = @unserialize(getOption('newAddonsAvailableV3'));

	if (!empty($addon)) {
	 	return $addon;
	} 
	return false;
}

function getNewFreeAddonsAvailableV3(){
	$addon = @unserialize(getOption('newFreeAddonsAvailableV3'));

	if (!empty($addon)) {
	 	return $addon;
	} 
	return false;
}

function getNewAddonAvailableV3(){
	$addon = @unserialize(getOption('newAddonsAvailableV3'));

	if (!empty($addon)) {
	 	foreach ($addon as $key => $value) {
	 		if (empty($value['isInstalled']) && $key != 'clientReporting') {
	 			return $value;
	 		}
	 	}
	}
	if (!empty($addon['clientReporting']) && empty($addon['clientReporting']['isInstalled'])) {
	 	return $addon['clientReporting'];
	} 
	return false;
}

function getNewFreeAddonAvailableV3(){
	$addon = @unserialize(getOption('newFreeAddonsAvailableV3'));

	if (!empty($addon)) {
	 	foreach ($addon as $key => $value) {
	 		if (empty($value['isInstalled'])) {
	 			return $value;
	 		}
	 	}
	}
	return false;
}

function activateAddonsV3($addons){
	$success = array();
	foreach($addons as $key => &$addon){
		$where = array(
			      		'query' =>  "slug = ':slug'",
			      		'params' => array(
			               ':slug'=>$addon['slug']
           				)
        			);
		$isExist = DB::getField("?:addons_v3", "slug", $where);
		if(!$isExist){
			addNotification($type='E', $title='Addon activation failed', $message='The '.$addon['slug'].' addon does not exist in the database.', $state='U', $callbackOnClose='', $callbackReference='');
			$addons[$key]['activate'] = false;
			continue;
		}		
		
		if(file_exists(getAppRoot().'/addons/'.$addon['slug'].'/addon.'.$addon['slug'].'.php')){
			//activating the addon
			$isDone = DB::update("?:addons_v3", array( 'status' => 'active'), $where);
			if($isDone){
				$addons[$key]['activate'] = true;
				$success[$addon['slug']] = DB::getField("?:addons_v3", "addon", $where);
				include_once(getAppRoot().'/addons/'.$addon['slug'].'/addon.'.$addon['slug'].'.php');
				if(method_exists('addon'.ucfirst($addon['slug']),'activate')){
					call_user_func(array('addon'.ucfirst($addon['slug']),'activate'));
				}
			}
		}
		else{
			$addons[$key]['activate'] = false;
			addNotification($type='E', $title='Addon activation failed', $message='A file was found missing while activating the '.$addon['slug'].' addon.', $state='U', $callbackOnClose='', $callbackReference='');
		}
	}
	if(!empty($success)){
		addNotification($type='N', $title='Addon has been activated', $message=implode('<br>', $success), $state='U', $callbackOnClose='', $callbackReference='');
	}
	return $addons;
}

function deactivateAddonsV3($addons){
	foreach($addons as $key => $addon){
		$where = array(
			      		'query' =>  "slug = ':slug'",
			      		'params' => array(
			               ':slug'=>$addon['slug']
           				)
        			);
		$isExist = DB::getField("?:addons_v3", "slug", $where);
		if(!$isExist){
			$addons[$key]['deactivate'] = false;
			addNotification($type='E', $title='Addon deactivation failed', $message='The '.$addon['slug'].' addon does not exist in the database.', $state='U', $callbackOnClose='', $callbackReference='');
			continue;
		}		
		
		if(file_exists(getAppRoot().'/addons/'.$addon['slug'].'/addon.'.$addon['slug'].'.php')){
			//activating the addon
			$isDone = DB::update("?:addons_v3", array( 'status' => 'inactive'), $where);
			if($isDone){
				$addons[$key]['deactivate'] = true;
				$success[$addon['slug']] = DB::getField("?:addons_v3", "addon", $where);
				include_once(getAppRoot().'/addons/'.$addon['slug'].'/addon.'.$addon['slug'].'.php');
				if(method_exists('addon'.ucfirst($addon['slug']),'deactivate')){
					call_user_func(array('addon'.ucfirst($addon['slug']),'deactivate'));
				}
			}
		}
		else{
			$addons[$key]['deactivate'] = false;
			addNotification($type='E', $title='Addon deactivation failed', $message='A file was found missing while deactivating the '.$addon['slug'].' addon.', $state='U', $callbackOnClose='', $callbackReference='');
		}
	}
	if(!empty($success)){
		addNotification($type='N', $title='Addon has been deactivated', $message=implode('<br>', $success), $state='U', $callbackOnClose='', $callbackReference='');
	}
	return $addons;
}

function getUpdateAvailableAddonsV3($withUpdates){
	$addons = DB::getArray("?:addons_v3", "*", "1", 'slug');
        
        if(empty($addons)){
		return false;
	}
	foreach($addons as $slug => $addon){
		$addons[$slug]['version'] = getAddonVersion($slug);	
		unset($addons[$slug]['validityExpires']);//dont trust the data saved in app db so unsetting
	}
	
	if($withUpdates){
		$updateAddonsAvailable = @unserialize(getOption('updateAddonsAvailableV3'));
		$updateFreeAddonsAvailableV3 = @unserialize(getOption('updateFreeAddonsAvailableV3'));
		if (empty($updateAddonsAvailable)) {
			$updateAddonsAvailable = array();
		}
		if (empty($updateFreeAddonsAvailableV3)) {
			$updateFreeAddonsAvailableV3 = array();
		}
		$updateAddonsAvailable = array_merge($updateAddonsAvailable, $updateFreeAddonsAvailableV3);
		if(!empty($updateAddonsAvailable)){
			foreach($updateAddonsAvailable as $slug => $updateAddon){
				if(!empty($addons[$slug])){
					if(!empty($updateAddon['updateAvailable'])){			
						$addons[$slug]['updateAvailable'] = $updateAddon['updateAvailable'];				
					}else{
						unset($addons[$slug]);
					}
					
				}else{
					unset($addons[$slug]);
				}
			}
		}
	}
	if (empty($addons)) {
		return false;
	}
	return $addons;
}

function getUpdateAvailableAddonV3($withUpdates){
	$where = array(
			'query' =>  "isFree = ':isFree'",
			'params' => array(
			':isFree'=>0
			)
	);
	$addons = DB::getArray("?:addons_v3", "*", $where, 'slug');
        
        if(empty($addons)){
		return false;
	}
	foreach($addons as $slug => $addon){
		$addons[$slug]['version'] = getAddonVersion($slug);	
		unset($addons[$slug]['validityExpires']);//dont trust the data saved in app db so unsetting
	}
	
	if($withUpdates){
		$updateAddonsAvailable = @unserialize(getOption('updateAddonsAvailableV3'));
		if(!empty($updateAddonsAvailable)){
			foreach($updateAddonsAvailable as $slug => $updateAddon){
				if(!empty($addons[$slug])){
					if(!empty($updateAddon['updateAvailable'])){			
						$addons[$slug]['updateAvailable'] = $updateAddon['updateAvailable'];	
					}else{
						unset($addons[$slug]);
					}
					
				}else{
					unset($addons[$slug]);
				}
			}
		}
	}
	if (empty($addons)) {
		return false;
	}
	if (!empty($addons)) {
	 	foreach ($addons as $key => $value) {
	 		if (empty($value['updateAvailable']['isInstalled']) && $key != 'clientReporting') {
	 			return $value;
	 		}
	 	}
	}
	if (!empty($addons['clientReporting']) && empty($addons['clientReporting']['updateAvailable']['isInstalled'])) {
	 	return $addons['clientReporting'];
	}
	return false;
}

function getUpdateAvailableFreeAddonV3($withUpdates){
	$where = array(
			'query' =>  "isFree = ':isFree'",
			'params' => array(
			':isFree'=>1
			)
	);
	$addons = DB::getArray("?:addons_v3", "*", $where, 'slug');
		
		if(empty($addons)){
		return false;
	}
	foreach($addons as $slug => $addon){
		$addons[$slug]['version'] = getAddonVersion($slug);	
		unset($addons[$slug]['validityExpires']);//dont trust the data saved in app db so unsetting
	}
	if (empty($addons)) {
		return false;
	}
	if($withUpdates){
		$updateAddonsAvailable = @unserialize(getOption('updateFreeAddonsAvailableV3'));
		if(!empty($updateAddonsAvailable)){
			foreach($updateAddonsAvailable as $slug => $updateAddon){
				if(!empty($addons[$slug])){
					if(!empty($updateAddon['updateAvailable'])){			
						$addons[$slug]['updateAvailable'] = $updateAddon['updateAvailable'];	
					}else{
						unset($addons[$slug]);
					}
					
				}else{
					unset($addons[$slug]);
				}
			}
		}
	}
	if (empty($addons)) {
		return false;
	}
	if (!empty($addons)) {
		foreach ($addons as $key => $value) {
			if (empty($value['updateAvailable']['isInstalled'])) {
				return $value;
			}
		}
   }
	return $addons;
}


function uninstallAddonsV3($addons){
	foreach($addons as $addon){
		
		if(is_object($GLOBALS['FileSystemObj']) || uninstallAddonsInitFileSystemV3()){
			$GLOBALS['FileSystemObj']->delete(APP_ROOT.'/addons/'.$addon['slug'], true);
		}
		$where = array(
			      		'query' =>  "slug = ':slug'",
			      		'params' => array(
			               ':slug'=>$addon['slug']
           				)
        			);		
		$isDone = DB::delete("?:addons_v3", $where);
		addNotification($type='N', $title='Addon uninstalled', $message='The '.$addon['slug'].' addon has been uninstalled.', $state='U', $callbackOnClose='', $callbackReference='');	
	}
}

function uninstallAddonsInitFileSystemV3(){
	ob_start();
	$r = initFileSystem();
	ob_end_clean();
	return $r;
}

function updateAdditionalStats($siteID, $type, $stats){
	$where = array(
          'query' => "siteID = ':siteID' && type = ':type'",
          'params' => array(
               ':siteID'=>$siteID,
               ':type'  => $type
           )
        );
	
	if(isExistAdditionalStats($siteID, $type)){
		return DB::update("?:additional_stats", array('siteID' => $siteID, 'lastUpdatedTime' =>time(), 'stats' => $stats,'type' => $type), $where);
	}
	else{
		return addAdditionalStat($siteID, $type, $stats);
	}
}

function isExistAdditionalStats($siteID, $type){
	$where = array(
          'query' => "siteID = ':siteID' && type = ':type'",
          'params' => array(
               ':siteID'=>$siteID,
               ':type'  => $type
           )
        );
	return DB::getExists("?:additional_stats", "stats", $where);
}

function addAdditionalStat($siteID, $type, $stats){
	return DB::insert("?:additional_stats", array('siteID' => $siteID, 'lastUpdatedTime' =>time(), 'stats' => $stats,'type' => $type));
}

function deleteAdditionalStats($siteID,$type){
	$where = array(
          'query' => "siteID = ':siteID' && type = ':type'",
          'params' => array(
               ':siteID'=>$siteID,
               ':type'  => $type
           )
        );
	return DB::delete("?:additional_stats", $where);
}
function getAddAdditionalStat($type){
	$where2 = '';
	if (userStatus() != "admin") {
		$where = array(
	      		'query' =>  "userID = :userID",
	      		'params' => array(
	               ':userID'=>$GLOBALS['userID']
					)
			);
		$siteIDs = DB::getFields('?:user_access', 'siteID', $where);
		$where2 = "AND siteID IN ('". implode("','", DB::esc($siteIDs)) ."')";
	}
	$where = array(
          'query' => "type = ':type' ".$where2,
          'params' => array(
               ':type'=>$type
           )
        );
	return DB::getArray("?:additional_stats", "*", $where);
}
function checkV3PRPRequestCompatability($siteData, &$PRP, &$historyAdditionalData){
	if (version_compare($siteData['pluginVersion'], '1.9.3',  '<')) {
		$PRP['status'] = 'error';
		$PRP['error'] = 'plugin_update';
		$historyAdditionalData[0]['status'] = 'error';
		$historyAdditionalData[0]['error'] = 'plugin_update';
		$historyAdditionalData[0]['errorMsg'] = 'Please update your client plugin to latest version';
	}
}
function userAddonsAccessV3(&$activeAddons){
	
	$permissions = userAllowAccessTest();
	
	if(!empty($permissions) && is_array($permissions)){
		foreach($activeAddons as $activeAddonkey => $activeAddonsSlug){
			if(in_array($activeAddonsSlug, $permissions['restrict'])){
				unset($activeAddons[$activeAddonkey]);
			}
		}
	}
}
function userStatusV3($userID = false){
	if (!$userID) {
		$userID = $GLOBALS['userID'];
	}
	$where = array(
			      		'query' =>  "userID = ':userID'",
			      		'params' => array(
			               ':userID'=> $userID
           				)
        			);
	$status = DB::getRow("?:users", "userID, accessLevel,email,name", $where);
	return $status;
}

function getAddonsHTMLV3(){
	$addonsHTML = getOption('addonsHTMLV3');
	if (empty($addonsHTML)) {
		return '';
	}

	return $addonsHTML;
}
function getAddonsIllegalHTMLV3(){
	$addonsHTML = getOption('addonsIllegalHTMLV3');
	if (empty($addonsHTML)) {
		return '';
	}

	return $addonsHTML;
}
function getAddSiteHTMLV3(){
	$addonsHTML = getOption('addSiteHTMLV3');
	if (empty($addonsHTML)) {
		return '';
	}

	return $addonsHTML;
}
function getLastPanelUpdatedV3(){
	$time = getOption('lastPanelUpdatedV3');
	if (empty($time)) {
		return false;
	}
	$date = @date('j M Y h:i:s A', $time);
	return $date;
}
function getOldAddonVersionV3($slug){ //supported from 2.2.0 //this should be used after replacing old addon with new addon files and then to get old version
	$where = array(
			      		'query' =>  "slug = ':slug'",
			      		'params' => array(
			               ':slug'=>$slug
           				)
        			);
	return DB::getField("?:addons_v3", "updateCurrentVersion", $where);
}
function defineAppFullURLV3(){
	$appFullURLV3 = buildAppURL(APP_URL);
	define('APP_FULL_URL', $appFullURLV3);
	if(defined('APP_URL_V2')){
		$appFullURL_V2 = buildAppURL(APP_URL_V2);
		define('APP_FULL_URL_V2', $appFullURL_V2);
	}
}

function addURLHeaderV3($params){
	if(!defined('APP_ROOT_V2')){
		// v2
		return '__URL_PREFIX__'.$params['folderPath'].$params['fileName'];
	}else{
		// v3
		return '__URL_PREFIX__V3'.$params['folderPath'].$params['fileName'];
	}

}

function replaceURLHeaderV3($URL){ 
	$headerPos = strpos($URL, '__URL_PREFIX__V3');
	if($headerPos !== false){
		return str_replace('__URL_PREFIX__V3', APP_FULL_URL, $URL);
	}
	$headerPosV2 = strpos($URL, '__URL_PREFIX__');
	if($headerPosV2 !== false){
		return str_replace('__URL_PREFIX__', APP_FULL_URL_V2, $URL);
	}
	return $URL;
	
}

function findUpdatedVersionByIDV3($historyID, $type){
	if (!in_array($type, array('plugin', 'theme', 'core'), true)) {
		return false;
	}
	$where = array(
		'query' =>  "historyID = ':historyID'",
		'params' => array(
		 ':historyID'=>$historyID
		 )
 	 );
	$request = DB::getField("?:history_raw_details", "request", $where);
	$request = unserialize(base64_decode($request));
	if (!empty($request) && !empty($request['params'])) {

		if ($type == 'plugin' && (!empty($request['params']['upgrade_plugins'][0]))) {
			$item = $request['params']['upgrade_plugins'][0]; //Taking 0 because we dont perform bulk update
			return  array('new_version' =>$item['new_version'] ,'old_version'=> $item['old_version'] );
		}elseif ($type == 'theme' && (!empty($request['params']['upgrade_themes'][0]))) {
			$item = $request['params']['upgrade_themes'][0]; //Taking 0 because we dont perform bulk update
			return  array('new_version' =>$item['new_version'] ,'old_version'=> $item['old_version'] );
		}elseif ($type == 'core' && !empty($request['params']['wp_upgrade'])) {
			$item = $request['params']['wp_upgrade']; //Taking 0 because we dont perform bulk update
			return  array('new_version' =>$item['current'] ,'old_version'=> $item['current_version'] );
		}
		
	}
	
}

function isAddonInstalledV3($slug){
	$where = array(
		      		'query' =>  "slug = ':slug'",
		      		'params' => array(
		               ':slug'=>$slug
       				)
    			);
	$status = DB::getField("?:addons_v3", "status", $where);

	if (!empty($status)) {
		return true;
	}

	return false;
}