<?php
/**
 * Created by PhpStorm.
 * User: Thilina
 * Date: 8/20/17
 * Time: 9:40 AM
 */

namespace Classes\Email;

use Utils\LogManager;

class PHPMailer extends EmailSender
{

    public function __construct($settings)
    {
        parent::__construct($settings);
    }

    protected function sendMail(
        $subject,
        $body,
        $toEmail,
        $fromEmail,
        $replyToEmail = null,
        $ccList = array(),
        $bccList = array(),
        $fromName = null
    ) {

        try {
            if ($fromName) {
                $fromEmail = $fromName." <".$fromEmail.">";
            }

            if (empty($replyToEmail)) {
                $replyToEmail = $fromEmail;
            }

            LogManager::getInstance()->info("Sending email to: " . $toEmail . "/ from: " . $fromEmail);

            $headers = 'MIME-Version: 1.0' . "\r\n";
            $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
            $headers .= 'From: ' . $fromEmail . "\r\n";
            if (!empty($ccList)) {
                $headers .= 'CC: ' . implode(",", $ccList) . "\r\n";
            }
            if (!empty($bccList)) {
                $headers .= 'BCC: ' . implode(",", $bccList) . "\r\n";
            }
            $headers .= 'ReplyTo: ' . $replyToEmail . "\r\n";
            $headers .= 'Ice-Mailer: PHP/' . phpversion();

            return mail($toEmail, $subject, $body, $headers);
        } catch (\Exception $e) {
            LogManager::getInstance()->error("Error sending email:" . $e->getMessage());
            LogManager::getInstance()->notifyException($e);
            return false;
        }
    }
}
