<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Français (French)
* Version: 3.6.x
*
* ==> CONTRIBUTORS
*
* Yul
* Wed
* Aum
* Philippe
* Thomas Cassen
* Yan-David Alaury
* Jean-Michel Schibler
* Jason Gass Martinez
* William Néron
* Didier Fourny
* Florian Marrel
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Français';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='French';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_general_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Répondre au-dessus de cette ligne ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Nouvelle Demande : %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Demande Reçue : %%SUBJECT%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Demande Assignée : %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Nouvelle Réponse : %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Nouvelle Réponse : %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Demande Déplacée : %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Nouvelle note ajoutée : %%SUBJECT%%';
$hesklang['new_pm']='Nouveau Message Privé : %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Liste de vos Demandes en Attente';

// ERROR MESSAGES
$hesklang['cant_connect_db']='Impossible de se connecter aux bases de données !';
$hesklang['invalid_action']='Action invalide';
$hesklang['select_username']='Sélectionner votre Nom d\'Utilisateur';
$hesklang['enter_pass']='Entrer votre Mot de Passe';
$hesklang['cant_sql']='Impossible d\'exécuter SQL';
$hesklang['contact_webmsater']='Envoyer un Message à L\'Administrateur';
$hesklang['mysql_said']='MySQL a dit';
$hesklang['wrong_pass']='Mot de Passe Incorrect.';
$hesklang['session_expired']='Votre session a expiré, Merci de vous reconnecter en utilisant le Formulaire ci-dessous.';
$hesklang['attempt']='Tentative Invalide !';
$hesklang['not_authorized_tickets']='Vous n\'êtes pas autorisé à voir les tickets dans cette catégorie !';
$hesklang['must_be_admin']='Vous n\'êtes pas autorisé à afficher cette page ! Pour afficher cette page, vous devez être connecté en tant qu´administrateur !';
$hesklang['no_session']='Impossible de démarrer une nouvelle session';
$hesklang['error']='Erreur';
$hesklang['int_error']='Erreur de Logiciel';
$hesklang['no_trackID']='Aucune ID de suivi';
$hesklang['status_not_valid']='Statut Invalide';
$hesklang['trackID_not_found']='Votre Numéro de Ticket est introuvable !';
$hesklang['enter_message']='Saisir votre Message';
$hesklang['select_priority']='Sélectionner la Priorité';
$hesklang['ticket_not_found']='Désolé, votre demande est introuvable ! Assurez-vous que vous avez saisi correctement le <strong>Numéro de Référence</strong> de votre Demande';
$hesklang['no_selected']='Aucune demande choisie, rien à changer';
$hesklang['id_not_valid']='Identité Invalide';
$hesklang['enter_id']='Entrer Le Numéro de Suivi de votre Demande';
$hesklang['enter_name']='Saisir le Nom du Client';
$hesklang['enter_date']='Saisir la date dans laquelle porte votre recherche';
$hesklang['date_not_valid']='Date non valide. Saisir une date au format <b>DD-MM-YYYY</b>.';
$hesklang['enter_subject']='Saisir un Sujet pour la Demande';
$hesklang['invalid_search']='Action de recherche invalide';
$hesklang['choose_cat_ren']='Choisir une Catégorie à renommer';
$hesklang['cat_ren_name']='Saisir le Nouveau Nom de la Catégorie';
$hesklang['cat_not_found']='Catégorie introuvable';
$hesklang['enter_cat_name']='Entrer le nom de la Catégorie';
$hesklang['no_cat_id']='Sans ID de la Catégorie';
$hesklang['cant_del_default_cat']='Vous ne pouvez pas supprimer la Catégorie par défaut, vous pouvez seulement la renommer';
$hesklang['no_valid_id']='Utilisateur ID non valide';
$hesklang['user_not_found']='Utilisateur Introuvable;';
$hesklang['enter_real_name']='Merci de saisir le nom d\'Utilisateur réel';
$hesklang['enter_valid_email']='Merci de nous communiquer une adresse E-mail valide';
$hesklang['enter_username']='Saisir le nom d\'Utilisateur (login)';
$hesklang['asign_one_cat']='Merci d\'assigner au moins une catégorie à l\'utilisateur !';
$hesklang['signature_long']='Signature trop longue ! Veuillez limiter la signature à 1000 caractères';
$hesklang['confirm_user_pass']='Confirmer le Mot de Passe';
$hesklang['passwords_not_same']='Les deux Mots de Passe saisis ne sont pas identiques !';
$hesklang['cant_del_admin']='Vous ne pouvez pas supprimer l\'Administrateur par défaut !';
$hesklang['cant_del_own']='Vous ne pouvez pas supprimer le profil avec lequel vous êtes connecté';
$hesklang['enter_your_name']='Saisir votre Nom';
$hesklang['sel_app_cat']='Merci de sélectionner la catégorie appropriée';
$hesklang['sel_app_priority']='Merci de sélectionner la priorité appropriée';
$hesklang['enter_ticket_subject']='Saisir un sujet pour votre demande';
$hesklang['user_not_found_nothing_edit']='Utilisateur non trouvé ou rien à changer';

// ADMIN PANEL
$hesklang['administrator']='Administrateur';
$hesklang['login']='Login';
$hesklang['user']='Utilisateur';
$hesklang['username']='Nom d\'Utilisateur';
$hesklang['pass']='Mot de Passe';
$hesklang['confirm_pass']='Confirmer le Mot de Passe';
$hesklang['logged_out']='Déconnecté';
$hesklang['logout']='Déconnection';
$hesklang['logout_success']='Vous avez été Déconnecté avec succès !';
$hesklang['click_login']='Cliquer ici pour vous Connecter';
$hesklang['back']='Retour';
$hesklang['displaying_pages']='Affichage <b>%d</b> Tickets. Pages :';
$hesklang['trackID']='Numéro de la Demande';
$hesklang['timestamp']='Horodatage';
$hesklang['name']='Votre Nom';
$hesklang['subject']='Objet de votre Demande';
$hesklang['status']='Statut';
$hesklang['priority']='Choisir la Priorité ';
$hesklang['open']='Nouveau';
$hesklang['open_action']='Réouvrir la Demande'; // Open ACTION
$hesklang['close']='Fermer'; // Closed ticket STATUS
$hesklang['any_status']='Aucun Statut';
$hesklang['high']='Élevée';
$hesklang['medium']='Moyenne';
$hesklang['low']='Basse';
$hesklang['del_selected']='Supprimer certaines Demandes';
$hesklang['manage_cat']='Gérer les Catégories';
$hesklang['profile']='Votre Profil';
$hesklang['show_tickets']='Afficher les Tickets d\'Assistance';
$hesklang['sort_by']='Trier par';
$hesklang['date_posted']='Date de Publication';
$hesklang['category']='Catégorie';
$hesklang['any_cat']='Aucune Catégorie';
$hesklang['order']='Ordre';
$hesklang['ascending']='Ascendante';
$hesklang['descending']='Descendante';
$hesklang['display']='Affichage';
$hesklang['tickets_page']='Demandes par Page';
$hesklang['find_ticket']='Trouver une Demande de Support';
$hesklang['yyyy_mm_dd']='DD-MM-YYYY';
$hesklang['results_page']='Résultats par Page';
$hesklang['opened']='Ouvert'; // The ticket has been OPENED
$hesklang['closed']='Résolu'; // Ticket has been RESOLVED
$hesklang['ticket']='Demande';
$hesklang['tickets']='Demandes d\'Assistance ';
$hesklang['ticket_been']='Cette demande a été';
$hesklang['view_ticket']='Voir votre Demande';
$hesklang['open_tickets']='Ouvrir les Tickets';
$hesklang['remove_statement']='Enlever &quot;Réalisé par&quot;';
$hesklang['click_info']='Cliquer Ici pour plus d\'Informations';
$hesklang['reply_added']='Réponse ajoutée';
$hesklang['reply_submitted']='Réponse envoyée';
$hesklang['ticket_marked']='Cette demande a été marquée';
$hesklang['ticket_status']='Statut de la demande';
$hesklang['replies']='Réponses';
$hesklang['date']='Date';
$hesklang['email']='Votre Adresse E-mail ';
$hesklang['ip']='IP';
$hesklang['message']='Message ';
$hesklang['add_reply']='Ajouter une réponse';
$hesklang['close_this_ticket']='Marquer ce ticket comme résolu';
$hesklang['change_priority']='Changer la priorité';
$hesklang['attach_sign']='Joindre Signature';
$hesklang['profile_settings']='Paramètres du profil';
$hesklang['submit_reply']='Soumettre votre Réponse';
$hesklang['support_panel']='Panneau de Support';
$hesklang['ticket_trackID']='Numéro de Référence de votre Demande ';
$hesklang['c2c']='Cliquer pour Continuer';
$hesklang['tickets_deleted']='Tickets supprimés';
$hesklang['num_tickets_deleted']='Nombre de Tickets supprim&eacute;s : <b>%d</b>';
$hesklang['confirm_del_cat']='Etes-vous sûr de vouloir supprimer cette catégorie ?';
$hesklang['cat_intro']='Ici, vous êtes capable de gérer les catégories. Les catégories sont utiles
pour classer les tickets par pertinence (par exemple &quot;Ventes&quot;,
&quot;Hardware problèmes&quot;, &quot;PHP/MySQL problèmes&quot, etc) et pour assigner des utilisateurs à des catégories (par exemple l\'utilisateur ne pourra voir que les tickets de cette catégorie )';
$hesklang['cat_name']='Nom de la catégorie';
$hesklang['remove']='Supprimer';
$hesklang['add_cat']='Ajouter une nouvelle Catégorie';
$hesklang['max_chars']='max 40 caractères';
$hesklang['create_cat']='Créer une Catégorie';
$hesklang['ren_cat']='Renommer la Catégorie';
$hesklang['to']='à';
$hesklang['cat_added']='Catégorie ajoutée';
$hesklang['cat_name_added']='La catégorie %s a été ajoutée avec succès';
$hesklang['cat_renamed']='Catégorie renommée';
$hesklang['cat_renamed_to']='La catégorie sélectionnée a été renommée avec succès';
$hesklang['cat_removed']='Catégorie supprimée';
$hesklang['cat_removed_db']='La catégorie sélectionnée a été supprimée de la base de données';
$hesklang['sure_remove_user']='Etes-vous sûr de vouloir supprimer cet utilisateur ?';
$hesklang['manage_users']='Gestion des Techniciens';
$hesklang['users_intro']='Cette section vous permet de répondre à des tickets ainsi que de gérer les Techniciens autorisés à se connecter au panneau d\'Administration';
$hesklang['yes']='OUI';
$hesklang['no']='NON';
$hesklang['edit']='&Eacute;diter';
$hesklang['add_user']='Ajouter un Nouveau Technicien';
$hesklang['req_marked_with']='Les champs obligatoires sont signalés par';
$hesklang['real_name']='Nom';
$hesklang['signature_max']='Signature (max 1000 caractères)';
$hesklang['sign_extra']='Le code HTML n\'est pas autorisé; les liens seront cliquables.';
$hesklang['create_user']='Créer un Technicien';
$hesklang['editing_user']='Modifier un Technicien';
$hesklang['user_added']='Technicien ajouté';
$hesklang['user_added_success']='Le Nouveau Technicien %s avec le Mot de Passe %s a été ajouté';
$hesklang['profile_updated']='Profil mis à jour';
$hesklang['profile_updated_success']='Votre profil a été mis à jour';
$hesklang['user_removed']='Technicien supprimé';
$hesklang['sel_user_removed']='Le Technicien sélectionné a été supprimé de la base de données';
$hesklang['profile_for']='Profil de';
$hesklang['new_pass']='Nouveau mot de passe';
$hesklang['update_profile']='Mettre à jour le profil';
$hesklang['notify_new_posts']='Avertissez-moi des nouveaux tickets et des messages dans ma catégorie';
$hesklang['view_profile']='Voir profil';
$hesklang['new_ticket_submitted']='Nouvelle Demande soumise';
$hesklang['user_profile_updated_success']='Ce profil de Technicien a été mis à jour avec succès';
$hesklang['printer_friendly']='Version imprimable';
$hesklang['end_ticket']='--- Fin de demande ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='Votre Demande a été';
$hesklang['view_your_ticket']='Voir votre Demande';
$hesklang['submit_ticket']='Soumettre une Demande d\'Assistance';
$hesklang['sub_ticket']='Soumettre votre Demande au Centre d\'Assistance';
$hesklang['before_submit']='Avant d\'adresser votre Demande au Centre d\'Assistance, Merci de vérifier les points suivants :';
$hesklang['all_info_in']='Toutes les <strong>Informations Nécessaires</strong> ont été remplies';
$hesklang['all_error_free']='Toutes vos <strong>Informations sont correctes et sans erreurs</strong>';
$hesklang['we_have']='Nous respectons les Obligations du Réglement Général de la Protection des Données et nous Enregistrons ';
$hesklang['recorded_ip']='Votre Adresse IP';
$hesklang['recorded_time']='La Date et l\'Heure de votre Message';
$hesklang['save_changes']='Enregistrer les modifications';
$hesklang['reply_submitted_success']='Votre réponse à cette demande a été soumise avec succès';
$hesklang['ticket_submitted']='Demande Soumise';
$hesklang['ticket_submitted_success']='Votre demande a été soumise avec succès ! Référence de votre Demande';
$hesklang['your_ticket']='Votre demande';

// Added in version 0.94
$hesklang['check_updates']='Assurez-vous d\'avoir installé la dernière Version de Hesk';
$hesklang['check4updates']='Vérifier les Mises à Jour';
$hesklang['wait_reply']='Attente Réponse';
$hesklang['replied']='Répondu';
$hesklang['last_replier']='Dernière Réponse';
$hesklang['staff']='Equipe Support';
$hesklang['customer']='Client';
$hesklang['close_selected']='Marquer comme Résolues';
$hesklang['execute']='Exécuter';
$hesklang['saved_replies']='Réponses prêtes';
$hesklang['manage_saved']='Gérer les Réponses Prêtes';
$hesklang['manage_intro']='Ici vous pouvez ajouter, gérer une réponse prête. Ces réponses sont utilisées pour une même réponse pour chaque client. Utilisez la réponse prête pour éviter d\'avoir à ressaisir toujours les mêmes réponses.';
$hesklang['saved_title']='Titre (max 50 caractères)';
$hesklang['no_saved']='Aucune réponse prête';
$hesklang['delete_saved']='Etes-vous sûr de vouloir supprimer cette réponse prête ?';
$hesklang['new_saved']='Ajouter ou éditer une réponse prête';
$hesklang['canned_add']='Créer une nouvelle réponse prête';
$hesklang['canned_edit']='Éditer les réponses prêtes sélectionnées';
$hesklang['save_reply']='Enregister la réponse';
$hesklang['saved']='Réponse enregistrée';
$hesklang['your_saved']='Votre réponse prête a bien été enregistrée pour une utilisation future';
$hesklang['ent_saved_title']='Saisir un titre de réponse';
$hesklang['ent_saved_msg']='Saisir un message de réponse';
$hesklang['saved_removed']='Réponse prête supprimée';
$hesklang['saved_rem_full']='La réponse prête sélectionnée a bien été supprimée';
$hesklang['clip_alt']='Ce message a des Pièces Jointes';
$hesklang['attachments']='Pièces Jointes';
$hesklang['fill_all']='Champ obligatoire manquant ';
$hesklang['file_too_large']='Votre Fichier %s est trop Grand';
$hesklang['cannot_move_tmp']='Impossible de déplacer le fichier dans le répertoire &quot;Pièces Jointes&quot;';
$hesklang['created_on']='Créé le';
$hesklang['tickets_closed']='Tickets Fermés';
$hesklang['num_tickets_closed']='<b>%d</b> Tickets ont été fermés';
$hesklang['select_saved']='Sélectionner une Réponse Type';
$hesklang['select_empty']='Sélection / Vide';
$hesklang['insert_special']='Insérer une balise spéciale (sera remplacée avec les informations du client)';
$hesklang['move_to_catgory']='Déplacer la demande vers';
$hesklang['move']='Déplacer';
$hesklang['moved']='Demande déplacée';
$hesklang['moved_to']='Cette demande a été déplacée dans la nouvelle catégorie';
$hesklang['url']='URL';
$hesklang['all_not_closed']='Tous mais fermé';
$hesklang['chg_all']='Tout changer';
$hesklang['settings']='Parametres';
$hesklang['settings_intro']='Utiliser cet outil pour configurer votre bureau. Pour plus d\'informations sur tous les paramètres et les options cliquer sur l\'aide ou consulter le fichier readme';
$hesklang['all_req']='Tous les champs (excepté ceux désactivés) sont obligatoires !';
$hesklang['wbst_title']='Titre du Site';
$hesklang['wbst_url']='URL du Site';
$hesklang['email_wm']='E-mail Administrateur';
$hesklang['max_listings']='Listes par Page';
$hesklang['print_size']='Taille du texte pour imprimer';
$hesklang['debug_mode']='Mode de débogage';
$hesklang['on']='ON';
$hesklang['off']='OFF';
$hesklang['use_secimg']='Utiliser l\'image anti-SPAM';
$hesklang['secimg_no']='Non disponible';
$hesklang['attach_use']='Utiliser Pièces Jointes';
$hesklang['attach_num']='Nombre par Post';
$hesklang['attach_type']='Types de Fichiers Acceptés';
$hesklang['place_after']='Après le message';
$hesklang['place_before']='Avant le Message';
$hesklang['custom_f']='Champ personnalisé';
$hesklang['custom_u']='Utiliser ce champ';
$hesklang['custom_n']='Nom du champ';
$hesklang['custom_l']='Longueur maxi (caractères)';
$hesklang['db_host']='Hôte de la base de données(Database host)';
$hesklang['db_name']='Nom de la base de données (Database name)';
$hesklang['db_user']='Nom d\'utilisateur de base de données (Database username)';
$hesklang['db_pass']='Mot de passe de base de données (Database password)';
$hesklang['err_sname']='Saisir le titre le votre site';
$hesklang['err_surl']='Saisir l\'URL de votre site, une URL valide (avec http:// ou https://)';
$hesklang['err_wmmail']='Saisir une adresse webmaster E-mail valide';
$hesklang['err_nomail']='Saisir une adresse noreply E-mail valide';
$hesklang['err_htitle']='Saisir un titre pour votre support HESK';
$hesklang['err_hurl']='Saisir l\'URL de votre dossier HESK, une URL valide (avec http:// ou https://)';
$hesklang['err_lang']='Sélectionner la langue de HESK';
$hesklang['err_nolang']='Le langage spécifié n\'existe pas dans le dossier langage ! Assurez-vous que le fichier langage est bien présent sur le serveur avant de modifier les param&eagrave;tres';
$hesklang['err_max']='Sélectionner un nombre maximal de liste affichable par page';
$hesklang['err_psize']='Saisissez la taille de la police d\'impression';
$hesklang['err_dbhost']='Saisir la valeur MySQL de l\'hôte de la base de données';
$hesklang['err_dbname']='Saisir la valeur MySQL du nom de la base de données';
$hesklang['err_dbuser']='Saisir la valeur MySQL du nom d\'utilisateur de la base de données';
$hesklang['err_dbpass']='Saisir la valeur MySQL du mot de passe de la base de données';
$hesklang['err_dbconn']='Impossible de se connecter à la base de données MySQL en utilisant les informations fournies !';
$hesklang['err_dbsele']='Impossible de sélectionner MySQL database, vérifier le nom de votre database';
$hesklang['err_custname']='Saisir un nom pour une sélection de champs optionnels';
$hesklang['err_openset']='Impossible d\'ouvrir le fichier <b>hesk_settings.inc.php</b> pour écriture. Mettre le CHMOD du fichier sur 666 (rw-rw-rw-)';
$hesklang['set_saved']='Paramètres sauvegardés';
$hesklang['set_were_saved']='Vos paramètres ont bien été sauvegardés';
$hesklang['sec_img']='Image de sécurité';
$hesklang['sec_miss']='Saisir le nombre Anti-Spam';
$hesklang['sec_wrng']='Mauvaise saisie du nombre de vérification';
$hesklang['submit_problems']='Cliquer sur Retour et corriger les problèmes suivants';
$hesklang['cat_order']='Ordre de catégorie';
$hesklang['reply_order']='Ordre des réponses prêtes';
$hesklang['move_up']='Déplacer vers le haut';
$hesklang['move_dn']='Déplacer au-dessous';
$hesklang['cat_move_id']='Il manque l\'identifiant de la catégorie';
$hesklang['reply_move_id']='Il manque l\'identifiant du réservoir de réponses prêtes';
$hesklang['forgot_tid']='Numéro de Référence de Demande Oublié ?';
$hesklang['tid_send']='Valider votre Envoi';
$hesklang['tid_not_found']='Désolé, aucune demande avec cette adresse E-mail n\'a été trouvée';
$hesklang['tid_sent']='Référence de demande envoyée';
$hesklang['tid_sent2']='Un E-mail avec les détails de votre demande a été envoyé';
$hesklang['check_spambox']='Si aucun message n\'est reçu, vérifier que le message n\'est pas dans la boîte SPAM ou dans les courriers indésirables.';
$hesklang['reply_not_found']='Réponse prête non trouvée';
$hesklang['exists']='Existe';
$hesklang['no_exists']='n\'existe pas';
$hesklang['writable']='Ecriture Serveur OK';
$hesklang['not_writable']='Ecriture Serveur Impossible';
$hesklang['disabled']='Désactivé';
$hesklang['e_settings']='Vous ne serez pas en mesure d\'enregistrer vos paramètres, sauf si ce fichier est accessible en écriture par le Logiciel. Référez-vous au fichier Readme ou Lisez-Moi pour plus d\'instructions !';
$hesklang['e_attdir']='Vous ne serez pas en mesure de déposer des pièces jointes sauf si c´est accessible en écriture par le Logiciel. Référez-vous au fichier Readme ou Lisez-Moi pour plus d\'instructions !';
$hesklang['e_save_settings']='Impossible d\'enregistrer vos paramètres parce que le fichier <b>hesk_settings.inc.php</b> n\'est pas accessible en écriture.';
$hesklang['e_attach']='Désactivé car votre dossier <b>pièces jointes</b> n\'est pas accessible en écriture.';
$hesklang['go']='Aller';

// Added in version 2.0
$hesklang['v']='Version du Logiciel';
$hesklang['check_status']='Vérification du Statut du Logiciel';
$hesklang['sub_support']='Soumettre une Demande d\'Assistance';
$hesklang['open_ticket']='<strong>Inscrivez-vous et Demandez une Assistance en Ligne</strong>';
$hesklang['view_existing']='Voir une Demande d\'Assistance';
$hesklang['vet']='Connectez-vous et Suivez vos Demandes d\'Assistance';
$hesklang['enter_user']='Saisir votre nom d\'Utilisateur';
$hesklang['remember_user']='Se souvenir de mon nom d\'Utilisateur';
$hesklang['wrong_user']='Nom d\'Utilisateur erroné !';
$hesklang['no_permission']='Vous n\'avez pas l\'autorisation d\'effectuer cette tâche, connectez-vous avec un compte qui possède ces droits.';
$hesklang['tickets_on_pages']='Nombre de Tickets d\'Assistance : %d | Nombre de Pages : %d'; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']='| Aller à la page :';
$hesklang['no_tickets_open']='Aucune demande non résolue trouvée';
$hesklang['no_tickets_crit']='Aucune demande correspondant à vos critères n\'a été trouvée';
$hesklang['confirm_execute']='Etes-vous sur de vouloir continuer ?';
$hesklang['legend']='Légende';
$hesklang['main_page']='Accueil';
$hesklang['menu_users']='Techniciens';
$hesklang['menu_cat']='Catégories';
$hesklang['menu_profile']='Profil';
$hesklang['menu_kb']='Base de Connaissance'; // Admin MENU item
$hesklang['kb_text']='Base de Connaissance'; // Item visible to customers
$hesklang['viewkb']='Voir la Totalité de la Base de Connaissance';
$hesklang['kb']='Gérer la Base de Connaissance';
$hesklang['kb_intro']='La Base de Connaissance est une collection de réponses aux questions fréquemment posées (FAQ) et des articles qui prévoient l\'assistance à vos clients.
Complète et bien écrite la base de connaissances peut réduire considérablement le nombre de tickets que vous recevez et économiser beaucoup de temps. Vous pouvez classer les articles par catégories
et sous-catégories.'; // Description in ADMIN panel
$hesklang['kb_is']='La base de connaissance est une collecte de réponses à des questions fréquemment posées (FAQ) et des articles. Vous pouvez lire des articles dans cette catégorie ou sélectionner une sous-catégorie qui vous intéresse.'; // Description for CUSTOMERS
$hesklang['new_kb_art']='Nouvel article de la base de connaissance';
$hesklang['kb_cat']='Catégorie';
$hesklang['kb_subject']='Sujet';
$hesklang['kb_content']='Contenu';
$hesklang['kb_type']='Type';
$hesklang['kb_published']='Publié';
$hesklang['kb_published2']='Cet article est visible par tout le monde dans la base de connaissance.';
$hesklang['kb_private']='Privé';
$hesklang['kb_private2']='Les articles privés ne peuvent être lus que par l\'Equipe Support.';
$hesklang['kb_draft']='Brouillon';
$hesklang['kb_draft2']='Cet article est sauvegardé mais pas encore publié. Il ne peut être lu que par les personnes du support<br />ayant les permissions pour gérer les articles de la base de connaissance.';
$hesklang['kb_links']='<i><span class="notice"><b>Attention !</b></span><br />Entrer un code valide, sans &lt;head&gt; ni &lt;body&gt;, juste le contenu !</i>';
$hesklang['kb_ehtml']='C´est du code HTML (j´entre du code valide (X)HTML code)';
$hesklang['kb_dhtml']='Ceci est du texte <i>normal</i> (les liens seront cliquables)';
$hesklang['kb_save']='Sauvegarder l\'article';
$hesklang['kb_e_subj']='Saisir le sujet de l\'article !';
$hesklang['kb_e_cont']='Ecrire un contenu pour cet article !';
$hesklang['kb_art_added']='Article ajouté';
$hesklang['your_kb_added']='Un nouvel article de la Base de Connaissance a bien été ajouté';
$hesklang['kb_art_deleted']='Article effacé';
$hesklang['your_kb_deleted']='l\'article de la Base de Connaissance sélectionné a bien été supprimé';
$hesklang['kb_art_mod']='Article modifié';
$hesklang['your_kb_mod']='Les modifications de l\'article sélectionné ont bien été sauvegardées';
$hesklang['kb_cat_new']='Nouvelle (sous)catégorie de la Base de Connaissance';
$hesklang['kb_cat_parent']='Catégorie Parente';
$hesklang['kb_cat_sub']='Sous-Catégories';
$hesklang['kb_cat_title']='Titre de Catégorie';
$hesklang['kb_cat_published']='La Catégorie est visible par tout le monde dans la Base de Connaissance.';
$hesklang['kb_cat_private']='La Catégorie ne peut être lue que par l\'Équipe Support.';
$hesklang['kb_cat_add']='Ajouter une Catégorie';
$hesklang['kb_cat_e_title']='Saisir un titre de Catégorie !';
$hesklang['kb_cat_added']='Catégorie ajoutée';
$hesklang['kb_cat_added2']='Une nouvelle Catégorie a bien été ajoutée dans la Base de Connaissance';
$hesklang['kb_cat_man']='Gérer les Catégories de la Base de Connaissance';
$hesklang['kb_cat_edit']='Editer les détails de la Catégorie';
$hesklang['kb_cat_inv']='Catégorie non valide';
$hesklang['kb_cat_art']='Articles dans cette Catégorie';
$hesklang['kb_p_art']='+ Article';
$hesklang['kb_p_art2']='Ajouter un nouvel article dans la catégorie sélectionnée.';
$hesklang['kb_add_art']='Ajouter un article';
$hesklang['kb_p_cat']='+ Catégorie';
$hesklang['kb_p_cat2']='Créer une nouvelle Sous-Catégorie dans la catégorie sélectionnée.';
$hesklang['kb_add_cat']='Ajouter une Catégorie';
$hesklang['kb_p_man']='Gérer';
$hesklang['kb_p_man2']='Gérer la Catégorie sélectionnée (éditer, supprimer, gestion d\'articles).';
$hesklang['kb_main']='La catégorie principale de la base de connaissance ne peut être déplacée ou supprimée.';
$hesklang['kb_no_art']='Il n\'y a aucun Article dans cette Catégorie.';
$hesklang['author']='Auteur';
$hesklang['views']='Affichage';
$hesklang['delete']='Supprimer';
$hesklang['rating']='Evaluer';
$hesklang['votes']='Voter';
$hesklang['kb_rated']='Article évalué %s/5.0';
$hesklang['kb_not_rated']='Article pas encore évalué';
$hesklang['del_art']='Etes-vous sur de vouloir supprimer l&rsquo;article sélectionné ?';
$hesklang['kb_art_id']='L\'identifiant est invalide ou manquant !';
$hesklang['kb_art_edit']='Editer l\'article';
$hesklang['revhist']='Historique des révisions';
$hesklang['revision1']='<li class="smaller">%s | soumis par %s</li>'; // %s = date, user making change
$hesklang['revision2']='<li class="smaller">%s | modifié par %s</li>'; // %s = date, user making change
$hesklang['kb_order']='Tri';
$hesklang['kb_delcat']='Etes-vous sûr de vouloir supprimer cette catégorie ?';
$hesklang['kb_cat_mod']='Catégorie modifiée';
$hesklang['your_cat_mod']='Les modifications sur la catégorie sélectionnée ont bien été sauvegardées';
$hesklang['kb_cat_del']='La catégorie de la base de connaissance a été supprimée';
$hesklang['kb_cat_dlt']='La catégorie sélectionnée de la base de connaissance a été supprimée.';
$hesklang['allowed_cat']='Catégories';
$hesklang['allow_feat']='Fonctions';
$hesklang['can_view_tickets']='Afficher les Tickets';
$hesklang['can_reply_tickets']='Répondre aux Tickets';
$hesklang['can_assign_tickets']='Assigner des Tickets';
$hesklang['can_del_tickets']='Supprimer des Tickets';
$hesklang['can_edit_tickets']='Editer les réponses aux demandes';
$hesklang['can_change_cat']='Changer la demande de catégorie';
$hesklang['can_man_kb']='Gérer la base de connaissance';
$hesklang['can_man_users']='Gérer les utilisateurs';
$hesklang['can_man_cat']='Gérer les catégories';
$hesklang['can_man_canned']='Gérer les réservoirs de réponses';
$hesklang['can_man_settings']='Gérer les paramètres du système de support';
$hesklang['can_del_notes']='Supprimer les notes d\'une demande';
$hesklang['dan']='les utilisateurs peuvent supprimer leur propre note sur une demande, ne sélectionner cette option que si vous souhaitez autoriser les utilisateurs a être en mesure de supprimer des notes d\'autres utilisateurs';
$hesklang['in_all_cat']='Autorisé uniquement dans les catégories';
$hesklang['admin_can']='(accès à toutes les fonctions et catégories)';
$hesklang['staff_can']='(vous pouvez limiter les fonctions et les catégories)';
$hesklang['asign_one_feat']='Assigner au moins une fonction à cet utilisateur !';
$hesklang['na_view_tickets']='Vous n\'êtes pas autorisé à afficher les Tickets';
$hesklang['support_notice']='Désolé, cette partie ne sera masquée qu´après l\'achat d\'une Licence HESK !';
$hesklang['rart']='Est-ce que cet article vous a été utile ?';
$hesklang['r']='Est-ce que cette réponse vous a été utile ?';
$hesklang['tyr']='Merci pour votre évaluation';
$hesklang['cw']='Fermer la fenêtre';
$hesklang['cw2']='Fermer la fenêtre et soumettre la demande';
$hesklang['rh']='Merci, cette évaluation a été <i>utile</i>';
$hesklang['rnh']='Désolé, l\'évaluation <i>n\'a pas été utile</i>';
$hesklang['ar']='En cours d\'évaluation';
$hesklang['rated']='Utilisateur évaluation %s/5.0 (%s votes)';
$hesklang['not_rated']='Utilisateur non évalué pour le moment';
$hesklang['rdis']='l\'évaluation a été désactivée';
$hesklang['kbdis']='La base de connaissance est désactivée';
$hesklang['kbpart']='Désolé, vous n\'avez pas les autorisations d\'accès pour cet article';
$hesklang['popart']='Les articles de la base de connaissance les plus vus :';
$hesklang['latart']='Derniers articles de la base de connaissance :';
$hesklang['m']='Plus de sujets';
$hesklang['ac']='Articles dans cette Catégorie :';
$hesklang['noa']='Aucun Article';
$hesklang['noac']='Désolé, Aucun Article dans cette Catégorie';
$hesklang['dta']='Date';
$hesklang['ad']='Détails de l\'Article';
$hesklang['aid']='Article ID';
$hesklang['as']='Solution';
$hesklang['search']='Recherche';
$hesklang['sr']='Résultats de la Recherche';
$hesklang['nosr']='Aucun Article correspondant trouvé. Essayez de parcourir notre Base de Connaissance ou de soumettre une nouvelle demande.';
$hesklang['rv']='Ré-initialiser le Compteur du nombre d\'Affichages';
$hesklang['rr']='Ré-initialiser les Votes (évaluation)';
$hesklang['opt']='Options';
$hesklang['delcat']='Supprimer la Catégorie';
$hesklang['move1']='Déplacer les Articles vers la Catégorie Générale';
$hesklang['move2']='Supprimer les articles dans cette catégorie';
$hesklang['sc']='Articles suggérés dans la Base de Connaissance';
$hesklang['not']='Tickets'; // Number of all tickets in category
$hesklang['graph']='Statistiques';
$hesklang['lu']='Liste des Utilisateurs';
$hesklang['aclose']='Fermeture auto. Tickets';
$hesklang['aclose2']='jours après la dernière réponse du Support Administrés';
$hesklang['s_ucrt']='Ré-ouvrir des Tickets';
$hesklang['urate']='Avis de réponse';
$hesklang['hesk_url']='URL du Système de support';
$hesklang['hesk_title']='Titre du Support';
$hesklang['cid']='ID suivi de Cas';
$hesklang['tfor']='Format de l\'Heure';
$hesklang['prefix']='Préfixe de Table';
$hesklang['s_ekb']='Autoriser base de connaissance';
$hesklang['s_kbs']='Activer la recherche dans la base de connaissance';
$hesklang['s_kbr']='Activer l\'évaluation dans la base de connaissance';
$hesklang['s_maxsr']='Résultat maximal de recherche';
$hesklang['s_suggest']='Suggérer des articles dans la base de connaissance';
$hesklang['s_spop']='Voir les articles les plus populaires';
$hesklang['s_slat']='Voir les derniers articles';
$hesklang['s_onin']='sur la page <a href="../" target="_blank">Index du support</a>';
$hesklang['s_onkb']='sur la page <a href="../knowledgebase.php" target="_blank">Index de la Base de Connaissance</a>';
$hesklang['s_scol']='Lignes par catégorie';
$hesklang['s_ptxt']='Longueur de visualisation d\'article';
$hesklang['s_psubart']='Articles de sous-catégorie';
$hesklang['enable']='Activer';
$hesklang['s_type']='Type';
$hesklang['custom_r']='Requis';
$hesklang['custom_place']='Localisation';
$hesklang['custom_use']='Champs Personnalisés';
$hesklang['stf']='Champ texte';
$hesklang['stb']='Largeur de la zone de texte';
$hesklang['srb']='Bouton radio';
$hesklang['ssb']='Liste';
$hesklang['db']='Base de Données';
$hesklang['hd']='Paramètres HESK';
$hesklang['gs']='Paramètres principaux';
$hesklang['cwin']='Fermer la fenêtre';
$hesklang['defw']='Valeur par défaut';
$hesklang['ok']='OK';
$hesklang['ns']='Ces options sont disponibles pour ce champ personnalisé. Pour enregistrer les modifications cliquer sur "OK" et le bouton "Enregistrer les modifications" sur la page des paramètres de administrateur !';
$hesklang['rows']='Lignes (hauteur)';
$hesklang['cols']='Colonnes (largeur)';
$hesklang['opt2']='Options pour ce bouton radio, entrer une option par ligne (chaque ligne va créer un nouveau bouton radio avec une valeur à choisir). Vous devez entrer au moins deux options !';
$hesklang['opt3']='Options pour cette case à cocher, entrer une option par ligne (chaque ligne offrira un choix d\'options à vos clients). Vous devez entrer au moins deux options !';
$hesklang['atl2']='Entrer au moins deux options (une par ligne) !';
$hesklang['notes']='Notes';
$hesklang['addnote']='+ Ajouter une note';
$hesklang['noteby']='Note par';
$hesklang['delnote']='Supprimer une note';
$hesklang['noteerr']='Note déja supprimée ou mauvais paramètre';
$hesklang['s']='Soumettre';
$hesklang['nhid']='Les notes ne sont pas visibles et servent uniquement à l\'équipe support !';
$hesklang['delt']='Supprimer ce post';
$hesklang['edtt']='Editer ce post';
$hesklang['edt1']='Post modifié';
$hesklang['edt2']='Les modifications du post sélectionné ont été sauvegardées';
$hesklang['dele']='Supprimer cette demande';
$hesklang['repd']='Post supprimé';
$hesklang['repl']='Le post sélectionné a été supprimé';
$hesklang['tickets_found']='Résultats de recherche';
$hesklang['al']='Lien Administration';
$hesklang['ap']='&Eacute;quipe Support';
$hesklang['dap']='Lien Administration';
$hesklang['q_miss']='Répondre à la question Anti-Spam';
$hesklang['use_q']='Utiliser la question anti-SPAM';
$hesklang['q_q']='-&gt; Question (le code HTML est <span class="success">autorisé</span>)';
$hesklang['q_a']='-&gt; Réponse';
$hesklang['err_qask']='Saisir une question anti-SPAM';
$hesklang['err_qans']='Saisir une réponse à la question anti-SPAM';
$hesklang['genq']='Générer une question au hasard';

// Added in version 2.1
$hesklang['amo']='Ajouter plus';
$hesklang['delatt']='Supprimer la pièce jointe sélectionnée ?';
$hesklang['kb_att_rem']='La pièce jointe sélectionnée est supprimée';
$hesklang['inv_att_id']='l\'ID de la pièces jointe est invalide !';
$hesklang['scb']='Case à cocher';
$hesklang['opt4']='Merci de noter une réponse par ligne pour cette option. Un utilisateur pourra choisir une ou plusieurs réponses parmi cette liste. Vous devez entrer au moins 2 options';
$hesklang['autologin']='Connectez moi automatiquement à chaque visite';
$hesklang['just_user']='Se souvenir uniquement de mon nom d\'utilisateur';
$hesklang['nothx']='Non, merci';
$hesklang['pinfo']='Informations sur le profil';
$hesklang['sig']='Signature';
$hesklang['pref']='Préférences';
$hesklang['aftrep']='Après une réponse à une demande';
$hesklang['showtic']='Afficher la demande à laquelle je viens de répondre';
$hesklang['gomain']='Retour à la page d\'administration';
$hesklang['shownext']='Ouvrir la prochaine demande en attente de réponse (si aucune, retour à la page d\'administration)';
$hesklang['rssn']='Afficher la prochaine demande en attente de réponse';
$hesklang['mrep']='Remplacer le Message existant';
$hesklang['madd']='Ajouter la réponse à la suite';
$hesklang['priv']='Les Catégories et les Articles Privés ne sont consultables que par l\'Équipe Support. Elles sont marquées par un astérisque (*)';
$hesklang['inve']='Fichier E-mail invalide';
$hesklang['emfm']='Fchier E-mail';
$hesklang['hesk_lang']='Langue par défaut';
$hesklang['s_mlang']='Multilangue';
$hesklang['s_mlange']='Si activé, vos utilisateurs pourront choisir la langue de leur choix. Activer seulement si vous prévoyez de fournir un support dans plusieurs langues !';
$hesklang['s_inl']='Test Répertoire Langues';
$hesklang['s_inle']='Test du répertoire language pour les langues valides. Seules les langues qui passent tous les tests sont installées proprement.';
$hesklang['ta']='Essayer à nouveau';
$hesklang['alo']='Connexion auto.';
$hesklang['chol']='Langue préférée';
$hesklang['mmdl']='Valider comme Langue préférée';
$hesklang['warn']='ATTENTION';
$hesklang['dmod']='Le Debug mode est activé. Soyez sûr de désactiver le mode debug (débogage) dans les paramètres du script une fois que celui-ci est installé et fonctionne correctement.';
$hesklang['kb_spar']='La catégorie ne peut pas être sa propre racine !';
$hesklang['mysql_root']='Votre mot de passe MySQL est vide, êtes vous sûr de vouloir vous connecter avec l\'utilisateur root ? Ceci représente un grave risque de sécurité !';
$hesklang['chg']='Modifier';
$hesklang['chpri']='Priorité modifiée';
$hesklang['chpri2']='La priorité de la demande a été modifiée en %s';
$hesklang['selcan']='Choisir la réponse en boîte que vous voudriez éditer';
$hesklang['q_wrng']='Ecrire la réponse anti-SPAM';
$hesklang['cndupl']='Une catégorie portant ce nom existe déjà. Choisir un nom unique pour chaque catégorie.';
$hesklang['wsel']='Sélectionner le champ avec lequel vous souhaitez rechercher';

// Added in version 2.2
$hesklang['eto']='Demande invalide';
$hesklang['id']='ID';
$hesklang['geco']='Générer Lien Direct';
$hesklang['genl']='Lien Direct pour la Catégorie';
$hesklang['genl2']='Utiliser ce lien pour pré-sélectionner la catégorie dans le formulaire &quot;Envoyer une demande&quot;.';
$hesklang['ask']='Recherche Aide :';
$hesklang['exa']='Exemples';
$hesklang['small']='Petite Boîte';
$hesklang['large']='Grande Boîte';
$hesklang['cpri']='Priorité à la clientèle';
$hesklang['owner']='Technicien';
$hesklang['unas']='Sans attribution';
$hesklang['assi']='Assigner';
$hesklang['asst']='Assigner à';
$hesklang['asst2']='Assigner cette demande à';
$hesklang['asss']='M\'assigner la demande';
$hesklang['asss2']='Assigner cette demande à moi-même';
$hesklang['can_assign_self']='Assigner des Tickets pour soi-même';
$hesklang['can_assign_others']='Assigner des demandes à d\'autres Personnes';
$hesklang['can_run_reports']='Peut démarrer rapport (perso)';
$hesklang['can_view_ass_others']='Possibilité de visualiser les tickets assignés à d\'autres';
$hesklang['unoa']='l\'utilisateur sélectionné n\'a pas accès à cette catégorie';
$hesklang['tasi']='Technicien assigné';
$hesklang['tasy']='Cette demande vous a été assignée';
$hesklang['taso']='Cette demande a été assignée à l\'Utilisateur sélectionné';
$hesklang['tasy2']='La demande vous est assignée';
$hesklang['taso2']='Assigné à d\'autres membres de l\'équipe support';
$hesklang['nose']='Aucun Technicien sélectionné';
$hesklang['onasc']='Ce Technicien n\'a pas accès à la catégorie sélectionnée.';
$hesklang['tunasi']='Demande sans attribution';
$hesklang['tunasi2']='La demande est sans Technicien et prête à être assignée à nouveau';
$hesklang['note']='Note';
$hesklang['success']='Succès';
$hesklang['nyt']='Cette demande est assignée à';
$hesklang['noch']='Aucune modification n\'a été faite';
$hesklang['orch']='Ordre d\'affichage a été modifié';
$hesklang['rfm']='Informations obligatoires manquantes :';
$hesklang['repl0']='Autorisations insuffisantes pour effectuer cette tâche';
$hesklang['repl1']='Ce poste n\'existe pas';
$hesklang['reports']='Rapports';
$hesklang['reports_intro']='La section des rapports vous permet d\'exécuter plusieurs rapports et consulter les statistiques de tickets dans une plage de date choisie.';
$hesklang['refi']='Réinitialiser les données';
$hesklang['dich']='Abandonner les modifications';
$hesklang['dire']='Afficher rapport';
$hesklang['m1']='janvier';
$hesklang['m2']='février';
$hesklang['m3']='mars';
$hesklang['m4']='avril';
$hesklang['m5']='mai';
$hesklang['m6']='juin';
$hesklang['m7']='juillet';
$hesklang['m8']='août';
$hesklang['m9']='septembre';
$hesklang['m10']='octobre';
$hesklang['m11']='novembre';
$hesklang['m12']='décembre';
$hesklang['d1']='lundi';
$hesklang['d2']='mardi';
$hesklang['d3']='mercredi';
$hesklang['d4']='jeudi';
$hesklang['d5']='vendredi';
$hesklang['d6']='samedi';
$hesklang['d0']='dimanche';
$hesklang['mo']='Lu';
$hesklang['tu']='Ma';
$hesklang['we']='Me';
$hesklang['th']='Je';
$hesklang['fr']='Ve';
$hesklang['sa']='Sa';
$hesklang['su']='Di';
$hesklang['from']='De';
$hesklang['cinv']='Date invalide';
$hesklang['cinv2']='Format accepté est mm/dd/yyyy';
$hesklang['cinm']='Valeur de mois invalide';
$hesklang['cinm2']='Plage autorisée est';
$hesklang['cind']='Jour du mois invalide';
$hesklang['cind2']='Plage autorisée pour le mois sélectionné est';
$hesklang['month']='Mois';
$hesklang['ocal']='Ouvrir le calendrier';
$hesklang['ca01']='Année précédente';
$hesklang['ca02']='Mois précédent';
$hesklang['ca03']='Le mois prochain';
$hesklang['ca04']='Année suivante';
$hesklang['ca05']='Fermer Calendrier';
$hesklang['cdr']='Choisir une tranche de date';
$hesklang['crt']='Type de rapport';
$hesklang['r1']='Aujourd\'hui';
$hesklang['r2']='Hier';
$hesklang['r3']='Ce mois-ci';
$hesklang['r4']='Mois dernier';
$hesklang['r5']='30 derniers jours';
$hesklang['r6']='Cette semaine (Lu-Di)';
$hesklang['r7']='La semaine dernière (Lu-Di)';
$hesklang['r8']='Cette semaine commerciale (Lu-Ve)';
$hesklang['r9']='Dernière semaine commerciale (Lu-Ve)';
$hesklang['r10']='Cette année';
$hesklang['r11']='Année dernière';
$hesklang['r12']='Tout le temps';
$hesklang['datetofrom']='&quot;Dater de&quot; ne peut pas être supérieur à &quot;Date à&quot;. Les dates ont été inversées.';
$hesklang['t1']='Tickets par jour';
$hesklang['t2']='Tickets par mois';
$hesklang['t3']='Tickets par utilisateur';
$hesklang['t4']='Tickets par catégorie';
$hesklang['ticass']='Tickets Assignés';
$hesklang['ticall']='Tickets Répondus';
$hesklang['totals']='Totaux';
$hesklang['all']='Tout';
$hesklang['atik']='Nouveaux tickets';
$hesklang['kbca']='Vous avez déjà une catégorie de base de connaissance avec ce nom.';
$hesklang['menu_msg']='E-Mail';
$hesklang['menu_can']='RÉPONSES';
$hesklang['m_from']='De:'; // Mail "from" address
$hesklang['m_to']='À:'; // Mail "to" address
$hesklang['m_sub']='Sujet:'; // Mail subject
$hesklang['m_re']='Re:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='Tr:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Messages Privés';
$hesklang['m_intro']='Utiliser les messages privés pour envoyer des messages rapides aux autres membres du Personnel HESK.';
$hesklang['e_udel']='(Utilisateur supprimé)';
$hesklang['new_mail']='Nouveau message privé';
$hesklang['m_send']='Envoyer un message';
$hesklang['m_rec']='Sélectionner le destinataire du message';
$hesklang['m_inr']='Destinataire du message invalide';
$hesklang['m_esu']='Entrer le sujet du message privé';
$hesklang['m_pms']='Votre message privé a été envoyé';
$hesklang['inbox']='Messages Reçus';
$hesklang['outbox']='Messages Envoyés';
$hesklang['m_new']='Nouveau Message';
$hesklang['pg']='Voir la page';
$hesklang['npm']='Pas de messages privés dans ce dossier.';
$hesklang['m_ena']='Vous n\'avez pas la permission de lire ce message.';
$hesklang['mau']='Marquer comme non lu';
$hesklang['mo1']='Marquer les messages sélectionnés comme lus';
$hesklang['mo2']='Marquer les messages sélectionnés comme non lus';
$hesklang['mo3']='Supprimer les messages sélectionnés';
$hesklang['delm']='Supprimer ce message';
$hesklang['e_tid']='Erreur générer une demande d\'identification unique, s\'il vous plaît essayer de soumettre le formulaire plus tard.';
$hesklang['smmr']='Les messages sélectionnés ont été marqués comme lus';
$hesklang['smmu']='Les messages sélectionnés ont été marqués comme non lus';
$hesklang['smdl']='Les messages sélectionnés ont été supprimés';
$hesklang['show']='Montrer';
$hesklang['s_my']='Assigné à moi-même';
$hesklang['s_ot']='Assigné à d\'autres';
$hesklang['s_un']='Demandes non assignées';
$hesklang['s_for']='Rechercher';
$hesklang['s_in']='Rechercher dans';
$hesklang['s_incl']='Rechercher dans';
$hesklang['find_ticket_by']='Trouver une Demande de Support';
$hesklang['e_nose']='Aucun statut d\'attribution choisi, en montrant tous les tickets.';
$hesklang['fsq']='Entrer votre requête de recherche';
$hesklang['topen']='Ouvert';
$hesklang['nms']='Aucun message sélectionné, rien à changer';
$hesklang['tlo']='Verrouiller demande';
$hesklang['tul']='Déverrouiller demande';
$hesklang['loc']='Bloqué';
$hesklang['isloc']='Les clients ne peuvent pas répondre ou rouvrir les tickets verrouillés. Lorsqu´elle est verrouillée, la demande est marquée comme résolue.';
$hesklang['tlock']='Demande a été verrouillée';
$hesklang['tunlock']='Demande a été déverrouillée';
$hesklang['tislock']='Cette demande a été verrouillée. Le client ne pourra pas poster une réponse.';
$hesklang['tislock2']='Cette demande a été verrouillée, vous ne pouvez pas poster une réponse.';
$hesklang['nsfo']='Pas d\'articles pertinents trouvés.';
$hesklang['thist1']='<li class="smaller">%s | déplacé vers la catégorie %s par %s</li>'; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller">%s | assigné à %s par %s</li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class="smaller">%s | fermé par %s</li>'; // %s = date, user making change
$hesklang['thist4']='<li class="smaller">%s | ouvert par %s</li>'; // %s = date, user making change
$hesklang['thist5']='<li class="smaller">%s | bloqué par %s</li>'; // %s = date, user making change
$hesklang['thist6']='<li class="smaller">%s | débloqué par %s</li>'; // %s = date, user making change
$hesklang['thist7']='<li class="smaller">%s | ticket créé par %s</li>'; // %s = date, user making change
$hesklang['elocked']='Cette demande a été verrouillée ou supprimée.';
$hesklang['nti2']='Insérer une Nouvelle Demande';
$hesklang['nti3']='Utiliser ce Formulaire pour créer une nouvelle demande au nom du Client. Entrer les informations du <i>Client</i> dans le Formulaire (Nom, E-mail, ...) et NON votre nom ! La demande sera créée comme si elle avait été soumise par le Client lui-même.';
$hesklang['addop']='Options';
$hesklang['seno']='Envoyer un Message E-mail pour le Client';
$hesklang['otas']='Voir la demande après avoir envoyé le message';
$hesklang['notn']='Notifications';
$hesklang['nomw']='Le Logiciel de Support Administrés enverra une Notification par E-mail lorsque :';
$hesklang['nwts']='Une nouvelle demande est soumise par le propriétaire :';
$hesklang['ncrt']='Le client répond à une demande avec le propriétaire';
$hesklang['ntam']='une demande est assignée à moi';
$hesklang['npms']='Un message privé est envoyé à moi';
$hesklang['support_remove']='Le développement de HESK a nécessité beaucoup de temps et d’efforts. Soutenez HESK en achetant une licence qui supprimera les liens de crédits <i> du logiciel Help Desk HESK </ i> de votre service d\'assistance.';
$hesklang['ycvtao']='Vous n\'êtes pas autorisé à voir les Tickets attribués à d\'autres Techniciens';
$hesklang['password_not_valid']='Mot de passe doit être d\'au moins 5 caractères';
$hesklang['lkbs']='Chargement des bases de connaissances...';
$hesklang['auto']='(automatiquement)';

// Added in version 2.3
$hesklang['unknown']='Inconnu';
$hesklang['pcer']='Merci de corriger les Erreurs Suivantes :';
$hesklang['seqid']='ID du Ticket';
$hesklang['close_action']='Marquer comme Résolu'; // Close ACTION
$hesklang['archived']='Marqué';
$hesklang['archived2']='Demande marquée';
$hesklang['add_archive']='Marquer cette demande';
$hesklang['add_archive_quick']='Marquer les demandes sélectionnées';
$hesklang['remove_archive']='Démarquer cette demande';
$hesklang['remove_archive_quick']='Démarquer les demandes sélectionnées';
$hesklang['added_archive']='Demande Marquée';
$hesklang['removed_archive']='Demande Démarquée';
$hesklang['added2archive']='la Demande a été marquée';
$hesklang['removedfromarchive']='la demande a été démarquée';
$hesklang['num_tickets_tag']='<b>%d</b> des demandes ont été marquées';
$hesklang['num_tickets_untag']='<b>%d</b> des demandes ont été démarquées';
$hesklang['can_add_archive']='Peut marquer une demande';
$hesklang['disp_only_archived']='Les demandes marquées';
$hesklang['search_only_archived']='Les demandes marquées';
$hesklang['critical']=' * critique * ';
$hesklang['thist8']='<li class="smaller">%s | priorité changée à %s par %s</li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class="smaller">%s | statut changé à %s par %s</li>'; // %s = date, new status, user making change
$hesklang['thist10']='<li class="smaller">%s | assigné automatiquement à %s</li>'; // %s = date, user making change
$hesklang['thist11']='<li class="smaller">%s | soumis par collecte E-mail</li>'; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']=' Année<br />';
$hesklang['abbr']['month']=' Mois<br />';
$hesklang['abbr']['week']=' Sem<br />';
$hesklang['abbr']['day']=' Jour<br />';
$hesklang['abbr']['hour']=' Heure<br />';
$hesklang['abbr']['minute']=' Min<br />';
$hesklang['abbr']['second']=' Sec';
// END abberviations
$hesklang['cnsm']='Impossible d\'envoyer le Message à :';
$hesklang['yhbb']='Vous êtes exclu du système pour %s Minutes, trop d\'Erreurs de Connexion.';
$hesklang['pwdst']='Longueur du Mot de Passe';
$hesklang['tid_mail']='Saisir <b>l\'Adresse E-mail</b> avec laquelle la demande a été soumise. <br/>Le Numéro de Référence vous parviendra immédiatement.<br />';
$hesklang['rem_email']='Se rappeler de mon adresse E-mail';
$hesklang['eytid']='Entrer votre Numéro de Demande.';
$hesklang['enmdb']='l\'adresse E-mail entrée, ne correpond pas à cette Référence de Demande.';
$hesklang['confemail']='Confirmer votre E-mail';
$hesklang['confemail2']='Merci de confirmer votre adresse E-mail';
$hesklang['confemaile']='Les deux adresses ne sont pas identiques';
$hesklang['taso3']='Demandé par :';
$hesklang['sec_enter']='Entrer le nombre que vous voyez ci-dessous.';
$hesklang['reload']='Recharger l\'image';
$hesklang['verify_q']='Prévention du SPAM :'; // For anti-spam question
$hesklang['verify_i']='Prévention du SPAM :'; // For anti-spam image (captcha)
$hesklang['admin_login']='Connexion du Personnel';
$hesklang['vrfy']='Test réussi';
$hesklang['last_update']='Mis à jour';
$hesklang['cot']='Ne pas forcer les tickets critiques au-dessus';
$hesklang['def']='Faire de cette vue ma vue par defaut';
$hesklang['gbou']='Ces tickets sont <b>Non-assignés :</b>';
$hesklang['gbom']='Tickets assignés à <b>moi :</b>';
$hesklang['gboo']='Tickets assignés à <b>%s :</b>';
$hesklang['select']=' - - Sélectionner - - ';
$hesklang['chngstatus']='Changer le statut en :';
$hesklang['perat']='%s de tous les tickets'; // Will change to "23% of all tickets"
$hesklang['viewart']='Voir cet article';
$hesklang['chdp']='Merci de changer votre Mot de Passe sur votre <a href="profile.php">Profil !</a>';
$hesklang['chdp2']='Changer votre Mot de Passe, vous utilisez celui par défaut !';
$hesklang['security']='Sécurité';
$hesklang['kb_i_art']='Nouvel Article';
$hesklang['kb_i_art2']='Insérer un Article';
$hesklang['kb_i_cat']='Nouvelle catégorie';
$hesklang['kb_i_cat2']='Insérer une catégorie';
$hesklang['gopr']='Voir la base de connaissance';
$hesklang['kbstruct']='Structure de la base de connaissance';
$hesklang['cancel']='Annuler';
$hesklang['sh']='Cacher le Maessage';
$hesklang['goodkb']='Comment écrire un bon article pour la base de connaissance ?';
$hesklang['catset']='Paramètres de Catégorie';
$hesklang['inpr']='Sélectionner la nouvelle Catégorie';
$hesklang['incat']='Sélectionner la nouvelle Catégorie';
$hesklang['instat']='Sélectionner le nouveau statut';
$hesklang['tsst']='Le statut de la demande a été changé en %s';
$hesklang['aass']='Assignement-Automatique';
$hesklang['aaon']='l\'Assignement-Automatique des tickets a été activé (cliquer pour désactiver)';
$hesklang['aaoff']='l\'Assignement-Automatique des tickets a été désactivé (cliquer pour activer)';
$hesklang['uaaon']='l\'Assignement-Automatique a été activé pour l\'utilisateur sélectionné';
$hesklang['uaaoff']='l\'Assignement-Automatique a été désactivé pour l\'utilisateur sélectionné';
$hesklang['taasy']='Cette demande vous a été automatiquement assignée';
$hesklang['can_view_unassigned']='Peut voir les tickets non assignés';
$hesklang['ycovtay']='Vous pouvez seulement voir les tickets qui vous ont été assignés';
$hesklang['in_progress']='En Cours';
$hesklang['on_hold']='En Attente';
$hesklang['import_kb']='Importer cette demande à la base de connaissance';
$hesklang['import']='Vous importez une <i>demande privée</i> vers une <i>demande publique</i>.<br /><br />Soyez sûr de supprimer toute information privée ou sensible du sujet et du message !';
$hesklang['tab_1']='Général';
$hesklang['tab_2']='Assistance';
$hesklang['tab_3']='Base de Connaissance';
$hesklang['tab_4']='Champs Personnalisés';
$hesklang['tab_5']='Divers';
$hesklang['disable']='Désactiver';
$hesklang['dat']='Date &amp; Heure';
$hesklang['lgs']='Language';
$hesklang['onc']='ON - Clients';
$hesklang['ons']='ON - Tous';
$hesklang['viewvtic']='Voir les demandes';
$hesklang['reqetv']='Exiger un E-mail pour voir une demande';
$hesklang['banlim']='Tentative Connexion';
$hesklang['banmin']='Bannissement (minutes)';
$hesklang['subnot']='Soumettre une notification';
$hesklang['subnot2']='Montrer la notification aux clients qui soumettent des demandes';
$hesklang['eseqid']='ID Séquentielle';
$hesklang['sconfe']='Confirmer l\'E-mail';
$hesklang['saass']='Auto-assigner les demandes';
$hesklang['swyse']='Editeur WYSIWYG';
$hesklang['hrts']='Noter HESK';
$hesklang['hrts2']='Montrer noter Ce Script dans la partie admin';
$hesklang['emlpipe']='Collecte E-mail';
$hesklang['emlsend2']='Envoyer les E-mails en utilisant';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='SMTP Server';
$hesklang['smtph']='Hôte SMTP';
$hesklang['smtpp']='Port SMTP';
$hesklang['smtpu']='Nom d\'utilisateur SMTP';
$hesklang['smtpw']='Mot de passe SMTP';
$hesklang['smtpt']='Délai d\'attente SMTP';
$hesklang['other']='Autre';
$hesklang['features']='Caractéristiques';
$hesklang['can_view_online']='Peut voir les membres de l\'équipe qui sont en ligne';
$hesklang['online']='En Ligne';
$hesklang['offline']='Hors Ligne';
$hesklang['onlinep']='Utilisateurs En Ligne'; // For display in footer
$hesklang['sonline']='Utilisateurs En Ligne'; // For settings page
$hesklang['sonline2']='Montrer les Utilisateurs En Ligne. Limite (minutes) :'; // For settings page
$hesklang['gb']='Grouper par';
$hesklang['dg']='Ne pas Grouper';
$hesklang['err_dpi']='La base de données %s ne contient pas toutes les tables HESK avec le préfixe %s, aucun changement sauvegardé.';
$hesklang['err_dpi2']='Tables non trouvées :';
$hesklang['sme']='SMTP erreur';
$hesklang['scl']='log de connexion SMTP';
$hesklang['dnl']='Télécharger';
$hesklang['dela']='Supprimer la Pièce jointe';
$hesklang['pda']='Voulez vous vraiment supprimer la pièce jointe ?';
$hesklang['thist12']='<li class="smaller">%s | Fichier joint %s supprimé par %s</li>'; // %s = date, deleted attachment, user making change
$hesklang['mopt']='Plus d\'Options';
$hesklang['lopt']='Moins d\'Options';
$hesklang['meml']='Multiple E-mails';
$hesklang['meml2']='Autoriser les clients à entrer de multiples contacts E-mails.';

// Added in version 2.4
$hesklang['catd']='(Catégorie supprimée)';
$hesklang['noopen']='Aucun Ticket ouvert n\'a été trouvé avec cette adresse E-mail.';
$hesklang['maxopen']='Vous avez atteint le nombre maximum de tickets ouverts (%d of %d). Veuillez patienter jusqu\'à ce que vos tickets existants soient résolus avant d\'ouvrir de nouveaux tickets.';
$hesklang['ntnote']='Quelqu\'un a ajouté une note à l\'un des Tickets qui m\'est assigné';
$hesklang['cat_public']='Cette catégorie est PUBLIQUE (cliquez pour la rendre privée)';
$hesklang['cat_private']='Cette catégorie est PRIV&Eacute;E (cliquez pour la rendre publique)';
$hesklang['cat_aa']='Assigner automatiquement les tickets dans cette catégorie.';
$hesklang['cat_type']='Rendre cette catégorie privée (seul le support peut la sélectionner).';
$hesklang['caaon']='L\'assignation automatique a été autorisée pour la catégorie sélectionnée';
$hesklang['caaoff']='L\'assignation automatique a été désactivée pour la catégorie sélectionnée';
$hesklang['cpub']='Type de la catégorie changé en PUBLIC';
$hesklang['cpriv']='Type de la catégorie changé en PRIV&Eacute;';
$hesklang['cpric']='Les clients ne peuvent pas sélectionner de catégories privées, seul le support peut !';
$hesklang['user_aa']='Assigner automatiquement les Tickets à ce Technicien.';
$hesklang['attach_size']='Taille Maximale des Fichiers';
$hesklang['B']='B';
$hesklang['kB']='kB';
$hesklang['MB']='MB';
$hesklang['GB']='GB';
$hesklang['bytes']='bytes';
$hesklang['kilobytes']='kilobytes';
$hesklang['megabytes']='megabytes';
$hesklang['gigabytes']='gigabytes';
$hesklang['smtpssl']='SSL Protocol';
$hesklang['smtptls']='TLS Protocol';
$hesklang['oo']='Ouverture seule';
$hesklang['ool']='Lister seulement les tickets ouverts dans les E-mails &quot;ID de suivi perdu&quot;';
$hesklang['mop']='Maximum de tickets ouverts';
$hesklang['rord']='Ordre des réponses';
$hesklang['newbot']='Nouvelle réponse en bas';
$hesklang['newtop']='Nouvelle réponse en haut';
$hesklang['ford']='Formulaire de réponse';
$hesklang['formbot']='Afficher le formulaire en bas';
$hesklang['formtop']='Afficher le formulaire en haut';
$hesklang['mysqlv']='MySQL version';
$hesklang['phpv']='PHP version';
$hesklang['csrt']='Heure courante du serveur :';
$hesklang['listp']='Lister les articles privés';
$hesklang['listd']='Lister les articles brouillons';
$hesklang['artp']='Articles privés';
$hesklang['artd']='Articles brouillon';
$hesklang['kb_no_part']='Pas d\'articles en privé dans la base de connaissance.';
$hesklang['kb_no_dart']='Pas d\'articles en brouillon dans la base de connaissance.';
$hesklang['attpri']='Vous n\'avez pas accès à cette pièce jointe.';
$hesklang['can_merge_tickets']='Fusionner des tickets';
$hesklang['mer_selected']='Fusionner les tickets sélectionnés';
$hesklang['merged']='Les tickets sélectionnés ont été fusionnés en un seul.';
$hesklang['merge_err']='Un problème s\'est produit lors de la fusion des tickets :';
$hesklang['merr1']='sélectionnez au moins deux tickets.';
$hesklang['merr2']='ticket recherché non trouvé.';
$hesklang['merr3']='ticket dans une catégorie à laquelle vous n\'avez pas accès.';
$hesklang['tme']='Le ticket %s a été fusionné avec ce ticket (%s).';
$hesklang['tme1']='Le ticket %s a été fusionné avec le ticket %s';
$hesklang['tme2']='Pour accéder au ticket %s, entrez l\'adresse E-mail associée.';
$hesklang['eyou']='Utilisez la page de profil pour éditer vos paramétrages.';
$hesklang['npea']='Vous n\'avez pas la permission d\'éditer cet utilisateur.';
$hesklang['duplicate_user']='L\'utilisateur avec ce nom existe déjà, veuillez choisir un nom différent.';
$hesklang['kw']='Mots clés';
$hesklang['kw1']='(optionnel - séparer par un espace, une virgule ou une nouvelle ligne)';
$hesklang['type_not_allowed']='Les fichiers se terminant par <b>%s</b> ne sont pas acceptés (%s)'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='Le client n\'a pas encore lu cette réponse.';
$hesklang['sticky']='&quot;&Eacute;pingler&quot; cet article';
$hesklang['stickyon']='Changer l\'article en &quot;&Eacute;pinglé&quot;';
$hesklang['stickyoff']='Change l\'article en &quot;Normal&quot;';
$hesklang['ason']='Article marqué comme &quot;&Eacute;pinglé&quot;';
$hesklang['asoff']='Article marqué comme &quot;Normal&quot;';
$hesklang['ts']='Temps de traitement';
$hesklang['start']='Début / Arrêt';
$hesklang['reset']='Réinitialiser';
$hesklang['save']='Enregistrer';
$hesklang['hh']='Heures';
$hesklang['mm']='Minutes';
$hesklang['ss']='Secondes';
$hesklang['thist']='Historique du Ticket';
$hesklang['thist13']='<li class="smaller">%s | mixé avec le ticket %s par %s</li>'; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class="smaller">%s | Temps de travail modifié en %s par %s</li>'; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class="smaller">%s | soumis par %s</li>'; // %s = date, user making change
$hesklang['thist16']='<li class="smaller">%s | soumis par relevé POP3</li>';
$hesklang['twu']='Le temps de traitement du ticket a été mis à jour.';
$hesklang['autoss']='Démarrer automatiquement le chronomètre quand j\'ouvre un ticket';
$hesklang['ful']='Limites de Téléchargement de Fichiers';
$hesklang['ufl']='Vous pouvez envoyer des Fichiers se terminant par :';
$hesklang['nat']='Nombre de Pièces Jointes :';
$hesklang['mfs']='Taille maximale par Pièce Jointe :';
$hesklang['lps']='Vos préférences de Langue ont été sauvegardées';
$hesklang['sav']='Afficher les articles par vues';
$hesklang['sad']='Afficher les articles par date';
$hesklang['emp']='Votre PHP n\'a pas le support MYSQL activé (mysqli extension requise)';
$hesklang['epd']='[HESK] Collecte E-mail EST DESACTIVE DANS LES PARAMETRAGES';
$hesklang['pfd']='[HESK] Relève POP3 EST DESACTIVE DANS LES PARAMETRAGES';
$hesklang['pem']='[Courrier Electronique]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Client]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='E-mail';
$hesklang['pop3']='Relève POP3';
$hesklang['pop3h']='Hôte POP3';
$hesklang['pop3p']='Port POP3';
$hesklang['pop3tls']='Protocole TLS';
$hesklang['pop3u']='utilisateur POP3';
$hesklang['pop3w']='Mot de passe POP3';
$hesklang['pop3e']='Erreur POP3';
$hesklang['pop3log']='Journal de connexion POP3';
$hesklang['mysqltest']='Tester la connexion MySQL';
$hesklang['smtptest']='Test connexion SMTP';
$hesklang['pop3test']='Test connexion POP3';
$hesklang['contest']='Test de la connexion, cela peut prendre du temps...';
$hesklang['conok']='Connexion avec succès !';
$hesklang['conokn']='Cependant, si votre serveur nécessite un nom d\'utilisateur et un mot de passe, un E-mail ne sera pas envoyé !';
$hesklang['saving']='Enregistrement des paramètres, veuillez patienter...';
$hesklang['sns']='Les paramètres ont été enregistrés, mais quelques fonctions ont été désactivées car des tests ont échoué.';
$hesklang['looph']='Essais Maximum';
$hesklang['loopt']='Plage de temps';
$hesklang['didum']='Vous voulez dire %s?'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Oui, corrigez le';
$hesklang['nole']='Non, laisser tel quel';
$hesklang['sconfe2']='Afficher un champ &quot;E-mail de Confirmation&quot; sur le formulaire de soumission de ticket';
$hesklang['oln']='Ancien Nom :';
$hesklang['nen']='Nouveau Nom :';
$hesklang['use_form_below']='<i>Utilisez ce Formulaire pour envoyer un Ticket à l\'Assistance en Ligne. <strong>Les champs requis sont marqués avec</strong></i>';
$hesklang['esf']='N\'a pas pu envoyer de Notifications par E-mail.';
$hesklang['qrr']='(Réponse avec citations supprimées)';
$hesklang['remqr']='Nettoyer les réponses citées';
$hesklang['remqr2']='Supprimer les réponses citées des E-mails des clients';
$hesklang['suge']='Détecter les erreurs de frappes dans les E-mails';
$hesklang['epro']='Fournisseurs E-mail';
$hesklang['email_noreply']=' &quot;De:&quot; E-mail';
$hesklang['email_name']='&quot;De:&quot; nom';
$hesklang['vscl']='Limites configurées sur le serveur';
$hesklang['fnuscphp']='L\'upload de fichier a échoué, essayez avec un fichier plus petit ou sans pièce jointe.';
$hesklang['redv']='réinitialiser la vue par défaut';
$hesklang['fatte1']='Le &quot;nombre de vos pièces jointes par ticket&quot; est plus important que ce que permet notre serveur !';
$hesklang['fatte2']='La taille maximale des pièces jointes est plus grande que ce que permet notre serveur !';
$hesklang['fatte3']='Notre serveur n\'autorise pas une publication aussi lourde, essayez de réduire le nombre de pièces jointes ou la taille des fichiers autorisée !';
$hesklang['embed']='Fichiers dans le corps du mail';
$hesklang['embed2']='Sauvegarder les fichiers dans le corps du message en pièces jointes';
$hesklang['emrem']='(Image supprimée)';
$hesklang['hdemo']='(Caché dans la DEMO)';
$hesklang['ddemo']='Désolé, cette fonction a été désactivée en mode DEMO !';
$hesklang['sdemo']='Les sauvegardes sont désactivées en MODE DEMO';
$hesklang['hud']='HESK est à Jour';
$hesklang['hnw']='Mise à Jour Disponible';
$hesklang['getup']='Mettre à Jour HESK';
$hesklang['updates']='Mises à Jour';
$hesklang['updates2']='Vérifier automatiquement les Mises à Jour de HESK';

// Added in version 2.5.0
$hesklang['attdel']='Ce fichier a été supprimé du serveur et n\'est plus disponible en téléchargement';
$hesklang['dsen']='Ne pas envoyer d\'E-mail de notification pour cette réponse au client';
$hesklang['attrem']='* Des fichiers joints ont été supprimés *';
$hesklang['attnum']='Nombre maximal atteint: %s'; // %s will show attachment name
$hesklang['attsiz']='Fichier trop grand : %s'; // %s will show attachment name
$hesklang['atttyp']='Type de Fichier interdit : %s'; // %s will show attachment name
$hesklang['adf']='Répertoire Admin';
$hesklang['atf']='Répertoire pièces jointes';
$hesklang['err_adf']='Le répertoire admin sélectionné (%s) n\'existe pas !'; // %s will show folder name
$hesklang['err_atf']='Le répertoire pièces jointes (%s) n\'existe pas !'; // %s will show folder name
$hesklang['err_atr']='Le répertoire pièces jointes (%s) n\'est pas en mode lecture !'; // %s will show folder name
$hesklang['fatt']='Fichiers attachés à ce message :';
$hesklang['wrepo']='SVP, écrivez une réponse après avoir réouvert le ticket.';
$hesklang['ktool']='&raquo; Outils Base de Connaissance';
$hesklang['uac']='Vérifiez et mettez à jour le compteur catégorie article';
$hesklang['acv']='Compteur Articles a été vérifié';
$hesklang['xyz']='nombre d\'articles publics, privés et brouillons dans la catégorie.';
$hesklang['reports_tab']='Démarrer rapports'; // Tab title
$hesklang['can_run_reports_full']='Peut démarrer des rapports (tous)';
$hesklang['can_export']='Peut exporter les tickets';
$hesklang['roo']='<i>(seuls les tickets qui vous sont assignés sont inclus dans le rapport)</i>';
$hesklang['shu']='Liens rapides';
$hesklang['export']='Exporter tickets'; // Tab title
$hesklang['export_btn']='Exporter tickets'; // Button title
$hesklang['export_intro']='Cet outil vous permet d&rsquo;exporter les tickets au format XML qui peut être ouvert avec Excel.';
$hesklang['stte']='Sélectionnez les tickets à exporter';
$hesklang['dtrg']='Intervalle Date';
$hesklang['sequentially']='Séquentiellement'; // Order tickets: Sequentially
$hesklang['ede']='Impossible de créer le répertoire d&rsquo;export, créez un répertoire nommé <b>export</b> dans le répertoire attachments et assurez-vous qu\'il soit inscriptible par PHP (sur Linux CHMOD en 777 - rwxrwxrwx).';
$hesklang['eef']='Impossible de créer le fichier d&rsquo;export, pas de droits de lecture sur le répertoire d&rsquo;exportation.';
$hesklang['inite']='Initialisation export';
$hesklang['gXML']='Génération du fichier XML en cours';
$hesklang['nrow']='Nombre de lignes exportées : %d'; // %d will show number of rows exported
$hesklang['cZIP']='Compression du fichier en archive ZIP en cours';
$hesklang['eZIP']='Erreur de création du fichier archive ZIP';
$hesklang['fZIP']='Compression du fichier archive terminée';
$hesklang['pmem']='Utilisation mémoire maximale: %.2f Mb'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo; CLIQUEZ ICI POUR TELECHARGER LE FICHIER D\'EXPORTATION &laquo;';
$hesklang['n2ex']='Aucun ticket correspondant à vos critères trouvé, rien à exporter !';
$hesklang['sp']='Prévention SPAM'; // For settings page
$hesklang['sit']='-&gt; Type Image';
$hesklang['sis']='Simple image';
$hesklang['rcpb']='Cl&Eacute; de site';
$hesklang['rcpv']='Cl&Eacute; Secrète';
$hesklang['pop3keep']='Garder une copie';
$hesklang['beta']='(TEST VERSION)';
$hesklang['maxpost']='Vous avez certainement essayé de soumettre plus de données que votre serveur n\'accepte.<br /><br />SVP, Essayez de soumettre le formulaire avec moins ou pas de fichiers joints.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='Impossible de valider la protection antispam reCAPTCHA.';

// Added in version 2.6.0
$hesklang['ticket_closed']='[#%%TRACK_ID%%] Ticket fermé/résolu';
$hesklang['ms01']='Jan';
$hesklang['ms02']='Fév';
$hesklang['ms03']='Mar';
$hesklang['ms04']='Avr';
$hesklang['ms05']='Mai';
$hesklang['ms06']='Juin';
$hesklang['ms07']='Juil';
$hesklang['ms08']='Aou';
$hesklang['ms09']='Sep';
$hesklang['ms10']='Oct';
$hesklang['ms11']='Nov';
$hesklang['ms12']='Déc';
$hesklang['sdf']='Format de la date soumise';
$hesklang['lcf']='Format de la date de mise à jour';
$hesklang['lcf0']='Description courte';
$hesklang['lcf1']='Date et Heure';
$hesklang['lcf2']='Style de HESK';
$hesklang['ticket_tpl']='Modèles de ticket';
$hesklang['can_man_ticket_tpl']='Peut gérer les modèles de ticket'; // Permission title
$hesklang['ticket_tpl_man']='Gérer les modèles de ticket'; // Page and link title
$hesklang['ticket_tpl_intro']='Créer ou éditer les modèles de ticket que vous pouvez utiliser pour soumettre rapidement de nouveaux tickets depuis l\'interface d\'administration.';
$hesklang['no_ticket_tpl']='Pas de modèles de ticket';
$hesklang['ticket_tpl_title']='Titre';
$hesklang['delete_tpl']='Etes-vous sûr de vouloir supprimer ce modèle ?';
$hesklang['new_ticket_tpl']='Ajouter ou éditer un modèle de ticket';
$hesklang['ticket_tpl_add']='Créer un nouveau modèle de ticket';
$hesklang['ticket_tpl_edit']='Editer le modèle du ticket sélectionné';
$hesklang['save_ticket_tpl']='Enregistrer le modèle de ticket';
$hesklang['ticket_tpl_saved']='Votre modèle de ticket a été sauvé pour un usage futur';
$hesklang['ticket_tpl_removed']='Le modèle de ticket sélectionné a été supprimé de la base de données';
$hesklang['ticket_tpl_not_found']='Modèle de ticket non trouvé';
$hesklang['sel_ticket_tpl']='Sélectionnez le modèle de ticket que vous voulez éditer';
$hesklang['ent_ticket_tpl_title']='Veuillez entrer le titre du modèle';
$hesklang['ent_ticket_tpl_msg']='Veuillez entrer le message du modèle';
$hesklang['ticket_tpl_id']='ID du modèle de ticket manquant';
$hesklang['select_ticket_tpl']='Sélectionnez un modèle de ticket';
$hesklang['list_tickets_cat']='Lister tous les tickets dans cette catégorie';
$hesklang['def_msg']='[Pas de message]';
$hesklang['emlreqmsg']='Message requis';
$hesklang['emlreqmsg2']='Ignorer les emails piped/fetched sans message';
$hesklang['relart']='Articles en rapport'; // Title of related articles box
$hesklang['s_relart']='Articles en rapport'; // On settings page
$hesklang['tab_7']='Liste des tickets';
$hesklang['fitl']='Champs dans la liste des tickets';
$hesklang['submitted']='Soumis';
$hesklang['clickemail']='Voir';
$hesklang['set_pri_to']='Définir la priorité :'; // Action below the ticket list
$hesklang['pri_set_to']='Priorité définie à :';
$hesklang['cat_pri']='La priorité de la catégorie sera utilisée quand les utilisateurs ne sont pas autorisés à sélectionner la priorité et quand un ticket est soumis dans l\'interface utilisateur.';
$hesklang['cat_pri_info']='Vos utilisateurs sont autorisés à sélectionner une priorité, la priorité de la catégorie sera donc ignorée.<br /><br />Pour utiliser la priorité de la catégorie, désactivez la fonctionnalité suivante dans les paramétrages de HESK :';
$hesklang['def_pri']='Priorité de la catégorie :';
$hesklang['ch_cat_pri']='Définir la priorité de la catégorie';
$hesklang['cat_pri_ch']='La priorité de la catégorie est définie à :';
$hesklang['err_dbversion']='Version de MySql trop ancienne :';
$hesklang['ip_whois']='IP whois';
$hesklang['ednote']='Editer le message de la note';
$hesklang['ednote2']='Message de la note enregistré';
$hesklang['perm_deny']='Permission refusée';
$hesklang['mis_note']='ID de la note manquante';
$hesklang['no_note']='ID de cette note non trouvé';
$hesklang['sacl']='Enregistrer et continuer plus tard';
$hesklang['reply_saved']='Votre message de réponse a été enregistré pour un usage ultérieur.';
$hesklang['submit_as']='Soumettre en tant que :';
$hesklang['sasc']='Soumettre en tant que réponse utilisateur';
$hesklang['creb']='Réponse utilisateur saisie par :';
$hesklang['show_select']='Afficher &quot;Cliquer pour sélectionner&quot; comme option par défaut';
// Settings
$hesklang['mms']='Mode maintenance';
$hesklang['mmd']='Activer le mode maintenance';
// Customer notice
$hesklang['mm1']='Maintenance en cours';
$hesklang['mm2']='Pour pouvoir mettre en oeuvre la maintenance planifiée, l\'outil de support a été désactivé temporairement.';
$hesklang['mm3']='Veuillez nous excuser pour les désagréments et réessayer plus tard.';
// Staff notice
$hesklang['mma1']='Mode maintenance actif !';
$hesklang['mma2']='Les utilisateurs ne sont pas autorisés à utiliser l\'outil de support.';
$hesklang['tools']='Outils';
$hesklang['banemail']='Emails bannis';
$hesklang['banemail_intro']='Empêcher certaines adresses e-mail de soumettre des tickets à l\'outil de support.';
$hesklang['no_banemails']='<i>Aucun E-mails bannis.</i>';
$hesklang['eperm']='E-mails bannis de façon permanente :';
$hesklang['bananemail']='Adresse E-mail à bannir';
$hesklang['savebanemail']='Bannir cet E-mail';
$hesklang['enterbanemail']='Entrer l\'adresse E-mail que vous souhaitez bannir.';
$hesklang['validbanemail']='Entrer une adresse E-mail valide (<i>martin.dupont@domaine.com</i>) ou un domaine (<i>@domaine.com</i>)';
$hesklang['email_banned']='L\'adresse E-mail <i>%s</i> a été bannie et HESK n\'acceptera plus de tickets avec cette adresse'; // %s will be replaced with email
$hesklang['emailbanexists']='L\'adresse E-mail <i>%s</i> est déjà bannie.'; // %s will be replaced with email
$hesklang['email_unbanned']='Adresse E-mail bannie supprimée';
$hesklang['banby']='Banni par';
$hesklang['delban']='Supprimer le bannissement';
$hesklang['delban_confirm']='Effacer ce bannissement ?';
$hesklang['baned_e']='Vous avez été banni et ne pouvez plus soumettre de nouveaux tickets au support.';
$hesklang['baned_ip']='Vous avez été banni de cet outil de support';
$hesklang['can_ban_emails']='Peut bannir des adresses E-mails';
$hesklang['can_unban_emails']='Peut réactiver des adresses E-mail bannies ';
$hesklang['eisban']='Cette adresse E-mail est bannie.';
$hesklang['click_unban']='Cliquer ici pour supprimer le banissement.';
$hesklang['banip']='IP bannies';
$hesklang['banip_intro']='Les visiteurs provenant d\'adresses IP bannies ne pourront pas voir ou soumettre de tickets ni se connecter au Logicile de Support.';
$hesklang['ipperm']='IP bannies en permanence :';
$hesklang['iptemp']='Echecs de connexion bannis :';
$hesklang['savebanip']='Bannir cette IP';
$hesklang['no_banips']='<i>Aucune adresse IP bannie.</i>';
$hesklang['bananip']='Adresse IP à bannir';
$hesklang['banex']='Exemples :';
$hesklang['iprange']='Etendue d\'adresses IP';
$hesklang['ippermban']='Bannir cette IP en permanence';
$hesklang['enterbanip']='Entrer l\'adresse IP ou une plage IP à bannir.';
$hesklang['validbanip']='Entrer une adresse IP valide ou une plage d\'adresses IP';
$hesklang['ip_banned']='L\'adresse IP <i>%s</i> a été bannie et HESK n\'acceptera plus de tickets de cette adresse.'; // %s will be replaced with IP
$hesklang['ip_rbanned']='L\'étendue d\'adresses IP <i>%s</i> a été bannie et HESK n\'acceptera plus de tickets de cette étendue.'; // %s will be replaced with IP
$hesklang['ipbanexists']='L\'adresse IP <i>%s</i> est déjà bannie.'; // %s will be replaced with IP
$hesklang['iprbanexists']='la Plage d\'adresses IP <i>%s</i> est déjà bannie.'; // %s will be replaced with IP
$hesklang['ip_unbanned']='IP bannie supprimée';
$hesklang['ip_tempun']='Bannissement temporaire adresse IP supprimé';
$hesklang['can_ban_ips']='Peut bannir des adresses IP';
$hesklang['can_unban_ips']='Peut effacer bannissement IP';
$hesklang['ipisban']='Cette adresse IP est bannie.';
$hesklang['m2e']='Expire dans (minutes)';
$hesklang['info']='Info';
$hesklang['sm_title']='Messages de service';
$hesklang['sm_intro']='Afficher un message de service dans l\'espace utilisateur, par exemple pour lui notifier des problèmes connus et des informations importantes.';
$hesklang['can_service_msg']='Editer les messages de service';
$hesklang['new_sm']='Nouveau message de service';
$hesklang['edit_sm']='Editer message de service';
$hesklang['ex_sm']='Messages de service existants';
$hesklang['sm_author']='Auteur';
$hesklang['sm_type']='Type';
$hesklang['sm_published']='Publié';
$hesklang['sm_draft']='Brouillon';
$hesklang['sm_style']='Style';
$hesklang['sm_none']='Aucun';
$hesklang['sm_success']='Succès';
$hesklang['sm_info']='Info';
$hesklang['sm_notice']='Notice';
$hesklang['sm_error']='Erreur';
$hesklang['sm_save']='Enregistrer message de service';
$hesklang['sm_preview']='Prévisualiser message de service';
$hesklang['sm_mtitle']='Titre';
$hesklang['sm_msg']='Message';
$hesklang['sm_e_title']='Entrer le titre du message de service';
$hesklang['sm_e_msg']='Entrer le message de service';
$hesklang['sm_e_id']='ID du message manquant';
$hesklang['sm_added']='Un nouveau message de service a été ajouté';
$hesklang['sm_deleted']='Message de setrvice supprimé';
$hesklang['sm_not_found']='Ce message de service n\'existe pas';
$hesklang['no_sm']='Aucun message de service';
$hesklang['del_sm']='Supprimer ce message de service ?';
$hesklang['sm_mdf']='Message de service enregistré';
$hesklang['sska']='Afficher les articles suggérés';
$hesklang['taws']='Ces articles ont été suggérés :';
$hesklang['defaults']='Par défaut';
$hesklang['pncn']='Sélectionner l\'option Notifier l\'utilisateur dans le formulaire nouveau ticket';
$hesklang['pncr']='Sélectionner l\'option Notifier l\'utilisateur dans le formulaire de réponse à un ticket';
$hesklang['pssy']='Afficher quels articles de la base de connaissance ont été suggérés à l\'utilisateur';
$hesklang['ccct']='Résolu par l\'utilisateur';
$hesklang['custnot']='Notifier les utilisateurs quand';
$hesklang['notnew']='Un nouveau ticket de support est soumis';
$hesklang['notclo']='Un ticket de support est marqué comme résolu';
$hesklang['enn']='Sauf le remplissage pour les E-mails si le sujet de l\'email contient :';
$hesklang['spamn']='Notice SPAM';
$hesklang['spam_inbox']='<span style="color:red"><b>Pas d\'E-mail de confirmation ?</b><br />Nous avons envoyé un message de confirmation à votre adresse E-mail. Si vous ne le recevez pas d\'ici quelques minutes, vérifiez votre dossier de spams. Marquez le message comme <b>Non SPAM</b> pour éviter les problèmes lors de la réception de nos prochains messages.</span>';
$hesklang['ekb_n']='<b>NON</b>, désactiver base de connaissance';
$hesklang['ekb_y']='<b>OUI</b>, autoriser base de connaissance';
$hesklang['ekb_o']='<b>OUI</b>, utiliser HESK comme base de connaissance seule (<i>désactive l\'outil de support</i>)';
$hesklang['kb_set']='Paramétres de la base de connaissance';
$hesklang['kbo1']='Mode base de connaissance seule';
$hesklang['kbo2']='<br /><br />Les visiteurs ne peuvent pas soumettre de nouveaux tickets et sont dirigés directement vers la base de connaissance.';
$hesklang['fpass']='Mot de passe oublié ?';
$hesklang['passr']='Réinitialiser le mot de passe';
$hesklang['passa']='Autoriser les Utilisateurs à réinitialiser un Mot de Passe perdu par E-mail';
$hesklang['passe']='Entrez votre adresse E-mail';
$hesklang['passs']='Envoyez-moi un lien de réinitialisation du mot de passe';
$hesklang['noace']='Aucun compte avec cette adresse E-mail n\'a été trouvé';
$hesklang['pemls']='Nous vous avons envoyé un E-mail avec les instructions pour réinitialiser votre Mot de Passe';
$hesklang['reset_password']='Réinitiliser votre Mot de Passe'; // Email subject
$hesklang['ehash']='Lien de réinitialisation de mot de passe invalide ou arrivé à expiration';
$hesklang['ehaip']='Mauvaise adresse IP. Les Mots de Passe peuvent seulement être réinitialisés à partir de l\'adresse IP qui a effectué la demande de réinitialisation.';
$hesklang['resim']='<b>Entrez votre nouveau Mot de Passe dans le formulaire ci-dessous !</b>';
$hesklang['permissions']='Permissions';
$hesklang['atype']='Type de compte';
$hesklang['astaff']='&Eacute;quipe Support';
$hesklang['oon1']='Envoyez-moi seulement les Tickets d\'Assistance ouverts';
$hesklang['oon2']='Envoyez-moi tous mes Tickets d\'Assistance ';
$hesklang['anyown']='N\'importe quel propriétaire';
$hesklang['pfr']='Une autre tâche de remplissage POP3 est en cours.';
$hesklang['pjt']='Dépassement de délai pour la tâche';
$hesklang['pjt2']='minutes après le démarrage';
$hesklang['nkba']='La recherche dans la base de connaissance nécessite suffisament d\'articles uniques pour fonctionner correctement.<br /><br />Veuillez créer de nouveaux articles pour améliorer les réusultats de la recherche et les suggestions d\'articles.';
$hesklang['saa']='Les articles épinglés sont affichés en haut de la liste des articles';
$hesklang['yhbr']='Vous avez été bloqué par le Logiciel pendant %s minutes car vous avez posté trop de réponses à un ticket.';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='fr';

// Added in version 2.7.0
$hesklang['imap']='Relève IMAP';
$hesklang['imaph']='Hote IMAP';
$hesklang['imapp']='Port IMAP';
$hesklang['enc']='Chiffrement';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='Aucun';
$hesklang['imapu']='Utilisateur IMAP';
$hesklang['imapw']='Mot de Passe IMAP';
$hesklang['imaptest']='Tester connexion IMAP';
$hesklang['ifd']='[HESK] LA RECHERCHEC IMAP EST DESACTIVE&Eacute; DANS LES PARAM&Egrave;TRES';
$hesklang['iei']='[HESK] l\'extension PHP IMAP n\'est pas installée.';
$hesklang['ifr']='Une autre tâche d\'alimentation IMAP est toujours en cours.';
$hesklang['arp']='Recharger page automatiquement';
$hesklang['arpp']='Recharger automatiquement la page liste des tickets tous les :';
$hesklang['seconds']='Secondes';
$hesklang['minutes']='Minutes';
$hesklang['atbr']='Ce ticket nécessite d\'être assigné à un Technicien avant de pouvoir y répondre.';
$hesklang['attm']='M\'assigner ce ticket';
$hesklang['owneed']='Technicien requis';
$hesklang['taat']='Ce ticket est déjà assigné à <b>%s</b>.';
$hesklang['scoy']='&Ecirc;tes-vous sur de vouloir l\'assigner à vous-même ?';
$hesklang['scot']='&Ecirc;tes-vous sur de vouloir l\'assigner à %s?';
$hesklang['ycto']='OUI, changer le Technicien';
$hesklang['ncto']='NON, garder le Technicien actuel';
$hesklang['fass']='Technicien requis';
$hesklang['req_sub']='Requiert un sujet';
$hesklang['req_msg']='Requiert un message';
$hesklang['req_email']='Requiert une adresse E-mail';
$hesklang['default_subject']='Ticket de %s';
$hesklang['off-hide']='Cacher dans le formulaire personnalisé';
$hesklang['not_valid_email']='Entrer une adresse E-mail valide ou laisser ce champ vide';
$hesklang['write_down']='<span style="color:red">Nous vous recommandons d\'écrire l\'identifiant de votre ticket pour le retrouver plus tard.</span>';
$hesklang['re_confirm1']='Désactiver ceci désactivera aussi "Requiert une adresse E-mail pour voir les tickets" dan "Securité". Continuer ?';
$hesklang['re_confirm2']='Autoriser ceci autorisera aussi "Nécessite une adresse E-mail" sous "Fonctionnalités". Continuer ?';
$hesklang['can_email_tpl']='Modifier les Modèles d\'E-mail';
$hesklang['et_title']='Modèles d\'E-mail';
$hesklang['et_intro']='Modifier les E-mails qui sont envoyés à votre équipe et vos utilisateurs';
$hesklang['file']='Fichier';
$hesklang['efile']='&Eacute;diter le Fichier';
$hesklang['rdesc']='(Destinataire) Description';
$hesklang['desc_forgot_ticket_id']='(Utilisateur) ID du Ticket Perdue';
$hesklang['desc_new_reply_by_staff']='(Utilisateur) Nouvelle réponse du Support';
$hesklang['desc_new_ticket']='(Utilisateur) Ticket reçu';
$hesklang['desc_ticket_closed']='(Utilisateur) Ticket fermé/résolu';
$hesklang['desc_category_moved']='(Support) Ticket déplacé dans une nouvelle catégorie';
$hesklang['desc_new_reply_by_customer']='(Support) Nouvelle réponse de l\'utilisateur';
$hesklang['desc_new_ticket_staff']='(Support) Nouveau ticket déposé';
$hesklang['desc_ticket_assigned_to_you']='(Support) Un ticket vous est assigné';
$hesklang['desc_new_pm']='(Support) Nouveau Message Privé';
$hesklang['desc_new_note']='(Support) Nouvelle note sur un ticket qui vous est assigné';
$hesklang['desc_reset_password']='(Support) Réinitialiser votre mot de passe';
$hesklang['etfm']='Il manque un ou plusieurs modèles d\'e-mail.<br /><br />Assurez-vous que tous les modèles d\'E-mail sont présents dans le dossier <i>/language/%s/emails</i>.';
$hesklang['etfw']='Certains modèles d\'E-mail n\'ont pas les droits en écriture.<br /><br />
					Assurez-vous que PHP ait les permissions en écriture pour tous les fichiers dans le dossier <i>/language/%s/emails</i>.<br /><br />
					Sur les serveurs Unix vous pouvez avoir besoin d\'utiliser CHMOD pour les modèles d\'E-mails en 666 (rw-rw-rw-)';
$hesklang['et_e_id']='ID manquant pour le modèle';
$hesklang['et_fm']='Ce fichier de modèle d\'Email est manquant';
$hesklang['et_fw']='Ce fichier de modèle d\'E-mail n\'est pas autorisé en écriture';
$hesklang['et_save']='Enregistrer le modèle d\'E-mail';
$hesklang['updated_on']='Mis à jour le';
$hesklang['ticket_url']='Ticket URL';
$hesklang['pm_url']='URL de message privé';
$hesklang['et_num']='Nombre de Tickets';
$hesklang['et_list']='Liste des Tickets du Support';
$hesklang['et_empty']='Le modèle d\'E-mail ne peut pas être vide';
$hesklang['et_saved']='Modèle d\'E-mail enregistré';
$hesklang['source']='Source';
$hesklang['select_category']='Choisir une Catégorie';
$hesklang['select_category_text']='<strong>Sélectionnez une Catégorie pour votre demande d\'Assistance</strong>';
$hesklang['select_category_staff']='Sélectionner la Catégorie du Ticket';
$hesklang['scat']='Limite affichage Catégories';
$hesklang['scat2']='(une liste déroulante s\'affichera si le nombre de catégories est supérieur)';
$hesklang['new_cf']='Nouveau Champ Personnalisé';
$hesklang['cf_intro']='Utilisez cette fonctionnalité pour ajouter des champs personnalisés au formulaire de dépôt de ticket, vous pourrez ainsi collecter d\'autres informations sur vos utilisateurs.';
$hesklang['cf_public']='Public';
$hesklang['cf_private']='Seulement Equipe Support';
$hesklang['cf_cust']='Pour les Utilisateurs';
$hesklang['cf_all']='Tous';
$hesklang['cf_cat']='Sélectionné';
$hesklang['cf_ctrl']='Astuce : maintenir enfoncée la touche CTRL pour sélectionner plusieurs catégories';
$hesklang['visibility']='Visibilité';
$hesklang['cf_save']='Enregistrer les Modifications';
$hesklang['ex_cf']='Champs Personnalisés Actifs';
$hesklang['no_cf']='Pas de Champs Personnalisés Actifs';
$hesklang['del_cf']='Supprimer ce champ personnalisé ? Cela supprimera aussi toutes les données enregistrées dans la base de données pour ce champ !';
$hesklang['cf_e_id']='ID Invalide';
$hesklang['edit_cf']='Modifier le Champ Personnalisé';
$hesklang['cf_deleted']='Champ Personnalisé Supprimé';
$hesklang['cf_not_found']='Ce champ Personnalisé n\'existe pas';
$hesklang['cf_added']='Un nouveau champ personnalisé a été ajouté';
$hesklang['cf_nocat']='Sélectionnez au moins une catégorie pour ce champ personnalisé';
$hesklang['cf_mdf']='Le champ personnalisé a été enregistré';
$hesklang['atl1']='Entrer au moins une option.';
$hesklang['sch']='Caché';
$hesklang['meml3']='Autoriser la saisie de plusieurs adresses E-email';
$hesklang['dmin']='Date minimum acceptée';
$hesklang['dmax']='Date maximum acceptée';
$hesklang['d_day']='jours(s)';
$hesklang['d_week']='semaine(s)';
$hesklang['d_month']='mois(s)';
$hesklang['d_year']='année(s)';
$hesklang['d_any']='N\'importe quelle date';
$hesklang['d_fixed']='Date fixe';
$hesklang['d_relative']='Date relative';
$hesklang['d_mm']='La date minimum ne peut pas être supérieure à la date maximum';
$hesklang['d_emin']='La date minimum pour <i>%s</i> est %s';
$hesklang['d_emax']='La date maximum pour <i>%s</i> est %s';
$hesklang['d_format']='Format d\'affichage de date';
$hesklang['d_custom']='Format personnalisé';
$hesklang['d_ci']='ADMINISTRATION : format de date PHP valide, voir le manuel PHP.';
$hesklang['cf_noe']='Saisir une adresse E-mail valide dans <i>%s</i>';
$hesklang['cf_noem']='Saisir une ou plusieurs adresses E-mail valide dans <i>%s</i>';
$hesklang['can_resolve']='Peut Résoudre un Ticket';
$hesklang['can_change_own_cat']='Changer un Ticket de catégorie(membre autorisé)';
$hesklang['can_submit_any_cat']='Peut soumettre un ticket dans n\'importe quelle catégorie';
$hesklang['noauth_submit']='Vous n\'êtes pas autorisé à soumettre des tickets dans cette catégorie !';
$hesklang['noauth_move']='Vous n\'êtes pas autorisé à déplacer des tickets dans cette catégorie !';
$hesklang['noauth_resolve']='Vous n\'êtes pas autorisé à résoudre des tickets !';
$hesklang['force_ssl']='Forcer connections SSL';
$hesklang['d_ssl']='<i>disabled</i> - ouvrir cette page avec https:// pour gérer cette option';
$hesklang['scno']='Ce statut ne peut pas être changé';
$hesklang['statuses']='Statuts';
$hesklang['statuses_intro']='Utilisez cet outil pour ajouter des statuts personnalisés à vos Tickets';
$hesklang['color']='Couleur';
$hesklang['csscl']='Classe CSS ou Couleur';
$hesklang['clr_view']='Prévisualisation de la couleur sur du texte';
$hesklang['cbc']='Modifiable par les Utilisateurs';
$hesklang['ccc']='Les Utilisateurs peuvent-ils changer ce statut ?';
$hesklang['del_status']='Supprimer ce statut ?';
$hesklang['ex_status']='Statuts existants';
$hesklang['status_hesk']='Statuts prédéfinis (ne peuvent pas être modifiés ici)';
$hesklang['status_custom']='Statuts Personnalisés';
$hesklang['status_custom_none']='Pas de statuts personnalisés. Vous pouvez en ajouter en utilisant le formulaire ci-dessus.';
$hesklang['status_save']='Enregistrer statut';
$hesklang['list_tkt_status']='Lister tous les Tickets avec ce statut';
$hesklang['new_status']='Nouveau statut personnalisé';
$hesklang['edit_status']='Modifier statut personnalisé';
$hesklang['err_status']='Entrer le nom du statut';
$hesklang['status_added']='Un nouveau statut personnalisé a été ajouté';
$hesklang['status_e_id']='ID Invalide';
$hesklang['status_mdf']='Le statut personnalisé a été enregistré';
$hesklang['status_deleted']='Statut personnalisé supprimé';
$hesklang['status_not_found']='Ce statut personnalisé n\'existe pas';
$hesklang['status_not_empty']='Ce statut ne peut pas être supprimé car il existe des tickets avec ce statut';
$hesklang['status_limit']='Vous avez créé 100 statuts personnalisés, vous ne pouvez plus en ajouter.';
$hesklang['public_link']='Lien public';
$hesklang['frames']='Frames';
$hesklang['frames2']='Empêcher le Logiciel de se charger dans des Frames dans des domaines tiers';
$hesklang['numsub']='Tickets soumis';
$hesklang['hidf']='Les champs cachés ne sont pas visibles par les utilisateurs sur le formulaire
					de soumission de ticket (la valeur restera cependant visible dans les détails de la page
					s\'ils sont déclarés comme public). Ils se comportent comme des champs de type texte normaux
					pour les membres du support.';
$hesklang['rcheck']='Ne pas choisir d\'option par défaut';
$hesklang['refresh_page']='<strong>Rafraîchir cette Page</strong>';
$hesklang['del_kba']='Supprimer cet Article';
$hesklang['del_kbaa']='Supprimer cet article de manière permanente';
$hesklang['hni1']='Logiciel pas encore installé ?';
$hesklang['hni2']='Il semble que cette copie de ce Logiciel ne soit pas bien installée ou pas encore configurée.';
$hesklang['hni3']='Pour installer le Logiciel, suivre <a href="docs/">les instructions dans la documentation</a>';
$hesklang['cf']='Répertoire du cache';
$hesklang['e_cdir']='Le Logiciel ne sera pas capable d\'analyser les e-mails ou le cache si les résultats du cache à moins que le cache existe et qu\'il soit autorisé en écriture.';
$hesklang['step1']='&Eacute;tape 1';
$hesklang['step2']='&Eacute;tape 2';
$hesklang['dffs']='Quand le téléchargement est terminé, supprimez ce fichier du serveur';
$hesklang['fd']='Fichier d\'export supprimé du serveur';

// Added in version 2.8.0
$hesklang['TZ']='Fuseau Horaire';
$hesklang['thist17']='<li class="smaller">%s | soumis par collecte IMAP</li>';
$hesklang['sir3']='reCAPTCHA Invisible';
$hesklang['invisible']='invisible';
$hesklang['imap_not']='PHP n\'est pas compil&eacute; avec le support IMAP';
$hesklang['imap_warning']='L\'utilisateur %1$s a la m&ecirc;me adresse e-mail que votre adresse e-mail IMAP : %2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='L\'utilisateur %1$s a la m&ecirc;me adresse e-mail que votre adresse e-mail POP3 : %2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='Cela peut entraîner une boucle d\'e-mail dans laquelle de nouveaux tickets sont cr&eacute;&eacute;s à partir des notifications par e-mail des utilisateurs. Votre adresse &Eacute;lectronique de r&eacute;cup&eacute;ration doit &ecirc;tre unique et ne doit &ecirc;tre utilis&eacute;e par personne d\'autre.';
$hesklang['can_view_ass_by']='Peut voir les Tickets attribu&eacute;s à d\'autres Techniciens';
$hesklang['can_privacy']='Peut rendre anonyme les Tickets';
$hesklang['confirm_anony']='Rendre Anonyme ce Ticket';
$hesklang['anon_selected']='Rendre Anonyme les Tickets s&eacute;lectionn&eacute;s';
$hesklang['privacy_anon_info']='Supprimez toutes les donn&eacute;es personnelles et le contenu des tickets (nom du client, email, message, pièces jointes, IP ...), mais gardez des tickets dans la base de donn&eacute;es pour les statistiques (droit à l\'oubli).';
$hesklang['success_anon']='Ticket rendu Anonyme avec succès';
$hesklang['num_tickets_anon']='Nombre de Tickets Anonymis&eacute;s : <b>%d</b>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Customer]'; // Customer name in anonymized tickets
$hesklang['anon_email']='[Email]'; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Subject]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Message]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class="smaller">%s | Anonymis&eacute; par %s</li>';
$hesklang['print_selected']='Imprimer les tickets S&eacute;lectionn&eacute;s';
$hesklang['with_selected']='S&eacute;lectionner :';
$hesklang['assign_selected']='Attribuer les Tickets s&eacute;lectionn&eacute;s à :';
$hesklang['assign_no']='Aucun propri&eacute;taire s&eacute;lectionn&eacute;, aucun changement effectu&eacute;';
$hesklang['assign_1']='Les Tickets s&eacute;lectionn&eacute;s ont &eacute;t&eacute; d&eacute;finis sur Non Affect&eacute;.';
$hesklang['assign_2']='Le Ticket d\'ID %1$s est d&eacute;fini sur Non Affect&eacute;'; // %1$s = ticket numerical ID
$hesklang['assign_3']='%1$s Erreur : Ticket d&eacute;jà affect&eacute; à %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s Assign&eacute; à %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='%1$s Erreur : %2$s n\'a pas accès à la Cat&eacute;gorie des Tickets'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='R&eacute;sultat d\'assignation de ticket en bloc : <br /><br /> Attribu&eacute; : %1$s<br /> Erreurs : %2$s<br /><br /> Journal : <br /> <pre>%3$s</pre>'; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='Adresse IP';
$hesklang['moret']='Plus d\'Options'; // More options button title
$hesklang['btn_more']='Plus'; // More options button text
$hesklang['btn_print']='Imprimer';
$hesklang['btn_edit']='Éditer';
$hesklang['btn_lock']='Verrouiller le Ticket';
$hesklang['btn_unlock']='D&eacute;verrouiller le Ticket';
$hesklang['btn_tag']='Pointer le Ticket';
$hesklang['btn_resend']='Renvoyer une Notification par E-mail';
$hesklang['btn_untag']='D&eacute;pointer Ticket';
$hesklang['btn_import_kb']='Importer dans la Base de Connaissances';
$hesklang['btn_anony']='Anonymiser un Ticket';
$hesklang['btn_delt']='Supprimer le Ticket';
$hesklang['btn_delr']='Supprimer la R&eacute;ponse';
$hesklang['ernf']='R&eacute;ponse non trouv&eacute;e';
$hesklang['tns']='Les notifications de Tickets ont &eacute;t&eacute; envoy&eacute;es à nouveau';
$hesklang['rns']='Les notifications de r&eacute;ponse ont &eacute;t&eacute; envoy&eacute;es à nouveau';
$hesklang['fname']='Pr&eacute;nom';
$hesklang['export_selected']='Exporter les tickets s&eacute;lectionn&eacute;s';
$hesklang['btn_export']='Exporter vers XML pour Excel';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='Réponses';
$hesklang['team']='Équipe';
$hesklang['sm_content']='Contenu';
$hesklang['sm_settings']='Paramètres';
$hesklang['wizard_back']='Retour'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Suivant'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Vers les paramètres';
$hesklang['sm_return_to_editing']='Retour à l\'édition';
$hesklang['email_tpl_title']='Titre';
$hesklang['edit_email_template']='Editer le modèle d\'émail';
$hesklang['err_no_settings_section']='Aucun paramètre n\'a été saisi.';
$hesklang['this_field_is_required']='Champs obligatoire';
$hesklang['reset_your_password']='Réinitialiser votre mot de passe';
$hesklang['reset_password_instructions']='Merci de remplir le formulaire ci-dessous. Un lien de réinitialisation de mot de passe vous sera envoyé.';
$hesklang['enter_email']='saisissez votre émail';
$hesklang['password_reset_check_your_email']='Ressaissez votre émail';
$hesklang['password_reset_link_sent']='Nous vous envoyons un lien de réinitialisation de votre mot de passe.';
$hesklang['back_to_login']='Retour au login';
$hesklang['pager_first']='Première page';
$hesklang['pager_previous']='Précédente';
$hesklang['pager_next']='Suivante';
$hesklang['pager_last']='Dernière';
$hesklang['new_team_member']='Nouveau membre du Team';
$hesklang['role']='Rôle';
$hesklang['optional']='Facultatif';
$hesklang['edit_profile']='Modifier le profile';
$hesklang['assigned_to']='Assigné à';
$hesklang['contact']='Contact';
$hesklang['unban_email']='Autoriser cet email';
$hesklang['unban_ip']='Autoriser cette IP';
$hesklang['show_previous_replies']='Voir les réponses précédentes';
$hesklang['type_your_message']='Saississez votre message'; // Used when there are no canned responses
$hesklang['close_button_text']='Fermer';
$hesklang['create_new_ticket']='Créer un nouveau ticket';
$hesklang['delete_article']='Supprimer l\'article';
$hesklang['view_existing_tickets']='Voir les articles existants';
$hesklang['how_can_we_help']='Bonjour, comment pouvons-nous vous aider ?';
$hesklang['search_for_articles']='Rechercher des articles';
$hesklang['submit_a_support_request']='Soumettre une demande de support';
$hesklang['verify_header']='SPAM Prévention';
$hesklang['ticket_details']='Détails du ticket';
$hesklang['yes_title_case']='Oui';
$hesklang['no_title_case']='Non';
$hesklang['no_results_found']='Aucun résultat trouvé';
$hesklang['site_theme']='Thème du site';
$hesklang['test_theme_folder']='Test du répertoire thème';
$hesklang['test_theme_folder_description']='Test du dossier thème pour validation. Seuls les thèmes qui passent tous les tests sont installés correctement.';
$hesklang['err_site_theme']='Sélectionner le thème Hesk';
$hesklang['confirm']='Confirmer';
$hesklang['confirm_deletion']='Confirmer la suppression';
$hesklang['confirm_delete_status']='Etes-vous certain de vouloir supprimer ce status personalisé ?';
$hesklang['help_desk']='Help Desk'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.fr.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Affichage de l\'heure';
$hesklang['tdisd']='Date et heure';
$hesklang['tdisa']='Heure (exemple : il y a 5 heures)';
$hesklang['nav_templates']='Modèles'; // Admin panel navigation item
$hesklang['hide_replies']='Cacher les réponses des tickets';
$hesklang['hide_replies_no']='Jamais, toujours montrer toutes les réponses';
$hesklang['hide_replies_yes']='Cacher toutes les réponses sauf la dernière :';
$hesklang['hide_replies_def']='Afficher la dernière réponse du personnel et toute réponse ultérieure du client';
$hesklang['reply_by']='Réponse de'; // Reply by NAME
$hesklang['btt']='Retour en haut de page';
$hesklang['lwidth']='Limiter la largeur du ticket';
$hesklang['lwidtall']='Utiliser toute la largeur disponible';
$hesklang['lwidtpx']='Largeur maximum en pixels :';
// 3-letter days of the week
$hesklang['mon']='Lun';
$hesklang['tue']='Mar';
$hesklang['wed']='Mer';
$hesklang['thu']='Jeu';
$hesklang['fri']='Ven';
$hesklang['sat']='Sam';
$hesklang['sun']='Dim';
$hesklang['clear']='Effacer'; // delete field value
$hesklang['first_day_of_week']='1'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='Au moins une mesure de prévention du SPAM doit être activée !';
$hesklang['modules']='Modules';
$hesklang['modules_demo']='Ce module n\'est actuellement disponible que sur %s'; // %s = Hesk cloud link
$hesklang['see_demo']='Essayez la démo en ligne ici : %s'; // %s = Hesk demo link
$hesklang['statistics']['tab']='Statistiques';
$hesklang['statistics']['intro']='Ce rapport vous donnera un aperçu de l\'utilisation de votre service d\'assistance et des performances de votre personnel.';
$hesklang['statistics']['ntsp']='Pas de tickets dans la période choisie.';
$hesklang['statistics']['pie_title_ro']='Tickets Ouverts vs Résolus';
$hesklang['statistics']['open']='Ouvert';
$hesklang['statistics']['resolved']='Résolu';
$hesklang['statistics']['pie_title_as']='Tickets ouverts : Assigné vs non assigné';
$hesklang['statistics']['ass']='Assigné';
$hesklang['statistics']['unas']='Non assigné';
$hesklang['statistics']['pie_title_au']='Tickets ouverts : Répondus ou sans réponses';
$hesklang['statistics']['answered']='Répondu';
$hesklang['statistics']['unanswered']='Sans réponse';
$hesklang['statistics']['pie_title_so']='Statut des tickets ouverts';
$hesklang['statistics']['retic']='Tickets :';
$hesklang['statistics']['chart_title_md']='Tickets par jour du mois';
$hesklang['statistics']['chart_title_wd']='Tickets par jour de la semaine';
$hesklang['statistics']['chart_title_hd']='Tickets par heure de jour';
$hesklang['statistics']['chart_title_tfr']='Heure de la première réponse du personnel';
$hesklang['statistics']['chart_title_tfrc']='Réponse aux tickets dans un laps de temps';
$hesklang['statistics']['chart_title_ttr']='Délai entre la soumission et la résolution d\'un ticket';
$hesklang['statistics']['chart_title_ttrc']='Tickets résolus dans un laps de temps';
$hesklang['statistics']['chart_title_sr']='Réponses du personnel';
$hesklang['statistics']['chart_title_srt']='Réponses du personnel par ticket';
$hesklang['statistics']['chart_title_srtr']='Réponses du personnel par ticket (tickets résolus uniquement)';
$hesklang['statistics']['chart_title_srt1']='Réponses du personnel par ticket (tickets avec au moins 1 réponse)';
$hesklang['statistics']['ct_30']='30 minutes';
$hesklang['statistics']['ct_1h']='1 heure';
$hesklang['statistics']['ct_2h']='2 heures';
$hesklang['statistics']['ct_4h']='4 heures';
$hesklang['statistics']['ct_1d']='1 journée';
$hesklang['statistics']['ct_2d']='2 journées';
$hesklang['statistics']['ct_3d']='3 journées';
$hesklang['statistics']['ct_1w']='1 semaine';
$hesklang['statistics']['ct_wp']='> 1 semaine';
$hesklang['statistics']['ct_1m']='1 mois';
$hesklang['statistics']['ct_mp']='> 1 mois';
$hesklang['statistics']['axis1']='% de réponses aux tickets';
$hesklang['statistics']['axis2']='% des tickets résolus';
$hesklang['statistics']['axis3']='% de tickets';
$hesklang['statistics']['axis4']='Délai de la première réponse';
$hesklang['statistics']['axis5']='Temps de résolution';
$hesklang['statistics']['axis6']='Nombre de réponses';
$hesklang['statistics']['axis7']='Nombre de tickets';
$hesklang['statistics']['axis8']='Jour de la semaine';
$hesklang['statistics']['axis9']='Heure';
$hesklang['statistics']['axis10']='Jour du mois';
$hesklang['statistics']['tr_0']='Aucune réponse';
$hesklang['statistics']['tr_1']='1 réponse';
$hesklang['statistics']['tr_2']='2 réponses';
$hesklang['statistics']['tr_5']='3-5 réponses';
$hesklang['statistics']['tr_10']='6-10 réponses';
$hesklang['statistics']['tr_99']='> 10 réponses';
$hesklang['statistics']['average']='Moyenne';
$hesklang['statistics']['atfr']='Moyenne d\'heures et de minutes avant la première réponse du personnel :';
$hesklang['statistics']['attr']='Moyenne d\'heures et de minutes pour résoudre un ticket :';
$hesklang['statistics']['about']='environ %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='N/A';
$hesklang['statistics']['trept']='Total des tickets auxquels le personnel a répondu :';
$hesklang['statistics']['trnr']='Total des tickets résolus sans réponse du personnel :';
$hesklang['statistics']['tsr']='Total des réponses du personnel :';
$hesklang['statistics']['tsrt']='Moyenne de réponses du personnel par ticket :';
$hesklang['statistics']['tsro']='Moyenne de réponses du personnel par ticket (tickets avec au moins 1 réponse du personnel) :';
$hesklang['statistics']['tsrc']='Moyenne des réponses du personnel nécessaires pour résoudre un ticket :';
$hesklang['statistics']['tsrr']='Moyenne des réponses du personnel nécessaires pour résoudre un ticket : (tickets avec au moins 1 réponse du personnel):';
$hesklang['sep_1000']='.'; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']=','; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='et bien plus encore...'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] Ticket en retard';
$hesklang['ticket_escalated']='[#%%TRACK_ID%%] TRANSFERE : %%SUBJECT%%';
$hesklang['escalate']['tab']='Transférer'; // Menu link
$hesklang['escalate']['page_title']='Transférer les tickets'; // Page H2 title
$hesklang['escalate']['intro']='Ce module vous aidera à faire remonter les tickets qui ne sont pas traités à temps.';
$hesklang['escalate']['feat1']='Tickets non attribués, non répondus ou résolus dans un délai donné';
$hesklang['escalate']['feat2']='tickets approchant la date déchéance et tickets en retard';
$hesklang['escalate']['feat3']='modifier automatiquement la priorité du ticket, réattribuer un ticket, envoyer une notification par e-mail';
$hesklang['escalate']['feat4']='appliquer les règles en fonction de la catégorie, du propriétaire et du statut du ticket';
$hesklang['escalate']['prefix']='Transféré :'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Règles actives';
$hesklang['escalate']['new']='Nouvelle règle de transfére';
$hesklang['escalate']['no_rules']='Vous avez aucune règle de transfert. Créez-en une en cliquant sur "Nouvelle règle de transfére" bouton ci-dessus.';
$hesklang['escalate']['title']='Titre de la règle';
$hesklang['escalate']['titlet']='Un titre descriptif, par exemple : Réaffecter les tickets sans réponse dans la journée';
$hesklang['escalate']['default_title']='Règle par %1$s'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Déclencheur de règle';
$hesklang['escalate']['trigt']='Définir la condition qui déclenchera (exécutera) cette règle.';
$hesklang['escalate']['hits']='Hits'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Condition'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Action'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='Appliquer à'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']='Supprimer cette règle ?';
$hesklang['escalate']['edit']='Modification de ID de règle de transfére %1$s'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='Un ticket de support est :'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='pas de réponse du personnel';
$hesklang['escalate']['nrepc']='pas de réponse du client';
$hesklang['escalate']['nass']='non assigné';
$hesklang['escalate']['nres']='non résolu';
$hesklang['escalate']['ndue']='la date déchéance approche';
$hesklang['escalate']['odue']='en retard';
$hesklang['escalate']['within']='Dans :';
$hesklang['escalate']['minutes']='minutes';
$hesklang['escalate']['hours']='heures';
$hesklang['escalate']['days']='jours';
$hesklang['escalate']['weeks']='semaines';
$hesklang['escalate']['months']='mois';
$hesklang['escalate']['years']='années';
$hesklang['escalate']['ofs']='de être soumis';
$hesklang['escalate']['resend']='Renvoyer les notifications par e-mail :';
$hesklang['escalate']['force']='Toujours envoyer, ne pas tenir compte des paramètres du personnel';
$hesklang['escalate']['noforce']='Respecter les paramètres de notification du personnel';
$hesklang['escalate']['setpri']='Définir la priorité sur :';
$hesklang['escalate']['setsta']='Définir le statut sur :';
$hesklang['escalate']['assto']='Attribuer le ticket à :';
$hesklang['escalate']['asm']='Un autre membre du personnel';
$hesklang['escalate']['notify']='Notifier les membres du personnel...';
$hesklang['escalate']['ato']='Appliquer à :';
$hesklang['escalate']['tic']='Tickets dans la catégorie :';
$hesklang['escalate']['tat']='Tickets attribués à :';
$hesklang['escalate']['tws']='Tickets avec statut :';
$hesklang['escalate']['tall']='Appliquer cette règle aux tickets existants et futurs';
$hesklang['escalate']['tfn']='Appliquer cette règle aux futurs tickets uniquement, ignorer les tickets existants';
$hesklang['escalate']['tfi']='Appliquez cette règle uniquement aux tickets dont ID est supérieur à :';
$hesklang['escalate']['save']='Enregistrer la règle';
$hesklang['escalate']['e_tt']='Le temps doit être compris entre 1 et 10000';
$hesklang['escalate']['e_a']='Sélectionnez au moins une action à effectuer sur les tickets correspondants';
$hesklang['escalate']['nocat']='Sélectionnez au moins une catégorie';
$hesklang['escalate']['nouser']='Sélectionnez au moins un utilisateur';
$hesklang['escalate']['nostatus']='Sélectionnez au moins un statut';
$hesklang['escalate']['nocata']='%1$s n\'a pas accès à ces catégories :'; // %1$s = user name
$hesklang['escalate']['rule_added']='Une nouvelle règle a été créée';
$hesklang['escalate']['mdf']='Les paramètres des règles ont été enregistrés';
$hesklang['escalate']['e_id']='Aucune règle avec cet ID trouvée';
$hesklang['escalate']['deleted']='La règle sélectionnée a été supprimée';
$hesklang['escalate']['edit_notice']='la modification du déclencheur de la règle aura aucun effet sur les tickets déjà transféré par cette règle (sauf si vous réinitialisez la règle).';
$hesklang['escalate']['reset']='Réinitialiser cette règle';
$hesklang['escalate']['reset2']='Êtes-vous sûr de vouloir réinitialiser cette règle ?<br><br>Les réponses aux règles passeront à 0 et tout ticket correspondant à cette règle sera à nouveau transféré.';
$hesklang['escalate']['reset3']='La règle sélectionnée a été réinitialisée';
$hesklang['escalate']['log_title']='Règle #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class="smaller">%1$s | transféré par %2$s :</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class="smaller">%1$s | - définir la priorité sur %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class="smaller">%1$s | - attribuer à %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class="smaller">%1$s | - envoyer une notification au personnel</li>';
$hesklang['escalate']['thist5']='<li class="smaller">%1$s | - envoyer une notification au personnel (forcée)</li>';
$hesklang['escalate']['thist6']='<li class="smaller">%1$s | - erreur : %2$s n\'a pas accès à la catégorie de ticket</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class="smaller">%1$s | - erreur : %2$s n\'a pas la permission de voir les tickets</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class="smaller">%1$s | - erreur : aucun autre utilisateur ne peut voir ce ticket</li>'; // %1$s = date
$hesklang['escalate']['thist9']='<li class="smaller">%1$s | - avis : priorité déjà définie sur %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class="smaller">%1$s | - avis : déjà attribué à %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class="smaller">%1$s | - notifier : %2$s</li>'; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class="smaller">%1$s | - définir le statut sur %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class="smaller">%1$s | - avis : statut déjà défini sur %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Actif'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Activer cette règle (commencez à utiliser)';
$hesklang['escalate']['activated']='La règle sélectionnée a été activée'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='Désactiver cette règle (arrêter de utiliser)';
$hesklang['escalate']['deactivated']='La règle sélectionnée a été désactivée'; // %1$s = rule log title
$hesklang['escalate']['no_active']='Aucune règle de transfére active';
$hesklang['escalate']['matched']='Nombre de tickets correspondants trouvés : %1$s '; // %1$s = number of tickets
$hesklang['escalate']['tools']='Outils';
$hesklang['escalate']['test']='Simuler cette règle';
$hesklang['escalate']['testa']='Simuler toutes les règles';
$hesklang['escalate']['testaa']='Simuler toutes les règles actives';
$hesklang['escalate']['testr']='Résultats de la simulation';
$hesklang['escalate']['rsim']='Répéter la simulation';
$hesklang['escalate']['tbef']='Avant une règle ne soit active, vous devez activer en cliquant sur la case à cocher dans le champ "ACTIVE" colonne.<br><br>\n                               Nous vous recommandons fortement de <strong>simuler</strong> chaque règle en cliquant sur icône %1$s (Simuler cette règle) dans le tableau des règles\n                               pour voir comment cela affectera vos tickets existants avant de activer.<br><br>\n                               <strong>Les règles actives sont traitées toutes les %2$s minutes. Un ticket ne peut être transféré qu\' une seule fois par chaque règle</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='MODE SIMULATION, aucun changement dans la base de données';
$hesklang['escalate']['sic']='SIMULATION COMPLÈTE';
$hesklang['escalate']['r']='[RULE]';
$hesklang['escalate']['i']='[INFO]';
$hesklang['multopt']='Astuce : maintenez la touche CTRL enfoncée pour sélectionner plusieurs options';
$hesklang['desc_ticket_escalated']='Le ticket (personnel) a été remonté'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Formatage des tickets (personnel)';
$hesklang['ticket_formatting_plaintext']='Texte brut';
$hesklang['ticket_formatting_rich_text']='Texte enrichi (HTML)';
$hesklang['due_date']='Due date';
$hesklang['invalid_due_date']='Une date d\'échéance invalide a été saisie.';
$hesklang['thist19']='<li class="smaller">%s | date déchéance mise à jour à %s par %s</li>'; // %s = date, new due date, user making change
$hesklang['thist20']='<li class="smaller">%s | date déchéance supprimée par %s</li>'; // %s = date, user making change
$hesklang['due_date_updated']='La date d\'échéance du ticket a été mise à jour.';
$hesklang['menu_kb_manage']='Gérer'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='Afficher'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Tout sélectionner';
$hesklang['a_deselect']='Désélectionner tout';
$hesklang['a_toggle']='Tout basculer';
$hesklang['ql_all']='Tous les tickets';
$hesklang['ql_alo']='Tous les tickets ouverts';
$hesklang['ql_fit']='Tickets filtrés';
$hesklang['ql_a2m']='Attribué à moi';
$hesklang['ql_a2o']='Attribués aux autres';
$hesklang['ql_una']='Non attribué';
$hesklang['ql_due']='Dû bientôt';
$hesklang['ql_ovr']='En retard';
$hesklang['set_ds']='Afficher comme "dû bientôt"'; // Settings page (title of setting)
$hesklang['set_ds2']='jours avant la date déchéance';
$hesklang['not_aos']='Certains tickets ouverts auxquels vous avez accès ne sont pas affichés à cause de vos filtres.';
$hesklang['ntoverdue']='Un ticket est en retard avec le propriétaire :';
$hesklang['ovdcron']='pour que les notifications de retard fonctionnent, votre administrateur doit activer une tâche cron.';
$hesklang['instructions']='Instructions';
$hesklang['desc_overdue_ticket']='(Personnel) Ticket en retard';
$hesklang['overdue_starting']='Démarrage du processus de notification des tickets en retard';
$hesklang['overdue_sim']='Envoi de-mails et la mise à jour des tickets sont désactivés en mode SIMULATION.';
$hesklang['overdue_ticket_count']='Trouvé %s tickets en retard.'; // %s = Number of tickets
$hesklang['overdue_finished']='Tickets en retard terminés. %s e-mails envoyés. %s e-mails ont pas pu être envoyés.'; // %s = Successful emails, failed emails
$hesklang['admin_css']='CSS administrateur';
$hesklang['admin_css2']='Charger un fichier de style personnalisé supplémentaire pour le panneau dadministration';
$hesklang['noval_cert']='Ne pas valider les certificats du serveur';
$hesklang['chg_cat']='Cliquez pour changer de catégorie de ticket';
$hesklang['tlan']='Langue du ticket';
$hesklang['uue']='Deux membres du personnel ou plus ont la même adresse e-mail. Nous vous recommandons de définir une adresse e-mail unique pour chaque utilisateur.';
$hesklang['flood']='Limite dinondation';
$hesklang['e_flood']='Ooops, vous avez déjà envoyé une réponse récemment. Nous avons arrêté cette requête pour éviter inondation de réponses.';
$hesklang['cookies']='Cookies';
$hesklang['ukey']='Clé accès URL'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='Générer une clé daccès URL aléatoire';
$hesklang['ukeym']='Erreur : pour exécuter ce fichier via HTTP, vous devez inclure votre clé daccès URL dans la requête. Exemple :';
$hesklang['ukeyw']='Erreur : clé daccès URL incorrecte';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Ticket reçu : %%SUBJECT%%';
$hesklang['mfa_verification']='%%VERIFICATION_CODE%% est votre code de vérification';
$hesklang['follow_up_email']='Soyez honnête - comment avons-nous fait ?';
$hesklang['mfa']='Multi-Authentification par facteur (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='MFA Activé ?';
$hesklang['mfa_required']='Exiger une authentification multi-facteurs';
$hesklang['mfa_manage_profile']='Gérer AMF';
$hesklang['mfa_disabled']='L\'authentification multifactorielle est désactivée';
$hesklang['mfa_enabled']='L\'authentification multifactorielle est activée. (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='Aucune';
$hesklang['mfa_method_none_subtext']='Suppression de l\'authentification multifactorielle sur votre compte.';
$hesklang['mfa_method_email']='Email';
$hesklang['mfa_method_email_subtext']='Le service d\'assistance enverra un courriel contenant un code de connexion aléatoire à l\'adresse suivante <strong>%s</strong> lors de l\'ouverture de session.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='Application Authenticator';
$hesklang['mfa_method_auth_app_short']='App';
$hesklang['mfa_method_auth_app_subtext']='Utilisez une application pour smartphone, telle que Free OTP ou Google Authenticator, pour générer un code de connexion aléatoire lors de la connexion..';
$hesklang['mfa_step_method']='Méthode';
$hesklang['mfa_step_verification']='Vérification';
$hesklang['mfa_step_complete']='Complète';
$hesklang['mfa_introduction']='L\'authentification multifactorielle améliore la sécurité du compte en vous demandant de vérifier votre connexion à l\'aide d\'une méthode de vérification supplémentaire, telle que l\'e-mail ou une application d\'authentification (telle que Free OTP ou Google Authenticator)..';
$hesklang['mfa_reset_warning']='Vous avez déjà activé l\'authentification multifactorielle. En effectuant cette opération, vous réinitialiserez votre dispositif d\'authentification multi-factions (s\'il est activé)..';
$hesklang['mfa_select_method_colon']='Sélectionnez une méthode d\'authentification :';
$hesklang['mfa_verification_header']='Vérification - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='Un courriel a été envoyé à <strong>%s</strong> contenant un code de vérification à six chiffres. Entrez le code que vous avez reçu par e-mail ci-dessous pour continuer.'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; Étape 1 : Scannez l\'image ci-dessous avec l\'application d\'authentification multifactorielle sur votre appareil mobile..';
$hesklang['mfa_verification_auth_app_cant_scan']='Vous ne pouvez pas scanner l\'image ? Saisissez manuellement ce code sur votre appareil : <b>%s</b>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; Étape 2 : Saisissez le code à 6 chiffres affiché sur votre application pour vérifier votre appareil..';
$hesklang['mfa_verify']='Vérifié';
$hesklang['mfa_invalid_method']='Une méthode d\'authentification multifactorielle invalide a été reçue..';
$hesklang['mfa_invalid_verification_code']='Le code qui a été saisi est incorrect ou a expiré.';
$hesklang['mfa_configured']='L\'authentification multifactorielle a été activée pour votre compte !';
$hesklang['mfa_removed']='L\'authentification multifactorielle a été désactivée pour votre compte !';
$hesklang['mfa_verification_needed']='L\'authentification multifacteur est activée pour ce compte.';
$hesklang['mfa_verification_needed_email']='Veuillez entrer le code de vérification qui a été envoyé à votre adresse e-mail.';
$hesklang['mfa_verification_needed_auth_app']='Veuillez entrer le code qui s\'affiche sur votre application d\'authentification.';
$hesklang['mfa_verification_code']='Le code de vérification';
$hesklang['mfa_server_time_issue']='L\'heure de votre serveur semble inexacte : %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Réinitialiser l\'authentification multifacteur';
$hesklang['mfa_reset_confirm']='Êtes-vous sûr de vouloir réinitialiser AMF pour cet utilisateur ?';
$hesklang['mfa_reset_yes']='Réinitialiser';
$hesklang['mfa_reset']='L\'authentification multifacteur a été réinitialisée pour l\'utilisateur';
$hesklang['desc_mfa_verification']='(Personnel) Code d\'authentification multifacteur';
$hesklang['mfa_code']='Code :';
$hesklang['mfa_backup_codes_header']='ENREGISTREZ VOS CODES DE SECOURS !';
$hesklang['mfa_backup_codes_description']='Conservez ces codes de sauvegarde dans un endroit sûr mais accessible. Si vous perdez l\'accès à votre appareil AMF ou à votre messagerie électronique, vous pouvez saisir l\'un des codes de secours suivants pour vous connecter.<br><br><strong>Assurez-vous de traiter ces codes de sauvegarde comme des mots de passe. Vous ne pourrez plus revoir ces codes !</strong>';
$hesklang['mfa_verify_another_way']='Vérifiez votre compte d\'une autre manière'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Obtenez un code de vérification à %s';
$hesklang['mfa_verify_another_way_code']='Entrez l\'un de vos codes de secours à 8 caractères';
$hesklang['mfa_verify_another_way_admin']='Contactez l\'administrateur de votre service d\'assistance pour obtenir de l\'aide';
$hesklang['mfa_verify_another_way_reset']='Réinitialisez votre authentification multifacteur en téléchargeant un fichier sur le serveur';
$hesklang['mfa_send_another_email']='Envoyer un autre e-mail';
$hesklang['mfa_sent']='Un e-mail avec un nouveau code de vérification a été envoyé à votre adresse e-mail';
$hesklang['mfa_backup_code']='Code de sauvegarde';
$hesklang['mfa_backup_codes']='Codes de sauvegarde';
$hesklang['mfa_backup_codes_info']='Codes à usage unique pour passer la vérification multifacteur lorsqu\'il est impossible d\'accéder à votre e-mail ou à votre application d\'authentification. Une fois que vous utilisez un code de secours pour vous connecter, ce code devient inactif.';
$hesklang['mfa_backup_codes_num']='Vous pouvez obtenir un nouvel ensemble de 10 codes de secours quand vous le souhaitez. Lorsque vous créez un nouveau jeu de codes, l\'ancien jeu devient automatiquement inactif.';
$hesklang['mfa_backup_codes_num2']='Nombre de vos codes actifs : %s';
$hesklang['mfa_invalid_backup_code']='Le code de secours saisi est incorrect ou a déjà été utilisé.';
$hesklang['mfa_del_codes']='Supprimer mes codes de secours';
$hesklang['mfa_del_codes2']='Tous vos codes de secours ont été supprimés.';
$hesklang['mfa_new_codes']='Générer de nouveaux codes de secours';
$hesklang['mfa_new_codes2']='De nouveaux codes de secours ont été générés';
$hesklang['old_php_version']='Erreur : version PHP non prise en charge';
$hesklang['category_default_due_date']='Date d\'échéance';
$hesklang['category_change_default_due_date']='Régler la date d\'échéance';
$hesklang['category_leave_blank_for_no_default_due_date']='(laisser vide pour aucune date d\'échéance)';
$hesklang['category_default_due_date_updated']='La date d\'échéance à été mise à jour.';
$hesklang['email_formatting']='Formatage des e-mails';
$hesklang['email_formatting_html_and_plaintext']='HTML avec alternative en texte brut à partir d\'un modèle de texte brut (par défaut)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML avec une alternative en texte brut générée à partir d\'un modèle HTML';
$hesklang['email_formatting_html']='HTML uniquement';
$hesklang['email_formatting_plaintext']='Texte brut uniquement';
$hesklang['email_formatting_note']='Votre sélection dans %1$s &gt; %2$s &gt; %3$s est réglée sur : <i>%4$s</i>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='Cela signifie que Hesk ignorera les modèles HTML ici.';
$hesklang['email_formatting_note1']='Cela signifie que Hesk ignorera les modèles de texte brut ici.';
$hesklang['email_formatting_note2']='Cela signifie que Hesk générera une version en texte brut des e-mails à partir de vos modèles HTML et ignorera les modèles en texte brut ici.';
$hesklang['etnu']='Ce modèle d\'e-mail n\'est actuellement pas utilisé par Hesk en raison de votre sélection dans %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='Modifier la catégorie';
$hesklang['create_category']='Créer une catégorie';
$hesklang['one_user_included']='1 utilisateur inclus';
$hesklang['one_user_excluded']='1 user excluded';
$hesklang['x_users_included']='%s utilisateurs inclus'; // %s = Number of users
$hesklang['x_users_excluded']='%s utilisateurs exclus'; // %s = Number of users
$hesklang['aa_cat']='Attribuer automatiquement des tickets dans cette catégorie';
$hesklang['modify_autoassign_settings']='Modifier les paramètres d\'attribution automatique';
$hesklang['autoassign_on_all_users']='Oui, à tout utilisateur ayant accès à cette catégorie';
$hesklang['autoassign_on_select_users']='Oui, à des utilisateurs spécifiques';
$hesklang['autoassign_off']='Non, soumettre des tickets comme non attribués';
$hesklang['autoassign_users']='Utilisateurs à inclure/exclure dans l\'attribution automatique';
$hesklang['autoassign_selected_include']='Les utilisateurs sélectionnés doivent être <strong>inclus</strong> lors de l\'attribution automatique des tickets dans cette catégorie';
$hesklang['autoassign_selected_exclude']='Les utilisateurs sélectionnés doivent être <strong>exclu</strong> lors de l\'attribution automatique des tickets dans cette catégorie';
$hesklang['cat_edited']='La catégorie %s a été modifiée avec succès';
$hesklang['search_for_user']='Rechercher un utilisateur';
$hesklang['email_sending']='Envoyer des emails';
$hesklang['email_to_ticket']='E-mail au ticket';
$hesklang['email_to_ticket_info']='La conversion des e-mails en tickets nécessite une configuration côté serveur. Pour plus de détails, veuillez consulter <a href="%s" target="_blank">ce guide de la base de connaissances (En anglais)</a>.'; // %s = link to article
$hesklang['from_warning2']='Hesk utilise un serveur SMTP pour envoyer des notifications par e-mail. Ton <strong>%1$s</strong> doit être réglé sur <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Extension de fichier manquante';
$hesklang['block_ignore']='E-mail au ticket - Ignorer les e-mails et éviter les boucles';
$hesklang['block_noreply']='Ne pas répondre';
$hesklang['block_noreply2']='Ignorer les e-mails envoyés depuis &quot;ne pas répondre&quot; adresses mail';
$hesklang['block_returned']='Revenu';
$hesklang['block_returned2']='Ignorer les e-mails renvoyés, tels que les notifications d\'état de livraison et les réponses automatiques';
$hesklang['block_duplicate']='Doublons';
$hesklang['block_duplicate2']='Ignorer les e-mails avec le même message envoyé dans &quot;%s&quot; secondes'; // %s = "Timeframe"
$hesklang['loop_info']='e-mails reçus de la même adresse e-mail dans &quot;%s&quot; secondes';
$hesklang['thist21']='<li class="smaller">%s | notification par e-mail de retard envoyée</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | mail de suivi envoyé</li>'; // %s = date
$hesklang['elevator_header']='Entrer dans la zone sécurisée';
$hesklang['elevator_intro']='Vous êtes sur le point d\'entrer dans une zone sécurisée.';
$hesklang['elevator_enter_password']='Veuillez entrer votre mot de passe pour continuer.';
$hesklang['elevator_duration_setting_title']='Durée de la zone sécurisée';
$hesklang['desc_survey']='(Client) E-mail de suivi (enquête)'; // Email description
$hesklang['satisfaction']['tab']='Satisfaction';
$hesklang['satisfaction']['title']='Sondage sur la satisfaction de la clientèle';
$hesklang['satisfaction']['intro']='Envoyez à vos clients une enquête de satisfaction de suivi pour recueillir des commentaires sur leur expérience avec votre service d\'assistance.';
$hesklang['satisfaction']['tab1']='Réglages';
$hesklang['satisfaction']['tab2']='Se désengager';
$hesklang['satisfaction']['enable']='Activer les e-mails de suivi :';
$hesklang['satisfaction']['enabled']='Les enquêtes de satisfaction client sont activées.';
$hesklang['satisfaction']['disabled']='Les enquêtes de satisfaction client sont actuellement désactivées.';
$hesklang['satisfaction']['url']='Adresse URL de l\'enquête :';
$hesklang['satisfaction']['send']='Délai de suivi des e-mails :';
$hesklang['satisfaction']['at_least']='Attendez au moins';
$hesklang['satisfaction']['after']='une fois le ticket résolu avant d\'envoyer l\'e-mail';
$hesklang['satisfaction']['h1']='Comment utiliser cet outil ?';
$hesklang['satisfaction']['h2']='Tout d\'abord, créez une enquête de satisfaction client dans votre outil d\'enquête préféré. Si vous ne savez pas quel outil utiliser ou quelles questions poser, nous avons un <a href="%s" target="_blank">guide disponible ici</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='Lorsque votre enquête est prête, activez les e-mails de suivi à l\'aide du formulaire ci-dessous. Hesk traitera les tickets résolus avec au moins une réponse du personnel une fois par heure et enverra votre lien d\'enquête à vos clients.';
$hesklang['satisfaction']['e_url']='Saisissez une adresse URL de sondage valide. Il s\'agit de l\'URL vers laquelle vos clients seront redirigés.';
$hesklang['satisfaction']['as']='Saisissez une adresse URL de sondage valide. Il s\'agit de l\'URL vers laquelle vos clients seront redirigés.';
$hesklang['satisfaction']['oo1']='Cette page répertorie les adresses e-mail auxquelles les e-mails de suivi ne seront <b>pas</b> à être envoyé.';
$hesklang['satisfaction']['oo2']='Vos clients peuvent refuser de recevoir des e-mails d\'enquête en cliquant sur un lien dans l\'e-mail. Vous pouvez également ajouter manuellement des adresses e-mail sur cette page.';
$hesklang['satisfaction']['ooe']='Adresse e-mail pour se désinscrire';
$hesklang['satisfaction']['ooe2']='Entrez l\'adresse e-mail que vous souhaitez désactiver pour recevoir des e-mails d\'enquête.';
$hesklang['satisfaction']['ooe3']='Cette adresse e-mail <i>%s</i> est déjà désactivé pour recevoir des e-mails d\'enquête.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Désactiver cet e-mail';
$hesklang['satisfaction']['oob']='Désactivé par';
$hesklang['satisfaction']['no_oo']='Aucun client n\'a choisi de ne pas recevoir d\'e-mails d\'enquête.';
$hesklang['satisfaction']['oor']='Retirer';
$hesklang['satisfaction']['oor2']='E-mail supprimé du désengagement';
$hesklang['satisfaction']['oor3']='Confirmer la suppression';
$hesklang['satisfaction']['oor4']='Une fois retiré désengagement, cet utilisateur recevra à nouveau des e-mails de suivi.';
$hesklang['satisfaction']['optedout']='L\'adresse e-mail <i>%s</i> a été désactivé pour recevoir des e-mails d\'enquête.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='ID d\'enquête manquant ou non valide';
$hesklang['satisfaction']['starting']='Démarrage du processus de notification de l\'enquête de satisfaction client';
$hesklang['satisfaction']['tc']='Trouvé %s tickets clôturés sans enquête de satisfaction envoyée.'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Enquête de satisfaction client terminée. E-mails envoyés : %1$s. Les e-mails n\'ont pas pu être envoyés: %2$s. Tickets sans e-mail : %3$s. Tickets avec e-mail de désinscription: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='Ignorez ce client ne souhaite pas recevoir d\'e-mails d\'enquête.';
$hesklang['satisfaction']['ne']='Ignorez ce ticket est sans adresse e-mail';
$hesklang['satisfaction']['feat1']='Créez votre enquête à l\'aide de n\'importe quel outil tiers, tel que Google Forms';
$hesklang['satisfaction']['feat2']='configurez l\'URL, les préférences et les limites de votre enquête dans ce module';
$hesklang['satisfaction']['feat3']='lorsque vous résolvez un ticket, Hesk enverra par e-mail à votre client le lien vers l\'enquête';
$hesklang['dfor']='Format de date';
$hesklang['dtfor']='Date et l\'heure';
$hesklang['cdfor']='Format de sélection de date';
$hesklang['custom']='Personnalisé';
$hesklang['jsc_notice']='La sélection de date ne prend pas en charge le formatage de date de style PHP. Sélectionnez l\'une des options préconfigurées ou cliquez sur l\'icone %s ci-dessous pour voir les options d\'affichage disponibles.'; // %s = replaced by icon
$hesklang['lcf3']='Date uniquement'; // Display: "Date only"
$hesklang['epdd']='Erreur lors de l\'analyse du paramètre de la date d\'échéance :';
$hesklang['edit_pass']='Modifier le mot de passe';
$hesklang['save_pass']='Enregistrer le mot de passe';
$hesklang['cur_pass']='Mot de passe actuel';
$hesklang['cur_pass2']='Vous devez fournir votre mot de passe actuel pour pouvoir le changer.';
$hesklang['cur_pass3']='Après une mise à jour réussie du mot de passe, vous serez redirigé vers la page de connexion, où vous pourrez vous connecter avec votre nouveau mot de passe.';
$hesklang['e_new_pass']='Veuillez entrer votre nouveau mot de passe';
$hesklang['pass_len']='Le mot de passe ne doit pas dépasser 64 caractères';
$hesklang['pass_login']='Veuillez vous reconnecter après avoir changé votre mot de passe';
$hesklang['bf_int']='Vous avez été déconnecté en raison d\'un trop grand nombre de tentatives de vérification infructueuses';
$hesklang['tst_cnt']='Nombre d\'e-mails que votre serveur de messagerie enverra à Hesk : %s'; // %s = number of emails
$hesklang['wrn_imap']='Vous avez de nombreux e-mails non lus dans votre boîte aux lettres (%1$s). Hesk transformera tous ces e-mails en tickets.<br><br>Vous pouvez marquer les e-mails existants comme lus avant d\'activer %2$s ou utilisez un nouveau compte de messagerie pour Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='Vous avez de nombreux e-mails dans votre boîte aux lettres (%1$s). Hesk transformera tous ces e-mails en tickets.<br><br>Vous voudrez peut-être supprimer les e-mails existants avant d\'activer %2$s ou utilisez un nouveau compte de messagerie pour Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='Dû le'; // Due on (date)
$hesklang['search_due_date_range']='Dû en'; // Due in (X days)
$hesklang['attachment_add_files']='Ajouter le fichier';
$hesklang['attachment_max_exceeded']='Ce fichier ne sera pas téléchargé car vous avez déjà téléchargé le nombre maximum de fichiers autorisés.';
$hesklang['attachment_viewer_message']='Faites glisser les fichiers ici ou cliquez sur le bouton \'Ajouter un fichier\' ci-dessous pour sélectionner les fichiers à télécharger.';
$hesklang['attachment_invalid_type_message']='Désolé, mais le type de fichier que vous avez essayé de télécharger n\'est pas autorisé..';
$hesklang['attachment_upload_error']='Une erreur s\'est produite lors de la tentative de téléchargement. Veuillez réessayer plus tard.';
$hesklang['attachment_too_large']='Cette pièce jointe dépasse la taille de fichier maximale autorisée.';
$hesklang['attachment_cancel']='Annuler';
$hesklang['attachment_confirm_cancel']='Voulez-vous vraiment annuler ce téléchargement ?';
$hesklang['attachment_remove']='Supprimer la pièce jointe';
$hesklang['attachment_too_many_uploads']='Trop de pièces jointes ont été téléchargées depuis votre emplacement en peu de temps. Veuillez réessayer votre demande plus tard.';
$hesklang['sub_note']='Soumettre une note';
$hesklang['can_view_users']='Afficher tous les utilisateurs (mais pas les gérer)';
$hesklang['welcome1']='Salut, tu sembles être nouveau ici. Bonjour !';
$hesklang['welcome2']='Pour vous aider à démarrer, consultez le %s.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Guide de démarrage rapide en ligne Hesk';
$hesklang['tmce1']='Utilisez Ctrl + clic droit pour accéder au correcteur orthographique';
$hesklang['tmce2']='Maintenez la touche Contrôle (Ctrl) enfoncée et faites un clic droit sur le mot mal orthographié pour accéder au correcteur orthographique.';
$hesklang['desc_new_ticket_by_staff']='(Client) Nouveau ticket soumis par le personnel';
$hesklang['mod_et_h']='Vous pouvez modifier les modèles d\'e-mail sous %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Définir la langue sur';
$hesklang['ouwa']='Seuls les utilisateurs ayant accès à cette catégorie sont répertoriés ci-dessous. Pour ajouter des membres du personnel à cette catégorie, modifiez leurs autorisations sur la %s page'; // %s = Team
$hesklang['previous_tickets']='Tickets précédents';
$hesklang['no_previous']='Aucun ticket précédent par %s'; // %s = email address
$hesklang['all_previous']='Lister tous les tickets précédents';
$hesklang['confirm_delete_ticket']='Êtes-vous sûr de vouloir supprimer définitivement ce ticket ?';
$hesklang['confirm_delete_reply']='Êtes-vous sûr de vouloir supprimer définitivement cette réponse ?';
$hesklang['select_new_category']='Nombre de tickets dans cette catégorie : %s<br><br>Veuillez sélectionner une nouvelle catégorie pour transférer ces tickets vers:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='Nombre de tickets attribués à cet utilisateur : %1$s<br>Nombre de tickets <b>ouvert</b> attribué à cet utilisateur : %2$s<br><br>Les tickets <b>Ouvert</b> seront <b>Non attribué</b> après avoir supprimé cet utilisateur.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='Licence du logiciel';
$hesklang['hlic_free']='GRATUITE';
$hesklang['hlic_buyl']='Acheter une licence';
$hesklang['hlic_paid']='Activé';
$hesklang['antdemo']='La soumission de tickets depuis le panneau d\'administration a été désactivée en mode démo.<br><br>Veuillez utiliser le <a href="%s" target="_blank">côté public</a> soumettre un ticket de test.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Méthode d\'authentification';
$hesklang['email_authentication_method_username_password']='Basique (Nom d\'utilisateur / Mot de passe)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - Aucun fournisseur OAuth vérifié configuré.';
$hesklang['email_authentication_method_oauth_link']='Gérer les fournisseurs OAuth'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='URL du point d\'autorisation';
$hesklang['email_oauth_token_url']='URL du point de récupération de jeton';
$hesklang['email_oauth_client_id']='ID Client';
$hesklang['email_oauth_client_secret']='Secret Client';
$hesklang['email_oauth_scope']='Portée';
$hesklang['oauth_error_invalid_state']='L\'état OAuth ne correspond pas à l\'état envoyé au fournisseur OAuth.';
$hesklang['oauth_error_unknown']='Une erreur inconnue s\'est produite lors de la tentative de sauvegarde des jetons OAuth.';
$hesklang['oauth_error_no_token']='Jeton d\'accès manquant dans la réponse JSON.';
$hesklang['oauth_error_retrieve']='Impossible de récupérer un jeton d\'accès. Veuillez confirmer les paramètres de votre fournisseur OAuth et les enregistrer à nouveau pour obtenir un nouveau jeton.';
$hesklang['email_oauth_provider']='Fournisseur OAuth';
$hesklang['email_oauth_providers']='Fournisseurs OAuth';
$hesklang['email_oauth_provider_guide']='Avant d\'utiliser OAuth, vous devez enregistrer un fournisseur OAuth. Pour plus de détails, veuillez consulter <a href="%s" target="_blank">ce guide de la base de connaissances</a>.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='Votre URI de redirection OAuth pour Hesk est :<br><i>%s</i>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Utilisez cet outil pour ajouter des fournisseurs OAuth à votre service d\'assistance';
$hesklang['email_oauth_provider_name']='Nom'; // OAuth provider name
$hesklang['email_oauth_new_provider']='Nouveau fournisseur';
$hesklang['email_oauth_edit_provider']='Modifier le fournisseur';
$hesklang['email_oauth_provider_being_used_for']='Utilisé pour';
$hesklang['email_oauth_providers_none']='Aucun fournisseur OAuth enregistré. Vous pouvez les ajouter en cliquant sur "Nouveau fournisseur" ci-dessus.';
$hesklang['email_oauth_provider_cannot_be_deleted']='Ce fournisseur ne peut pas être supprimé car il est utilisé par le service d\'assistance.';
$hesklang['email_oauth_confirm_delete_provider']='Êtes-vous sûr de vouloir supprimer ce fournisseur OAuth ?';
$hesklang['oauth_provider_saved']='Fournisseur OAuth enregistré';
$hesklang['oauth_provider_use']='Vous pouvez maintenant sélectionner ce fournisseur dans %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Entrez le nom du fournisseur';
$hesklang['oauth_provider_err_auth_url']='Entrez une URL d\'autorisation valide';
$hesklang['oauth_provider_err_token_url']='Entrez une URL de jeton valide';
$hesklang['oauth_provider_err_client_id']='Entrez l\'ID client';
$hesklang['oauth_provider_err_client_secret']='Entrez le secret client';
$hesklang['oauth_provider_err_scope']='Entrez la portée';
$hesklang['oauth_provider_deleted']='Fournisseur OAuth supprimé';
$hesklang['oauth_provider_not_found']='Ce fournisseur OAuth n\'existe pas';
$hesklang['oauth_provider_verified']='Vérifié';
$hesklang['oauth_provider_click_to_verify']='Cliquez pour vérifier';
$hesklang['can_due_date']='Peut définir une date d\'échéance'; // Permission to set and modify due date
$hesklang['can_due_date_e']='Vous n\'avez pas la permission de définir des dates d\'échéance';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Vérifiez votre inscription';
$hesklang['customer_verify_new_email']='Vérifiez votre nouvelle adresse e-mail';
$hesklang['customer_reset_password']='Réinitialisez votre mot de passe du service d\'assistance';
$hesklang['customer_approved']='Compte approuvé';
$hesklang['customer_rejected']='Compte rejeté';
$hesklang['email_rejected']='Compte requis pour soumettre des tickets de support';
$hesklang['require_curl']='Cette fonctionnalité nécessite le support de <strong>cURL</strong> pour PHP activé sur votre serveur. Veuillez demander à votre hébergeur d\'activer cURL pour PHP.';
$hesklang['customer_accounts_heading']='Comptes clients';
$hesklang['customer_accounts']='Comptes clients';
$hesklang['customer_accounts_off']='<strong>Désactivé</strong>';
$hesklang['customer_accounts_allowed']='<strong>Activé - Optionnel</strong> (les clients peuvent soumettre des tickets de support sans s\'enregistrer ni se connecter)';
$hesklang['customer_accounts_required_to_submit']='<strong>Activé - Requis pour les tickets</strong> (seuls les clients connectés peuvent soumettre des tickets de support)';
$hesklang['customer_accounts_required']='<strong>Activé - Requis pour accéder</strong> (seuls les clients connectés peuvent accéder au service d\'assistance et à la base de connaissances)';
$hesklang['customer_accounts_reg']='Enregistrement de compte';
$hesklang['customer_accounts_reg_customer']='Les clients peuvent enregistrer des comptes';
$hesklang['customer_accounts_reg_approve']='Les clients peuvent enregistrer un compte, le personnel doit approuver les nouvelles inscriptions';
$hesklang['customer_accounts_reg_staff']='Seul le personnel peut enregistrer des comptes clients';
$hesklang['customer_accounts_allow_email_changes']='Permettre aux clients de changer leur adresse e-mail';
$hesklang['customer_accounts_allow_email_resends']='Délai avant que les clients puissent demander un nouvel e-mail de vérification';
$hesklang['customer_login']='Connexion';
$hesklang['customer_logout']='Déconnexion';
$hesklang['customer_register']='Inscription';
$hesklang['customer_accounts_disabled']='Les connexions et inscriptions clients sont désactivées.';
$hesklang['customer_accounts_registration_disabled']='Les inscriptions clients sont désactivées.';
$hesklang['customer_forgot_password']='Mot de passe oublié ?';
$hesklang['customer_email']='Adresse e-mail';
$hesklang['customer_accounts_email_banned']='Vous avez été banni de ce service d\'assistance.';
$hesklang['customer_registration_successful']='Inscription réussie !';
$hesklang['customer_registration_email_exists_no_reset_link']='Un compte avec l\'e-mail %s existe déjà.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='Un compte avec l\'e-mail %s existe déjà. <a href="login.php">Souhaitez-vous vous connecter à la place ?</a>'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='Un compte avec l\'e-mail %s existe déjà et est en attente de vérification par e-mail.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='Un compte avec l\'e-mail %s existe déjà et est en attente d\'approbation du personnel.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='Vérifiez votre e-mail !';
$hesklang['customer_registration_check_your_email_content']='Vous devez vérifier votre adresse e-mail avant de pouvoir vous connecter.<br><br>Si vous ne le recevez pas dans quelques minutes, veuillez vérifier vos dossiers Junk, Bulk ou Spam. Marquez le message comme <b>Non SPAM</b> pour éviter les problèmes de réception de nos correspondances à l\'avenir.';
$hesklang['customer_login_not_verified']='Vous devez vérifier votre adresse e-mail avant de pouvoir vous connecter.';
$hesklang['customer_login_not_verified2']='Si vous n\'avez pas reçu l\'e-mail de vérification de notre part, veuillez vérifier vos dossiers Junk, Bulk ou Spam. Marquez le message comme <b>Non SPAM</b> pour éviter les problèmes de réception de nos correspondances à l\'avenir.';
$hesklang['customer_login_resend_verification_email']='Renvoyer l\'e-mail de vérification';
$hesklang['customer_login_resend_verification_email_none']='Il n\'y a pas de vérification d\'e-mail en attente à envoyer.';
$hesklang['customer_login_resend_verification_email_too_early']='Vous ne pouvez pas demander un nouvel e-mail de vérification pour le moment, veuillez réessayer plus tard.';
$hesklang['customer_login_not_approved']='Un membre du personnel doit approuver votre compte avant de pouvoir vous connecter. Une fois approuvé, vous serez averti par e-mail.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Vérifiez votre inscription';
$hesklang['customer_registration_verify_success']='Votre e-mail a été vérifié et vous pouvez maintenant vous connecter en utilisant le formulaire ci-dessous.';
$hesklang['customer_registration_verify_approval_needed']='Votre e-mail a été vérifié. Cependant, un membre du personnel doit approuver votre compte avant de pouvoir vous connecter. Une fois approuvé, vous serez averti par e-mail.';
$hesklang['customer_registration_verify_failure']='Votre e-mail n\'a pas pu être vérifié. Le lien a peut-être déjà été utilisé ou a expiré.';
$hesklang['emails_to_customers']='&raquo; E-mails envoyés aux clients';
$hesklang['emails_to_staff']='&raquo; E-mails envoyés au personnel';
$hesklang['emails_to_everyone']='&raquo; E-mails envoyés au personnel ou aux clients';
$hesklang['new_customer_approval']='Vous avez des comptes clients en attente d\'approbation'; // Email subject
$hesklang['desc_new_customer_approval']='(Personnel) Comptes clients en attente d\'approbation';
$hesklang['n_cust_app']='Il y a des approbations de clients en attente'; // Notify me when...
$hesklang['et_num_customers']='Nombre d\'approbations en attente';
$hesklang['et_link_customers']='Lien vers la page Gérer les clients';
$hesklang['et_link_verify']='Lien de vérification';
$hesklang['et_cust_login']='URL de connexion client';
$hesklang['submit_ticket_customer_email_exists']='Un client avec cet e-mail existe déjà. Veuillez <a href="login.php?email=%s">vous connecter</a> pour soumettre un ticket.'; // %s - User's email
$hesklang['customer_login_email_required']='Veuillez entrer une adresse e-mail valide.';
$hesklang['customer_login_password_required']='Veuillez entrer votre mot de passe.';
$hesklang['customer_login_remember_just_email']='Se souvenir seulement de mon e-mail';
$hesklang['customer_login_remember_email']='Se souvenir de mon e-mail';
$hesklang['customer_wrong_user']='Votre adresse e-mail %s n\'est pas enregistrée chez nous.<br><br>Souhaitez-vous <a href="register.php">créer un compte ?</a>'; // %s - Entered email address
$hesklang['customer_wrong_pass']='Votre adresse e-mail et votre mot de passe ne correspondent pas à nos enregistrements.<br><br>Souhaitez-vous <a href="login.php?submittedForgot=1">réinitialiser votre mot de passe ?</a>';
$hesklang['customer_must_be_logged_in_to_view']='Veuillez vous connecter pour continuer.';
$hesklang['customer_register_here']='Si vous n\'avez pas de compte chez nous, vous pouvez <a href="register.php">vous inscrire ici</a>.';
$hesklang['create_account']='Créer un compte';
$hesklang['customer_my_tickets_heading']='Mes tickets';
$hesklang['customer_my_tickets_description']='Voir tous vos tickets précédents';
$hesklang['customer_my_tickets_search_for_tickets']='Rechercher des tickets';
$hesklang['customer_password_reset_successful']='Votre nouveau mot de passe a été enregistré. Vous pouvez maintenant vous connecter.';
$hesklang['customer_profile']='Profil';
$hesklang['customer_edit_profile']='Modifier le profil';
$hesklang['customer_edit_pass']='Modifier le mot de passe';
$hesklang['customer_edit_pass_same']='Votre nouveau mot de passe ne doit pas être identique à l\'actuel.';
$hesklang['customer_change_email']='Changer l\'e-mail';
$hesklang['customer_change_email_banned']='L\'e-mail que vous avez entré est interdit.';
$hesklang['customer_change_email_pending']='Il y a une demande en cours pour changer votre adresse e-mail en : <b>%s</b><br><br>Nous avons envoyé un e-mail à cette adresse. Veuillez cliquer sur le lien dans l\'e-mail pour confirmer le changement.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Renvoyer l\'e-mail de confirmation</a>';
$hesklang['customer_change_email_submitted']='Veuillez cliquer sur le lien de vérification envoyé à <b>%s</b> pour vérifier votre nouvel e-mail.'; // %s - new email
$hesklang['customer_change_email_verify_success']='Votre nouvelle adresse e-mail a été vérifiée et votre profil mis à jour.';
$hesklang['customer_change_email_disabled']='La possibilité de mettre à jour votre e-mail est désactivée. Contactez-nous si vous souhaitez changer d\'adresse e-mail.';
$hesklang['customer_profile_saved']='Votre profil a été enregistré.';
$hesklang['customers']='Clients';
$hesklang['customers_intro']='Les comptes clients permettent aux clients de voir tous leurs tickets en un seul endroit.';
$hesklang['sure_remove_customer']='Êtes-vous sûr de vouloir supprimer ce client ?';
$hesklang['sure_remove_customer_additional_note']='La suppression d\'un client est définitive. Une fois supprimé, il ne peut pas être récupéré !';
$hesklang['new_customer']='Nouveau client';
$hesklang['new_follower']='Nouveau suiveur';
$hesklang['add_customer']='+ Ajouter un client'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Ajouter un suiveur'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='Le client fourni n\'existe pas encore. Cliquez sur "Enregistrer" si vous souhaitez créer ce client.';
$hesklang['followers']='Suiveurs';
$hesklang['no_customers']='Il n\'y a actuellement aucun client dans la base de données.';
$hesklang['no_customers_disabled']='Vous commencerez à voir des clients ici lorsqu\'ils soumettront des tickets de support.';
$hesklang['no_customers_enabled']='Vous commencerez à voir des clients ici lorsqu\'ils s\'inscriront ou soumettront des tickets de support.';
$hesklang['no_customers_enabled2']='Alternativement, les boutons au-dessus de ce message vous permettent de créer manuellement des comptes clients ou d\'importer des clients existants dans le service d\'assistance.';
$hesklang['import_customers']='Importer des clients';
$hesklang['import_customers_tip']='Utilisez un fichier CSV pour importer plusieurs clients à la fois.';
$hesklang['customer_not_found']='Client introuvable pour le ticket !';
$hesklang['search_by_name_or_email']='Rechercher par nom ou e-mail...';
$hesklang['search_by_pattern']='Rechercher par modèle...';
$hesklang['is_searchable']='Recherchable';
$hesklang['custom_is_searchable']='Recherchable';
$hesklang['yes_via_autocomplete']='OUI (recherche via l\'autocomplétion)';
$hesklang['customer_required']='Vous devez sélectionner un client';
$hesklang['customer_email_exists']='Un client avec cet e-mail existe déjà.';
$hesklang['customer_name_with_no_email_exists']='Un client avec ce nom et sans e-mail existe déjà.';
$hesklang['an_error_occurred_validating_email']='Une erreur s\'est produite lors de la tentative de vérification de l\'adresse e-mail saisie.';
$hesklang['customer_count_x_more']='+%s de plus'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Enregistré';
$hesklang['customer_account_verified']='Vérifié';
$hesklang['customer_account_verified_help']='Les clients doivent vérifier leur compte via un lien d\'activation envoyé à leur adresse e-mail avant de pouvoir se connecter.';
$hesklang['customer_account_setting_password_will_verify_user']='Définir un mot de passe pour ce client vérifiera automatiquement leur compte.';
$hesklang['deleting_customer_with_tickets']='Ce client a %1$s ticket(s) <b>(%2$s ouvert(s))</b> qui ont également d\'autres clients associés. <br> Que faire de ces tickets ?'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='Une adresse e-mail valide est nécessaire pour renvoyer un e-mail de vérification.';
$hesklang['customer_resend_verification_email_not_found']='Aucun compte avec cette adresse e-mail n\'existe ou le compte a déjà été vérifié.';
$hesklang['customer_resend_verification_email_sent']='Un e-mail de vérification a été envoyé à votre adresse e-mail.<br><br>Si vous ne le recevez pas dans quelques minutes, veuillez vérifier vos dossiers Junk, Bulk ou Spam. Marquez le message comme <b>Non SPAM</b> pour éviter les problèmes de réception de nos correspondances à l\'avenir.';
$hesklang['customer_permission_denied']='Vous n\'avez pas la permission de modifier les clients.';
$hesklang['customer_manage_approvals']='Comptes clients en attente d\'approbation : <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Approuver le client';
$hesklang['customer_manage_bulk_approve']='Approuver les clients sélectionnés';
$hesklang['customer_manage_bulk_approve_complete']='Clients approuvés : %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Rejeter le client';
$hesklang['customer_manage_bulk_reject']='Rejeter les clients sélectionnés';
$hesklang['customer_manage_bulk_reject_complete']='Clients rejetés : %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Supprimer le client';
$hesklang['customer_manage_bulk_delete']='Supprimer les clients sélectionnés';
$hesklang['customer_manage_bulk_delete_complete']='Clients supprimés : %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Modifier le client';
$hesklang['customer_manage_verification_email_sent']='E-mail de vérification envoyé à %s'; // %s = customer's email
$hesklang['can_man_customers']='Gérer les clients';
$hesklang['can_view_customers']='Voir tous les clients (mais ne pas les gérer)';
$hesklang['import_customer_select_file']='Sélectionner le fichier';
$hesklang['import_customer_step1_instructions']='Pour importer des clients, préparez un fichier CSV (valeurs séparées par des virgules).';
$hesklang['import_customer_step1_note']='Sélectionnez votre fichier CSV';
$hesklang['import_customer_step1_separator']='Les colonnes de mon fichier CSV sont séparées par';
$hesklang['import_customer_sample']='&raquo; Fichiers CSV d\'exemple';
$hesklang['import_customer_sample_1']='Fichier CSV au format US avec des colonnes séparées par ,';
$hesklang['import_customer_sample_2']='Fichier CSV au format EU avec des colonnes séparées par ;';
$hesklang['import_customer_upload_requirements_1']='Votre fichier CSV doit inclure au moins une colonne nom ou adresse e-mail. La colonne mot de passe est optionnelle.';
$hesklang['import_customer_upload_requirements_2']='La première ligne de votre fichier doit contenir les en-têtes de colonnes.';
$hesklang['import_customer_upload_requirements_3']='Votre fichier doit être encodé en UTF-8.';
$hesklang['import_customer_select_columns']='Sélectionnez les colonnes';
$hesklang['import_customer_upload_customers']='Importer les clients';
$hesklang['import_customer_column_name']='Colonne Nom';
$hesklang['import_customer_column_email']='Colonne E-mail';
$hesklang['import_customer_column_pass']='Colonne Mot de passe';
$hesklang['import_customer_step2_note']='Sélectionnez le nom de colonne correct de votre fichier CSV dans les listes déroulantes, puis cliquez sur "Suivant".';
$hesklang['import_customer_name_or_email_required']='Le nom ou l\'e-mail est requis';
$hesklang['import_customer_step3_note']='Vos clients sont en cours d\'importation. Ne quittez pas cette page !';
$hesklang['import_customer_step3_pending']='En attente';
$hesklang['import_customer_step3_successful_imports']='Importations réussies';
$hesklang['import_customer_step3_failed_imports']='Importations échouées';
$hesklang['import_customer_step3_progress']='Progression';
$hesklang['import_customer_step3_complete_some_failed']='Le processus d\'importation est terminé, cependant <b>%s</b> clients n\'ont pas pu être importés. Consultez le tableau ci-dessous pour plus d\'informations.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='Le processus d\'importation est terminé !';
$hesklang['import_customer_step3_importing']='Importation';
$hesklang['staff_deleted']='[Personnel supprimé]';
$hesklang['customer_account_approved']='Inscription client approuvée';
$hesklang['customer_account_rejected']='Inscription client rejetée';
$hesklang['customer_account_deleted']='Inscription client supprimée';
$hesklang['ticket_followers']='Suiveurs de ticket';
$hesklang['ticket_followers2']='Autoriser plusieurs clients par ticket';
$hesklang['add_cc']='Ajouter en Cc';
$hesklang['cc']='Cc';
$hesklang['cc_help']='Séparez chaque e-mail par une virgule.';
$hesklang['search_customers']='Rechercher des clients';
$hesklang['page_size']='Taille de la page';
$hesklang['customers_on_pages']='Nombre de clients : %d | Nombre de pages : %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Client) Réinitialisez votre mot de passe';
$hesklang['desc_customer_verify_registration']='(Client) Vérifiez votre inscription';
$hesklang['desc_customer_verify_new_email']='(Client) Vérifiez votre nouvelle adresse e-mail';
$hesklang['desc_customer_approved']='(Client) Compte approuvé';
$hesklang['desc_customer_rejected']='(Client) Compte rejeté';
$hesklang['desc_email_rejected_can_self_register']='(Client) Ticket par e-mail rejeté; le client peut s\'auto-enregistrer';
$hesklang['desc_email_rejected_cannot_self_register']='(Client) Ticket par e-mail rejeté; le client ne peut pas s\'auto-enregistrer';
$hesklang['user_added_success_no_pass']='Nouvel utilisateur %s ajouté avec succès';
$hesklang['email_tag_requester']='Demandeur (De)';
$hesklang['email_tag_requester_name']='Nom du demandeur (De)';
$hesklang['email_tag_requester_first_name']='Prénom du demandeur (De)';
$hesklang['email_tag_requester_email']='E-mail du demandeur (De)';
$hesklang['email_tag_followers']='Suiveurs (Cc)';
$hesklang['email_tag_follower_names']='Noms des suiveurs (Cc)';
$hesklang['email_tag_follower_emails']='E-mails des suiveurs (Cc)';
$hesklang['barcode']='Code-barres';
$hesklang['barcode_use']='Afficher un code-barres sur les tickets imprimés';
$hesklang['barcode_staff_only']='Masquer le code-barres aux clients';
$hesklang['barcode_type']='Type de code-barres';
$hesklang['barcode_format']='Format';
$hesklang['barcode_width']='Largeur';
$hesklang['barcode_height']='Hauteur';
$hesklang['barcode_color']='Couleur';
$hesklang['barcode_bg']='Fond';
$hesklang['copy_link']='Copier le lien du ticket';
$hesklang['copy_link_title']='Copier le lien public vers ce ticket';
$hesklang['copy_link_exp']='Le lien copié est le lien direct pour que le client puisse voir ce ticket';
$hesklang['copy_value']='Copier cette valeur';
$hesklang['download_class']='Cette fonction nécessite la classe ZipArchive. Demandez à votre hébergeur de compiler PHP avec le support zip.';
$hesklang['download_all']='Tout télécharger';
$hesklang['download_prep']='Préparation du téléchargement...';
$hesklang['download_tma']='Trop de pièces jointes';
$hesklang['download_nva']='Aucune pièce jointe valide';
$hesklang['download_ntd']='Rien à télécharger';
$hesklang['resolved_at']='Résolu à';
$hesklang['disable_GSSAPI']='Désactiver l\'authentificateur GSSAPI (solution d\'erreur Kerberos)';
$hesklang['ex_history']='Inclure le journal de l\'historique du ticket dans l\'exportation';
$hesklang['sm_location']='Emplacement'; // Location (page) of a service message
$hesklang['loc_sm']='Afficher ce message de service sur :';
$hesklang['loc_all']='Toutes les pages clients';
$hesklang['loc_norec']='(non recommandé)';
$hesklang['loc_home']='Page d\'accueil du service d\'assistance';
$hesklang['loc_selected']='Sur des pages sélectionnées';
$hesklang['loc_selerr']='Sélectionnez au moins une page pour afficher le message';
$hesklang['loc_t_cat']='Soumettre un ticket - sélectionner une catégorie';
$hesklang['loc_t_add']='Soumettre un ticket - formulaire de soumission de ticket';
$hesklang['loc_t_ok']='Soumettre un ticket - confirmation de ticket';
$hesklang['loc_t_view']='Voir un ticket';
$hesklang['loc_t_form']='Voir un formulaire de ticket';
$hesklang['loc_kb_main']='Page d\'accueil de la base de connaissances';
$hesklang['loc_kb_sub']='Pages des sous-catégories de la base de connaissances';
$hesklang['loc_kb_art']='Articles de la base de connaissances';
$hesklang['loc_login']='Page de connexion client';
$hesklang['loc_register']='Page d\'enregistrement client';
$hesklang['loc_register_ok']='Inscription client réussie';
$hesklang['loc_acc']='Page &quot;Mes tickets&quot; client';
$hesklang['loc_profile']='Page &quot;Profil&quot; client';
$hesklang['sending_show']='Afficher la notification &quot;Soumission en cours&quot;';
$hesklang['sending_wait']='Soumission en cours, veuillez patienter...';
$hesklang['e_c_email']='Entrez l\'adresse e-mail correcte pour voir ce ticket';
$hesklang['only_verified_cc']='Les suiveurs sans compte vérifié seront ignorés.';
$hesklang['followers_removed']='Ces adresses e-mail ont été retirées du ticket car elles n\'ont pas de compte vérifié :';
$hesklang['novace']='Nous n\'avons trouvé aucun compte enregistré et vérifié avec cette adresse e-mail.';
$hesklang['max_recipients']='Nombre maximal de destinataires';
$hesklang['max_recipients2']='dans un seul e-mail';
$hesklang['admin_js']='Admin JS';
$hesklang['admin_js2']='Charger un fichier Javascript personnalisé supplémentaire pour le panneau d\'administration';
$hesklang['cf_limit_all']='Vous avez atteint la limite de champs personnalisés et ne pouvez pas créer de nouveaux champs personnalisés.';
$hesklang['remind_assigned']='Rappeler au personnel assigné';
$hesklang['remind_sent']='Rappel par e-mail envoyé au membre du personnel assigné';
$hesklang['thist23']='<li class="smaller">%s | rappel envoyé à %s par %s</li>';
$hesklang['ql_bookmarks']='Signets';
$hesklang['bookmark']='Mon Signet';
$hesklang['bookmarks_add']='Ajouter aux signets';
$hesklang['bookmarks_added']='Ce ticket a été ajouté à vos signets';
$hesklang['bookmarks_remove']='Retirer des signets';
$hesklang['bookmarks_removed']='Ce ticket a été retiré de vos signets';
$hesklang['genl_not_copied']='Erreur : la copie dans le presse-papiers n\'est pas prise en charge sur cet appareil/navigateur.';
$hesklang['profile_duplicate_email']='Un utilisateur avec l\'adresse e-mail <b>%s</b> existe déjà.'; // %s: new email
$hesklang['seq_id_numeric']='La recherche de numéro de ticket doit contenir uniquement des chiffres';
$hesklang['confirm_new_pass']='Confirmer le nouveau mot de passe';
$hesklang['piping_notify_rejected_customers1']='E-mails de rejet des clients';
$hesklang['piping_notify_rejected_customers2']='Envoyer un e-mail de rejet aux clients lorsque leur ticket est rejeté';
$hesklang['piping_notify_rejected_customers3']='Temps entre les e-mails de rejet';
$hesklang['register_url']='URL d\'inscription';
$hesklang['email_subject']='Objet de l\'e-mail';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Collaboration sur le ticket : %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] Réponse du personnel à : %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] Note ajoutée à : %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Ticket en retard : %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Ticket résolu : %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Date limite d\'envoi d\'e-mail de suivi :'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='Ne pas envoyer d\'e-mail aux tickets résolus depuis plus de'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='(doit être une période plus longue que "%s")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='La période de date limite d\'e-mail doit être plus longue que le délai d\'e-mail de suivi';
$hesklang['available_language']='Langues disponibles';
$hesklang['click_to_show_available_language']='Cliquez pour afficher les langues disponibles';
$hesklang['install_lan']='Installer';
$hesklang['remove_lan']='Supprimer';
$hesklang['title_lan']='Titre';
$hesklang['description_lan']='Description';
$hesklang['completed_lan']='Terminé';
$hesklang['no_language_availble']='Aucune langue disponible';
$hesklang['success_install_lan_txt']='la langue a été ajoutée avec succès';
$hesklang['error_install_lan_txt']='la langue n\'a pas été ajoutée';
$hesklang['success_remove_lan_txt']='la langue a été supprimée avec succès';
$hesklang['error_remove_lan_txt']='la langue n\'a pas été supprimée';
$hesklang['remove_default_language_error']='La langue par défaut doit rester active et ne peut pas être supprimée';
$hesklang['click_for_manual_step']='Cliquez pour l\'installation manuelle';
$hesklang['upgrade_lan']='Mettre à jour';
$hesklang['success_upgrade_lan_txt']='la langue a été mise à jour avec succès';
$hesklang['error_upgrade_lan_txt']='la langue n\'a pas été mise à jour';
$hesklang['please_wait']='Veuillez patienter...';
$hesklang['add_a_note']='Ajouter une note';
$hesklang['add_a_reply']='Ajouter une réponse';
$hesklang['customer_id']='ID client';
$hesklang['deleting_customer_tickets']='Tickets ouverts par le client : <b>%1$s</b><br>Que devons-nous faire avec ces tickets ?'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Tickets où le client est en copie : <b>%1$s</b><br>Ceux-ci perdront ce client comme suiveur ; les tickets restent inchangés.'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Supprimer définitivement les tickets';
$hesklang['deleting_customer_anonymize_tickets2']='Anonymiser les tickets (supprimer les messages et données personnelles)';
$hesklang['deleting_customer_retain_tickets2']='Conserver les tickets (laisser toutes les données intactes)';
$hesklang['for_staff']='pour le personnel du support'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='pour les clients'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='Boîte aux lettres IMAP';
$hesklang['file_attachment_options']='Options de pièces jointes d\'e-mail';
$hesklang['link_to_attachments_in_emails']='Lien vers les pièces jointes dans les e-mails';
$hesklang['add_attachments_directly_to_emails']='Ajouter les pièces jointes directement aux e-mails';
$hesklang['directly_attach_file_smaller_than']='Joindre directement seulement les fichiers plus petits que';
$hesklang['directly_attach_file_of_any_size']='Joindre directement les fichiers de toute taille';
$hesklang['directly_attach_only_first_x_attachments']='Joindre directement seulement les premiers';
$hesklang['directly_attach_all_attachments']='Joindre directement toutes les pièces jointes';
$hesklang['directly_attach_size']='Taille de la pièce jointe';
$hesklang['directly_attach_no_of_files']='Nombre de fichiers';
$hesklang['notice_about_directly_attach_files']='Joindre de nombreux ou volumineux fichiers aux e-mails peut causer des retards lors de la communication avec votre serveur SMTP';
$hesklang['fatt_2']='Fichiers supplémentaires joints à ce message :';
$hesklang['no_collaborators']='Aucun';
$hesklang['collaborate']='Collaborer sur ce ticket';
$hesklang['collaborators']='Collaborateurs';
$hesklang['ql_cbm']='Collaborateur';
$hesklang['collaborating']='Vous collaborez maintenant sur ce ticket';
$hesklang['not_collaborating']='Vous ne collaborez plus sur ce ticket';
$hesklang['add_collaborator']='Ajouter un collaborateur';
$hesklang['user_collaborator_added']='Utilisateur ajouté comme collaborateur sur ce ticket';
$hesklang['remove_collaborator']='Supprimer le collaborateur';
$hesklang['staff_name']='Nom du personnel';
$hesklang['user_collaborator_removed']='Utilisateur supprimé comme collaborateur sur ce ticket';
$hesklang['desc_collaborator_added']='(Personnel) Vous collaborez sur un nouveau ticket';
$hesklang['desc_collaborator_staff_reply']='(Personnel) Un membre du personnel a répondu à un ticket collaboratif';
$hesklang['desc_collaborator_note']='(Personnel) Nouvelle note ajoutée à un ticket collaboratif';
$hesklang['desc_collaborator_resolved']='(Personnel) Un ticket collaboratif a été résolu';
$hesklang['desc_collaborator_overdue']='(Personnel) Un ticket collaboratif est en retard';
$hesklang['notify_collaborator_added']='Je suis ajouté comme collaborateur de ticket';
$hesklang['notify_collaborator_customer_reply']='Le client répond à un ticket collaboratif';
$hesklang['notify_collaborator_staff_reply']='Le personnel répond à un ticket collaboratif';
$hesklang['notify_collaborator_note']='Le personnel ajoute une note à un ticket collaboratif';
$hesklang['notify_collaborator_resolved']='Le personnel résout un ticket collaboratif';
$hesklang['notify_collaborator_overdue']='Le ticket collaboratif est en retard';
$hesklang['recurring_tickets']['tab']='Tickets récurrents'; // Menu link
$hesklang['recurring_tickets']['page_title']='Tickets récurrents'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Automatisez les tâches répétitives ; laissez Hesk créer les tickets de routine pour vous, exactement quand vous en avez besoin.';
$hesklang['recurring_tickets']['active_rules']='Règles actives';
$hesklang['recurring_tickets']['new']='Nouvelle règle de ticket récurrent';
$hesklang['recurring_tickets']['no_rules']='Vous n\'avez aucune règle de ticket récurrent. Créez-en une en cliquant sur le bouton &quot;Nouvelle règle de ticket récurrent&quot; ci-dessus.';
$hesklang['recurring_tickets']['title']='Titre de la règle';
$hesklang['recurring_tickets']['titlet']='Un titre descriptif, par exemple : Réassigner les tickets sans réponse dans la journée';
$hesklang['recurring_tickets']['default_title']='Règle par %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Déclencheur de règle';
$hesklang['recurring_tickets']['trigt']='Définir la condition qui déclenchera (exécutera) cette règle.';
$hesklang['recurring_tickets']['hits']='Occurrences'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Moment de création'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='Paramètres généraux'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Champs personnalisés'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Contenu'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='Supprimer cette règle ?';
$hesklang['recurring_tickets']['edit']='Modification de la règle de ticket récurrent ID %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='Dans :';
$hesklang['recurring_tickets']['minutes']='minutes';
$hesklang['recurring_tickets']['hours']='heures';
$hesklang['recurring_tickets']['days']='jours';
$hesklang['recurring_tickets']['weeks']='semaines';
$hesklang['recurring_tickets']['months']='mois';
$hesklang['recurring_tickets']['years']='années';
$hesklang['recurring_tickets']['setpri']='Définir la priorité à :';
$hesklang['recurring_tickets']['setsta']='Définir le statut à :';
$hesklang['recurring_tickets']['assto']='Assigner le ticket à :';
$hesklang['recurring_tickets']['asm']='Un autre membre du personnel';
$hesklang['recurring_tickets']['notify']='Notifier les membres du personnel...';
$hesklang['recurring_tickets']['ato']='Appliquer à :';
$hesklang['recurring_tickets']['save']='Enregistrer la règle';
$hesklang['recurring_tickets']['e_tt']='Le temps doit être compris entre 1 et 10000';
$hesklang['recurring_tickets']['nocat']='Sélectionnez au moins une catégorie';
$hesklang['recurring_tickets']['nouser']='Sélectionnez au moins un utilisateur';
$hesklang['recurring_tickets']['nostatus']='Sélectionnez au moins un statut';
$hesklang['recurring_tickets']['nocata']='%1$s n\'a pas accès à ces catégories :'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='Une nouvelle règle a été créée';
$hesklang['recurring_tickets']['mdf']='Les paramètres de la règle ont été enregistrés';
$hesklang['recurring_tickets']['e_id']='Aucune règle avec cet ID trouvée';
$hesklang['recurring_tickets']['deleted']='La règle sélectionnée a été supprimée';
$hesklang['recurring_tickets']['log_title']='Règle #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Active'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Activer cette règle (commencer à l\'utiliser)';
$hesklang['recurring_tickets']['activated']='La règle sélectionnée a été activée'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='Désactiver cette règle (arrêter de l\'utiliser)';
$hesklang['recurring_tickets']['deactivated']='La règle sélectionnée a été désactivée'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='Aucune règle de ticket récurrent active';
$hesklang['recurring_tickets']['tools']='Outils';
$hesklang['recurring_tickets']['tbef']='Avant qu\'une règle soit en ligne, vous devez l\'activer en cochant la case dans la colonne &quot;ACTIVE&quot;.<br><br>
                               <strong>Les règles actives sont traitées toutes les %2$s minutes.</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[RÈGLE]';
$hesklang['recurring_tickets']['r2']='[RÈGLE] Règle #%s';
$hesklang['recurring_tickets']['r3']='Règle #%s';
$hesklang['recurring_tickets']['i']='[INFO]';
$hesklang['recurring_tickets']['matched']='Nombre de tickets déjà créés aujourd\'hui : %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Réinitialiser cette règle';
$hesklang['recurring_tickets']['reset2']='Êtes-vous sûr de vouloir réinitialiser cette règle ?<br><br>Les occurrences de la règle passeront à 0 et tous les tickets déjà générés pour elle aujourd\'hui pourraient être re-générés lors de la prochaine exécution cron.';
$hesklang['recurring_tickets']['reset3']='La règle sélectionnée a été réinitialisée';
$hesklang['recurring_tickets']['test']='Simuler cette règle';
$hesklang['recurring_tickets']['testa']='Simuler toutes les règles';
$hesklang['recurring_tickets']['testaa']='Simuler toutes les règles actives';
$hesklang['recurring_tickets']['testr']='Résultats de simulation';
$hesklang['recurring_tickets']['rsim']='Répéter la simulation';
$hesklang['recurring_tickets']['sim']='MODE SIMULATION, aucune modification à la base de données';
$hesklang['recurring_tickets']['sic']='SIMULATION TERMINÉE';
$hesklang['recurring_tickets']['rrule_type_required']='Veuillez sélectionner un déclencheur de règle récurrente valide.';
$hesklang['recurring_tickets']['rrule_string_required']='Veuillez sélectionner toutes les options de déclencheur de règle récurrente requises.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Veuillez saisir une valeur d\'intervalle de 1 ou plus pour "Chaque".';
$hesklang['recurring_tickets']['disable_note']='*Si des paramètres critiques d\'hesk sont modifiés après la création d\'une règle, elle sera désactivée lors de la prochaine tentative d\'exécution et devra être éditée pour passer les nouvelles exigences de validation.';
$hesklang['recurring_tickets']['thist1']='<li class="smaller">%1$s | soumis par la règle de tickets récurrents "%2$s"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class="smaller">%1$s | assigné à %2$s par la règle de tickets récurrents "%3$s"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class="smaller">%1$s | fermé automatiquement par la règle de tickets récurrents "%2$s"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class="smaller">%1$s | statut changé vers %2$s par la règle de tickets récurrents "%3$s"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class="smaller">%1$s | automatiquement assigné à %2$s par la règle de tickets récurrents "%3$s"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='La règle a été désactivée en raison d\'erreurs de validation. Vérifiez les détails ci-dessous.';
$hesklang['recurring_tickets']['errors_title']='Une ou plusieurs de vos règles ont produit des erreurs lors de leur tentative d\'exécution et ont été désactivées.';
$hesklang['recurring_tickets']['rule_errors']='<hr>Erreurs de la règle #%s :';
$hesklang['recurring_tickets']['create_customers']='Il n\'y a pas de clients existants - veuillez les créer <a href="%s" target="_blank">ici</a>.';
$hesklang['recurring_tickets']['exec_dates']='Dates d\'exécution de la règle';
$hesklang['recurring_tickets']['show_exec_dates']='[Afficher les dates d\'exécution actuelles de la règle]';
$hesklang['recurring_tickets']['no_exec_dates']='Veuillez sélectionner des déclencheurs de règle valides pour voir les dates d\'exécution.';
$hesklang['recurring_tickets']['invalid_disabled']='paramètres Rrule invalides - règle désactivée.';
$hesklang['recurring_tickets']['next_occ']='Prochaines %s occurrences de règle :';
$hesklang['recurring_tickets']['occ_on']='le %s';
$hesklang['recurring_tickets']['not_firing_today']='n\'a pas besoin d\'être déclenchée aujourd\'hui.';
$hesklang['recurring_tickets']['rules_fulfilled']='règles récurrentes remplies - ticket créé aujourd\'hui !';
$hesklang['recurring_tickets']['validation_failed']='validation échouée - règle désactivée. Détails ci-dessous :';
$hesklang['recurring_tickets']['validation_error']='Erreur de validation :';
$hesklang['recurring_tickets']['processed']='traité.';
$hesklang['recurring_tickets']['created_ticket']='ticket créé id : %1$s, trackid : %2$s';
$hesklang['recurring_tickets']['due_date_note']='relatif à la date de création du ticket';
$hesklang['priorities']='Priorités';
$hesklang['priority_intro']='Utilisez cet outil pour gérer les priorités des tickets de votre support';
$hesklang['new_priority']='Nouvelle priorité';
$hesklang['edit_priority']='Modifier la priorité';
$hesklang['priority_title']='Titre';
$hesklang['can_customers_select_it']='Les clients peuvent-ils sélectionner cette priorité ?';
$hesklang['selected_by_customer']='Sélectionnable par les clients';
$hesklang['err_priority']='Saisissez le titre de la priorité';
$hesklang['priority_added']='Une nouvelle priorité a été ajoutée';
$hesklang['priority_e_id']='ID de priorité invalide';
$hesklang['priority_mdf']='La priorité a été enregistrée';
$hesklang['priority_deleted']='Priorité supprimée';
$hesklang['priority_not_found']='Cette priorité n\'existe pas';
$hesklang['priority_not_empty']='Cette priorité ne peut pas être supprimée car des tickets avec cette priorité existent';
$hesklang['click_to_enable_drag_drop']='Cliquez pour activer le glisser-déposer pour la ligne, puis faites glisser la ligne vers le haut ou vers le bas pour réorganiser les priorités.';
$hesklang['confirm_delete_priority']='Êtes-vous sûr de vouloir supprimer cette priorité ?';
$hesklang['reordered_message']='L\'ordre de votre liste de priorités a été enregistré.';
$hesklang['list_tkt_priority']='Lister tous les tickets avec cette priorité';
$hesklang['deletion_priority_restricted']='Il s\'agit d\'une priorité spéciale qui ne peut pas être supprimée';
$hesklang['priority_limit']='Vous ne pouvez pas créer de nouvelles priorités';
$hesklang['skip_to_main_content']='Aller au contenu principal';
$hesklang['opens_dialog']='Ouvre une boîte de dialogue';
$hesklang['create_a_ticket']='Créer un ticket';
$hesklang['toggle_navigation']='Basculer la navigation';
$hesklang['add_a_ticket_reply']='Ajouter une réponse au ticket';
$hesklang['linked_tickets']='Tickets liés';
$hesklang['no_linked_tickets']='Aucun ticket lié';
$hesklang['link_ticket']='Lier le ticket';
$hesklang['can_link_tickets_e']='Vous n\'êtes pas autorisé à lier/délier ce ticket';
$hesklang['link_ticket_success']='Le ticket a été lié avec succès';
$hesklang['link_ticket_required_error']='Pour lier un ticket, veuillez fournir un ID de suivi valide';
$hesklang['link_ticket_itself_error']='Un ticket ne peut pas être lié à lui-même. Veuillez saisir un ID de suivi différent';
$hesklang['already_linked_error']='Le ticket a déjà été lié';
$hesklang['unlink_success']='Le ticket a été délié avec succès';
$hesklang['unlink_error']='Aucun enregistrement lié n\'existe';
$hesklang['link_history']='<li class="smaller">%s | %s ticket lié par %s</li>';
$hesklang['unlink_history']='<li class="smaller">%s | %s ticket délié par %s</li>';
$hesklang['can_link_tickets']='Peut lier le ticket';
$hesklang['link_a_ticket']='Lier un ticket';
$hesklang['mfa_curl']='Impossible de générer une image QR à scanner car le support <strong>cURL</strong> n\'est pas activé sur votre serveur.';
$hesklang['require_xml']='PHP-XML doit être activé pour les messages en texte enrichi (HTML). Veuillez demander à votre hébergeur d\'activer XML pour PHP.';
$hesklang['thist24']='<li class="smaller">%1$s | %2$s ajouté comme collaborateur par %3$s</li>';
$hesklang['thist25']='<li class="smaller">%1$s | %2$s supprimé comme collaborateur par %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Parfait pour les tâches de maintenance préventive, les révisions d\'accès mensuelles, les contrôles récurrents des clients, et plus encore.';
$hesklang['recurring_tickets']['feat1']='<strong>Programmation définie et oubliée.</strong> Quotidien, chaque lundi, chaque mars, le 15 de chaque mois, ou toute date future';
$hesklang['recurring_tickets']['feat2']='<strong>Arrivent pré-remplis et assignés.</strong> Choisissez la catégorie, la priorité, l\'agent et jusqu\'à 100 valeurs de champs personnalisés';
$hesklang['recurring_tickets']['feat3']='<strong>Prévisualisation des dates et simulation.</strong> Voyez chaque ticket que Hesk générera avant d\'activer une règle, il n\'y a donc pas de surprises.';
$hesklang['unlink_btn']='Délier';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');