/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2025 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */
var cytoscape=window.cytoscape;var GLPIImpact={NODE:1,EDGE:2,DEFAULT:0,FORWARD:1,BACKWARD:2,BOTH:3,EDITION_DEFAULT:1,EDITION_ADD_NODE:2,EDITION_ADD_EDGE:3,EDITION_DELETE:4,EDITION_ADD_COMPOUND:5,EDITION_SETTINGS:6,NODE_ID_SEPERATOR:"::",EDGE_ID_SEPERATOR:"->",DELTA_ACTION_ADD:1,DELTA_ACTION_UPDATE:2,DELTA_ACTION_DELETE:3,ACTION_MOVE:1,ACTION_ADD_NODE:2,ACTION_ADD_EDGE:3,ACTION_ADD_COMPOUND:4,ACTION_ADD_GRAPH:5,ACTION_EDIT_COMPOUND:6,ACTION_REMOVE_FROM_COMPOUND:7,ACTION_DELETE:8,ACTION_EDIT_MAX_DEPTH:9,ACTION_EDIT_IMPACT_VISIBILITY:10,ACTION_EDIT_DEPENDS_VISIBILITY:11,ACTION_EDIT_DEPENDS_COLOR:12,ACTION_EDIT_IMPACT_COLOR:13,ACTION_EDIT_IMPACT_AND_DEPENDS_COLOR:14,DEFAULT_DEPTH:5,MAX_DEPTH:10,NO_DEPTH_LIMIT:1e4,initialState:null,directionVisibility:{},defaultColors:{},edgeColors:{},cy:null,impactContainer:null,editionMode:null,startNode:null,maxDepth:this.DEFAULT_DEPTH,readonly:true,fullscreen:false,selectedItemtype:"",addAssetPage:0,undoStack:[],redoStack:[],no_positions:[],badgesHitboxes:[],selectors:{ongoingDialog:"#ongoing_dialog",ongoingDialogBody:"#ongoing_dialog .modal-body",editCompoundDialog:"#edit_compound_dialog",editCompoundDialogSave:"#edit_compound_save",editCompoundDialogCancel:"#edit_compound_cancel",compoundName:"input[name=compound_name]",compoundColor:"input[name=compound_color]",dependsColor:"input[name=depends_color]",impactColor:"input[name=impact_color]",impactAndDependsColor:"input[name=impact_and_depends_color]",toggleImpact:"#toggle_impact",toggleDepends:"#toggle_depends",maxDepth:"#max_depth",maxDepthView:"#max_depth_view",helpText:"#help_text",save:"#save_impact",addNode:"#add_node",addEdge:"#add_edge",addCompound:"#add_compound",deleteElement:"#delete_element",export:"#export_graph",expandToolbar:"#expand_toolbar",toggleFullscreen:"#toggle_fullscreen",impactSettings:"#impact_settings",sideToggle:".impact-side-toggle",sideToggleIcon:".impact-side-toggle i",undo:"#impact_undo",redo:"#impact_redo",side:".impact-side",sidePanel:".impact-side-panel",sideAddNode:".impact-side-add-node",sideSettings:".impact-side-settings",sideSearch:".impact-side-search",sideSearchSpinner:".impact-side-search-spinner",sideSearchNoResults:".impact-side-search-no-results",sideSearchMore:".impact-side-search-more",sideSearchResults:".impact-side-search-results",sideSearchSelectItemtype:".impact-side-select-itemtype",sideSearchFilterItemtype:"#impact-side-filter-itemtypes",sideFilterAssets:"#impact-side-filter-assets",sideFilterItem:".impact-side-filter-itemtypes-item",form:"form[name=form_impact_network]",dropPreview:".impact-drop-preview"},eventData:{addEdgeStart:null,tmpEles:null,lastClicktimestamp:null,lastClickTarget:null,boxSelected:[],grabNodeStart:null,boundingBox:null,showPointerForBadge:false,previousCursor:"default",ctrlDown:false,editCompound:null},addToUndo:function(e,t){this.undoStack.push({code:e,data:t});$(this.selectors.undo).removeClass("impact-disabled");this.redoStack=[];$(this.selectors.redo).addClass("impact-disabled")},undo:function(){if(this.undoStack.length===0){return}var e=this.undoStack.pop();var t=e.data;this.redoStack.push(e);$(this.selectors.redo).removeClass("impact-disabled");switch(e.code){case this.ACTION_MOVE:this.cy.filter("node"+this.makeIDSelector(t.node)).position({x:t.oldPosition.x,y:t.oldPosition.y});if(t.newParent!==null){this.cy.filter("node"+this.makeIDSelector(t.node)).move({parent:null})}break;case this.ACTION_ADD_NODE:this.cy.getElementById(t.toAdd.data.id).remove();break;case this.ACTION_ADD_EDGE:this.cy.remove("edge"+this.makeIDSelector(t.id));this.updateFlags();break;case this.ACTION_ADD_COMPOUND:t.children.forEach(function(e){GLPIImpact.cy.filter("node"+GLPIImpact.makeIDSelector(e)).move({parent:null})});this.cy.remove("node"+this.makeIDSelector(t.data.id));this.updateFlags();break;case this.ACTION_ADD_GRAPH:t.edges.forEach(function(e){GLPIImpact.cy.getElementById(e.id).remove()});t.compounds.forEach(function(e){e.compoundChildren.forEach(function(e){GLPIImpact.cy.getElementById(e).move({parent:null})});GLPIImpact.cy.getElementById(e.compoundData.id).remove()});t.nodes.forEach(function(e){GLPIImpact.cy.getElementById(e.nodeData.id).remove()});this.updateFlags();break;case this.ACTION_EDIT_COMPOUND:this.cy.filter("node"+this.makeIDSelector(t.id)).data({label:t.oldLabel,color:t.oldColor});GLPIImpact.cy.trigger("change");break;case this.ACTION_REMOVE_FROM_COMPOUND:if(t.children.length<=2){this.cy.add({group:"nodes",data:t.compoundData});t.children.forEach(function(e){GLPIImpact.cy.getElementById(e).move({parent:t.compoundData.id})})}else{this.cy.getElementById(t.nodeData.id).move({parent:t.compoundData.id})}break;case this.ACTION_DELETE:t.nodes.forEach(function(e){var t=GLPIImpact.cy.add({group:"nodes",data:e.nodeData});t.position(e.nodePosition)});t.compounds.forEach(function(e){GLPIImpact.cy.add({group:"nodes",data:e.compoundData});e.compoundChildren.forEach(function(t){GLPIImpact.cy.getElementById(t).move({parent:e.compoundData.id})})});t.edges.forEach(function(e){GLPIImpact.cy.add({group:"edges",data:e})});this.updateFlags();break;case this.ACTION_EDIT_IMPACT_VISIBILITY:this.toggleVisibility(this.FORWARD);$(GLPIImpact.selectors.toggleImpact).prop("checked",!$(GLPIImpact.selectors.toggleImpact).prop("checked"));break;case this.ACTION_EDIT_DEPENDS_VISIBILITY:this.toggleVisibility(this.BACKWARD);$(GLPIImpact.selectors.toggleDepends).prop("checked",!$(GLPIImpact.selectors.toggleDepends).prop("checked"));break;case this.ACTION_EDIT_DEPENDS_COLOR:this.setEdgeColors({backward:t.oldColor});$(GLPIImpact.selectors.dependsColor).val(GLPIImpact.edgeColors[GLPIImpact.BACKWARD]);this.updateStyle();this.cy.trigger("change");break;case this.ACTION_EDIT_IMPACT_COLOR:this.setEdgeColors({forward:t.oldColor});$(GLPIImpact.selectors.impactColor).val(GLPIImpact.edgeColors[GLPIImpact.FORWARD]);this.updateStyle();this.cy.trigger("change");break;case this.ACTION_EDIT_IMPACT_AND_DEPENDS_COLOR:this.setEdgeColors({both:t.oldColor});$(GLPIImpact.selectors.impactAndDependsColor).val(GLPIImpact.edgeColors[GLPIImpact.BOTH]);this.updateStyle();this.cy.trigger("change");break;case this.ACTION_EDIT_MAX_DEPTH:this.setDepth(t.oldDepth);$(GLPIImpact.selectors.maxDepth).val(t.oldDepth);break}if(this.undoStack.length===0){$(this.selectors.undo).addClass("impact-disabled")}},redo:function(){if(this.redoStack.length===0){return}var e=this.redoStack.pop();var t=e.data;this.undoStack.push(e);$(this.selectors.undo).removeClass("impact-disabled");switch(e.code){case this.ACTION_MOVE:this.cy.filter("node"+this.makeIDSelector(t.node)).position({x:t.newPosition.x,y:t.newPosition.y});if(t.newParent!==null){this.cy.filter("node"+this.makeIDSelector(t.node)).move({parent:t.newParent})}break;case this.ACTION_ADD_NODE:this.cy.add(t.toAdd);break;case this.ACTION_ADD_EDGE:this.cy.add({group:"edges",data:t});this.updateFlags();break;case this.ACTION_ADD_COMPOUND:this.cy.add({group:"nodes",data:t.data});t.children.forEach(function(e){GLPIImpact.cy.filter("node"+GLPIImpact.makeIDSelector(e)).move({parent:t.data.id})});this.updateFlags();break;case this.ACTION_ADD_GRAPH:t.nodes.forEach(function(e){var t=GLPIImpact.cy.add({group:"nodes",data:e.nodeData});t.position(e.nodePosition)});t.compounds.forEach(function(e){GLPIImpact.cy.add({group:"nodes",data:e.compoundData});e.compoundChildren.forEach(function(t){GLPIImpact.cy.getElementById(t).move({parent:e.compoundData.id})})});t.edges.forEach(function(e){GLPIImpact.cy.add({group:"edges",data:e})});this.updateFlags();break;case this.ACTION_EDIT_COMPOUND:this.cy.filter("node"+this.makeIDSelector(t.id)).data({label:t.label,color:t.color});GLPIImpact.cy.trigger("change");break;case this.ACTION_REMOVE_FROM_COMPOUND:if(t.children.length<=2){t.children.forEach(function(e){GLPIImpact.cy.getElementById(e).move({parent:null})});this.cy.getElementById(t.compoundData.id).remove()}else{this.cy.getElementById(t.nodeData.id).move({parent:null})}break;case this.ACTION_DELETE:t.edges.forEach(function(e){GLPIImpact.cy.getElementById(e.id).remove()});t.compounds.forEach(function(e){e.compoundChildren.forEach(function(e){GLPIImpact.cy.getElementById(e).move({parent:null})});GLPIImpact.cy.getElementById(e.compoundData.id).remove()});t.nodes.forEach(function(e){GLPIImpact.cy.getElementById(e.id).remove()});this.updateFlags();break;case this.ACTION_EDIT_IMPACT_VISIBILITY:this.toggleVisibility(this.FORWARD);$(GLPIImpact.selectors.toggleImpact).prop("checked",!$(GLPIImpact.selectors.toggleImpact).prop("checked"));break;case this.ACTION_EDIT_DEPENDS_VISIBILITY:this.toggleVisibility(this.BACKWARD);$(GLPIImpact.selectors.toggleDepends).prop("checked",!$(GLPIImpact.selectors.toggleDepends).prop("checked"));break;case this.ACTION_EDIT_DEPENDS_COLOR:this.setEdgeColors({backward:t.newColor});$(GLPIImpact.selectors.dependsColor).val(GLPIImpact.edgeColors[GLPIImpact.BACKWARD]);this.updateStyle();this.cy.trigger("change");break;case this.ACTION_EDIT_IMPACT_COLOR:this.setEdgeColors({forward:t.newColor});$(GLPIImpact.selectors.forwardColor).val("set",GLPIImpact.edgeColors[GLPIImpact.FORWARD]);this.updateStyle();this.cy.trigger("change");break;case this.ACTION_EDIT_IMPACT_AND_DEPENDS_COLOR:this.setEdgeColors({both:t.newColor});$(GLPIImpact.selectors.impactAndDependsColor).val(GLPIImpact.edgeColors[GLPIImpact.BOTH]);this.updateStyle();this.cy.trigger("change");break;case this.ACTION_EDIT_MAX_DEPTH:this.setDepth(t.newDepth);$(GLPIImpact.selectors.maxDepth).val(t.newDepth);break}if(this.redoStack.length===0){$(this.selectors.redo).addClass("impact-disabled")}},getHiddenSelector:function(){var e="[depth > "+this.maxDepth+"][depth !> "+Number.MAX_SAFE_INTEGER+"]";var t;var a=this.directionVisibility[this.FORWARD];var o=this.directionVisibility[this.BACKWARD];if(a&&o){t="[flag = -1]"}else if(a&&!o){t="[flag = "+this.BACKWARD+"]"}else if(!a&&o){t="[flag = "+this.FORWARD+"]"}else{t="[flag != 0]"}return t+", "+e},getNetworkStyle:function(){let e=$(document.body).css("--tblr-body-color");if(!e||e===""){e="#000000"}return[{selector:"core",style:{"selection-box-opacity":"0.2","selection-box-border-width":"0","selection-box-color":"#24acdf"}},{selector:"node",style:{color:e}},{selector:"node:parent",style:{padding:"30px",shape:"roundrectangle","border-width":"1px","background-opacity":"0.5","font-size":"1.1em","background-color":"#d2d2d2","text-margin-y":"20px","text-opacity":.7}},{selector:"node:parent[label]",style:{label:"data(label)"}},{selector:"node:parent[color]",style:{"border-color":"data(color)","background-color":"data(color)"}},{selector:"node[image]",style:{label:"data(label)",shape:"rectangle","background-color":"#666","background-image":"data(image)","background-fit":"contain","background-opacity":"0","font-size":"1em","text-opacity":.7,"overlay-opacity":.01,"overlay-color":"white"}},{selector:"node[highlight=1]",style:{"font-weight":"bold"}},{selector:":selected",style:{"overlay-opacity":.2,"overlay-color":"gray"}},{selector:"[todelete=1]:selected",style:{"overlay-opacity":.2,"overlay-color":"red"}},{selector:GLPIImpact.getHiddenSelector(),style:{display:"none"}},{selector:'[id="tmp_node"]',style:{opacity:0}},{selector:"edge",style:{width:1,"line-color":this.edgeColors[0],"target-arrow-color":this.edgeColors[0],"target-arrow-shape":"triangle","arrow-scale":.7,"curve-style":"bezier","source-endpoint":"outside-to-node-or-label","target-endpoint":"outside-to-node-or-label","source-distance-from-node":"2px","target-distance-from-node":"2px"}},{selector:'edge[target="tmp_node"]',style:{"source-endpoint":"inside-to-node","target-endpoint":"inside-to-node","source-distance-from-node":"0px","target-distance-from-node":"0px"}},{selector:"[flag="+GLPIImpact.FORWARD+"]",style:{"line-color":this.edgeColors[GLPIImpact.FORWARD],"target-arrow-color":this.edgeColors[GLPIImpact.FORWARD]}},{selector:"[flag="+GLPIImpact.BACKWARD+"]",style:{"line-color":this.edgeColors[GLPIImpact.BACKWARD],"target-arrow-color":this.edgeColors[GLPIImpact.BACKWARD]}},{selector:"[flag="+GLPIImpact.BOTH+"]",style:{"line-color":this.edgeColors[GLPIImpact.BOTH],"target-arrow-color":this.edgeColors[GLPIImpact.BOTH]}}]},getPresetLayout:function(e){this.no_positions=[];return{name:"preset",positions:function(t){var a=0;var o=0;if(!t.isParent()&&e[t.data("id")]!==undefined){a=parseFloat(e[t.data("id")].x);o=parseFloat(e[t.data("id")].y)}return{x:a,y:o}}}},generateMissingPositions:function(){if(this.cy.filter("node:childless").length==this.no_positions.length){this.no_positions.pop()}var e=[];this.no_positions.forEach(function(t){e.push(t.data("id"))});var t=[];var a=[];while(this.no_positions.length!==0){this.no_positions.forEach(function(o,i){var c=false;o.neighborhood().forEach(function(t){if(c){return}if(!t.isNode()){return}if(e.indexOf(t.data("id"))===-1||a.indexOf(t.data("id"))!==-1){c=true}});if(c){a.push(o.data("id"));t.push(o);GLPIImpact.no_positions.splice(i,1)}})}this.no_positions=t;this.no_positions.forEach(function(t){var a=null;t.neighborhood().forEach(function(o){if(a!==null){return}if(!o.isNode()){return}if(o.data("id")==t.data("id")){return}if(e.indexOf(o.data("id"))!==-1){return}a=o});if(a===null){return}var o=null;var i=Number.MAX_SAFE_INTEGER;a.neighborhood().forEach(function(e){if(!e.isNode()){return}var t=GLPIImpact.getDistance(a.position(),e.position());if(t<i){i=t;o=e}});if(o===null){i=100}var c=t.edgesTo(a)[0];if(c==undefined){c=a.edgesTo(t)[0]}var s;if(c.data("target")==t.data("id")){s=1}else{s=-1}var n=false;while(!n){var r=0;var I=false;while(r!==-75){var d={x:s*(i*Math.cos(r*(Math.PI/180)))+a.position().x,y:i*Math.sin(r*(Math.PI/180))+a.position().y};var p=true;GLPIImpact.cy.filter().forEach(function(e){var t=e.boundingBox();if(t.x1-20<d.x&&t.x2+20>d.x&&t.y1-20<d.y&&t.y2+20>d.y){p=false}});if(p){t.position(d);var l=e.indexOf(t.data("id"));e.splice(l,1);n=true;break}if(!I&&r!==0){r=r*-1;I=true}else{if(r<0){r=0-r;I=false}r+=15}}i+=30}});this.no_positions=[]},getDagreLayout:function(){return{name:"dagre",rankDir:"LR",fit:false}},getCurrentState:function(){var e={edges:{},compounds:{},items:{}};GLPIImpact.cy.edges().forEach(function(t){e.edges[t.data("id")]={source:t.data("source"),target:t.data("target")}});GLPIImpact.cy.filter("node:parent").forEach(function(t){e.compounds[t.data("id")]={name:t.data("label"),color:t.data("color")}});GLPIImpact.cy.filter("node:childless").forEach(function(t){e.items[t.data("id")]={impactitem_id:t.data("impactitem_id"),parent:t.data("parent"),position:t.position()}});return e},computeEdgeDelta:function(e){var t={};Object.keys(GLPIImpact.initialState.edges).forEach(function(a){var o=GLPIImpact.initialState.edges[a];if(Object.prototype.hasOwnProperty.call(e,a)){delete e[a]}else{var i=o.source.split(GLPIImpact.NODE_ID_SEPERATOR);var c=o.target.split(GLPIImpact.NODE_ID_SEPERATOR);t[a]={action:GLPIImpact.DELTA_ACTION_DELETE,itemtype_source:i[0],items_id_source:i[1],itemtype_impacted:c[0],items_id_impacted:c[1]}}});Object.keys(e).forEach(function(a){var o=e[a];var i=o.source.split(GLPIImpact.NODE_ID_SEPERATOR);var c=o.target.split(GLPIImpact.NODE_ID_SEPERATOR);t[a]={action:GLPIImpact.DELTA_ACTION_ADD,itemtype_source:i[0],items_id_source:i[1],itemtype_impacted:c[0],items_id_impacted:c[1]}});return t},computeCompoundsDelta:function(e){var t={};Object.keys(GLPIImpact.initialState.compounds).forEach(function(a){var o=GLPIImpact.initialState.compounds[a];if(Object.prototype.hasOwnProperty.call(e,a)){var i=e[a];if(o.name!=i.name||o.color!=i.color){t[a]={action:GLPIImpact.DELTA_ACTION_UPDATE,name:i.name,color:i.color}}delete e[a]}else{t[a]={action:GLPIImpact.DELTA_ACTION_DELETE}}});Object.keys(e).forEach(function(a){t[a]={action:GLPIImpact.DELTA_ACTION_ADD,name:e[a].name,color:e[a].color}});return t},computeContext:function(e){var t={};Object.keys(e).forEach(function(a){var o=e[a];t[a]={x:o.position.x,y:o.position.y}});return{node_id:this.startNode,positions:JSON.stringify(t),zoom:GLPIImpact.cy.zoom(),pan_x:GLPIImpact.cy.pan().x,pan_y:GLPIImpact.cy.pan().y,impact_color:GLPIImpact.edgeColors[GLPIImpact.FORWARD],depends_color:GLPIImpact.edgeColors[GLPIImpact.BACKWARD],impact_and_depends_color:GLPIImpact.edgeColors[GLPIImpact.BOTH],show_depends:GLPIImpact.directionVisibility[GLPIImpact.BACKWARD],show_impact:GLPIImpact.directionVisibility[GLPIImpact.FORWARD],max_depth:GLPIImpact.maxDepth}},computeItemsDelta:function(e){var t={};Object.keys(e).forEach(function(a){var o=e[a];t[o.impactitem_id]={action:GLPIImpact.DELTA_ACTION_UPDATE,parent_id:o.parent};if(o.parent==undefined){o.parent=0}t[o.impactitem_id]={action:GLPIImpact.DELTA_ACTION_UPDATE,parent_id:o.parent}});return t},computeDelta:function(){var e={};var t=this.getCurrentState();e.edges=this.computeEdgeDelta(t.edges);e.compounds=this.computeCompoundsDelta(t.compounds);e.items=this.computeItemsDelta(t.items);e.context=this.computeContext(t.items);return e},getContextMenuItems:function(){return[{id:"goTo",content:'<i class="fas fa-link me-2"></i>'+__("Go to"),tooltipText:_.unescape(__("Open this element in a new tab")),selector:"node[link]",onClickFunction:this.menuOnGoTo},{id:"showOngoing",content:'<i class="fas fa-list me-2"></i>'+__("Show ongoing tickets"),tooltipText:_.unescape(__("Show ongoing tickets for this item")),selector:"node[hasITILObjects=1]",onClickFunction:this.menuOnShowOngoing},{id:"editCompound",content:'<i class="fas fa-edit me-2"></i>'+__("Group properties..."),tooltipText:_.unescape(__("Set name and/or color for this group")),selector:"node:parent",onClickFunction:this.menuOnEditCompound,show:!this.readonly},{id:"removeFromCompound",content:'<i class="fas fa-external-link-alt me-2"></i>'+__("Remove from group"),tooltipText:_.unescape(__("Remove this asset from the group")),selector:"node:child",onClickFunction:this.menuOnRemoveFromCompound,show:!this.readonly},{id:"delete",content:'<i class="fas fa-trash me-2"></i>'+__("Delete"),tooltipText:_.unescape(__("Delete element")),selector:"node, edge",onClickFunction:this.menuOnDelete,show:!this.readonly}]},addNode:function(e,t,a){var o={itemtype:t,items_id:e};var i=GLPIImpact.makeID(GLPIImpact.NODE,o.itemtype,o.items_id);if(GLPIImpact.cy.filter('node[id="'+i+'"]').length>0){alert(__("This asset already exists."));return}$.when(GLPIImpact.buildGraphFromNode(o)).done(function(e,t){GLPIImpact.insertGraph(e,t,{id:i,x:a.x,y:a.y});GLPIImpact.updateFlags()}).fail(function(){alert(__("Unexpected error."))})},showOngoingDialog:function(e){$(GLPIImpact.selectors.ongoingDialogBody).html(GLPIImpact.buildOngoingDialogContent(e));$(GLPIImpact.selectors.ongoingDialog).modal("show")},prepareEditCompoundDialog:function(){$(this.selectors.editCompoundDialogSave).on("click",function(){var e=GLPIImpact.eventData.editCompound.target;e.data("label",$(GLPIImpact.selectors.compoundName).val());e.data("color",$(GLPIImpact.selectors.compoundColor).val());$(GLPIImpact.selectors.editCompoundDialog).modal("hide");GLPIImpact.cy.trigger("change");if(GLPIImpact.eventData.newCompound==null){var t=GLPIImpact.eventData.editCompound.previousLabel;var a=GLPIImpact.eventData.editCompound.previousColor;GLPIImpact.addToUndo(GLPIImpact.ACTION_EDIT_COMPOUND,{id:e.data("id"),label:e.data("label"),color:e.data("color"),oldLabel:t,oldColor:a})}else{var o=$(GLPIImpact.selectors.compoundName).val();var i=$(GLPIImpact.selectors.compoundColor).val();GLPIImpact.eventData.newCompound.data.label=o;GLPIImpact.eventData.newCompound.data.color=i;GLPIImpact.addToUndo(GLPIImpact.ACTION_ADD_COMPOUND,_.cloneDeep(GLPIImpact.eventData.newCompound));GLPIImpact.eventData.newCompound=null}})},showEditCompoundDialog:function(e){var t=e.data("label");var a=e.data("color");$(GLPIImpact.selectors.compoundName).val(t);$(GLPIImpact.selectors.compoundColor).val(a);this.eventData.editCompound={target:e,previousLabel:t,previousColor:a};$(GLPIImpact.selectors.editCompoundDialog).modal("show")},prepareNetwork:function(e,t,a){this.impactContainer=e;this.directionVisibility[GLPIImpact.FORWARD]=true;this.directionVisibility[GLPIImpact.BACKWARD]=true;this.defaultColors=t;this.setEdgeColors(t);this.startNode=a;this.prepareEditCompoundDialog();this.initToolbar()},buildNetwork:function(e,t,a){var o;GLPIImpact.showDefaultWorkspaceStatus();if(t.impactcontexts_id!==undefined&&t.impactcontexts_id!==0){this.setEdgeColors({forward:t.impact_color,backward:t.depends_color,both:t.impact_and_depends_color});this.maxDepth=t.max_depth;o=this.getPresetLayout(JSON.parse(t.positions))}else{this.setEdgeColors(this.defaultColors);this.maxDepth=this.DEFAULT_DEPTH;o=this.getDagreLayout()}this.cy=cytoscape({container:this.impactContainer,elements:e,style:this.getNetworkStyle(),layout:o,wheelSensitivity:.25});this.generateMissingPositions();this.cy.minZoom(.5);this.initialState=this.getCurrentState();if(!a){this.enableGraphEdition()}this.cy.filter("node[start]").data({highlight:1,start_node:1});this.cy.contextMenus({menuItems:this.getContextMenuItems(),menuItemClasses:[],contextMenuClasses:[]});this.cy.gridGuide({gridStackOrder:0,snapToGridOnRelease:false,snapToGridDuringDrag:true,gridSpacing:12,drawGrid:true,panGrid:true,gridColor:getComputedStyle(document.documentElement).getPropertyValue("--card-border-color")});this.cy.boxSelectionEnabled(false);if(t.impactcontexts_id!==undefined&&t.impactcontexts_id!==0){if(!parseInt(t.show_depends)){$(GLPIImpact.selectors.toggleImpact).prop("checked",false)}if(!parseInt(t.show_impact)){$(GLPIImpact.selectors.toggleDepends).prop("checked",false)}this.updateFlags();if(t.zoom!="0"){this.cy.viewport({zoom:parseFloat(t.zoom),pan:{x:parseFloat(t.pan_x),y:parseFloat(t.pan_y)}});var i=GLPIImpact.cy.extent();var c=true;GLPIImpact.cy.nodes().forEach(function(e){if(e.position().x>i.x1&&e.position().x<i.x2&&e.position().y>i.x1&&e.position().y<i.x2){c=false}});if(c||GLPIImpact.cy.filter("node:childless").length==1){this.cy.fit();if(this.cy.zoom()>2.3){this.cy.zoom(2.3);this.cy.center()}}}else{this.cy.fit();if(this.cy.zoom()>2.3){this.cy.zoom(2.3);this.cy.center()}}}else{this.cy.fit();if(this.cy.zoom()>2.3){this.cy.zoom(2.3);this.cy.center()}}this.cy.on("mousedown","node",this.nodeOnMousedown);this.cy.on("mouseup",this.onMouseUp);this.cy.on("mousemove",this.onMousemove);this.cy.on("mouseover",this.onMouseover);this.cy.on("mouseout",this.onMouseout);this.cy.on("click",this.onClick);this.cy.on("click","edge",this.edgeOnClick);this.cy.on("click","node",this.nodeOnClick);this.cy.on("box",this.onBox);this.cy.on("drag add remove change",this.onChange);this.cy.on("doubleClick",this.onDoubleClick);this.cy.on("remove",this.onRemove);this.cy.on("grabon",this.onGrabOn);this.cy.on("freeon",this.onFreeOn);this.initCanvasOverlay();$(document).keydown(this.onKeyDown);$(document).keyup(this.onKeyUp);this.setEditionMode(GLPIImpact.EDITION_DEFAULT);var s=GLPIImpact.maxDepth;if(GLPIImpact.maxDepth>=GLPIImpact.MAX_DEPTH){s="infinity"}$(GLPIImpact.selectors.maxDepthView).html(s);$(GLPIImpact.selectors.maxDepth).val(GLPIImpact.maxDepth);$(GLPIImpact.selectors.dependsColor).val(GLPIImpact.edgeColors[GLPIImpact.BACKWARD]);$(GLPIImpact.selectors.impactColor).val(GLPIImpact.edgeColors[GLPIImpact.FORWARD]);$(GLPIImpact.selectors.impactAndDependsColor).val(GLPIImpact.edgeColors[GLPIImpact.BOTH])},enableGraphEdition:function(){$(this.selectors.save).show();$(this.selectors.addNode).show();$(this.selectors.addEdge).show();$(this.selectors.addCompound).show();$(this.selectors.deleteElement).show();$(this.selectors.impactSettings).show();$(this.selectors.sideToggle).show();this.readonly=false},makeID:function(e,t,a){switch(e){case GLPIImpact.NODE:return t+"::"+a;case GLPIImpact.EDGE:return t+"->"+a}return null},makeIDSelector:function(e){return"[id='"+e+"']"},updateStyle:function(){this.cy.style(this.getNetworkStyle());this.cy.edges().forEach(function(e){var t=GLPIImpact.cy.filter(GLPIImpact.makeIDSelector(e.data("source")));var a=GLPIImpact.cy.filter(GLPIImpact.makeIDSelector(e.data("target")));if(t.visible()&&a.visible()){e.data("depth",0)}else{e.data("depth",Number.MAX_VALUE)}})},updateFlags:function(){this.cy.elements().forEach(function(e){e.data("flag",GLPIImpact.DEFAULT)});var e=this.cy.elements().dijkstra(this.makeIDSelector(this.startNode),function(){return 1},true);this.cy.$("node:childless").forEach(function(t){var a=e.distanceTo(t);t.data("depth",a);if(a!==Infinity){t.data("flag",t.data("flag")|GLPIImpact.FORWARD)}});this.cy.$("node:childless").forEach(function(e){if(e.data("id")==GLPIImpact.startNode){return}var t=GLPIImpact.cy.elements().dijkstra(e,function(){return 1},true);var a=t.distanceTo(GLPIImpact.makeIDSelector(GLPIImpact.startNode));if(e.data("depth")>a){e.data("depth",a)}if(a!==Infinity){e.data("flag",e.data("flag")|GLPIImpact.BACKWARD)}});GLPIImpact.cy.$(GLPIImpact.makeIDSelector(GLPIImpact.startNode)).data("flag",this.BOTH);this.cy.filter("node:parent").forEach(function(e){var t=Infinity;var a=GLPIImpact.DEFAULT;e.children().forEach(function(e){var o=e.data("depth");if(o<t){t=o}a=a|e.data("flag")});e.data("depth",t);e.data("flag",a)});this.cy.edges().forEach(function(e){var t=GLPIImpact.cy.$(GLPIImpact.makeIDSelector(e.data("source")));var a=GLPIImpact.cy.$(GLPIImpact.makeIDSelector(e.data("target")));e.data("flag",t.data("flag")&a.data("flag"))});GLPIImpact.cy.$(GLPIImpact.makeIDSelector(GLPIImpact.startNode)).data("flag",this.DEFAULT);GLPIImpact.updateStyle()},toggleVisibility:function(e){GLPIImpact.directionVisibility[e]=!GLPIImpact.directionVisibility[e];GLPIImpact.updateFlags();GLPIImpact.cy.trigger("change")},setDepth:function(e){GLPIImpact.maxDepth=e;if(e>=GLPIImpact.MAX_DEPTH){e="infinity";GLPIImpact.maxDepth=GLPIImpact.NO_DEPTH_LIMIT}$(GLPIImpact.selectors.maxDepthView).html(e);GLPIImpact.updateStyle();GLPIImpact.cy.trigger("change")},buildGraphFromNode:function(e){e.action="load";var t=jQuery.Deferred();$.ajax({type:"GET",url:CFG_GLPI.root_doc+"/ajax/impact.php",dataType:"json",data:e,success:function(e){t.resolve(JSON.parse(e.graph),JSON.parse(e.params))},error:function(){t.reject()}});return t.promise()},getDistance:function(e,t){return Math.sqrt(Math.pow(t.x-e.x,2)+Math.pow(t.y-e.y,2))},insertGraph:function(e,t,a){var o=[];var i=this.cy.filter().boundingBox();var c;for(c=0;c<e.length;c++){var s=e[c].data.id;if(this.cy.filter('[id="'+s+'"]').length>0){continue}o.push(e[c]);if(e[c].group=="nodes"&&e[c].data.color===undefined){var n=e[c].data.id.split(GLPIImpact.NODE_ID_SEPERATOR);var r=n[0];var I=n[1];$("p[data-id="+I+"][data-type='"+r+"']").remove()}}if(o.length==1){o[0].position={x:a.x,y:a.y};this.cy.add(o);this.addToUndo(this.ACTION_ADD_NODE,{toAdd:o[0]});return}var d=this.cy.add(o);var p;if(t.positions===undefined){p=this.getDagreLayout()}else{p=this.getPresetLayout(JSON.parse(t.positions))}var l=d.layout(p);l.run();this.generateMissingPositions();var m=d.boundingBox();var u={x:(m.x1+m.x2)/2,y:(m.y1+m.y2)/2};var h=[a.x-u.x,a.y-u.y];d.nodes().forEach(function(e){if(!e.isParent()){e.position({x:e.position().x+h[0],y:e.position().y+h[1]})}});m=d.boundingBox();if(!(i.x1>m.x2||m.x1>i.x2||i.y1>m.y2||m.y1>i.y2)){u={x:Math.round((m.x1+m.x2)/2),y:Math.round((m.y1+m.y2)/2)};var P=[[1,0],[0,1],[-1,0],[0,-1],[1,1],[-1,1],[-1,-1],[1,-1]];var L=[{a:{x:Math.round(i.x1),y:Math.round(i.y1)},b:{x:Math.round(i.x2),y:Math.round(i.y1)}},{a:{x:Math.round(i.x2),y:Math.round(i.y1)},b:{x:Math.round(i.x1),y:Math.round(i.y2)}},{a:{x:Math.round(i.x1),y:Math.round(i.y2)},b:{x:Math.round(i.x2),y:Math.round(i.y2)}},{a:{x:Math.round(i.x2),y:Math.round(i.y2)},b:{x:Math.round(i.x1),y:Math.round(i.y1)}}];c=0;var D;while(c<5e4){P.forEach(function(e){if(D!==undefined){return}var t={x:u.x+e[0]*c,y:u.y+e[1]*c};L.forEach(function(e){if(D!==undefined){return}if(GLPIImpact.getDistance(t,e.a)+GLPIImpact.getDistance(t,e.b)==GLPIImpact.getDistance(e.a,e.b)){D={x:t.x,y:t.y}}})});c++;if(D!==undefined){break}}if(D!==undefined){u={x:(i.x1+i.x2)/2,y:(i.y1+i.y2)/2};var G=[{x:m.x1,y:m.y1},{x:m.x1,y:m.y2},{x:m.x2,y:m.y1},{x:m.x2,y:m.y2}];var g;var f;G.forEach(function(e){var t=GLPIImpact.getDistance(e,u);if(f==undefined||t<f){f=t;g=e}});var E=[D.x-g.x,D.y-g.y];d.nodes().forEach(function(e){if(!e.isParent()){e.position({x:e.position().x+E[0],y:e.position().y+E[1]})}})}}this.generateMissingPositions();this.cy.animate({center:{eles:GLPIImpact.cy.filter("")}});this.cy.getElementById(a.id).data("highlight",1);var y={edges:d.edges().map(function(e){return e.data()}),compounds:[],nodes:[]};d.nodes().forEach(function(e){if(e.isParent()){y.compounds.push({compoundData:_.clone(e.data()),compoundChildren:e.children().map(function(e){return e.data("id")})})}else{y.nodes.push({nodeData:_.clone(e.data()),nodePosition:_.clone(e.position())})}});this.addToUndo(this.ACTION_ADD_GRAPH,y)},setEdgeColors:function(e){this.setColorIfExist(GLPIImpact.DEFAULT,e.default);this.setColorIfExist(GLPIImpact.BACKWARD,e.backward);this.setColorIfExist(GLPIImpact.FORWARD,e.forward);this.setColorIfExist(GLPIImpact.BOTH,e.both)},setColorIfExist:function(e,t){if(t!==undefined){this.edgeColors[e]=t}},setEditionMode:function(e){if(this.editionMode==e){e=GLPIImpact.EDITION_DEFAULT}this.exitEditionMode();this.enterEditionMode(e);this.editionMode=e},exitEditionMode:function(){switch(this.editionMode){case GLPIImpact.EDITION_DEFAULT:GLPIImpact.cy.nodes().ungrabify();break;case GLPIImpact.EDITION_ADD_NODE:GLPIImpact.cy.nodes().ungrabify();$(GLPIImpact.selectors.sideToggleIcon).addClass("fa-chevron-left");$(GLPIImpact.selectors.sideToggleIcon).removeClass("fa-chevron-right");$(GLPIImpact.selectors.side).removeClass("impact-side-expanded");$(GLPIImpact.selectors.sidePanel).removeClass("impact-side-expanded");$(GLPIImpact.selectors.addNode).removeClass("active");break;case GLPIImpact.EDITION_ADD_EDGE:$(GLPIImpact.selectors.addEdge).removeClass("active");GLPIImpact.eventData.addEdgeStart=null;GLPIImpact.cy.filter("#tmp_node").remove();break;case GLPIImpact.EDITION_DELETE:GLPIImpact.cy.filter().unselect();GLPIImpact.cy.data("todelete",0);$(GLPIImpact.selectors.deleteElement).removeClass("active");break;case GLPIImpact.EDITION_ADD_COMPOUND:GLPIImpact.cy.panningEnabled(true);GLPIImpact.cy.boxSelectionEnabled(false);$(GLPIImpact.selectors.addCompound).removeClass("active");break;case GLPIImpact.EDITION_SETTINGS:GLPIImpact.cy.nodes().ungrabify();$(GLPIImpact.selectors.sideToggleIcon).addClass("fa-chevron-left");$(GLPIImpact.selectors.sideToggleIcon).removeClass("fa-chevron-right");$(GLPIImpact.selectors.side).removeClass("impact-side-expanded");$(GLPIImpact.selectors.sidePanel).removeClass("impact-side-expanded");$(GLPIImpact.selectors.impactSettings).removeClass("active");break}},enterEditionMode:function(e){switch(e){case GLPIImpact.EDITION_DEFAULT:GLPIImpact.clearHelpText();GLPIImpact.cy.nodes().grabify();$(GLPIImpact.impactContainer).css("cursor","move");break;case GLPIImpact.EDITION_ADD_NODE:GLPIImpact.cy.nodes().grabify();GLPIImpact.clearHelpText();$(GLPIImpact.selectors.sideToggleIcon).removeClass("fa-chevron-left");$(GLPIImpact.selectors.sideToggleIcon).addClass("fa-chevron-right");$(GLPIImpact.selectors.side).addClass("impact-side-expanded");$(GLPIImpact.selectors.sidePanel).addClass("impact-side-expanded");$(GLPIImpact.selectors.addNode).addClass("active");$(GLPIImpact.impactContainer).css("cursor","move");$(GLPIImpact.selectors.sideSettings).hide();$(GLPIImpact.selectors.sideAddNode).show();break;case GLPIImpact.EDITION_ADD_EDGE:GLPIImpact.showHelpText(__("Draw a line between two assets to add an impact relation"));$(GLPIImpact.selectors.addEdge).addClass("active");$(GLPIImpact.impactContainer).css("cursor","crosshair");break;case GLPIImpact.EDITION_DELETE:GLPIImpact.cy.filter().unselect();GLPIImpact.showHelpText(__("Click on an element to remove it from the network"));$(GLPIImpact.selectors.deleteElement).addClass("active");$(GLPIImpact.impactContainer).css("cursor","move");break;case GLPIImpact.EDITION_ADD_COMPOUND:GLPIImpact.cy.panningEnabled(false);GLPIImpact.cy.boxSelectionEnabled(true);GLPIImpact.showHelpText(__("Draw a square containing the assets you wish to group"));$(GLPIImpact.selectors.addCompound).addClass("active");$(GLPIImpact.impactContainer).css("cursor","crosshair");break;case GLPIImpact.EDITION_SETTINGS:GLPIImpact.cy.nodes().grabify();$(GLPIImpact.selectors.sideToggleIcon).removeClass("fa-chevron-left");$(GLPIImpact.selectors.sideToggleIcon).addClass("fa-chevron-right");$(GLPIImpact.selectors.side).addClass("impact-side-expanded");$(GLPIImpact.selectors.sidePanel).addClass("impact-side-expanded");$(GLPIImpact.selectors.impactSettings).addClass("active");$(GLPIImpact.selectors.sideAddNode).hide();$(GLPIImpact.selectors.sideSettings).show();break}},showHelpText:function(e){$(GLPIImpact.selectors.helpText).html(e).show()},clearHelpText:function(){$(GLPIImpact.selectors.helpText).hide()},download:function(e,t){var a;var o;GLPIImpact.impactContainer.append("<a id='impact_download'></a>");var i=$("#impact_download");switch(e){case"png":a="impact.png";o=this.cy.png({bg:t?"transparent":"white"});break;case"jpeg":a="impact.jpeg";o=this.cy.jpg();break}i.prop("download",a);i.prop("href",o);i[0].click();i.remove()},getNodeAt:function(e,t){var a=this.cy.nodes();for(var o=0;o<a.length;o++){if(a[o].boundingBox().x1<e.x&&a[o].boundingBox().x2>e.x&&a[o].boundingBox().y1<e.y&&a[o].boundingBox().y2>e.y){if(t(a[o])){return a[o]}}}return null},showCleanWorkspaceStatus:function(){$(GLPIImpact.selectors.save).removeClass("dirty");$(GLPIImpact.selectors.save).removeClass("clean");$(GLPIImpact.selectors.save).addClass("clean")},showDirtyWorkspaceStatus:function(){$(GLPIImpact.selectors.save).removeClass("clean");$(GLPIImpact.selectors.save).addClass("dirty")},showDefaultWorkspaceStatus:function(){$(GLPIImpact.selectors.save).removeClass("clean");$(GLPIImpact.selectors.save).removeClass("dirty")},buildOngoingDialogContent:function(e){return this.listElements(__("Requests"),e.requests,"ticket")+this.listElements(__("Incidents"),e.incidents,"ticket")+this.listElements(__("Changes"),e.changes,"change")+this.listElements(__("Problems"),e.problems,"problem")},listElements:function(e,t,a){var o="";if(t.length>0){o+="<h3>"+e+"</h3>";o+="<ul>";t.forEach(function(e){var t=CFG_GLPI.root_doc+"/front/"+a+".form.php?id="+e.id;o+='<li><a target="_blank" href="'+t+'">'+e.name+"</a></li>"});o+="</ul>"}return o},addCompoundFromSelection:_.debounce(function(){if(GLPIImpact.eventData.boxSelected.length<1){alert(__("You need to select at least 1 asset to make a group"))}else{var e=GLPIImpact.cy.add({group:"nodes",data:{color:"#dadada"}});GLPIImpact.eventData.newCompound={data:{id:e.data("id")},children:[]};GLPIImpact.eventData.boxSelected.forEach(function(t){t.move({parent:e.data("id")});GLPIImpact.eventData.newCompound.children.push(t.data("id"))});GLPIImpact.showEditCompoundDialog(e);GLPIImpact.setEditionMode(GLPIImpact.EDITION_DEFAULT)}GLPIImpact.eventData.boxSelected=[];GLPIImpact.cy.filter(":selected").unselect()},100,false),deleteFromGraph:function(e){if(e.data("id")==GLPIImpact.startNode){alert("Can't remove starting node");return}var t={edges:[],nodes:[],compounds:[]};if(e.isEdge()){t.edges.push(_.clone(e.data()));e.remove()}else if(e.isParent()){t.compounds.push({compoundData:_.clone(e.data()),compoundChildren:e.children().map(function(e){return e.data("id")})});e.children().move({parent:null});e.remove()}else{if(!e.isOrphan()&&e.parent().children().length<=2){var a=e.parent();t.compounds.push({compoundData:_.clone(a.data()),compoundChildren:a.children().map(function(e){return e.data("id")})});a.children().move({parent:null});a.remove()}t.nodes.push({nodeData:_.clone(e.data()),nodePosition:_.clone(e.position())});t.edges=t.edges.concat(e.connectedEdges(function(e){var a=false;t.edges.forEach(function(t){if(t.id==e.data("id")){a=true}});if(GLPIImpact.eventData.multipleDeletion!=null){GLPIImpact.eventData.multipleDeletion.edges.forEach(function(t){if(t.id==e.data("id")){a=true}})}return!a}).map(function(e){return e.data()}));e.remove()}GLPIImpact.updateFlags();if(this.eventData.multipleDeletion!=null){this.eventData.multipleDeletion.edges=this.eventData.multipleDeletion.edges.concat(t.edges);this.eventData.multipleDeletion.nodes=this.eventData.multipleDeletion.nodes.concat(t.nodes);this.eventData.multipleDeletion.compounds=this.eventData.multipleDeletion.compounds.concat(t.compounds)}else{this.addToUndo(this.ACTION_DELETE,t)}},toggleFullscreen:function(){this.fullscreen=!this.fullscreen;$(this.selectors.toggleFullscreen).toggleClass("active");$(this.impactContainer).toggleClass("fullscreen");$(this.selectors.side).toggleClass("fullscreen");if(this.fullscreen){$(this.impactContainer).children("canvas:eq(0)").css({height:"100vh"});$("html, body").css("overflow","hidden")}else{$(this.impactContainer).children("canvas:eq(0)").css({height:"unset"});$("html, body").css("overflow","unset")}GLPIImpact.cy.resize()},checkBadgeHitboxes:function(e,t,a){var o=false;var i=5*GLPIImpact.cy.zoom();GLPIImpact.badgesHitboxes.forEach(function(c){if(o){return}var s=c.position;var n={x1:s.x-i,x2:s.x+i,y1:s.y-i,y2:s.y+i};if(n.x1<e.x&&n.x2>e.x&&n.y1<e.y&&n.y2>e.y){o=true;if(t){var r=c.target;r+="&criteria[0][link]=AND&criteria[0][field]=13&criteria[0][searchtype]=contains&criteria[0][value]="+c.id;r+="&criteria[1][link]=AND&criteria[1][field]=131&criteria[1][searchtype]=equals&criteria[1][value]="+c.itemtype;r+="&criteria[2][link]=AND&criteria[2][field]=14&criteria[2][searchtype]=equals&criteria[2][value]=1";r+="&criteria[3][link]=AND&criteria[3][field]=12&criteria[3][searchtype]=equals&criteria[3][value]=notold";if(a){window.open(r)}else{window.location.href=r}}}});return o},onClick:function(e){switch(GLPIImpact.editionMode){case GLPIImpact.EDITION_DEFAULT:break;case GLPIImpact.EDITION_ADD_NODE:break;case GLPIImpact.EDITION_ADD_EDGE:break;case GLPIImpact.EDITION_DELETE:break}GLPIImpact.checkBadgeHitboxes(e.renderedPosition,true,GLPIImpact.eventData.ctrlDown)},edgeOnClick:function(e){switch(GLPIImpact.editionMode){case GLPIImpact.EDITION_DEFAULT:break;case GLPIImpact.EDITION_ADD_NODE:break;case GLPIImpact.EDITION_ADD_EDGE:break;case GLPIImpact.EDITION_DELETE:GLPIImpact.deleteFromGraph(e.target);break}},nodeOnClick:function(e){switch(GLPIImpact.editionMode){case GLPIImpact.EDITION_DEFAULT:if(GLPIImpact.eventData.lastClicktimestamp!=null){if(e.timeStamp-GLPIImpact.eventData.lastClicktimestamp<500&&e.target==GLPIImpact.eventData.lastClickTarget){e.target.trigger("doubleClick",e)}}GLPIImpact.eventData.lastClicktimestamp=e.timeStamp;GLPIImpact.eventData.lastClickTarget=e.target;break;case GLPIImpact.EDITION_ADD_NODE:break;case GLPIImpact.EDITION_ADD_EDGE:break;case GLPIImpact.EDITION_DELETE:GLPIImpact.deleteFromGraph(e.target);break}},onBox:function(e){switch(GLPIImpact.editionMode){case GLPIImpact.EDITION_DEFAULT:break;case GLPIImpact.EDITION_ADD_NODE:break;case GLPIImpact.EDITION_ADD_EDGE:break;case GLPIImpact.EDITION_DELETE:break;case GLPIImpact.EDITION_ADD_COMPOUND:var t=e.target;if(t.isNode()&&t.isOrphan()&&!t.isParent()){GLPIImpact.eventData.boxSelected.push(t)}GLPIImpact.addCompoundFromSelection();break}},onChange:function(){GLPIImpact.showDirtyWorkspaceStatus();GLPIImpact.cy.$("[highlight][!start_node]").data("highlight",0)},onDoubleClick:function(e){if(e.target.isParent()){GLPIImpact.showEditCompoundDialog(e.target)}else if(e.target.isNode()){window.open(e.target.data("link"))}},onGrabOn:function(e){GLPIImpact.eventData.grabNodePosition={x:e.target.position().x,y:e.target.position().y};var t=null;if(e.target.parent()!==undefined){t=e.target.parent().data("id")}GLPIImpact.eventData.grabNodeParent=t},onFreeOn:function(e){var t=null;if(e.target.parent()!==undefined){t=e.target.parent().data("id")}var a=null;if(t!==GLPIImpact.eventData.grabNodeParent){a=t}if(GLPIImpact.eventData.grabNodePosition.x!==e.target.position().x||GLPIImpact.eventData.grabNodePosition.y!==e.target.position().y){GLPIImpact.addToUndo(GLPIImpact.ACTION_MOVE,{node:e.target.data("id"),oldPosition:GLPIImpact.eventData.grabNodePosition,newPosition:{x:e.target.position().x,y:e.target.position().y},newParent:a})}},onRemove:function(e){if(e.target.isNode()&&!e.target.isParent()){var t=e.target.data("id").split(GLPIImpact.NODE_ID_SEPERATOR)[0];if(t==GLPIImpact.selectedItemtype){$(GLPIImpact.selectors.sideSearchResults).html("");GLPIImpact.searchAssets(GLPIImpact.selectedItemtype,JSON.stringify(GLPIImpact.getUsedAssets()),$(GLPIImpact.selectors.sideFilterAssets).val(),0)}}},onKeyDown:function(e){if(e.target.nodeName=="INPUT"){return}switch(e.which){case 16:if(e.ctrlKey){if(GLPIImpact.editionMode!=GLPIImpact.EDITION_ADD_COMPOUND){if(GLPIImpact.eventData.previousEditionMode===undefined){GLPIImpact.eventData.previousEditionMode=GLPIImpact.editionMode}GLPIImpact.setEditionMode(GLPIImpact.EDITION_ADD_COMPOUND)}}else{if(GLPIImpact.editionMode!=GLPIImpact.EDITION_ADD_EDGE){if(GLPIImpact.eventData.previousEditionMode===undefined){GLPIImpact.eventData.previousEditionMode=GLPIImpact.editionMode}GLPIImpact.setEditionMode(GLPIImpact.EDITION_ADD_EDGE)}}break;case 17:GLPIImpact.eventData.ctrlDown=true;break;case 27:if(GLPIImpact.editionMode!=GLPIImpact.EDITION_DEFAULT){GLPIImpact.setEditionMode(GLPIImpact.EDITION_DEFAULT)}break;case 46:if(GLPIImpact.readonly){break}GLPIImpact.eventData.multipleDeletion={edges:[],nodes:[],compounds:[]};GLPIImpact.cy.filter(":selected").forEach(function(e){GLPIImpact.deleteFromGraph(e)});GLPIImpact.addToUndo(GLPIImpact.ACTION_DELETE,GLPIImpact.eventData.multipleDeletion);GLPIImpact.eventData.multipleDeletion=null;break;case 89:if(!e.ctrlKey){break}GLPIImpact.redo();break;case 90:if(!e.ctrlKey){break}if(e.shiftKey){GLPIImpact.redo()}else{GLPIImpact.undo()}break}},onKeyUp:function(e){switch(e.which){case 16:if(GLPIImpact.eventData.previousEditionMode!==undefined&&(GLPIImpact.editionMode==GLPIImpact.EDITION_ADD_EDGE||GLPIImpact.editionMode==GLPIImpact.EDITION_ADD_COMPOUND)){GLPIImpact.setEditionMode(GLPIImpact.eventData.previousEditionMode);GLPIImpact.eventData.previousEditionMode=undefined}break;case 17:if(GLPIImpact.editionMode==GLPIImpact.EDITION_ADD_COMPOUND&&GLPIImpact.eventData.previousEditionMode!==undefined){GLPIImpact.setEditionMode(GLPIImpact.eventData.previousEditionMode);GLPIImpact.eventData.previousEditionMode=undefined}GLPIImpact.eventData.ctrlDown=false;break}},nodeOnMousedown:function(e){switch(GLPIImpact.editionMode){case GLPIImpact.EDITION_DEFAULT:$(GLPIImpact.impactContainer).css("cursor","grabbing");if(e.target.isOrphan()&&!e.target.isParent()){GLPIImpact.eventData.grabNodeStart=e.target}break;case GLPIImpact.EDITION_ADD_NODE:break;case GLPIImpact.EDITION_ADD_EDGE:if(!e.target.isParent()){GLPIImpact.eventData.addEdgeStart=this.data("id")}break;case GLPIImpact.EDITION_DELETE:break;case GLPIImpact.EDITION_ADD_COMPOUND:break}},onMouseUp:function(e){if(e.target.data("id")!=undefined&&e.target.isNode()){GLPIImpact.nodeOnMouseup()}switch(GLPIImpact.editionMode){case GLPIImpact.EDITION_DEFAULT:break;case GLPIImpact.EDITION_ADD_NODE:break;case GLPIImpact.EDITION_ADD_EDGE:if(GLPIImpact.eventData.addEdgeStart==null){return}var t=GLPIImpact.eventData.addEdgeStart;GLPIImpact.eventData.addEdgeStart=null;e.cy.remove(GLPIImpact.eventData.tmpEles);var a=GLPIImpact.eventData.tmpEles.data("id");GLPIImpact.eventData.tmpEles=null;if(a=="tmp_node"){return}var o=a.split(GLPIImpact.EDGE_ID_SEPERATOR);if(e.cy.filter('edge[id="'+a+'"]').length>0){return}if(t==o[1]){return}var i={id:a,source:t,target:o[1]};e.cy.add({group:"edges",data:i});GLPIImpact.addToUndo(GLPIImpact.ACTION_ADD_EDGE,_.clone(i));GLPIImpact.updateFlags();break;case GLPIImpact.EDITION_DELETE:break}},nodeOnMouseup:function(){switch(GLPIImpact.editionMode){case GLPIImpact.EDITION_DEFAULT:$(GLPIImpact.impactContainer).css("cursor","grab");GLPIImpact.eventData.grabNodeStart=null;GLPIImpact.eventData.boundingBox=null;break;case GLPIImpact.EDITION_ADD_NODE:break;case GLPIImpact.EDITION_ADD_EDGE:break;case GLPIImpact.EDITION_DELETE:break}},onMousemove:_.throttle(function(e){var t;if(GLPIImpact.checkBadgeHitboxes(e.renderedPosition,false,false)&&!GLPIImpact.eventData.showPointerForBadge){GLPIImpact.eventData.showPointerForBadge=true;GLPIImpact.eventData.previousCursor=$(GLPIImpact.impactContainer).css("cursor");$(GLPIImpact.impactContainer).css("cursor","pointer")}else if(GLPIImpact.eventData.showPointerForBadge&&!GLPIImpact.checkBadgeHitboxes(e.renderedPosition,false,false)){GLPIImpact.eventData.showPointerForBadge=false;$(GLPIImpact.impactContainer).css("cursor",GLPIImpact.eventData.previousCursor)}switch(GLPIImpact.editionMode){case GLPIImpact.EDITION_DEFAULT:case GLPIImpact.EDITION_ADD_NODE:if(GLPIImpact.eventData.grabNodeStart==null){return}t=GLPIImpact.getNodeAt(e.position,function(e){return e.isParent()});if(t){if(GLPIImpact.eventData.boundingBox!=null){if(GLPIImpact.eventData.boundingBox.x1>e.position.x||GLPIImpact.eventData.boundingBox.x2<e.position.x||GLPIImpact.eventData.boundingBox.y1>e.position.y||GLPIImpact.eventData.boundingBox.y2<e.position.y){GLPIImpact.eventData.grabNodeStart.move({parent:null});GLPIImpact.eventData.boundingBox=null}}else{GLPIImpact.eventData.grabNodeStart.move({parent:t.data("id")});GLPIImpact.eventData.boundingBox=t.boundingBox()}}else{GLPIImpact.eventData.grabNodeStart.move({parent:null})}break;case GLPIImpact.EDITION_ADD_EDGE:if(GLPIImpact.eventData.addEdgeStart==null){return}if(GLPIImpact.eventData.tmpEles!=null){e.cy.remove(GLPIImpact.eventData.tmpEles)}t=GLPIImpact.getNodeAt(e.position,function(e){var t=e.data("id");if(t==GLPIImpact.eventData.addEdgeStart){return false}if(e.isParent()){return false}var a=GLPIImpact.makeID(GLPIImpact.EDGE,GLPIImpact.eventData.addEdgeStart,t);if(GLPIImpact.cy.filter('edge[id="'+a+'"]').length>0){return false}if(!GLPIImpact.cy.getElementById(t).visible()){return false}return true});if(t!=null){t=t.data("id");GLPIImpact.eventData.tmpEles=e.cy.add([{group:"edges",data:{id:GLPIImpact.makeID(GLPIImpact.EDGE,GLPIImpact.eventData.addEdgeStart,t),source:GLPIImpact.eventData.addEdgeStart,target:t}}])}else{GLPIImpact.eventData.tmpEles=e.cy.add([{group:"nodes",data:{id:"tmp_node"},position:{x:e.position.x,y:e.position.y}},{group:"edges",data:{id:GLPIImpact.makeID(GLPIImpact.EDGE,GLPIImpact.eventData.addEdgeStart,"tmp_node"),source:GLPIImpact.eventData.addEdgeStart,target:"tmp_node"}}])}break;case GLPIImpact.EDITION_DELETE:break}},25),onMouseover:function(e){switch(GLPIImpact.editionMode){case GLPIImpact.EDITION_DEFAULT:if(e.target.data("id")==undefined){break}if(e.target.isNode()){if(!GLPIImpact.eventData.showPointerForBadge){$(GLPIImpact.impactContainer).css("cursor","grab")}}else if(e.target.isEdge()){GLPIImpact.cy.panningEnabled(false);if(!GLPIImpact.eventData.showPointerForBadge){$(GLPIImpact.impactContainer).css("cursor","default")}}break;case GLPIImpact.EDITION_ADD_NODE:if(e.target.data("id")==undefined){break}if(e.target.isNode()){$(GLPIImpact.impactContainer).css("cursor","grab")}else if(e.target.isEdge()){$(GLPIImpact.impactContainer).css("cursor","default");GLPIImpact.cy.panningEnabled(false)}break;case GLPIImpact.EDITION_ADD_EDGE:break;case GLPIImpact.EDITION_DELETE:if(e.target.data("id")==undefined){break}$(GLPIImpact.impactContainer).css("cursor","default");var t=e.target.data("id");e.cy.filter().data("todelete",0);e.cy.filter().unselect();if(e.target.data("id")==GLPIImpact.startNode){$(GLPIImpact.impactContainer).css("cursor","not-allowed");break}e.target.data("todelete",1);e.target.select();if(e.target.isNode()){var a="edge[source='"+t+"']";var o="edge[target='"+t+"']";e.cy.filter(a+", "+o).data("todelete",1).select()}break}},onMouseout:function(e){switch(GLPIImpact.editionMode){case GLPIImpact.EDITION_DEFAULT:if(!GLPIImpact.eventData.showPointerForBadge){$(GLPIImpact.impactContainer).css("cursor","move")}GLPIImpact.cy.panningEnabled(true);break;case GLPIImpact.EDITION_ADD_NODE:if(!GLPIImpact.eventData.showPointerForBadge){$(GLPIImpact.impactContainer).css("cursor","move")}GLPIImpact.cy.panningEnabled(true);break;case GLPIImpact.EDITION_ADD_EDGE:break;case GLPIImpact.EDITION_DELETE:e.cy.filter().data("todelete",0);e.cy.filter().unselect();if(!GLPIImpact.eventData.showPointerForBadge){$(GLPIImpact.impactContainer).css("cursor","move")}break}},menuOnGoTo:function(e){window.open(e.target.data("link"))},menuOnShowOngoing:function(e){GLPIImpact.showOngoingDialog(e.target.data("ITILObjects"))},menuOnEditCompound:function(e){GLPIImpact.showEditCompoundDialog(e.target)},menuOnRemoveFromCompound:function(e){var t=GLPIImpact.cy.getElementById(e.target.data("parent"));GLPIImpact.addToUndo(GLPIImpact.ACTION_REMOVE_FROM_COMPOUND,{nodeData:_.clone(e.target.data()),compoundData:_.clone(t.data()),children:t.children().map(function(e){return e.data("id")})});e.target.move({parent:null});if(t.children().length<2){t.children().move({parent:null});GLPIImpact.cy.remove(t)}},menuOnDelete:function(e){GLPIImpact.deleteFromGraph(e.target)},searchAssets:function(e,t,a,o){var i=GLPIImpact.cy.nodes(GLPIImpact.getHiddenSelector()).filter(function(e){return!e.isParent()}).map(function(e){return e.data("id")});$(GLPIImpact.selectors.sideSearchSpinner).show();$(GLPIImpact.selectors.sideSearchNoResults).hide();$.ajax({type:"GET",url:$(GLPIImpact.selectors.form).prop("action"),data:{action:"search",itemtype:e,used:t,filter:a,page:o},success:function(t){$.each(t.items,function(t,a){var o=e+GLPIImpact.NODE_ID_SEPERATOR+a["id"];var c=i.indexOf(o)!==-1;var s="";if(c){s="impact-res-disabled"}var n='<p class="'+s+'" data-id="'+a["id"]+'" data-type="'+e+'">';n+='<img src="'+$(GLPIImpact.selectors.sideSearch+" img").attr("src")+'"></img>';n+=a["name"];if(c){n+='<i class="fas fa-eye-slash impact-res-hidden"></i>'}n+="</p>";$(GLPIImpact.selectors.sideSearchResults).append(n)});if(t.total<=(o+1)*20){$(GLPIImpact.selectors.sideSearchMore).hide()}else{$(GLPIImpact.selectors.sideSearchMore).show()}if(t.total==0&&o==0){$(GLPIImpact.selectors.sideSearchNoResults).show()}$(GLPIImpact.selectors.sideSearchSpinner).hide()},error:function(){alert("error")}})},getUsedAssets:function(){var e=[];GLPIImpact.cy.nodes().not(GLPIImpact.getHiddenSelector()).forEach(function(t){if(t.isParent()){return}var a=t.data("id").split(GLPIImpact.NODE_ID_SEPERATOR);if(a[0]==GLPIImpact.selectedItemtype){e.push(parseInt(a[1]))}});return e},projectIntoViewport:function(e,t,a){var o=this.cy;var i=this.findContainerClientCoords();var c=i[0];var s=i[1];var n=i[4];var r=o.pan();var I=o.zoom();if(a){return{x:e-c,y:t-s}}else{return{x:((e-c)/n-r.x)/I,y:((t-s)/n-r.y)/I}}},findContainerClientCoords:function(){var e=this.impactContainer[0];var t=e.getBoundingClientRect();var a=window.getComputedStyle(e);var o=function e(t){return parseFloat(a.getPropertyValue(t))};var i={left:o("padding-left"),right:o("padding-right"),top:o("padding-top"),bottom:o("padding-bottom")};var c={left:o("border-left-width"),right:o("border-right-width"),top:o("border-top-width"),bottom:o("border-bottom-width")};var s=e.clientWidth;var n=e.clientHeight;var r=i.left+i.right;var I=i.top+i.bottom;var d=c.left+c.right;var p=t.width/(s+d);var l=s-r;var m=n-I;var u=t.left+i.left+c.left;var h=t.top+i.top+c.top;return[u,h,l,m,p]},initToolbar:function(){$(GLPIImpact.selectors.save).click(function(){GLPIImpact.showCleanWorkspaceStatus();$.ajax({type:"POST",url:$(GLPIImpact.selectors.form).prop("action"),data:{impacts:JSON.stringify(GLPIImpact.computeDelta())},success:function(){GLPIImpact.initialState=GLPIImpact.getCurrentState();$(document).trigger("impactUpdated")},error:function(){GLPIImpact.showDirtyWorkspaceStatus()}})});$(GLPIImpact.selectors.addNode).click(function(){GLPIImpact.setEditionMode(GLPIImpact.EDITION_ADD_NODE)});$(GLPIImpact.selectors.addEdge).click(function(){GLPIImpact.setEditionMode(GLPIImpact.EDITION_ADD_EDGE)});$(GLPIImpact.selectors.addCompound).click(function(){GLPIImpact.setEditionMode(GLPIImpact.EDITION_ADD_COMPOUND)});$(GLPIImpact.selectors.deleteElement).click(function(){GLPIImpact.setEditionMode(GLPIImpact.EDITION_DELETE)});$(GLPIImpact.selectors.export).click(function(){GLPIImpact.download("png",false)});$(this.selectors.impactSettings).click(function(){if($(this).find("i.fa-chevron-right").length){GLPIImpact.setEditionMode(GLPIImpact.EDITION_DEFAULT)}else{GLPIImpact.setEditionMode(GLPIImpact.EDITION_SETTINGS)}});$(GLPIImpact.selectors.undo).click(function(){GLPIImpact.undo()});$(GLPIImpact.selectors.redo).click(function(){GLPIImpact.redo()});$(this.selectors.sideToggle).click(function(){if($(this).find("i.fa-chevron-right").length){GLPIImpact.setEditionMode(GLPIImpact.EDITION_DEFAULT)}else{GLPIImpact.setEditionMode(GLPIImpact.EDITION_ADD_NODE)}});$(GLPIImpact.selectors.toggleImpact).click(function(){GLPIImpact.toggleVisibility(GLPIImpact.FORWARD);GLPIImpact.addToUndo(GLPIImpact.ACTION_EDIT_IMPACT_VISIBILITY,{})});$(GLPIImpact.selectors.toggleDepends).click(function(){GLPIImpact.toggleVisibility(GLPIImpact.BACKWARD);GLPIImpact.addToUndo(GLPIImpact.ACTION_EDIT_DEPENDS_VISIBILITY,{})});$(GLPIImpact.selectors.maxDepth).on("input",function(){var e=GLPIImpact.maxDepth;GLPIImpact.setDepth($(GLPIImpact.selectors.maxDepth).val());GLPIImpact.addToUndo(GLPIImpact.ACTION_EDIT_MAX_DEPTH,{oldDepth:e,newDepth:GLPIImpact.maxDepth})});$(GLPIImpact.selectors.toggleFullscreen).click(function(){GLPIImpact.toggleFullscreen()});$(GLPIImpact.selectors.sideSearchFilterItemtype).on("input",function(){var e=$(GLPIImpact.selectors.sideSearchFilterItemtype).val().toLowerCase();$(GLPIImpact.selectors.sideFilterItem+" img").each(function(){var t=$(this).attr("title").toLowerCase();if(e==""||t.indexOf(e)!=-1){$(this).parent().show()}else{$(this).parent().hide()}})});$(GLPIImpact.selectors.sideFilterItem).click(function(){var e=$(this).find("img").eq(0);GLPIImpact.selectedItemtype=$(e).attr("data-itemtype");$(GLPIImpact.selectors.sideSearch).show();$(GLPIImpact.selectors.sideSearch+" img").attr("title",$(e).attr("title"));$(GLPIImpact.selectors.sideSearch+" img").attr("src",$(e).attr("src"));$(GLPIImpact.selectors.sideSearch+" > h4 > span").html($(e).attr("title"));$(GLPIImpact.selectors.sideSearchSelectItemtype).hide();GLPIImpact.searchAssets(GLPIImpact.selectedItemtype,JSON.stringify(GLPIImpact.getUsedAssets()),$(GLPIImpact.selectors.sideFilterAssets).val(),0)});$(GLPIImpact.selectors.sideSearch+" > h4 > i").click(function(){$(GLPIImpact.selectors.sideSearch).hide();$(GLPIImpact.selectors.sideSearchSelectItemtype).show();$(GLPIImpact.selectors.sideSearchResults).html("")});$(GLPIImpact.selectors.sideFilterAssets).on("input",function(){$(GLPIImpact.selectors.sideSearchResults).html("");$(GLPIImpact.selectors.sideSearchMore).hide();$(GLPIImpact.selectors.sideSearchSpinner).show();$(GLPIImpact.selectors.sideSearchNoResults).hide();searchAssetsDebounced(GLPIImpact.selectedItemtype,JSON.stringify(GLPIImpact.getUsedAssets()),$(GLPIImpact.selectors.sideFilterAssets).val(),0)});$(GLPIImpact.selectors.sideSearchMore).on("click",function(){GLPIImpact.searchAssets(GLPIImpact.selectedItemtype,JSON.stringify(GLPIImpact.getUsedAssets()),$(GLPIImpact.selectors.sideFilterAssets).val(),++GLPIImpact.addAssetPage)});$(GLPIImpact.selectors.dependsColor).change(function(){var e=GLPIImpact.edgeColors[GLPIImpact.BACKWARD];GLPIImpact.setEdgeColors({backward:$(GLPIImpact.selectors.dependsColor).val()});GLPIImpact.updateStyle();GLPIImpact.cy.trigger("change");GLPIImpact.addToUndo(GLPIImpact.ACTION_EDIT_DEPENDS_COLOR,{oldColor:e,newColor:GLPIImpact.edgeColors[GLPIImpact.BACKWARD]})});$(GLPIImpact.selectors.impactColor).change(function(){var e=GLPIImpact.edgeColors[GLPIImpact.FORWARD];GLPIImpact.setEdgeColors({forward:$(GLPIImpact.selectors.impactColor).val()});GLPIImpact.updateStyle();GLPIImpact.cy.trigger("change");GLPIImpact.addToUndo(GLPIImpact.ACTION_EDIT_IMPACT_COLOR,{oldColor:e,newColor:GLPIImpact.edgeColors[GLPIImpact.FORWARD]})});$(GLPIImpact.selectors.impactAndDependsColor).change(function(){var e=GLPIImpact.edgeColors[GLPIImpact.BOTH];GLPIImpact.setEdgeColors({both:$(GLPIImpact.selectors.impactAndDependsColor).val()});GLPIImpact.updateStyle();GLPIImpact.cy.trigger("change");GLPIImpact.addToUndo(GLPIImpact.ACTION_EDIT_IMPACT_AND_DEPENDS_COLOR,{oldColor:e,newColor:GLPIImpact.edgeColors[GLPIImpact.BOTH]})});$(document).on("mousedown",GLPIImpact.selectors.sideSearchResults+" p",function(e){if(e.which!==1||$(e.target).hasClass("impact-res-disabled")||$(e.target).parent().hasClass("impact-res-disabled")){return}GLPIImpact.eventData.addNodeStart={id:$(this).attr("data-id"),type:$(this).attr("data-type")};$(GLPIImpact.selectors.dropPreview).css({left:e.clientX-24,top:e.clientY-24});$(GLPIImpact.selectors.dropPreview).attr("src",$(this).find("img").attr("src"));$(GLPIImpact.selectors.dropPreview).show();$("*").css({cursor:"grabbing"})});$(document).on("mouseup",function(e){if(event.which==2){GLPIImpact.checkBadgeHitboxes(GLPIImpact.projectIntoViewport(e.clientX,e.clientY,true),true,true)}if(GLPIImpact.eventData.addNodeStart===undefined){return}if(e.target.nodeName=="CANVAS"){GLPIImpact.addNode(GLPIImpact.eventData.addNodeStart.id,GLPIImpact.eventData.addNodeStart.type,GLPIImpact.projectIntoViewport(e.clientX,e.clientY,false))}$(GLPIImpact.selectors.dropPreview).hide();GLPIImpact.eventData.addNodeStart=undefined;$("*").css("cursor","")});$(document).on("mousemove",function(e){if(GLPIImpact.eventData.addNodeStart===undefined){return}$(GLPIImpact.selectors.dropPreview).css({left:e.clientX-24,top:e.clientY-24})})},initCanvasOverlay:function(){var e=GLPIImpact.cy.cyCanvas();var t=e.getCanvas();var a=t.getContext("2d");GLPIImpact.cy.on("render cyCanvas.resize",function(){e.resetTransform(a);e.clear(a);GLPIImpact.badgesHitboxes=[];GLPIImpact.cy.filter("node:childless:visible").forEach(function(e){if(!e.data("badge")){return}var t=hexToRgb(e.data("badge").color);while(contrast([255,255,255],[t.r,t.g,t.b])<1.8){t.r*=.95;t.g*=.95;t.b*=.95}var o=e.renderedBoundingBox({includeLabels:false,includeOverlays:false,includeNodes:true});var i={x:o.x2+GLPIImpact.cy.zoom(),y:o.y2+GLPIImpact.cy.zoom()};GLPIImpact.badgesHitboxes.push({position:i,target:e.data("badge").target,itemtype:e.data("id").split(GLPIImpact.NODE_ID_SEPERATOR)[0],id:e.data("id").split(GLPIImpact.NODE_ID_SEPERATOR)[1]});a.beginPath();a.arc(i.x,i.y,4*GLPIImpact.cy.zoom(),0,2*Math.PI,false);a.fillStyle="rgb("+t.r+", "+t.g+", "+t.b+")";a.fill();var c=(Math.round(t.r*299)+Math.round(t.g*587)+Math.round(t.b*114))/1e3;a.fillStyle=c>=138?"#4e4e4e":"white";a.font=6*GLPIImpact.cy.zoom()+"px sans-serif";a.fillText(e.data("badge").count,i.x-1.95*GLPIImpact.cy.zoom(),i.y+2.23*GLPIImpact.cy.zoom())})})}};var searchAssetsDebounced=_.debounce(GLPIImpact.searchAssets,400,false);