<?php
/*
Gibbon: the flexible, open school platform
Founded by Ross Parker at ICHK Secondary. Built by Ross Parker, Sandra Kuipers and the Gibbon community (https://gibbonedu.org/about/)
Copyright © 2010, Gibbon Foundation
Gibbon™, Gibbon Education Ltd. (Hong Kong)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

use Gibbon\Domain\System\SettingGateway;
use Gibbon\Services\Format;

//Module includes
require_once __DIR__ . '/moduleFunctions.php';

if (isActionAccessible($guid, $connection2, '/modules/Planner/planner_unitOverview.php') == false) {
    //Acess denied
    $page->addError(__('Your request failed because you do not have access to this action.'));
} else {
    $highestAction = getHighestGroupedAction($guid, $_GET['q'], $connection2);
    if ($highestAction == false) {
        $page->addError(__('The highest grouped action cannot be determined.'));
    } else {
        $viewBy = null;
        if (isset($_GET['viewBy'])) {
            $viewBy = $_GET['viewBy'] ?? '';
        }
        $subView = null;
        if (isset($_GET['subView'])) {
            $subView = $_GET['subView'] ?? '';
        }
        if ($viewBy != 'date' and $viewBy != 'class') {
            $viewBy = 'date';
        }
        $gibbonCourseClassID = null;
        $date = null;
        $dateStamp = null;
        if ($viewBy == 'date') {
            $date = $_GET['date'] ?? '';
            if (isset($_GET['dateHuman'])) {
                $date = Format::dateConvert($_GET['dateHuman']);
            }
            if ($date == '') {
                $date = date('Y-m-d');
            }
            [$dateYear, $dateMonth, $dateDay] = explode('-', $date);
            $dateStamp = mktime(0, 0, 0, $dateMonth, $dateDay, $dateYear);
        } elseif ($viewBy == 'class') {
            $class = $_GET['class'] ?? [];
            $gibbonCourseClassID = $_GET['gibbonCourseClassID'] ?? '';
        }
        $replyTo = null;
        if (isset($_GET['replyTo'])) {
            $replyTo = $_GET['replyTo'] ?? '';
        }

        $gibbonPersonID = null;
        if (isset($_GET['search'])) {
            $gibbonPersonID = $_GET['search'] ?? '';
        }

        //Get class variable
        $gibbonPlannerEntryID = null;
        if (isset($_GET['gibbonPlannerEntryID'])) {
            $gibbonPlannerEntryID = $_GET['gibbonPlannerEntryID'] ?? '';
        }
        if ($gibbonPlannerEntryID == '') {
            echo "<div class='warning'>";
            echo __('You have not specified one or more required parameters.');
            echo '</div>';
        }
        //Check existence of and access to this class.
        else {
            if ($highestAction == 'Lesson Planner_viewMyChildrensClasses') {
                if ($_GET['search'] == '') {
                    echo "<div class='warning'>";
                    echo __('You have not specified one or more required parameters.');
                    echo '</div>';
                } else {

                        $dataChild = array('gibbonPersonID1' => $gibbonPersonID, 'gibbonPersonID2' => $session->get('gibbonPersonID'));
                        $sqlChild = "SELECT * FROM gibbonFamilyChild JOIN gibbonFamily ON (gibbonFamilyChild.gibbonFamilyID=gibbonFamily.gibbonFamilyID) JOIN gibbonFamilyAdult ON (gibbonFamilyAdult.gibbonFamilyID=gibbonFamily.gibbonFamilyID) JOIN gibbonPerson ON (gibbonFamilyChild.gibbonPersonID=gibbonPerson.gibbonPersonID) WHERE gibbonPerson.status='Full' AND (dateStart IS NULL OR dateStart<='".date('Y-m-d')."') AND (dateEnd IS NULL  OR dateEnd>='".date('Y-m-d')."') AND gibbonFamilyChild.gibbonPersonID=:gibbonPersonID1 AND gibbonFamilyAdult.gibbonPersonID=:gibbonPersonID2 AND childDataAccess='Y'";
                        $resultChild = $connection2->prepare($sqlChild);
                        $resultChild->execute($dataChild);
                    if ($resultChild->rowCount() != 1) {
                        $page->addError(__('The selected record does not exist, or you do not have access to it.'));
                    } else {
                        $data = array('date' => $date);
                        $data['gibbonPlannerEntryID1'] = $gibbonPlannerEntryID;
                        $data['gibbonPlannerEntryID2'] = $gibbonPlannerEntryID;
                        $data['gibbonPersonID'] = $gibbonPersonID;
                        $sql = "(SELECT gibbonPlannerEntry.gibbonPlannerEntryID, gibbonCourseClass.gibbonCourseClassID, gibbonUnitID, gibbonPlannerEntry.gibbonCourseClassID, gibbonPlannerEntry.name, gibbonCourse.nameShort AS course, gibbonCourseClass.nameShort AS class, date, timeStart, timeEnd, summary, gibbonPlannerEntry.description, teachersNotes, homework, homeworkDueDateTime, homeworkDetails, viewableStudents, viewableParents, role, homeworkSubmission, homeworkSubmissionDateOpen, homeworkSubmissionDrafts, homeworkSubmissionType FROM gibbonPlannerEntry JOIN gibbonCourseClass ON (gibbonPlannerEntry.gibbonCourseClassID=gibbonCourseClass.gibbonCourseClassID) JOIN gibbonCourseClassPerson ON (gibbonCourseClass.gibbonCourseClassID=gibbonCourseClassPerson.gibbonCourseClassID) JOIN gibbonCourse ON (gibbonCourse.gibbonCourseID=gibbonCourseClass.gibbonCourseID) WHERE gibbonCourseClassPerson.gibbonPersonID=:gibbonPersonID AND NOT role='Student - Left' AND NOT role='Teacher - Left' AND gibbonPlannerEntry.gibbonPlannerEntryID=:gibbonPlannerEntryID1) UNION (SELECT gibbonPlannerEntry.gibbonPlannerEntryID, gibbonCourseClass.gibbonCourseClassID, gibbonUnitID, gibbonPlannerEntry.gibbonCourseClassID, gibbonPlannerEntry.name, gibbonCourse.nameShort AS course, gibbonCourseClass.nameShort AS class, date, timeStart, timeEnd, summary, gibbonPlannerEntry.description, teachersNotes, homework, homeworkDueDateTime, homeworkDetails, viewableStudents, viewableParents, role, homeworkSubmission, homeworkSubmissionDateOpen, homeworkSubmissionDrafts, homeworkSubmissionType FROM gibbonPlannerEntry JOIN gibbonCourseClass ON (gibbonPlannerEntry.gibbonCourseClassID=gibbonCourseClass.gibbonCourseClassID) JOIN gibbonPlannerEntryGuest ON (gibbonPlannerEntryGuest.gibbonPlannerEntryID=gibbonPlannerEntry.gibbonPlannerEntryID) JOIN gibbonCourse ON (gibbonCourse.gibbonCourseID=gibbonCourseClass.gibbonCourseID) WHERE date=:date AND gibbonPlannerEntryGuest.gibbonPersonID=:gibbonPersonID AND gibbonPlannerEntry.gibbonPlannerEntryID=:gibbonPlannerEntryID2) ORDER BY date, timeStart";
                    }
                }
            } elseif ($highestAction == 'Lesson Planner_viewMyClasses') {
                $data = array('date' => $date, 'gibbonPlannerEntryID1' => $gibbonPlannerEntryID, 'gibbonPlannerEntryID2' => $gibbonPlannerEntryID, 'gibbonPersonID' => $session->get('gibbonPersonID'));
                $sql = "(SELECT gibbonPlannerEntry.gibbonPlannerEntryID, gibbonCourseClass.gibbonCourseClassID, gibbonUnitID, gibbonPlannerEntry.gibbonCourseClassID, gibbonPlannerEntry.name, gibbonCourse.nameShort AS course, gibbonCourseClass.nameShort AS class, date, timeStart, timeEnd, summary, gibbonPlannerEntry.description, teachersNotes, homework, homeworkDueDateTime, homeworkDetails, viewableStudents, viewableParents, role, homeworkSubmission, homeworkSubmissionDateOpen, homeworkSubmissionDrafts, homeworkSubmissionType FROM gibbonPlannerEntry JOIN gibbonCourseClass ON (gibbonPlannerEntry.gibbonCourseClassID=gibbonCourseClass.gibbonCourseClassID) JOIN gibbonCourseClassPerson ON (gibbonCourseClass.gibbonCourseClassID=gibbonCourseClassPerson.gibbonCourseClassID) JOIN gibbonCourse ON (gibbonCourse.gibbonCourseID=gibbonCourseClass.gibbonCourseID) WHERE gibbonCourseClassPerson.gibbonPersonID=:gibbonPersonID AND NOT role='Student - Left' AND NOT role='Teacher - Left' AND gibbonPlannerEntry.gibbonPlannerEntryID=:gibbonPlannerEntryID1) UNION (SELECT gibbonPlannerEntry.gibbonPlannerEntryID, gibbonCourseClass.gibbonCourseClassID, gibbonUnitID, gibbonPlannerEntry.gibbonCourseClassID, gibbonPlannerEntry.name, gibbonCourse.nameShort AS course, gibbonCourseClass.nameShort AS class, date, timeStart, timeEnd, summary, gibbonPlannerEntry.description, teachersNotes, homework, homeworkDueDateTime, homeworkDetails, viewableStudents, viewableParents, role, homeworkSubmission, homeworkSubmissionDateOpen, homeworkSubmissionDrafts, homeworkSubmissionType FROM gibbonPlannerEntry JOIN gibbonCourseClass ON (gibbonPlannerEntry.gibbonCourseClassID=gibbonCourseClass.gibbonCourseClassID) JOIN gibbonPlannerEntryGuest ON (gibbonPlannerEntryGuest.gibbonPlannerEntryID=gibbonPlannerEntry.gibbonPlannerEntryID) JOIN gibbonCourse ON (gibbonCourse.gibbonCourseID=gibbonCourseClass.gibbonCourseID) WHERE date=:date AND gibbonPlannerEntryGuest.gibbonPersonID=:gibbonPersonID AND gibbonPlannerEntry.gibbonPlannerEntryID=:gibbonPlannerEntryID2) ORDER BY date, timeStart";
            } elseif ($highestAction == 'Lesson Planner_viewAllEditMyClasses' or $highestAction == 'Lesson Planner_viewEditAllClasses' or $highestAction == 'Lesson Planner_viewOnly') {
                $data = array('gibbonPlannerEntryID' => $gibbonPlannerEntryID);
                $sql = "SELECT gibbonPlannerEntry.gibbonPlannerEntryID, gibbonCourseClass.gibbonCourseClassID, gibbonUnitID, gibbonPlannerEntry.gibbonCourseClassID, gibbonPlannerEntry.name, gibbonCourse.nameShort AS course, gibbonCourseClass.nameShort AS class, date, timeStart, timeEnd, summary, gibbonPlannerEntry.description, teachersNotes, homework, homeworkDueDateTime, homeworkDetails, viewableStudents, viewableParents, 'Teacher' AS role, homeworkSubmission, homeworkSubmissionDateOpen, homeworkSubmissionDrafts, homeworkSubmissionType FROM gibbonPlannerEntry JOIN gibbonCourseClass ON (gibbonPlannerEntry.gibbonCourseClassID=gibbonCourseClass.gibbonCourseClassID) JOIN gibbonCourse ON (gibbonCourse.gibbonCourseID=gibbonCourseClass.gibbonCourseID) WHERE gibbonPlannerEntry.gibbonPlannerEntryID=:gibbonPlannerEntryID ORDER BY date, timeStart";
            }

                $result = $connection2->prepare($sql);
                $result->execute($data);

            if ($result->rowCount() != 1) {
                $page->addError(__('The selected record does not exist, or you do not have access to it.'));
            } else {
                $row = $result->fetch();

                // target of the planner
                $target = ($viewBy === 'class') ? $row['course'].'.'.$row['class'] : Format::date($date);

                // planner parameters
                $params = [];
                if ($date != '') {
                    $params['date'] = $_GET['date'] ?? '';
                }
                if ($viewBy != '') {
                    $params['viewBy'] = $_GET['viewBy'] ?? '';
                }
                if ($gibbonCourseClassID != '') {
                    $params['gibbonCourseClassID'] = $gibbonCourseClassID;
                }
                $params['subView'] = $subView;
                $paramsVar = '&' . http_build_query($params); // for backward compatibile uses below (should be get rid of)

                $page->breadcrumbs
                    ->add(__('Planner for {classDesc}', [
                        'classDesc' => $target,
                    ]), 'planner.php', $params)
                    ->add(__('View Lesson Plan'), 'planner_view_full.php', $params + ['gibbonPlannerEntryID' => $gibbonPlannerEntryID, 'search' => $gibbonPersonID])
                    ->add(__('Unit Overview'));

                if ($row['gibbonUnitID'] == '') {
                    echo __('The selected record does not exist, or you do not have access to it.');
                } else {
                    //Get unit contents

                        $dataUnit = array('gibbonUnitID' => $row['gibbonUnitID']);
                        $sqlUnit = 'SELECT * FROM gibbonUnit WHERE gibbonUnitID=:gibbonUnitID';
                        $resultUnit = $connection2->prepare($sqlUnit);
                        $resultUnit->execute($dataUnit);

                    if ($resultUnit->rowCount() != 1) {
                        $page->addError(__('The selected record does not exist, or you do not have access to it.'));
                    } else {
                        $rowUnit = $resultUnit->fetch();

                        echo '<h2>';
                        echo $rowUnit['name'];
                        echo '</h2>';
                        echo '<p>';
                        echo __('This page shows an overview of the unit that the current lesson belongs to, including all the outcomes, resources, lessons and chats for the classes you have access to.');
                        echo '</p>';

                        //Set up where and data array for getting items from accessible planners
                        if ($highestAction == 'Lesson Planner_viewEditAllClasses' or $highestAction == 'Lesson Planner_viewAllEditMyClasses' or $highestAction == 'Lesson Planner_viewOnly') {
                            $dataPlanners = array('gibbonUnitID' => $row['gibbonUnitID'], 'gibbonCourseClassID' => $row['gibbonCourseClassID']);
                            $sqlPlanners = 'SELECT * FROM gibbonPlannerEntry WHERE gibbonUnitID=:gibbonUnitID AND gibbonCourseClassID=:gibbonCourseClassID';
                        } elseif ($highestAction == 'Lesson Planner_viewMyClasses') {
                            $dataPlanners = array('gibbonUnitID1' => $row['gibbonUnitID'], 'gibbonPersonID1' => $session->get('gibbonPersonID'), 'gibbonCourseClassID1' => $row['gibbonCourseClassID'], 'gibbonUnitID2' => $row['gibbonUnitID'], 'gibbonPersonID2' => $session->get('gibbonPersonID'), 'gibbonCourseClassID2' => $row['gibbonCourseClassID']);
                            $sqlPlanners = "(SELECT gibbonPlannerEntry.* FROM gibbonPlannerEntry JOIN gibbonCourseClass ON (gibbonPlannerEntry.gibbonCourseClassID=gibbonCourseClass.gibbonCourseClassID) JOIN gibbonCourseClassPerson ON (gibbonCourseClassPerson.gibbonCourseClassID=gibbonCourseClass.gibbonCourseClassID) WHERE gibbonUnitID=:gibbonUnitID1 AND gibbonPersonID=:gibbonPersonID1 AND gibbonCourseClass.gibbonCourseClassID=:gibbonCourseClassID1 AND role='Teacher')
							UNION
							(SELECT gibbonPlannerEntry.* FROM gibbonPlannerEntry JOIN gibbonCourseClass ON (gibbonPlannerEntry.gibbonCourseClassID=gibbonCourseClass.gibbonCourseClassID) JOIN gibbonCourseClassPerson ON (gibbonCourseClassPerson.gibbonCourseClassID=gibbonCourseClass.gibbonCourseClassID) WHERE gibbonUnitID=:gibbonUnitID2 AND gibbonPersonID=:gibbonPersonID2 AND gibbonCourseClass.gibbonCourseClassID=:gibbonCourseClassID2 AND role='Student' AND viewableStudents='Y')";
                        } elseif ($highestAction == 'Lesson Planner_viewMyChildrensClasses') {
                            $dataPlanners = array('gibbonUnitID' => $row['gibbonUnitID'], 'gibbonCourseClassID' => $row['gibbonCourseClassID']);
                            $sqlPlanners = "SELECT * FROM gibbonPlannerEntry WHERE gibbonUnitID=:gibbonUnitID AND gibbonCourseClassID=:gibbonCourseClassID AND viewableParents='Y'";
                        }

                            $resultPlanners = $connection2->prepare($sqlPlanners);
                            $resultPlanners->execute($dataPlanners);

                        if ($resultPlanners->rowCount() < 1) {
                            echo $page->getBlankSlate();
                        } else {
                            $dataMulti = array();
                            $whereMulti = '(';
                            $multiCount = 0;
                            while ($rowPlanners = $resultPlanners->fetch()) {
                                $dataMulti['gibbonPlannerEntryID'.$multiCount] = $rowPlanners['gibbonPlannerEntryID'];
                                $whereMulti .= 'gibbonPlannerEntryID=:gibbonPlannerEntryID'.$multiCount.' OR ';
                                ++$multiCount;
                            }
                            $whereMulti = substr($whereMulti, 0, -4).')';
                            ?>
							<script type='text/javascript'>
								$(function() {
									$( "#tabs" ).tabs({
										ajaxOptions: {
											error: function( xhr, status, index, anchor ) {
												$( anchor.hash ).html(
													"Couldn't load this tab." );
											}
										}
									});
								});
							</script>
							<?php

                            echo "<div id='tabs' style='margin: 20px 0'>";
							//Tab links
							echo '<ul>';
                            echo "<li><a href='#tabs1'>".__('Unit Overview').'</a></li>';
                            echo "<li><a href='#tabs2'>".__('Smart Blocks').'</a></li>';
                            echo "<li><a href='#tabs3'>".__('Outcomes').'</a></li>';
                            echo "<li><a href='#tabs4'>".__('Lessons').'</a></li>';
                            echo "<li><a href='#tabs5'>".__('Resources').'</a></li>';
                            echo '</ul>';

							//Tab content
							//UNIT OVERVIEW
							echo "<div id='tabs1'>";
                            $shareUnitOutline = $container->get(SettingGateway::class)->getSettingByScope('Planner', 'shareUnitOutline');
                            echo '<h2>';
                            echo __('Description');
                            echo '</h2>';
                            echo '<p>';
                            echo $rowUnit['description'];
                            echo '</p>';

                            if ($rowUnit['tags'] != '') {
                                echo '<h2>';
                                echo __('Concepts & Keywords');
                                echo '</h2>';
                                echo '<p>';
                                echo $rowUnit['tags'];
                                echo '</p>';
                            }
                            if ($highestAction == 'Lesson Planner_viewEditAllClasses' or $highestAction == 'Lesson Planner_viewAllEditMyClasses' or $shareUnitOutline == 'Y') {
                                if ($rowUnit['details'] != '') {
                                    echo '<h2>';
                                    echo __('Unit Outline');
                                    echo '</h2>';
                                    echo '<p>';
                                    echo $rowUnit['details'];
                                    echo '</p>';
                                }
                            }
                            echo '</div>';
                            //SMART BLOCKS
                            echo "<div id='tabs2'>";

                                $dataBlocks = array('gibbonUnitID' => $row['gibbonUnitID']);
                                $sqlBlocks = 'SELECT * FROM gibbonUnitBlock WHERE gibbonUnitID=:gibbonUnitID ORDER BY sequenceNumber';
                                $resultBlocks = $connection2->prepare($sqlBlocks);
                                $resultBlocks->execute($dataBlocks);

                            while ($rowBlocks = $resultBlocks->fetch()) {
                                if ($rowBlocks['title'] != '' or $rowBlocks['type'] != '' or $rowBlocks['length'] != '') {
                                    echo "<div class='blockView' style='min-height: 35px'>";
                                    if ($rowBlocks['type'] != '' or $rowBlocks['length'] != '') {
                                        $width = '69%';
                                    } else {
                                        $width = '100%';
                                    }
                                    echo "<div style='padding-left: 3px; width: $width; float: left;'>";
                                    if ($rowBlocks['title'] != '') {
                                        echo "<h5 style='padding-bottom: 2px'>".$rowBlocks['title'].'</h5>';
                                    }
                                    echo '</div>';
                                    if ($rowBlocks['type'] != '' or $rowBlocks['length'] != '') {
                                        echo "<div style='float: right; width: 29%; padding-right: 3px; height: 55px'>";
                                        echo "<div style='text-align: right; font-size: 85%; font-style: italic; margin-top: 3px; border-bottom: 1px solid #ddd; height: 21px'>";
                                        if ($rowBlocks['type'] != '') {
                                            echo $rowBlocks['type'];
                                            if ($rowBlocks['length'] != '') {
                                                echo ' | ';
                                            }
                                        }
                                        if ($rowBlocks['length'] != '') {
                                            echo $rowBlocks['length'].' min';
                                        }
                                        echo '</div>';
                                        echo '</div>';
                                    }
                                    echo '</div>';
                                }
                                if ($rowBlocks['contents'] != '') {
                                    echo "<div style='padding: 15px 3px 10px 3px; width: 100%; text-align: justify; border-bottom: 1px solid #ddd'>".$rowBlocks['contents'].'</div>';
                                }
                            }
                            echo '</div>';
                            //OUTCOMES
							echo "<div id='tabs3'>";

                                $dataOutcomes = $dataMulti;
                                $dataOutcomes['gibbonUnitID'] = $row['gibbonUnitID'];
                                $sqlOutcomes = "(SELECT gibbonOutcome.*, gibbonPlannerEntryOutcome.content FROM gibbonPlannerEntryOutcome JOIN gibbonOutcome ON (gibbonPlannerEntryOutcome.gibbonOutcomeID=gibbonOutcome.gibbonOutcomeID) WHERE $whereMulti AND active='Y')
									UNION
									(SELECT gibbonOutcome.*, gibbonUnitOutcome.content FROM gibbonUnitOutcome JOIN gibbonOutcome ON (gibbonUnitOutcome.gibbonOutcomeID=gibbonOutcome.gibbonOutcomeID) WHERE gibbonUnitID=:gibbonUnitID AND active='Y')
									ORDER BY scope DESC, name";
                                $resultOutcomes = $connection2->prepare($sqlOutcomes);
                                $resultOutcomes->execute($dataOutcomes);
                            if ($resultOutcomes->rowCount() < 1) {
                                echo $page->getBlankSlate();
                            } else {
                                echo "<table cellspacing='0' style='width: 100%'>";
                                echo "<tr class='head'>";
                                echo '<th>';
                                echo __('Scope');
                                echo '</th>';
                                echo '<th>';
                                echo __('Category');
                                echo '</th>';
                                echo '<th>';
                                echo __('Name');
                                echo '</th>';
                                echo '<th>';
                                echo __('Year Groups');
                                echo '</th>';
                                echo '<th>';
                                echo __('Actions');
                                echo '</th>';
                                echo '</tr>';

                                $count = 0;
                                $rowNum = 'odd';
                                while ($rowOutcomes = $resultOutcomes->fetch()) {
                                    if ($count % 2 == 0) {
                                        $rowNum = 'even';
                                    } else {
                                        $rowNum = 'odd';
                                    }

									//COLOR ROW BY STATUS!
									echo "<tr class=$rowNum>";
                                    echo '<td>';
                                    echo '<b>'.$rowOutcomes['scope'].'</b><br/>';
                                    if ($rowOutcomes['scope'] == 'Learning Area' and $rowOutcomes['gibbonDepartmentID'] != '') {

                                            $dataLearningArea = array('gibbonDepartmentID' => $rowOutcomes['gibbonDepartmentID']);
                                            $sqlLearningArea = 'SELECT * FROM gibbonDepartment WHERE gibbonDepartmentID=:gibbonDepartmentID';
                                            $resultLearningArea = $connection2->prepare($sqlLearningArea);
                                            $resultLearningArea->execute($dataLearningArea);
                                        if ($resultLearningArea->rowCount() == 1) {
                                            $rowLearningAreas = $resultLearningArea->fetch();
                                            echo "<span style='font-size: 75%; font-style: italic'>".$rowLearningAreas['name'].'</span>';
                                        }
                                    }
                                    echo '</td>';
                                    echo '<td>';
                                    echo '<b>'.$rowOutcomes['category'].'</b><br/>';
                                    echo '</td>';
                                    echo '<td>';
                                    echo '<b>'.$rowOutcomes['nameShort'].'</b><br/>';
                                    echo "<span style='font-size: 75%; font-style: italic'>".$rowOutcomes['name'].'</span>';
                                    echo '</td>';
                                    echo '<td>';
                                    echo getYearGroupsFromIDList($guid, $connection2, $rowOutcomes['gibbonYearGroupIDList']);
                                    echo '</td>';
                                    echo '<td>';
                                    echo "<script type='text/javascript'>";
                                    echo '$(document).ready(function(){';
                                    echo "\$(\".description-$count\").hide();";
                                    echo "\$(\".show_hide-$count\").fadeIn(1000);";
                                    echo "\$(\".show_hide-$count\").click(function(){";
                                    echo "\$(\".description-$count\").fadeToggle(1000);";
                                    echo '});';
                                    echo '});';
                                    echo '</script>';
                                    if ($rowOutcomes['content'] != '') {
                                        echo "<a title='".__('View Description')."' class='show_hide-$count' onclick='false' href='#'><img style='padding-left: 0px' src='".$session->get('absoluteURL').'/themes/'.$session->get('gibbonThemeName')."/img/page_down.png' alt='".__('Show Comment')."' onclick='return false;' /></a>";
                                    }
                                    echo '</td>';
                                    echo '</tr>';
                                    if ($rowOutcomes['content'] != '') {
                                        echo "<tr class='description-$count' id='description-$count'>";
                                        echo '<td colspan=6>';
                                        echo $rowOutcomes['content'];
                                        echo '</td>';
                                        echo '</tr>';
                                    }
                                    echo '</tr>';

                                    ++$count;
                                }
                                echo '</table>';
                            }
                            echo '</div>';
                            //LESSONS
                            echo "<div id='tabs4'>";
                            $resourceContents = '';

                                $dataLessons = $dataMulti;
                                $sqlLessons = "SELECT * FROM gibbonPlannerEntry WHERE $whereMulti";
                                $resultLessons = $connection2->prepare($sqlLessons);
                                $resultLessons->execute($dataLessons);

                            if ($resultLessons->rowCount() < 1) {
                                echo "<div class='warning'>";
                                echo __('There are no records to display.');
                                echo '</div>';
                            } else {
                                while ($rowLessons = $resultLessons->fetch()) {
                                    echo '<h3>'.$rowLessons['name'].'</h3>';
                                    echo $rowLessons['description'];
                                    $resourceContents .= $rowLessons['description'];
                                    if ($rowLessons['teachersNotes'] != '' and ($highestAction == 'Lesson Planner_viewAllEditMyClasses' or $highestAction == 'Lesson Planner_viewEditAllClasses')) {
                                        echo "<div style='background-color: #F6CECB; padding: 0px 3px 10px 3px; width: 98%; text-align: justify; border-bottom: 1px solid #ddd'><p style='margin-bottom: 0px'><b>".__("Teacher's Notes").':</b></p> '.$rowLessons['teachersNotes'].'</div>';
                                        $resourceContents .= $rowLessons['teachersNotes'];
                                    }


                                        $dataBlock = array('gibbonPlannerEntryID' => $rowLessons['gibbonPlannerEntryID']);
                                        $sqlBlock = 'SELECT * FROM gibbonUnitClassBlock WHERE gibbonPlannerEntryID=:gibbonPlannerEntryID ORDER BY sequenceNumber';
                                        $resultBlock = $connection2->prepare($sqlBlock);
                                        $resultBlock->execute($dataBlock);

                                    while ($rowBlock = $resultBlock->fetch()) {
                                        echo "<h5 style='font-size: 85%'>".$rowBlock['title'].'</h5>';
                                        echo '<p>';
                                        echo '<b>'.__('Type').'</b>: '.$rowBlock['type'].'<br/>';
                                        echo '<b>'.__('Length').'</b>: '.$rowBlock['length'].'<br/>';
                                        echo '<b>'.__('Contents').'</b>: '.$rowBlock['contents'].'<br/>';
                                        $resourceContents .= $rowBlock['contents'];
                                        if ($rowBlock['teachersNotes'] != '' and ($highestAction == 'Lesson Planner_viewAllEditMyClasses' or $highestAction == 'Lesson Planner_viewEditAllClasses')) {
                                            echo "<div style='background-color: #F6CECB; padding: 0px 3px 10px 3px; width: 98%; text-align: justify; border-bottom: 1px solid #ddd'><p style='margin-bottom: 0px'><b>".__("Teacher's Notes").':</b></p> '.$rowBlock['teachersNotes'].'</div>';
                                            $resourceContents .= $rowBlock['teachersNotes'];
                                        }
                                        echo '</p>';
                                    }

									//Print chats
                                    try {
                                        $dataDiscuss = array('gibbonPlannerEntryID' => $rowLessons['gibbonPlannerEntryID']);
                                        $sqlDiscuss = 'SELECT gibbonPlannerEntryDiscuss.*, title, surname, preferredName, category FROM gibbonPlannerEntryDiscuss JOIN gibbonPerson ON (gibbonPlannerEntryDiscuss.gibbonPersonID=gibbonPerson.gibbonPersonID) JOIN gibbonRole ON (gibbonPerson.gibbonRoleIDPrimary=gibbonRole.gibbonRoleID) WHERE gibbonPlannerEntryID=:gibbonPlannerEntryID ORDER BY timestamp';
                                        $resultDiscuss = $connection2->prepare($sqlDiscuss);
                                        $resultDiscuss->execute($dataDiscuss);
                                    } catch (PDOException $e) {}

                                    if ($resultDiscuss->rowCount() > 0) {
                                        echo "<h5 style='font-size: 85%'>".__('Chat').'</h5>';
                                        echo '<style type="text/css">';
                                        echo 'table.chatbox { width: 90%!important }';
                                        echo '</style>';
                                        echo getThread($guid, $connection2, $rowLessons['gibbonPlannerEntryID'], null, 0, null, null, null, null, null, $class[1] ?? '', $session->get('gibbonPersonID'), 'Teacher', false, true);
                                    }
                                }
                            }
                            echo '</div>';
                            //RESOURCES
                            echo "<div id='tabs5'>";
                            $noReosurces = true;

                            if (!empty($resourceContents)) {
                                $resourceContents = '<?xml version="1.0" encoding="UTF-8"?>'.$resourceContents;

                                //Links
                                $links = '';
                                $linksArray = array();
                                $linksCount = 0;
                                $dom = new DOMDocument();
                                @$dom->loadHTML($resourceContents);
                                foreach ($dom->getElementsByTagName('a') as $node) {
                                    if ($node->nodeValue != '') {
                                        $linksArray[$linksCount] = "<li><a href='".$node->getAttribute('href')."'>".$node->nodeValue.'</a></li>';
                                        ++$linksCount;
                                    }
                                }

                                $linksArray = array_unique($linksArray);
                                natcasesort($linksArray);

                                foreach ($linksArray as $link) {
                                    $links .= $link;
                                }

                                if ($links != '') {
                                    echo '<h2>';
                                    echo 'Links';
                                    echo '</h2>';
                                    echo '<ul>';
                                    echo $links;
                                    echo '</ul>';
                                    $noReosurces = false;
                                }

                                //Images
                                $images = '';
                                $imagesArray = array();
                                $imagesCount = 0;
                                $dom2 = new DOMDocument();
                                @$dom2->loadHTML($resourceContents);
                                foreach ($dom2->getElementsByTagName('img') as $node) {
                                    if ($node->getAttribute('src') != '') {
                                        $imagesArray[$imagesCount] = "<img class='resource' style='margin: 10px 0; max-width: 560px' src='".$node->getAttribute('src')."'/><br/>";
                                        ++$imagesCount;
                                    }
                                }

                                $imagesArray = array_unique($imagesArray);
                                natcasesort($imagesArray);

                                foreach ($imagesArray as $image) {
                                    $images .= $image;
                                }

                                if ($images != '') {
                                    echo '<h2>';
                                    echo 'Images';
                                    echo '</h2>';
                                    echo $images;
                                    $noReosurces = false;
                                }

                                //Embeds
                                $embeds = '';
                                $embedsArray = array();
                                $embedsCount = 0;
                                $dom2 = new DOMDocument();
                                @$dom2->loadHTML($resourceContents);
                                foreach ($dom2->getElementsByTagName('iframe') as $node) {
                                    if ($node->getAttribute('src') != '') {
                                        $embedsArray[$embedsCount] = "<iframe style='max-width: 560px' width='".$node->getAttribute('width')."' height='".$node->getAttribute('height')."' src='".$node->getAttribute('src')."' frameborder='".$node->getAttribute('frameborder')."'></iframe>";
                                        ++$embedsCount;
                                    }
                                }

                                $embedsArray = array_unique($embedsArray);
                                natcasesort($embedsArray);

                                foreach ($embedsArray as $embed) {
                                    $embeds .= $embed.'<br/><br/>';
                                }

                                if ($embeds != '') {
                                    echo '<h2>';
                                    echo 'Embeds';
                                    echo '</h2>';
                                    echo $embeds;
                                    $noReosurces = false;
                                }
                            }

							//No resources!
							if ($noReosurces) {
								echo $page->getBlankSlate();
							}
                            echo '</div>';
                            echo '</div>';
                        }
                    }
                }
            }
        }
    }
}
