<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'memorizzato in ":timezone"',
    'displayed_in_tz'                           => 'visualizzato in ":timezone"',
    'close'                                     => 'Chiudi',
    'actions'                                   => 'Azioni',
    'edit'                                      => 'Modifica',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => 'Elimina',
    'split'                                     => 'Dividi',
    'single_split'                              => 'Divisione',
    'clone'                                     => 'Clona',
    'clone_and_edit'                            => 'Clona e modifica',
    'confirm_action'                            => 'Conferma azione',
    'last_seven_days'                           => 'Ultimi sette giorni',
    'last_thirty_days'                          => 'Ultimi trenta giorni',
    'last_180_days'                             => 'Ultimi 180 giorni',
    'month_to_date'                             => 'Ultimo mese',
    'year_to_date'                              => 'Ultimo anno',
    'YTD'                                       => 'Anno corrente',
    'welcome_back'                              => 'La tua situazione finanziaria',
    'main_dashboard_page_title'                 => 'Pagina principale',
    'everything'                                => 'Tutto',
    'today'                                     => 'oggi',
    'customRange'                               => 'Intervallo personalizzato',
    'date_range'                                => 'Intervallo di date',
    'apply'                                     => 'Applica',
    'select_date'                               => 'Seleziona data...',
    'cancel'                                    => 'Annulla',
    'from'                                      => 'Da',
    'to'                                        => 'A',
    'structure'                                 => 'Struttura',
    'help_translating'                          => 'Questo testo di aiuto non è ancora disponibile in italiano. <a href="https://crowdin.com/project/firefly-iii-help">Vuoi aiutare con la traduzione?</a>',
    'showEverything'                            => 'Mostra tutto',
    'never'                                     => 'Mai',
    'no_results_for_empty_search'               => 'Chiave di ricerca vuota, quindi non è stato trovato nulla.',
    'removed_amount'                            => 'Rimosso :amount',
    'added_amount'                              => 'Aggiunto :amount',
    'asset_account_role_help'                   => 'Qualsiasi opzione aggiuntiva risultante dalla tua scelta può essere impostata in seguito.',
    'Opening balance'                           => 'Saldo di apertura',
    'create_new_stuff'                          => 'Crea nuove cose',
    'new_withdrawal'                            => 'Nuova uscita',
    'create_new_transaction'                    => 'Crea una nuova transazione',
    'sidebar_frontpage_create'                  => 'Crea',
    'new_transaction'                           => 'Nuova transazione',
    'no_rules_for_bill'                         => 'Questo pagamento ricorrente non ha regole a esso associate.',
    'go_to_asset_accounts'                      => 'Visualizza i tuoi conti attività',
    'go_to_budgets'                             => 'Vai ai tuoi budget',
    'go_to_withdrawals'                         => 'Vai ai tuoi prelievi',
    'clones_journal_x'                          => 'Questa transazione è un clone di ":description" (#:id)',
    'go_to_categories'                          => 'Vai alle tue categorie',
    'go_to_bills'                               => 'Vai ai tuoi pagamenti ricorrenti',
    'go_to_expense_accounts'                    => 'Vedi i tuoi conti spese',
    'go_to_revenue_accounts'                    => 'Vedi i tuoi conti entrate',
    'go_to_piggies'                             => 'Vai ai tuoi salvadanai',
    'new_deposit'                               => 'Nuova entrata',
    'new_transfer'                              => 'Nuovo trasferimento',
    'new_transfers'                             => 'Nuovo trasferimento',
    'new_asset_account'                         => 'Nuovo conto attività',
    'new_expense_account'                       => 'Nuovo conto spese',
    'new_revenue_account'                       => 'Nuovo conto entrate',
    'new_liabilities_account'                   => 'Nuova passività',
    'new_budget'                                => 'Nuovo budget',
    'new_bill'                                  => 'Nuovo pagamento ricorrente',
    'block_account_logout'                      => 'Sei stato disconnesso. Gli account bloccati non possono utilizzare questo sito. Ti sei registrato con un indirizzo email valido?',
    'flash_success'                             => 'Successo!',
    'flash_info'                                => 'Messaggio',
    'flash_warning'                             => 'Avviso!',
    'flash_error'                               => 'Errore!',
    'flash_danger'                              => 'Attenzione!',
    'flash_info_multiple'                       => 'C\'è un messaggio | Ci sono :count messaggi',
    'flash_error_multiple'                      => 'C\'è un errore | Ci sono :count errors',
    'net_worth'                                 => 'Patrimonio',
    'help_for_this_page'                        => 'Aiuto per questa pagina',
    'help_for_this_page_body'                   => 'Trovi maggiori informazioni su questa pagina <a href="https://docs.firefly-iii.org/">nella documentazione</a>.',
    'two_factor_welcome'                        => 'Ciao!',
    'two_factor_enter_code'                     => 'Per continuare inserisci il tuo codice di autenticazione a due fattori. La tua applicazione può generarlo per te.',
    'two_factor_code_here'                      => 'Inserisci qui il codice',
    'two_factor_title'                          => 'Autenticazione a due fattori',
    'authenticate'                              => 'Autenticati',
    'two_factor_forgot_title'                   => 'Autenticazione a due fattori persa',
    'two_factor_forgot'                         => 'Ho dimenticato la mia chiave a due fattori.',
    'two_factor_lost_header'                    => 'Hai perso l\'autenticazione a due fattori?',
    'two_factor_lost_intro'                     => 'Se hai perso anche i codici di recupero, sei sfortunato. Questo non è qualcosa che puoi risolvere tramite l\'interfaccia web. Hai due scelte.',
    'two_factor_lost_fix_self'                  => 'Se esegui la tua istanza di Firefly III, leggi <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working>questo articolo nelle Domande Frequenti</a> per le istruzioni.',
    'two_factor_lost_fix_owner'                 => 'In caso contrario, invia un mail al proprietario del sito, <a href="mailto::site_owner">:site_owner</a>, e chiedi loro di resettare l\'autenticazione a due fattori.',
    'mfa_backup_code'                           => 'Hai usato un codice di recupero per accedere a Firefly III. Questo codice non potrà essere utilizzato di nuovo, quindi cancellalo dalla lista.',
    'pref_two_factor_new_backup_codes'          => 'Ottieni nuovi codici di recupero',
    'pref_two_factor_backup_code_count'         => 'Hai :count codice di backup valido!Hai :count codici di backup validi.',
    '2fa_i_have_them'                           => 'Li ho salvati!',
    'warning_much_data'                         => ':days di caricamento dei dati potrebbero richiedere un pò di tempo.',
    'registered'                                => 'Ti sei registrato con successo!',
    'Default asset account'                     => 'Conto attività predefinito',
    'no_budget_pointer'                         => 'Sembra che tu non abbia ancora dei budget. Dovresti crearne alcuni nella pagina dei <a href="budgets">budget</a>. I budget possono aiutarti a tenere traccia delle spese.',
    'no_bill_pointer'                           => 'Sembra che tu non abbia ancora un pagamento ricorrente. Dovresti crearne alcuni sulla pagina <a href="subscriptions">pagamenti ricorrenti</a>. I pagamenti ricorrenti possono aiutarti a tenere traccia delle spese.',
    'Savings account'                           => 'Conti risparmio',
    'Credit card'                               => 'Carta di credito',
    'source_accounts'                           => 'Conto origine|Conti origine',
    'destination_accounts'                      => 'Conto destinazione|Conti destinazione',
    'user_id_is'                                => 'Il tuo ID utente è <strong>:user</strong>',
    'field_supports_markdown'                   => 'Questo campo supporta <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Se hai bisogno di ulteriore aiuto con Firefly III, ti preghiamo di <a href="https://github.com/firefly-iii/firefly-iii/issues">aprire un ticket su Github</a>.',
    'reenable_intro_text'                       => 'Puoi anche riattivare <a href="#" id="reenableGuidance">la guida introduttiva</a>.',
    'intro_boxes_after_refresh'                 => 'Le caselle di introduzione riappariranno quando si aggiorna la pagina.',
    'show_all_no_filter'                        => 'Mostra tutte le transazioni senza raggrupparle per data.',
    'expenses_by_category'                      => 'Spese per categorie',
    'expenses_by_budget'                        => 'Spese per budget',
    'income_by_category'                        => 'Entrate per categoria',
    'expenses_by_asset_account'                 => 'Spese per conto attività',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Spiacente ma Firefly III non può reindirizzarti alla pagina corretta.',
    'sum_of_expenses'                           => 'Totale spese',
    'sum_of_income'                             => 'Somma delle entrate',
    'liabilities'                               => 'Passività',
    'spent_in_specific_budget'                  => 'Speso nel budget ":budget"',
    'spent_in_specific_double'                  => 'Spesi nel conto ":account"',
    'earned_in_specific_double'                 => 'Entrati nel conto ":account"',
    'source_account'                            => 'Conto di origine',
    'source_account_reconciliation'             => 'Non puoi modificare il conto di origine di una transazione di riconciliazione.',
    'destination_account'                       => 'Conto destinazione',
    'destination_account_reconciliation'        => 'Non è possibile modificare il conto di destinazione di una transazione di riconciliazione.',
    'sum_of_expenses_in_budget'                 => 'Spesa totale nel budget ":budget"',
    'left_in_budget_limit'                      => 'Disponibile per spese in base ai budget',
    'current_period'                            => 'Periodo corrente',
    'show_the_current_period_and_overview'      => 'Mostra il periodo e la panoramica correnti',
    'pref_languages_locale'                     => 'Affinché una lingua diversa dall\'inglese funzioni correttamente, il sistema operativo deve essere dotato delle corrette informazioni locali. Se queste non sono presenti, i dati di valuta, le date e gli importi potrebbero essere formattati in modo errato.',
    'budget_in_period'                          => 'Tutte le transazioni per il budget ":name" fra :start e :end in :currency',
    'chart_budget_in_period'                    => 'Grafico di tutte le transazioni per il budget ":name" fra :start e :end in :currency',
    'chart_budget_in_period_only_currency'      => 'L\'importo che hai inserito è in :currency, quindi questo grafico mostrerà solo le transazioni in :currency.',
    'chart_account_in_period'                   => 'Grafico di tutte le transazioni per il conto ":name" (:balance) fra :start e :end',
    'chart_category_in_period'                  => 'Grafico di tutte le transazioni per la categoria ":name" fra :start e :end',
    'chart_category_all'                        => 'Grafico di tutte le transazioni per la categoria ":name"',
    'clone_withdrawal'                          => 'Duplica questo prelievo',
    'clone_deposit'                             => 'Duplica questa entrata',
    'clone_transfer'                            => 'Duplica questo trasferimento',
    'multi_select_no_selection'                 => 'Nessuno selezionato',
    'multi_select_select_all'                   => 'Seleziona tutto',
    'multi_select_n_selected'                   => 'selezionato',
    'multi_select_all_selected'                 => 'Seleziona tutto',
    'multi_select_filter_placeholder'           => 'Cerca...',
    'intro_next_label'                          => 'Avanti',
    'intro_prev_label'                          => 'Indietro',
    'intro_skip_label'                          => 'Salta ogni',
    'intro_done_label'                          => 'Fatto',
    'between_dates_breadcrumb'                  => 'Fra :start e :end',
    'all_journals_without_budget'               => 'Tutte le transazioni senza un budget',
    'journals_without_budget'                   => 'Transazioni senza budget',
    'all_journals_without_category'             => 'Tutte le transazioni senza una categoria',
    'journals_without_category'                 => 'Transazioni senza categoria',
    'all_journals_for_account'                  => 'Tutte le transazioni per il conto :name',
    'chart_all_journals_for_account'            => 'Grafico di tutte le transazioni per il conto :name',
    'journals_in_period_for_account'            => 'Tutte le transazioni per il conto :name fra :start e :end',
    'journals_in_period_for_account_js'         => 'Tutte le transazioni per il conto {title} fra {start} e {end}',
    'transferred'                               => 'Trasferito',
    'all_withdrawal'                            => 'Tutte le spese',
    'all_transactions'                          => 'Tutte le Transazioni',
    'title_withdrawal_between'                  => 'Tutte le spese tra :start e :end',
    'all_deposit'                               => 'Tutte le entrate',
    'title_deposit_between'                     => 'Tutte le entrate fra :start e :end',
    'all_transfers'                             => 'Tutti i trasferimenti',
    'title_transfers_between'                   => 'Tutti i trasferimenti fra :start e :end',
    'all_transfer'                              => 'Tutti i trasferimenti',
    'all_journals_for_tag'                      => 'Tutte le transazioni per l\'etichetta ":tag"',
    'title_transfer_between'                    => 'Tutti i trasferimenti fra :start e :end',
    'all_journals_for_category'                 => 'Tutte le transazioni per la categoria :name',
    'all_journals_for_budget'                   => 'Tutte le transazione per budget :name',
    'chart_all_journals_for_budget'             => 'Grafico di tutte le transazioni per il budget :name',
    'journals_in_period_for_category'           => 'Tutte le transazioni per Categoria :name fra :start e :end',
    'journals_in_period_for_tag'                => 'Tutte le transazioni per l\'etichetta :tag fra :start e :end',
    'not_available_demo_user'                   => 'La funzione a cui tenti di accedere non è disponibile per gli utenti demo.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'Il conto attività di origine "@source_name" accetta solo transazioni in @source_currency. Il conto attività di destinazione "@dest_name" accetta solo transazioni in @dest_currency. È necessario fornire l\'importo trasferito correttamente in entrambe le valute.',
    'transaction_data'                          => 'Informazioni transazione',
    'invalid_server_configuration'              => 'Configurazione del server non corretta',
    'invalid_locale_settings'                   => 'Firefly III non è in grado di formattare gli importi monetari, poiché il tuo server è privo dei pacchetti necessari. Esistono delle <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">istruzioni su come farlo</a>.',
    'quickswitch'                               => 'Interruttore veloce',
    'sign_in_to_start'                          => 'Accedi per iniziare la sessione',
    'sign_in'                                   => 'Accedi',
    'register_new_account'                      => 'Registra nuovo conto',
    'forgot_my_password'                        => 'Ho dimenticato la mia password',
    'problems_with_input'                       => 'Ci sono stati alcuni problemi con il tuo inserimento.',
    'reset_password'                            => 'reimposta la tua password',
    'button_reset_password'                     => 'Resetta password',
    'reset_button'                              => 'Resetta',
    'want_to_login'                             => 'Voglio accedere',
    'login_page_title'                          => 'Accedi a Firefly III',
    'register_page_title'                       => 'Registrati a Firefly III',
    'forgot_pw_page_title'                      => 'Hai dimenticato la password per Firefly III',
    'reset_pw_page_title'                       => 'Reimposta la password per Firefly III',
    'cannot_reset_demo_user'                    => 'Non puoi reimpostare la password dell\'utente demo.',
    'no_att_demo_user'                          => 'L\'utente demo non può caricare allegati.',
    'button_register'                           => 'Registrare',
    'authorization'                             => 'Autorizzazione',
    'active_bills_only'                         => 'solo pagamento ricorrente attivo',
    'active_bills_only_total'                   => 'tutti i pagamenti ricorrenti attivi',
    'active_exp_bills_only'                     => 'solo i pagamenti ricorrenti attivi e previsti',
    'active_exp_bills_only_total'               => 'solo i pagamenti ricorrenti previsti attivi',
    'per_period_sum_1D'                         => 'Costi giornalieri previsti',
    'per_period_sum_1W'                         => 'Costi settimanali previsti',
    'per_period_sum_1M'                         => 'Costi mensili previsti',
    'per_period_sum_3M'                         => 'Costi trimestrali previsti',
    'per_period_sum_6M'                         => 'Costi semestrali previsti',
    'per_period_sum_1Y'                         => 'Costi annui previsti',
    'average_per_bill'                          => 'media per pagamento ricorrente',
    'expected_total'                            => 'totale previsto',
    'reconciliation_account_name'               => ':name riconciliazione (:currency)',
    'saved'                                     => 'Salvata',
    'advanced_options'                          => 'Opzioni avanzate',
    'advanced_options_explain'                  => 'Alcune pagine in Firefly III hanno opzioni avanzate nascoste dietro questo pulsante. Questa pagina non ha nulla di interessante, ma controlla le altre!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',

    // Webhooks
    'webhooks'                                  => 'Webhook',
    'webhooks_breadcrumb'                       => 'Webhook',
    'webhooks_menu_disabled'                    => 'disabilitato',
    'no_webhook_messages'                       => 'Non ci sono messaggi webhook',
    'webhook_trigger_STORE_TRANSACTION'         => 'Dopo aver creato la transazione',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Dopo aver aggiornato la transazione',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Dopo aver eliminato la transazione',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Dettagli transazione',
    'webhook_response_ACCOUNTS'                 => 'Dettagli conto',
    'webhook_response_none_BUDGET'              => 'Budget details',
    'webhook_response_none_NONE'                => 'Nessun dettaglio',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Ispeziona',
    'create_new_webhook'                        => 'Crea nuovo webhook',
    'webhooks_create_breadcrumb'                => 'Crea nuovo webhook',
    'webhook_trigger_form_help'                 => 'Indica quale evento attiverà il webhook',
    'webhook_response_form_help'                => 'Indica cosa il webhook deve inviare all\'URL.',
    'webhook_delivery_form_help'                => 'In quale formato il webhook deve fornire i dati.',
    'webhook_active_form_help'                  => 'Il webhook deve essere attivo o non verrà chiamato.',
    'stored_new_webhook'                        => 'Nuovo webhook ":title" salvato',
    'delete_webhook'                            => 'Elimina Webhook',
    'deleted_webhook'                           => 'Webhook ":title" eliminato',
    'edit_webhook'                              => 'Modifica webhook ":title"',
    'updated_webhook'                           => 'Webhook ":title" aggiornato',
    'edit_webhook_js'                           => 'Modifica webhook "{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'Il webhook è stato attivato sulla transazione indicata. Si prega di attendere che i risultati appaiano.',
    'webhook_messages'                          => 'Messaggio Webhook',
    'view_message'                              => 'Visualizza messaggio',
    'view_attempts'                             => 'Visualizza tentativi falliti',
    'message_content_title'                     => 'Contenuto del messaggio Webhook',
    'message_content_help'                      => 'Questo è il contenuto del messaggio che è stato inviato (o ha tentato) utilizzando questo webhook.',
    'attempt_content_title'                     => 'Tentativi del Webhook',
    'attempt_content_help'                      => 'Questi sono tutti i tentativi falliti di questo messaggio webhook da inviare all\'URL configurato. Dopo qualche tempo, Firefly III smetterà di provare.',
    'no_attempts'                               => 'Non ci sono tentativi falliti. È una buona cosa!',
    'webhook_attempt_at'                        => 'Tentativo a {moment}',
    'logs'                                      => 'Log',
    'response'                                  => 'Risposta',
    'visit_webhook_url'                         => 'Visita URL webhook',
    'reset_webhook_secret'                      => 'Reimposta il segreto del webhook',
    'webhook_stored_link'                       => 'Il <a href="webhooks/show/{ID}">webhook #{ID} ("{title}")</a> è stato archiviato.',
    'webhook_updated_link'                      => 'Il <a href="webhooks/show/{ID}">webhook #{ID} ("{title}")</a> è stato aggiornato.',

    // API access
    'authorization_request'                     => 'Firefly III v:version Richiesta Autorizzazione',
    'authorization_request_intro'               => '<strong>:client</strong> sta richiedendo l\'autorizzazione per accedere alla tua amministrazione finanziaria. Desideri autorizzare <strong>:client</strong> ad accedere a questi record?',
    'authorization_request_site'                => 'Sarai reindirizzato a <code>:url</code> che sarà quindi in grado di accedere ai tuoi dati di Firefly III.',
    'authorization_request_invalid'             => 'Questa richiesta di accesso non è valida. Non seguire più questo link.',
    'scopes_will_be_able'                       => 'Questa applicazione sarà in grado di:',
    'button_authorize'                          => 'Autorizza',
    'none_in_select_list'                       => '(nessuna)',
    'no_piggy_bank'                             => '(nessun salvadanaio)',
    'name_in_currency'                          => ':name in :currency',
    'paid_in_currency'                          => 'Pagata in :currency',
    'unpaid_in_currency'                        => 'Non pagata in :currency',
    'is_alpha_warning'                          => 'Stai eseguendo una versione ALHPA. Fai attenzione a bug e problemi.',
    'is_beta_warning'                           => 'Stai eseguendo una versione BETA. Fai attenzione a bug e problemi.',
    'all_destination_accounts'                  => 'Conti di destinazione',
    'all_source_accounts'                       => 'Conti di origine',
    'back_to_index'                             => 'Torna all\'indice',
    'cant_logout_guard'                         => 'Firefly III non può disconnetterti.',
    'internal_reference'                        => 'Riferimento interno',

    // check for updates:
    'update_check_title'                        => 'Controlla aggiornamenti',
    'admin_update_check_title'                  => 'Controlla automaticamente aggiornamento',
    'admin_update_check_explain'                => 'Firefly III può verificare automaticamente gli aggiornamenti. Quando attivi questa impostazione, contatterà il server di aggiornamento per verificare se è disponibile una nuova versione di Firefly III. Quando questo è il caso, riceverai una notifica. Puoi testare questa notifica utilizzando il pulsante a destra. Indicare di seguito se si desidera che Firefly III controlli gli aggiornamenti.',
    'check_for_updates_permission'              => 'Firefly III può controllare gli aggiornamenti, ma è necessario il tuo permesso per farlo. Vai nell\'<a href=":link">amministrazione</a> per indicare se desideri che questa funzione sia abilitata.',
    'updates_ask_me_later'                      => 'Chiedimelo più tardi',
    'updates_do_not_check'                      => 'Non controllare gli aggiornamenti',
    'updates_enable_check'                      => 'Abilita il controllo degli aggiornamenti',
    'admin_update_check_now_title'              => 'Controlla gli aggiornamenti ora',
    'admin_update_check_now_explain'            => 'Se si preme il pulsante, Firefly III controllerà se la versione corrente è la più recente.',
    'check_for_updates_button'                  => 'Controlla ora!',
    'update_new_version_alert'                  => 'È disponibile una nuova versione di Firefly III. Stai utilizzando :your_version, l\'ultima versione è :new_version che è stata rilasciata il :date.',
    'update_version_beta'                       => 'Questa versione è una versione BETA. Puoi avere problemi.',
    'update_version_alpha'                      => 'Questa versione è una versione ALPHA. Puoi avere problemi.',
    'update_current_dev_older'                  => 'Stai eseguendo il rilascio di sviluppo ":version", che è più vecchio dell\'ultima versione :new_version. Si prega di aggiornare!',
    'update_current_dev_newer'                  => 'Stai utilizzando il rilascio di sviluppo :version, che è più recente dell\'ultima versione :new_version.',
    'update_current_version_alert'              => 'Stai utilizzando :version, che è l\'ultima versione disponibile.',
    'update_newer_version_alert'                => 'Stai utilizzando :your_version, che è più recente dell\'ultima versione, :new_version.',
    'update_check_error'                        => 'Si è verificato un errore durante il controllo degli aggiornamenti: :error',
    'unknown_error'                             => 'Errore sconosciuto. Siamo spiacenti.',
    'disabled_but_check'                        => 'Hai disabilitato il controllo degli aggiornamenti. Quindi non dimenticarti di controllare gli aggiornamenti di tanto in tanto. Grazie!',
    'admin_update_channel_title'                => 'Canale di aggiornamento',
    'admin_update_channel_explain'              => 'Firefly III dispone di tre "canali" di aggiornamento che indicano quanto avanti ti trovi in termini di funzionalità, miglioramenti e bug. Usa il canale "beta" se sei avventuroso e quello "alpha" se vuoi vivere pericolosamente.',
    'update_channel_stable'                     => 'Stabile. Tutto dovrebbe funzionare come previsto.',
    'update_channel_beta'                       => 'Beta. Nuove funzionalità ma qualcosa potrebbe rompersi.',
    'update_channel_alpha'                      => 'Alpha. Inseriamo qualsiasi cosa e vediamo cosa funziona.',

    // search
    'search'                                    => 'Cerca',
    'search_query'                              => 'Domanda',
    'search_found_transactions'                 => 'Firefly III ha trovato :count transazione in :time secondi.|Firefly III ha trovato :count transazioni in :time secondi.',
    'search_found_more_transactions'            => 'Firefly III ha trovato più di :count transazioni in :time secondi.',
    'search_for_overview'                       => 'Firefly III è alla ricerca di transazioni che soddisfino <b>tutte</b> delle seguenti condizioni:',
    'search_for_query'                          => 'Devono essere presenti tutte queste parole: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'Nessuna di queste parole può essere presente: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Questi parametri di ricerca non sono validi e sono stati ignorati.',

    // old


    'search_modifier_date_on'                             => 'La data della transazione è ":value"',
    'search_modifier_not_date_on'                         => 'La data della transazione non è ":value"',
    'search_modifier_reconciled'                          => 'La transazione è riconciliata',
    'search_modifier_not_reconciled'                      => 'La transazione non è riconciliata',
    'search_modifier_id'                                  => 'L\'ID della transazione è ":value"',
    'search_modifier_not_id'                              => 'L\'ID della transazione non è ":value"',
    'search_modifier_date_before'                         => 'La data della transazione è antecedente o uguale a ":value"',
    'search_modifier_date_after'                          => 'La data della transazione è successiva o uguale a ":value"',
    'search_modifier_external_id_is'                      => 'L\'ID esterno è ":value"',
    'search_modifier_not_external_id_is'                  => 'L\'ID esterno non è ":value"',
    'search_modifier_no_external_url'                     => 'La transazione non ha URL esterno',
    'search_modifier_no_external_id'                      => 'La transazione non ha un ID esterno',
    'search_modifier_not_any_external_url'                => 'La transazione non ha URL esterno',
    'search_modifier_not_any_external_id'                 => 'La transazione non ha un ID esterno',
    'search_modifier_any_external_url'                    => 'La transazione deve avere un (qualsiasi) URL esterno',
    'search_modifier_any_external_id'                     => 'La transazione deve avere un (qualunque) ID esterno',
    'search_modifier_not_no_external_url'                 => 'La transazione deve avere un (qualsiasi) URL esterno',
    'search_modifier_not_no_external_id'                  => 'La transazione deve avere un (qualunque) ID esterno',
    'search_modifier_internal_reference_is'               => 'Il riferimento interno è ":value"',
    'search_modifier_not_internal_reference_is'           => 'Il riferimento interno non è ":value"',
    'search_modifier_description_starts'                  => 'La descrizione inizia con ":value"',
    'search_modifier_not_description_starts'              => 'La descrizione non inizia con ":value"',
    'search_modifier_description_ends'                    => 'La descrizione termina con ":value"',
    'search_modifier_not_description_ends'                => 'La descrizione non termina con ":value"',
    'search_modifier_description_contains'                => 'La descrizione contiene ":value"',
    'search_modifier_not_description_contains'            => 'La descrizione non contiene ":value"',
    'search_modifier_description_is'                      => 'La descrizione è esattamente ":value"',
    'search_modifier_not_description_is'                  => 'La descrizione non è esattamente ":value"',
    'search_modifier_currency_is'                         => 'La valuta (estera) della transazione è ":value"',
    'search_modifier_not_currency_is'                     => 'La valuta (estera) della transazione non è ":value"',
    'search_modifier_foreign_currency_is'                 => 'La valuta estera della transazione è ":value"',
    'search_modifier_not_foreign_currency_is'             => 'La valuta estera della transazione non è ":value"',
    'search_modifier_has_attachments'                     => 'La transazione deve avere un allegato',
    'search_modifier_has_no_category'                     => 'La transazione non deve avere una categoria',
    'search_modifier_not_has_no_category'                 => 'La transazione deve avere una (qualsiasi) categoria',
    'search_modifier_not_has_any_category'                => 'La transazione non deve avere una categoria',
    'search_modifier_has_any_category'                    => 'La transazione deve avere una (qualsiasi) categoria',
    'search_modifier_has_no_budget'                       => 'La transazione non deve avere un budget',
    'search_modifier_not_has_any_budget'                  => 'La transazione non deve avere budget',
    'search_modifier_has_any_budget'                      => 'La transazione deve avere un budget (qualsiasi)',
    'search_modifier_not_has_no_budget'                   => 'La transazione deve avere un budget (qualsiasi)',
    'search_modifier_has_no_bill'                         => 'La transazione non deve avere alcun pagamento ricorrente',
    'search_modifier_not_has_no_bill'                     => 'La transazione deve avere un (qualsiasi) pagamento ricorrente',
    'search_modifier_has_any_bill'                        => 'La transazione deve avere un (qualsiasi) pagamento ricorrente',
    'search_modifier_not_has_any_bill'                    => 'La transazione non deve avere alcun pagamento ricorrente',
    'search_modifier_has_no_tag'                          => 'La transazione non deve avere etichette',
    'search_modifier_not_has_any_tag'                     => 'La transazione non deve avere etichette',
    'search_modifier_not_has_no_tag'                      => 'La transazione deve avere una (qualsiasi) etichetta',
    'search_modifier_has_any_tag'                         => 'La transazione deve avere una (qualsiasi) etichetta',
    'search_modifier_notes_contains'                      => 'Le note della transazione contengono ":value"',
    'search_modifier_not_notes_contains'                  => 'Le note della transazione non contengono ":value"',
    'search_modifier_notes_starts'                        => 'Le note della transazione iniziano con ":value"',
    'search_modifier_not_notes_starts'                    => 'Le note della transazione non iniziano con ":value"',
    'search_modifier_notes_ends'                          => 'Le note della transazione terminano con ":value"',
    'search_modifier_not_notes_ends'                      => 'Le note della transazione non terminano con ":value"',
    'search_modifier_notes_is'                            => 'Le note della transazione sono esattamente ":value"',
    'search_modifier_not_notes_is'                        => 'Le note della transazione non sono esattamente ":value"',
    'search_modifier_no_notes'                            => 'La transazione non ha note',
    'search_modifier_not_no_notes'                        => 'La transazione deve avere delle note',
    'search_modifier_any_notes'                           => 'La transazione deve avere note',
    'search_modifier_not_any_notes'                       => 'La transazione non ha note',
    'search_modifier_amount_is'                           => 'L\'importo è esattamente :value',
    'search_modifier_not_amount_is'                       => 'Il valore non è :value',
    'search_modifier_amount_less'                         => 'L\'importo è inferiore o uguale a :value',
    'search_modifier_not_amount_more'                     => 'Il valore è minore o uguale a :value',
    'search_modifier_amount_more'                         => 'L\'importo è superiore o uguale a :value',
    'search_modifier_not_amount_less'                     => 'Il valore è maggiore o uguale a :value',
    'search_modifier_source_account_is'                   => 'Il nome del conto di origine è esattamente ":value"',
    'search_modifier_not_source_account_is'               => 'Il nome del conto di origine non è ":value"',
    'search_modifier_source_account_contains'             => 'Il nome del conto di origine contiene ":value"',
    'search_modifier_not_source_account_contains'         => 'Il nome del conto di origine non contiene ":value"',
    'search_modifier_source_account_starts'               => 'Il nome del conto di origine inizia con ":value"',
    'search_modifier_not_source_account_starts'           => 'Il nome del conto di origine non inizia con ":value"',
    'search_modifier_source_account_ends'                 => 'Il nome del conto di origine termina con ":value"',
    'search_modifier_not_source_account_ends'             => 'Il nome del conto di origine non finisce con ":value"',
    'search_modifier_source_account_id'                   => 'L\'ID del conto di origine è :value',
    'search_modifier_not_source_account_id'               => 'L\'ID del conto di origine non è ":value"',
    'search_modifier_source_account_nr_is'                => 'Il numero del conto di origine (IBAN) è ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Il numero del conto di origine (IBAN) non è ":value"',
    'search_modifier_source_account_nr_contains'          => 'Il numero del conto di origine (IBAN) contiene ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Il numero del conto di origine (IBAN) non contiene ":value"',
    'search_modifier_source_account_nr_starts'            => 'Il numero del conto di origine (IBAN) inizia con ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Il numero del conto di origine (IBAN) non inizia con ":value"',
    'search_modifier_source_account_nr_ends'              => 'Il numero del conto di origine (IBAN) finisce con ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Il numero del conto di origine (IBAN) non finisce con ":value"',
    'search_modifier_destination_account_is'              => 'Il nome del conto di destinazione ":value"',
    'search_modifier_not_destination_account_is'          => 'Il nome del conto di destinazione non è ":value"',
    'search_modifier_destination_account_contains'        => 'Il nome del conto di destinazione contiene ":value"',
    'search_modifier_not_destination_account_contains'    => 'Il nome del conto di destinazione non contiene ":value"',
    'search_modifier_destination_account_starts'          => 'Il nome del conto di destinazione inizia con ":value"',
    'search_modifier_not_destination_account_starts'      => 'Il nome del conto di destinazione non inizia con ":value"',
    'search_modifier_destination_account_ends'            => 'Il nome del conto di destinazione finisce con ":value"',
    'search_modifier_not_destination_account_ends'        => 'Il nome del conto di destinazione non finisce con ":value"',
    'search_modifier_destination_account_id'              => 'L\'ID del conto di destinazione è :value',
    'search_modifier_not_destination_account_id'          => 'L\'ID del conto di destinazione non è ":value"',
    'search_modifier_destination_is_cash'                 => 'Il conto di destinazione é il conto "(contanti)"',
    'search_modifier_not_destination_is_cash'             => 'Il conto di destinazione non é il conto "(contanti)"',
    'search_modifier_source_is_cash'                      => 'Il conto di origine é il conto "(contanti)"',
    'search_modifier_not_source_is_cash'                  => 'Il conto di origine non é il conto "(contanti)"',
    'search_modifier_destination_account_nr_is'           => 'Il numero del conto di destinazione (IBAN) è ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Il numero del conto di destinazione (IBAN) è ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Il numero del conto di destinazione (IBAN) contiene ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Il numero del conto di destinazione (IBAN) non contiene ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Il numero del conto di destinazione (IBAN) inizia con ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Il numero del conto di destinazione (IBAN) non inizia con ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Il numero del conto di destinazione (IBAN) termina con ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Il numero del conto di destinazione (IBAN) non finisce con ":value"',
    'search_modifier_account_id'                          => 'L\'ID del conto sorgente e/o destinazione è/sono :value',
    'search_modifier_not_account_id'                      => 'L\'ID del conto di origine o destinazione non è/sono :value',
    'search_modifier_category_is'                         => 'La categoria è ":value"',
    'search_modifier_not_category_is'                     => 'La categoria non è ":value"',
    'search_modifier_budget_is'                           => 'Il budget è ":value"',
    'search_modifier_not_budget_is'                       => 'Il budget non è ":value"',
    'search_modifier_bill_is'                             => 'Il pagamento ricorrente è ":value"',
    'search_modifier_not_bill_is'                         => 'Il pagamento ricorrente non è ":value"',
    'search_modifier_transaction_type'                    => 'Il tipo di transazione è ":value"',
    'search_modifier_not_transaction_type'                => 'Il tipo della transizione non è ":value"',
    'search_modifier_tag_is'                              => 'L\'etichetta è ":value"',
    'search_modifier_tag_contains'                        => 'La bolletta contiene ":value"',
    'search_modifier_not_tag_contains'                    => 'Il tag non contiene ":value"',
    'search_modifier_tag_ends'                            => 'Il tag termina per ":value"',
    'search_modifier_tag_starts'                          => 'Il tag inizia per ":value"',
    'search_modifier_not_tag_is'                          => 'Nessuna etichetta è ":value"',
    'search_modifier_date_on_year'                        => 'La transazione è dell\'anno ":value"',
    'search_modifier_not_date_on_year'                    => 'La transazione non è dell\'anno ":value"',
    'search_modifier_date_on_month'                       => 'La transazione è del mese di ":value"',
    'search_modifier_not_date_on_month'                   => 'La transazione non è del mese di ":value"',
    'search_modifier_date_on_day'                         => 'La transazione è il giorno del mese ":value"',
    'search_modifier_not_date_on_day'                     => 'La transazione non è del giorno del mese ":value"',
    'search_modifier_date_before_year'                    => 'La transazione è precedente all\'anno o dell\'anno ":value"',
    'search_modifier_date_before_month'                   => 'La transazione è precedente o è del mese di ":value"',
    'search_modifier_date_before_day'                     => 'La transazione è precedente o è del giorno ":value"',
    'search_modifier_date_after_year'                     => 'La transazione è successiva all\'anno o dell\'anno ":value"',
    'search_modifier_date_after_month'                    => 'La transazione è successiva o è del mese di ":value"',
    'search_modifier_date_after_day'                      => 'La transazione è successiva o è del giorno ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'Nessun etichetta è ":value"',
    'search_modifier_not_tag_is_not'                      => 'L\'etichetta è ":value"',
    'search_modifier_account_is'                          => 'Entrambi i profili sono ":value"',
    'search_modifier_not_account_is'                      => 'Nessuno conto è ":value"',
    'search_modifier_account_contains'                    => 'Entrambi i profili contengono ":value"',
    'search_modifier_not_account_contains'                => 'Nessun conto contiene ":value"',
    'search_modifier_account_ends'                        => 'Entrambi i profili terminano per ":value"',
    'search_modifier_not_account_ends'                    => 'Nessun conto finisce con ":value"',
    'search_modifier_account_starts'                      => 'Entrambi i profili iniziano per ":value"',
    'search_modifier_not_account_starts'                  => 'Nessun conto inizia con ":value"',
    'search_modifier_account_nr_is'                       => 'Entrambi i numeri di conto / IBAN sono ":value"',
    'search_modifier_not_account_nr_is'                   => 'Nessun numero di conto / IBAN è ":value"',
    'search_modifier_account_nr_contains'                 => 'Entrambi i numeri di conto / IBAN contengono ":value"',
    'search_modifier_not_account_nr_contains'             => 'Nessun numero di conto / IBAN contiene ":value"',
    'search_modifier_account_nr_ends'                     => 'Entrambi i numeri di conto / IBAN terminano per ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Nessun numero di conto / IBAN finisce con ":value"',
    'search_modifier_account_nr_starts'                   => 'Entrambi i numeri di conto / IBAN iniziano per ":value"',
    'search_modifier_not_account_nr_starts'               => 'Nessun numero di conto / IBAN inizia con ":value"',
    'search_modifier_category_contains'                   => 'La categoria contiene ":value"',
    'search_modifier_not_category_contains'               => 'La categoria non contiene ":value"',
    'search_modifier_category_ends'                       => 'La categoria finisce con ":value"',
    'search_modifier_not_category_ends'                   => 'La categoria non termina con ":value"',
    'search_modifier_category_starts'                     => 'La categoria inizia per ":value"',
    'search_modifier_not_category_starts'                 => 'La categoria non inizia con ":value"',
    'search_modifier_budget_contains'                     => 'Il budget contiene ":value"',
    'search_modifier_not_budget_contains'                 => 'Il budget non contiene ":value"',
    'search_modifier_budget_ends'                         => 'Il budget termina con ":value"',
    'search_modifier_not_budget_ends'                     => 'Il budget non termina con ":value"',
    'search_modifier_budget_starts'                       => 'Il budget inizia con ":value"',
    'search_modifier_not_budget_starts'                   => 'Il budget non inizia con ":value"',
    'search_modifier_bill_contains'                       => 'La bolletta contiene ":value"',
    'search_modifier_not_bill_contains'                   => 'Il pagamento ricorrente non contiene ":value"',
    'search_modifier_bill_ends'                           => 'Il pagamento ricorrente termina con ":value"',
    'search_modifier_not_bill_ends'                       => 'Il pagamento ricorrente non termina con ":value"',
    'search_modifier_bill_starts'                         => 'Il pagamento ricorrente inizia con ":value"',
    'search_modifier_not_bill_starts'                     => 'Il pagamento ricorrente non inizia con ":value"',
    'search_modifier_external_id_contains'                => 'L\'ID esterno contiene ":value"',
    'search_modifier_not_external_id_contains'            => 'L\'ID esterno non contiene ":value"',
    'search_modifier_external_id_ends'                    => 'L\'ID esterno termina con ":value"',
    'search_modifier_not_external_id_ends'                => 'L\'ID esterno non termina con ":value"',
    'search_modifier_external_id_starts'                  => 'L\'ID esterno inizia con ":value"',
    'search_modifier_not_external_id_starts'              => 'L\'ID esterno non inizia con ":value"',
    'search_modifier_internal_reference_contains'         => 'Il riferimento interno contiene ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Il riferimento interno non contiene ":value"',
    'search_modifier_internal_reference_ends'             => 'Il riferimento interno termina con ":value"',
    'search_modifier_internal_reference_starts'           => 'Il riferimento interno inizia con ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Il riferimento interno non termina con ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Il riferimento interno non inizia con ":value"',
    'search_modifier_external_url_is'                     => 'L\'URL esterno è ":value"',
    'search_modifier_not_external_url_is'                 => 'L\'URL esterno non è ":value"',
    'search_modifier_external_url_contains'               => 'L\'URL esterno contiene ":value"',
    'search_modifier_not_external_url_contains'           => 'L\'URL esterno non contiene ":value"',
    'search_modifier_external_url_ends'                   => 'L\'URL esterno termina con ":value"',
    'search_modifier_not_external_url_ends'               => 'L\'URL esterno non termina con ":value"',
    'search_modifier_external_url_starts'                 => 'L\'URL esterno inizia con ":value"',
    'search_modifier_not_external_url_starts'             => 'L\'URL esterno non inizia con ":value"',
    'search_modifier_has_no_attachments'                  => 'La transazione non ha allegati',
    'search_modifier_not_has_no_attachments'              => 'La transazione ha allegati',
    'search_modifier_not_has_attachments'                 => 'La transazione non ha allegati',
    'search_modifier_account_is_cash'                     => 'Uno dei due account è l\'account "(contanti)".',
    'search_modifier_not_account_is_cash'                 => 'Nessuno dei due account è l\'account "(contanti)".',
    'search_modifier_journal_id'                          => 'L\'ID del diario è ":value"',
    'search_modifier_not_journal_id'                      => 'L\'ID del diario non è ":value"',
    'search_modifier_recurrence_id'                       => 'L\'ID della transazione ricorrente è ":value"',
    'search_modifier_not_recurrence_id'                   => 'L\'ID della transazione ricorrente non è ":value"',
    'search_modifier_foreign_amount_is'                   => 'L\'importo estero è ":value"',
    'search_modifier_not_foreign_amount_is'               => 'L\'importo estero non è ":value"',
    'search_modifier_foreign_amount_less'                 => 'L\'importo estero è inferiore a ":value"',
    'search_modifier_not_foreign_amount_more'             => 'L\'importo estero è inferiore a ":value"',
    'search_modifier_not_foreign_amount_less'             => 'L\'importo estero è superiore a ":value"',
    'search_modifier_foreign_amount_more'                 => 'L\'importo estero è superiore a ":value"',
    'search_modifier_exists'                              => 'La transazione esiste (qualsiasi transazione)',
    'search_modifier_not_exists'                          => 'La transazione non esiste (nessuna transazione)',

    // date fields
    'search_modifier_interest_date_on'                    => 'La data dell\'interesse della transazione è ":value"',
    'search_modifier_not_interest_date_on'                => 'La data dell\'interesse della transazione non è ":value"',
    'search_modifier_interest_date_on_year'               => 'La data dell\'interesse della transazione è dell\'anno ":value"',
    'search_modifier_not_interest_date_on_year'           => 'La data dell\'interesse della transazione non è dell\'anno ":value"',
    'search_modifier_interest_date_on_month'              => 'La data dell\'interesse della transazione è del mese di ":value"',
    'search_modifier_not_interest_date_on_month'          => 'La data dell\'interesse della transazione non è del mese di ":value"',
    'search_modifier_interest_date_on_day'                => 'La data dell\'interesse della transazione è del giorno del mese ":value"',
    'search_modifier_not_interest_date_on_day'            => 'La data dell\'interesse della transazione non è del giorno del mese ":value"',
    'search_modifier_interest_date_before_year'           => 'La data dell\'interesse della transazione è prima o dell\'anno ":value"',
    'search_modifier_interest_date_before_month'          => 'La data dell\'interesse della transazione è prima o del mese di ":value"',
    'search_modifier_interest_date_before_day'            => 'La data dell\'interesse della transazione è prima o del giorno del mese ":value"',
    'search_modifier_interest_date_after_year'            => 'La data dell\'interesse della transazione è dopo o dell\'anno ":value"',
    'search_modifier_interest_date_after_month'           => 'La data dell\'interesse della transazione è dopo o del mese di ":value"',
    'search_modifier_interest_date_after_day'             => 'La data dell\'interesse della transazione è dopo o del giorno del mese ":value"',
    'search_modifier_book_date_on_year'                   => 'La data di prenotazione della transazione è nell\'anno ":value"',
    'search_modifier_book_date_on_month'                  => 'La data di prenotazione della transazione è nel mese ":value"',
    'search_modifier_book_date_on_day'                    => 'La data di prenotazione della transazione è il giorno del mese ":value"',
    'search_modifier_not_book_date_on_year'               => 'La data di prenotazione della transazione non è nell\'anno ":value"',
    'search_modifier_not_book_date_on_month'              => 'La data di prenotazione della transazione non è nel mese ":value"',
    'search_modifier_not_book_date_on_day'                => 'La data di prenotazione della transazione non è nel giorno del mese ":value"',
    'search_modifier_book_date_before_year'               => 'La data di fatturazione della transazione è precedente o nell\'anno ":value"',
    'search_modifier_book_date_before_month'              => 'La data di fatturazione della transazione è precedente o nel mese ":value"',
    'search_modifier_book_date_before_day'                => 'La data di fatturazione della transazione è precedente o nel mese ":value"',
    'search_modifier_book_date_after_year'                => 'La data di fatturazione della transazione è successiva o nell\'anno ":value"',
    'search_modifier_book_date_after_month'               => 'La data di fatturazione è successiva o nel mese ":value"',
    'search_modifier_book_date_after_day'                 => 'La data di fatturazione è successiva o nel giorno del mese ":value"',
    'search_modifier_process_date_on_year'                => 'La data di elaborazione della transazione è nell\'anno ":value"',
    'search_modifier_process_date_on_month'               => 'La data di elaborazione della transazione è nel mese di ":value"',
    'search_modifier_process_date_on_day'                 => 'La data di elaborazione della transazione è nel giorno del mese ":value"',
    'search_modifier_not_process_date_on_year'            => 'La data di elaborazione della transazione non è nell\'anno ":value"',
    'search_modifier_not_process_date_on_month'           => 'La data di elaborazione della transazione non è nel mese di ":value"',
    'search_modifier_not_process_date_on_day'             => 'La data di elaborazione della transazione è il giorno ":value" del mese',
    'search_modifier_process_date_before_year'            => 'La data di elaborazione della transazione è prima o nell\'anno ":value"',
    'search_modifier_process_date_before_month'           => 'La data di elaborazione della transazione è prima o nel mese di ":value"',
    'search_modifier_process_date_before_day'             => 'La data di fatturazione della transazione è precedente o nel giorno ":value"',
    'search_modifier_process_date_after_year'             => 'La data di elaborazione della transazione o nell\'anno ":value" o successivi',
    'search_modifier_process_date_after_month'            => 'La data di elaborazione della transazione nel mese di ":value" o nei successivi',
    'search_modifier_process_date_after_day'              => 'La data di elaborazione della transazione è nel giorno del mese ":value" o successivi',
    'search_modifier_due_date_on_year'                    => 'La data di scadenza della transazione è nell\'anno ":value"',
    'search_modifier_due_date_on_month'                   => 'La data di scadenza della transazione è nel mese ":value"',
    'search_modifier_due_date_on_day'                     => 'La data di scadenza della transazione è il giorno del mese ":value"',
    'search_modifier_not_due_date_on_year'                => 'La data di scadenza della transazione non è nell\'anno ":value"',
    'search_modifier_not_due_date_on_month'               => 'La data di scadenza della transazione non è nel mese ":value"',
    'search_modifier_not_due_date_on_day'                 => 'La data di scadenza della transazione non è il giorno del mese ":value"',
    'search_modifier_due_date_before_year'                => 'La data di scadenza della transazione è precedente o nell\'anno ":value"',
    'search_modifier_due_date_before_month'               => 'La data di scadenza della transazione è precedente o nel mese di ":value"',
    'search_modifier_due_date_before_day'                 => 'La data di scadenza della transazione è precedente o nel giorno ":value" del mese',
    'search_modifier_due_date_after_year'                 => 'La data di scadenza della transazione è nell\'anno ":value" o successivi',
    'search_modifier_due_date_after_month'                => 'La data di scadenza della transazione nel mese ":value" o successivi',
    'search_modifier_due_date_after_day'                  => 'La data di scadenza della transazione nel giorno del mese ":value" o successivi',
    'search_modifier_payment_date_on_year'                => 'La data di pagamento della transazione è nell\'anno ":value"',
    'search_modifier_payment_date_on_month'               => 'La data di pagamento della transazione è nel mese di ":value"',
    'search_modifier_payment_date_on_day'                 => 'La data di pagamento della transazione è il giorno ":value" del mese',
    'search_modifier_not_payment_date_on_year'            => 'La data di pagamento della transazione non è nell\'anno ":value"',
    'search_modifier_not_payment_date_on_month'           => 'La data di pagamento della transazione non è nel mese ":value"',
    'search_modifier_not_payment_date_on_day'             => 'La data di pagamento della transazione non è il giorno ":value" del mese',
    'search_modifier_payment_date_before_year'            => 'La data di pagamento della transazione è prima o nell\'anno ":value"',
    'search_modifier_payment_date_before_month'           => 'La data di pagamento della transazione è prima o il mese ":value"',
    'search_modifier_payment_date_before_day'             => 'La data di pagamento della transazione è precedente o il giorno ":value"',
    'search_modifier_payment_date_after_year'             => 'La data di pagamento della transazione è nell\'anno ":value" o successivi',
    'search_modifier_payment_date_after_month'            => 'La data di pagamento della transazione è nel mese ":value" o successivi',
    'search_modifier_payment_date_after_day'              => 'La data di pagamento della transazione è nel giorno del mese ":value" o successivi',
    'search_modifier_invoice_date_on_year'                => 'La data di fatturazione della transazione è nell\'anno ":value"',
    'search_modifier_invoice_date_on_month'               => 'La data di fatturazione della transazione è nel mese ":value"',
    'search_modifier_invoice_date_on_day'                 => 'La data di fatturazione della transazione è nel giorno del mese ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'La data di fatturazione della transazione non è nell\'anno ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'La data di fatturazione della transazione non è nell mese ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'La data di fatturazione della transazione non è nel giorno del mese ":value"',
    'search_modifier_invoice_date_before_year'            => 'La data di fatturazione della transazione è precedente o nell\'anno ":value"',
    'search_modifier_invoice_date_before_month'           => 'La data di fatturazione della transazione è precedente o nel mese ":value"',
    'search_modifier_invoice_date_before_day'             => 'La data di fatturazione della transazione è precedente o il giorno ":value" del mese',
    'search_modifier_invoice_date_after_year'             => 'La data di fatturazione della transazione è nell\'anno ":value" o successivi',
    'search_modifier_invoice_date_after_month'            => 'La data di fatturazione della transazione nel mese di ":value" o successivi',
    'search_modifier_invoice_date_after_day'              => 'La data di fatturazione della transazione è successiva o uguale al giorno ":value" del mese',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'La transazione è stata aggiornata l\'ultima volta nell\'anno ":value"',
    'search_modifier_updated_at_on_month'                 => 'La transazione è stata aggiornata l\'ultima volta nel mese ":value"',
    'search_modifier_updated_at_on_day'                   => 'La transazione è stata aggiornata l\'ultima volta nel giorno ":value" del mese',
    'search_modifier_not_updated_at_on_year'              => 'La transazione non è stata aggiornata l\'ultima volta nell\'anno ":value"',
    'search_modifier_not_updated_at_on_month'             => 'La transazione non è stata aggiornata l\'ultima volta nel mese ":value"',
    'search_modifier_not_updated_at_on_day'               => 'La transazione non è stata aggiornata il giorno del mese ":value"',
    'search_modifier_updated_at_before_year'              => 'La transazione è stata aggiornata l\'ultima volta durante o prima dell\'anno ":value"',
    'search_modifier_updated_at_before_month'             => 'La transazione è stata aggiornata l\'ultima volta durante o prima del mese ":value"',
    'search_modifier_updated_at_before_day'               => 'La transazione è stata aggiornata l\'ultima volta durante o prima del giorno del mese ":value"',
    'search_modifier_updated_at_after_year'               => 'La transazione è stata aggiornata l\'ultima volta durante o dopo l\'anno ":value"',
    'search_modifier_updated_at_after_month'              => 'La transazione è stata aggiornata l\'ultima volta durante o dopo il mese ":value"',
    'search_modifier_updated_at_after_day'                => 'La transazione è stata aggiornata l\'ultima volta durante o dopo il giorno del mese ":value"',
    'search_modifier_created_at_on_year'                  => 'La transazione è stata creata nell\'anno ":value"',
    'search_modifier_created_at_on_month'                 => 'La transazione è stata creata nel mese ":value"',
    'search_modifier_created_at_on_day'                   => 'La transazione è stata create nel giorno del mese ":value"',
    'search_modifier_not_created_at_on_year'              => 'La transazione non è stata creata nell\'anno ":value"',
    'search_modifier_not_created_at_on_month'             => 'La transazione non è stata creata nel mese ":value"',
    'search_modifier_not_created_at_on_day'               => 'La transazione non è stata creata il giorno del mese ":value"',
    'search_modifier_created_at_before_year'              => 'La transazione è stata creata durante o prima dell\'anno ":value"',
    'search_modifier_created_at_before_month'             => 'La transazione è stata creata durante o prima del mese ":value"',
    'search_modifier_created_at_before_day'               => 'La transazione è stata creata durante o prima del giorno del mese ":value"',
    'search_modifier_created_at_after_year'               => 'La transazione è stata creata durante o dopo l\'anno ":value"',
    'search_modifier_created_at_after_month'              => 'La transazione è stata creata durante o dopo il mese ":value"',
    'search_modifier_created_at_after_day'                => 'La transazione è stata creata durante o dopo il giorno del mese ":value"',
    'search_modifier_interest_date_before'                => 'La data d\'interesse della transazione è il o prima del ":value"',
    'search_modifier_interest_date_after'                 => 'La data d\'interesse della transazione è il o dopo il ":value"',
    'search_modifier_book_date_on'                        => 'La data di prenotazione della transazione è il ":value"',
    'search_modifier_not_book_date_on'                    => 'La data di prenotazione della transazione non è il ":value"',
    'search_modifier_book_date_before'                    => 'La data di prenotazione della transazione è il o prima del ":value"',
    'search_modifier_book_date_after'                     => 'La data di prenotazione della transazione è il o dopo il ":value"',
    'search_modifier_process_date_on'                     => 'La data di elaborazione della transazione è il ":value"',
    'search_modifier_not_process_date_on'                 => 'La data di elaborazione della transazione non è il ":value"',
    'search_modifier_process_date_before'                 => 'La data di elaborazione della transazione è il o prima del ":value"',
    'search_modifier_process_date_after'                  => 'La data di elaborazione della transazione è il o dopo il ":value"',
    'search_modifier_due_date_on'                         => 'La data di scadenza della transazione è il ":value"',
    'search_modifier_not_due_date_on'                     => 'La data di scadenza della transazione non è il ":value"',
    'search_modifier_due_date_before'                     => 'La data di scadenza della transazione è il o prima del ":value"',
    'search_modifier_due_date_after'                      => 'La data di scadenza della transazione è il o dopo il ":value"',
    'search_modifier_payment_date_on'                     => 'La data di pagamento della transazione è il ":value"',
    'search_modifier_not_payment_date_on'                 => 'La data di pagamento della transazione non è il ":value"',
    'search_modifier_payment_date_before'                 => 'La data di pagamento della transazione è il o prima del ":value"',
    'search_modifier_payment_date_after'                  => 'La data di pagamento della transazione è il o dopo il ":value"',
    'search_modifier_invoice_date_on'                     => 'La data di fatturazione della transazione è il ":value"',
    'search_modifier_not_invoice_date_on'                 => 'La data di fatturazione della transazione non è il ":value"',
    'search_modifier_invoice_date_before'                 => 'La data di fatturazione della transazione è il o prima del ":value"',
    'search_modifier_invoice_date_after'                  => 'La data di fatturazione della transazione è il o dopo il ":value"',
    'search_modifier_created_at_on'                       => 'La transazione è stata creata il giorno ":value"',
    'search_modifier_not_created_at_on'                   => 'La transazione non è stata creata il giorno ":value"',
    'search_modifier_created_at_before'                   => 'La transazione è stata creata il o prima del ":value"',
    'search_modifier_created_at_after'                    => 'La transazione è stata creata il o dopo il ":value"',
    'search_modifier_updated_at_on'                       => 'La transazione è stata aggiornata il ":value"',
    'search_modifier_not_updated_at_on'                   => 'La transazione non è stata aggiornata il ":value"',
    'search_modifier_updated_at_before'                   => 'La transazione è stata aggiornata il o prima del ":value"',
    'search_modifier_updated_at_after'                    => 'La transazione è stata aggiornata il o dopo il ":value"',

    'search_modifier_attachment_name_is'            => 'Il nome di qualsiasi allegato è ":value"',
    'search_modifier_attachment_name_contains'      => 'Il nome di qualsiasi allegato contiene ":value"',
    'search_modifier_attachment_name_starts'        => 'Il nome di qualsiasi allegato inizia con ":value"',
    'search_modifier_attachment_name_ends'          => 'Il nome di qualsiasi allegato finisce con ":value"',
    'search_modifier_attachment_notes_are'          => 'Qualsiasi nota dell\'allegato è ":value"',
    'search_modifier_attachment_notes_contains'     => 'Qualsiasi nota dell\'allegato contiene ":value"',
    'search_modifier_attachment_notes_starts'       => 'Le note di qualsiasi allegato iniziano con ":value"',
    'search_modifier_attachment_notes_ends'         => 'Le note di qualsiasi allegato terminano con ":value"',
    'search_modifier_not_attachment_name_is'        => 'Nessun nome degli allegati ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Nessun nome degli allegati contiene ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Nessun nome degli allegati inizia con ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Nessun nome degli allegati termina con ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Nessuna nota degli allegati è ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Nessuna nota degli allegati contiene ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Nessuna nota degli allegati inizia con ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Nessuna nota degli allegati termina con ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT è ":value"',
    'update_rule_from_query'                        => 'Aggiorna la regola ":rule" dalla ricerca',
    'create_rule_from_query'                        => 'Crea nuova regola dalla ricerca',
    'rule_from_search_words'                        => 'Il motore delle regole ha difficoltà a gestire ":string". La regola suggerita che si adatta alla tua ricerca potrebbe dare risultati diversi. Verifica attentamente che la regola funzioni.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Il saldo del conto di destinazione è esattamente ":value"',
    'search_modifier_not_destination_balance_is'    => 'Il saldo del conto di destinazione NON è esattamente ":value"',
    'search_modifier_source_balance_is'             => 'Il saldo del conto di origine è esattamente ":value"',
    'search_modifier_not_source_balance_is'         => 'Il saldo del conto di origine NON è esattamente ":value"',

    'search_modifier_destination_balance_lte'     => 'Il saldo del conto di destinazione è inferiore o uguale a ":value"',
    'search_modifier_not_destination_balance_lte' => 'Il saldo del conto di destinazione è superiore a ":value"',
    'search_modifier_source_balance_lte'          => 'Il saldo del conto di origine è inferiore o uguale a ":value"',
    'search_modifier_not_source_balance_lte'      => 'Il saldo del conto di origine è superiore a ":value"',

    'search_modifier_destination_balance_lt'     => 'Il saldo del conto di destinazione è inferiore a ":value"',
    'search_modifier_not_destination_balance_lt' => 'Il saldo del conto di destinazione è superiore o uguale a ":value"',
    'search_modifier_source_balance_lt'          => 'Il saldo del conto di origine è inferiore a ":value"',
    'search_modifier_not_source_balance_lt'      => 'Il saldo del conto di origine è maggiore o uguale a ":value"',

    'search_modifier_destination_balance_gte'     => 'Il saldo del conto di destinazione è superiore o uguale a ":value"',
    'search_modifier_not_destination_balance_gte' => 'Il saldo del conto di destinazione è inferiore a ":value"',
    'search_modifier_source_balance_gte'          => 'Il saldo del conto di origine è maggiore o uguale a ":value"',
    'search_modifier_not_source_balance_gte'      => 'Il saldo del conto di origine è inferiore a ":value"',

    'search_modifier_destination_balance_gt'              => 'Il saldo del conto di destinazione è superiore a ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Il saldo del conto di destinazione è inferiore o uguale a ":value"',
    'search_modifier_source_balance_gt'                   => 'Il saldo del conto di origine è superiore a ":value"',
    'search_modifier_not_source_balance_gt'               => 'Il saldo del conto di origine è inferiore o uguale a ":value"',


    // END
    'general_search_error'                                => 'Si è verificato un errore durante la ricerca. Si prega di controllare i file di registro per ulteriori informazioni.',
    'search_box'                                          => 'Ricerca',
    'search_box_intro'                                    => 'Benvenuto nella funzione di ricerca di Firefly III. Inserisci la query di ricerca nella casella. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Assicurati di controllare il file della guida</a> perché la ricerca è piuttosto avanzata.',
    'search_error'                                        => 'Errore durante la ricerca',
    'search_searching'                                    => 'Ricerca in corso...',
    'search_results'                                      => 'Risultati ricerca',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'annualmente',
    'repeat_freq_half-year'                               => 'semestralmente',
    'repeat_freq_quarterly'                               => 'trimestralmente',
    'repeat_freq_monthly'                                 => 'mensilmente',
    'repeat_freq_weekly'                                  => 'settimanalmente',
    'repeat_freq_daily'                                   => 'ogni giorno',
    'daily'                                               => 'ogni giorno',
    'weekly'                                              => 'settimanale',
    'quarterly'                                           => 'trimestrale',
    'half-year'                                           => 'ogni sei mesi',
    'yearly'                                              => 'annuale',

    // rules
    'is_not_rule_trigger'                                 => 'Non',
    'cannot_fire_inactive_rules'                          => 'Non puoi eseguire regole inattive.',
    'show_triggers'                                       => 'Mostra inneschi',
    'show_actions'                                        => 'Mostra azioni',
    'rules'                                               => 'Regole',
    'rule_name'                                           => 'Nome regola',
    'rule_triggers'                                       => 'La regola si innesca quando',
    'rule_actions'                                        => 'La regola eseguirà',
    'new_rule'                                            => 'Nuova regola',
    'new_rule_group'                                      => 'Nuovo gruppo di regole',
    'rule_priority_up'                                    => 'Dai maggiore priorità alla regola',
    'rule_priority_down'                                  => 'Dai minore priorità alla regola',
    'make_new_rule_group'                                 => 'Crea un nuovo gruppo di regole',
    'store_new_rule_group'                                => 'Memorizza un nuovo gruppo di regole',
    'created_new_rule_group'                              => 'Nuovo gruppo di regole ":title" memorizzate!',
    'updated_rule_group'                                  => 'Gruppo di regole ":title" aggiornato con successo.',
    'edit_rule_group'                                     => 'Modifica il gruppo di regole ":title"',
    'duplicate_rule'                                      => 'Duplica regola ":title"',
    'rule_copy_of'                                        => 'Copia di ":title"',
    'duplicated_rule'                                     => 'Regola ":title" duplicata come ":newTitle"',
    'delete_rule_group'                                   => 'Elimina il gruppo di regole ":title"',
    'deleted_rule_group'                                  => 'Gruppo regole eliminato ":title"',
    'update_rule_group'                                   => 'Aggiorna gruppo di regole',
    'no_rules_in_group'                                   => 'Non ci sono regole in questo gruppo',
    'move_rule_group_up'                                  => 'Sposta sopra il gruppo di regole',
    'move_rule_group_down'                                => 'Sposta sotto il gruppo di regole',
    'save_rules_by_moving'                                => 'Salva questa regola spostandola in un altro gruppo di regole:|Salva queste regole spostandole in un altro gruppo di regole:',
    'make_new_rule'                                       => 'Crea una nuova regola nel gruppo di regole ":title"',
    'make_new_rule_no_group'                              => 'Crea una nuova regola',
    'instructions_rule_from_bill'                         => 'Per abbinare le transazioni al tuo nuovo pagamento ricorrente ":name" Firefly III può creare una regola verrà automaticamente controllata per ogni transazione che memorizzi. Verifica i dettagli sottostanti e salva la regola perché Firefly III abbini le transazioni alla tua nuova bolletta.',
    'instructions_rule_from_journal'                      => 'Crea una regola basata su una delle tue transazioni. Completa o conferma il modulo sottostante.',
    'rule_is_strict'                                      => 'regola severa',
    'rule_is_not_strict'                                  => 'regola non severa',
    'rule_help_stop_processing'                           => 'Quando si seleziona questa casella, le regole successive in questo gruppo non saranno eseguite se questa particolare regola viene eseguita.',
    'rule_help_strict'                                    => 'Nelle regole severe TUTTI i trigger devono venire azionati perché l\'azione venga eseguita. Nelle regole non severe, è sufficiente UN QUALSIASI trigger perché l\'azione venga eseguita.',
    'rule_help_active'                                    => 'Le regole non attive non verranno mai eseguite.',
    'stored_new_rule'                                     => 'Nuova regola memorizzata con titolo ":title"',
    'deleted_rule'                                        => 'Regola eliminata con titolo ":title"',
    'store_new_rule'                                      => 'Salva nuova regola',
    'updated_rule'                                        => 'Regola aggiornata con titolo ":title"',
    'default_rule_group_name'                             => 'Regole predefinite',
    'default_rule_group_description'                      => 'Tutte le tue regole che non sono in un gruppo specifico.',
    'trigger'                                             => 'Trigger',
    'trigger_value'                                       => 'Attiva al valore',
    'stop_processing_other_triggers'                      => 'Smetti di elaborare altri trigger',
    'add_rule_trigger'                                    => 'Aggiungi un nuovo trigger',
    'action'                                              => 'Azione',
    'action_value'                                        => 'Valore azione',
    'stop_executing_other_actions'                        => 'Smetti di eseguire altre azioni',
    'add_rule_action'                                     => 'Aggiungi nuova azione',
    'edit_rule'                                           => 'Modifica regola #:nr ":title"',
    'delete_rule'                                         => 'Elimina regola ":title"',
    'update_rule'                                         => 'Aggiorna regola',
    'test_rule_triggers'                                  => 'Vedi le transazioni corrispondenti',
    'warning_no_matching_transactions'                    => 'Nessuna transazione corrispondente trovata.',
    'warning_no_valid_triggers'                           => 'Nessun trigger valido fornito.',
    'apply_rule_selection'                                => 'Applica la regola ":title" a una selezione delle tue transazioni',
    'apply_rule_selection_intro'                          => 'Regole come ":title" sono normalmente applicate solo a transazioni nuove o aggiornate, ma puoi dire a Firefly III di eseguirle su una selezione delle tue transazioni esistenti. Questo può essere utile quando hai aggiornato una regola e hai bisogno che le modifiche vengano applicate a tutte le altre transazioni.',
    'include_transactions_from_accounts'                  => 'Includi transazioni da questi conti',
    'include'                                             => 'Includere?',
    'applied_rule_selection'                              => '{0} Nessuna transazione della selezione è stata cambiata dalla regola ":title".|[1] Una transazione della selezione è stata modificata dalla regola ":title".|[2,*] :count transazioni della selezione sono state modificate dalla regola ":title".',
    'execute'                                             => 'Eseguire',
    'apply_rule_group_selection'                          => 'Applica il gruppo di regole ":title" a una selezione delle tue transazioni',
    'apply_rule_group_selection_intro'                    => 'Gruppi di regole come ":title" sono normalmente applicati solo a transazioni nuove o aggiornate, ma puoi dire a Firefly III di eseguire tutte le regole in questo gruppo su una selezione delle tue transazioni esistenti. Questo può essere utile quando hai aggiornato un gruppo di regole e hai bisogno delle modifiche da applicare a tutte le tue altre transazioni.',
    'applied_rule_group_selection'                        => 'Il gruppo di regole ":title" è stato applicato alla selezione.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Quando una transazione viene creata',
    'rule_trigger_update_journal'                         => 'Quando una transazione viene aggiornata',
    'rule_trigger_manual'                                 => 'Solo se attivato dall\'utente',
    'rule_trigger_user_action'                            => 'L\'azione dell\'utente è ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Il nome del conto di origine inizia con..',
    'rule_trigger_source_account_starts'                  => 'Il nome del conto di origine inizia con ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Il nome del conto di origine termina con..',
    'rule_trigger_source_account_ends'                    => 'Il nome del conto di origine termina con ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Il nome del conto di origine è..',
    'rule_trigger_source_account_is'                      => 'Il nome del conto di origine è ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Il nome del conto di origine contiene...',
    'rule_trigger_source_account_contains'                => 'Il nome del conto di origine contiene ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Entrambi gli ID del conto sono esattamente..',
    'rule_trigger_account_id'                             => 'Entrambi gli ID dei conti sono esattamente :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'L\'ID del conto di origine è esattamente...',
    'rule_trigger_source_account_id'                      => 'L\'ID del conto di origine è esattamente :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'L\'ID del conto di destinazione è esattamente...',
    'rule_trigger_destination_account_id'                 => 'L\'ID del conto di destinazione è esattamente :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Entrambi i conti sono contanti',
    'rule_trigger_account_is_cash'                        => 'Entrambi i conti sono contanti',
    'rule_trigger_source_is_cash_choice'                  => 'Il conte di origine è un conto (in contanti)',
    'rule_trigger_source_is_cash'                         => 'Il conte di origine è un conto (in contanti)',
    'rule_trigger_destination_is_cash_choice'             => 'Il conto destinazione è un conto (in contanti)',
    'rule_trigger_destination_is_cash'                    => 'Il conto destinazione è un conto (in contanti)',
    'rule_trigger_source_account_nr_starts_choice'        => 'Il numero del conto di origine / l\'IBAN inizia con...',
    'rule_trigger_source_account_nr_starts'               => 'Il numero del conto di origine / l\'IBAN inizia con ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Il numero del conto di origine / l\'IBAN termina con...',
    'rule_trigger_source_account_nr_ends'                 => 'Il numero del conto di origine / l\'IBAN termina con ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Il numero del conto di origine / l\'IBAN è...',
    'rule_trigger_source_account_nr_is'                   => 'Il numero del conto di origine / l\'IBAN è ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Il numero del conto di origine / l\'IBAN contiene...',
    'rule_trigger_source_account_nr_contains'             => 'Il numero del conto di origine / IBAN contiene ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Il nome del conto di destinazione inizia con...',
    'rule_trigger_destination_account_starts'             => 'Il nome del conto di destinazione inizia con ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Il nome del conto di destinazione termina con...',
    'rule_trigger_destination_account_ends'               => 'Il nome del conto di destinazione termina con ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Il nome del conto di destinazione è..',
    'rule_trigger_destination_account_is'                 => 'Il nome del conto di destinazione è ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Il nome del conto di destinazione contiene..',
    'rule_trigger_destination_account_contains'           => 'Il conto di destinazione contiene ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Il numero del conto di destinazione / l\'IBAN inizia con..',
    'rule_trigger_destination_account_nr_starts'          => 'Il numero del conto di destinazione / l\'IBAN inizia con ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Il numero del conto di destinazione / l\'IBAN termina con..',
    'rule_trigger_destination_account_nr_ends'            => 'Il numero del conto di destinazione / l\'IBAN termina con ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Il numero del conto di destinazione / l\'IBAN è..',
    'rule_trigger_destination_account_nr_is'              => 'Il numero del conto di destinazione / l\'IBAN è ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Il numero del conto di destinazione / l\'IBAN contiene..',
    'rule_trigger_destination_account_nr_contains'        => 'Il numero del conto di destinazione / l\'IBAN contiene ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'La transazione è di tipo...',
    'rule_trigger_transaction_type'                       => 'La transazione è di tipo ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'La categoria è...',
    'rule_trigger_category_is'                            => 'La categoria è ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'L\'importo è inferiore o uguale a ..',
    'rule_trigger_amount_less'                            => 'L\'importo è inferiore o uguale a :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'L\'importo è..',
    'rule_trigger_amount_is'                              => 'L\'importo è :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'L\'importo è superiore o uguale a..',
    'rule_trigger_amount_more'                            => 'L\'importo è superiore o uguale a :trigger_value',
    'rule_trigger_description_starts_choice'              => 'La descrizione inizia con...',
    'rule_trigger_description_starts'                     => 'La descrizione inizia con ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'La descrizione termina con...',
    'rule_trigger_description_ends'                       => 'La descrizione termina con ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'La descrizione contiene...',
    'rule_trigger_description_contains'                   => 'La descrizione contiene ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'La descrizione è...',
    'rule_trigger_description_is'                         => 'La descrizione è ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'La data della transizione è..',
    'rule_trigger_date_on'                                => 'La data della transizione è ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'La data della transazione è antecedente al...',
    'rule_trigger_date_before'                            => 'La data della transazione è antecedente al ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'La data della transazione è successiva al...',
    'rule_trigger_date_after'                             => 'La data della transazione è successiva al ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'La transazione è avvenuta il..',
    'rule_trigger_created_at_on'                          => 'La transazione è avvenuta il ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'La transazione è stata modificata l\'ultima volta il..',
    'rule_trigger_updated_at_on'                          => 'Transazione modificata l\'ultima volta il ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Il budget è...',
    'rule_trigger_budget_is'                              => 'Il budget è ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Qualsiasi tag è..',
    'rule_trigger_tag_is'                                 => 'Qualsiasi tag è ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Qualsiasi tag contiene..',
    'rule_trigger_tag_contains'                           => 'Qualsiasi tag contiene ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Qualsiasi tag finisce con..',
    'rule_trigger_tag_ends'                               => 'Qualsiasi tag che termina per ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Qualsiasi tag che inizia con..',
    'rule_trigger_tag_starts'                             => 'Qualsiasi tag che inizia per ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'La valuta della transazione è...',
    'rule_trigger_currency_is'                            => 'La valuta della transazione è ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'La valuta estera della transazione è...',
    'rule_trigger_foreign_currency_is'                    => 'La valuta estera della transazione è ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Ha qualsiasi allegati',
    'rule_trigger_has_attachments'                        => 'Ha qualsiasi allegato(i)',
    'rule_trigger_has_no_category_choice'                 => 'Non ha categoria',
    'rule_trigger_has_no_category'                        => 'La transazione non ha categoria',
    'rule_trigger_has_any_category_choice'                => 'Ha una (qualsiasi) categoria',
    'rule_trigger_has_any_category'                       => 'La transazione ha una (qualsiasi) categoria',
    'rule_trigger_has_no_budget_choice'                   => 'Non ha un budget',
    'rule_trigger_has_no_budget'                          => 'La transazione non ha un budget',
    'rule_trigger_has_any_budget_choice'                  => 'Ha un (qualsiasi) budget',
    'rule_trigger_has_any_budget'                         => 'La transazione ha un (qualsiasi) budget',
    'rule_trigger_has_no_bill_choice'                     => 'Non ha pagamenti ricorrenti',
    'rule_trigger_has_no_bill'                            => 'La transazione non ha pagamenti ricorrenti',
    'rule_trigger_has_any_bill_choice'                    => 'Ha un (qualsiasi) pagamento ricorrente',
    'rule_trigger_has_any_bill'                           => 'La transazione ha un (qualsiasi) pagamento ricorrente',
    'rule_trigger_has_no_tag_choice'                      => 'Non ha etichette',
    'rule_trigger_has_no_tag'                             => 'La transazione non ha etichette',
    'rule_trigger_has_any_tag_choice'                     => 'Ha una o più etichette (qualsiasi)',
    'rule_trigger_has_any_tag'                            => 'La transazione ha una o più etichette (qualsiasi)',
    'rule_trigger_any_notes_choice'                       => 'Ha una (qualsiasi) nota',
    'rule_trigger_any_notes'                              => 'La transazione ha una (qualsiasi) nota',
    'rule_trigger_no_notes_choice'                        => 'Non ha note',
    'rule_trigger_no_notes'                               => 'La transazione non ha note',
    'rule_trigger_notes_is_choice'                        => 'Le note sono..',
    'rule_trigger_notes_is'                               => 'Le note sono ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Le note contengono..',
    'rule_trigger_notes_contains'                         => 'Le note contengono ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Le note iniziano per..',
    'rule_trigger_notes_starts'                           => 'Le note iniziano per ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Le note terminano per..',
    'rule_trigger_notes_ends'                             => 'Le note terminano per ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Il pagamento ricorrente è..',
    'rule_trigger_bill_is'                                => 'Il pagamento ricorrente è ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'L\'ID esterno è..',
    'rule_trigger_external_id_is'                         => 'L\'ID esterno è ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Il riferimento interno è..',
    'rule_trigger_internal_reference_is'                  => 'Il riferimento interno è ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'L\'ID journal della transazione è...',
    'rule_trigger_journal_id'                             => 'L\'ID journal della transazione è ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'La transazione contiene un URL esterno (qualsiasi)',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'La transazione contiene un ID esterno (qualsiasi)',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'La transazione non ha URL esterno',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'La transazione non ha ID esterno',
    'rule_trigger_id_choice'                              => 'L\'ID della transazione è...',
    'rule_trigger_id'                                     => 'L\'ID della transazione è ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT è..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT è ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'L\'azione dell\'utente è ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'Nessun tag è..',
    'rule_trigger_tag_is_not'                             => 'Nessun tag è ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Entrambi i conti sono esattamente..',
    'rule_trigger_account_is'                             => 'Entrambi i conti sono esattamente ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Entrambi i conti contengono..',
    'rule_trigger_account_contains'                       => 'Entrambi i conti contengono ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Entrambi i conti terminano per..',
    'rule_trigger_account_ends'                           => 'Entrambi i conti terminano per ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Entrambi i conti iniziano per..',
    'rule_trigger_account_starts'                         => 'Entrambi i conti terminano per ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Entrambi i numeri di conto / IBAN sono..',
    'rule_trigger_account_nr_is'                          => 'Entrambi i numeri di conto / IBAN sono ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Entrambi i numeri di conto / IBAN contengono..',
    'rule_trigger_account_nr_contains'                    => 'Entrambi i numeri di conto / IBAN contengono ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Entrambi i numeri di conto / IBAN terminano per..',
    'rule_trigger_account_nr_ends'                        => 'Entrambi i numeri di conto / IBAN terminano per ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Entrambi i numeri di conto / IBAN iniziano per..',
    'rule_trigger_account_nr_starts'                      => 'Entrambi i numeri di conto / IBAN iniziano per ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'La categoria contiene..',
    'rule_trigger_category_contains'                      => 'La categoria contiene ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'La categoria termina per..',
    'rule_trigger_category_ends'                          => 'La categoria termina per ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'La categoria inizia per..',
    'rule_trigger_category_starts'                        => 'La categoria inizia per ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Il budget contiene..',
    'rule_trigger_budget_contains'                        => 'Il budget contiene ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Il budget termina per..',
    'rule_trigger_budget_ends'                            => 'Il budget termina per ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Il budget inizia per..',
    'rule_trigger_budget_starts'                          => 'Il budget inizia per ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Il pagamento ricorrente contiene..',
    'rule_trigger_bill_contains'                          => 'Il pagamento ricorrente contiene ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Il pagamento ricorrente termina con..',
    'rule_trigger_bill_ends'                              => 'Il pagamento ricorrente termina con ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Il pagamento ricorrente inizia con..',
    'rule_trigger_bill_starts'                            => 'Il pagamento ricorrente inizia con ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'L\'ID esterno contiene..',
    'rule_trigger_external_id_contains'                   => 'L\'ID esterno contiene ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'L\'ID esterno termina per..',
    'rule_trigger_external_id_ends'                       => 'L\'ID esterno termina per ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'L\'ID esterno inizia per..',
    'rule_trigger_external_id_starts'                     => 'L\'ID esterno inizia per ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Il riferimento interno contiene..',
    'rule_trigger_internal_reference_contains'            => 'Il riferimento interno contiene ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Il riferimento interno termina per..',
    'rule_trigger_internal_reference_ends'                => 'Il riferimento interno termina per ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Il riferimento interno inizia per..',
    'rule_trigger_internal_reference_starts'              => 'Il riferimento interno inizia per ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'L\'URL esterno è..',
    'rule_trigger_external_url_is'                        => 'L\'URL esterno è ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'L\'URL esterno contiene..',
    'rule_trigger_external_url_contains'                  => 'L\'URL esterno contiene ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'L\'URL esterno termina per..',
    'rule_trigger_external_url_ends'                      => 'L\'URL esterno termina per ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'L\'URL esterno inizia per..',
    'rule_trigger_external_url_starts'                    => 'L\'URL esterno inizia per ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Non contiene allegati',
    'rule_trigger_has_no_attachments'                     => 'La transazione non contiene alcun allegato',
    'rule_trigger_recurrence_id_choice'                   => 'L\'ID della transazione ricorrente è..',
    'rule_trigger_recurrence_id'                          => 'L\'ID della transazione ricorrente è ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'La data di interesse è il..',
    'rule_trigger_interest_date_on'                       => 'La data di interesse è il ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'La data di interesse è prima del..',
    'rule_trigger_interest_date_before'                   => 'La data di interesse è prima del ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'La data di interesse è dopo il..',
    'rule_trigger_interest_date_after'                    => 'La data di interesse è dopo il ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'La data di prenotazione è il..',
    'rule_trigger_book_date_on'                           => 'La data di prenotazione è il ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'La data di prenotazione è prima del..',
    'rule_trigger_book_date_before'                       => 'La data di prenotazione è prima del ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'La data di prenotazione è dopo il..',
    'rule_trigger_book_date_after'                        => 'La data di prenotazione è dopo il ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'La data di elaborazione è il..',
    'rule_trigger_process_date_on'                        => 'La data di elaborazione è il ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'La data di elaborazione è prima del..',
    'rule_trigger_process_date_before'                    => 'La data di elaborazione è prima del ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'La data di elaborazione è dopo il..',
    'rule_trigger_process_date_after'                     => 'La data di elaborazione è dopo il ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'La data di scadenza è il..',
    'rule_trigger_due_date_on'                            => 'La data di scadenza è il ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'La data di scadenza è prima del..',
    'rule_trigger_due_date_before'                        => 'La data di scadenza è prima del ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'La data di scadenza è dopo il..',
    'rule_trigger_due_date_after'                         => 'La data di scadenza è dopo il ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'La data di pagamento è il..',
    'rule_trigger_payment_date_on'                        => 'La data di pagamento è il ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'La data di pagamento è prima del..',
    'rule_trigger_payment_date_before'                    => 'La data di pagamento è prima del ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'La data di pagamento è dopo il..',
    'rule_trigger_payment_date_after'                     => 'La data di pagamento è dopo il ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'La data di fatturazione è il..',
    'rule_trigger_invoice_date_on'                        => 'La data di fatturazione è il ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'La data di fatturazione è prima del..',
    'rule_trigger_invoice_date_before'                    => 'La data di fatturazione è prima del ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'La data di fatturazione è dopo il..',
    'rule_trigger_invoice_date_after'                     => 'La data di fatturazione è dopo il ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'La transazione è stata creata prima del..',
    'rule_trigger_created_at_before'                      => 'La transazione è stata creata prima del ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'La transazione è stata creata dopo il..',
    'rule_trigger_created_at_after'                       => 'La transazione è stata creata dopo il ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'La transazione è stata aggiornata prima del..',
    'rule_trigger_updated_at_before'                      => 'La transazione è stata aggiornata prima del ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'La transazione è stata aggiornata dopo il..',
    'rule_trigger_updated_at_after'                       => 'La transazione è stata aggiornata dopo ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'L\'importo straniero è esattamente di..',
    'rule_trigger_foreign_amount_is'                      => 'L\'importo straniero è esattamente di ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'L\'importo straniero è inferiore a..',
    'rule_trigger_foreign_amount_less'                    => 'L\'importo straniero è inferiore a ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'L\'importo straniero è maggiore di..',
    'rule_trigger_foreign_amount_more'                    => 'L\'importo straniero è maggiore di ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Il nome di qualsiasi allegato è..',
    'rule_trigger_attachment_name_is'                     => 'Il nome di qualsiasi allegato è ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Il nome di qualsiasi allegato contiene..',
    'rule_trigger_attachment_name_contains'               => 'Il nome di qualsiasi allegato contiene ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Il nome di qualsiasi allegato inizia per..',
    'rule_trigger_attachment_name_starts'                 => 'Il nome di qualsiasi allegato inizia per ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Il nome di qualsiasi allegato termina per..',
    'rule_trigger_attachment_name_ends'                   => 'Il nome di qualsiasi allegato termina per ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Le note di qualsiasi allegato sono..',
    'rule_trigger_attachment_notes_are'                   => 'Le note di qualsiasi allegato sono ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Le note di qualsiasi allegato contengono..',
    'rule_trigger_attachment_notes_contains'              => 'Le note di qualsiasi allegato contengono ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Le note di qualsiasi allegato iniziano per..',
    'rule_trigger_attachment_notes_starts'                => 'Le note di qualsiasi allegato iniziano per ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Le note di qualsiasi allegato terminano per..',
    'rule_trigger_attachment_notes_ends'                  => 'Le note di qualsiasi allegato terminano per ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'La transazione è riconciliata',
    'rule_trigger_reconciled'                             => 'La transazione è riconciliata',
    'rule_trigger_exists_choice'                          => 'Qualsiasi transazione corrisponde(!)',
    'rule_trigger_exists'                                 => 'Qualsiasi transazione corrisponde',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'L\'ID del conto non è ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'L\'ID del conto di origine non è ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'L\'ID del conto di destinazione non è ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Il tipo di transazione non è ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Il tag non è ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Il tag è ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'La descrizione non è ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'La descrizione non termina per ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'La descrizione non inizia per ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Le note non sono ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Le note non contengono ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Le note non terminano per ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Le note non iniziano per ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Il conto di origine non è ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Il conto di origine non contiene ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Il conto di origine non termina per ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Il conto di origine non inizia per ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Il numero del conto di origine / IBAN non è ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Il numero del conto di origine / IBAN non contiene ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Il numero del conto di origine / IBAN non termina per ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Il numero del conto di origine / IBAN non inizia per ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Il conto di destinazione non è ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Il conto di destinazione non contiene ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Il conto di destinazione non termina per ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Il conto di destinazione non inizia per ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Il numero del conto / IBAN di destinazione non è ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Il numero del conto / IBAN di destinazione non contiene ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Il numero del conto / IBAN di destinazione non termina per ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Il numero del conto / IBAN di destinazione non inizia per ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Nessun conto è ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Nessun conto contiene ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Nessun conto termina per ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Nessun conto inizia per ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Nessun numero di conto / IBAN è ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Nessun numero di conto / IBAN contiene ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Nessun numero di conto / IBAN termina per ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Nessun numero di conto / IBAN inizia per ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'La categoria non è ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'La categoria non contiene ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'La categoria non termina per ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'La categoria non inizia per ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Il budget non è ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Il budget non contiene ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Il budget non termina il ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Il budget non inizia per ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Il pagamento ricorrente non è ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Il pagamento ricorrente non contiene ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Il pagamento ricorrente non termina in ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Il pagamento ricorrente non termina con ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'L\'ID esterno non è ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'L\'ID esterno non contiene ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'L\'ID esterno non termina il ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'L\'ID esterno non inizia per ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Il riferimento interno non è ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Il riferimento interno non contiene ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Il riferimento interno non termina il ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Il riferimento interno non inizia per ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'L\'URL esterno non è ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'L\'URL esterno non contiene ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'L\'URL esterno non termina il ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'L\'URL esterno non inizia per ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'La valuta non è ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'La valuta straniera non è ":trigger_value"',
    'rule_trigger_not_id'                                 => 'L\'ID della transazione non è ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'L\'ID del diario della transazione non è ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'L\'ID della ricorrenza non è ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'La data non è ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'La data non è prima del ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'La data non è dopo il ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'La data d\'interesse non è il ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'La data d\'interesse non è prima del ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'La data d\'interesse non è dopo il ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'La data di prenotazione non è il ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'La data di prenotazione non è prima del ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'La data di prenotazione non è dopo il ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'La data di elaborazione non è il ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'La data di elaborazione non è prima del ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'La data di elaborazione non è dopo il ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'La data di scadenza non è il ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'La data di scadenza non è prima del ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'La data di scadenza non è dopo il ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'La data di pagamento non è il ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'La data di pagamento non è prima del ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'La data di pagamento non è dopo il ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'La data della fattura non è il ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'La data della fattura non è prima del ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'La data della fattura non è dopo il ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'La transazione non è stata creata il ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'La transazione non è stata creata prima del ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'La transazione non è stata creata dopo il ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'La transazione non è stata aggiornata il ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'La transazione non è stata aggiornata prima del ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'La transazione non è stata aggiornata dopo il ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'L\'importo della transazione non è ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'L\'importo della transazione è maggiore di ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'L\'importo della transazione è inferiore a ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'L\'importo della transazione straniera non è ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'L\'importo della transazione straniera è maggiore di ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'L\'importo della transazione straniera è inferiore a ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'Nessun allegato denominato ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'Nessun nome dell\'allegato contiene ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'Nessun nome dell\'allegato inizia per ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'Nessun nome dell\'allegato termina in ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'Nessuna nota dell\'allegato è ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'Nessuna nota dell\'allegato contiene ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'Nessuna nota dell\'allegato inizia per ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'Nessuna nota dell\'allegato termina per ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'La transazione non è riconciliata',
    'rule_trigger_not_exists'                             => 'La transazione non esiste',
    'rule_trigger_not_has_attachments'                    => 'La transazione non ha allegati',
    'rule_trigger_not_has_any_category'                   => 'La transazione non ha alcuna categoria',
    'rule_trigger_not_has_any_budget'                     => 'La transazione non ha un budget',
    'rule_trigger_not_has_any_bill'                       => 'La transazione non ha pagamenti ricorrenti',
    'rule_trigger_not_has_any_tag'                        => 'La transazione non ha alcun tag',
    'rule_trigger_not_any_notes'                          => 'La transazione non ha alcuna nota',
    'rule_trigger_not_any_external_url'                   => 'La transazione non ha alcun URL esterno',
    'rule_trigger_not_has_no_attachments'                 => 'La transazione ha uno o più allegati',
    'rule_trigger_not_has_no_category'                    => 'La transazione non ha una o più categorie',
    'rule_trigger_not_has_no_budget'                      => 'La transazione ha uno o più budget',
    'rule_trigger_not_has_no_bill'                        => 'La transazione ha un (qualsiasi) pagamento ricorrente',
    'rule_trigger_not_has_no_tag'                         => 'La transazione ha uno o più tag',
    'rule_trigger_not_no_notes'                           => 'La transazione contiene qualsiasi nota',
    'rule_trigger_not_no_external_url'                    => 'La transazione ha un URL esterno',
    'rule_trigger_not_source_is_cash'                     => 'Il conto di origine non è un conto corrente',
    'rule_trigger_not_destination_is_cash'                => 'Il conto di destinazione non è un conto corrente',
    'rule_trigger_not_account_is_cash'                    => 'Nessun conto è un conto corrente',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Il saldo del conto di destinazione è superiore a..',
    'rule_trigger_destination_balance_gte_choice'         => 'Il saldo del conto di destinazione è superiore o uguale a..',
    'rule_trigger_destination_balance_is_choice'          => 'Il saldo del conto di destinazione è esattamente..',
    'rule_trigger_destination_balance_lt_choice'          => 'Il saldo del conto di destinazione è inferiore a..',
    'rule_trigger_destination_balance_lte_choice'         => 'Il saldo del conto di destinazione è inferiore o uguale a..',

    'rule_trigger_source_balance_gt_choice'  => 'Il saldo del conto di origine è superiore a..',
    'rule_trigger_source_balance_gte_choice' => 'Il saldo del conto di origine è maggiore o uguale a..',
    'rule_trigger_source_balance_is_choice'  => 'Il saldo del conto di origine è esattamente..',
    'rule_trigger_source_balance_lt_choice'  => 'Il saldo del conto di origine è inferiore a..',
    'rule_trigger_source_balance_lte_choice' => 'Il saldo del conto di origine è inferiore o uguale a..',

    'rule_trigger_destination_balance_gt'  => 'Il saldo del conto di destinazione è superiore a :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Il saldo del conto di destinazione è superiore o uguale a :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Il saldo del conto di destinazione è esattamente :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Il saldo del conto di destinazione è inferiore a :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Il saldo del conto di destinazione è inferiore o uguale a :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Il saldo del conto di origine è superiore a :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Il saldo del conto di origine è maggiore o uguale a :trigger_value',
    'rule_trigger_source_balance_is'           => 'Il saldo del conto di origine è esattamente :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Il saldo del conto di origine è inferiore a :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Il saldo del conto di origine è inferiore o uguale a :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Il saldo del conto di destinazione è inferiore o uguale a :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Il saldo del conto di destinazione è inferiore a :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Il saldo del conto di destinazione non è :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Il saldo del conto di destinazione è superiore o uguale a :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Il saldo del conto di destinazione è superiore a :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Il saldo del conto di origine è inferiore o uguale a :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Il saldo del conto di origine è inferiore a :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Il saldo del conto di origine non è :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Il saldo del conto di origine è maggiore o uguale a :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Il saldo del conto di origine è superiore a :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'ELIMINA transazione(!)',
    'rule_action_delete_transaction'             => 'ELIMINA transazione(!)',
    'rule_action_set_category'                   => 'Imposta categoria a ":action_value"',
    'rule_action_clear_category'                 => 'Rimuovi dalla categoria',
    'rule_action_set_budget'                     => 'Imposta il budget su ":action_value"',
    'rule_action_clear_budget'                   => 'Rimuovi dal budget',
    'rule_action_add_tag'                        => 'Aggiungi etichetta ":action_value"',
    'rule_action_remove_tag'                     => 'Rimuovi l\'etichetta ":action_value"',
    'rule_action_remove_all_tags'                => 'Rimuovi tutte le etichette',
    'rule_action_set_description'                => 'Imposta la descrizione a ":action_value"',
    'rule_action_append_description'             => 'Aggiungi alla descrizione ":action_value"',
    'rule_action_prepend_description'            => 'Anteponi alla descrizione ":action_value"',
    'rule_action_set_category_choice'            => 'Imposta la categoria a..',
    'rule_action_clear_category_choice'          => 'Rimuovi da tutte le categorie',
    'rule_action_set_budget_choice'              => 'Imposta il budget a..',
    'rule_action_clear_budget_choice'            => 'Rimuovi da tutti i budget',
    'rule_action_add_tag_choice'                 => 'Aggiungi tag..',
    'rule_action_remove_tag_choice'              => 'Rimuovi tag..',
    'rule_action_remove_all_tags_choice'         => 'Rimuovi tutte le etichette',
    'rule_action_set_description_choice'         => 'Imposta la descrizione a..',
    'rule_action_update_piggy_choice'            => 'Aggiungi / rimuovi l\'importo di transazione nel salvadanaio..',
    'rule_action_update_piggy'                   => 'Aggiungi / rimuovi l\'importo di transazione nel salvadanaio.. ":action_value"',
    'rule_action_append_description_choice'      => 'Aggiungi descrizione con..',
    'rule_action_prepend_description_choice'     => 'Anteponi alla descrizione con..',
    'rule_action_set_source_account_choice'      => 'Imposta il conto d\'origine a..',
    'rule_action_set_source_account'             => 'Imposta come conto di origine :action_value',
    'rule_action_set_destination_account_choice' => 'Imposta il conto di destinazione a..',
    'rule_action_set_destination_account'        => 'Imposta come conto di destinazione :action_value',
    'rule_action_append_notes_choice'            => 'Aggiungi alle note con..',
    'rule_action_append_notes'                   => 'Aggiungi alle note ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Anteponi alle note con..',
    'rule_action_prepend_notes'                  => 'Anteponi alle note ":action_value"',
    'rule_action_clear_notes_choice'             => 'Rimuovi tutte le note',
    'rule_action_clear_notes'                    => 'Rimuovi tutte le note',
    'rule_action_set_notes_choice'               => 'Imposta le note a..',
    'rule_action_link_to_bill_choice'            => 'Collega a un pagamento ricorrente..',
    'rule_action_link_to_bill'                   => 'Collega al pagamento ricorrente ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Cambia conti di origine e destinazione (solo trasferimenti)',
    'rule_action_switch_accounts'                => 'Cambia origine e destinazione',
    'rule_action_set_notes'                      => 'Imposta le note su ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Converti la transazione in un deposito',
    'rule_action_convert_deposit'                => 'Converti la transazione in un deposito da ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Converti la transazione in un prelievo',
    'rule_action_convert_withdrawal'             => 'Converti la transazione in un prelievo da ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Converti la transazione in un trasferimento',
    'rule_action_convert_transfer'               => 'Converti la transazione in un trasferimento con ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Aggiungi la descrizione alle note di transazione',
    'rule_action_append_notes_to_descr_choice'   => 'Aggiungi le note di transazione alla descrizione',
    'rule_action_move_descr_to_notes_choice'     => 'Sostituisci le note della transazione corrente con la descrizione',
    'rule_action_move_notes_to_descr_choice'     => 'Sostituisci la descrizione corrente con le note di transazione',
    'rule_action_append_descr_to_notes'          => 'Aggiungi una descrizione alle note',
    'rule_action_append_notes_to_descr'          => 'Aggiungi le note alla descrizione',
    'rule_action_move_descr_to_notes'            => 'Sostituisci le note con la descrizione',
    'rule_action_move_notes_to_descr'            => 'Sostituisci la descrizione con le note',
    'rule_action_set_amount_choice'              => 'Imposta l\'importo a ..',
    'rule_action_set_amount'                     => 'Imposta l\'importo su ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Imposta il conto di destinazione a (corrente)',
    'rule_action_set_source_to_cash_choice'      => 'Imposta il conto di origine a (corrente)',
    'rulegroup_for_bills_title'                  => 'Gruppo di regole per pagamenti ricorrenti',
    'rulegroup_for_bills_description'            => 'Un gruppo di regole speciale per tutte le regole relative ai pagamenti ricorrenti.',
    'rule_for_bill_title'                        => 'Regola generata automaticamente per il pagamento ricorrente ":name"',
    'rule_for_bill_description'                  => 'Questa regola è generata automaticamente per corrispondere al pagamento ricorrente ":name".',
    'create_rule_for_bill'                       => 'Crea una nuova regola per il pagamento ricorrente ":name"',
    'create_rule_for_bill_txt'                   => 'Congratulazioni, hai appena creato un nuovo pagamento ricorrente chiamato ":name"! Firefly III può automagicamente abbinare le nuove uscite a questo pagamento ricorrente. Per esempio, ogni volta che paghi il pagamento ricorrente "affitto" verrà collegata a questa spesa. In questo modo Firefly III può visualizzare con accuratezza quali pagamenti ricorrenti sono in scadenza e quali no. Per far ciò è necessario creare una nuova regola. Firefly III ha inserito al posto tuo alcuni dettagli ragionevoli. Assicurati che questi siano corretti. Se questi valori sono corretti, Firefly III automaticamente collegherà il prelievo giusto al pagamento ricorrente giusto. Controlla che i trigger siano corretti e aggiungine altri se sono sbagliati.',
    'new_rule_for_bill_title'                    => 'Regola per il pagamento ricorrente ":name"',
    'new_rule_for_bill_description'              => 'Questa regola contrassegna le transazioni per il pagamento ricorrente ":name".',

    'new_rule_for_journal_title'                => 'Regola basata sulla transazione ":description"',
    'new_rule_for_journal_description'          => 'Questa regola è basata sulla transazione ":description". Verrà applicata a transazioni uguali.',

    // tags
    'store_new_tag'                             => 'Salva la nuova etichetta',
    'update_tag'                                => 'Aggiorna etichetta',
    'no_location_set'                           => 'Nessuna posizione impostata.',
    'meta_data'                                 => 'Meta dati',
    'location'                                  => 'Posizione',
    'location_first_split'                      => 'La posizione di questa transazione può essere impostata sulla prima suddivisione di questa transazione.',
    'without_date'                              => 'Senza data',
    'result'                                    => 'Risultato',
    'sums_apply_to_range'                       => 'Tutte le somme si applicano all\'intervallo selezionato',
    'mapbox_api_key'                            => 'Per utilizzare la mappa, ottieni una chiave API da <a href="https://www.mapbox.com/">Mapbox</a>. Apri il tuo file <code>.env</code> e inserisci questo codice dopo <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'Clicca con il tasto destro o premi a lungo per impostare la posizione dell\'oggetto.',
    'click_tap_location'                        => 'Fare clic o toccare la mappa per aggiungere una posizione',
    'clear_location'                            => 'Rimuovi dalla posizione',
    'delete_all_selected_tags'                  => 'Elimina tutte le etichette selezionate',
    'select_tags_to_delete'                     => 'Non dimenticare di selezionare qualche etichetta.',
    'deleted_x_tags'                            => 'Eliminata l\'etichetta :count.Eliminate le etichette :count.',
    'create_rule_from_transaction'              => 'Crea una regola basata sulla transazione',
    'create_recurring_from_transaction'         => 'Crea una transazione ricorrente basandosi su una transazione',

    // preferences
    'test_notifications_buttons'                => 'Per testare la configurazione, usa i pulsanti qui sotto. Si prega di notare che i pulsanti non hanno controllo spam.',
    'dark_mode_option_browser'                  => 'Fai decidere al tuo browser',
    'dark_mode_option_light'                    => 'Sempre chiaro',
    'dark_mode_option_dark'                     => 'Sempre scuro',
    'equal_to_language'                         => '(uguale alla lingua)',
    'dark_mode_preference'                      => 'Modalità scura',
    'dark_mode_preference_help'                 => 'Indica a Firefly III quando utilizzare la modalità scura.',
    'pref_home_screen_accounts'                 => 'Conti nella pagina iniziale',
    'pref_home_screen_accounts_help'            => 'Quali conti vuoi che vengano visualizzati nella pagina iniziale?',
    'pref_view_range'                           => 'Intervallo di visualizzazione',
    'pref_view_range_help'                      => 'Alcuni grafici vengono raggruppati automaticamente in periodi. Anche i tuoi budget saranno raggruppati in periodi. Quale periodo preferisci?',
    'pref_1D'                                   => 'Un giorno',
    'pref_1W'                                   => 'Una settimana',
    'pref_1M'                                   => 'Un mese',
    'pref_3M'                                   => 'Tre mesi (trimestre)',
    'pref_6M'                                   => 'Sei mesi',
    'pref_1Y'                                   => 'Un anno',
    'pref_last365'                              => 'Anno scorso',
    'pref_last90'                               => 'Ultimi 90 giorni',
    'pref_last30'                               => 'Ultimi 30 giorni',
    'pref_last7'                                => 'Ultimi 7 giorni',
    'pref_YTD'                                  => 'Ultimo anno',
    'pref_QTD'                                  => 'Ultimo trimestre',
    'pref_MTD'                                  => 'Ultimo mese',
    'pref_languages'                            => 'Lingue',
    'pref_locale'                               => 'Impostazioni regionali',
    'pref_languages_help'                       => 'Firefly III supporta diverse lingue. Quale di queste preferisci?',
    'pref_locale_help'                          => 'Firefly III ti permette di impostare altre impostazioni regionali, come la formattazione delle valute, dei numeri e delle date. Le voci in questa lista potrebbero non essere supportate dal tuo sistema. Firefly III non ha le corrette impostazioni di data per ogni regione; contattami per ulteriori miglioramenti.',
    'pref_locale_no_demo'                       => 'Questa funzionalità non è disponibile per l\'utente demo.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Impostazioni anno fiscale',
    'pref_custom_fiscal_year_label'             => 'Abilita',
    'pref_custom_fiscal_year_help'              => 'Nei paesi che utilizzano un anno finanziario che non va dal 1 gennaio al 31 dicembre, è possibile attivare questa opzione e specificare i giorni di inizio / fine dell\'anno fiscale',
    'pref_fiscal_year_start_label'              => 'Data di inizio anno fiscale',
    'pref_two_factor_auth'                      => 'Autenticazione a più fattori',
    'pref_two_factor_auth_help'                 => 'Quando abiliti l\'autenticazione a più fattori (nota anche come autenticazione a due fattori), aggiungi un ulteriore livello di sicurezza al tuo account. Accedi con qualcosa che conosci (la tua password) e qualcosa che hai (un codice di verifica). I codici di verifica sono generati da un\'applicazione sul telefono, come Authy o Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Abilita l\'autenticazione a più fattori',
    'pref_two_factor_auth_disabled'             => 'Codice di verifica dell\'autenticazione a più fattori rimosso e disabilitato',
    'pref_two_factor_auth_remove_it'            => 'Non dimenticare di rimuovere l\'account dalla tua app di autenticazione!',
    'pref_two_factor_auth_code'                 => 'Verificare il codice',
    'pref_two_factor_auth_code_help'            => 'Scansiona il codice QR con un\'applicazione sul tuo telefono come Authy o Google Authenticator e inserisci il codice generato. Il codice QR cambia ogni volta che visiti questa pagina. Assicurati di utilizzare quello più recente.',
    'pref_two_factor_auth_reset_code'           => 'Reimposta il codice di verifica',
    'pref_two_factor_auth_disable_2fa'          => 'Disattiva MFA',
    '2fa_use_secret_instead'                    => 'Se non puoi scansionare il codice QR, sentiti libero di utilizzare al suo posto il segreto: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Salva questi codici di recupero per accedere nel caso perdessi il tuo dispositivo.',
    '2fa_already_enabled'                       => 'La verifica dell\'autenticazione a più fattori è già abilitata.',
    'wrong_mfa_code'                            => 'Questo codice MFA non è valido.',
    'pref_save_settings'                        => 'Salva le impostazioni',
    'saved_preferences'                         => 'Preferenze salvate!',
    'preferences_general'                       => 'Generale',
    'preferences_frontpage'                     => 'Pagina iniziale',
    'preferences_security'                      => 'Sicurezza',
    'preferences_layout'                        => 'Impaginazione',
    'preferences_notifications'                 => 'Notifiche',
    'pref_home_show_deposits'                   => 'Mostra i depositi nella pagina iniziale',
    'pref_home_show_deposits_info'              => 'La pagina iniziale mostra già i tuoi conti spese. Vuoi che mostri anche i tuoi conti entrate?',
    'pref_home_do_show_deposits'                => 'Sì, mostrali',
    'successful_count'                          => 'di cui :count con successo',
    'list_page_size_title'                      => 'Dimensioni pagina',
    'list_page_size_help'                       => 'Ogni elenco (di conti, di transazioni, ecc) mostra al massimo questo numero di elementi per pagina.',
    'list_page_size_label'                      => 'Dimensioni pagina',
    'between_dates'                             => '(:start e :end)',
    'pref_optional_fields_transaction'          => 'Campi opzionali per le transazioni',
    'pref_optional_fields_transaction_help'     => 'Come impostazione predefinita, non tutti i campi sono abilitati quando si crea una nuova transazione (per evitare confusione). Di seguito, puoi abilitare questi campi se ritieni che possano esserti utili. Ovviamente, qualsiasi campo che è disabilitato, ma già compilato, sarà visibile indipendentemente dall\'impostazione.',
    'optional_tj_date_fields'                   => 'Campi data',
    'optional_tj_other_fields'                  => 'Altri campi',
    'optional_tj_attachment_fields'             => 'Campi allegati',
    'pref_optional_tj_interest_date'            => 'Data di valuta',
    'pref_optional_tj_book_date'                => 'Data contabile',
    'pref_optional_tj_process_date'             => 'Data elaborazione',
    'pref_optional_tj_due_date'                 => 'Data scadenza',
    'pref_optional_tj_payment_date'             => 'Data pagamento',
    'pref_optional_tj_invoice_date'             => 'Data fatturazione',
    'pref_optional_tj_internal_reference'       => 'Riferimento interno',
    'pref_optional_tj_notes'                    => 'Note',
    'pref_optional_tj_attachments'              => 'Allegati',
    'pref_optional_tj_external_url'             => 'URL esterno',
    'pref_optional_tj_location'                 => 'Posizione',
    'pref_optional_tj_links'                    => 'Collegamenti della transazione',
    'optional_field_meta_dates'                 => 'Dati',
    'optional_field_meta_business'              => 'Attività commerciale',
    'optional_field_attachments'                => 'Allegati',
    'optional_field_meta_data'                  => 'Metadati opzionali',
    'external_url'                              => 'URL esterno',
    'pref_notification_login_failure'           => 'Errore di login',
    'pref_notification_bill_reminder'           => 'Promemoria sui pagamenti ricorrenti in scadenza',
    'pref_notification_new_access_token'        => 'Avvisa quando viene creato un nuovo token d\'accesso dell\'API',
    'pref_notification_transaction_creation'    => 'Avvisa quando viene creata automaticamente una transazione',
    'pref_notification_user_login'              => 'Avvisa quando accedi da una nuova posizione',
    'pref_notification_rule_action_failures'    => 'Avvisa quando le azioni della regola non riescono a essere eseguite (non tramite email)',
    'pref_notification_new_password'            => 'La tua password è cambiata',
    'pref_notification_enabled_mfa'             => 'L\'autenticazione a più fattori è abilitata',
    'pref_notification_disabled_mfa'            => 'L\'autenticazione a più fattori è disabilitata',
    'pref_notification_few_left_mfa'            => 'Hai solo alcuni codici di backup rimanenti',
    'pref_notification_no_left_mfa'             => 'Non hai più codici di backup rimanenti',
    'pref_notification_many_failed_mfa'         => 'Il controllo di autenticazione a più fattori continua a fallire',
    'pref_notification_new_backup_codes'        => 'Nuovi codici di backup sono stati generati',
    'pref_notifications'                        => 'Notifiche',
    'pref_notifications_help'                   => 'Indica se queste sono delle notifiche che vorresti ricevere. Alcune notifiche potrebbero contenere informazioni finanziarie sensibili.',
    'pref_notifications_settings'               => 'Impostazioni notifiche',
    'pref_notifications_settings_help'          => 'Usa queste impostazioni per configurare i canali di notifica. Nota che le notifiche saranno inviate a TUTTI i canali. Per favore salva le impostazioni PRIMA.',
    'slack_url_label'                           => 'URL del "webhook in entrata" di Slack',
    'discord_url_label'                         => 'URL webhook Discord',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Tassi di cambio',
    'header_exchange_rates'                     => 'Tassi di cambio',
    'exchange_rates_intro'                      => 'Firefly III supporta il download e l\'utilizzo dei tassi di cambio. Per saperne di più, consulta <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">la documentazione</a>.',
    'exchange_rates_from_to'                    => 'Tra {from} e {to} (e viceversa)',
    'header_exchange_rates_rates'               => 'Tassi di cambio',
    'exchange_rates_intro_rates'                => 'Firefly III utilizza i seguenti tassi di cambio. L\'inverso viene calcolato automaticamente quando non è fornito. Se non esiste un tasso di cambio per la data della transazione, Firefly III tornerà indietro nel tempo per trovarne uno. Se nessuno è presente, verrà utilizzato il tasso "1".',
    'header_exchange_rates_table'               => 'Tabella con i tassi di cambio',
    'help_rate_form'                            => 'In questo giorno, quanti {to} otterrai per un {from}?',
    'save_new_rate'                             => 'Salva nuovo tasso',
    'add_new_rate'                              => 'Aggiungi un nuovo tasso di cambio',
    'not_enough_currencies'                     => 'Valute non sufficienti',
    'not_enough_currencies_enabled'             => 'Se hai solo una valuta abilitata, non c\'è bisogno di aggiungere tassi di cambio.',

    // Financial administrations
    'administration_index'                      => 'Amministrazione finanziaria',
    'administrations_breadcrumb'                => 'Amministrazioni finanziarie',
    'administrations_page_title'                => 'Amministrazioni finanziarie',
    'administrations_index_menu'                => 'Amministrazioni finanziarie',
    'administrations_page_sub_title'            => 'Panoramica',
    'create_administration'                     => 'Crea nuova amministrazione',
    'administration_owner'                      => 'Titolare dell\'amministrazione: {{email}}',
    'administration_you'                        => 'Il tuo ruolo: {{role}}',
    'other_users_in_admin'                      => 'Altri utenti in questa amministrazione',
    'administrations_create_breadcrumb'         => 'Crea nuova amministrazione finanziaria',
    'administrations_page_create_sub_title'     => 'Crea nuova amministrazione finanziaria',
    'basic_administration_information'          => 'Informazioni di base sull\'amministrazione',
    'new_administration_created'                => 'La nuova amministrazione finanziaria "{{title}}" è stata creata',
    'edit_administration_breadcrumb'            => 'Modifica amministrazione finanziaria ":title"',
    'administrations_page_edit_sub_title'       => 'Modifica amministrazione finanziaria ":title"',
    'administrations_page_edit_sub_title_js'    => 'Modifica amministrazione finanziaria "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'L\'amministrazione ":title" è stata aggiornata',
    'flash_administration_created'              => 'L\'amministrazione ":title" è stata creata',
    'flash_administration_deleted'              => 'L\'amministrazione ":title" è stata eliminata',

    // roles
    'administration_role_owner'                 => 'Proprietario',
    'administration_role_ro'                    => 'Sola lettura',
    'administration_role_mng_trx'               => 'Gestisci transazioni',
    'administration_role_mng_meta'              => 'Gestisci classificazione e meta-dati',
    'administration_role_mng_budgets'           => 'Gestisci budget',
    'administration_role_mng_piggies'           => 'Gestisci salvadanai',
    'administration_role_mng_subscriptions'     => 'Gestisci pagamenti ricorrenti',
    'administration_role_mng_rules'             => 'Gestisci regole',
    'administration_role_mng_recurring'         => 'Gestisci transazioni ricorrenti',
    'administration_role_mng_webhooks'          => 'Gestisci webhook',
    'administration_role_mng_currencies'        => 'Gestisci valute',
    'administration_role_view_reports'          => 'Visualizza report',
    'administration_role_full'                  => 'Accesso completo',

    // mfa
    'enable_mfa'                                => 'Abilita l\'autenticazione a più fattori',
    'mfa_index_title'                           => 'Autenticazione a più fattori',
    'mfa_index_intro'                           => 'Firefly III supporta l\'autenticazione a più fattori (MFA). Puoi abilitare MFA per il tuo account per aggiungere un ulteriore livello di sicurezza. Applicazioni come Authy, Google Authenticator e FreeOTP possono essere utilizzate per generare i codici necessari per effettuare il login. Le chiavi di sicurezza non sono supportate da Firefly III, ma è possibile utilizzare una chiave di sicurezza come dispositivo di archiviazione per la chiave segreta MFA.',
    'mfa_index_enabled'                         => 'L\'autenticazione a più fattori è abilitata per il tuo account.',
    'mfa_index_disabled'                        => 'L\'autenticazione a più fattori non è abilitata per il tuo account.',
    'mfa_index_owner'                           => 'Il proprietario di questa istanza sarà sempre in grado di disabilitare l\'autenticazione a più fattori per il tuo account.',
    'current_password_confirm_mfa'              => 'Inserisci la tua password attuale',
    'mfa_warning_code_changes'                  => 'Dopo aver inserito la password e il codice MFA, potresti visualizzare una finestra di dialogo MFA. In questo caso, attendi che la tua applicazione generi un nuovo codice MFA, e non riciclare quello appena utilizzato.',
    'mfa_already_disabled'                      => 'L\'autenticazione a più fattori non è abilitata, quindi non puoi disabilitarla.',
    'disable_mfa_page'                          => 'Disabilita autenticazione a più fattori',
    'disable_mfa_intro'                         => 'Puoi disabilitare l\'autenticazione a più fattori. Per farlo, inserisci la tua password e un codice di autenticazione a più fattori. Se invece vuoi disabilitare l\'autenticazione a più fattori perché hai perso l\'accesso al tuo generatore di codice, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">fai riferimento alla documentazione</a>.',
    'pref_disable_mfa'                          => 'Disabilita autenticazione a più fattori',
    'mfa_not_enabled'                           => 'L\'autenticazione a più fattori non è abilitata.',
    'mfa_backup_codes_intro'                    => 'Firefly III può generare codici di backup per te. Questi codici possono essere utilizzati per accedere quando non è possibile utilizzare il generatore di codici. È possibile generare un nuovo set di codici in qualsiasi momento. Se si genera un nuovo set, il vecchio set sarà invalidato.',
    'mfa_backup_codes_quick'                    => 'Se stai arrivando molto velocemente dalla pagina di configurazione di autenticazione a più fattori, la tua app potrebbe non aver ancora generato un nuovo codice. Tieni presente che i codici MFA possono essere utilizzati solo una volta. Assicurati di utilizzare un codice diverso da quello precedente.',
    'mfa_backup_codes_title'                    => 'Codici di backup per autenticazione a più fattori',
    'mfa_backup_codes_post_title'               => 'Codici di backup per autenticazione a più fattori',

    // profile:
    'manage_mfa_settings'                       => 'Gestisci le impostazioni dell\'autenticazione a più fattori',
    'purge_data_title'                          => 'Elimina i dati da Firefly III',
    'purge_data_expl'                           => '"Purge" significa "eliminare ciò che è già stato eliminato". In normali circostanze, Firefly III non elimina nulla permanentemente. Semplicemente, lo nasconde. Il seguente pulsante elimina tutti i registri "eliminati" in precedenza, PER SEMPRE.',
    'delete_stuff_header'                       => 'Elimina definitivamente i dati',
    'purge_all_data'                            => 'Elimina tutti i registri eliminati',
    'purge_data'                                => 'Elimina dati',
    'purged_all_records'                        => 'Tutti i registri eliminati sono stati eliminati del tutto.',
    'delete_data_title'                         => 'Elimina i dati da Firefly III',
    'permanent_delete_stuff'                    => 'Puoi eliminare cose da Firefly III. Utilizzare i seguenti pulsanti preclude che tutti i tuoi elementi saranno rimossi dalla vista e nascosti. Non esiste alcun pulsante di annullamento, ma gli elementi resteranno visibili nel database, da cui potrai recuperarli, se necessario.',
    'other_sessions_logged_out'                 => 'Sei stato disconnesso da tutte le altre sessioni.',
    'delete_unused_accounts'                    => 'Eliminare i conti inutilizzati, pulirà i tuoi elenchi di completamento automatico.',
    'delete_all_unused_accounts'                => 'Elimina i conti inutilizzati',
    'deleted_all_unused_accounts'               => 'Tutti i conti inutilizzati sono eliminati',
    'delete_all_budgets'                        => 'Elimina TUTTI i budget',
    'delete_all_categories'                     => 'Elimina TUTTE le categorie',
    'delete_all_tags'                           => 'Elimina TUTTE le etichette',
    'delete_all_bills'                          => 'Elimina TUTTI i tuoi pagamenti ricorrenti',
    'delete_all_piggy_banks'                    => 'Elimina TUTTI i salvadanai',
    'delete_all_rules'                          => 'Elimina TUTTE le regole',
    'delete_all_recurring'                      => 'Elimina TUTTE le transazioni ricorrenti',
    'delete_all_object_groups'                  => 'Elimina TUTTI i gruppi di oggetti',
    'delete_all_accounts'                       => 'Elimina TUTTI gli account',
    'delete_all_asset_accounts'                 => 'Elimina TUTTI i conti attività',
    'delete_all_expense_accounts'               => 'Elimina TUTTI i conti spese',
    'delete_all_revenue_accounts'               => 'Elimina TUTTI i conti entrate',
    'delete_all_liabilities'                    => 'Elimina TUTTE le passività',
    'delete_all_transactions'                   => 'Elimina TUTTE le transazioni',
    'delete_all_withdrawals'                    => 'Elimina TUTTI i prelievi',
    'delete_all_deposits'                       => 'Elimina TUTTI i depositi',
    'delete_all_transfers'                      => 'Elimina TUTTI i trasferimenti',
    'also_delete_transactions'                  => 'L\'eliminazione dei conti cancellerà anche TUTTI i prelievi, i depositi e i trasferimenti associati!',
    'deleted_all_budgets'                       => 'Tutti i budget sono stati eliminati',
    'deleted_all_categories'                    => 'Tutte le categorie sono state eliminate',
    'deleted_all_tags'                          => 'Tutte le etichette sono state eliminate',
    'deleted_all_bills'                         => 'Tutti i pagamenti ricorrenti sono stati eliminati',
    'deleted_all_piggy_banks'                   => 'Tutti i salvadanai sono stati eliminati',
    'deleted_all_rules'                         => 'Tutte le regole e i gruppi di regole sono stati eliminati',
    'deleted_all_object_groups'                 => 'Tutti i gruppi sono stati eliminati',
    'deleted_all_accounts'                      => 'Tutti i conti sono stati eliminati',
    'deleted_all_asset_accounts'                => 'Tutti i conti attività sono stati eliminati',
    'deleted_all_expense_accounts'              => 'Tutti i conti spese sono stati eliminati',
    'deleted_all_revenue_accounts'              => 'Tutti i conti entrate sono stati eliminati',
    'deleted_all_liabilities'                   => 'Tutte le passività sono state eliminate',
    'deleted_all_transactions'                  => 'Tutte le transazioni sono state eliminate',
    'deleted_all_withdrawals'                   => 'Tutti i prelievi sono stati eliminati',
    'deleted_all_deposits'                      => 'Tutti i depositi sono stati eliminati',
    'deleted_all_transfers'                     => 'Tutti i trasferimenti sono stati eliminati',
    'deleted_all_recurring'                     => 'Tutte le transazioni ricorrenti sono state eliminate',
    'change_your_password'                      => 'Cambia la tua password',
    'delete_account'                            => 'Elimina account',
    'current_password'                          => 'Password corrente',
    'new_password'                              => 'Nuova password',
    'new_password_again'                        => 'Nuova password (ripeti)',
    'delete_your_account'                       => 'Elimina il tuo account',
    'delete_your_account_help'                  => 'L\'eliminazione del tuo account eliminerà anche conti, transazioni, <em>qualsiasi cosa</em> che potresti aver salvato in Firefly III. Sarà tutto PERDUTO.',
    'delete_your_account_password'              => 'Inserisci la tua password per continuare.',
    'password'                                  => 'Password',
    'are_you_sure'                              => 'Sei sicuro? Non puoi annullare questo.',
    'are_you_sure_confirm'                      => 'Sei sicuro/a?',
    'delete_account_button'                     => 'ELIMINA il tuo account',
    'invalid_current_password'                  => 'Password attuale non valida!',
    'password_changed'                          => 'Password cambiata!',
    'should_change'                             => 'L\'idea è di cambiare la tua password.',
    'invalid_password'                          => 'Password non valida!',
    'what_is_pw_security'                       => 'Che cos\'è "verifica la sicurezza della password"?',
    'secure_pw_title'                           => 'Come scegliere una password sicura',
    'forgot_password_response'                  => 'Grazie. Se esiste un account con questo indirizzo email, troverai le istruzioni nella tua casella di posta.',
    'secure_pw_history'                         => 'Non passa una settimana senza leggere una notizia di un sito che perde le password dei suoi utenti. Gli hacker e i ladri usano queste password per cercare di rubare le tue informazioni personali. Queste informazioni sono preziose.',
    'secure_pw_ff'                              => 'Utilizzi la stessa password ovunque in Internet? Se un sito perde la tua password, gli hacker hanno accesso a tutti i tuoi dati. Firefly III si affida a te nello scegliere una password robusta e unica per proteggere le tue informazioni finanziarie.',
    'secure_pw_check_box'                       => 'Per aiutarti a fare ciò, Firefly III può controllare se la password che vuoi utilizzare è stata rubata in passato. In un caso del genere, Firefly III ti consiglia di NON utilizzare quella password.',
    'secure_pw_working_title'                   => 'Come funziona?',
    'secure_pw_working'                         => 'Selezionando la casella, Firefly III invierà i primi cinque caratteri dell\'hash SHA1 della tua password al<a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">sito web di Troy Hunt</a> per vedere se è presente nell\'elenco. Questo ti impedirà di usare password non sicure come raccomandato nell\'ultima <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">pubblicazione speciale NIST</a> su questo argomento.',
    'secure_pw_should'                          => 'Devo controllare la scatola?',
    'secure_pw_long_password'                   => 'Sì. Verifica sempre che la tua password sia sicura.',
    'command_line_token'                        => 'Token della riga di comando',
    'explain_command_line_token'                => 'È necessario questo token per eseguire le opzioni dalla riga di comando, come l\'esportazione di dati. Senza di esso tale comando sensibile non funzionerà. Non condividere il token della riga di comando. Nessuno ti chiederà questo token, nemmeno io. Se temi di averlo perso, o se sei paranoico, rigenera questo token usando il pulsante.',
    'regenerate_command_line_token'             => 'Rigenera il token della riga di comando',
    'token_regenerated'                         => 'È stato generato un nuovo token della riga di comando',
    'change_your_email'                         => 'Cambia il tuo indirizzo email',
    'email_verification'                        => 'Un messaggio di posta elettronica verrà inviato al vecchio E al nuovo indirizzo email. Per motivi di sicurezza, non potrai accedere fino a quando non avrai verificato il tuo nuovo indirizzo email. Se non si è sicuri che l\'installazione di Firefly III sia in grado di inviare e-mail, si prega di non utilizzare questa funzione. Se sei un amministratore, puoi verificarlo nelle <a href="settings">impostazioni</a>.',
    'email_changed_logout'                      => 'Fino a quando non verifichi il tuo indirizzo email, non puoi effettuare il login.',
    'login_with_new_email'                      => 'Ora puoi accedere con il tuo nuovo indirizzo email.',
    'login_with_old_email'                      => 'Ora puoi accedere nuovamente con il tuo vecchio indirizzo email.',
    'login_provider_local_only'                 => 'Questa azione non è disponibile quando ci si è autenticati con ":login_provider".',
    'external_user_mgt_disabled'                => 'Questa azione non è disponibile quando Firefly III non è responsabile della gestione utente o dell\'autenticazione.',
    'external_auth_disabled'                    => 'Questa azione non è disponibile quando Firefly III non è responsabile dell\'autenticazione.',
    'delete_local_info_only'                    => "Poiché Firefly III non è responsabile della gestione utente o dell'autenticazione, questa funzione eliminerà solo le informazioni locali di Firefly III.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'Client OAuth',
    'profile_oauth_no_clients'                  => 'Non hai creato nessun client OAuth.',
    'profile_oauth_clients_external_auth'       => 'Se stai utilizzando un fornitore di autenticazione esterno come Authelia, i client di OAuth non funzioneranno. Puoi utilizzare soltanto i Token d\'Accesso Personale.',
    'profile_oauth_clients_header'              => 'Client',
    'profile_oauth_client_id'                   => 'ID client',
    'profile_oauth_client_name'                 => 'Nome',
    'profile_oauth_client_secret'               => 'Segreto',
    'profile_oauth_create_new_client'           => 'Crea nuovo client',
    'profile_oauth_create_client'               => 'Crea client',
    'profile_oauth_edit_client'                 => 'Modifica client',
    'profile_oauth_name_help'                   => 'Qualcosa di cui i tuoi utenti potranno riconoscere e fidarsi.',
    'profile_oauth_redirect_url'                => 'URL di reindirizzamento',
    'profile_oauth_redirect_url_help'           => 'L\'URL di callback dell\'autorizzazione della tua applicazione.',
    'profile_authorized_apps'                   => 'Applicazioni autorizzate',
    'profile_authorized_clients'                => 'Client autorizzati',
    'profile_scopes'                            => 'Ambiti',
    'profile_revoke'                            => 'Revoca',
    'profile_oauth_client_secret_title'         => 'Segreto del client',
    'profile_oauth_client_secret_expl'          => 'Ecco il segreto del nuovo client. Questa è l\'unica occasione in cui viene mostrato pertanto non perderlo! Ora puoi usare questo segreto per effettuare delle richieste alle API.',
    'profile_personal_access_tokens'            => 'Token di acceso personale',
    'profile_personal_access_token'             => 'Token di acceso personale',
    'profile_oauth_confidential'                => 'Riservato',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Ecco il tuo nuovo token di accesso personale. Questa è l\'unica volta che ti viene mostrato per cui non perderlo! Da adesso puoi utilizzare questo token per effettuare delle richieste API.',
    'profile_no_personal_access_token'          => 'Non hai creato alcun token di accesso personale.',
    'profile_create_new_token'                  => 'Crea nuovo token',
    'profile_create_token'                      => 'Crea token',
    'profile_create'                            => 'Crea',
    'profile_save_changes'                      => 'Salva modifiche',
    'profile_whoops'                            => 'Oops!',
    'profile_something_wrong'                   => 'Qualcosa non ha funzionato!',
    'profile_try_again'                         => 'Qualcosa non ha funzionato. Riprova.',
    'amounts'                                   => 'Importi',
    'multi_account_warning_unknown'             => 'A seconda del tipo di transazione che hai creato, il conto di origine e/o destinazione delle successive suddivisioni può essere sovrascritto da qualsiasi cosa sia definita nella prima suddivisione della transazione.',
    'multi_account_warning_withdrawal'          => 'Ricorda che il conto di origine delle successive suddivisioni verrà sovrascritto da quello definito nella prima suddivisione del prelievo.',
    'multi_account_warning_deposit'             => 'Ricorda che il conto di destinazione delle successive suddivisioni verrà sovrascritto da quello definito nella prima suddivisione del deposito.',
    'multi_account_warning_transfer'            => 'Ricorda che il conto di origine e il conto di destinazione delle successive suddivisioni verranno sovrascritti da quelli definiti nella prima suddivisione del trasferimento.',


    // export data:
    'export_data_title'                         => 'Esporta dati da Firefly III',
    'export_data_menu'                          => 'Esporta dati',
    'export_data_bc'                            => 'Esporta dati da Firefly III',
    'export_data_main_title'                    => 'Esporta dati da Firefly III',
    'export_data_expl'                          => 'Questo link ti consente di esportare tutte le transazioni e i meta dati da Firefly III. Fai riferimento alla guida (icona (?) in alto a destra) per ulteriori informazioni sul processo.',
    'export_data_all_transactions'              => 'Esporta tutte le transazioni',
    'export_data_advanced_expl'                 => 'Se hai bisogno di un tipo più avanzato o specifico di esportazione, leggi la guida su come usare il comando da terminale <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Un allegato|:count allegati',
    'attachments'                               => 'Allegati',
    'edit_attachment'                           => 'Modifica allegato ":name"',
    'update_attachment'                         => 'Aggiorna allegati',
    'delete_attachment'                         => 'Elimina allegato ":name"',
    'attachment_deleted'                        => 'Allegato eliminato ":name"',
    'liabilities_deleted'                       => 'Passività ":name" eliminata',
    'attachment_updated'                        => 'Allegato ":name" aggiornato',
    'upload_max_file_size'                      => 'Dimensione massima del file: :size',
    'list_all_attachments'                      => 'Lista di tutti gli allegati',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Poiché questa transazione è riconciliata, non potrai aggiornare i conti, né l\'importo o gli importi a meno che non venga rimosso il contrassegno di riconciliazione.',
    'is_reconciled'                             => 'È riconciliata',
    'title_expenses'                            => 'Spese',
    'title_withdrawal'                          => 'Spese',
    'title_revenue'                             => 'Entrate',
    'title_deposit'                             => 'Redditi / entrate',
    'title_transfer'                            => 'Trasferimenti',
    'title_transfers'                           => 'Trasferimenti',
    'submission_options'                        => 'Opzioni di invio',
    'apply_rules_checkbox'                      => 'Applica le regole',
    'fire_webhooks_checkbox'                    => 'Esegui webhook',
    'select_source_account'                     => 'Si prega di selezionare o digitare un conto di origine valido',
    'select_dest_account'                       => 'Si prega di selezionare o digitare un conto di destinazione valido',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Questa transazione è già un\'uscita',
    'convert_is_already_type_Deposit'           => 'Questa transazione è già un\'entrata',
    'convert_is_already_type_Transfer'          => 'Questa transazione è già un trasferimento',
    'convert_to_Withdrawal'                     => 'Converti ":description" in un\'uscita',
    'convert_to_Deposit'                        => 'Converti ":description" in un\'entrata',
    'convert_to_Transfer'                       => 'Converti ":description" in un trasferimento',
    'convert_options_WithdrawalDeposit'         => 'Converti un\'uscita in un\'entrata',
    'convert_options_WithdrawalTransfer'        => 'Converti un\'uscita in un trasferimento',
    'convert_options_DepositTransfer'           => 'Converti un\'entrata in un trasferimento',
    'convert_options_DepositWithdrawal'         => 'Converti un\'entrata in un\'uscita',
    'convert_options_TransferWithdrawal'        => 'Converti un trasferimento in un\'uscita',
    'convert_options_TransferDeposit'           => 'Converti un trasferimento in un\'entrata',
    'convert_Withdrawal_to_deposit'             => 'Converti questa uscita in un\'entrata',
    'convert_Withdrawal_to_transfer'            => 'Converti questa uscita in un trasferimento',
    'convert_Deposit_to_withdrawal'             => 'Converti questa entrata in un\'uscita',
    'convert_Deposit_to_transfer'               => 'Converti questa entrata in un trasferimento',
    'convert_Transfer_to_deposit'               => 'Converti questo trasferimento in un\'entrata',
    'convert_Transfer_to_withdrawal'            => 'Converti questo trasferimento in un\'uscita',
    'convert_please_set_revenue_source'         => 'Si prega di scegliere il conto delle entrate da dove verranno i soldi.',
    'convert_please_set_asset_destination'      => 'Scegli il conto attività in cui andranno i soldi.',
    'convert_please_set_expense_destination'    => 'Si prega di scegliere il conto spese dove andranno i soldi.',
    'convert_please_set_asset_source'           => 'Scegli il conto attività da cui verranno i soldi.',
    'convert_expl_w_d'                          => 'Quando si converte da un prelievo a un deposito, il denaro verrà depositato nel conto di destinazione visualizzato, invece di essere ritirato da esso.|Quando si converte da un prelievo a un deposito, il denaro verrà depositato nei conti di destinazione visualizzati, invece di essere ritirato da essi.',
    'convert_expl_w_t'                          => 'Quando si converte un prelievo in un trasferimento, il denaro sarà trasferito dal conto di origine in un altro conto attività o passività invece di essere speso sul conto di spesa originale.|Quando si converte un prelievo in un trasferimento, il denaro sarà trasferito dai conti di origine in altri conti attività o passività invece di essere speso nei conti di spesa originali.',
    'convert_expl_d_w'                          => 'Quando si converte un deposito in un prelievo, il denaro sarà prelevato dal conto di origine visualizzato, invece di essere depositato in esso.|Quando si converte un deposito in un prelievo, il denaro sarà prelevato dai conti di origine visualizzati, invece di essere depositato in essi. Per completare la conversione, selezionare i nuovi conti di destinazione. Per completare la conversione, selezionare i nuovi conti destinazione.',
    'convert_expl_d_t'                          => 'Quando si converte un deposito in un trasferimento, il denaro verrà depositato sul conto di destinazione elencato da uno qualsiasi del tuo conto attività o passività.|Quando si converte un deposito in un trasferimento, il denaro verrà depositato nei conti di destinazione elencati da uno qualsiasi dei tuoi conti attività o passività.',
    'convert_expl_t_w'                          => 'Quando si converte un trasferimento in un prelievo, il denaro sarà speso sul conto di destinazione impostato qui, invece di essere trasferito da esso.|Quando si converte un trasferimento in un prelievo, il denaro sarà speso per i conti di destinazione che si imposta qui, invece di essere trasferito da essi.',
    'convert_expl_t_d'                          => 'Quando si converte un trasferimento in un deposito, il denaro verrà depositato nel conto di destinazione che vedi qui, invece di essere trasferito in esso.|Quando si converte un trasferimento in un deposito, il denaro verrà depositato nei conti di destinazione che vedi qui, invece di essere trasferito in loro.',
    'convert_select_sources'                    => 'Per completare la conversione, imposta il nuovo conto di origine qui sotto.|Per completare la conversione, imposta i nuovi conti di origine qui sotto.',
    'convert_select_destinations'               => 'Per completare la conversione, selezionare il nuovo conto di destinazione qui sotto.|Per completare la conversione, selezionare i nuovi conti di destinazione qui sotto.',
    'converted_to_Withdrawal'                   => 'La transazione è stata convertita in un\'uscita',
    'converted_to_Deposit'                      => 'La transazione è stata convertita in un\'entrata',
    'converted_to_Transfer'                     => 'La transazione è stata convertita in un trasferimento',
    'invalid_convert_selection'                 => 'Il conto che hai selezionato è già utilizzato in questa transazione o non esiste.',
    'source_or_dest_invalid'                    => 'Impossibile trovare i dettagli corretti della transazione. Non è possibile effettuare la conversione.',
    'convert_to_withdrawal'                     => 'Converti in prelievo',
    'convert_to_deposit'                        => 'Converti in entrata',
    'convert_to_transfer'                       => 'Converti in trasferimento',

    // create new stuff:
    'create_new_withdrawal'                     => 'Crea una nuova uscita',
    'create_new_deposit'                        => 'Crea una nuova entrata',
    'create_new_transfer'                       => 'Crea un nuovo trasferimento',
    'create_new_asset'                          => 'Crea un nuovo conto attività',
    'create_new_liabilities'                    => 'Crea nuova passività',
    'create_new_expense'                        => 'Crea un nuovo conto di spesa',
    'create_new_revenue'                        => 'Crea un nuovo conto entrate',
    'create_new_piggy_bank'                     => 'Crea un nuovo salvadanaio',
    'create_new_bill'                           => 'Crea un nuovo pagamento ricorrente',
    'create_new_subscription'                   => 'Crea un nuovo pagamento ricorrente',
    'create_new_rule'                           => 'Crea nuova regola',

    // currencies:
    'create_currency'                           => 'Crea una nuova valuta',
    'store_currency'                            => 'Salva nuova valuta',
    'update_currency'                           => 'Aggiorna valuta',
    'new_default_currency'                      => '":name" è ora la valuta predefinita.',
    'default_currency_failed'                   => 'Impossibile rendere ":name" la valuta predefinita. Ti preghiamo di consultare i registri.',
    'cannot_delete_currency'                    => 'Impossibile eliminare :name perché è ancora in uso.',
    'cannot_delete_fallback_currency'           => ':name è la valuta di default del sistema e non può essere eliminata.',
    'cannot_disable_currency_journals'          => 'Non è possibile disabilitare :name perché ci sono ancora transazioni che la utilizzano.',
    'cannot_disable_currency_last_left'         => 'Non è possibile disabilitare :name perché è l\'ultima valuta abilitata.',
    'cannot_disable_currency_account_meta'      => 'Non è possibile disabilitare :name perché è utilizzata in conti attività.',
    'cannot_disable_currency_bills'             => 'Non è possibile disabilitare :name perché è utilizzata nei pagamenti ricorrenti.',
    'cannot_disable_currency_recurring'         => 'Non è possibile disabilitare :name perché è utilizzata in transazioni ricorrenti.',
    'cannot_disable_currency_available_budgets' => 'Non è possibile disabilitare :name perché è disponibile nei budget disponibili.',
    'cannot_disable_currency_budget_limits'     => 'Non è possibile disabilitare :name perché è utilizzata nei limiti dei budget.',
    'cannot_disable_currency_current_default'   => 'Non è possibile disabilitare :name perché è la valuta predefinita corrente.',
    'cannot_disable_currency_system_fallback'   => 'Non è possibile disabilitare :name perché è la valuta predefinita di sistema.',
    'disable_EUR_side_effects'                  => 'L\'Euro è la valuta predefinita di sistema in caso di emergenza. Disabilitarla potrebbe provocare effetti collaterali non previsti e potrebbe annullare la garanzia.',
    'deleted_currency'                          => 'Valuta :name elimina',
    'created_currency'                          => 'Valuta :name creata',
    'could_not_store_currency'                  => 'Impossibile memorizzare la nuova valuta.',
    'updated_currency'                          => 'Valuta :name aggiornata',
    'ask_site_owner'                            => 'Chiedi a :owner di aggiungere, rimuovere o modificare valute.',
    'currencies_intro'                          => 'Firefly III supporta varie valute che è possibile impostare e abilitare qui.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Rendila predefinita',
    'default_currency'                          => 'predefinita',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Disabilitata',
    'enable_currency'                           => 'Abilita',
    'disable_currency'                          => 'Disabilita',
    'currencies_default_disabled'               => 'Come impostazione predefinita la maggior parte di queste valute sono disabilitate. Per usarle devi prima abilitarle.',
    'currency_is_now_enabled'                   => 'La valuta ":name" è stata abilitata',
    'could_not_enable_currency'                 => 'Impossibile abilitare la valuta ":name". Ti preghiamo di revisionare i registri.',
    'currency_is_now_disabled'                  => 'La valuta ":name" è stata disabilitata',
    'could_not_disable_currency'                => 'Impossibile disabilitare la valuta ":name". Forse è ancora in uso?',

    // forms:
    'mandatoryFields'                           => 'Campi obbligatori',
    'optionalFields'                            => 'Campi opzionali',
    'options'                                   => 'Opzioni',

    // budgets:
    'daily_budgets'                             => 'Budget giornalieri',
    'weekly_budgets'                            => 'Budget settimanali',
    'monthly_budgets'                           => 'Budget mensili',
    'quarterly_budgets'                         => 'Bilanci trimestrali',
    'half_year_budgets'                         => 'Bilanci semestrali',
    'yearly_budgets'                            => 'Budget annuali',
    'other_budgets'                             => 'Budget a periodi personalizzati',
    'budget_limit_not_in_range'                 => 'Questo importo si applica dal :start al :end:',
    'total_available_budget'                    => 'Budget totale disponibile (tra :start e :end)',
    'total_available_budget_in_currency'        => 'Budget totale disponibile in :currency',
    'see_below'                                 => 'vedi sotto',
    'create_new_budget'                         => 'Crea nuovo budget',
    'store_new_budget'                          => 'Salva il nuovo budget',
    'stored_new_budget'                         => 'Nuovo budget salvato ":name"',
    'available_between'                         => 'Disponibile tra :start e :end',
    'transactionsWithoutBudget'                 => 'Spese senza budget',
    'transactions_no_budget'                    => 'Spese senza budget tra :start e :end',
    'spent_between'                             => 'Già spesi tra :start e :end',
    'spent_between_left'                        => 'Spesi :spent tra :start e :end, rimasti :left.',
    'set_available_amount'                      => 'Imposta importo disponibile',
    'update_available_amount'                   => 'Aggiorna importo disponibile',
    'ab_basic_modal_explain'                    => 'Usa questo modulo per indicare quanto ti aspetti di mettere a budget (in totale, in :currency) nel periodo indicato.',
    'createBudget'                              => 'Nuovo budget',
    'invalid_currency'                          => 'Questa non è una valuta valida',
    'invalid_amount'                            => 'Inserisci un importo',
    'set_ab'                                    => 'L\'importo del budget disponibile è stato impostato',
    'updated_ab'                                => 'L\'importo del budget disponibile è stato aggiornato',
    'deleted_ab'                                => 'L\'importo del budget disponibile è stato eliminato',
    'deleted_bl'                                => 'L\'importo del budget è stato eliminato',
    'alt_currency_ab_create'                    => 'Imposta il budget disponibile in un\'altra valuta',
    'bl_create_btn'                             => 'Imposta il budget in un\'altra valuta',
    'inactiveBudgets'                           => 'Budget disattivati',
    'without_budget_between'                    => 'Transazioni senza un budget tra :start e :end',
    'delete_budget'                             => 'Elimina budget ":name"',
    'deleted_budget'                            => 'Budget eliminato ":name"',
    'edit_budget'                               => 'Modifica budget ":name"',
    'updated_budget'                            => 'Budget ":name" aggiornato',
    'update_amount'                             => 'Aggiorna importo',
    'update_budget'                             => 'Budget aggiornato',
    'update_budget_amount_range'                => 'Aggiorna l\'importo disponibile (previsto) tra il :start e il :end',
    'set_budget_limit_title'                    => 'Imposta l\'importo del budget per il budget :budget tra :start e :end',
    'set_budget_limit'                          => 'Importo del budget impostato',
    'budget_period_navigator'                   => 'Navigatore dei periodi',
    'info_on_available_amount'                  => 'Cosa ho a disposizione?',
    'available_amount_indication'               => 'Utilizza questi importi per ottenere un\'indicazione di quale potrebbe essere il tuo budget totale.',
    'suggested'                                 => 'Consigliato',
    'average_between'                           => 'Media tra :start e :end',
    'transferred_in'                            => 'Trasferito (ingresso)',
    'transferred_away'                          => 'Trasferito (uscita)',
    'auto_budget_none'                          => 'Nessun budget automatico',
    'auto_budget_reset'                         => 'Imposta un importo fisso per ogni periodo',
    'auto_budget_rollover'                      => 'Aggiungi un importo per ogni periodo',
    'auto_budget_adjusted'                      => 'Aggiungi un importo ogni periodo e correggi la spesa eccessiva',
    'auto_budget_period_daily'                  => 'Giornaliero',
    'auto_budget_period_weekly'                 => 'Settimanale',
    'auto_budget_period_monthly'                => 'Mensile',
    'auto_budget_period_quarterly'              => 'Trimestrale',
    'auto_budget_period_half_year'              => 'Semestrale',
    'auto_budget_period_yearly'                 => 'Annuale',
    'auto_budget_help'                          => 'Puoi leggere di più su questa funzione nella guida. Clicca sull\'icona (?) in alto a destra.',
    'auto_budget_reset_icon'                    => 'Questo budget sarà impostato periodicamente',
    'auto_budget_rollover_icon'                 => 'L\'importo del budget aumenterà periodicamente',
    'auto_budget_adjusted_icon'                 => 'L\'importo del budget aumenterà periodicamente e correggerà la spesa eccessiva',
    'remove_budgeted_amount'                    => 'Rimuovi l\'import a budget in :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Usa il campo salta per creare intervalli bimestrali (salta = 1) o altri intervalli personalizzati.',
    'subscription'                              => 'Pagamento ricorrente',
    'not_expected_period'                       => 'Non prevista per questo periodo',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => 'No (per ora)',
    'visit_bill'                                => 'Visita il pagamento ricorrente ":name" su Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Il pagamento ricorrente abbina le transazioni tra :low e :high.',
    'running_again_loss'                        => 'Le transazioni precedentemente collegate a questo pagamento ricorrente potrebbero perdere la loro connessione se (non) corrispondono (più) alla regola.',
    'bill_related_rules'                        => 'Regole relative a questo pagamento ricorrente',
    'repeats'                                   => 'Si ripete',
    'bill_end_date_help'                        => 'Campo opzionale. Il pagamento ricorrente dovrebbe terminare in questa data.',
    'bill_extension_date_help'                  => 'Campo opzionale. Il pagamento ricorrente deve essere esteso (o annullato) in questa data o prima.',
    'bill_end_index_line'                       => 'Questo pagamento ricorrente termina il giorno :date',
    'bill_extension_index_line'                 => 'Questo pagamento ricorrente deve essere esteso o annullato il :date',
    'connected_journals'                        => 'Transazioni connesse',
    'auto_match_on'                             => 'Abbinato automaticamente da Firefly III',
    'auto_match_off'                            => 'Non abbinato automaticamente a Firefly III',
    'next_expected_match'                       => 'Prossimo abbinamento previsto',
    'delete_bill'                               => 'Elimina pagamento ricorrente ":name"',
    'deleted_bill'                              => 'Pagamento ricorrente ":name" eliminato',
    'edit_bill'                                 => 'Modifica pagamento ricorrente ":name"',
    'more'                                      => 'Altro',
    'rescan_old'                                => 'Esegui nuovamente le regole su tutte le transazioni',
    'update_bill'                               => 'Aggiorna pagamento ricorrente',
    'updated_bill'                              => 'Pagamento ricorrente ":name" aggiornato',
    'store_new_bill'                            => 'Salva un nuovo pagamento ricorrente',
    'stored_new_bill'                           => 'Nuovo pagamento ricorrente ":name" salvato',
    'cannot_scan_inactive_bill'                 => 'I pagamenti ricorrenti non attivi non possono essere scansionate.',
    'rescanned_bill'                            => 'Riscansionato tutto, e collegata :count transazione al pagamento ricorrente.|Riscansionato tutto, e collegate :count transazioni al pagamento ricorrente.',
    'average_bill_amount_year'                  => 'Importo medio del pagamento ricorrente (:year)',
    'average_bill_amount_overall'               => 'Importo medio del pagamento ricorrente (totale)',
    'bill_is_active'                            => 'Il pagamento ricorrente è attivo',
    'bill_expected_between'                     => 'Previsto tra :start e :end',
    'bill_will_automatch'                       => 'Il pagamento ricorrente verrà automaticamente collegato alle transazioni corrispondenti',
    'skips_over'                                => 'ogni',
    'bill_store_error'                          => 'Si è verificato un errore imprevisto durante la memorizzazione del nuovo pagamento ricorrente. Si prega di controllare i file di log',
    'list_inactive_rule'                        => 'regola inattiva',
    'bill_edit_rules'                           => 'Firefly III tenterà anche di modificare la regola relativa a questo pagamento ricorrente. Se hai modificato questa regola da solo, Firefly III non cambierà nulla.|Firefly III tenterà anche di modificare le :count regole relative a questo pagamento ricorrente. Se hai modificato queste regole, Firefly III non cambierà nulla.',
    'bill_expected_date'                        => 'Attesa :date',
    'bill_expected_date_js'                     => 'Attesa per {date}',
    'expected_amount'                           => 'Importo (previsto)',
    'bill_paid_on'                              => 'Pagata il {date}',
    'bill_repeats_weekly'                       => 'Ripeti ogni settimana',
    'bill_repeats_monthly'                      => 'Ripeti ogni mese',
    'bill_repeats_quarterly'                    => 'Ripeti ogni tre mesi',
    'bill_repeats_half-year'                    => 'Ripeti ogni sei mesi',
    'bill_repeats_yearly'                       => 'Ripeti ogni anno',
    'bill_repeats_weekly_other'                 => 'Ripeti a settimane alterne',
    'bill_repeats_monthly_other'                => 'Ripeti a mesi alterni',
    'bill_repeats_quarterly_other'              => 'Ripeti ogni altro trimestre',
    'bill_repeats_half-year_other'              => 'Ripeti ogni anno',
    'bill_repeats_yearly_other'                 => 'Ripeti ad anni alterni',
    'bill_repeats_weekly_skip'                  => 'Ripeti ogni {skip} settimane',
    'bill_repeats_monthly_skip'                 => 'Ripeti ogni {skip} mesi',
    'bill_repeats_quarterly_skip'               => 'Ripeti ogni {skip} trimestri',
    'bill_repeats_half-year_skip'               => 'Ripeti ogni {skip} mezzi anni',
    'bill_repeats_yearly_skip'                  => 'Ripeti ogni {skip} anni',
    'subscriptions'                             => 'Pagamenti ricorrenti',
    'go_to_subscriptions'                       => 'Vai ai tuoi pagamenti ricorrenti',
    'forever'                                   => 'Per sempre',
    'extension_date_is'                         => 'La data di estensione è {date}',

    // accounts:
    'account_locked_currency'                   => 'La valuta di questo conto deve rimanere :name finché ci sono salvadanai collegate a esso.',
    'i_am_owed_amount'                          => 'Mi è dovuto l\'importo',
    'i_owe_amount'                              => 'Devo l\'importo',
    'inactive_account_link'                     => 'Hai :count conto inattivo (archiviato), che puoi visualizzare in questa pagina separata.|Hai :count conti inattivi (archiviati), che puoi visualizzare in questa pagina separata.',
    'all_accounts_inactive'                     => 'Questi sono i tuoi conti inattivi.',
    'active_account_link'                       => 'Questo collegamento ti riporta ai conti attivi.',
    'account_missing_transaction'               => 'Non è possibile visualizzare il conto #:id (":name") direttamente, a Firefly mancano le informazioni per il reindirizzamento.',
    'cc_monthly_payment_date_help'              => 'Seleziona qualsiasi anno e mese, verrà comunque ignorato. Solo il giorno del mese è rilevante.',
    'details_for_asset'                         => 'Dettagli per conto attività ":name"',
    'details_for_expense'                       => 'Dettagli per conto uscite ":name"',
    'details_for_revenue'                       => 'Dettagli per conto entrate ":name"',
    'details_for_cash'                          => 'Dettagli per il conto contanti ":name"',
    'store_new_asset_account'                   => 'Salva nuovo conto attività',
    'store_new_expense_account'                 => 'Salva il nuovo conto uscite',
    'store_new_revenue_account'                 => 'Salva il nuovo conto entrate',
    'edit_asset_account'                        => 'Modifica conto attività ":name"',
    'edit_expense_account'                      => 'Modifica conto uscite ":name"',
    'edit_revenue_account'                      => 'Modifica conto entrate ":name"',
    'delete_asset_account'                      => 'Elimina conto attività ":name"',
    'delete_expense_account'                    => 'Elimina conto uscite ":name"',
    'delete_revenue_account'                    => 'Elimina conto entrate ":name"',
    'delete_liabilities_account'                => 'Elimina passività ":name"',
    'asset_deleted'                             => 'Conto attività ":name" eliminato correttamente',
    'account_deleted'                           => 'Il conto ":name" è stato eliminato con successo',
    'expense_deleted'                           => 'Conto uscite ":name" eliminato correttamente',
    'revenue_deleted'                           => 'Conto entrate ":name" eliminato correttamente',
    'update_asset_account'                      => 'Aggiorna conto attività',
    'update_undefined_account'                  => 'Aggiorna conto',
    'update_liabilities_account'                => 'Aggiorna passività',
    'update_expense_account'                    => 'Aggiorna conto uscite',
    'update_revenue_account'                    => 'Aggiorna conto entrate',
    'make_new_asset_account'                    => 'Crea un nuovo conto attività',
    'make_new_expense_account'                  => 'Crea un nuovo conto uscite',
    'make_new_revenue_account'                  => 'Crea nuovo conto entrate',
    'make_new_liabilities_account'              => 'Crea una nuova passività',
    'asset_accounts'                            => 'Conti attività',
    'undefined_accounts'                        => 'Conti',
    'asset_accounts_inactive'                   => 'Conti attività (inattivi)',
    'expense_account'                           => 'Conto di spese',
    'expense_accounts'                          => 'Conti uscite',
    'expense_accounts_inactive'                 => 'Conti spese (inattivi)',
    'revenue_account'                           => 'Conto di entrate',
    'revenue_accounts'                          => 'Conti entrate',
    'revenue_accounts_inactive'                 => 'Conti entrate (inattivi)',
    'cash_accounts'                             => 'Conti contanti',
    'Cash account'                              => 'Conto contanti',
    'liabilities_accounts'                      => 'Passività',
    'liabilities_accounts_inactive'             => 'Passività (inattive)',
    'reconcile_account'                         => 'Riconciliazione conto ":account"',
    'overview_of_reconcile_modal'               => 'Panoramica della riconciliazione',
    'delete_reconciliation'                     => 'Elimina riconciliazione',
    'update_reconciliation'                     => 'Aggiorna riconciliazione',
    'amount_cannot_be_zero'                     => 'L\'importo non può essere zero',
    'end_of_reconcile_period'                   => 'Fine periodo riconciliazione: :period',
    'start_of_reconcile_period'                 => 'Inizio periodo riconciliazione: :period',
    'start_balance'                             => 'Saldo iniziale',
    'end_balance'                               => 'Saldo finale',
    'update_balance_dates_instruction'          => 'Abbina gli importi e le date qui sopra al tuo estratto conto e premi "Inizia la riconciliazione"',
    'select_transactions_instruction'           => 'Seleziona le transazioni che appaiono sul tuo estratto conto.',
    'select_range_and_balance'                  => 'Innanzitutto verifica l\'intervallo delle date e i saldi. Quindi premi "Inizia la riconciliazione"',
    'date_change_instruction'                   => 'Se cambi ora l\'intervallo di date, qualsiasi progresso andrà perso.',
    'update_selection'                          => 'Aggiorna selezione',
    'store_reconcile'                           => 'Memorizza la riconciliazione',
    'reconciliation_transaction'                => 'Transazione di riconciliazione',
    'Reconciliation'                            => 'Riconciliazione',
    'reconciliation'                            => 'Riconciliazione',
    'reconcile_options'                         => 'Opzioni di riconciliazione',
    'reconcile_range'                           => 'Intervallo di riconciliazione',
    'start_reconcile'                           => 'Inizia la riconciliazione',
    'cash_account_type'                         => 'Contante',
    'cash'                                      => 'contanti',
    'cant_find_redirect_account'                => 'Firefly III ha provato a reindirizzare ma non è riuscito. Ci dispiace. Torna all\'indice.',
    'account_type'                              => 'Tipo conto',
    'save_transactions_by_moving'               => 'Salva questa transazione spostandola in un altro conto:|Salva queste transazioni spostandole in un altro conto:',
    'save_transactions_by_moving_js'            => 'Nessuna transazione|Salva questa transazione spostandola in un altro conto.|Salva queste transazioni spostandole in un altro conto.',
    'stored_new_account'                        => 'Nuovo conto ":name" stored!',
    'stored_new_account_js'                     => 'Nuovo conto "<a href="accounts/show/{ID}">{name}</a>" salvato!',
    'updated_account'                           => 'Aggiorna conto ":name"',
    'updated_account_js'                        => 'Conto "<a href="accounts/show/{ID}">{title}</a>" aggiornato.',
    'credit_card_options'                       => 'Opzioni carta di credito',
    'no_transactions_account'                   => 'Non ci sono transazioni (in questo periodo) per il conto attività ":name".',
    'no_transactions_period'                    => 'Non ci sono transazioni (in questo periodo).',
    'no_data_for_chart'                         => 'Non ci sono (ancora) abbastanza informazioni per generare questo grafico.',
    'select_at_least_one_account'               => 'Seleziona almeno un conto attività',
    'select_at_least_one_category'              => 'Seleziona almeno una categoria',
    'select_at_least_one_budget'                => 'Seleziona almeno un budget',
    'select_at_least_one_tag'                   => 'Seleziona almeno un\'etichetta',
    'select_at_least_one_expense'               => 'Seleziona almeno una combinazione di conti spese/entrate. Se non ne hai nessuno (la lista è vuota) questo resoconto non è disponibile.',
    'account_default_currency'                  => 'Questa sarà la valuta predefinita associata a questo conto.',
    'piggy_default_currency'                    => 'I salvadanai possono conservare denaro solo in un\'unica valuta.',
    'piggy_account_currency_match'              => 'Verranno accettati solo i conti che utilizzano la valuta selezionata in precedenza.',
    'reconcile_has_more'                        => 'Il libro mastro di Firefly III ha più denaro rispetto a quanto afferma la tua banca. Ci sono diverse opzioni. Scegli cosa fare. In seguito, premi "Conferma riconciliazione".',
    'reconcile_has_less'                        => 'Il tuo conto Firefly III ha meno denaro rispetto a quanto afferma la tua banca. Ci sono diverse opzioni Si prega di scegliere cosa fare. Quindi, premi "Conferma riconciliazione".',
    'reconcile_is_equal'                        => 'Il libro mastro di Firefly III e i tuoi estratti conto bancari corrispondono. Non c\'è niente da fare. Premi "Conferma riconciliazione" per confermare l\'inserimento.',
    'create_pos_reconcile_transaction'          => 'Concilia le transazioni selezionate e crea una correzione aggiungendo :amount a questo conto attività.',
    'create_neg_reconcile_transaction'          => 'Concilia le transazioni selezionate e crea una correzione rimuovendo :amount da questo conto attività.',
    'reconcile_do_nothing'                      => 'Concilia le transazioni selezionate, ma non correggere.',
    'reconcile_go_back'                         => 'Puoi sempre modificare o eliminare una correzione in un secondo momento.',
    'must_be_asset_account'                     => 'È possibile riconciliare solo i conti attività',
    'reconciliation_stored'                     => 'Riconciliazione memorizzata',
    'reconciliation_error'                      => 'A causa di un errore le transazioni sono state contrassegnate come riconciliate ma la correzione non è stata memorizzata: :error.',
    'reconciliation_transaction_title'          => 'Riconciliazione (:from - :to)',
    'sum_of_reconciliation'                     => 'Somma riconciliazione',
    'reconcile_this_account'                    => 'Riconcilia questo conto',
    'reconcile'                                 => 'Riconcilia',
    'show'                                      => 'Mostra',
    'confirm_reconciliation'                    => 'Conferma riconciliazione',
    'submitted_start_balance'                   => 'Saldo iniziale inserito',
    'selected_transactions'                     => 'Transazioni selezionate (:count)',
    'already_cleared_transactions'              => 'Transazioni già conciliate (:count)',
    'submitted_end_balance'                     => 'Saldo finale inserito',
    'initial_balance_description'               => 'Saldo iniziale per ":account"',
    'liability_credit_description'              => 'Credito passività per ":account"',
    'interest_calc_'                            => 'sconosciuto',
    'interest_calc_daily'                       => 'Al giorno',
    'interest_calc_monthly'                     => 'Al mese',
    'interest_calc_yearly'                      => 'All\'anno',
    'interest_calc_weekly'                      => 'Settimanale',
    'interest_calc_half-year'                   => 'Semestrale',
    'interest_calc_quarterly'                   => 'Trimestrale',
    'initial_balance_account'                   => 'Saldo iniziale del conto :account',
    'list_options'                              => 'Lista opzioni',
    'account_column_opt_drag_and_drop'          => 'Trascina e rilascia',
    'account_column_opt_active'                 => 'Attivo',
    'account_column_opt_name'                   => 'Nome',
    'account_column_opt_type'                   => 'Tipo',
    'account_column_opt_liability_type'         => 'Tipo passività',
    'account_column_opt_liability_direction'    => 'Direzione passività',
    'account_column_opt_liability_interest'     => 'Interessi passività',
    'account_column_opt_number'                 => 'Numero conto',
    'account_column_opt_current_balance'        => 'Saldo corrente',
    'account_column_opt_amount_due'             => 'Importo dovuto',
    'account_column_opt_last_activity'          => 'Ultima attività',
    'account_column_opt_balance_difference'     => 'Differenze saldi',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Nuova categoria',
    'create_new_category'                       => 'Crea nuova categoria',
    'without_category'                          => 'Senza categoria',
    'update_category'                           => 'Aggiorna categoria',
    'updated_category'                          => 'Aggiorna categoria ":name"',
    'categories'                                => 'Categorie',
    'edit_category'                             => 'Modifica categoria ":name"',
    'no_category'                               => '(nessuna categoria)',
    'unknown_category_plain'                    => 'Nessuna categoria',
    'category'                                  => 'Categoria',
    'delete_category'                           => 'Elimina categoria ":name"',
    'deleted_category'                          => 'Categoria eliminata ":name"',
    'store_category'                            => 'Salva nuova categoria',
    'stored_category'                           => 'Salva nuova categoria ":name"',
    'without_category_between'                  => 'Senza categoria tra :start e :end',


    // transactions:
    'wait_loading_transaction'                  => 'Attendi il caricamento del modello',
    'wait_loading_data'                         => 'Ti preghiamo di attendere il caricamento delle tue informazioni...',
    'wait_attachments'                          => 'Attendere che gli allegati vengano caricati.',
    'errors_upload'                             => 'Caricamento fallito. Controlla la console del tuo browser per l\'errore.',
    'amount_foreign_if'                         => 'Importo in valuta estera, nel caso',
    'amount_destination_account'                => 'Importo nella valuta del conto di destinazione',
    'edit_transaction_title'                    => 'Modifica transazione ":description"',
    'unreconcile'                               => 'Annulla riconciliazione',
    'update_withdrawal'                         => 'Aggiorna prelievo',
    'update_deposit'                            => 'Aggiorna entrata',
    'update_transaction'                        => 'Aggiorna transazione',
    'update_transfer'                           => 'Aggiorna trasferimento',
    'updated_withdrawal'                        => 'Prelievo ":description" aggiornato',
    'updated_deposit'                           => 'Entrata aggiornata ":description"',
    'updated_transfer'                          => 'Trasferimento ":description" aggiornato',
    'no_changes_withdrawal'                     => 'La ":description" del prelievo non è stata modificata.',
    'no_changes_deposit'                        => 'La ":description" del deposito non è stata modificata.',
    'no_changes_transfer'                       => 'La ":description" del trasferimento non è stata modificata.',
    'delete_withdrawal'                         => 'Elimina prelievo ":description"',
    'delete_deposit'                            => 'Elimina entrata ":description"',
    'delete_transfer'                           => 'Elimina trasferimento ":description"',
    'deleted_withdrawal'                        => 'Prelievo ":description" eliminato correttamente',
    'deleted_deposit'                           => 'Entrata ":description" eliminata correttamente',
    'deleted_transfer'                          => 'Trasferimento ":description" eliminato correttamente',
    'deleted_reconciliation'                    => 'Transazione di riconciliazione ":description" elimina con successo',
    'stored_journal'                            => 'Nuova transazione ":description" creata correttamente',
    'stored_journal_js'                         => 'Nuova transazione "{{description}}" creata con successo',
    'stored_journal_no_descr'                   => 'Hai creato con successo la nuova transazione',
    'updated_journal_no_descr'                  => 'Transazione aggiornata con successo',
    'select_transactions'                       => 'Seleziona transazioni',
    'rule_group_select_transactions'            => 'Applica ":title" a transazioni',
    'rule_select_transactions'                  => 'Applica ":title" a transazioni',
    'stop_selection'                            => 'Smetti di selezionare le transazioni',
    'reconcile_selected'                        => 'Riconcilia',
    'mass_delete_journals'                      => 'Elimina un certo numero di transazioni',
    'mass_edit_journals'                        => 'Modifica un certo numero di transazioni',
    'mass_bulk_journals'                        => 'Modifica in blocco un certo numero di transazioni',
    'mass_bulk_journals_explain'                => 'Questo modulo di consente di cambiare le proprietà delle transazioni elencate di seguito in un unico aggiornamento. Tutte le transazioni nella tabella verranno aggiornate quando cambi i parametri che vedi.',
    'part_of_split'                             => 'Questa transazione fa parte di una transazione suddivisa. Se non hai selezionato tutte le suddivisioni, potresti finire con il modificare solo metà della transazione.',
    'bulk_set_new_values'                       => 'Usa gli inserimenti qui sotto per impostare nuovi valori. Se li lasci vuoti, saranno resi vuoti per tutti. Inoltre, si noti che solo i prelievi avranno un budget.',
    'no_bulk_category'                          => 'Non aggiornare la categoria',
    'no_bulk_budget'                            => 'Non aggiornare il budget',
    'no_bulk_tags'                              => 'Non aggiornare le etichette',
    'replace_with_these_tags'                   => 'Sostituisci con queste etichette',
    'append_these_tags'                         => 'Aggiungi queste etichette',
    'mass_edit'                                 => 'Modifica singolarmente le selezionate',
    'bulk_edit'                                 => 'Modifica in gruppo le selezionate',
    'mass_delete'                               => 'Elimina selezionate',
    'cannot_edit_other_fields'                  => 'Non puoi modificare in blocco altri campi oltre a quelli presenti perché non c\'è spazio per mostrarli. Segui il link e modificali uno per uno se è necessario modificare questi campi.',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(nessun budget)',
    'no_bill'                                   => '(nessun pagamento ricorrente)',
    'account_per_budget'                        => 'Conto per budget',
    'account_per_category'                      => 'Conto per categoria',
    'create_new_object'                         => 'Crea',
    'empty'                                     => '(vuoto)',
    'all_other_budgets'                         => '(tutti gli altri budget)',
    'all_other_accounts'                        => '(tutti gli altri conti)',
    'expense_per_source_account'                => 'Spese per conto di origine',
    'expense_per_destination_account'           => 'Spese per conto di destinazione',
    'income_per_destination_account'            => 'Entrate per conto di destinazione',
    'spent_in_specific_category'                => 'Spesi nella categoria ":category"',
    'earned_in_specific_category'               => 'Guadagnati nella categoria ":category"',
    'spent_in_specific_tag'                     => 'Spesi per l\'etichetta ":tag"',
    'earned_in_specific_tag'                    => 'Guadagnati per l\'etichetta ":tag"',
    'income_per_source_account'                 => 'Reddito per conto di origine',
    'average_spending_per_destination'          => 'Spesa media per conto di destinazione',
    'average_spending_per_source'               => 'Spesa media per conto di origine',
    'average_earning_per_source'                => 'Guadagno medio per conto di origine',
    'average_earning_per_destination'           => 'Guadagno medio per conto di destinazione',
    'account_per_tag'                           => 'Conto per etichetta',
    'tag_report_expenses_listed_once'           => 'Spese e entrate non sono mai elencate due volte. Se una transazione ha più di un\'etichetta, potrebbe apparire sotto solo uno delle sue etichette. Può sembrare che questa lista manchi di alcuni dati ma gli importi saranno corretti.',
    'double_report_expenses_charted_once'       => 'Spese e entrate non sono mai visualizzate due volte. Se una transazione ha più di un\'etichetta, potrebbe apparire sotto solo uno delle sue etichette. Può sembrare che questo grafico manchi di alcuni dati ma gli importi saranno corretti.',
    'tag_report_chart_single_tag'               => 'Questo grafico è valido per una singola etichetta. Se una transazione ha più di una etichetta, quello che tu vedi qui potrebbe vedersi anche nei grafici delle altre etichette.',
    'tag'                                       => 'Etichetta',
    'no_budget_squared'                         => '(nessun budget)',
    'perm-delete-many'                          => 'Eliminare molti elementi in una sola volta può essere molto pericoloso. Sii cauto. Da questa pagina puoi eliminare parte di una transazione suddivisa, quindi fallo con attenzione.',
    'mass_deleted_transactions_success'         => ':count transazione eliminata.|:count transazioni eliminate.',
    'mass_edited_transactions_success'          => ':count transazione aggiornata.|:count transazioni aggiornate.',
    'opt_group_'                                => '(nessun tipo di conto)',
    'opt_group_no_account_type'                 => '(nessun tipo di conto)',
    'opt_group_defaultAsset'                    => 'Conti attività predefiniti',
    'opt_group_savingAsset'                     => 'Conti risparmio',
    'opt_group_sharedAsset'                     => 'Conti attività condivisi',
    'opt_group_ccAsset'                         => 'Carte di credito',
    'opt_group_cashWalletAsset'                 => 'Portafogli',
    'opt_group_expense_account'                 => 'Conti uscite',
    'opt_group_revenue_account'                 => 'Conti entrate',
    'opt_group_l_Loan'                          => 'Passività: Prestito',
    'opt_group_cash_account'                    => 'Conto contanti',
    'opt_group_l_Debt'                          => 'Passività: Debito',
    'opt_group_l_Mortgage'                      => 'Passività: Mutuo',
    'opt_group_l_Credit card'                   => 'Passività: Carta di credito',
    'notes'                                     => 'Note',
    'view_notes'                                => 'Visualizza note',
    'set_budget_limit_notes'                    => 'Visualizza le note per questo importo preventivato',
    'edit_bl_notes'                             => 'Modifica note',
    'update_bl_notes'                           => 'Aggiorna note',
    'unknown_journal_error'                     => 'Impossibile memorizzare la transazione. Controllare i file di log.',
    'attachment_not_found'                      => 'Impossibile trovare questo allegato.',
    'journal_link_bill'                         => 'Questa transazione è collegata al pagamento ricorrente <a href=":route">:name</a>. Per rimuovere il collegamento, deseleziona la casella di controllo. Usa le regole per collegarla a un altro pagamento ricorrente.',
    'transaction_stored_link'                   => 'La <a href="transactions/show/{ID}">transazione #{ID} ("{title}")</a> è stata salvata.',
    'transaction_new_stored_link'               => 'La <a href="transactions/show/{ID}">transazione #{ID}</a> è stata salvata.',
    'transaction_updated_link'                  => 'La <a href="transactions/show/{ID}">transazione #{ID}</a> ("{title}") è stata aggiornata.',
    'transaction_updated_no_changes'            => 'La <a href="transactions/show/{ID}">transazione #{ID}</a> ("{title}") non ha avuto cambiamenti.',
    'first_split_decides'                       => 'La prima suddivisione determina il valore di questo campo',
    'first_split_overrules_source'              => 'La prima suddivisione potrebbe sovrascrivere l\'account di origine',
    'first_split_overrules_destination'         => 'La prima suddivisione potrebbe sovrascrivere l\'account di destinazione',
    'spent_x_of_y'                              => 'Spesi {amount} di {total}',

    // new user:
    'welcome'                                   => 'Benvenuto in Firefly III!',
    'submit'                                    => 'Invia',
    'submission'                                => 'Invio',
    'submit_yes_really'                         => 'Invia (sì, so quello che sto facendo)',
    'getting_started'                           => 'Inizia',
    'to_get_started'                            => 'È bello vedere che hai installato Firefly III con successo. Per iniziare con questo strumento, inserisci il nome della tua banca e il saldo del tuo conto corrente principale. Non preoccuparti se hai più conti. È possibile aggiungere quelli più tardi. Firefly III ha bisogno di qualcosa per iniziare.',
    'savings_balance_text'                      => 'Firefly III creerà automaticamente un conto di risparmio per te. Per impostazione predefinita, non ci saranno soldi nel tuo conto di risparmio, ma se comunichi a Firefly III il saldo verrà salvato come tale.',
    'finish_up_new_user'                        => 'Questo è tutto! Puoi continuare premendo <strong>Invia</strong>. Verrai indirizzato all\'indice di Firefly III.',
    'stored_new_accounts_new_user'              => 'I tuoi nuovi conti sono stati salvati.',
    'set_preferred_language'                    => 'Se preferisci usare Firefly III in un\'altra lingua, impostala qui.',
    'language'                                  => 'Lingua',
    'new_savings_account'                       => 'Conto di risparmio :bank_name',
    'cash_wallet'                               => 'Portafoglio',
    'currency_not_present'                      => 'Se la valuta che usi normalmente non è elencata, non preoccuparti. Puoi creare le tue valute in Opzioni > Valute.',

    // home page:
    'transaction_table_description'             => 'Una tabella contenente le tue transazioni',
    'opposing_account'                          => 'Conto beneficiario',
    'yourAccounts'                              => 'I tuoi conti',
    'your_accounts'                             => 'Panoramica del tuo account',
    'category_overview'                         => 'Panoramica della categoria',
    'expense_overview'                          => 'Panoramica del conto spese',
    'revenue_overview'                          => 'Panoramica del conto entrate',
    'budgetsAndSpending'                        => 'Budget e spese',
    'budgets_and_spending'                      => 'Budget e spese',
    'go_to_budget'                              => 'Vai al budget "{budget}"',
    'go_to_deposits'                            => 'Vai ai depositi',
    'go_to_expenses'                            => 'Vai alle spese',
    'savings'                                   => 'Risparmi',
    'newWithdrawal'                             => 'Nuova uscita',
    'newDeposit'                                => 'Nuova entrata',
    'newTransfer'                               => 'Nuovo trasferimento',
    'bills_to_pay'                              => 'Pagamenti ricorrenti da pagare',
    'per_day'                                   => 'Al giorno',
    'left_to_spend_per_day'                     => 'Spese al giorno',
    'bills_paid'                                => 'Pagamento ricorrente pagato',
    'custom_period'                             => 'Periodo personalizzato',
    'reset_to_current'                          => 'Ripristina il periodo corrente',
    'select_period'                             => 'Seleziona il periodo',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Valuta',
    'preferences'                               => 'Preferenze',
    'logout'                                    => 'Esci',
    'logout_other_sessions'                     => 'Esci da tutte le altre sessioni',
    'toggleNavigation'                          => 'Attiva / disattiva la navigazione',
    'toggle_dropdown'                           => 'Espandi menù',
    'searchPlaceholder'                         => 'Cerca...',
    'version'                                   => 'Versione',
    'dashboard'                                 => 'Cruscotto',
    'income_and_expense'                        => 'Entrate e spese',
    'all_money'                                 => 'Tutto il tuo denaro',
    'unknown_source_plain'                      => 'Conto d\'origine sconosciuto',
    'unknown_dest_plain'                        => 'Conto di destinazione sconosciuto',
    'unknown_any_plain'                         => 'Conto sconosciuto',
    'unknown_budget_plain'                      => 'Nessun budget',
    'available_budget'                          => 'Budget disponibile ({currency})',
    'currencies'                                => 'Valute',
    'activity'                                  => 'Attività',
    'usage'                                     => 'Uso',
    'accounts'                                  => 'Conti',
    'Asset account'                             => 'Conto attività',
    'Default account'                           => 'Conto attività',
    'Expense account'                           => 'Conto spese',
    'Revenue account'                           => 'Conto entrate',
    'Initial balance account'                   => 'Saldo iniziale conto',
    'account_type_Asset account'                => 'Conto di risorse',
    'account_type_Expense account'              => 'Conto di spesa',
    'account_type_Revenue account'              => 'Conto di entrate',
    'account_type_Debt'                         => 'Debito',
    'account_type_Loan'                         => 'Prestito',
    'account_type_Mortgage'                     => 'Mutuo',
    'account_type_debt'                         => 'Debito',
    'account_type_loan'                         => 'Prestito',
    'account_type_mortgage'                     => 'Mutuo',
    'account_type_Credit card'                  => 'Carta di credito',
    'credit_card_type_monthlyFull'              => 'Pagamento intero ogni mese',
    'liability_direction_credit'                => 'Questo debito mi è dovuto',
    'liability_direction_debit'                 => 'Devo questo debito a qualcun altro',
    'liability_direction_credit_short'          => 'Mi devono questo debito',
    'liability_direction_debit_short'           => 'Devo questo debito',
    'liability_direction__short'                => 'Sconosciuta',
    'liability_direction_null_short'            => 'Sconosciuta',
    'Liability credit'                          => 'Credito passività',
    'budgets'                                   => 'Budget',
    'tags'                                      => 'Etichette',
    'reports'                                   => 'Resoconti',
    'transactions'                              => 'Transazioni',
    'expenses'                                  => 'Spese / uscite',
    'income'                                    => 'Redditi / entrate',
    'transfers'                                 => 'Trasferimenti',
    'moneyManagement'                           => 'Gestione denaro',
    'money_management'                          => 'Gestione del denaro',
    'tools'                                     => 'Strumenti',
    'piggyBanks'                                => 'Salvadanai',
    'piggy_banks'                               => 'Salvadanai',
    'amount_x_of_y'                             => '{current} di {total}',
    'bills'                                     => 'Pagamenti ricorrenti',
    'withdrawal'                                => 'Uscita',
    'opening_balance'                           => 'Saldo di apertura',
    'deposit'                                   => 'Entrata',
    'account'                                   => 'Conto',
    'transfer'                                  => 'Trasferimento',
    'Withdrawal'                                => 'Prelievo',
    'Deposit'                                   => 'Entrata',
    'Transfer'                                  => 'Trasferimento',
    'bill'                                      => 'Pagamento ricorrente',
    'yes'                                       => 'Si',
    'no'                                        => 'No',
    'amount'                                    => 'Importo',
    'overview'                                  => 'Panoramica',
    'saveOnAccount'                             => 'Risparmio sul conto',
    'saveOnAccounts'                            => 'Risparmi sul conto(i)',
    'unknown'                                   => 'Sconosciuto',
    'monthly'                                   => 'Mensile',
    'profile'                                   => 'Profilo',
    'errors'                                    => 'Errori',
    'debt_start_date'                           => 'Data di inizio del debito',
    'debt_start_amount'                         => 'Importo iniziale del debito',
    'debt_start_amount_help'                    => 'È sempre meglio impostare questo valore su un importo negativo. Leggi le pagine di aiuto (icona (?) in alto a destra) per ulteriori informazioni.',
    'interest_period_help'                      => 'Questo campo è puramente estetico e non ti viene calcolato. Sembra che le banche siano molto subdole, pertanto Firefly III non lo calcola mai correttamente.',
    'store_new_liabilities_account'             => 'Memorizza nuova passività',
    'edit_liabilities_account'                  => 'Modica passività ":name"',
    'financial_control'                         => 'Controllo finanziario',
    'accounting'                                => 'Contabilità',
    'automation'                                => 'Automazione',
    'others'                                    => 'Altro',
    'classification'                            => 'Classificazione',
    'store_transaction'                         => 'Salva transazione',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Resoconto predefinito delle tue finanze tra :start e :end',
    'report_audit'                              => 'Panoramica cronologica delle transazioni tra :start e :end',
    'report_category'                           => 'Resoconto categoria tra :start e :end',
    'report_double'                             => 'Resoconto conto spese/entrate tra :start e :end',
    'report_budget'                             => 'Resoconto budget tra :start e :end',
    'report_tag'                                => 'Resoconto etichetta tra :start e :end',
    'quick_link_reports'                        => 'Collegamenti veloci',
    'quick_link_examples'                       => 'Questi sono alcuni link di esempio con i quali puoi cominciare. Leggi le pagine d\'aiuto tramite il pulsante (?) per avere informazioni su tutti i rapporti e le parole magiche che puoi usare.',
    'quick_link_default_report'                 => 'Resoconto finanziario predefinito',
    'quick_link_audit_report'                   => 'Panoramica cronologica delle transazioni',
    'report_this_month_quick'                   => 'Mese corrente, tutti i conti',
    'report_last_month_quick'                   => 'Mese scorso, tutti i conti',
    'report_this_year_quick'                    => 'Anno corrente - tutti i conti',
    'report_this_fiscal_year_quick'             => 'Anno fiscale corrente - tutti i conti',
    'report_all_time_quick'                     => 'Sempre tutti i conti',
    'reports_can_bookmark'                      => 'Ricorda che i resoconti possono essere aggiunti ai segnalibri.',
    'incomeVsExpenses'                          => 'Entrate vs spese',
    'accountBalances'                           => 'Saldo dei conti',
    'balanceStart'                              => 'Saldo all\'inizio del periodo',
    'balanceEnd'                                => 'Saldo alla fine del periodo',
    'splitByAccount'                            => 'Dividi per conto',
    'coveredWithTags'                           => 'Coperto con etichetta',
    'leftInBudget'                              => 'Rimanenza nel budget',
    'left_in_debt'                              => 'Importo da pagare',
    'sumOfSums'                                 => 'Somma dei conti',
    'noCategory'                                => '(nessuna categoria)',
    'notCharged'                                => 'Non (ancora) addebitato',
    'inactive'                                  => 'Disattivo',
    'active'                                    => 'Attivo',
    'difference'                                => 'Differenza',
    'money_flowing_in'                          => 'Entrate',
    'money_flowing_out'                         => 'Uscite',
    'topX'                                      => 'Superiore :number',
    'show_full_list'                            => 'Mostra elenco completo',
    'show_only_top'                             => 'Mostra solo in alto :number',
    'report_type'                               => 'Tipo resoconto',
    'report_type_default'                       => 'Resoconto finanziario predefinito',
    'report_type_audit'                         => 'Panoramica cronologica delle transazioni (verifica)',
    'report_type_category'                      => 'Resoconto categoria',
    'report_type_budget'                        => 'Resoconto budget',
    'report_type_tag'                           => 'Resoconto etichetta',
    'report_type_double'                        => 'Resoconto conto spese/entrate',
    'more_info_help'                            => 'Ulteriori informazioni su questi tipi di resoconti sono disponibili nelle pagine della guida. Premi l\'icona (?) nell\'angolo in alto a destra.',
    'report_included_accounts'                  => 'Inclusi i conti',
    'report_date_range'                         => 'Intervallo di date',
    'report_preset_ranges'                      => 'Intervalli preimpostati',
    'shared'                                    => 'Condiviso',
    'fiscal_year'                               => 'Anno fiscale',
    'income_entry'                              => 'Entrate del conto ":name" tra :start e :end',
    'expense_entry'                             => 'Spese per il conto ":name" tra :start e :end',
    'category_entry'                            => 'Spese e entrate nella categoria ":name" tra il :start e il :end',
    'budget_spent_amount'                       => 'Spese nel budget ":budget" tra :start e :end',
    'balance_amount'                            => 'Spese nel budget ":budget" pagate dal conto ":account" tra il :start e il :end',
    'no_audit_activity'                         => 'Nessuna attività è stata registrata nel conto <a href=":url" title=":account_name">:account_name</a> tra il :start e il :end.',
    'audit_end_balance'                         => 'Il saldo del conto <a href=":url" title=":account_name">:account_name</a> alla fine di :end era: :balance',
    'reports_extra_options'                     => 'Opzioni extra',
    'report_has_no_extra_options'               => 'Questo resoconto non ha opzioni extra',
    'reports_submit'                            => 'Mostra resoconto',
    'end_after_start_date'                      => 'La data della fine del resoconto deve essere successiva alla data di inizio.',
    'select_category'                           => 'Seleziona le categorie',
    'select_budget'                             => 'Seleziona i budget.',
    'select_tag'                                => 'Seleziona etichette.',
    'income_per_category'                       => 'Entrate per categoria',
    'expense_per_category'                      => 'Spesa per categoria',
    'expense_per_budget'                        => 'Spese per budget',
    'income_per_account'                        => 'Entrate per conto',
    'expense_per_account'                       => 'Spese per conto',
    'expense_per_tag'                           => 'Spese per etichetta',
    'income_per_tag'                            => 'Entrate per etichetta',
    'include_expense_not_in_budget'             => 'Incluse le spese non appartenenti ai budget selezionati',
    'include_expense_not_in_account'            => 'Incluse le spese non appartenenti ai conti selezionati',
    'include_expense_not_in_category'           => 'Incluse le spese non appartenenti alle categorie selezionate',
    'include_income_not_in_category'            => 'Incluse le entrate non appartenenti alle categorie selezionate',
    'include_income_not_in_account'             => 'Incluse le entrate non appartenenti ai conti selezionati',
    'include_income_not_in_tags'                => 'Incluse le entrate non appartenenti alle etichette selezionate',
    'include_expense_not_in_tags'               => 'Incluse le spese non appartenenti alle etichette selezionate',
    'everything_else'                           => 'Tutto il resto',
    'income_and_expenses'                       => 'Entrate e spese',
    'spent_average'                             => 'Spesi (media)',
    'income_average'                            => 'Entrate (media)',
    'transaction_count'                         => 'Conteggio transazioni',
    'average_spending_per_account'              => 'Spesa media per conto',
    'average_income_per_account'                => 'Media entrate per conto',
    'total'                                     => 'Totale',
    'description'                               => 'Descrizione',
    'sum_of_period'                             => 'Somma del periodo',
    'average_in_period'                         => 'Media nel periodo',
    'no_account_role'                           => '(nessun ruolo)',
    'account_role_defaultAsset'                 => 'Conto attività predefinito',
    'account_role_sharedAsset'                  => 'Conto attività condiviso',
    'account_role_savingAsset'                  => 'Conto risparmio',
    'account_role_ccAsset'                      => 'Carta di credito',
    'account_role_cashWalletAsset'              => 'Portafoglio',
    'budget_chart_click'                        => 'Fai clic su un nome di un budget nella tabella sopra per vedere un grafico.',
    'category_chart_click'                      => 'Fare clic sul nome di una categoria nella tabella sopra per vedere un grafico.',
    'in_out_accounts'                           => 'Guadagnati e spesi per combinazione',
    'in_out_accounts_per_asset'                 => 'Guadagnato e speso (per conto attività)',
    'in_out_per_category'                       => 'Guadagnati e spesi per categoria',
    'out_per_budget'                            => 'Speso per budget',
    'select_expense_revenue'                    => 'Seleziona conto spese/entrate',
    'multi_currency_report_sum'                 => 'Poiché questo elenco contiene conti con più valute, le somme potrebbero non avere senso. Il rapporto ripiegherà sempre sulla valuta predefinita.',
    'sum_in_default_currency'                   => 'La somma sarà sempre nella tua valuta predefinita.',
    'net_filtered_prefs'                        => 'Questo grafico non includerà mai i conti che hanno l\'opzione "Includi nel patrimonio" non selezionata.',


    // charts:
    'chart'                                     => 'Grafico',
    'month'                                     => 'Mese',
    'budget'                                    => 'Budget',
    'spent'                                     => 'Speso',
    'spent_capped'                              => 'Speso (massimo)',
    'spent_in_budget'                           => 'Speso nel budget',
    'left_to_spend'                             => 'Altro da spendere',
    'earned'                                    => 'Guadagnato',
    'overspent'                                 => 'Speso troppo',
    'left'                                      => 'Resto',
    'max-amount'                                => 'Importo massimo',
    'min-amount'                                => 'Importo minimo',
    'journal-amount'                            => 'Voce pagamento ricorrente corrente',
    'name'                                      => 'Nome',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Data',
    'date_and_time'                             => 'Data e ora',
    'time'                                      => 'Ora',
    'paid'                                      => 'Pagati',
    'unpaid'                                    => 'Da pagare',
    'day'                                       => 'Giorno',
    'budgeted'                                  => 'Preventivato',
    'period'                                    => 'Periodo',
    'balance'                                   => 'Saldo',
    'in_out_period'                             => 'Bilancio di questo periodo',
    'sum'                                       => 'Somma',
    'summary'                                   => 'Riepilogo',
    'average'                                   => 'Media',
    'balanceFor'                                => 'Saldo per :name',
    'no_tags'                                   => '(nessuna etichetta)',
    'nothing_found'                             => '(nessun risultato)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Impostazioni pagina',
    'visible_columns'               => 'Colonne visibili',
    'accounts_to_show'              => 'Conti da mostrare',
    'active_accounts_only'          => 'Solo conti attivi',
    'in_active_accounts_only'       => 'Solo conti inattivi',
    'show_all_accounts'             => 'Mostra tutti i conti',
    'group_accounts'                => 'Conti di gruppo',

    // piggy banks:
    'event_history'                 => 'Storico eventi',
    'add_money_to_piggy'            => 'Aggiungi denaro al salvadanaio":name"',
    'piggy_bank'                    => 'Salvadanaio',
    'new_piggy_bank'                => 'Nuovo salvadanaio',
    'store_piggy_bank'              => 'Salva il nuovo salvadanaio',
    'stored_piggy_bank'             => 'Salva il nuovo salvadanaio ":name"',
    'account_status'                => 'Stato conto',
    'left_for_piggy_banks'          => 'Rimanente per i salvadanai',
    'sum_of_piggy_banks'            => 'Somma dei salvadanai',
    'saved_so_far'                  => 'Risparmiato finora',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => 'Rimanente da risparmiare',
    'suggested_amount'              => 'Quantità mensile consigliata da salvare',
    'add_money_to_piggy_title'      => 'Aggiungi denaro al salvadanaio ":name"',
    'remove_money_from_piggy_title' => 'Rimuovi i soldi dal salvadanaio ":name"',
    'add'                           => 'Aggiungi',
    'no_money_for_piggy'            => 'non hai soldi da mettere in questo salvadanaio.',
    'suggested_savings_per_month'   => 'Suggerimento per mese',

    'remove'                    => 'Rimuovi',
    'max_amount_add'            => 'L\'importo massimo che puoi aggiungere è',
    'max_amount_remove'         => 'L\'importo massimo che puoi rimuovere è',
    'update_piggy_button'       => 'Aggiorna salvadanaio',
    'update_piggy_title'        => 'Aggiorna salvadanaio ":name"',
    'updated_piggy_bank'        => 'Aggiorna salvadanaio ":name"',
    'details'                   => 'Dettagli',
    'events'                    => 'Eventi',
    'target_amount'             => 'Importo obiettivo',
    'start_date'                => 'Data inizio',
    'no_start_date'             => 'Nessuna data di inizio',
    'target_date'               => 'Data fine',
    'no_target_date'            => 'Nessuna data fine',
    'table'                     => 'Tabella',
    'delete_piggy_bank'         => 'Elimina salvadanaio ":name"',
    'cannot_add_amount_piggy'   => 'Impossibile aggiungere :amount a ":name".',
    'cannot_remove_from_piggy'  => 'Impossibile rimuovere :amount a ":name".',
    'deleted_piggy_bank'        => 'Salvadanaio eliminato ":name"',
    'added_amount_to_piggy'     => 'Aggiunto :amount a ":name"',
    'removed_amount_from_piggy' => 'Rimosso :amount a ":name"',
    'piggy_events'              => 'Salvadanai correlati',

    // tags
    'delete_tag'                => 'Elimina etichetta ":tag"',
    'deleted_tag'               => 'Etichetta ":tag" eliminata',
    'new_tag'                   => 'Crea nuova etichetta',
    'edit_tag'                  => 'Modifica etichetta ":tag"',
    'updated_tag'               => 'Etichetta ":tag" aggiornata',
    'created_tag'               => 'Etichetta ":tag" creata correttamente',

    'transaction_journal_information'               => 'Informazioni transazione',
    'transaction_journal_amount'                    => 'Informazioni sull\'importo',
    'transaction_journal_meta'                      => 'Meta informazioni',
    'transaction_journal_more'                      => 'Altre informazioni',
    'basic_journal_information'                     => 'Informazioni di base sulla transazione',
    'transaction_journal_extra'                     => 'Informazioni aggiuntive',
    'att_part_of_journal'                           => 'Memorizzato sotto ":journal"',
    'total_amount'                                  => 'Importo totale',
    'number_of_decimals'                            => 'Cifre decimali',


    // administration
    'invite_is_already_redeemed'                    => 'L\'invito a ":address" è già stato revocato.',
    'invite_is_deleted'                             => 'L\'invito a ":address" è stato eliminato.',
    'invite_new_user_title'                         => 'Invita nuovo utente',
    'invite_new_user_text'                          => 'Come amministratore, puoi invitare gli utenti a registrarsi alla tua installazione di Firefly III. Utilizzando il link diretto, puoi condividerlo con loro, così che potranno registrare un conto. L\'utente invitato e il suo link d\'invito appariranno nella seguente tabella. Sei libero di condividere il link d\'invito con chi desideri.',
    'invited_user_mail'                             => 'Indirizzo email',
    'invite_user'                                   => 'Invita l\'utente',
    'user_is_invited'                               => 'L\'indirizzo email ":address" è stato invitato a Firefly III',
    'administration'                                => 'Amministrazione',
    'system_settings'                               => 'Impostazioni di sistema',
    'code_already_used'                             => 'Il codice d\'invito è stato utilizzato',
    'user_administration'                           => 'Amministrazione utenti',
    'list_all_users'                                => 'Tutti gli utenti',
    'all_users'                                     => 'Tutti gli utenti',
    'instance_configuration'                        => 'Configurazione',
    'firefly_instance_configuration'                => 'Configurazione Firefly III',
    'setting_single_user_mode'                      => 'Modo utente singolo',
    'setting_single_user_mode_explain'              => 'Per impostazione predefinita, Firefly III accetta solo una (1) registrazione: tu. Questa è una misura di sicurezza, che impedisce ad altri di usare la tua istanza a meno che tu non le autorizzi. Le future registrazioni sono bloccate. Bene! quando deselezioni questa casella, gli altri possono usare la tua istanza, supponendo che possano raggiungerla (quando è connessa a Internet).',
    'store_configuration'                           => 'Salva configurazione',
    'single_user_administration'                    => 'Amministrazione utenti per :email',
    'edit_user'                                     => 'Modifica utente :email',
    'hidden_fields_preferences'                     => 'Puoi abilitare maggiori opzioni per le transazioni nelle tue <a href="preferences">impostazioni</a>.',
    'user_data_information'                         => 'Dati utente',
    'user_information'                              => 'Informazioni Utente',
    'total_size'                                    => 'dimensione totale',
    'budget_or_budgets'                             => ':count budget|:count budget',
    'budgets_with_limits'                           => ':count budget con un importo impostato|:count budget con importi impostati',
    'nr_of_rules_in_total_groups'                   => ':count_rules regole in :count_groups gruppi di regole',
    'tag_or_tags'                                   => ':count etichetta|:count etichette',
    'configuration_updated'                         => 'La configurazione è stata aggiornata',
    'setting_is_demo_site'                          => 'Sito Demo',
    'setting_is_demo_site_explain'                  => 'Se si seleziona questa casella, questa installazione si comporterà come se fosse il sito demo, che può avere strani effetti collaterali.',
    'block_code_bounced'                            => 'Messaggi email respinti',
    'block_code_expired'                            => 'Conto demo scaduto',
    'no_block_code'                                 => 'Nessun motivo per bloccare o non bloccare un utente',
    'demo_user_export'                              => 'L\'utente demo non può esportare dati',
    'block_code_email_changed'                      => 'L\'utente non ha ancora confermato il nuovo indirizzo emails',
    'admin_update_email'                            => 'Contrariamente alla pagina del profilo, l\'utente NON riceverà alcuna notifica al proprio indirizzo email!',
    'update_user'                                   => 'Aggiorna utente',
    'updated_user'                                  => 'I dati dell\'utente sono stati modificati.',
    'delete_user'                                   => 'Elimina utente :email',
    'user_deleted'                                  => 'L\'utente è stato eliminato',
    'send_test_email'                               => 'Invia un messaggio di posta elettronica di prova',
    'send_test_email_text'                          => 'Per vedere se la tua installazione è in grado di inviare notifiche, per favore premi questo pulsante. Qui non vedrai un errore (se presente), <strong>i file di log rifletteranno eventuali errori</strong>. Puoi premere questo pulsante tutte le volte che vuoi. Non c\'è controllo dello spam. Il messaggio verrà inviato a <code>:email</code> e dovrebbe arrivare a breve.',
    'send_message'                                  => 'Invia messaggio',
    'send_test_triggered'                           => 'Il test è stato attivato. Controlla la tua casella di posta e i file di log.',
    'give_admin_careful'                            => 'Gli utenti con privilegi di amministratore posso rimuovere i tuoi privilegi. Fai attenzione.',
    'admin_maintanance_title'                       => 'Manutenzione',
    'admin_maintanance_expl'                        => 'Qualche pulsante per la manutenzione di Firefly III',
    'admin_maintenance_clear_cache'                 => 'Svuota cache',
    'owner_notifications'                           => 'Notifiche amministratore',
    'owner_notifications_expl'                      => 'Le seguenti notifiche possono essere abilitate o disabilitate dall\'amministratore. Verranno inviate su TUTTI i canali configurati. Alcuni canali sono configurati nelle variabili d\'ambiente, altri possono essere impostati qui.',
    'channel_settings'                              => 'Impostazioni per i canali di notifica',
    'notification_test_failed'                      => 'Notifica test per il canale ":channel" non riuscita. I registri conterranno maggiori dettagli.',
    'notification_test_executed'                    => 'Notifica test per il canale ":channel" riuscita. Controlla i registri per i dettagli.',
    'settings_notifications'                        => 'Impostazioni per le notifiche',
    'title_owner_notifications'                     => 'Notifiche proprietario',
    'owner_notification_check_user_new_reg'         => 'L\'utente riceve il messaggio di benvenuto post-registrazione',
    'owner_notification_check_admin_new_reg'        => 'Gli amministratori ricevono la notifica di registrazione di nuovi utenti',
    'owner_notification_check_new_version'          => 'È disponibile una nuova versione',
    'owner_notification_check_invite_created'       => 'Un utente è stato invitato in Firefly III',
    'owner_notification_check_invite_redeemed'      => 'Un invito utente è stato accettato',
    'owner_notification_check_unknown_user_attempt' => 'Un utente sconosciuto ha tentato di accedere',
    'all_invited_users'                             => 'Utenti invitati',
    'save_notification_settings'                    => 'Salva le impostazioni',
    'notification_settings'                         => 'Impostazioni per le notifiche',
    'notification_settings_saved'                   => 'Le impostazioni sulle notifiche sono state salvate',
    'available_channels_title'                      => 'Canali disponibili',
    'available_channels_expl'                       => 'Questi canali sono disponibili per inviare notifiche. Per testare la configurazione, usa i pulsanti qui sotto. Nota che i pulsanti non hanno alcun controllo spam.',
    'notification_channel_name_email'               => 'Email',
    'slack_discord_double'                          => 'Il canale di notifica Slack può anche inviare notifiche a Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'non disponibile',
    'configure_channel_in_env'                      => 'necessita di variabili d\'ambiente',
    'test_notification_channel_name_email'          => 'Testa email',
    'test_notification_channel_name_slack'          => 'Testa Slack',
    'test_notification_channel_name_ntfy'           => 'Testa Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Testa Pushover',
    'test_notification_channel_name_gotify'         => 'Testa Gotify',
    'test_notification_channel_name_pushbullet'     => 'Testa Pushbullet',

    'split_transaction_title'               => 'Descrizione della transazione suddivisa',
    'split_transaction_title_help'          => 'Se crei una transazione suddivisa, è necessario che ci sia una descrizione globale per tutte le suddivisioni della transazione.',
    'split_title_help'                      => 'Se crei una transazione suddivisa è necessario che ci sia una descrizione globale per tutte le suddivisioni della transazione.',
    'you_create_transfer'                   => 'Stai creando un trasferimento.',
    'you_create_withdrawal'                 => 'Stai creando un prelievo.',
    'you_create_deposit'                    => 'Stai creando un deposito.',

    // links
    'journal_link_configuration'            => 'Configurazione collegamenti della transazione',
    'create_new_link_type'                  => 'Crea un nuovo tipo di collegamento',
    'store_new_link_type'                   => 'Memorizza nuovo tipo di collegamento',
    'update_link_type'                      => 'Aggiorna il tipo di collegamento',
    'edit_link_type'                        => 'Modifica il tipo di collegamento ":name"',
    'updated_link_type'                     => 'Tipo del collegamento ":name" aggiornato',
    'delete_link_type'                      => 'Elimina il tipo di collegamento ":name"',
    'deleted_link_type'                     => 'Tipo di collegamento eliminato ":name"',
    'stored_new_link_type'                  => 'Memorizza nuovo tipo di collegamento ":name"',
    'cannot_edit_link_type'                 => 'Impossibile modificare il tipo di collegamento ":name"',
    'link_type_help_name'                   => 'Es.: "Duplicati"',
    'link_type_help_inward'                 => 'Es.: "duplicati"',
    'link_type_help_outward'                => 'Es.: "è duplicata da"',
    'save_connections_by_moving'            => 'Salva il collegamento tra queste transazioni spostandole in un altro tipo di collegamento:',
    'do_not_save_connection'                => '(non salvare la connessione)',
    'link_transaction'                      => 'Collega transazione',
    'link_to_other_transaction'             => 'Collega questa transazione a un\'altra transazione',
    'select_transaction_to_link'            => 'Seleziona una transazione da collegare a questa. I collegamenti non sono al momento utilizzati in Firefly III (a parte la visualizzazione), ma prevedo di cambiare la cosa in futuro. Usa il box di ricerca per selezionare una transazione per titolo o per ID. Se vuoi aggiungere tipi di collegamento personalizzati, controlla la sezione amministrazione.',
    'this_transaction'                      => 'Questa transazione',
    'transaction'                           => 'Transazione',
    'comments'                              => 'Commenti',
    'link_notes'                            => 'Qualsiasi nota che tu voglia salvare con il collegamento.',
    'invalid_link_selection'                => 'Impossibile collegare queste transazioni',
    'selected_transaction'                  => 'Transazione selezionata',
    'journals_linked'                       => 'Le transazioni sono collegate.',
    'journals_error_linked'                 => 'Queste transazioni sono già collegate.',
    'journals_link_to_self'                 => 'Non puoi collegare una transazione con se stessa',
    'journal_links'                         => 'Collegamenti della transazione',
    'this_withdrawal'                       => 'Questo prelievo',
    'this_deposit'                          => 'Questa entrata',
    'this_transfer'                         => 'Questo trasferimento',
    'overview_for_link'                     => 'Panoramica per tipo di collegamento ":name"',
    'source_transaction'                    => 'Transazione di origine',
    'link_description'                      => 'Descrizione del collegamento',
    'destination_transaction'               => 'Transazione di destinazione',
    'delete_journal_link'                   => 'Elimina il collegamento tra <a href=":source_link">:source</a> e <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Elimina collegamento',

    // link translations:
    'Paid_name'                             => 'Pagata',
    'Refund_name'                           => 'Rimborso',
    'Reimbursement_name'                    => 'Rimborso spese',
    'Related_name'                          => 'Inerenti',
    'relates to_inward'                     => 'correlata a',
    'is (partially) refunded by_inward'     => 'è (parzialmente) rimborsata da',
    'is (partially) paid for by_inward'     => 'è (parzialmente) pagata da',
    'is (partially) reimbursed by_inward'   => 'è (parzialmente) rimborsata da',
    'inward_transaction'                    => 'Transazione in ingresso',
    'outward_transaction'                   => 'Transazione in uscita',
    'relates to_outward'                    => 'inerente a',
    '(partially) refunds_outward'           => 'rimborsa (parzialmente)',
    '(partially) pays for_outward'          => '(parzialmente) paga per',
    '(partially) reimburses_outward'        => '(parzialmente) rimborsa',
    'is (partially) refunded by'            => 'è (parzialmente) rimborsata da',
    'is (partially) paid for by'            => 'è (parzialmente) pagata da',
    'is (partially) reimbursed by'          => 'è (parzialmente) rimborsata da',
    'relates to'                            => 'inerente a',
    '(partially) refunds'                   => 'rimborsa (parzialmente)',
    '(partially) pays for'                  => '(parzialmente) paga per',
    '(partially) reimburses'                => '(parzialmente) rimborsa',

    // split a transaction:
    'splits'                                => 'Suddivisioni',
    'add_another_split'                     => 'Aggiungi un\'altra divisione',
    'cannot_edit_opening_balance'           => 'Non è possibile modificare il saldo di apertura di un conto.',
    'no_edit_multiple_left'                 => 'Non hai selezionato transazioni valide da modificare.',
    'breadcrumb_convert_group'              => 'Converti transazione',
    'convert_invalid_source'                => 'L\'informazione di origine non è valida per la transazione #%d.',
    'convert_invalid_destination'           => 'L\'informazione di destinazione non è valida per la transazione #%d.',
    'create_another'                        => 'Dopo il salvataggio, torna qui per crearne un\'altra.',
    'after_update_create_another'           => 'Dopo l\'aggiornamento, torna qui per continuare la modifica.',
    'store_as_new'                          => 'Salva come nuova transazione invece di aggiornarla.',
    'reset_after'                           => 'Resetta il modulo dopo l\'invio',
    'errors_submission'                     => 'Errore durante l\'invio. Controlla gli errori segnalati qui sotto.',
    'errors_submission_v2'                  => 'C\'è stato qualcosa di sbagliato con il tuo invio. Controlla gli errori qui sotto: {{errorMessage}}',
    'transaction_expand_split'              => 'Espandi suddivisione',
    'transaction_remove_split'              => 'Rimuovi divisione',
    'transaction_collapse_split'            => 'Comprimi suddivisione',

    // object groups
    'default_group_title_name'              => '(non in un gruppo)',
    'default_group_title_name_plain'        => 'non raggruppato',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Creiamo un conto attività!',
    'no_accounts_intro_asset'               => 'Non hai ancora un conto attività. I conti attività sono i tuoi conti principali: il tuo conto corrente, il tuo conto di risparmio, il conto condiviso o persino la tua carta di credito.',
    'no_accounts_imperative_asset'          => 'Per iniziare a utilizzare Firefly III è necessario creare almeno un conto attività. Facciamolo ora:',
    'no_accounts_create_asset'              => 'Crea un conto attività',
    'no_accounts_title_expense'             => 'Creiamo un conto spese!',
    'no_accounts_intro_expense'             => 'Non hai ancora un conto spesa. I conti spese sono i luoghi in cui si spendono soldi, come negozi e supermercati.',
    'no_accounts_imperative_expense'        => 'I conti spesa vengono creati automaticamente quando si creano le transazioni, ma è possibile crearne anche manualmente, se lo si desidera. Ne creiamo uno ora:',
    'no_accounts_create_expense'            => 'Crea conto spesa',
    'no_accounts_title_revenue'             => 'Creiamo un conto entrate!',
    'no_accounts_intro_revenue'             => 'Non hai ancora un conto entrate. I conti delle entrate sono i luoghi da cui ricevi denaro, come il tuo datore di lavoro.',
    'no_accounts_imperative_revenue'        => 'I conti entrate vengono creati automaticamente quando si creano le transazioni, ma è possibile crearne anche manualmente, se lo si desidera. Creiamone uno ora:',
    'no_accounts_create_revenue'            => 'Crea conto entrate',
    'no_accounts_title_liabilities'         => 'Creiamo una passività!',
    'no_accounts_intro_liabilities'         => 'Non hai ancora delle passività. Le passività sono conti che registrano i prestiti (studenteschi) e altri debiti.',
    'no_accounts_imperative_liabilities'    => 'Non è necessario che usi questa funzionalità ma può essere utile se vuoi tenere traccia di queste cose.',
    'no_accounts_create_liabilities'        => 'Crea una passività',
    'no_budgets_title_default'              => 'Creiamo un budget',
    'no_rules_title_default'                => 'Creiamo una regola',
    'no_budgets_intro_default'              => 'Non hai ancora budget. I budget sono usati per organizzare le tue spese in gruppi logici, ai quali puoi dare un tetto indicativo per limitare le tue spese.',
    'no_rules_intro_default'                => 'Non hai ancora regole. Le regole sono potenti automazioni in grado di gestire le transazioni per te.',
    'no_rules_imperative_default'           => 'Le regole possono essere molto utili quando gestisci le transazioni. Creiamone una:',
    'no_budgets_imperative_default'         => 'I budget sono gli strumenti di base della gestione finanziaria. Creiamone uno ora:',
    'no_budgets_create_default'             => 'Crea budget',
    'no_rules_create_default'               => 'Crea regola',
    'no_categories_title_default'           => 'Creaiamo una categoria!',
    'no_categories_intro_default'           => 'Non hai ancora categorie. Le categorie vengono utilizzate per mettere a punto le transazioni e etichettarle con la categoria designata.',
    'no_categories_imperative_default'      => 'Le categorie vengono create automaticamente quando si creano le transazioni, ma è possibile crearne anche manualmente. Ne creiamo una ora:',
    'no_categories_create_default'          => 'Crea categoria',
    'no_tags_title_default'                 => 'Creiamo una etichetta!',
    'no_tags_intro_default'                 => 'Non hai ancora un etichetta. Le etichette vengono utilizzate per mettere a punto le transazioni e etichettarle con parole chiave specifiche.',
    'no_tags_imperative_default'            => 'Le etichette vengono create automaticamente quando si creano le transazioni, ma è possibile crearne anche manualmente. Creiamo una ora:',
    'no_tags_create_default'                => 'Crea etichetta',
    'no_transactions_title_withdrawal'      => 'Creiamo una spesa!',
    'no_transactions_intro_withdrawal'      => 'Non hai ancora spese. Dovresti creare delle spese per iniziare a gestire le tue finanze.',
    'no_transactions_imperative_withdrawal' => 'Hai effettuato delle spese? Dovresti registrarle:',
    'no_transactions_create_withdrawal'     => 'Crea spese',
    'no_transactions_title_deposit'         => 'Creiamo delle entrate!',
    'no_transactions_intro_deposit'         => 'Non hai ancora delle entrate registrate. Dovresti creare delle voci di entrata per iniziare a gestire le tue finanze.',
    'no_transactions_imperative_deposit'    => 'Hai ricevuto dei soldi? Dovresti scriverlo:',
    'no_transactions_create_deposit'        => 'Crea una entrata',
    'no_transactions_title_transfers'       => 'Creiamo un trasferimento!',
    'no_transactions_intro_transfers'       => 'Non hai ancora trasferimenti. Quando sposti denaro tra i conti attività, viene registrato come trasferimento.',
    'no_transactions_imperative_transfers'  => 'Hai spostato dei soldi in giro? Dovresti scriverlo:',
    'no_transactions_create_transfers'      => 'Crea un trasferimento',
    'no_piggies_title_default'              => 'Creiamo un salvadanaio!',
    'no_piggies_intro_default'              => 'Non hai ancora salvadanai. Puoi creare salvadanai per dividere i tuoi risparmi e tenere traccia di ciò per cui stai risparmiando.',
    'no_piggies_imperative_default'         => 'Hai cose per le quali stai risparmiando? Crea un salvadanaio e tieni traccia:',
    'no_piggies_create_default'             => 'Crea un nuovo salvadanaio',
    'no_bills_title_default'                => 'Creiamo un pagamento ricorrente!',
    'no_bills_intro_default'                => 'Non hai ancora nessun pagamento ricorrente. Puoi creare pagamenti ricorrenti per tenere traccia delle spese regolari, come il tuo affitto o l\'assicurazione.',
    'no_bills_imperative_default'           => 'Hai dei pagamenti ricorrenti? Crea un pagamento ricorrente e tieni traccia dei tuoi pagamenti:',
    'no_bills_create_default'               => 'Crea un pagamento ricorrente',

    // recurring transactions
    'recurrence_max_count'                  => 'Questa transazione ricorrente verrà creata al massimo :max volta(e), ed è già stata creata :count volta(e).',
    'create_right_now'                      => 'Crea adesso',
    'no_new_transaction_in_recurrence'      => 'Nessuna nuova transazione creata. Forse è già sta effettuata per questa data?',
    'recurrences'                           => 'Transazioni ricorrenti',
    'repeat_until_in_past'                  => 'Questa transazione ricorrente ha smesso di ripetersi il :date.',
    'recurring_calendar_view'               => 'Calendario',
    'no_recurring_title_default'            => 'Creiamo una transazione ricorrente!',
    'no_recurring_intro_default'            => 'Non hai ancora una transazione ricorrente. Puoi utilizzare queste per lasciare che Firefly III crei automaticamente le transazioni per te.',
    'no_recurring_imperative_default'       => 'Questa è una caratteristica piuttosto avanzata che può essere estremamente utile. Assicurati di leggere la documentazione (l\'icona (?) nell\'angolo in alto a destra) prima di continuare.',
    'no_recurring_create_default'           => 'Crea una transazione ricorrente',
    'make_new_recurring'                    => 'Crea una transazione ricorrente',
    'recurring_daily'                       => 'Ogni giorno',
    'recurring_weekly'                      => 'Ogni settimana di :weekday',
    'recurring_weekly_skip'                 => 'Ogni :skip° settimana il :weekday',
    'recurring_monthly'                     => 'Ogni mese il giorno :dayOfMonth',
    'recurring_monthly_skip'                => 'Il giorno :dayOfMonth di ogni :skip° mese',
    'recurring_ndom'                        => 'Ogni :dayOfMonth° :weekday del mese',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Ogni anno il :date',
    'overview_for_recurrence'               => 'Panoramica per la transazione ricorrente ":title"',
    'warning_duplicates_repetitions'        => 'In alcuni casi rari è possibile che delle date appaiano due volte in questa lista. Questo può succedere quando ripetizioni multiple collidono. Firefly III si assicurerà sempre di generare una sola transazione per giorno.',
    'created_transactions'                  => 'Transazioni collegate',
    'expected_withdrawals'                  => 'Prelievi previsti',
    'expected_deposits'                     => 'Depositi previsti',
    'expected_transfers'                    => 'Trasferimenti previsti',
    'created_withdrawals'                   => 'Prelievi creati',
    'created_deposits'                      => 'Depositi creati',
    'created_transfers'                     => 'Trasferimenti creati',
    'recurring_info'                        => 'Transazione ricorrente :count / :total',
    'created_from_recurrence'               => 'Creata dalla transazione ricorrente ":title" (#:id)',
    'recurring_never_cron'                  => 'Sembra che il job cron necessario per le transazioni ricorrenti non sia mai stato eseguito. Questo è ovviamente normale quando hai appena installato Firefly III, tuttavia dovrebbe essere impostato il prima possibile. Consulta le pagine di aiuto usando l\'icona (?) nell\'angolo in alto a destra della pagina.',
    'recurring_cron_long_ago'               => 'Sembra che siano passate più di 36 ore dall\'ultima volta che il job cron per le transazioni ricorrenti sia stato lanciato. Sei sicuro che sia stato impostato correttamente? Consulta le pagine di aiuto usando l\'icona (?) nell\'angolo in alto a destra della pagina.',

    'create_new_recurrence'              => 'Crea una nuova transazione ricorrente',
    'help_first_date'                    => 'Indica quando la ricorrenza dovrebbe avvenire per la prima volta. Questo deve essere nel futuro.',
    'help_first_date_no_past'            => 'Indica quando la ricorrenza dovrebbe avvenire per la prima volta. Firefly III non creerà transazioni nel passato.',
    'no_currency'                        => '(nessuna valuta)',
    'mandatory_for_recurring'            => 'Informazioni obbligatorie sulla ricorrenza',
    'mandatory_for_transaction'          => 'Informazioni obbligatorie sulla transazione',
    'optional_for_recurring'             => 'Informazioni facoltative sulla ricorrenza',
    'optional_for_transaction'           => 'Informazioni facoltative sulla transazione',
    'change_date_other_options'          => 'Cambia la "prima volta" per visualizzare maggiori opzioni.',
    'mandatory_fields_for_tranaction'    => 'Il valore qui presente finirà nella transazione che verrà creata',
    'click_for_calendar'                 => 'Clicca qui per visualizzare in un calendario quando la transazione si ripete.',
    'repeat_forever'                     => 'Ripeti per sempre',
    'repeat_until_date'                  => 'Ripeti fino alla data',
    'repeat_times'                       => 'Ripeti per un certo numero di volte',
    'recurring_skips_one'                => 'Una volta sì e una volta no',
    'recurring_skips_more'               => 'Salta per :count volte',
    'store_new_recurrence'               => 'Salva transazione ricorrente',
    'stored_new_recurrence'              => 'La transazione ricorrente ":title" è stata salvata con successo.',
    'edit_recurrence'                    => 'Modifica transazione ricorrente ":title"',
    'recurring_repeats_until'            => 'Si ripete fino al :date',
    'recurring_repeats_forever'          => 'Si ripete per sempre',
    'recurring_repeats_x_times'          => 'Si ripete per :count volta|Si ripete per :count volte',
    'update_recurrence'                  => 'Aggiorna transazione ricorrente',
    'updated_recurrence'                 => 'Transazione ricorrente ":title" aggiornata',
    'recurrence_is_inactive'             => 'Questa transazione ricorrente non è attiva e non genererà nuove transazioni.',
    'delete_recurring'                   => 'Elimina transazione ricorrente ":title"',
    'new_recurring_transaction'          => 'Nuova transazione ricorrente',
    'help_weekend'                       => 'Cosa vuoi che Firefly III faccia quando la transazione ricorrente cade di sabato o domenica?',
    'do_nothing'                         => 'Crea la transazione',
    'skip_transaction'                   => 'Salta l\'occorrenza',
    'jump_to_friday'                     => 'Crea la transazione il venerdì precedente',
    'jump_to_monday'                     => 'Crea la transazione il lunedì successivo',
    'will_jump_friday'                   => 'Verrà creata il venerdì anziché nel fine settimana.',
    'will_jump_monday'                   => 'Verrà creata il lunedì anziché il fine settimana.',
    'except_weekends'                    => 'Tranne il fine settimana',
    'recurrence_deleted'                 => 'La transazione ricorrente ":title" è stata eliminata',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Saldo (:currency)',
    'box_spent_in_currency'              => 'Spesi (:currency)',
    'box_earned_in_currency'             => 'Guadagnati (:currency)',
    'box_budgeted_in_currency'           => 'A budget (:currency)',
    'box_bill_paid_in_currency'          => 'Pagamenti ricorrenti pagati (:currency)',
    'box_bill_unpaid_in_currency'        => 'Pagamenti ricorrenti non pagati (:currency)',
    'box_left_to_spend_in_currency'      => 'Disponibile da spendere (:currency)',
    'box_net_worth_in_currency'          => 'Patrimonio netto (:currency)',
    'box_spend_per_day'                  => 'Disponibile da spendere per giorno: :amount',

    // debug page
    'debug_page'                         => 'Pagina di debug',
    'debug_submit_instructions'          => 'Se incontri problemi, puoi usare le informazioni in questo riquadro come informazioni di debug. Copia-incollale in una nuova o esistente <a href="https://github.com/firefly-iii/firefly-iii/issues">issue di Github</a>. Creerà una bellissima tabella che potrà essere utilizzata per diagnosticare rapidamente il tuo problema.',
    'debug_pretty_table'                 => 'Copia-incollando il riquadro sottostante in una issue di Github verrà creata una tabella. Non circondare questo testo con accenti gravi o virgolette.',
    'debug_additional_data'              => 'Puoi anche condividere il contenuto del riquadro sottostante. È anche possibile copiare e incollare questo in una nuova o esistente <a href="https://github.com/firefly-iii/firefly-iii/issues">issue di GitHub</a>. Tuttavia, il contenuto di questo riquadro può contenere informazioni private come i nomi dei conti, i dettagli delle transazioni o indirizzi e-mail.',

    // object groups
    'object_groups_menu_bar'             => 'Gruppi',
    'object_groups_page_title'           => 'Gruppi',
    'object_groups_breadcrumb'           => 'Gruppi',
    'object_groups_index'                => 'Panoramica',
    'object_groups'                      => 'Gruppi',
    'object_groups_empty_explain'        => 'Alcune cose in Firefly III possono essere divise in gruppi. I salvadanai, per esempio, dispongono di un campo "Gruppo" nelle schermate di modifica e creazione. Quando si imposta questo campo, è possibile modificare i nomi e l\'ordine dei gruppi in questa pagina. Per ulteriori informazioni, consulta le pagine di aiuto nell\'angolo in alto a destra, con l\'icona (?).',
    'object_group_title'                 => 'Titolo',
    'edit_object_group'                  => 'Modifica gruppo ":title"',
    'delete_object_group'                => 'Elimina gruppo ":title"',
    'update_object_group'                => 'Aggiorna gruppo',
    'updated_object_group'               => 'Il gruppo ":title" è stato aggiornato con successo',
    'deleted_object_group'               => 'Il gruppo ":title" è stato eliminato con successo',
    'object_group'                       => 'Gruppo',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Voci del registro di controllo',
    'ale_action_log_add'                 => 'Aggiunto :amount al salvadanaio ":name"',
    'ale_action_log_remove'              => 'Rimosso :amount dal salvadanaio ":name"',
    'ale_action_clear_budget'            => 'Rimosso dal budget',
    'ale_action_update_group_title'      => 'Titolo del gruppo di transazioni aggiornato',
    'ale_action_update_date'             => 'Data della transazione aggiornata',
    'ale_action_update_order'            => 'Ordine di transazione aggiornato',
    'ale_action_clear_category'          => 'Rimossa dalla categoria',
    'ale_action_clear_notes'             => 'Note rimosse',
    'ale_action_clear_tag'               => 'Etichette cancellate',
    'ale_action_clear_all_tags'          => 'Tutte le etichette sono state cancellate',
    'ale_action_set_bill'                => 'Collegato al pagamento ricorrente',
    'ale_action_switch_accounts'         => 'Conto di origine e di destinazione scambiato',
    'ale_action_set_budget'              => 'Imposta un budget',
    'ale_action_set_category'            => 'Imposta una categoria',
    'ale_action_set_source'              => 'Imposta un conto di origine',
    'ale_action_set_destination'         => 'Imposta un beneficiario',
    'ale_action_update_transaction_type' => 'Tipo di transazione modificato',
    'ale_action_update_notes'            => 'Note cambiate',
    'ale_action_update_description'      => 'Modifica descrizione',
    'ale_action_add_to_piggy'            => 'Salvadanaio',
    'ale_action_remove_from_piggy'       => 'Salvadanaio',
    'ale_action_add_tag'                 => 'Etichette aggiunte',
    'ale_action_update_amount'           => 'Importo aggiornato',

    // dashboard
    'enable_auto_convert'                => 'Abilita la conversione della valuta',
    'disable_auto_convert'               => 'Disabilita la conversione della valuta',
];
