<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => '存储在":timezone"',
    'displayed_in_tz'                           => '显示在":timezone"',
    'close'                                     => '关闭',
    'actions'                                   => '操作',
    'edit'                                      => '编辑',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => '交易日志 ID',
    'delete'                                    => '删除',
    'split'                                     => '拆分',
    'single_split'                              => '拆分',
    'clone'                                     => '复制',
    'clone_and_edit'                            => '复制并编辑',
    'confirm_action'                            => '确认操作',
    'last_seven_days'                           => '最近 7 天',
    'last_thirty_days'                          => '最近 30 天',
    'last_180_days'                             => '最近 180 天',
    'month_to_date'                             => '本月至今',
    'year_to_date'                              => '本年至今',
    'YTD'                                       => '本年至今',
    'welcome_back'                              => '今天理财了吗？',
    'main_dashboard_page_title'                 => '首页',
    'everything'                                => '所有',
    'today'                                     => '今天',
    'customRange'                               => '自定义范围',
    'date_range'                                => '日期范围',
    'apply'                                     => '应用',
    'select_date'                               => '选择日期..',
    'cancel'                                    => '取消',
    'from'                                      => '自',
    'to'                                        => '至',
    'structure'                                 => '结构',
    'help_translating'                          => '帮助文本尚未提供您的语言的版本，您愿意<a href="https://crowdin.com/project/firefly-iii-help">协助翻译</a>吗？',
    'showEverything'                            => '全部显示',
    'never'                                     => '永不',
    'no_results_for_empty_search'               => '您的搜索结果为空，找不到任何内容。',
    'removed_amount'                            => '已移除 :amount',
    'added_amount'                              => '已新增 :amount',
    'asset_account_role_help'                   => '基于您的选择而产生的额外选项，均可于事后调整。',
    'Opening balance'                           => '初始余额',
    'create_new_stuff'                          => '创建新内容',
    'new_withdrawal'                            => '新支出',
    'create_new_transaction'                    => '创建新交易',
    'sidebar_frontpage_create'                  => '创建',
    'new_transaction'                           => '新交易',
    'no_rules_for_bill'                         => '此订阅没有相关规则。',
    'go_to_asset_accounts'                      => '查看您的资产账户',
    'go_to_budgets'                             => '前往您的预算',
    'go_to_withdrawals'                         => '前往支出',
    'clones_journal_x'                          => '此交易是“:description” (#:id) 的复制版本',
    'go_to_categories'                          => '前往您的分类',
    'go_to_bills'                               => '前往我的订阅',
    'go_to_expense_accounts'                    => '查看您的支出账户',
    'go_to_revenue_accounts'                    => '查看您的收入账户',
    'go_to_piggies'                             => '前往您的存钱罐',
    'new_deposit'                               => '新收入',
    'new_transfer'                              => '新转账',
    'new_transfers'                             => '新转账',
    'new_asset_account'                         => '新资产账户',
    'new_expense_account'                       => '新支出账户',
    'new_revenue_account'                       => '新收入账户',
    'new_liabilities_account'                   => '新债务账户',
    'new_budget'                                => '新预算',
    'new_bill'                                  => '新订阅',
    'block_account_logout'                      => '您已被强制退出登录，被封禁的帐户无法使用此站点。请确认您使用了有效的电子邮件地址进行注册。',
    'flash_success'                             => '成功！',
    'flash_info'                                => '提示',
    'flash_warning'                             => '警告！',
    'flash_error'                               => '错误！',
    'flash_danger'                              => '危险！',
    'flash_info_multiple'                       => '有1条消息|有:count条消息',
    'flash_error_multiple'                      => '有1个错误|有 :count 个错误',
    'net_worth'                                 => '净资产',
    'help_for_this_page'                        => '本页说明',
    'help_for_this_page_body'                   => '你可以在<a href="https://docs.firefly-iii.org/">文档</a>中找到关于这个页面的更多信息。',
    'two_factor_welcome'                        => '您好！',
    'two_factor_enter_code'                     => '若要继续，请输入您的手机 App 为您生成的两步验证代码。',
    'two_factor_code_here'                      => '在此输入代码',
    'two_factor_title'                          => '两步验证',
    'authenticate'                              => '验证',
    'two_factor_forgot_title'                   => '遗失两步验证',
    'two_factor_forgot'                         => '我忘记了两步验证码',
    'two_factor_lost_header'                    => '遗失了您的两步验证吗？',
    'two_factor_lost_intro'                     => '如果您同时遗失了备用代码，很抱歉，您无法通过网页进行恢复。您可以通过下述方式进行操作。',
    'two_factor_lost_fix_self'                  => '若您自行运行 Firefly III 服务，查看 <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">常见问题解答</a> 来参考',
    'two_factor_lost_fix_owner'                 => '如果这不是您自己的 Firefly III 站点，请邮件联系站点管理员（<a href="mailto::site_owner">:site_owner</a>）协助您重置两步验证。',
    'mfa_backup_code'                           => '您已使用备用代码登录到 Firefly III 。 您不能再使用它，因此请将其划掉。',
    'pref_two_factor_new_backup_codes'          => '获取新的备用代码',
    'pref_two_factor_backup_code_count'         => '您还有 :count 个可用的备用代码|您还有 :count 个可用的备用代码',
    '2fa_i_have_them'                           => '我存下来了！',
    'warning_much_data'                         => ':days 天的数据需要一段时间加载。',
    'registered'                                => '您已成功注册！',
    'Default asset account'                     => '默认资产账户',
    'no_budget_pointer'                         => '您还没有预算，您应该在<a href="budgets">预算页面</a>进行创建。预算可以帮助您追踪支出。',
    'no_bill_pointer'                           => '您似乎还没有订阅。您应该在 <a href="subscriptions">订阅</a>-页面上创建一些。订阅可以帮助您跟踪费用。',
    'Savings account'                           => '储蓄账户',
    'Credit card'                               => '信用卡',
    'source_accounts'                           => '来源账户|来源账户',
    'destination_accounts'                      => '目标账户|目标账户',
    'user_id_is'                                => '您的帐户 ID 为 <strong>:user</strong>',
    'field_supports_markdown'                   => '此字段支持 <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a> 语法。',
    'need_more_help'                            => '如果您在使用 Firefly III 时需要获取更多帮助，请<a href="https://github.com/firefly-iii/firefly-iii/issues">提交 GitHub 工单</a>。',
    'reenable_intro_text'                       => '您也可以重置 <a href="#" id="reenableGuidance">页面引导流程</a>。',
    'intro_boxes_after_refresh'                 => '当您重新整理页面后，介绍框将会重新出现。',
    'show_all_no_filter'                        => '显示所有交易，不以日期分组',
    'expenses_by_category'                      => '按分类的支出',
    'expenses_by_budget'                        => '按预算的支出',
    'income_by_category'                        => '按分类的收入',
    'expenses_by_asset_account'                 => '按资产账户的支出',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Firefly III 无法重新指向您至正确页面，抱歉。',
    'sum_of_expenses'                           => '支出总和',
    'sum_of_income'                             => '收入总和',
    'liabilities'                               => '债务',
    'spent_in_specific_budget'                  => '预算“:budget”的支出',
    'spent_in_specific_double'                  => '账户“:account”的支出',
    'earned_in_specific_double'                 => '“:account” 中的收入',
    'source_account'                            => '来源账户',
    'source_account_reconciliation'             => '您不能编辑对账交易的来源账户。',
    'destination_account'                       => '目标账户',
    'destination_account_reconciliation'        => '您不能编辑对账交易的目标账户',
    'sum_of_expenses_in_budget'                 => '预算“:budget”的总支出',
    'left_in_budget_limit'                      => '依照预算的支出尚余',
    'current_period'                            => '目前区间',
    'show_the_current_period_and_overview'      => '显示目前区间与概览',
    'pref_languages_locale'                     => '若要正常使用英语外的语言，您的操作系统必须配置了正确的区域信息（locale-information）。若上述信息不存在，则货币数据、日期与金额可能出现格式错误。',
    'budget_in_period'                          => ':start – :end 预算“:name” (:currency) 的所有交易',
    'chart_budget_in_period'                    => ':start – :end 预算“:name” (:currency) 的所有交易图表',
    'chart_budget_in_period_only_currency'      => '您的预算金额以 :currency 显示 ，因此此图表将以 :currency 显示交易。',
    'chart_account_in_period'                   => ':start – :end 账户“:name” (:balance) 的所有交易图表',
    'chart_category_in_period'                  => ':start – :end 分类“:name”的所有交易图表',
    'chart_category_all'                        => '分类「:name」的所有交易图表',
    'clone_withdrawal'                          => '复制此支出',
    'clone_deposit'                             => '复制此收入',
    'clone_transfer'                            => '复制此转账',
    'multi_select_no_selection'                 => '未选取',
    'multi_select_select_all'                   => '选取全部',
    'multi_select_n_selected'                   => '选取',
    'multi_select_all_selected'                 => '全部选取',
    'multi_select_filter_placeholder'           => '查找…',
    'intro_next_label'                          => '下一个',
    'intro_prev_label'                          => '上一个',
    'intro_skip_label'                          => '跳过',
    'intro_done_label'                          => '完成',
    'between_dates_breadcrumb'                  => ':start – :end',
    'all_journals_without_budget'               => '没有预算的所有交易',
    'journals_without_budget'                   => '没有预算的交易',
    'all_journals_without_category'             => '没有类别的所有交易',
    'journals_without_category'                 => '没有类别的交易',
    'all_journals_for_account'                  => '账户“:name”的所有交易',
    'chart_all_journals_for_account'            => '账户“:name”的所有交易图表',
    'journals_in_period_for_account'            => ':start – :end 账户“:name”的所有交易',
    'journals_in_period_for_account_js'         => '在 {start} 和 {end} 之间 {title} 账户的所有交易',
    'transferred'                               => '已转账',
    'all_withdrawal'                            => '所有支出',
    'all_transactions'                          => '所有交易',
    'title_withdrawal_between'                  => ':start – :end 的所有支出',
    'all_deposit'                               => '所有收入',
    'title_deposit_between'                     => ':start – :end 的所有收入',
    'all_transfers'                             => '所有转账',
    'title_transfers_between'                   => ':start – :end 的所有转账',
    'all_transfer'                              => '所有转账',
    'all_journals_for_tag'                      => '标签「:tag」的所有交易',
    'title_transfer_between'                    => ':start – :end 的所有转账',
    'all_journals_for_category'                 => '分类 :name 的所有交易',
    'all_journals_for_budget'                   => '预算 :name 的所有交易',
    'chart_all_journals_for_budget'             => '预算 :name 的所有交易图表',
    'journals_in_period_for_category'           => ':start – :end 分类“:name”的所有交易',
    'journals_in_period_for_tag'                => ':start – :end 标签“:tag”的所有交易',
    'not_available_demo_user'                   => '您尝试使用的功能对演示用户不可用。',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => '来源资产账户“@source_name”仅接受 @source_currency 的交易，目标资产账户“@dest_name”仅接受 @dest_currency 的交易，您必须用两方货币来提供正确的已转账总额。',
    'transaction_data'                          => '交易资料',
    'invalid_server_configuration'              => '无效服务器设置',
    'invalid_locale_settings'                   => 'Fifly III 无法格式化货币金额，因为您的服务器缺少所需的软件包。 <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">操作指示</a>',
    'quickswitch'                               => '快速切换',
    'sign_in_to_start'                          => '登录即可开始您的理财规划',
    'sign_in'                                   => '登录',
    'register_new_account'                      => '注册新帐号',
    'forgot_my_password'                        => '忘记密码',
    'problems_with_input'                       => '你的输入有一些问题。',
    'reset_password'                            => '重设密码',
    'button_reset_password'                     => '重设密码',
    'reset_button'                              => '重置',
    'want_to_login'                             => '我想登录',
    'login_page_title'                          => '登录到Firefly III',
    'register_page_title'                       => '在 Firefly III 注册',
    'forgot_pw_page_title'                      => '忘记您 Firefly III 的密码',
    'reset_pw_page_title'                       => '重设您 Firefly III 的密码',
    'cannot_reset_demo_user'                    => '您不能重置演示用户的密码。',
    'no_att_demo_user'                          => '演示用户不能上传附件。',
    'button_register'                           => '注册帐号',
    'authorization'                             => '认证',
    'active_bills_only'                         => '仅活动订阅',
    'active_bills_only_total'                   => '所有活动订阅',
    'active_exp_bills_only'                     => '仅活动和预期的订阅',
    'active_exp_bills_only_total'               => '仅限所有活动的预期订阅',
    'per_period_sum_1D'                         => '预期每日支出',
    'per_period_sum_1W'                         => '预期每周支出',
    'per_period_sum_1M'                         => '预期每月支出',
    'per_period_sum_3M'                         => '预期每季度支出',
    'per_period_sum_6M'                         => '预期每半年支出',
    'per_period_sum_1Y'                         => '预期每年支出',
    'average_per_bill'                          => '平均每个订阅',
    'expected_total'                            => '期望总数',
    'reconciliation_account_name'               => ':name 对账 (:currency)',
    'saved'                                     => '已保存',
    'advanced_options'                          => '高级选项',
    'advanced_options_explain'                  => 'Firefly III 的部分页面将高级选项隐藏于此按钮中。当前页面没有需要额外查看的内容，但请一定要留意其他页面！',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',

    // Webhooks
    'webhooks'                                  => 'Webhooks',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => '已禁用',
    'no_webhook_messages'                       => '没有 Webhook 消息',
    'webhook_trigger_STORE_TRANSACTION'         => '交易创建后',
    'webhook_trigger_UPDATE_TRANSACTION'        => '交易更新后',
    'webhook_trigger_DESTROY_TRANSACTION'       => '交易删除后',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => '交易详情',
    'webhook_response_ACCOUNTS'                 => '账户详情',
    'webhook_response_none_BUDGET'              => 'Budget details',
    'webhook_response_none_NONE'                => '无详细信息',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => '检查',
    'create_new_webhook'                        => '创建新 Webhook',
    'webhooks_create_breadcrumb'                => '创建新 Webhook',
    'webhook_trigger_form_help'                 => '推送事件发生时的触发条件',
    'webhook_response_form_help'                => '推送必须提交给URL的内容',
    'webhook_delivery_form_help'                => '推送采用哪种格式发送数据',
    'webhook_active_form_help'                  => 'Webhook 必须是激活状态，否则不会被调用。',
    'stored_new_webhook'                        => '新的 webhook “:title” 已保存',
    'delete_webhook'                            => '删除 Webhook',
    'deleted_webhook'                           => '已删除 webhook “:title”',
    'edit_webhook'                              => '编辑 webhook “:title”',
    'updated_webhook'                           => '已更新 webhook “:title”',
    'edit_webhook_js'                           => '编辑 webhook “{title}”',
    'show_webhook'                              => 'Webhook “:title”',
    'webhook_was_triggered'                     => '在指定的交易中触发了推送，请等待显示结果',
    'webhook_messages'                          => 'Webhook 消息',
    'view_message'                              => '查看消息',
    'view_attempts'                             => '查看失败的尝试',
    'message_content_title'                     => 'Webhook 消息内容',
    'message_content_help'                      => '这是使用推送发送（或尝试）的消息内容',
    'attempt_content_title'                     => 'Webhook 尝试',
    'attempt_content_help'                      => '这是提交至配置网址的webhook消息的所有失败请求，一段时间后，Firefly III 将停止尝试。',
    'no_attempts'                               => '所有尝试均已成功完成。好极了！',
    'webhook_attempt_at'                        => '尝试于 {moment}',
    'logs'                                      => '日志',
    'response'                                  => '响应',
    'visit_webhook_url'                         => '访问 webhook URL',
    'reset_webhook_secret'                      => '重置 webhook 密钥',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">推送 #{ID} ("{title}")</a> 已保存.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">推送 #{ID}</a> ("{title}") 已更新.',

    // API access
    'authorization_request'                     => 'Firefly III :version 版授权请求',
    'authorization_request_intro'               => '应用 "<strong>:client</strong>" 正在请求权限以访问您的财务管理功能。是否授权 <strong>:client</strong> 访问这些记录？',
    'authorization_request_site'                => '您将被重定向到 <code>:url</code> ，然后就能够访问您的 Firefly III 数据。',
    'authorization_request_invalid'             => '此访问请求无效。请不要再次使用此链接。',
    'scopes_will_be_able'                       => '此应用可以：',
    'button_authorize'                          => '授权',
    'none_in_select_list'                       => '(空)',
    'no_piggy_bank'                             => '(无存钱罐)',
    'name_in_currency'                          => ':name 于 :currency',
    'paid_in_currency'                          => '以 :currency 支付',
    'unpaid_in_currency'                        => '未以 :currency 支付',
    'is_alpha_warning'                          => '您正在运行 ALPHA 版本。请注意错误和问题。',
    'is_beta_warning'                           => '您正在运行 BETA 版本。请注意错误和问题。',
    'all_destination_accounts'                  => '目标账户',
    'all_source_accounts'                       => '来源账户',
    'back_to_index'                             => '返回列表　',
    'cant_logout_guard'                         => 'Firefly III 无法退出登录。',
    'internal_reference'                        => '内部引用',

    // check for updates:
    'update_check_title'                        => '检查更新',
    'admin_update_check_title'                  => '自动检查更新',
    'admin_update_check_explain'                => 'Firefly III 可以自动检查更新。当您启用此设置时，它将与 Firefly III 更新服务器通讯，查看是否有新版本的 Firefly III。当有新版时，您将收到通知。您可以使用右边的按钮测试此通知。请在下面选择您是否希望 Firefly III 检查更新。',
    'check_for_updates_permission'              => 'Firefly III 可检查更新，但此功能需要您的许可。请前往<a href=":link">设置页面</a>确认您是否需要启用此功能。',
    'updates_ask_me_later'                      => '稍后再次询问',
    'updates_do_not_check'                      => '不检查更新',
    'updates_enable_check'                      => '启用检查更新',
    'admin_update_check_now_title'              => '立即检查更新',
    'admin_update_check_now_explain'            => '如果您点击此按钮，Firefly III 将会检查您现在的版本是否为最新版。',
    'check_for_updates_button'                  => '立即检查！',
    'update_new_version_alert'                  => '发现可用的 Firefly III 新版本，您正在运行的版本是 :your_version，最新版本是 :new_version（发布于 :date）。',
    'update_version_beta'                       => '此版本是 BETA 版本。您可能会遇到问题。',
    'update_version_alpha'                      => '此版本是 ALPHA 版本。您可能会遇到问题。',
    'update_current_dev_older'                  => '您正在运行开发版本 ":version", 该版本比最新版本的 :new_version旧。请更新！',
    'update_current_dev_newer'                  => '您正在运行开发版本 ":version", 它比最新版本 :new_version 更新。',
    'update_current_version_alert'              => '您正在运行 :version，这是最新的可用版本。',
    'update_newer_version_alert'                => '您正在运行 :your_version，它比最新发布的 :new_version 更新。',
    'update_check_error'                        => '检查更新时发生错误：:error',
    'unknown_error'                             => '未知错误。抱歉。',
    'disabled_but_check'                        => '您已禁用更新检查。所以请不要忘记手动检查更新。谢谢！',
    'admin_update_channel_title'                => '更新通道',
    'admin_update_channel_explain'              => 'Firefly III 具有三个更新“通道”，其决定了您在功能、改进和错误修正方面的不同体验。如果您喜欢冒险，请使用“beta”通道；如果您不惧危险，请使用“alpha”通道。',
    'update_channel_stable'                     => '稳定版，所有功能可以正常运行',
    'update_channel_beta'                       => 'Beta版，拥有新功能但可能崩溃',
    'update_channel_alpha'                      => 'Alpha版，随时添加新功能，可能出现未知问题',

    // search
    'search'                                    => '搜索',
    'search_query'                              => '搜索语句',
    'search_found_transactions'                 => 'Firefly III 找到 :count 条交易，用时 :time 秒。|Firefly III 找到 :count 条交易，用时 :time 秒。',
    'search_found_more_transactions'            => 'Firefly III 找到超过 :count 条交易，用时 :time 秒。',
    'search_for_overview'                       => 'Firefly III 正在搜索满足以下条件的 <b>所有</b> 交易：',
    'search_for_query'                          => '所有这些字词都必须存在： <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => '所有这些字词都不存在： <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => '搜索参数无效，已忽略。',

    // old


    'search_modifier_date_on'                             => '交易日期为 “:value”',
    'search_modifier_not_date_on'                         => '交易日期不为 “:value”',
    'search_modifier_reconciled'                          => '交易已对账',
    'search_modifier_not_reconciled'                      => '交易未对账',
    'search_modifier_id'                                  => '交易 ID 为 “:value”',
    'search_modifier_not_id'                              => '交易 ID 不为“:value”',
    'search_modifier_date_before'                         => '交易日期为“:value”或之前',
    'search_modifier_date_after'                          => '交易日期为“:value”或之后',
    'search_modifier_external_id_is'                      => '外部 ID 为“:value”',
    'search_modifier_not_external_id_is'                  => '外部 ID 不为“:value”',
    'search_modifier_no_external_url'                     => '交易没有外部链接',
    'search_modifier_no_external_id'                      => '交易没有外部ID',
    'search_modifier_not_any_external_url'                => '交易没有外部链接',
    'search_modifier_not_any_external_id'                 => '交易没有外部ID',
    'search_modifier_any_external_url'                    => '交易必须有一个（或任意多个）外部链接',
    'search_modifier_any_external_id'                     => '交易必须有一个（或任意多个）外部ID',
    'search_modifier_not_no_external_url'                 => '交易必须有一个（或任意多个）外部链接',
    'search_modifier_not_no_external_id'                  => '交易必须有一个（或任意多个）外部ID',
    'search_modifier_internal_reference_is'               => '内部引用为“:value”',
    'search_modifier_not_internal_reference_is'           => '内部引用不为“:value”',
    'search_modifier_description_starts'                  => '描述开头为“:value”',
    'search_modifier_not_description_starts'              => '描述开头不为“:value”',
    'search_modifier_description_ends'                    => '描述结尾为“:value”',
    'search_modifier_not_description_ends'                => '描述结尾不为“:value”',
    'search_modifier_description_contains'                => '描述包含“:value”',
    'search_modifier_not_description_contains'            => '描述不包含“:value”',
    'search_modifier_description_is'                      => '描述为“:value”',
    'search_modifier_not_description_is'                  => '描述不为 ":value"',
    'search_modifier_currency_is'                         => '交易 (外币) 货币为“:value”',
    'search_modifier_not_currency_is'                     => '交易 (外币) 货币不为“:value”',
    'search_modifier_foreign_currency_is'                 => '交易外币为“:value”',
    'search_modifier_not_foreign_currency_is'             => '交易外币不为“:value”',
    'search_modifier_has_attachments'                     => '交易必须有附件',
    'search_modifier_has_no_category'                     => '交易不能有分类',
    'search_modifier_not_has_no_category'                 => '交易必须有一个（或任意多个）分类',
    'search_modifier_not_has_any_category'                => '交易必须没有分类',
    'search_modifier_has_any_category'                    => '交易必须有分类',
    'search_modifier_has_no_budget'                       => '交易不能有预算',
    'search_modifier_not_has_any_budget'                  => '交易必须不存在预算',
    'search_modifier_has_any_budget'                      => '交易必须有预算',
    'search_modifier_not_has_no_budget'                   => '交易必须有一个（或任意多个）预算',
    'search_modifier_has_no_bill'                         => '交易必须没有订阅',
    'search_modifier_not_has_no_bill'                     => '交易必须有一个(任何)订阅',
    'search_modifier_has_any_bill'                        => '交易必须有一个(任何)订阅',
    'search_modifier_not_has_any_bill'                    => '交易必须没有订阅',
    'search_modifier_has_no_tag'                          => '交易不能有标签',
    'search_modifier_not_has_any_tag'                     => '交易必须没有标签',
    'search_modifier_not_has_no_tag'                      => '交易必须有一个（或任意多个）标签',
    'search_modifier_has_any_tag'                         => '交易必须有标签',
    'search_modifier_notes_contains'                      => '交易备注包含“:value”',
    'search_modifier_not_notes_contains'                  => '交易备注不包含“:value”',
    'search_modifier_notes_starts'                        => '交易备注开头为“:value”',
    'search_modifier_not_notes_starts'                    => '交易备注开头不含":value"',
    'search_modifier_notes_ends'                          => '交易备注结尾包含":value"',
    'search_modifier_not_notes_ends'                      => '交易备注结尾不含":value"',
    'search_modifier_notes_is'                            => '交易备注是":value"',
    'search_modifier_not_notes_is'                        => '交易备注不是":value"',
    'search_modifier_no_notes'                            => '交易备注为空',
    'search_modifier_not_no_notes'                        => '交易必须填写备注',
    'search_modifier_any_notes'                           => '交易备注不为空',
    'search_modifier_not_any_notes'                       => '交易没有备注',
    'search_modifier_amount_is'                           => '金额为 :value',
    'search_modifier_not_amount_is'                       => '金额不是 :value',
    'search_modifier_amount_less'                         => '金额小于或等于:value',
    'search_modifier_not_amount_more'                     => '金额小于或等于:value',
    'search_modifier_amount_more'                         => '金额大于或等于:value',
    'search_modifier_not_amount_less'                     => '金额大于或等于:value',
    'search_modifier_source_account_is'                   => '来源账户名称为“:value”',
    'search_modifier_not_source_account_is'               => '来源账户名称不为“:value”',
    'search_modifier_source_account_contains'             => '来源账户名称包含“:value”',
    'search_modifier_not_source_account_contains'         => '来源账户名称不包含“:value”',
    'search_modifier_source_account_starts'               => '来源账户名称开头为“:value”',
    'search_modifier_not_source_account_starts'           => '来源帐户名称不以 ":value 开头的',
    'search_modifier_source_account_ends'                 => '来源账户名称结尾为“:value”',
    'search_modifier_not_source_account_ends'             => '来源帐户名称不以":value" 结尾的',
    'search_modifier_source_account_id'                   => '来源账户 ID 为 :value',
    'search_modifier_not_source_account_id'               => '来源账户 ID 不为 :value',
    'search_modifier_source_account_nr_is'                => '来源账户编号 (IBAN) 为“:value”',
    'search_modifier_not_source_account_nr_is'            => '来源账户编号 (IBAN) 不为“:value”',
    'search_modifier_source_account_nr_contains'          => '来源账户编号 (IBAN) 包含“:value”',
    'search_modifier_not_source_account_nr_contains'      => '来源账户编号 (IBAN) 不包含“:value”',
    'search_modifier_source_account_nr_starts'            => '来源账户编号 (IBAN) 开头为“:value”',
    'search_modifier_not_source_account_nr_starts'        => '来源账户编号 (IBAN) 不以“:value”开头的',
    'search_modifier_source_account_nr_ends'              => '来源账户编号 (IBAN) 以“:value”结尾的',
    'search_modifier_not_source_account_nr_ends'          => '来源账户编号 (IBAN) 不以“:value”结尾的',
    'search_modifier_destination_account_is'              => '目标账户名称为“:value”',
    'search_modifier_not_destination_account_is'          => '目标帐户名称不是 ":value"',
    'search_modifier_destination_account_contains'        => '目标账户名称包含“:value”',
    'search_modifier_not_destination_account_contains'    => '目标帐户名称不包含 ":value"',
    'search_modifier_destination_account_starts'          => '目标账户名称开头为“:value”',
    'search_modifier_not_destination_account_starts'      => '目标帐户名称不是以 ":value 开头的',
    'search_modifier_destination_account_ends'            => '目标帐户名称以 ":value" 结束',
    'search_modifier_not_destination_account_ends'        => '目标帐户名称不是以 ":value 结束的',
    'search_modifier_destination_account_id'              => '目标账户 ID 为 :value',
    'search_modifier_not_destination_account_id'          => '目标帐户 ID 不是 :value',
    'search_modifier_destination_is_cash'                 => '目标账户为 (现金) 账户',
    'search_modifier_not_destination_is_cash'             => '目标帐户不是"(现金)"帐户',
    'search_modifier_source_is_cash'                      => '来源账户为 (现金) 账户',
    'search_modifier_not_source_is_cash'                  => '来源账户不是 (现金) 账户',
    'search_modifier_destination_account_nr_is'           => '目标账户编号 (IBAN) 为“:value”',
    'search_modifier_not_destination_account_nr_is'       => '目标账户编号 (IBAN) 为“:value”',
    'search_modifier_destination_account_nr_contains'     => '目标账户编号 (IBAN) 包含“:value”',
    'search_modifier_not_destination_account_nr_contains' => '目标帐户号 (IBAN) 不包含明确的 ":value"',
    'search_modifier_destination_account_nr_starts'       => '目标账户编号 (IBAN) 开头为“:value”',
    'search_modifier_not_destination_account_nr_starts'   => '目标账户编号 (IBAN) 不以“:value”开头的',
    'search_modifier_destination_account_nr_ends'         => '目标账户编号 (IBAN) 结尾为“:value”',
    'search_modifier_not_destination_account_nr_ends'     => '目标账户编号 (IBAN) 不以“:value”结尾的',
    'search_modifier_account_id'                          => '来源或/和目标账户 ID 为：:value',
    'search_modifier_not_account_id'                      => '来源账户或目标账户 ID 不是: :value',
    'search_modifier_category_is'                         => '分类是“:value”',
    'search_modifier_not_category_is'                     => '分类不为“:value”',
    'search_modifier_budget_is'                           => '预算是“:value”',
    'search_modifier_not_budget_is'                       => '预算不为 “:value"',
    'search_modifier_bill_is'                             => '订阅是 ":value"',
    'search_modifier_not_bill_is'                         => '订阅不是":value"',
    'search_modifier_transaction_type'                    => '交易类型是“:value”',
    'search_modifier_not_transaction_type'                => '交易类型不为“:value”',
    'search_modifier_tag_is'                              => '标签是“:value”',
    'search_modifier_tag_contains'                        => '标签包含":value"',
    'search_modifier_not_tag_contains'                    => '标签不包含 ":value"',
    'search_modifier_tag_ends'                            => '标注以 ":value " 结束',
    'search_modifier_tag_starts'                          => '标签以“:value”开始',
    'search_modifier_not_tag_is'                          => '标签不为":value"',
    'search_modifier_date_on_year'                        => '交易年份是 ":value"',
    'search_modifier_not_date_on_year'                    => '交易年份不是 ":value"',
    'search_modifier_date_on_month'                       => '交易月份是 ":value"',
    'search_modifier_not_date_on_month'                   => '交易月份不是 ":value"',
    'search_modifier_date_on_day'                         => '交易在月份中的日期 ":value"',
    'search_modifier_not_date_on_day'                     => '交易不在月中的日期 ":value"',
    'search_modifier_date_before_year'                    => '交易是在之前或当前的年份 “:value”',
    'search_modifier_date_before_month'                   => '交易是在之前或当前的月份 “:value”',
    'search_modifier_date_before_day'                     => '交易为月中第“:value”天或之前',
    'search_modifier_date_after_year'                     => '交易在年内或年后“:value”',
    'search_modifier_date_after_month'                    => '交易在月内或月后“:value”',
    'search_modifier_date_after_day'                      => '交易为月中第“:value”天或之后',

    // new
    'search_modifier_tag_is_not'                          => '没有标签是 ":value"',
    'search_modifier_not_tag_is_not'                      => '标签是“:value”',
    'search_modifier_account_is'                          => '其中一个账户为":value"',
    'search_modifier_not_account_is'                      => '两个帐户都不是 ":value"',
    'search_modifier_account_contains'                    => '其中一个账户包含":value"',
    'search_modifier_not_account_contains'                => '两个帐户都不包含 ":value"',
    'search_modifier_account_ends'                        => '其中一个账户结尾为 ":value"',
    'search_modifier_not_account_ends'                    => '两个账户的结尾都不是":value"',
    'search_modifier_account_starts'                      => '其中一个账户开头为":value"',
    'search_modifier_not_account_starts'                  => '两个账户的开头都不是":value"',
    'search_modifier_account_nr_is'                       => '其中一个账户编号/IBAN为":value"',
    'search_modifier_not_account_nr_is'                   => '两个账户的编号/IBAN都不是":value"',
    'search_modifier_account_nr_contains'                 => '其中一个账户编号/IBAN包含":value"',
    'search_modifier_not_account_nr_contains'             => '两个账户的编号/IBAN都不包含":value"',
    'search_modifier_account_nr_ends'                     => '其中一个账户编号/IBAN结尾为":value"',
    'search_modifier_not_account_nr_ends'                 => '两个账户的编号/IBAN结尾都不是":value"',
    'search_modifier_account_nr_starts'                   => '其中一个账户编号/IBAN开头为":value"',
    'search_modifier_not_account_nr_starts'               => '两个账户的编号/IBAN开头都不是":value"',
    'search_modifier_category_contains'                   => '分类包含":value"',
    'search_modifier_not_category_contains'               => '分类不包含":value"',
    'search_modifier_category_ends'                       => '分类结尾为“:value”',
    'search_modifier_not_category_ends'                   => '分类结尾不为":value"',
    'search_modifier_category_starts'                     => '分类开头为":value"',
    'search_modifier_not_category_starts'                 => '分类开头不为":value"',
    'search_modifier_budget_contains'                     => '预算包含":value"',
    'search_modifier_not_budget_contains'                 => '预算不包含":value"',
    'search_modifier_budget_ends'                         => '预算结尾为":value"',
    'search_modifier_not_budget_ends'                     => '预算结尾不为":value"',
    'search_modifier_budget_starts'                       => '预算开头为":value"',
    'search_modifier_not_budget_starts'                   => '预算开头不为":value"',
    'search_modifier_bill_contains'                       => '订阅包含":value"',
    'search_modifier_not_bill_contains'                   => '订阅不包含 ":value"',
    'search_modifier_bill_ends'                           => '订阅结束于 ":value"',
    'search_modifier_not_bill_ends'                       => '订阅不在 ":value " 结束',
    'search_modifier_bill_starts'                         => '订阅开始于 ":value"',
    'search_modifier_not_bill_starts'                     => '订阅不以 ":value " 开始',
    'search_modifier_external_id_contains'                => '外部ID包含 ":value"',
    'search_modifier_not_external_id_contains'            => '外部ID不包含 ":value"',
    'search_modifier_external_id_ends'                    => '外部ID结尾是 ":value"',
    'search_modifier_not_external_id_ends'                => '外部ID结尾不是 ":value"',
    'search_modifier_external_id_starts'                  => '外部ID开头是 ":value"',
    'search_modifier_not_external_id_starts'              => '外部ID开头不是 ":value"',
    'search_modifier_internal_reference_contains'         => '内部引用包含":value"',
    'search_modifier_not_internal_reference_contains'     => '内部引用不含":value"',
    'search_modifier_internal_reference_ends'             => '内部引用结尾为":value"',
    'search_modifier_internal_reference_starts'           => '内部引用开头为":value"',
    'search_modifier_not_internal_reference_ends'         => '内部引用结尾不为":value"',
    'search_modifier_not_internal_reference_starts'       => '内部引用开头不为":value"',
    'search_modifier_external_url_is'                     => '外部URL是“:value”',
    'search_modifier_not_external_url_is'                 => '外部URL不是 ":value"',
    'search_modifier_external_url_contains'               => '外部URL包含 ":value"',
    'search_modifier_not_external_url_contains'           => '外部URL不包含 ":value"',
    'search_modifier_external_url_ends'                   => '外部URL以“:value”结尾。',
    'search_modifier_not_external_url_ends'               => '外部 URL 不以 ":value 结尾。',
    'search_modifier_external_url_starts'                 => '外部 URL 始于“:value”',
    'search_modifier_not_external_url_starts'             => '外部 URL 不是以 ":value 开头的',
    'search_modifier_has_no_attachments'                  => '交易没有附件',
    'search_modifier_not_has_no_attachments'              => '交易包含附件',
    'search_modifier_not_has_attachments'                 => '交易没有附件',
    'search_modifier_account_is_cash'                     => '其中一个账户为现金账户',
    'search_modifier_not_account_is_cash'                 => '两个账户都不是现金账户',
    'search_modifier_journal_id'                          => '日志ID是":value"',
    'search_modifier_not_journal_id'                      => '日志ID不是":value"',
    'search_modifier_recurrence_id'                       => '定期交易ID为":value"',
    'search_modifier_not_recurrence_id'                   => '定期交易ID不为":value"',
    'search_modifier_foreign_amount_is'                   => '外币金额为“:value”',
    'search_modifier_not_foreign_amount_is'               => '外币不是“:value”',
    'search_modifier_foreign_amount_less'                 => '外币金额小于“:value”',
    'search_modifier_not_foreign_amount_more'             => '外币金额小于“:value”',
    'search_modifier_not_foreign_amount_less'             => '外币金额大于“:value”',
    'search_modifier_foreign_amount_more'                 => '外币金额大于“:value”',
    'search_modifier_exists'                              => '交易已存在 (任何交易)',
    'search_modifier_not_exists'                          => '交易不存在(没有交易)',

    // date fields
    'search_modifier_interest_date_on'                    => '交易的利息日期为 ":value"',
    'search_modifier_not_interest_date_on'                => '交易利息日期不为“:value”',
    'search_modifier_interest_date_on_year'               => '交易利息日期的年份为“:value”',
    'search_modifier_not_interest_date_on_year'           => '交易利息日期的年份不为“:value”',
    'search_modifier_interest_date_on_month'              => '交易利息日期的月份为“:value”',
    'search_modifier_not_interest_date_on_month'          => '交易利息日期的月份不为“:value”',
    'search_modifier_interest_date_on_day'                => '交易利息日期为月中第“:value”天',
    'search_modifier_not_interest_date_on_day'            => '交易利息日期不为月中第“:value”天',
    'search_modifier_interest_date_before_year'           => '交易利息日期的年份为当前或之前：“:value”',
    'search_modifier_interest_date_before_month'          => '交易利息日期的月份为“:value”或之前',
    'search_modifier_interest_date_before_day'            => '交易利息的日期为月中第“:value”天或之前',
    'search_modifier_interest_date_after_year'            => '交易利息日期的年份为“:value”或之后',
    'search_modifier_interest_date_after_month'           => '交易利息日期的月份为“:value”或之后',
    'search_modifier_interest_date_after_day'             => '交易利息的日期为月中第“:value”天或之后',
    'search_modifier_book_date_on_year'                   => '交易登记日期的年份为“:value”',
    'search_modifier_book_date_on_month'                  => '交易登记日期的月份为“:value”',
    'search_modifier_book_date_on_day'                    => '交易登记日期为月中第“:value”天',
    'search_modifier_not_book_date_on_year'               => '交易登记日期的年份不为“:value”',
    'search_modifier_not_book_date_on_month'              => '交易登记日期的月份不为“:value”',
    'search_modifier_not_book_date_on_day'                => '交易登记日期不为月中第“:value”天',
    'search_modifier_book_date_before_year'               => '交易登记日期的年份为“:value”或之前',
    'search_modifier_book_date_before_month'              => '交易登记日期的月份为“:value”或之前',
    'search_modifier_book_date_before_day'                => '交易登记日期为月中第“:value”天或之前',
    'search_modifier_book_date_after_year'                => '交易登记日期的年份为“:value”或之后',
    'search_modifier_book_date_after_month'               => '交易登记日期的月份为“:value”或之后',
    'search_modifier_book_date_after_day'                 => '交易登记日期为月中第“:value”天或之后',
    'search_modifier_process_date_on_year'                => '交易处理日期的年份为“:value”',
    'search_modifier_process_date_on_month'               => '交易处理日期的月份为“:value”',
    'search_modifier_process_date_on_day'                 => '交易处理日期为月中第“:value”天',
    'search_modifier_not_process_date_on_year'            => '交易处理日期的年份不为“:value”',
    'search_modifier_not_process_date_on_month'           => '交易处理日期的月份不为“:value”',
    'search_modifier_not_process_date_on_day'             => '交易处理日期不为月中第“:value”天',
    'search_modifier_process_date_before_year'            => '交易处理日期的年份为“:value”或之前',
    'search_modifier_process_date_before_month'           => '交易处理日期的月份为“:value”或之前',
    'search_modifier_process_date_before_day'             => '交易处理日期为月中第“:value”天或之前',
    'search_modifier_process_date_after_year'             => '交易处理日期的年份为“:value”或之后',
    'search_modifier_process_date_after_month'            => '交易处理日期的月份为“:value”或之后',
    'search_modifier_process_date_after_day'              => '交易处理日期为月中第“:value”天或之后',
    'search_modifier_due_date_on_year'                    => '交易截止日期的年份为“:value”',
    'search_modifier_due_date_on_month'                   => '交易截止日期的月份为“:value”',
    'search_modifier_due_date_on_day'                     => '交易截止日期为月中第“:value”天',
    'search_modifier_not_due_date_on_year'                => '交易截止日期的年份不为“:value”',
    'search_modifier_not_due_date_on_month'               => '交易截止日期的月份不为“:value”',
    'search_modifier_not_due_date_on_day'                 => '交易截止日期不为月中第“:value”天',
    'search_modifier_due_date_before_year'                => '交易截止日期的年份为“:value”或之前',
    'search_modifier_due_date_before_month'               => '交易截止日期的月份为“:value”或之前',
    'search_modifier_due_date_before_day'                 => '交易截止日期为月中第“:value”天或之前',
    'search_modifier_due_date_after_year'                 => '交易截止日期的年份为“:value”或之后',
    'search_modifier_due_date_after_month'                => '交易截止日期的月份为“:value”或之后',
    'search_modifier_due_date_after_day'                  => '交易截止日期为月中第“:value”天或之后',
    'search_modifier_payment_date_on_year'                => '交易付款日期的年份为“:value”',
    'search_modifier_payment_date_on_month'               => '交易付款日期的月份为“:value”',
    'search_modifier_payment_date_on_day'                 => '交易付款日期为月中第“:value”天',
    'search_modifier_not_payment_date_on_year'            => '交易付款日期的年份不为“:value”',
    'search_modifier_not_payment_date_on_month'           => '交易付款日期的月份不为“:value”',
    'search_modifier_not_payment_date_on_day'             => '交易付款日期不为月中第“:value”天',
    'search_modifier_payment_date_before_year'            => '交易付款日期的年份为“:value”或之前',
    'search_modifier_payment_date_before_month'           => '交易付款日期的月份为“:value”或之前',
    'search_modifier_payment_date_before_day'             => '交易付款日期为月中第“:value”天或之前',
    'search_modifier_payment_date_after_year'             => '交易付款日期的年份为“:value”或之后',
    'search_modifier_payment_date_after_month'            => '交易付款日期的月份为“:value”或之后',
    'search_modifier_payment_date_after_day'              => '交易付款日期为月中第“:value”天或之后',
    'search_modifier_invoice_date_on_year'                => '交易发票日期的年份为":value"',
    'search_modifier_invoice_date_on_month'               => '交易发票日期的月份为":value"',
    'search_modifier_invoice_date_on_day'                 => '交易发票日期为月中第“:value”天',
    'search_modifier_not_invoice_date_on_year'            => '交易发票日期的年份不为“:value”',
    'search_modifier_not_invoice_date_on_month'           => '交易发票日期的月份不为“:value”',
    'search_modifier_not_invoice_date_on_day'             => '交易发票日期不为月中第“:value”天',
    'search_modifier_invoice_date_before_year'            => '交易发票日期的年份为“:value”或之前',
    'search_modifier_invoice_date_before_month'           => '交易发票日期的月份为“:value”或之前',
    'search_modifier_invoice_date_before_day'             => '交易发票日期为月中第“:value”天或之前',
    'search_modifier_invoice_date_after_year'             => '交易发票日期的年份为“:value”或之后',
    'search_modifier_invoice_date_after_month'            => '交易发票日期的月份为“:value”或之后',
    'search_modifier_invoice_date_after_day'              => '交易发票日期为月中第“:value”天或之后',
    // other dates
    'search_modifier_updated_at_on_year'                  => '交易上次更新的年份为“:value”',
    'search_modifier_updated_at_on_month'                 => '交易上次更新的月份为“:value”',
    'search_modifier_updated_at_on_day'                   => '交易上次更新为月中第“:value”天',
    'search_modifier_not_updated_at_on_year'              => '交易上次更新的年份不为“:value”',
    'search_modifier_not_updated_at_on_month'             => '交易上次更新的月份不为“:value”',
    'search_modifier_not_updated_at_on_day'               => '交易上次更新不为月中第“:value”天',
    'search_modifier_updated_at_before_year'              => '交易上次更新的年份为“:value”或之前',
    'search_modifier_updated_at_before_month'             => '交易上次更新的月份为“:value”或之前',
    'search_modifier_updated_at_before_day'               => '交易上次更新为月中第“:value”天或之前',
    'search_modifier_updated_at_after_year'               => '交易上次更新的年份为“:value”或之后',
    'search_modifier_updated_at_after_month'              => '交易上次更新的月份为“:value”或之后',
    'search_modifier_updated_at_after_day'                => '交易上次更新为月中第“:value”天或之后',
    'search_modifier_created_at_on_year'                  => '交易创建的年份为“:value”',
    'search_modifier_created_at_on_month'                 => '交易创建的月份为“:value”',
    'search_modifier_created_at_on_day'                   => '交易创建为月中第“:value”天',
    'search_modifier_not_created_at_on_year'              => '交易创建的年份不为“:value”',
    'search_modifier_not_created_at_on_month'             => '交易创建的月份不为“:value”',
    'search_modifier_not_created_at_on_day'               => '交易创建不为月中第“:value”天',
    'search_modifier_created_at_before_year'              => '交易创建的年份为“:value”或之前',
    'search_modifier_created_at_before_month'             => '交易创建的月份为“:value”或之前',
    'search_modifier_created_at_before_day'               => '交易创建为月中第“:value”天或之前',
    'search_modifier_created_at_after_year'               => '交易创建的年份为“:value”或之后',
    'search_modifier_created_at_after_month'              => '交易创建的月份为“:value”或之后',
    'search_modifier_created_at_after_day'                => '交易创建为月中第“:value”天或之后',
    'search_modifier_interest_date_before'                => '交易利息日期为“:value”或之前',
    'search_modifier_interest_date_after'                 => '交易利息日期为“:value”或之后',
    'search_modifier_book_date_on'                        => '交易登记日期为“:value”',
    'search_modifier_not_book_date_on'                    => '交易登记日期不为“:value”',
    'search_modifier_book_date_before'                    => '交易登记日期为“:value”或之前',
    'search_modifier_book_date_after'                     => '交易登记日期为“:value”或之后',
    'search_modifier_process_date_on'                     => '交易处理日期为“:value”',
    'search_modifier_not_process_date_on'                 => '交易处理日期不为“:value”',
    'search_modifier_process_date_before'                 => '交易处理日期为“:value”或之前',
    'search_modifier_process_date_after'                  => '交易处理日期为“:value”或之后',
    'search_modifier_due_date_on'                         => '交易截止日期为“:value”',
    'search_modifier_not_due_date_on'                     => '交易截止日期不为“:value”',
    'search_modifier_due_date_before'                     => '交易截止日期为“:value”或之前',
    'search_modifier_due_date_after'                      => '交易截止日期为“:value”或之后',
    'search_modifier_payment_date_on'                     => '交易付款日期为“:value”',
    'search_modifier_not_payment_date_on'                 => '交易付款日期不为“:value”',
    'search_modifier_payment_date_before'                 => '交易付款日期为“:value”或之前',
    'search_modifier_payment_date_after'                  => '交易付款日期为“:value”或之后',
    'search_modifier_invoice_date_on'                     => '交易发票日期为：“:value”',
    'search_modifier_not_invoice_date_on'                 => '交易发票日期不为：“:value”',
    'search_modifier_invoice_date_before'                 => '交易发票日期为“:value”或之前',
    'search_modifier_invoice_date_after'                  => '交易发票日期为“:value”或之后',
    'search_modifier_created_at_on'                       => '交易创建于":value"',
    'search_modifier_not_created_at_on'                   => '交易不是创建于“:value”',
    'search_modifier_created_at_before'                   => '交易创建于“:value”或之前',
    'search_modifier_created_at_after'                    => '交易创建于“:value”或之后',
    'search_modifier_updated_at_on'                       => '交易更新于“:value”',
    'search_modifier_not_updated_at_on'                   => '交易不是更新于“:value”',
    'search_modifier_updated_at_before'                   => '交易不是更新于“:value”或之前',
    'search_modifier_updated_at_after'                    => '交易不是更新于“:value”或之后',

    'search_modifier_attachment_name_is'            => '任意一个附件名称为":value"',
    'search_modifier_attachment_name_contains'      => '任何附件的名称包含":value"',
    'search_modifier_attachment_name_starts'        => '任何附件的名称开头为":value"',
    'search_modifier_attachment_name_ends'          => '任何附件的名称结尾为":value"',
    'search_modifier_attachment_notes_are'          => '任意一个附件的备注是“:value”',
    'search_modifier_attachment_notes_contains'     => '任意一个附件的备注不是“:value”',
    'search_modifier_attachment_notes_starts'       => '任一附件的备注开头为“:value”',
    'search_modifier_attachment_notes_ends'         => '任一附件的结尾为“:value”',
    'search_modifier_not_attachment_name_is'        => '任一附件的名称不为“:value”',
    'search_modifier_not_attachment_name_contains'  => '任一附件的名称不包含“:value”',
    'search_modifier_not_attachment_name_starts'    => '任一附件的名称开头不为“:value”',
    'search_modifier_not_attachment_name_ends'      => '任一附件的名称结尾不为“:value”',
    'search_modifier_not_attachment_notes_are'      => '任一附件的备注不为“:value”',
    'search_modifier_not_attachment_notes_contains' => '任一附件的备注不包含“:value”',
    'search_modifier_not_attachment_notes_starts'   => '任一附件的备注开头为“:value”',
    'search_modifier_not_attachment_notes_ends'     => '任一附件的结尾不为“:value”',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT是“:value”',
    'update_rule_from_query'                        => '从搜索语句更新规则“:rule”',
    'create_rule_from_query'                        => '从搜索语句创建新规则',
    'rule_from_search_words'                        => '规则引擎无法处理“:string”。符合搜索语句的建议规则可能会给出不同的结果，请仔细确认规则触发条件。',

    // more new stuff
    'search_modifier_destination_balance_is'        => '目标帐户余额正是“:value”',
    'search_modifier_not_destination_balance_is'    => '目标帐户余额不是正确的":value"',
    'search_modifier_source_balance_is'             => '源账户余额正好是“:value”',
    'search_modifier_not_source_balance_is'         => '源账户余额不是正确的":value"',

    'search_modifier_destination_balance_lte'     => '目标帐户余额小于或等于 ":value"',
    'search_modifier_not_destination_balance_lte' => '目标帐户余额大于 ":value"',
    'search_modifier_source_balance_lte'          => '源账户余额小于或等于 ":value"',
    'search_modifier_not_source_balance_lte'      => '源账户余额大于 ":value"',

    'search_modifier_destination_balance_lt'     => '目标帐户余额小于":value"',
    'search_modifier_not_destination_balance_lt' => '目标帐户余额大于或等于 ":value"',
    'search_modifier_source_balance_lt'          => '源账户余额小于":value"',
    'search_modifier_not_source_balance_lt'      => '源账户余额大于或等于 ":value"',

    'search_modifier_destination_balance_gte'     => '目标帐户余额大于或等于 ":value"',
    'search_modifier_not_destination_balance_gte' => '目标帐户余额小于":value"',
    'search_modifier_source_balance_gte'          => '源账户余额大于或等于 ":value"',
    'search_modifier_not_source_balance_gte'      => '源账户余额小于":value"',

    'search_modifier_destination_balance_gt'              => '目标帐户余额大于 ":value"',
    'search_modifier_not_destination_balance_gt'          => '目标帐户余额小于或等于 ":value"',
    'search_modifier_source_balance_gt'                   => '源账户余额大于 ":value"',
    'search_modifier_not_source_balance_gt'               => '源账户余额小于或等于 ":value"',


    // END
    'general_search_error'                                => '搜索时出错。请检查日志文件以获取更多信息。',
    'search_box'                                          => '搜索',
    'search_box_intro'                                    => '欢迎来到 Firefly III 的搜索功能。在搜索框内输入您的查询内容。由于搜索为高级功能，<a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">请确保您已阅读过帮助文件</a>。',
    'search_error'                                        => '搜索时出现错误',
    'search_searching'                                    => '正在搜索...',
    'search_results'                                      => '搜索结果',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => '每年',
    'repeat_freq_half-year'                               => '每半年',
    'repeat_freq_quarterly'                               => '每季',
    'repeat_freq_monthly'                                 => '每月',
    'repeat_freq_weekly'                                  => '每周',
    'repeat_freq_daily'                                   => '每天',
    'daily'                                               => '每天',
    'weekly'                                              => '每周',
    'quarterly'                                           => '每季',
    'half-year'                                           => '每半年',
    'yearly'                                              => '每年',

    // rules
    'is_not_rule_trigger'                                 => '相反',
    'cannot_fire_inactive_rules'                          => '您不能执行已停用的规则。',
    'show_triggers'                                       => '显示触发器',
    'show_actions'                                        => '显示动作',
    'rules'                                               => '规则',
    'rule_name'                                           => '规则名称',
    'rule_triggers'                                       => '规则触发于',
    'rule_actions'                                        => '规则将执行',
    'new_rule'                                            => '新规则',
    'new_rule_group'                                      => '新规则组',
    'rule_priority_up'                                    => '赋予规则更高优先次序',
    'rule_priority_down'                                  => '赋予规则更低优先次序',
    'make_new_rule_group'                                 => '创建新规则组',
    'store_new_rule_group'                                => '保存新规则组',
    'created_new_rule_group'                              => '新规则组“:title”已保存！',
    'updated_rule_group'                                  => '成功更新“:title”规则组',
    'edit_rule_group'                                     => '编辑“:title”规则组',
    'duplicate_rule'                                      => '复制规则“:title”',
    'rule_copy_of'                                        => ':title 副本',
    'duplicated_rule'                                     => '已复制规则“:title”为“:newTitle”',
    'delete_rule_group'                                   => '删除“:title”规则组',
    'deleted_rule_group'                                  => '已删除规则组“:title”',
    'update_rule_group'                                   => '更新规则组',
    'no_rules_in_group'                                   => '此群组内没有规则',
    'move_rule_group_up'                                  => '向上移动规则组',
    'move_rule_group_down'                                => '向下移动规则组',
    'save_rules_by_moving'                                => '将此规则移动到另一个规则组并保存：|将这些规则移动到另一个规则组并保存：',
    'make_new_rule'                                       => '在规则组“:title”中创建新规则',
    'make_new_rule_no_group'                              => '建立新规则',
    'instructions_rule_from_bill'                         => '为了使交易与您的新订阅匹配":name", Firefly III 可以创建一条规则，将自动与您存储的任何交易核对。 请验证下面的详细信息并存储规则，以使Fifly III 自动匹配您的新账单。',
    'instructions_rule_from_journal'                      => '基于您的交易之一创建一条规则。补充或提交下面的表格。',
    'rule_is_strict'                                      => '精确规则',
    'rule_is_not_strict'                                  => '模糊规则',
    'rule_help_stop_processing'                           => '当您选中此框时，如果执行此特定规则，此组中的后续规则将不会被执行。',
    'rule_help_strict'                                    => '在精确规则中，所有触发条件必须全部满足才能执行动作。在模糊规则中，满足任意触发条件即可执行动作。',
    'rule_help_active'                                    => '已停用的规则永远不会被触发。',
    'stored_new_rule'                                     => '新规则“:title”已保存',
    'deleted_rule'                                        => '已删除标题为 ":title" 的规则',
    'store_new_rule'                                      => '保存新规则',
    'updated_rule'                                        => '已以 ":title" 为标题更新规则',
    'default_rule_group_name'                             => '默认规则',
    'default_rule_group_description'                      => '未添加至特定组的规则。',
    'trigger'                                             => '触发条件',
    'trigger_value'                                       => '触发值',
    'stop_processing_other_triggers'                      => '停止处理其他触发条件',
    'add_rule_trigger'                                    => '新增触发条件',
    'action'                                              => '动作',
    'action_value'                                        => '动作值',
    'stop_executing_other_actions'                        => '停止处理其他动作',
    'add_rule_action'                                     => '新增动作',
    'edit_rule'                                           => '编辑规则 #:nr “:title”',
    'delete_rule'                                         => '删除规则 ":title"',
    'update_rule'                                         => '更新规则',
    'test_rule_triggers'                                  => '查看匹配的交易',
    'warning_no_matching_transactions'                    => '未找到符合条件的交易',
    'warning_no_valid_triggers'                           => '未提供有效触发条件。',
    'apply_rule_selection'                                => '选取交易并应用规则“:title”',
    'apply_rule_selection_intro'                          => '规则如“:title”一般仅应用于新增的或更新后的交易，但您可要求 Firefly III 针对已有的单笔或多笔交易执行规则。在您更新一条规则后，且必须应用此规则至其他交易时，即可使用此功能。',
    'include_transactions_from_accounts'                  => '包含来自这些账户的交易',
    'include'                                             => '包含？',
    'applied_rule_selection'                              => '{0} 规则“:title”没有改变任何您选择的交易。|[1] 规则“:title”改变了一条您选择的交易。|[2,*] 规则“:title”改变了:count条您选择的交易。',
    'execute'                                             => '执行',
    'apply_rule_group_selection'                          => '选取交易并应用规则组“:title”',
    'apply_rule_group_selection_intro'                    => '规则组如“:title”一般仅应用于新增的或更新后的交易，但您可要求 Firefly III 针对已有的单笔或多笔交易执行规则组内的规则。在您更新一个规则组后，且必须应用此组至其他交易时，即可使用此功能。',
    'applied_rule_group_selection'                        => '规则组“:title”已应用至所选交易',

    // actions and triggers
    'rule_trigger_store_journal'                          => '当创建交易时',
    'rule_trigger_update_journal'                         => '当交易更新时',
    'rule_trigger_manual'                                 => '仅当用户激活',
    'rule_trigger_user_action'                            => '用户动作为“:trigger_value”',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => '来源账户名称开头为...',
    'rule_trigger_source_account_starts'                  => '来源账户名称开头为“:trigger_value”',
    'rule_trigger_source_account_ends_choice'             => '来源账户结尾为…',
    'rule_trigger_source_account_ends'                    => '来源账户名称结尾为“:trigger_value”',
    'rule_trigger_source_account_is_choice'               => '来源账户名称为...',
    'rule_trigger_source_account_is'                      => '来源账户名称为“:trigger_value”',
    'rule_trigger_source_account_contains_choice'         => '来源账户名称包含...',
    'rule_trigger_source_account_contains'                => '来源账户名称包含“:trigger_value”',
    'rule_trigger_account_id_choice'                      => '其中一个账户ID为...',
    'rule_trigger_account_id'                             => '其中一个账户ID是:trigger_value',
    'rule_trigger_source_account_id_choice'               => '来源账户 ID 为...',
    'rule_trigger_source_account_id'                      => '来源账户 ID 为 :trigger_value',
    'rule_trigger_destination_account_id_choice'          => '目标账户 ID 为...',
    'rule_trigger_destination_account_id'                 => '目标账户 ID 为 :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => '其中一个账户是现金账户',
    'rule_trigger_account_is_cash'                        => '其中一个账户是现金账户',
    'rule_trigger_source_is_cash_choice'                  => '来源账户为 (现金) 账户',
    'rule_trigger_source_is_cash'                         => '来源账户为 (现金) 账户',
    'rule_trigger_destination_is_cash_choice'             => '目标账户为 (现金) 账户',
    'rule_trigger_destination_is_cash'                    => '目标账户为 (现金) 账户',
    'rule_trigger_source_account_nr_starts_choice'        => '来源账户编号 / IBAN 开头为...',
    'rule_trigger_source_account_nr_starts'               => '来源账户编号 / IBAN 开头为“:trigger_value”',
    'rule_trigger_source_account_nr_ends_choice'          => '来源账户编号 / IBAN 结尾为...',
    'rule_trigger_source_account_nr_ends'                 => '来源账户编号 / IBAN 结尾为“:trigger_value”',
    'rule_trigger_source_account_nr_is_choice'            => '来源账户编号 / IBAN 为...',
    'rule_trigger_source_account_nr_is'                   => '来源账户编号 / IBAN 为“:trigger_value”',
    'rule_trigger_source_account_nr_contains_choice'      => '来源账户编号 / IBAN 包含...',
    'rule_trigger_source_account_nr_contains'             => '来源账户编号 / IBAN 包含“:trigger_value”',
    'rule_trigger_destination_account_starts_choice'      => '目标账户名称开头为...',
    'rule_trigger_destination_account_starts'             => '目标账户名称开头为“:trigger_value”',
    'rule_trigger_destination_account_ends_choice'        => '目标账户名称结尾为...',
    'rule_trigger_destination_account_ends'               => '目标账户名称结尾为“:trigger_value”',
    'rule_trigger_destination_account_is_choice'          => '目标账户名称为...',
    'rule_trigger_destination_account_is'                 => '目标账户名称为“:trigger_value”',
    'rule_trigger_destination_account_contains_choice'    => '目标账户名称包含...',
    'rule_trigger_destination_account_contains'           => '目标账户名称包含“:trigger_value”',
    'rule_trigger_destination_account_nr_starts_choice'   => '目标账户编号 / IBAN 开头为...',
    'rule_trigger_destination_account_nr_starts'          => '目标账户编号 / IBAN 开头为“:trigger_value”',
    'rule_trigger_destination_account_nr_ends_choice'     => '目标账户编号 / IBAN 结尾为...',
    'rule_trigger_destination_account_nr_ends'            => '目标账户编号 / IBAN 结尾为“:trigger_value”',
    'rule_trigger_destination_account_nr_is_choice'       => '目标账户编号 / IBAN 为...',
    'rule_trigger_destination_account_nr_is'              => '目标账户编号 / IBAN 为“:trigger_value”',
    'rule_trigger_destination_account_nr_contains_choice' => '目标账户编号 / IBAN 包含...',
    'rule_trigger_destination_account_nr_contains'        => '目标账户编号 / IBAN 包含“:trigger_value”',
    'rule_trigger_transaction_type_choice'                => '交易类型为…',
    'rule_trigger_transaction_type'                       => '转账类型为“:trigger_value”',
    'rule_trigger_category_is_choice'                     => '分类为...',
    'rule_trigger_category_is'                            => '分类为 ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => '金额小于或等于...',
    'rule_trigger_amount_less'                            => '金额小于或等于:trigger_value',
    'rule_trigger_amount_is_choice'                       => '金额是...',
    'rule_trigger_amount_is'                              => '金额为:trigger_value',
    'rule_trigger_amount_more_choice'                     => '金额大于或等于...',
    'rule_trigger_amount_more'                            => '金额大于或等于:trigger_value',
    'rule_trigger_description_starts_choice'              => '描述开头为...',
    'rule_trigger_description_starts'                     => '描述开头为 ":trigger_value"',
    'rule_trigger_description_ends_choice'                => '描述结尾为...',
    'rule_trigger_description_ends'                       => '描述结尾为“:trigger_value”',
    'rule_trigger_description_contains_choice'            => '描述包含…',
    'rule_trigger_description_contains'                   => '描述包含 ":trigger_value"',
    'rule_trigger_description_is_choice'                  => '描述为…',
    'rule_trigger_description_is'                         => '描述为“:trigger_value”',
    'rule_trigger_date_on_choice'                         => '交易日期为...',
    'rule_trigger_date_on'                                => '交易日期为“:trigger_value”',
    'rule_trigger_date_before_choice'                     => '交易日期早于...',
    'rule_trigger_date_before'                            => '交易日期早于“:trigger_value”',
    'rule_trigger_date_after_choice'                      => '交易日期晚于...',
    'rule_trigger_date_after'                             => '交易日期晚于“:trigger_value”',
    'rule_trigger_created_at_on_choice'                   => '交易生成于...',
    'rule_trigger_created_at_on'                          => '交易生成于“:trigger_value”',
    'rule_trigger_updated_at_on_choice'                   => '交易最后编辑于...',
    'rule_trigger_updated_at_on'                          => '交易最后编辑于“:trigger_value”',
    'rule_trigger_budget_is_choice'                       => '预算为…',
    'rule_trigger_budget_is'                              => '预算为 ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => '其中一个标签为...',
    'rule_trigger_tag_is'                                 => '其中一个标签为":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => '任何标签包含...',
    'rule_trigger_tag_contains'                           => '任何标签包含 ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => '任何标签结尾...',
    'rule_trigger_tag_ends'                               => '任何标签以 ":trigger_value " 结尾',
    'rule_trigger_tag_starts_choice'                      => '任何标签开头...',
    'rule_trigger_tag_starts'                             => '任何标签以 ":trigger_value " 开头',
    'rule_trigger_currency_is_choice'                     => '交易货币为…',
    'rule_trigger_currency_is'                            => '交易货币为“:trigger_value”',
    'rule_trigger_foreign_currency_is_choice'             => '交易外币为...',
    'rule_trigger_foreign_currency_is'                    => '交易外币为“:trigger_value”',
    'rule_trigger_has_attachments_choice'                 => '有任何附件',
    'rule_trigger_has_attachments'                        => '有任何附件',
    'rule_trigger_has_no_category_choice'                 => '无分类',
    'rule_trigger_has_no_category'                        => '交易没有分类',
    'rule_trigger_has_any_category_choice'                => '有一个 (任何) 分类',
    'rule_trigger_has_any_category'                       => '交易有一个 (任何) 分类',
    'rule_trigger_has_no_budget_choice'                   => '没有预算',
    'rule_trigger_has_no_budget'                          => '交易没有预算',
    'rule_trigger_has_any_budget_choice'                  => '有一个 (任何) 预算',
    'rule_trigger_has_any_budget'                         => '交易有一个 (任何) 预算',
    'rule_trigger_has_no_bill_choice'                     => '没有账单',
    'rule_trigger_has_no_bill'                            => '交易没有周期性账单',
    'rule_trigger_has_any_bill_choice'                    => '有一个账单 (任何)',
    'rule_trigger_has_any_bill'                           => '交易包含有周期性账单',
    'rule_trigger_has_no_tag_choice'                      => '没有标签',
    'rule_trigger_has_no_tag'                             => '交易没有标签',
    'rule_trigger_has_any_tag_choice'                     => '有一个或多个 (任何) 标签',
    'rule_trigger_has_any_tag'                            => '交易有一个或多个 (任何) 标签',
    'rule_trigger_any_notes_choice'                       => '有 (任意) 备注',
    'rule_trigger_any_notes'                              => '交易有 (任意) 备注',
    'rule_trigger_no_notes_choice'                        => '无备注',
    'rule_trigger_no_notes'                               => '交易没有备注',
    'rule_trigger_notes_is_choice'                        => '备注为...',
    'rule_trigger_notes_is'                               => '备注为":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => '备注包含...',
    'rule_trigger_notes_contains'                         => '备注包含":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => '备注开头为...',
    'rule_trigger_notes_starts'                           => '备注开头为":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => '备注结尾为...',
    'rule_trigger_notes_ends'                             => '备注结尾为":trigger_value"',
    'rule_trigger_bill_is_choice'                         => '账单为...',
    'rule_trigger_bill_is'                                => '周期性账单是“:trigger_value”',
    'rule_trigger_external_id_is_choice'                  => '外部ID为...',
    'rule_trigger_external_id_is'                         => '外部ID为 ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => '内部引用为...',
    'rule_trigger_internal_reference_is'                  => '内部引用为":trigger_value"',
    'rule_trigger_journal_id_choice'                      => '交易日志 ID 为...',
    'rule_trigger_journal_id'                             => '交易日志 ID 为“:trigger_value”',
    'rule_trigger_any_external_url'                       => '交易有一个（任意）外部链接',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => '交易有一个（任意）外部ID',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => '交易没有外部URL',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => '交易没有外部ID',
    'rule_trigger_id_choice'                              => '交易ID为...',
    'rule_trigger_id'                                     => '交易ID为":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT是...',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT是“:trigger_value”',

    // new values:
    'rule_trigger_user_action_choice'                     => '用户操作为“:trigger_value”',
    'rule_trigger_tag_is_not_choice'                      => '没有标签为...',
    'rule_trigger_tag_is_not'                             => '没有标签为“:trigger_value”',
    'rule_trigger_account_is_choice'                      => '其中一个账户为...',
    'rule_trigger_account_is'                             => '其中一个账户为":trigger_value"',
    'rule_trigger_account_contains_choice'                => '其中一个账户包含...',
    'rule_trigger_account_contains'                       => '其中一个账户包含":trigger_value"',
    'rule_trigger_account_ends_choice'                    => '其中一个账户结尾为...',
    'rule_trigger_account_ends'                           => '其中一个账户结尾为":trigger_value"',
    'rule_trigger_account_starts_choice'                  => '其中一个账户开头为...',
    'rule_trigger_account_starts'                         => '其中一个账户开头为":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => '其中一个账户编号/IBAN为...',
    'rule_trigger_account_nr_is'                          => '其中一个账户编号/IBAN为":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => '其中一个账户编号/IBAN包含...',
    'rule_trigger_account_nr_contains'                    => '其中一个账户编号/IBAN包含":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => '其中一个账户编号/IBAN结尾为...',
    'rule_trigger_account_nr_ends'                        => '其中一个账户编号/IBAN结尾为":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => '其中一个账户编号/IBAN开头为...',
    'rule_trigger_account_nr_starts'                      => '其中一个账户编号/IBAN为":trigger_value"',
    'rule_trigger_category_contains_choice'               => '分类包含...',
    'rule_trigger_category_contains'                      => '分类包含":trigger_value"',
    'rule_trigger_category_ends_choice'                   => '分类结尾为...',
    'rule_trigger_category_ends'                          => '分类结尾为":trigger_value"',
    'rule_trigger_category_starts_choice'                 => '分类开头为...',
    'rule_trigger_category_starts'                        => '分类开头为":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => '预算包含...',
    'rule_trigger_budget_contains'                        => '预算包含":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => '预算结尾为',
    'rule_trigger_budget_ends'                            => '预算结尾为":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => '预算开头为...',
    'rule_trigger_budget_starts'                          => '预算开头为":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => '周期性账单包含...',
    'rule_trigger_bill_contains'                          => '周期性账单包含“:trigger_value”',
    'rule_trigger_bill_ends_choice'                       => '周期性账单的结尾为...',
    'rule_trigger_bill_ends'                              => '周期性账单的结尾是“:trigger_value”',
    'rule_trigger_bill_starts_choice'                     => '周期性账单的开头为...',
    'rule_trigger_bill_starts'                            => '周期性账单的开头是“:trigger_value”',
    'rule_trigger_external_id_contains_choice'            => '外部ID包含...',
    'rule_trigger_external_id_contains'                   => '外部ID包含":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => '外部ID结尾为...',
    'rule_trigger_external_id_ends'                       => '外部ID结尾为":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => '外部ID开头为...',
    'rule_trigger_external_id_starts'                     => '外部ID开头为":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => '内部引用包含...',
    'rule_trigger_internal_reference_contains'            => '内部引用包含“:trigger_value”',
    'rule_trigger_internal_reference_ends_choice'         => '内部引用结尾为...',
    'rule_trigger_internal_reference_ends'                => '内部引用结尾为“:trigger_value”',
    'rule_trigger_internal_reference_starts_choice'       => '内部引用开头为...',
    'rule_trigger_internal_reference_starts'              => '内部引用开头为“:trigger_value”',
    'rule_trigger_external_url_is_choice'                 => '外部URL为...',
    'rule_trigger_external_url_is'                        => '外部URL为":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => '外部URL包含...',
    'rule_trigger_external_url_contains'                  => '外部URL包含":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => '外部URL结尾为',
    'rule_trigger_external_url_ends'                      => '外部URL结尾为":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => '外部URL开头为...',
    'rule_trigger_external_url_starts'                    => '外部URL开头为":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => '没有附件',
    'rule_trigger_has_no_attachments'                     => '交易没有附件',
    'rule_trigger_recurrence_id_choice'                   => '定期交易ID为...',
    'rule_trigger_recurrence_id'                          => '定期交易ID为":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => '利息日期是...',
    'rule_trigger_interest_date_on'                       => '利息日期是":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => '利息日期早于...',
    'rule_trigger_interest_date_before'                   => '利息日期早于":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => '利息日期晚于...',
    'rule_trigger_interest_date_after'                    => '利息日期晚于":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => '登记日期是...',
    'rule_trigger_book_date_on'                           => '登记日期是":trigger_value"',
    'rule_trigger_book_date_before_choice'                => '登记日期早于...',
    'rule_trigger_book_date_before'                       => '登记日期早于":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => '登记日期晚于...',
    'rule_trigger_book_date_after'                        => '登记日期晚于":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => '处理日期是...',
    'rule_trigger_process_date_on'                        => '处理日期是":trigger_value"',
    'rule_trigger_process_date_before_choice'             => '处理日期早于...',
    'rule_trigger_process_date_before'                    => '处理日期早于":trigger_value"',
    'rule_trigger_process_date_after_choice'              => '处理日期晚于...',
    'rule_trigger_process_date_after'                     => '处理日期晚于":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => '截止日期是...',
    'rule_trigger_due_date_on'                            => '截止日期是":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => '截止日期早于...',
    'rule_trigger_due_date_before'                        => '截止日期早于":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => '截止日期晚于...',
    'rule_trigger_due_date_after'                         => '截止日期晚于":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => '付款日期是...',
    'rule_trigger_payment_date_on'                        => '付款日期是":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => '付款日期早于...',
    'rule_trigger_payment_date_before'                    => '付款日期早于":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => '付款日期晚于...',
    'rule_trigger_payment_date_after'                     => '付款日期晚于":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => '发票日期是...',
    'rule_trigger_invoice_date_on'                        => '发票日期是":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => '发票日期早于...',
    'rule_trigger_invoice_date_before'                    => '发票日期早于":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => '发票日期晚于...',
    'rule_trigger_invoice_date_after'                     => '发票日期晚于":trigger_value"',
    'rule_trigger_created_at_before_choice'               => '交易创建日期早于...',
    'rule_trigger_created_at_before'                      => '交易创建日期早于":trigger_value"',
    'rule_trigger_created_at_after_choice'                => '交易创建日期晚于...',
    'rule_trigger_created_at_after'                       => '交易创建日期晚于":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => '交易最后更新日期早于...',
    'rule_trigger_updated_at_before'                      => '交易最后更新日期早于":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => '交易最后更新日期晚于...',
    'rule_trigger_updated_at_after'                       => '交易最后更新日期晚于":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => '外币金额等于...',
    'rule_trigger_foreign_amount_is'                      => '外币金额等于“:trigger_value”',
    'rule_trigger_foreign_amount_less_choice'             => '外币金额少于...',
    'rule_trigger_foreign_amount_less'                    => '外币金额小于“:trigger_value”',
    'rule_trigger_foreign_amount_more_choice'             => '外币金额大于...',
    'rule_trigger_foreign_amount_more'                    => '外币金额大于“:trigger_value”',
    'rule_trigger_attachment_name_is_choice'              => '任意一个附件的名字为...',
    'rule_trigger_attachment_name_is'                     => '任意一个附件的名称为":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => '任意一个附件的名称包含...',
    'rule_trigger_attachment_name_contains'               => '任意一个附件的名称包含":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => '任意一个附件的名称开头为...',
    'rule_trigger_attachment_name_starts'                 => '任意一个附件的名称开头为":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => '任意一个附件的名称结尾为...',
    'rule_trigger_attachment_name_ends'                   => '任意一个附件的名称结尾为":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => '任意一个附件的备注是...',
    'rule_trigger_attachment_notes_are'                   => '任意一个附件的备注是":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => '任意一个附件的备注包含...',
    'rule_trigger_attachment_notes_contains'              => '任意一个附件的备注包含":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => '任意一个附件的备注开头为...',
    'rule_trigger_attachment_notes_starts'                => '任意一个附件的备注开头为":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => '任意一个附件的结尾为...',
    'rule_trigger_attachment_notes_ends'                  => '任意一个附件的备注结尾为":trigger_value"',
    'rule_trigger_reconciled_choice'                      => '交易已对账',
    'rule_trigger_reconciled'                             => '交易已对账',
    'rule_trigger_exists_choice'                          => '任意交易匹配(!)',
    'rule_trigger_exists'                                 => '任意交易匹配',

    // more values for new types:
    'rule_trigger_not_account_id'                         => '账户ID不为":trigger_value"',
    'rule_trigger_not_source_account_id'                  => '来源账户ID不为":trigger_value"',
    'rule_trigger_not_destination_account_id'             => '目标账户ID不为":trigger_value"',
    'rule_trigger_not_transaction_type'                   => '交易类型不为":trigger_value"',
    'rule_trigger_not_tag_is'                             => '标签不为":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => '标签为":trigger_value"',
    'rule_trigger_not_description_is'                     => '描述不为":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => '描述结尾不为":trigger_value"',
    'rule_trigger_not_description_starts'                 => '描述开头不为":trigger_value"',
    'rule_trigger_not_notes_is'                           => '备注不为":trigger_value"',
    'rule_trigger_not_notes_contains'                     => '备注不含":trigger_value"',
    'rule_trigger_not_notes_ends'                         => '备注结尾不为":trigger_value"',
    'rule_trigger_not_notes_starts'                       => '备注开头不为":trigger_value"',
    'rule_trigger_not_source_account_is'                  => '来源账户不为":trigger_value"',
    'rule_trigger_not_source_account_contains'            => '来源账户不含":trigger_value"',
    'rule_trigger_not_source_account_ends'                => '来源账户结尾不为":trigger_value"',
    'rule_trigger_not_source_account_starts'              => '来源账户开头不为":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => '来源账户编号 / IBAN 不为":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => '来源账户编号 / IBAN 不含":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => '来源账户编号 / IBAN 结尾不为":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => '来源账户编号 / IBAN 开头不为":trigger_value"',
    'rule_trigger_not_destination_account_is'             => '目标账户不为":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => '目标账户不含":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => '目标账户结尾不为":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => '目标账户开头不为":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => '目标账户编号 / IBAN 不为":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => '目标账户编号 / IBAN 不含":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => '目标账户编号 / IBAN 结尾不为":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => '目标账户编号 / IBAN 开头不为":trigger_value"',
    'rule_trigger_not_account_is'                         => '两个账户都不是":trigger_value"',
    'rule_trigger_not_account_contains'                   => '两个账户都不包含":trigger_value"',
    'rule_trigger_not_account_ends'                       => '两个账户的结尾都不是":trigger_value"',
    'rule_trigger_not_account_starts'                     => '两个账户的开头都不是":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => '两个账户的编号/IBAN都不是":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => '两个账户的编号/IBAN都不包含":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => '两个账户的编号/IBAN结尾都不是":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => '两个账户的编号/IBAN开头都不是":trigger_value"',
    'rule_trigger_not_category_is'                        => '分类不为":trigger_value"',
    'rule_trigger_not_category_contains'                  => '分类不含":trigger_value"',
    'rule_trigger_not_category_ends'                      => '分类结尾不为":trigger_value"',
    'rule_trigger_not_category_starts'                    => '分类开头不为":trigger_value"',
    'rule_trigger_not_budget_is'                          => '预算不为":trigger_value"',
    'rule_trigger_not_budget_contains'                    => '预算不含":trigger_value"',
    'rule_trigger_not_budget_ends'                        => '预算结尾不为":trigger_value"',
    'rule_trigger_not_budget_starts'                      => '预算开头不为":trigger_value"',
    'rule_trigger_not_bill_is'                            => '订阅不是":trigger_value"',
    'rule_trigger_not_bill_contains'                      => '周期性账单不包含“:trigger_value”',
    'rule_trigger_not_bill_ends'                          => '周期性账单结束时间不为“:trigger_value”',
    'rule_trigger_not_bill_starts'                        => '周期性账单结尾不为“:trigger_value”',
    'rule_trigger_not_external_id_is'                     => '外部ID不为":trigger_value"',
    'rule_trigger_not_external_id_contains'               => '外部ID不包含":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => '外部ID结尾不为":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => '外部ID开头不为":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => '内部引用不为":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => '内部引用不含":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => '内部引用结尾不为":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => '内部引用开头不为":trigger_value"',
    'rule_trigger_not_external_url_is'                    => '外部URL不为":trigger_value"',
    'rule_trigger_not_external_url_contains'              => '外部URL不含":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => '外部URL结尾不为":trigger_value"',
    'rule_trigger_not_external_url_starts'                => '外部URL开头不为":trigger_value"',
    'rule_trigger_not_currency_is'                        => '货币不为":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => '外币不为":trigger_value"',
    'rule_trigger_not_id'                                 => '交易ID不为":trigger_value"',
    'rule_trigger_not_journal_id'                         => '交易日志ID不为":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => '重复ID不是“:trigger_value”',
    'rule_trigger_not_date_on'                            => '日期不为":trigger_value"',
    'rule_trigger_not_date_before'                        => '日期不早于":trigger_value"',
    'rule_trigger_not_date_after'                         => '日期不晚于":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => '利息日期不为“:trigger_value”',
    'rule_trigger_not_interest_date_before'               => '利息日期不早于“:trigger_value”',
    'rule_trigger_not_interest_date_after'                => '利息日期不晚于“:trigger_value”',
    'rule_trigger_not_book_date_on'                       => '登记日期不为“:trigger_value”',
    'rule_trigger_not_book_date_before'                   => '登记日期不早于“:trigger_value”',
    'rule_trigger_not_book_date_after'                    => '登记日期不晚于“:trigger_value”',
    'rule_trigger_not_process_date_on'                    => '处理日期不为“:trigger_value”',
    'rule_trigger_not_process_date_before'                => '处理日期不早于“:trigger_value”',
    'rule_trigger_not_process_date_after'                 => '处理日期不晚于“:trigger_value”',
    'rule_trigger_not_due_date_on'                        => '截止日期不为“:trigger_value”',
    'rule_trigger_not_due_date_before'                    => '截止日期不早于“:trigger_value”',
    'rule_trigger_not_due_date_after'                     => '截止日期不晚于“:trigger_value”',
    'rule_trigger_not_payment_date_on'                    => '付款日期不为“:trigger_value”',
    'rule_trigger_not_payment_date_before'                => '付款日期不早于“:trigger_value”',
    'rule_trigger_not_payment_date_after'                 => '付款日期不晚于“:trigger_value”',
    'rule_trigger_not_invoice_date_on'                    => '发票日期不为“:trigger_value”',
    'rule_trigger_not_invoice_date_before'                => '发票日期不早于“:trigger_value”',
    'rule_trigger_not_invoice_date_after'                 => '发票日期不晚于“:trigger_value”',
    'rule_trigger_not_created_at_on'                      => '交易创建日期不为“:trigger_value”',
    'rule_trigger_not_created_at_before'                  => '交易创建日期不早于":trigger_value"',
    'rule_trigger_not_created_at_after'                   => '交易创建日期不晚于":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => '交易不是更新于“:trigger_value”',
    'rule_trigger_not_updated_at_before'                  => '交易更新日期不早于":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => '交易更新日期不晚于“:trigger_value”',
    'rule_trigger_not_amount_is'                          => '交易金额不是“:trigger_value”',
    'rule_trigger_not_amount_less'                        => '交易金额大于“:trigger_value”',
    'rule_trigger_not_amount_more'                        => '交易金额小于“:trigger_value”',
    'rule_trigger_not_foreign_amount_is'                  => '外币交易金额不是“:trigger_value”',
    'rule_trigger_not_foreign_amount_less'                => '外币交易金额大于:trigger_value',
    'rule_trigger_not_foreign_amount_more'                => '外币交易金额小于:trigger_value',
    'rule_trigger_not_attachment_name_is'                 => '没有名称为“:trigger_value”的附件',
    'rule_trigger_not_attachment_name_contains'           => '没有名称包含“:trigger_value”的附件',
    'rule_trigger_not_attachment_name_starts'             => '没有名称开头为“:trigger_value”的附件',
    'rule_trigger_not_attachment_name_ends'               => '没有名称结尾为“:trigger_value”的附件',
    'rule_trigger_not_attachment_notes_are'               => '没有备注为“:trigger_value”的附件',
    'rule_trigger_not_attachment_notes_contains'          => '没有备注包含“:trigger_value”的附件',
    'rule_trigger_not_attachment_notes_starts'            => '没有备注开头为“:trigger_value”的附件',
    'rule_trigger_not_attachment_notes_ends'              => '没有备注结尾为“:trigger_value”的附件',
    'rule_trigger_not_reconciled'                         => '交易未对账',
    'rule_trigger_not_exists'                             => '交易不存在',
    'rule_trigger_not_has_attachments'                    => '交易不含附件',
    'rule_trigger_not_has_any_category'                   => '交易不含分类',
    'rule_trigger_not_has_any_budget'                     => '交易没有预算',
    'rule_trigger_not_has_any_bill'                       => '交易没有周期性账单',
    'rule_trigger_not_has_any_tag'                        => '交易不含标签',
    'rule_trigger_not_any_notes'                          => '交易不含备注',
    'rule_trigger_not_any_external_url'                   => '交易没有外部链接',
    'rule_trigger_not_has_no_attachments'                 => '交易有 (任何) 一个附件',
    'rule_trigger_not_has_no_category'                    => '交易有 (任何) 一个分类',
    'rule_trigger_not_has_no_budget'                      => '交易有 (任何) 一个预算',
    'rule_trigger_not_has_no_bill'                        => '交易包含于周期性账单',
    'rule_trigger_not_has_no_tag'                         => '交易有 (任意) 一个标签',
    'rule_trigger_not_no_notes'                           => '交易有任意备注',
    'rule_trigger_not_no_external_url'                    => '交易有一个外部链接',
    'rule_trigger_not_source_is_cash'                     => '来源账户不为现金账户',
    'rule_trigger_not_destination_is_cash'                => '目标账户不为现金账户',
    'rule_trigger_not_account_is_cash'                    => '两个账户都不是现金账户',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => '目标帐户余额大于 ',
    'rule_trigger_destination_balance_gte_choice'         => '目标帐户余额大于或等于 ',
    'rule_trigger_destination_balance_is_choice'          => '目标帐户余额等于 ',
    'rule_trigger_destination_balance_lt_choice'          => '目标帐户余额小于 ',
    'rule_trigger_destination_balance_lte_choice'         => '目标帐户余额小于或等于 ',

    'rule_trigger_source_balance_gt_choice'  => '来源账户余额大于 ',
    'rule_trigger_source_balance_gte_choice' => '来源账户余额大于或等于 ',
    'rule_trigger_source_balance_is_choice'  => '来源账户余额等于 ',
    'rule_trigger_source_balance_lt_choice'  => '来源账户余额小于 ',
    'rule_trigger_source_balance_lte_choice' => '源账户余额小于或等于 ',

    'rule_trigger_destination_balance_gt'  => '目标帐户余额大于 :trigger_value',
    'rule_trigger_destination_balance_gte' => '目标帐户余额大于或等于:trigger_value',
    'rule_trigger_destination_balance_is'  => '目标帐户余额等于:trigger_value',
    'rule_trigger_destination_balance_lt'  => '目标帐户余额小于:trigger_value',
    'rule_trigger_destination_balance_lte' => '目标帐户余额小于或等于:trigger_value',

    'rule_trigger_source_balance_gt'           => '来源账户余额大于 :trigger_value',
    'rule_trigger_source_balance_gte'          => '来源账户余额大于或等于 :trigger_value',
    'rule_trigger_source_balance_is'           => '来源账户余额等于 :trigger_value',
    'rule_trigger_source_balance_lt'           => '来源帐户余额小于:trigger_value',
    'rule_trigger_source_balance_lte'          => '来源帐户余额小于或等于:trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => '目标帐户余额小于或等于:trigger_value',
    'rule_trigger_not_destination_balance_gte' => '目标帐户余额小于:trigger_value',
    'rule_trigger_not_destination_balance_is'  => '目标帐户余额不等于:trigger_value',
    'rule_trigger_not_destination_balance_lt'  => '目标帐户余额大于或等于:trigger_value',
    'rule_trigger_not_destination_balance_lte' => '目标帐户余额大于 :trigger_value',

    'rule_trigger_not_source_balance_gt'         => '来源帐户余额小于或等于:trigger_value',
    'rule_trigger_not_source_balance_gte'        => '来源帐户余额小于:trigger_value',
    'rule_trigger_not_source_balance_is'         => '来源账户余额不等于 :trigger_value',
    'rule_trigger_not_source_balance_lt'         => '来源账户余额大于或等于 :trigger_value',
    'rule_trigger_not_source_balance_lte'        => '来源账户余额大于 :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => '删除交易！',
    'rule_action_delete_transaction'             => '删除交易！',
    'rule_action_set_category'                   => '设定分类为 ":action_value"',
    'rule_action_clear_category'                 => '清空分类',
    'rule_action_set_budget'                     => '添加到预算“:action_value”',
    'rule_action_clear_budget'                   => '清空预算',
    'rule_action_add_tag'                        => '新增标签 ":action_value"',
    'rule_action_remove_tag'                     => '移除标签 ":action_value"',
    'rule_action_remove_all_tags'                => '移除所有标签',
    'rule_action_set_description'                => '设定描述为“:action_value”',
    'rule_action_append_description'             => '描述后添加“:action_value”',
    'rule_action_prepend_description'            => '描述前添加“:action_value”',
    'rule_action_set_category_choice'            => '设置分类为...',
    'rule_action_clear_category_choice'          => '清空所有分类',
    'rule_action_set_budget_choice'              => '设置预算为...',
    'rule_action_clear_budget_choice'            => '清空所有预算',
    'rule_action_add_tag_choice'                 => '添加标签..',
    'rule_action_remove_tag_choice'              => '移除标签..',
    'rule_action_remove_all_tags_choice'         => '移除所有标签',
    'rule_action_set_description_choice'         => '设置描述为',
    'rule_action_update_piggy_choice'            => '添加/删除存钱罐中的交易金额',
    'rule_action_update_piggy'                   => '添加/删除存钱罐“:action_value”中的交易金额',
    'rule_action_append_description_choice'      => '描述后添加…',
    'rule_action_prepend_description_choice'     => '描述前添加…',
    'rule_action_set_source_account_choice'      => '设置来源账户为...',
    'rule_action_set_source_account'             => '将来源账户设为 :action_value',
    'rule_action_set_destination_account_choice' => '设置目标账户为...',
    'rule_action_set_destination_account'        => '将目标账户设为 :action_value',
    'rule_action_append_notes_choice'            => '备注后添加...',
    'rule_action_append_notes'                   => '备注后添加“:action_value”',
    'rule_action_prepend_notes_choice'           => '备注前添加...',
    'rule_action_prepend_notes'                  => '备注前添加“:action_value”',
    'rule_action_clear_notes_choice'             => '移除所有备注',
    'rule_action_clear_notes'                    => '移除所有备注',
    'rule_action_set_notes_choice'               => '设置备注为..',
    'rule_action_link_to_bill_choice'            => '关联到周期性账单...',
    'rule_action_link_to_bill'                   => '关联至周期性账单“:action_value”',
    'rule_action_switch_accounts_choice'         => '交换来源账户和目标账户（仅转账！）',
    'rule_action_switch_accounts'                => '交换来源账户和目标账户',
    'rule_action_set_notes'                      => '设定备注至“:action_value”',
    'rule_action_convert_deposit_choice'         => '转换交易为收入',
    'rule_action_convert_deposit'                => '转换交易为来自“:action_value”的收入',
    'rule_action_convert_withdrawal_choice'      => '转换交易为支出',
    'rule_action_convert_withdrawal'             => '转换交易为从“:action_value”的支出',
    'rule_action_convert_transfer_choice'        => '转换交易为转账',
    'rule_action_convert_transfer'               => '转换交易为与“:action_value”间的转账',
    'rule_action_append_descr_to_notes_choice'   => '描述添加至交易备注后',
    'rule_action_append_notes_to_descr_choice'   => '交易备注添加至描述后',
    'rule_action_move_descr_to_notes_choice'     => '用描述替换当前交易备注',
    'rule_action_move_notes_to_descr_choice'     => '用交易的备注替换当前描述',
    'rule_action_append_descr_to_notes'          => '在备注后追加描述',
    'rule_action_append_notes_to_descr'          => '在描述后追加备注',
    'rule_action_move_descr_to_notes'            => '用描述替换备注',
    'rule_action_move_notes_to_descr'            => '用备注替换描述',
    'rule_action_set_amount_choice'              => '设置金额为 ...',
    'rule_action_set_amount'                     => '设置金额为 ":action_value"',
    'rule_action_set_destination_to_cash_choice' => '将目标帐户设置为 (现金)',
    'rule_action_set_source_to_cash_choice'      => '将源账户设置为 (现金)',
    'rulegroup_for_bills_title'                  => '账单规则组',
    'rulegroup_for_bills_description'            => '一个特殊的规则组，用于所有包含订阅的规则。',
    'rule_for_bill_title'                        => '为订阅 ":name" 自动生成的规则',
    'rule_for_bill_description'                  => '此规则是自动生成的以尝试匹配订阅“:name”。',
    'create_rule_for_bill'                       => '为订阅创建一条新规则 ":name"',
    'create_rule_for_bill_txt'                   => '您刚刚创建了一个名为“:name”的新订阅，恭喜！Firefly III 可以自动匹配新支出到此账单中。例如，每当您支付租金时，“租金”账单将与此支出挂钩。 这样的话，Firefly III 可以准确地向你们展示哪些订阅将要到期以及哪些订阅尚未到期。要实现该功能，必须创建一项新的规则。Firefly III 已经为您填写了一些合理的默认值。请确保它们是正确的。如果这些值是正确的，Frefly III 将自动将正确的支出与正确的订阅关联起来。 请查看触发器以确认他们是否正确，如果触发器不正确，请添加一些正确的触发器。',
    'new_rule_for_bill_title'                    => '周期性账单规则“:name”',
    'new_rule_for_bill_description'              => '此规则标记用于订阅“:name”的交易。',

    'new_rule_for_journal_title'                => '基于交易":description"的规则',
    'new_rule_for_journal_description'          => '此规则基于交易“:description”，它将匹配完全相同的交易。',

    // tags
    'store_new_tag'                             => '保存新标签',
    'update_tag'                                => '更新标签',
    'no_location_set'                           => '没有设定位置。',
    'meta_data'                                 => '后设资料',
    'location'                                  => '位置',
    'location_first_split'                      => '交易的位置可以设置在此交易的第一个拆分。',
    'without_date'                              => '不含日期',
    'result'                                    => '结果',
    'sums_apply_to_range'                       => '所有总和均应用至所选范围',
    'mapbox_api_key'                            => '若要使用地图，请从 <a href="https://www.mapbox.com/">Mapbox</a> 获取 API 密钥。打开 <code>.env</code> 文件并在 <code>MAPBOX_API_KEY=</code> 后输入密钥。',
    'press_object_location'                     => '右键单击或长按设置对象的位置。',
    'click_tap_location'                        => '点击或点击地图添加位置',
    'clear_location'                            => '清除位置',
    'delete_all_selected_tags'                  => '删除所有选中的标签',
    'select_tags_to_delete'                     => '别忘了选择一些标签。',
    'deleted_x_tags'                            => '已删除 :count 个标签。|已删除 :count 个标签。',
    'create_rule_from_transaction'              => '基于交易创建规则',
    'create_recurring_from_transaction'         => '从交易创建定期交易',

    // preferences
    'test_notifications_buttons'                => '要测试您的配置，请使用下面的按钮。请注意该按钮没有垃圾邮件控制。',
    'dark_mode_option_browser'                  => '让您的浏览器决定',
    'dark_mode_option_light'                    => '始终使用亮色',
    'dark_mode_option_dark'                     => '始终使用暗色',
    'equal_to_language'                         => '(与语言相同)',
    'dark_mode_preference'                      => '暗色模式',
    'dark_mode_preference_help'                 => '告诉 Firefly III 何时使用暗色模式。',
    'pref_home_screen_accounts'                 => '主屏幕账户',
    'pref_home_screen_accounts_help'            => '哪些账户应该显示在主屏幕上？',
    'pref_view_range'                           => '查看范围',
    'pref_view_range_help'                      => '部分图表自动按照周期分组，您的预算也将按照周期分组。请问您倾向于哪个周期？',
    'pref_1D'                                   => '1天',
    'pref_1W'                                   => '1周',
    'pref_1M'                                   => '1个月',
    'pref_3M'                                   => '3个月 (1季度)',
    'pref_6M'                                   => '6个月',
    'pref_1Y'                                   => '1年',
    'pref_last365'                              => '最近一年',
    'pref_last90'                               => '最近90天',
    'pref_last30'                               => '最近 30 天',
    'pref_last7'                                => '最近7天',
    'pref_YTD'                                  => '今年至今',
    'pref_QTD'                                  => '本季度至今',
    'pref_MTD'                                  => '本月至今',
    'pref_languages'                            => '语言',
    'pref_locale'                               => '区域设置',
    'pref_languages_help'                       => 'Firefly III 支持多语言，请问您倾向于哪个语言？',
    'pref_locale_help'                          => 'Firefly III 允许您配置其他本地设置，例如货币、数字、日期的格式。您的系统可能不支持此列表中的某些条目。Firefly III 没有为每个区域设置正确的日期格式；请联系开发者进行改进。',
    'pref_locale_no_demo'                       => '此功能对演示用户无效。',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => '财年设置',
    'pref_custom_fiscal_year_label'             => '已启用',
    'pref_custom_fiscal_year_help'              => '在不使用1月1日至12月31日作为财年的国家，您可开启此功能并指定财年的起止日期。',
    'pref_fiscal_year_start_label'              => '财政年度开始日期',
    'pref_two_factor_auth'                      => '多因素认证',
    'pref_two_factor_auth_help'                 => '当您启用多因素认证（也称为双因素认证）时，可以为您的账户增加一层额外的安全保护。您使用您已经知道的（您的密码）和您能得到的（一个验证码）来进行登录。验证码由您手机上的应用程序（例如 Authy 或 Google 身份验证器）生成。',
    'pref_enable_two_factor_auth'               => '启用多因素认证',
    'pref_two_factor_auth_disabled'             => '多因素认证验证码已删除并禁用',
    'pref_two_factor_auth_remove_it'            => '请不要忘记从您的身份验证 APP 上删除账户！',
    'pref_two_factor_auth_code'                 => '验证码',
    'pref_two_factor_auth_code_help'            => '在您的手机上用诸如 Authy 或 Google 身份验证器之类的应用程序扫描二维码并输入生成的代码。 每次访问这个页面时，二维码都会变化。请确保您使用的是最新的二维码。',
    'pref_two_factor_auth_reset_code'           => '重置验证码',
    'pref_two_factor_auth_disable_2fa'          => '禁用多因素认证',
    '2fa_use_secret_instead'                    => '如果您无法扫描 QR 码，请使用密钥: <code>:secret</code>。',
    '2fa_backup_codes'                          => '保存这些备用代码，以便在您丢失设备时访问。',
    '2fa_already_enabled'                       => '多因素认证已启用。',
    'wrong_mfa_code'                            => '此MFA代码无效。',
    'pref_save_settings'                        => '保存设置',
    'saved_preferences'                         => '偏好设定已保存！',
    'preferences_general'                       => '通用',
    'preferences_frontpage'                     => '主屏幕',
    'preferences_security'                      => '安全性',
    'preferences_layout'                        => '布局',
    'preferences_notifications'                 => '通知',
    'pref_home_show_deposits'                   => '在主屏幕显示收入',
    'pref_home_show_deposits_info'              => '主屏幕已显示您的支出账户，是否同时显示您的收入账户？',
    'pref_home_do_show_deposits'                => '是，要显示',
    'successful_count'                          => ':count 项成功',
    'list_page_size_title'                      => '页面大小',
    'list_page_size_help'                       => '任何项目 (账户、交易等) 的列表每页最多显示此数量。',
    'list_page_size_label'                      => '页面大小',
    'between_dates'                             => '(:start – :end)',
    'pref_optional_fields_transaction'          => '交易选填字段',
    'pref_optional_fields_transaction_help'     => '默认情况下，建立一笔新交易时 (由于太多字段比较杂乱) ，所有字段并非全部启用。如果您认为下面的这些字段对您有用，您可以启用它们。当然，任何已禁用但已填写的字段仍然可见，与设置无关。
',
    'optional_tj_date_fields'                   => '日期字段',
    'optional_tj_other_fields'                  => '其他字段',
    'optional_tj_attachment_fields'             => '附件字段',
    'pref_optional_tj_interest_date'            => '利息日期',
    'pref_optional_tj_book_date'                => '登记日期',
    'pref_optional_tj_process_date'             => '处理日期',
    'pref_optional_tj_due_date'                 => '截止日期',
    'pref_optional_tj_payment_date'             => '付款日期',
    'pref_optional_tj_invoice_date'             => '发票日期',
    'pref_optional_tj_internal_reference'       => '内部引用',
    'pref_optional_tj_notes'                    => '备注',
    'pref_optional_tj_attachments'              => '附件',
    'pref_optional_tj_external_url'             => '外部链接',
    'pref_optional_tj_location'                 => '位置',
    'pref_optional_tj_links'                    => '交易关联',
    'optional_field_meta_dates'                 => '日期',
    'optional_field_meta_business'              => '商务',
    'optional_field_attachments'                => '附件',
    'optional_field_meta_data'                  => '可选后设资料',
    'external_url'                              => '外部链接',
    'pref_notification_login_failure'           => '登录失败',
    'pref_notification_bill_reminder'           => '关于到期周期性账单的提醒',
    'pref_notification_new_access_token'        => '创建新 API 访问令牌时提醒',
    'pref_notification_transaction_creation'    => '自动创建交易时提醒',
    'pref_notification_user_login'              => '当您从一个新位置登录时提醒',
    'pref_notification_rule_action_failures'    => '当规则操作未能执行时提醒（不通过电子邮件）',
    'pref_notification_new_password'            => '您的密码已更改',
    'pref_notification_enabled_mfa'             => '多因素认证已启用',
    'pref_notification_disabled_mfa'            => '多因素认证已禁用',
    'pref_notification_few_left_mfa'            => '您只剩下没几个备份代码',
    'pref_notification_no_left_mfa'             => '您没有剩余的备份代码',
    'pref_notification_many_failed_mfa'         => '多因素身份验证检查持续失败',
    'pref_notification_new_backup_codes'        => '已生成新的备份代码',
    'pref_notifications'                        => '通知',
    'pref_notifications_help'                   => '设置您想要接收的通知。一些通知可能包含敏感的财务信息。',
    'pref_notifications_settings'               => '通知设置',
    'pref_notifications_settings_help'          => '使用这些设置来配置您的通知频道。请注意通知将发送到所有频道。请首先保存您的设置。',
    'slack_url_label'                           => 'Slack“回传webhook”网址',
    'discord_url_label'                         => 'Discord Webhook 链接',

    // exchange rates
    'menu_exchange_rates_index'                 => '汇率',
    'header_exchange_rates'                     => '汇率',
    'exchange_rates_intro'                      => 'Frefly III 支持下载和使用汇率。请在 <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">这份文档</a>中阅读更多。',
    'exchange_rates_from_to'                    => '从 {from} 到 {to} 的汇率（以及反向）',
    'header_exchange_rates_rates'               => '汇率',
    'exchange_rates_intro_rates'                => 'Firefly III 采用以下汇率。如果没有提供反向汇率则自动计算。 如果交易日期不存在汇率，Fifrefly III 将寻找前一个可用日期的汇率。 如果没有，将按汇率为 1 进行计算。',
    'header_exchange_rates_table'               => '汇率表',
    'help_rate_form'                            => '在这一天，你能从每 1 个单位的 {from} 获得多少 {to}？',
    'save_new_rate'                             => '保存新汇率',
    'add_new_rate'                              => '添加新汇率',
    'not_enough_currencies'                     => '没有足够的货币',
    'not_enough_currencies_enabled'             => '如果您只启用了一种货币，就不需要添加汇率。',

    // Financial administrations
    'administration_index'                      => '财务管理',
    'administrations_breadcrumb'                => '财务管理',
    'administrations_page_title'                => '财务管理',
    'administrations_index_menu'                => '财务管理',
    'administrations_page_sub_title'            => '概览',
    'create_administration'                     => '创建新的管理',
    'administration_owner'                      => '管理归属: {{email}}',
    'administration_you'                        => '你的角色: {{role}}',
    'other_users_in_admin'                      => '此管理中的其他用户',
    'administrations_create_breadcrumb'         => '创建新的财务管理',
    'administrations_page_create_sub_title'     => '创建新的财务管理',
    'basic_administration_information'          => '基础管理信息',
    'new_administration_created'                => '新的财务管理 "{{title}}" 已创建',
    'edit_administration_breadcrumb'            => '编辑财务管理 ":title"',
    'administrations_page_edit_sub_title'       => '编辑财务管理 ":title"',
    'administrations_page_edit_sub_title_js'    => '编辑财务管理{title}',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => '已更新管理 ":title"',
    'flash_administration_created'              => '已创建管理 ":title"',
    'flash_administration_deleted'              => '已删除管理 ":title"',

    // roles
    'administration_role_owner'                 => '所有者',
    'administration_role_ro'                    => '只读',
    'administration_role_mng_trx'               => '管理交易',
    'administration_role_mng_meta'              => '管理分类和元数据',
    'administration_role_mng_budgets'           => '管理预算',
    'administration_role_mng_piggies'           => '管理存钱罐',
    'administration_role_mng_subscriptions'     => '管理订阅',
    'administration_role_mng_rules'             => '管理规则',
    'administration_role_mng_recurring'         => '管理定期交易',
    'administration_role_mng_webhooks'          => '管理 Webhooks',
    'administration_role_mng_currencies'        => '管理币种',
    'administration_role_view_reports'          => '查看报表',
    'administration_role_full'                  => '完全访问权限',

    // mfa
    'enable_mfa'                                => '启用多因素认证',
    'mfa_index_title'                           => '多因素认证',
    'mfa_index_intro'                           => 'Firefly III 支持多因素认证（MFA）。 您可以为您的帐户启用多因素认证来添加额外的一层安全保护。诸如 Authy、Google Authenticator 和 FreeOTP 之类的应用程序可以用于生成您需要登录的代码。 Firefly III 不支持安全密钥，但您可以使用安全密钥作为您的多因素认证密钥的存储设备。',
    'mfa_index_enabled'                         => '您的帐户已启用多因素认证。',
    'mfa_index_disabled'                        => '您的帐户未启用多因素认证。',
    'mfa_index_owner'                           => '此实例的所有者将始终能够禁用您账户的多因素认证。',
    'current_password_confirm_mfa'              => '输入您当前的密码',
    'mfa_warning_code_changes'                  => '您会在输入密码和多因素认证的验证码后看到一个多因素认证的对话框。在这种情况下，请等待您的应用程序生成一个新的多因素认证的验证码，不要再使用您刚刚用过的验证码。',
    'mfa_already_disabled'                      => '多因素认证未启用，所以您无法禁用它。',
    'disable_mfa_page'                          => '禁用多因素认证',
    'disable_mfa_intro'                         => '您可以禁用多因素认证，要禁用的话，请输入您的密码和多因素认证验证码。 如果您是因为失去了对代码生成器的访问权限，从而想要禁用多因素认证， <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">请参考该文档</a>。',
    'pref_disable_mfa'                          => '禁用多因素认证',
    'mfa_not_enabled'                           => '多因素认证未启用。',
    'mfa_backup_codes_intro'                    => 'Firefly III 可以为您生成备用代码。当您不能使用验证代码生成器时，这些代码可以用于登录。 您可以随时生成一套新的代码。如果您生成新的备用代码，旧的备用代码将失效。',
    'mfa_backup_codes_quick'                    => '如果您刚刚从多因素认证的设置页面跳转过来，您的应用可能还没有生成新的验证码。 请注意多因素认证的验证码只能使用一次。请确保您使用不同于前一个的新验证码。',
    'mfa_backup_codes_title'                    => '多因素认证备用代码',
    'mfa_backup_codes_post_title'               => '多因素认证备用代码',

    // profile:
    'manage_mfa_settings'                       => '管理多因素认证设置',
    'purge_data_title'                          => '从 Frefly III 清除数据',
    'purge_data_expl'                           => '“清除”是指“删除已经删除的内容”。在正常情况下，Firefly III 不会永久删除记录，只是将其隐藏。下面的按钮会将先前“已删除”的记录永久删除。',
    'delete_stuff_header'                       => '删除数据',
    'purge_all_data'                            => '彻底删除所有已删除的记录',
    'purge_data'                                => '彻底清除数据',
    'purged_all_records'                        => '所有已删除的记录已被彻底清除。',
    'delete_data_title'                         => '从 Firefly III 删除数据',
    'permanent_delete_stuff'                    => '你可以从 Firefly III 删除数据。使用下列按钮意味着你的数据会从视图中移除并隐藏。这些操作没有撤销按钮，但如果必要的话，你可以从数据库中找回数据，它们可能仍然存在于数据库中。',
    'other_sessions_logged_out'                 => '所有其他设备已退出登录。',
    'delete_unused_accounts'                    => '删除未使用的账户会清空您的自动补全列表。',
    'delete_all_unused_accounts'                => '删除未使用的账户',
    'deleted_all_unused_accounts'               => '所有未使用的账户都已删除',
    'delete_all_budgets'                        => '删除所有预算',
    'delete_all_categories'                     => '删除所有分类',
    'delete_all_tags'                           => '删除所有标签',
    'delete_all_bills'                          => '删除您所有的订阅',
    'delete_all_piggy_banks'                    => '删除所有存钱罐',
    'delete_all_rules'                          => '删除所有规则',
    'delete_all_recurring'                      => '删除所有定期交易',
    'delete_all_object_groups'                  => '删除所有组',
    'delete_all_accounts'                       => '删除所有账户',
    'delete_all_asset_accounts'                 => '删除所有资产账户',
    'delete_all_expense_accounts'               => '删除所有支出账户',
    'delete_all_revenue_accounts'               => '删除所有收入账户',
    'delete_all_liabilities'                    => '删除所有债务',
    'delete_all_transactions'                   => '删除所有交易',
    'delete_all_withdrawals'                    => '删除所有支出',
    'delete_all_deposits'                       => '删除所有收入',
    'delete_all_transfers'                      => '删除所有转账',
    'also_delete_transactions'                  => '删除账户将同时删除所有关联的收入、支出和转账！',
    'deleted_all_budgets'                       => '所有预算已被删除',
    'deleted_all_categories'                    => '所有分类已被删除',
    'deleted_all_tags'                          => '所有标签已被删除',
    'deleted_all_bills'                         => '所有订阅已删除',
    'deleted_all_piggy_banks'                   => '所有存钱罐已被删除',
    'deleted_all_rules'                         => '所有规则和规则组已被删除',
    'deleted_all_object_groups'                 => '所有组已被删除',
    'deleted_all_accounts'                      => '所有账户已被删除',
    'deleted_all_asset_accounts'                => '所有资产账户已被删除',
    'deleted_all_expense_accounts'              => '所有支出账户已被删除',
    'deleted_all_revenue_accounts'              => '所有收入账户已被删除',
    'deleted_all_liabilities'                   => '所有债务已被删除',
    'deleted_all_transactions'                  => '所有交易已被删除',
    'deleted_all_withdrawals'                   => '所有支出已被删除',
    'deleted_all_deposits'                      => '所有收入已被删除',
    'deleted_all_transfers'                     => '所有转账已被删除',
    'deleted_all_recurring'                     => '所有定期交易已被删除',
    'change_your_password'                      => '更改您的密码',
    'delete_account'                            => '删除账户',
    'current_password'                          => '当前密码',
    'new_password'                              => '新密码',
    'new_password_again'                        => '新密码 (再输入一次)',
    'delete_your_account'                       => '删除您的账户',
    'delete_your_account_help'                  => '删除您的账户亦将删除所有创建的账户、交易，包括<em>所有</em>您存在 Firefly III 的内容都将被清除！',
    'delete_your_account_password'              => '输入您的密码以继续。',
    'password'                                  => '密码',
    'are_you_sure'                              => '是否确定？您无法还原此操作。',
    'are_you_sure_confirm'                      => '您确定吗？',
    'delete_account_button'                     => '删除您的账户',
    'invalid_current_password'                  => '无效的当前密码！',
    'password_changed'                          => '已变更密码！',
    'should_change'                             => '我们的想法是更改您的密码。',
    'invalid_password'                          => '无效密码！',
    'what_is_pw_security'                       => '什么是“验证密码安全”？',
    'secure_pw_title'                           => '如何选择安全密码',
    'forgot_password_response'                  => '谢谢，如果此电子邮件地址的账户存在，您将在收件箱中找到说明。',
    'secure_pw_history'                         => '每周都能看到有关网站泄漏用户密码的新闻，黑客与小偷会使用这些窃取您的个人信息，这些信息价值不菲。',
    'secure_pw_ff'                              => '您在网上使用的密码都一样吗？如果一个网站泄漏了您的密码，黑客将可获取您的所有资料。Firefly III 需要您选择强大且独特的密码以保护您的财务记录。',
    'secure_pw_check_box'                       => '为了协助您使用安全密码，Firefly III 可自动检查您的密码过去是否已被盗用。若如此，Firefly III 建议您不要使用此密码。',
    'secure_pw_working_title'                   => '它是如何运作的？',
    'secure_pw_working'                         => '勾选此复选框后，Firefly III 会发送您密码的 SHA1 哈希值的前5个字符至 <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">Troy Hunt 网站</a> 以检查是否被泄漏。根据 <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">NIST 特殊刊物</a> 的建议，我们将阻止您使用不安全的密码。',
    'secure_pw_should'                          => '我应该勾选此复选框吗？',
    'secure_pw_long_password'                   => '是的，请总是验证您的密码是安全的。',
    'command_line_token'                        => '命令行令牌',
    'explain_command_line_token'                => '您需要此令牌进行命令行操作，例如导出数据等。若没有令牌，敏感操作将无法完成。请勿泄漏您的命令行令牌，包括开发者在内的任何人都无权向您索要。如果您不小心泄漏或遗失了令牌，请使用此按钮重新生成。',
    'regenerate_command_line_token'             => '重新生成命令行令牌',
    'token_regenerated'                         => '已生成新的命令行令牌',
    'change_your_email'                         => '更改您的电子邮件地址',
    'email_verification'                        => '您的旧邮件地址和新邮件地址都将收到一封邮件。出于安全考虑，您在验证新的电子邮件地址前将无法登录。如果您不确定此 Firefly III 站点是否能发送邮件，请不要使用此功能。如果您是站点管理员，您可以在<a href="admin">管理页面</a>进行测试。',
    'email_changed_logout'                      => '在验证您的电子邮件地址之前，您无法登入。',
    'login_with_new_email'                      => '现在，您可以使用新的电子邮件地址登入。',
    'login_with_old_email'                      => '现在，您可以再次使用旧的电子邮件地址登入。',
    'login_provider_local_only'                 => '当藉由 ":login_provider" 验证时，此动作不可用。',
    'external_user_mgt_disabled'                => '当 Firefly III 不负责用户管理或身份验证时，此操作不可用。',
    'external_auth_disabled'                    => '当 Firefly III 不负责身份验证时，此操作不可用。',
    'delete_local_info_only'                    => "由于 Firefly III 不负责用户管理和身份验证时，此操作将仅删除 Firefly III 本地的信息。",
    'oauth'                                     => 'OAuth 授权',
    'profile_oauth_clients'                     => 'OAuth 客户端',
    'profile_oauth_no_clients'                  => '您尚未创建任何 OAuth 客户端。',
    'profile_oauth_clients_external_auth'       => '如果您正在使用如 Authelia 的外部身份验证提供商，OAuth 客户端将无法工作。您只能使用个人访问令牌。',
    'profile_oauth_clients_header'              => '客户端',
    'profile_oauth_client_id'                   => '客户端 ID',
    'profile_oauth_client_name'                 => '名称',
    'profile_oauth_client_secret'               => '密钥',
    'profile_oauth_create_new_client'           => '创建新客户端',
    'profile_oauth_create_client'               => '创建客户端',
    'profile_oauth_edit_client'                 => '编辑客户端',
    'profile_oauth_name_help'                   => '您的用户可以识别并信任的信息',
    'profile_oauth_redirect_url'                => '跳转网址',
    'profile_oauth_redirect_url_help'           => '您的应用程序的授权回调网址',
    'profile_authorized_apps'                   => '已授权应用',
    'profile_authorized_clients'                => '已授权客户端',
    'profile_scopes'                            => '范围',
    'profile_revoke'                            => '撤消',
    'profile_oauth_client_secret_title'         => '客户端密钥',
    'profile_oauth_client_secret_expl'          => '请妥善保存您的新客户端的密钥，此密钥仅会在这里展示一次。您现在已可以使用此密钥进行 API 请求。',
    'profile_personal_access_tokens'            => '个人访问令牌',
    'profile_personal_access_token'             => '个人访问令牌',
    'profile_oauth_confidential'                => '使用加密',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => '请妥善保存您的新个人访问令牌，此令牌仅会在这里展示一次。您现在已可以使用此令牌进行 API 请求。',
    'profile_no_personal_access_token'          => '您还没有创建个人访问令牌。',
    'profile_create_new_token'                  => '创建新令牌',
    'profile_create_token'                      => '创建令牌',
    'profile_create'                            => '创建',
    'profile_save_changes'                      => '保存更改',
    'profile_whoops'                            => '很抱歉！',
    'profile_something_wrong'                   => '发生错误！',
    'profile_try_again'                         => '发生错误，请稍后再试。',
    'amounts'                                   => '金额',
    'multi_account_warning_unknown'             => '根据您创建的交易类型，后续拆分的来源和/或目标账户可能被交易的首笔拆分的配置所覆盖。',
    'multi_account_warning_withdrawal'          => '请注意，后续拆分的来源账户将会被支出的首笔拆分的配置所覆盖。',
    'multi_account_warning_deposit'             => '请注意，后续拆分的目标账户将会被收入的首笔拆分的配置所覆盖。',
    'multi_account_warning_transfer'            => '请注意，后续拆分的来源和目标账户将会被转账的首笔拆分的配置所覆盖。',


    // export data:
    'export_data_title'                         => '从 Firefly III 导出数据',
    'export_data_menu'                          => '导出数据',
    'export_data_bc'                            => '从 Firefly III 导出数据',
    'export_data_main_title'                    => '从 Firefly III 导出数据',
    'export_data_expl'                          => '此链接允许您从 Firefly III 导出所有交易和元数据。请查看帮助 (右上角的问号 (?) 图标) 获取更多有关信息。',
    'export_data_all_transactions'              => '导出所有交易',
    'export_data_advanced_expl'                 => '如果您需要更高级或特殊类型的导出功能，请阅读如何使用命令行 <code>php artisan help firefly-iii:export-data</code> 的帮助内容。',

    // attachments
    'nr_of_attachments'                         => '1个附件|:count个附件',
    'attachments'                               => '附件',
    'edit_attachment'                           => '编辑附件“:name”',
    'update_attachment'                         => '更新附件',
    'delete_attachment'                         => '删除附件“:name”',
    'attachment_deleted'                        => '已删除附件“:name”',
    'liabilities_deleted'                       => '已删除债务 ":name"',
    'attachment_updated'                        => '已更新附件“:name”',
    'upload_max_file_size'                      => '最大文件尺寸：:size',
    'list_all_attachments'                      => '附件列表',

    // transaction index
    'is_reconciled_fields_dropped'              => '因为这笔交易已经对账，您将无法更新帐户，也无法更新金额，除非您移除对账标记。',
    'is_reconciled'                             => '已核销',
    'title_expenses'                            => '支出',
    'title_withdrawal'                          => '支出',
    'title_revenue'                             => '收入',
    'title_deposit'                             => '收入',
    'title_transfer'                            => '转账',
    'title_transfers'                           => '转账',
    'submission_options'                        => '提交选项',
    'apply_rules_checkbox'                      => '应用规则',
    'fire_webhooks_checkbox'                    => '触发 webhook',
    'select_source_account'                     => '请选择或输入一个有效的源帐户名称',
    'select_dest_account'                       => '请选择或输入一个有效的目标帐户名称',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => '此交易已经为支出',
    'convert_is_already_type_Deposit'           => '此交易已经为收入',
    'convert_is_already_type_Transfer'          => '此交易已经为转账',
    'convert_to_Withdrawal'                     => '转换“:description”为支出',
    'convert_to_Deposit'                        => '转换“:description”为收入',
    'convert_to_Transfer'                       => '转换“:description”为转账',
    'convert_options_WithdrawalDeposit'         => '将支出转换为收入',
    'convert_options_WithdrawalTransfer'        => '将支出转换为转账',
    'convert_options_DepositTransfer'           => '将收入转换为转账',
    'convert_options_DepositWithdrawal'         => '将收入转换为支出',
    'convert_options_TransferWithdrawal'        => '将转账转换为支出',
    'convert_options_TransferDeposit'           => '将转账转换为收入',
    'convert_Withdrawal_to_deposit'             => '将此支出转换为收入',
    'convert_Withdrawal_to_transfer'            => '将此支出转换为转账',
    'convert_Deposit_to_withdrawal'             => '将此收入转换为支出',
    'convert_Deposit_to_transfer'               => '将此收入转换为转账',
    'convert_Transfer_to_deposit'               => '将此转账转换为收入',
    'convert_Transfer_to_withdrawal'            => '将此转账转换为支出',
    'convert_please_set_revenue_source'         => '请选择资金来源的收入账户',
    'convert_please_set_asset_destination'      => '请选择资金流向的资产账户',
    'convert_please_set_expense_destination'    => '请选择资金流向的支出账户',
    'convert_please_set_asset_source'           => '请选择资金来源的资产账户',
    'convert_expl_w_d'                          => '将支出转换为收入时，资金将会存入显示的目标账户，而不是取出。|将支出转换为收入时，资金将会存入显示的目标账户，而不是取出。',
    'convert_expl_w_t'                          => '将支出转换为转账时，资金将会从来源账户转到其他资产或债务账户，而不是在原支出账户上消费。|将支出转换为转账时，资金将会从来源账户转到其他资产或债务账户，而不是在原支出账户上消费。',
    'convert_expl_d_w'                          => '将收入转换为支出时，资金将会从显示的来源账户中取出，而不是存入。|将收入转换为支出时，资金将会从显示的来源账户中取出，而不是存入。',
    'convert_expl_d_t'                          => '将收入转换为转账时，资金将会从任意资产或债务账户存入列出的目标账户中。|将收入转换为转账时，资金将会从任意资产或债务账户存入列出的目标账户中。',
    'convert_expl_t_w'                          => '将转账转换为支出时，资金将会在此处设定的目标账户上被消费，而不是被转走。|将转账转换为支出时，资金将会在此处设定的目标账户上被消费，而不是被转走。',
    'convert_expl_t_d'                          => '将转账转换为收入时，资金将会被存入此处列出的目标账户，而不是转入。|将转账转换为收入时，资金将会被存入此处列出的目标账户，而不是转入。',
    'convert_select_sources'                    => '要完成转换，请在下方设置新的来源账户。|要完成转换，请在下方设置新的来源账户。',
    'convert_select_destinations'               => '要完成转换，请在下方设置新的目标账户。|要完成转换，请在下方设置新的目标账户。',
    'converted_to_Withdrawal'                   => '此交易已被转换为支出',
    'converted_to_Deposit'                      => '此交易已被转换为收入',
    'converted_to_Transfer'                     => '此交易已被转换为转账',
    'invalid_convert_selection'                 => '您选择的账户已用于此交易或不存在。',
    'source_or_dest_invalid'                    => '找不到正确的交易细节，无法转换。',
    'convert_to_withdrawal'                     => '转换为支出',
    'convert_to_deposit'                        => '转换为收入',
    'convert_to_transfer'                       => '转换为转账',

    // create new stuff:
    'create_new_withdrawal'                     => '创建新支出',
    'create_new_deposit'                        => '创建新收入',
    'create_new_transfer'                       => '创建新转账',
    'create_new_asset'                          => '创建新资产账户',
    'create_new_liabilities'                    => '创建新债务',
    'create_new_expense'                        => '创建新支出账户',
    'create_new_revenue'                        => '创建新收入账户',
    'create_new_piggy_bank'                     => '创建新存钱罐',
    'create_new_bill'                           => '创建新账单',
    'create_new_subscription'                   => '创建新账单',
    'create_new_rule'                           => '创建新规则',

    // currencies:
    'create_currency'                           => '创建新货币',
    'store_currency'                            => '保存新货币',
    'update_currency'                           => '更新货币',
    'new_default_currency'                      => '当前默认货币为“:name”',
    'default_currency_failed'                   => '无法将“:name”设置为默认货币，请检查日志。',
    'cannot_delete_currency'                    => '因为仍在使用中，无法删除 :name 。',
    'cannot_delete_fallback_currency'           => ':name 是系统默认货币，无法删除',
    'cannot_disable_currency_journals'          => '无法禁用 :name，因为仍有交易在使用。',
    'cannot_disable_currency_last_left'         => '无法禁用 :name，因为它是目前唯一启用的货币。',
    'cannot_disable_currency_account_meta'      => '无法禁用 :name，因为它已被用于资产账户。',
    'cannot_disable_currency_bills'             => '无法禁用 :name，因为它仍在订阅账单中使用。',
    'cannot_disable_currency_recurring'         => '无法禁用 :name，定期交易正在使用此货币',
    'cannot_disable_currency_available_budgets' => '无法禁用 :name，因为它仍在预算中被使用。',
    'cannot_disable_currency_budget_limits'     => '无法禁用 :name，因为它仍在预算中被使用。',
    'cannot_disable_currency_current_default'   => '无法禁用 :name ，因为它是当前的默认货币。',
    'cannot_disable_currency_system_fallback'   => '无法禁用 :name ，因为它是系统默认货币。',
    'disable_EUR_side_effects'                  => '欧元是此系统的紧急备用货币。禁用它可能会产生意外的副作用，并可能使您的修改无效。',
    'deleted_currency'                          => ':name 货币已删除',
    'created_currency'                          => '货币 :name 已创建',
    'could_not_store_currency'                  => '无法保存新货币。',
    'updated_currency'                          => ':name 货币已更新',
    'ask_site_owner'                            => '请联系管理员 :owner 新增、删除或编辑货币。',
    'currencies_intro'                          => 'Firefly III 支持多种货币，您可在此设置并启用。',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => '设为默认',
    'default_currency'                          => '默认',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => '已停用',
    'enable_currency'                           => '启用',
    'disable_currency'                          => '停用',
    'currencies_default_disabled'               => '大多数的货币均默认为停用，若需使用，请先启用。',
    'currency_is_now_enabled'                   => '货币 ":name" 已被启用',
    'could_not_enable_currency'                 => '无法启用货币“:name”，请检查日志。',
    'currency_is_now_disabled'                  => '货币 ":name" 已被停用',
    'could_not_disable_currency'                => '无法禁用货币“:name”，可能仍在使用？',

    // forms:
    'mandatoryFields'                           => '必填字段',
    'optionalFields'                            => '选填字段',
    'options'                                   => '选项',

    // budgets:
    'daily_budgets'                             => '每日预算',
    'weekly_budgets'                            => '每周预算',
    'monthly_budgets'                           => '每月预算',
    'quarterly_budgets'                         => '每季度预算',
    'half_year_budgets'                         => '每半年预算',
    'yearly_budgets'                            => '每年预算',
    'other_budgets'                             => '自定义区间预算',
    'budget_limit_not_in_range'                 => '此金额应用于 :start 至 :end：',
    'total_available_budget'                    => '可用预算总额 (:start – :end)',
    'total_available_budget_in_currency'        => '可用预算总额 (:currency)',
    'see_below'                                 => '见下方',
    'create_new_budget'                         => '创建新预算',
    'store_new_budget'                          => '保存新预算',
    'stored_new_budget'                         => '已保存新预算“:name”',
    'available_between'                         => ':start – :end 可用',
    'transactionsWithoutBudget'                 => '无预算支出',
    'transactions_no_budget'                    => ':start – :end 的无预算支出',
    'spent_between'                             => ':start – :end 的支出',
    'spent_between_left'                        => '在 :start 和 :end之间消耗 :spent ，剩下 :left。',
    'set_available_amount'                      => '设置可用金额',
    'update_available_amount'                   => '更新可用金额',
    'ab_basic_modal_explain'                    => '使用此表单来指定您预期在指定周期内的预算总额 (:currency)。',
    'createBudget'                              => '新预算',
    'invalid_currency'                          => '这是一个无效的货币',
    'invalid_amount'                            => '请输入金额',
    'set_ab'                                    => '可用预算金额已设置',
    'updated_ab'                                => '可用预算金额已更新',
    'deleted_ab'                                => '可用预算金额已删除',
    'deleted_bl'                                => '预算金额已移除',
    'alt_currency_ab_create'                    => '以其他货币为单位设置可用预算',
    'bl_create_btn'                             => '以其他货币为单位设置预算',
    'inactiveBudgets'                           => '已停用预算',
    'without_budget_between'                    => ':start – :end 的无预算交易',
    'delete_budget'                             => '删除预算 ":name"',
    'deleted_budget'                            => '已删除预算 ":name"',
    'edit_budget'                               => '编辑预算 ":name"',
    'updated_budget'                            => '预算 ":name" 已更新',
    'update_amount'                             => '更新金额',
    'update_budget'                             => '更新预算',
    'update_budget_amount_range'                => '更新 (预期) :start – :end 的可用金额',
    'set_budget_limit_title'                    => '为预算“:budget"设置 :start – :end 的预算金额',
    'set_budget_limit'                          => '设置预算金额',
    'budget_period_navigator'                   => '周期导航',
    'info_on_available_amount'                  => '我有甚麽可用？',
    'available_amount_indication'               => '使用这些金额以获得您总预算可能为何的指标',
    'suggested'                                 => '建议',
    'average_between'                           => ':start – :end 的平均值',
    'transferred_in'                            => '转账 (转入)',
    'transferred_away'                          => '转账 (转出)',
    'auto_budget_none'                          => '无自动预算',
    'auto_budget_reset'                         => '设置每个周期的固定金额',
    'auto_budget_rollover'                      => '每个周期添加金额',
    'auto_budget_adjusted'                      => '每周期增加一个金额并纠正超支',
    'auto_budget_period_daily'                  => '每日',
    'auto_budget_period_weekly'                 => '每周',
    'auto_budget_period_monthly'                => '每月',
    'auto_budget_period_quarterly'              => '每季度',
    'auto_budget_period_half_year'              => '每半年',
    'auto_budget_period_yearly'                 => '每年',
    'auto_budget_help'                          => '您可以在帮助页面了解此功能的更多信息，点击右上角的问号 (?) 图标即可。',
    'auto_budget_reset_icon'                    => '此预算将周期性设置',
    'auto_budget_rollover_icon'                 => '此预算的金额将周期性增加',
    'auto_budget_adjusted_icon'                 => '预算金额将定期增加，并将纠正超支',
    'remove_budgeted_amount'                    => '移除预算上限 (:currency)',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => '使用跳过字段创建自定义间隔 (例如设置跳过 = 1 将创建每 2 个月一次的间隔)',
    'subscription'                              => '订阅',
    'not_expected_period'                       => '此周期没有预期支付',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => '尚未',
    'visit_bill'                                => '在Firefly III中访问名为“:name”的订阅',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => '订阅匹配 :low 和 :high 之间的交易。',
    'running_again_loss'                        => '以前连接到此订阅的交易可能会失去连接，如果它们(不再)符合规则(s)。',
    'bill_related_rules'                        => '与此账单相关的规则',
    'repeats'                                   => '重复',
    'bill_end_date_help'                        => '可选字段。订阅预计将在此日期结束。',
    'bill_extension_date_help'                  => '可选字段。订阅必须在此日期或之前延长(或取消)。',
    'bill_end_index_line'                       => '此周期性账单结束于 :date',
    'bill_extension_index_line'                 => '此账单必须在 :date 延续或取消',
    'connected_journals'                        => '已关联交易',
    'auto_match_on'                             => '由 Firefly III 自动匹配',
    'auto_match_off'                            => '未由 Firefly III 自动匹配',
    'next_expected_match'                       => '预期下次支付',
    'delete_bill'                               => '删除周期性账单 ":name"',
    'deleted_bill'                              => '已删除周期性账单 ":name"',
    'edit_bill'                                 => '编辑周期性账单 ":name"',
    'more'                                      => '更多',
    'rescan_old'                                => '再次于所有交易执行规则',
    'update_bill'                               => '更新账单',
    'updated_bill'                              => '已更新周期性账单 ":name"',
    'store_new_bill'                            => '创建新周期性账单',
    'stored_new_bill'                           => '已保存周期性账单 ":name"',
    'cannot_scan_inactive_bill'                 => '已停用的周期性账单无法被扫描。',
    'rescanned_bill'                            => '重新扫描了所有内容，并关联了:count笔交易到账单。|重新扫描了所有内容，并关联了:count笔交易到订阅账单。',
    'average_bill_amount_year'                  => '平均周期性账单金额 (:year)',
    'average_bill_amount_overall'               => '平均周期性账单金额 (总体)',
    'bill_is_active'                            => '周期性账单已生效',
    'bill_expected_between'                     => ':start – :end 的预期值',
    'bill_will_automatch'                       => '周期性账单将自动关联至符合的交易',
    'skips_over'                                => '跳过',
    'bill_store_error'                          => '存储您的新订阅时发生意外错误。请检查日志文件',
    'list_inactive_rule'                        => '已停用的规则',
    'bill_edit_rules'                           => 'Fifly III 将尝试编辑与此订阅相关的规则。 但是，如果你自己已经编辑了这条规则，Firefly III不会改变任何东西。 Firefly III 将尝试编辑与此订阅相关的 :count 规则。 如果您已经编辑了这些规则，Firefly III将不会改变任何东西。',
    'bill_expected_date'                        => '预期为:date',
    'bill_expected_date_js'                     => '已延续至{date}',
    'expected_amount'                           => '(预期) 金额',
    'bill_paid_on'                              => '支付于 {date}',
    'bill_repeats_weekly'                       => '每周',
    'bill_repeats_monthly'                      => '每月',
    'bill_repeats_quarterly'                    => '每季度',
    'bill_repeats_half-year'                    => '每半年',
    'bill_repeats_yearly'                       => '每年',
    'bill_repeats_weekly_other'                 => '每隔一周',
    'bill_repeats_monthly_other'                => '每隔一个月重复',
    'bill_repeats_quarterly_other'              => '每隔一季度重复',
    'bill_repeats_half-year_other'              => '每年重复',
    'bill_repeats_yearly_other'                 => '每隔一年重复',
    'bill_repeats_weekly_skip'                  => '每 {skip} 周重复',
    'bill_repeats_monthly_skip'                 => '每 {skip} 个月重复',
    'bill_repeats_quarterly_skip'               => '每 {skip} 个季度重复',
    'bill_repeats_half-year_skip'               => '每 {skip} 半年重复',
    'bill_repeats_yearly_skip'                  => '每 {skip} 年重复',
    'subscriptions'                             => '订阅',
    'go_to_subscriptions'                       => '前往我的订阅',
    'forever'                                   => '永久',
    'extension_date_is'                         => '延续日期是{date}',

    // accounts:
    'account_locked_currency'                   => '只要存钱罐与该帐户已关联，此帐户的货币就必须保持 :name。',
    'i_am_owed_amount'                          => '借款金额',
    'i_owe_amount'                              => '欠款金额',
    'inactive_account_link'                     => '您有 :count 个已停用 (已归档) 的账户，您可以在此独立页面中查看。|您有 :count 个已停用 (已归档) 的账户，您可以在此独立页面中查看。',
    'all_accounts_inactive'                     => '这些是您的已停用账户。',
    'active_account_link'                       => '此链接返回到您的已启用账户。',
    'account_missing_transaction'               => '账户 #:id (:name) 无法直接显示，因为 Firefly 找不到重定向信息。',
    'cc_monthly_payment_date_help'              => '随便选择“年”和“月”，其数据都将被忽略，仅“日”会被使用。',
    'details_for_asset'                         => '资产账户“:name”的详细信息',
    'details_for_expense'                       => '支出账户“:name”的详细信息',
    'details_for_revenue'                       => '收入账户“:name”的详细信息',
    'details_for_cash'                          => '现金账户“:name”的详细信息',
    'store_new_asset_account'                   => '保存新资产账户',
    'store_new_expense_account'                 => '保存新支出账户',
    'store_new_revenue_account'                 => '保存新收入账户',
    'edit_asset_account'                        => '编辑资产账户“:name”',
    'edit_expense_account'                      => '编辑支出账户“:name”',
    'edit_revenue_account'                      => '编辑收入账户“:name”',
    'delete_asset_account'                      => '删除资产账户“:name”',
    'delete_expense_account'                    => '删除支出账户“:name”',
    'delete_revenue_account'                    => '删除收入账户“:name”',
    'delete_liabilities_account'                => '删除债务账户“:name”',
    'asset_deleted'                             => '已成功删除资产账户“:name”',
    'account_deleted'                           => '已成功删除账户“:name”',
    'expense_deleted'                           => '已成功删除支出账户“:name”',
    'revenue_deleted'                           => '已成功删除收入账户“:name”',
    'update_asset_account'                      => '更新资产账户',
    'update_undefined_account'                  => '更新账户',
    'update_liabilities_account'                => '更新债务账户',
    'update_expense_account'                    => '更新支出账户',
    'update_revenue_account'                    => '更新收入账户',
    'make_new_asset_account'                    => '创建新资产账户',
    'make_new_expense_account'                  => '创建新支出账户',
    'make_new_revenue_account'                  => '创建新收入账户',
    'make_new_liabilities_account'              => '创建新债务账户',
    'asset_accounts'                            => '资产账户',
    'undefined_accounts'                        => '账户',
    'asset_accounts_inactive'                   => '资产账户 (已停用)',
    'expense_account'                           => '支出账户',
    'expense_accounts'                          => '支出账户',
    'expense_accounts_inactive'                 => '支出账户 (已停用)',
    'revenue_account'                           => '收入账户',
    'revenue_accounts'                          => '收入账户',
    'revenue_accounts_inactive'                 => '收入账户 (已停用)',
    'cash_accounts'                             => '现金账户',
    'Cash account'                              => '现金账户',
    'liabilities_accounts'                      => '债务账户',
    'liabilities_accounts_inactive'             => '债务账户 (已停用)',
    'reconcile_account'                         => '对账账户“:account”',
    'overview_of_reconcile_modal'               => '对帐概览',
    'delete_reconciliation'                     => '删除对帐',
    'update_reconciliation'                     => '更新对账',
    'amount_cannot_be_zero'                     => '金额不能为零',
    'end_of_reconcile_period'                   => '对帐区间结束: :period',
    'start_of_reconcile_period'                 => '对帐区间开始: :period',
    'start_balance'                             => '初始余额',
    'end_balance'                               => '结束余额',
    'update_balance_dates_instruction'          => '将您的银行账单与金额和日期进行匹配，并点击“开始对账”',
    'select_transactions_instruction'           => '选择您银行账单上显示的交易。',
    'select_range_and_balance'                  => '首先验证日期范围与余额，然后点击“开始对账”',
    'date_change_instruction'                   => '如果您现在变更日期范围，任何进度均将遗失。',
    'update_selection'                          => '更新所选项',
    'store_reconcile'                           => '保存对账',
    'reconciliation_transaction'                => '对帐交易',
    'Reconciliation'                            => '对帐',
    'reconciliation'                            => '对帐',
    'reconcile_options'                         => '对帐选项',
    'reconcile_range'                           => '对账范围',
    'start_reconcile'                           => '开始对帐',
    'cash_account_type'                         => '现金账户',
    'cash'                                      => '现金',
    'cant_find_redirect_account'                => '很抱歉，Firefly III 无法跳转。正在返回主页...',
    'account_type'                              => '账户类型',
    'save_transactions_by_moving'               => '将此交易移动到另一个账户并保存：|将这些交易移动到另一个账户并保存：',
    'save_transactions_by_moving_js'            => '没有交易|将该交易转移到另一个账户，以保存该交易。|通过将它们转移到另一个账户保存这些交易。',
    'stored_new_account'                        => '新账户“:name”已保存！',
    'stored_new_account_js'                     => '新账户"<a href="accounts/show/{ID}">{name}</a>"已保存',
    'updated_account'                           => '账户“:name”已更新',
    'updated_account_js'                        => '已更新账户“<a href="accounts/show/{ID}">”。',
    'credit_card_options'                       => '信用卡选项',
    'no_transactions_account'                   => '资产账户“:name”没有交易 (此周期内)。',
    'no_transactions_period'                    => '无交易 (此周期内)',
    'no_data_for_chart'                         => '目前还没有足够的信息以生成图表。',
    'select_at_least_one_account'               => '选择至少一个资产账户',
    'select_at_least_one_category'              => '选择至少一个分类',
    'select_at_least_one_budget'                => '选择至少一个预算',
    'select_at_least_one_tag'                   => '选择至少一个标签',
    'select_at_least_one_expense'               => '请选择至少一个支出/收入账户的组合，若无 (即列表为空) 则此报表不可用。',
    'account_default_currency'                  => '这将是与此账户关连的默认货币。',
    'piggy_default_currency'                    => '存钱罐只能存储单一货币。',
    'piggy_account_currency_match'              => '仅支持与您上面选择的货币相同的帐户。',
    'reconcile_has_more'                        => '您的 Firefly III 帐目比您的银行有更多的金钱，有多个选项可应处，请选择并按下 "确认对帐"。',
    'reconcile_has_less'                        => '您的 Firefly III 帐目比您的银行有更少的金钱，有多个选项可应处，请选择并按下 "确认对帐"。',
    'reconcile_is_equal'                        => '您的 Firefly III 账目和您的银行账单相符，无须处理，点击“确认对账”来确认输入。',
    'create_pos_reconcile_transaction'          => '核销所选交易，并创建调整记录，向该资产账户增加 :amount。',
    'create_neg_reconcile_transaction'          => '核销所选交易，并创建调整记录，从该资产账户扣除 :amount。',
    'reconcile_do_nothing'                      => '核销所选交易，但不进行调整。',
    'reconcile_go_back'                         => '您可之后再编辑或删除较正。',
    'must_be_asset_account'                     => '您只可以对账资产账户。',
    'reconciliation_stored'                     => '已保存对账',
    'reconciliation_error'                      => '由于一项错误，该笔交易虽被标记为已对账，但相应的修正却没有保存：:error。',
    'reconciliation_transaction_title'          => '对账 (:from 至 :to)',
    'sum_of_reconciliation'                     => '对账总和',
    'reconcile_this_account'                    => '对账此账户',
    'reconcile'                                 => '对账',
    'show'                                      => '显示',
    'confirm_reconciliation'                    => '确认对帐',
    'submitted_start_balance'                   => '初始余额已提交',
    'selected_transactions'                     => '已选择 (:count) 项交易',
    'already_cleared_transactions'              => '已核销的交易(:count)',
    'submitted_end_balance'                     => '已提交结束余额',
    'initial_balance_description'               => '“:account”的初始余额',
    'liability_credit_description'              => '“:account”债务信用',
    'interest_calc_'                            => '未知',
    'interest_calc_daily'                       => '每日',
    'interest_calc_monthly'                     => '每月',
    'interest_calc_yearly'                      => '每年',
    'interest_calc_weekly'                      => '每周',
    'interest_calc_half-year'                   => '每半年',
    'interest_calc_quarterly'                   => '每季度',
    'initial_balance_account'                   => '初始余额账户“:account”',
    'list_options'                              => '列表选项',
    'account_column_opt_drag_and_drop'          => '拖放',
    'account_column_opt_active'                 => '启用',
    'account_column_opt_name'                   => '名称',
    'account_column_opt_type'                   => '类型',
    'account_column_opt_liability_type'         => '债务类型',
    'account_column_opt_liability_direction'    => '债务方向',
    'account_column_opt_liability_interest'     => '债务利息',
    'account_column_opt_number'                 => '账户号码',
    'account_column_opt_current_balance'        => '当前余额',
    'account_column_opt_amount_due'             => '应付金额',
    'account_column_opt_last_activity'          => '最后活动',
    'account_column_opt_balance_difference'     => '余额差',
    'account_column_opt_menu'                   => '菜单',

    // categories:
    'new_category'                              => '新分类',
    'create_new_category'                       => '创建新分类',
    'without_category'                          => '没有分类',
    'update_category'                           => '更新分类',
    'updated_category'                          => '已更新分类“:name”',
    'categories'                                => '分类',
    'edit_category'                             => '编辑分类 “:name”',
    'no_category'                               => '(没有分类)',
    'unknown_category_plain'                    => '没有分类',
    'category'                                  => '分类',
    'delete_category'                           => '删除分类 “:name”',
    'deleted_category'                          => '已删除分类 “:name”',
    'store_category'                            => '保存新分类',
    'stored_category'                           => '已保存新分类“:name”',
    'without_category_between'                  => ':start – :end 没有分类',


    // transactions:
    'wait_loading_transaction'                  => '请等待表单加载',
    'wait_loading_data'                         => '请等待您的信息加载...',
    'wait_attachments'                          => '请等待附件上传。',
    'errors_upload'                             => '上传失败。请检查您的浏览器控制台是否有错误。',
    'amount_foreign_if'                         => '外币金额（如果有的话）',
    'amount_destination_account'                => '目标账户货币金额',
    'edit_transaction_title'                    => '编辑交易":description"',
    'unreconcile'                               => '撤销对账',
    'update_withdrawal'                         => '更新支出',
    'update_deposit'                            => '更新收入',
    'update_transaction'                        => '更新交易',
    'update_transfer'                           => '更新转账',
    'updated_withdrawal'                        => '已更新支出“:description“',
    'updated_deposit'                           => '已更新收入“:description”',
    'updated_transfer'                          => '已更新转账“:description”',
    'no_changes_withdrawal'                     => '支出“:description”未更改。',
    'no_changes_deposit'                        => '收入“:description”未更改。',
    'no_changes_transfer'                       => '转账“:description”未更改。',
    'delete_withdrawal'                         => '删除支出“:description”',
    'delete_deposit'                            => '删除收入“:description”',
    'delete_transfer'                           => '删除转账“:description”',
    'deleted_withdrawal'                        => '已成功删除支出“:description”',
    'deleted_deposit'                           => '已成功删除收入“:description”',
    'deleted_transfer'                          => '已成功删除转账“:description”',
    'deleted_reconciliation'                    => '成功删除对账交易“:description”',
    'stored_journal'                            => '成功创建新交易“:description”',
    'stored_journal_js'                         => '成功创建新交易 "{{description}}"',
    'stored_journal_no_descr'                   => '成功创建您的新交易',
    'updated_journal_no_descr'                  => '成功更新您的交易',
    'select_transactions'                       => '选择交易',
    'rule_group_select_transactions'            => '应用“:title”至交易',
    'rule_select_transactions'                  => '应用“:title”至交易',
    'stop_selection'                            => '停止选取交易',
    'reconcile_selected'                        => '对帐',
    'mass_delete_journals'                      => '删除数个交易',
    'mass_edit_journals'                        => '编辑数个交易',
    'mass_bulk_journals'                        => '批次编辑数个交易',
    'mass_bulk_journals_explain'                => '此表单允许您在单次更新中修改下列交易的属性。当您修改这里所看到的参数时，表格中的所有交易都将被更新。',
    'part_of_split'                             => '此交易是某笔拆分交易的一部分。 如果您没有选择所有的拆分，您最终可能只更改了半笔交易。',
    'bulk_set_new_values'                       => '用下方的输入框设定新值。若空留，则全部会为空值。此外，请注意仅支出会被赋予预算。',
    'no_bulk_category'                          => '不更新分类',
    'no_bulk_budget'                            => '不更新预算',
    'no_bulk_tags'                              => '不更新标签',
    'replace_with_these_tags'                   => '用这些标签替换',
    'append_these_tags'                         => '添加这些标签',
    'mass_edit'                                 => '分开编辑所选项',
    'bulk_edit'                                 => '批量编辑所选项',
    'mass_delete'                               => '删除所选项',
    'cannot_edit_other_fields'                  => '由于页面空间限制，除了此处所示的字段以外，您无法批量编辑其他字段。若您需要编辑其他字段，请点击链接并依次编辑。',
    'cannot_change_amount_reconciled'           => '您不能修改已对账交易的金额或账户。',
    'no_budget'                                 => '(无预算)',
    'no_bill'                                   => '(无订阅)',
    'account_per_budget'                        => '每笔预算的账户',
    'account_per_category'                      => '每个分类的账户',
    'create_new_object'                         => '创建',
    'empty'                                     => '(空)',
    'all_other_budgets'                         => '(所有其他预算)',
    'all_other_accounts'                        => '(所有其他账户)',
    'expense_per_source_account'                => '每个来源账户的支出',
    'expense_per_destination_account'           => '每个目标账户的支出',
    'income_per_destination_account'            => '每个目标账户的收入',
    'spent_in_specific_category'                => '分类“:category”的支出',
    'earned_in_specific_category'               => '在 “:category” 中的收入',
    'spent_in_specific_tag'                     => '标签“:tag”的支出',
    'earned_in_specific_tag'                    => '标签“:tag”中的收入',
    'income_per_source_account'                 => '每个来源账户的收入',
    'average_spending_per_destination'          => '每个目标账户的平均支出',
    'average_spending_per_source'               => '每个来源账户的平均支出',
    'average_earning_per_source'                => '每个来源账户的平均收入',
    'average_earning_per_destination'           => '每个目标账户的平均收入',
    'account_per_tag'                           => '每个标签的账户',
    'tag_report_expenses_listed_once'           => '支出和收入从未列出两次。如果交易有多个标签，它可能只显示在其标签中的一个标签。此列表可能似乎丢失数据，但数额是正确的。',
    'double_report_expenses_charted_once'       => '支出和收入从未显示两次。如果交易有多个标签，它可能只显示在其标签中的一个标签。此图表可能似乎丢失数据，但数额是正确的。',
    'tag_report_chart_single_tag'               => '此图表适用于单一标签。如果交易有多个标签，您可以在其他标签的图表中反映您看到的情况。',
    'tag'                                       => '标签',
    'no_budget_squared'                         => '(无预算)',
    'perm-delete-many'                          => '一次删除多个项目可能非常混乱，请谨慎操作。请注意，您可能从这里删掉含有多笔拆分的交易的其中一部分。',
    'mass_deleted_transactions_success'         => '已删除 :count 条交易。|已删除 :count 条交易。',
    'mass_edited_transactions_success'          => '已更新 :count 条交易。|已更新 :count 条交易。',
    'opt_group_'                                => '(无账户类型)',
    'opt_group_no_account_type'                 => '(无账户类型)',
    'opt_group_defaultAsset'                    => '默认资产账户',
    'opt_group_savingAsset'                     => '储蓄账户',
    'opt_group_sharedAsset'                     => '共用资产账户',
    'opt_group_ccAsset'                         => '信用卡',
    'opt_group_cashWalletAsset'                 => '现金钱包',
    'opt_group_expense_account'                 => '支出账户',
    'opt_group_revenue_account'                 => '收入账户',
    'opt_group_l_Loan'                          => '债务: 贷款',
    'opt_group_cash_account'                    => '现金账户',
    'opt_group_l_Debt'                          => '债务: 欠款',
    'opt_group_l_Mortgage'                      => '债务: 抵押',
    'opt_group_l_Credit card'                   => '债务: 信用卡',
    'notes'                                     => '备注',
    'view_notes'                                => '查看备注',
    'set_budget_limit_notes'                    => '查看这笔预算金额的备注',
    'edit_bl_notes'                             => '编辑备注',
    'update_bl_notes'                           => '更新备注',
    'unknown_journal_error'                     => '无法保存交易，请检查日志文件。',
    'attachment_not_found'                      => '找不到此附件。',
    'journal_link_bill'                         => '此交易已链接到订阅 <a href=":route">:name</a>。要删除连接，取消选中复选框。使用规则将其连接到另一个订阅。',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">交易 #{ID} (“{title}”)</a> 已保存。',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">交易 #{ID}</a> 已保存。',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">交易 #{ID}</a> (“{title}”) 已更新。',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">交易#{ID}</a>（“{title}”）未收到任何更改。',
    'first_split_decides'                       => '首笔拆分决定此字段的值',
    'first_split_overrules_source'              => '首笔拆分可能覆盖来源账户',
    'first_split_overrules_destination'         => '首笔拆分可能覆盖目标账户',
    'spent_x_of_y'                              => '花费{total}的{amount}',

    // new user:
    'welcome'                                   => '欢迎使用 Firefly III！',
    'submit'                                    => '提交',
    'submission'                                => '提交',
    'submit_yes_really'                         => '提交 (我知道我在干什么)',
    'getting_started'                           => '开始使用',
    'to_get_started'                            => '很高兴看到您成功安装 Firefly III。要开始使用此工具，请输入您主要使用的的银行名称与支票账户余额。别担心，若您有多个账户，可以稍后添加，此处仅为让 Firefly III 进行初始化设置。',
    'savings_balance_text'                      => 'Firefly III 会自动为您创建储蓄账户。默认情况下，储蓄账户里没有任何资金。但如果您告诉 Firefly III 相关金额，程序则会按照您的要求进行保存。',
    'finish_up_new_user'                        => '就到这里了！您可按下 <strong>送出</strong> 继续，您将被带至 Firefly III 的首页。',
    'stored_new_accounts_new_user'              => '太好了！您的新账户已保存。',
    'set_preferred_language'                    => '若您倾向在 Firefly III 使用其他语言，请于此表示。',
    'language'                                  => '语系',
    'new_savings_account'                       => ':bank_name 储蓄账户',
    'cash_wallet'                               => '现金钱包',
    'currency_not_present'                      => '若您日常使用的货币未列出，请不要担心，您可以在 选项 > 货币 创建您自己的货币。',

    // home page:
    'transaction_table_description'             => '包含您交易的表格',
    'opposing_account'                          => '对方账户',
    'yourAccounts'                              => '您的账户',
    'your_accounts'                             => '账户概览',
    'category_overview'                         => '类别概述',
    'expense_overview'                          => '支出账户概览',
    'revenue_overview'                          => '收入账户概览',
    'budgetsAndSpending'                        => '预算与支出',
    'budgets_and_spending'                      => '预算与支出',
    'go_to_budget'                              => '转到预算 "{budget}"',
    'go_to_deposits'                            => '前往收入',
    'go_to_expenses'                            => '前往支出',
    'savings'                                   => '储蓄',
    'newWithdrawal'                             => '新支出',
    'newDeposit'                                => '新收入',
    'newTransfer'                               => '新转账',
    'bills_to_pay'                              => '未支付账单',
    'per_day'                                   => '每日',
    'left_to_spend_per_day'                     => '每日剩余支出',
    'bills_paid'                                => '已支付账单',
    'custom_period'                             => '自定义周期',
    'reset_to_current'                          => '重置为当前周期',
    'select_period'                             => '选择周期',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => '货币',
    'preferences'                               => '偏好设定',
    'logout'                                    => '退出登录',
    'logout_other_sessions'                     => '退出所有其他已登录设备',
    'toggleNavigation'                          => '切换导览',
    'toggle_dropdown'                           => '切换下拉列表',
    'searchPlaceholder'                         => '搜索…',
    'version'                                   => '版本',
    'dashboard'                                 => '仪表盘',
    'income_and_expense'                        => '收入与支出',
    'all_money'                                 => '全部资金',
    'unknown_source_plain'                      => '未知来源账户',
    'unknown_dest_plain'                        => '未知目标账户',
    'unknown_any_plain'                         => '未知账户',
    'unknown_budget_plain'                      => '无预算',
    'available_budget'                          => '可用预算 ({currency})',
    'currencies'                                => '货币',
    'activity'                                  => '活动',
    'usage'                                     => '使用情况',
    'accounts'                                  => '账户',
    'Asset account'                             => '资产账户',
    'Default account'                           => '资产账户',
    'Expense account'                           => '支出账户',
    'Revenue account'                           => '收入账户',
    'Initial balance account'                   => '初始余额账户',
    'account_type_Asset account'                => '资产账户',
    'account_type_Expense account'              => '支出账户',
    'account_type_Revenue account'              => '收入账户',
    'account_type_Debt'                         => '欠款',
    'account_type_Loan'                         => '贷款',
    'account_type_Mortgage'                     => '抵押',
    'account_type_debt'                         => '负债',
    'account_type_loan'                         => '贷款',
    'account_type_mortgage'                     => '抵押',
    'account_type_Credit card'                  => '信用卡',
    'credit_card_type_monthlyFull'              => '每月全额付款',
    'liability_direction_credit'                => '别人欠我这笔钱',
    'liability_direction_debit'                 => '我欠别人这笔钱',
    'liability_direction_credit_short'          => '借款',
    'liability_direction_debit_short'           => '欠款',
    'liability_direction__short'                => '未知',
    'liability_direction_null_short'            => '未知',
    'Liability credit'                          => '债务信用',
    'budgets'                                   => '预算',
    'tags'                                      => '标签',
    'reports'                                   => '报表',
    'transactions'                              => '交易',
    'expenses'                                  => '支出',
    'income'                                    => '收入',
    'transfers'                                 => '转账',
    'moneyManagement'                           => '金钱管理',
    'money_management'                          => '金钱管理',
    'tools'                                     => '工具',
    'piggyBanks'                                => '存钱罐',
    'piggy_banks'                               => '存钱罐',
    'amount_x_of_y'                             => '{total} 中的 {current}',
    'bills'                                     => '订阅',
    'withdrawal'                                => '支出',
    'opening_balance'                           => '开户余额',
    'deposit'                                   => '收入',
    'account'                                   => '账户',
    'transfer'                                  => '转账',
    'Withdrawal'                                => '支出',
    'Deposit'                                   => '收入',
    'Transfer'                                  => '转账',
    'bill'                                      => '账单',
    'yes'                                       => '是',
    'no'                                        => '否',
    'amount'                                    => '金额',
    'overview'                                  => '概览',
    'saveOnAccount'                             => '存至账户',
    'saveOnAccounts'                            => '存至(这个或者这些)账户',
    'unknown'                                   => '未知',
    'monthly'                                   => '每月',
    'profile'                                   => '个人档案',
    'errors'                                    => '错误',
    'debt_start_date'                           => '欠款开始日期',
    'debt_start_amount'                         => '欠款开始金额',
    'debt_start_amount_help'                    => '最佳实践是永远将此值设为负，阅读帮助页面 (右上角问号 (?) 图标) 获取更多信息。',
    'interest_period_help'                      => '此字段纯粹是装饰性的，不会为您进行计算。事实证明，银行非常狡猾，Firefly III 永远无法计算正确。',
    'store_new_liabilities_account'             => '保存新债务账户',
    'edit_liabilities_account'                  => '编辑债务账户“:name”',
    'financial_control'                         => '财务管控',
    'accounting'                                => '记账',
    'automation'                                => '自动化',
    'others'                                    => '其他',
    'classification'                            => '归类整理',
    'store_transaction'                         => '保存交易',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => ':start – :end 的默认财务报表',
    'report_audit'                              => ':start – :end 的交易历史概览',
    'report_category'                           => ':start – :end 的分类报表',
    'report_double'                             => ':start – :end 的支出/收入账户报表',
    'report_budget'                             => ':start – :end 的预算报表',
    'report_tag'                                => ':start – :end 的标签报表',
    'quick_link_reports'                        => '快捷链接',
    'quick_link_examples'                       => '这些是示例链接以帮助您开始使用。点击右上角问号 (?) 图标查看帮助页面，获取所有报表的信息和可以使用的“魔法词”。',
    'quick_link_default_report'                 => '默认财务报表',
    'quick_link_audit_report'                   => '交易历史概览',
    'report_this_month_quick'                   => '当前月份，全部账户',
    'report_last_month_quick'                   => '上一月份，全部账户',
    'report_this_year_quick'                    => '当前年份，全部账户',
    'report_this_fiscal_year_quick'             => '当前财年，全部账户',
    'report_all_time_quick'                     => '所有时间，全部账户',
    'reports_can_bookmark'                      => '提示：可以将报表加入书签。',
    'incomeVsExpenses'                          => '收入 vs. 支出',
    'accountBalances'                           => '账户余额',
    'balanceStart'                              => '此周期起始余额',
    'balanceEnd'                                => '此周期结束余额',
    'splitByAccount'                            => '按账户拆分',
    'coveredWithTags'                           => '以标签涵盖',
    'leftInBudget'                              => '预算剩余',
    'left_in_debt'                              => '到期金额',
    'sumOfSums'                                 => '总和',
    'noCategory'                                => '(没有分类)',
    'notCharged'                                => '(尚) 未开始',
    'inactive'                                  => '已停用',
    'active'                                    => '启用',
    'difference'                                => '差异',
    'money_flowing_in'                          => '流入',
    'money_flowing_out'                         => '流出',
    'topX'                                      => '前 :number',
    'show_full_list'                            => '显示完整列表',
    'show_only_top'                             => '仅显示前 :number',
    'report_type'                               => '报表类型',
    'report_type_default'                       => '默认财务报表',
    'report_type_audit'                         => '交易历史概览 (审计)',
    'report_type_category'                      => '分类报表',
    'report_type_budget'                        => '预算报表',
    'report_type_tag'                           => '标签报表',
    'report_type_double'                        => '支出/收入账户报表',
    'more_info_help'                            => '可在帮助页面找到更多关于报表类型的信息，请点击右上角的问号 (?) 图标。',
    'report_included_accounts'                  => '已包含的账户',
    'report_date_range'                         => '日期范围',
    'report_preset_ranges'                      => '预设范围',
    'shared'                                    => '共用',
    'fiscal_year'                               => '财政年度',
    'income_entry'                              => ':start – :end 账户“:name”的收入',
    'expense_entry'                             => ':start – :end 账户“:name”的支出',
    'category_entry'                            => ':start – :end 分类“:name”的收入',
    'budget_spent_amount'                       => ':start – :end 预算“:budget”的支出',
    'balance_amount'                            => ':start – :end 从账户“:account”支付的预算“:budget”的支出',
    'no_audit_activity'                         => ':start – :end 账户“<a href=":url" title=":account_name">:account_name</a>”没有任何活动。',
    'audit_end_balance'                         => '账户“<a href=":url" title=":account_name">:account_name</a>”在 :end 末的账户余额为：:balance',
    'reports_extra_options'                     => '额外选项',
    'report_has_no_extra_options'               => '此报表没有额外选项',
    'reports_submit'                            => '查看报表',
    'end_after_start_date'                      => '报表的结束日期必须在开始日期之后。',
    'select_category'                           => '选择类别',
    'select_budget'                             => '选择预算',
    'select_tag'                                => '选择标签',
    'income_per_category'                       => '每个类别的收入',
    'expense_per_category'                      => '每个类别的支出',
    'expense_per_budget'                        => '每个预算的费用',
    'income_per_account'                        => '每个账户的收入',
    'expense_per_account'                       => '每个账户的支出',
    'expense_per_tag'                           => '每个标签的支出',
    'income_per_tag'                            => '每个标签的收入',
    'include_expense_not_in_budget'             => '包含的支出不在所选的预算内',
    'include_expense_not_in_account'            => '包含的支出不在所选的账户内',
    'include_expense_not_in_category'           => '包含的支出不在所选的份额里内',
    'include_income_not_in_category'            => '未列入所选类别的收入',
    'include_income_not_in_account'             => '未列入所选账户的收入',
    'include_income_not_in_tags'                => '未包含在所选标记中的收入',
    'include_expense_not_in_tags'               => '未包含在所选标记中的支出',
    'everything_else'                           => '其他',
    'income_and_expenses'                       => '收入与支出',
    'spent_average'                             => '支出 (平均)',
    'income_average'                            => '收入 (平均)',
    'transaction_count'                         => '交易数',
    'average_spending_per_account'              => '每个账户的平均支出',
    'average_income_per_account'                => '每个账户的平均收入',
    'total'                                     => '总计',
    'description'                               => '描述',
    'sum_of_period'                             => '区间内的总和',
    'average_in_period'                         => '区间平均',
    'no_account_role'                           => '(无角色)',
    'account_role_defaultAsset'                 => '默认资产账户',
    'account_role_sharedAsset'                  => '共用资产账户',
    'account_role_savingAsset'                  => '储蓄账户',
    'account_role_ccAsset'                      => '信用卡',
    'account_role_cashWalletAsset'              => '现金钱包',
    'budget_chart_click'                        => '请点击上表中的预算名称查看图表。',
    'category_chart_click'                      => '请点击上表中的类别名称以查看图表。',
    'in_out_accounts'                           => '每个组合的收入与支出',
    'in_out_accounts_per_asset'                 => '收入与支出 (每个资产账户)',
    'in_out_per_category'                       => '每个分类的收入与支出',
    'out_per_budget'                            => '每个预算的支出',
    'select_expense_revenue'                    => '选择支出/收入账户',
    'multi_currency_report_sum'                 => '由于此列表包括多种货币，您所看到的总和可能无意义。报表会总是以您的默认货币为主。',
    'sum_in_default_currency'                   => '总额会总是以您的默认货币显示',
    'net_filtered_prefs'                        => '此图表永远不会包括未勾选“包含于净资产”选项的账户',


    // charts:
    'chart'                                     => '图表',
    'month'                                     => '月',
    'budget'                                    => '预算',
    'spent'                                     => '支出',
    'spent_capped'                              => '支出 (上限)',
    'spent_in_budget'                           => '预算内支出',
    'left_to_spend'                             => '剩余支出',
    'earned'                                    => '收入',
    'overspent'                                 => '超支',
    'left'                                      => '剩余',
    'max-amount'                                => '最大',
    'min-amount'                                => '最小金额',
    'journal-amount'                            => '当前周期性账单条目',
    'name'                                      => '名称',
    'expires_at'                                => '过期于',
    'date'                                      => '日期',
    'date_and_time'                             => '日期和时间',
    'time'                                      => '时间',
    'paid'                                      => '已付款',
    'unpaid'                                    => '未付款',
    'day'                                       => '日',
    'budgeted'                                  => '预算上限',
    'period'                                    => '区间',
    'balance'                                   => '余额',
    'in_out_period'                             => '本周期流入流出',
    'sum'                                       => '总计',
    'summary'                                   => '概要',
    'average'                                   => '平均',
    'balanceFor'                                => ':name 的余额',
    'no_tags'                                   => '(无标签)',
    'nothing_found'                             => '(没有找到)',

    // page settings and wizard dialogs

    'page_settings_header'          => '页面设置',
    'visible_columns'               => '可见的列',
    'accounts_to_show'              => '显示的账户',
    'active_accounts_only'          => '仅活动账户',
    'in_active_accounts_only'       => '仅非活动账户',
    'show_all_accounts'             => '显示全部账户',
    'group_accounts'                => '群组账户',

    // piggy banks:
    'event_history'                 => '事件历史',
    'add_money_to_piggy'            => '存入存钱罐 “:name”',
    'piggy_bank'                    => '存钱罐',
    'new_piggy_bank'                => '新存钱罐',
    'store_piggy_bank'              => '保存新存钱罐',
    'stored_piggy_bank'             => '保存新存钱罐“:name”',
    'account_status'                => '账户状态',
    'left_for_piggy_banks'          => '可用于存钱罐',
    'sum_of_piggy_banks'            => '存钱罐总金额',
    'saved_so_far'                  => '已存金额',
    'saved_so_far_total'            => '到目前为止已总共存了',
    'reset_history'                 => '重置历史记录',
    'reset_history_confirm'         => '您确定要重置这个存钱罐的历史吗？这将使图表再次与存钱罐的金额相匹配。',
    'piggy_history_reset'           => '存钱罐历史记录已被重置',
    'left_to_save'                  => '剩余金额',
    'suggested_amount'              => '建议每月储蓄金额',
    'add_money_to_piggy_title'      => '存至存钱罐 “:name”',
    'remove_money_from_piggy_title' => '自存钱罐 “:name” 中取出',
    'add'                           => '新增',
    'no_money_for_piggy'            => '您已没有钱可放至存钱罐',
    'suggested_savings_per_month'   => '每月建议金额',

    'remove'                    => '移除',
    'max_amount_add'            => '可以增加的最大金额为',
    'max_amount_remove'         => '所能移除之最大金额为',
    'update_piggy_button'       => '更新存钱罐',
    'update_piggy_title'        => '更新存钱罐“:name”',
    'updated_piggy_bank'        => '已更新存钱罐“:name”',
    'details'                   => '详情',
    'events'                    => '事件',
    'target_amount'             => '目标金额',
    'start_date'                => '开始日期',
    'no_start_date'             => '无开始日期',
    'target_date'               => '目标日期',
    'no_target_date'            => '无目标日期',
    'table'                     => '表格',
    'delete_piggy_bank'         => '删除存钱罐 ":name"',
    'cannot_add_amount_piggy'   => '无法增加 :amount 至 “:name”。',
    'cannot_remove_from_piggy'  => '无法自 “:name” 移除 :amount。',
    'deleted_piggy_bank'        => '删除存钱罐 ":name"',
    'added_amount_to_piggy'     => '已新增 :amount 至 “:name”',
    'removed_amount_from_piggy' => '已自 “:name” 移除 :amount',
    'piggy_events'              => '相关的存钱罐',

    // tags
    'delete_tag'                => '删除标签 ":tag"',
    'deleted_tag'               => '已删除标签 ":tag"',
    'new_tag'                   => '建立新标签',
    'edit_tag'                  => '编辑标签 ":tag"',
    'updated_tag'               => '已更新标签“:tag”',
    'created_tag'               => '标签 “:tag” 已被建立！',

    'transaction_journal_information'               => '交易信息',
    'transaction_journal_amount'                    => '金额信息',
    'transaction_journal_meta'                      => '元信息',
    'transaction_journal_more'                      => '更多信息',
    'basic_journal_information'                     => '基础交易信息',
    'transaction_journal_extra'                     => '额外信息',
    'att_part_of_journal'                           => '在“:journal”中存储',
    'total_amount'                                  => '总金额',
    'number_of_decimals'                            => '小数位数',


    // administration
    'invite_is_already_redeemed'                    => '已撤回“:address”的邀请',
    'invite_is_deleted'                             => '已删除“:address”的邀请',
    'invite_new_user_title'                         => '邀请新用户',
    'invite_new_user_text'                          => '作为管理者，您可以邀请用户注册到您的 Firefly III 实例，他们可以通过您分享的直链注册一个账户。被邀请的用户和邀请链接显示在下表中，您可以自由分享邀请链接。',
    'invited_user_mail'                             => '电子邮件地址',
    'invite_user'                                   => '邀请用户',
    'user_is_invited'                               => '电子邮件地址“:address”已被邀请到 Fifrefly III',
    'administration'                                => '管理',
    'system_settings'                               => '系统设置',
    'code_already_used'                             => '邀请码已使用',
    'user_administration'                           => '用户管理',
    'list_all_users'                                => '所有用户',
    'all_users'                                     => '所有用户',
    'instance_configuration'                        => '设置',
    'firefly_instance_configuration'                => 'Firefly III 设置',
    'setting_single_user_mode'                      => '单用户模式',
    'setting_single_user_mode_explain'              => '默认情况下，Firefly III 只接受一 (1) 次来自您自己的注册请求。这是一项安全防护措施，若没有您的批准，其他人将无法使用您的站点，所有的注册请求都将被拒绝。当您取消选中此复选框后，若站点可以访问 (站点接入外网)，则其他人也可以使用您的站点。',
    'store_configuration'                           => '保存配置',
    'single_user_administration'                    => '管理用户 :email',
    'edit_user'                                     => '编辑用户 :email',
    'hidden_fields_preferences'                     => '您可以在<a href="preferences">偏好设定</a>中启用更多交易选项。',
    'user_data_information'                         => '用户数据',
    'user_information'                              => '用户信息',
    'total_size'                                    => '总大小',
    'budget_or_budgets'                             => ':count 笔预算|:count 笔预算',
    'budgets_with_limits'                           => ':count 笔预算有上限|:count 笔预算有上限',
    'nr_of_rules_in_total_groups'                   => ':count_groups规则组中，包含:count_rules条规则',
    'tag_or_tags'                                   => ':count 个标签|:count 个标签',
    'configuration_updated'                         => '已更新配置',
    'setting_is_demo_site'                          => '演示网站',
    'setting_is_demo_site_explain'                  => '若您勾选此选项，此安装将会以展示网站方式运作，会有奇怪的副作用。',
    'block_code_bounced'                            => '电子邮件被退回',
    'block_code_expired'                            => '演示账户已过期',
    'no_block_code'                                 => '无封禁理由或用户未被封禁',
    'demo_user_export'                              => '演示用户不能导出数据',
    'block_code_email_changed'                      => '用户尚未确认新的电子邮件地址',
    'admin_update_email'                            => '与个人档案页面相反，用户不会被通知他们的电子邮件地址已变更！',
    'update_user'                                   => '更新用户',
    'updated_user'                                  => '用户资料已更改。',
    'delete_user'                                   => '删除用户 :email',
    'user_deleted'                                  => '用户已被删除',
    'send_test_email'                               => '发送测试邮件消息',
    'send_test_email_text'                          => '要检查您的站点是否能发送通知，请点击此按钮。您不会在此看到错误 (如果有的话)，<strong>日志文件会反映一切错误</strong>。您可依照自己意愿多次点击此按钮，站点并无垃圾邮件管控，测试消息将会很快发送至 <code>:email</code>。',
    'send_message'                                  => '发送消息',
    'send_test_triggered'                           => '测试已触发，请检查您的收件箱与日志文件。',
    'give_admin_careful'                            => '被授予管理员权限的用户可以收回您的权限。请千万注意这点。',
    'admin_maintanance_title'                       => '维护',
    'admin_maintanance_expl'                        => '用于 Firefly III 维护的漂亮按钮',
    'admin_maintenance_clear_cache'                 => '清除缓存',
    'owner_notifications'                           => '管理操作通知',
    'owner_notifications_expl'                      => '管理员可以启用或禁用以下通知。它将通过所有配置的频道发送。 某些频道是在您的环境变量中配置的，其他频道可以在此处设置。',
    'channel_settings'                              => '通知通道设置',
    'notification_test_failed'                      => '频道":channel"的通知测试失败。日志将有更多详细信息。',
    'notification_test_executed'                    => '已执行频道“:channel”通知测试。请检查日志的详细信息。',
    'settings_notifications'                        => '通知设置',
    'title_owner_notifications'                     => '所有者通知',
    'owner_notification_check_user_new_reg'         => '用户会收到注册后的欢迎消息',
    'owner_notification_check_admin_new_reg'        => '管理员会收到新用户的注册通知',
    'owner_notification_check_new_version'          => '有新版本可用',
    'owner_notification_check_invite_created'       => '用户被邀请注册 Firefly III',
    'owner_notification_check_invite_redeemed'      => '用户邀请已被激活',
    'owner_notification_check_unknown_user_attempt' => '一个未知用户尝试登录',
    'all_invited_users'                             => '所有受邀用户',
    'save_notification_settings'                    => '保存设置',
    'notification_settings'                         => '通知设置',
    'notification_settings_saved'                   => '通知设置已保存',
    'available_channels_title'                      => '可用通道',
    'available_channels_expl'                       => '这些频道可用来发送通知。要测试您的配置，请使用下面的按钮。请注意按钮没有垃圾邮件控制。',
    'notification_channel_name_email'               => '电子邮件',
    'slack_discord_double'                          => 'Slack 通知频道也可以发送通知到 Discord。',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => '不可用',
    'configure_channel_in_env'                      => '需要环境变量',
    'test_notification_channel_name_email'          => '测试电子邮件',
    'test_notification_channel_name_slack'          => '测试 Slack',
    'test_notification_channel_name_ntfy'           => '测试 Ntfy.sh',
    'test_notification_channel_name_pushover'       => '测试 Pushover',
    'test_notification_channel_name_gotify'         => '测试 Gotify',
    'test_notification_channel_name_pushbullet'     => '测试 Pushbullet',

    'split_transaction_title'               => '拆分交易的描述',
    'split_transaction_title_help'          => '如果您创建了一笔拆分交易，必须有一个所有拆分的全局描述。',
    'split_title_help'                      => '如果您创建了一笔拆分交易，必须有一个所有拆分的全局描述。',
    'you_create_transfer'                   => '您正在创建一笔转账',
    'you_create_withdrawal'                 => '您正在创建一笔支出',
    'you_create_deposit'                    => '您正在创建一笔收入',

    // links
    'journal_link_configuration'            => '交易关联配置',
    'create_new_link_type'                  => '创建新关联类型',
    'store_new_link_type'                   => '保存新关联类型',
    'update_link_type'                      => '更新关联类型',
    'edit_link_type'                        => '编辑关联类型“:name”',
    'updated_link_type'                     => '更新关联类型“:name”',
    'delete_link_type'                      => '删除关联类型“:name”',
    'deleted_link_type'                     => '删除关联类型“:name”',
    'stored_new_link_type'                  => '保存关联类型“:name”',
    'cannot_edit_link_type'                 => '无法编辑连结类型 ":name"',
    'link_type_help_name'                   => '例如“复制”',
    'link_type_help_inward'                 => '例如“进行复制”',
    'link_type_help_outward'                => '例如“的复制来源为”',
    'save_connections_by_moving'            => '将此交易关联移动到另一个关联类型并保存：',
    'do_not_save_connection'                => '(不保存连接)',
    'link_transaction'                      => '关联交易',
    'link_to_other_transaction'             => '链结此交易至另一笔',
    'select_transaction_to_link'            => '选择一笔交易来关联此交易。关联目前尚未在 Firefly III 中使用 (未显示)，但开发者已计划在将来进行改动。您可以使用搜索框来用标题或 ID 选择一笔交易。如果您想要添加自定义关联类型，请访问设置页面。',
    'this_transaction'                      => '这笔交易',
    'transaction'                           => '交易',
    'comments'                              => '评论',
    'link_notes'                            => '任何您希望与关联一起保存的备注。',
    'invalid_link_selection'                => '无法关联这些交易',
    'selected_transaction'                  => '已选交易',
    'journals_linked'                       => '交易已关联',
    'journals_error_linked'                 => '这些交易已互相链结',
    'journals_link_to_self'                 => '您无法将一笔交易关联至此交易本身',
    'journal_links'                         => '交易关联',
    'this_withdrawal'                       => '此支出',
    'this_deposit'                          => '这笔收入',
    'this_transfer'                         => '此传输',
    'overview_for_link'                     => '关联类型“:name”概览',
    'source_transaction'                    => '源交易记录',
    'link_description'                      => '关联描述',
    'destination_transaction'               => '指定的交易',
    'delete_journal_link'                   => '删除 <a href=":source_link">:source</a> 和<a href=":destination_link">:destination</a>之间的联繫',
    'deleted_link'                          => '已删除关联',

    // link translations:
    'Paid_name'                             => '已付款',
    'Refund_name'                           => '退款',
    'Reimbursement_name'                    => '报销',
    'Related_name'                          => '相关',
    'relates to_inward'                     => '关联于',
    'is (partially) refunded by_inward'     => '的 (部分) 退款方为',
    'is (partially) paid for by_inward'     => '的 (部分) 付款目标为',
    'is (partially) reimbursed by_inward'   => '的 (部分) 还款方为',
    'inward_transaction'                    => '内向交易',
    'outward_transaction'                   => '外向交易',
    'relates to_outward'                    => '关联于',
    '(partially) refunds_outward'           => '(部分) 退款',
    '(partially) pays for_outward'          => '(部分) 支付',
    '(partially) reimburses_outward'        => '(部分) 还款',
    'is (partially) refunded by'            => '的 (部分) 退款方为',
    'is (partially) paid for by'            => '的 (部分) 付款目标为',
    'is (partially) reimbursed by'          => '的 (部分) 还款方为',
    'relates to'                            => '关联于',
    '(partially) refunds'                   => '(部分) 退款',
    '(partially) pays for'                  => '(部分) 支付',
    '(partially) reimburses'                => '(部分) 还款',

    // split a transaction:
    'splits'                                => '拆分',
    'add_another_split'                     => '增加另一笔拆分',
    'cannot_edit_opening_balance'           => '您无法编辑一个账户的开户余额。',
    'no_edit_multiple_left'                 => '您没有选择有效的交易进行编辑。',
    'breadcrumb_convert_group'              => '转换交易',
    'convert_invalid_source'                => '交易 #%d 的来源信息无效。',
    'convert_invalid_destination'           => '交易 #%d 的目标信息无效。',
    'create_another'                        => '保存后，返回此页面以创建新记录',
    'after_update_create_another'           => '更新后，返回此页面继续编辑。',
    'store_as_new'                          => '保存为新交易而不是更新此交易。',
    'reset_after'                           => '提交后重置表单',
    'errors_submission'                     => '您的提交有误，请查看下面输出的错误信息。',
    'errors_submission_v2'                  => '您提交的内容有误，请检查错误信息: {{errorMessage}}',
    'transaction_expand_split'              => '展开拆分',
    'transaction_remove_split'              => '移除拆分',
    'transaction_collapse_split'            => '折叠拆分',

    // object groups
    'default_group_title_name'              => '(未分组)',
    'default_group_title_name_plain'        => '未分组',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => '创建一个资产账户！',
    'no_accounts_intro_asset'               => '您目前还没有资产账户。资产账户是您的主要账户，包括：您的支票账户、储蓄账户、共用账户，甚至信用卡等。',
    'no_accounts_imperative_asset'          => '要开始使用 Firefly III，您需要至少一个资产账户。我们现在就来：',
    'no_accounts_create_asset'              => '创建资产账户',
    'no_accounts_title_expense'             => '创建一个支出账户！',
    'no_accounts_intro_expense'             => '您目前还没有支出账户。支出账户用于记录您消费的地方，如商店或超市。',
    'no_accounts_imperative_expense'        => '当您创建交易时会自动创建支出账户，但您也可以手动创建，我们现在就来：',
    'no_accounts_create_expense'            => '创建支出账户',
    'no_accounts_title_revenue'             => '创建一个收入账户！',
    'no_accounts_intro_revenue'             => '您目前还没有收入账户。收入账户用于记录向您付款的各方，比如您的雇主。',
    'no_accounts_imperative_revenue'        => '当您创建交易时会自动创建收入账户，但您也可以手动创建，我们现在就来：',
    'no_accounts_create_revenue'            => '创建收入账户',
    'no_accounts_title_liabilities'         => '创建一个债务账户！',
    'no_accounts_intro_liabilities'         => '您目前还没有债务账户。债务账户用于注册您的 (学生) 贷款或其他负债。',
    'no_accounts_imperative_liabilities'    => '您不用必须使用此功能，但若您要追踪这些东西的话，此功能十分有用。',
    'no_accounts_create_liabilities'        => '创建债务账户',
    'no_budgets_title_default'              => '创建一笔预算！',
    'no_rules_title_default'                => '创建一个规则！',
    'no_budgets_intro_default'              => '您目前还没有预算。预算用于将您的支出归为具有逻辑性的组，为您的支出添加一个软性上限。',
    'no_rules_intro_default'                => '你还没有创建任何规则。规则是一种强大的自动化功能，可以帮助你处理交易。',
    'no_rules_imperative_default'           => '规则可以帮助你更好地管理交易。现在就创建一个吧：',
    'no_budgets_imperative_default'         => '预算是财务管理的基本工具，我们现在就来：',
    'no_budgets_create_default'             => '创建预算',
    'no_rules_create_default'               => '创建规则',
    'no_categories_title_default'           => '创建一个分类！',
    'no_categories_intro_default'           => '您目前还没有分类。分类用于微调您的交易，并依指定分类标示。',
    'no_categories_imperative_default'      => '当您创建交易时会自动创建分类，但您也可以手动创建，我们现在就来：',
    'no_categories_create_default'          => '创建分类',
    'no_tags_title_default'                 => '创建一个标签！',
    'no_tags_intro_default'                 => '您目前还没有标签。标签用于微调您的交易，并依指定关键字标示。',
    'no_tags_imperative_default'            => '当您创建交易时会自动创建标签，但您也可以手动创建，我们现在就来：',
    'no_tags_create_default'                => '创建标签',
    'no_transactions_title_withdrawal'      => '创建一笔支出！',
    'no_transactions_intro_withdrawal'      => '您目前还没有支出，您应该创建支出以开始管理您的财务。',
    'no_transactions_imperative_withdrawal' => '您消费了一些钱吗？那么您应该记下来：',
    'no_transactions_create_withdrawal'     => '创建支出',
    'no_transactions_title_deposit'         => '创建一些收入！',
    'no_transactions_intro_deposit'         => '您目前还没有收入记录，您应该创建收入记录以开始管理您的财务。',
    'no_transactions_imperative_deposit'    => '您收到了一些钱吗？那么您应该记下来：',
    'no_transactions_create_deposit'        => '创建收入',
    'no_transactions_title_transfers'       => '创建一笔转账！',
    'no_transactions_intro_transfers'       => '您目前还没有转账。当您在资产账户之间移动资金时，将自动记录为转账。',
    'no_transactions_imperative_transfers'  => '您有移动这些钱吗？那么您应该记下来：',
    'no_transactions_create_transfers'      => '创建转账',
    'no_piggies_title_default'              => '创建一个存钱罐！',
    'no_piggies_intro_default'              => '您目前还没有存钱罐，您可以创建存钱罐来划分您的储蓄，并追踪您存钱的目标。',
    'no_piggies_imperative_default'         => '您有想要为之攒钱的东西吗？创建一个存钱罐然后开始追踪：',
    'no_piggies_create_default'             => '创建新存钱罐',
    'no_bills_title_default'                => '让我们创建一个账单！',
    'no_bills_intro_default'                => '您目前还没有周期性账单，您可以创建周期性账单以追踪您的日常支出，比如房租或保险。',
    'no_bills_imperative_default'           => '您有这样的日常周期性账单吗？创建周期性账单并追踪您的付款：',
    'no_bills_create_default'               => '创建订阅',

    // recurring transactions
    'recurrence_max_count'                  => '此定期交易将最多创建 :max 次，并且已经创建 :count 次。',
    'create_right_now'                      => '立即创建',
    'no_new_transaction_in_recurrence'      => '未创建新交易，可能已经在此日期取消？',
    'recurrences'                           => '定期交易',
    'repeat_until_in_past'                  => '此定期交易已于 :date 停止重复。',
    'recurring_calendar_view'               => '日历',
    'no_recurring_title_default'            => '创建一笔定期交易！',
    'no_recurring_intro_default'            => '您还目前没有定期交易，使用此功能可以让 Firefly III 自动为您创建交易。',
    'no_recurring_imperative_default'       => '此功能适合高级用户，同时也极为有用。请在继续操作前，确认您已阅读右上角问号 (?) 图标) 里的帮助文档。',
    'no_recurring_create_default'           => '创建定期交易',
    'make_new_recurring'                    => '创建定期交易',
    'recurring_daily'                       => '每天',
    'recurring_weekly'                      => '每周的:weekday',
    'recurring_weekly_skip'                 => '每:skip个周的:weekday',
    'recurring_monthly'                     => '每月的第:dayOfMonth天',
    'recurring_monthly_skip'                => '每:skip个月的第:dayOfMonth天',
    'recurring_ndom'                        => '每月的第:dayOfMonth个:weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => '每年的:date',
    'overview_for_recurrence'               => '定期交易“:title”概览',
    'warning_duplicates_repetitions'        => '在极少数情况下，日期在此列表上会显示两次，这是由多个重复项目的冲突造成的。Firefly III 每天只会产生一条交易。',
    'created_transactions'                  => '相关交易',
    'expected_withdrawals'                  => '预期支出',
    'expected_deposits'                     => '预期收入',
    'expected_transfers'                    => '预期转账',
    'created_withdrawals'                   => '已创建支出',
    'created_deposits'                      => '已创建收入',
    'created_transfers'                     => '已创建转账',
    'recurring_info'                        => '定期交易 :count / :total',
    'created_from_recurrence'               => '从定期交易“:title” (#:id) 创建',
    'recurring_never_cron'                  => '用于支持定期交易的计划任务尚未运行。全新安装 Firefly III 后出现此提示为正常情况，请尽快按照说明进行操作。点击页面右上角的问号 (?) 图标查看帮助页面。',
    'recurring_cron_long_ago'               => '距离上次运行用于支持定期交易的计划任务已超过36小时，请确认您的配置正确无误。点击页面右上角的问号 (?) 图标查看帮助页面。',

    'create_new_recurrence'              => '创建新定期交易',
    'help_first_date'                    => '第一笔预期的定期交易的日期，必须位于将来。',
    'help_first_date_no_past'            => '表示第一次预计的定期，Firefly III 不会创建已经过去的交易。',
    'no_currency'                        => '(没有货币)',
    'mandatory_for_recurring'            => '必填定期信息',
    'mandatory_for_transaction'          => '必填交易信息',
    'optional_for_recurring'             => '选填定期信息',
    'optional_for_transaction'           => '选填交易信息',
    'change_date_other_options'          => '更改“初次日期”以查看更多选项。',
    'mandatory_fields_for_tranaction'    => '这里的数值最终会出现在创建的交易中',
    'click_for_calendar'                 => '点这裡开启显示定期重复交易的行事曆',
    'repeat_forever'                     => '永远重复',
    'repeat_until_date'                  => '重复至特定日期',
    'repeat_times'                       => '一定次数后重复',
    'recurring_skips_one'                => '每隔一个',
    'recurring_skips_more'               => '跳过:count次',
    'store_new_recurrence'               => '保存定期交易',
    'stored_new_recurrence'              => '定期交易“:title”保存成功',
    'edit_recurrence'                    => '编辑定期交易“:title”',
    'recurring_repeats_until'            => '重复至 :date',
    'recurring_repeats_forever'          => '永远重复',
    'recurring_repeats_x_times'          => '重复:count次|重复:count次',
    'update_recurrence'                  => '更新定期交易',
    'updated_recurrence'                 => '定期交易“:title”已更新',
    'recurrence_is_inactive'             => '此定期交易已停用，不会自动生成新交易',
    'delete_recurring'                   => '删除定期交易“:title”',
    'new_recurring_transaction'          => '新定期交易',
    'help_weekend'                       => '当定期交易发生于周六或周日时，Firefly III 要如何处理？',
    'do_nothing'                         => '仅创建交易',
    'skip_transaction'                   => '跳过此次',
    'jump_to_friday'                     => '在上个星期五创建交易',
    'jump_to_monday'                     => '在下个星期一创建交易',
    'will_jump_friday'                   => '将提前到星期五创建而不是周末',
    'will_jump_monday'                   => '将推迟到星期一创建而不是周末',
    'except_weekends'                    => '例外的周末',
    'recurrence_deleted'                 => '定期交易“:title”已删除',


    // new lines for summary controller.
    'box_balance_in_currency'            => '余额(:currency)',
    'box_spent_in_currency'              => '支出 (:currency)',
    'box_earned_in_currency'             => '收入 (:currency)',
    'box_budgeted_in_currency'           => '预算 (:currency)',
    'box_bill_paid_in_currency'          => '周期性账单已支付 (:currency)',
    'box_bill_unpaid_in_currency'        => '周期性账单未支付 (:currency)',
    'box_left_to_spend_in_currency'      => '剩余支出 (:currency)',
    'box_net_worth_in_currency'          => '净资产 (:currency)',
    'box_spend_per_day'                  => '每日剩余支出：:amount',

    // debug page
    'debug_page'                         => '调试页面',
    'debug_submit_instructions'          => '如果您遇到问题，您可以使用此框内的信息协助调试，请将其复制并粘贴到新的或已存在的 <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub 工单</a> 中。系统将自动生成美观的表格，以方便快速诊断问题。',
    'debug_pretty_table'                 => '如果您复制/粘贴框中的内容到 GitHub 工单中，系统会自动生成表格。请不要在此文本前后加上引号或反引号。',
    'debug_additional_data'              => '您还可以分享下方框中的内容，将其复制并粘贴至新的或已有的 <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub 工单</a> 中。然而，框中的内容可能包含隐私信息，例如账户名称、转账详情或电子邮件地址。',

    // object groups
    'object_groups_menu_bar'             => '组',
    'object_groups_page_title'           => '组',
    'object_groups_breadcrumb'           => '组',
    'object_groups_index'                => '概览',
    'object_groups'                      => '组',
    'object_groups_empty_explain'        => 'Firefly III 的一些项目可以分为组。例如，存钱罐的编辑和创建页面有“组”字段。当您设定了此字段，您可以在此页面编辑组名称和排列顺序。点击右上角的问号 (?) 图标查看帮助页面，获取更多信息。',
    'object_group_title'                 => '标题',
    'edit_object_group'                  => '编辑组“:title”',
    'delete_object_group'                => '删除组“:title”',
    'update_object_group'                => '更新组',
    'updated_object_group'               => '成功更新组“:title”',
    'deleted_object_group'               => '成功删除组“:title”',
    'object_group'                       => '组',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => '审计日志记录',
    'ale_action_log_add'                 => '向存钱罐“:name”中存入:amount',
    'ale_action_log_remove'              => '自存钱罐 “:name” 中取出:amount',
    'ale_action_clear_budget'            => '已从预算中移除',
    'ale_action_update_group_title'      => '已更新交易的分组标题',
    'ale_action_update_date'             => '已更新交易日期',
    'ale_action_update_order'            => '已更新交易订单',
    'ale_action_clear_category'          => '已从分类中删除',
    'ale_action_clear_notes'             => '移除备注',
    'ale_action_clear_tag'               => '清除标签',
    'ale_action_clear_all_tags'          => '清除所有标签',
    'ale_action_set_bill'                => '已关联到周期性账单',
    'ale_action_switch_accounts'         => '已切换来源账户或和目标账户',
    'ale_action_set_budget'              => '设置预算',
    'ale_action_set_category'            => '设置分类',
    'ale_action_set_source'              => '设置来源账户',
    'ale_action_set_destination'         => '设置目标账户',
    'ale_action_update_transaction_type' => '更改交易类型',
    'ale_action_update_notes'            => '更改备注',
    'ale_action_update_description'      => '更改描述',
    'ale_action_add_to_piggy'            => '存钱罐',
    'ale_action_remove_from_piggy'       => '存钱罐',
    'ale_action_add_tag'                 => '添加标签',
    'ale_action_update_amount'           => '已更新金额',

    // dashboard
    'enable_auto_convert'                => '启用货币转换',
    'disable_auto_convert'               => '禁用货币转换',
];
