<?php

/**
 * validation.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


declare(strict_types=1);

return [
    'webhook_budget_info'            => 'Cannot deliver budget information for transaction related webhooks.',
    'webhook_account_info'           => 'Cannot deliver account information for budget related webhooks.',
    'webhook_transaction_info'       => 'Cannot deliver transaction information for budget related webhooks.',
    'invalid_account_type'           => 'A piggy bank can only be linked to asset accounts and liabilities',
    'invalid_account_currency'       => 'This account does not use the currency you have selected',
    'current_amount_too_much'        => 'The combined amount in "current_amount" cannot exceed the "target_amount".',
    'filter_must_be_in'              => 'Filter ":filter" must be one of: :values',
    'filter_not_string'              => 'Filter ":filter" is expected to be a string of text',
    'bad_api_filter'                 => 'This API endpoint does not support ":filter" as a filter.',
    'nog_logged_in'                  => 'You are not logged in.',
    'bad_type_source'                => 'Firefly III can\'t determine the transaction type based on this source account.',
    'bad_type_destination'           => 'Firefly III can\'t determine the transaction type based on this destination account.',
    'missing_where'                  => 'Array is missing "where"-clause',
    'missing_update'                 => 'Array is missing "update"-clause',
    'invalid_where_key'              => 'JSON contains an invalid key for the "where"-clause',
    'invalid_update_key'             => 'JSON contains an invalid key for the "update"-clause',
    'invalid_query_data'             => 'There is invalid data in the %s:%s field of your query.',
    'invalid_query_account_type'     => 'Your query contains accounts of different types, which is not allowed.',
    'invalid_query_currency'         => 'Your query contains accounts that have different currency settings, which is not allowed.',
    'iban'                           => 'Bu geçerli bir IBAN değil.',
    'zero_or_more'                   => 'Değer negatif olamaz.',
    'more_than_zero'                 => 'The value must be more than zero.',
    'more_than_zero_correct'         => 'The value must be zero or more.',
    'no_asset_account'               => 'This is not an asset account.',
    'date_or_time'                   => 'Değer geçerli tarih veya zaman formatı olmalıdır (ISO 8601).',
    'source_equals_destination'      => 'Kaynak hesabın hedef hesap eşittir.',
    'unique_account_number_for_user' => 'Bu hesap numarası zaten kullanılmaktadır.',
    'unique_user_group_for_user'     => 'It looks like this administration title is already in use.',
    'unique_iban_for_user'           => 'Bu IBAN numarası zaten kullanılmaktadır.',
    'reconciled_forbidden_field'     => 'This transaction is already reconciled, you cannot change the ":field"',
    'deleted_user'                   => 'Güvenlik kısıtlamaları nedeniyle, bu e-posta adresini kullanarak kayıt yapamazsınız.',
    'rule_trigger_value'             => 'Bu eylem, seçili işlem için geçersizdir.',
    'rule_action_expression'         => 'Invalid expression. :error',
    'rule_action_value'              => 'Bu eylem seçili işlem için geçersizdir.',
    'file_already_attached'          => 'Yüklenen dosya ":name" zaten bu nesneye bağlı.',
    'file_attached'                  => '":name" dosyası başarıyla yüklendi.',
    'file_zero'                      => 'The file is zero bytes in size.',
    'must_exist'                     => 'ID alanı :attribute veritabanın içinde yok.',
    'all_accounts_equal'             => 'Bu alandaki tüm hesapları eşit olmalıdır.',
    'group_title_mandatory'          => 'Birden fazla işlem olduğunda grup başlığı zorunludur.',
    'transaction_types_equal'        => 'Tüm bölümlemeler aynı türde olmalıdır.',
    'invalid_transaction_type'       => 'Geçersiz işlem türü.',
    'invalid_selection'              => 'Seçiminiz geçersiz.',
    'belongs_user'                   => 'This value is linked to an object that does not seem to exist.',
    'belongs_user_or_user_group'     => 'This value is linked to an object that does not seem to exist in your current financial administration.',
    'no_access_group'                => 'The user has no access to this administration.',
    'no_accepted_roles_defined'      => 'No access roles have been defined for this endpoint, access denied.',
    'at_least_one_transaction'       => 'En az bir işlem gerekir.',
    'recurring_transaction_id'       => 'Need at least one transaction.',
    'need_id_to_match'               => 'You need to submit this entry with an ID for the API to be able to match it.',
    'too_many_unmatched'             => 'Too many submitted transactions cannot be matched to their respective database entries. Make sure existing entries have a valid ID.',
    'id_does_not_match'              => 'Submitted ID #:id does not match expected ID. Make sure it matches or omit the field.',
    'at_least_one_repetition'        => 'En az bir tekrarı gerekir.',
    'require_repeat_until'           => 'Require either a number of repetitions, or an end date (repeat_until). Not both.',
    'require_currency_info'          => 'Bu alanın içeriği para birimi bilgileri geçersiz.',
    'require_currency_id_code'       => 'Please set either "transaction_currency_id" or "transaction_currency_code".',
    'not_transfer_account'           => 'This account is not an account that can be used for transfers.',
    'require_currency_amount'        => 'The content of this field is invalid without foreign amount information.',
    'require_foreign_currency'       => 'This field requires a number',
    'require_foreign_dest'           => 'This field value must match the currency of the destination account.',
    'require_foreign_src'            => 'This field value must match the currency of the source account.',
    'equal_description'              => 'İşlem açıklaması genel açıklama eşit değildir.',
    'file_invalid_mime'              => '":name" dosyası ":mime" türünde olup yeni bir yükleme olarak kabul edilemez.',
    'file_too_large'                 => '":name" dosyası çok büyük.',
    'belongs_to_user'                => ':attribute\'nin değeri bilinmiyor',
    'accepted'                       => ':attribute kabul edilmek zorunda.',
    'bic'                            => 'Bu BIC geçerli değilrdir.',
    'at_least_one_trigger'           => 'Kural en az bir tetikleyiciye sahip olması gerekir.',
    'at_least_one_active_trigger'    => 'Rule must have at least one active trigger.',
    'at_least_one_action'            => 'Kural en az bir eylem olması gerekir.',
    'at_least_one_active_action'     => 'Rule must have at least one active action.',
    'base64'                         => 'Bu geçerli Base64 olarak kodlanmış veri değildir.',
    'model_id_invalid'               => 'Verilen kimlik bu model için geçersiz görünüyor.',
    'less'                           => ':attribute  10.000.000 den daha az olmalıdır',
    'active_url'                     => ':attribute geçerli bir URL değil.',
    'after'                          => ':attribute :date tarihinden sonrası için tarihlendirilmelidir.',
    'date_after'                     => 'The start date must be before the end date.',
    'alpha'                          => ':attribute sadece harf içerebilir.',
    'alpha_dash'                     => ':attribute sadece harf, sayı ve kısa çizgi içerebilir.',
    'alpha_num'                      => ':attribute sadece harf ve sayı içerebilir.',
    'array'                          => ':attribute bir dizi olmalıdır.',
    'unique_for_user'                => ':attribute\'de zaten bir girdi var.',
    'before'                         => ':attribute :date tarihinden öncesi için tarihlendirilmelidir.',
    'unique_object_for_user'         => 'Bu isim zaten kullanılıyor.',
    'unique_account_for_user'        => 'Bu hesap adı zaten kullanılıyor.',


    'between.numeric'            => ':attribute :min ve :max arasında olmalıdır.',
    'between.file'               => ':attribute, :min kilobayt ve :max kilobayt arasında olmalıdır.',
    'between.string'             => ':attribute :min karakter ve :max karakter olmalıdır.',
    'between.array'              => ':attribute :min öğe ve :max öğe olmalıdır.',
    'boolean'                    => ':attribute alanının doğru veya yanlış olması gerekir.',
    'confirmed'                  => ':attribute doğrulaması eşleşmiyor.',
    'date'                       => ':attribute geçerli bir tarih değil.',
    'date_format'                => ':attribute :format formatına uymuyor.',
    'different'                  => ':attribute ve :other farklı olmalı.',
    'digits'                     => ':attribute :digits basamak olmalıdır.',
    'digits_between'             => ':attribute en az :min basamak en fazla :max basamak olmalı.',
    'email'                      => ':attribute geçerli bir e-posta adresi olmalıdır.',
    'filled'                     => ':attribute alanı gereklidir.',
    'exists'                     => 'Seçili :attribute geçersiz.',
    'image'                      => ':attribute bir resim olmalı.',
    'in'                         => 'Seçili :attribute geçersiz.',
    'integer'                    => ':attribute bir tamsayı olmalı.',
    'ip'                         => ':attribute geçerli bir IP adresi olmalı.',
    'json'                       => ':attribute geçerli bir JSON dizini olmalı.',
    'max.numeric'                => ':attribute, :max değerinden daha büyük olamamalıdır.',
    'max.file'                   => ':attribute :max kilobayttan büyük olmamalıdır.',
    'max.string'                 => ':attribute :max karakterden büyük olmamalıdır.',
    'max.array'                  => ':attribute :max öğeden daha fazlasına sahip olamaz.',
    'mimes'                      => ':attribute :values türünde bir dosya olmalı.',
    'min.numeric'                => ':attribute en az :min olmalıdır.',
    'lte.numeric'                => ':attribute küçük veya eşit olması gerekir :value.',
    'min.file'                   => ':attribute en az :min kilobayt olmalıdır.',
    'min.string'                 => ':attribute en az :min karakter olmalıdır.',
    'min.array'                  => ':attribute en az :min öğe içermelidir.',
    'not_in'                     => 'Seçili :attribute geçersiz.',
    'numeric'                    => ':attribute sayı olmalıdır.',
    'convert_to_itself'          => 'Cannot store currency exchange rate for ":code", because from and to currency are the same.',
    'invalid_currency_code'      => 'Currency code ":code" is invalid',
    'scientific_notation'        => 'The :attribute cannot use the scientific notation.',
    'numeric_primary'            => 'The primary currency amount must be a number.',
    'numeric_destination'        => 'Hedef tutar bir sayı olması gerekir.',
    'numeric_source'             => 'Kaynak tutarın bir sayı olması gerekir.',
    'generic_invalid'            => 'This value is invalid.',
    'transaction_type_changed'   => 'If you change the type of the transaction, make sure the correct source/destination accounts are set.',
    'regex'                      => ':attribute biçimi geçersiz.',
    'required'                   => ':attribute alanı gereklidir.',
    'required_if'                => ':other :value iken :attribute alanı gereklidir.',
    'required_unless'            => ':other :values içinde değilse :attribute alanı gereklidir.',
    'required_with'              => ':values mevcutken :attribute alanı gereklidir.',
    'required_with_all'          => ':values mevcutken :attribute alanı gereklidir.',
    'required_without'           => ':values mevcut değilken :attribute alanı gereklidir.',
    'required_without_all'       => 'Hiçbir :values mevcut değilken :attribute alanı gereklidir.',
    'same'                       => ':attribute ve :other eşleşmelidir.',
    'size.numeric'               => ':attribute :size olmalıdır.',
    'amount_min_over_max'        => 'En az  tutar en fazla tutardan büyük olamaz.',
    'size.file'                  => ':attribute :size kilobyte olmalıdır.',
    'size.string'                => ':attribute :size karakter olmalıdır.',
    'size.array'                 => ':attribute :size öğeye sahip olmalıdır.',
    'unique'                     => ':attribute zaten alınmış.',
    'string'                     => ':attribute bir dizi olmalıdır.',
    'url'                        => ':attribute biçimi geçersiz.',
    'timezone'                   => ':attribute geçerli bir bölge olmalıdır.',
    '2fa_code'                   => ':attribute alanı geçersiz.',
    'dimensions'                 => ':attribute geçersiz görüntü boyutlarına sahip.',
    'distinct'                   => ':attribute alanı yinelenen bir değere sahip.',
    'file'                       => ':attribute bir dosya olmalıdır.',
    'in_array'                   => ':attribute alanı :other içinde olamaz.',
    'present'                    => ':attribute alanı mevcut olmalıdır.',
    'amount_zero'                => 'Toplam tutarı sıfır olamaz.',
    'current_target_amount'      => 'The current amount must be less than the target amount.',
    'unique_piggy_bank_for_user' => 'Kumbara adı benzersiz olmalıdır.',
    'unique_object_group'        => 'Grup adı benzersiz olmalıdır',
    'starts_with'                => 'Değer şununla başlamalıdır :values.',
    'unique_webhook'             => 'You already have a webhook with this combination of URL, trigger, response and delivery.',
    'unique_existing_webhook'    => 'You already have another webhook with this combination of URL, trigger, response and delivery.',
    'same_account_type'          => 'Both accounts must be of the same account type',
    'same_account_currency'      => 'Both accounts must have the same currency setting',
    'piggy_no_change_currency'   => 'Because there are piggy banks linked to this account, you cannot change the currency of the account.',


    'secure_password'             => 'This is not a secure password. Please try again. For more information, visit https://bit.ly/FF3-password',
    'valid_recurrence_rep_type'   => 'Invalid repetition type for recurring transactions.',
    'valid_recurrence_rep_moment' => 'Invalid repetition moment for this type of repetition.',
    'invalid_account_info'        => 'Geçersiz hesap bilgileri.',
    'attributes'                  => [
        'email'                   => 'E-posta adresi',
        'description'             => 'Açıklama',
        'amount'                  => 'Tutar',
        'transactions.*.amount'   => 'transfer tutarı',
        'name'                    => 'adı',
        'piggy_bank_id'           => 'Kumbara ID',
        'targetamount'            => 'Hedef tutar',
        'opening_balance_date'    => 'açılış bakiye tarihi',
        'opening_balance'         => 'açılış Bakiyesi',
        'match'                   => 'Eşleşme',
        'amount_min'              => 'Minimum tutar',
        'amount_max'              => 'Maksimum tutar',
        'title'                   => 'başlık',
        'tag'                     => 'etiket',
        'transaction_description' => 'İşlem Açıklaması',
        'rule-action-value.1'     => 'kural eylemi değer #1',
        'rule-action-value.2'     => 'kural eylemi değer #1',
        'rule-action-value.3'     => 'kural eylem değeri #3',
        'rule-action-value.4'     => 'kural eylem değeri #4',
        'rule-action-value.5'     => 'kural eylem değeri #5',
        'rule-action.1'           => 'kural eylemi #1',
        'rule-action.2'           => 'kural eylemi #2',
        'rule-action.3'           => 'kural eylemi #3',
        'rule-action.4'           => 'kural eylemi #4',
        'rule-action.5'           => 'kural eylemi #5',
        'rule-trigger-value.1'    => 'kural tetikleyici değeri #1',
        'rule-trigger-value.2'    => 'kural tetikleyici değeri #2',
        'rule-trigger-value.3'    => 'kural tetikleyici değeri #3',
        'rule-trigger-value.4'    => 'kural tetikleyici değeri #4',
        'rule-trigger-value.5'    => 'kural tetikleyici değeri #5',
        'rule-trigger.1'          => 'kural tetikleyici #1',
        'rule-trigger.2'          => 'kural tetikleyici #2',
        'rule-trigger.3'          => 'kural tetikleyici #3',
        'rule-trigger.4'          => 'kural tetikleyici #4',
        'rule-trigger.5'          => 'kural tetikleyici #5',
    ],

    // validation of accounts:
    'withdrawal_source_need_data' => 'Need to get a valid source account ID and/or valid source account name to continue.',
    'withdrawal_source_bad_data'  => '[a] Could not find a valid source account when searching for ID ":id" or name ":name".',
    'withdrawal_dest_need_data'   => '[a] Need to get a valid destination account ID and/or valid destination account name to continue.',
    'withdrawal_dest_bad_data'    => 'Could not find a valid destination account when searching for ID ":id" or name ":name".',

    'withdrawal_dest_iban_exists' => 'This destination account IBAN is already in use by an asset account or a liability and cannot be used as a withdrawal destination.',
    'deposit_src_iban_exists'     => 'This source account IBAN is already in use by an asset account or a liability and cannot be used as a deposit source.',

    'reconciliation_source_bad_data' => 'Could not find a valid reconciliation account when searching for ID ":id" or name ":name".',

    'generic_source_bad_data' => '[e] Could not find a valid source account when searching for ID ":id" or name ":name".',

    'deposit_source_need_data' => 'Need to get a valid source account ID and/or valid source account name to continue.',
    'deposit_source_bad_data'  => '[b] Could not find a valid source account when searching for ID ":id" or name ":name".',
    'deposit_dest_need_data'   => '[b] Need to get a valid destination account ID and/or valid destination account name to continue.',
    'deposit_dest_bad_data'    => 'Could not find a valid destination account when searching for ID ":id" or name ":name".',
    'deposit_dest_wrong_type'  => 'The submitted destination account is not of the right type.',


    'transfer_source_need_data' => 'Need to get a valid source account ID and/or valid source account name to continue.',
    'transfer_source_bad_data'  => '[c] Could not find a valid source account when searching for ID ":id" or name ":name".',
    'transfer_dest_need_data'   => '[c] Need to get a valid destination account ID and/or valid destination account name to continue.',
    'transfer_dest_bad_data'    => 'Could not find a valid destination account when searching for ID ":id" or name ":name".',
    'need_id_in_edit'           => 'Each split must have transaction_journal_id (either valid ID or 0).',

    'ob_source_need_data'           => 'Need to get a valid source account ID and/or valid source account name to continue.',
    'lc_source_need_data'           => 'Need to get a valid source account ID to continue.',
    'ob_dest_need_data'             => '[d] Need to get a valid destination account ID and/or valid destination account name to continue.',
    'ob_dest_bad_data'              => 'Could not find a valid destination account when searching for ID ":id" or name ":name".',
    'reconciliation_either_account' => 'To submit a reconciliation, you must submit either a source or a destination account. Not both, not neither.',

    'generic_invalid_source'      => 'You can\'t use this account as the source account.',
    'generic_invalid_destination' => 'You can\'t use this account as the destination account.',

    'generic_no_source'      => 'You must submit source account information or submit a transaction journal ID.',
    'generic_no_destination' => 'You must submit destination account information or submit a transaction journal ID.',

    'gte.numeric'  => 'The :attribute must be greater than or equal to :value.',
    'gt.numeric'   => 'The :attribute must be greater than :value.',
    'gte.file'     => 'The :attribute must be greater than or equal to :value kilobytes.',
    'gte.string'   => 'The :attribute must be greater than or equal to :value characters.',
    'gte.array'    => 'The :attribute must have :value items or more.',
    'missing_with' => 'The :attribute cannot be combined with another field.',

    'amount_required_for_auto_budget' => 'The amount is required.',
    'auto_budget_amount_positive'     => 'The amount must be more than zero.',

    'auto_budget_period_mandatory' => 'The auto budget period is a mandatory field.',

    // no access to administration:
    'no_auth_user_group'           => 'You have to be logged in to access this administration.',
    'no_access_user_group'         => 'You do not have the correct access rights for this administration.',
    'administration_owner_rename'  => 'You can\'t rename your standard administration.',
    'existing_mfa_code'            => 'Please enter a valid code',
];
