<?php

$web = 'index.php';

if (in_array('phar', stream_get_wrappers()) && class_exists('Phar', 0)) {
Phar::interceptFileFuncs();
set_include_path('phar://' . __FILE__ . PATH_SEPARATOR . get_include_path());
Phar::webPhar(null, $web);
include 'phar://' . __FILE__ . '/' . Extract_Phar::START;
return;
}

if (@(isset($_SERVER['REQUEST_URI']) && isset($_SERVER['REQUEST_METHOD']) && ($_SERVER['REQUEST_METHOD'] == 'GET' || $_SERVER['REQUEST_METHOD'] == 'POST'))) {
Extract_Phar::go(true);
$mimes = array(
'phps' => 2,
'c' => 'text/plain',
'cc' => 'text/plain',
'cpp' => 'text/plain',
'c++' => 'text/plain',
'dtd' => 'text/plain',
'h' => 'text/plain',
'log' => 'text/plain',
'rng' => 'text/plain',
'txt' => 'text/plain',
'xsd' => 'text/plain',
'php' => 1,
'inc' => 1,
'avi' => 'video/avi',
'bmp' => 'image/bmp',
'css' => 'text/css',
'gif' => 'image/gif',
'htm' => 'text/html',
'html' => 'text/html',
'htmls' => 'text/html',
'ico' => 'image/x-ico',
'jpe' => 'image/jpeg',
'jpg' => 'image/jpeg',
'jpeg' => 'image/jpeg',
'js' => 'application/x-javascript',
'midi' => 'audio/midi',
'mid' => 'audio/midi',
'mod' => 'audio/mod',
'mov' => 'movie/quicktime',
'mp3' => 'audio/mp3',
'mpg' => 'video/mpeg',
'mpeg' => 'video/mpeg',
'pdf' => 'application/pdf',
'png' => 'image/png',
'swf' => 'application/shockwave-flash',
'tif' => 'image/tiff',
'tiff' => 'image/tiff',
'wav' => 'audio/wav',
'xbm' => 'image/xbm',
'xml' => 'text/xml',
);

header("Cache-Control: no-cache, must-revalidate");
header("Pragma: no-cache");

$basename = basename(__FILE__);
if (!strpos($_SERVER['REQUEST_URI'], $basename)) {
chdir(Extract_Phar::$temp);
include $web;
return;
}
$pt = substr($_SERVER['REQUEST_URI'], strpos($_SERVER['REQUEST_URI'], $basename) + strlen($basename));
if (!$pt || $pt == '/') {
$pt = $web;
header('HTTP/1.1 301 Moved Permanently');
header('Location: ' . $_SERVER['REQUEST_URI'] . '/' . $pt);
exit;
}
$a = realpath(Extract_Phar::$temp . DIRECTORY_SEPARATOR . $pt);
if (!$a || strlen(dirname($a)) < strlen(Extract_Phar::$temp)) {
header('HTTP/1.0 404 Not Found');
echo "<html>\n <head>\n  <title>File Not Found<title>\n </head>\n <body>\n  <h1>404 - File Not Found</h1>\n </body>\n</html>";
exit;
}
$b = pathinfo($a);
if (!isset($b['extension'])) {
header('Content-Type: text/plain');
header('Content-Length: ' . filesize($a));
readfile($a);
exit;
}
if (isset($mimes[$b['extension']])) {
if ($mimes[$b['extension']] === 1) {
include $a;
exit;
}
if ($mimes[$b['extension']] === 2) {
highlight_file($a);
exit;
}
header('Content-Type: ' .$mimes[$b['extension']]);
header('Content-Length: ' . filesize($a));
readfile($a);
exit;
}
}

class Extract_Phar
{
static $temp;
static $origdir;
const GZ = 0x1000;
const BZ2 = 0x2000;
const MASK = 0x3000;
const START = 'index.php';
const LEN = 6643;

static function go($return = false)
{
$fp = fopen(__FILE__, 'rb');
fseek($fp, self::LEN);
$L = unpack('V', $a = fread($fp, 4));
$m = '';

do {
$read = 8192;
if ($L[1] - strlen($m) < 8192) {
$read = $L[1] - strlen($m);
}
$last = fread($fp, $read);
$m .= $last;
} while (strlen($last) && strlen($m) < $L[1]);

if (strlen($m) < $L[1]) {
die('ERROR: manifest length read was "' .
strlen($m) .'" should be "' .
$L[1] . '"');
}

$info = self::_unpack($m);
$f = $info['c'];

if ($f & self::GZ) {
if (!function_exists('gzinflate')) {
die('Error: zlib extension is not enabled -' .
' gzinflate() function needed for zlib-compressed .phars');
}
}

if ($f & self::BZ2) {
if (!function_exists('bzdecompress')) {
die('Error: bzip2 extension is not enabled -' .
' bzdecompress() function needed for bz2-compressed .phars');
}
}

$temp = self::tmpdir();

if (!$temp || !is_writable($temp)) {
$sessionpath = session_save_path();
if (strpos ($sessionpath, ";") !== false)
$sessionpath = substr ($sessionpath, strpos ($sessionpath, ";")+1);
if (!file_exists($sessionpath) || !is_dir($sessionpath)) {
die('Could not locate temporary directory to extract phar');
}
$temp = $sessionpath;
}

$temp .= '/pharextract/'.basename(__FILE__, '.phar');
self::$temp = $temp;
self::$origdir = getcwd();
@mkdir($temp, 0777, true);
$temp = realpath($temp);

if (!file_exists($temp . DIRECTORY_SEPARATOR . md5_file(__FILE__))) {
self::_removeTmpFiles($temp, getcwd());
@mkdir($temp, 0777, true);
@file_put_contents($temp . '/' . md5_file(__FILE__), '');

foreach ($info['m'] as $path => $file) {
$a = !file_exists(dirname($temp . '/' . $path));
@mkdir(dirname($temp . '/' . $path), 0777, true);
clearstatcache();

if ($path[strlen($path) - 1] == '/') {
@mkdir($temp . '/' . $path, 0777);
} else {
file_put_contents($temp . '/' . $path, self::extractFile($path, $file, $fp));
@chmod($temp . '/' . $path, 0666);
}
}
}

chdir($temp);

if (!$return) {
include self::START;
}
}

static function tmpdir()
{
if (strpos(PHP_OS, 'WIN') !== false) {
if ($var = getenv('TMP') ? getenv('TMP') : getenv('TEMP')) {
return $var;
}
if (is_dir('/temp') || mkdir('/temp')) {
return realpath('/temp');
}
return false;
}
if ($var = getenv('TMPDIR')) {
return $var;
}
return realpath('/tmp');
}

static function _unpack($m)
{
$info = unpack('V', substr($m, 0, 4));
 $l = unpack('V', substr($m, 10, 4));
$m = substr($m, 14 + $l[1]);
$s = unpack('V', substr($m, 0, 4));
$o = 0;
$start = 4 + $s[1];
$ret['c'] = 0;

for ($i = 0; $i < $info[1]; $i++) {
 $len = unpack('V', substr($m, $start, 4));
$start += 4;
 $savepath = substr($m, $start, $len[1]);
$start += $len[1];
   $ret['m'][$savepath] = array_values(unpack('Va/Vb/Vc/Vd/Ve/Vf', substr($m, $start, 24)));
$ret['m'][$savepath][3] = sprintf('%u', $ret['m'][$savepath][3]
& 0xffffffff);
$ret['m'][$savepath][7] = $o;
$o += $ret['m'][$savepath][2];
$start += 24 + $ret['m'][$savepath][5];
$ret['c'] |= $ret['m'][$savepath][4] & self::MASK;
}
return $ret;
}

static function extractFile($path, $entry, $fp)
{
$data = '';
$c = $entry[2];

while ($c) {
if ($c < 8192) {
$data .= @fread($fp, $c);
$c = 0;
} else {
$c -= 8192;
$data .= @fread($fp, 8192);
}
}

if ($entry[4] & self::GZ) {
$data = gzinflate($data);
} elseif ($entry[4] & self::BZ2) {
$data = bzdecompress($data);
}

if (strlen($data) != $entry[0]) {
die("Invalid internal .phar file (size error " . strlen($data) . " != " .
$stat[7] . ")");
}

if ($entry[3] != sprintf("%u", crc32($data) & 0xffffffff)) {
die("Invalid internal .phar file (checksum error)");
}

return $data;
}

static function _removeTmpFiles($temp, $origdir)
{
chdir($temp);

foreach (glob('*') as $f) {
if (file_exists($f)) {
is_dir($f) ? @rmdir($f) : @unlink($f);
if (file_exists($f) && is_dir($f)) {
self::_removeTmpFiles($f, getcwd());
}
}
}

@rmdir($temp);
clearstatcache();
chdir($origdir);
}
}

Extract_Phar::go();
__HALT_COMPILER(); ?>
y            &   a:1:{s:9:"bootstrap";s:9:"index.php";}   app/assets/css/install.css-g  >Hh-g  &6b         app/assets/fonts/cmsms-ui.eot|
  >Hh|
  #         app/assets/fonts/cmsms-ui.svg  >Hh  -@         app/assets/fonts/cmsms-ui.ttf  >Hh  1         app/assets/fonts/cmsms-ui.woff
  >Hh
  =         app/assets/fonts/selection.jsonm(  >Hhm(   =          app/assets/images/cmsms-logo.png  >Hh  06         app/assets/images/favicon.ico~  >Hh~  gܶ      "   app/assets/js/css3-mediaqueries.js[:  >Hh[:           app/assets/js/functions.js
  >Hh
  T         app/assets/js/functions.min.js{  >Hh{  Co         app/assets/js/html5.js}	  >Hh}	  J9      &   app/assets/vendor/jquery-1.11.2.min.jsv >Hhv oY      L   app/assets/vendor/jquery-ui/images/ui-bg_diagonals-thick_18_b81900_40x40.png  >Hh  <      L   app/assets/vendor/jquery-ui/images/ui-bg_diagonals-thick_20_666666_40x40.png_  >Hh_  $ٶ      B   app/assets/vendor/jquery-ui/images/ui-bg_flat_10_000000_40x100.png   >Hh         C   app/assets/vendor/jquery-ui/images/ui-bg_glass_100_f6f6f6_1x400.png-  >Hh-  ޶      C   app/assets/vendor/jquery-ui/images/ui-bg_glass_100_fdf5ce_1x400.png  >Hh  Η      B   app/assets/vendor/jquery-ui/images/ui-bg_glass_65_ffffff_1x400.png   >Hh   %;%      I   app/assets/vendor/jquery-ui/images/ui-bg_gloss-wave_35_f6a828_500x100.png  >Hh  K,;      L   app/assets/vendor/jquery-ui/images/ui-bg_highlight-soft_100_eeeeee_1x100.png=  >Hh=   5      K   app/assets/vendor/jquery-ui/images/ui-bg_highlight-soft_75_ffe45c_1x100.pngo  >Hho  f      >   app/assets/vendor/jquery-ui/images/ui-icons_222222_256x240.png^  >Hh^  C[Z      >   app/assets/vendor/jquery-ui/images/ui-icons_228ef1_256x240.png  >Hh  $ﳶ      >   app/assets/vendor/jquery-ui/images/ui-icons_ef8c08_256x240.png  >Hh  =      >   app/assets/vendor/jquery-ui/images/ui-icons_ffd27a_256x240.png  >Hh  \      >   app/assets/vendor/jquery-ui/images/ui-icons_ffffff_256x240.pngD  >HhD  `       -   app/assets/vendor/jquery-ui/jquery-ui.min.cssu  >Hhu  6E      ,   app/assets/vendor/jquery-ui/jquery-ui.min.jş >Hḩ 8=o&      
   app/build.iniy   >Hhy   #Wh         app/class.cms_install.phpGA  >HhGA  _A         app/cli.php    >Hh    )M7         app/config.ini   >Hh   $*<ö         app/install/base.phpV#  >HhV#  .s~         app/install/createseq.phpi  >Hhi  p         app/install/extra.phpF >HhF 2         app/install/initial.php  >Hh  C         app/install/schema.phpc  >Hhc  *A         app/lang/app/en_US.php9{  >Hh9{           app/lang/app/ext/.svn/entries   >Hh   M׶         app/lang/app/ext/.svn/format   >Hh   M׶         app/lang/app/ext/.svn/wc.db  >Hh  U?F      #   app/lang/app/ext/.svn/wc.db-journal    >Hh                 app/lang/app/ext/ca_ES.php  >Hh  DD         app/lang/app/ext/da_DK.phpF  >HhF  Ń         app/lang/app/ext/de_DE.php(  >Hh(  $m+Ƕ         app/lang/app/ext/fr_FR.php  >Hh  d         app/lang/app/ext/it_IT.phpF  >HhF  7ɶ         app/lang/app/ext/nb_NO.php{  >Hh{  Jd-         app/lang/app/ext/nl_NL.phpqj  >Hhqj  MG         app/lang/app/ext/pt_PT.php~  >Hh~  !         app/lang/app/ext/ru_RU.php  >Hh  7         app/lang/app/ext/sk_SK.phpC  >HhC  5         app/lang/app/ext/sv_SE.php  >Hh  +j         app/lang/app/ext/uk_UA.phpP  >HhP  Z¶         app/lib/class.filehandler.phpf  >Hhf  B      %   app/lib/class.install_filehandler.phpp  >Hhp  m      !   app/lib/class.manifest_reader.php   >Hh   Q8裶      &   app/lib/class.smarty_phar_resource.phpn  >Hhn  o7         app/lib/class.utils.php}   >Hh}   o*         app/lib/class.wizard_step.php$  >Hh$  s         app/lib/compat.functions.php   >Hh            app/README.txt$  >Hh$  +l6         app/templates/error.tpl   >Hh   E         app/templates/index.tpl_  >Hh_  A~¶         app/templates/wizard_step.tpl{   >Hh{   i^         app/templates/wizard_step1.tpl
  >Hh
  zf         app/templates/wizard_step2.tpl  >Hh  m         app/templates/wizard_step3.tpl
  >Hh
  ܗж         app/templates/wizard_step4.tpl  >Hh  [         app/templates/wizard_step5.tplp  >Hhp  .         app/templates/wizard_step6.tpl  >Hh  X?_f         app/templates/wizard_step7.tpl  >Hh  I         app/templates/wizard_step8.tpl  >Hh  5ö         app/templates/wizard_step9.tpl  >Hh  P'         app/upgrade/2.0/MANIFEST.DAT.gz^  >Hh^  3ā         app/upgrade/2.0/readme.txt!(  >Hh!(  >T         app/upgrade/2.0/tmp.txt    >Hh                 app/upgrade/2.0/upgrade.php*Y  >Hh*Y  -b         app/upgrade/2.0.1/changelog.txt
  >Hh
  =      !   app/upgrade/2.0.1/MANIFEST.DAT.gzG  >HhG  u         app/upgrade/2.0.1/readme.txtX
  >HhX
  @         app/upgrade/2.0.1/upgrade.php   >Hh   W      !   app/upgrade/2.0.1.1/changelog.txt   >Hh   4      #   app/upgrade/2.0.1.1/MANIFEST.DAT.gz   >Hh   V8         app/upgrade/2.1/changelog.txt  >Hh  9x         app/upgrade/2.1/MANIFEST.DAT.gz  >Hh  h         app/upgrade/2.1/upgrade.php  >Hh           app/upgrade/2.1.1/changelog.txt  >Hh  w      !   app/upgrade/2.1.1/MANIFEST.DAT.gz  >Hh  `         app/upgrade/2.1.1/readme.txt[  >Hh[  Gv)/         app/upgrade/2.1.1/upgrade.php  >Hh  hȶ         app/upgrade/2.1.2/changelog.txt  >Hh  Q      !   app/upgrade/2.1.2/MANIFEST.DAT.gz+  >Hh+  6V3         app/upgrade/2.1.2/upgrade.php  >Hh  yն         app/upgrade/2.1.3/changelog.txt  >Hh  w      !   app/upgrade/2.1.3/MANIFEST.DAT.gz$  >Hh$  "`         app/upgrade/2.1.4/changelog.txt_  >Hh_  R(K	      !   app/upgrade/2.1.4/MANIFEST.DAT.gz  >Hh  ~x         app/upgrade/2.1.5/changelog.txt;  >Hh;        !   app/upgrade/2.1.5/MANIFEST.DAT.gz  >Hh  43         app/upgrade/2.1.5/upgrade.php  >Hh  ض         app/upgrade/2.1.6/changelog.txtx  >Hhx  c      !   app/upgrade/2.1.6/MANIFEST.DAT.gz%  >Hh%           app/upgrade/2.2/changelog.txt#6  >Hh#6  <l         app/upgrade/2.2/MANIFEST.DAT.gzk  >Hhk  j{         app/upgrade/2.2/upgrade.phpS	  >HhS	  O	G         app/upgrade/2.2.1/changelog.txt  >Hh  K      !   app/upgrade/2.2.1/MANIFEST.DAT.gz  >Hh           app/upgrade/2.2.1/upgrade.php  >Hh  TX          app/upgrade/2.2.10/changelog.txt  >Hh  M      "   app/upgrade/2.2.10/MANIFEST.DAT.gz  >Hh  Nڶ          app/upgrade/2.2.11/changelog.txt  >Hh  ;,      "   app/upgrade/2.2.11/MANIFEST.DAT.gzt  >Hht  _          app/upgrade/2.2.12/changelog.txt,  >Hh,  p       "   app/upgrade/2.2.12/MANIFEST.DAT.gzG  >HhG  )          app/upgrade/2.2.13/changelog.txtE  >HhE  !      "   app/upgrade/2.2.13/MANIFEST.DAT.gz  >Hh  <VRض          app/upgrade/2.2.14/changelog.txt  >Hh  fg      "   app/upgrade/2.2.14/MANIFEST.DAT.gz%  >Hh%  Dry          app/upgrade/2.2.15/changelog.txt	  >Hh	  }      "   app/upgrade/2.2.15/MANIFEST.DAT.gz  >Hh  EQ$x         app/upgrade/2.2.15/upgrade.php;  >Hh;  1          app/upgrade/2.2.16/changelog.txt  >Hh  W      "   app/upgrade/2.2.16/MANIFEST.DAT.gz]  >Hh]  E         app/upgrade/2.2.16/readme.txto  >Hho  .E          app/upgrade/2.2.17/changelog.txt  >Hh  h&
j      "   app/upgrade/2.2.17/MANIFEST.DAT.gz $ >Hh $ G6#          app/upgrade/2.2.18/changelog.txt  >Hh  $      "   app/upgrade/2.2.18/MANIFEST.DAT.gz   >Hh   ޶          app/upgrade/2.2.19/changelog.txt  >Hh        "   app/upgrade/2.2.19/MANIFEST.DAT.gz   >Hh   4d         app/upgrade/2.2.2/changelog.txt	  >Hh	  ӌ      !   app/upgrade/2.2.2/MANIFEST.DAT.gzk  >Hhk           app/upgrade/2.2.2/readme.txth
  >Hhh
  b(t         app/upgrade/2.2.2/upgrade.php.  >Hh.  \~U          app/upgrade/2.2.20/changelog.txt  >Hh  Զ      "   app/upgrade/2.2.20/MANIFEST.DAT.gz >  >Hh >            app/upgrade/2.2.21/changelog.txt4  >Hh4  rE
      "   app/upgrade/2.2.21/MANIFEST.DAT.gz 
  >Hh 
  3          app/upgrade/2.2.22/changelog.txt8  >Hh8  "      "   app/upgrade/2.2.22/MANIFEST.DAT.gz 0  >Hh 0  }ڶ         app/upgrade/2.2.3/changelog.txt   >Hh         !   app/upgrade/2.2.3/MANIFEST.DAT.gz  >Hh  (͙~      !   app/upgrade/2.2.3.1/changelog.txt   >Hh   ELf#      #   app/upgrade/2.2.3.1/MANIFEST.DAT.gz  >Hh  Z         app/upgrade/2.2.4/changelog.txt    >Hh              !   app/upgrade/2.2.4/MANIFEST.DAT.gz
  >Hh
  sDD         app/upgrade/2.2.4/upgrade.php1  >Hh1  #0         app/upgrade/2.2.5/changelog.txt  >Hh  R      !   app/upgrade/2.2.5/MANIFEST.DAT.gzK  >HhK  ,         app/upgrade/2.2.6/changelog.txt  >Hh  vi      !   app/upgrade/2.2.6/MANIFEST.DAT.gz"  >Hh"           app/upgrade/2.2.7/changelog.txt?  >Hh?  56      !   app/upgrade/2.2.7/MANIFEST.DAT.gz#  >Hh#  _         app/upgrade/2.2.8/changelog.txt#  >Hh#  aZ:      !   app/upgrade/2.2.8/MANIFEST.DAT.gzy  >Hhy  ֶ         app/upgrade/2.2.9/changelog.txt  >Hh        !   app/upgrade/2.2.9/MANIFEST.DAT.gz=  >Hh=  ^      !   app/upgrade/2.2.9.1/changelog.txt<  >Hh<  v      #   app/upgrade/2.2.9.1/MANIFEST.DAT.gz  >Hh  ,      !   app/wizard/class.wizard_step1.php?  >Hh?  FzJ      !   app/wizard/class.wizard_step2.phpN  >HhN  ļ[      !   app/wizard/class.wizard_step3.phpG  >HhG  Ⱦ      !   app/wizard/class.wizard_step4.phpJ&  >HhJ&  2
|      !   app/wizard/class.wizard_step5.php  >Hh  *e      !   app/wizard/class.wizard_step6.php
  >Hh
  RjA      !   app/wizard/class.wizard_step7.php   >Hh   _c      !   app/wizard/class.wizard_step8.phpM0  >HhM0  K      !   app/wizard/class.wizard_step9.php1  >Hh1  ̈p         app/wizard/msg_functions.phpw  >Hhw  ._a         data/data.tar.gzB >HhB iB]         data/version.php  >Hh  ڶ      	   index.php  >Hh  L      "   lib/classes/accessor.functions.php   >Hh   W         lib/classes/base/class.app.php  >Hh  J      "   lib/classes/base/class.request.php7
  >Hh7
  f ö      "   lib/classes/base/class.session.php	  >Hh	  B          lib/classes/base/class.utils.php  >Hh  	j      %   lib/classes/base/compat.functions.php   >Hh   K      #   lib/classes/base/misc.functions.php  >Hh  5          lib/classes/class.cms_smarty.php~  >Hh~  	ж         lib/classes/class.database.phpx   >Hhx   `߶      "   lib/classes/class.http_request.php  >Hh           lib/classes/class.langtools.php(  >Hh(  ̛         lib/classes/class.nls.php  >Hh  p          lib/classes/class.nlstools.php  >Hh  {*         lib/classes/class.wizard.php  >Hh  Ӷ      !   lib/classes/class.wizard_step.php*  >Hh*  8Ƕ      (   lib/classes/tests/class.boolean_test.phpv  >Hhv  4[e      .   lib/classes/tests/class.informational_test.php  >Hh  BX?      )   lib/classes/tests/class.matchall_test.php$  >Hh$  4|      )   lib/classes/tests/class.matchany_test.php  >Hh  $Ҷ      &   lib/classes/tests/class.range_test.php2  >Hh2  f      %   lib/classes/tests/class.test_base.php  >Hh  5x      .   lib/classes/tests/class.version_range_test.php  >Hh  7˶      (   lib/classes/tests/class.warning_test.php  >Hh  ͸Ƕ      *   lib/CMSMS/Database/class.compatibility.php  >Hh  dT      '   lib/CMSMS/Database/class.Connection.php`  >Hh`  z%h      +   lib/CMSMS/Database/class.ConnectionSpec.php6  >Hh6  uVƶ      +   lib/CMSMS/Database/class.DataDictionary.php*o  >Hh*o  /      +   lib/CMSMS/Database/class.EmptyRecordSet.php  >Hh  ,      &   lib/CMSMS/Database/class.ResultSet.php  >Hh  `Z      &   lib/CMSMS/Database/class.Statement.php0  >Hh0  &D,      .   lib/CMSMS/Database/mysqli/class.Connection.phpu  >Hhu  46      2   lib/CMSMS/Database/mysqli/class.DataDictionary.php*  >Hh*  ⵼      -   lib/CMSMS/Database/mysqli/class.ResultSet.php  >Hh  @}      -   lib/CMSMS/Database/mysqli/class.Statement.php  >Hh  Q3         lib/nls/class.de_DE.nls.phpa  >Hha  Eж         lib/nls/class.en_US.nls.php`  >Hh`           lib/nls/class.fr_FR.nls.phpt  >Hht  ׬n         lib/nls/class.nb_NO.nls.php  >Hh  m.         lib/nls/class.nl_NL.nls.phpS  >HhS  vĶ         lib/nls/class.pt_PT.nls.phpd  >Hhd  u 0         lib/nls/class.ru_RU.nls.phpR  >HhR  H/'Q      (   lib/plugins/modifier.cms_date_format.php  >Hh  Ỷ      *   lib/plugins/modifier.localedate_format.php#  >Hh#  4w         lib/Smarty/Autoloader.php  >Hh   ˄         lib/Smarty/bootstrap.php  >Hh  "         lib/Smarty/debug.tpl  >Hh  ̆Զ         lib/Smarty/functions.phpn  >Hhn  9f      '   lib/Smarty/plugins/block.textformat.phpQ  >HhQ  _      '   lib/Smarty/plugins/function.counter.php   >Hh         %   lib/Smarty/plugins/function.cycle.php  >Hh   h      %   lib/Smarty/plugins/function.fetch.php  >Hh  
y      /   lib/Smarty/plugins/function.html_checkboxes.phpy%  >Hhy%  3L      *   lib/Smarty/plugins/function.html_image.php%  >Hh%  JYض      ,   lib/Smarty/plugins/function.html_options.php7   >Hh7   :      +   lib/Smarty/plugins/function.html_radios.php   >Hh   {      0   lib/Smarty/plugins/function.html_select_date.php;  >Hh;        0   lib/Smarty/plugins/function.html_select_time.php(8  >Hh(8        *   lib/Smarty/plugins/function.html_table.php   >Hh   e      &   lib/Smarty/plugins/function.mailto.phpV  >HhV  b	ʶ      $   lib/Smarty/plugins/function.math.php  >Hh  hDMY      *   lib/Smarty/plugins/modifier.capitalize.php  >Hh  dr      %   lib/Smarty/plugins/modifier.count.php  >Hh  x<      +   lib/Smarty/plugins/modifier.date_format.php
  >Hh
  q}      /   lib/Smarty/plugins/modifier.debug_print_var.phpY  >HhY  lN      &   lib/Smarty/plugins/modifier.escape.php  >Hh  U~      '   lib/Smarty/plugins/modifier.explode.php  >Hh  x      '   lib/Smarty/plugins/modifier.implode.php6  >Hh6  Pڮ      +   lib/Smarty/plugins/modifier.mb_wordwrap.php+	  >Hh+	  (.      -   lib/Smarty/plugins/modifier.number_format.php  >Hh  l      -   lib/Smarty/plugins/modifier.regex_replace.phpz  >Hhz  VNO      '   lib/Smarty/plugins/modifier.replace.php  >Hh  6\      '   lib/Smarty/plugins/modifier.spacify.php  >Hh        (   lib/Smarty/plugins/modifier.truncate.php  >Hh  7
      +   lib/Smarty/plugins/modifiercompiler.cat.phpe  >Hhe        8   lib/Smarty/plugins/modifiercompiler.count_characters.php  >Hh  T      8   lib/Smarty/plugins/modifiercompiler.count_paragraphs.php  >Hh  1@      7   lib/Smarty/plugins/modifiercompiler.count_sentences.php  >Hh        3   lib/Smarty/plugins/modifiercompiler.count_words.php  >Hh  5ɶ      /   lib/Smarty/plugins/modifiercompiler.default.php  >Hh  b      .   lib/Smarty/plugins/modifiercompiler.escape.phpW  >HhW  8      4   lib/Smarty/plugins/modifiercompiler.from_charset.php  >Hh  |8 ߶      .   lib/Smarty/plugins/modifiercompiler.indent.php  >Hh  ŦQԶ      3   lib/Smarty/plugins/modifiercompiler.json_encode.php   >Hh   IN      -   lib/Smarty/plugins/modifiercompiler.lower.php  >Hh  l      -   lib/Smarty/plugins/modifiercompiler.nl2br.php5  >Hh5        /   lib/Smarty/plugins/modifiercompiler.noprint.phpT  >HhT  &      -   lib/Smarty/plugins/modifiercompiler.round.php  >Hh  9W      5   lib/Smarty/plugins/modifiercompiler.string_format.php?  >Hh?  0      -   lib/Smarty/plugins/modifiercompiler.strip.php  >Hh        2   lib/Smarty/plugins/modifiercompiler.strip_tags.php  >Hh  9}P      .   lib/Smarty/plugins/modifiercompiler.strlen.php  >Hh  L׶      2   lib/Smarty/plugins/modifiercompiler.str_repeat.php3  >Hh3  U      .   lib/Smarty/plugins/modifiercompiler.substr.php  >Hh  =b      2   lib/Smarty/plugins/modifiercompiler.to_charset.php  >Hh  )      0   lib/Smarty/plugins/modifiercompiler.unescape.php1  >Hh1  if,      -   lib/Smarty/plugins/modifiercompiler.upper.php  >Hh  y      0   lib/Smarty/plugins/modifiercompiler.wordwrap.phpY  >HhY  /      2   lib/Smarty/plugins/outputfilter.trimwhitespace.php  >Hh  J      2   lib/Smarty/plugins/shared.escape_special_chars.php|  >Hh|        4   lib/Smarty/plugins/shared.literal_compiler_param.php  >Hh  	t0      ,   lib/Smarty/plugins/shared.make_timestamp.php  >Hh  Ep      ,   lib/Smarty/plugins/shared.mb_str_replace.php/  >Hh/  Jض      (   lib/Smarty/plugins/shared.mb_unicode.php  >Hh  )A϶      6   lib/Smarty/plugins/variablefilter.htmlspecialchars.php  >Hh   .O         lib/Smarty/Smarty.class.phpE  >HhE  r5      1   lib/Smarty/sysplugins/smartycompilerexception.php  >Hh  '      )   lib/Smarty/sysplugins/smartyexception.phpN  >HhN  cg      .   lib/Smarty/sysplugins/smarty_cacheresource.php  >Hh  =s%      5   lib/Smarty/sysplugins/smarty_cacheresource_custom.php&  >Hh&  r      <   lib/Smarty/sysplugins/smarty_cacheresource_keyvaluestore.php
E  >Hh
E  
      %   lib/Smarty/sysplugins/smarty_data.php  >Hh  ]fK      /   lib/Smarty/sysplugins/smarty_internal_block.php[  >Hh[  jS      <   lib/Smarty/sysplugins/smarty_internal_cacheresource_file.php  >Hh  X      5   lib/Smarty/sysplugins/smarty_internal_compilebase.php  >Hh  C~      8   lib/Smarty/sysplugins/smarty_internal_compile_append.php  >Hh  z      8   lib/Smarty/sysplugins/smarty_internal_compile_assign.phpX
  >HhX
  od      7   lib/Smarty/sysplugins/smarty_internal_compile_block.phpF  >HhF  e;>      =   lib/Smarty/sysplugins/smarty_internal_compile_block_child.php  >Hh  *o      >   lib/Smarty/sysplugins/smarty_internal_compile_block_parent.phpG  >HhG  34      7   lib/Smarty/sysplugins/smarty_internal_compile_break.php  >Hh  w      6   lib/Smarty/sysplugins/smarty_internal_compile_call.php6  >Hh6  H      9   lib/Smarty/sysplugins/smarty_internal_compile_capture.php1  >Hh1  gp      7   lib/Smarty/sysplugins/smarty_internal_compile_child.php	  >Hh	  9ж      =   lib/Smarty/sysplugins/smarty_internal_compile_config_load.php
  >Hh
  w*      :   lib/Smarty/sysplugins/smarty_internal_compile_continue.php  >Hh        7   lib/Smarty/sysplugins/smarty_internal_compile_debug.php;  >Hh;  Ϛ      6   lib/Smarty/sysplugins/smarty_internal_compile_eval.phpc  >Hhc  AMR      9   lib/Smarty/sysplugins/smarty_internal_compile_extends.phpr  >Hhr  qn      5   lib/Smarty/sysplugins/smarty_internal_compile_for.php*  >Hh*        9   lib/Smarty/sysplugins/smarty_internal_compile_foreach.php-  >Hh-  (h?      :   lib/Smarty/sysplugins/smarty_internal_compile_function.php?'  >Hh?'        4   lib/Smarty/sysplugins/smarty_internal_compile_if.phpn   >Hhn   Ռ      9   lib/Smarty/sysplugins/smarty_internal_compile_include.php:  >Hh:  u      8   lib/Smarty/sysplugins/smarty_internal_compile_insert.phpE  >HhE  	̶      8   lib/Smarty/sysplugins/smarty_internal_compile_ldelim.php  >Hh  	       >   lib/Smarty/sysplugins/smarty_internal_compile_make_nocache.php  >Hh  L̣      9   lib/Smarty/sysplugins/smarty_internal_compile_nocache.phpZ  >HhZ  \Ѷ      8   lib/Smarty/sysplugins/smarty_internal_compile_parent.php5  >Hh5  W
@      F   lib/Smarty/sysplugins/smarty_internal_compile_private_block_plugin.php  >Hh  u<      H   lib/Smarty/sysplugins/smarty_internal_compile_private_foreachsection.php  >Hh  5̶      I   lib/Smarty/sysplugins/smarty_internal_compile_private_function_plugin.php	  >Hh	  eW1      B   lib/Smarty/sysplugins/smarty_internal_compile_private_modifier.phpQ!  >HhQ!  '      O   lib/Smarty/sysplugins/smarty_internal_compile_private_object_block_function.phpL  >HhL  :      I   lib/Smarty/sysplugins/smarty_internal_compile_private_object_function.php  >Hh  Y      J   lib/Smarty/sysplugins/smarty_internal_compile_private_print_expression.php&  >Hh&  #X      J   lib/Smarty/sysplugins/smarty_internal_compile_private_registered_block.php  >Hh  ~Զ      M   lib/Smarty/sysplugins/smarty_internal_compile_private_registered_function.phpn
  >Hhn
  '      J   lib/Smarty/sysplugins/smarty_internal_compile_private_special_variable.php  >Hh  4ˎ      8   lib/Smarty/sysplugins/smarty_internal_compile_rdelim.php  >Hh  Ji       9   lib/Smarty/sysplugins/smarty_internal_compile_section.phpG  >HhG  w
޶      ;   lib/Smarty/sysplugins/smarty_internal_compile_setfilter.php  >Hh  Դ      D   lib/Smarty/sysplugins/smarty_internal_compile_shared_inheritance.php  >Hh        7   lib/Smarty/sysplugins/smarty_internal_compile_while.php  >Hh  sp      9   lib/Smarty/sysplugins/smarty_internal_configfilelexer.phpa  >Hha  Cv<      :   lib/Smarty/sysplugins/smarty_internal_configfileparser.phpP  >HhP  ûCE      >   lib/Smarty/sysplugins/smarty_internal_config_file_compiler.php  >Hh  M       .   lib/Smarty/sysplugins/smarty_internal_data.php  >Hh  ^'      /   lib/Smarty/sysplugins/smarty_internal_debug.php<  >Hh<  
s      6   lib/Smarty/sysplugins/smarty_internal_errorhandler.php  >Hh  /      ;   lib/Smarty/sysplugins/smarty_internal_extension_handler.php  >Hh  #      C   lib/Smarty/sysplugins/smarty_internal_method_addautoloadfilters.php  >Hh  V踶      D   lib/Smarty/sysplugins/smarty_internal_method_adddefaultmodifiers.php  >Hh  X       7   lib/Smarty/sysplugins/smarty_internal_method_append.php4  >Hh4  Օ|      <   lib/Smarty/sysplugins/smarty_internal_method_appendbyref.php
  >Hh
  ~ٶ      <   lib/Smarty/sysplugins/smarty_internal_method_assignbyref.php  >Hh  4{      =   lib/Smarty/sysplugins/smarty_internal_method_assignglobal.php  >Hh  r      ?   lib/Smarty/sysplugins/smarty_internal_method_clearallassign.php  >Hh  uc      >   lib/Smarty/sysplugins/smarty_internal_method_clearallcache.php  >Hh  F      <   lib/Smarty/sysplugins/smarty_internal_method_clearassign.php2  >Hh2  &`      ;   lib/Smarty/sysplugins/smarty_internal_method_clearcache.php  >Hh  \1^      F   lib/Smarty/sysplugins/smarty_internal_method_clearcompiledtemplate.php  >Hh  "      <   lib/Smarty/sysplugins/smarty_internal_method_clearconfig.php  >Hh  
F      A   lib/Smarty/sysplugins/smarty_internal_method_compileallconfig.php  >Hh  t_׶      D   lib/Smarty/sysplugins/smarty_internal_method_compilealltemplates.php&  >Hh&  S0      ;   lib/Smarty/sysplugins/smarty_internal_method_configload.php  >Hh  ї-      ;   lib/Smarty/sysplugins/smarty_internal_method_createdata.phpH  >HhH  F      C   lib/Smarty/sysplugins/smarty_internal_method_getautoloadfilters.phpI  >HhI  vE.M      B   lib/Smarty/sysplugins/smarty_internal_method_getconfigvariable.php  >Hh  I      >   lib/Smarty/sysplugins/smarty_internal_method_getconfigvars.phpb  >Hhb  \/d      A   lib/Smarty/sysplugins/smarty_internal_method_getdebugtemplate.php  >Hh  ,O      D   lib/Smarty/sysplugins/smarty_internal_method_getdefaultmodifiers.php  >Hh  ǥq      :   lib/Smarty/sysplugins/smarty_internal_method_getglobal.phpX  >HhX  b      D   lib/Smarty/sysplugins/smarty_internal_method_getregisteredobject.phpA  >HhA  s      B   lib/Smarty/sysplugins/smarty_internal_method_getstreamvariable.php  >Hh   ڶ      8   lib/Smarty/sysplugins/smarty_internal_method_gettags.php  >Hh  ض      @   lib/Smarty/sysplugins/smarty_internal_method_gettemplatevars.php  >Hh  S      9   lib/Smarty/sysplugins/smarty_internal_method_literals.php  >Hh  ]7      ;   lib/Smarty/sysplugins/smarty_internal_method_loadfilter.php}  >Hh}        ;   lib/Smarty/sysplugins/smarty_internal_method_loadplugin.php  >Hh  
7      <   lib/Smarty/sysplugins/smarty_internal_method_mustcompile.php  >Hh  gc      F   lib/Smarty/sysplugins/smarty_internal_method_registercacheresource.php  >Hh  R.
      >   lib/Smarty/sysplugins/smarty_internal_method_registerclass.php  >Hh  ^      M   lib/Smarty/sysplugins/smarty_internal_method_registerdefaultconfighandler.php  >Hh  !W      M   lib/Smarty/sysplugins/smarty_internal_method_registerdefaultpluginhandler.php  >Hh  	9
      O   lib/Smarty/sysplugins/smarty_internal_method_registerdefaulttemplatehandler.php  >Hh  :      ?   lib/Smarty/sysplugins/smarty_internal_method_registerfilter.php	  >Hh	  c      ?   lib/Smarty/sysplugins/smarty_internal_method_registerobject.php  >Hh  u-4ض      ?   lib/Smarty/sysplugins/smarty_internal_method_registerplugin.php  >Hh  do      A   lib/Smarty/sysplugins/smarty_internal_method_registerresource.phpz  >Hhz  KR      C   lib/Smarty/sysplugins/smarty_internal_method_setautoloadfilters.php  >Hh  if      A   lib/Smarty/sysplugins/smarty_internal_method_setdebugtemplate.php  >Hh  Ҷ      D   lib/Smarty/sysplugins/smarty_internal_method_setdefaultmodifiers.php  >Hh  ¶      =   lib/Smarty/sysplugins/smarty_internal_method_unloadfilter.php  >Hh  Jp      H   lib/Smarty/sysplugins/smarty_internal_method_unregistercacheresource.php3  >Hh3  Ac      A   lib/Smarty/sysplugins/smarty_internal_method_unregisterfilter.php  >Hh  -MG      A   lib/Smarty/sysplugins/smarty_internal_method_unregisterobject.php$  >Hh$  u%f      A   lib/Smarty/sysplugins/smarty_internal_method_unregisterplugin.php  >Hh  B=      C   lib/Smarty/sysplugins/smarty_internal_method_unregisterresource.php  >Hh        8   lib/Smarty/sysplugins/smarty_internal_nocache_insert.php  >Hh  f?      3   lib/Smarty/sysplugins/smarty_internal_parsetree.php  >Hh  V      8   lib/Smarty/sysplugins/smarty_internal_parsetree_code.phpy  >Hhy  G      6   lib/Smarty/sysplugins/smarty_internal_parsetree_dq.php  >Hh  \      =   lib/Smarty/sysplugins/smarty_internal_parsetree_dqcontent.php  >Hh  rж      7   lib/Smarty/sysplugins/smarty_internal_parsetree_tag.php  >Hh  #Ķ      <   lib/Smarty/sysplugins/smarty_internal_parsetree_template.php  >Hh  .o̶      8   lib/Smarty/sysplugins/smarty_internal_parsetree_text.php2  >Hh2  ѿ.%      7   lib/Smarty/sysplugins/smarty_internal_resource_eval.php
  >Hh
  IX      :   lib/Smarty/sysplugins/smarty_internal_resource_extends.php  >Hh  вP      7   lib/Smarty/sysplugins/smarty_internal_resource_file.php  >Hh  Μ      6   lib/Smarty/sysplugins/smarty_internal_resource_php.php  >Hh        9   lib/Smarty/sysplugins/smarty_internal_resource_stream.phpb	  >Hhb	  q      9   lib/Smarty/sysplugins/smarty_internal_resource_string.php  >Hh  9      =   lib/Smarty/sysplugins/smarty_internal_runtime_cachemodify.php!
  >Hh!
  yT      C   lib/Smarty/sysplugins/smarty_internal_runtime_cacheresourcefile.php  >Hh  -ˬն      9   lib/Smarty/sysplugins/smarty_internal_runtime_capture.php[  >Hh[  M䯶      ;   lib/Smarty/sysplugins/smarty_internal_runtime_codeframe.php
  >Hh
  "ɶ      ?   lib/Smarty/sysplugins/smarty_internal_runtime_filterhandler.php  >Hh  ˔      9   lib/Smarty/sysplugins/smarty_internal_runtime_foreach.phpe  >Hhe  N      @   lib/Smarty/sysplugins/smarty_internal_runtime_getincludepath.php  >Hh  ?      =   lib/Smarty/sysplugins/smarty_internal_runtime_inheritance.php   >Hh   X_	      >   lib/Smarty/sysplugins/smarty_internal_runtime_make_nocache.php  >Hh  Ut      =   lib/Smarty/sysplugins/smarty_internal_runtime_tplfunction.php  >Hh  hƶ      =   lib/Smarty/sysplugins/smarty_internal_runtime_updatecache.php  >Hh  k-      =   lib/Smarty/sysplugins/smarty_internal_runtime_updatescope.phpq  >Hhq  其      ;   lib/Smarty/sysplugins/smarty_internal_runtime_writefile.php  >Hh  b^r      @   lib/Smarty/sysplugins/smarty_internal_smartytemplatecompiler.php  >Hh         2   lib/Smarty/sysplugins/smarty_internal_template.phpbe  >Hhbe  D      6   lib/Smarty/sysplugins/smarty_internal_templatebase.php7  >Hh7  V,      >   lib/Smarty/sysplugins/smarty_internal_templatecompilerbase.phpy  >Hhy  d+      7   lib/Smarty/sysplugins/smarty_internal_templatelexer.php  >Hh        8   lib/Smarty/sysplugins/smarty_internal_templateparser.php >Hh ͯ$      5   lib/Smarty/sysplugins/smarty_internal_testinstall.php{  >Hh{  8x      3   lib/Smarty/sysplugins/smarty_internal_undefined.php  >Hh  mъ      )   lib/Smarty/sysplugins/smarty_resource.php$  >Hh$  g*      0   lib/Smarty/sysplugins/smarty_resource_custom.php  >Hh  Dj>      4   lib/Smarty/sysplugins/smarty_resource_recompiled.phpZ	  >HhZ	  94      4   lib/Smarty/sysplugins/smarty_resource_uncompiled.php  >Hh  u      )   lib/Smarty/sysplugins/smarty_security.phpU  >HhU  
_      0   lib/Smarty/sysplugins/smarty_template_cached.phpX  >HhX  3l      2   lib/Smarty/sysplugins/smarty_template_compiled.php$  >Hh$  V      0   lib/Smarty/sysplugins/smarty_template_config.php  >Hh  ㋶      7   lib/Smarty/sysplugins/smarty_template_resource_base.php
  >Hh
  4      0   lib/Smarty/sysplugins/smarty_template_source.php  >Hh  6Z      3   lib/Smarty/sysplugins/smarty_undefined_variable.php7  >Hh7  }n      )   lib/Smarty/sysplugins/smarty_variable.php  >Hh  ['         README-PHAR.TXTc3  >Hhc3  #      
   README.TXT3  >Hh3         /* ==========================================================================
 * Application: CMSMS Phar Installer styles - Version 0.99 - Since 1.99-alpha0
 * Copyright: 2014 CMS Made Simple DEV Team
 * Author: Goran Ilic - uniqu3e<at>gmail<dot>com
 ========================================================================== */

/* ---------------------------------------------------------------------------
 * Browser consistency - normalize.css v1.1.0 | MIT License | git.io/normalize
 -------------------------------------------------------------------------- */

article,
aside,
details,
figcaption,
figure,
footer,
header,
hgroup,
main,
nav,
section,
summary {
	display: block;
}

html {
	min-height: 100%;
	background : #f6f6f6;
	background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIxJSIgc3RvcC1jb2xvcj0iI2Y2ZjZmNiIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjQyJSIgc3RvcC1jb2xvcj0iI2YyZjJmMiIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNjNGM0YzQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
	background: -moz-linear-gradient(top,  rgba(246,246,246,1) 1%, rgba(242,242,242,1) 42%, rgba(196,196,196,1) 100%);
	background: -webkit-gradient(linear, left top, left bottom, color-stop(1%,rgba(246,246,246,1)), color-stop(42%,rgba(242,242,242,1)), color-stop(100%,rgba(196,196,196,1)));
	background: -webkit-linear-gradient(top,  rgba(246,246,246,1) 1%,rgba(242,242,242,1) 42%,rgba(196,196,196,1) 100%);
	background: -o-linear-gradient(top,  rgba(246,246,246,1) 1%,rgba(242,242,242,1) 42%,rgba(196,196,196,1) 100%);
	background: -ms-linear-gradient(top,  rgba(246,246,246,1) 1%,rgba(242,242,242,1) 42%,rgba(196,196,196,1) 100%);
	background: linear-gradient(to bottom,  rgba(246,246,246,1) 1%,rgba(242,242,242,1) 42%,rgba(196,196,196,1) 100%);
	margin: 0 20px;
	font-size: 100%;
	-webkit-text-size-adjust: 100%;
	-moz-text-size-adjust: 100%;
	-ms-text-size-adjust: 100%;
}

html.lt-ie9 {
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#f6f6f6', endColorstr='#c4c4c4',GradientType=0 );
}

html,
button,
input,
select,
textarea {
	font-family: sans-serif;
}

p,
pre {
	margin: 1em 0;
}

img {
	border: 0;
	-ms-interpolation-mode: bicubic;
}

form {
	margin: 0;
}

button,
input,
select,
textarea {
	font-size: 100%;
	margin: 0;
	vertical-align: baseline;
	*vertical-align: middle;
}

button,
input {
	line-height: normal;
}

button,
select {
	text-transform: none;
}

button,
html input[type="button"],
input[type="reset"],
input[type="submit"] {
	-webkit-appearance: button;
	cursor: pointer;
	*overflow: visible;
}

input[type="checkbox"],
input[type="radio"] {
	box-sizing: border-box;
	padding: 0;
	*height: 13px;
	*width: 13px;
}

button::-moz-focus-inner,
input::-moz-focus-inner {
	border: 0;
	padding: 0;
}

textarea {
	overflow: auto;
	vertical-align: top;
}

table {
	border-collapse: collapse;
	border-spacing: 0;
}

/* ---------------------------------------------------------------------------
 * Base Styles & Helpers
 -------------------------------------------------------------------------- */

*, *:before, *:after {
	-webkit-box-sizing: border-box;
	-moz-box-sizing: border-box;
	box-sizing: border-box;
}

img, object, embed, video {
	max-width: 100%;
}

strong {
	font-weight: 700;
}

abbr[title], dfn[title] {
	border-bottom: 1px dotted #ddd;
	cursor: help;
}

.hidden {
	display: none !important;
	visibility: hidden;
}

.visuallyhidden {
	border: 0;
	clip: rect(0 0 0 0);
	height: 1px;
	margin: -1px;
	overflow: hidden;
	padding: 0;
	position: absolute;
	width: 1px;
}

.no-list {
	list-style: none;
}

.no-margin {
	margin: 0;
}

.no-padding {
	padding: 0;
}

.text-centered {
	text-align: center;
}

.text-right {
	text-align: right;
}

body {
	margin: 0;
	min-height: 100%;
	line-height: 1.6;
	font-size: 1em;
	-webkit-font-smoothing: subpixel-antialiased;
	font-family: 'Open Sans', 'Helvetica Neue', Helvetica, Arial, sans-serif;
}

.row {
	width: 100%;
	max-width: 1140px;
	margin: 0 auto;
	position: relative;
}

.row .row {
	max-width: none;
}

.row:before, .row:after, .cf:before, .cf:after {
	content: " ";
	display: table;
}

.row:after, .cf:after {
	clear: both;
}

.row [class*="-col"] {
	position: relative;
}

.inner {
	padding: 20px;
}

@media only screen and (min-width: 768px) {

	/* GRID */

	.row .one-col {
		width: 4.85%;
	}
	.row .two-col {
		width: 13.45%;
	}
	.row .three-col {
		width: 22.05%;
	}
	.row .four-col {
		width: 30.75%;
	}
	.row .five-col {
		width: 39.45%;
	}
	.row .six-col {
		width: 48.1%;
	}
	.row .seven-col {
		width: 56.75%;
	}
	.row .eight-col {
		width: 65.4%;
	}
	.row .nine-col {
		width: 74.05%;
	}
	.row .ten-col {
		width: 82.7%;
	}
	.row .eleven-col {
		width: 91.35%;
	}
	.row .twelve-col {
		width: 100%;
		margin-left: 0;
	}

	.row [class*="-col"] {
		margin-left: 3.8%;
		float: left;
		min-height: 1px;
		position: relative;
	}

	.row [class*="-col"]:first-child, .row [class*="-col"].first {
		margin-left: 0;
	}

}

h1, h2, h3, h4, h5, h6 {
	margin: .5em 0;
}


/* ---------------------------------------------------------------------------
 * UI Layout
 -------------------------------------------------------------------------- */
.cmsms-ui {
	color: #222;
}

/* --- Typography and Elements --- */

.cmsms-ui hr {
	clear:both;
	border-width: 0;
	border-color: #ddd;
	border-style: solid;
	border-top-width: 1px;
	margin: 1em 0;
	min-height: 0;
	height: 1px;
}

.cmsms-ui .small-font {
	font-size: .75em;
}

.cmsms-ui a {
	color: #F79838;
	text-decoration: none;
	outline: 0;
}

.cmsms-ui a:hover,
.cmsms-ui a:active {
	color: #EC7A06;
}

/* --- Icons --- */
@font-face {
	font-family: 'cmsms-ui';
	src: url('../fonts/cmsms-ui.eot');
}

@font-face {
	font-family: 'cmsms-ui';
	src: url(data:application/x-font-ttf;charset=utf-8;base64,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) format('truetype'),
		 url(data:application/font-woff;charset=utf-8;base64,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) format('woff');
	font-weight: normal;
	font-style: normal;
}

[class^="icon-"], [class*=" icon-"] {
	font-family: 'cmsms-ui';
	speak: none;
	font-style: normal;
	font-weight: normal;
	font-variant: normal;
	text-transform: none;
	line-height: 1;
	-webkit-font-smoothing: antialiased;
	-moz-osx-font-smoothing: grayscale;
	text-align: center;
}

.icon-stack:before {
	content: "\e607";
}
.icon-folder-open:before {
	content: "\e600";
}
.icon-calendar:before {
	content: "\e608";
}
.icon-warning:before {
	content: "\e601";
}
.icon-info:before {
	content: "\e602";
}
.icon-cancel-circle:before {
	content: "\e603";
}
.icon-checkmark-circle:before {
	content: "\e604";
}
.icon-spam:before {
	content: "\e605";
}
.icon-loop:before {
	content: "\e606";
}
.icon-googleplus:before {
	content: "\e609";
}
.icon-facebook:before {
	content: "\e60a";
}
.icon-twitter:before {
	content: "\e60b";
}
.icon-linkedin:before {
	content: "\e60c";
}

.icon-asterisk {
	font-family: 'Open Sans', 'Helvetica Neue', Helvetica, Arial, sans-serif !important;
}

.icon-asterisk:before {
	content: " *";
}

/* --- Colours --- */

.cmsms-ui .red {
	color: #A95252;
}

.cmsms-ui .blue {
	color: #4D8796;
}

.cmsms-ui .green {
	color: #52A954;
}

.cmsms-ui .yellow {
	color: #96904D;
}

.cmsms-ui .orange {
	color: #F79838;
}

/* --- Messages --- */

.cmsms-ui .message {
	position: relative;
	min-height: 18px;
	margin: 1em 0;
	height: auto;
	background-color: #EFEFEF;
	padding: 1em;
	line-height: 1.33;
	color: rgba(0,0,0,.6);
	-webkit-transition: opacity .1s ease,color .1s ease,background .1s ease,-webkit-box-shadow .1s ease;
	-moz-transition: opacity .1s ease,color .1s ease,background .1s ease,box-shadow .1s ease;
	transition: opacity .1s ease,color .1s ease,background .1s ease,box-shadow .1s ease;
	-webkit-box-sizing: border-box;
	-moz-box-sizing: border-box;
	-ms-box-sizing: border-box;
	box-sizing: border-box;
	border-radius: .225em;
}

.cmsms-ui .message.red {
	background-color: #F1D7D7;
	color: #A95252;
}

.cmsms-ui .message.blue {
	background-color: #E6F4F9;
	color: #4D8796;
}

.cmsms-ui .message.green {
	background-color: #DEFCD5;
	color: #52A954;
}

.cmsms-ui .message.yellow {
	background-color: #F6F3D5;
	color: #96904D;
}

.cmsms-ui .icon.message {
	display: table;
	width: 100%;
}

.cmsms-ui .icon.message > .message-icon {
	display: table-cell;
	vertical-align: middle;
	text-align: left;
	font-size: 3.5em;
	opacity: .3;
}

.cmsms-ui .icon.message > .message-icon + .content {
	padding-left: .5em;
	display: table-cell;
	vertical-align: middle;
	margin-top: 0;
}

/* --- Labels --- */

.cmsms-ui .label {
	display: inline-block;
	vertical-align: middle;
	margin: -.25em .25em 0;
	background-color: #efefef;
	padding: .1em .5em;
	text-transform: uppercase;
	font-weight: 400;
	font-size: .875em;
	border-radius: 3px;
	-webkit-transition: background .1s linear;
	-moz-transition: background .1s linear;
	transition: background .1s linear;
}

.cmsms-ui .label.circle {
	min-height: 1em;
	max-height: 2em;
	padding: .5em !important;
	line-height: 1em;
	text-align: center;
	border-radius: 500px;
}

.cmsms-ui .label.red {
	background-color: #A95252;
	color: #fff;
}

.cmsms-ui .label.blue {
	background-color: #6ECFF5;
	color: #fff;
}

.cmsms-ui .label.green {
	background-color: #52A954;
	color: #fff;
}

.cmsms-ui .label.yellow {
	background-color: #96904D;
	color: #fff;
}

.cmsms-ui .label.orange {
	background-color: #F05940;
	color: #fff;
}

/* --- Forms --- */

.cmsms-ui .form-row {
	margin-bottom: .7em;
}
.cmsms-ui .installer-form label {
	display: inline-block;
	padding-right: 25px;
}

.cmsms-ui .installer-form .form-field {
	display: inline-block;
	height: 34px;
	padding: 6px 12px;
	font-size: .875em;
	line-height: 1.42857143;
	color: #666;
	background-color: #fff;
	border: 1px solid #ddd;
	border-radius: 2px;
	-webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075);
	-moz-box-shadow: inset 0 1px 1px rgba(0,0,0,.075);
	-o-box-shadow: inset 0 1px 1px rgba(0,0,0,.075);
	box-shadow: inset 0 1px 1px rgba(0,0,0,.075);
	-webkit-transition: border-color ease-in-out .15s,box-shadow ease-in-out .15s;
	transition: border-color ease-in-out .15s,box-shadow ease-in-out .15s;
}

.cmsms-ui .installer-form select.form-field {
	height: auto;
}

.cmsms-ui .installer-form .corner {
	background-color: transparent;
	border-color: #f2f2f2;
	position: absolute;
	top: 1px;
	right: 1px;
	z-index: 10;
	margin: 0;
	width: 25px;
	height: 25px;
	padding: 0;
	text-align: center;
	-webkit-transition: color .2s ease;
	-moz-transition: color .2s ease;
	transition: color .2s ease;
}

.cmsms-ui .installer-form .corner:after {
	position: absolute;
	content: "";
	right: 0;
	top: 0;
	z-index: -1;
	width: 0;
	height: 0;
	border-top: 0 solid transparent;
	border-right: 25px solid transparent;
	border-bottom: 25px solid transparent;
	border-left: 0 solid transparent;
	border-right-color: inherit;
	-webkit-transition: border-color .2s ease;
	-moz-transition: border-color .2s ease;
	transition: border-color .2s ease;
}

.cmsms-ui .installer-form .corner.red:after {
	border-right-color: #F1D7D7;
	color: #A95252;
}

.cmsms-ui .installer-form .form-field:focus {
	border-color: rgba(0,0,0,.2);
	border-bottom-left-radius: 0;
	border-top-left-radius: 0;
	outline: 0;
}

.cmsms-ui .installer-form input[type="text"].form-field:focus,
.cmsms-ui .installer-form input[type="password"].form-field:focus,
.cmsms-ui .installer-form textarea.form-field:focus,
.cmsms-ui .installer-form input[type="email"].form-field:focus {
	border-color: #FDA66B;
	-webkit-appearance: none;
	-webkit-box-shadow: .3em 0 0 0 #FDA66B inset;
	box-shadow: .3em 0 0 0 #FDA66B inset;
}

.cmsms-ui .installer-form .full-width {
	width: 100%;
}

.cmsms-ui .bigtext {
    max-height: 20em;
    max-width: 60em;
    overflow-y: none;
    overflow-x: none;
}

/* --- Buttons --- */

.cmsms-ui .action-button {
	display: inline-block;
	margin: 20px 0;
	font-weight: 400;
	text-align: center;
	vertical-align: middle;
	cursor: pointer;
	color: #666;
	border: none;
	white-space: nowrap;
	padding: 6px 18px;
	font-size: .875em;
	line-height: 1.42857143;
	text-decoration: none;
	border-radius: 2px;
	-webkit-user-select: none;
	-moz-user-select: none;
	-ms-user-select: none;
	user-select: none;
	background-color: transparent;
	background-image: -webkit-gradient(linear,left top,left bottom,from(rgba(0,0,0,0)),to(rgba(0,0,0,.05)));
	background-image: -webkit-linear-gradient(rgba(0,0,0,0),rgba(0,0,0,.05));
	background-image: -moz-linear-gradient(rgba(0,0,0,0),rgba(0,0,0,.05));
	background-image: linear-gradient(rgba(0,0,0,0),rgba(0,0,0,.05));
	-webkit-tap-highlight-color: rgba(0,0,0,0);
	-webkit-box-shadow: 0 0 0 1px rgba(0,0,0,.08) inset;
	box-shadow: 0 0 0 1px rgba(0,0,0,.08) inset;
	-webkit-transition: opacity .25s ease,background-color .25s ease,color .25s ease,background .25s ease,-webkit-box-shadow .25s ease;
	-moz-transition: opacity .25s ease,background-color .25s ease,color .25s ease,background .25s ease,box-shadow .25s ease;
	transition: opacity .25s ease,background-color .25s ease,color .25s ease,background .25s ease,box-shadow .25s ease;
}

.cmsms-ui .action-button.positive {
	background-color: #5BBD72 !important;
	color: #fff;
}

.cmsms-ui .action-button.negative {
	background-color: #D95C5C !important;
	color: #fff;
}

.cmsms-ui .action-button.blue {
	background-color: #6ECFF5 !important;
	color: #fff;
}

.cmsms-ui .action-button.orange {
	background-color: #E96633 !important;
	color: #fff;
}

.cmsms-ui .action-button.social {
	color: #fff;
	font-weight: 700;
	text-transform: uppercase;
}

.cmsms-ui .action-button.google {
	background-color: #D34836;
}

.cmsms-ui .action-button.facebook {
	background-color: #3B579D;
}

.cmsms-ui .action-button.twitter {
	background-color: #4092CC;
}

.cmsms-ui .action-button.linkedin {
	background-color: #1F88BE;
}

.cmsms-ui .action-button:hover,
.cmsms-ui .action-button:active {
	background-image: none;
}

.cmsms-ui .action-button.positive:hover,
.cmsms-ui .action-button.positive:active {
	background-color: #58CB73 !important;
	color: #fff;
}

.cmsms-ui .action-button.negative:hover
.cmsms-ui .action-button.negative:active {
	background-color: #D24B4C !important;
	color: #fff;
}

.cmsms-ui .action-button.blue:hover,
.cmsms-ui .action-button.blue:active {
	background-color: #1AB8F3 !important;
	color: #fff;
}

.cmsms-ui .action-button.orange:hover,
.cmsms-ui .action-button.orange:active {
	background-color: #FF7038;
	color: #fff;
}

/* --- Tables --- */

.cmsms-ui .table {
	width: 100%;
	border-collapse: collapse;
}

.cmsms-ui .table caption {
	font-weight: bold;
	text-align: left;
	font-size: 1.25em;
}

.cmsms-ui .table thead {
	border-bottom: 1px solid rgba(0,0,0,.03);
}

.cmsms-ui .bordered-table td, .cmsms-ui .bordered-table th {
  border: 1px solid #ddd;
}

.cmsms-ui .table th,
.cmsms-ui .table tr,
.cmsms-ui.table td {
	border-collapse: collapse;
	-webkit-box-sizing: border-box;
	-moz-box-sizing: border-box;
	-ms-box-sizing: border-box;
	box-sizing: border-box;
	-webkit-transition: all .1s ease-out;
	-moz-transition: all .1s ease-out;
	transition: all .1s ease-out;
}

.cmsms-ui .table th {
	cursor: auto;
	background-color: #f2f2f2;
	text-align: left;
	color: rgba(0,0,0,.8);
	padding: .5em .7em;
	vertical-align: middle;
}

.cmsms-ui .table td {
	padding: .4em .7em;
	vertical-align: middle;
}

.cmsms-ui .table.zebra-table tr.even,
.cmsms-ui .table.zebra-table td.even {
	background-color: #f9f9f9;
}

.cmsms-ui .table tr.warning,
.cmsms-ui .table td.warning {
	background-color: #FBF6E9 !important;
	color: #7D6C00;
}

.cmsms-ui .table tr.error,
.cmsms-ui .table td.error {
	background-color: #F9F4F4;
	color: #CD2929;
}

.cmsms-ui .table tr.warning:hover,
.cmsms-ui .table td.warning:hover {
	background-color: #F3EDDC !important;
	color: #7D6C00;
}

.cmsms-ui .table tr:hover.error,
.cmsms-ui .table td:hover.error {
	background-color: #F2E8E8;
	color: #CD2929;
}

.cmsms-ui .table .tests-infotext {
	display: inline-block;
	font-size: .875em;
	line-height: 1.3;
}


/* HEADER */

.cmsms-ui .header-section {
	text-align: center;
	padding: 28px 0 25px 0;
	line-height: 1;
}

.cmsms-ui .header-section .installer-title {
	display: block;
	font-size: 1.75em;
	font-weight: 300;
}

/* CONTENT */

.cmsms-ui .installer-section {
	background: #fff;
	border-radius: 2px;
	-webkit-box-shadow: 0 0 6px rgba(0, 0, 0, .1);
	-moz-box-shadow: 0 0 6px rgba(0, 0, 0, .1);
	-o-box-shadow: 0 0 6px rgba(0, 0, 0, .1);
	box-shadow: 0 0 6px rgba(0, 0, 0, .1);
}

.cmsms-ui .existing-info li {
	margin-bottom: .3em;
	word-break: break-word;
}

/* -- Aside steps indicator --- */

.cmsms-ui .installer-steps ol {
	margin: 0;
	padding-left: 20px;
	list-style: decimal;
}

.cmsms-ui .installer-steps ol > li {
	margin-bottom: 1.2em;
}

.cmsms-ui .installer-steps ol > li:hover {
	color: #666;
}

.cmsms-ui .installer-steps {
	color: #666;
	font-size: .875em;
}

.cmsms-ui .step-title {
	margin-bottom: 0;
}

.cmsms-ui .current-step {
	color: #F79838;
}

.cmsms-ui .done-step {
	color: #7AB949;
}

.cmsms-ui .step-description {
	margin-top: 0;
	line-height: 1.3;
	font-size: .928571em;
	color: #333;
}

.cmsms-ui .current-step .step-description {
	color: #333;
}

/* --- main content section --- */

.cmsms-ui .info {
	font-size: .875em;
}

.cmsms-ui .installer-form label {
	font-size: .875em;
}

.cmsms-ui .installer-form fieldset {
	margin: 0;
	padding: 15px;
	border: 1px solid #ddd;
	border-radius: 3px;
	background-color: #fefefe;
}

.cmsms-ui .installer-form .corner .icon-asterisk {
	margin-left: 12px;
}

.cmsms-ui .installer-content-section h1 {
	font-size: 1.5em;
}

.cmsms-ui .installer-test-legend {
	margin-top: 25px;
}

.cmsms-ui .installer-test-legend th {
	background-color: #f2f2f2 !important;
}

.cmsms-ui .table.installer-test-information {
	font-size: .875em;
}

#bottom_nav {
    display: none;
}

/* FOOTER */
.cmsms-ui .footer-section {
	text-align: center;
	padding: 10px 0 15px 0;
}

.cmsms-ui .footer-info a {
	font-size: .875em;
	color: #666;
	font-weight: 700;
}

.cmsms-ui .footer-section small {
	display: block;
}
|
                         LP                       T_                   c m s m s - u i    R e g u l a r    V e r s i o n   1 . 0    c m s m s - u i            0OS/2"      `cmapUc     Lgasp     h   glyfR`Kh  p  	head  
   6hhea  
   $hmtx    
   Dloca0  ,   $maxp    P    name  p  Bpost              Lf   GLf                                    @                                     8   
                                         79               79               79           
  %!33```@@@    @@      1 ?  !512#!".67>34>32#".572#'4>3 X	
N
	 				 	
,
	qO	L								``	         $  "32>54.#3#5#535#533 5]F((F]55]F((F]5 @@`  ` (F]55]F((F]55]F(`@@           %  "32>54.##'#57'5373 5]F((F]55]F((F]5SS-SS-SS-SS-(F]55]F((F]55]F(SS-SS-SS-SS-        "32>54.#'77 5]F((F]55]F((F]50j/;(F]55]F((F]55]F(`1K      	    %#375'#535#53 P@@@@pp`@@      3  .#">3235".'7#732>7'#).2)K?/<
$/8&"
HK&"
HK).2)K?/<
$/8
,=$-"
HK
HK
,=$-"         	    %
%%'7%77%7      3  33  3@VVVVVgg               # ' 4 9  3#73#73#3#73#73#'3#73#73#%3##5##5#!#!!@@`@@`@@@@`@@`@@`@@`@@`@@@@`@@@@ ` @@@@@@@@@@@@@@@@@`       `        
  h     704044017>'.#&%54.'&>665'>5''5'57577667.54>7"&.'>0&<#21.'."&&7<645<.5 v!!

<;+(8
` `` `]		

[

 	-&(''*	# 



a__a 		"d	<!

		      1  !"3!2>'.###7#737&>;#"3 W 	Ta/-(YG	_


V
 I0&O(I         !"3!2>'.##".'2:32>7.'22326263.'2&2"33.7&>7&6&6'>32>7>7 W  <Z9!"



	&-0


	


V
*WF-
			





        2 O  !"3!2>54.##53".54>32##54.#"#53>32T@@ 				 @		@@T` 				 		(
        .m_<      lI    lI                                                                                                  
   8  4V. l                                                 N        &        \                6      
 ( l  	      	   N  	   &  	   \  	     	   >  	 
 ( l c m s m s - u i V e r s i o n   1 . 0 c m s m s - u icmsms-ui c m s m s - u i R e g u l a r c m s m s - u i G e n e r a t e d   b y   I c o M o o n                                 <?xml version="1.0" standalone="no"?>
<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd" >
<svg xmlns="http://www.w3.org/2000/svg">
<metadata>Generated by IcoMoon</metadata>
<defs>
<font id="cmsms-ui" horiz-adv-x="512">
<font-face units-per-em="512" ascent="480" descent="-32" />
<missing-glyph horiz-adv-x="512" />
<glyph unicode="&#x20;" d="" horiz-adv-x="256" />
<glyph unicode="&#xe600;" d="M416 0l96 256h-416l-96-256zM64 288l-64-288v416h144l64-64h208v-64z" />
<glyph unicode="&#xe601;" d="M256 400.638l-172.417-368.638h344.834l-172.417 368.638zM256 480v0c11.035 0 22.070-7.441 30.442-22.324l218.536-435.556c16.745-29.766 2.5-54.12-31.651-54.12h-434.654c-34.152 0-48.395 24.354-31.652 54.12l218.537 435.556c8.372 14.883 19.407 22.324 30.442 22.324zM224 96c0 17.673 14.327 32 32 32s32-14.327 32-32c0-17.673-14.327-32-32-32-17.673 0-32 14.327-32 32zM256 288c17.673 0 32-14.327 32-32l-10-96h-44l-10 96c0 17.673 14.327 32 32 32z" />
<glyph unicode="&#xe602;" d="M256 480c-141.385 0-256-114.615-256-256s114.615-256 256-256 256 114.615 256 256-114.615 256-256 256zM224 384h64v-64h-64v64zM320 64h-128v32h32v128h-32v32h96v-160h32v-32z" />
<glyph unicode="&#xe603;" d="M256 480c-141.385 0-256-114.615-256-256s114.615-256 256-256 256 114.615 256 256-114.615 256-256 256zM384 306.745l-82.744-82.745 82.744-82.744v-45.256h-45.256l-82.744 82.744-82.745-82.744h-45.255v45.256l82.745 82.744-82.745 82.745v45.255h45.255l82.745-82.745 82.744 82.745h45.256v-45.255z" />
<glyph unicode="&#xe604;" d="M256 480c-141.385 0-256-114.615-256-256s114.615-256 256-256 256 114.615 256 256-114.615 256-256 256zM208 64l-106 138 47 49 59-75 185 151 23-23-208-240z" />
<glyph unicode="&#xe605;" d="M512 112l-144 368h-224l-144-144v-224l144-144h224l144 144v224l-144 144zM288 64h-64v64h64v-64zM288 192h-64v192h64v-192z" />
<glyph unicode="&#xe606;" d="M437.011 405.010c-46.326 46.328-110.318 74.99-181.011 74.99-109.744 0-203.345-69.064-239.749-166.094l59.938-22.477c27.302 72.773 97.503 124.571 179.811 124.571 53.020 0 101.010-21.5 135.753-56.247l-71.753-71.753h192v192l-74.989-74.99zM256 32c-53.020 0-101.013 21.496-135.756 56.244l71.756 71.756h-192v-192l74.997 74.997c46.323-46.331 110.309-74.997 181.003-74.997 109.745 0 203.346 69.064 239.75 166.094l-59.938 22.477c-27.302-72.773-97.503-124.571-179.812-124.571z" />
<glyph unicode="&#xe607;" d="M512 320l-256 128-256-128 256-128 256 128zM256 405.515l171.029-85.515-171.029-85.515-171.029 85.515 171.029 85.515zM460.722 249.639l51.278-25.639-256-128-256 128 51.278 25.639 204.722-102.361zM460.722 153.639l51.278-25.639-256-128-256 128 51.278 25.639 204.722-102.361z" />
<glyph unicode="&#xe608;" d="M160 288h64v-64h-64zM256 288h64v-64h-64zM352 288h64v-64h-64zM64 96h64v-64h-64zM160 96h64v-64h-64zM256 96h64v-64h-64zM160 192h64v-64h-64zM256 192h64v-64h-64zM352 192h64v-64h-64zM64 192h64v-64h-64zM416 480v-32h-64v32h-224v-32h-64v32h-64v-512h480v512h-64zM448 0h-416v352h416v-352z" />
<glyph unicode="&#xe609;" d="M0.403 45.168c-0.122 1.266-0.226 2.535-0.292 3.815 0.065-1.28 0.17-2.549 0.292-3.815zM117.954 197.426c46.005-1.369 76.867 46.349 68.931 106.599-7.947 60.24-51.698 108.584-97.704 109.961-46.013 1.365-76.87-44.741-68.926-105 7.941-60.234 51.676-110.187 97.699-111.56zM512 352v42.655c0 46.94-38.391 85.345-85.329 85.345h-341.328c-46.138 0-84.006-37.116-85.282-82.963 29.181 25.693 69.662 47.158 111.437 47.158 44.652 0 178.622 0 178.622 0l-39.974-33.809h-56.634c37.565-14.402 57.578-58.062 57.578-102.861 0-37.624-20.905-69.977-50.444-92.984-28.822-22.451-34.286-31.854-34.286-50.939 0-16.289 30.873-44 47.016-55.394 47.191-33.269 62.458-64.156 62.458-115.728 0-8.214-1.021-16.415-3.033-24.48h153.871c46.937 0 85.328 38.375 85.328 85.345v266.654h-96v-95.999h-32v96h-95.999v32h95.999v96h32v-96h96zM92.943 97.032c10.807 0 20.711 0.295 30.968 0.295-13.573 13.167-24.313 29.3-24.313 49.19 0 11.804 3.782 23.168 9.067 33.26-5.391-0.385-10.895-0.497-16.563-0.497-37.178 0-68.753 12.038-92.102 31.927v-33.621l0.003-100.865c26.72 12.687 58.444 20.311 92.94 20.311zM1.71 36.371c-0.556 2.729-0.983 5.503-1.271 8.317 0.287-2.814 0.715-5.588 1.271-8.317zM227.725 3.577c-7.529 29.403-34.227 43.982-71.444 69.784-13.536 4.366-28.447 6.937-44.447 7.104-44.809 0.482-86.554-17.471-110.108-44.186 7.96-38.853 42.517-68.279 83.617-68.279h143.222c0.908 5.564 1.348 11.316 1.348 17.216 0 6.267-0.767 12.396-2.188 18.361z" />
<glyph unicode="&#xe60a;" d="M426.672 480h-341.33c-46.936 0-85.342-38.407-85.342-85.344v-341.313c0-46.969 38.406-85.343 85.342-85.343l341.33 0.001c46.938 0 85.328 38.373 85.328 85.344v341.311c0 46.937-38.391 85.344-85.328 85.344zM435.296 224h-83.296v-224h-96v224h-46.263v73.282h46.263v47.593c0 64.671 27.896 103.125 103.935 103.125h87.622v-79.285h-71.565c-21.241 0.035-23.876-11.076-23.876-31.756l-0.116-39.677h96l-12.704-73.282z" />
<glyph unicode="&#xe60b;" d="M426.671 480h-341.328c-46.937 0-85.343-38.405-85.343-85.345v-341.311c0-46.969 38.406-85.344 85.343-85.344h341.328c46.938 0 85.329 38.375 85.329 85.345v341.31c0 46.94-38.391 85.345-85.329 85.345zM419.026 309.083c0.164-3.671 0.245-7.364 0.245-11.074 0-113.107-84.608-243.534-239.329-243.534-47.502 0-91.717 14.174-128.943 38.459 6.58-0.794 13.276-1.197 20.065-1.197 39.411 0 75.679 13.685 104.467 36.641-36.808 0.69-67.872 25.438-78.577 59.441 5.137-1 10.406-1.537 15.826-1.537 7.672 0 15.103 1.048 22.16 3.004-38.48 7.866-67.475 42.458-67.475 83.928 0 0.361 0 0.719 0.008 1.076 11.34-6.41 24.312-10.26 38.1-10.705-22.571 15.349-37.421 41.546-37.421 71.244 0 15.685 4.147 30.389 11.389 43.029 41.487-51.785 103.468-85.86 173.377-89.431-1.435 6.266-2.179 12.798-2.179 19.507 0 47.269 37.663 85.59 84.115 85.59 24.195 0 46.059-10.393 61.401-27.029 19.16 3.838 37.162 10.96 53.416 20.771-6.281-19.988-19.617-36.761-36.983-47.355 17.013 2.069 33.226 6.67 48.31 13.477-11.273-17.162-25.535-32.238-41.972-44.305z" />
<glyph unicode="&#xe60c;" d="M426 480h-340c-47.3 0-86-38.7-86-86v-340c0-47.3 38.7-86 86-86h340c47.3 0 86 38.7 86 86v340c0 47.3-38.7 86-86 86zM192 64h-64v224h64v-224zM160 320c-17.673 0-32 14.327-32 32s14.327 32 32 32 32-14.327 32-32-14.327-32-32-32zM416 64h-64v128c0 17.673-14.327 32-32 32s-32-14.327-32-32v-128h-64v224h64v-39.736c13.199 18.132 33.376 39.736 56 39.736 39.765 0 72-35.817 72-80v-144z" />
</font></defs></svg>       0OS/2"      `cmapUc     Lgasp     h   glyfR`Kh  p  	head  
   6hhea  
   $hmtx    
   Dloca0  ,   $maxp    P    name  p  Bpost              Lf   GLf                                    @                                     8   
                                         79               79               79           
  %!33```@@@    @@      1 ?  !512#!".67>34>32#".572#'4>3 X	
N
	 				 	
,
	qO	L								``	         $  "32>54.#3#5#535#533 5]F((F]55]F((F]5 @@`  ` (F]55]F((F]55]F(`@@           %  "32>54.##'#57'5373 5]F((F]55]F((F]5SS-SS-SS-SS-(F]55]F((F]55]F(SS-SS-SS-SS-        "32>54.#'77 5]F((F]55]F((F]50j/;(F]55]F((F]55]F(`1K      	    %#375'#535#53 P@@@@pp`@@      3  .#">3235".'7#732>7'#).2)K?/<
$/8&"
HK&"
HK).2)K?/<
$/8
,=$-"
HK
HK
,=$-"         	    %
%%'7%77%7      3  33  3@VVVVVgg               # ' 4 9  3#73#73#3#73#73#'3#73#73#%3##5##5#!#!!@@`@@`@@@@`@@`@@`@@`@@`@@@@`@@@@ ` @@@@@@@@@@@@@@@@@`       `        
  h     704044017>'.#&%54.'&>665'>5''5'57577667.54>7"&.'>0&<#21.'."&&7<645<.5 v!!

<;+(8
` `` `]		

[

 	-&(''*	# 



a__a 		"d	<!

		      1  !"3!2>'.###7#737&>;#"3 W 	Ta/-(YG	_


V
 I0&O(I         !"3!2>'.##".'2:32>7.'22326263.'2&2"33.7&>7&6&6'>32>7>7 W  <Z9!"



	&-0


	


V
*WF-
			





        2 O  !"3!2>54.##53".54>32##54.#"#53>32T@@ 				 @		@@T` 				 		(
        .m_<      lI    lI                                                                                                  
   8  4V. l                                                 N        &        \                6      
 ( l  	      	   N  	   &  	   \  	     	   >  	 
 ( l c m s m s - u i V e r s i o n   1 . 0 c m s m s - u icmsms-ui c m s m s - u i R e g u l a r c m s m s - u i G e n e r a t e d   b y   I c o M o o n                                 wOFFOTTO  
 
    
T                       CFF        SOS/2     `   `"cmap  <   L   LUcgasp           head     6   6hhea     $   $hmtx     D   D  maxp  	0       P name  	8  B  Bpost  
|             	cmsms-ui   :
 S
 Skt         	   	"',16;@EJOTYcmsms-uicmsms-uiu0u1u20uE600uE601uE602uE603uE604uE605uE606uE607uE608uE609uE60AuE60BuE60C        
 
 1  U;*=\44+K4$KdK%@@|oHm|siFi|oHk}yy}}yy}T}y+_t!!!!!!!!k+ˋKKk닋4kt!!!!!!!!A888^^888^8ދ8޸^t!!!!!!!![4!@M+td$t$$t$$t$$t$$;4KˋKKTˋTI)]KD.Ff*tҿ݋vhCCTT@@I	V[hTT]nҋаOpBDW9?5?5??a0qa$aqa$4ˋKKˋKKˋKKˋKKˋKKˋKK+4ˋKKˋKKˋKKˋKKkKtkKKtKt44
,ǃ_]]l]OOY/e\]ef]ciS}__evkntntxzpjlW.++k+닋뫋+7}fktj&0Nvkpf~|{^aytpdn$?t\ee\\ee\8t+t]Թ̧׋㋋<Cvvc~B?t\ee\\ee\?7/[_ffldnt|Wiчzw~{zz||{>t\dd\\dd\~4Ktˋtky}}yy}}yK}yy}}yKtˋcg_$
       Lf   GLf                                    @                                     8   
                                   _T_<      lI    lI                                                                                               P                         N        &        \                6      
 ( l  	      	   N  	   &  	   \  	     	   >  	 
 ( l c m s m s - u i V e r s i o n   1 . 0 c m s m s - u icmsms-ui c m s m s - u i R e g u l a r c m s m s - u i G e n e r a t e d   b y   I c o M o o n                                 {
	"IcoMoonType": "selection",
	"icons": [
		{
			"icon": {
				"paths": [
					"M512 0c-282.77 0-512 229.23-512 512s229.23 512 512 512 512-229.23 512-512-229.23-512-512-512zM416 832l-212-276 94-98 118 150 370-302 46 46-416 480z"
				],
				"tags": [
					"checkmark-circle",
					"tick",
					"correct"
				],
				"grid": 16
			},
			"properties": {
				"id": 251,
				"order": 1,
				"prevSize": 32,
				"code": 58884,
				"name": "checkmark-circle",
				"ligatures": ""
			},
			"setIdx": 0,
			"iconIdx": 251
		},
		{
			"icon": {
				"paths": [
					"M512 0c-282.77 0-512 229.23-512 512s229.23 512 512 512 512-229.23 512-512-229.23-512-512-512zM768 346.51l-165.488 165.49 165.488 165.488v90.512h-90.512l-165.488-165.488-165.49 165.488h-90.51v-90.512l165.49-165.488-165.49-165.49v-90.51h90.51l165.49 165.49 165.488-165.49h90.512v90.51z"
				],
				"tags": [
					"cancel-circle",
					"close",
					"remove",
					"delete"
				],
				"grid": 16
			},
			"properties": {
				"id": 250,
				"order": 2,
				"prevSize": 32,
				"code": 58883,
				"name": "cancel-circle",
				"ligatures": ""
			},
			"setIdx": 0,
			"iconIdx": 250
		},
		{
			"icon": {
				"paths": [
					"M1024 736 736 0h-448l-288 288v448l288 288h448l288-288v-448l-288-288zM576 832h-128v-128h128v128zM576 576h-128v-384h128v384z"
				],
				"tags": [
					"spam",
					"notice",
					"notification",
					"exclamation"
				],
				"grid": 16
			},
			"properties": {
				"id": 252,
				"order": 3,
				"prevSize": 32,
				"code": 58885,
				"name": "spam",
				"ligatures": ""
			},
			"setIdx": 0,
			"iconIdx": 252
		},
		{
			"icon": {
				"paths": [
					"M832 960l192-512h-832l-192 512zM128 384l-128 576v-832h288l128 128h416v128z"
				],
				"tags": [
					"folder-open",
					"directory",
					"category",
					"browse"
				],
				"grid": 16
			},
			"properties": {
				"id": 47,
				"order": 4,
				"prevSize": 32,
				"code": 58880,
				"name": "folder-open",
				"ligatures": ""
			},
			"setIdx": 0,
			"iconIdx": 47
		},
		{
			"icon": {
				"paths": [
					"M512 0c-282.77 0-512 229.23-512 512s229.23 512 512 512 512-229.23 512-512-229.23-512-512-512zM448 192h128v128h-128v-128zM640 832h-256v-64h64v-256h-64v-64h192v320h64v64z"
				],
				"tags": [
					"info",
					"information"
				],
				"grid": 16
			},
			"properties": {
				"id": 248,
				"order": 5,
				"prevSize": 32,
				"code": 58882,
				"name": "info",
				"ligatures": ""
			},
			"setIdx": 0,
			"iconIdx": 248
		},
		{
			"icon": {
				"paths": [
					"M512 158.724l-344.834 737.276h689.668l-344.834-737.276zM512 0v0c22.070 0 44.14 14.882 60.884 44.648l437.072 871.112c33.49 59.532 5 108.24-63.302 108.24h-869.308c-68.304 0-96.79-48.708-63.304-108.24l437.074-871.112c16.744-29.766 38.814-44.648 60.884-44.648zM448 768c0-35.346 28.654-64 64-64s64 28.654 64 64c0 35.346-28.654 64-64 64-35.346 0-64-28.654-64-64zM512 384c35.346 0 64 28.654 64 64l-20 192h-88l-20-192c0-35.346 28.654-64 64-64z"
				],
				"tags": [
					"warning",
					"sign"
				],
				"grid": 16
			},
			"properties": {
				"id": 244,
				"order": 6,
				"prevSize": 32,
				"code": 58881,
				"name": "warning",
				"ligatures": ""
			},
			"setIdx": 0,
			"iconIdx": 244
		},
		{
			"icon": {
				"paths": [
					"M874.022 149.98c-92.652-92.656-220.636-149.98-362.022-149.98-219.488 0-406.69 138.128-479.498 332.188l119.876 44.954c54.604-145.546 195.006-249.142 359.622-249.142 106.040 0 202.020 43 271.506 112.494l-143.506 143.506h384v-384l-149.978 149.98zM512 896c-106.040 0-202.026-42.992-271.512-112.488l143.512-143.512h-384v384l149.994-149.994c92.646 92.662 220.618 149.994 362.006 149.994 219.49 0 406.692-138.128 479.5-332.188l-119.876-44.954c-54.604 145.546-195.006 249.142-359.624 249.142z"
				],
				"tags": [
					"loop",
					"repeat",
					"reload",
					"refresh",
					"update",
					"upgrade",
					"synchronize",
					"media control",
					"arrows"
				],
				"grid": 16
			},
			"properties": {
				"id": 284,
				"order": 7,
				"prevSize": 32,
				"code": 58886,
				"name": "loop",
				"ligatures": ""
			},
			"setIdx": 0,
			"iconIdx": 284
		},
		{
			"icon": {
				"paths": [
					"M1024 320l-512-256-512 256 512 256 512-256zM512 148.97l342.058 171.030-342.058 171.030-342.058-171.030 342.058-171.030zM921.444 460.722l102.556 51.278-512 256-512-256 102.556-51.278 409.444 204.722zM921.444 652.722l102.556 51.278-512 256-512-256 102.556-51.278 409.444 204.722z"
				],
				"tags": [
					"stack",
					"layers"
				],
				"grid": 16
			},
			"properties": {
				"id": 45,
				"order": 8,
				"prevSize": 32,
				"code": 58887,
				"name": "stack",
				"ligatures": ""
			},
			"setIdx": 0,
			"iconIdx": 45
		},
		{
			"icon": {
				"paths": [
					"M320 384h128v128h-128zM512 384h128v128h-128zM704 384h128v128h-128zM128 768h128v128h-128zM320 768h128v128h-128zM512 768h128v128h-128zM320 576h128v128h-128zM512 576h128v128h-128zM704 576h128v128h-128zM128 576h128v128h-128zM832 0v64h-128v-64h-448v64h-128v-64h-128v1024h960v-1024h-128zM896 960h-832v-704h832v704z"
				],
				"tags": [
					"calendar",
					"schedule",
					"date",
					"time",
					"day"
				],
				"grid": 16
			},
			"properties": {
				"id": 78,
				"order": 9,
				"prevSize": 32,
				"code": 58888,
				"name": "calendar",
				"ligatures": ""
			},
			"setIdx": 0,
			"iconIdx": 78
		},
		{
			"icon": {
				"paths": [
					"M852 0h-680c-94.6 0-172 77.4-172 172v680c0 94.6 77.4 172 172 172h680c94.6 0 172-77.4 172-172v-680c0-94.6-77.4-172-172-172zM384 832h-128v-448h128v448zM320 320c-35.346 0-64-28.654-64-64s28.654-64 64-64 64 28.654 64 64-28.654 64-64 64zM832 832h-128v-256c0-35.346-28.654-64-64-64s-64 28.654-64 64v256h-128v-448h128v79.472c26.398-36.264 66.752-79.472 112-79.472 79.53 0 144 71.634 144 160v288z"
				],
				"tags": [
					"linkedin",
					"social"
				],
				"grid": 16
			},
			"properties": {
				"id": 415,
				"order": 10,
				"prevSize": 32,
				"code": 58892,
				"name": "linkedin",
				"ligatures": ""
			},
			"setIdx": 0,
			"iconIdx": 415
		},
		{
			"icon": {
				"paths": [
					"M853.344 0h-682.66c-93.872 0-170.684 76.814-170.684 170.688v682.626c0 93.938 76.812 170.686 170.684 170.686l682.66-0.002c93.876 0 170.656-76.746 170.656-170.688v-682.622c0-93.874-76.782-170.688-170.656-170.688zM870.592 512h-166.592v448h-192v-448h-92.526v-146.564h92.526v-95.186c0-129.342 55.792-206.25 207.87-206.25h175.244v158.57h-143.13c-42.482-0.070-47.752 22.152-47.752 63.512l-0.232 79.354h192l-25.408 146.564z"
				],
				"tags": [
					"facebook",
					"social"
				],
				"grid": 16
			},
			"properties": {
				"id": 362,
				"order": 11,
				"prevSize": 32,
				"code": 58890,
				"name": "facebook",
				"ligatures": ""
			},
			"setIdx": 0,
			"iconIdx": 362
		},
		{
			"icon": {
				"paths": [
					"M853.342 0h-682.656c-93.874 0-170.686 76.81-170.686 170.69v682.622c0 93.938 76.812 170.688 170.686 170.688h682.656c93.876 0 170.658-76.75 170.658-170.69v-682.62c0-93.88-76.782-170.69-170.658-170.69zM838.052 341.834c0.328 7.342 0.49 14.728 0.49 22.148 0 226.214-169.216 487.068-478.658 487.068-95.004 0-183.434-28.348-257.886-76.918 13.16 1.588 26.552 2.394 40.13 2.394 78.822 0 151.358-27.37 208.934-73.282-73.616-1.38-135.744-50.876-157.154-118.882 10.274 2 20.812 3.074 31.652 3.074 15.344 0 30.206-2.096 44.32-6.008-76.96-15.732-134.95-84.916-134.95-167.856 0-0.722 0-1.438 0.016-2.152 22.68 12.82 48.624 20.52 76.2 21.41-45.142-30.698-74.842-83.092-74.842-142.488 0-31.37 8.294-60.778 22.778-86.058 82.974 103.57 206.936 171.72 346.754 178.862-2.87-12.532-4.358-25.596-4.358-39.014 0-94.538 75.326-171.18 168.23-171.18 48.39 0 92.118 20.786 122.802 54.058 38.32-7.676 74.324-21.92 106.832-41.542-12.562 39.976-39.234 73.522-73.966 94.71 34.026-4.138 66.452-13.34 96.62-26.954-22.546 34.324-51.070 64.476-83.944 88.61z"
				],
				"tags": [
					"twitter",
					"tweet",
					"social"
				],
				"grid": 16
			},
			"properties": {
				"id": 366,
				"order": 12,
				"prevSize": 32,
				"code": 58891,
				"name": "twitter",
				"ligatures": ""
			},
			"setIdx": 0,
			"iconIdx": 366
		},
		{
			"icon": {
				"paths": [
					"M0.806 869.664c-0.244-2.532-0.452-5.070-0.584-7.63 0.13 2.56 0.34 5.098 0.584 7.63zM235.908 565.148c92.010 2.738 153.734-92.698 137.862-213.198-15.894-120.48-103.396-217.168-195.408-219.922-92.026-2.73-153.74 89.482-137.852 210 15.882 120.468 103.352 220.374 195.398 223.12zM1024 256v-85.31c0-93.88-76.782-170.69-170.658-170.69h-682.656c-92.276 0-168.012 74.232-170.564 165.926 58.362-51.386 139.324-94.316 222.874-94.316 89.304 0 357.244 0 357.244 0l-79.948 67.618h-113.268c75.13 28.804 115.156 116.124 115.156 205.722 0 75.248-41.81 139.954-100.888 185.968-57.644 44.902-68.572 63.708-68.572 101.878 0 32.578 61.746 88 94.032 110.788 94.382 66.538 124.916 128.312 124.916 231.456 0 16.428-2.042 32.83-6.066 48.96h307.742c93.874 0 170.656-76.75 170.656-170.69v-533.308h-192v191.998h-64v-192h-191.998v-64h191.998v-192h64v192h192zM185.886 765.936c21.614 0 41.422-0.59 61.936-0.59-27.146-26.334-48.626-58.6-48.626-98.38 0-23.608 7.564-46.336 18.134-66.52-10.782 0.77-21.79 0.994-33.126 0.994-74.356 0-137.506-24.076-184.204-63.854v67.242l0.006 201.73c53.44-25.374 116.888-40.622 185.88-40.622zM3.42 887.258c-1.112-5.458-1.966-11.006-2.542-16.634 0.574 5.628 1.43 11.176 2.542 16.634zM455.45 952.846c-15.058-58.806-68.454-87.964-142.888-139.568-27.072-8.732-56.894-13.874-88.894-14.208-89.618-0.964-173.108 34.942-220.216 88.372 15.92 77.706 85.034 136.558 167.234 136.558h286.444c1.816-11.128 2.696-22.632 2.696-34.432 0-12.534-1.534-24.792-4.376-36.722z"
				],
				"tags": [
					"google plus",
					"social"
				],
				"grid": 16
			},
			"properties": {
				"id": 358,
				"order": 13,
				"prevSize": 32,
				"code": 58889,
				"name": "googleplus",
				"ligatures": ""
			},
			"setIdx": 0,
			"iconIdx": 358
		}
	],
	"height": 1024,
	"metadata": {
		"name": "cmsms-ui"
	},
	"preferences": {
		"showGlyphs": true,
		"showQuickUse": true,
		"fontPref": {
			"prefix": "icon-",
			"metadata": {
				"fontFamily": "cmsms-ui",
				"majorVersion": 1,
				"minorVersion": 0
			},
			"metrics": {
				"emSize": 512,
				"baseline": 6.25,
				"whitespace": 50
			},
			"embed": true,
			"showVersion": true,
			"showMetadata": true,
			"showMetrics": true,
			"resetPoint": 58880
		},
		"imagePref": {},
		"historySize": 100,
		"showCodes": true,
		"search": "",
		"gridSize": 16
	}
}PNG

   
IHDR  L   M   E]N   tEXtSoftware Adobe ImageReadyqe<  IDATxOlWǟ')R́ro
*z}q*$RE"	'.TYz y6Q	q薞/C6JƿqǓ7߼Y_i̛7g~{O           PSH/4GҼX9܏2@Ay 9+?9T$My%@c,ʖ$vyE  <Z#YW%8Hy0(ccDTsE  sae2\&|Fi("`v$80
4s#UIđ|{wŃ %4Ü7^-)ֵPGCBP$?:{q2zKm<Pf l2,$H=,ıO6-ox邡°%9B:?3ԢK=K/PMGǊ<;V`@ 
	/|Ym\	=ߎzbZhCsIO]`2PXa`92ܣڝ(Nkܿ
A]8],t s`9)iaZgY6d=*.7o216&KNk`8%-F:F;w>	Ym(fUIM2kAtu7t'՗4EGvAoѽ7_N`ߐUB
,|45LDE9ԯwguJҀ
A3;=wy[O^c鏩,C9z0tkpj1UIEO4I¼&c.<Q(B2뺚`{Xq
=Tȼg3qkΏ9~}ս4lS	{o4'hAhº|_1@jQȐ>s?;]MY:fQY7\nUQnr/ru&)|q^ʤ'|.ݟiIE4
d
skL@eRdLX3tI䋵*g3#fM-,ĮAͩ/>N'H&OZ3.KX{#72$)L->W.*?EےCܤ\3t9?glYg"C>RtcJwO'qAx ʘ-+?Ea[/el6Mq,o=KPҠ
 =SR̜]NΣl4MR|mZ\;e|
xp8kf.(=g9op/scyXS=0Uί/Y}q-V7F8`:MSE*KftP"Z٧p嬋R`X|5Kk0fHYdeQDq[,]fܺs벡ftFI34?=|Ŝsh%ئiXua*7-ǀxp>6iS4fX5#fpgϟ`fmh*Pxo)'@>~X_*#S#?]
ia@%{W+尨LE'@D
LZ5܇gţǇ5	0m2>GW#s5U_K	Kÿ*.iA
NIH+Ftvd궨VC}SR=.jzZ, 3UzIKbᬜ.C>:{m4W
-LWY#%>[UHnDyRx;woB\3*uP,:+$E)K[ܒ鞝#N4/&l,o/ 0GF03*x
ڰ4oAADkyk3',܏nVV`F]YՇ Y*%ۨIN˜gO~nwm	
\T8`#zS<Qפ&/~DʹY3g`K _\~CV{`n3`檰XL 3!YS?h>n׼ $v!>/	 3cE߬+`,-
IUb:Y+Lsh᎝>"@SiZ4 rӨ K>zN|yLBb_0թɭ'G,02yy(>9|+U
n[`_έ:n<[T,MJI`Z5K^?"x[d ̜Vtg-Hr+`m;j
֩SnBE䦕5+UG
3{0i-Bf#f\Y<i$SW~4Ҧjk V]f䜞,!:d	`z){>&Mtv 4,,+r"rk
Rv/2ɮtҴZ`8mfqSm5!GG0iƏ2Rtvor	Pcp=407Xe+aSc]6+Rg>0ɊE5.Ö8;{d	<tնEXRQxU:E5E+T̤7``<|#[pz_OE5lE&wGiuL)aM]l&)	Mϲ54QJT*^'hOE)EJkQQIӸsP	X Boڔwˈt>Gi- ! z
´K,˗^.Fm-}Ǔ}~  3
6.! jZ)Oe֡!j2S<ql.r6 Lh"5Qek+&mN@46fzX婢UV9,qibsTǺd؜MgXYN0ůYN@Kh4%kAM֬,i'jUV'u==!<i>Ue&Q]$DtKĲym\,87D9?UaG6d]x^EJ+kfB=|8TBm.Kjiͭ+🕤+k2|J&m.**cUf$f_C{2]}Jka
|}`eF,{'V]H [k\Z/ޛ/DY!Bvԁ,-[NW6-7gK+@c-kAŀQf$\n+VD@*>{yA܂`Ky*H4N7w]\-i]`^(K(QnzfE4{ԕ1cM7Cs!9v^jTw^ 4]3=Nxh	D	rt#צ#=HKÒ$YGyBT*U?@=rRA5˰#3C.1	˪Y#/t
&E|-AC؝LxED˸9Z	D0#׾	o0/J˲ѷoPW5-ټj(xK&8)kba,r^3^0-MW4Bi"?\Ig¶3g56<yU>e"5A5% gI`RAH{]Bn҅I;w-ouh  s@h[B	M44	^ qiQ4C.A9NʃV](E8
$App&A1j*W`UB9fl9f!AY8imXA1PB9IlϦQsw
.J}p x&7~/AAAAAAAAAA W    IENDB`         h     (                                                 I/jVIIXoL)                        8D<888888?F                8L8888888888R            R88Fq}V88Y    =.<8{>H'Z88McO88L>UB8888l{nK88HB888Qh88888HM8J8D888TW8V888d<58ga88=F+    L8vu?88R        8
H8BB8lE8L8            8
B8888sL:D8                        87XLA=HW81                                                        if(typeof Object.create!=="function"){Object.create=function(e){function t(){}t.prototype=e;return new t}}var ua={toString:function(){return navigator.userAgent},test:function(e){return this.toString().toLowerCase().indexOf(e.toLowerCase())>-1}};ua.version=(ua.toString().toLowerCase().match(/[\s\S]+(?:rv|it|ra|ie)[\/: ]([\d.]+)/)||[])[1];ua.webkit=ua.test("webkit");ua.gecko=ua.test("gecko")&&!ua.webkit;ua.opera=ua.test("opera");ua.ie=ua.test("msie")&&!ua.opera;ua.ie6=ua.ie&&document.compatMode&&typeof document.documentElement.style.maxHeight==="undefined";ua.ie7=ua.ie&&document.documentElement&&typeof document.documentElement.style.maxHeight!=="undefined"&&typeof XDomainRequest==="undefined";ua.ie8=ua.ie&&typeof XDomainRequest!=="undefined";var domReady=function(){var e=[];var t=function(){if(!arguments.callee.done){arguments.callee.done=true;for(var t=0;t<e.length;t++){e[t]()}}};if(document.addEventListener){document.addEventListener("DOMContentLoaded",t,false)}if(ua.ie){(function(){try{document.documentElement.doScroll("left")}catch(e){setTimeout(arguments.callee,50);return}t()})();document.onreadystatechange=function(){if(document.readyState==="complete"){document.onreadystatechange=null;t()}}}if(ua.webkit&&document.readyState){(function(){if(document.readyState!=="loading"){t()}else{setTimeout(arguments.callee,10)}})()}window.onload=t;return function(t){if(typeof t==="function"){e[e.length]=t}return t}}();var cssHelper=function(){var e={BLOCKS:/[^\s{;][^{;]*\{(?:[^{}]*\{[^{}]*\}[^{}]*|[^{}]*)*\}/g,BLOCKS_INSIDE:/[^\s{][^{]*\{[^{}]*\}/g,DECLARATIONS:/[a-zA-Z\-]+[^;]*:[^;]+;/g,RELATIVE_URLS:/url\(['"]?([^\/\)'"][^:\)'"]+)['"]?\)/g,REDUNDANT_COMPONENTS:/(?:\/\*([^*\\\\]|\*(?!\/))+\*\/|@import[^;]+;)/g,REDUNDANT_WHITESPACE:/\s*(,|:|;|\{|\})\s*/g,WHITESPACE_IN_PARENTHESES:/\(\s*(\S*)\s*\)/g,MORE_WHITESPACE:/\s{2,}/g,FINAL_SEMICOLONS:/;\}/g,NOT_WHITESPACE:/\S+/g};var t,n=false;var r=[];var s=function(e){if(typeof e==="function"){r[r.length]=e}};var o=function(){for(var e=0;e<r.length;e++){r[e](t)}};var u={};var a=function(e,t){if(u[e]){var n=u[e].listeners;if(n){for(var r=0;r<n.length;r++){n[r](t)}}}};var f=function(e,t,n){if(ua.ie&&!window.XMLHttpRequest){window.XMLHttpRequest=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}if(!XMLHttpRequest){return""}var r=new XMLHttpRequest;try{r.open("get",e,true);r.setRequestHeader("X_REQUESTED_WITH","XMLHttpRequest")}catch(i){n();return}var s=false;setTimeout(function(){s=true},5e3);document.documentElement.style.cursor="progress";r.onreadystatechange=function(){if(r.readyState===4&&!s){if(!r.status&&location.protocol==="file:"||r.status>=200&&r.status<300||r.status===304||navigator.userAgent.indexOf("Safari")>-1&&typeof r.status==="undefined"){t(r.responseText)}else{n()}document.documentElement.style.cursor="";r=null}};r.send("")};var l=function(t){t=t.replace(e.REDUNDANT_COMPONENTS,"");t=t.replace(e.REDUNDANT_WHITESPACE,"$1");t=t.replace(e.WHITESPACE_IN_PARENTHESES,"($1)");t=t.replace(e.MORE_WHITESPACE," ");t=t.replace(e.FINAL_SEMICOLONS,"}");return t};var c={stylesheet:function(t){var n={};var r=[],i=[],s=[],o=[];var u=t.cssHelperText;var a=t.getAttribute("media");if(a){var f=a.toLowerCase().split(",")}else{var f=["all"]}for(var l=0;l<f.length;l++){r[r.length]=c.mediaQuery(f[l],n)}var h=u.match(e.BLOCKS);if(h!==null){for(var l=0;l<h.length;l++){if(h[l].substring(0,7)==="@media "){var p=c.mediaQueryList(h[l],n);s=s.concat(p.getRules());i[i.length]=p}else{s[s.length]=o[o.length]=c.rule(h[l],n,null)}}}n.element=t;n.getCssText=function(){return u};n.getAttrMediaQueries=function(){return r};n.getMediaQueryLists=function(){return i};n.getRules=function(){return s};n.getRulesWithoutMQ=function(){return o};return n},mediaQueryList:function(t,n){var r={};var i=t.indexOf("{");var s=t.substring(0,i);t=t.substring(i+1,t.length-1);var o=[],u=[];var a=s.toLowerCase().substring(7).split(",");for(var f=0;f<a.length;f++){o[o.length]=c.mediaQuery(a[f],r)}var l=t.match(e.BLOCKS_INSIDE);if(l!==null){for(f=0;f<l.length;f++){u[u.length]=c.rule(l[f],n,r)}}r.type="mediaQueryList";r.getMediaQueries=function(){return o};r.getRules=function(){return u};r.getListText=function(){return s};r.getCssText=function(){return t};return r},mediaQuery:function(t,n){t=t||"";var r,i;if(n.type==="mediaQueryList"){r=n}else{i=n}var s=false,o;var u=[];var a=true;var f=t.match(e.NOT_WHITESPACE);for(var l=0;l<f.length;l++){var c=f[l];if(!o&&(c==="not"||c==="only")){if(c==="not"){s=true}}else if(!o){o=c}else if(c.charAt(0)==="("){var h=c.substring(1,c.length-1).split(":");u[u.length]={mediaFeature:h[0],value:h[1]||null}}}return{getQueryText:function(){return t},getAttrStyleSheet:function(){return i||null},getList:function(){return r||null},getValid:function(){return a},getNot:function(){return s},getMediaType:function(){return o},getExpressions:function(){return u}}},rule:function(e,t,n){var r={};var i=e.indexOf("{");var s=e.substring(0,i);var o=s.split(",");var u=[];var a=e.substring(i+1,e.length-1).split(";");for(var f=0;f<a.length;f++){u[u.length]=c.declaration(a[f],r)}r.getStylesheet=function(){return t||null};r.getMediaQueryList=function(){return n||null};r.getSelectors=function(){return o};r.getSelectorText=function(){return s};r.getDeclarations=function(){return u};r.getPropertyValue=function(e){for(var t=0;t<u.length;t++){if(u[t].getProperty()===e){return u[t].getValue()}}return null};return r},declaration:function(e,t){var n=e.indexOf(":");var r=e.substring(0,n);var i=e.substring(n+1);return{getRule:function(){return t||null},getProperty:function(){return r},getValue:function(){return i}}}};var h=function(e){if(typeof e.cssHelperText!=="string"){return}var n={stylesheet:null,mediaQueryLists:[],rules:[],selectors:{},declarations:[],properties:{}};var r=n.stylesheet=c.stylesheet(e);var s=n.mediaQueryLists=r.getMediaQueryLists();var o=n.rules=r.getRules();var u=n.selectors;var a=function(e){var t=e.getSelectors();for(var n=0;n<t.length;n++){var r=t[n];if(!u[r]){u[r]=[]}u[r][u[r].length]=e}};for(i=0;i<o.length;i++){a(o[i])}var f=n.declarations;for(i=0;i<o.length;i++){f=n.declarations=f.concat(o[i].getDeclarations())}var l=n.properties;for(i=0;i<f.length;i++){var h=f[i].getProperty();if(!l[h]){l[h]=[]}l[h][l[h].length]=f[i]}e.cssHelperParsed=n;t[t.length]=e;return n};var p=function(e,t){return;e.cssHelperText=l(t||e.innerHTML);return h(e)};var d=function(){n=true;t=[];var r=[];var i=function(){for(var e=0;e<r.length;e++){h(r[e])}var t=document.getElementsByTagName("style");for(e=0;e<t.length;e++){p(t[e])}n=false;o()};var s=document.getElementsByTagName("link");for(var u=0;u<s.length;u++){var a=s[u];if(a.getAttribute("rel").indexOf("style")>-1&&a.href&&a.href.length!==0&&!a.disabled){r[r.length]=a}}if(r.length>0){var c=0;var d=function(){c++;if(c===r.length){i()}};var v=function(t){var n=t.href;f(n,function(r){r=l(r).replace(e.RELATIVE_URLS,"url("+n.substring(0,n.lastIndexOf("/"))+"/$1)");t.cssHelperText=r;d()},d)};for(u=0;u<r.length;u++){v(r[u])}}else{i()}};var v={stylesheets:"array",mediaQueryLists:"array",rules:"array",selectors:"object",declarations:"array",properties:"object"};var m={stylesheets:null,mediaQueryLists:null,rules:null,selectors:null,declarations:null,properties:null};var g=function(e,t){if(m[e]!==null){if(v[e]==="array"){return m[e]=m[e].concat(t)}else{var n=m[e];for(var r in t){if(t.hasOwnProperty(r)){if(!n[r]){n[r]=t[r]}else{n[r]=n[r].concat(t[r])}}}return n}}};var y=function(e){m[e]=v[e]==="array"?[]:{};for(var n=0;n<t.length;n++){var r=e==="stylesheets"?"stylesheet":e;g(e,t[n].cssHelperParsed[r])}return m[e]};var b=function(e){if(typeof window.innerWidth!="undefined"){return window["inner"+e]}else if(typeof document.documentElement!=="undefined"&&typeof document.documentElement.clientWidth!=="undefined"&&document.documentElement.clientWidth!=0){return document.documentElement["client"+e]}};return{addStyle:function(e,t,n){var r=document.createElement("style");r.setAttribute("type","text/css");if(t&&t.length>0){r.setAttribute("media",t.join(","))}document.getElementsByTagName("head")[0].appendChild(r);if(r.styleSheet){r.styleSheet.cssText=e}else{r.appendChild(document.createTextNode(e))}r.addedWithCssHelper=true;if(typeof n==="undefined"||n===true){cssHelper.parsed(function(t){var n=p(r,e);for(var i in n){if(n.hasOwnProperty(i)){g(i,n[i])}}a("newStyleParsed",r)})}else{r.parsingDisallowed=true}return r},removeStyle:function(e){return e.parentNode.removeChild(e)},parsed:function(e){if(n){s(e)}else{if(typeof t!=="undefined"){if(typeof e==="function"){e(t)}}else{s(e);d()}}},stylesheets:function(e){cssHelper.parsed(function(t){e(m.stylesheets||y("stylesheets"))})},mediaQueryLists:function(e){cssHelper.parsed(function(t){e(m.mediaQueryLists||y("mediaQueryLists"))})},rules:function(e){cssHelper.parsed(function(t){e(m.rules||y("rules"))})},selectors:function(e){cssHelper.parsed(function(t){e(m.selectors||y("selectors"))})},declarations:function(e){cssHelper.parsed(function(t){e(m.declarations||y("declarations"))})},properties:function(e){cssHelper.parsed(function(t){e(m.properties||y("properties"))})},broadcast:a,addListener:function(e,t){if(typeof t==="function"){if(!u[e]){u[e]={listeners:[]}}u[e].listeners[u[e].listeners.length]=t}},removeListener:function(e,t){if(typeof t==="function"&&u[e]){var n=u[e].listeners;for(var r=0;r<n.length;r++){if(n[r]===t){n.splice(r,1);r-=1}}}},getViewportWidth:function(){return b("Width")},getViewportHeight:function(){return b("Height")}}}();domReady(function(){var t;var n={LENGTH_UNIT:/[0-9]+(em|ex|px|in|cm|mm|pt|pc)$/,RESOLUTION_UNIT:/[0-9]+(dpi|dpcm)$/,ASPECT_RATIO:/^[0-9]+\/[0-9]+$/,ABSOLUTE_VALUE:/^[0-9]*(\.[0-9]+)*$/};var r=[];var i=function(){var e="css3-mediaqueries-test";var t=document.createElement("div");t.id=e;var n=cssHelper.addStyle("@media all and (width) { #"+e+" { width: 1px !important; } }",[],false);document.body.appendChild(t);var r=t.offsetWidth===1;n.parentNode.removeChild(n);t.parentNode.removeChild(t);i=function(){return r};return r};var s=function(){t=document.createElement("div");t.style.cssText="position:absolute;top:-9999em;left:-9999em;"+"margin:0;border:none;padding:0;width:1em;font-size:1em;";document.body.appendChild(t);if(t.offsetWidth!==16){t.style.fontSize=16/t.offsetWidth+"em"}t.style.width=""};var o=function(e){t.style.width=e;var n=t.offsetWidth;t.style.width="";return n};var u=function(e,t){var r=e.length;var i=e.substring(0,4)==="min-";var s=!i&&e.substring(0,4)==="max-";if(t!==null){var u;var a;if(n.LENGTH_UNIT.exec(t)){u="length";a=o(t)}else if(n.RESOLUTION_UNIT.exec(t)){u="resolution";a=parseInt(t,10);var f=t.substring((a+"").length)}else if(n.ASPECT_RATIO.exec(t)){u="aspect-ratio";a=t.split("/")}else if(n.ABSOLUTE_VALUE){u="absolute";a=t}else{u="unknown"}}var l,c;if("device-width"===e.substring(r-12,r)){l=screen.width;if(t!==null){if(u==="length"){return i&&l>=a||s&&l<a||!i&&!s&&l===a}else{return false}}else{return l>0}}else if("device-height"===e.substring(r-13,r)){c=screen.height;if(t!==null){if(u==="length"){return i&&c>=a||s&&c<a||!i&&!s&&c===a}else{return false}}else{return c>0}}else if("width"===e.substring(r-5,r)){l=document.documentElement.clientWidth||document.body.clientWidth;if(t!==null){if(u==="length"){return i&&l>=a||s&&l<a||!i&&!s&&l===a}else{return false}}else{return l>0}}else if("height"===e.substring(r-6,r)){c=document.documentElement.clientHeight||document.body.clientHeight;if(t!==null){if(u==="length"){return i&&c>=a||s&&c<a||!i&&!s&&c===a}else{return false}}else{return c>0}}else if("device-aspect-ratio"===e.substring(r-19,r)){return u==="aspect-ratio"&&screen.width*a[1]===screen.height*a[0]}else if("color-index"===e.substring(r-11,r)){var h=Math.pow(2,screen.colorDepth);if(t!==null){if(u==="absolute"){return i&&h>=a||s&&h<a||!i&&!s&&h===a}else{return false}}else{return h>0}}else if("color"===e.substring(r-5,r)){var p=screen.colorDepth;if(t!==null){if(u==="absolute"){return i&&p>=a||s&&p<a||!i&&!s&&p===a}else{return false}}else{return p>0}}else if("resolution"===e.substring(r-10,r)){var d;if(f==="dpcm"){d=o("1cm")}else{d=o("1in")}if(t!==null){if(u==="resolution"){return i&&d>=a||s&&d<a||!i&&!s&&d===a}else{return false}}else{return d>0}}else{return false}};var a=function(e){var t=e.getValid();var n=e.getExpressions();var r=n.length;if(r>0){for(var i=0;i<r&&t;i++){t=u(n[i].mediaFeature,n[i].value)}var s=e.getNot();return t&&!s||s&&!t}return t};var f=function(e,t){var n=e.getMediaQueries();var i={};for(var s=0;s<n.length;s++){var o=n[s].getMediaType();if(n[s].getExpressions().length===0){continue}var u=true;if(o!=="all"&&t&&t.length>0){u=false;for(var f=0;f<t.length;f++){if(t[f]===o){u=true}}}if(u&&a(n[s])){i[o]=true}}var l=[],c=0;for(var h in i){if(i.hasOwnProperty(h)){if(c>0){l[c++]=","}l[c++]=h}}if(l.length>0){r[r.length]=cssHelper.addStyle("@media "+l.join("")+"{"+e.getCssText()+"}",t,false)}};var l=function(e,t){for(var n=0;n<e.length;n++){f(e[n],t)}};var c=function(e){var t=e.getAttrMediaQueries();var n=false;var i={};for(var s=0;s<t.length;s++){if(a(t[s])){i[t[s].getMediaType()]=t[s].getExpressions().length>0}}var o=[],u=[];for(var f in i){if(i.hasOwnProperty(f)){o[o.length]=f;if(i[f]){u[u.length]=f}if(f==="all"){n=true}}}if(u.length>0){r[r.length]=cssHelper.addStyle(e.getCssText(),u,false)}var c=e.getMediaQueryLists();if(n){l(c)}else{l(c,o)}};var h=function(e){for(var t=0;t<e.length;t++){c(e[t])}if(ua.ie){document.documentElement.style.display="block";setTimeout(function(){document.documentElement.style.display=""},0);setTimeout(function(){cssHelper.broadcast("cssMediaQueriesTested")},100)}else{cssHelper.broadcast("cssMediaQueriesTested")}};var p=function(){for(var e=0;e<r.length;e++){cssHelper.removeStyle(r[e])}r=[];cssHelper.stylesheets(h)};var d=0;var v=function(){var e=cssHelper.getViewportWidth();var t=cssHelper.getViewportHeight();if(ua.ie){var n=document.createElement("div");n.style.position="absolute";n.style.top="-9999em";n.style.overflow="scroll";document.body.appendChild(n);d=n.offsetWidth-n.clientWidth;document.body.removeChild(n)}var r;var s=function(){var n=cssHelper.getViewportWidth();var s=cssHelper.getViewportHeight();if(Math.abs(n-e)>d||Math.abs(s-t)>d){e=n;t=s;clearTimeout(r);r=setTimeout(function(){if(!i()){p()}else{cssHelper.broadcast("cssMediaQueriesTested")}},500)}};window.onresize=function(){var e=window.onresize||function(){};return function(){e();s()}}()};var m=document.documentElement;m.style.marginLeft="-32767px";setTimeout(function(){m.style.marginLeft=""},5e3);return function(){if(!i()){cssHelper.addListener("newStyleParsed",function(e){c(e.cssHelperParsed.stylesheet)});cssHelper.addListener("cssMediaQueriesTested",function(){if(ua.ie){m.style.width="1px"}setTimeout(function(){m.style.width="";m.style.marginLeft=""},0);cssHelper.removeListener("cssMediaQueriesTested",arguments.callee)});s();p()}else{m.style.marginLeft=""}v()}}());try{document.execCommand("BackgroundImageCache",false,true)}catch(e){}function add_message(str) {
    var theDiv = document.getElementById("inner");
    var newNode = document.createElement('p');
    newNode.className = 'message blue';
    newNode.innerHTML = str;
    theDiv.appendChild(newNode);
    theDiv.scrollTop = theDiv.scrollHeight;
}

function add_verbose(str) {
    var theDiv = document.getElementById("inner");
    var newNode = document.createElement('p');
    newNode.className = 'verbose';
    newNode.innerHTML = str;
    theDiv.appendChild(newNode);
    theDiv.scrollTop = theDiv.scrollHeight;
}

function add_error(str) {
    var theDiv = document.getElementById("inner");
    var newNode = document.createElement('p');
    newNode.innerHTML = str;
    newNode.className = 'message red';
    theDiv.appendChild(newNode);
    theDiv.scrollTop = theDiv.scrollHeight;
}

function set_block_html(id, html) {
    var theDiv = document.getElementById(id);
    theDiv.innerHTML = html;
}

function finish() {
    var theDiv = document.getElementById("bottom_nav");
    theDiv.style.display = 'block';
}

function socialShare() {

    // Twitter
    if (document.getElementById('twitter')) {
        document.getElementById('twitter').onclick = function() {
            window.open('https://twitter.com/intent/tweet?button_hashtag=cmsms&text=' + cmsms_lang.message, 'sharertwt', 'toolbar=0,status=0,width=540,height=345');
        };
    }
    // Google+
    if (document.getElementById('google')) {
        document.getElementById('google').onclick = function() {
            window.open('https://plus.google.com/share?url=http://www.cmsmadesimple.org', 'sharergplus', 'toolbar=0,status=0,width=524,height=505');
        };
    }
    // Facebook
    if (document.getElementById('facebook')) {
        document.getElementById('facebook').onclick = function() {
            window.open('http://www.facebook.com/sharer.php?u=http://www.cmsmadesimple.org', 'sharerfacebook', 'toolbar=0,status=0,width=525,height=368');
        };
    }
    // Linkedin
    if (document.getElementById('linkedin')) {
        document.getElementById('linkedin').onclick = function() {
            window.open('https://www.linkedin.com/cws/share?url=http%3A%2F%2Fwww.cmsmadesimple.org%2F&isFramed=true', 'sharerlinkedin', 'toolbar=0,status=0,width=540,height=528');
        };
    }

}

window.onload = function() {
    var freshen = document.getElementById('freshen'),
        upgrade = document.getElementById('upgrade');

    if( freshen ) {
        freshen.onclick = function() {
            return confirm(cmsms_lang.freshen);
        };
    }
    if( upgrade ) {
        upgrade.onclick = function() {
            return confirm(cmsms_lang.upgrade);
        };
    }

    socialShare();
};

function add_message(str){var theDiv=document.getElementById("inner");var newNode=document.createElement('p');newNode.className='message blue';newNode.innerHTML=str;theDiv.appendChild(newNode);theDiv.scrollTop=theDiv.scrollHeight;}
function add_verbose(str){var theDiv=document.getElementById("inner");var newNode=document.createElement('p');newNode.className='verbose';newNode.innerHTML=str;theDiv.appendChild(newNode);theDiv.scrollTop=theDiv.scrollHeight;}
function add_error(str){var theDiv=document.getElementById("inner");var newNode=document.createElement('p');newNode.innerHTML=str;newNode.className='message red';theDiv.appendChild(newNode);theDiv.scrollTop=theDiv.scrollHeight;}
function set_block_html(id,html){var theDiv=document.getElementById(id);theDiv.innerHTML=html;}
function finish(){var theDiv=document.getElementById("bottom_nav");theDiv.style.display='table';}
function socialShare(){if(document.getElementById('twitter')){document.getElementById('twitter').onclick=function(){window.open('https://twitter.com/intent/tweet?button_hashtag=cmsms&text='+cmsms_lang.message,'sharertwt','toolbar=0,status=0,width=540,height=345');};}
if(document.getElementById('google')){document.getElementById('google').onclick=function(){window.open('https://plus.google.com/share?url=http://www.cmsmadesimple.org','sharergplus','toolbar=0,status=0,width=524,height=505');};}
if(document.getElementById('facebook')){document.getElementById('facebook').onclick=function(){window.open('http://www.facebook.com/sharer.php?u=http://www.cmsmadesimple.org','sharerfacebook','toolbar=0,status=0,width=525,height=368');};}
if(document.getElementById('linkedin')){document.getElementById('linkedin').onclick=function(){window.open('https://www.linkedin.com/cws/share?url=http%3A%2F%2Fwww.cmsmadesimple.org%2F&isFramed=true','sharerlinkedin','toolbar=0,status=0,width=540,height=528');};}}
window.onload=function(){var freshen=document.getElementById('freshen'),upgrade=document.getElementById('upgrade');if(freshen){freshen.onclick=function(){return confirm(cmsms_lang.freshen);};}
if(upgrade){upgrade.onclick=function(){return confirm(cmsms_lang.upgrade);};}
socialShare();};/*
 HTML5 Shiv v3.7.0 | @afarkas @jdalton @jon_neal @rem | MIT/GPL2 Licensed
*/
(function(l,f){function m(){var a=e.elements;return"string"==typeof a?a.split(" "):a}function i(a){var b=n[a[o]];b||(b={},h++,a[o]=h,n[h]=b);return b}function p(a,b,c){b||(b=f);if(g)return b.createElement(a);c||(c=i(b));b=c.cache[a]?c.cache[a].cloneNode():r.test(a)?(c.cache[a]=c.createElem(a)).cloneNode():c.createElem(a);return b.canHaveChildren&&!s.test(a)?c.frag.appendChild(b):b}function t(a,b){if(!b.cache)b.cache={},b.createElem=a.createElement,b.createFrag=a.createDocumentFragment,b.frag=b.createFrag();
a.createElement=function(c){return!e.shivMethods?b.createElem(c):p(c,a,b)};a.createDocumentFragment=Function("h,f","return function(){var n=f.cloneNode(),c=n.createElement;h.shivMethods&&("+m().join().replace(/[\w\-]+/g,function(a){b.createElem(a);b.frag.createElement(a);return'c("'+a+'")'})+");return n}")(e,b.frag)}function q(a){a||(a=f);var b=i(a);if(e.shivCSS&&!j&&!b.hasCSS){var c,d=a;c=d.createElement("p");d=d.getElementsByTagName("head")[0]||d.documentElement;c.innerHTML="x<style>article,aside,dialog,figcaption,figure,footer,header,hgroup,main,nav,section{display:block}mark{background:#FF0;color:#000}template{display:none}</style>";
c=d.insertBefore(c.lastChild,d.firstChild);b.hasCSS=!!c}g||t(a,b);return a}var k=l.html5||{},s=/^<|^(?:button|map|select|textarea|object|iframe|option|optgroup)$/i,r=/^(?:a|b|code|div|fieldset|h1|h2|h3|h4|h5|h6|i|label|li|ol|p|q|span|strong|style|table|tbody|td|th|tr|ul)$/i,j,o="_html5shiv",h=0,n={},g;(function(){try{var a=f.createElement("a");a.innerHTML="<xyz></xyz>";j="hidden"in a;var b;if(!(b=1==a.childNodes.length)){f.createElement("a");var c=f.createDocumentFragment();b="undefined"==typeof c.cloneNode||
"undefined"==typeof c.createDocumentFragment||"undefined"==typeof c.createElement}g=b}catch(d){g=j=!0}})();var e={elements:k.elements||"abbr article aside audio bdi canvas data datalist details dialog figcaption figure footer header hgroup main mark meter nav output progress section summary template time video",version:"3.7.0",shivCSS:!1!==k.shivCSS,supportsUnknownElements:g,shivMethods:!1!==k.shivMethods,type:"default",shivDocument:q,createElement:p,createDocumentFragment:function(a,b){a||(a=f);
if(g)return a.createDocumentFragment();for(var b=b||i(a),c=b.frag.cloneNode(),d=0,e=m(),h=e.length;d<h;d++)c.createElement(e[d]);return c}};l.html5=e;q(f)})(this,document);
/*! jQuery v1.11.2 | (c) 2005, 2014 jQuery Foundation, Inc. | jquery.org/license */
!function(a,b){"object"==typeof module&&"object"==typeof module.exports?module.exports=a.document?b(a,!0):function(a){if(!a.document)throw new Error("jQuery requires a window with a document");return b(a)}:b(a)}("undefined"!=typeof window?window:this,function(a,b){var c=[],d=c.slice,e=c.concat,f=c.push,g=c.indexOf,h={},i=h.toString,j=h.hasOwnProperty,k={},l="1.11.2",m=function(a,b){return new m.fn.init(a,b)},n=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,o=/^-ms-/,p=/-([\da-z])/gi,q=function(a,b){return b.toUpperCase()};m.fn=m.prototype={jquery:l,constructor:m,selector:"",length:0,toArray:function(){return d.call(this)},get:function(a){return null!=a?0>a?this[a+this.length]:this[a]:d.call(this)},pushStack:function(a){var b=m.merge(this.constructor(),a);return b.prevObject=this,b.context=this.context,b},each:function(a,b){return m.each(this,a,b)},map:function(a){return this.pushStack(m.map(this,function(b,c){return a.call(b,c,b)}))},slice:function(){return this.pushStack(d.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(a){var b=this.length,c=+a+(0>a?b:0);return this.pushStack(c>=0&&b>c?[this[c]]:[])},end:function(){return this.prevObject||this.constructor(null)},push:f,sort:c.sort,splice:c.splice},m.extend=m.fn.extend=function(){var a,b,c,d,e,f,g=arguments[0]||{},h=1,i=arguments.length,j=!1;for("boolean"==typeof g&&(j=g,g=arguments[h]||{},h++),"object"==typeof g||m.isFunction(g)||(g={}),h===i&&(g=this,h--);i>h;h++)if(null!=(e=arguments[h]))for(d in e)a=g[d],c=e[d],g!==c&&(j&&c&&(m.isPlainObject(c)||(b=m.isArray(c)))?(b?(b=!1,f=a&&m.isArray(a)?a:[]):f=a&&m.isPlainObject(a)?a:{},g[d]=m.extend(j,f,c)):void 0!==c&&(g[d]=c));return g},m.extend({expando:"jQuery"+(l+Math.random()).replace(/\D/g,""),isReady:!0,error:function(a){throw new Error(a)},noop:function(){},isFunction:function(a){return"function"===m.type(a)},isArray:Array.isArray||function(a){return"array"===m.type(a)},isWindow:function(a){return null!=a&&a==a.window},isNumeric:function(a){return!m.isArray(a)&&a-parseFloat(a)+1>=0},isEmptyObject:function(a){var b;for(b in a)return!1;return!0},isPlainObject:function(a){var b;if(!a||"object"!==m.type(a)||a.nodeType||m.isWindow(a))return!1;try{if(a.constructor&&!j.call(a,"constructor")&&!j.call(a.constructor.prototype,"isPrototypeOf"))return!1}catch(c){return!1}if(k.ownLast)for(b in a)return j.call(a,b);for(b in a);return void 0===b||j.call(a,b)},type:function(a){return null==a?a+"":"object"==typeof a||"function"==typeof a?h[i.call(a)]||"object":typeof a},globalEval:function(b){b&&m.trim(b)&&(a.execScript||function(b){a.eval.call(a,b)})(b)},camelCase:function(a){return a.replace(o,"ms-").replace(p,q)},nodeName:function(a,b){return a.nodeName&&a.nodeName.toLowerCase()===b.toLowerCase()},each:function(a,b,c){var d,e=0,f=a.length,g=r(a);if(c){if(g){for(;f>e;e++)if(d=b.apply(a[e],c),d===!1)break}else for(e in a)if(d=b.apply(a[e],c),d===!1)break}else if(g){for(;f>e;e++)if(d=b.call(a[e],e,a[e]),d===!1)break}else for(e in a)if(d=b.call(a[e],e,a[e]),d===!1)break;return a},trim:function(a){return null==a?"":(a+"").replace(n,"")},makeArray:function(a,b){var c=b||[];return null!=a&&(r(Object(a))?m.merge(c,"string"==typeof a?[a]:a):f.call(c,a)),c},inArray:function(a,b,c){var d;if(b){if(g)return g.call(b,a,c);for(d=b.length,c=c?0>c?Math.max(0,d+c):c:0;d>c;c++)if(c in b&&b[c]===a)return c}return-1},merge:function(a,b){var c=+b.length,d=0,e=a.length;while(c>d)a[e++]=b[d++];if(c!==c)while(void 0!==b[d])a[e++]=b[d++];return a.length=e,a},grep:function(a,b,c){for(var d,e=[],f=0,g=a.length,h=!c;g>f;f++)d=!b(a[f],f),d!==h&&e.push(a[f]);return e},map:function(a,b,c){var d,f=0,g=a.length,h=r(a),i=[];if(h)for(;g>f;f++)d=b(a[f],f,c),null!=d&&i.push(d);else for(f in a)d=b(a[f],f,c),null!=d&&i.push(d);return e.apply([],i)},guid:1,proxy:function(a,b){var c,e,f;return"string"==typeof b&&(f=a[b],b=a,a=f),m.isFunction(a)?(c=d.call(arguments,2),e=function(){return a.apply(b||this,c.concat(d.call(arguments)))},e.guid=a.guid=a.guid||m.guid++,e):void 0},now:function(){return+new Date},support:k}),m.each("Boolean Number String Function Array Date RegExp Object Error".split(" "),function(a,b){h["[object "+b+"]"]=b.toLowerCase()});function r(a){var b=a.length,c=m.type(a);return"function"===c||m.isWindow(a)?!1:1===a.nodeType&&b?!0:"array"===c||0===b||"number"==typeof b&&b>0&&b-1 in a}var s=function(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u="sizzle"+1*new Date,v=a.document,w=0,x=0,y=hb(),z=hb(),A=hb(),B=function(a,b){return a===b&&(l=!0),0},C=1<<31,D={}.hasOwnProperty,E=[],F=E.pop,G=E.push,H=E.push,I=E.slice,J=function(a,b){for(var c=0,d=a.length;d>c;c++)if(a[c]===b)return c;return-1},K="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",L="[\\x20\\t\\r\\n\\f]",M="(?:\\\\.|[\\w-]|[^\\x00-\\xa0])+",N=M.replace("w","w#"),O="\\["+L+"*("+M+")(?:"+L+"*([*^$|!~]?=)"+L+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+N+"))|)"+L+"*\\]",P=":("+M+")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|"+O+")*)|.*)\\)|)",Q=new RegExp(L+"+","g"),R=new RegExp("^"+L+"+|((?:^|[^\\\\])(?:\\\\.)*)"+L+"+$","g"),S=new RegExp("^"+L+"*,"+L+"*"),T=new RegExp("^"+L+"*([>+~]|"+L+")"+L+"*"),U=new RegExp("="+L+"*([^\\]'\"]*?)"+L+"*\\]","g"),V=new RegExp(P),W=new RegExp("^"+N+"$"),X={ID:new RegExp("^#("+M+")"),CLASS:new RegExp("^\\.("+M+")"),TAG:new RegExp("^("+M.replace("w","w*")+")"),ATTR:new RegExp("^"+O),PSEUDO:new RegExp("^"+P),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+L+"*(even|odd|(([+-]|)(\\d*)n|)"+L+"*(?:([+-]|)"+L+"*(\\d+)|))"+L+"*\\)|)","i"),bool:new RegExp("^(?:"+K+")$","i"),needsContext:new RegExp("^"+L+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+L+"*((?:-\\d)?\\d*)"+L+"*\\)|)(?=[^-]|$)","i")},Y=/^(?:input|select|textarea|button)$/i,Z=/^h\d$/i,$=/^[^{]+\{\s*\[native \w/,_=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,ab=/[+~]/,bb=/'|\\/g,cb=new RegExp("\\\\([\\da-f]{1,6}"+L+"?|("+L+")|.)","ig"),db=function(a,b,c){var d="0x"+b-65536;return d!==d||c?b:0>d?String.fromCharCode(d+65536):String.fromCharCode(d>>10|55296,1023&d|56320)},eb=function(){m()};try{H.apply(E=I.call(v.childNodes),v.childNodes),E[v.childNodes.length].nodeType}catch(fb){H={apply:E.length?function(a,b){G.apply(a,I.call(b))}:function(a,b){var c=a.length,d=0;while(a[c++]=b[d++]);a.length=c-1}}}function gb(a,b,d,e){var f,h,j,k,l,o,r,s,w,x;if((b?b.ownerDocument||b:v)!==n&&m(b),b=b||n,d=d||[],k=b.nodeType,"string"!=typeof a||!a||1!==k&&9!==k&&11!==k)return d;if(!e&&p){if(11!==k&&(f=_.exec(a)))if(j=f[1]){if(9===k){if(h=b.getElementById(j),!h||!h.parentNode)return d;if(h.id===j)return d.push(h),d}else if(b.ownerDocument&&(h=b.ownerDocument.getElementById(j))&&t(b,h)&&h.id===j)return d.push(h),d}else{if(f[2])return H.apply(d,b.getElementsByTagName(a)),d;if((j=f[3])&&c.getElementsByClassName)return H.apply(d,b.getElementsByClassName(j)),d}if(c.qsa&&(!q||!q.test(a))){if(s=r=u,w=b,x=1!==k&&a,1===k&&"object"!==b.nodeName.toLowerCase()){o=g(a),(r=b.getAttribute("id"))?s=r.replace(bb,"\\$&"):b.setAttribute("id",s),s="[id='"+s+"'] ",l=o.length;while(l--)o[l]=s+rb(o[l]);w=ab.test(a)&&pb(b.parentNode)||b,x=o.join(",")}if(x)try{return H.apply(d,w.querySelectorAll(x)),d}catch(y){}finally{r||b.removeAttribute("id")}}}return i(a.replace(R,"$1"),b,d,e)}function hb(){var a=[];function b(c,e){return a.push(c+" ")>d.cacheLength&&delete b[a.shift()],b[c+" "]=e}return b}function ib(a){return a[u]=!0,a}function jb(a){var b=n.createElement("div");try{return!!a(b)}catch(c){return!1}finally{b.parentNode&&b.parentNode.removeChild(b),b=null}}function kb(a,b){var c=a.split("|"),e=a.length;while(e--)d.attrHandle[c[e]]=b}function lb(a,b){var c=b&&a,d=c&&1===a.nodeType&&1===b.nodeType&&(~b.sourceIndex||C)-(~a.sourceIndex||C);if(d)return d;if(c)while(c=c.nextSibling)if(c===b)return-1;return a?1:-1}function mb(a){return function(b){var c=b.nodeName.toLowerCase();return"input"===c&&b.type===a}}function nb(a){return function(b){var c=b.nodeName.toLowerCase();return("input"===c||"button"===c)&&b.type===a}}function ob(a){return ib(function(b){return b=+b,ib(function(c,d){var e,f=a([],c.length,b),g=f.length;while(g--)c[e=f[g]]&&(c[e]=!(d[e]=c[e]))})})}function pb(a){return a&&"undefined"!=typeof a.getElementsByTagName&&a}c=gb.support={},f=gb.isXML=function(a){var b=a&&(a.ownerDocument||a).documentElement;return b?"HTML"!==b.nodeName:!1},m=gb.setDocument=function(a){var b,e,g=a?a.ownerDocument||a:v;return g!==n&&9===g.nodeType&&g.documentElement?(n=g,o=g.documentElement,e=g.defaultView,e&&e!==e.top&&(e.addEventListener?e.addEventListener("unload",eb,!1):e.attachEvent&&e.attachEvent("onunload",eb)),p=!f(g),c.attributes=jb(function(a){return a.className="i",!a.getAttribute("className")}),c.getElementsByTagName=jb(function(a){return a.appendChild(g.createComment("")),!a.getElementsByTagName("*").length}),c.getElementsByClassName=$.test(g.getElementsByClassName),c.getById=jb(function(a){return o.appendChild(a).id=u,!g.getElementsByName||!g.getElementsByName(u).length}),c.getById?(d.find.ID=function(a,b){if("undefined"!=typeof b.getElementById&&p){var c=b.getElementById(a);return c&&c.parentNode?[c]:[]}},d.filter.ID=function(a){var b=a.replace(cb,db);return function(a){return a.getAttribute("id")===b}}):(delete d.find.ID,d.filter.ID=function(a){var b=a.replace(cb,db);return function(a){var c="undefined"!=typeof a.getAttributeNode&&a.getAttributeNode("id");return c&&c.value===b}}),d.find.TAG=c.getElementsByTagName?function(a,b){return"undefined"!=typeof b.getElementsByTagName?b.getElementsByTagName(a):c.qsa?b.querySelectorAll(a):void 0}:function(a,b){var c,d=[],e=0,f=b.getElementsByTagName(a);if("*"===a){while(c=f[e++])1===c.nodeType&&d.push(c);return d}return f},d.find.CLASS=c.getElementsByClassName&&function(a,b){return p?b.getElementsByClassName(a):void 0},r=[],q=[],(c.qsa=$.test(g.querySelectorAll))&&(jb(function(a){o.appendChild(a).innerHTML="<a id='"+u+"'></a><select id='"+u+"-\f]' msallowcapture=''><option selected=''></option></select>",a.querySelectorAll("[msallowcapture^='']").length&&q.push("[*^$]="+L+"*(?:''|\"\")"),a.querySelectorAll("[selected]").length||q.push("\\["+L+"*(?:value|"+K+")"),a.querySelectorAll("[id~="+u+"-]").length||q.push("~="),a.querySelectorAll(":checked").length||q.push(":checked"),a.querySelectorAll("a#"+u+"+*").length||q.push(".#.+[+~]")}),jb(function(a){var b=g.createElement("input");b.setAttribute("type","hidden"),a.appendChild(b).setAttribute("name","D"),a.querySelectorAll("[name=d]").length&&q.push("name"+L+"*[*^$|!~]?="),a.querySelectorAll(":enabled").length||q.push(":enabled",":disabled"),a.querySelectorAll("*,:x"),q.push(",.*:")})),(c.matchesSelector=$.test(s=o.matches||o.webkitMatchesSelector||o.mozMatchesSelector||o.oMatchesSelector||o.msMatchesSelector))&&jb(function(a){c.disconnectedMatch=s.call(a,"div"),s.call(a,"[s!='']:x"),r.push("!=",P)}),q=q.length&&new RegExp(q.join("|")),r=r.length&&new RegExp(r.join("|")),b=$.test(o.compareDocumentPosition),t=b||$.test(o.contains)?function(a,b){var c=9===a.nodeType?a.documentElement:a,d=b&&b.parentNode;return a===d||!(!d||1!==d.nodeType||!(c.contains?c.contains(d):a.compareDocumentPosition&&16&a.compareDocumentPosition(d)))}:function(a,b){if(b)while(b=b.parentNode)if(b===a)return!0;return!1},B=b?function(a,b){if(a===b)return l=!0,0;var d=!a.compareDocumentPosition-!b.compareDocumentPosition;return d?d:(d=(a.ownerDocument||a)===(b.ownerDocument||b)?a.compareDocumentPosition(b):1,1&d||!c.sortDetached&&b.compareDocumentPosition(a)===d?a===g||a.ownerDocument===v&&t(v,a)?-1:b===g||b.ownerDocument===v&&t(v,b)?1:k?J(k,a)-J(k,b):0:4&d?-1:1)}:function(a,b){if(a===b)return l=!0,0;var c,d=0,e=a.parentNode,f=b.parentNode,h=[a],i=[b];if(!e||!f)return a===g?-1:b===g?1:e?-1:f?1:k?J(k,a)-J(k,b):0;if(e===f)return lb(a,b);c=a;while(c=c.parentNode)h.unshift(c);c=b;while(c=c.parentNode)i.unshift(c);while(h[d]===i[d])d++;return d?lb(h[d],i[d]):h[d]===v?-1:i[d]===v?1:0},g):n},gb.matches=function(a,b){return gb(a,null,null,b)},gb.matchesSelector=function(a,b){if((a.ownerDocument||a)!==n&&m(a),b=b.replace(U,"='$1']"),!(!c.matchesSelector||!p||r&&r.test(b)||q&&q.test(b)))try{var d=s.call(a,b);if(d||c.disconnectedMatch||a.document&&11!==a.document.nodeType)return d}catch(e){}return gb(b,n,null,[a]).length>0},gb.contains=function(a,b){return(a.ownerDocument||a)!==n&&m(a),t(a,b)},gb.attr=function(a,b){(a.ownerDocument||a)!==n&&m(a);var e=d.attrHandle[b.toLowerCase()],f=e&&D.call(d.attrHandle,b.toLowerCase())?e(a,b,!p):void 0;return void 0!==f?f:c.attributes||!p?a.getAttribute(b):(f=a.getAttributeNode(b))&&f.specified?f.value:null},gb.error=function(a){throw new Error("Syntax error, unrecognized expression: "+a)},gb.uniqueSort=function(a){var b,d=[],e=0,f=0;if(l=!c.detectDuplicates,k=!c.sortStable&&a.slice(0),a.sort(B),l){while(b=a[f++])b===a[f]&&(e=d.push(f));while(e--)a.splice(d[e],1)}return k=null,a},e=gb.getText=function(a){var b,c="",d=0,f=a.nodeType;if(f){if(1===f||9===f||11===f){if("string"==typeof a.textContent)return a.textContent;for(a=a.firstChild;a;a=a.nextSibling)c+=e(a)}else if(3===f||4===f)return a.nodeValue}else while(b=a[d++])c+=e(b);return c},d=gb.selectors={cacheLength:50,createPseudo:ib,match:X,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(a){return a[1]=a[1].replace(cb,db),a[3]=(a[3]||a[4]||a[5]||"").replace(cb,db),"~="===a[2]&&(a[3]=" "+a[3]+" "),a.slice(0,4)},CHILD:function(a){return a[1]=a[1].toLowerCase(),"nth"===a[1].slice(0,3)?(a[3]||gb.error(a[0]),a[4]=+(a[4]?a[5]+(a[6]||1):2*("even"===a[3]||"odd"===a[3])),a[5]=+(a[7]+a[8]||"odd"===a[3])):a[3]&&gb.error(a[0]),a},PSEUDO:function(a){var b,c=!a[6]&&a[2];return X.CHILD.test(a[0])?null:(a[3]?a[2]=a[4]||a[5]||"":c&&V.test(c)&&(b=g(c,!0))&&(b=c.indexOf(")",c.length-b)-c.length)&&(a[0]=a[0].slice(0,b),a[2]=c.slice(0,b)),a.slice(0,3))}},filter:{TAG:function(a){var b=a.replace(cb,db).toLowerCase();return"*"===a?function(){return!0}:function(a){return a.nodeName&&a.nodeName.toLowerCase()===b}},CLASS:function(a){var b=y[a+" "];return b||(b=new RegExp("(^|"+L+")"+a+"("+L+"|$)"))&&y(a,function(a){return b.test("string"==typeof a.className&&a.className||"undefined"!=typeof a.getAttribute&&a.getAttribute("class")||"")})},ATTR:function(a,b,c){return function(d){var e=gb.attr(d,a);return null==e?"!="===b:b?(e+="","="===b?e===c:"!="===b?e!==c:"^="===b?c&&0===e.indexOf(c):"*="===b?c&&e.indexOf(c)>-1:"$="===b?c&&e.slice(-c.length)===c:"~="===b?(" "+e.replace(Q," ")+" ").indexOf(c)>-1:"|="===b?e===c||e.slice(0,c.length+1)===c+"-":!1):!0}},CHILD:function(a,b,c,d,e){var f="nth"!==a.slice(0,3),g="last"!==a.slice(-4),h="of-type"===b;return 1===d&&0===e?function(a){return!!a.parentNode}:function(b,c,i){var j,k,l,m,n,o,p=f!==g?"nextSibling":"previousSibling",q=b.parentNode,r=h&&b.nodeName.toLowerCase(),s=!i&&!h;if(q){if(f){while(p){l=b;while(l=l[p])if(h?l.nodeName.toLowerCase()===r:1===l.nodeType)return!1;o=p="only"===a&&!o&&"nextSibling"}return!0}if(o=[g?q.firstChild:q.lastChild],g&&s){k=q[u]||(q[u]={}),j=k[a]||[],n=j[0]===w&&j[1],m=j[0]===w&&j[2],l=n&&q.childNodes[n];while(l=++n&&l&&l[p]||(m=n=0)||o.pop())if(1===l.nodeType&&++m&&l===b){k[a]=[w,n,m];break}}else if(s&&(j=(b[u]||(b[u]={}))[a])&&j[0]===w)m=j[1];else while(l=++n&&l&&l[p]||(m=n=0)||o.pop())if((h?l.nodeName.toLowerCase()===r:1===l.nodeType)&&++m&&(s&&((l[u]||(l[u]={}))[a]=[w,m]),l===b))break;return m-=e,m===d||m%d===0&&m/d>=0}}},PSEUDO:function(a,b){var c,e=d.pseudos[a]||d.setFilters[a.toLowerCase()]||gb.error("unsupported pseudo: "+a);return e[u]?e(b):e.length>1?(c=[a,a,"",b],d.setFilters.hasOwnProperty(a.toLowerCase())?ib(function(a,c){var d,f=e(a,b),g=f.length;while(g--)d=J(a,f[g]),a[d]=!(c[d]=f[g])}):function(a){return e(a,0,c)}):e}},pseudos:{not:ib(function(a){var b=[],c=[],d=h(a.replace(R,"$1"));return d[u]?ib(function(a,b,c,e){var f,g=d(a,null,e,[]),h=a.length;while(h--)(f=g[h])&&(a[h]=!(b[h]=f))}):function(a,e,f){return b[0]=a,d(b,null,f,c),b[0]=null,!c.pop()}}),has:ib(function(a){return function(b){return gb(a,b).length>0}}),contains:ib(function(a){return a=a.replace(cb,db),function(b){return(b.textContent||b.innerText||e(b)).indexOf(a)>-1}}),lang:ib(function(a){return W.test(a||"")||gb.error("unsupported lang: "+a),a=a.replace(cb,db).toLowerCase(),function(b){var c;do if(c=p?b.lang:b.getAttribute("xml:lang")||b.getAttribute("lang"))return c=c.toLowerCase(),c===a||0===c.indexOf(a+"-");while((b=b.parentNode)&&1===b.nodeType);return!1}}),target:function(b){var c=a.location&&a.location.hash;return c&&c.slice(1)===b.id},root:function(a){return a===o},focus:function(a){return a===n.activeElement&&(!n.hasFocus||n.hasFocus())&&!!(a.type||a.href||~a.tabIndex)},enabled:function(a){return a.disabled===!1},disabled:function(a){return a.disabled===!0},checked:function(a){var b=a.nodeName.toLowerCase();return"input"===b&&!!a.checked||"option"===b&&!!a.selected},selected:function(a){return a.parentNode&&a.parentNode.selectedIndex,a.selected===!0},empty:function(a){for(a=a.firstChild;a;a=a.nextSibling)if(a.nodeType<6)return!1;return!0},parent:function(a){return!d.pseudos.empty(a)},header:function(a){return Z.test(a.nodeName)},input:function(a){return Y.test(a.nodeName)},button:function(a){var b=a.nodeName.toLowerCase();return"input"===b&&"button"===a.type||"button"===b},text:function(a){var b;return"input"===a.nodeName.toLowerCase()&&"text"===a.type&&(null==(b=a.getAttribute("type"))||"text"===b.toLowerCase())},first:ob(function(){return[0]}),last:ob(function(a,b){return[b-1]}),eq:ob(function(a,b,c){return[0>c?c+b:c]}),even:ob(function(a,b){for(var c=0;b>c;c+=2)a.push(c);return a}),odd:ob(function(a,b){for(var c=1;b>c;c+=2)a.push(c);return a}),lt:ob(function(a,b,c){for(var d=0>c?c+b:c;--d>=0;)a.push(d);return a}),gt:ob(function(a,b,c){for(var d=0>c?c+b:c;++d<b;)a.push(d);return a})}},d.pseudos.nth=d.pseudos.eq;for(b in{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})d.pseudos[b]=mb(b);for(b in{submit:!0,reset:!0})d.pseudos[b]=nb(b);function qb(){}qb.prototype=d.filters=d.pseudos,d.setFilters=new qb,g=gb.tokenize=function(a,b){var c,e,f,g,h,i,j,k=z[a+" "];if(k)return b?0:k.slice(0);h=a,i=[],j=d.preFilter;while(h){(!c||(e=S.exec(h)))&&(e&&(h=h.slice(e[0].length)||h),i.push(f=[])),c=!1,(e=T.exec(h))&&(c=e.shift(),f.push({value:c,type:e[0].replace(R," ")}),h=h.slice(c.length));for(g in d.filter)!(e=X[g].exec(h))||j[g]&&!(e=j[g](e))||(c=e.shift(),f.push({value:c,type:g,matches:e}),h=h.slice(c.length));if(!c)break}return b?h.length:h?gb.error(a):z(a,i).slice(0)};function rb(a){for(var b=0,c=a.length,d="";c>b;b++)d+=a[b].value;return d}function sb(a,b,c){var d=b.dir,e=c&&"parentNode"===d,f=x++;return b.first?function(b,c,f){while(b=b[d])if(1===b.nodeType||e)return a(b,c,f)}:function(b,c,g){var h,i,j=[w,f];if(g){while(b=b[d])if((1===b.nodeType||e)&&a(b,c,g))return!0}else while(b=b[d])if(1===b.nodeType||e){if(i=b[u]||(b[u]={}),(h=i[d])&&h[0]===w&&h[1]===f)return j[2]=h[2];if(i[d]=j,j[2]=a(b,c,g))return!0}}}function tb(a){return a.length>1?function(b,c,d){var e=a.length;while(e--)if(!a[e](b,c,d))return!1;return!0}:a[0]}function ub(a,b,c){for(var d=0,e=b.length;e>d;d++)gb(a,b[d],c);return c}function vb(a,b,c,d,e){for(var f,g=[],h=0,i=a.length,j=null!=b;i>h;h++)(f=a[h])&&(!c||c(f,d,e))&&(g.push(f),j&&b.push(h));return g}function wb(a,b,c,d,e,f){return d&&!d[u]&&(d=wb(d)),e&&!e[u]&&(e=wb(e,f)),ib(function(f,g,h,i){var j,k,l,m=[],n=[],o=g.length,p=f||ub(b||"*",h.nodeType?[h]:h,[]),q=!a||!f&&b?p:vb(p,m,a,h,i),r=c?e||(f?a:o||d)?[]:g:q;if(c&&c(q,r,h,i),d){j=vb(r,n),d(j,[],h,i),k=j.length;while(k--)(l=j[k])&&(r[n[k]]=!(q[n[k]]=l))}if(f){if(e||a){if(e){j=[],k=r.length;while(k--)(l=r[k])&&j.push(q[k]=l);e(null,r=[],j,i)}k=r.length;while(k--)(l=r[k])&&(j=e?J(f,l):m[k])>-1&&(f[j]=!(g[j]=l))}}else r=vb(r===g?r.splice(o,r.length):r),e?e(null,g,r,i):H.apply(g,r)})}function xb(a){for(var b,c,e,f=a.length,g=d.relative[a[0].type],h=g||d.relative[" "],i=g?1:0,k=sb(function(a){return a===b},h,!0),l=sb(function(a){return J(b,a)>-1},h,!0),m=[function(a,c,d){var e=!g&&(d||c!==j)||((b=c).nodeType?k(a,c,d):l(a,c,d));return b=null,e}];f>i;i++)if(c=d.relative[a[i].type])m=[sb(tb(m),c)];else{if(c=d.filter[a[i].type].apply(null,a[i].matches),c[u]){for(e=++i;f>e;e++)if(d.relative[a[e].type])break;return wb(i>1&&tb(m),i>1&&rb(a.slice(0,i-1).concat({value:" "===a[i-2].type?"*":""})).replace(R,"$1"),c,e>i&&xb(a.slice(i,e)),f>e&&xb(a=a.slice(e)),f>e&&rb(a))}m.push(c)}return tb(m)}function yb(a,b){var c=b.length>0,e=a.length>0,f=function(f,g,h,i,k){var l,m,o,p=0,q="0",r=f&&[],s=[],t=j,u=f||e&&d.find.TAG("*",k),v=w+=null==t?1:Math.random()||.1,x=u.length;for(k&&(j=g!==n&&g);q!==x&&null!=(l=u[q]);q++){if(e&&l){m=0;while(o=a[m++])if(o(l,g,h)){i.push(l);break}k&&(w=v)}c&&((l=!o&&l)&&p--,f&&r.push(l))}if(p+=q,c&&q!==p){m=0;while(o=b[m++])o(r,s,g,h);if(f){if(p>0)while(q--)r[q]||s[q]||(s[q]=F.call(i));s=vb(s)}H.apply(i,s),k&&!f&&s.length>0&&p+b.length>1&&gb.uniqueSort(i)}return k&&(w=v,j=t),r};return c?ib(f):f}return h=gb.compile=function(a,b){var c,d=[],e=[],f=A[a+" "];if(!f){b||(b=g(a)),c=b.length;while(c--)f=xb(b[c]),f[u]?d.push(f):e.push(f);f=A(a,yb(e,d)),f.selector=a}return f},i=gb.select=function(a,b,e,f){var i,j,k,l,m,n="function"==typeof a&&a,o=!f&&g(a=n.selector||a);if(e=e||[],1===o.length){if(j=o[0]=o[0].slice(0),j.length>2&&"ID"===(k=j[0]).type&&c.getById&&9===b.nodeType&&p&&d.relative[j[1].type]){if(b=(d.find.ID(k.matches[0].replace(cb,db),b)||[])[0],!b)return e;n&&(b=b.parentNode),a=a.slice(j.shift().value.length)}i=X.needsContext.test(a)?0:j.length;while(i--){if(k=j[i],d.relative[l=k.type])break;if((m=d.find[l])&&(f=m(k.matches[0].replace(cb,db),ab.test(j[0].type)&&pb(b.parentNode)||b))){if(j.splice(i,1),a=f.length&&rb(j),!a)return H.apply(e,f),e;break}}}return(n||h(a,o))(f,b,!p,e,ab.test(a)&&pb(b.parentNode)||b),e},c.sortStable=u.split("").sort(B).join("")===u,c.detectDuplicates=!!l,m(),c.sortDetached=jb(function(a){return 1&a.compareDocumentPosition(n.createElement("div"))}),jb(function(a){return a.innerHTML="<a href='#'></a>","#"===a.firstChild.getAttribute("href")})||kb("type|href|height|width",function(a,b,c){return c?void 0:a.getAttribute(b,"type"===b.toLowerCase()?1:2)}),c.attributes&&jb(function(a){return a.innerHTML="<input/>",a.firstChild.setAttribute("value",""),""===a.firstChild.getAttribute("value")})||kb("value",function(a,b,c){return c||"input"!==a.nodeName.toLowerCase()?void 0:a.defaultValue}),jb(function(a){return null==a.getAttribute("disabled")})||kb(K,function(a,b,c){var d;return c?void 0:a[b]===!0?b.toLowerCase():(d=a.getAttributeNode(b))&&d.specified?d.value:null}),gb}(a);m.find=s,m.expr=s.selectors,m.expr[":"]=m.expr.pseudos,m.unique=s.uniqueSort,m.text=s.getText,m.isXMLDoc=s.isXML,m.contains=s.contains;var t=m.expr.match.needsContext,u=/^<(\w+)\s*\/?>(?:<\/\1>|)$/,v=/^.[^:#\[\.,]*$/;function w(a,b,c){if(m.isFunction(b))return m.grep(a,function(a,d){return!!b.call(a,d,a)!==c});if(b.nodeType)return m.grep(a,function(a){return a===b!==c});if("string"==typeof b){if(v.test(b))return m.filter(b,a,c);b=m.filter(b,a)}return m.grep(a,function(a){return m.inArray(a,b)>=0!==c})}m.filter=function(a,b,c){var d=b[0];return c&&(a=":not("+a+")"),1===b.length&&1===d.nodeType?m.find.matchesSelector(d,a)?[d]:[]:m.find.matches(a,m.grep(b,function(a){return 1===a.nodeType}))},m.fn.extend({find:function(a){var b,c=[],d=this,e=d.length;if("string"!=typeof a)return this.pushStack(m(a).filter(function(){for(b=0;e>b;b++)if(m.contains(d[b],this))return!0}));for(b=0;e>b;b++)m.find(a,d[b],c);return c=this.pushStack(e>1?m.unique(c):c),c.selector=this.selector?this.selector+" "+a:a,c},filter:function(a){return this.pushStack(w(this,a||[],!1))},not:function(a){return this.pushStack(w(this,a||[],!0))},is:function(a){return!!w(this,"string"==typeof a&&t.test(a)?m(a):a||[],!1).length}});var x,y=a.document,z=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]*))$/,A=m.fn.init=function(a,b){var c,d;if(!a)return this;if("string"==typeof a){if(c="<"===a.charAt(0)&&">"===a.charAt(a.length-1)&&a.length>=3?[null,a,null]:z.exec(a),!c||!c[1]&&b)return!b||b.jquery?(b||x).find(a):this.constructor(b).find(a);if(c[1]){if(b=b instanceof m?b[0]:b,m.merge(this,m.parseHTML(c[1],b&&b.nodeType?b.ownerDocument||b:y,!0)),u.test(c[1])&&m.isPlainObject(b))for(c in b)m.isFunction(this[c])?this[c](b[c]):this.attr(c,b[c]);return this}if(d=y.getElementById(c[2]),d&&d.parentNode){if(d.id!==c[2])return x.find(a);this.length=1,this[0]=d}return this.context=y,this.selector=a,this}return a.nodeType?(this.context=this[0]=a,this.length=1,this):m.isFunction(a)?"undefined"!=typeof x.ready?x.ready(a):a(m):(void 0!==a.selector&&(this.selector=a.selector,this.context=a.context),m.makeArray(a,this))};A.prototype=m.fn,x=m(y);var B=/^(?:parents|prev(?:Until|All))/,C={children:!0,contents:!0,next:!0,prev:!0};m.extend({dir:function(a,b,c){var d=[],e=a[b];while(e&&9!==e.nodeType&&(void 0===c||1!==e.nodeType||!m(e).is(c)))1===e.nodeType&&d.push(e),e=e[b];return d},sibling:function(a,b){for(var c=[];a;a=a.nextSibling)1===a.nodeType&&a!==b&&c.push(a);return c}}),m.fn.extend({has:function(a){var b,c=m(a,this),d=c.length;return this.filter(function(){for(b=0;d>b;b++)if(m.contains(this,c[b]))return!0})},closest:function(a,b){for(var c,d=0,e=this.length,f=[],g=t.test(a)||"string"!=typeof a?m(a,b||this.context):0;e>d;d++)for(c=this[d];c&&c!==b;c=c.parentNode)if(c.nodeType<11&&(g?g.index(c)>-1:1===c.nodeType&&m.find.matchesSelector(c,a))){f.push(c);break}return this.pushStack(f.length>1?m.unique(f):f)},index:function(a){return a?"string"==typeof a?m.inArray(this[0],m(a)):m.inArray(a.jquery?a[0]:a,this):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(a,b){return this.pushStack(m.unique(m.merge(this.get(),m(a,b))))},addBack:function(a){return this.add(null==a?this.prevObject:this.prevObject.filter(a))}});function D(a,b){do a=a[b];while(a&&1!==a.nodeType);return a}m.each({parent:function(a){var b=a.parentNode;return b&&11!==b.nodeType?b:null},parents:function(a){return m.dir(a,"parentNode")},parentsUntil:function(a,b,c){return m.dir(a,"parentNode",c)},next:function(a){return D(a,"nextSibling")},prev:function(a){return D(a,"previousSibling")},nextAll:function(a){return m.dir(a,"nextSibling")},prevAll:function(a){return m.dir(a,"previousSibling")},nextUntil:function(a,b,c){return m.dir(a,"nextSibling",c)},prevUntil:function(a,b,c){return m.dir(a,"previousSibling",c)},siblings:function(a){return m.sibling((a.parentNode||{}).firstChild,a)},children:function(a){return m.sibling(a.firstChild)},contents:function(a){return m.nodeName(a,"iframe")?a.contentDocument||a.contentWindow.document:m.merge([],a.childNodes)}},function(a,b){m.fn[a]=function(c,d){var e=m.map(this,b,c);return"Until"!==a.slice(-5)&&(d=c),d&&"string"==typeof d&&(e=m.filter(d,e)),this.length>1&&(C[a]||(e=m.unique(e)),B.test(a)&&(e=e.reverse())),this.pushStack(e)}});var E=/\S+/g,F={};function G(a){var b=F[a]={};return m.each(a.match(E)||[],function(a,c){b[c]=!0}),b}m.Callbacks=function(a){a="string"==typeof a?F[a]||G(a):m.extend({},a);var b,c,d,e,f,g,h=[],i=!a.once&&[],j=function(l){for(c=a.memory&&l,d=!0,f=g||0,g=0,e=h.length,b=!0;h&&e>f;f++)if(h[f].apply(l[0],l[1])===!1&&a.stopOnFalse){c=!1;break}b=!1,h&&(i?i.length&&j(i.shift()):c?h=[]:k.disable())},k={add:function(){if(h){var d=h.length;!function f(b){m.each(b,function(b,c){var d=m.type(c);"function"===d?a.unique&&k.has(c)||h.push(c):c&&c.length&&"string"!==d&&f(c)})}(arguments),b?e=h.length:c&&(g=d,j(c))}return this},remove:function(){return h&&m.each(arguments,function(a,c){var d;while((d=m.inArray(c,h,d))>-1)h.splice(d,1),b&&(e>=d&&e--,f>=d&&f--)}),this},has:function(a){return a?m.inArray(a,h)>-1:!(!h||!h.length)},empty:function(){return h=[],e=0,this},disable:function(){return h=i=c=void 0,this},disabled:function(){return!h},lock:function(){return i=void 0,c||k.disable(),this},locked:function(){return!i},fireWith:function(a,c){return!h||d&&!i||(c=c||[],c=[a,c.slice?c.slice():c],b?i.push(c):j(c)),this},fire:function(){return k.fireWith(this,arguments),this},fired:function(){return!!d}};return k},m.extend({Deferred:function(a){var b=[["resolve","done",m.Callbacks("once memory"),"resolved"],["reject","fail",m.Callbacks("once memory"),"rejected"],["notify","progress",m.Callbacks("memory")]],c="pending",d={state:function(){return c},always:function(){return e.done(arguments).fail(arguments),this},then:function(){var a=arguments;return m.Deferred(function(c){m.each(b,function(b,f){var g=m.isFunction(a[b])&&a[b];e[f[1]](function(){var a=g&&g.apply(this,arguments);a&&m.isFunction(a.promise)?a.promise().done(c.resolve).fail(c.reject).progress(c.notify):c[f[0]+"With"](this===d?c.promise():this,g?[a]:arguments)})}),a=null}).promise()},promise:function(a){return null!=a?m.extend(a,d):d}},e={};return d.pipe=d.then,m.each(b,function(a,f){var g=f[2],h=f[3];d[f[1]]=g.add,h&&g.add(function(){c=h},b[1^a][2].disable,b[2][2].lock),e[f[0]]=function(){return e[f[0]+"With"](this===e?d:this,arguments),this},e[f[0]+"With"]=g.fireWith}),d.promise(e),a&&a.call(e,e),e},when:function(a){var b=0,c=d.call(arguments),e=c.length,f=1!==e||a&&m.isFunction(a.promise)?e:0,g=1===f?a:m.Deferred(),h=function(a,b,c){return function(e){b[a]=this,c[a]=arguments.length>1?d.call(arguments):e,c===i?g.notifyWith(b,c):--f||g.resolveWith(b,c)}},i,j,k;if(e>1)for(i=new Array(e),j=new Array(e),k=new Array(e);e>b;b++)c[b]&&m.isFunction(c[b].promise)?c[b].promise().done(h(b,k,c)).fail(g.reject).progress(h(b,j,i)):--f;return f||g.resolveWith(k,c),g.promise()}});var H;m.fn.ready=function(a){return m.ready.promise().done(a),this},m.extend({isReady:!1,readyWait:1,holdReady:function(a){a?m.readyWait++:m.ready(!0)},ready:function(a){if(a===!0?!--m.readyWait:!m.isReady){if(!y.body)return setTimeout(m.ready);m.isReady=!0,a!==!0&&--m.readyWait>0||(H.resolveWith(y,[m]),m.fn.triggerHandler&&(m(y).triggerHandler("ready"),m(y).off("ready")))}}});function I(){y.addEventListener?(y.removeEventListener("DOMContentLoaded",J,!1),a.removeEventListener("load",J,!1)):(y.detachEvent("onreadystatechange",J),a.detachEvent("onload",J))}function J(){(y.addEventListener||"load"===event.type||"complete"===y.readyState)&&(I(),m.ready())}m.ready.promise=function(b){if(!H)if(H=m.Deferred(),"complete"===y.readyState)setTimeout(m.ready);else if(y.addEventListener)y.addEventListener("DOMContentLoaded",J,!1),a.addEventListener("load",J,!1);else{y.attachEvent("onreadystatechange",J),a.attachEvent("onload",J);var c=!1;try{c=null==a.frameElement&&y.documentElement}catch(d){}c&&c.doScroll&&!function e(){if(!m.isReady){try{c.doScroll("left")}catch(a){return setTimeout(e,50)}I(),m.ready()}}()}return H.promise(b)};var K="undefined",L;for(L in m(k))break;k.ownLast="0"!==L,k.inlineBlockNeedsLayout=!1,m(function(){var a,b,c,d;c=y.getElementsByTagName("body")[0],c&&c.style&&(b=y.createElement("div"),d=y.createElement("div"),d.style.cssText="position:absolute;border:0;width:0;height:0;top:0;left:-9999px",c.appendChild(d).appendChild(b),typeof b.style.zoom!==K&&(b.style.cssText="display:inline;margin:0;border:0;padding:1px;width:1px;zoom:1",k.inlineBlockNeedsLayout=a=3===b.offsetWidth,a&&(c.style.zoom=1)),c.removeChild(d))}),function(){var a=y.createElement("div");if(null==k.deleteExpando){k.deleteExpando=!0;try{delete a.test}catch(b){k.deleteExpando=!1}}a=null}(),m.acceptData=function(a){var b=m.noData[(a.nodeName+" ").toLowerCase()],c=+a.nodeType||1;return 1!==c&&9!==c?!1:!b||b!==!0&&a.getAttribute("classid")===b};var M=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,N=/([A-Z])/g;function O(a,b,c){if(void 0===c&&1===a.nodeType){var d="data-"+b.replace(N,"-$1").toLowerCase();if(c=a.getAttribute(d),"string"==typeof c){try{c="true"===c?!0:"false"===c?!1:"null"===c?null:+c+""===c?+c:M.test(c)?m.parseJSON(c):c}catch(e){}m.data(a,b,c)}else c=void 0}return c}function P(a){var b;for(b in a)if(("data"!==b||!m.isEmptyObject(a[b]))&&"toJSON"!==b)return!1;
return!0}function Q(a,b,d,e){if(m.acceptData(a)){var f,g,h=m.expando,i=a.nodeType,j=i?m.cache:a,k=i?a[h]:a[h]&&h;if(k&&j[k]&&(e||j[k].data)||void 0!==d||"string"!=typeof b)return k||(k=i?a[h]=c.pop()||m.guid++:h),j[k]||(j[k]=i?{}:{toJSON:m.noop}),("object"==typeof b||"function"==typeof b)&&(e?j[k]=m.extend(j[k],b):j[k].data=m.extend(j[k].data,b)),g=j[k],e||(g.data||(g.data={}),g=g.data),void 0!==d&&(g[m.camelCase(b)]=d),"string"==typeof b?(f=g[b],null==f&&(f=g[m.camelCase(b)])):f=g,f}}function R(a,b,c){if(m.acceptData(a)){var d,e,f=a.nodeType,g=f?m.cache:a,h=f?a[m.expando]:m.expando;if(g[h]){if(b&&(d=c?g[h]:g[h].data)){m.isArray(b)?b=b.concat(m.map(b,m.camelCase)):b in d?b=[b]:(b=m.camelCase(b),b=b in d?[b]:b.split(" ")),e=b.length;while(e--)delete d[b[e]];if(c?!P(d):!m.isEmptyObject(d))return}(c||(delete g[h].data,P(g[h])))&&(f?m.cleanData([a],!0):k.deleteExpando||g!=g.window?delete g[h]:g[h]=null)}}}m.extend({cache:{},noData:{"applet ":!0,"embed ":!0,"object ":"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"},hasData:function(a){return a=a.nodeType?m.cache[a[m.expando]]:a[m.expando],!!a&&!P(a)},data:function(a,b,c){return Q(a,b,c)},removeData:function(a,b){return R(a,b)},_data:function(a,b,c){return Q(a,b,c,!0)},_removeData:function(a,b){return R(a,b,!0)}}),m.fn.extend({data:function(a,b){var c,d,e,f=this[0],g=f&&f.attributes;if(void 0===a){if(this.length&&(e=m.data(f),1===f.nodeType&&!m._data(f,"parsedAttrs"))){c=g.length;while(c--)g[c]&&(d=g[c].name,0===d.indexOf("data-")&&(d=m.camelCase(d.slice(5)),O(f,d,e[d])));m._data(f,"parsedAttrs",!0)}return e}return"object"==typeof a?this.each(function(){m.data(this,a)}):arguments.length>1?this.each(function(){m.data(this,a,b)}):f?O(f,a,m.data(f,a)):void 0},removeData:function(a){return this.each(function(){m.removeData(this,a)})}}),m.extend({queue:function(a,b,c){var d;return a?(b=(b||"fx")+"queue",d=m._data(a,b),c&&(!d||m.isArray(c)?d=m._data(a,b,m.makeArray(c)):d.push(c)),d||[]):void 0},dequeue:function(a,b){b=b||"fx";var c=m.queue(a,b),d=c.length,e=c.shift(),f=m._queueHooks(a,b),g=function(){m.dequeue(a,b)};"inprogress"===e&&(e=c.shift(),d--),e&&("fx"===b&&c.unshift("inprogress"),delete f.stop,e.call(a,g,f)),!d&&f&&f.empty.fire()},_queueHooks:function(a,b){var c=b+"queueHooks";return m._data(a,c)||m._data(a,c,{empty:m.Callbacks("once memory").add(function(){m._removeData(a,b+"queue"),m._removeData(a,c)})})}}),m.fn.extend({queue:function(a,b){var c=2;return"string"!=typeof a&&(b=a,a="fx",c--),arguments.length<c?m.queue(this[0],a):void 0===b?this:this.each(function(){var c=m.queue(this,a,b);m._queueHooks(this,a),"fx"===a&&"inprogress"!==c[0]&&m.dequeue(this,a)})},dequeue:function(a){return this.each(function(){m.dequeue(this,a)})},clearQueue:function(a){return this.queue(a||"fx",[])},promise:function(a,b){var c,d=1,e=m.Deferred(),f=this,g=this.length,h=function(){--d||e.resolveWith(f,[f])};"string"!=typeof a&&(b=a,a=void 0),a=a||"fx";while(g--)c=m._data(f[g],a+"queueHooks"),c&&c.empty&&(d++,c.empty.add(h));return h(),e.promise(b)}});var S=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,T=["Top","Right","Bottom","Left"],U=function(a,b){return a=b||a,"none"===m.css(a,"display")||!m.contains(a.ownerDocument,a)},V=m.access=function(a,b,c,d,e,f,g){var h=0,i=a.length,j=null==c;if("object"===m.type(c)){e=!0;for(h in c)m.access(a,b,h,c[h],!0,f,g)}else if(void 0!==d&&(e=!0,m.isFunction(d)||(g=!0),j&&(g?(b.call(a,d),b=null):(j=b,b=function(a,b,c){return j.call(m(a),c)})),b))for(;i>h;h++)b(a[h],c,g?d:d.call(a[h],h,b(a[h],c)));return e?a:j?b.call(a):i?b(a[0],c):f},W=/^(?:checkbox|radio)$/i;!function(){var a=y.createElement("input"),b=y.createElement("div"),c=y.createDocumentFragment();if(b.innerHTML="  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>",k.leadingWhitespace=3===b.firstChild.nodeType,k.tbody=!b.getElementsByTagName("tbody").length,k.htmlSerialize=!!b.getElementsByTagName("link").length,k.html5Clone="<:nav></:nav>"!==y.createElement("nav").cloneNode(!0).outerHTML,a.type="checkbox",a.checked=!0,c.appendChild(a),k.appendChecked=a.checked,b.innerHTML="<textarea>x</textarea>",k.noCloneChecked=!!b.cloneNode(!0).lastChild.defaultValue,c.appendChild(b),b.innerHTML="<input type='radio' checked='checked' name='t'/>",k.checkClone=b.cloneNode(!0).cloneNode(!0).lastChild.checked,k.noCloneEvent=!0,b.attachEvent&&(b.attachEvent("onclick",function(){k.noCloneEvent=!1}),b.cloneNode(!0).click()),null==k.deleteExpando){k.deleteExpando=!0;try{delete b.test}catch(d){k.deleteExpando=!1}}}(),function(){var b,c,d=y.createElement("div");for(b in{submit:!0,change:!0,focusin:!0})c="on"+b,(k[b+"Bubbles"]=c in a)||(d.setAttribute(c,"t"),k[b+"Bubbles"]=d.attributes[c].expando===!1);d=null}();var X=/^(?:input|select|textarea)$/i,Y=/^key/,Z=/^(?:mouse|pointer|contextmenu)|click/,$=/^(?:focusinfocus|focusoutblur)$/,_=/^([^.]*)(?:\.(.+)|)$/;function ab(){return!0}function bb(){return!1}function cb(){try{return y.activeElement}catch(a){}}m.event={global:{},add:function(a,b,c,d,e){var f,g,h,i,j,k,l,n,o,p,q,r=m._data(a);if(r){c.handler&&(i=c,c=i.handler,e=i.selector),c.guid||(c.guid=m.guid++),(g=r.events)||(g=r.events={}),(k=r.handle)||(k=r.handle=function(a){return typeof m===K||a&&m.event.triggered===a.type?void 0:m.event.dispatch.apply(k.elem,arguments)},k.elem=a),b=(b||"").match(E)||[""],h=b.length;while(h--)f=_.exec(b[h])||[],o=q=f[1],p=(f[2]||"").split(".").sort(),o&&(j=m.event.special[o]||{},o=(e?j.delegateType:j.bindType)||o,j=m.event.special[o]||{},l=m.extend({type:o,origType:q,data:d,handler:c,guid:c.guid,selector:e,needsContext:e&&m.expr.match.needsContext.test(e),namespace:p.join(".")},i),(n=g[o])||(n=g[o]=[],n.delegateCount=0,j.setup&&j.setup.call(a,d,p,k)!==!1||(a.addEventListener?a.addEventListener(o,k,!1):a.attachEvent&&a.attachEvent("on"+o,k))),j.add&&(j.add.call(a,l),l.handler.guid||(l.handler.guid=c.guid)),e?n.splice(n.delegateCount++,0,l):n.push(l),m.event.global[o]=!0);a=null}},remove:function(a,b,c,d,e){var f,g,h,i,j,k,l,n,o,p,q,r=m.hasData(a)&&m._data(a);if(r&&(k=r.events)){b=(b||"").match(E)||[""],j=b.length;while(j--)if(h=_.exec(b[j])||[],o=q=h[1],p=(h[2]||"").split(".").sort(),o){l=m.event.special[o]||{},o=(d?l.delegateType:l.bindType)||o,n=k[o]||[],h=h[2]&&new RegExp("(^|\\.)"+p.join("\\.(?:.*\\.|)")+"(\\.|$)"),i=f=n.length;while(f--)g=n[f],!e&&q!==g.origType||c&&c.guid!==g.guid||h&&!h.test(g.namespace)||d&&d!==g.selector&&("**"!==d||!g.selector)||(n.splice(f,1),g.selector&&n.delegateCount--,l.remove&&l.remove.call(a,g));i&&!n.length&&(l.teardown&&l.teardown.call(a,p,r.handle)!==!1||m.removeEvent(a,o,r.handle),delete k[o])}else for(o in k)m.event.remove(a,o+b[j],c,d,!0);m.isEmptyObject(k)&&(delete r.handle,m._removeData(a,"events"))}},trigger:function(b,c,d,e){var f,g,h,i,k,l,n,o=[d||y],p=j.call(b,"type")?b.type:b,q=j.call(b,"namespace")?b.namespace.split("."):[];if(h=l=d=d||y,3!==d.nodeType&&8!==d.nodeType&&!$.test(p+m.event.triggered)&&(p.indexOf(".")>=0&&(q=p.split("."),p=q.shift(),q.sort()),g=p.indexOf(":")<0&&"on"+p,b=b[m.expando]?b:new m.Event(p,"object"==typeof b&&b),b.isTrigger=e?2:3,b.namespace=q.join("."),b.namespace_re=b.namespace?new RegExp("(^|\\.)"+q.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,b.result=void 0,b.target||(b.target=d),c=null==c?[b]:m.makeArray(c,[b]),k=m.event.special[p]||{},e||!k.trigger||k.trigger.apply(d,c)!==!1)){if(!e&&!k.noBubble&&!m.isWindow(d)){for(i=k.delegateType||p,$.test(i+p)||(h=h.parentNode);h;h=h.parentNode)o.push(h),l=h;l===(d.ownerDocument||y)&&o.push(l.defaultView||l.parentWindow||a)}n=0;while((h=o[n++])&&!b.isPropagationStopped())b.type=n>1?i:k.bindType||p,f=(m._data(h,"events")||{})[b.type]&&m._data(h,"handle"),f&&f.apply(h,c),f=g&&h[g],f&&f.apply&&m.acceptData(h)&&(b.result=f.apply(h,c),b.result===!1&&b.preventDefault());if(b.type=p,!e&&!b.isDefaultPrevented()&&(!k._default||k._default.apply(o.pop(),c)===!1)&&m.acceptData(d)&&g&&d[p]&&!m.isWindow(d)){l=d[g],l&&(d[g]=null),m.event.triggered=p;try{d[p]()}catch(r){}m.event.triggered=void 0,l&&(d[g]=l)}return b.result}},dispatch:function(a){a=m.event.fix(a);var b,c,e,f,g,h=[],i=d.call(arguments),j=(m._data(this,"events")||{})[a.type]||[],k=m.event.special[a.type]||{};if(i[0]=a,a.delegateTarget=this,!k.preDispatch||k.preDispatch.call(this,a)!==!1){h=m.event.handlers.call(this,a,j),b=0;while((f=h[b++])&&!a.isPropagationStopped()){a.currentTarget=f.elem,g=0;while((e=f.handlers[g++])&&!a.isImmediatePropagationStopped())(!a.namespace_re||a.namespace_re.test(e.namespace))&&(a.handleObj=e,a.data=e.data,c=((m.event.special[e.origType]||{}).handle||e.handler).apply(f.elem,i),void 0!==c&&(a.result=c)===!1&&(a.preventDefault(),a.stopPropagation()))}return k.postDispatch&&k.postDispatch.call(this,a),a.result}},handlers:function(a,b){var c,d,e,f,g=[],h=b.delegateCount,i=a.target;if(h&&i.nodeType&&(!a.button||"click"!==a.type))for(;i!=this;i=i.parentNode||this)if(1===i.nodeType&&(i.disabled!==!0||"click"!==a.type)){for(e=[],f=0;h>f;f++)d=b[f],c=d.selector+" ",void 0===e[c]&&(e[c]=d.needsContext?m(c,this).index(i)>=0:m.find(c,this,null,[i]).length),e[c]&&e.push(d);e.length&&g.push({elem:i,handlers:e})}return h<b.length&&g.push({elem:this,handlers:b.slice(h)}),g},fix:function(a){if(a[m.expando])return a;var b,c,d,e=a.type,f=a,g=this.fixHooks[e];g||(this.fixHooks[e]=g=Z.test(e)?this.mouseHooks:Y.test(e)?this.keyHooks:{}),d=g.props?this.props.concat(g.props):this.props,a=new m.Event(f),b=d.length;while(b--)c=d[b],a[c]=f[c];return a.target||(a.target=f.srcElement||y),3===a.target.nodeType&&(a.target=a.target.parentNode),a.metaKey=!!a.metaKey,g.filter?g.filter(a,f):a},props:"altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),fixHooks:{},keyHooks:{props:"char charCode key keyCode".split(" "),filter:function(a,b){return null==a.which&&(a.which=null!=b.charCode?b.charCode:b.keyCode),a}},mouseHooks:{props:"button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" "),filter:function(a,b){var c,d,e,f=b.button,g=b.fromElement;return null==a.pageX&&null!=b.clientX&&(d=a.target.ownerDocument||y,e=d.documentElement,c=d.body,a.pageX=b.clientX+(e&&e.scrollLeft||c&&c.scrollLeft||0)-(e&&e.clientLeft||c&&c.clientLeft||0),a.pageY=b.clientY+(e&&e.scrollTop||c&&c.scrollTop||0)-(e&&e.clientTop||c&&c.clientTop||0)),!a.relatedTarget&&g&&(a.relatedTarget=g===a.target?b.toElement:g),a.which||void 0===f||(a.which=1&f?1:2&f?3:4&f?2:0),a}},special:{load:{noBubble:!0},focus:{trigger:function(){if(this!==cb()&&this.focus)try{return this.focus(),!1}catch(a){}},delegateType:"focusin"},blur:{trigger:function(){return this===cb()&&this.blur?(this.blur(),!1):void 0},delegateType:"focusout"},click:{trigger:function(){return m.nodeName(this,"input")&&"checkbox"===this.type&&this.click?(this.click(),!1):void 0},_default:function(a){return m.nodeName(a.target,"a")}},beforeunload:{postDispatch:function(a){void 0!==a.result&&a.originalEvent&&(a.originalEvent.returnValue=a.result)}}},simulate:function(a,b,c,d){var e=m.extend(new m.Event,c,{type:a,isSimulated:!0,originalEvent:{}});d?m.event.trigger(e,null,b):m.event.dispatch.call(b,e),e.isDefaultPrevented()&&c.preventDefault()}},m.removeEvent=y.removeEventListener?function(a,b,c){a.removeEventListener&&a.removeEventListener(b,c,!1)}:function(a,b,c){var d="on"+b;a.detachEvent&&(typeof a[d]===K&&(a[d]=null),a.detachEvent(d,c))},m.Event=function(a,b){return this instanceof m.Event?(a&&a.type?(this.originalEvent=a,this.type=a.type,this.isDefaultPrevented=a.defaultPrevented||void 0===a.defaultPrevented&&a.returnValue===!1?ab:bb):this.type=a,b&&m.extend(this,b),this.timeStamp=a&&a.timeStamp||m.now(),void(this[m.expando]=!0)):new m.Event(a,b)},m.Event.prototype={isDefaultPrevented:bb,isPropagationStopped:bb,isImmediatePropagationStopped:bb,preventDefault:function(){var a=this.originalEvent;this.isDefaultPrevented=ab,a&&(a.preventDefault?a.preventDefault():a.returnValue=!1)},stopPropagation:function(){var a=this.originalEvent;this.isPropagationStopped=ab,a&&(a.stopPropagation&&a.stopPropagation(),a.cancelBubble=!0)},stopImmediatePropagation:function(){var a=this.originalEvent;this.isImmediatePropagationStopped=ab,a&&a.stopImmediatePropagation&&a.stopImmediatePropagation(),this.stopPropagation()}},m.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(a,b){m.event.special[a]={delegateType:b,bindType:b,handle:function(a){var c,d=this,e=a.relatedTarget,f=a.handleObj;return(!e||e!==d&&!m.contains(d,e))&&(a.type=f.origType,c=f.handler.apply(this,arguments),a.type=b),c}}}),k.submitBubbles||(m.event.special.submit={setup:function(){return m.nodeName(this,"form")?!1:void m.event.add(this,"click._submit keypress._submit",function(a){var b=a.target,c=m.nodeName(b,"input")||m.nodeName(b,"button")?b.form:void 0;c&&!m._data(c,"submitBubbles")&&(m.event.add(c,"submit._submit",function(a){a._submit_bubble=!0}),m._data(c,"submitBubbles",!0))})},postDispatch:function(a){a._submit_bubble&&(delete a._submit_bubble,this.parentNode&&!a.isTrigger&&m.event.simulate("submit",this.parentNode,a,!0))},teardown:function(){return m.nodeName(this,"form")?!1:void m.event.remove(this,"._submit")}}),k.changeBubbles||(m.event.special.change={setup:function(){return X.test(this.nodeName)?(("checkbox"===this.type||"radio"===this.type)&&(m.event.add(this,"propertychange._change",function(a){"checked"===a.originalEvent.propertyName&&(this._just_changed=!0)}),m.event.add(this,"click._change",function(a){this._just_changed&&!a.isTrigger&&(this._just_changed=!1),m.event.simulate("change",this,a,!0)})),!1):void m.event.add(this,"beforeactivate._change",function(a){var b=a.target;X.test(b.nodeName)&&!m._data(b,"changeBubbles")&&(m.event.add(b,"change._change",function(a){!this.parentNode||a.isSimulated||a.isTrigger||m.event.simulate("change",this.parentNode,a,!0)}),m._data(b,"changeBubbles",!0))})},handle:function(a){var b=a.target;return this!==b||a.isSimulated||a.isTrigger||"radio"!==b.type&&"checkbox"!==b.type?a.handleObj.handler.apply(this,arguments):void 0},teardown:function(){return m.event.remove(this,"._change"),!X.test(this.nodeName)}}),k.focusinBubbles||m.each({focus:"focusin",blur:"focusout"},function(a,b){var c=function(a){m.event.simulate(b,a.target,m.event.fix(a),!0)};m.event.special[b]={setup:function(){var d=this.ownerDocument||this,e=m._data(d,b);e||d.addEventListener(a,c,!0),m._data(d,b,(e||0)+1)},teardown:function(){var d=this.ownerDocument||this,e=m._data(d,b)-1;e?m._data(d,b,e):(d.removeEventListener(a,c,!0),m._removeData(d,b))}}}),m.fn.extend({on:function(a,b,c,d,e){var f,g;if("object"==typeof a){"string"!=typeof b&&(c=c||b,b=void 0);for(f in a)this.on(f,b,c,a[f],e);return this}if(null==c&&null==d?(d=b,c=b=void 0):null==d&&("string"==typeof b?(d=c,c=void 0):(d=c,c=b,b=void 0)),d===!1)d=bb;else if(!d)return this;return 1===e&&(g=d,d=function(a){return m().off(a),g.apply(this,arguments)},d.guid=g.guid||(g.guid=m.guid++)),this.each(function(){m.event.add(this,a,d,c,b)})},one:function(a,b,c,d){return this.on(a,b,c,d,1)},off:function(a,b,c){var d,e;if(a&&a.preventDefault&&a.handleObj)return d=a.handleObj,m(a.delegateTarget).off(d.namespace?d.origType+"."+d.namespace:d.origType,d.selector,d.handler),this;if("object"==typeof a){for(e in a)this.off(e,b,a[e]);return this}return(b===!1||"function"==typeof b)&&(c=b,b=void 0),c===!1&&(c=bb),this.each(function(){m.event.remove(this,a,c,b)})},trigger:function(a,b){return this.each(function(){m.event.trigger(a,b,this)})},triggerHandler:function(a,b){var c=this[0];return c?m.event.trigger(a,b,c,!0):void 0}});function db(a){var b=eb.split("|"),c=a.createDocumentFragment();if(c.createElement)while(b.length)c.createElement(b.pop());return c}var eb="abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|header|hgroup|mark|meter|nav|output|progress|section|summary|time|video",fb=/ jQuery\d+="(?:null|\d+)"/g,gb=new RegExp("<(?:"+eb+")[\\s/>]","i"),hb=/^\s+/,ib=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,jb=/<([\w:]+)/,kb=/<tbody/i,lb=/<|&#?\w+;/,mb=/<(?:script|style|link)/i,nb=/checked\s*(?:[^=]|=\s*.checked.)/i,ob=/^$|\/(?:java|ecma)script/i,pb=/^true\/(.*)/,qb=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g,rb={option:[1,"<select multiple='multiple'>","</select>"],legend:[1,"<fieldset>","</fieldset>"],area:[1,"<map>","</map>"],param:[1,"<object>","</object>"],thead:[1,"<table>","</table>"],tr:[2,"<table><tbody>","</tbody></table>"],col:[2,"<table><tbody></tbody><colgroup>","</colgroup></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:k.htmlSerialize?[0,"",""]:[1,"X<div>","</div>"]},sb=db(y),tb=sb.appendChild(y.createElement("div"));rb.optgroup=rb.option,rb.tbody=rb.tfoot=rb.colgroup=rb.caption=rb.thead,rb.th=rb.td;function ub(a,b){var c,d,e=0,f=typeof a.getElementsByTagName!==K?a.getElementsByTagName(b||"*"):typeof a.querySelectorAll!==K?a.querySelectorAll(b||"*"):void 0;if(!f)for(f=[],c=a.childNodes||a;null!=(d=c[e]);e++)!b||m.nodeName(d,b)?f.push(d):m.merge(f,ub(d,b));return void 0===b||b&&m.nodeName(a,b)?m.merge([a],f):f}function vb(a){W.test(a.type)&&(a.defaultChecked=a.checked)}function wb(a,b){return m.nodeName(a,"table")&&m.nodeName(11!==b.nodeType?b:b.firstChild,"tr")?a.getElementsByTagName("tbody")[0]||a.appendChild(a.ownerDocument.createElement("tbody")):a}function xb(a){return a.type=(null!==m.find.attr(a,"type"))+"/"+a.type,a}function yb(a){var b=pb.exec(a.type);return b?a.type=b[1]:a.removeAttribute("type"),a}function zb(a,b){for(var c,d=0;null!=(c=a[d]);d++)m._data(c,"globalEval",!b||m._data(b[d],"globalEval"))}function Ab(a,b){if(1===b.nodeType&&m.hasData(a)){var c,d,e,f=m._data(a),g=m._data(b,f),h=f.events;if(h){delete g.handle,g.events={};for(c in h)for(d=0,e=h[c].length;e>d;d++)m.event.add(b,c,h[c][d])}g.data&&(g.data=m.extend({},g.data))}}function Bb(a,b){var c,d,e;if(1===b.nodeType){if(c=b.nodeName.toLowerCase(),!k.noCloneEvent&&b[m.expando]){e=m._data(b);for(d in e.events)m.removeEvent(b,d,e.handle);b.removeAttribute(m.expando)}"script"===c&&b.text!==a.text?(xb(b).text=a.text,yb(b)):"object"===c?(b.parentNode&&(b.outerHTML=a.outerHTML),k.html5Clone&&a.innerHTML&&!m.trim(b.innerHTML)&&(b.innerHTML=a.innerHTML)):"input"===c&&W.test(a.type)?(b.defaultChecked=b.checked=a.checked,b.value!==a.value&&(b.value=a.value)):"option"===c?b.defaultSelected=b.selected=a.defaultSelected:("input"===c||"textarea"===c)&&(b.defaultValue=a.defaultValue)}}m.extend({clone:function(a,b,c){var d,e,f,g,h,i=m.contains(a.ownerDocument,a);if(k.html5Clone||m.isXMLDoc(a)||!gb.test("<"+a.nodeName+">")?f=a.cloneNode(!0):(tb.innerHTML=a.outerHTML,tb.removeChild(f=tb.firstChild)),!(k.noCloneEvent&&k.noCloneChecked||1!==a.nodeType&&11!==a.nodeType||m.isXMLDoc(a)))for(d=ub(f),h=ub(a),g=0;null!=(e=h[g]);++g)d[g]&&Bb(e,d[g]);if(b)if(c)for(h=h||ub(a),d=d||ub(f),g=0;null!=(e=h[g]);g++)Ab(e,d[g]);else Ab(a,f);return d=ub(f,"script"),d.length>0&&zb(d,!i&&ub(a,"script")),d=h=e=null,f},buildFragment:function(a,b,c,d){for(var e,f,g,h,i,j,l,n=a.length,o=db(b),p=[],q=0;n>q;q++)if(f=a[q],f||0===f)if("object"===m.type(f))m.merge(p,f.nodeType?[f]:f);else if(lb.test(f)){h=h||o.appendChild(b.createElement("div")),i=(jb.exec(f)||["",""])[1].toLowerCase(),l=rb[i]||rb._default,h.innerHTML=l[1]+f.replace(ib,"<$1></$2>")+l[2],e=l[0];while(e--)h=h.lastChild;if(!k.leadingWhitespace&&hb.test(f)&&p.push(b.createTextNode(hb.exec(f)[0])),!k.tbody){f="table"!==i||kb.test(f)?"<table>"!==l[1]||kb.test(f)?0:h:h.firstChild,e=f&&f.childNodes.length;while(e--)m.nodeName(j=f.childNodes[e],"tbody")&&!j.childNodes.length&&f.removeChild(j)}m.merge(p,h.childNodes),h.textContent="";while(h.firstChild)h.removeChild(h.firstChild);h=o.lastChild}else p.push(b.createTextNode(f));h&&o.removeChild(h),k.appendChecked||m.grep(ub(p,"input"),vb),q=0;while(f=p[q++])if((!d||-1===m.inArray(f,d))&&(g=m.contains(f.ownerDocument,f),h=ub(o.appendChild(f),"script"),g&&zb(h),c)){e=0;while(f=h[e++])ob.test(f.type||"")&&c.push(f)}return h=null,o},cleanData:function(a,b){for(var d,e,f,g,h=0,i=m.expando,j=m.cache,l=k.deleteExpando,n=m.event.special;null!=(d=a[h]);h++)if((b||m.acceptData(d))&&(f=d[i],g=f&&j[f])){if(g.events)for(e in g.events)n[e]?m.event.remove(d,e):m.removeEvent(d,e,g.handle);j[f]&&(delete j[f],l?delete d[i]:typeof d.removeAttribute!==K?d.removeAttribute(i):d[i]=null,c.push(f))}}}),m.fn.extend({text:function(a){return V(this,function(a){return void 0===a?m.text(this):this.empty().append((this[0]&&this[0].ownerDocument||y).createTextNode(a))},null,a,arguments.length)},append:function(){return this.domManip(arguments,function(a){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var b=wb(this,a);b.appendChild(a)}})},prepend:function(){return this.domManip(arguments,function(a){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var b=wb(this,a);b.insertBefore(a,b.firstChild)}})},before:function(){return this.domManip(arguments,function(a){this.parentNode&&this.parentNode.insertBefore(a,this)})},after:function(){return this.domManip(arguments,function(a){this.parentNode&&this.parentNode.insertBefore(a,this.nextSibling)})},remove:function(a,b){for(var c,d=a?m.filter(a,this):this,e=0;null!=(c=d[e]);e++)b||1!==c.nodeType||m.cleanData(ub(c)),c.parentNode&&(b&&m.contains(c.ownerDocument,c)&&zb(ub(c,"script")),c.parentNode.removeChild(c));return this},empty:function(){for(var a,b=0;null!=(a=this[b]);b++){1===a.nodeType&&m.cleanData(ub(a,!1));while(a.firstChild)a.removeChild(a.firstChild);a.options&&m.nodeName(a,"select")&&(a.options.length=0)}return this},clone:function(a,b){return a=null==a?!1:a,b=null==b?a:b,this.map(function(){return m.clone(this,a,b)})},html:function(a){return V(this,function(a){var b=this[0]||{},c=0,d=this.length;if(void 0===a)return 1===b.nodeType?b.innerHTML.replace(fb,""):void 0;if(!("string"!=typeof a||mb.test(a)||!k.htmlSerialize&&gb.test(a)||!k.leadingWhitespace&&hb.test(a)||rb[(jb.exec(a)||["",""])[1].toLowerCase()])){a=a.replace(ib,"<$1></$2>");try{for(;d>c;c++)b=this[c]||{},1===b.nodeType&&(m.cleanData(ub(b,!1)),b.innerHTML=a);b=0}catch(e){}}b&&this.empty().append(a)},null,a,arguments.length)},replaceWith:function(){var a=arguments[0];return this.domManip(arguments,function(b){a=this.parentNode,m.cleanData(ub(this)),a&&a.replaceChild(b,this)}),a&&(a.length||a.nodeType)?this:this.remove()},detach:function(a){return this.remove(a,!0)},domManip:function(a,b){a=e.apply([],a);var c,d,f,g,h,i,j=0,l=this.length,n=this,o=l-1,p=a[0],q=m.isFunction(p);if(q||l>1&&"string"==typeof p&&!k.checkClone&&nb.test(p))return this.each(function(c){var d=n.eq(c);q&&(a[0]=p.call(this,c,d.html())),d.domManip(a,b)});if(l&&(i=m.buildFragment(a,this[0].ownerDocument,!1,this),c=i.firstChild,1===i.childNodes.length&&(i=c),c)){for(g=m.map(ub(i,"script"),xb),f=g.length;l>j;j++)d=i,j!==o&&(d=m.clone(d,!0,!0),f&&m.merge(g,ub(d,"script"))),b.call(this[j],d,j);if(f)for(h=g[g.length-1].ownerDocument,m.map(g,yb),j=0;f>j;j++)d=g[j],ob.test(d.type||"")&&!m._data(d,"globalEval")&&m.contains(h,d)&&(d.src?m._evalUrl&&m._evalUrl(d.src):m.globalEval((d.text||d.textContent||d.innerHTML||"").replace(qb,"")));i=c=null}return this}}),m.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(a,b){m.fn[a]=function(a){for(var c,d=0,e=[],g=m(a),h=g.length-1;h>=d;d++)c=d===h?this:this.clone(!0),m(g[d])[b](c),f.apply(e,c.get());return this.pushStack(e)}});var Cb,Db={};function Eb(b,c){var d,e=m(c.createElement(b)).appendTo(c.body),f=a.getDefaultComputedStyle&&(d=a.getDefaultComputedStyle(e[0]))?d.display:m.css(e[0],"display");return e.detach(),f}function Fb(a){var b=y,c=Db[a];return c||(c=Eb(a,b),"none"!==c&&c||(Cb=(Cb||m("<iframe frameborder='0' width='0' height='0'/>")).appendTo(b.documentElement),b=(Cb[0].contentWindow||Cb[0].contentDocument).document,b.write(),b.close(),c=Eb(a,b),Cb.detach()),Db[a]=c),c}!function(){var a;k.shrinkWrapBlocks=function(){if(null!=a)return a;a=!1;var b,c,d;return c=y.getElementsByTagName("body")[0],c&&c.style?(b=y.createElement("div"),d=y.createElement("div"),d.style.cssText="position:absolute;border:0;width:0;height:0;top:0;left:-9999px",c.appendChild(d).appendChild(b),typeof b.style.zoom!==K&&(b.style.cssText="-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;display:block;margin:0;border:0;padding:1px;width:1px;zoom:1",b.appendChild(y.createElement("div")).style.width="5px",a=3!==b.offsetWidth),c.removeChild(d),a):void 0}}();var Gb=/^margin/,Hb=new RegExp("^("+S+")(?!px)[a-z%]+$","i"),Ib,Jb,Kb=/^(top|right|bottom|left)$/;a.getComputedStyle?(Ib=function(b){return b.ownerDocument.defaultView.opener?b.ownerDocument.defaultView.getComputedStyle(b,null):a.getComputedStyle(b,null)},Jb=function(a,b,c){var d,e,f,g,h=a.style;return c=c||Ib(a),g=c?c.getPropertyValue(b)||c[b]:void 0,c&&(""!==g||m.contains(a.ownerDocument,a)||(g=m.style(a,b)),Hb.test(g)&&Gb.test(b)&&(d=h.width,e=h.minWidth,f=h.maxWidth,h.minWidth=h.maxWidth=h.width=g,g=c.width,h.width=d,h.minWidth=e,h.maxWidth=f)),void 0===g?g:g+""}):y.documentElement.currentStyle&&(Ib=function(a){return a.currentStyle},Jb=function(a,b,c){var d,e,f,g,h=a.style;return c=c||Ib(a),g=c?c[b]:void 0,null==g&&h&&h[b]&&(g=h[b]),Hb.test(g)&&!Kb.test(b)&&(d=h.left,e=a.runtimeStyle,f=e&&e.left,f&&(e.left=a.currentStyle.left),h.left="fontSize"===b?"1em":g,g=h.pixelLeft+"px",h.left=d,f&&(e.left=f)),void 0===g?g:g+""||"auto"});function Lb(a,b){return{get:function(){var c=a();if(null!=c)return c?void delete this.get:(this.get=b).apply(this,arguments)}}}!function(){var b,c,d,e,f,g,h;if(b=y.createElement("div"),b.innerHTML="  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>",d=b.getElementsByTagName("a")[0],c=d&&d.style){c.cssText="float:left;opacity:.5",k.opacity="0.5"===c.opacity,k.cssFloat=!!c.cssFloat,b.style.backgroundClip="content-box",b.cloneNode(!0).style.backgroundClip="",k.clearCloneStyle="content-box"===b.style.backgroundClip,k.boxSizing=""===c.boxSizing||""===c.MozBoxSizing||""===c.WebkitBoxSizing,m.extend(k,{reliableHiddenOffsets:function(){return null==g&&i(),g},boxSizingReliable:function(){return null==f&&i(),f},pixelPosition:function(){return null==e&&i(),e},reliableMarginRight:function(){return null==h&&i(),h}});function i(){var b,c,d,i;c=y.getElementsByTagName("body")[0],c&&c.style&&(b=y.createElement("div"),d=y.createElement("div"),d.style.cssText="position:absolute;border:0;width:0;height:0;top:0;left:-9999px",c.appendChild(d).appendChild(b),b.style.cssText="-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;display:block;margin-top:1%;top:1%;border:1px;padding:1px;width:4px;position:absolute",e=f=!1,h=!0,a.getComputedStyle&&(e="1%"!==(a.getComputedStyle(b,null)||{}).top,f="4px"===(a.getComputedStyle(b,null)||{width:"4px"}).width,i=b.appendChild(y.createElement("div")),i.style.cssText=b.style.cssText="-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;display:block;margin:0;border:0;padding:0",i.style.marginRight=i.style.width="0",b.style.width="1px",h=!parseFloat((a.getComputedStyle(i,null)||{}).marginRight),b.removeChild(i)),b.innerHTML="<table><tr><td></td><td>t</td></tr></table>",i=b.getElementsByTagName("td"),i[0].style.cssText="margin:0;border:0;padding:0;display:none",g=0===i[0].offsetHeight,g&&(i[0].style.display="",i[1].style.display="none",g=0===i[0].offsetHeight),c.removeChild(d))}}}(),m.swap=function(a,b,c,d){var e,f,g={};for(f in b)g[f]=a.style[f],a.style[f]=b[f];e=c.apply(a,d||[]);for(f in b)a.style[f]=g[f];return e};var Mb=/alpha\([^)]*\)/i,Nb=/opacity\s*=\s*([^)]*)/,Ob=/^(none|table(?!-c[ea]).+)/,Pb=new RegExp("^("+S+")(.*)$","i"),Qb=new RegExp("^([+-])=("+S+")","i"),Rb={position:"absolute",visibility:"hidden",display:"block"},Sb={letterSpacing:"0",fontWeight:"400"},Tb=["Webkit","O","Moz","ms"];function Ub(a,b){if(b in a)return b;var c=b.charAt(0).toUpperCase()+b.slice(1),d=b,e=Tb.length;while(e--)if(b=Tb[e]+c,b in a)return b;return d}function Vb(a,b){for(var c,d,e,f=[],g=0,h=a.length;h>g;g++)d=a[g],d.style&&(f[g]=m._data(d,"olddisplay"),c=d.style.display,b?(f[g]||"none"!==c||(d.style.display=""),""===d.style.display&&U(d)&&(f[g]=m._data(d,"olddisplay",Fb(d.nodeName)))):(e=U(d),(c&&"none"!==c||!e)&&m._data(d,"olddisplay",e?c:m.css(d,"display"))));for(g=0;h>g;g++)d=a[g],d.style&&(b&&"none"!==d.style.display&&""!==d.style.display||(d.style.display=b?f[g]||"":"none"));return a}function Wb(a,b,c){var d=Pb.exec(b);return d?Math.max(0,d[1]-(c||0))+(d[2]||"px"):b}function Xb(a,b,c,d,e){for(var f=c===(d?"border":"content")?4:"width"===b?1:0,g=0;4>f;f+=2)"margin"===c&&(g+=m.css(a,c+T[f],!0,e)),d?("content"===c&&(g-=m.css(a,"padding"+T[f],!0,e)),"margin"!==c&&(g-=m.css(a,"border"+T[f]+"Width",!0,e))):(g+=m.css(a,"padding"+T[f],!0,e),"padding"!==c&&(g+=m.css(a,"border"+T[f]+"Width",!0,e)));return g}function Yb(a,b,c){var d=!0,e="width"===b?a.offsetWidth:a.offsetHeight,f=Ib(a),g=k.boxSizing&&"border-box"===m.css(a,"boxSizing",!1,f);if(0>=e||null==e){if(e=Jb(a,b,f),(0>e||null==e)&&(e=a.style[b]),Hb.test(e))return e;d=g&&(k.boxSizingReliable()||e===a.style[b]),e=parseFloat(e)||0}return e+Xb(a,b,c||(g?"border":"content"),d,f)+"px"}m.extend({cssHooks:{opacity:{get:function(a,b){if(b){var c=Jb(a,"opacity");return""===c?"1":c}}}},cssNumber:{columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{"float":k.cssFloat?"cssFloat":"styleFloat"},style:function(a,b,c,d){if(a&&3!==a.nodeType&&8!==a.nodeType&&a.style){var e,f,g,h=m.camelCase(b),i=a.style;if(b=m.cssProps[h]||(m.cssProps[h]=Ub(i,h)),g=m.cssHooks[b]||m.cssHooks[h],void 0===c)return g&&"get"in g&&void 0!==(e=g.get(a,!1,d))?e:i[b];if(f=typeof c,"string"===f&&(e=Qb.exec(c))&&(c=(e[1]+1)*e[2]+parseFloat(m.css(a,b)),f="number"),null!=c&&c===c&&("number"!==f||m.cssNumber[h]||(c+="px"),k.clearCloneStyle||""!==c||0!==b.indexOf("background")||(i[b]="inherit"),!(g&&"set"in g&&void 0===(c=g.set(a,c,d)))))try{i[b]=c}catch(j){}}},css:function(a,b,c,d){var e,f,g,h=m.camelCase(b);return b=m.cssProps[h]||(m.cssProps[h]=Ub(a.style,h)),g=m.cssHooks[b]||m.cssHooks[h],g&&"get"in g&&(f=g.get(a,!0,c)),void 0===f&&(f=Jb(a,b,d)),"normal"===f&&b in Sb&&(f=Sb[b]),""===c||c?(e=parseFloat(f),c===!0||m.isNumeric(e)?e||0:f):f}}),m.each(["height","width"],function(a,b){m.cssHooks[b]={get:function(a,c,d){return c?Ob.test(m.css(a,"display"))&&0===a.offsetWidth?m.swap(a,Rb,function(){return Yb(a,b,d)}):Yb(a,b,d):void 0},set:function(a,c,d){var e=d&&Ib(a);return Wb(a,c,d?Xb(a,b,d,k.boxSizing&&"border-box"===m.css(a,"boxSizing",!1,e),e):0)}}}),k.opacity||(m.cssHooks.opacity={get:function(a,b){return Nb.test((b&&a.currentStyle?a.currentStyle.filter:a.style.filter)||"")?.01*parseFloat(RegExp.$1)+"":b?"1":""},set:function(a,b){var c=a.style,d=a.currentStyle,e=m.isNumeric(b)?"alpha(opacity="+100*b+")":"",f=d&&d.filter||c.filter||"";c.zoom=1,(b>=1||""===b)&&""===m.trim(f.replace(Mb,""))&&c.removeAttribute&&(c.removeAttribute("filter"),""===b||d&&!d.filter)||(c.filter=Mb.test(f)?f.replace(Mb,e):f+" "+e)}}),m.cssHooks.marginRight=Lb(k.reliableMarginRight,function(a,b){return b?m.swap(a,{display:"inline-block"},Jb,[a,"marginRight"]):void 0}),m.each({margin:"",padding:"",border:"Width"},function(a,b){m.cssHooks[a+b]={expand:function(c){for(var d=0,e={},f="string"==typeof c?c.split(" "):[c];4>d;d++)e[a+T[d]+b]=f[d]||f[d-2]||f[0];return e}},Gb.test(a)||(m.cssHooks[a+b].set=Wb)}),m.fn.extend({css:function(a,b){return V(this,function(a,b,c){var d,e,f={},g=0;if(m.isArray(b)){for(d=Ib(a),e=b.length;e>g;g++)f[b[g]]=m.css(a,b[g],!1,d);return f}return void 0!==c?m.style(a,b,c):m.css(a,b)},a,b,arguments.length>1)},show:function(){return Vb(this,!0)},hide:function(){return Vb(this)},toggle:function(a){return"boolean"==typeof a?a?this.show():this.hide():this.each(function(){U(this)?m(this).show():m(this).hide()})}});function Zb(a,b,c,d,e){return new Zb.prototype.init(a,b,c,d,e)
}m.Tween=Zb,Zb.prototype={constructor:Zb,init:function(a,b,c,d,e,f){this.elem=a,this.prop=c,this.easing=e||"swing",this.options=b,this.start=this.now=this.cur(),this.end=d,this.unit=f||(m.cssNumber[c]?"":"px")},cur:function(){var a=Zb.propHooks[this.prop];return a&&a.get?a.get(this):Zb.propHooks._default.get(this)},run:function(a){var b,c=Zb.propHooks[this.prop];return this.pos=b=this.options.duration?m.easing[this.easing](a,this.options.duration*a,0,1,this.options.duration):a,this.now=(this.end-this.start)*b+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),c&&c.set?c.set(this):Zb.propHooks._default.set(this),this}},Zb.prototype.init.prototype=Zb.prototype,Zb.propHooks={_default:{get:function(a){var b;return null==a.elem[a.prop]||a.elem.style&&null!=a.elem.style[a.prop]?(b=m.css(a.elem,a.prop,""),b&&"auto"!==b?b:0):a.elem[a.prop]},set:function(a){m.fx.step[a.prop]?m.fx.step[a.prop](a):a.elem.style&&(null!=a.elem.style[m.cssProps[a.prop]]||m.cssHooks[a.prop])?m.style(a.elem,a.prop,a.now+a.unit):a.elem[a.prop]=a.now}}},Zb.propHooks.scrollTop=Zb.propHooks.scrollLeft={set:function(a){a.elem.nodeType&&a.elem.parentNode&&(a.elem[a.prop]=a.now)}},m.easing={linear:function(a){return a},swing:function(a){return.5-Math.cos(a*Math.PI)/2}},m.fx=Zb.prototype.init,m.fx.step={};var $b,_b,ac=/^(?:toggle|show|hide)$/,bc=new RegExp("^(?:([+-])=|)("+S+")([a-z%]*)$","i"),cc=/queueHooks$/,dc=[ic],ec={"*":[function(a,b){var c=this.createTween(a,b),d=c.cur(),e=bc.exec(b),f=e&&e[3]||(m.cssNumber[a]?"":"px"),g=(m.cssNumber[a]||"px"!==f&&+d)&&bc.exec(m.css(c.elem,a)),h=1,i=20;if(g&&g[3]!==f){f=f||g[3],e=e||[],g=+d||1;do h=h||".5",g/=h,m.style(c.elem,a,g+f);while(h!==(h=c.cur()/d)&&1!==h&&--i)}return e&&(g=c.start=+g||+d||0,c.unit=f,c.end=e[1]?g+(e[1]+1)*e[2]:+e[2]),c}]};function fc(){return setTimeout(function(){$b=void 0}),$b=m.now()}function gc(a,b){var c,d={height:a},e=0;for(b=b?1:0;4>e;e+=2-b)c=T[e],d["margin"+c]=d["padding"+c]=a;return b&&(d.opacity=d.width=a),d}function hc(a,b,c){for(var d,e=(ec[b]||[]).concat(ec["*"]),f=0,g=e.length;g>f;f++)if(d=e[f].call(c,b,a))return d}function ic(a,b,c){var d,e,f,g,h,i,j,l,n=this,o={},p=a.style,q=a.nodeType&&U(a),r=m._data(a,"fxshow");c.queue||(h=m._queueHooks(a,"fx"),null==h.unqueued&&(h.unqueued=0,i=h.empty.fire,h.empty.fire=function(){h.unqueued||i()}),h.unqueued++,n.always(function(){n.always(function(){h.unqueued--,m.queue(a,"fx").length||h.empty.fire()})})),1===a.nodeType&&("height"in b||"width"in b)&&(c.overflow=[p.overflow,p.overflowX,p.overflowY],j=m.css(a,"display"),l="none"===j?m._data(a,"olddisplay")||Fb(a.nodeName):j,"inline"===l&&"none"===m.css(a,"float")&&(k.inlineBlockNeedsLayout&&"inline"!==Fb(a.nodeName)?p.zoom=1:p.display="inline-block")),c.overflow&&(p.overflow="hidden",k.shrinkWrapBlocks()||n.always(function(){p.overflow=c.overflow[0],p.overflowX=c.overflow[1],p.overflowY=c.overflow[2]}));for(d in b)if(e=b[d],ac.exec(e)){if(delete b[d],f=f||"toggle"===e,e===(q?"hide":"show")){if("show"!==e||!r||void 0===r[d])continue;q=!0}o[d]=r&&r[d]||m.style(a,d)}else j=void 0;if(m.isEmptyObject(o))"inline"===("none"===j?Fb(a.nodeName):j)&&(p.display=j);else{r?"hidden"in r&&(q=r.hidden):r=m._data(a,"fxshow",{}),f&&(r.hidden=!q),q?m(a).show():n.done(function(){m(a).hide()}),n.done(function(){var b;m._removeData(a,"fxshow");for(b in o)m.style(a,b,o[b])});for(d in o)g=hc(q?r[d]:0,d,n),d in r||(r[d]=g.start,q&&(g.end=g.start,g.start="width"===d||"height"===d?1:0))}}function jc(a,b){var c,d,e,f,g;for(c in a)if(d=m.camelCase(c),e=b[d],f=a[c],m.isArray(f)&&(e=f[1],f=a[c]=f[0]),c!==d&&(a[d]=f,delete a[c]),g=m.cssHooks[d],g&&"expand"in g){f=g.expand(f),delete a[d];for(c in f)c in a||(a[c]=f[c],b[c]=e)}else b[d]=e}function kc(a,b,c){var d,e,f=0,g=dc.length,h=m.Deferred().always(function(){delete i.elem}),i=function(){if(e)return!1;for(var b=$b||fc(),c=Math.max(0,j.startTime+j.duration-b),d=c/j.duration||0,f=1-d,g=0,i=j.tweens.length;i>g;g++)j.tweens[g].run(f);return h.notifyWith(a,[j,f,c]),1>f&&i?c:(h.resolveWith(a,[j]),!1)},j=h.promise({elem:a,props:m.extend({},b),opts:m.extend(!0,{specialEasing:{}},c),originalProperties:b,originalOptions:c,startTime:$b||fc(),duration:c.duration,tweens:[],createTween:function(b,c){var d=m.Tween(a,j.opts,b,c,j.opts.specialEasing[b]||j.opts.easing);return j.tweens.push(d),d},stop:function(b){var c=0,d=b?j.tweens.length:0;if(e)return this;for(e=!0;d>c;c++)j.tweens[c].run(1);return b?h.resolveWith(a,[j,b]):h.rejectWith(a,[j,b]),this}}),k=j.props;for(jc(k,j.opts.specialEasing);g>f;f++)if(d=dc[f].call(j,a,k,j.opts))return d;return m.map(k,hc,j),m.isFunction(j.opts.start)&&j.opts.start.call(a,j),m.fx.timer(m.extend(i,{elem:a,anim:j,queue:j.opts.queue})),j.progress(j.opts.progress).done(j.opts.done,j.opts.complete).fail(j.opts.fail).always(j.opts.always)}m.Animation=m.extend(kc,{tweener:function(a,b){m.isFunction(a)?(b=a,a=["*"]):a=a.split(" ");for(var c,d=0,e=a.length;e>d;d++)c=a[d],ec[c]=ec[c]||[],ec[c].unshift(b)},prefilter:function(a,b){b?dc.unshift(a):dc.push(a)}}),m.speed=function(a,b,c){var d=a&&"object"==typeof a?m.extend({},a):{complete:c||!c&&b||m.isFunction(a)&&a,duration:a,easing:c&&b||b&&!m.isFunction(b)&&b};return d.duration=m.fx.off?0:"number"==typeof d.duration?d.duration:d.duration in m.fx.speeds?m.fx.speeds[d.duration]:m.fx.speeds._default,(null==d.queue||d.queue===!0)&&(d.queue="fx"),d.old=d.complete,d.complete=function(){m.isFunction(d.old)&&d.old.call(this),d.queue&&m.dequeue(this,d.queue)},d},m.fn.extend({fadeTo:function(a,b,c,d){return this.filter(U).css("opacity",0).show().end().animate({opacity:b},a,c,d)},animate:function(a,b,c,d){var e=m.isEmptyObject(a),f=m.speed(b,c,d),g=function(){var b=kc(this,m.extend({},a),f);(e||m._data(this,"finish"))&&b.stop(!0)};return g.finish=g,e||f.queue===!1?this.each(g):this.queue(f.queue,g)},stop:function(a,b,c){var d=function(a){var b=a.stop;delete a.stop,b(c)};return"string"!=typeof a&&(c=b,b=a,a=void 0),b&&a!==!1&&this.queue(a||"fx",[]),this.each(function(){var b=!0,e=null!=a&&a+"queueHooks",f=m.timers,g=m._data(this);if(e)g[e]&&g[e].stop&&d(g[e]);else for(e in g)g[e]&&g[e].stop&&cc.test(e)&&d(g[e]);for(e=f.length;e--;)f[e].elem!==this||null!=a&&f[e].queue!==a||(f[e].anim.stop(c),b=!1,f.splice(e,1));(b||!c)&&m.dequeue(this,a)})},finish:function(a){return a!==!1&&(a=a||"fx"),this.each(function(){var b,c=m._data(this),d=c[a+"queue"],e=c[a+"queueHooks"],f=m.timers,g=d?d.length:0;for(c.finish=!0,m.queue(this,a,[]),e&&e.stop&&e.stop.call(this,!0),b=f.length;b--;)f[b].elem===this&&f[b].queue===a&&(f[b].anim.stop(!0),f.splice(b,1));for(b=0;g>b;b++)d[b]&&d[b].finish&&d[b].finish.call(this);delete c.finish})}}),m.each(["toggle","show","hide"],function(a,b){var c=m.fn[b];m.fn[b]=function(a,d,e){return null==a||"boolean"==typeof a?c.apply(this,arguments):this.animate(gc(b,!0),a,d,e)}}),m.each({slideDown:gc("show"),slideUp:gc("hide"),slideToggle:gc("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(a,b){m.fn[a]=function(a,c,d){return this.animate(b,a,c,d)}}),m.timers=[],m.fx.tick=function(){var a,b=m.timers,c=0;for($b=m.now();c<b.length;c++)a=b[c],a()||b[c]!==a||b.splice(c--,1);b.length||m.fx.stop(),$b=void 0},m.fx.timer=function(a){m.timers.push(a),a()?m.fx.start():m.timers.pop()},m.fx.interval=13,m.fx.start=function(){_b||(_b=setInterval(m.fx.tick,m.fx.interval))},m.fx.stop=function(){clearInterval(_b),_b=null},m.fx.speeds={slow:600,fast:200,_default:400},m.fn.delay=function(a,b){return a=m.fx?m.fx.speeds[a]||a:a,b=b||"fx",this.queue(b,function(b,c){var d=setTimeout(b,a);c.stop=function(){clearTimeout(d)}})},function(){var a,b,c,d,e;b=y.createElement("div"),b.setAttribute("className","t"),b.innerHTML="  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>",d=b.getElementsByTagName("a")[0],c=y.createElement("select"),e=c.appendChild(y.createElement("option")),a=b.getElementsByTagName("input")[0],d.style.cssText="top:1px",k.getSetAttribute="t"!==b.className,k.style=/top/.test(d.getAttribute("style")),k.hrefNormalized="/a"===d.getAttribute("href"),k.checkOn=!!a.value,k.optSelected=e.selected,k.enctype=!!y.createElement("form").enctype,c.disabled=!0,k.optDisabled=!e.disabled,a=y.createElement("input"),a.setAttribute("value",""),k.input=""===a.getAttribute("value"),a.value="t",a.setAttribute("type","radio"),k.radioValue="t"===a.value}();var lc=/\r/g;m.fn.extend({val:function(a){var b,c,d,e=this[0];{if(arguments.length)return d=m.isFunction(a),this.each(function(c){var e;1===this.nodeType&&(e=d?a.call(this,c,m(this).val()):a,null==e?e="":"number"==typeof e?e+="":m.isArray(e)&&(e=m.map(e,function(a){return null==a?"":a+""})),b=m.valHooks[this.type]||m.valHooks[this.nodeName.toLowerCase()],b&&"set"in b&&void 0!==b.set(this,e,"value")||(this.value=e))});if(e)return b=m.valHooks[e.type]||m.valHooks[e.nodeName.toLowerCase()],b&&"get"in b&&void 0!==(c=b.get(e,"value"))?c:(c=e.value,"string"==typeof c?c.replace(lc,""):null==c?"":c)}}}),m.extend({valHooks:{option:{get:function(a){var b=m.find.attr(a,"value");return null!=b?b:m.trim(m.text(a))}},select:{get:function(a){for(var b,c,d=a.options,e=a.selectedIndex,f="select-one"===a.type||0>e,g=f?null:[],h=f?e+1:d.length,i=0>e?h:f?e:0;h>i;i++)if(c=d[i],!(!c.selected&&i!==e||(k.optDisabled?c.disabled:null!==c.getAttribute("disabled"))||c.parentNode.disabled&&m.nodeName(c.parentNode,"optgroup"))){if(b=m(c).val(),f)return b;g.push(b)}return g},set:function(a,b){var c,d,e=a.options,f=m.makeArray(b),g=e.length;while(g--)if(d=e[g],m.inArray(m.valHooks.option.get(d),f)>=0)try{d.selected=c=!0}catch(h){d.scrollHeight}else d.selected=!1;return c||(a.selectedIndex=-1),e}}}}),m.each(["radio","checkbox"],function(){m.valHooks[this]={set:function(a,b){return m.isArray(b)?a.checked=m.inArray(m(a).val(),b)>=0:void 0}},k.checkOn||(m.valHooks[this].get=function(a){return null===a.getAttribute("value")?"on":a.value})});var mc,nc,oc=m.expr.attrHandle,pc=/^(?:checked|selected)$/i,qc=k.getSetAttribute,rc=k.input;m.fn.extend({attr:function(a,b){return V(this,m.attr,a,b,arguments.length>1)},removeAttr:function(a){return this.each(function(){m.removeAttr(this,a)})}}),m.extend({attr:function(a,b,c){var d,e,f=a.nodeType;if(a&&3!==f&&8!==f&&2!==f)return typeof a.getAttribute===K?m.prop(a,b,c):(1===f&&m.isXMLDoc(a)||(b=b.toLowerCase(),d=m.attrHooks[b]||(m.expr.match.bool.test(b)?nc:mc)),void 0===c?d&&"get"in d&&null!==(e=d.get(a,b))?e:(e=m.find.attr(a,b),null==e?void 0:e):null!==c?d&&"set"in d&&void 0!==(e=d.set(a,c,b))?e:(a.setAttribute(b,c+""),c):void m.removeAttr(a,b))},removeAttr:function(a,b){var c,d,e=0,f=b&&b.match(E);if(f&&1===a.nodeType)while(c=f[e++])d=m.propFix[c]||c,m.expr.match.bool.test(c)?rc&&qc||!pc.test(c)?a[d]=!1:a[m.camelCase("default-"+c)]=a[d]=!1:m.attr(a,c,""),a.removeAttribute(qc?c:d)},attrHooks:{type:{set:function(a,b){if(!k.radioValue&&"radio"===b&&m.nodeName(a,"input")){var c=a.value;return a.setAttribute("type",b),c&&(a.value=c),b}}}}}),nc={set:function(a,b,c){return b===!1?m.removeAttr(a,c):rc&&qc||!pc.test(c)?a.setAttribute(!qc&&m.propFix[c]||c,c):a[m.camelCase("default-"+c)]=a[c]=!0,c}},m.each(m.expr.match.bool.source.match(/\w+/g),function(a,b){var c=oc[b]||m.find.attr;oc[b]=rc&&qc||!pc.test(b)?function(a,b,d){var e,f;return d||(f=oc[b],oc[b]=e,e=null!=c(a,b,d)?b.toLowerCase():null,oc[b]=f),e}:function(a,b,c){return c?void 0:a[m.camelCase("default-"+b)]?b.toLowerCase():null}}),rc&&qc||(m.attrHooks.value={set:function(a,b,c){return m.nodeName(a,"input")?void(a.defaultValue=b):mc&&mc.set(a,b,c)}}),qc||(mc={set:function(a,b,c){var d=a.getAttributeNode(c);return d||a.setAttributeNode(d=a.ownerDocument.createAttribute(c)),d.value=b+="","value"===c||b===a.getAttribute(c)?b:void 0}},oc.id=oc.name=oc.coords=function(a,b,c){var d;return c?void 0:(d=a.getAttributeNode(b))&&""!==d.value?d.value:null},m.valHooks.button={get:function(a,b){var c=a.getAttributeNode(b);return c&&c.specified?c.value:void 0},set:mc.set},m.attrHooks.contenteditable={set:function(a,b,c){mc.set(a,""===b?!1:b,c)}},m.each(["width","height"],function(a,b){m.attrHooks[b]={set:function(a,c){return""===c?(a.setAttribute(b,"auto"),c):void 0}}})),k.style||(m.attrHooks.style={get:function(a){return a.style.cssText||void 0},set:function(a,b){return a.style.cssText=b+""}});var sc=/^(?:input|select|textarea|button|object)$/i,tc=/^(?:a|area)$/i;m.fn.extend({prop:function(a,b){return V(this,m.prop,a,b,arguments.length>1)},removeProp:function(a){return a=m.propFix[a]||a,this.each(function(){try{this[a]=void 0,delete this[a]}catch(b){}})}}),m.extend({propFix:{"for":"htmlFor","class":"className"},prop:function(a,b,c){var d,e,f,g=a.nodeType;if(a&&3!==g&&8!==g&&2!==g)return f=1!==g||!m.isXMLDoc(a),f&&(b=m.propFix[b]||b,e=m.propHooks[b]),void 0!==c?e&&"set"in e&&void 0!==(d=e.set(a,c,b))?d:a[b]=c:e&&"get"in e&&null!==(d=e.get(a,b))?d:a[b]},propHooks:{tabIndex:{get:function(a){var b=m.find.attr(a,"tabindex");return b?parseInt(b,10):sc.test(a.nodeName)||tc.test(a.nodeName)&&a.href?0:-1}}}}),k.hrefNormalized||m.each(["href","src"],function(a,b){m.propHooks[b]={get:function(a){return a.getAttribute(b,4)}}}),k.optSelected||(m.propHooks.selected={get:function(a){var b=a.parentNode;return b&&(b.selectedIndex,b.parentNode&&b.parentNode.selectedIndex),null}}),m.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){m.propFix[this.toLowerCase()]=this}),k.enctype||(m.propFix.enctype="encoding");var uc=/[\t\r\n\f]/g;m.fn.extend({addClass:function(a){var b,c,d,e,f,g,h=0,i=this.length,j="string"==typeof a&&a;if(m.isFunction(a))return this.each(function(b){m(this).addClass(a.call(this,b,this.className))});if(j)for(b=(a||"").match(E)||[];i>h;h++)if(c=this[h],d=1===c.nodeType&&(c.className?(" "+c.className+" ").replace(uc," "):" ")){f=0;while(e=b[f++])d.indexOf(" "+e+" ")<0&&(d+=e+" ");g=m.trim(d),c.className!==g&&(c.className=g)}return this},removeClass:function(a){var b,c,d,e,f,g,h=0,i=this.length,j=0===arguments.length||"string"==typeof a&&a;if(m.isFunction(a))return this.each(function(b){m(this).removeClass(a.call(this,b,this.className))});if(j)for(b=(a||"").match(E)||[];i>h;h++)if(c=this[h],d=1===c.nodeType&&(c.className?(" "+c.className+" ").replace(uc," "):"")){f=0;while(e=b[f++])while(d.indexOf(" "+e+" ")>=0)d=d.replace(" "+e+" "," ");g=a?m.trim(d):"",c.className!==g&&(c.className=g)}return this},toggleClass:function(a,b){var c=typeof a;return"boolean"==typeof b&&"string"===c?b?this.addClass(a):this.removeClass(a):this.each(m.isFunction(a)?function(c){m(this).toggleClass(a.call(this,c,this.className,b),b)}:function(){if("string"===c){var b,d=0,e=m(this),f=a.match(E)||[];while(b=f[d++])e.hasClass(b)?e.removeClass(b):e.addClass(b)}else(c===K||"boolean"===c)&&(this.className&&m._data(this,"__className__",this.className),this.className=this.className||a===!1?"":m._data(this,"__className__")||"")})},hasClass:function(a){for(var b=" "+a+" ",c=0,d=this.length;d>c;c++)if(1===this[c].nodeType&&(" "+this[c].className+" ").replace(uc," ").indexOf(b)>=0)return!0;return!1}}),m.each("blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error contextmenu".split(" "),function(a,b){m.fn[b]=function(a,c){return arguments.length>0?this.on(b,null,a,c):this.trigger(b)}}),m.fn.extend({hover:function(a,b){return this.mouseenter(a).mouseleave(b||a)},bind:function(a,b,c){return this.on(a,null,b,c)},unbind:function(a,b){return this.off(a,null,b)},delegate:function(a,b,c,d){return this.on(b,a,c,d)},undelegate:function(a,b,c){return 1===arguments.length?this.off(a,"**"):this.off(b,a||"**",c)}});var vc=m.now(),wc=/\?/,xc=/(,)|(\[|{)|(}|])|"(?:[^"\\\r\n]|\\["\\\/bfnrt]|\\u[\da-fA-F]{4})*"\s*:?|true|false|null|-?(?!0\d)\d+(?:\.\d+|)(?:[eE][+-]?\d+|)/g;m.parseJSON=function(b){if(a.JSON&&a.JSON.parse)return a.JSON.parse(b+"");var c,d=null,e=m.trim(b+"");return e&&!m.trim(e.replace(xc,function(a,b,e,f){return c&&b&&(d=0),0===d?a:(c=e||b,d+=!f-!e,"")}))?Function("return "+e)():m.error("Invalid JSON: "+b)},m.parseXML=function(b){var c,d;if(!b||"string"!=typeof b)return null;try{a.DOMParser?(d=new DOMParser,c=d.parseFromString(b,"text/xml")):(c=new ActiveXObject("Microsoft.XMLDOM"),c.async="false",c.loadXML(b))}catch(e){c=void 0}return c&&c.documentElement&&!c.getElementsByTagName("parsererror").length||m.error("Invalid XML: "+b),c};var yc,zc,Ac=/#.*$/,Bc=/([?&])_=[^&]*/,Cc=/^(.*?):[ \t]*([^\r\n]*)\r?$/gm,Dc=/^(?:about|app|app-storage|.+-extension|file|res|widget):$/,Ec=/^(?:GET|HEAD)$/,Fc=/^\/\//,Gc=/^([\w.+-]+:)(?:\/\/(?:[^\/?#]*@|)([^\/?#:]*)(?::(\d+)|)|)/,Hc={},Ic={},Jc="*/".concat("*");try{zc=location.href}catch(Kc){zc=y.createElement("a"),zc.href="",zc=zc.href}yc=Gc.exec(zc.toLowerCase())||[];function Lc(a){return function(b,c){"string"!=typeof b&&(c=b,b="*");var d,e=0,f=b.toLowerCase().match(E)||[];if(m.isFunction(c))while(d=f[e++])"+"===d.charAt(0)?(d=d.slice(1)||"*",(a[d]=a[d]||[]).unshift(c)):(a[d]=a[d]||[]).push(c)}}function Mc(a,b,c,d){var e={},f=a===Ic;function g(h){var i;return e[h]=!0,m.each(a[h]||[],function(a,h){var j=h(b,c,d);return"string"!=typeof j||f||e[j]?f?!(i=j):void 0:(b.dataTypes.unshift(j),g(j),!1)}),i}return g(b.dataTypes[0])||!e["*"]&&g("*")}function Nc(a,b){var c,d,e=m.ajaxSettings.flatOptions||{};for(d in b)void 0!==b[d]&&((e[d]?a:c||(c={}))[d]=b[d]);return c&&m.extend(!0,a,c),a}function Oc(a,b,c){var d,e,f,g,h=a.contents,i=a.dataTypes;while("*"===i[0])i.shift(),void 0===e&&(e=a.mimeType||b.getResponseHeader("Content-Type"));if(e)for(g in h)if(h[g]&&h[g].test(e)){i.unshift(g);break}if(i[0]in c)f=i[0];else{for(g in c){if(!i[0]||a.converters[g+" "+i[0]]){f=g;break}d||(d=g)}f=f||d}return f?(f!==i[0]&&i.unshift(f),c[f]):void 0}function Pc(a,b,c,d){var e,f,g,h,i,j={},k=a.dataTypes.slice();if(k[1])for(g in a.converters)j[g.toLowerCase()]=a.converters[g];f=k.shift();while(f)if(a.responseFields[f]&&(c[a.responseFields[f]]=b),!i&&d&&a.dataFilter&&(b=a.dataFilter(b,a.dataType)),i=f,f=k.shift())if("*"===f)f=i;else if("*"!==i&&i!==f){if(g=j[i+" "+f]||j["* "+f],!g)for(e in j)if(h=e.split(" "),h[1]===f&&(g=j[i+" "+h[0]]||j["* "+h[0]])){g===!0?g=j[e]:j[e]!==!0&&(f=h[0],k.unshift(h[1]));break}if(g!==!0)if(g&&a["throws"])b=g(b);else try{b=g(b)}catch(l){return{state:"parsererror",error:g?l:"No conversion from "+i+" to "+f}}}return{state:"success",data:b}}m.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:zc,type:"GET",isLocal:Dc.test(yc[1]),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":Jc,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/xml/,html:/html/,json:/json/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":m.parseJSON,"text xml":m.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(a,b){return b?Nc(Nc(a,m.ajaxSettings),b):Nc(m.ajaxSettings,a)},ajaxPrefilter:Lc(Hc),ajaxTransport:Lc(Ic),ajax:function(a,b){"object"==typeof a&&(b=a,a=void 0),b=b||{};var c,d,e,f,g,h,i,j,k=m.ajaxSetup({},b),l=k.context||k,n=k.context&&(l.nodeType||l.jquery)?m(l):m.event,o=m.Deferred(),p=m.Callbacks("once memory"),q=k.statusCode||{},r={},s={},t=0,u="canceled",v={readyState:0,getResponseHeader:function(a){var b;if(2===t){if(!j){j={};while(b=Cc.exec(f))j[b[1].toLowerCase()]=b[2]}b=j[a.toLowerCase()]}return null==b?null:b},getAllResponseHeaders:function(){return 2===t?f:null},setRequestHeader:function(a,b){var c=a.toLowerCase();return t||(a=s[c]=s[c]||a,r[a]=b),this},overrideMimeType:function(a){return t||(k.mimeType=a),this},statusCode:function(a){var b;if(a)if(2>t)for(b in a)q[b]=[q[b],a[b]];else v.always(a[v.status]);return this},abort:function(a){var b=a||u;return i&&i.abort(b),x(0,b),this}};if(o.promise(v).complete=p.add,v.success=v.done,v.error=v.fail,k.url=((a||k.url||zc)+"").replace(Ac,"").replace(Fc,yc[1]+"//"),k.type=b.method||b.type||k.method||k.type,k.dataTypes=m.trim(k.dataType||"*").toLowerCase().match(E)||[""],null==k.crossDomain&&(c=Gc.exec(k.url.toLowerCase()),k.crossDomain=!(!c||c[1]===yc[1]&&c[2]===yc[2]&&(c[3]||("http:"===c[1]?"80":"443"))===(yc[3]||("http:"===yc[1]?"80":"443")))),k.data&&k.processData&&"string"!=typeof k.data&&(k.data=m.param(k.data,k.traditional)),Mc(Hc,k,b,v),2===t)return v;h=m.event&&k.global,h&&0===m.active++&&m.event.trigger("ajaxStart"),k.type=k.type.toUpperCase(),k.hasContent=!Ec.test(k.type),e=k.url,k.hasContent||(k.data&&(e=k.url+=(wc.test(e)?"&":"?")+k.data,delete k.data),k.cache===!1&&(k.url=Bc.test(e)?e.replace(Bc,"$1_="+vc++):e+(wc.test(e)?"&":"?")+"_="+vc++)),k.ifModified&&(m.lastModified[e]&&v.setRequestHeader("If-Modified-Since",m.lastModified[e]),m.etag[e]&&v.setRequestHeader("If-None-Match",m.etag[e])),(k.data&&k.hasContent&&k.contentType!==!1||b.contentType)&&v.setRequestHeader("Content-Type",k.contentType),v.setRequestHeader("Accept",k.dataTypes[0]&&k.accepts[k.dataTypes[0]]?k.accepts[k.dataTypes[0]]+("*"!==k.dataTypes[0]?", "+Jc+"; q=0.01":""):k.accepts["*"]);for(d in k.headers)v.setRequestHeader(d,k.headers[d]);if(k.beforeSend&&(k.beforeSend.call(l,v,k)===!1||2===t))return v.abort();u="abort";for(d in{success:1,error:1,complete:1})v[d](k[d]);if(i=Mc(Ic,k,b,v)){v.readyState=1,h&&n.trigger("ajaxSend",[v,k]),k.async&&k.timeout>0&&(g=setTimeout(function(){v.abort("timeout")},k.timeout));try{t=1,i.send(r,x)}catch(w){if(!(2>t))throw w;x(-1,w)}}else x(-1,"No Transport");function x(a,b,c,d){var j,r,s,u,w,x=b;2!==t&&(t=2,g&&clearTimeout(g),i=void 0,f=d||"",v.readyState=a>0?4:0,j=a>=200&&300>a||304===a,c&&(u=Oc(k,v,c)),u=Pc(k,u,v,j),j?(k.ifModified&&(w=v.getResponseHeader("Last-Modified"),w&&(m.lastModified[e]=w),w=v.getResponseHeader("etag"),w&&(m.etag[e]=w)),204===a||"HEAD"===k.type?x="nocontent":304===a?x="notmodified":(x=u.state,r=u.data,s=u.error,j=!s)):(s=x,(a||!x)&&(x="error",0>a&&(a=0))),v.status=a,v.statusText=(b||x)+"",j?o.resolveWith(l,[r,x,v]):o.rejectWith(l,[v,x,s]),v.statusCode(q),q=void 0,h&&n.trigger(j?"ajaxSuccess":"ajaxError",[v,k,j?r:s]),p.fireWith(l,[v,x]),h&&(n.trigger("ajaxComplete",[v,k]),--m.active||m.event.trigger("ajaxStop")))}return v},getJSON:function(a,b,c){return m.get(a,b,c,"json")},getScript:function(a,b){return m.get(a,void 0,b,"script")}}),m.each(["get","post"],function(a,b){m[b]=function(a,c,d,e){return m.isFunction(c)&&(e=e||d,d=c,c=void 0),m.ajax({url:a,type:b,dataType:e,data:c,success:d})}}),m._evalUrl=function(a){return m.ajax({url:a,type:"GET",dataType:"script",async:!1,global:!1,"throws":!0})},m.fn.extend({wrapAll:function(a){if(m.isFunction(a))return this.each(function(b){m(this).wrapAll(a.call(this,b))});if(this[0]){var b=m(a,this[0].ownerDocument).eq(0).clone(!0);this[0].parentNode&&b.insertBefore(this[0]),b.map(function(){var a=this;while(a.firstChild&&1===a.firstChild.nodeType)a=a.firstChild;return a}).append(this)}return this},wrapInner:function(a){return this.each(m.isFunction(a)?function(b){m(this).wrapInner(a.call(this,b))}:function(){var b=m(this),c=b.contents();c.length?c.wrapAll(a):b.append(a)})},wrap:function(a){var b=m.isFunction(a);return this.each(function(c){m(this).wrapAll(b?a.call(this,c):a)})},unwrap:function(){return this.parent().each(function(){m.nodeName(this,"body")||m(this).replaceWith(this.childNodes)}).end()}}),m.expr.filters.hidden=function(a){return a.offsetWidth<=0&&a.offsetHeight<=0||!k.reliableHiddenOffsets()&&"none"===(a.style&&a.style.display||m.css(a,"display"))},m.expr.filters.visible=function(a){return!m.expr.filters.hidden(a)};var Qc=/%20/g,Rc=/\[\]$/,Sc=/\r?\n/g,Tc=/^(?:submit|button|image|reset|file)$/i,Uc=/^(?:input|select|textarea|keygen)/i;function Vc(a,b,c,d){var e;if(m.isArray(b))m.each(b,function(b,e){c||Rc.test(a)?d(a,e):Vc(a+"["+("object"==typeof e?b:"")+"]",e,c,d)});else if(c||"object"!==m.type(b))d(a,b);else for(e in b)Vc(a+"["+e+"]",b[e],c,d)}m.param=function(a,b){var c,d=[],e=function(a,b){b=m.isFunction(b)?b():null==b?"":b,d[d.length]=encodeURIComponent(a)+"="+encodeURIComponent(b)};if(void 0===b&&(b=m.ajaxSettings&&m.ajaxSettings.traditional),m.isArray(a)||a.jquery&&!m.isPlainObject(a))m.each(a,function(){e(this.name,this.value)});else for(c in a)Vc(c,a[c],b,e);return d.join("&").replace(Qc,"+")},m.fn.extend({serialize:function(){return m.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var a=m.prop(this,"elements");return a?m.makeArray(a):this}).filter(function(){var a=this.type;return this.name&&!m(this).is(":disabled")&&Uc.test(this.nodeName)&&!Tc.test(a)&&(this.checked||!W.test(a))}).map(function(a,b){var c=m(this).val();return null==c?null:m.isArray(c)?m.map(c,function(a){return{name:b.name,value:a.replace(Sc,"\r\n")}}):{name:b.name,value:c.replace(Sc,"\r\n")}}).get()}}),m.ajaxSettings.xhr=void 0!==a.ActiveXObject?function(){return!this.isLocal&&/^(get|post|head|put|delete|options)$/i.test(this.type)&&Zc()||$c()}:Zc;var Wc=0,Xc={},Yc=m.ajaxSettings.xhr();a.attachEvent&&a.attachEvent("onunload",function(){for(var a in Xc)Xc[a](void 0,!0)}),k.cors=!!Yc&&"withCredentials"in Yc,Yc=k.ajax=!!Yc,Yc&&m.ajaxTransport(function(a){if(!a.crossDomain||k.cors){var b;return{send:function(c,d){var e,f=a.xhr(),g=++Wc;if(f.open(a.type,a.url,a.async,a.username,a.password),a.xhrFields)for(e in a.xhrFields)f[e]=a.xhrFields[e];a.mimeType&&f.overrideMimeType&&f.overrideMimeType(a.mimeType),a.crossDomain||c["X-Requested-With"]||(c["X-Requested-With"]="XMLHttpRequest");for(e in c)void 0!==c[e]&&f.setRequestHeader(e,c[e]+"");f.send(a.hasContent&&a.data||null),b=function(c,e){var h,i,j;if(b&&(e||4===f.readyState))if(delete Xc[g],b=void 0,f.onreadystatechange=m.noop,e)4!==f.readyState&&f.abort();else{j={},h=f.status,"string"==typeof f.responseText&&(j.text=f.responseText);try{i=f.statusText}catch(k){i=""}h||!a.isLocal||a.crossDomain?1223===h&&(h=204):h=j.text?200:404}j&&d(h,i,j,f.getAllResponseHeaders())},a.async?4===f.readyState?setTimeout(b):f.onreadystatechange=Xc[g]=b:b()},abort:function(){b&&b(void 0,!0)}}}});function Zc(){try{return new a.XMLHttpRequest}catch(b){}}function $c(){try{return new a.ActiveXObject("Microsoft.XMLHTTP")}catch(b){}}m.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/(?:java|ecma)script/},converters:{"text script":function(a){return m.globalEval(a),a}}}),m.ajaxPrefilter("script",function(a){void 0===a.cache&&(a.cache=!1),a.crossDomain&&(a.type="GET",a.global=!1)}),m.ajaxTransport("script",function(a){if(a.crossDomain){var b,c=y.head||m("head")[0]||y.documentElement;return{send:function(d,e){b=y.createElement("script"),b.async=!0,a.scriptCharset&&(b.charset=a.scriptCharset),b.src=a.url,b.onload=b.onreadystatechange=function(a,c){(c||!b.readyState||/loaded|complete/.test(b.readyState))&&(b.onload=b.onreadystatechange=null,b.parentNode&&b.parentNode.removeChild(b),b=null,c||e(200,"success"))},c.insertBefore(b,c.firstChild)},abort:function(){b&&b.onload(void 0,!0)}}}});var _c=[],ad=/(=)\?(?=&|$)|\?\?/;m.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var a=_c.pop()||m.expando+"_"+vc++;return this[a]=!0,a}}),m.ajaxPrefilter("json jsonp",function(b,c,d){var e,f,g,h=b.jsonp!==!1&&(ad.test(b.url)?"url":"string"==typeof b.data&&!(b.contentType||"").indexOf("application/x-www-form-urlencoded")&&ad.test(b.data)&&"data");return h||"jsonp"===b.dataTypes[0]?(e=b.jsonpCallback=m.isFunction(b.jsonpCallback)?b.jsonpCallback():b.jsonpCallback,h?b[h]=b[h].replace(ad,"$1"+e):b.jsonp!==!1&&(b.url+=(wc.test(b.url)?"&":"?")+b.jsonp+"="+e),b.converters["script json"]=function(){return g||m.error(e+" was not called"),g[0]},b.dataTypes[0]="json",f=a[e],a[e]=function(){g=arguments},d.always(function(){a[e]=f,b[e]&&(b.jsonpCallback=c.jsonpCallback,_c.push(e)),g&&m.isFunction(f)&&f(g[0]),g=f=void 0}),"script"):void 0}),m.parseHTML=function(a,b,c){if(!a||"string"!=typeof a)return null;"boolean"==typeof b&&(c=b,b=!1),b=b||y;var d=u.exec(a),e=!c&&[];return d?[b.createElement(d[1])]:(d=m.buildFragment([a],b,e),e&&e.length&&m(e).remove(),m.merge([],d.childNodes))};var bd=m.fn.load;m.fn.load=function(a,b,c){if("string"!=typeof a&&bd)return bd.apply(this,arguments);var d,e,f,g=this,h=a.indexOf(" ");return h>=0&&(d=m.trim(a.slice(h,a.length)),a=a.slice(0,h)),m.isFunction(b)?(c=b,b=void 0):b&&"object"==typeof b&&(f="POST"),g.length>0&&m.ajax({url:a,type:f,dataType:"html",data:b}).done(function(a){e=arguments,g.html(d?m("<div>").append(m.parseHTML(a)).find(d):a)}).complete(c&&function(a,b){g.each(c,e||[a.responseText,b,a])}),this},m.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(a,b){m.fn[b]=function(a){return this.on(b,a)}}),m.expr.filters.animated=function(a){return m.grep(m.timers,function(b){return a===b.elem}).length};var cd=a.document.documentElement;function dd(a){return m.isWindow(a)?a:9===a.nodeType?a.defaultView||a.parentWindow:!1}m.offset={setOffset:function(a,b,c){var d,e,f,g,h,i,j,k=m.css(a,"position"),l=m(a),n={};"static"===k&&(a.style.position="relative"),h=l.offset(),f=m.css(a,"top"),i=m.css(a,"left"),j=("absolute"===k||"fixed"===k)&&m.inArray("auto",[f,i])>-1,j?(d=l.position(),g=d.top,e=d.left):(g=parseFloat(f)||0,e=parseFloat(i)||0),m.isFunction(b)&&(b=b.call(a,c,h)),null!=b.top&&(n.top=b.top-h.top+g),null!=b.left&&(n.left=b.left-h.left+e),"using"in b?b.using.call(a,n):l.css(n)}},m.fn.extend({offset:function(a){if(arguments.length)return void 0===a?this:this.each(function(b){m.offset.setOffset(this,a,b)});var b,c,d={top:0,left:0},e=this[0],f=e&&e.ownerDocument;if(f)return b=f.documentElement,m.contains(b,e)?(typeof e.getBoundingClientRect!==K&&(d=e.getBoundingClientRect()),c=dd(f),{top:d.top+(c.pageYOffset||b.scrollTop)-(b.clientTop||0),left:d.left+(c.pageXOffset||b.scrollLeft)-(b.clientLeft||0)}):d},position:function(){if(this[0]){var a,b,c={top:0,left:0},d=this[0];return"fixed"===m.css(d,"position")?b=d.getBoundingClientRect():(a=this.offsetParent(),b=this.offset(),m.nodeName(a[0],"html")||(c=a.offset()),c.top+=m.css(a[0],"borderTopWidth",!0),c.left+=m.css(a[0],"borderLeftWidth",!0)),{top:b.top-c.top-m.css(d,"marginTop",!0),left:b.left-c.left-m.css(d,"marginLeft",!0)}}},offsetParent:function(){return this.map(function(){var a=this.offsetParent||cd;while(a&&!m.nodeName(a,"html")&&"static"===m.css(a,"position"))a=a.offsetParent;return a||cd})}}),m.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(a,b){var c=/Y/.test(b);m.fn[a]=function(d){return V(this,function(a,d,e){var f=dd(a);return void 0===e?f?b in f?f[b]:f.document.documentElement[d]:a[d]:void(f?f.scrollTo(c?m(f).scrollLeft():e,c?e:m(f).scrollTop()):a[d]=e)},a,d,arguments.length,null)}}),m.each(["top","left"],function(a,b){m.cssHooks[b]=Lb(k.pixelPosition,function(a,c){return c?(c=Jb(a,b),Hb.test(c)?m(a).position()[b]+"px":c):void 0})}),m.each({Height:"height",Width:"width"},function(a,b){m.each({padding:"inner"+a,content:b,"":"outer"+a},function(c,d){m.fn[d]=function(d,e){var f=arguments.length&&(c||"boolean"!=typeof d),g=c||(d===!0||e===!0?"margin":"border");return V(this,function(b,c,d){var e;return m.isWindow(b)?b.document.documentElement["client"+a]:9===b.nodeType?(e=b.documentElement,Math.max(b.body["scroll"+a],e["scroll"+a],b.body["offset"+a],e["offset"+a],e["client"+a])):void 0===d?m.css(b,c,g):m.style(b,c,d,g)},b,f?d:void 0,f,null)}})}),m.fn.size=function(){return this.length},m.fn.andSelf=m.fn.addBack,"function"==typeof define&&define.amd&&define("jquery",[],function(){return m});var ed=a.jQuery,fd=a.$;return m.noConflict=function(b){return a.$===m&&(a.$=fd),b&&a.jQuery===m&&(a.jQuery=ed),m},typeof b===K&&(a.jQuery=a.$=m),m});
PNG

   
IHDR   (   (   Sy   gAMA  a    cHRM  z&         u0  `  :  pQ<   bKGD	X   IDATh1
1F6^@-y'kZ@dyɫdLO~2z_}r9oo7[ܹ	R`65@Ui]-"Uq GfP$j̣`* fS3pTHTK:qnpt̠6I
G5Tj̦fj촸ԱӢS$j̣`* fS3pT5vZ\iѩnpt̠hp   %tEXtdate:create 2014-10-16T11:29:35-04:00   %tEXtdate:modify 2014-10-16T11:29:35-04:00d    IENDB`PNG

   
IHDR   (   (    ;   gAMA  a    cHRM  z&         u0  `  :  pQ<   bKGD1   zIDATH EQM6jE2bݝ!K2g}/\)W@ -@3K,7:ׁ@k U
Hrd
sM
u ESt.s/rڧ+   %tEXtdate:create 2014-10-16T11:29:35-04:00   %tEXtdate:modify 2014-10-16T11:29:35-04:00d    IENDB`PNG

   
IHDR   (   d    O   gAMA  a    cHRM  z&         u0  `  :  pQ<   bKGD ݊   IDAT(c`  X u6w   %tEXtdate:create 2014-10-16T11:29:35-04:00   %tEXtdate:modify 2014-10-16T11:29:35-04:00d    IENDB`PNG

   
IHDR         D   gAMA  a    cHRM  z&         u0  `  :  pQ<   bKGD1   HIDAT8c5a"oK1|a~Ï?~Ne%7\(1d4F1 G#NP   %tEXtdate:create 2014-10-16T11:29:35-04:00   %tEXtdate:modify 2014-10-16T11:29:35-04:00d    IENDB`PNG

   
IHDR        A   gAMA  a    cHRM  z&         u0  `  :  pQ<   bKGD	X   IDATH?H&](v_W`5_YmFѤt?˧;=eY<#  aƷAY&IRɆh`5`u8FD[9tF'pe ͞zΧ=W]{EpK:_
0~2UE\   %tEXtdate:create 2014-10-16T11:29:35-04:00   %tEXtdate:modify 2014-10-16T11:29:35-04:00d    IENDB`PNG

   
IHDR         G#7v   gAMA  a    cHRM  z&         u0  `  :  pQ<   bKGD ݊   IDAT(ch`p h4i   %tEXtdate:create 2014-10-16T11:29:35-04:00   %tEXtdate:modify 2014-10-16T11:29:35-04:00d    IENDB`PNG

   
IHDR     d   5i   gAMA  a    cHRM  z&         u0  `  :  pQ<   bKGD	X  IDATx_gULTT,`
JI<Tй<
VZ|De`$gp
&%|˽36'P0{|83wܜk}ɜoww     6u;      7;    `    0ظ    L 6     ;    `    0ظ    L 6     ;    `    0ظ    L 6     ;    `    0ظ    L 6     feworEjc^bپ:nPFyyu-dߛ͕^Z3WɬMfS9yk9u[z_ł7s_\+%sA_mxEa/k}X@y}#{c*?6?~}?3T     X	We~ؽM')k(Ur%	y_Mm^evVrfWCXZuXbme3/y:Q.߶S7GuUTӪdvx#^yx-G׻׾UA&     h<,ކt     H2     ;    a5vwȝq=Gz[vnWJi]YWRɑ^T}R֔:Q|RRo%͠YV+sj
=UnJU)kR-ՕFW޵N==Xj%o5F֫x,˕d6/ƔJ.^߾USaڵe+1cm)^q)S:ڤS<FW΅dj\(i<eGɑ2t>-,㭓Wz5WE3HG)veZQ{múIf^yƥ֭ٹw>%:%:3Hϸ*y{ERq    
Se     &     L 6     `aU    fy	     ^     Sefa;Oz
}׵SˇU2f[nqw߁
IYV
RWƱB-Uf'%S6WʎnspOل'ׂrҳ\˷v5S[nS~53|w9
     eY\9pea'z{{,;:݂QyFGlҧ<<;z/EX
%vT{œڦbѵ<*Y|+uuKհz"75n޺e^+*)sS
-<-ך)ޖy
xuVYW>ςmYΦwס k|i     X!|
    0 Sǽq{C˒S|gg?&S>0PtfMEΠRvt[z]4]me*բ%/wayc)
ͻWy);C>~,^+uK_ymg[%+73U,גqjV˰v?0ǿ?Ӧ6㟕޻%}7A>l*ǿ>,&Be^jixklM*}شe\sͼ*Mcϗ<yq]߸    {6qKBݼQRRQ{.ADQқk=w^tl*\ϠzUm֪LZK֫R^^^ޕJA]|e]xgkYNyk8t
q~*j]WMn!eӛA=ޒo<<{2W,lӡ΀mMoNl3UO}q_otWu2zyfL)LX^W2)jX[+k=[+\[[OxןWFiJ+m+5E樓^굡oykWsIZ(]Oʛy9-ػ?yѝT     q     `',v2wsSnܓlSRѪ.%ZjnTKy%^o\yJtֳB͔oފ]͚o+1z=V؎Ru+YJu}9dk9ϫ^R5\t>'z%wbǔ%3´|Kޭ;aGgUvS$w^?^z(fᵜꫫ蟧dyf㾺%Qm|Gɋ׾]jg[
]1aG3vZѥtսg{ҳkWc,+ת[U爒Me%|*ϝZ+F~=EyD4p     6y=~/~~pݢD|??.{W4][f
:'继S	  `tOYp'|?zG"k3÷'2׿v vlq6'3݅[p?z0랾I{fτG³6wvol lx{p2 Lwמ?
bOnT~4-m.|,\
7
 	ép:=;ݓsSݝ፭~[Hlt7c]ݍ?սug=.;`  hKW~O
  ,l}ͩӍ㾭_;4f\a  _Z>>o{z{y
oL,^x/zbxBnW>Xw  0qntφ{
m7óݧ˳p{w&\
<rp{wX's[O_{I	 >߱|!\N_?аpbB
_/-;5J0iG+ſX   
^C:=ץ?xp".t-G
|f/9|>{뼣@	t،F/W}aKz{8}Ob|yvUKz)00;[Kʯ2|-iꛚJ?SsmӪBGѼEُLcZRK]l}}[&^Sa',~-?/_`e OãqyհfbiXbEZl4dſn    s    & w    	0˰?w     >    &<|2SG6x,w,)u=)]o;F)\@?mQϵk3(}֌>䭐Ʋӽݴ5'E,Ԋ&^5άueFd|5G|lW)y}t_x0     ^          H~     4f    3WSe     `q*    e    `ÙeT    ͆S    &@e_N'ۤ*x-}R*SؚԭqVR+^UJ"euJfzlz}G37^^5[relѕLzz#zJEyV<ک]Z<O-O=Z    N         0as    ë2     `',v6z)c.x*9ҟZ>>zWJR]t=?	d2G+-ݾ^>mkLYЂJSlz+Qfwezt˰v3/ٯ~g        LyX}6     <,     l6é2    vòU    
2'U3tujJj|%u7MYU[Q+j(
lyMϣRy}mUXlFW
%>}E<V&gܻcb][rkyzr)yuIW)D$͔}czTK=ާ@>D֋fRZR{"x#[gGg3kPuN#?ۏ+w^q2=Q%tb}(lJ꠫Z^e?6llyU(Q(ӕO;_%/j]8޼uF^5fKE$sM;QuЭzv{hGuȦn~oY؞kmp+ަ{-ގ-t˶}2azS~֚v{G[b!/׵"^/k-*Į
:GOd[{K(R}o5zs7u>]+*ܫVU	%9b?Rf     `%̯>[f[<F7ܪ2|+YKl&RϔڲNޟSa'\J]ۙڤ*cqOoI.tXR)TC(ʈ6z,v*֫[:Inxk>%w̋W<v.=kizfPvs+#=.oysd'[w>J$ֻ\oܗ^f]nJ|7ؾ}65J|7%5>Em_=eV /)m۵dgSWWNBʪ	zYcX˫.}(Z>tUKfJz+dPS'ZڊyOXj=JW~i     
f<&uXRkƭE;7S刺v>xS*kGQJ"ڜo7AZ|צŨyn[j`-#GO
p:X(T1%ǁU0} <OdK׶1&[7zԊ1%+1Wg{֔Cl[譺Cy*7忽2+UTҏS̛Q+C$#ywKæS͑Z̎Z>U=)zNz,˰vϞw     Vȼ^-mqJݯMmq:E7J-NQSjN𰕬unIzEf7oŶ^e5{׸~u+YJu}9dk9ϫ%g(g(}
ObN(Z
wMɌ0w_:_
˰v,l˿׾p}`|7u]<g!F5=n.uWDG-&>WJ[ɔe%hT>Cˣn珒}ExgJUFT7Fj*تz[oFVZsD
NI~ujEn<c򞹵fW2n}le     +a޿{GW?n7     <a`c_   %tEXtdate:create 2014-10-16T11:29:35-04:00   %tEXtdate:modify 2014-10-16T11:29:35-04:00d    IENDB`PNG

   
IHDR      d    2   gAMA  a    cHRM  z&         u0  `  :  pQ<   bKGD1   XIDAT½
@@ я4tU3#U9-xy<'+w-n[bfL1&T<2GR.   %tEXtdate:create 2014-10-16T11:29:35-04:00   %tEXtdate:modify 2014-10-16T11:29:35-04:00d    IENDB`PNG

   
IHDR      d   t   gAMA  a    cHRM  z&         u0  `  :  pQ<   bKGD	X   IDAT(1
PDSZ6M!rKJFf,>Ao`x;,,cs p>҇uQ`߯i%S)~ζrV
=O･ pl:]ZO?q|   %tEXtdate:create 2014-10-16T11:29:35-04:00   %tEXtdate:modify 2014-10-16T11:29:35-04:00d    IENDB`PNG

   
IHDR         Er@   gAMA  a    cHRM  z&         u0  `  :  pQ<   bKGD "b  TIDATxm%Uy
$!,h ,%&@|IEMrݱD2;f܉A^$5Ƣj^K@U-wWD`|q"t>ν3}S~9}<><yNp	M)`	pxht% yYD^`Or%`:
$%{ 0LL?a|6܉]A7P'@/:]5JH&ay2:8ty@#*'?t緝;Ywגm׸ {>|Dg7\J{4K3tfZޱ`7u7Yɶ~f]<4m*<%%{^`FR 
	l8<Oh8<Ok2 n6cL`>]=u$,`&+hk6J_*|K0 ?@lxdom]L3ݞߌ0.;TE,;4tMOmPLUA&e+`8u]577~"h8<Oh8<]C8YsZ}iA ֠)Ȟs W.!m.
z[#R䨚
\R{v
r	R ?˝#[|f` y)A-QN
4wϮ:Kr{河3ZP!0t{l\YwSnPIA.Vm-R
$ysI@;eغX.vYvB
 n]gWcVn*ôy T=Mhpt
+3
'@	px4 
'@	pC`=x?.jlk]R
Q.ޫ5@P,[Zj6ƵKɟڕ[ ,P/5/thzG]Yn!wk9څR+@Ktťa.mKuD<i5Еcn[@z@VmPgQOc:Ӕ%{%܄.緯ןߖF {h'@{"ȕ.=>M篂U!LgK\At$VrX˒ `LoMe/R+X.X.]L]Nq%e 7w"<
ּp뻴ʩ@	 uǤ
OO7 
'@	px4  PdrvM{wQve{Ȯ]0d1w%L,vQwqyyx`]jW.!WWl/D3,v܁6]iZ<:IݯtM~9UPi!snS!QyU緯lJȚ!$(7-/ޮB¤F[^)F#*U$`7\!OUŪ3ǐ_J:𨃏ܽX6X!|.!}t$ePROQա/P[Cmb,=XA!tho14]Zh=Oh8<#@keEٲM&IKѢ&b04(.%thtIH2>Dgͳ]ݢ@NE]hɟ|T=m5@.#BW2wQ׿¨alrvEb)n#ය݄F/N6%t]KX"nz"t.'`[A-<d #]/\#
sDbVGӫ
@u>y-LTi 	rgW=)lj&˺;YeF,6CG_0l;y1| 5'@	px4 SLT_ʿߐ:ADV\cK
!e8L}F{=.y0~w,ݭ9^n	gH<sٌgd}ܠ):$:N"<S!,qg
駹\v'g{;W3pImbni;J) s <.$_.[5{IV\ⷸ"[$@d	Ke%b!ѮFn0#l§8 o($%f)@6[L9(?Ko?wjSl2^9 EL
VH)0ͭ!k@}CnU:l|4
2sPRQ,Qgdp6صpKi*B?O_1?Ʒd'%d;§\k:?r7p#'reL3[[$꿟3D
N_8״)<z'i>]Y,b}H!0La4-Uڣ$R|crQx/a_seRmDz $V\
3<ɔ0㗹1VD<n&S	LC4*5O`KA`5D$n}5Bf"GPM	rU/j"$!f+{/fjtkPt쇘S ӹr#q>#a=5!*,6~ ^#Jt
Wg{ȃsd,o9X1	?*uuB,=`޻'1l$[Gx4 
'@	DΞ -z)E}:g˖	gÁyk>fiNa~ɏk`.73PȸҜ;+
ZpMlbinFݬLپȓ4 :a.0JN.pk8NPx\lh݅x2iǹ?OH5M@.K4p\a/>ay%^zU25O'0VOsMR4"0VܞFqyYEL0])PK~Irx/Qs*SL1fn>6U4>i#\}cJjrjo_u8n,JFgyFk6a[0y|kS\6+)L*g	EDخq|Y_'-?Z";<Wϼ=
[\IL}7OqX
4<z7=~CP6w'ƟL~*?7ȳg %npMBC{
L^O2;C!<n$7B5F&XQ?̧>-c%DP]y_VaX1uҗEc_t'[PP>`4B "O7ՑF3
 <5ϝ|B.0#bb],ҥK{/QWܯd0~.ꏜ}eK
Y@3>?_"X,u5OԘ(xsG4DI 
4 
'@	p4 XNIMs(,ѡކ<&R=>@]ZG^
_Hk|p7rFp,/^>G-B+7(z3d-A^'qzj
z_`I:L0T|aɄ܇<SIU̅囌3I'.GÓҐl{UR̌"gh.Gj,NUi0`rƀ1 GlKTQzy"?or>'/CTS̤
U
(.2Rr ?<
aGBKsRƔ[IlcylU_ɷxO 	QH1NcӺ#?5f4ߣ 3lgGA<aW9w@I68F߮U3hC'aQ?m*w\9$;`[6q5e(|E"8ODHF+~Sm<*Mʖ
._S9<ΐҫQw ŉW)p?
gW,

'!pFQ8_/_z {!XZ7&9W&Ef!GU)Y:l{`s6Ãld,GyxIC
_kJwiKs88Mq,y
SV{ycPI#ిűoos:*i@Z8]^ext7)%-T,)O\NKQ|0w fKl.Xګ=_;fl⧅;ϱm ]/OB.ySW/))xsp;+<.pƴjqICE[kOy  
'@Q$6^=|;6o\
|ˤt_⽃G}{KT{q8b
 vK"kK/n8'@e6e^jԪp؀l)l㩻7hkdC]H4nnF[:b	l[ꑬ'n(|[Ƹ4%t]BFh%Z`%>njԄ&"\r'VZvD)ykCbW;I[k!fuiQ*tWsN_~W<
g)'8}ږj HzD6 6Dkx3?xFy
zno O+v,bcxsLwxtnGĝlNn2ھIOΐlƟw
gkг=ޜlAl)l[k;)"W2:-.H٥aq66$\0oqǌcC[Oh8<O":F@j1Xg dbݖ3<cw
'úlajdiiK[:Jw@!? ~iy
0\]#cY9%&
BsQ@6[sJ8NIW߭C'QۥdFPM P8a# $Q(+K	:eBziX|N~<ƜGc̥5P\|t+ss(A[P} 
|-Vܘ `UZLhv$0sƼyihH ?KQ`a#d*AS#\j=i,]6 
'@	px4Ezl@dh !MUc]"!@n~RJ%O2!Eah=P~`$AGSr52rb&ATZ-JC -W8?<8ʽ*[4FTjGp8&)vU<Uji,~|?=lWj ˻RR$3}n|TK 5..NQE\)k)ʿ xS,qEi!{ q}g.r
gUSqs=W2^ ).[ABhW.ywȼ=}06O8A6ϫ
O
'@	px4lԕT
ž--@]-\A+õ2{]$g-h"MM-|9ZvY?0䷕_,mo9	aa.IK*VJ6[B:n.aP/0Ks Զ_rSFOVh	 (ɸ5@Y	P}x5yoEZ=UJȯ|?tk3=hvn'SO!` Շ]~r	պpSn=ҝ/A=p/cNء葜&(G)JG$6yI/,MP%P(iCC~[vWB篾ꒈV$˹}工(k&
Z^8S8>zELHWW+wx0-pxk`	px4 
'@	pAܣDkH2u]AzwnPExFyAum	0F0bG:1;L6|CGICHRݿ6y~˘{o}@]Q~"h8<Oh8/~B	P-d׻͒ £"D
;R򠫹 `d] a{ -+PS#R3@O z-̒
¿rvJQz `W_9HGx\EA2͌r͠&~U >wS[Σ- `9'C~C@eCٹq_	X zN   %tEXtdate:create 2014-10-16T11:14:19-04:00}#`   %tEXtdate:modify 2014-05-26T11:47:31-04:00(   tEXtSoftware Adobe ImageReadyqe<    IENDB`PNG

   
IHDR         IJ   gAMA  a    cHRM  z&         u0  `  :  pQ<  PLTE"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""anX   ZtRNS XG|"2wfZNz@eSFcaMhms}䁎]bp
Ιi8*yѧȓد͐ǫʄ   bKGD H  kIDATx]c۶H阒K8n&s6/^]umԦk:z;<RhlG @Y dMز0rz7/	f@eb`@c`r~&A-
29~
tΠ 2'L`Dzx0 O ;)>LS:1ǀ5Ի BEDDDDDD	nJXyO4'| J f7ńU@	D!!~{=ɖsLBI`܂fhm,ףmV$=dc@.=siށG/BܽǷJI<\i

뷕#: HleF<\|Od1s9+3;-˟5ׄH,0n9o=DOH./H:ݩ۾\dDDDDDDMEm=݌Ĳ]
.Uր*lm .^NɊtoozQ?/OZ6'^{Å|xK,=#m [;'aK4k4jeNϷ؀tF koNX {pd0	z`]t`ę1XLB $
KZpN y~>&"""""bԸܻ8wTȣ36Xn;g`Z/'ʎ;7}jmtxշd 0O/!`//$3j^_pМ7N@nH,0o'i  M}RY@;=[҉`Oa<1^CBk_DDDDFzod|U5i)bz_ip5RRWbT!l@R5Cf|Be:.3mG/t{߈"gM`\X9A))SXb7t,iX;6*@+4tF#HM
21&C!O
/+n}HFH@_t?""""f!S~B~[[Cn*7r`r\*f49qK E
@gJqW8d(n '4*^QLWmREsC߶Tf+[uzI	tUm5AZQiB  1 D' YDJCc8]&{0 TG$!	&jI`
CU\h<@{1{.J}LiR 7m>HUxWiJuy U>b.pK!/|oOׯ$@nr@I0pxx`_2 ?- x~9pT
GDt'=!|/\
c&, ۟N&B} <9~Fu!y;L`X\!-&-%b21v
F.7N NU~ # 
V홛s0uW80-p %dC-Jtv7DDDD?=6m#AGmQ#vckyޞ[&kBdu@6?43ES&wZGJE?]yYi2=\kh5(3Tq;1cr7o_;9f~/_{Ao
BA?6Bn&HV_,\
ٯ.R:V3mt	fO<}v6ʤ}g=^`Od|xS߷kg>80v(,`
uh.l)cb,Cjj[Rߧi2Ǳ1@&Ƀ?/	HujgOc|(9hha0C#^$da#$ ɟrwv__~Sz¼zuZZVwZ	jP*ܓ@&
wH8,<Or%@s>StQsM?N{
0>yAAQm=X	rqQt
(""""bi1\y[U޻iA
+·@W_
_)K?܇'O&hVM9̦/a!Q	¿+,iӍؔ=d]:t3*AW1^n_IrJ4 M=ݷ=SP-#PNF
*Rkgj>L
Wu4K!Z?5Ci/e0!2uPT)9-`>3^jMQi`ol _]fv%e(OH4p,DϞ?;u@-Rnfjġy&+[}J|.Ȇs8;S /A2|_5JGW{pPaisfgggpMYs=a%G@jhm`i%c L0k؇ ?GaHHI=_"Q&˚
ի#$.W1`s2"""xwm7j@\ \ͨ㶛5)uꎣ޵
,aOřy,_/h]\ h޴9`#
M	[zKuO_z˿Dܫ*kOJ(7v\e
IT}aTna*baoۺHXaEzn
NS&Sn4A@r8OW+&bov,
zh&Tǀa5:=SD0}b!pZpވXG:`?iYx60يKF>3ȬDP#^>@(0(RȠBFWmA|%CB6 &&UZHh 	"07B L	(?F3:&`f)!nE[c ǀ|cw`~@DDDD͆9~ݔ^
\)\7UV?I@+3 }T&
)
s!N֫CњjE&n߆s?'5{Ov9(-o_HuKJGPZ)j\X_ThM<:{y a!)l?\
>WޠdܵrLuW^hzn*w}>.ϕox^V2U+3N_7]$邶_| ]rSWp(?Og-?h_!\_LCV47L!~B@=ug#`BB-Ⳁ3Q6.}v)ASY2p>`ԚAPbt*U I맃Uh vڑHuڕJw#""""""<KG5$ / ?=7$L%7vDcMDDDDDDDl !5!hHDk@U@RPno/_ڵ7S_CuW_kU_8c@ ZcAw1r}݇O   %tEXtdate:create 2014-10-16T11:14:19-04:00}#`   %tEXtdate:modify 2014-05-26T11:47:31-04:00(   tEXtSoftware Adobe ImageReadyqe<    IENDB`PNG

   
IHDR         IJ   gAMA  a    cHRM  z&         u0  `  :  pQ<  PLTE18   ZtRNS XG|"2wfZNz@eSFcaMhms}䁎]bp
Ιi8*yѧȓد͐ǫʄ   bKGD H  kIDATx]c۶H阒K8n&s6/^]umԦk:z;<RhlG @Y dMز0rz7/	f@eb`@c`r~&A-
29~
tΠ 2'L`Dzx0 O ;)>LS:1ǀ5Ի BEDDDDDD	nJXyO4'| J f7ńU@	D!!~{=ɖsLBI`܂fhm,ףmV$=dc@.=siށG/BܽǷJI<\i

뷕#: HleF<\|Od1s9+3;-˟5ׄH,0n9o=DOH./H:ݩ۾\dDDDDDDMEm=݌Ĳ]
.Uր*lm .^NɊtoozQ?/OZ6'^{Å|xK,=#m [;'aK4k4jeNϷ؀tF koNX {pd0	z`]t`ę1XLB $
KZpN y~>&"""""bԸܻ8wTȣ36Xn;g`Z/'ʎ;7}jmtxշd 0O/!`//$3j^_pМ7N@nH,0o'i  M}RY@;=[҉`Oa<1^CBk_DDDDFzod|U5i)bz_ip5RRWbT!l@R5Cf|Be:.3mG/t{߈"gM`\X9A))SXb7t,iX;6*@+4tF#HM
21&C!O
/+n}HFH@_t?""""f!S~B~[[Cn*7r`r\*f49qK E
@gJqW8d(n '4*^QLWmREsC߶Tf+[uzI	tUm5AZQiB  1 D' YDJCc8]&{0 TG$!	&jI`
CU\h<@{1{.J}LiR 7m>HUxWiJuy U>b.pK!/|oOׯ$@nr@I0pxx`_2 ?- x~9pT
GDt'=!|/\
c&, ۟N&B} <9~Fu!y;L`X\!-&-%b21v
F.7N NU~ # 
V홛s0uW80-p %dC-Jtv7DDDD?=6m#AGmQ#vckyޞ[&kBdu@6?43ES&wZGJE?]yYi2=\kh5(3Tq;1cr7o_;9f~/_{Ao
BA?6Bn&HV_,\
ٯ.R:V3mt	fO<}v6ʤ}g=^`Od|xS߷kg>80v(,`
uh.l)cb,Cjj[Rߧi2Ǳ1@&Ƀ?/	HujgOc|(9hha0C#^$da#$ ɟrwv__~Sz¼zuZZVwZ	jP*ܓ@&
wH8,<Or%@s>StQsM?N{
0>yAAQm=X	rqQt
(""""bi1\y[U޻iA
+·@W_
_)K?܇'O&hVM9̦/a!Q	¿+,iӍؔ=d]:t3*AW1^n_IrJ4 M=ݷ=SP-#PNF
*Rkgj>L
Wu4K!Z?5Ci/e0!2uPT)9-`>3^jMQi`ol _]fv%e(OH4p,DϞ?;u@-Rnfjġy&+[}J|.Ȇs8;S /A2|_5JGW{pPaisfgggpMYs=a%G@jhm`i%c L0k؇ ?GaHHI=_"Q&˚
ի#$.W1`s2"""xwm7j@\ \ͨ㶛5)uꎣ޵
,aOřy,_/h]\ h޴9`#
M	[zKuO_z˿Dܫ*kOJ(7v\e
IT}aTna*baoۺHXaEzn
NS&Sn4A@r8OW+&bov,
zh&Tǀa5:=SD0}b!pZpވXG:`?iYx60يKF>3ȬDP#^>@(0(RȠBFWmA|%CB6 &&UZHh 	"07B L	(?F3:&`f)!nE[c ǀ|cw`~@DDDD͆9~ݔ^
\)\7UV?I@+3 }T&
)
s!N֫CњjE&n߆s?'5{Ov9(-o_HuKJGPZ)j\X_ThM<:{y a!)l?\
>WޠdܵrLuW^hzn*w}>.ϕox^V2U+3N_7]$邶_| ]rSWp(?Og-?h_!\_LCV47L!~B@=ug#`BB-Ⳁ3Q6.}v)ASY2p>`ԚAPbt*U I맃Uh vڑHuڕJw#""""""<KG5$ / ?=7$L%7vDcMDDDDDDDl !5!hHDk@U@RPno/_ڵ7S_CuW_kU_8c@ ZcAw1r}݇O   %tEXtdate:create 2014-10-16T11:14:19-04:00}#`   %tEXtdate:modify 2014-05-26T11:47:31-04:00(   tEXtSoftware Adobe ImageReadyqe<    IENDB`PNG

   
IHDR         IJ   gAMA  a    cHRM  z&         u0  `  :  pQ<  PLTEzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz=b+I   ZtRNS XG|"2wfZNz@eSFcaMhms}䁎]bp
Ιi8*yѧȓد͐ǫʄ   bKGD H  kIDATx]c۶H阒K8n&s6/^]umԦk:z;<RhlG @Y dMز0rz7/	f@eb`@c`r~&A-
29~
tΠ 2'L`Dzx0 O ;)>LS:1ǀ5Ի BEDDDDDD	nJXyO4'| J f7ńU@	D!!~{=ɖsLBI`܂fhm,ףmV$=dc@.=siށG/BܽǷJI<\i

뷕#: HleF<\|Od1s9+3;-˟5ׄH,0n9o=DOH./H:ݩ۾\dDDDDDDMEm=݌Ĳ]
.Uր*lm .^NɊtoozQ?/OZ6'^{Å|xK,=#m [;'aK4k4jeNϷ؀tF koNX {pd0	z`]t`ę1XLB $
KZpN y~>&"""""bԸܻ8wTȣ36Xn;g`Z/'ʎ;7}jmtxշd 0O/!`//$3j^_pМ7N@nH,0o'i  M}RY@;=[҉`Oa<1^CBk_DDDDFzod|U5i)bz_ip5RRWbT!l@R5Cf|Be:.3mG/t{߈"gM`\X9A))SXb7t,iX;6*@+4tF#HM
21&C!O
/+n}HFH@_t?""""f!S~B~[[Cn*7r`r\*f49qK E
@gJqW8d(n '4*^QLWmREsC߶Tf+[uzI	tUm5AZQiB  1 D' YDJCc8]&{0 TG$!	&jI`
CU\h<@{1{.J}LiR 7m>HUxWiJuy U>b.pK!/|oOׯ$@nr@I0pxx`_2 ?- x~9pT
GDt'=!|/\
c&, ۟N&B} <9~Fu!y;L`X\!-&-%b21v
F.7N NU~ # 
V홛s0uW80-p %dC-Jtv7DDDD?=6m#AGmQ#vckyޞ[&kBdu@6?43ES&wZGJE?]yYi2=\kh5(3Tq;1cr7o_;9f~/_{Ao
BA?6Bn&HV_,\
ٯ.R:V3mt	fO<}v6ʤ}g=^`Od|xS߷kg>80v(,`
uh.l)cb,Cjj[Rߧi2Ǳ1@&Ƀ?/	HujgOc|(9hha0C#^$da#$ ɟrwv__~Sz¼zuZZVwZ	jP*ܓ@&
wH8,<Or%@s>StQsM?N{
0>yAAQm=X	rqQt
(""""bi1\y[U޻iA
+·@W_
_)K?܇'O&hVM9̦/a!Q	¿+,iӍؔ=d]:t3*AW1^n_IrJ4 M=ݷ=SP-#PNF
*Rkgj>L
Wu4K!Z?5Ci/e0!2uPT)9-`>3^jMQi`ol _]fv%e(OH4p,DϞ?;u@-Rnfjġy&+[}J|.Ȇs8;S /A2|_5JGW{pPaisfgggpMYs=a%G@jhm`i%c L0k؇ ?GaHHI=_"Q&˚
ի#$.W1`s2"""xwm7j@\ \ͨ㶛5)uꎣ޵
,aOřy,_/h]\ h޴9`#
M	[zKuO_z˿Dܫ*kOJ(7v\e
IT}aTna*baoۺHXaEzn
NS&Sn4A@r8OW+&bov,
zh&Tǀa5:=SD0}b!pZpވXG:`?iYx60يKF>3ȬDP#^>@(0(RȠBFWmA|%CB6 &&UZHh 	"07B L	(?F3:&`f)!nE[c ǀ|cw`~@DDDD͆9~ݔ^
\)\7UV?I@+3 }T&
)
s!N֫CњjE&n߆s?'5{Ov9(-o_HuKJGPZ)j\X_ThM<:{y a!)l?\
>WޠdܵrLuW^hzn*w}>.ϕox^V2U+3N_7]$邶_| ]rSWp(?Og-?h_!\_LCV47L!~B@=ug#`BB-Ⳁ3Q6.}v)ASY2p>`ԚAPbt*U I맃Uh vڑHuڕJw#""""""<KG5$ / ?=7$L%7vDcMDDDDDDDl !5!hHDk@U@RPno/_ڵ7S_CuW_kU_8c@ ZcAw1r}݇O   %tEXtdate:create 2014-10-16T11:14:19-04:00}#`   %tEXtdate:modify 2014-05-26T11:47:31-04:00(   tEXtSoftware Adobe ImageReadyqe<    IENDB`PNG

   
IHDR         Er@   gAMA  a    cHRM  z&         u0  `  :  pQ<   bKGD ̿  :IDATx]m]Y~)*|&q4!KK$dk~#>uҪn?vBRi]9?7Z?XST18jڵCOi"k>8ܻ<{yg9gwfNBF]" pDu! ":XM_?}M&
9CD!5N"%}cc?7i5<6
z͕!@<yZs.Sw:nP(^z
w6
z(ק n%s-@?sp?֤ F4߂:F]$$tXu1 #ZG$@ # pDHiG]ftyimJͦZ|| /2/2Wo 79rm*]]oe^r7&oJ]\@vl u>Ǿ^ kޠCf9s	`at>˿!G4H	8"G$@ Q`@HFxPw7K>Fe	YTIuN9˷ B
Yj{WS'\䨛گ>*%EpU?9}@>U0_>Y	DԀ"/|Ot6MJ@EꄕgΒ_^2Enϻ2K UqagkOG6[lO6Ueٻ@7yX.uYnR	Twp裀}8 pDK` # pDH	8Dt@hpihtzVZx.~9[㷬̷ywuX[0N.eytiR}Xn-Ob9^NmFQ>[/N:o93O - }} tT=I~%("һJ{ͥtyrW 0vHx!>w>m篃g?IGG+ARԖ3Il]trӁKgޅނr)+N"®&4E5<Aӯ.|rG "q\|_@D(	8"G$@ 6V\y}
Pc楳NǺ+v0f+>0|-M-qTK?PDfla64Җq=rd絧?,:y5,՘X.tu=חT8ʝ;{eXR;xلUFg9WHK@oB¦FW៳m-F,~:E[6pygؑ=Cȟ\\cL/Bqxll2FׯIQ~J˛yw<fRQ*ƨ;f8m!ǳ1~>n)y>'(b34Dw隷
 #G$@ # p
ϗmsِ-zA}NpAyVmWwu<;2Vj;Xe)_	ĥ%ҮHcՐ>VoSuYBAd-wiQrLe k	Ehmf/ouI\#`|߶D'v@)a	t50OeaT4%/k	(?EL
.'FvnGp=G䳉]6"@Q 	 ~ƍm ) FgVĝ10B[~4ORTq0,G0nb/ bK	8"G$@IP?V@sdk.5t]5݊ݚ9 h:e+L:e8YJ	:
-z+<n&H}źD¾Ezr	]M5uE-"s谵D]"Fj ,  A.pDq&&$$ʙ,1߯)I
$8VuƄY	g1g\krfMJISLb!& PoQZ+n
Y"8W;w)~KoUFpu|Y>4ƸϒUܐDW)NfqJ؀憼-~	-2#P'L.(G:ő/<)~ܒ1|z(]gpY#@IYbsh+z~Z->
a:f1Wm-r3N*~ w1  β2WS 88	`<|}{>y 3	zR.3u
~W; 	j8ۤ&s Lq o3." ;~/`1 w0{-JfqU҄gB.bC8I˞0
	B4>'HRmf$ޕ\/_Az˷	l{pH1נ_kY   0F0$l0a`>H*?M貣mՆnyX{b
A`O<:>.~ߨՍ78!\=hLt#;Q # pDHdAp-6
GFӡEܤYa:Ia"_Q+y %GЫn`G}_BK]JaZ"M"k"V"{e
l"Y=ېƙlyԨJzAk2ڵo-kƤ>'mgV0b)@"|`pK!W]
&'n2-0$9Ԣy}Wn+|EK.-;8wRaF-rNs'66pXw]a?;C~؋o|+X}ź]\1XL-~ 
m @P ״9u* bg"zBD?	
+rX/NRUߗ%ٗ<NfDЛx>L3_˳LH'igKU5"&g9ᙊPu3M;"j,k"Pa'~zv!ڠ'1tS1*n[&AP)o% !#Wy(]T')Q&r8r) ^;ك
ݡnϡ3mҲ]*f5kZ]NdESyߩ~0@ې\pVKm|
Ud~R #G$@ #<ncnL+Fg7{ݞ1t1FvX]ƌ6g׍EՑ:C'i~Bz$}3tRK_ZB9k0H]]1G-"gK$@?+4kTI/En9Κ~?C-t
xM~L67ۍ]LQ8Q$@nϑshQ^Oi7B	D+|'ym ,
 i+M#oѱ,dr {;QT>cw-\  \g|m<n- ヌ
N tp)&c=-90IvFAO XpݾwU`?& ăayqh65)XUh	'=*ºUҺE5[,=+Z_@xn:x<W ]z;PJ| p㓸ܓ5r\@)wig
)9@U?i/ҭ1 .iߓ^V|xNnNc' d0{3.hr]<H`rgϔW~?-IGoá,q_ p	!f _nNǚul{p{;1ҋ &p&0	 'ud(scGB+t*dzv]Ga q-𣀕l0!pD 0JC	ѷHOGQK<u,Dʂ6t[`]AڧڴmJrC8DH C%"kxxrxG]@~|:⽦?_u#C^ tBAe;fsqO1IiyvcaLQg~K-Ik̸ncvU.9f1>lPmʯ/I
~Pq<mg|LfhE/s%[DErmͰBea7IV2ŷ3"po/Zr =R!* |-t3ߗ v}wfth6iƐ;8p
C Wȕ?UIl
$ +j*0ӏMm|djv
( 3r
 &XҤKF5LֆF w<~e߯oɨ.1E870pDH	8"G$tB$ a10WB
p*	JGaƉ UksFц%M|Eʩ06<R-06K7I6fiRr0އ 6ѣKwITI~Z 
߲ByL0wRn6
CM,7jOnbH'/6	,G&o
v7@cN~p62`; Ht[
Tó..݆8"G$@ C% 	/ %< `/FZ.9X-}g+xS+je&d-NDD /RrM~ͣ~Ô`RnE6NN)uʶ;ն0DidN+xW  *ǣt38c8`
&  ai} avÌNpdэ/R_@/8z{qUp	lz}?~fqj&d]oⒺB8-g |ac0Ktn= Df0tO>__>}C@8r # pp|o7
[>Z^YפbSkaˇ]Qk4q8]Dk*wm49l7jy+:񕭏1Dղ%+5awU~{J/5R𵮈TZ,
"O|	QI_Q5}K~|2]~ "Uq;G}rR~W͟
5<skwu!>'\,>}x
oͻxsum+O)Dz@)ʗ(w/)rS%99娑*bo/M@7\
M* CcLOUWm	rOUU@ZWEƄn!jڡ:OoAZԦf!1b[>Z^3	!#zG$@ # pD;e<dodmT1voT̡ٕ4!BJ װfObMt(N@5}
ĤUI+A	d&TDT~ڞCEA~ zG4H	8"G$@ۗ hd4 t^ptg	 2fNտ<bXF?@ W
̪$z4yF^[	efb?j/gA(;ٟ:KZtqar
.c_֠8տĖA3`soC8Ǜ	мVխ~0Ac"|޻6   %tEXtdate:create 2014-10-16T11:14:19-04:00}#`   %tEXtdate:modify 2014-05-26T11:47:31-04:00(   tEXtSoftware Adobe ImageReadyqe<    IENDB`/*! jQuery UI - v1.11.2 - 2014-10-16
* http://jqueryui.com
* Includes: core.css, accordion.css, autocomplete.css, button.css, datepicker.css, dialog.css, draggable.css, menu.css, progressbar.css, resizable.css, selectable.css, selectmenu.css, slider.css, sortable.css, spinner.css, tabs.css, tooltip.css, theme.css
* To view and modify this theme, visit http://jqueryui.com/themeroller/?ffDefault=Trebuchet%20MS%2CTahoma%2CVerdana%2CArial%2Csans-serif&fwDefault=bold&fsDefault=1.1em&cornerRadius=4px&bgColorHeader=f6a828&bgTextureHeader=gloss_wave&bgImgOpacityHeader=35&borderColorHeader=e78f08&fcHeader=ffffff&iconColorHeader=ffffff&bgColorContent=eeeeee&bgTextureContent=highlight_soft&bgImgOpacityContent=100&borderColorContent=dddddd&fcContent=333333&iconColorContent=222222&bgColorDefault=f6f6f6&bgTextureDefault=glass&bgImgOpacityDefault=100&borderColorDefault=cccccc&fcDefault=1c94c4&iconColorDefault=ef8c08&bgColorHover=fdf5ce&bgTextureHover=glass&bgImgOpacityHover=100&borderColorHover=fbcb09&fcHover=c77405&iconColorHover=ef8c08&bgColorActive=ffffff&bgTextureActive=glass&bgImgOpacityActive=65&borderColorActive=fbd850&fcActive=eb8f00&iconColorActive=ef8c08&bgColorHighlight=ffe45c&bgTextureHighlight=highlight_soft&bgImgOpacityHighlight=75&borderColorHighlight=fed22f&fcHighlight=363636&iconColorHighlight=228ef1&bgColorError=b81900&bgTextureError=diagonals_thick&bgImgOpacityError=18&borderColorError=cd0a0a&fcError=ffffff&iconColorError=ffd27a&bgColorOverlay=666666&bgTextureOverlay=diagonals_thick&bgImgOpacityOverlay=20&opacityOverlay=50&bgColorShadow=000000&bgTextureShadow=flat&bgImgOpacityShadow=10&opacityShadow=20&thicknessShadow=5px&offsetTopShadow=-5px&offsetLeftShadow=-5px&cornerRadiusShadow=5px
* Copyright 2014 jQuery Foundation and other contributors; Licensed MIT */

.ui-helper-hidden{display:none}.ui-helper-hidden-accessible{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.ui-helper-reset{margin:0;padding:0;border:0;outline:0;line-height:1.3;text-decoration:none;font-size:100%;list-style:none}.ui-helper-clearfix:before,.ui-helper-clearfix:after{content:"";display:table;border-collapse:collapse}.ui-helper-clearfix:after{clear:both}.ui-helper-clearfix{min-height:0}.ui-helper-zfix{width:100%;height:100%;top:0;left:0;position:absolute;opacity:0;filter:Alpha(Opacity=0)}.ui-front{z-index:100}.ui-state-disabled{cursor:default!important}.ui-icon{display:block;text-indent:-99999px;overflow:hidden;background-repeat:no-repeat}.ui-widget-overlay{position:fixed;top:0;left:0;width:100%;height:100%}.ui-accordion .ui-accordion-header{display:block;cursor:pointer;position:relative;margin:2px 0 0 0;padding:.5em .5em .5em .7em;min-height:0;font-size:100%}.ui-accordion .ui-accordion-icons{padding-left:2.2em}.ui-accordion .ui-accordion-icons .ui-accordion-icons{padding-left:2.2em}.ui-accordion .ui-accordion-header .ui-accordion-header-icon{position:absolute;left:.5em;top:50%;margin-top:-8px}.ui-accordion .ui-accordion-content{padding:1em 2.2em;border-top:0;overflow:auto}.ui-autocomplete{position:absolute;top:0;left:0;cursor:default}.ui-button{display:inline-block;position:relative;padding:0;line-height:normal;margin-right:.1em;cursor:pointer;vertical-align:middle;text-align:center;overflow:visible}.ui-button,.ui-button:link,.ui-button:visited,.ui-button:hover,.ui-button:active{text-decoration:none}.ui-button-icon-only{width:2.2em}button.ui-button-icon-only{width:2.4em}.ui-button-icons-only{width:3.4em}button.ui-button-icons-only{width:3.7em}.ui-button .ui-button-text{display:block;line-height:normal}.ui-button-text-only .ui-button-text{padding:.4em 1em}.ui-button-icon-only .ui-button-text,.ui-button-icons-only .ui-button-text{padding:.4em;text-indent:-9999999px}.ui-button-text-icon-primary .ui-button-text,.ui-button-text-icons .ui-button-text{padding:.4em 1em .4em 2.1em}.ui-button-text-icon-secondary .ui-button-text,.ui-button-text-icons .ui-button-text{padding:.4em 2.1em .4em 1em}.ui-button-text-icons .ui-button-text{padding-left:2.1em;padding-right:2.1em}input.ui-button{padding:.4em 1em}.ui-button-icon-only .ui-icon,.ui-button-text-icon-primary .ui-icon,.ui-button-text-icon-secondary .ui-icon,.ui-button-text-icons .ui-icon,.ui-button-icons-only .ui-icon{position:absolute;top:50%;margin-top:-8px}.ui-button-icon-only .ui-icon{left:50%;margin-left:-8px}.ui-button-text-icon-primary .ui-button-icon-primary,.ui-button-text-icons .ui-button-icon-primary,.ui-button-icons-only .ui-button-icon-primary{left:.5em}.ui-button-text-icon-secondary .ui-button-icon-secondary,.ui-button-text-icons .ui-button-icon-secondary,.ui-button-icons-only .ui-button-icon-secondary{right:.5em}.ui-buttonset{margin-right:7px}.ui-buttonset .ui-button{margin-left:0;margin-right:-.3em}input.ui-button::-moz-focus-inner,button.ui-button::-moz-focus-inner{border:0;padding:0}.ui-datepicker{width:17em;padding:.2em .2em 0;display:none}.ui-datepicker .ui-datepicker-header{position:relative;padding:.2em 0}.ui-datepicker .ui-datepicker-prev,.ui-datepicker .ui-datepicker-next{position:absolute;top:2px;width:1.8em;height:1.8em}.ui-datepicker .ui-datepicker-prev-hover,.ui-datepicker .ui-datepicker-next-hover{top:1px}.ui-datepicker .ui-datepicker-prev{left:2px}.ui-datepicker .ui-datepicker-next{right:2px}.ui-datepicker .ui-datepicker-prev-hover{left:1px}.ui-datepicker .ui-datepicker-next-hover{right:1px}.ui-datepicker .ui-datepicker-prev span,.ui-datepicker .ui-datepicker-next span{display:block;position:absolute;left:50%;margin-left:-8px;top:50%;margin-top:-8px}.ui-datepicker .ui-datepicker-title{margin:0 2.3em;line-height:1.8em;text-align:center}.ui-datepicker .ui-datepicker-title select{font-size:1em;margin:1px 0}.ui-datepicker select.ui-datepicker-month,.ui-datepicker select.ui-datepicker-year{width:45%}.ui-datepicker table{width:100%;font-size:.9em;border-collapse:collapse;margin:0 0 .4em}.ui-datepicker th{padding:.7em .3em;text-align:center;font-weight:bold;border:0}.ui-datepicker td{border:0;padding:1px}.ui-datepicker td span,.ui-datepicker td a{display:block;padding:.2em;text-align:right;text-decoration:none}.ui-datepicker .ui-datepicker-buttonpane{background-image:none;margin:.7em 0 0 0;padding:0 .2em;border-left:0;border-right:0;border-bottom:0}.ui-datepicker .ui-datepicker-buttonpane button{float:right;margin:.5em .2em .4em;cursor:pointer;padding:.2em .6em .3em .6em;width:auto;overflow:visible}.ui-datepicker .ui-datepicker-buttonpane button.ui-datepicker-current{float:left}.ui-datepicker.ui-datepicker-multi{width:auto}.ui-datepicker-multi .ui-datepicker-group{float:left}.ui-datepicker-multi .ui-datepicker-group table{width:95%;margin:0 auto .4em}.ui-datepicker-multi-2 .ui-datepicker-group{width:50%}.ui-datepicker-multi-3 .ui-datepicker-group{width:33.3%}.ui-datepicker-multi-4 .ui-datepicker-group{width:25%}.ui-datepicker-multi .ui-datepicker-group-last .ui-datepicker-header,.ui-datepicker-multi .ui-datepicker-group-middle .ui-datepicker-header{border-left-width:0}.ui-datepicker-multi .ui-datepicker-buttonpane{clear:left}.ui-datepicker-row-break{clear:both;width:100%;font-size:0}.ui-datepicker-rtl{direction:rtl}.ui-datepicker-rtl .ui-datepicker-prev{right:2px;left:auto}.ui-datepicker-rtl .ui-datepicker-next{left:2px;right:auto}.ui-datepicker-rtl .ui-datepicker-prev:hover{right:1px;left:auto}.ui-datepicker-rtl .ui-datepicker-next:hover{left:1px;right:auto}.ui-datepicker-rtl .ui-datepicker-buttonpane{clear:right}.ui-datepicker-rtl .ui-datepicker-buttonpane button{float:left}.ui-datepicker-rtl .ui-datepicker-buttonpane button.ui-datepicker-current,.ui-datepicker-rtl .ui-datepicker-group{float:right}.ui-datepicker-rtl .ui-datepicker-group-last .ui-datepicker-header,.ui-datepicker-rtl .ui-datepicker-group-middle .ui-datepicker-header{border-right-width:0;border-left-width:1px}.ui-dialog{overflow:hidden;position:absolute;top:0;left:0;padding:.2em;outline:0}.ui-dialog .ui-dialog-titlebar{padding:.4em 1em;position:relative}.ui-dialog .ui-dialog-title{float:left;margin:.1em 0;white-space:nowrap;width:90%;overflow:hidden;text-overflow:ellipsis}.ui-dialog .ui-dialog-titlebar-close{position:absolute;right:.3em;top:50%;width:20px;margin:-10px 0 0 0;padding:1px;height:20px}.ui-dialog .ui-dialog-content{position:relative;border:0;padding:.5em 1em;background:none;overflow:auto}.ui-dialog .ui-dialog-buttonpane{text-align:left;border-width:1px 0 0 0;background-image:none;margin-top:.5em;padding:.3em 1em .5em .4em}.ui-dialog .ui-dialog-buttonpane .ui-dialog-buttonset{float:right}.ui-dialog .ui-dialog-buttonpane button{margin:.5em .4em .5em 0;cursor:pointer}.ui-dialog .ui-resizable-se{width:12px;height:12px;right:-5px;bottom:-5px;background-position:16px 16px}.ui-draggable .ui-dialog-titlebar{cursor:move}.ui-draggable-handle{-ms-touch-action:none;touch-action:none}.ui-menu{list-style:none;padding:0;margin:0;display:block;outline:none}.ui-menu .ui-menu{position:absolute}.ui-menu .ui-menu-item{position:relative;margin:0;padding:3px 1em 3px .4em;cursor:pointer;min-height:0;list-style-image:url("data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7")}.ui-menu .ui-menu-divider{margin:5px 0;height:0;font-size:0;line-height:0;border-width:1px 0 0 0}.ui-menu .ui-state-focus,.ui-menu .ui-state-active{margin:-1px}.ui-menu-icons{position:relative}.ui-menu-icons .ui-menu-item{padding-left:2em}.ui-menu .ui-icon{position:absolute;top:0;bottom:0;left:.2em;margin:auto 0}.ui-menu .ui-menu-icon{left:auto;right:0}.ui-progressbar{height:2em;text-align:left;overflow:hidden}.ui-progressbar .ui-progressbar-value{margin:-1px;height:100%}.ui-progressbar .ui-progressbar-overlay{background:url("data:image/gif;base64,R0lGODlhKAAoAIABAAAAAP///yH/C05FVFNDQVBFMi4wAwEAAAAh+QQJAQABACwAAAAAKAAoAAACkYwNqXrdC52DS06a7MFZI+4FHBCKoDeWKXqymPqGqxvJrXZbMx7Ttc+w9XgU2FB3lOyQRWET2IFGiU9m1frDVpxZZc6bfHwv4c1YXP6k1Vdy292Fb6UkuvFtXpvWSzA+HycXJHUXiGYIiMg2R6W459gnWGfHNdjIqDWVqemH2ekpObkpOlppWUqZiqr6edqqWQAAIfkECQEAAQAsAAAAACgAKAAAApSMgZnGfaqcg1E2uuzDmmHUBR8Qil95hiPKqWn3aqtLsS18y7G1SzNeowWBENtQd+T1JktP05nzPTdJZlR6vUxNWWjV+vUWhWNkWFwxl9VpZRedYcflIOLafaa28XdsH/ynlcc1uPVDZxQIR0K25+cICCmoqCe5mGhZOfeYSUh5yJcJyrkZWWpaR8doJ2o4NYq62lAAACH5BAkBAAEALAAAAAAoACgAAAKVDI4Yy22ZnINRNqosw0Bv7i1gyHUkFj7oSaWlu3ovC8GxNso5fluz3qLVhBVeT/Lz7ZTHyxL5dDalQWPVOsQWtRnuwXaFTj9jVVh8pma9JjZ4zYSj5ZOyma7uuolffh+IR5aW97cHuBUXKGKXlKjn+DiHWMcYJah4N0lYCMlJOXipGRr5qdgoSTrqWSq6WFl2ypoaUAAAIfkECQEAAQAsAAAAACgAKAAAApaEb6HLgd/iO7FNWtcFWe+ufODGjRfoiJ2akShbueb0wtI50zm02pbvwfWEMWBQ1zKGlLIhskiEPm9R6vRXxV4ZzWT2yHOGpWMyorblKlNp8HmHEb/lCXjcW7bmtXP8Xt229OVWR1fod2eWqNfHuMjXCPkIGNileOiImVmCOEmoSfn3yXlJWmoHGhqp6ilYuWYpmTqKUgAAIfkECQEAAQAsAAAAACgAKAAAApiEH6kb58biQ3FNWtMFWW3eNVcojuFGfqnZqSebuS06w5V80/X02pKe8zFwP6EFWOT1lDFk8rGERh1TTNOocQ61Hm4Xm2VexUHpzjymViHrFbiELsefVrn6XKfnt2Q9G/+Xdie499XHd2g4h7ioOGhXGJboGAnXSBnoBwKYyfioubZJ2Hn0RuRZaflZOil56Zp6iioKSXpUAAAh+QQJAQABACwAAAAAKAAoAAACkoQRqRvnxuI7kU1a1UU5bd5tnSeOZXhmn5lWK3qNTWvRdQxP8qvaC+/yaYQzXO7BMvaUEmJRd3TsiMAgswmNYrSgZdYrTX6tSHGZO73ezuAw2uxuQ+BbeZfMxsexY35+/Qe4J1inV0g4x3WHuMhIl2jXOKT2Q+VU5fgoSUI52VfZyfkJGkha6jmY+aaYdirq+lQAACH5BAkBAAEALAAAAAAoACgAAAKWBIKpYe0L3YNKToqswUlvznigd4wiR4KhZrKt9Upqip61i9E3vMvxRdHlbEFiEXfk9YARYxOZZD6VQ2pUunBmtRXo1Lf8hMVVcNl8JafV38aM2/Fu5V16Bn63r6xt97j09+MXSFi4BniGFae3hzbH9+hYBzkpuUh5aZmHuanZOZgIuvbGiNeomCnaxxap2upaCZsq+1kAACH5BAkBAAEALAAAAAAoACgAAAKXjI8By5zf4kOxTVrXNVlv1X0d8IGZGKLnNpYtm8Lr9cqVeuOSvfOW79D9aDHizNhDJidFZhNydEahOaDH6nomtJjp1tutKoNWkvA6JqfRVLHU/QUfau9l2x7G54d1fl995xcIGAdXqMfBNadoYrhH+Mg2KBlpVpbluCiXmMnZ2Sh4GBqJ+ckIOqqJ6LmKSllZmsoq6wpQAAAh+QQJAQABACwAAAAAKAAoAAAClYx/oLvoxuJDkU1a1YUZbJ59nSd2ZXhWqbRa2/gF8Gu2DY3iqs7yrq+xBYEkYvFSM8aSSObE+ZgRl1BHFZNr7pRCavZ5BW2142hY3AN/zWtsmf12p9XxxFl2lpLn1rseztfXZjdIWIf2s5dItwjYKBgo9yg5pHgzJXTEeGlZuenpyPmpGQoKOWkYmSpaSnqKileI2FAAACH5BAkBAAEALAAAAAAoACgAAAKVjB+gu+jG4kORTVrVhRlsnn2dJ3ZleFaptFrb+CXmO9OozeL5VfP99HvAWhpiUdcwkpBH3825AwYdU8xTqlLGhtCosArKMpvfa1mMRae9VvWZfeB2XfPkeLmm18lUcBj+p5dnN8jXZ3YIGEhYuOUn45aoCDkp16hl5IjYJvjWKcnoGQpqyPlpOhr3aElaqrq56Bq7VAAAOw==");height:100%;filter:alpha(opacity=25);opacity:0.25}.ui-progressbar-indeterminate .ui-progressbar-value{background-image:none}.ui-resizable{position:relative}.ui-resizable-handle{position:absolute;font-size:0.1px;display:block;-ms-touch-action:none;touch-action:none}.ui-resizable-disabled .ui-resizable-handle,.ui-resizable-autohide .ui-resizable-handle{display:none}.ui-resizable-n{cursor:n-resize;height:7px;width:100%;top:-5px;left:0}.ui-resizable-s{cursor:s-resize;height:7px;width:100%;bottom:-5px;left:0}.ui-resizable-e{cursor:e-resize;width:7px;right:-5px;top:0;height:100%}.ui-resizable-w{cursor:w-resize;width:7px;left:-5px;top:0;height:100%}.ui-resizable-se{cursor:se-resize;width:12px;height:12px;right:1px;bottom:1px}.ui-resizable-sw{cursor:sw-resize;width:9px;height:9px;left:-5px;bottom:-5px}.ui-resizable-nw{cursor:nw-resize;width:9px;height:9px;left:-5px;top:-5px}.ui-resizable-ne{cursor:ne-resize;width:9px;height:9px;right:-5px;top:-5px}.ui-selectable{-ms-touch-action:none;touch-action:none}.ui-selectable-helper{position:absolute;z-index:100;border:1px dotted black}.ui-selectmenu-menu{padding:0;margin:0;position:absolute;top:0;left:0;display:none}.ui-selectmenu-menu .ui-menu{overflow:auto;overflow-x:hidden;padding-bottom:1px}.ui-selectmenu-menu .ui-menu .ui-selectmenu-optgroup{font-size:1em;font-weight:bold;line-height:1.5;padding:2px 0.4em;margin:0.5em 0 0 0;height:auto;border:0}.ui-selectmenu-open{display:block}.ui-selectmenu-button{display:inline-block;overflow:hidden;position:relative;text-decoration:none;cursor:pointer}.ui-selectmenu-button span.ui-icon{right:0.5em;left:auto;margin-top:-8px;position:absolute;top:50%}.ui-selectmenu-button span.ui-selectmenu-text{text-align:left;padding:0.4em 2.1em 0.4em 1em;display:block;line-height:1.4;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.ui-slider{position:relative;text-align:left}.ui-slider .ui-slider-handle{position:absolute;z-index:2;width:1.2em;height:1.2em;cursor:default;-ms-touch-action:none;touch-action:none}.ui-slider .ui-slider-range{position:absolute;z-index:1;font-size:.7em;display:block;border:0;background-position:0 0}.ui-slider.ui-state-disabled .ui-slider-handle,.ui-slider.ui-state-disabled .ui-slider-range{filter:inherit}.ui-slider-horizontal{height:.8em}.ui-slider-horizontal .ui-slider-handle{top:-.3em;margin-left:-.6em}.ui-slider-horizontal .ui-slider-range{top:0;height:100%}.ui-slider-horizontal .ui-slider-range-min{left:0}.ui-slider-horizontal .ui-slider-range-max{right:0}.ui-slider-vertical{width:.8em;height:100px}.ui-slider-vertical .ui-slider-handle{left:-.3em;margin-left:0;margin-bottom:-.6em}.ui-slider-vertical .ui-slider-range{left:0;width:100%}.ui-slider-vertical .ui-slider-range-min{bottom:0}.ui-slider-vertical .ui-slider-range-max{top:0}.ui-sortable-handle{-ms-touch-action:none;touch-action:none}.ui-spinner{position:relative;display:inline-block;overflow:hidden;padding:0;vertical-align:middle}.ui-spinner-input{border:none;background:none;color:inherit;padding:0;margin:.2em 0;vertical-align:middle;margin-left:.4em;margin-right:22px}.ui-spinner-button{width:16px;height:50%;font-size:.5em;padding:0;margin:0;text-align:center;position:absolute;cursor:default;display:block;overflow:hidden;right:0}.ui-spinner a.ui-spinner-button{border-top:none;border-bottom:none;border-right:none}.ui-spinner .ui-icon{position:absolute;margin-top:-8px;top:50%;left:0}.ui-spinner-up{top:0}.ui-spinner-down{bottom:0}.ui-spinner .ui-icon-triangle-1-s{background-position:-65px -16px}.ui-tabs{position:relative;padding:.2em}.ui-tabs .ui-tabs-nav{margin:0;padding:.2em .2em 0}.ui-tabs .ui-tabs-nav li{list-style:none;float:left;position:relative;top:0;margin:1px .2em 0 0;border-bottom-width:0;padding:0;white-space:nowrap}.ui-tabs .ui-tabs-nav .ui-tabs-anchor{float:left;padding:.5em 1em;text-decoration:none}.ui-tabs .ui-tabs-nav li.ui-tabs-active{margin-bottom:-1px;padding-bottom:1px}.ui-tabs .ui-tabs-nav li.ui-tabs-active .ui-tabs-anchor,.ui-tabs .ui-tabs-nav li.ui-state-disabled .ui-tabs-anchor,.ui-tabs .ui-tabs-nav li.ui-tabs-loading .ui-tabs-anchor{cursor:text}.ui-tabs-collapsible .ui-tabs-nav li.ui-tabs-active .ui-tabs-anchor{cursor:pointer}.ui-tabs .ui-tabs-panel{display:block;border-width:0;padding:1em 1.4em;background:none}.ui-tooltip{padding:8px;position:absolute;z-index:9999;max-width:300px;-webkit-box-shadow:0 0 5px #aaa;box-shadow:0 0 5px #aaa}body .ui-tooltip{border-width:2px}.ui-widget{font-family:Trebuchet MS,Tahoma,Verdana,Arial,sans-serif;font-size:1.1em}.ui-widget .ui-widget{font-size:1em}.ui-widget input,.ui-widget select,.ui-widget textarea,.ui-widget button{font-family:Trebuchet MS,Tahoma,Verdana,Arial,sans-serif;font-size:1em}.ui-widget-content{border:1px solid #ddd;background:#eee url("images/ui-bg_highlight-soft_100_eeeeee_1x100.png") 50% top repeat-x;color:#333}.ui-widget-content a{color:#333}.ui-widget-header{border:1px solid #e78f08;background:#f6a828 url("images/ui-bg_gloss-wave_35_f6a828_500x100.png") 50% 50% repeat-x;color:#fff;font-weight:bold}.ui-widget-header a{color:#fff}.ui-state-default,.ui-widget-content .ui-state-default,.ui-widget-header .ui-state-default{border:1px solid #ccc;background:#f6f6f6 url("images/ui-bg_glass_100_f6f6f6_1x400.png") 50% 50% repeat-x;font-weight:bold;color:#1c94c4}.ui-state-default a,.ui-state-default a:link,.ui-state-default a:visited{color:#1c94c4;text-decoration:none}.ui-state-hover,.ui-widget-content .ui-state-hover,.ui-widget-header .ui-state-hover,.ui-state-focus,.ui-widget-content .ui-state-focus,.ui-widget-header .ui-state-focus{border:1px solid #fbcb09;background:#fdf5ce url("images/ui-bg_glass_100_fdf5ce_1x400.png") 50% 50% repeat-x;font-weight:bold;color:#c77405}.ui-state-hover a,.ui-state-hover a:hover,.ui-state-hover a:link,.ui-state-hover a:visited,.ui-state-focus a,.ui-state-focus a:hover,.ui-state-focus a:link,.ui-state-focus a:visited{color:#c77405;text-decoration:none}.ui-state-active,.ui-widget-content .ui-state-active,.ui-widget-header .ui-state-active{border:1px solid #fbd850;background:#fff url("images/ui-bg_glass_65_ffffff_1x400.png") 50% 50% repeat-x;font-weight:bold;color:#eb8f00}.ui-state-active a,.ui-state-active a:link,.ui-state-active a:visited{color:#eb8f00;text-decoration:none}.ui-state-highlight,.ui-widget-content .ui-state-highlight,.ui-widget-header .ui-state-highlight{border:1px solid #fed22f;background:#ffe45c url("images/ui-bg_highlight-soft_75_ffe45c_1x100.png") 50% top repeat-x;color:#363636}.ui-state-highlight a,.ui-widget-content .ui-state-highlight a,.ui-widget-header .ui-state-highlight a{color:#363636}.ui-state-error,.ui-widget-content .ui-state-error,.ui-widget-header .ui-state-error{border:1px solid #cd0a0a;background:#b81900 url("images/ui-bg_diagonals-thick_18_b81900_40x40.png") 50% 50% repeat;color:#fff}.ui-state-error a,.ui-widget-content .ui-state-error a,.ui-widget-header .ui-state-error a{color:#fff}.ui-state-error-text,.ui-widget-content .ui-state-error-text,.ui-widget-header .ui-state-error-text{color:#fff}.ui-priority-primary,.ui-widget-content .ui-priority-primary,.ui-widget-header .ui-priority-primary{font-weight:bold}.ui-priority-secondary,.ui-widget-content .ui-priority-secondary,.ui-widget-header .ui-priority-secondary{opacity:.7;filter:Alpha(Opacity=70);font-weight:normal}.ui-state-disabled,.ui-widget-content .ui-state-disabled,.ui-widget-header .ui-state-disabled{opacity:.35;filter:Alpha(Opacity=35);background-image:none}.ui-state-disabled .ui-icon{filter:Alpha(Opacity=35)}.ui-icon{width:16px;height:16px}.ui-icon,.ui-widget-content .ui-icon{background-image:url("images/ui-icons_222222_256x240.png")}.ui-widget-header .ui-icon{background-image:url("images/ui-icons_ffffff_256x240.png")}.ui-state-default .ui-icon{background-image:url("images/ui-icons_ef8c08_256x240.png")}.ui-state-hover .ui-icon,.ui-state-focus .ui-icon{background-image:url("images/ui-icons_ef8c08_256x240.png")}.ui-state-active .ui-icon{background-image:url("images/ui-icons_ef8c08_256x240.png")}.ui-state-highlight .ui-icon{background-image:url("images/ui-icons_228ef1_256x240.png")}.ui-state-error .ui-icon,.ui-state-error-text .ui-icon{background-image:url("images/ui-icons_ffd27a_256x240.png")}.ui-icon-blank{background-position:16px 16px}.ui-icon-carat-1-n{background-position:0 0}.ui-icon-carat-1-ne{background-position:-16px 0}.ui-icon-carat-1-e{background-position:-32px 0}.ui-icon-carat-1-se{background-position:-48px 0}.ui-icon-carat-1-s{background-position:-64px 0}.ui-icon-carat-1-sw{background-position:-80px 0}.ui-icon-carat-1-w{background-position:-96px 0}.ui-icon-carat-1-nw{background-position:-112px 0}.ui-icon-carat-2-n-s{background-position:-128px 0}.ui-icon-carat-2-e-w{background-position:-144px 0}.ui-icon-triangle-1-n{background-position:0 -16px}.ui-icon-triangle-1-ne{background-position:-16px -16px}.ui-icon-triangle-1-e{background-position:-32px -16px}.ui-icon-triangle-1-se{background-position:-48px -16px}.ui-icon-triangle-1-s{background-position:-64px -16px}.ui-icon-triangle-1-sw{background-position:-80px -16px}.ui-icon-triangle-1-w{background-position:-96px -16px}.ui-icon-triangle-1-nw{background-position:-112px -16px}.ui-icon-triangle-2-n-s{background-position:-128px -16px}.ui-icon-triangle-2-e-w{background-position:-144px -16px}.ui-icon-arrow-1-n{background-position:0 -32px}.ui-icon-arrow-1-ne{background-position:-16px -32px}.ui-icon-arrow-1-e{background-position:-32px -32px}.ui-icon-arrow-1-se{background-position:-48px -32px}.ui-icon-arrow-1-s{background-position:-64px -32px}.ui-icon-arrow-1-sw{background-position:-80px -32px}.ui-icon-arrow-1-w{background-position:-96px -32px}.ui-icon-arrow-1-nw{background-position:-112px -32px}.ui-icon-arrow-2-n-s{background-position:-128px -32px}.ui-icon-arrow-2-ne-sw{background-position:-144px -32px}.ui-icon-arrow-2-e-w{background-position:-160px -32px}.ui-icon-arrow-2-se-nw{background-position:-176px -32px}.ui-icon-arrowstop-1-n{background-position:-192px -32px}.ui-icon-arrowstop-1-e{background-position:-208px -32px}.ui-icon-arrowstop-1-s{background-position:-224px -32px}.ui-icon-arrowstop-1-w{background-position:-240px -32px}.ui-icon-arrowthick-1-n{background-position:0 -48px}.ui-icon-arrowthick-1-ne{background-position:-16px -48px}.ui-icon-arrowthick-1-e{background-position:-32px -48px}.ui-icon-arrowthick-1-se{background-position:-48px -48px}.ui-icon-arrowthick-1-s{background-position:-64px -48px}.ui-icon-arrowthick-1-sw{background-position:-80px -48px}.ui-icon-arrowthick-1-w{background-position:-96px -48px}.ui-icon-arrowthick-1-nw{background-position:-112px -48px}.ui-icon-arrowthick-2-n-s{background-position:-128px -48px}.ui-icon-arrowthick-2-ne-sw{background-position:-144px -48px}.ui-icon-arrowthick-2-e-w{background-position:-160px -48px}.ui-icon-arrowthick-2-se-nw{background-position:-176px -48px}.ui-icon-arrowthickstop-1-n{background-position:-192px -48px}.ui-icon-arrowthickstop-1-e{background-position:-208px -48px}.ui-icon-arrowthickstop-1-s{background-position:-224px -48px}.ui-icon-arrowthickstop-1-w{background-position:-240px -48px}.ui-icon-arrowreturnthick-1-w{background-position:0 -64px}.ui-icon-arrowreturnthick-1-n{background-position:-16px -64px}.ui-icon-arrowreturnthick-1-e{background-position:-32px -64px}.ui-icon-arrowreturnthick-1-s{background-position:-48px -64px}.ui-icon-arrowreturn-1-w{background-position:-64px -64px}.ui-icon-arrowreturn-1-n{background-position:-80px -64px}.ui-icon-arrowreturn-1-e{background-position:-96px -64px}.ui-icon-arrowreturn-1-s{background-position:-112px -64px}.ui-icon-arrowrefresh-1-w{background-position:-128px -64px}.ui-icon-arrowrefresh-1-n{background-position:-144px -64px}.ui-icon-arrowrefresh-1-e{background-position:-160px -64px}.ui-icon-arrowrefresh-1-s{background-position:-176px -64px}.ui-icon-arrow-4{background-position:0 -80px}.ui-icon-arrow-4-diag{background-position:-16px -80px}.ui-icon-extlink{background-position:-32px -80px}.ui-icon-newwin{background-position:-48px -80px}.ui-icon-refresh{background-position:-64px -80px}.ui-icon-shuffle{background-position:-80px -80px}.ui-icon-transfer-e-w{background-position:-96px -80px}.ui-icon-transferthick-e-w{background-position:-112px -80px}.ui-icon-folder-collapsed{background-position:0 -96px}.ui-icon-folder-open{background-position:-16px -96px}.ui-icon-document{background-position:-32px -96px}.ui-icon-document-b{background-position:-48px -96px}.ui-icon-note{background-position:-64px -96px}.ui-icon-mail-closed{background-position:-80px -96px}.ui-icon-mail-open{background-position:-96px -96px}.ui-icon-suitcase{background-position:-112px -96px}.ui-icon-comment{background-position:-128px -96px}.ui-icon-person{background-position:-144px -96px}.ui-icon-print{background-position:-160px -96px}.ui-icon-trash{background-position:-176px -96px}.ui-icon-locked{background-position:-192px -96px}.ui-icon-unlocked{background-position:-208px -96px}.ui-icon-bookmark{background-position:-224px -96px}.ui-icon-tag{background-position:-240px -96px}.ui-icon-home{background-position:0 -112px}.ui-icon-flag{background-position:-16px -112px}.ui-icon-calendar{background-position:-32px -112px}.ui-icon-cart{background-position:-48px -112px}.ui-icon-pencil{background-position:-64px -112px}.ui-icon-clock{background-position:-80px -112px}.ui-icon-disk{background-position:-96px -112px}.ui-icon-calculator{background-position:-112px -112px}.ui-icon-zoomin{background-position:-128px -112px}.ui-icon-zoomout{background-position:-144px -112px}.ui-icon-search{background-position:-160px -112px}.ui-icon-wrench{background-position:-176px -112px}.ui-icon-gear{background-position:-192px -112px}.ui-icon-heart{background-position:-208px -112px}.ui-icon-star{background-position:-224px -112px}.ui-icon-link{background-position:-240px -112px}.ui-icon-cancel{background-position:0 -128px}.ui-icon-plus{background-position:-16px -128px}.ui-icon-plusthick{background-position:-32px -128px}.ui-icon-minus{background-position:-48px -128px}.ui-icon-minusthick{background-position:-64px -128px}.ui-icon-close{background-position:-80px -128px}.ui-icon-closethick{background-position:-96px -128px}.ui-icon-key{background-position:-112px -128px}.ui-icon-lightbulb{background-position:-128px -128px}.ui-icon-scissors{background-position:-144px -128px}.ui-icon-clipboard{background-position:-160px -128px}.ui-icon-copy{background-position:-176px -128px}.ui-icon-contact{background-position:-192px -128px}.ui-icon-image{background-position:-208px -128px}.ui-icon-video{background-position:-224px -128px}.ui-icon-script{background-position:-240px -128px}.ui-icon-alert{background-position:0 -144px}.ui-icon-info{background-position:-16px -144px}.ui-icon-notice{background-position:-32px -144px}.ui-icon-help{background-position:-48px -144px}.ui-icon-check{background-position:-64px -144px}.ui-icon-bullet{background-position:-80px -144px}.ui-icon-radio-on{background-position:-96px -144px}.ui-icon-radio-off{background-position:-112px -144px}.ui-icon-pin-w{background-position:-128px -144px}.ui-icon-pin-s{background-position:-144px -144px}.ui-icon-play{background-position:0 -160px}.ui-icon-pause{background-position:-16px -160px}.ui-icon-seek-next{background-position:-32px -160px}.ui-icon-seek-prev{background-position:-48px -160px}.ui-icon-seek-end{background-position:-64px -160px}.ui-icon-seek-start{background-position:-80px -160px}.ui-icon-seek-first{background-position:-80px -160px}.ui-icon-stop{background-position:-96px -160px}.ui-icon-eject{background-position:-112px -160px}.ui-icon-volume-off{background-position:-128px -160px}.ui-icon-volume-on{background-position:-144px -160px}.ui-icon-power{background-position:0 -176px}.ui-icon-signal-diag{background-position:-16px -176px}.ui-icon-signal{background-position:-32px -176px}.ui-icon-battery-0{background-position:-48px -176px}.ui-icon-battery-1{background-position:-64px -176px}.ui-icon-battery-2{background-position:-80px -176px}.ui-icon-battery-3{background-position:-96px -176px}.ui-icon-circle-plus{background-position:0 -192px}.ui-icon-circle-minus{background-position:-16px -192px}.ui-icon-circle-close{background-position:-32px -192px}.ui-icon-circle-triangle-e{background-position:-48px -192px}.ui-icon-circle-triangle-s{background-position:-64px -192px}.ui-icon-circle-triangle-w{background-position:-80px -192px}.ui-icon-circle-triangle-n{background-position:-96px -192px}.ui-icon-circle-arrow-e{background-position:-112px -192px}.ui-icon-circle-arrow-s{background-position:-128px -192px}.ui-icon-circle-arrow-w{background-position:-144px -192px}.ui-icon-circle-arrow-n{background-position:-160px -192px}.ui-icon-circle-zoomin{background-position:-176px -192px}.ui-icon-circle-zoomout{background-position:-192px -192px}.ui-icon-circle-check{background-position:-208px -192px}.ui-icon-circlesmall-plus{background-position:0 -208px}.ui-icon-circlesmall-minus{background-position:-16px -208px}.ui-icon-circlesmall-close{background-position:-32px -208px}.ui-icon-squaresmall-plus{background-position:-48px -208px}.ui-icon-squaresmall-minus{background-position:-64px -208px}.ui-icon-squaresmall-close{background-position:-80px -208px}.ui-icon-grip-dotted-vertical{background-position:0 -224px}.ui-icon-grip-dotted-horizontal{background-position:-16px -224px}.ui-icon-grip-solid-vertical{background-position:-32px -224px}.ui-icon-grip-solid-horizontal{background-position:-48px -224px}.ui-icon-gripsmall-diagonal-se{background-position:-64px -224px}.ui-icon-grip-diagonal-se{background-position:-80px -224px}.ui-corner-all,.ui-corner-top,.ui-corner-left,.ui-corner-tl{border-top-left-radius:4px}.ui-corner-all,.ui-corner-top,.ui-corner-right,.ui-corner-tr{border-top-right-radius:4px}.ui-corner-all,.ui-corner-bottom,.ui-corner-left,.ui-corner-bl{border-bottom-left-radius:4px}.ui-corner-all,.ui-corner-bottom,.ui-corner-right,.ui-corner-br{border-bottom-right-radius:4px}.ui-widget-overlay{background:#666 url("images/ui-bg_diagonals-thick_20_666666_40x40.png") 50% 50% repeat;opacity:.5;filter:Alpha(Opacity=50)}.ui-widget-shadow{margin:-5px 0 0 -5px;padding:5px;background:#000 url("images/ui-bg_flat_10_000000_40x100.png") 50% 50% repeat-x;opacity:.2;filter:Alpha(Opacity=20);border-radius:5px}/*! jQuery UI - v1.11.2 - 2014-10-16
* http://jqueryui.com
* Includes: core.js, widget.js, mouse.js, position.js, accordion.js, autocomplete.js, button.js, datepicker.js, dialog.js, draggable.js, droppable.js, effect.js, effect-blind.js, effect-bounce.js, effect-clip.js, effect-drop.js, effect-explode.js, effect-fade.js, effect-fold.js, effect-highlight.js, effect-puff.js, effect-pulsate.js, effect-scale.js, effect-shake.js, effect-size.js, effect-slide.js, effect-transfer.js, menu.js, progressbar.js, resizable.js, selectable.js, selectmenu.js, slider.js, sortable.js, spinner.js, tabs.js, tooltip.js
* Copyright 2014 jQuery Foundation and other contributors; Licensed MIT */

(function(e){"function"==typeof define&&define.amd?define(["jquery"],e):e(jQuery)})(function(e){function t(t,s){var n,a,o,r=t.nodeName.toLowerCase();return"area"===r?(n=t.parentNode,a=n.name,t.href&&a&&"map"===n.nodeName.toLowerCase()?(o=e("img[usemap='#"+a+"']")[0],!!o&&i(o)):!1):(/input|select|textarea|button|object/.test(r)?!t.disabled:"a"===r?t.href||s:s)&&i(t)}function i(t){return e.expr.filters.visible(t)&&!e(t).parents().addBack().filter(function(){return"hidden"===e.css(this,"visibility")}).length}function s(e){for(var t,i;e.length&&e[0]!==document;){if(t=e.css("position"),("absolute"===t||"relative"===t||"fixed"===t)&&(i=parseInt(e.css("zIndex"),10),!isNaN(i)&&0!==i))return i;e=e.parent()}return 0}function n(){this._curInst=null,this._keyEvent=!1,this._disabledInputs=[],this._datepickerShowing=!1,this._inDialog=!1,this._mainDivId="ui-datepicker-div",this._inlineClass="ui-datepicker-inline",this._appendClass="ui-datepicker-append",this._triggerClass="ui-datepicker-trigger",this._dialogClass="ui-datepicker-dialog",this._disableClass="ui-datepicker-disabled",this._unselectableClass="ui-datepicker-unselectable",this._currentClass="ui-datepicker-current-day",this._dayOverClass="ui-datepicker-days-cell-over",this.regional=[],this.regional[""]={closeText:"Done",prevText:"Prev",nextText:"Next",currentText:"Today",monthNames:["January","February","March","April","May","June","July","August","September","October","November","December"],monthNamesShort:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],dayNames:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],dayNamesShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],dayNamesMin:["Su","Mo","Tu","We","Th","Fr","Sa"],weekHeader:"Wk",dateFormat:"mm/dd/yy",firstDay:0,isRTL:!1,showMonthAfterYear:!1,yearSuffix:""},this._defaults={showOn:"focus",showAnim:"fadeIn",showOptions:{},defaultDate:null,appendText:"",buttonText:"...",buttonImage:"",buttonImageOnly:!1,hideIfNoPrevNext:!1,navigationAsDateFormat:!1,gotoCurrent:!1,changeMonth:!1,changeYear:!1,yearRange:"c-10:c+10",showOtherMonths:!1,selectOtherMonths:!1,showWeek:!1,calculateWeek:this.iso8601Week,shortYearCutoff:"+10",minDate:null,maxDate:null,duration:"fast",beforeShowDay:null,beforeShow:null,onSelect:null,onChangeMonthYear:null,onClose:null,numberOfMonths:1,showCurrentAtPos:0,stepMonths:1,stepBigMonths:12,altField:"",altFormat:"",constrainInput:!0,showButtonPanel:!1,autoSize:!1,disabled:!1},e.extend(this._defaults,this.regional[""]),this.regional.en=e.extend(!0,{},this.regional[""]),this.regional["en-US"]=e.extend(!0,{},this.regional.en),this.dpDiv=a(e("<div id='"+this._mainDivId+"' class='ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>"))}function a(t){var i="button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a";return t.delegate(i,"mouseout",function(){e(this).removeClass("ui-state-hover"),-1!==this.className.indexOf("ui-datepicker-prev")&&e(this).removeClass("ui-datepicker-prev-hover"),-1!==this.className.indexOf("ui-datepicker-next")&&e(this).removeClass("ui-datepicker-next-hover")}).delegate(i,"mouseover",o)}function o(){e.datepicker._isDisabledDatepicker(v.inline?v.dpDiv.parent()[0]:v.input[0])||(e(this).parents(".ui-datepicker-calendar").find("a").removeClass("ui-state-hover"),e(this).addClass("ui-state-hover"),-1!==this.className.indexOf("ui-datepicker-prev")&&e(this).addClass("ui-datepicker-prev-hover"),-1!==this.className.indexOf("ui-datepicker-next")&&e(this).addClass("ui-datepicker-next-hover"))}function r(t,i){e.extend(t,i);for(var s in i)null==i[s]&&(t[s]=i[s]);return t}function h(e){return function(){var t=this.element.val();e.apply(this,arguments),this._refresh(),t!==this.element.val()&&this._trigger("change")}}e.ui=e.ui||{},e.extend(e.ui,{version:"1.11.2",keyCode:{BACKSPACE:8,COMMA:188,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,LEFT:37,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,RIGHT:39,SPACE:32,TAB:9,UP:38}}),e.fn.extend({scrollParent:function(t){var i=this.css("position"),s="absolute"===i,n=t?/(auto|scroll|hidden)/:/(auto|scroll)/,a=this.parents().filter(function(){var t=e(this);return s&&"static"===t.css("position")?!1:n.test(t.css("overflow")+t.css("overflow-y")+t.css("overflow-x"))}).eq(0);return"fixed"!==i&&a.length?a:e(this[0].ownerDocument||document)},uniqueId:function(){var e=0;return function(){return this.each(function(){this.id||(this.id="ui-id-"+ ++e)})}}(),removeUniqueId:function(){return this.each(function(){/^ui-id-\d+$/.test(this.id)&&e(this).removeAttr("id")})}}),e.extend(e.expr[":"],{data:e.expr.createPseudo?e.expr.createPseudo(function(t){return function(i){return!!e.data(i,t)}}):function(t,i,s){return!!e.data(t,s[3])},focusable:function(i){return t(i,!isNaN(e.attr(i,"tabindex")))},tabbable:function(i){var s=e.attr(i,"tabindex"),n=isNaN(s);return(n||s>=0)&&t(i,!n)}}),e("<a>").outerWidth(1).jquery||e.each(["Width","Height"],function(t,i){function s(t,i,s,a){return e.each(n,function(){i-=parseFloat(e.css(t,"padding"+this))||0,s&&(i-=parseFloat(e.css(t,"border"+this+"Width"))||0),a&&(i-=parseFloat(e.css(t,"margin"+this))||0)}),i}var n="Width"===i?["Left","Right"]:["Top","Bottom"],a=i.toLowerCase(),o={innerWidth:e.fn.innerWidth,innerHeight:e.fn.innerHeight,outerWidth:e.fn.outerWidth,outerHeight:e.fn.outerHeight};e.fn["inner"+i]=function(t){return void 0===t?o["inner"+i].call(this):this.each(function(){e(this).css(a,s(this,t)+"px")})},e.fn["outer"+i]=function(t,n){return"number"!=typeof t?o["outer"+i].call(this,t):this.each(function(){e(this).css(a,s(this,t,!0,n)+"px")})}}),e.fn.addBack||(e.fn.addBack=function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}),e("<a>").data("a-b","a").removeData("a-b").data("a-b")&&(e.fn.removeData=function(t){return function(i){return arguments.length?t.call(this,e.camelCase(i)):t.call(this)}}(e.fn.removeData)),e.ui.ie=!!/msie [\w.]+/.exec(navigator.userAgent.toLowerCase()),e.fn.extend({focus:function(t){return function(i,s){return"number"==typeof i?this.each(function(){var t=this;setTimeout(function(){e(t).focus(),s&&s.call(t)},i)}):t.apply(this,arguments)}}(e.fn.focus),disableSelection:function(){var e="onselectstart"in document.createElement("div")?"selectstart":"mousedown";return function(){return this.bind(e+".ui-disableSelection",function(e){e.preventDefault()})}}(),enableSelection:function(){return this.unbind(".ui-disableSelection")},zIndex:function(t){if(void 0!==t)return this.css("zIndex",t);if(this.length)for(var i,s,n=e(this[0]);n.length&&n[0]!==document;){if(i=n.css("position"),("absolute"===i||"relative"===i||"fixed"===i)&&(s=parseInt(n.css("zIndex"),10),!isNaN(s)&&0!==s))return s;n=n.parent()}return 0}}),e.ui.plugin={add:function(t,i,s){var n,a=e.ui[t].prototype;for(n in s)a.plugins[n]=a.plugins[n]||[],a.plugins[n].push([i,s[n]])},call:function(e,t,i,s){var n,a=e.plugins[t];if(a&&(s||e.element[0].parentNode&&11!==e.element[0].parentNode.nodeType))for(n=0;a.length>n;n++)e.options[a[n][0]]&&a[n][1].apply(e.element,i)}};var l=0,u=Array.prototype.slice;e.cleanData=function(t){return function(i){var s,n,a;for(a=0;null!=(n=i[a]);a++)try{s=e._data(n,"events"),s&&s.remove&&e(n).triggerHandler("remove")}catch(o){}t(i)}}(e.cleanData),e.widget=function(t,i,s){var n,a,o,r,h={},l=t.split(".")[0];return t=t.split(".")[1],n=l+"-"+t,s||(s=i,i=e.Widget),e.expr[":"][n.toLowerCase()]=function(t){return!!e.data(t,n)},e[l]=e[l]||{},a=e[l][t],o=e[l][t]=function(e,t){return this._createWidget?(arguments.length&&this._createWidget(e,t),void 0):new o(e,t)},e.extend(o,a,{version:s.version,_proto:e.extend({},s),_childConstructors:[]}),r=new i,r.options=e.widget.extend({},r.options),e.each(s,function(t,s){return e.isFunction(s)?(h[t]=function(){var e=function(){return i.prototype[t].apply(this,arguments)},n=function(e){return i.prototype[t].apply(this,e)};return function(){var t,i=this._super,a=this._superApply;return this._super=e,this._superApply=n,t=s.apply(this,arguments),this._super=i,this._superApply=a,t}}(),void 0):(h[t]=s,void 0)}),o.prototype=e.widget.extend(r,{widgetEventPrefix:a?r.widgetEventPrefix||t:t},h,{constructor:o,namespace:l,widgetName:t,widgetFullName:n}),a?(e.each(a._childConstructors,function(t,i){var s=i.prototype;e.widget(s.namespace+"."+s.widgetName,o,i._proto)}),delete a._childConstructors):i._childConstructors.push(o),e.widget.bridge(t,o),o},e.widget.extend=function(t){for(var i,s,n=u.call(arguments,1),a=0,o=n.length;o>a;a++)for(i in n[a])s=n[a][i],n[a].hasOwnProperty(i)&&void 0!==s&&(t[i]=e.isPlainObject(s)?e.isPlainObject(t[i])?e.widget.extend({},t[i],s):e.widget.extend({},s):s);return t},e.widget.bridge=function(t,i){var s=i.prototype.widgetFullName||t;e.fn[t]=function(n){var a="string"==typeof n,o=u.call(arguments,1),r=this;return n=!a&&o.length?e.widget.extend.apply(null,[n].concat(o)):n,a?this.each(function(){var i,a=e.data(this,s);return"instance"===n?(r=a,!1):a?e.isFunction(a[n])&&"_"!==n.charAt(0)?(i=a[n].apply(a,o),i!==a&&void 0!==i?(r=i&&i.jquery?r.pushStack(i.get()):i,!1):void 0):e.error("no such method '"+n+"' for "+t+" widget instance"):e.error("cannot call methods on "+t+" prior to initialization; "+"attempted to call method '"+n+"'")}):this.each(function(){var t=e.data(this,s);t?(t.option(n||{}),t._init&&t._init()):e.data(this,s,new i(n,this))}),r}},e.Widget=function(){},e.Widget._childConstructors=[],e.Widget.prototype={widgetName:"widget",widgetEventPrefix:"",defaultElement:"<div>",options:{disabled:!1,create:null},_createWidget:function(t,i){i=e(i||this.defaultElement||this)[0],this.element=e(i),this.uuid=l++,this.eventNamespace="."+this.widgetName+this.uuid,this.bindings=e(),this.hoverable=e(),this.focusable=e(),i!==this&&(e.data(i,this.widgetFullName,this),this._on(!0,this.element,{remove:function(e){e.target===i&&this.destroy()}}),this.document=e(i.style?i.ownerDocument:i.document||i),this.window=e(this.document[0].defaultView||this.document[0].parentWindow)),this.options=e.widget.extend({},this.options,this._getCreateOptions(),t),this._create(),this._trigger("create",null,this._getCreateEventData()),this._init()},_getCreateOptions:e.noop,_getCreateEventData:e.noop,_create:e.noop,_init:e.noop,destroy:function(){this._destroy(),this.element.unbind(this.eventNamespace).removeData(this.widgetFullName).removeData(e.camelCase(this.widgetFullName)),this.widget().unbind(this.eventNamespace).removeAttr("aria-disabled").removeClass(this.widgetFullName+"-disabled "+"ui-state-disabled"),this.bindings.unbind(this.eventNamespace),this.hoverable.removeClass("ui-state-hover"),this.focusable.removeClass("ui-state-focus")},_destroy:e.noop,widget:function(){return this.element},option:function(t,i){var s,n,a,o=t;if(0===arguments.length)return e.widget.extend({},this.options);if("string"==typeof t)if(o={},s=t.split("."),t=s.shift(),s.length){for(n=o[t]=e.widget.extend({},this.options[t]),a=0;s.length-1>a;a++)n[s[a]]=n[s[a]]||{},n=n[s[a]];if(t=s.pop(),1===arguments.length)return void 0===n[t]?null:n[t];n[t]=i}else{if(1===arguments.length)return void 0===this.options[t]?null:this.options[t];o[t]=i}return this._setOptions(o),this},_setOptions:function(e){var t;for(t in e)this._setOption(t,e[t]);return this},_setOption:function(e,t){return this.options[e]=t,"disabled"===e&&(this.widget().toggleClass(this.widgetFullName+"-disabled",!!t),t&&(this.hoverable.removeClass("ui-state-hover"),this.focusable.removeClass("ui-state-focus"))),this},enable:function(){return this._setOptions({disabled:!1})},disable:function(){return this._setOptions({disabled:!0})},_on:function(t,i,s){var n,a=this;"boolean"!=typeof t&&(s=i,i=t,t=!1),s?(i=n=e(i),this.bindings=this.bindings.add(i)):(s=i,i=this.element,n=this.widget()),e.each(s,function(s,o){function r(){return t||a.options.disabled!==!0&&!e(this).hasClass("ui-state-disabled")?("string"==typeof o?a[o]:o).apply(a,arguments):void 0}"string"!=typeof o&&(r.guid=o.guid=o.guid||r.guid||e.guid++);var h=s.match(/^([\w:-]*)\s*(.*)$/),l=h[1]+a.eventNamespace,u=h[2];u?n.delegate(u,l,r):i.bind(l,r)})},_off:function(t,i){i=(i||"").split(" ").join(this.eventNamespace+" ")+this.eventNamespace,t.unbind(i).undelegate(i),this.bindings=e(this.bindings.not(t).get()),this.focusable=e(this.focusable.not(t).get()),this.hoverable=e(this.hoverable.not(t).get())},_delay:function(e,t){function i(){return("string"==typeof e?s[e]:e).apply(s,arguments)}var s=this;return setTimeout(i,t||0)},_hoverable:function(t){this.hoverable=this.hoverable.add(t),this._on(t,{mouseenter:function(t){e(t.currentTarget).addClass("ui-state-hover")},mouseleave:function(t){e(t.currentTarget).removeClass("ui-state-hover")}})},_focusable:function(t){this.focusable=this.focusable.add(t),this._on(t,{focusin:function(t){e(t.currentTarget).addClass("ui-state-focus")},focusout:function(t){e(t.currentTarget).removeClass("ui-state-focus")}})},_trigger:function(t,i,s){var n,a,o=this.options[t];if(s=s||{},i=e.Event(i),i.type=(t===this.widgetEventPrefix?t:this.widgetEventPrefix+t).toLowerCase(),i.target=this.element[0],a=i.originalEvent)for(n in a)n in i||(i[n]=a[n]);return this.element.trigger(i,s),!(e.isFunction(o)&&o.apply(this.element[0],[i].concat(s))===!1||i.isDefaultPrevented())}},e.each({show:"fadeIn",hide:"fadeOut"},function(t,i){e.Widget.prototype["_"+t]=function(s,n,a){"string"==typeof n&&(n={effect:n});var o,r=n?n===!0||"number"==typeof n?i:n.effect||i:t;n=n||{},"number"==typeof n&&(n={duration:n}),o=!e.isEmptyObject(n),n.complete=a,n.delay&&s.delay(n.delay),o&&e.effects&&e.effects.effect[r]?s[t](n):r!==t&&s[r]?s[r](n.duration,n.easing,a):s.queue(function(i){e(this)[t](),a&&a.call(s[0]),i()})}}),e.widget;var d=!1;e(document).mouseup(function(){d=!1}),e.widget("ui.mouse",{version:"1.11.2",options:{cancel:"input,textarea,button,select,option",distance:1,delay:0},_mouseInit:function(){var t=this;this.element.bind("mousedown."+this.widgetName,function(e){return t._mouseDown(e)}).bind("click."+this.widgetName,function(i){return!0===e.data(i.target,t.widgetName+".preventClickEvent")?(e.removeData(i.target,t.widgetName+".preventClickEvent"),i.stopImmediatePropagation(),!1):void 0}),this.started=!1},_mouseDestroy:function(){this.element.unbind("."+this.widgetName),this._mouseMoveDelegate&&this.document.unbind("mousemove."+this.widgetName,this._mouseMoveDelegate).unbind("mouseup."+this.widgetName,this._mouseUpDelegate)},_mouseDown:function(t){if(!d){this._mouseMoved=!1,this._mouseStarted&&this._mouseUp(t),this._mouseDownEvent=t;var i=this,s=1===t.which,n="string"==typeof this.options.cancel&&t.target.nodeName?e(t.target).closest(this.options.cancel).length:!1;return s&&!n&&this._mouseCapture(t)?(this.mouseDelayMet=!this.options.delay,this.mouseDelayMet||(this._mouseDelayTimer=setTimeout(function(){i.mouseDelayMet=!0},this.options.delay)),this._mouseDistanceMet(t)&&this._mouseDelayMet(t)&&(this._mouseStarted=this._mouseStart(t)!==!1,!this._mouseStarted)?(t.preventDefault(),!0):(!0===e.data(t.target,this.widgetName+".preventClickEvent")&&e.removeData(t.target,this.widgetName+".preventClickEvent"),this._mouseMoveDelegate=function(e){return i._mouseMove(e)},this._mouseUpDelegate=function(e){return i._mouseUp(e)},this.document.bind("mousemove."+this.widgetName,this._mouseMoveDelegate).bind("mouseup."+this.widgetName,this._mouseUpDelegate),t.preventDefault(),d=!0,!0)):!0}},_mouseMove:function(t){if(this._mouseMoved){if(e.ui.ie&&(!document.documentMode||9>document.documentMode)&&!t.button)return this._mouseUp(t);if(!t.which)return this._mouseUp(t)}return(t.which||t.button)&&(this._mouseMoved=!0),this._mouseStarted?(this._mouseDrag(t),t.preventDefault()):(this._mouseDistanceMet(t)&&this._mouseDelayMet(t)&&(this._mouseStarted=this._mouseStart(this._mouseDownEvent,t)!==!1,this._mouseStarted?this._mouseDrag(t):this._mouseUp(t)),!this._mouseStarted)},_mouseUp:function(t){return this.document.unbind("mousemove."+this.widgetName,this._mouseMoveDelegate).unbind("mouseup."+this.widgetName,this._mouseUpDelegate),this._mouseStarted&&(this._mouseStarted=!1,t.target===this._mouseDownEvent.target&&e.data(t.target,this.widgetName+".preventClickEvent",!0),this._mouseStop(t)),d=!1,!1},_mouseDistanceMet:function(e){return Math.max(Math.abs(this._mouseDownEvent.pageX-e.pageX),Math.abs(this._mouseDownEvent.pageY-e.pageY))>=this.options.distance},_mouseDelayMet:function(){return this.mouseDelayMet},_mouseStart:function(){},_mouseDrag:function(){},_mouseStop:function(){},_mouseCapture:function(){return!0}}),function(){function t(e,t,i){return[parseFloat(e[0])*(p.test(e[0])?t/100:1),parseFloat(e[1])*(p.test(e[1])?i/100:1)]}function i(t,i){return parseInt(e.css(t,i),10)||0}function s(t){var i=t[0];return 9===i.nodeType?{width:t.width(),height:t.height(),offset:{top:0,left:0}}:e.isWindow(i)?{width:t.width(),height:t.height(),offset:{top:t.scrollTop(),left:t.scrollLeft()}}:i.preventDefault?{width:0,height:0,offset:{top:i.pageY,left:i.pageX}}:{width:t.outerWidth(),height:t.outerHeight(),offset:t.offset()}}e.ui=e.ui||{};var n,a,o=Math.max,r=Math.abs,h=Math.round,l=/left|center|right/,u=/top|center|bottom/,d=/[\+\-]\d+(\.[\d]+)?%?/,c=/^\w+/,p=/%$/,f=e.fn.position;e.position={scrollbarWidth:function(){if(void 0!==n)return n;var t,i,s=e("<div style='display:block;position:absolute;width:50px;height:50px;overflow:hidden;'><div style='height:100px;width:auto;'></div></div>"),a=s.children()[0];return e("body").append(s),t=a.offsetWidth,s.css("overflow","scroll"),i=a.offsetWidth,t===i&&(i=s[0].clientWidth),s.remove(),n=t-i},getScrollInfo:function(t){var i=t.isWindow||t.isDocument?"":t.element.css("overflow-x"),s=t.isWindow||t.isDocument?"":t.element.css("overflow-y"),n="scroll"===i||"auto"===i&&t.width<t.element[0].scrollWidth,a="scroll"===s||"auto"===s&&t.height<t.element[0].scrollHeight;return{width:a?e.position.scrollbarWidth():0,height:n?e.position.scrollbarWidth():0}},getWithinInfo:function(t){var i=e(t||window),s=e.isWindow(i[0]),n=!!i[0]&&9===i[0].nodeType;return{element:i,isWindow:s,isDocument:n,offset:i.offset()||{left:0,top:0},scrollLeft:i.scrollLeft(),scrollTop:i.scrollTop(),width:s||n?i.width():i.outerWidth(),height:s||n?i.height():i.outerHeight()}}},e.fn.position=function(n){if(!n||!n.of)return f.apply(this,arguments);n=e.extend({},n);var p,m,g,v,y,b,_=e(n.of),x=e.position.getWithinInfo(n.within),w=e.position.getScrollInfo(x),k=(n.collision||"flip").split(" "),T={};return b=s(_),_[0].preventDefault&&(n.at="left top"),m=b.width,g=b.height,v=b.offset,y=e.extend({},v),e.each(["my","at"],function(){var e,t,i=(n[this]||"").split(" ");1===i.length&&(i=l.test(i[0])?i.concat(["center"]):u.test(i[0])?["center"].concat(i):["center","center"]),i[0]=l.test(i[0])?i[0]:"center",i[1]=u.test(i[1])?i[1]:"center",e=d.exec(i[0]),t=d.exec(i[1]),T[this]=[e?e[0]:0,t?t[0]:0],n[this]=[c.exec(i[0])[0],c.exec(i[1])[0]]}),1===k.length&&(k[1]=k[0]),"right"===n.at[0]?y.left+=m:"center"===n.at[0]&&(y.left+=m/2),"bottom"===n.at[1]?y.top+=g:"center"===n.at[1]&&(y.top+=g/2),p=t(T.at,m,g),y.left+=p[0],y.top+=p[1],this.each(function(){var s,l,u=e(this),d=u.outerWidth(),c=u.outerHeight(),f=i(this,"marginLeft"),b=i(this,"marginTop"),D=d+f+i(this,"marginRight")+w.width,S=c+b+i(this,"marginBottom")+w.height,M=e.extend({},y),C=t(T.my,u.outerWidth(),u.outerHeight());"right"===n.my[0]?M.left-=d:"center"===n.my[0]&&(M.left-=d/2),"bottom"===n.my[1]?M.top-=c:"center"===n.my[1]&&(M.top-=c/2),M.left+=C[0],M.top+=C[1],a||(M.left=h(M.left),M.top=h(M.top)),s={marginLeft:f,marginTop:b},e.each(["left","top"],function(t,i){e.ui.position[k[t]]&&e.ui.position[k[t]][i](M,{targetWidth:m,targetHeight:g,elemWidth:d,elemHeight:c,collisionPosition:s,collisionWidth:D,collisionHeight:S,offset:[p[0]+C[0],p[1]+C[1]],my:n.my,at:n.at,within:x,elem:u})}),n.using&&(l=function(e){var t=v.left-M.left,i=t+m-d,s=v.top-M.top,a=s+g-c,h={target:{element:_,left:v.left,top:v.top,width:m,height:g},element:{element:u,left:M.left,top:M.top,width:d,height:c},horizontal:0>i?"left":t>0?"right":"center",vertical:0>a?"top":s>0?"bottom":"middle"};d>m&&m>r(t+i)&&(h.horizontal="center"),c>g&&g>r(s+a)&&(h.vertical="middle"),h.important=o(r(t),r(i))>o(r(s),r(a))?"horizontal":"vertical",n.using.call(this,e,h)}),u.offset(e.extend(M,{using:l}))})},e.ui.position={fit:{left:function(e,t){var i,s=t.within,n=s.isWindow?s.scrollLeft:s.offset.left,a=s.width,r=e.left-t.collisionPosition.marginLeft,h=n-r,l=r+t.collisionWidth-a-n;t.collisionWidth>a?h>0&&0>=l?(i=e.left+h+t.collisionWidth-a-n,e.left+=h-i):e.left=l>0&&0>=h?n:h>l?n+a-t.collisionWidth:n:h>0?e.left+=h:l>0?e.left-=l:e.left=o(e.left-r,e.left)},top:function(e,t){var i,s=t.within,n=s.isWindow?s.scrollTop:s.offset.top,a=t.within.height,r=e.top-t.collisionPosition.marginTop,h=n-r,l=r+t.collisionHeight-a-n;t.collisionHeight>a?h>0&&0>=l?(i=e.top+h+t.collisionHeight-a-n,e.top+=h-i):e.top=l>0&&0>=h?n:h>l?n+a-t.collisionHeight:n:h>0?e.top+=h:l>0?e.top-=l:e.top=o(e.top-r,e.top)}},flip:{left:function(e,t){var i,s,n=t.within,a=n.offset.left+n.scrollLeft,o=n.width,h=n.isWindow?n.scrollLeft:n.offset.left,l=e.left-t.collisionPosition.marginLeft,u=l-h,d=l+t.collisionWidth-o-h,c="left"===t.my[0]?-t.elemWidth:"right"===t.my[0]?t.elemWidth:0,p="left"===t.at[0]?t.targetWidth:"right"===t.at[0]?-t.targetWidth:0,f=-2*t.offset[0];0>u?(i=e.left+c+p+f+t.collisionWidth-o-a,(0>i||r(u)>i)&&(e.left+=c+p+f)):d>0&&(s=e.left-t.collisionPosition.marginLeft+c+p+f-h,(s>0||d>r(s))&&(e.left+=c+p+f))},top:function(e,t){var i,s,n=t.within,a=n.offset.top+n.scrollTop,o=n.height,h=n.isWindow?n.scrollTop:n.offset.top,l=e.top-t.collisionPosition.marginTop,u=l-h,d=l+t.collisionHeight-o-h,c="top"===t.my[1],p=c?-t.elemHeight:"bottom"===t.my[1]?t.elemHeight:0,f="top"===t.at[1]?t.targetHeight:"bottom"===t.at[1]?-t.targetHeight:0,m=-2*t.offset[1];0>u?(s=e.top+p+f+m+t.collisionHeight-o-a,e.top+p+f+m>u&&(0>s||r(u)>s)&&(e.top+=p+f+m)):d>0&&(i=e.top-t.collisionPosition.marginTop+p+f+m-h,e.top+p+f+m>d&&(i>0||d>r(i))&&(e.top+=p+f+m))}},flipfit:{left:function(){e.ui.position.flip.left.apply(this,arguments),e.ui.position.fit.left.apply(this,arguments)},top:function(){e.ui.position.flip.top.apply(this,arguments),e.ui.position.fit.top.apply(this,arguments)}}},function(){var t,i,s,n,o,r=document.getElementsByTagName("body")[0],h=document.createElement("div");t=document.createElement(r?"div":"body"),s={visibility:"hidden",width:0,height:0,border:0,margin:0,background:"none"},r&&e.extend(s,{position:"absolute",left:"-1000px",top:"-1000px"});for(o in s)t.style[o]=s[o];t.appendChild(h),i=r||document.documentElement,i.insertBefore(t,i.firstChild),h.style.cssText="position: absolute; left: 10.7432222px;",n=e(h).offset().left,a=n>10&&11>n,t.innerHTML="",i.removeChild(t)}()}(),e.ui.position,e.widget("ui.accordion",{version:"1.11.2",options:{active:0,animate:{},collapsible:!1,event:"click",header:"> li > :first-child,> :not(li):even",heightStyle:"auto",icons:{activeHeader:"ui-icon-triangle-1-s",header:"ui-icon-triangle-1-e"},activate:null,beforeActivate:null},hideProps:{borderTopWidth:"hide",borderBottomWidth:"hide",paddingTop:"hide",paddingBottom:"hide",height:"hide"},showProps:{borderTopWidth:"show",borderBottomWidth:"show",paddingTop:"show",paddingBottom:"show",height:"show"},_create:function(){var t=this.options;this.prevShow=this.prevHide=e(),this.element.addClass("ui-accordion ui-widget ui-helper-reset").attr("role","tablist"),t.collapsible||t.active!==!1&&null!=t.active||(t.active=0),this._processPanels(),0>t.active&&(t.active+=this.headers.length),this._refresh()},_getCreateEventData:function(){return{header:this.active,panel:this.active.length?this.active.next():e()}},_createIcons:function(){var t=this.options.icons;t&&(e("<span>").addClass("ui-accordion-header-icon ui-icon "+t.header).prependTo(this.headers),this.active.children(".ui-accordion-header-icon").removeClass(t.header).addClass(t.activeHeader),this.headers.addClass("ui-accordion-icons"))},_destroyIcons:function(){this.headers.removeClass("ui-accordion-icons").children(".ui-accordion-header-icon").remove()},_destroy:function(){var e;this.element.removeClass("ui-accordion ui-widget ui-helper-reset").removeAttr("role"),this.headers.removeClass("ui-accordion-header ui-accordion-header-active ui-state-default ui-corner-all ui-state-active ui-state-disabled ui-corner-top").removeAttr("role").removeAttr("aria-expanded").removeAttr("aria-selected").removeAttr("aria-controls").removeAttr("tabIndex").removeUniqueId(),this._destroyIcons(),e=this.headers.next().removeClass("ui-helper-reset ui-widget-content ui-corner-bottom ui-accordion-content ui-accordion-content-active ui-state-disabled").css("display","").removeAttr("role").removeAttr("aria-hidden").removeAttr("aria-labelledby").removeUniqueId(),"content"!==this.options.heightStyle&&e.css("height","")},_setOption:function(e,t){return"active"===e?(this._activate(t),void 0):("event"===e&&(this.options.event&&this._off(this.headers,this.options.event),this._setupEvents(t)),this._super(e,t),"collapsible"!==e||t||this.options.active!==!1||this._activate(0),"icons"===e&&(this._destroyIcons(),t&&this._createIcons()),"disabled"===e&&(this.element.toggleClass("ui-state-disabled",!!t).attr("aria-disabled",t),this.headers.add(this.headers.next()).toggleClass("ui-state-disabled",!!t)),void 0)},_keydown:function(t){if(!t.altKey&&!t.ctrlKey){var i=e.ui.keyCode,s=this.headers.length,n=this.headers.index(t.target),a=!1;switch(t.keyCode){case i.RIGHT:case i.DOWN:a=this.headers[(n+1)%s];break;case i.LEFT:case i.UP:a=this.headers[(n-1+s)%s];break;case i.SPACE:case i.ENTER:this._eventHandler(t);break;case i.HOME:a=this.headers[0];break;case i.END:a=this.headers[s-1]}a&&(e(t.target).attr("tabIndex",-1),e(a).attr("tabIndex",0),a.focus(),t.preventDefault())}},_panelKeyDown:function(t){t.keyCode===e.ui.keyCode.UP&&t.ctrlKey&&e(t.currentTarget).prev().focus()},refresh:function(){var t=this.options;this._processPanels(),t.active===!1&&t.collapsible===!0||!this.headers.length?(t.active=!1,this.active=e()):t.active===!1?this._activate(0):this.active.length&&!e.contains(this.element[0],this.active[0])?this.headers.length===this.headers.find(".ui-state-disabled").length?(t.active=!1,this.active=e()):this._activate(Math.max(0,t.active-1)):t.active=this.headers.index(this.active),this._destroyIcons(),this._refresh()},_processPanels:function(){var e=this.headers,t=this.panels;this.headers=this.element.find(this.options.header).addClass("ui-accordion-header ui-state-default ui-corner-all"),this.panels=this.headers.next().addClass("ui-accordion-content ui-helper-reset ui-widget-content ui-corner-bottom").filter(":not(.ui-accordion-content-active)").hide(),t&&(this._off(e.not(this.headers)),this._off(t.not(this.panels)))},_refresh:function(){var t,i=this.options,s=i.heightStyle,n=this.element.parent();this.active=this._findActive(i.active).addClass("ui-accordion-header-active ui-state-active ui-corner-top").removeClass("ui-corner-all"),this.active.next().addClass("ui-accordion-content-active").show(),this.headers.attr("role","tab").each(function(){var t=e(this),i=t.uniqueId().attr("id"),s=t.next(),n=s.uniqueId().attr("id");t.attr("aria-controls",n),s.attr("aria-labelledby",i)}).next().attr("role","tabpanel"),this.headers.not(this.active).attr({"aria-selected":"false","aria-expanded":"false",tabIndex:-1}).next().attr({"aria-hidden":"true"}).hide(),this.active.length?this.active.attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0}).next().attr({"aria-hidden":"false"}):this.headers.eq(0).attr("tabIndex",0),this._createIcons(),this._setupEvents(i.event),"fill"===s?(t=n.height(),this.element.siblings(":visible").each(function(){var i=e(this),s=i.css("position");"absolute"!==s&&"fixed"!==s&&(t-=i.outerHeight(!0))}),this.headers.each(function(){t-=e(this).outerHeight(!0)}),this.headers.next().each(function(){e(this).height(Math.max(0,t-e(this).innerHeight()+e(this).height()))}).css("overflow","auto")):"auto"===s&&(t=0,this.headers.next().each(function(){t=Math.max(t,e(this).css("height","").height())}).height(t))},_activate:function(t){var i=this._findActive(t)[0];i!==this.active[0]&&(i=i||this.active[0],this._eventHandler({target:i,currentTarget:i,preventDefault:e.noop}))},_findActive:function(t){return"number"==typeof t?this.headers.eq(t):e()},_setupEvents:function(t){var i={keydown:"_keydown"};t&&e.each(t.split(" "),function(e,t){i[t]="_eventHandler"}),this._off(this.headers.add(this.headers.next())),this._on(this.headers,i),this._on(this.headers.next(),{keydown:"_panelKeyDown"}),this._hoverable(this.headers),this._focusable(this.headers)},_eventHandler:function(t){var i=this.options,s=this.active,n=e(t.currentTarget),a=n[0]===s[0],o=a&&i.collapsible,r=o?e():n.next(),h=s.next(),l={oldHeader:s,oldPanel:h,newHeader:o?e():n,newPanel:r};t.preventDefault(),a&&!i.collapsible||this._trigger("beforeActivate",t,l)===!1||(i.active=o?!1:this.headers.index(n),this.active=a?e():n,this._toggle(l),s.removeClass("ui-accordion-header-active ui-state-active"),i.icons&&s.children(".ui-accordion-header-icon").removeClass(i.icons.activeHeader).addClass(i.icons.header),a||(n.removeClass("ui-corner-all").addClass("ui-accordion-header-active ui-state-active ui-corner-top"),i.icons&&n.children(".ui-accordion-header-icon").removeClass(i.icons.header).addClass(i.icons.activeHeader),n.next().addClass("ui-accordion-content-active")))},_toggle:function(t){var i=t.newPanel,s=this.prevShow.length?this.prevShow:t.oldPanel;this.prevShow.add(this.prevHide).stop(!0,!0),this.prevShow=i,this.prevHide=s,this.options.animate?this._animate(i,s,t):(s.hide(),i.show(),this._toggleComplete(t)),s.attr({"aria-hidden":"true"}),s.prev().attr("aria-selected","false"),i.length&&s.length?s.prev().attr({tabIndex:-1,"aria-expanded":"false"}):i.length&&this.headers.filter(function(){return 0===e(this).attr("tabIndex")}).attr("tabIndex",-1),i.attr("aria-hidden","false").prev().attr({"aria-selected":"true",tabIndex:0,"aria-expanded":"true"})},_animate:function(e,t,i){var s,n,a,o=this,r=0,h=e.length&&(!t.length||e.index()<t.index()),l=this.options.animate||{},u=h&&l.down||l,d=function(){o._toggleComplete(i)};return"number"==typeof u&&(a=u),"string"==typeof u&&(n=u),n=n||u.easing||l.easing,a=a||u.duration||l.duration,t.length?e.length?(s=e.show().outerHeight(),t.animate(this.hideProps,{duration:a,easing:n,step:function(e,t){t.now=Math.round(e)}}),e.hide().animate(this.showProps,{duration:a,easing:n,complete:d,step:function(e,i){i.now=Math.round(e),"height"!==i.prop?r+=i.now:"content"!==o.options.heightStyle&&(i.now=Math.round(s-t.outerHeight()-r),r=0)}}),void 0):t.animate(this.hideProps,a,n,d):e.animate(this.showProps,a,n,d)},_toggleComplete:function(e){var t=e.oldPanel;t.removeClass("ui-accordion-content-active").prev().removeClass("ui-corner-top").addClass("ui-corner-all"),t.length&&(t.parent()[0].className=t.parent()[0].className),this._trigger("activate",null,e)}}),e.widget("ui.menu",{version:"1.11.2",defaultElement:"<ul>",delay:300,options:{icons:{submenu:"ui-icon-carat-1-e"},items:"> *",menus:"ul",position:{my:"left-1 top",at:"right top"},role:"menu",blur:null,focus:null,select:null},_create:function(){this.activeMenu=this.element,this.mouseHandled=!1,this.element.uniqueId().addClass("ui-menu ui-widget ui-widget-content").toggleClass("ui-menu-icons",!!this.element.find(".ui-icon").length).attr({role:this.options.role,tabIndex:0}),this.options.disabled&&this.element.addClass("ui-state-disabled").attr("aria-disabled","true"),this._on({"mousedown .ui-menu-item":function(e){e.preventDefault()},"click .ui-menu-item":function(t){var i=e(t.target);!this.mouseHandled&&i.not(".ui-state-disabled").length&&(this.select(t),t.isPropagationStopped()||(this.mouseHandled=!0),i.has(".ui-menu").length?this.expand(t):!this.element.is(":focus")&&e(this.document[0].activeElement).closest(".ui-menu").length&&(this.element.trigger("focus",[!0]),this.active&&1===this.active.parents(".ui-menu").length&&clearTimeout(this.timer)))},"mouseenter .ui-menu-item":function(t){if(!this.previousFilter){var i=e(t.currentTarget);i.siblings(".ui-state-active").removeClass("ui-state-active"),this.focus(t,i)
}},mouseleave:"collapseAll","mouseleave .ui-menu":"collapseAll",focus:function(e,t){var i=this.active||this.element.find(this.options.items).eq(0);t||this.focus(e,i)},blur:function(t){this._delay(function(){e.contains(this.element[0],this.document[0].activeElement)||this.collapseAll(t)})},keydown:"_keydown"}),this.refresh(),this._on(this.document,{click:function(e){this._closeOnDocumentClick(e)&&this.collapseAll(e),this.mouseHandled=!1}})},_destroy:function(){this.element.removeAttr("aria-activedescendant").find(".ui-menu").addBack().removeClass("ui-menu ui-widget ui-widget-content ui-menu-icons ui-front").removeAttr("role").removeAttr("tabIndex").removeAttr("aria-labelledby").removeAttr("aria-expanded").removeAttr("aria-hidden").removeAttr("aria-disabled").removeUniqueId().show(),this.element.find(".ui-menu-item").removeClass("ui-menu-item").removeAttr("role").removeAttr("aria-disabled").removeUniqueId().removeClass("ui-state-hover").removeAttr("tabIndex").removeAttr("role").removeAttr("aria-haspopup").children().each(function(){var t=e(this);t.data("ui-menu-submenu-carat")&&t.remove()}),this.element.find(".ui-menu-divider").removeClass("ui-menu-divider ui-widget-content")},_keydown:function(t){var i,s,n,a,o=!0;switch(t.keyCode){case e.ui.keyCode.PAGE_UP:this.previousPage(t);break;case e.ui.keyCode.PAGE_DOWN:this.nextPage(t);break;case e.ui.keyCode.HOME:this._move("first","first",t);break;case e.ui.keyCode.END:this._move("last","last",t);break;case e.ui.keyCode.UP:this.previous(t);break;case e.ui.keyCode.DOWN:this.next(t);break;case e.ui.keyCode.LEFT:this.collapse(t);break;case e.ui.keyCode.RIGHT:this.active&&!this.active.is(".ui-state-disabled")&&this.expand(t);break;case e.ui.keyCode.ENTER:case e.ui.keyCode.SPACE:this._activate(t);break;case e.ui.keyCode.ESCAPE:this.collapse(t);break;default:o=!1,s=this.previousFilter||"",n=String.fromCharCode(t.keyCode),a=!1,clearTimeout(this.filterTimer),n===s?a=!0:n=s+n,i=this._filterMenuItems(n),i=a&&-1!==i.index(this.active.next())?this.active.nextAll(".ui-menu-item"):i,i.length||(n=String.fromCharCode(t.keyCode),i=this._filterMenuItems(n)),i.length?(this.focus(t,i),this.previousFilter=n,this.filterTimer=this._delay(function(){delete this.previousFilter},1e3)):delete this.previousFilter}o&&t.preventDefault()},_activate:function(e){this.active.is(".ui-state-disabled")||(this.active.is("[aria-haspopup='true']")?this.expand(e):this.select(e))},refresh:function(){var t,i,s=this,n=this.options.icons.submenu,a=this.element.find(this.options.menus);this.element.toggleClass("ui-menu-icons",!!this.element.find(".ui-icon").length),a.filter(":not(.ui-menu)").addClass("ui-menu ui-widget ui-widget-content ui-front").hide().attr({role:this.options.role,"aria-hidden":"true","aria-expanded":"false"}).each(function(){var t=e(this),i=t.parent(),s=e("<span>").addClass("ui-menu-icon ui-icon "+n).data("ui-menu-submenu-carat",!0);i.attr("aria-haspopup","true").prepend(s),t.attr("aria-labelledby",i.attr("id"))}),t=a.add(this.element),i=t.find(this.options.items),i.not(".ui-menu-item").each(function(){var t=e(this);s._isDivider(t)&&t.addClass("ui-widget-content ui-menu-divider")}),i.not(".ui-menu-item, .ui-menu-divider").addClass("ui-menu-item").uniqueId().attr({tabIndex:-1,role:this._itemRole()}),i.filter(".ui-state-disabled").attr("aria-disabled","true"),this.active&&!e.contains(this.element[0],this.active[0])&&this.blur()},_itemRole:function(){return{menu:"menuitem",listbox:"option"}[this.options.role]},_setOption:function(e,t){"icons"===e&&this.element.find(".ui-menu-icon").removeClass(this.options.icons.submenu).addClass(t.submenu),"disabled"===e&&this.element.toggleClass("ui-state-disabled",!!t).attr("aria-disabled",t),this._super(e,t)},focus:function(e,t){var i,s;this.blur(e,e&&"focus"===e.type),this._scrollIntoView(t),this.active=t.first(),s=this.active.addClass("ui-state-focus").removeClass("ui-state-active"),this.options.role&&this.element.attr("aria-activedescendant",s.attr("id")),this.active.parent().closest(".ui-menu-item").addClass("ui-state-active"),e&&"keydown"===e.type?this._close():this.timer=this._delay(function(){this._close()},this.delay),i=t.children(".ui-menu"),i.length&&e&&/^mouse/.test(e.type)&&this._startOpening(i),this.activeMenu=t.parent(),this._trigger("focus",e,{item:t})},_scrollIntoView:function(t){var i,s,n,a,o,r;this._hasScroll()&&(i=parseFloat(e.css(this.activeMenu[0],"borderTopWidth"))||0,s=parseFloat(e.css(this.activeMenu[0],"paddingTop"))||0,n=t.offset().top-this.activeMenu.offset().top-i-s,a=this.activeMenu.scrollTop(),o=this.activeMenu.height(),r=t.outerHeight(),0>n?this.activeMenu.scrollTop(a+n):n+r>o&&this.activeMenu.scrollTop(a+n-o+r))},blur:function(e,t){t||clearTimeout(this.timer),this.active&&(this.active.removeClass("ui-state-focus"),this.active=null,this._trigger("blur",e,{item:this.active}))},_startOpening:function(e){clearTimeout(this.timer),"true"===e.attr("aria-hidden")&&(this.timer=this._delay(function(){this._close(),this._open(e)},this.delay))},_open:function(t){var i=e.extend({of:this.active},this.options.position);clearTimeout(this.timer),this.element.find(".ui-menu").not(t.parents(".ui-menu")).hide().attr("aria-hidden","true"),t.show().removeAttr("aria-hidden").attr("aria-expanded","true").position(i)},collapseAll:function(t,i){clearTimeout(this.timer),this.timer=this._delay(function(){var s=i?this.element:e(t&&t.target).closest(this.element.find(".ui-menu"));s.length||(s=this.element),this._close(s),this.blur(t),this.activeMenu=s},this.delay)},_close:function(e){e||(e=this.active?this.active.parent():this.element),e.find(".ui-menu").hide().attr("aria-hidden","true").attr("aria-expanded","false").end().find(".ui-state-active").not(".ui-state-focus").removeClass("ui-state-active")},_closeOnDocumentClick:function(t){return!e(t.target).closest(".ui-menu").length},_isDivider:function(e){return!/[^\-\u2014\u2013\s]/.test(e.text())},collapse:function(e){var t=this.active&&this.active.parent().closest(".ui-menu-item",this.element);t&&t.length&&(this._close(),this.focus(e,t))},expand:function(e){var t=this.active&&this.active.children(".ui-menu ").find(this.options.items).first();t&&t.length&&(this._open(t.parent()),this._delay(function(){this.focus(e,t)}))},next:function(e){this._move("next","first",e)},previous:function(e){this._move("prev","last",e)},isFirstItem:function(){return this.active&&!this.active.prevAll(".ui-menu-item").length},isLastItem:function(){return this.active&&!this.active.nextAll(".ui-menu-item").length},_move:function(e,t,i){var s;this.active&&(s="first"===e||"last"===e?this.active["first"===e?"prevAll":"nextAll"](".ui-menu-item").eq(-1):this.active[e+"All"](".ui-menu-item").eq(0)),s&&s.length&&this.active||(s=this.activeMenu.find(this.options.items)[t]()),this.focus(i,s)},nextPage:function(t){var i,s,n;return this.active?(this.isLastItem()||(this._hasScroll()?(s=this.active.offset().top,n=this.element.height(),this.active.nextAll(".ui-menu-item").each(function(){return i=e(this),0>i.offset().top-s-n}),this.focus(t,i)):this.focus(t,this.activeMenu.find(this.options.items)[this.active?"last":"first"]())),void 0):(this.next(t),void 0)},previousPage:function(t){var i,s,n;return this.active?(this.isFirstItem()||(this._hasScroll()?(s=this.active.offset().top,n=this.element.height(),this.active.prevAll(".ui-menu-item").each(function(){return i=e(this),i.offset().top-s+n>0}),this.focus(t,i)):this.focus(t,this.activeMenu.find(this.options.items).first())),void 0):(this.next(t),void 0)},_hasScroll:function(){return this.element.outerHeight()<this.element.prop("scrollHeight")},select:function(t){this.active=this.active||e(t.target).closest(".ui-menu-item");var i={item:this.active};this.active.has(".ui-menu").length||this.collapseAll(t,!0),this._trigger("select",t,i)},_filterMenuItems:function(t){var i=t.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&"),s=RegExp("^"+i,"i");return this.activeMenu.find(this.options.items).filter(".ui-menu-item").filter(function(){return s.test(e.trim(e(this).text()))})}}),e.widget("ui.autocomplete",{version:"1.11.2",defaultElement:"<input>",options:{appendTo:null,autoFocus:!1,delay:300,minLength:1,position:{my:"left top",at:"left bottom",collision:"none"},source:null,change:null,close:null,focus:null,open:null,response:null,search:null,select:null},requestIndex:0,pending:0,_create:function(){var t,i,s,n=this.element[0].nodeName.toLowerCase(),a="textarea"===n,o="input"===n;this.isMultiLine=a?!0:o?!1:this.element.prop("isContentEditable"),this.valueMethod=this.element[a||o?"val":"text"],this.isNewMenu=!0,this.element.addClass("ui-autocomplete-input").attr("autocomplete","off"),this._on(this.element,{keydown:function(n){if(this.element.prop("readOnly"))return t=!0,s=!0,i=!0,void 0;t=!1,s=!1,i=!1;var a=e.ui.keyCode;switch(n.keyCode){case a.PAGE_UP:t=!0,this._move("previousPage",n);break;case a.PAGE_DOWN:t=!0,this._move("nextPage",n);break;case a.UP:t=!0,this._keyEvent("previous",n);break;case a.DOWN:t=!0,this._keyEvent("next",n);break;case a.ENTER:this.menu.active&&(t=!0,n.preventDefault(),this.menu.select(n));break;case a.TAB:this.menu.active&&this.menu.select(n);break;case a.ESCAPE:this.menu.element.is(":visible")&&(this.isMultiLine||this._value(this.term),this.close(n),n.preventDefault());break;default:i=!0,this._searchTimeout(n)}},keypress:function(s){if(t)return t=!1,(!this.isMultiLine||this.menu.element.is(":visible"))&&s.preventDefault(),void 0;if(!i){var n=e.ui.keyCode;switch(s.keyCode){case n.PAGE_UP:this._move("previousPage",s);break;case n.PAGE_DOWN:this._move("nextPage",s);break;case n.UP:this._keyEvent("previous",s);break;case n.DOWN:this._keyEvent("next",s)}}},input:function(e){return s?(s=!1,e.preventDefault(),void 0):(this._searchTimeout(e),void 0)},focus:function(){this.selectedItem=null,this.previous=this._value()},blur:function(e){return this.cancelBlur?(delete this.cancelBlur,void 0):(clearTimeout(this.searching),this.close(e),this._change(e),void 0)}}),this._initSource(),this.menu=e("<ul>").addClass("ui-autocomplete ui-front").appendTo(this._appendTo()).menu({role:null}).hide().menu("instance"),this._on(this.menu.element,{mousedown:function(t){t.preventDefault(),this.cancelBlur=!0,this._delay(function(){delete this.cancelBlur});var i=this.menu.element[0];e(t.target).closest(".ui-menu-item").length||this._delay(function(){var t=this;this.document.one("mousedown",function(s){s.target===t.element[0]||s.target===i||e.contains(i,s.target)||t.close()})})},menufocus:function(t,i){var s,n;return this.isNewMenu&&(this.isNewMenu=!1,t.originalEvent&&/^mouse/.test(t.originalEvent.type))?(this.menu.blur(),this.document.one("mousemove",function(){e(t.target).trigger(t.originalEvent)}),void 0):(n=i.item.data("ui-autocomplete-item"),!1!==this._trigger("focus",t,{item:n})&&t.originalEvent&&/^key/.test(t.originalEvent.type)&&this._value(n.value),s=i.item.attr("aria-label")||n.value,s&&e.trim(s).length&&(this.liveRegion.children().hide(),e("<div>").text(s).appendTo(this.liveRegion)),void 0)},menuselect:function(e,t){var i=t.item.data("ui-autocomplete-item"),s=this.previous;this.element[0]!==this.document[0].activeElement&&(this.element.focus(),this.previous=s,this._delay(function(){this.previous=s,this.selectedItem=i})),!1!==this._trigger("select",e,{item:i})&&this._value(i.value),this.term=this._value(),this.close(e),this.selectedItem=i}}),this.liveRegion=e("<span>",{role:"status","aria-live":"assertive","aria-relevant":"additions"}).addClass("ui-helper-hidden-accessible").appendTo(this.document[0].body),this._on(this.window,{beforeunload:function(){this.element.removeAttr("autocomplete")}})},_destroy:function(){clearTimeout(this.searching),this.element.removeClass("ui-autocomplete-input").removeAttr("autocomplete"),this.menu.element.remove(),this.liveRegion.remove()},_setOption:function(e,t){this._super(e,t),"source"===e&&this._initSource(),"appendTo"===e&&this.menu.element.appendTo(this._appendTo()),"disabled"===e&&t&&this.xhr&&this.xhr.abort()},_appendTo:function(){var t=this.options.appendTo;return t&&(t=t.jquery||t.nodeType?e(t):this.document.find(t).eq(0)),t&&t[0]||(t=this.element.closest(".ui-front")),t.length||(t=this.document[0].body),t},_initSource:function(){var t,i,s=this;e.isArray(this.options.source)?(t=this.options.source,this.source=function(i,s){s(e.ui.autocomplete.filter(t,i.term))}):"string"==typeof this.options.source?(i=this.options.source,this.source=function(t,n){s.xhr&&s.xhr.abort(),s.xhr=e.ajax({url:i,data:t,dataType:"json",success:function(e){n(e)},error:function(){n([])}})}):this.source=this.options.source},_searchTimeout:function(e){clearTimeout(this.searching),this.searching=this._delay(function(){var t=this.term===this._value(),i=this.menu.element.is(":visible"),s=e.altKey||e.ctrlKey||e.metaKey||e.shiftKey;(!t||t&&!i&&!s)&&(this.selectedItem=null,this.search(null,e))},this.options.delay)},search:function(e,t){return e=null!=e?e:this._value(),this.term=this._value(),e.length<this.options.minLength?this.close(t):this._trigger("search",t)!==!1?this._search(e):void 0},_search:function(e){this.pending++,this.element.addClass("ui-autocomplete-loading"),this.cancelSearch=!1,this.source({term:e},this._response())},_response:function(){var t=++this.requestIndex;return e.proxy(function(e){t===this.requestIndex&&this.__response(e),this.pending--,this.pending||this.element.removeClass("ui-autocomplete-loading")},this)},__response:function(e){e&&(e=this._normalize(e)),this._trigger("response",null,{content:e}),!this.options.disabled&&e&&e.length&&!this.cancelSearch?(this._suggest(e),this._trigger("open")):this._close()},close:function(e){this.cancelSearch=!0,this._close(e)},_close:function(e){this.menu.element.is(":visible")&&(this.menu.element.hide(),this.menu.blur(),this.isNewMenu=!0,this._trigger("close",e))},_change:function(e){this.previous!==this._value()&&this._trigger("change",e,{item:this.selectedItem})},_normalize:function(t){return t.length&&t[0].label&&t[0].value?t:e.map(t,function(t){return"string"==typeof t?{label:t,value:t}:e.extend({},t,{label:t.label||t.value,value:t.value||t.label})})},_suggest:function(t){var i=this.menu.element.empty();this._renderMenu(i,t),this.isNewMenu=!0,this.menu.refresh(),i.show(),this._resizeMenu(),i.position(e.extend({of:this.element},this.options.position)),this.options.autoFocus&&this.menu.next()},_resizeMenu:function(){var e=this.menu.element;e.outerWidth(Math.max(e.width("").outerWidth()+1,this.element.outerWidth()))},_renderMenu:function(t,i){var s=this;e.each(i,function(e,i){s._renderItemData(t,i)})},_renderItemData:function(e,t){return this._renderItem(e,t).data("ui-autocomplete-item",t)},_renderItem:function(t,i){return e("<li>").text(i.label).appendTo(t)},_move:function(e,t){return this.menu.element.is(":visible")?this.menu.isFirstItem()&&/^previous/.test(e)||this.menu.isLastItem()&&/^next/.test(e)?(this.isMultiLine||this._value(this.term),this.menu.blur(),void 0):(this.menu[e](t),void 0):(this.search(null,t),void 0)},widget:function(){return this.menu.element},_value:function(){return this.valueMethod.apply(this.element,arguments)},_keyEvent:function(e,t){(!this.isMultiLine||this.menu.element.is(":visible"))&&(this._move(e,t),t.preventDefault())}}),e.extend(e.ui.autocomplete,{escapeRegex:function(e){return e.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&")},filter:function(t,i){var s=RegExp(e.ui.autocomplete.escapeRegex(i),"i");return e.grep(t,function(e){return s.test(e.label||e.value||e)})}}),e.widget("ui.autocomplete",e.ui.autocomplete,{options:{messages:{noResults:"No search results.",results:function(e){return e+(e>1?" results are":" result is")+" available, use up and down arrow keys to navigate."}}},__response:function(t){var i;this._superApply(arguments),this.options.disabled||this.cancelSearch||(i=t&&t.length?this.options.messages.results(t.length):this.options.messages.noResults,this.liveRegion.children().hide(),e("<div>").text(i).appendTo(this.liveRegion))}}),e.ui.autocomplete;var c,p="ui-button ui-widget ui-state-default ui-corner-all",f="ui-button-icons-only ui-button-icon-only ui-button-text-icons ui-button-text-icon-primary ui-button-text-icon-secondary ui-button-text-only",m=function(){var t=e(this);setTimeout(function(){t.find(":ui-button").button("refresh")},1)},g=function(t){var i=t.name,s=t.form,n=e([]);return i&&(i=i.replace(/'/g,"\\'"),n=s?e(s).find("[name='"+i+"'][type=radio]"):e("[name='"+i+"'][type=radio]",t.ownerDocument).filter(function(){return!this.form})),n};e.widget("ui.button",{version:"1.11.2",defaultElement:"<button>",options:{disabled:null,text:!0,label:null,icons:{primary:null,secondary:null}},_create:function(){this.element.closest("form").unbind("reset"+this.eventNamespace).bind("reset"+this.eventNamespace,m),"boolean"!=typeof this.options.disabled?this.options.disabled=!!this.element.prop("disabled"):this.element.prop("disabled",this.options.disabled),this._determineButtonType(),this.hasTitle=!!this.buttonElement.attr("title");var t=this,i=this.options,s="checkbox"===this.type||"radio"===this.type,n=s?"":"ui-state-active";null===i.label&&(i.label="input"===this.type?this.buttonElement.val():this.buttonElement.html()),this._hoverable(this.buttonElement),this.buttonElement.addClass(p).attr("role","button").bind("mouseenter"+this.eventNamespace,function(){i.disabled||this===c&&e(this).addClass("ui-state-active")}).bind("mouseleave"+this.eventNamespace,function(){i.disabled||e(this).removeClass(n)}).bind("click"+this.eventNamespace,function(e){i.disabled&&(e.preventDefault(),e.stopImmediatePropagation())}),this._on({focus:function(){this.buttonElement.addClass("ui-state-focus")},blur:function(){this.buttonElement.removeClass("ui-state-focus")}}),s&&this.element.bind("change"+this.eventNamespace,function(){t.refresh()}),"checkbox"===this.type?this.buttonElement.bind("click"+this.eventNamespace,function(){return i.disabled?!1:void 0}):"radio"===this.type?this.buttonElement.bind("click"+this.eventNamespace,function(){if(i.disabled)return!1;e(this).addClass("ui-state-active"),t.buttonElement.attr("aria-pressed","true");var s=t.element[0];g(s).not(s).map(function(){return e(this).button("widget")[0]}).removeClass("ui-state-active").attr("aria-pressed","false")}):(this.buttonElement.bind("mousedown"+this.eventNamespace,function(){return i.disabled?!1:(e(this).addClass("ui-state-active"),c=this,t.document.one("mouseup",function(){c=null}),void 0)}).bind("mouseup"+this.eventNamespace,function(){return i.disabled?!1:(e(this).removeClass("ui-state-active"),void 0)}).bind("keydown"+this.eventNamespace,function(t){return i.disabled?!1:((t.keyCode===e.ui.keyCode.SPACE||t.keyCode===e.ui.keyCode.ENTER)&&e(this).addClass("ui-state-active"),void 0)}).bind("keyup"+this.eventNamespace+" blur"+this.eventNamespace,function(){e(this).removeClass("ui-state-active")}),this.buttonElement.is("a")&&this.buttonElement.keyup(function(t){t.keyCode===e.ui.keyCode.SPACE&&e(this).click()})),this._setOption("disabled",i.disabled),this._resetButton()},_determineButtonType:function(){var e,t,i;this.type=this.element.is("[type=checkbox]")?"checkbox":this.element.is("[type=radio]")?"radio":this.element.is("input")?"input":"button","checkbox"===this.type||"radio"===this.type?(e=this.element.parents().last(),t="label[for='"+this.element.attr("id")+"']",this.buttonElement=e.find(t),this.buttonElement.length||(e=e.length?e.siblings():this.element.siblings(),this.buttonElement=e.filter(t),this.buttonElement.length||(this.buttonElement=e.find(t))),this.element.addClass("ui-helper-hidden-accessible"),i=this.element.is(":checked"),i&&this.buttonElement.addClass("ui-state-active"),this.buttonElement.prop("aria-pressed",i)):this.buttonElement=this.element},widget:function(){return this.buttonElement},_destroy:function(){this.element.removeClass("ui-helper-hidden-accessible"),this.buttonElement.removeClass(p+" ui-state-active "+f).removeAttr("role").removeAttr("aria-pressed").html(this.buttonElement.find(".ui-button-text").html()),this.hasTitle||this.buttonElement.removeAttr("title")},_setOption:function(e,t){return this._super(e,t),"disabled"===e?(this.widget().toggleClass("ui-state-disabled",!!t),this.element.prop("disabled",!!t),t&&("checkbox"===this.type||"radio"===this.type?this.buttonElement.removeClass("ui-state-focus"):this.buttonElement.removeClass("ui-state-focus ui-state-active")),void 0):(this._resetButton(),void 0)},refresh:function(){var t=this.element.is("input, button")?this.element.is(":disabled"):this.element.hasClass("ui-button-disabled");t!==this.options.disabled&&this._setOption("disabled",t),"radio"===this.type?g(this.element[0]).each(function(){e(this).is(":checked")?e(this).button("widget").addClass("ui-state-active").attr("aria-pressed","true"):e(this).button("widget").removeClass("ui-state-active").attr("aria-pressed","false")}):"checkbox"===this.type&&(this.element.is(":checked")?this.buttonElement.addClass("ui-state-active").attr("aria-pressed","true"):this.buttonElement.removeClass("ui-state-active").attr("aria-pressed","false"))},_resetButton:function(){if("input"===this.type)return this.options.label&&this.element.val(this.options.label),void 0;var t=this.buttonElement.removeClass(f),i=e("<span></span>",this.document[0]).addClass("ui-button-text").html(this.options.label).appendTo(t.empty()).text(),s=this.options.icons,n=s.primary&&s.secondary,a=[];s.primary||s.secondary?(this.options.text&&a.push("ui-button-text-icon"+(n?"s":s.primary?"-primary":"-secondary")),s.primary&&t.prepend("<span class='ui-button-icon-primary ui-icon "+s.primary+"'></span>"),s.secondary&&t.append("<span class='ui-button-icon-secondary ui-icon "+s.secondary+"'></span>"),this.options.text||(a.push(n?"ui-button-icons-only":"ui-button-icon-only"),this.hasTitle||t.attr("title",e.trim(i)))):a.push("ui-button-text-only"),t.addClass(a.join(" "))}}),e.widget("ui.buttonset",{version:"1.11.2",options:{items:"button, input[type=button], input[type=submit], input[type=reset], input[type=checkbox], input[type=radio], a, :data(ui-button)"},_create:function(){this.element.addClass("ui-buttonset")},_init:function(){this.refresh()},_setOption:function(e,t){"disabled"===e&&this.buttons.button("option",e,t),this._super(e,t)},refresh:function(){var t="rtl"===this.element.css("direction"),i=this.element.find(this.options.items),s=i.filter(":ui-button");i.not(":ui-button").button(),s.button("refresh"),this.buttons=i.map(function(){return e(this).button("widget")[0]}).removeClass("ui-corner-all ui-corner-left ui-corner-right").filter(":first").addClass(t?"ui-corner-right":"ui-corner-left").end().filter(":last").addClass(t?"ui-corner-left":"ui-corner-right").end().end()},_destroy:function(){this.element.removeClass("ui-buttonset"),this.buttons.map(function(){return e(this).button("widget")[0]}).removeClass("ui-corner-left ui-corner-right").end().button("destroy")}}),e.ui.button,e.extend(e.ui,{datepicker:{version:"1.11.2"}});var v;e.extend(n.prototype,{markerClassName:"hasDatepicker",maxRows:4,_widgetDatepicker:function(){return this.dpDiv},setDefaults:function(e){return r(this._defaults,e||{}),this},_attachDatepicker:function(t,i){var s,n,a;s=t.nodeName.toLowerCase(),n="div"===s||"span"===s,t.id||(this.uuid+=1,t.id="dp"+this.uuid),a=this._newInst(e(t),n),a.settings=e.extend({},i||{}),"input"===s?this._connectDatepicker(t,a):n&&this._inlineDatepicker(t,a)},_newInst:function(t,i){var s=t[0].id.replace(/([^A-Za-z0-9_\-])/g,"\\\\$1");return{id:s,input:t,selectedDay:0,selectedMonth:0,selectedYear:0,drawMonth:0,drawYear:0,inline:i,dpDiv:i?a(e("<div class='"+this._inlineClass+" ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>")):this.dpDiv}},_connectDatepicker:function(t,i){var s=e(t);i.append=e([]),i.trigger=e([]),s.hasClass(this.markerClassName)||(this._attachments(s,i),s.addClass(this.markerClassName).keydown(this._doKeyDown).keypress(this._doKeyPress).keyup(this._doKeyUp),this._autoSize(i),e.data(t,"datepicker",i),i.settings.disabled&&this._disableDatepicker(t))},_attachments:function(t,i){var s,n,a,o=this._get(i,"appendText"),r=this._get(i,"isRTL");i.append&&i.append.remove(),o&&(i.append=e("<span class='"+this._appendClass+"'>"+o+"</span>"),t[r?"before":"after"](i.append)),t.unbind("focus",this._showDatepicker),i.trigger&&i.trigger.remove(),s=this._get(i,"showOn"),("focus"===s||"both"===s)&&t.focus(this._showDatepicker),("button"===s||"both"===s)&&(n=this._get(i,"buttonText"),a=this._get(i,"buttonImage"),i.trigger=e(this._get(i,"buttonImageOnly")?e("<img/>").addClass(this._triggerClass).attr({src:a,alt:n,title:n}):e("<button type='button'></button>").addClass(this._triggerClass).html(a?e("<img/>").attr({src:a,alt:n,title:n}):n)),t[r?"before":"after"](i.trigger),i.trigger.click(function(){return e.datepicker._datepickerShowing&&e.datepicker._lastInput===t[0]?e.datepicker._hideDatepicker():e.datepicker._datepickerShowing&&e.datepicker._lastInput!==t[0]?(e.datepicker._hideDatepicker(),e.datepicker._showDatepicker(t[0])):e.datepicker._showDatepicker(t[0]),!1}))},_autoSize:function(e){if(this._get(e,"autoSize")&&!e.inline){var t,i,s,n,a=new Date(2009,11,20),o=this._get(e,"dateFormat");o.match(/[DM]/)&&(t=function(e){for(i=0,s=0,n=0;e.length>n;n++)e[n].length>i&&(i=e[n].length,s=n);return s},a.setMonth(t(this._get(e,o.match(/MM/)?"monthNames":"monthNamesShort"))),a.setDate(t(this._get(e,o.match(/DD/)?"dayNames":"dayNamesShort"))+20-a.getDay())),e.input.attr("size",this._formatDate(e,a).length)}},_inlineDatepicker:function(t,i){var s=e(t);s.hasClass(this.markerClassName)||(s.addClass(this.markerClassName).append(i.dpDiv),e.data(t,"datepicker",i),this._setDate(i,this._getDefaultDate(i),!0),this._updateDatepicker(i),this._updateAlternate(i),i.settings.disabled&&this._disableDatepicker(t),i.dpDiv.css("display","block"))},_dialogDatepicker:function(t,i,s,n,a){var o,h,l,u,d,c=this._dialogInst;return c||(this.uuid+=1,o="dp"+this.uuid,this._dialogInput=e("<input type='text' id='"+o+"' style='position: absolute; top: -100px; width: 0px;'/>"),this._dialogInput.keydown(this._doKeyDown),e("body").append(this._dialogInput),c=this._dialogInst=this._newInst(this._dialogInput,!1),c.settings={},e.data(this._dialogInput[0],"datepicker",c)),r(c.settings,n||{}),i=i&&i.constructor===Date?this._formatDate(c,i):i,this._dialogInput.val(i),this._pos=a?a.length?a:[a.pageX,a.pageY]:null,this._pos||(h=document.documentElement.clientWidth,l=document.documentElement.clientHeight,u=document.documentElement.scrollLeft||document.body.scrollLeft,d=document.documentElement.scrollTop||document.body.scrollTop,this._pos=[h/2-100+u,l/2-150+d]),this._dialogInput.css("left",this._pos[0]+20+"px").css("top",this._pos[1]+"px"),c.settings.onSelect=s,this._inDialog=!0,this.dpDiv.addClass(this._dialogClass),this._showDatepicker(this._dialogInput[0]),e.blockUI&&e.blockUI(this.dpDiv),e.data(this._dialogInput[0],"datepicker",c),this},_destroyDatepicker:function(t){var i,s=e(t),n=e.data(t,"datepicker");s.hasClass(this.markerClassName)&&(i=t.nodeName.toLowerCase(),e.removeData(t,"datepicker"),"input"===i?(n.append.remove(),n.trigger.remove(),s.removeClass(this.markerClassName).unbind("focus",this._showDatepicker).unbind("keydown",this._doKeyDown).unbind("keypress",this._doKeyPress).unbind("keyup",this._doKeyUp)):("div"===i||"span"===i)&&s.removeClass(this.markerClassName).empty())},_enableDatepicker:function(t){var i,s,n=e(t),a=e.data(t,"datepicker");n.hasClass(this.markerClassName)&&(i=t.nodeName.toLowerCase(),"input"===i?(t.disabled=!1,a.trigger.filter("button").each(function(){this.disabled=!1}).end().filter("img").css({opacity:"1.0",cursor:""})):("div"===i||"span"===i)&&(s=n.children("."+this._inlineClass),s.children().removeClass("ui-state-disabled"),s.find("select.ui-datepicker-month, select.ui-datepicker-year").prop("disabled",!1)),this._disabledInputs=e.map(this._disabledInputs,function(e){return e===t?null:e}))},_disableDatepicker:function(t){var i,s,n=e(t),a=e.data(t,"datepicker");n.hasClass(this.markerClassName)&&(i=t.nodeName.toLowerCase(),"input"===i?(t.disabled=!0,a.trigger.filter("button").each(function(){this.disabled=!0}).end().filter("img").css({opacity:"0.5",cursor:"default"})):("div"===i||"span"===i)&&(s=n.children("."+this._inlineClass),s.children().addClass("ui-state-disabled"),s.find("select.ui-datepicker-month, select.ui-datepicker-year").prop("disabled",!0)),this._disabledInputs=e.map(this._disabledInputs,function(e){return e===t?null:e}),this._disabledInputs[this._disabledInputs.length]=t)},_isDisabledDatepicker:function(e){if(!e)return!1;for(var t=0;this._disabledInputs.length>t;t++)if(this._disabledInputs[t]===e)return!0;return!1},_getInst:function(t){try{return e.data(t,"datepicker")}catch(i){throw"Missing instance data for this datepicker"}},_optionDatepicker:function(t,i,s){var n,a,o,h,l=this._getInst(t);return 2===arguments.length&&"string"==typeof i?"defaults"===i?e.extend({},e.datepicker._defaults):l?"all"===i?e.extend({},l.settings):this._get(l,i):null:(n=i||{},"string"==typeof i&&(n={},n[i]=s),l&&(this._curInst===l&&this._hideDatepicker(),a=this._getDateDatepicker(t,!0),o=this._getMinMaxDate(l,"min"),h=this._getMinMaxDate(l,"max"),r(l.settings,n),null!==o&&void 0!==n.dateFormat&&void 0===n.minDate&&(l.settings.minDate=this._formatDate(l,o)),null!==h&&void 0!==n.dateFormat&&void 0===n.maxDate&&(l.settings.maxDate=this._formatDate(l,h)),"disabled"in n&&(n.disabled?this._disableDatepicker(t):this._enableDatepicker(t)),this._attachments(e(t),l),this._autoSize(l),this._setDate(l,a),this._updateAlternate(l),this._updateDatepicker(l)),void 0)},_changeDatepicker:function(e,t,i){this._optionDatepicker(e,t,i)},_refreshDatepicker:function(e){var t=this._getInst(e);t&&this._updateDatepicker(t)},_setDateDatepicker:function(e,t){var i=this._getInst(e);i&&(this._setDate(i,t),this._updateDatepicker(i),this._updateAlternate(i))},_getDateDatepicker:function(e,t){var i=this._getInst(e);return i&&!i.inline&&this._setDateFromField(i,t),i?this._getDate(i):null},_doKeyDown:function(t){var i,s,n,a=e.datepicker._getInst(t.target),o=!0,r=a.dpDiv.is(".ui-datepicker-rtl");if(a._keyEvent=!0,e.datepicker._datepickerShowing)switch(t.keyCode){case 9:e.datepicker._hideDatepicker(),o=!1;break;case 13:return n=e("td."+e.datepicker._dayOverClass+":not(."+e.datepicker._currentClass+")",a.dpDiv),n[0]&&e.datepicker._selectDay(t.target,a.selectedMonth,a.selectedYear,n[0]),i=e.datepicker._get(a,"onSelect"),i?(s=e.datepicker._formatDate(a),i.apply(a.input?a.input[0]:null,[s,a])):e.datepicker._hideDatepicker(),!1;case 27:e.datepicker._hideDatepicker();break;case 33:e.datepicker._adjustDate(t.target,t.ctrlKey?-e.datepicker._get(a,"stepBigMonths"):-e.datepicker._get(a,"stepMonths"),"M");break;case 34:e.datepicker._adjustDate(t.target,t.ctrlKey?+e.datepicker._get(a,"stepBigMonths"):+e.datepicker._get(a,"stepMonths"),"M");break;case 35:(t.ctrlKey||t.metaKey)&&e.datepicker._clearDate(t.target),o=t.ctrlKey||t.metaKey;break;case 36:(t.ctrlKey||t.metaKey)&&e.datepicker._gotoToday(t.target),o=t.ctrlKey||t.metaKey;break;case 37:(t.ctrlKey||t.metaKey)&&e.datepicker._adjustDate(t.target,r?1:-1,"D"),o=t.ctrlKey||t.metaKey,t.originalEvent.altKey&&e.datepicker._adjustDate(t.target,t.ctrlKey?-e.datepicker._get(a,"stepBigMonths"):-e.datepicker._get(a,"stepMonths"),"M");break;case 38:(t.ctrlKey||t.metaKey)&&e.datepicker._adjustDate(t.target,-7,"D"),o=t.ctrlKey||t.metaKey;break;case 39:(t.ctrlKey||t.metaKey)&&e.datepicker._adjustDate(t.target,r?-1:1,"D"),o=t.ctrlKey||t.metaKey,t.originalEvent.altKey&&e.datepicker._adjustDate(t.target,t.ctrlKey?+e.datepicker._get(a,"stepBigMonths"):+e.datepicker._get(a,"stepMonths"),"M");break;case 40:(t.ctrlKey||t.metaKey)&&e.datepicker._adjustDate(t.target,7,"D"),o=t.ctrlKey||t.metaKey;break;default:o=!1}else 36===t.keyCode&&t.ctrlKey?e.datepicker._showDatepicker(this):o=!1;o&&(t.preventDefault(),t.stopPropagation())},_doKeyPress:function(t){var i,s,n=e.datepicker._getInst(t.target);return e.datepicker._get(n,"constrainInput")?(i=e.datepicker._possibleChars(e.datepicker._get(n,"dateFormat")),s=String.fromCharCode(null==t.charCode?t.keyCode:t.charCode),t.ctrlKey||t.metaKey||" ">s||!i||i.indexOf(s)>-1):void 0
},_doKeyUp:function(t){var i,s=e.datepicker._getInst(t.target);if(s.input.val()!==s.lastVal)try{i=e.datepicker.parseDate(e.datepicker._get(s,"dateFormat"),s.input?s.input.val():null,e.datepicker._getFormatConfig(s)),i&&(e.datepicker._setDateFromField(s),e.datepicker._updateAlternate(s),e.datepicker._updateDatepicker(s))}catch(n){}return!0},_showDatepicker:function(t){if(t=t.target||t,"input"!==t.nodeName.toLowerCase()&&(t=e("input",t.parentNode)[0]),!e.datepicker._isDisabledDatepicker(t)&&e.datepicker._lastInput!==t){var i,n,a,o,h,l,u;i=e.datepicker._getInst(t),e.datepicker._curInst&&e.datepicker._curInst!==i&&(e.datepicker._curInst.dpDiv.stop(!0,!0),i&&e.datepicker._datepickerShowing&&e.datepicker._hideDatepicker(e.datepicker._curInst.input[0])),n=e.datepicker._get(i,"beforeShow"),a=n?n.apply(t,[t,i]):{},a!==!1&&(r(i.settings,a),i.lastVal=null,e.datepicker._lastInput=t,e.datepicker._setDateFromField(i),e.datepicker._inDialog&&(t.value=""),e.datepicker._pos||(e.datepicker._pos=e.datepicker._findPos(t),e.datepicker._pos[1]+=t.offsetHeight),o=!1,e(t).parents().each(function(){return o|="fixed"===e(this).css("position"),!o}),h={left:e.datepicker._pos[0],top:e.datepicker._pos[1]},e.datepicker._pos=null,i.dpDiv.empty(),i.dpDiv.css({position:"absolute",display:"block",top:"-1000px"}),e.datepicker._updateDatepicker(i),h=e.datepicker._checkOffset(i,h,o),i.dpDiv.css({position:e.datepicker._inDialog&&e.blockUI?"static":o?"fixed":"absolute",display:"none",left:h.left+"px",top:h.top+"px"}),i.inline||(l=e.datepicker._get(i,"showAnim"),u=e.datepicker._get(i,"duration"),i.dpDiv.css("z-index",s(e(t))+1),e.datepicker._datepickerShowing=!0,e.effects&&e.effects.effect[l]?i.dpDiv.show(l,e.datepicker._get(i,"showOptions"),u):i.dpDiv[l||"show"](l?u:null),e.datepicker._shouldFocusInput(i)&&i.input.focus(),e.datepicker._curInst=i))}},_updateDatepicker:function(t){this.maxRows=4,v=t,t.dpDiv.empty().append(this._generateHTML(t)),this._attachHandlers(t);var i,s=this._getNumberOfMonths(t),n=s[1],a=17,r=t.dpDiv.find("."+this._dayOverClass+" a");r.length>0&&o.apply(r.get(0)),t.dpDiv.removeClass("ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4").width(""),n>1&&t.dpDiv.addClass("ui-datepicker-multi-"+n).css("width",a*n+"em"),t.dpDiv[(1!==s[0]||1!==s[1]?"add":"remove")+"Class"]("ui-datepicker-multi"),t.dpDiv[(this._get(t,"isRTL")?"add":"remove")+"Class"]("ui-datepicker-rtl"),t===e.datepicker._curInst&&e.datepicker._datepickerShowing&&e.datepicker._shouldFocusInput(t)&&t.input.focus(),t.yearshtml&&(i=t.yearshtml,setTimeout(function(){i===t.yearshtml&&t.yearshtml&&t.dpDiv.find("select.ui-datepicker-year:first").replaceWith(t.yearshtml),i=t.yearshtml=null},0))},_shouldFocusInput:function(e){return e.input&&e.input.is(":visible")&&!e.input.is(":disabled")&&!e.input.is(":focus")},_checkOffset:function(t,i,s){var n=t.dpDiv.outerWidth(),a=t.dpDiv.outerHeight(),o=t.input?t.input.outerWidth():0,r=t.input?t.input.outerHeight():0,h=document.documentElement.clientWidth+(s?0:e(document).scrollLeft()),l=document.documentElement.clientHeight+(s?0:e(document).scrollTop());return i.left-=this._get(t,"isRTL")?n-o:0,i.left-=s&&i.left===t.input.offset().left?e(document).scrollLeft():0,i.top-=s&&i.top===t.input.offset().top+r?e(document).scrollTop():0,i.left-=Math.min(i.left,i.left+n>h&&h>n?Math.abs(i.left+n-h):0),i.top-=Math.min(i.top,i.top+a>l&&l>a?Math.abs(a+r):0),i},_findPos:function(t){for(var i,s=this._getInst(t),n=this._get(s,"isRTL");t&&("hidden"===t.type||1!==t.nodeType||e.expr.filters.hidden(t));)t=t[n?"previousSibling":"nextSibling"];return i=e(t).offset(),[i.left,i.top]},_hideDatepicker:function(t){var i,s,n,a,o=this._curInst;!o||t&&o!==e.data(t,"datepicker")||this._datepickerShowing&&(i=this._get(o,"showAnim"),s=this._get(o,"duration"),n=function(){e.datepicker._tidyDialog(o)},e.effects&&(e.effects.effect[i]||e.effects[i])?o.dpDiv.hide(i,e.datepicker._get(o,"showOptions"),s,n):o.dpDiv["slideDown"===i?"slideUp":"fadeIn"===i?"fadeOut":"hide"](i?s:null,n),i||n(),this._datepickerShowing=!1,a=this._get(o,"onClose"),a&&a.apply(o.input?o.input[0]:null,[o.input?o.input.val():"",o]),this._lastInput=null,this._inDialog&&(this._dialogInput.css({position:"absolute",left:"0",top:"-100px"}),e.blockUI&&(e.unblockUI(),e("body").append(this.dpDiv))),this._inDialog=!1)},_tidyDialog:function(e){e.dpDiv.removeClass(this._dialogClass).unbind(".ui-datepicker-calendar")},_checkExternalClick:function(t){if(e.datepicker._curInst){var i=e(t.target),s=e.datepicker._getInst(i[0]);(i[0].id!==e.datepicker._mainDivId&&0===i.parents("#"+e.datepicker._mainDivId).length&&!i.hasClass(e.datepicker.markerClassName)&&!i.closest("."+e.datepicker._triggerClass).length&&e.datepicker._datepickerShowing&&(!e.datepicker._inDialog||!e.blockUI)||i.hasClass(e.datepicker.markerClassName)&&e.datepicker._curInst!==s)&&e.datepicker._hideDatepicker()}},_adjustDate:function(t,i,s){var n=e(t),a=this._getInst(n[0]);this._isDisabledDatepicker(n[0])||(this._adjustInstDate(a,i+("M"===s?this._get(a,"showCurrentAtPos"):0),s),this._updateDatepicker(a))},_gotoToday:function(t){var i,s=e(t),n=this._getInst(s[0]);this._get(n,"gotoCurrent")&&n.currentDay?(n.selectedDay=n.currentDay,n.drawMonth=n.selectedMonth=n.currentMonth,n.drawYear=n.selectedYear=n.currentYear):(i=new Date,n.selectedDay=i.getDate(),n.drawMonth=n.selectedMonth=i.getMonth(),n.drawYear=n.selectedYear=i.getFullYear()),this._notifyChange(n),this._adjustDate(s)},_selectMonthYear:function(t,i,s){var n=e(t),a=this._getInst(n[0]);a["selected"+("M"===s?"Month":"Year")]=a["draw"+("M"===s?"Month":"Year")]=parseInt(i.options[i.selectedIndex].value,10),this._notifyChange(a),this._adjustDate(n)},_selectDay:function(t,i,s,n){var a,o=e(t);e(n).hasClass(this._unselectableClass)||this._isDisabledDatepicker(o[0])||(a=this._getInst(o[0]),a.selectedDay=a.currentDay=e("a",n).html(),a.selectedMonth=a.currentMonth=i,a.selectedYear=a.currentYear=s,this._selectDate(t,this._formatDate(a,a.currentDay,a.currentMonth,a.currentYear)))},_clearDate:function(t){var i=e(t);this._selectDate(i,"")},_selectDate:function(t,i){var s,n=e(t),a=this._getInst(n[0]);i=null!=i?i:this._formatDate(a),a.input&&a.input.val(i),this._updateAlternate(a),s=this._get(a,"onSelect"),s?s.apply(a.input?a.input[0]:null,[i,a]):a.input&&a.input.trigger("change"),a.inline?this._updateDatepicker(a):(this._hideDatepicker(),this._lastInput=a.input[0],"object"!=typeof a.input[0]&&a.input.focus(),this._lastInput=null)},_updateAlternate:function(t){var i,s,n,a=this._get(t,"altField");a&&(i=this._get(t,"altFormat")||this._get(t,"dateFormat"),s=this._getDate(t),n=this.formatDate(i,s,this._getFormatConfig(t)),e(a).each(function(){e(this).val(n)}))},noWeekends:function(e){var t=e.getDay();return[t>0&&6>t,""]},iso8601Week:function(e){var t,i=new Date(e.getTime());return i.setDate(i.getDate()+4-(i.getDay()||7)),t=i.getTime(),i.setMonth(0),i.setDate(1),Math.floor(Math.round((t-i)/864e5)/7)+1},parseDate:function(t,i,s){if(null==t||null==i)throw"Invalid arguments";if(i="object"==typeof i?""+i:i+"",""===i)return null;var n,a,o,r,h=0,l=(s?s.shortYearCutoff:null)||this._defaults.shortYearCutoff,u="string"!=typeof l?l:(new Date).getFullYear()%100+parseInt(l,10),d=(s?s.dayNamesShort:null)||this._defaults.dayNamesShort,c=(s?s.dayNames:null)||this._defaults.dayNames,p=(s?s.monthNamesShort:null)||this._defaults.monthNamesShort,f=(s?s.monthNames:null)||this._defaults.monthNames,m=-1,g=-1,v=-1,y=-1,b=!1,_=function(e){var i=t.length>n+1&&t.charAt(n+1)===e;return i&&n++,i},x=function(e){var t=_(e),s="@"===e?14:"!"===e?20:"y"===e&&t?4:"o"===e?3:2,n="y"===e?s:1,a=RegExp("^\\d{"+n+","+s+"}"),o=i.substring(h).match(a);if(!o)throw"Missing number at position "+h;return h+=o[0].length,parseInt(o[0],10)},w=function(t,s,n){var a=-1,o=e.map(_(t)?n:s,function(e,t){return[[t,e]]}).sort(function(e,t){return-(e[1].length-t[1].length)});if(e.each(o,function(e,t){var s=t[1];return i.substr(h,s.length).toLowerCase()===s.toLowerCase()?(a=t[0],h+=s.length,!1):void 0}),-1!==a)return a+1;throw"Unknown name at position "+h},k=function(){if(i.charAt(h)!==t.charAt(n))throw"Unexpected literal at position "+h;h++};for(n=0;t.length>n;n++)if(b)"'"!==t.charAt(n)||_("'")?k():b=!1;else switch(t.charAt(n)){case"d":v=x("d");break;case"D":w("D",d,c);break;case"o":y=x("o");break;case"m":g=x("m");break;case"M":g=w("M",p,f);break;case"y":m=x("y");break;case"@":r=new Date(x("@")),m=r.getFullYear(),g=r.getMonth()+1,v=r.getDate();break;case"!":r=new Date((x("!")-this._ticksTo1970)/1e4),m=r.getFullYear(),g=r.getMonth()+1,v=r.getDate();break;case"'":_("'")?k():b=!0;break;default:k()}if(i.length>h&&(o=i.substr(h),!/^\s+/.test(o)))throw"Extra/unparsed characters found in date: "+o;if(-1===m?m=(new Date).getFullYear():100>m&&(m+=(new Date).getFullYear()-(new Date).getFullYear()%100+(u>=m?0:-100)),y>-1)for(g=1,v=y;;){if(a=this._getDaysInMonth(m,g-1),a>=v)break;g++,v-=a}if(r=this._daylightSavingAdjust(new Date(m,g-1,v)),r.getFullYear()!==m||r.getMonth()+1!==g||r.getDate()!==v)throw"Invalid date";return r},ATOM:"yy-mm-dd",COOKIE:"D, dd M yy",ISO_8601:"yy-mm-dd",RFC_822:"D, d M y",RFC_850:"DD, dd-M-y",RFC_1036:"D, d M y",RFC_1123:"D, d M yy",RFC_2822:"D, d M yy",RSS:"D, d M y",TICKS:"!",TIMESTAMP:"@",W3C:"yy-mm-dd",_ticksTo1970:1e7*60*60*24*(718685+Math.floor(492.5)-Math.floor(19.7)+Math.floor(4.925)),formatDate:function(e,t,i){if(!t)return"";var s,n=(i?i.dayNamesShort:null)||this._defaults.dayNamesShort,a=(i?i.dayNames:null)||this._defaults.dayNames,o=(i?i.monthNamesShort:null)||this._defaults.monthNamesShort,r=(i?i.monthNames:null)||this._defaults.monthNames,h=function(t){var i=e.length>s+1&&e.charAt(s+1)===t;return i&&s++,i},l=function(e,t,i){var s=""+t;if(h(e))for(;i>s.length;)s="0"+s;return s},u=function(e,t,i,s){return h(e)?s[t]:i[t]},d="",c=!1;if(t)for(s=0;e.length>s;s++)if(c)"'"!==e.charAt(s)||h("'")?d+=e.charAt(s):c=!1;else switch(e.charAt(s)){case"d":d+=l("d",t.getDate(),2);break;case"D":d+=u("D",t.getDay(),n,a);break;case"o":d+=l("o",Math.round((new Date(t.getFullYear(),t.getMonth(),t.getDate()).getTime()-new Date(t.getFullYear(),0,0).getTime())/864e5),3);break;case"m":d+=l("m",t.getMonth()+1,2);break;case"M":d+=u("M",t.getMonth(),o,r);break;case"y":d+=h("y")?t.getFullYear():(10>t.getYear()%100?"0":"")+t.getYear()%100;break;case"@":d+=t.getTime();break;case"!":d+=1e4*t.getTime()+this._ticksTo1970;break;case"'":h("'")?d+="'":c=!0;break;default:d+=e.charAt(s)}return d},_possibleChars:function(e){var t,i="",s=!1,n=function(i){var s=e.length>t+1&&e.charAt(t+1)===i;return s&&t++,s};for(t=0;e.length>t;t++)if(s)"'"!==e.charAt(t)||n("'")?i+=e.charAt(t):s=!1;else switch(e.charAt(t)){case"d":case"m":case"y":case"@":i+="0123456789";break;case"D":case"M":return null;case"'":n("'")?i+="'":s=!0;break;default:i+=e.charAt(t)}return i},_get:function(e,t){return void 0!==e.settings[t]?e.settings[t]:this._defaults[t]},_setDateFromField:function(e,t){if(e.input.val()!==e.lastVal){var i=this._get(e,"dateFormat"),s=e.lastVal=e.input?e.input.val():null,n=this._getDefaultDate(e),a=n,o=this._getFormatConfig(e);try{a=this.parseDate(i,s,o)||n}catch(r){s=t?"":s}e.selectedDay=a.getDate(),e.drawMonth=e.selectedMonth=a.getMonth(),e.drawYear=e.selectedYear=a.getFullYear(),e.currentDay=s?a.getDate():0,e.currentMonth=s?a.getMonth():0,e.currentYear=s?a.getFullYear():0,this._adjustInstDate(e)}},_getDefaultDate:function(e){return this._restrictMinMax(e,this._determineDate(e,this._get(e,"defaultDate"),new Date))},_determineDate:function(t,i,s){var n=function(e){var t=new Date;return t.setDate(t.getDate()+e),t},a=function(i){try{return e.datepicker.parseDate(e.datepicker._get(t,"dateFormat"),i,e.datepicker._getFormatConfig(t))}catch(s){}for(var n=(i.toLowerCase().match(/^c/)?e.datepicker._getDate(t):null)||new Date,a=n.getFullYear(),o=n.getMonth(),r=n.getDate(),h=/([+\-]?[0-9]+)\s*(d|D|w|W|m|M|y|Y)?/g,l=h.exec(i);l;){switch(l[2]||"d"){case"d":case"D":r+=parseInt(l[1],10);break;case"w":case"W":r+=7*parseInt(l[1],10);break;case"m":case"M":o+=parseInt(l[1],10),r=Math.min(r,e.datepicker._getDaysInMonth(a,o));break;case"y":case"Y":a+=parseInt(l[1],10),r=Math.min(r,e.datepicker._getDaysInMonth(a,o))}l=h.exec(i)}return new Date(a,o,r)},o=null==i||""===i?s:"string"==typeof i?a(i):"number"==typeof i?isNaN(i)?s:n(i):new Date(i.getTime());return o=o&&"Invalid Date"==""+o?s:o,o&&(o.setHours(0),o.setMinutes(0),o.setSeconds(0),o.setMilliseconds(0)),this._daylightSavingAdjust(o)},_daylightSavingAdjust:function(e){return e?(e.setHours(e.getHours()>12?e.getHours()+2:0),e):null},_setDate:function(e,t,i){var s=!t,n=e.selectedMonth,a=e.selectedYear,o=this._restrictMinMax(e,this._determineDate(e,t,new Date));e.selectedDay=e.currentDay=o.getDate(),e.drawMonth=e.selectedMonth=e.currentMonth=o.getMonth(),e.drawYear=e.selectedYear=e.currentYear=o.getFullYear(),n===e.selectedMonth&&a===e.selectedYear||i||this._notifyChange(e),this._adjustInstDate(e),e.input&&e.input.val(s?"":this._formatDate(e))},_getDate:function(e){var t=!e.currentYear||e.input&&""===e.input.val()?null:this._daylightSavingAdjust(new Date(e.currentYear,e.currentMonth,e.currentDay));return t},_attachHandlers:function(t){var i=this._get(t,"stepMonths"),s="#"+t.id.replace(/\\\\/g,"\\");t.dpDiv.find("[data-handler]").map(function(){var t={prev:function(){e.datepicker._adjustDate(s,-i,"M")},next:function(){e.datepicker._adjustDate(s,+i,"M")},hide:function(){e.datepicker._hideDatepicker()},today:function(){e.datepicker._gotoToday(s)},selectDay:function(){return e.datepicker._selectDay(s,+this.getAttribute("data-month"),+this.getAttribute("data-year"),this),!1},selectMonth:function(){return e.datepicker._selectMonthYear(s,this,"M"),!1},selectYear:function(){return e.datepicker._selectMonthYear(s,this,"Y"),!1}};e(this).bind(this.getAttribute("data-event"),t[this.getAttribute("data-handler")])})},_generateHTML:function(e){var t,i,s,n,a,o,r,h,l,u,d,c,p,f,m,g,v,y,b,_,x,w,k,T,D,S,M,C,N,A,P,I,z,H,F,E,O,j,W,L=new Date,R=this._daylightSavingAdjust(new Date(L.getFullYear(),L.getMonth(),L.getDate())),Y=this._get(e,"isRTL"),B=this._get(e,"showButtonPanel"),J=this._get(e,"hideIfNoPrevNext"),q=this._get(e,"navigationAsDateFormat"),K=this._getNumberOfMonths(e),V=this._get(e,"showCurrentAtPos"),U=this._get(e,"stepMonths"),Q=1!==K[0]||1!==K[1],G=this._daylightSavingAdjust(e.currentDay?new Date(e.currentYear,e.currentMonth,e.currentDay):new Date(9999,9,9)),X=this._getMinMaxDate(e,"min"),$=this._getMinMaxDate(e,"max"),Z=e.drawMonth-V,et=e.drawYear;if(0>Z&&(Z+=12,et--),$)for(t=this._daylightSavingAdjust(new Date($.getFullYear(),$.getMonth()-K[0]*K[1]+1,$.getDate())),t=X&&X>t?X:t;this._daylightSavingAdjust(new Date(et,Z,1))>t;)Z--,0>Z&&(Z=11,et--);for(e.drawMonth=Z,e.drawYear=et,i=this._get(e,"prevText"),i=q?this.formatDate(i,this._daylightSavingAdjust(new Date(et,Z-U,1)),this._getFormatConfig(e)):i,s=this._canAdjustMonth(e,-1,et,Z)?"<a class='ui-datepicker-prev ui-corner-all' data-handler='prev' data-event='click' title='"+i+"'><span class='ui-icon ui-icon-circle-triangle-"+(Y?"e":"w")+"'>"+i+"</span></a>":J?"":"<a class='ui-datepicker-prev ui-corner-all ui-state-disabled' title='"+i+"'><span class='ui-icon ui-icon-circle-triangle-"+(Y?"e":"w")+"'>"+i+"</span></a>",n=this._get(e,"nextText"),n=q?this.formatDate(n,this._daylightSavingAdjust(new Date(et,Z+U,1)),this._getFormatConfig(e)):n,a=this._canAdjustMonth(e,1,et,Z)?"<a class='ui-datepicker-next ui-corner-all' data-handler='next' data-event='click' title='"+n+"'><span class='ui-icon ui-icon-circle-triangle-"+(Y?"w":"e")+"'>"+n+"</span></a>":J?"":"<a class='ui-datepicker-next ui-corner-all ui-state-disabled' title='"+n+"'><span class='ui-icon ui-icon-circle-triangle-"+(Y?"w":"e")+"'>"+n+"</span></a>",o=this._get(e,"currentText"),r=this._get(e,"gotoCurrent")&&e.currentDay?G:R,o=q?this.formatDate(o,r,this._getFormatConfig(e)):o,h=e.inline?"":"<button type='button' class='ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all' data-handler='hide' data-event='click'>"+this._get(e,"closeText")+"</button>",l=B?"<div class='ui-datepicker-buttonpane ui-widget-content'>"+(Y?h:"")+(this._isInRange(e,r)?"<button type='button' class='ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all' data-handler='today' data-event='click'>"+o+"</button>":"")+(Y?"":h)+"</div>":"",u=parseInt(this._get(e,"firstDay"),10),u=isNaN(u)?0:u,d=this._get(e,"showWeek"),c=this._get(e,"dayNames"),p=this._get(e,"dayNamesMin"),f=this._get(e,"monthNames"),m=this._get(e,"monthNamesShort"),g=this._get(e,"beforeShowDay"),v=this._get(e,"showOtherMonths"),y=this._get(e,"selectOtherMonths"),b=this._getDefaultDate(e),_="",w=0;K[0]>w;w++){for(k="",this.maxRows=4,T=0;K[1]>T;T++){if(D=this._daylightSavingAdjust(new Date(et,Z,e.selectedDay)),S=" ui-corner-all",M="",Q){if(M+="<div class='ui-datepicker-group",K[1]>1)switch(T){case 0:M+=" ui-datepicker-group-first",S=" ui-corner-"+(Y?"right":"left");break;case K[1]-1:M+=" ui-datepicker-group-last",S=" ui-corner-"+(Y?"left":"right");break;default:M+=" ui-datepicker-group-middle",S=""}M+="'>"}for(M+="<div class='ui-datepicker-header ui-widget-header ui-helper-clearfix"+S+"'>"+(/all|left/.test(S)&&0===w?Y?a:s:"")+(/all|right/.test(S)&&0===w?Y?s:a:"")+this._generateMonthYearHeader(e,Z,et,X,$,w>0||T>0,f,m)+"</div><table class='ui-datepicker-calendar'><thead>"+"<tr>",C=d?"<th class='ui-datepicker-week-col'>"+this._get(e,"weekHeader")+"</th>":"",x=0;7>x;x++)N=(x+u)%7,C+="<th scope='col'"+((x+u+6)%7>=5?" class='ui-datepicker-week-end'":"")+">"+"<span title='"+c[N]+"'>"+p[N]+"</span></th>";for(M+=C+"</tr></thead><tbody>",A=this._getDaysInMonth(et,Z),et===e.selectedYear&&Z===e.selectedMonth&&(e.selectedDay=Math.min(e.selectedDay,A)),P=(this._getFirstDayOfMonth(et,Z)-u+7)%7,I=Math.ceil((P+A)/7),z=Q?this.maxRows>I?this.maxRows:I:I,this.maxRows=z,H=this._daylightSavingAdjust(new Date(et,Z,1-P)),F=0;z>F;F++){for(M+="<tr>",E=d?"<td class='ui-datepicker-week-col'>"+this._get(e,"calculateWeek")(H)+"</td>":"",x=0;7>x;x++)O=g?g.apply(e.input?e.input[0]:null,[H]):[!0,""],j=H.getMonth()!==Z,W=j&&!y||!O[0]||X&&X>H||$&&H>$,E+="<td class='"+((x+u+6)%7>=5?" ui-datepicker-week-end":"")+(j?" ui-datepicker-other-month":"")+(H.getTime()===D.getTime()&&Z===e.selectedMonth&&e._keyEvent||b.getTime()===H.getTime()&&b.getTime()===D.getTime()?" "+this._dayOverClass:"")+(W?" "+this._unselectableClass+" ui-state-disabled":"")+(j&&!v?"":" "+O[1]+(H.getTime()===G.getTime()?" "+this._currentClass:"")+(H.getTime()===R.getTime()?" ui-datepicker-today":""))+"'"+(j&&!v||!O[2]?"":" title='"+O[2].replace(/'/g,"&#39;")+"'")+(W?"":" data-handler='selectDay' data-event='click' data-month='"+H.getMonth()+"' data-year='"+H.getFullYear()+"'")+">"+(j&&!v?"&#xa0;":W?"<span class='ui-state-default'>"+H.getDate()+"</span>":"<a class='ui-state-default"+(H.getTime()===R.getTime()?" ui-state-highlight":"")+(H.getTime()===G.getTime()?" ui-state-active":"")+(j?" ui-priority-secondary":"")+"' href='#'>"+H.getDate()+"</a>")+"</td>",H.setDate(H.getDate()+1),H=this._daylightSavingAdjust(H);M+=E+"</tr>"}Z++,Z>11&&(Z=0,et++),M+="</tbody></table>"+(Q?"</div>"+(K[0]>0&&T===K[1]-1?"<div class='ui-datepicker-row-break'></div>":""):""),k+=M}_+=k}return _+=l,e._keyEvent=!1,_},_generateMonthYearHeader:function(e,t,i,s,n,a,o,r){var h,l,u,d,c,p,f,m,g=this._get(e,"changeMonth"),v=this._get(e,"changeYear"),y=this._get(e,"showMonthAfterYear"),b="<div class='ui-datepicker-title'>",_="";if(a||!g)_+="<span class='ui-datepicker-month'>"+o[t]+"</span>";else{for(h=s&&s.getFullYear()===i,l=n&&n.getFullYear()===i,_+="<select class='ui-datepicker-month' data-handler='selectMonth' data-event='change'>",u=0;12>u;u++)(!h||u>=s.getMonth())&&(!l||n.getMonth()>=u)&&(_+="<option value='"+u+"'"+(u===t?" selected='selected'":"")+">"+r[u]+"</option>");_+="</select>"}if(y||(b+=_+(!a&&g&&v?"":"&#xa0;")),!e.yearshtml)if(e.yearshtml="",a||!v)b+="<span class='ui-datepicker-year'>"+i+"</span>";else{for(d=this._get(e,"yearRange").split(":"),c=(new Date).getFullYear(),p=function(e){var t=e.match(/c[+\-].*/)?i+parseInt(e.substring(1),10):e.match(/[+\-].*/)?c+parseInt(e,10):parseInt(e,10);return isNaN(t)?c:t},f=p(d[0]),m=Math.max(f,p(d[1]||"")),f=s?Math.max(f,s.getFullYear()):f,m=n?Math.min(m,n.getFullYear()):m,e.yearshtml+="<select class='ui-datepicker-year' data-handler='selectYear' data-event='change'>";m>=f;f++)e.yearshtml+="<option value='"+f+"'"+(f===i?" selected='selected'":"")+">"+f+"</option>";e.yearshtml+="</select>",b+=e.yearshtml,e.yearshtml=null}return b+=this._get(e,"yearSuffix"),y&&(b+=(!a&&g&&v?"":"&#xa0;")+_),b+="</div>"},_adjustInstDate:function(e,t,i){var s=e.drawYear+("Y"===i?t:0),n=e.drawMonth+("M"===i?t:0),a=Math.min(e.selectedDay,this._getDaysInMonth(s,n))+("D"===i?t:0),o=this._restrictMinMax(e,this._daylightSavingAdjust(new Date(s,n,a)));e.selectedDay=o.getDate(),e.drawMonth=e.selectedMonth=o.getMonth(),e.drawYear=e.selectedYear=o.getFullYear(),("M"===i||"Y"===i)&&this._notifyChange(e)},_restrictMinMax:function(e,t){var i=this._getMinMaxDate(e,"min"),s=this._getMinMaxDate(e,"max"),n=i&&i>t?i:t;return s&&n>s?s:n},_notifyChange:function(e){var t=this._get(e,"onChangeMonthYear");t&&t.apply(e.input?e.input[0]:null,[e.selectedYear,e.selectedMonth+1,e])},_getNumberOfMonths:function(e){var t=this._get(e,"numberOfMonths");return null==t?[1,1]:"number"==typeof t?[1,t]:t},_getMinMaxDate:function(e,t){return this._determineDate(e,this._get(e,t+"Date"),null)},_getDaysInMonth:function(e,t){return 32-this._daylightSavingAdjust(new Date(e,t,32)).getDate()},_getFirstDayOfMonth:function(e,t){return new Date(e,t,1).getDay()},_canAdjustMonth:function(e,t,i,s){var n=this._getNumberOfMonths(e),a=this._daylightSavingAdjust(new Date(i,s+(0>t?t:n[0]*n[1]),1));return 0>t&&a.setDate(this._getDaysInMonth(a.getFullYear(),a.getMonth())),this._isInRange(e,a)},_isInRange:function(e,t){var i,s,n=this._getMinMaxDate(e,"min"),a=this._getMinMaxDate(e,"max"),o=null,r=null,h=this._get(e,"yearRange");return h&&(i=h.split(":"),s=(new Date).getFullYear(),o=parseInt(i[0],10),r=parseInt(i[1],10),i[0].match(/[+\-].*/)&&(o+=s),i[1].match(/[+\-].*/)&&(r+=s)),(!n||t.getTime()>=n.getTime())&&(!a||t.getTime()<=a.getTime())&&(!o||t.getFullYear()>=o)&&(!r||r>=t.getFullYear())},_getFormatConfig:function(e){var t=this._get(e,"shortYearCutoff");return t="string"!=typeof t?t:(new Date).getFullYear()%100+parseInt(t,10),{shortYearCutoff:t,dayNamesShort:this._get(e,"dayNamesShort"),dayNames:this._get(e,"dayNames"),monthNamesShort:this._get(e,"monthNamesShort"),monthNames:this._get(e,"monthNames")}},_formatDate:function(e,t,i,s){t||(e.currentDay=e.selectedDay,e.currentMonth=e.selectedMonth,e.currentYear=e.selectedYear);var n=t?"object"==typeof t?t:this._daylightSavingAdjust(new Date(s,i,t)):this._daylightSavingAdjust(new Date(e.currentYear,e.currentMonth,e.currentDay));return this.formatDate(this._get(e,"dateFormat"),n,this._getFormatConfig(e))}}),e.fn.datepicker=function(t){if(!this.length)return this;e.datepicker.initialized||(e(document).mousedown(e.datepicker._checkExternalClick),e.datepicker.initialized=!0),0===e("#"+e.datepicker._mainDivId).length&&e("body").append(e.datepicker.dpDiv);var i=Array.prototype.slice.call(arguments,1);return"string"!=typeof t||"isDisabled"!==t&&"getDate"!==t&&"widget"!==t?"option"===t&&2===arguments.length&&"string"==typeof arguments[1]?e.datepicker["_"+t+"Datepicker"].apply(e.datepicker,[this[0]].concat(i)):this.each(function(){"string"==typeof t?e.datepicker["_"+t+"Datepicker"].apply(e.datepicker,[this].concat(i)):e.datepicker._attachDatepicker(this,t)}):e.datepicker["_"+t+"Datepicker"].apply(e.datepicker,[this[0]].concat(i))},e.datepicker=new n,e.datepicker.initialized=!1,e.datepicker.uuid=(new Date).getTime(),e.datepicker.version="1.11.2",e.datepicker,e.widget("ui.draggable",e.ui.mouse,{version:"1.11.2",widgetEventPrefix:"drag",options:{addClasses:!0,appendTo:"parent",axis:!1,connectToSortable:!1,containment:!1,cursor:"auto",cursorAt:!1,grid:!1,handle:!1,helper:"original",iframeFix:!1,opacity:!1,refreshPositions:!1,revert:!1,revertDuration:500,scope:"default",scroll:!0,scrollSensitivity:20,scrollSpeed:20,snap:!1,snapMode:"both",snapTolerance:20,stack:!1,zIndex:!1,drag:null,start:null,stop:null},_create:function(){"original"===this.options.helper&&this._setPositionRelative(),this.options.addClasses&&this.element.addClass("ui-draggable"),this.options.disabled&&this.element.addClass("ui-draggable-disabled"),this._setHandleClassName(),this._mouseInit()},_setOption:function(e,t){this._super(e,t),"handle"===e&&(this._removeHandleClassName(),this._setHandleClassName())},_destroy:function(){return(this.helper||this.element).is(".ui-draggable-dragging")?(this.destroyOnClear=!0,void 0):(this.element.removeClass("ui-draggable ui-draggable-dragging ui-draggable-disabled"),this._removeHandleClassName(),this._mouseDestroy(),void 0)},_mouseCapture:function(t){var i=this.options;return this._blurActiveElement(t),this.helper||i.disabled||e(t.target).closest(".ui-resizable-handle").length>0?!1:(this.handle=this._getHandle(t),this.handle?(this._blockFrames(i.iframeFix===!0?"iframe":i.iframeFix),!0):!1)},_blockFrames:function(t){this.iframeBlocks=this.document.find(t).map(function(){var t=e(this);return e("<div>").css("position","absolute").appendTo(t.parent()).outerWidth(t.outerWidth()).outerHeight(t.outerHeight()).offset(t.offset())[0]})},_unblockFrames:function(){this.iframeBlocks&&(this.iframeBlocks.remove(),delete this.iframeBlocks)},_blurActiveElement:function(t){var i=this.document[0];if(this.handleElement.is(t.target))try{i.activeElement&&"body"!==i.activeElement.nodeName.toLowerCase()&&e(i.activeElement).blur()}catch(s){}},_mouseStart:function(t){var i=this.options;return this.helper=this._createHelper(t),this.helper.addClass("ui-draggable-dragging"),this._cacheHelperProportions(),e.ui.ddmanager&&(e.ui.ddmanager.current=this),this._cacheMargins(),this.cssPosition=this.helper.css("position"),this.scrollParent=this.helper.scrollParent(!0),this.offsetParent=this.helper.offsetParent(),this.hasFixedAncestor=this.helper.parents().filter(function(){return"fixed"===e(this).css("position")}).length>0,this.positionAbs=this.element.offset(),this._refreshOffsets(t),this.originalPosition=this.position=this._generatePosition(t,!1),this.originalPageX=t.pageX,this.originalPageY=t.pageY,i.cursorAt&&this._adjustOffsetFromHelper(i.cursorAt),this._setContainment(),this._trigger("start",t)===!1?(this._clear(),!1):(this._cacheHelperProportions(),e.ui.ddmanager&&!i.dropBehaviour&&e.ui.ddmanager.prepareOffsets(this,t),this._normalizeRightBottom(),this._mouseDrag(t,!0),e.ui.ddmanager&&e.ui.ddmanager.dragStart(this,t),!0)},_refreshOffsets:function(e){this.offset={top:this.positionAbs.top-this.margins.top,left:this.positionAbs.left-this.margins.left,scroll:!1,parent:this._getParentOffset(),relative:this._getRelativeOffset()},this.offset.click={left:e.pageX-this.offset.left,top:e.pageY-this.offset.top}},_mouseDrag:function(t,i){if(this.hasFixedAncestor&&(this.offset.parent=this._getParentOffset()),this.position=this._generatePosition(t,!0),this.positionAbs=this._convertPositionTo("absolute"),!i){var s=this._uiHash();if(this._trigger("drag",t,s)===!1)return this._mouseUp({}),!1;this.position=s.position}return this.helper[0].style.left=this.position.left+"px",this.helper[0].style.top=this.position.top+"px",e.ui.ddmanager&&e.ui.ddmanager.drag(this,t),!1},_mouseStop:function(t){var i=this,s=!1;return e.ui.ddmanager&&!this.options.dropBehaviour&&(s=e.ui.ddmanager.drop(this,t)),this.dropped&&(s=this.dropped,this.dropped=!1),"invalid"===this.options.revert&&!s||"valid"===this.options.revert&&s||this.options.revert===!0||e.isFunction(this.options.revert)&&this.options.revert.call(this.element,s)?e(this.helper).animate(this.originalPosition,parseInt(this.options.revertDuration,10),function(){i._trigger("stop",t)!==!1&&i._clear()}):this._trigger("stop",t)!==!1&&this._clear(),!1},_mouseUp:function(t){return this._unblockFrames(),e.ui.ddmanager&&e.ui.ddmanager.dragStop(this,t),this.handleElement.is(t.target)&&this.element.focus(),e.ui.mouse.prototype._mouseUp.call(this,t)},cancel:function(){return this.helper.is(".ui-draggable-dragging")?this._mouseUp({}):this._clear(),this},_getHandle:function(t){return this.options.handle?!!e(t.target).closest(this.element.find(this.options.handle)).length:!0},_setHandleClassName:function(){this.handleElement=this.options.handle?this.element.find(this.options.handle):this.element,this.handleElement.addClass("ui-draggable-handle")},_removeHandleClassName:function(){this.handleElement.removeClass("ui-draggable-handle")},_createHelper:function(t){var i=this.options,s=e.isFunction(i.helper),n=s?e(i.helper.apply(this.element[0],[t])):"clone"===i.helper?this.element.clone().removeAttr("id"):this.element;return n.parents("body").length||n.appendTo("parent"===i.appendTo?this.element[0].parentNode:i.appendTo),s&&n[0]===this.element[0]&&this._setPositionRelative(),n[0]===this.element[0]||/(fixed|absolute)/.test(n.css("position"))||n.css("position","absolute"),n},_setPositionRelative:function(){/^(?:r|a|f)/.test(this.element.css("position"))||(this.element[0].style.position="relative")},_adjustOffsetFromHelper:function(t){"string"==typeof t&&(t=t.split(" ")),e.isArray(t)&&(t={left:+t[0],top:+t[1]||0}),"left"in t&&(this.offset.click.left=t.left+this.margins.left),"right"in t&&(this.offset.click.left=this.helperProportions.width-t.right+this.margins.left),"top"in t&&(this.offset.click.top=t.top+this.margins.top),"bottom"in t&&(this.offset.click.top=this.helperProportions.height-t.bottom+this.margins.top)},_isRootNode:function(e){return/(html|body)/i.test(e.tagName)||e===this.document[0]},_getParentOffset:function(){var t=this.offsetParent.offset(),i=this.document[0];return"absolute"===this.cssPosition&&this.scrollParent[0]!==i&&e.contains(this.scrollParent[0],this.offsetParent[0])&&(t.left+=this.scrollParent.scrollLeft(),t.top+=this.scrollParent.scrollTop()),this._isRootNode(this.offsetParent[0])&&(t={top:0,left:0}),{top:t.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:t.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)}},_getRelativeOffset:function(){if("relative"!==this.cssPosition)return{top:0,left:0};var e=this.element.position(),t=this._isRootNode(this.scrollParent[0]);return{top:e.top-(parseInt(this.helper.css("top"),10)||0)+(t?0:this.scrollParent.scrollTop()),left:e.left-(parseInt(this.helper.css("left"),10)||0)+(t?0:this.scrollParent.scrollLeft())}},_cacheMargins:function(){this.margins={left:parseInt(this.element.css("marginLeft"),10)||0,top:parseInt(this.element.css("marginTop"),10)||0,right:parseInt(this.element.css("marginRight"),10)||0,bottom:parseInt(this.element.css("marginBottom"),10)||0}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var t,i,s,n=this.options,a=this.document[0];return this.relativeContainer=null,n.containment?"window"===n.containment?(this.containment=[e(window).scrollLeft()-this.offset.relative.left-this.offset.parent.left,e(window).scrollTop()-this.offset.relative.top-this.offset.parent.top,e(window).scrollLeft()+e(window).width()-this.helperProportions.width-this.margins.left,e(window).scrollTop()+(e(window).height()||a.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top],void 0):"document"===n.containment?(this.containment=[0,0,e(a).width()-this.helperProportions.width-this.margins.left,(e(a).height()||a.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top],void 0):n.containment.constructor===Array?(this.containment=n.containment,void 0):("parent"===n.containment&&(n.containment=this.helper[0].parentNode),i=e(n.containment),s=i[0],s&&(t=/(scroll|auto)/.test(i.css("overflow")),this.containment=[(parseInt(i.css("borderLeftWidth"),10)||0)+(parseInt(i.css("paddingLeft"),10)||0),(parseInt(i.css("borderTopWidth"),10)||0)+(parseInt(i.css("paddingTop"),10)||0),(t?Math.max(s.scrollWidth,s.offsetWidth):s.offsetWidth)-(parseInt(i.css("borderRightWidth"),10)||0)-(parseInt(i.css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left-this.margins.right,(t?Math.max(s.scrollHeight,s.offsetHeight):s.offsetHeight)-(parseInt(i.css("borderBottomWidth"),10)||0)-(parseInt(i.css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top-this.margins.bottom],this.relativeContainer=i),void 0):(this.containment=null,void 0)
},_convertPositionTo:function(e,t){t||(t=this.position);var i="absolute"===e?1:-1,s=this._isRootNode(this.scrollParent[0]);return{top:t.top+this.offset.relative.top*i+this.offset.parent.top*i-("fixed"===this.cssPosition?-this.offset.scroll.top:s?0:this.offset.scroll.top)*i,left:t.left+this.offset.relative.left*i+this.offset.parent.left*i-("fixed"===this.cssPosition?-this.offset.scroll.left:s?0:this.offset.scroll.left)*i}},_generatePosition:function(e,t){var i,s,n,a,o=this.options,r=this._isRootNode(this.scrollParent[0]),h=e.pageX,l=e.pageY;return r&&this.offset.scroll||(this.offset.scroll={top:this.scrollParent.scrollTop(),left:this.scrollParent.scrollLeft()}),t&&(this.containment&&(this.relativeContainer?(s=this.relativeContainer.offset(),i=[this.containment[0]+s.left,this.containment[1]+s.top,this.containment[2]+s.left,this.containment[3]+s.top]):i=this.containment,e.pageX-this.offset.click.left<i[0]&&(h=i[0]+this.offset.click.left),e.pageY-this.offset.click.top<i[1]&&(l=i[1]+this.offset.click.top),e.pageX-this.offset.click.left>i[2]&&(h=i[2]+this.offset.click.left),e.pageY-this.offset.click.top>i[3]&&(l=i[3]+this.offset.click.top)),o.grid&&(n=o.grid[1]?this.originalPageY+Math.round((l-this.originalPageY)/o.grid[1])*o.grid[1]:this.originalPageY,l=i?n-this.offset.click.top>=i[1]||n-this.offset.click.top>i[3]?n:n-this.offset.click.top>=i[1]?n-o.grid[1]:n+o.grid[1]:n,a=o.grid[0]?this.originalPageX+Math.round((h-this.originalPageX)/o.grid[0])*o.grid[0]:this.originalPageX,h=i?a-this.offset.click.left>=i[0]||a-this.offset.click.left>i[2]?a:a-this.offset.click.left>=i[0]?a-o.grid[0]:a+o.grid[0]:a),"y"===o.axis&&(h=this.originalPageX),"x"===o.axis&&(l=this.originalPageY)),{top:l-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+("fixed"===this.cssPosition?-this.offset.scroll.top:r?0:this.offset.scroll.top),left:h-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+("fixed"===this.cssPosition?-this.offset.scroll.left:r?0:this.offset.scroll.left)}},_clear:function(){this.helper.removeClass("ui-draggable-dragging"),this.helper[0]===this.element[0]||this.cancelHelperRemoval||this.helper.remove(),this.helper=null,this.cancelHelperRemoval=!1,this.destroyOnClear&&this.destroy()},_normalizeRightBottom:function(){"y"!==this.options.axis&&"auto"!==this.helper.css("right")&&(this.helper.width(this.helper.width()),this.helper.css("right","auto")),"x"!==this.options.axis&&"auto"!==this.helper.css("bottom")&&(this.helper.height(this.helper.height()),this.helper.css("bottom","auto"))},_trigger:function(t,i,s){return s=s||this._uiHash(),e.ui.plugin.call(this,t,[i,s,this],!0),/^(drag|start|stop)/.test(t)&&(this.positionAbs=this._convertPositionTo("absolute"),s.offset=this.positionAbs),e.Widget.prototype._trigger.call(this,t,i,s)},plugins:{},_uiHash:function(){return{helper:this.helper,position:this.position,originalPosition:this.originalPosition,offset:this.positionAbs}}}),e.ui.plugin.add("draggable","connectToSortable",{start:function(t,i,s){var n=e.extend({},i,{item:s.element});s.sortables=[],e(s.options.connectToSortable).each(function(){var i=e(this).sortable("instance");i&&!i.options.disabled&&(s.sortables.push(i),i.refreshPositions(),i._trigger("activate",t,n))})},stop:function(t,i,s){var n=e.extend({},i,{item:s.element});s.cancelHelperRemoval=!1,e.each(s.sortables,function(){var e=this;e.isOver?(e.isOver=0,s.cancelHelperRemoval=!0,e.cancelHelperRemoval=!1,e._storedCSS={position:e.placeholder.css("position"),top:e.placeholder.css("top"),left:e.placeholder.css("left")},e._mouseStop(t),e.options.helper=e.options._helper):(e.cancelHelperRemoval=!0,e._trigger("deactivate",t,n))})},drag:function(t,i,s){e.each(s.sortables,function(){var n=!1,a=this;a.positionAbs=s.positionAbs,a.helperProportions=s.helperProportions,a.offset.click=s.offset.click,a._intersectsWith(a.containerCache)&&(n=!0,e.each(s.sortables,function(){return this.positionAbs=s.positionAbs,this.helperProportions=s.helperProportions,this.offset.click=s.offset.click,this!==a&&this._intersectsWith(this.containerCache)&&e.contains(a.element[0],this.element[0])&&(n=!1),n})),n?(a.isOver||(a.isOver=1,a.currentItem=i.helper.appendTo(a.element).data("ui-sortable-item",!0),a.options._helper=a.options.helper,a.options.helper=function(){return i.helper[0]},t.target=a.currentItem[0],a._mouseCapture(t,!0),a._mouseStart(t,!0,!0),a.offset.click.top=s.offset.click.top,a.offset.click.left=s.offset.click.left,a.offset.parent.left-=s.offset.parent.left-a.offset.parent.left,a.offset.parent.top-=s.offset.parent.top-a.offset.parent.top,s._trigger("toSortable",t),s.dropped=a.element,e.each(s.sortables,function(){this.refreshPositions()}),s.currentItem=s.element,a.fromOutside=s),a.currentItem&&(a._mouseDrag(t),i.position=a.position)):a.isOver&&(a.isOver=0,a.cancelHelperRemoval=!0,a.options._revert=a.options.revert,a.options.revert=!1,a._trigger("out",t,a._uiHash(a)),a._mouseStop(t,!0),a.options.revert=a.options._revert,a.options.helper=a.options._helper,a.placeholder&&a.placeholder.remove(),s._refreshOffsets(t),i.position=s._generatePosition(t,!0),s._trigger("fromSortable",t),s.dropped=!1,e.each(s.sortables,function(){this.refreshPositions()}))})}}),e.ui.plugin.add("draggable","cursor",{start:function(t,i,s){var n=e("body"),a=s.options;n.css("cursor")&&(a._cursor=n.css("cursor")),n.css("cursor",a.cursor)},stop:function(t,i,s){var n=s.options;n._cursor&&e("body").css("cursor",n._cursor)}}),e.ui.plugin.add("draggable","opacity",{start:function(t,i,s){var n=e(i.helper),a=s.options;n.css("opacity")&&(a._opacity=n.css("opacity")),n.css("opacity",a.opacity)},stop:function(t,i,s){var n=s.options;n._opacity&&e(i.helper).css("opacity",n._opacity)}}),e.ui.plugin.add("draggable","scroll",{start:function(e,t,i){i.scrollParentNotHidden||(i.scrollParentNotHidden=i.helper.scrollParent(!1)),i.scrollParentNotHidden[0]!==i.document[0]&&"HTML"!==i.scrollParentNotHidden[0].tagName&&(i.overflowOffset=i.scrollParentNotHidden.offset())},drag:function(t,i,s){var n=s.options,a=!1,o=s.scrollParentNotHidden[0],r=s.document[0];o!==r&&"HTML"!==o.tagName?(n.axis&&"x"===n.axis||(s.overflowOffset.top+o.offsetHeight-t.pageY<n.scrollSensitivity?o.scrollTop=a=o.scrollTop+n.scrollSpeed:t.pageY-s.overflowOffset.top<n.scrollSensitivity&&(o.scrollTop=a=o.scrollTop-n.scrollSpeed)),n.axis&&"y"===n.axis||(s.overflowOffset.left+o.offsetWidth-t.pageX<n.scrollSensitivity?o.scrollLeft=a=o.scrollLeft+n.scrollSpeed:t.pageX-s.overflowOffset.left<n.scrollSensitivity&&(o.scrollLeft=a=o.scrollLeft-n.scrollSpeed))):(n.axis&&"x"===n.axis||(t.pageY-e(r).scrollTop()<n.scrollSensitivity?a=e(r).scrollTop(e(r).scrollTop()-n.scrollSpeed):e(window).height()-(t.pageY-e(r).scrollTop())<n.scrollSensitivity&&(a=e(r).scrollTop(e(r).scrollTop()+n.scrollSpeed))),n.axis&&"y"===n.axis||(t.pageX-e(r).scrollLeft()<n.scrollSensitivity?a=e(r).scrollLeft(e(r).scrollLeft()-n.scrollSpeed):e(window).width()-(t.pageX-e(r).scrollLeft())<n.scrollSensitivity&&(a=e(r).scrollLeft(e(r).scrollLeft()+n.scrollSpeed)))),a!==!1&&e.ui.ddmanager&&!n.dropBehaviour&&e.ui.ddmanager.prepareOffsets(s,t)}}),e.ui.plugin.add("draggable","snap",{start:function(t,i,s){var n=s.options;s.snapElements=[],e(n.snap.constructor!==String?n.snap.items||":data(ui-draggable)":n.snap).each(function(){var t=e(this),i=t.offset();this!==s.element[0]&&s.snapElements.push({item:this,width:t.outerWidth(),height:t.outerHeight(),top:i.top,left:i.left})})},drag:function(t,i,s){var n,a,o,r,h,l,u,d,c,p,f=s.options,m=f.snapTolerance,g=i.offset.left,v=g+s.helperProportions.width,y=i.offset.top,b=y+s.helperProportions.height;for(c=s.snapElements.length-1;c>=0;c--)h=s.snapElements[c].left-s.margins.left,l=h+s.snapElements[c].width,u=s.snapElements[c].top-s.margins.top,d=u+s.snapElements[c].height,h-m>v||g>l+m||u-m>b||y>d+m||!e.contains(s.snapElements[c].item.ownerDocument,s.snapElements[c].item)?(s.snapElements[c].snapping&&s.options.snap.release&&s.options.snap.release.call(s.element,t,e.extend(s._uiHash(),{snapItem:s.snapElements[c].item})),s.snapElements[c].snapping=!1):("inner"!==f.snapMode&&(n=m>=Math.abs(u-b),a=m>=Math.abs(d-y),o=m>=Math.abs(h-v),r=m>=Math.abs(l-g),n&&(i.position.top=s._convertPositionTo("relative",{top:u-s.helperProportions.height,left:0}).top),a&&(i.position.top=s._convertPositionTo("relative",{top:d,left:0}).top),o&&(i.position.left=s._convertPositionTo("relative",{top:0,left:h-s.helperProportions.width}).left),r&&(i.position.left=s._convertPositionTo("relative",{top:0,left:l}).left)),p=n||a||o||r,"outer"!==f.snapMode&&(n=m>=Math.abs(u-y),a=m>=Math.abs(d-b),o=m>=Math.abs(h-g),r=m>=Math.abs(l-v),n&&(i.position.top=s._convertPositionTo("relative",{top:u,left:0}).top),a&&(i.position.top=s._convertPositionTo("relative",{top:d-s.helperProportions.height,left:0}).top),o&&(i.position.left=s._convertPositionTo("relative",{top:0,left:h}).left),r&&(i.position.left=s._convertPositionTo("relative",{top:0,left:l-s.helperProportions.width}).left)),!s.snapElements[c].snapping&&(n||a||o||r||p)&&s.options.snap.snap&&s.options.snap.snap.call(s.element,t,e.extend(s._uiHash(),{snapItem:s.snapElements[c].item})),s.snapElements[c].snapping=n||a||o||r||p)}}),e.ui.plugin.add("draggable","stack",{start:function(t,i,s){var n,a=s.options,o=e.makeArray(e(a.stack)).sort(function(t,i){return(parseInt(e(t).css("zIndex"),10)||0)-(parseInt(e(i).css("zIndex"),10)||0)});o.length&&(n=parseInt(e(o[0]).css("zIndex"),10)||0,e(o).each(function(t){e(this).css("zIndex",n+t)}),this.css("zIndex",n+o.length))}}),e.ui.plugin.add("draggable","zIndex",{start:function(t,i,s){var n=e(i.helper),a=s.options;n.css("zIndex")&&(a._zIndex=n.css("zIndex")),n.css("zIndex",a.zIndex)},stop:function(t,i,s){var n=s.options;n._zIndex&&e(i.helper).css("zIndex",n._zIndex)}}),e.ui.draggable,e.widget("ui.resizable",e.ui.mouse,{version:"1.11.2",widgetEventPrefix:"resize",options:{alsoResize:!1,animate:!1,animateDuration:"slow",animateEasing:"swing",aspectRatio:!1,autoHide:!1,containment:!1,ghost:!1,grid:!1,handles:"e,s,se",helper:!1,maxHeight:null,maxWidth:null,minHeight:10,minWidth:10,zIndex:90,resize:null,start:null,stop:null},_num:function(e){return parseInt(e,10)||0},_isNumber:function(e){return!isNaN(parseInt(e,10))},_hasScroll:function(t,i){if("hidden"===e(t).css("overflow"))return!1;var s=i&&"left"===i?"scrollLeft":"scrollTop",n=!1;return t[s]>0?!0:(t[s]=1,n=t[s]>0,t[s]=0,n)},_create:function(){var t,i,s,n,a,o=this,r=this.options;if(this.element.addClass("ui-resizable"),e.extend(this,{_aspectRatio:!!r.aspectRatio,aspectRatio:r.aspectRatio,originalElement:this.element,_proportionallyResizeElements:[],_helper:r.helper||r.ghost||r.animate?r.helper||"ui-resizable-helper":null}),this.element[0].nodeName.match(/canvas|textarea|input|select|button|img/i)&&(this.element.wrap(e("<div class='ui-wrapper' style='overflow: hidden;'></div>").css({position:this.element.css("position"),width:this.element.outerWidth(),height:this.element.outerHeight(),top:this.element.css("top"),left:this.element.css("left")})),this.element=this.element.parent().data("ui-resizable",this.element.resizable("instance")),this.elementIsWrapper=!0,this.element.css({marginLeft:this.originalElement.css("marginLeft"),marginTop:this.originalElement.css("marginTop"),marginRight:this.originalElement.css("marginRight"),marginBottom:this.originalElement.css("marginBottom")}),this.originalElement.css({marginLeft:0,marginTop:0,marginRight:0,marginBottom:0}),this.originalResizeStyle=this.originalElement.css("resize"),this.originalElement.css("resize","none"),this._proportionallyResizeElements.push(this.originalElement.css({position:"static",zoom:1,display:"block"})),this.originalElement.css({margin:this.originalElement.css("margin")}),this._proportionallyResize()),this.handles=r.handles||(e(".ui-resizable-handle",this.element).length?{n:".ui-resizable-n",e:".ui-resizable-e",s:".ui-resizable-s",w:".ui-resizable-w",se:".ui-resizable-se",sw:".ui-resizable-sw",ne:".ui-resizable-ne",nw:".ui-resizable-nw"}:"e,s,se"),this.handles.constructor===String)for("all"===this.handles&&(this.handles="n,e,s,w,se,sw,ne,nw"),t=this.handles.split(","),this.handles={},i=0;t.length>i;i++)s=e.trim(t[i]),a="ui-resizable-"+s,n=e("<div class='ui-resizable-handle "+a+"'></div>"),n.css({zIndex:r.zIndex}),"se"===s&&n.addClass("ui-icon ui-icon-gripsmall-diagonal-se"),this.handles[s]=".ui-resizable-"+s,this.element.append(n);this._renderAxis=function(t){var i,s,n,a;t=t||this.element;for(i in this.handles)this.handles[i].constructor===String&&(this.handles[i]=this.element.children(this.handles[i]).first().show()),this.elementIsWrapper&&this.originalElement[0].nodeName.match(/textarea|input|select|button/i)&&(s=e(this.handles[i],this.element),a=/sw|ne|nw|se|n|s/.test(i)?s.outerHeight():s.outerWidth(),n=["padding",/ne|nw|n/.test(i)?"Top":/se|sw|s/.test(i)?"Bottom":/^e$/.test(i)?"Right":"Left"].join(""),t.css(n,a),this._proportionallyResize()),e(this.handles[i]).length},this._renderAxis(this.element),this._handles=e(".ui-resizable-handle",this.element).disableSelection(),this._handles.mouseover(function(){o.resizing||(this.className&&(n=this.className.match(/ui-resizable-(se|sw|ne|nw|n|e|s|w)/i)),o.axis=n&&n[1]?n[1]:"se")}),r.autoHide&&(this._handles.hide(),e(this.element).addClass("ui-resizable-autohide").mouseenter(function(){r.disabled||(e(this).removeClass("ui-resizable-autohide"),o._handles.show())}).mouseleave(function(){r.disabled||o.resizing||(e(this).addClass("ui-resizable-autohide"),o._handles.hide())})),this._mouseInit()},_destroy:function(){this._mouseDestroy();var t,i=function(t){e(t).removeClass("ui-resizable ui-resizable-disabled ui-resizable-resizing").removeData("resizable").removeData("ui-resizable").unbind(".resizable").find(".ui-resizable-handle").remove()};return this.elementIsWrapper&&(i(this.element),t=this.element,this.originalElement.css({position:t.css("position"),width:t.outerWidth(),height:t.outerHeight(),top:t.css("top"),left:t.css("left")}).insertAfter(t),t.remove()),this.originalElement.css("resize",this.originalResizeStyle),i(this.originalElement),this},_mouseCapture:function(t){var i,s,n=!1;for(i in this.handles)s=e(this.handles[i])[0],(s===t.target||e.contains(s,t.target))&&(n=!0);return!this.options.disabled&&n},_mouseStart:function(t){var i,s,n,a=this.options,o=this.element;return this.resizing=!0,this._renderProxy(),i=this._num(this.helper.css("left")),s=this._num(this.helper.css("top")),a.containment&&(i+=e(a.containment).scrollLeft()||0,s+=e(a.containment).scrollTop()||0),this.offset=this.helper.offset(),this.position={left:i,top:s},this.size=this._helper?{width:this.helper.width(),height:this.helper.height()}:{width:o.width(),height:o.height()},this.originalSize=this._helper?{width:o.outerWidth(),height:o.outerHeight()}:{width:o.width(),height:o.height()},this.sizeDiff={width:o.outerWidth()-o.width(),height:o.outerHeight()-o.height()},this.originalPosition={left:i,top:s},this.originalMousePosition={left:t.pageX,top:t.pageY},this.aspectRatio="number"==typeof a.aspectRatio?a.aspectRatio:this.originalSize.width/this.originalSize.height||1,n=e(".ui-resizable-"+this.axis).css("cursor"),e("body").css("cursor","auto"===n?this.axis+"-resize":n),o.addClass("ui-resizable-resizing"),this._propagate("start",t),!0},_mouseDrag:function(t){var i,s,n=this.originalMousePosition,a=this.axis,o=t.pageX-n.left||0,r=t.pageY-n.top||0,h=this._change[a];return this._updatePrevProperties(),h?(i=h.apply(this,[t,o,r]),this._updateVirtualBoundaries(t.shiftKey),(this._aspectRatio||t.shiftKey)&&(i=this._updateRatio(i,t)),i=this._respectSize(i,t),this._updateCache(i),this._propagate("resize",t),s=this._applyChanges(),!this._helper&&this._proportionallyResizeElements.length&&this._proportionallyResize(),e.isEmptyObject(s)||(this._updatePrevProperties(),this._trigger("resize",t,this.ui()),this._applyChanges()),!1):!1},_mouseStop:function(t){this.resizing=!1;var i,s,n,a,o,r,h,l=this.options,u=this;return this._helper&&(i=this._proportionallyResizeElements,s=i.length&&/textarea/i.test(i[0].nodeName),n=s&&this._hasScroll(i[0],"left")?0:u.sizeDiff.height,a=s?0:u.sizeDiff.width,o={width:u.helper.width()-a,height:u.helper.height()-n},r=parseInt(u.element.css("left"),10)+(u.position.left-u.originalPosition.left)||null,h=parseInt(u.element.css("top"),10)+(u.position.top-u.originalPosition.top)||null,l.animate||this.element.css(e.extend(o,{top:h,left:r})),u.helper.height(u.size.height),u.helper.width(u.size.width),this._helper&&!l.animate&&this._proportionallyResize()),e("body").css("cursor","auto"),this.element.removeClass("ui-resizable-resizing"),this._propagate("stop",t),this._helper&&this.helper.remove(),!1},_updatePrevProperties:function(){this.prevPosition={top:this.position.top,left:this.position.left},this.prevSize={width:this.size.width,height:this.size.height}},_applyChanges:function(){var e={};return this.position.top!==this.prevPosition.top&&(e.top=this.position.top+"px"),this.position.left!==this.prevPosition.left&&(e.left=this.position.left+"px"),this.size.width!==this.prevSize.width&&(e.width=this.size.width+"px"),this.size.height!==this.prevSize.height&&(e.height=this.size.height+"px"),this.helper.css(e),e},_updateVirtualBoundaries:function(e){var t,i,s,n,a,o=this.options;a={minWidth:this._isNumber(o.minWidth)?o.minWidth:0,maxWidth:this._isNumber(o.maxWidth)?o.maxWidth:1/0,minHeight:this._isNumber(o.minHeight)?o.minHeight:0,maxHeight:this._isNumber(o.maxHeight)?o.maxHeight:1/0},(this._aspectRatio||e)&&(t=a.minHeight*this.aspectRatio,s=a.minWidth/this.aspectRatio,i=a.maxHeight*this.aspectRatio,n=a.maxWidth/this.aspectRatio,t>a.minWidth&&(a.minWidth=t),s>a.minHeight&&(a.minHeight=s),a.maxWidth>i&&(a.maxWidth=i),a.maxHeight>n&&(a.maxHeight=n)),this._vBoundaries=a},_updateCache:function(e){this.offset=this.helper.offset(),this._isNumber(e.left)&&(this.position.left=e.left),this._isNumber(e.top)&&(this.position.top=e.top),this._isNumber(e.height)&&(this.size.height=e.height),this._isNumber(e.width)&&(this.size.width=e.width)},_updateRatio:function(e){var t=this.position,i=this.size,s=this.axis;return this._isNumber(e.height)?e.width=e.height*this.aspectRatio:this._isNumber(e.width)&&(e.height=e.width/this.aspectRatio),"sw"===s&&(e.left=t.left+(i.width-e.width),e.top=null),"nw"===s&&(e.top=t.top+(i.height-e.height),e.left=t.left+(i.width-e.width)),e},_respectSize:function(e){var t=this._vBoundaries,i=this.axis,s=this._isNumber(e.width)&&t.maxWidth&&t.maxWidth<e.width,n=this._isNumber(e.height)&&t.maxHeight&&t.maxHeight<e.height,a=this._isNumber(e.width)&&t.minWidth&&t.minWidth>e.width,o=this._isNumber(e.height)&&t.minHeight&&t.minHeight>e.height,r=this.originalPosition.left+this.originalSize.width,h=this.position.top+this.size.height,l=/sw|nw|w/.test(i),u=/nw|ne|n/.test(i);return a&&(e.width=t.minWidth),o&&(e.height=t.minHeight),s&&(e.width=t.maxWidth),n&&(e.height=t.maxHeight),a&&l&&(e.left=r-t.minWidth),s&&l&&(e.left=r-t.maxWidth),o&&u&&(e.top=h-t.minHeight),n&&u&&(e.top=h-t.maxHeight),e.width||e.height||e.left||!e.top?e.width||e.height||e.top||!e.left||(e.left=null):e.top=null,e},_getPaddingPlusBorderDimensions:function(e){for(var t=0,i=[],s=[e.css("borderTopWidth"),e.css("borderRightWidth"),e.css("borderBottomWidth"),e.css("borderLeftWidth")],n=[e.css("paddingTop"),e.css("paddingRight"),e.css("paddingBottom"),e.css("paddingLeft")];4>t;t++)i[t]=parseInt(s[t],10)||0,i[t]+=parseInt(n[t],10)||0;return{height:i[0]+i[2],width:i[1]+i[3]}},_proportionallyResize:function(){if(this._proportionallyResizeElements.length)for(var e,t=0,i=this.helper||this.element;this._proportionallyResizeElements.length>t;t++)e=this._proportionallyResizeElements[t],this.outerDimensions||(this.outerDimensions=this._getPaddingPlusBorderDimensions(e)),e.css({height:i.height()-this.outerDimensions.height||0,width:i.width()-this.outerDimensions.width||0})},_renderProxy:function(){var t=this.element,i=this.options;this.elementOffset=t.offset(),this._helper?(this.helper=this.helper||e("<div style='overflow:hidden;'></div>"),this.helper.addClass(this._helper).css({width:this.element.outerWidth()-1,height:this.element.outerHeight()-1,position:"absolute",left:this.elementOffset.left+"px",top:this.elementOffset.top+"px",zIndex:++i.zIndex}),this.helper.appendTo("body").disableSelection()):this.helper=this.element},_change:{e:function(e,t){return{width:this.originalSize.width+t}},w:function(e,t){var i=this.originalSize,s=this.originalPosition;return{left:s.left+t,width:i.width-t}},n:function(e,t,i){var s=this.originalSize,n=this.originalPosition;return{top:n.top+i,height:s.height-i}},s:function(e,t,i){return{height:this.originalSize.height+i}},se:function(t,i,s){return e.extend(this._change.s.apply(this,arguments),this._change.e.apply(this,[t,i,s]))},sw:function(t,i,s){return e.extend(this._change.s.apply(this,arguments),this._change.w.apply(this,[t,i,s]))},ne:function(t,i,s){return e.extend(this._change.n.apply(this,arguments),this._change.e.apply(this,[t,i,s]))},nw:function(t,i,s){return e.extend(this._change.n.apply(this,arguments),this._change.w.apply(this,[t,i,s]))}},_propagate:function(t,i){e.ui.plugin.call(this,t,[i,this.ui()]),"resize"!==t&&this._trigger(t,i,this.ui())},plugins:{},ui:function(){return{originalElement:this.originalElement,element:this.element,helper:this.helper,position:this.position,size:this.size,originalSize:this.originalSize,originalPosition:this.originalPosition}}}),e.ui.plugin.add("resizable","animate",{stop:function(t){var i=e(this).resizable("instance"),s=i.options,n=i._proportionallyResizeElements,a=n.length&&/textarea/i.test(n[0].nodeName),o=a&&i._hasScroll(n[0],"left")?0:i.sizeDiff.height,r=a?0:i.sizeDiff.width,h={width:i.size.width-r,height:i.size.height-o},l=parseInt(i.element.css("left"),10)+(i.position.left-i.originalPosition.left)||null,u=parseInt(i.element.css("top"),10)+(i.position.top-i.originalPosition.top)||null;i.element.animate(e.extend(h,u&&l?{top:u,left:l}:{}),{duration:s.animateDuration,easing:s.animateEasing,step:function(){var s={width:parseInt(i.element.css("width"),10),height:parseInt(i.element.css("height"),10),top:parseInt(i.element.css("top"),10),left:parseInt(i.element.css("left"),10)};n&&n.length&&e(n[0]).css({width:s.width,height:s.height}),i._updateCache(s),i._propagate("resize",t)}})}}),e.ui.plugin.add("resizable","containment",{start:function(){var t,i,s,n,a,o,r,h=e(this).resizable("instance"),l=h.options,u=h.element,d=l.containment,c=d instanceof e?d.get(0):/parent/.test(d)?u.parent().get(0):d;c&&(h.containerElement=e(c),/document/.test(d)||d===document?(h.containerOffset={left:0,top:0},h.containerPosition={left:0,top:0},h.parentData={element:e(document),left:0,top:0,width:e(document).width(),height:e(document).height()||document.body.parentNode.scrollHeight}):(t=e(c),i=[],e(["Top","Right","Left","Bottom"]).each(function(e,s){i[e]=h._num(t.css("padding"+s))}),h.containerOffset=t.offset(),h.containerPosition=t.position(),h.containerSize={height:t.innerHeight()-i[3],width:t.innerWidth()-i[1]},s=h.containerOffset,n=h.containerSize.height,a=h.containerSize.width,o=h._hasScroll(c,"left")?c.scrollWidth:a,r=h._hasScroll(c)?c.scrollHeight:n,h.parentData={element:c,left:s.left,top:s.top,width:o,height:r}))},resize:function(t){var i,s,n,a,o=e(this).resizable("instance"),r=o.options,h=o.containerOffset,l=o.position,u=o._aspectRatio||t.shiftKey,d={top:0,left:0},c=o.containerElement,p=!0;c[0]!==document&&/static/.test(c.css("position"))&&(d=h),l.left<(o._helper?h.left:0)&&(o.size.width=o.size.width+(o._helper?o.position.left-h.left:o.position.left-d.left),u&&(o.size.height=o.size.width/o.aspectRatio,p=!1),o.position.left=r.helper?h.left:0),l.top<(o._helper?h.top:0)&&(o.size.height=o.size.height+(o._helper?o.position.top-h.top:o.position.top),u&&(o.size.width=o.size.height*o.aspectRatio,p=!1),o.position.top=o._helper?h.top:0),n=o.containerElement.get(0)===o.element.parent().get(0),a=/relative|absolute/.test(o.containerElement.css("position")),n&&a?(o.offset.left=o.parentData.left+o.position.left,o.offset.top=o.parentData.top+o.position.top):(o.offset.left=o.element.offset().left,o.offset.top=o.element.offset().top),i=Math.abs(o.sizeDiff.width+(o._helper?o.offset.left-d.left:o.offset.left-h.left)),s=Math.abs(o.sizeDiff.height+(o._helper?o.offset.top-d.top:o.offset.top-h.top)),i+o.size.width>=o.parentData.width&&(o.size.width=o.parentData.width-i,u&&(o.size.height=o.size.width/o.aspectRatio,p=!1)),s+o.size.height>=o.parentData.height&&(o.size.height=o.parentData.height-s,u&&(o.size.width=o.size.height*o.aspectRatio,p=!1)),p||(o.position.left=o.prevPosition.left,o.position.top=o.prevPosition.top,o.size.width=o.prevSize.width,o.size.height=o.prevSize.height)},stop:function(){var t=e(this).resizable("instance"),i=t.options,s=t.containerOffset,n=t.containerPosition,a=t.containerElement,o=e(t.helper),r=o.offset(),h=o.outerWidth()-t.sizeDiff.width,l=o.outerHeight()-t.sizeDiff.height;t._helper&&!i.animate&&/relative/.test(a.css("position"))&&e(this).css({left:r.left-n.left-s.left,width:h,height:l}),t._helper&&!i.animate&&/static/.test(a.css("position"))&&e(this).css({left:r.left-n.left-s.left,width:h,height:l})}}),e.ui.plugin.add("resizable","alsoResize",{start:function(){var t=e(this).resizable("instance"),i=t.options,s=function(t){e(t).each(function(){var t=e(this);t.data("ui-resizable-alsoresize",{width:parseInt(t.width(),10),height:parseInt(t.height(),10),left:parseInt(t.css("left"),10),top:parseInt(t.css("top"),10)})})};"object"!=typeof i.alsoResize||i.alsoResize.parentNode?s(i.alsoResize):i.alsoResize.length?(i.alsoResize=i.alsoResize[0],s(i.alsoResize)):e.each(i.alsoResize,function(e){s(e)})},resize:function(t,i){var s=e(this).resizable("instance"),n=s.options,a=s.originalSize,o=s.originalPosition,r={height:s.size.height-a.height||0,width:s.size.width-a.width||0,top:s.position.top-o.top||0,left:s.position.left-o.left||0},h=function(t,s){e(t).each(function(){var t=e(this),n=e(this).data("ui-resizable-alsoresize"),a={},o=s&&s.length?s:t.parents(i.originalElement[0]).length?["width","height"]:["width","height","top","left"];e.each(o,function(e,t){var i=(n[t]||0)+(r[t]||0);i&&i>=0&&(a[t]=i||null)}),t.css(a)})};"object"!=typeof n.alsoResize||n.alsoResize.nodeType?h(n.alsoResize):e.each(n.alsoResize,function(e,t){h(e,t)})},stop:function(){e(this).removeData("resizable-alsoresize")}}),e.ui.plugin.add("resizable","ghost",{start:function(){var t=e(this).resizable("instance"),i=t.options,s=t.size;t.ghost=t.originalElement.clone(),t.ghost.css({opacity:.25,display:"block",position:"relative",height:s.height,width:s.width,margin:0,left:0,top:0}).addClass("ui-resizable-ghost").addClass("string"==typeof i.ghost?i.ghost:""),t.ghost.appendTo(t.helper)},resize:function(){var t=e(this).resizable("instance");t.ghost&&t.ghost.css({position:"relative",height:t.size.height,width:t.size.width})},stop:function(){var t=e(this).resizable("instance");t.ghost&&t.helper&&t.helper.get(0).removeChild(t.ghost.get(0))}}),e.ui.plugin.add("resizable","grid",{resize:function(){var t,i=e(this).resizable("instance"),s=i.options,n=i.size,a=i.originalSize,o=i.originalPosition,r=i.axis,h="number"==typeof s.grid?[s.grid,s.grid]:s.grid,l=h[0]||1,u=h[1]||1,d=Math.round((n.width-a.width)/l)*l,c=Math.round((n.height-a.height)/u)*u,p=a.width+d,f=a.height+c,m=s.maxWidth&&p>s.maxWidth,g=s.maxHeight&&f>s.maxHeight,v=s.minWidth&&s.minWidth>p,y=s.minHeight&&s.minHeight>f;s.grid=h,v&&(p+=l),y&&(f+=u),m&&(p-=l),g&&(f-=u),/^(se|s|e)$/.test(r)?(i.size.width=p,i.size.height=f):/^(ne)$/.test(r)?(i.size.width=p,i.size.height=f,i.position.top=o.top-c):/^(sw)$/.test(r)?(i.size.width=p,i.size.height=f,i.position.left=o.left-d):((0>=f-u||0>=p-l)&&(t=i._getPaddingPlusBorderDimensions(this)),f-u>0?(i.size.height=f,i.position.top=o.top-c):(f=u-t.height,i.size.height=f,i.position.top=o.top+a.height-f),p-l>0?(i.size.width=p,i.position.left=o.left-d):(p=u-t.height,i.size.width=p,i.position.left=o.left+a.width-p))}}),e.ui.resizable,e.widget("ui.dialog",{version:"1.11.2",options:{appendTo:"body",autoOpen:!0,buttons:[],closeOnEscape:!0,closeText:"Close",dialogClass:"",draggable:!0,hide:null,height:"auto",maxHeight:null,maxWidth:null,minHeight:150,minWidth:150,modal:!1,position:{my:"center",at:"center",of:window,collision:"fit",using:function(t){var i=e(this).css(t).offset().top;0>i&&e(this).css("top",t.top-i)}},resizable:!0,show:null,title:null,width:300,beforeClose:null,close:null,drag:null,dragStart:null,dragStop:null,focus:null,open:null,resize:null,resizeStart:null,resizeStop:null},sizeRelatedOptions:{buttons:!0,height:!0,maxHeight:!0,maxWidth:!0,minHeight:!0,minWidth:!0,width:!0},resizableRelatedOptions:{maxHeight:!0,maxWidth:!0,minHeight:!0,minWidth:!0},_create:function(){this.originalCss={display:this.element[0].style.display,width:this.element[0].style.width,minHeight:this.element[0].style.minHeight,maxHeight:this.element[0].style.maxHeight,height:this.element[0].style.height},this.originalPosition={parent:this.element.parent(),index:this.element.parent().children().index(this.element)},this.originalTitle=this.element.attr("title"),this.options.title=this.options.title||this.originalTitle,this._createWrapper(),this.element.show().removeAttr("title").addClass("ui-dialog-content ui-widget-content").appendTo(this.uiDialog),this._createTitlebar(),this._createButtonPane(),this.options.draggable&&e.fn.draggable&&this._makeDraggable(),this.options.resizable&&e.fn.resizable&&this._makeResizable(),this._isOpen=!1,this._trackFocus()},_init:function(){this.options.autoOpen&&this.open()},_appendTo:function(){var t=this.options.appendTo;return t&&(t.jquery||t.nodeType)?e(t):this.document.find(t||"body").eq(0)},_destroy:function(){var e,t=this.originalPosition;this._destroyOverlay(),this.element.removeUniqueId().removeClass("ui-dialog-content ui-widget-content").css(this.originalCss).detach(),this.uiDialog.stop(!0,!0).remove(),this.originalTitle&&this.element.attr("title",this.originalTitle),e=t.parent.children().eq(t.index),e.length&&e[0]!==this.element[0]?e.before(this.element):t.parent.append(this.element)},widget:function(){return this.uiDialog},disable:e.noop,enable:e.noop,close:function(t){var i,s=this;if(this._isOpen&&this._trigger("beforeClose",t)!==!1){if(this._isOpen=!1,this._focusedElement=null,this._destroyOverlay(),this._untrackInstance(),!this.opener.filter(":focusable").focus().length)try{i=this.document[0].activeElement,i&&"body"!==i.nodeName.toLowerCase()&&e(i).blur()}catch(n){}this._hide(this.uiDialog,this.options.hide,function(){s._trigger("close",t)})}},isOpen:function(){return this._isOpen},moveToTop:function(){this._moveToTop()},_moveToTop:function(t,i){var s=!1,n=this.uiDialog.siblings(".ui-front:visible").map(function(){return+e(this).css("z-index")}).get(),a=Math.max.apply(null,n);return a>=+this.uiDialog.css("z-index")&&(this.uiDialog.css("z-index",a+1),s=!0),s&&!i&&this._trigger("focus",t),s},open:function(){var t=this;return this._isOpen?(this._moveToTop()&&this._focusTabbable(),void 0):(this._isOpen=!0,this.opener=e(this.document[0].activeElement),this._size(),this._position(),this._createOverlay(),this._moveToTop(null,!0),this.overlay&&this.overlay.css("z-index",this.uiDialog.css("z-index")-1),this._show(this.uiDialog,this.options.show,function(){t._focusTabbable(),t._trigger("focus")}),this._makeFocusTarget(),this._trigger("open"),void 0)},_focusTabbable:function(){var e=this._focusedElement;e||(e=this.element.find("[autofocus]")),e.length||(e=this.element.find(":tabbable")),e.length||(e=this.uiDialogButtonPane.find(":tabbable")),e.length||(e=this.uiDialogTitlebarClose.filter(":tabbable")),e.length||(e=this.uiDialog),e.eq(0).focus()},_keepFocus:function(t){function i(){var t=this.document[0].activeElement,i=this.uiDialog[0]===t||e.contains(this.uiDialog[0],t);i||this._focusTabbable()}t.preventDefault(),i.call(this),this._delay(i)},_createWrapper:function(){this.uiDialog=e("<div>").addClass("ui-dialog ui-widget ui-widget-content ui-corner-all ui-front "+this.options.dialogClass).hide().attr({tabIndex:-1,role:"dialog"}).appendTo(this._appendTo()),this._on(this.uiDialog,{keydown:function(t){if(this.options.closeOnEscape&&!t.isDefaultPrevented()&&t.keyCode&&t.keyCode===e.ui.keyCode.ESCAPE)return t.preventDefault(),this.close(t),void 0;
if(t.keyCode===e.ui.keyCode.TAB&&!t.isDefaultPrevented()){var i=this.uiDialog.find(":tabbable"),s=i.filter(":first"),n=i.filter(":last");t.target!==n[0]&&t.target!==this.uiDialog[0]||t.shiftKey?t.target!==s[0]&&t.target!==this.uiDialog[0]||!t.shiftKey||(this._delay(function(){n.focus()}),t.preventDefault()):(this._delay(function(){s.focus()}),t.preventDefault())}},mousedown:function(e){this._moveToTop(e)&&this._focusTabbable()}}),this.element.find("[aria-describedby]").length||this.uiDialog.attr({"aria-describedby":this.element.uniqueId().attr("id")})},_createTitlebar:function(){var t;this.uiDialogTitlebar=e("<div>").addClass("ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix").prependTo(this.uiDialog),this._on(this.uiDialogTitlebar,{mousedown:function(t){e(t.target).closest(".ui-dialog-titlebar-close")||this.uiDialog.focus()}}),this.uiDialogTitlebarClose=e("<button type='button'></button>").button({label:this.options.closeText,icons:{primary:"ui-icon-closethick"},text:!1}).addClass("ui-dialog-titlebar-close").appendTo(this.uiDialogTitlebar),this._on(this.uiDialogTitlebarClose,{click:function(e){e.preventDefault(),this.close(e)}}),t=e("<span>").uniqueId().addClass("ui-dialog-title").prependTo(this.uiDialogTitlebar),this._title(t),this.uiDialog.attr({"aria-labelledby":t.attr("id")})},_title:function(e){this.options.title||e.html("&#160;"),e.text(this.options.title)},_createButtonPane:function(){this.uiDialogButtonPane=e("<div>").addClass("ui-dialog-buttonpane ui-widget-content ui-helper-clearfix"),this.uiButtonSet=e("<div>").addClass("ui-dialog-buttonset").appendTo(this.uiDialogButtonPane),this._createButtons()},_createButtons:function(){var t=this,i=this.options.buttons;return this.uiDialogButtonPane.remove(),this.uiButtonSet.empty(),e.isEmptyObject(i)||e.isArray(i)&&!i.length?(this.uiDialog.removeClass("ui-dialog-buttons"),void 0):(e.each(i,function(i,s){var n,a;s=e.isFunction(s)?{click:s,text:i}:s,s=e.extend({type:"button"},s),n=s.click,s.click=function(){n.apply(t.element[0],arguments)},a={icons:s.icons,text:s.showText},delete s.icons,delete s.showText,e("<button></button>",s).button(a).appendTo(t.uiButtonSet)}),this.uiDialog.addClass("ui-dialog-buttons"),this.uiDialogButtonPane.appendTo(this.uiDialog),void 0)},_makeDraggable:function(){function t(e){return{position:e.position,offset:e.offset}}var i=this,s=this.options;this.uiDialog.draggable({cancel:".ui-dialog-content, .ui-dialog-titlebar-close",handle:".ui-dialog-titlebar",containment:"document",start:function(s,n){e(this).addClass("ui-dialog-dragging"),i._blockFrames(),i._trigger("dragStart",s,t(n))},drag:function(e,s){i._trigger("drag",e,t(s))},stop:function(n,a){var o=a.offset.left-i.document.scrollLeft(),r=a.offset.top-i.document.scrollTop();s.position={my:"left top",at:"left"+(o>=0?"+":"")+o+" "+"top"+(r>=0?"+":"")+r,of:i.window},e(this).removeClass("ui-dialog-dragging"),i._unblockFrames(),i._trigger("dragStop",n,t(a))}})},_makeResizable:function(){function t(e){return{originalPosition:e.originalPosition,originalSize:e.originalSize,position:e.position,size:e.size}}var i=this,s=this.options,n=s.resizable,a=this.uiDialog.css("position"),o="string"==typeof n?n:"n,e,s,w,se,sw,ne,nw";this.uiDialog.resizable({cancel:".ui-dialog-content",containment:"document",alsoResize:this.element,maxWidth:s.maxWidth,maxHeight:s.maxHeight,minWidth:s.minWidth,minHeight:this._minHeight(),handles:o,start:function(s,n){e(this).addClass("ui-dialog-resizing"),i._blockFrames(),i._trigger("resizeStart",s,t(n))},resize:function(e,s){i._trigger("resize",e,t(s))},stop:function(n,a){var o=i.uiDialog.offset(),r=o.left-i.document.scrollLeft(),h=o.top-i.document.scrollTop();s.height=i.uiDialog.height(),s.width=i.uiDialog.width(),s.position={my:"left top",at:"left"+(r>=0?"+":"")+r+" "+"top"+(h>=0?"+":"")+h,of:i.window},e(this).removeClass("ui-dialog-resizing"),i._unblockFrames(),i._trigger("resizeStop",n,t(a))}}).css("position",a)},_trackFocus:function(){this._on(this.widget(),{focusin:function(t){this._makeFocusTarget(),this._focusedElement=e(t.target)}})},_makeFocusTarget:function(){this._untrackInstance(),this._trackingInstances().unshift(this)},_untrackInstance:function(){var t=this._trackingInstances(),i=e.inArray(this,t);-1!==i&&t.splice(i,1)},_trackingInstances:function(){var e=this.document.data("ui-dialog-instances");return e||(e=[],this.document.data("ui-dialog-instances",e)),e},_minHeight:function(){var e=this.options;return"auto"===e.height?e.minHeight:Math.min(e.minHeight,e.height)},_position:function(){var e=this.uiDialog.is(":visible");e||this.uiDialog.show(),this.uiDialog.position(this.options.position),e||this.uiDialog.hide()},_setOptions:function(t){var i=this,s=!1,n={};e.each(t,function(e,t){i._setOption(e,t),e in i.sizeRelatedOptions&&(s=!0),e in i.resizableRelatedOptions&&(n[e]=t)}),s&&(this._size(),this._position()),this.uiDialog.is(":data(ui-resizable)")&&this.uiDialog.resizable("option",n)},_setOption:function(e,t){var i,s,n=this.uiDialog;"dialogClass"===e&&n.removeClass(this.options.dialogClass).addClass(t),"disabled"!==e&&(this._super(e,t),"appendTo"===e&&this.uiDialog.appendTo(this._appendTo()),"buttons"===e&&this._createButtons(),"closeText"===e&&this.uiDialogTitlebarClose.button({label:""+t}),"draggable"===e&&(i=n.is(":data(ui-draggable)"),i&&!t&&n.draggable("destroy"),!i&&t&&this._makeDraggable()),"position"===e&&this._position(),"resizable"===e&&(s=n.is(":data(ui-resizable)"),s&&!t&&n.resizable("destroy"),s&&"string"==typeof t&&n.resizable("option","handles",t),s||t===!1||this._makeResizable()),"title"===e&&this._title(this.uiDialogTitlebar.find(".ui-dialog-title")))},_size:function(){var e,t,i,s=this.options;this.element.show().css({width:"auto",minHeight:0,maxHeight:"none",height:0}),s.minWidth>s.width&&(s.width=s.minWidth),e=this.uiDialog.css({height:"auto",width:s.width}).outerHeight(),t=Math.max(0,s.minHeight-e),i="number"==typeof s.maxHeight?Math.max(0,s.maxHeight-e):"none","auto"===s.height?this.element.css({minHeight:t,maxHeight:i,height:"auto"}):this.element.height(Math.max(0,s.height-e)),this.uiDialog.is(":data(ui-resizable)")&&this.uiDialog.resizable("option","minHeight",this._minHeight())},_blockFrames:function(){this.iframeBlocks=this.document.find("iframe").map(function(){var t=e(this);return e("<div>").css({position:"absolute",width:t.outerWidth(),height:t.outerHeight()}).appendTo(t.parent()).offset(t.offset())[0]})},_unblockFrames:function(){this.iframeBlocks&&(this.iframeBlocks.remove(),delete this.iframeBlocks)},_allowInteraction:function(t){return e(t.target).closest(".ui-dialog").length?!0:!!e(t.target).closest(".ui-datepicker").length},_createOverlay:function(){if(this.options.modal){var t=!0;this._delay(function(){t=!1}),this.document.data("ui-dialog-overlays")||this._on(this.document,{focusin:function(e){t||this._allowInteraction(e)||(e.preventDefault(),this._trackingInstances()[0]._focusTabbable())}}),this.overlay=e("<div>").addClass("ui-widget-overlay ui-front").appendTo(this._appendTo()),this._on(this.overlay,{mousedown:"_keepFocus"}),this.document.data("ui-dialog-overlays",(this.document.data("ui-dialog-overlays")||0)+1)}},_destroyOverlay:function(){if(this.options.modal&&this.overlay){var e=this.document.data("ui-dialog-overlays")-1;e?this.document.data("ui-dialog-overlays",e):this.document.unbind("focusin").removeData("ui-dialog-overlays"),this.overlay.remove(),this.overlay=null}}}),e.widget("ui.droppable",{version:"1.11.2",widgetEventPrefix:"drop",options:{accept:"*",activeClass:!1,addClasses:!0,greedy:!1,hoverClass:!1,scope:"default",tolerance:"intersect",activate:null,deactivate:null,drop:null,out:null,over:null},_create:function(){var t,i=this.options,s=i.accept;this.isover=!1,this.isout=!0,this.accept=e.isFunction(s)?s:function(e){return e.is(s)},this.proportions=function(){return arguments.length?(t=arguments[0],void 0):t?t:t={width:this.element[0].offsetWidth,height:this.element[0].offsetHeight}},this._addToManager(i.scope),i.addClasses&&this.element.addClass("ui-droppable")},_addToManager:function(t){e.ui.ddmanager.droppables[t]=e.ui.ddmanager.droppables[t]||[],e.ui.ddmanager.droppables[t].push(this)},_splice:function(e){for(var t=0;e.length>t;t++)e[t]===this&&e.splice(t,1)},_destroy:function(){var t=e.ui.ddmanager.droppables[this.options.scope];this._splice(t),this.element.removeClass("ui-droppable ui-droppable-disabled")},_setOption:function(t,i){if("accept"===t)this.accept=e.isFunction(i)?i:function(e){return e.is(i)};else if("scope"===t){var s=e.ui.ddmanager.droppables[this.options.scope];this._splice(s),this._addToManager(i)}this._super(t,i)},_activate:function(t){var i=e.ui.ddmanager.current;this.options.activeClass&&this.element.addClass(this.options.activeClass),i&&this._trigger("activate",t,this.ui(i))},_deactivate:function(t){var i=e.ui.ddmanager.current;this.options.activeClass&&this.element.removeClass(this.options.activeClass),i&&this._trigger("deactivate",t,this.ui(i))},_over:function(t){var i=e.ui.ddmanager.current;i&&(i.currentItem||i.element)[0]!==this.element[0]&&this.accept.call(this.element[0],i.currentItem||i.element)&&(this.options.hoverClass&&this.element.addClass(this.options.hoverClass),this._trigger("over",t,this.ui(i)))},_out:function(t){var i=e.ui.ddmanager.current;i&&(i.currentItem||i.element)[0]!==this.element[0]&&this.accept.call(this.element[0],i.currentItem||i.element)&&(this.options.hoverClass&&this.element.removeClass(this.options.hoverClass),this._trigger("out",t,this.ui(i)))},_drop:function(t,i){var s=i||e.ui.ddmanager.current,n=!1;return s&&(s.currentItem||s.element)[0]!==this.element[0]?(this.element.find(":data(ui-droppable)").not(".ui-draggable-dragging").each(function(){var i=e(this).droppable("instance");return i.options.greedy&&!i.options.disabled&&i.options.scope===s.options.scope&&i.accept.call(i.element[0],s.currentItem||s.element)&&e.ui.intersect(s,e.extend(i,{offset:i.element.offset()}),i.options.tolerance,t)?(n=!0,!1):void 0}),n?!1:this.accept.call(this.element[0],s.currentItem||s.element)?(this.options.activeClass&&this.element.removeClass(this.options.activeClass),this.options.hoverClass&&this.element.removeClass(this.options.hoverClass),this._trigger("drop",t,this.ui(s)),this.element):!1):!1},ui:function(e){return{draggable:e.currentItem||e.element,helper:e.helper,position:e.position,offset:e.positionAbs}}}),e.ui.intersect=function(){function e(e,t,i){return e>=t&&t+i>e}return function(t,i,s,n){if(!i.offset)return!1;var a=(t.positionAbs||t.position.absolute).left+t.margins.left,o=(t.positionAbs||t.position.absolute).top+t.margins.top,r=a+t.helperProportions.width,h=o+t.helperProportions.height,l=i.offset.left,u=i.offset.top,d=l+i.proportions().width,c=u+i.proportions().height;switch(s){case"fit":return a>=l&&d>=r&&o>=u&&c>=h;case"intersect":return a+t.helperProportions.width/2>l&&d>r-t.helperProportions.width/2&&o+t.helperProportions.height/2>u&&c>h-t.helperProportions.height/2;case"pointer":return e(n.pageY,u,i.proportions().height)&&e(n.pageX,l,i.proportions().width);case"touch":return(o>=u&&c>=o||h>=u&&c>=h||u>o&&h>c)&&(a>=l&&d>=a||r>=l&&d>=r||l>a&&r>d);default:return!1}}}(),e.ui.ddmanager={current:null,droppables:{"default":[]},prepareOffsets:function(t,i){var s,n,a=e.ui.ddmanager.droppables[t.options.scope]||[],o=i?i.type:null,r=(t.currentItem||t.element).find(":data(ui-droppable)").addBack();e:for(s=0;a.length>s;s++)if(!(a[s].options.disabled||t&&!a[s].accept.call(a[s].element[0],t.currentItem||t.element))){for(n=0;r.length>n;n++)if(r[n]===a[s].element[0]){a[s].proportions().height=0;continue e}a[s].visible="none"!==a[s].element.css("display"),a[s].visible&&("mousedown"===o&&a[s]._activate.call(a[s],i),a[s].offset=a[s].element.offset(),a[s].proportions({width:a[s].element[0].offsetWidth,height:a[s].element[0].offsetHeight}))}},drop:function(t,i){var s=!1;return e.each((e.ui.ddmanager.droppables[t.options.scope]||[]).slice(),function(){this.options&&(!this.options.disabled&&this.visible&&e.ui.intersect(t,this,this.options.tolerance,i)&&(s=this._drop.call(this,i)||s),!this.options.disabled&&this.visible&&this.accept.call(this.element[0],t.currentItem||t.element)&&(this.isout=!0,this.isover=!1,this._deactivate.call(this,i)))}),s},dragStart:function(t,i){t.element.parentsUntil("body").bind("scroll.droppable",function(){t.options.refreshPositions||e.ui.ddmanager.prepareOffsets(t,i)})},drag:function(t,i){t.options.refreshPositions&&e.ui.ddmanager.prepareOffsets(t,i),e.each(e.ui.ddmanager.droppables[t.options.scope]||[],function(){if(!this.options.disabled&&!this.greedyChild&&this.visible){var s,n,a,o=e.ui.intersect(t,this,this.options.tolerance,i),r=!o&&this.isover?"isout":o&&!this.isover?"isover":null;r&&(this.options.greedy&&(n=this.options.scope,a=this.element.parents(":data(ui-droppable)").filter(function(){return e(this).droppable("instance").options.scope===n}),a.length&&(s=e(a[0]).droppable("instance"),s.greedyChild="isover"===r)),s&&"isover"===r&&(s.isover=!1,s.isout=!0,s._out.call(s,i)),this[r]=!0,this["isout"===r?"isover":"isout"]=!1,this["isover"===r?"_over":"_out"].call(this,i),s&&"isout"===r&&(s.isout=!1,s.isover=!0,s._over.call(s,i)))}})},dragStop:function(t,i){t.element.parentsUntil("body").unbind("scroll.droppable"),t.options.refreshPositions||e.ui.ddmanager.prepareOffsets(t,i)}},e.ui.droppable;var y="ui-effects-",b=e;e.effects={effect:{}},function(e,t){function i(e,t,i){var s=d[t.type]||{};return null==e?i||!t.def?null:t.def:(e=s.floor?~~e:parseFloat(e),isNaN(e)?t.def:s.mod?(e+s.mod)%s.mod:0>e?0:e>s.max?s.max:e)}function s(i){var s=l(),n=s._rgba=[];return i=i.toLowerCase(),f(h,function(e,a){var o,r=a.re.exec(i),h=r&&a.parse(r),l=a.space||"rgba";return h?(o=s[l](h),s[u[l].cache]=o[u[l].cache],n=s._rgba=o._rgba,!1):t}),n.length?("0,0,0,0"===n.join()&&e.extend(n,a.transparent),s):a[i]}function n(e,t,i){return i=(i+1)%1,1>6*i?e+6*(t-e)*i:1>2*i?t:2>3*i?e+6*(t-e)*(2/3-i):e}var a,o="backgroundColor borderBottomColor borderLeftColor borderRightColor borderTopColor color columnRuleColor outlineColor textDecorationColor textEmphasisColor",r=/^([\-+])=\s*(\d+\.?\d*)/,h=[{re:/rgba?\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,parse:function(e){return[e[1],e[2],e[3],e[4]]}},{re:/rgba?\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,parse:function(e){return[2.55*e[1],2.55*e[2],2.55*e[3],e[4]]}},{re:/#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})/,parse:function(e){return[parseInt(e[1],16),parseInt(e[2],16),parseInt(e[3],16)]}},{re:/#([a-f0-9])([a-f0-9])([a-f0-9])/,parse:function(e){return[parseInt(e[1]+e[1],16),parseInt(e[2]+e[2],16),parseInt(e[3]+e[3],16)]}},{re:/hsla?\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,space:"hsla",parse:function(e){return[e[1],e[2]/100,e[3]/100,e[4]]}}],l=e.Color=function(t,i,s,n){return new e.Color.fn.parse(t,i,s,n)},u={rgba:{props:{red:{idx:0,type:"byte"},green:{idx:1,type:"byte"},blue:{idx:2,type:"byte"}}},hsla:{props:{hue:{idx:0,type:"degrees"},saturation:{idx:1,type:"percent"},lightness:{idx:2,type:"percent"}}}},d={"byte":{floor:!0,max:255},percent:{max:1},degrees:{mod:360,floor:!0}},c=l.support={},p=e("<p>")[0],f=e.each;p.style.cssText="background-color:rgba(1,1,1,.5)",c.rgba=p.style.backgroundColor.indexOf("rgba")>-1,f(u,function(e,t){t.cache="_"+e,t.props.alpha={idx:3,type:"percent",def:1}}),l.fn=e.extend(l.prototype,{parse:function(n,o,r,h){if(n===t)return this._rgba=[null,null,null,null],this;(n.jquery||n.nodeType)&&(n=e(n).css(o),o=t);var d=this,c=e.type(n),p=this._rgba=[];return o!==t&&(n=[n,o,r,h],c="array"),"string"===c?this.parse(s(n)||a._default):"array"===c?(f(u.rgba.props,function(e,t){p[t.idx]=i(n[t.idx],t)}),this):"object"===c?(n instanceof l?f(u,function(e,t){n[t.cache]&&(d[t.cache]=n[t.cache].slice())}):f(u,function(t,s){var a=s.cache;f(s.props,function(e,t){if(!d[a]&&s.to){if("alpha"===e||null==n[e])return;d[a]=s.to(d._rgba)}d[a][t.idx]=i(n[e],t,!0)}),d[a]&&0>e.inArray(null,d[a].slice(0,3))&&(d[a][3]=1,s.from&&(d._rgba=s.from(d[a])))}),this):t},is:function(e){var i=l(e),s=!0,n=this;return f(u,function(e,a){var o,r=i[a.cache];return r&&(o=n[a.cache]||a.to&&a.to(n._rgba)||[],f(a.props,function(e,i){return null!=r[i.idx]?s=r[i.idx]===o[i.idx]:t})),s}),s},_space:function(){var e=[],t=this;return f(u,function(i,s){t[s.cache]&&e.push(i)}),e.pop()},transition:function(e,t){var s=l(e),n=s._space(),a=u[n],o=0===this.alpha()?l("transparent"):this,r=o[a.cache]||a.to(o._rgba),h=r.slice();return s=s[a.cache],f(a.props,function(e,n){var a=n.idx,o=r[a],l=s[a],u=d[n.type]||{};null!==l&&(null===o?h[a]=l:(u.mod&&(l-o>u.mod/2?o+=u.mod:o-l>u.mod/2&&(o-=u.mod)),h[a]=i((l-o)*t+o,n)))}),this[n](h)},blend:function(t){if(1===this._rgba[3])return this;var i=this._rgba.slice(),s=i.pop(),n=l(t)._rgba;return l(e.map(i,function(e,t){return(1-s)*n[t]+s*e}))},toRgbaString:function(){var t="rgba(",i=e.map(this._rgba,function(e,t){return null==e?t>2?1:0:e});return 1===i[3]&&(i.pop(),t="rgb("),t+i.join()+")"},toHslaString:function(){var t="hsla(",i=e.map(this.hsla(),function(e,t){return null==e&&(e=t>2?1:0),t&&3>t&&(e=Math.round(100*e)+"%"),e});return 1===i[3]&&(i.pop(),t="hsl("),t+i.join()+")"},toHexString:function(t){var i=this._rgba.slice(),s=i.pop();return t&&i.push(~~(255*s)),"#"+e.map(i,function(e){return e=(e||0).toString(16),1===e.length?"0"+e:e}).join("")},toString:function(){return 0===this._rgba[3]?"transparent":this.toRgbaString()}}),l.fn.parse.prototype=l.fn,u.hsla.to=function(e){if(null==e[0]||null==e[1]||null==e[2])return[null,null,null,e[3]];var t,i,s=e[0]/255,n=e[1]/255,a=e[2]/255,o=e[3],r=Math.max(s,n,a),h=Math.min(s,n,a),l=r-h,u=r+h,d=.5*u;return t=h===r?0:s===r?60*(n-a)/l+360:n===r?60*(a-s)/l+120:60*(s-n)/l+240,i=0===l?0:.5>=d?l/u:l/(2-u),[Math.round(t)%360,i,d,null==o?1:o]},u.hsla.from=function(e){if(null==e[0]||null==e[1]||null==e[2])return[null,null,null,e[3]];var t=e[0]/360,i=e[1],s=e[2],a=e[3],o=.5>=s?s*(1+i):s+i-s*i,r=2*s-o;return[Math.round(255*n(r,o,t+1/3)),Math.round(255*n(r,o,t)),Math.round(255*n(r,o,t-1/3)),a]},f(u,function(s,n){var a=n.props,o=n.cache,h=n.to,u=n.from;l.fn[s]=function(s){if(h&&!this[o]&&(this[o]=h(this._rgba)),s===t)return this[o].slice();var n,r=e.type(s),d="array"===r||"object"===r?s:arguments,c=this[o].slice();return f(a,function(e,t){var s=d["object"===r?e:t.idx];null==s&&(s=c[t.idx]),c[t.idx]=i(s,t)}),u?(n=l(u(c)),n[o]=c,n):l(c)},f(a,function(t,i){l.fn[t]||(l.fn[t]=function(n){var a,o=e.type(n),h="alpha"===t?this._hsla?"hsla":"rgba":s,l=this[h](),u=l[i.idx];return"undefined"===o?u:("function"===o&&(n=n.call(this,u),o=e.type(n)),null==n&&i.empty?this:("string"===o&&(a=r.exec(n),a&&(n=u+parseFloat(a[2])*("+"===a[1]?1:-1))),l[i.idx]=n,this[h](l)))})})}),l.hook=function(t){var i=t.split(" ");f(i,function(t,i){e.cssHooks[i]={set:function(t,n){var a,o,r="";if("transparent"!==n&&("string"!==e.type(n)||(a=s(n)))){if(n=l(a||n),!c.rgba&&1!==n._rgba[3]){for(o="backgroundColor"===i?t.parentNode:t;(""===r||"transparent"===r)&&o&&o.style;)try{r=e.css(o,"backgroundColor"),o=o.parentNode}catch(h){}n=n.blend(r&&"transparent"!==r?r:"_default")}n=n.toRgbaString()}try{t.style[i]=n}catch(h){}}},e.fx.step[i]=function(t){t.colorInit||(t.start=l(t.elem,i),t.end=l(t.end),t.colorInit=!0),e.cssHooks[i].set(t.elem,t.start.transition(t.end,t.pos))}})},l.hook(o),e.cssHooks.borderColor={expand:function(e){var t={};return f(["Top","Right","Bottom","Left"],function(i,s){t["border"+s+"Color"]=e}),t}},a=e.Color.names={aqua:"#00ffff",black:"#000000",blue:"#0000ff",fuchsia:"#ff00ff",gray:"#808080",green:"#008000",lime:"#00ff00",maroon:"#800000",navy:"#000080",olive:"#808000",purple:"#800080",red:"#ff0000",silver:"#c0c0c0",teal:"#008080",white:"#ffffff",yellow:"#ffff00",transparent:[null,null,null,0],_default:"#ffffff"}}(b),function(){function t(t){var i,s,n=t.ownerDocument.defaultView?t.ownerDocument.defaultView.getComputedStyle(t,null):t.currentStyle,a={};if(n&&n.length&&n[0]&&n[n[0]])for(s=n.length;s--;)i=n[s],"string"==typeof n[i]&&(a[e.camelCase(i)]=n[i]);else for(i in n)"string"==typeof n[i]&&(a[i]=n[i]);return a}function i(t,i){var s,a,o={};for(s in i)a=i[s],t[s]!==a&&(n[s]||(e.fx.step[s]||!isNaN(parseFloat(a)))&&(o[s]=a));return o}var s=["add","remove","toggle"],n={border:1,borderBottom:1,borderColor:1,borderLeft:1,borderRight:1,borderTop:1,borderWidth:1,margin:1,padding:1};e.each(["borderLeftStyle","borderRightStyle","borderBottomStyle","borderTopStyle"],function(t,i){e.fx.step[i]=function(e){("none"!==e.end&&!e.setAttr||1===e.pos&&!e.setAttr)&&(b.style(e.elem,i,e.end),e.setAttr=!0)}}),e.fn.addBack||(e.fn.addBack=function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}),e.effects.animateClass=function(n,a,o,r){var h=e.speed(a,o,r);return this.queue(function(){var a,o=e(this),r=o.attr("class")||"",l=h.children?o.find("*").addBack():o;l=l.map(function(){var i=e(this);return{el:i,start:t(this)}}),a=function(){e.each(s,function(e,t){n[t]&&o[t+"Class"](n[t])})},a(),l=l.map(function(){return this.end=t(this.el[0]),this.diff=i(this.start,this.end),this}),o.attr("class",r),l=l.map(function(){var t=this,i=e.Deferred(),s=e.extend({},h,{queue:!1,complete:function(){i.resolve(t)}});return this.el.animate(this.diff,s),i.promise()}),e.when.apply(e,l.get()).done(function(){a(),e.each(arguments,function(){var t=this.el;e.each(this.diff,function(e){t.css(e,"")})}),h.complete.call(o[0])})})},e.fn.extend({addClass:function(t){return function(i,s,n,a){return s?e.effects.animateClass.call(this,{add:i},s,n,a):t.apply(this,arguments)}}(e.fn.addClass),removeClass:function(t){return function(i,s,n,a){return arguments.length>1?e.effects.animateClass.call(this,{remove:i},s,n,a):t.apply(this,arguments)}}(e.fn.removeClass),toggleClass:function(t){return function(i,s,n,a,o){return"boolean"==typeof s||void 0===s?n?e.effects.animateClass.call(this,s?{add:i}:{remove:i},n,a,o):t.apply(this,arguments):e.effects.animateClass.call(this,{toggle:i},s,n,a)}}(e.fn.toggleClass),switchClass:function(t,i,s,n,a){return e.effects.animateClass.call(this,{add:i,remove:t},s,n,a)}})}(),function(){function t(t,i,s,n){return e.isPlainObject(t)&&(i=t,t=t.effect),t={effect:t},null==i&&(i={}),e.isFunction(i)&&(n=i,s=null,i={}),("number"==typeof i||e.fx.speeds[i])&&(n=s,s=i,i={}),e.isFunction(s)&&(n=s,s=null),i&&e.extend(t,i),s=s||i.duration,t.duration=e.fx.off?0:"number"==typeof s?s:s in e.fx.speeds?e.fx.speeds[s]:e.fx.speeds._default,t.complete=n||i.complete,t}function i(t){return!t||"number"==typeof t||e.fx.speeds[t]?!0:"string"!=typeof t||e.effects.effect[t]?e.isFunction(t)?!0:"object"!=typeof t||t.effect?!1:!0:!0}e.extend(e.effects,{version:"1.11.2",save:function(e,t){for(var i=0;t.length>i;i++)null!==t[i]&&e.data(y+t[i],e[0].style[t[i]])},restore:function(e,t){var i,s;for(s=0;t.length>s;s++)null!==t[s]&&(i=e.data(y+t[s]),void 0===i&&(i=""),e.css(t[s],i))},setMode:function(e,t){return"toggle"===t&&(t=e.is(":hidden")?"show":"hide"),t},getBaseline:function(e,t){var i,s;switch(e[0]){case"top":i=0;break;case"middle":i=.5;break;case"bottom":i=1;break;default:i=e[0]/t.height}switch(e[1]){case"left":s=0;break;case"center":s=.5;break;case"right":s=1;break;default:s=e[1]/t.width}return{x:s,y:i}},createWrapper:function(t){if(t.parent().is(".ui-effects-wrapper"))return t.parent();var i={width:t.outerWidth(!0),height:t.outerHeight(!0),"float":t.css("float")},s=e("<div></div>").addClass("ui-effects-wrapper").css({fontSize:"100%",background:"transparent",border:"none",margin:0,padding:0}),n={width:t.width(),height:t.height()},a=document.activeElement;try{a.id}catch(o){a=document.body}return t.wrap(s),(t[0]===a||e.contains(t[0],a))&&e(a).focus(),s=t.parent(),"static"===t.css("position")?(s.css({position:"relative"}),t.css({position:"relative"})):(e.extend(i,{position:t.css("position"),zIndex:t.css("z-index")}),e.each(["top","left","bottom","right"],function(e,s){i[s]=t.css(s),isNaN(parseInt(i[s],10))&&(i[s]="auto")}),t.css({position:"relative",top:0,left:0,right:"auto",bottom:"auto"})),t.css(n),s.css(i).show()},removeWrapper:function(t){var i=document.activeElement;return t.parent().is(".ui-effects-wrapper")&&(t.parent().replaceWith(t),(t[0]===i||e.contains(t[0],i))&&e(i).focus()),t},setTransition:function(t,i,s,n){return n=n||{},e.each(i,function(e,i){var a=t.cssUnit(i);a[0]>0&&(n[i]=a[0]*s+a[1])}),n}}),e.fn.extend({effect:function(){function i(t){function i(){e.isFunction(a)&&a.call(n[0]),e.isFunction(t)&&t()}var n=e(this),a=s.complete,r=s.mode;(n.is(":hidden")?"hide"===r:"show"===r)?(n[r](),i()):o.call(n[0],s,i)}var s=t.apply(this,arguments),n=s.mode,a=s.queue,o=e.effects.effect[s.effect];return e.fx.off||!o?n?this[n](s.duration,s.complete):this.each(function(){s.complete&&s.complete.call(this)}):a===!1?this.each(i):this.queue(a||"fx",i)},show:function(e){return function(s){if(i(s))return e.apply(this,arguments);var n=t.apply(this,arguments);return n.mode="show",this.effect.call(this,n)}}(e.fn.show),hide:function(e){return function(s){if(i(s))return e.apply(this,arguments);var n=t.apply(this,arguments);return n.mode="hide",this.effect.call(this,n)}}(e.fn.hide),toggle:function(e){return function(s){if(i(s)||"boolean"==typeof s)return e.apply(this,arguments);var n=t.apply(this,arguments);return n.mode="toggle",this.effect.call(this,n)}}(e.fn.toggle),cssUnit:function(t){var i=this.css(t),s=[];return e.each(["em","px","%","pt"],function(e,t){i.indexOf(t)>0&&(s=[parseFloat(i),t])}),s}})}(),function(){var t={};e.each(["Quad","Cubic","Quart","Quint","Expo"],function(e,i){t[i]=function(t){return Math.pow(t,e+2)}}),e.extend(t,{Sine:function(e){return 1-Math.cos(e*Math.PI/2)},Circ:function(e){return 1-Math.sqrt(1-e*e)},Elastic:function(e){return 0===e||1===e?e:-Math.pow(2,8*(e-1))*Math.sin((80*(e-1)-7.5)*Math.PI/15)},Back:function(e){return e*e*(3*e-2)},Bounce:function(e){for(var t,i=4;((t=Math.pow(2,--i))-1)/11>e;);return 1/Math.pow(4,3-i)-7.5625*Math.pow((3*t-2)/22-e,2)}}),e.each(t,function(t,i){e.easing["easeIn"+t]=i,e.easing["easeOut"+t]=function(e){return 1-i(1-e)},e.easing["easeInOut"+t]=function(e){return.5>e?i(2*e)/2:1-i(-2*e+2)/2}})}(),e.effects,e.effects.effect.blind=function(t,i){var s,n,a,o=e(this),r=/up|down|vertical/,h=/up|left|vertical|horizontal/,l=["position","top","bottom","left","right","height","width"],u=e.effects.setMode(o,t.mode||"hide"),d=t.direction||"up",c=r.test(d),p=c?"height":"width",f=c?"top":"left",m=h.test(d),g={},v="show"===u;o.parent().is(".ui-effects-wrapper")?e.effects.save(o.parent(),l):e.effects.save(o,l),o.show(),s=e.effects.createWrapper(o).css({overflow:"hidden"}),n=s[p](),a=parseFloat(s.css(f))||0,g[p]=v?n:0,m||(o.css(c?"bottom":"right",0).css(c?"top":"left","auto").css({position:"absolute"}),g[f]=v?a:n+a),v&&(s.css(p,0),m||s.css(f,a+n)),s.animate(g,{duration:t.duration,easing:t.easing,queue:!1,complete:function(){"hide"===u&&o.hide(),e.effects.restore(o,l),e.effects.removeWrapper(o),i()}})},e.effects.effect.bounce=function(t,i){var s,n,a,o=e(this),r=["position","top","bottom","left","right","height","width"],h=e.effects.setMode(o,t.mode||"effect"),l="hide"===h,u="show"===h,d=t.direction||"up",c=t.distance,p=t.times||5,f=2*p+(u||l?1:0),m=t.duration/f,g=t.easing,v="up"===d||"down"===d?"top":"left",y="up"===d||"left"===d,b=o.queue(),_=b.length;for((u||l)&&r.push("opacity"),e.effects.save(o,r),o.show(),e.effects.createWrapper(o),c||(c=o["top"===v?"outerHeight":"outerWidth"]()/3),u&&(a={opacity:1},a[v]=0,o.css("opacity",0).css(v,y?2*-c:2*c).animate(a,m,g)),l&&(c/=Math.pow(2,p-1)),a={},a[v]=0,s=0;p>s;s++)n={},n[v]=(y?"-=":"+=")+c,o.animate(n,m,g).animate(a,m,g),c=l?2*c:c/2;l&&(n={opacity:0},n[v]=(y?"-=":"+=")+c,o.animate(n,m,g)),o.queue(function(){l&&o.hide(),e.effects.restore(o,r),e.effects.removeWrapper(o),i()}),_>1&&b.splice.apply(b,[1,0].concat(b.splice(_,f+1))),o.dequeue()},e.effects.effect.clip=function(t,i){var s,n,a,o=e(this),r=["position","top","bottom","left","right","height","width"],h=e.effects.setMode(o,t.mode||"hide"),l="show"===h,u=t.direction||"vertical",d="vertical"===u,c=d?"height":"width",p=d?"top":"left",f={};e.effects.save(o,r),o.show(),s=e.effects.createWrapper(o).css({overflow:"hidden"}),n="IMG"===o[0].tagName?s:o,a=n[c](),l&&(n.css(c,0),n.css(p,a/2)),f[c]=l?a:0,f[p]=l?0:a/2,n.animate(f,{queue:!1,duration:t.duration,easing:t.easing,complete:function(){l||o.hide(),e.effects.restore(o,r),e.effects.removeWrapper(o),i()}})},e.effects.effect.drop=function(t,i){var s,n=e(this),a=["position","top","bottom","left","right","opacity","height","width"],o=e.effects.setMode(n,t.mode||"hide"),r="show"===o,h=t.direction||"left",l="up"===h||"down"===h?"top":"left",u="up"===h||"left"===h?"pos":"neg",d={opacity:r?1:0};e.effects.save(n,a),n.show(),e.effects.createWrapper(n),s=t.distance||n["top"===l?"outerHeight":"outerWidth"](!0)/2,r&&n.css("opacity",0).css(l,"pos"===u?-s:s),d[l]=(r?"pos"===u?"+=":"-=":"pos"===u?"-=":"+=")+s,n.animate(d,{queue:!1,duration:t.duration,easing:t.easing,complete:function(){"hide"===o&&n.hide(),e.effects.restore(n,a),e.effects.removeWrapper(n),i()}})},e.effects.effect.explode=function(t,i){function s(){b.push(this),b.length===d*c&&n()}function n(){p.css({visibility:"visible"}),e(b).remove(),m||p.hide(),i()}var a,o,r,h,l,u,d=t.pieces?Math.round(Math.sqrt(t.pieces)):3,c=d,p=e(this),f=e.effects.setMode(p,t.mode||"hide"),m="show"===f,g=p.show().css("visibility","hidden").offset(),v=Math.ceil(p.outerWidth()/c),y=Math.ceil(p.outerHeight()/d),b=[];for(a=0;d>a;a++)for(h=g.top+a*y,u=a-(d-1)/2,o=0;c>o;o++)r=g.left+o*v,l=o-(c-1)/2,p.clone().appendTo("body").wrap("<div></div>").css({position:"absolute",visibility:"visible",left:-o*v,top:-a*y}).parent().addClass("ui-effects-explode").css({position:"absolute",overflow:"hidden",width:v,height:y,left:r+(m?l*v:0),top:h+(m?u*y:0),opacity:m?0:1}).animate({left:r+(m?0:l*v),top:h+(m?0:u*y),opacity:m?1:0},t.duration||500,t.easing,s)},e.effects.effect.fade=function(t,i){var s=e(this),n=e.effects.setMode(s,t.mode||"toggle");s.animate({opacity:n},{queue:!1,duration:t.duration,easing:t.easing,complete:i})},e.effects.effect.fold=function(t,i){var s,n,a=e(this),o=["position","top","bottom","left","right","height","width"],r=e.effects.setMode(a,t.mode||"hide"),h="show"===r,l="hide"===r,u=t.size||15,d=/([0-9]+)%/.exec(u),c=!!t.horizFirst,p=h!==c,f=p?["width","height"]:["height","width"],m=t.duration/2,g={},v={};e.effects.save(a,o),a.show(),s=e.effects.createWrapper(a).css({overflow:"hidden"}),n=p?[s.width(),s.height()]:[s.height(),s.width()],d&&(u=parseInt(d[1],10)/100*n[l?0:1]),h&&s.css(c?{height:0,width:u}:{height:u,width:0}),g[f[0]]=h?n[0]:u,v[f[1]]=h?n[1]:0,s.animate(g,m,t.easing).animate(v,m,t.easing,function(){l&&a.hide(),e.effects.restore(a,o),e.effects.removeWrapper(a),i()})},e.effects.effect.highlight=function(t,i){var s=e(this),n=["backgroundImage","backgroundColor","opacity"],a=e.effects.setMode(s,t.mode||"show"),o={backgroundColor:s.css("backgroundColor")};"hide"===a&&(o.opacity=0),e.effects.save(s,n),s.show().css({backgroundImage:"none",backgroundColor:t.color||"#ffff99"}).animate(o,{queue:!1,duration:t.duration,easing:t.easing,complete:function(){"hide"===a&&s.hide(),e.effects.restore(s,n),i()}})},e.effects.effect.size=function(t,i){var s,n,a,o=e(this),r=["position","top","bottom","left","right","width","height","overflow","opacity"],h=["position","top","bottom","left","right","overflow","opacity"],l=["width","height","overflow"],u=["fontSize"],d=["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],c=["borderLeftWidth","borderRightWidth","paddingLeft","paddingRight"],p=e.effects.setMode(o,t.mode||"effect"),f=t.restore||"effect"!==p,m=t.scale||"both",g=t.origin||["middle","center"],v=o.css("position"),y=f?r:h,b={height:0,width:0,outerHeight:0,outerWidth:0};"show"===p&&o.show(),s={height:o.height(),width:o.width(),outerHeight:o.outerHeight(),outerWidth:o.outerWidth()},"toggle"===t.mode&&"show"===p?(o.from=t.to||b,o.to=t.from||s):(o.from=t.from||("show"===p?b:s),o.to=t.to||("hide"===p?b:s)),a={from:{y:o.from.height/s.height,x:o.from.width/s.width},to:{y:o.to.height/s.height,x:o.to.width/s.width}},("box"===m||"both"===m)&&(a.from.y!==a.to.y&&(y=y.concat(d),o.from=e.effects.setTransition(o,d,a.from.y,o.from),o.to=e.effects.setTransition(o,d,a.to.y,o.to)),a.from.x!==a.to.x&&(y=y.concat(c),o.from=e.effects.setTransition(o,c,a.from.x,o.from),o.to=e.effects.setTransition(o,c,a.to.x,o.to))),("content"===m||"both"===m)&&a.from.y!==a.to.y&&(y=y.concat(u).concat(l),o.from=e.effects.setTransition(o,u,a.from.y,o.from),o.to=e.effects.setTransition(o,u,a.to.y,o.to)),e.effects.save(o,y),o.show(),e.effects.createWrapper(o),o.css("overflow","hidden").css(o.from),g&&(n=e.effects.getBaseline(g,s),o.from.top=(s.outerHeight-o.outerHeight())*n.y,o.from.left=(s.outerWidth-o.outerWidth())*n.x,o.to.top=(s.outerHeight-o.to.outerHeight)*n.y,o.to.left=(s.outerWidth-o.to.outerWidth)*n.x),o.css(o.from),("content"===m||"both"===m)&&(d=d.concat(["marginTop","marginBottom"]).concat(u),c=c.concat(["marginLeft","marginRight"]),l=r.concat(d).concat(c),o.find("*[width]").each(function(){var i=e(this),s={height:i.height(),width:i.width(),outerHeight:i.outerHeight(),outerWidth:i.outerWidth()};
f&&e.effects.save(i,l),i.from={height:s.height*a.from.y,width:s.width*a.from.x,outerHeight:s.outerHeight*a.from.y,outerWidth:s.outerWidth*a.from.x},i.to={height:s.height*a.to.y,width:s.width*a.to.x,outerHeight:s.height*a.to.y,outerWidth:s.width*a.to.x},a.from.y!==a.to.y&&(i.from=e.effects.setTransition(i,d,a.from.y,i.from),i.to=e.effects.setTransition(i,d,a.to.y,i.to)),a.from.x!==a.to.x&&(i.from=e.effects.setTransition(i,c,a.from.x,i.from),i.to=e.effects.setTransition(i,c,a.to.x,i.to)),i.css(i.from),i.animate(i.to,t.duration,t.easing,function(){f&&e.effects.restore(i,l)})})),o.animate(o.to,{queue:!1,duration:t.duration,easing:t.easing,complete:function(){0===o.to.opacity&&o.css("opacity",o.from.opacity),"hide"===p&&o.hide(),e.effects.restore(o,y),f||("static"===v?o.css({position:"relative",top:o.to.top,left:o.to.left}):e.each(["top","left"],function(e,t){o.css(t,function(t,i){var s=parseInt(i,10),n=e?o.to.left:o.to.top;return"auto"===i?n+"px":s+n+"px"})})),e.effects.removeWrapper(o),i()}})},e.effects.effect.scale=function(t,i){var s=e(this),n=e.extend(!0,{},t),a=e.effects.setMode(s,t.mode||"effect"),o=parseInt(t.percent,10)||(0===parseInt(t.percent,10)?0:"hide"===a?0:100),r=t.direction||"both",h=t.origin,l={height:s.height(),width:s.width(),outerHeight:s.outerHeight(),outerWidth:s.outerWidth()},u={y:"horizontal"!==r?o/100:1,x:"vertical"!==r?o/100:1};n.effect="size",n.queue=!1,n.complete=i,"effect"!==a&&(n.origin=h||["middle","center"],n.restore=!0),n.from=t.from||("show"===a?{height:0,width:0,outerHeight:0,outerWidth:0}:l),n.to={height:l.height*u.y,width:l.width*u.x,outerHeight:l.outerHeight*u.y,outerWidth:l.outerWidth*u.x},n.fade&&("show"===a&&(n.from.opacity=0,n.to.opacity=1),"hide"===a&&(n.from.opacity=1,n.to.opacity=0)),s.effect(n)},e.effects.effect.puff=function(t,i){var s=e(this),n=e.effects.setMode(s,t.mode||"hide"),a="hide"===n,o=parseInt(t.percent,10)||150,r=o/100,h={height:s.height(),width:s.width(),outerHeight:s.outerHeight(),outerWidth:s.outerWidth()};e.extend(t,{effect:"scale",queue:!1,fade:!0,mode:n,complete:i,percent:a?o:100,from:a?h:{height:h.height*r,width:h.width*r,outerHeight:h.outerHeight*r,outerWidth:h.outerWidth*r}}),s.effect(t)},e.effects.effect.pulsate=function(t,i){var s,n=e(this),a=e.effects.setMode(n,t.mode||"show"),o="show"===a,r="hide"===a,h=o||"hide"===a,l=2*(t.times||5)+(h?1:0),u=t.duration/l,d=0,c=n.queue(),p=c.length;for((o||!n.is(":visible"))&&(n.css("opacity",0).show(),d=1),s=1;l>s;s++)n.animate({opacity:d},u,t.easing),d=1-d;n.animate({opacity:d},u,t.easing),n.queue(function(){r&&n.hide(),i()}),p>1&&c.splice.apply(c,[1,0].concat(c.splice(p,l+1))),n.dequeue()},e.effects.effect.shake=function(t,i){var s,n=e(this),a=["position","top","bottom","left","right","height","width"],o=e.effects.setMode(n,t.mode||"effect"),r=t.direction||"left",h=t.distance||20,l=t.times||3,u=2*l+1,d=Math.round(t.duration/u),c="up"===r||"down"===r?"top":"left",p="up"===r||"left"===r,f={},m={},g={},v=n.queue(),y=v.length;for(e.effects.save(n,a),n.show(),e.effects.createWrapper(n),f[c]=(p?"-=":"+=")+h,m[c]=(p?"+=":"-=")+2*h,g[c]=(p?"-=":"+=")+2*h,n.animate(f,d,t.easing),s=1;l>s;s++)n.animate(m,d,t.easing).animate(g,d,t.easing);n.animate(m,d,t.easing).animate(f,d/2,t.easing).queue(function(){"hide"===o&&n.hide(),e.effects.restore(n,a),e.effects.removeWrapper(n),i()}),y>1&&v.splice.apply(v,[1,0].concat(v.splice(y,u+1))),n.dequeue()},e.effects.effect.slide=function(t,i){var s,n=e(this),a=["position","top","bottom","left","right","width","height"],o=e.effects.setMode(n,t.mode||"show"),r="show"===o,h=t.direction||"left",l="up"===h||"down"===h?"top":"left",u="up"===h||"left"===h,d={};e.effects.save(n,a),n.show(),s=t.distance||n["top"===l?"outerHeight":"outerWidth"](!0),e.effects.createWrapper(n).css({overflow:"hidden"}),r&&n.css(l,u?isNaN(s)?"-"+s:-s:s),d[l]=(r?u?"+=":"-=":u?"-=":"+=")+s,n.animate(d,{queue:!1,duration:t.duration,easing:t.easing,complete:function(){"hide"===o&&n.hide(),e.effects.restore(n,a),e.effects.removeWrapper(n),i()}})},e.effects.effect.transfer=function(t,i){var s=e(this),n=e(t.to),a="fixed"===n.css("position"),o=e("body"),r=a?o.scrollTop():0,h=a?o.scrollLeft():0,l=n.offset(),u={top:l.top-r,left:l.left-h,height:n.innerHeight(),width:n.innerWidth()},d=s.offset(),c=e("<div class='ui-effects-transfer'></div>").appendTo(document.body).addClass(t.className).css({top:d.top-r,left:d.left-h,height:s.innerHeight(),width:s.innerWidth(),position:a?"fixed":"absolute"}).animate(u,t.duration,t.easing,function(){c.remove(),i()})},e.widget("ui.progressbar",{version:"1.11.2",options:{max:100,value:0,change:null,complete:null},min:0,_create:function(){this.oldValue=this.options.value=this._constrainedValue(),this.element.addClass("ui-progressbar ui-widget ui-widget-content ui-corner-all").attr({role:"progressbar","aria-valuemin":this.min}),this.valueDiv=e("<div class='ui-progressbar-value ui-widget-header ui-corner-left'></div>").appendTo(this.element),this._refreshValue()},_destroy:function(){this.element.removeClass("ui-progressbar ui-widget ui-widget-content ui-corner-all").removeAttr("role").removeAttr("aria-valuemin").removeAttr("aria-valuemax").removeAttr("aria-valuenow"),this.valueDiv.remove()},value:function(e){return void 0===e?this.options.value:(this.options.value=this._constrainedValue(e),this._refreshValue(),void 0)},_constrainedValue:function(e){return void 0===e&&(e=this.options.value),this.indeterminate=e===!1,"number"!=typeof e&&(e=0),this.indeterminate?!1:Math.min(this.options.max,Math.max(this.min,e))},_setOptions:function(e){var t=e.value;delete e.value,this._super(e),this.options.value=this._constrainedValue(t),this._refreshValue()},_setOption:function(e,t){"max"===e&&(t=Math.max(this.min,t)),"disabled"===e&&this.element.toggleClass("ui-state-disabled",!!t).attr("aria-disabled",t),this._super(e,t)},_percentage:function(){return this.indeterminate?100:100*(this.options.value-this.min)/(this.options.max-this.min)},_refreshValue:function(){var t=this.options.value,i=this._percentage();this.valueDiv.toggle(this.indeterminate||t>this.min).toggleClass("ui-corner-right",t===this.options.max).width(i.toFixed(0)+"%"),this.element.toggleClass("ui-progressbar-indeterminate",this.indeterminate),this.indeterminate?(this.element.removeAttr("aria-valuenow"),this.overlayDiv||(this.overlayDiv=e("<div class='ui-progressbar-overlay'></div>").appendTo(this.valueDiv))):(this.element.attr({"aria-valuemax":this.options.max,"aria-valuenow":t}),this.overlayDiv&&(this.overlayDiv.remove(),this.overlayDiv=null)),this.oldValue!==t&&(this.oldValue=t,this._trigger("change")),t===this.options.max&&this._trigger("complete")}}),e.widget("ui.selectable",e.ui.mouse,{version:"1.11.2",options:{appendTo:"body",autoRefresh:!0,distance:0,filter:"*",tolerance:"touch",selected:null,selecting:null,start:null,stop:null,unselected:null,unselecting:null},_create:function(){var t,i=this;this.element.addClass("ui-selectable"),this.dragged=!1,this.refresh=function(){t=e(i.options.filter,i.element[0]),t.addClass("ui-selectee"),t.each(function(){var t=e(this),i=t.offset();e.data(this,"selectable-item",{element:this,$element:t,left:i.left,top:i.top,right:i.left+t.outerWidth(),bottom:i.top+t.outerHeight(),startselected:!1,selected:t.hasClass("ui-selected"),selecting:t.hasClass("ui-selecting"),unselecting:t.hasClass("ui-unselecting")})})},this.refresh(),this.selectees=t.addClass("ui-selectee"),this._mouseInit(),this.helper=e("<div class='ui-selectable-helper'></div>")},_destroy:function(){this.selectees.removeClass("ui-selectee").removeData("selectable-item"),this.element.removeClass("ui-selectable ui-selectable-disabled"),this._mouseDestroy()},_mouseStart:function(t){var i=this,s=this.options;this.opos=[t.pageX,t.pageY],this.options.disabled||(this.selectees=e(s.filter,this.element[0]),this._trigger("start",t),e(s.appendTo).append(this.helper),this.helper.css({left:t.pageX,top:t.pageY,width:0,height:0}),s.autoRefresh&&this.refresh(),this.selectees.filter(".ui-selected").each(function(){var s=e.data(this,"selectable-item");s.startselected=!0,t.metaKey||t.ctrlKey||(s.$element.removeClass("ui-selected"),s.selected=!1,s.$element.addClass("ui-unselecting"),s.unselecting=!0,i._trigger("unselecting",t,{unselecting:s.element}))}),e(t.target).parents().addBack().each(function(){var s,n=e.data(this,"selectable-item");return n?(s=!t.metaKey&&!t.ctrlKey||!n.$element.hasClass("ui-selected"),n.$element.removeClass(s?"ui-unselecting":"ui-selected").addClass(s?"ui-selecting":"ui-unselecting"),n.unselecting=!s,n.selecting=s,n.selected=s,s?i._trigger("selecting",t,{selecting:n.element}):i._trigger("unselecting",t,{unselecting:n.element}),!1):void 0}))},_mouseDrag:function(t){if(this.dragged=!0,!this.options.disabled){var i,s=this,n=this.options,a=this.opos[0],o=this.opos[1],r=t.pageX,h=t.pageY;return a>r&&(i=r,r=a,a=i),o>h&&(i=h,h=o,o=i),this.helper.css({left:a,top:o,width:r-a,height:h-o}),this.selectees.each(function(){var i=e.data(this,"selectable-item"),l=!1;i&&i.element!==s.element[0]&&("touch"===n.tolerance?l=!(i.left>r||a>i.right||i.top>h||o>i.bottom):"fit"===n.tolerance&&(l=i.left>a&&r>i.right&&i.top>o&&h>i.bottom),l?(i.selected&&(i.$element.removeClass("ui-selected"),i.selected=!1),i.unselecting&&(i.$element.removeClass("ui-unselecting"),i.unselecting=!1),i.selecting||(i.$element.addClass("ui-selecting"),i.selecting=!0,s._trigger("selecting",t,{selecting:i.element}))):(i.selecting&&((t.metaKey||t.ctrlKey)&&i.startselected?(i.$element.removeClass("ui-selecting"),i.selecting=!1,i.$element.addClass("ui-selected"),i.selected=!0):(i.$element.removeClass("ui-selecting"),i.selecting=!1,i.startselected&&(i.$element.addClass("ui-unselecting"),i.unselecting=!0),s._trigger("unselecting",t,{unselecting:i.element}))),i.selected&&(t.metaKey||t.ctrlKey||i.startselected||(i.$element.removeClass("ui-selected"),i.selected=!1,i.$element.addClass("ui-unselecting"),i.unselecting=!0,s._trigger("unselecting",t,{unselecting:i.element})))))}),!1}},_mouseStop:function(t){var i=this;return this.dragged=!1,e(".ui-unselecting",this.element[0]).each(function(){var s=e.data(this,"selectable-item");s.$element.removeClass("ui-unselecting"),s.unselecting=!1,s.startselected=!1,i._trigger("unselected",t,{unselected:s.element})}),e(".ui-selecting",this.element[0]).each(function(){var s=e.data(this,"selectable-item");s.$element.removeClass("ui-selecting").addClass("ui-selected"),s.selecting=!1,s.selected=!0,s.startselected=!0,i._trigger("selected",t,{selected:s.element})}),this._trigger("stop",t),this.helper.remove(),!1}}),e.widget("ui.selectmenu",{version:"1.11.2",defaultElement:"<select>",options:{appendTo:null,disabled:null,icons:{button:"ui-icon-triangle-1-s"},position:{my:"left top",at:"left bottom",collision:"none"},width:null,change:null,close:null,focus:null,open:null,select:null},_create:function(){var e=this.element.uniqueId().attr("id");this.ids={element:e,button:e+"-button",menu:e+"-menu"},this._drawButton(),this._drawMenu(),this.options.disabled&&this.disable()},_drawButton:function(){var t=this,i=this.element.attr("tabindex");this.label=e("label[for='"+this.ids.element+"']").attr("for",this.ids.button),this._on(this.label,{click:function(e){this.button.focus(),e.preventDefault()}}),this.element.hide(),this.button=e("<span>",{"class":"ui-selectmenu-button ui-widget ui-state-default ui-corner-all",tabindex:i||this.options.disabled?-1:0,id:this.ids.button,role:"combobox","aria-expanded":"false","aria-autocomplete":"list","aria-owns":this.ids.menu,"aria-haspopup":"true"}).insertAfter(this.element),e("<span>",{"class":"ui-icon "+this.options.icons.button}).prependTo(this.button),this.buttonText=e("<span>",{"class":"ui-selectmenu-text"}).appendTo(this.button),this._setText(this.buttonText,this.element.find("option:selected").text()),this._resizeButton(),this._on(this.button,this._buttonEvents),this.button.one("focusin",function(){t.menuItems||t._refreshMenu()}),this._hoverable(this.button),this._focusable(this.button)},_drawMenu:function(){var t=this;this.menu=e("<ul>",{"aria-hidden":"true","aria-labelledby":this.ids.button,id:this.ids.menu}),this.menuWrap=e("<div>",{"class":"ui-selectmenu-menu ui-front"}).append(this.menu).appendTo(this._appendTo()),this.menuInstance=this.menu.menu({role:"listbox",select:function(e,i){e.preventDefault(),t._setSelection(),t._select(i.item.data("ui-selectmenu-item"),e)},focus:function(e,i){var s=i.item.data("ui-selectmenu-item");null!=t.focusIndex&&s.index!==t.focusIndex&&(t._trigger("focus",e,{item:s}),t.isOpen||t._select(s,e)),t.focusIndex=s.index,t.button.attr("aria-activedescendant",t.menuItems.eq(s.index).attr("id"))}}).menu("instance"),this.menu.addClass("ui-corner-bottom").removeClass("ui-corner-all"),this.menuInstance._off(this.menu,"mouseleave"),this.menuInstance._closeOnDocumentClick=function(){return!1},this.menuInstance._isDivider=function(){return!1}},refresh:function(){this._refreshMenu(),this._setText(this.buttonText,this._getSelectedItem().text()),this.options.width||this._resizeButton()},_refreshMenu:function(){this.menu.empty();var e,t=this.element.find("option");t.length&&(this._parseOptions(t),this._renderMenu(this.menu,this.items),this.menuInstance.refresh(),this.menuItems=this.menu.find("li").not(".ui-selectmenu-optgroup"),e=this._getSelectedItem(),this.menuInstance.focus(null,e),this._setAria(e.data("ui-selectmenu-item")),this._setOption("disabled",this.element.prop("disabled")))},open:function(e){this.options.disabled||(this.menuItems?(this.menu.find(".ui-state-focus").removeClass("ui-state-focus"),this.menuInstance.focus(null,this._getSelectedItem())):this._refreshMenu(),this.isOpen=!0,this._toggleAttr(),this._resizeMenu(),this._position(),this._on(this.document,this._documentClick),this._trigger("open",e))},_position:function(){this.menuWrap.position(e.extend({of:this.button},this.options.position))},close:function(e){this.isOpen&&(this.isOpen=!1,this._toggleAttr(),this.range=null,this._off(this.document),this._trigger("close",e))},widget:function(){return this.button},menuWidget:function(){return this.menu},_renderMenu:function(t,i){var s=this,n="";e.each(i,function(i,a){a.optgroup!==n&&(e("<li>",{"class":"ui-selectmenu-optgroup ui-menu-divider"+(a.element.parent("optgroup").prop("disabled")?" ui-state-disabled":""),text:a.optgroup}).appendTo(t),n=a.optgroup),s._renderItemData(t,a)})},_renderItemData:function(e,t){return this._renderItem(e,t).data("ui-selectmenu-item",t)},_renderItem:function(t,i){var s=e("<li>");return i.disabled&&s.addClass("ui-state-disabled"),this._setText(s,i.label),s.appendTo(t)},_setText:function(e,t){t?e.text(t):e.html("&#160;")},_move:function(e,t){var i,s,n=".ui-menu-item";this.isOpen?i=this.menuItems.eq(this.focusIndex):(i=this.menuItems.eq(this.element[0].selectedIndex),n+=":not(.ui-state-disabled)"),s="first"===e||"last"===e?i["first"===e?"prevAll":"nextAll"](n).eq(-1):i[e+"All"](n).eq(0),s.length&&this.menuInstance.focus(t,s)},_getSelectedItem:function(){return this.menuItems.eq(this.element[0].selectedIndex)},_toggle:function(e){this[this.isOpen?"close":"open"](e)},_setSelection:function(){var e;this.range&&(window.getSelection?(e=window.getSelection(),e.removeAllRanges(),e.addRange(this.range)):this.range.select(),this.button.focus())},_documentClick:{mousedown:function(t){this.isOpen&&(e(t.target).closest(".ui-selectmenu-menu, #"+this.ids.button).length||this.close(t))}},_buttonEvents:{mousedown:function(){var e;window.getSelection?(e=window.getSelection(),e.rangeCount&&(this.range=e.getRangeAt(0))):this.range=document.selection.createRange()},click:function(e){this._setSelection(),this._toggle(e)},keydown:function(t){var i=!0;switch(t.keyCode){case e.ui.keyCode.TAB:case e.ui.keyCode.ESCAPE:this.close(t),i=!1;break;case e.ui.keyCode.ENTER:this.isOpen&&this._selectFocusedItem(t);break;case e.ui.keyCode.UP:t.altKey?this._toggle(t):this._move("prev",t);break;case e.ui.keyCode.DOWN:t.altKey?this._toggle(t):this._move("next",t);break;case e.ui.keyCode.SPACE:this.isOpen?this._selectFocusedItem(t):this._toggle(t);break;case e.ui.keyCode.LEFT:this._move("prev",t);break;case e.ui.keyCode.RIGHT:this._move("next",t);break;case e.ui.keyCode.HOME:case e.ui.keyCode.PAGE_UP:this._move("first",t);break;case e.ui.keyCode.END:case e.ui.keyCode.PAGE_DOWN:this._move("last",t);break;default:this.menu.trigger(t),i=!1}i&&t.preventDefault()}},_selectFocusedItem:function(e){var t=this.menuItems.eq(this.focusIndex);t.hasClass("ui-state-disabled")||this._select(t.data("ui-selectmenu-item"),e)},_select:function(e,t){var i=this.element[0].selectedIndex;this.element[0].selectedIndex=e.index,this._setText(this.buttonText,e.label),this._setAria(e),this._trigger("select",t,{item:e}),e.index!==i&&this._trigger("change",t,{item:e}),this.close(t)},_setAria:function(e){var t=this.menuItems.eq(e.index).attr("id");this.button.attr({"aria-labelledby":t,"aria-activedescendant":t}),this.menu.attr("aria-activedescendant",t)},_setOption:function(e,t){"icons"===e&&this.button.find("span.ui-icon").removeClass(this.options.icons.button).addClass(t.button),this._super(e,t),"appendTo"===e&&this.menuWrap.appendTo(this._appendTo()),"disabled"===e&&(this.menuInstance.option("disabled",t),this.button.toggleClass("ui-state-disabled",t).attr("aria-disabled",t),this.element.prop("disabled",t),t?(this.button.attr("tabindex",-1),this.close()):this.button.attr("tabindex",0)),"width"===e&&this._resizeButton()},_appendTo:function(){var t=this.options.appendTo;return t&&(t=t.jquery||t.nodeType?e(t):this.document.find(t).eq(0)),t&&t[0]||(t=this.element.closest(".ui-front")),t.length||(t=this.document[0].body),t},_toggleAttr:function(){this.button.toggleClass("ui-corner-top",this.isOpen).toggleClass("ui-corner-all",!this.isOpen).attr("aria-expanded",this.isOpen),this.menuWrap.toggleClass("ui-selectmenu-open",this.isOpen),this.menu.attr("aria-hidden",!this.isOpen)},_resizeButton:function(){var e=this.options.width;e||(e=this.element.show().outerWidth(),this.element.hide()),this.button.outerWidth(e)},_resizeMenu:function(){this.menu.outerWidth(Math.max(this.button.outerWidth(),this.menu.width("").outerWidth()+1))},_getCreateOptions:function(){return{disabled:this.element.prop("disabled")}},_parseOptions:function(t){var i=[];t.each(function(t,s){var n=e(s),a=n.parent("optgroup");i.push({element:n,index:t,value:n.attr("value"),label:n.text(),optgroup:a.attr("label")||"",disabled:a.prop("disabled")||n.prop("disabled")})}),this.items=i},_destroy:function(){this.menuWrap.remove(),this.button.remove(),this.element.show(),this.element.removeUniqueId(),this.label.attr("for",this.ids.element)}}),e.widget("ui.slider",e.ui.mouse,{version:"1.11.2",widgetEventPrefix:"slide",options:{animate:!1,distance:0,max:100,min:0,orientation:"horizontal",range:!1,step:1,value:0,values:null,change:null,slide:null,start:null,stop:null},numPages:5,_create:function(){this._keySliding=!1,this._mouseSliding=!1,this._animateOff=!0,this._handleIndex=null,this._detectOrientation(),this._mouseInit(),this._calculateNewMax(),this.element.addClass("ui-slider ui-slider-"+this.orientation+" ui-widget"+" ui-widget-content"+" ui-corner-all"),this._refresh(),this._setOption("disabled",this.options.disabled),this._animateOff=!1},_refresh:function(){this._createRange(),this._createHandles(),this._setupEvents(),this._refreshValue()},_createHandles:function(){var t,i,s=this.options,n=this.element.find(".ui-slider-handle").addClass("ui-state-default ui-corner-all"),a="<span class='ui-slider-handle ui-state-default ui-corner-all' tabindex='0'></span>",o=[];for(i=s.values&&s.values.length||1,n.length>i&&(n.slice(i).remove(),n=n.slice(0,i)),t=n.length;i>t;t++)o.push(a);this.handles=n.add(e(o.join("")).appendTo(this.element)),this.handle=this.handles.eq(0),this.handles.each(function(t){e(this).data("ui-slider-handle-index",t)})},_createRange:function(){var t=this.options,i="";t.range?(t.range===!0&&(t.values?t.values.length&&2!==t.values.length?t.values=[t.values[0],t.values[0]]:e.isArray(t.values)&&(t.values=t.values.slice(0)):t.values=[this._valueMin(),this._valueMin()]),this.range&&this.range.length?this.range.removeClass("ui-slider-range-min ui-slider-range-max").css({left:"",bottom:""}):(this.range=e("<div></div>").appendTo(this.element),i="ui-slider-range ui-widget-header ui-corner-all"),this.range.addClass(i+("min"===t.range||"max"===t.range?" ui-slider-range-"+t.range:""))):(this.range&&this.range.remove(),this.range=null)},_setupEvents:function(){this._off(this.handles),this._on(this.handles,this._handleEvents),this._hoverable(this.handles),this._focusable(this.handles)},_destroy:function(){this.handles.remove(),this.range&&this.range.remove(),this.element.removeClass("ui-slider ui-slider-horizontal ui-slider-vertical ui-widget ui-widget-content ui-corner-all"),this._mouseDestroy()},_mouseCapture:function(t){var i,s,n,a,o,r,h,l,u=this,d=this.options;return d.disabled?!1:(this.elementSize={width:this.element.outerWidth(),height:this.element.outerHeight()},this.elementOffset=this.element.offset(),i={x:t.pageX,y:t.pageY},s=this._normValueFromMouse(i),n=this._valueMax()-this._valueMin()+1,this.handles.each(function(t){var i=Math.abs(s-u.values(t));(n>i||n===i&&(t===u._lastChangedValue||u.values(t)===d.min))&&(n=i,a=e(this),o=t)}),r=this._start(t,o),r===!1?!1:(this._mouseSliding=!0,this._handleIndex=o,a.addClass("ui-state-active").focus(),h=a.offset(),l=!e(t.target).parents().addBack().is(".ui-slider-handle"),this._clickOffset=l?{left:0,top:0}:{left:t.pageX-h.left-a.width()/2,top:t.pageY-h.top-a.height()/2-(parseInt(a.css("borderTopWidth"),10)||0)-(parseInt(a.css("borderBottomWidth"),10)||0)+(parseInt(a.css("marginTop"),10)||0)},this.handles.hasClass("ui-state-hover")||this._slide(t,o,s),this._animateOff=!0,!0))},_mouseStart:function(){return!0},_mouseDrag:function(e){var t={x:e.pageX,y:e.pageY},i=this._normValueFromMouse(t);return this._slide(e,this._handleIndex,i),!1},_mouseStop:function(e){return this.handles.removeClass("ui-state-active"),this._mouseSliding=!1,this._stop(e,this._handleIndex),this._change(e,this._handleIndex),this._handleIndex=null,this._clickOffset=null,this._animateOff=!1,!1},_detectOrientation:function(){this.orientation="vertical"===this.options.orientation?"vertical":"horizontal"},_normValueFromMouse:function(e){var t,i,s,n,a;return"horizontal"===this.orientation?(t=this.elementSize.width,i=e.x-this.elementOffset.left-(this._clickOffset?this._clickOffset.left:0)):(t=this.elementSize.height,i=e.y-this.elementOffset.top-(this._clickOffset?this._clickOffset.top:0)),s=i/t,s>1&&(s=1),0>s&&(s=0),"vertical"===this.orientation&&(s=1-s),n=this._valueMax()-this._valueMin(),a=this._valueMin()+s*n,this._trimAlignValue(a)},_start:function(e,t){var i={handle:this.handles[t],value:this.value()};return this.options.values&&this.options.values.length&&(i.value=this.values(t),i.values=this.values()),this._trigger("start",e,i)},_slide:function(e,t,i){var s,n,a;this.options.values&&this.options.values.length?(s=this.values(t?0:1),2===this.options.values.length&&this.options.range===!0&&(0===t&&i>s||1===t&&s>i)&&(i=s),i!==this.values(t)&&(n=this.values(),n[t]=i,a=this._trigger("slide",e,{handle:this.handles[t],value:i,values:n}),s=this.values(t?0:1),a!==!1&&this.values(t,i))):i!==this.value()&&(a=this._trigger("slide",e,{handle:this.handles[t],value:i}),a!==!1&&this.value(i))},_stop:function(e,t){var i={handle:this.handles[t],value:this.value()};this.options.values&&this.options.values.length&&(i.value=this.values(t),i.values=this.values()),this._trigger("stop",e,i)},_change:function(e,t){if(!this._keySliding&&!this._mouseSliding){var i={handle:this.handles[t],value:this.value()};this.options.values&&this.options.values.length&&(i.value=this.values(t),i.values=this.values()),this._lastChangedValue=t,this._trigger("change",e,i)}},value:function(e){return arguments.length?(this.options.value=this._trimAlignValue(e),this._refreshValue(),this._change(null,0),void 0):this._value()},values:function(t,i){var s,n,a;if(arguments.length>1)return this.options.values[t]=this._trimAlignValue(i),this._refreshValue(),this._change(null,t),void 0;if(!arguments.length)return this._values();if(!e.isArray(arguments[0]))return this.options.values&&this.options.values.length?this._values(t):this.value();for(s=this.options.values,n=arguments[0],a=0;s.length>a;a+=1)s[a]=this._trimAlignValue(n[a]),this._change(null,a);this._refreshValue()},_setOption:function(t,i){var s,n=0;switch("range"===t&&this.options.range===!0&&("min"===i?(this.options.value=this._values(0),this.options.values=null):"max"===i&&(this.options.value=this._values(this.options.values.length-1),this.options.values=null)),e.isArray(this.options.values)&&(n=this.options.values.length),"disabled"===t&&this.element.toggleClass("ui-state-disabled",!!i),this._super(t,i),t){case"orientation":this._detectOrientation(),this.element.removeClass("ui-slider-horizontal ui-slider-vertical").addClass("ui-slider-"+this.orientation),this._refreshValue(),this.handles.css("horizontal"===i?"bottom":"left","");break;case"value":this._animateOff=!0,this._refreshValue(),this._change(null,0),this._animateOff=!1;break;case"values":for(this._animateOff=!0,this._refreshValue(),s=0;n>s;s+=1)this._change(null,s);this._animateOff=!1;break;case"step":case"min":case"max":this._animateOff=!0,this._calculateNewMax(),this._refreshValue(),this._animateOff=!1;break;case"range":this._animateOff=!0,this._refresh(),this._animateOff=!1}},_value:function(){var e=this.options.value;return e=this._trimAlignValue(e)},_values:function(e){var t,i,s;if(arguments.length)return t=this.options.values[e],t=this._trimAlignValue(t);if(this.options.values&&this.options.values.length){for(i=this.options.values.slice(),s=0;i.length>s;s+=1)i[s]=this._trimAlignValue(i[s]);return i}return[]},_trimAlignValue:function(e){if(this._valueMin()>=e)return this._valueMin();if(e>=this._valueMax())return this._valueMax();var t=this.options.step>0?this.options.step:1,i=(e-this._valueMin())%t,s=e-i;return 2*Math.abs(i)>=t&&(s+=i>0?t:-t),parseFloat(s.toFixed(5))},_calculateNewMax:function(){var e=(this.options.max-this._valueMin())%this.options.step;this.max=this.options.max-e},_valueMin:function(){return this.options.min},_valueMax:function(){return this.max},_refreshValue:function(){var t,i,s,n,a,o=this.options.range,r=this.options,h=this,l=this._animateOff?!1:r.animate,u={};this.options.values&&this.options.values.length?this.handles.each(function(s){i=100*((h.values(s)-h._valueMin())/(h._valueMax()-h._valueMin())),u["horizontal"===h.orientation?"left":"bottom"]=i+"%",e(this).stop(1,1)[l?"animate":"css"](u,r.animate),h.options.range===!0&&("horizontal"===h.orientation?(0===s&&h.range.stop(1,1)[l?"animate":"css"]({left:i+"%"},r.animate),1===s&&h.range[l?"animate":"css"]({width:i-t+"%"},{queue:!1,duration:r.animate})):(0===s&&h.range.stop(1,1)[l?"animate":"css"]({bottom:i+"%"},r.animate),1===s&&h.range[l?"animate":"css"]({height:i-t+"%"},{queue:!1,duration:r.animate}))),t=i}):(s=this.value(),n=this._valueMin(),a=this._valueMax(),i=a!==n?100*((s-n)/(a-n)):0,u["horizontal"===this.orientation?"left":"bottom"]=i+"%",this.handle.stop(1,1)[l?"animate":"css"](u,r.animate),"min"===o&&"horizontal"===this.orientation&&this.range.stop(1,1)[l?"animate":"css"]({width:i+"%"},r.animate),"max"===o&&"horizontal"===this.orientation&&this.range[l?"animate":"css"]({width:100-i+"%"},{queue:!1,duration:r.animate}),"min"===o&&"vertical"===this.orientation&&this.range.stop(1,1)[l?"animate":"css"]({height:i+"%"},r.animate),"max"===o&&"vertical"===this.orientation&&this.range[l?"animate":"css"]({height:100-i+"%"},{queue:!1,duration:r.animate}))},_handleEvents:{keydown:function(t){var i,s,n,a,o=e(t.target).data("ui-slider-handle-index");switch(t.keyCode){case e.ui.keyCode.HOME:case e.ui.keyCode.END:case e.ui.keyCode.PAGE_UP:case e.ui.keyCode.PAGE_DOWN:case e.ui.keyCode.UP:case e.ui.keyCode.RIGHT:case e.ui.keyCode.DOWN:case e.ui.keyCode.LEFT:if(t.preventDefault(),!this._keySliding&&(this._keySliding=!0,e(t.target).addClass("ui-state-active"),i=this._start(t,o),i===!1))return}switch(a=this.options.step,s=n=this.options.values&&this.options.values.length?this.values(o):this.value(),t.keyCode){case e.ui.keyCode.HOME:n=this._valueMin();break;case e.ui.keyCode.END:n=this._valueMax();break;case e.ui.keyCode.PAGE_UP:n=this._trimAlignValue(s+(this._valueMax()-this._valueMin())/this.numPages);break;case e.ui.keyCode.PAGE_DOWN:n=this._trimAlignValue(s-(this._valueMax()-this._valueMin())/this.numPages);break;case e.ui.keyCode.UP:case e.ui.keyCode.RIGHT:if(s===this._valueMax())return;n=this._trimAlignValue(s+a);break;case e.ui.keyCode.DOWN:case e.ui.keyCode.LEFT:if(s===this._valueMin())return;n=this._trimAlignValue(s-a)}this._slide(t,o,n)},keyup:function(t){var i=e(t.target).data("ui-slider-handle-index");this._keySliding&&(this._keySliding=!1,this._stop(t,i),this._change(t,i),e(t.target).removeClass("ui-state-active"))}}}),e.widget("ui.sortable",e.ui.mouse,{version:"1.11.2",widgetEventPrefix:"sort",ready:!1,options:{appendTo:"parent",axis:!1,connectWith:!1,containment:!1,cursor:"auto",cursorAt:!1,dropOnEmpty:!0,forcePlaceholderSize:!1,forceHelperSize:!1,grid:!1,handle:!1,helper:"original",items:"> *",opacity:!1,placeholder:!1,revert:!1,scroll:!0,scrollSensitivity:20,scrollSpeed:20,scope:"default",tolerance:"intersect",zIndex:1e3,activate:null,beforeStop:null,change:null,deactivate:null,out:null,over:null,receive:null,remove:null,sort:null,start:null,stop:null,update:null},_isOverAxis:function(e,t,i){return e>=t&&t+i>e},_isFloating:function(e){return/left|right/.test(e.css("float"))||/inline|table-cell/.test(e.css("display"))},_create:function(){var e=this.options;this.containerCache={},this.element.addClass("ui-sortable"),this.refresh(),this.floating=this.items.length?"x"===e.axis||this._isFloating(this.items[0].item):!1,this.offset=this.element.offset(),this._mouseInit(),this._setHandleClassName(),this.ready=!0},_setOption:function(e,t){this._super(e,t),"handle"===e&&this._setHandleClassName()},_setHandleClassName:function(){this.element.find(".ui-sortable-handle").removeClass("ui-sortable-handle"),e.each(this.items,function(){(this.instance.options.handle?this.item.find(this.instance.options.handle):this.item).addClass("ui-sortable-handle")})},_destroy:function(){this.element.removeClass("ui-sortable ui-sortable-disabled").find(".ui-sortable-handle").removeClass("ui-sortable-handle"),this._mouseDestroy();for(var e=this.items.length-1;e>=0;e--)this.items[e].item.removeData(this.widgetName+"-item");return this},_mouseCapture:function(t,i){var s=null,n=!1,a=this;return this.reverting?!1:this.options.disabled||"static"===this.options.type?!1:(this._refreshItems(t),e(t.target).parents().each(function(){return e.data(this,a.widgetName+"-item")===a?(s=e(this),!1):void 0}),e.data(t.target,a.widgetName+"-item")===a&&(s=e(t.target)),s?!this.options.handle||i||(e(this.options.handle,s).find("*").addBack().each(function(){this===t.target&&(n=!0)}),n)?(this.currentItem=s,this._removeCurrentsFromItems(),!0):!1:!1)},_mouseStart:function(t,i,s){var n,a,o=this.options;if(this.currentContainer=this,this.refreshPositions(),this.helper=this._createHelper(t),this._cacheHelperProportions(),this._cacheMargins(),this.scrollParent=this.helper.scrollParent(),this.offset=this.currentItem.offset(),this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left},e.extend(this.offset,{click:{left:t.pageX-this.offset.left,top:t.pageY-this.offset.top},parent:this._getParentOffset(),relative:this._getRelativeOffset()}),this.helper.css("position","absolute"),this.cssPosition=this.helper.css("position"),this.originalPosition=this._generatePosition(t),this.originalPageX=t.pageX,this.originalPageY=t.pageY,o.cursorAt&&this._adjustOffsetFromHelper(o.cursorAt),this.domPosition={prev:this.currentItem.prev()[0],parent:this.currentItem.parent()[0]},this.helper[0]!==this.currentItem[0]&&this.currentItem.hide(),this._createPlaceholder(),o.containment&&this._setContainment(),o.cursor&&"auto"!==o.cursor&&(a=this.document.find("body"),this.storedCursor=a.css("cursor"),a.css("cursor",o.cursor),this.storedStylesheet=e("<style>*{ cursor: "+o.cursor+" !important; }</style>").appendTo(a)),o.opacity&&(this.helper.css("opacity")&&(this._storedOpacity=this.helper.css("opacity")),this.helper.css("opacity",o.opacity)),o.zIndex&&(this.helper.css("zIndex")&&(this._storedZIndex=this.helper.css("zIndex")),this.helper.css("zIndex",o.zIndex)),this.scrollParent[0]!==document&&"HTML"!==this.scrollParent[0].tagName&&(this.overflowOffset=this.scrollParent.offset()),this._trigger("start",t,this._uiHash()),this._preserveHelperProportions||this._cacheHelperProportions(),!s)for(n=this.containers.length-1;n>=0;n--)this.containers[n]._trigger("activate",t,this._uiHash(this));
return e.ui.ddmanager&&(e.ui.ddmanager.current=this),e.ui.ddmanager&&!o.dropBehaviour&&e.ui.ddmanager.prepareOffsets(this,t),this.dragging=!0,this.helper.addClass("ui-sortable-helper"),this._mouseDrag(t),!0},_mouseDrag:function(t){var i,s,n,a,o=this.options,r=!1;for(this.position=this._generatePosition(t),this.positionAbs=this._convertPositionTo("absolute"),this.lastPositionAbs||(this.lastPositionAbs=this.positionAbs),this.options.scroll&&(this.scrollParent[0]!==document&&"HTML"!==this.scrollParent[0].tagName?(this.overflowOffset.top+this.scrollParent[0].offsetHeight-t.pageY<o.scrollSensitivity?this.scrollParent[0].scrollTop=r=this.scrollParent[0].scrollTop+o.scrollSpeed:t.pageY-this.overflowOffset.top<o.scrollSensitivity&&(this.scrollParent[0].scrollTop=r=this.scrollParent[0].scrollTop-o.scrollSpeed),this.overflowOffset.left+this.scrollParent[0].offsetWidth-t.pageX<o.scrollSensitivity?this.scrollParent[0].scrollLeft=r=this.scrollParent[0].scrollLeft+o.scrollSpeed:t.pageX-this.overflowOffset.left<o.scrollSensitivity&&(this.scrollParent[0].scrollLeft=r=this.scrollParent[0].scrollLeft-o.scrollSpeed)):(t.pageY-e(document).scrollTop()<o.scrollSensitivity?r=e(document).scrollTop(e(document).scrollTop()-o.scrollSpeed):e(window).height()-(t.pageY-e(document).scrollTop())<o.scrollSensitivity&&(r=e(document).scrollTop(e(document).scrollTop()+o.scrollSpeed)),t.pageX-e(document).scrollLeft()<o.scrollSensitivity?r=e(document).scrollLeft(e(document).scrollLeft()-o.scrollSpeed):e(window).width()-(t.pageX-e(document).scrollLeft())<o.scrollSensitivity&&(r=e(document).scrollLeft(e(document).scrollLeft()+o.scrollSpeed))),r!==!1&&e.ui.ddmanager&&!o.dropBehaviour&&e.ui.ddmanager.prepareOffsets(this,t)),this.positionAbs=this._convertPositionTo("absolute"),this.options.axis&&"y"===this.options.axis||(this.helper[0].style.left=this.position.left+"px"),this.options.axis&&"x"===this.options.axis||(this.helper[0].style.top=this.position.top+"px"),i=this.items.length-1;i>=0;i--)if(s=this.items[i],n=s.item[0],a=this._intersectsWithPointer(s),a&&s.instance===this.currentContainer&&n!==this.currentItem[0]&&this.placeholder[1===a?"next":"prev"]()[0]!==n&&!e.contains(this.placeholder[0],n)&&("semi-dynamic"===this.options.type?!e.contains(this.element[0],n):!0)){if(this.direction=1===a?"down":"up","pointer"!==this.options.tolerance&&!this._intersectsWithSides(s))break;this._rearrange(t,s),this._trigger("change",t,this._uiHash());break}return this._contactContainers(t),e.ui.ddmanager&&e.ui.ddmanager.drag(this,t),this._trigger("sort",t,this._uiHash()),this.lastPositionAbs=this.positionAbs,!1},_mouseStop:function(t,i){if(t){if(e.ui.ddmanager&&!this.options.dropBehaviour&&e.ui.ddmanager.drop(this,t),this.options.revert){var s=this,n=this.placeholder.offset(),a=this.options.axis,o={};a&&"x"!==a||(o.left=n.left-this.offset.parent.left-this.margins.left+(this.offsetParent[0]===document.body?0:this.offsetParent[0].scrollLeft)),a&&"y"!==a||(o.top=n.top-this.offset.parent.top-this.margins.top+(this.offsetParent[0]===document.body?0:this.offsetParent[0].scrollTop)),this.reverting=!0,e(this.helper).animate(o,parseInt(this.options.revert,10)||500,function(){s._clear(t)})}else this._clear(t,i);return!1}},cancel:function(){if(this.dragging){this._mouseUp({target:null}),"original"===this.options.helper?this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper"):this.currentItem.show();for(var t=this.containers.length-1;t>=0;t--)this.containers[t]._trigger("deactivate",null,this._uiHash(this)),this.containers[t].containerCache.over&&(this.containers[t]._trigger("out",null,this._uiHash(this)),this.containers[t].containerCache.over=0)}return this.placeholder&&(this.placeholder[0].parentNode&&this.placeholder[0].parentNode.removeChild(this.placeholder[0]),"original"!==this.options.helper&&this.helper&&this.helper[0].parentNode&&this.helper.remove(),e.extend(this,{helper:null,dragging:!1,reverting:!1,_noFinalSort:null}),this.domPosition.prev?e(this.domPosition.prev).after(this.currentItem):e(this.domPosition.parent).prepend(this.currentItem)),this},serialize:function(t){var i=this._getItemsAsjQuery(t&&t.connected),s=[];return t=t||{},e(i).each(function(){var i=(e(t.item||this).attr(t.attribute||"id")||"").match(t.expression||/(.+)[\-=_](.+)/);i&&s.push((t.key||i[1]+"[]")+"="+(t.key&&t.expression?i[1]:i[2]))}),!s.length&&t.key&&s.push(t.key+"="),s.join("&")},toArray:function(t){var i=this._getItemsAsjQuery(t&&t.connected),s=[];return t=t||{},i.each(function(){s.push(e(t.item||this).attr(t.attribute||"id")||"")}),s},_intersectsWith:function(e){var t=this.positionAbs.left,i=t+this.helperProportions.width,s=this.positionAbs.top,n=s+this.helperProportions.height,a=e.left,o=a+e.width,r=e.top,h=r+e.height,l=this.offset.click.top,u=this.offset.click.left,d="x"===this.options.axis||s+l>r&&h>s+l,c="y"===this.options.axis||t+u>a&&o>t+u,p=d&&c;return"pointer"===this.options.tolerance||this.options.forcePointerForContainers||"pointer"!==this.options.tolerance&&this.helperProportions[this.floating?"width":"height"]>e[this.floating?"width":"height"]?p:t+this.helperProportions.width/2>a&&o>i-this.helperProportions.width/2&&s+this.helperProportions.height/2>r&&h>n-this.helperProportions.height/2},_intersectsWithPointer:function(e){var t="x"===this.options.axis||this._isOverAxis(this.positionAbs.top+this.offset.click.top,e.top,e.height),i="y"===this.options.axis||this._isOverAxis(this.positionAbs.left+this.offset.click.left,e.left,e.width),s=t&&i,n=this._getDragVerticalDirection(),a=this._getDragHorizontalDirection();return s?this.floating?a&&"right"===a||"down"===n?2:1:n&&("down"===n?2:1):!1},_intersectsWithSides:function(e){var t=this._isOverAxis(this.positionAbs.top+this.offset.click.top,e.top+e.height/2,e.height),i=this._isOverAxis(this.positionAbs.left+this.offset.click.left,e.left+e.width/2,e.width),s=this._getDragVerticalDirection(),n=this._getDragHorizontalDirection();return this.floating&&n?"right"===n&&i||"left"===n&&!i:s&&("down"===s&&t||"up"===s&&!t)},_getDragVerticalDirection:function(){var e=this.positionAbs.top-this.lastPositionAbs.top;return 0!==e&&(e>0?"down":"up")},_getDragHorizontalDirection:function(){var e=this.positionAbs.left-this.lastPositionAbs.left;return 0!==e&&(e>0?"right":"left")},refresh:function(e){return this._refreshItems(e),this._setHandleClassName(),this.refreshPositions(),this},_connectWith:function(){var e=this.options;return e.connectWith.constructor===String?[e.connectWith]:e.connectWith},_getItemsAsjQuery:function(t){function i(){r.push(this)}var s,n,a,o,r=[],h=[],l=this._connectWith();if(l&&t)for(s=l.length-1;s>=0;s--)for(a=e(l[s]),n=a.length-1;n>=0;n--)o=e.data(a[n],this.widgetFullName),o&&o!==this&&!o.options.disabled&&h.push([e.isFunction(o.options.items)?o.options.items.call(o.element):e(o.options.items,o.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"),o]);for(h.push([e.isFunction(this.options.items)?this.options.items.call(this.element,null,{options:this.options,item:this.currentItem}):e(this.options.items,this.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"),this]),s=h.length-1;s>=0;s--)h[s][0].each(i);return e(r)},_removeCurrentsFromItems:function(){var t=this.currentItem.find(":data("+this.widgetName+"-item)");this.items=e.grep(this.items,function(e){for(var i=0;t.length>i;i++)if(t[i]===e.item[0])return!1;return!0})},_refreshItems:function(t){this.items=[],this.containers=[this];var i,s,n,a,o,r,h,l,u=this.items,d=[[e.isFunction(this.options.items)?this.options.items.call(this.element[0],t,{item:this.currentItem}):e(this.options.items,this.element),this]],c=this._connectWith();if(c&&this.ready)for(i=c.length-1;i>=0;i--)for(n=e(c[i]),s=n.length-1;s>=0;s--)a=e.data(n[s],this.widgetFullName),a&&a!==this&&!a.options.disabled&&(d.push([e.isFunction(a.options.items)?a.options.items.call(a.element[0],t,{item:this.currentItem}):e(a.options.items,a.element),a]),this.containers.push(a));for(i=d.length-1;i>=0;i--)for(o=d[i][1],r=d[i][0],s=0,l=r.length;l>s;s++)h=e(r[s]),h.data(this.widgetName+"-item",o),u.push({item:h,instance:o,width:0,height:0,left:0,top:0})},refreshPositions:function(t){this.offsetParent&&this.helper&&(this.offset.parent=this._getParentOffset());var i,s,n,a;for(i=this.items.length-1;i>=0;i--)s=this.items[i],s.instance!==this.currentContainer&&this.currentContainer&&s.item[0]!==this.currentItem[0]||(n=this.options.toleranceElement?e(this.options.toleranceElement,s.item):s.item,t||(s.width=n.outerWidth(),s.height=n.outerHeight()),a=n.offset(),s.left=a.left,s.top=a.top);if(this.options.custom&&this.options.custom.refreshContainers)this.options.custom.refreshContainers.call(this);else for(i=this.containers.length-1;i>=0;i--)a=this.containers[i].element.offset(),this.containers[i].containerCache.left=a.left,this.containers[i].containerCache.top=a.top,this.containers[i].containerCache.width=this.containers[i].element.outerWidth(),this.containers[i].containerCache.height=this.containers[i].element.outerHeight();return this},_createPlaceholder:function(t){t=t||this;var i,s=t.options;s.placeholder&&s.placeholder.constructor!==String||(i=s.placeholder,s.placeholder={element:function(){var s=t.currentItem[0].nodeName.toLowerCase(),n=e("<"+s+">",t.document[0]).addClass(i||t.currentItem[0].className+" ui-sortable-placeholder").removeClass("ui-sortable-helper");return"tr"===s?t.currentItem.children().each(function(){e("<td>&#160;</td>",t.document[0]).attr("colspan",e(this).attr("colspan")||1).appendTo(n)}):"img"===s&&n.attr("src",t.currentItem.attr("src")),i||n.css("visibility","hidden"),n},update:function(e,n){(!i||s.forcePlaceholderSize)&&(n.height()||n.height(t.currentItem.innerHeight()-parseInt(t.currentItem.css("paddingTop")||0,10)-parseInt(t.currentItem.css("paddingBottom")||0,10)),n.width()||n.width(t.currentItem.innerWidth()-parseInt(t.currentItem.css("paddingLeft")||0,10)-parseInt(t.currentItem.css("paddingRight")||0,10)))}}),t.placeholder=e(s.placeholder.element.call(t.element,t.currentItem)),t.currentItem.after(t.placeholder),s.placeholder.update(t,t.placeholder)},_contactContainers:function(t){var i,s,n,a,o,r,h,l,u,d,c=null,p=null;for(i=this.containers.length-1;i>=0;i--)if(!e.contains(this.currentItem[0],this.containers[i].element[0]))if(this._intersectsWith(this.containers[i].containerCache)){if(c&&e.contains(this.containers[i].element[0],c.element[0]))continue;c=this.containers[i],p=i}else this.containers[i].containerCache.over&&(this.containers[i]._trigger("out",t,this._uiHash(this)),this.containers[i].containerCache.over=0);if(c)if(1===this.containers.length)this.containers[p].containerCache.over||(this.containers[p]._trigger("over",t,this._uiHash(this)),this.containers[p].containerCache.over=1);else{for(n=1e4,a=null,u=c.floating||this._isFloating(this.currentItem),o=u?"left":"top",r=u?"width":"height",d=u?"clientX":"clientY",s=this.items.length-1;s>=0;s--)e.contains(this.containers[p].element[0],this.items[s].item[0])&&this.items[s].item[0]!==this.currentItem[0]&&(h=this.items[s].item.offset()[o],l=!1,t[d]-h>this.items[s][r]/2&&(l=!0),n>Math.abs(t[d]-h)&&(n=Math.abs(t[d]-h),a=this.items[s],this.direction=l?"up":"down"));if(!a&&!this.options.dropOnEmpty)return;if(this.currentContainer===this.containers[p])return this.currentContainer.containerCache.over||(this.containers[p]._trigger("over",t,this._uiHash()),this.currentContainer.containerCache.over=1),void 0;a?this._rearrange(t,a,null,!0):this._rearrange(t,null,this.containers[p].element,!0),this._trigger("change",t,this._uiHash()),this.containers[p]._trigger("change",t,this._uiHash(this)),this.currentContainer=this.containers[p],this.options.placeholder.update(this.currentContainer,this.placeholder),this.containers[p]._trigger("over",t,this._uiHash(this)),this.containers[p].containerCache.over=1}},_createHelper:function(t){var i=this.options,s=e.isFunction(i.helper)?e(i.helper.apply(this.element[0],[t,this.currentItem])):"clone"===i.helper?this.currentItem.clone():this.currentItem;return s.parents("body").length||e("parent"!==i.appendTo?i.appendTo:this.currentItem[0].parentNode)[0].appendChild(s[0]),s[0]===this.currentItem[0]&&(this._storedCSS={width:this.currentItem[0].style.width,height:this.currentItem[0].style.height,position:this.currentItem.css("position"),top:this.currentItem.css("top"),left:this.currentItem.css("left")}),(!s[0].style.width||i.forceHelperSize)&&s.width(this.currentItem.width()),(!s[0].style.height||i.forceHelperSize)&&s.height(this.currentItem.height()),s},_adjustOffsetFromHelper:function(t){"string"==typeof t&&(t=t.split(" ")),e.isArray(t)&&(t={left:+t[0],top:+t[1]||0}),"left"in t&&(this.offset.click.left=t.left+this.margins.left),"right"in t&&(this.offset.click.left=this.helperProportions.width-t.right+this.margins.left),"top"in t&&(this.offset.click.top=t.top+this.margins.top),"bottom"in t&&(this.offset.click.top=this.helperProportions.height-t.bottom+this.margins.top)},_getParentOffset:function(){this.offsetParent=this.helper.offsetParent();var t=this.offsetParent.offset();return"absolute"===this.cssPosition&&this.scrollParent[0]!==document&&e.contains(this.scrollParent[0],this.offsetParent[0])&&(t.left+=this.scrollParent.scrollLeft(),t.top+=this.scrollParent.scrollTop()),(this.offsetParent[0]===document.body||this.offsetParent[0].tagName&&"html"===this.offsetParent[0].tagName.toLowerCase()&&e.ui.ie)&&(t={top:0,left:0}),{top:t.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:t.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)}},_getRelativeOffset:function(){if("relative"===this.cssPosition){var e=this.currentItem.position();return{top:e.top-(parseInt(this.helper.css("top"),10)||0)+this.scrollParent.scrollTop(),left:e.left-(parseInt(this.helper.css("left"),10)||0)+this.scrollParent.scrollLeft()}}return{top:0,left:0}},_cacheMargins:function(){this.margins={left:parseInt(this.currentItem.css("marginLeft"),10)||0,top:parseInt(this.currentItem.css("marginTop"),10)||0}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var t,i,s,n=this.options;"parent"===n.containment&&(n.containment=this.helper[0].parentNode),("document"===n.containment||"window"===n.containment)&&(this.containment=[0-this.offset.relative.left-this.offset.parent.left,0-this.offset.relative.top-this.offset.parent.top,e("document"===n.containment?document:window).width()-this.helperProportions.width-this.margins.left,(e("document"===n.containment?document:window).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top]),/^(document|window|parent)$/.test(n.containment)||(t=e(n.containment)[0],i=e(n.containment).offset(),s="hidden"!==e(t).css("overflow"),this.containment=[i.left+(parseInt(e(t).css("borderLeftWidth"),10)||0)+(parseInt(e(t).css("paddingLeft"),10)||0)-this.margins.left,i.top+(parseInt(e(t).css("borderTopWidth"),10)||0)+(parseInt(e(t).css("paddingTop"),10)||0)-this.margins.top,i.left+(s?Math.max(t.scrollWidth,t.offsetWidth):t.offsetWidth)-(parseInt(e(t).css("borderLeftWidth"),10)||0)-(parseInt(e(t).css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left,i.top+(s?Math.max(t.scrollHeight,t.offsetHeight):t.offsetHeight)-(parseInt(e(t).css("borderTopWidth"),10)||0)-(parseInt(e(t).css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top])},_convertPositionTo:function(t,i){i||(i=this.position);var s="absolute"===t?1:-1,n="absolute"!==this.cssPosition||this.scrollParent[0]!==document&&e.contains(this.scrollParent[0],this.offsetParent[0])?this.scrollParent:this.offsetParent,a=/(html|body)/i.test(n[0].tagName);return{top:i.top+this.offset.relative.top*s+this.offset.parent.top*s-("fixed"===this.cssPosition?-this.scrollParent.scrollTop():a?0:n.scrollTop())*s,left:i.left+this.offset.relative.left*s+this.offset.parent.left*s-("fixed"===this.cssPosition?-this.scrollParent.scrollLeft():a?0:n.scrollLeft())*s}},_generatePosition:function(t){var i,s,n=this.options,a=t.pageX,o=t.pageY,r="absolute"!==this.cssPosition||this.scrollParent[0]!==document&&e.contains(this.scrollParent[0],this.offsetParent[0])?this.scrollParent:this.offsetParent,h=/(html|body)/i.test(r[0].tagName);return"relative"!==this.cssPosition||this.scrollParent[0]!==document&&this.scrollParent[0]!==this.offsetParent[0]||(this.offset.relative=this._getRelativeOffset()),this.originalPosition&&(this.containment&&(t.pageX-this.offset.click.left<this.containment[0]&&(a=this.containment[0]+this.offset.click.left),t.pageY-this.offset.click.top<this.containment[1]&&(o=this.containment[1]+this.offset.click.top),t.pageX-this.offset.click.left>this.containment[2]&&(a=this.containment[2]+this.offset.click.left),t.pageY-this.offset.click.top>this.containment[3]&&(o=this.containment[3]+this.offset.click.top)),n.grid&&(i=this.originalPageY+Math.round((o-this.originalPageY)/n.grid[1])*n.grid[1],o=this.containment?i-this.offset.click.top>=this.containment[1]&&i-this.offset.click.top<=this.containment[3]?i:i-this.offset.click.top>=this.containment[1]?i-n.grid[1]:i+n.grid[1]:i,s=this.originalPageX+Math.round((a-this.originalPageX)/n.grid[0])*n.grid[0],a=this.containment?s-this.offset.click.left>=this.containment[0]&&s-this.offset.click.left<=this.containment[2]?s:s-this.offset.click.left>=this.containment[0]?s-n.grid[0]:s+n.grid[0]:s)),{top:o-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+("fixed"===this.cssPosition?-this.scrollParent.scrollTop():h?0:r.scrollTop()),left:a-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+("fixed"===this.cssPosition?-this.scrollParent.scrollLeft():h?0:r.scrollLeft())}},_rearrange:function(e,t,i,s){i?i[0].appendChild(this.placeholder[0]):t.item[0].parentNode.insertBefore(this.placeholder[0],"down"===this.direction?t.item[0]:t.item[0].nextSibling),this.counter=this.counter?++this.counter:1;var n=this.counter;this._delay(function(){n===this.counter&&this.refreshPositions(!s)})},_clear:function(e,t){function i(e,t,i){return function(s){i._trigger(e,s,t._uiHash(t))}}this.reverting=!1;var s,n=[];if(!this._noFinalSort&&this.currentItem.parent().length&&this.placeholder.before(this.currentItem),this._noFinalSort=null,this.helper[0]===this.currentItem[0]){for(s in this._storedCSS)("auto"===this._storedCSS[s]||"static"===this._storedCSS[s])&&(this._storedCSS[s]="");this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper")}else this.currentItem.show();for(this.fromOutside&&!t&&n.push(function(e){this._trigger("receive",e,this._uiHash(this.fromOutside))}),!this.fromOutside&&this.domPosition.prev===this.currentItem.prev().not(".ui-sortable-helper")[0]&&this.domPosition.parent===this.currentItem.parent()[0]||t||n.push(function(e){this._trigger("update",e,this._uiHash())}),this!==this.currentContainer&&(t||(n.push(function(e){this._trigger("remove",e,this._uiHash())}),n.push(function(e){return function(t){e._trigger("receive",t,this._uiHash(this))}}.call(this,this.currentContainer)),n.push(function(e){return function(t){e._trigger("update",t,this._uiHash(this))}}.call(this,this.currentContainer)))),s=this.containers.length-1;s>=0;s--)t||n.push(i("deactivate",this,this.containers[s])),this.containers[s].containerCache.over&&(n.push(i("out",this,this.containers[s])),this.containers[s].containerCache.over=0);if(this.storedCursor&&(this.document.find("body").css("cursor",this.storedCursor),this.storedStylesheet.remove()),this._storedOpacity&&this.helper.css("opacity",this._storedOpacity),this._storedZIndex&&this.helper.css("zIndex","auto"===this._storedZIndex?"":this._storedZIndex),this.dragging=!1,t||this._trigger("beforeStop",e,this._uiHash()),this.placeholder[0].parentNode.removeChild(this.placeholder[0]),this.cancelHelperRemoval||(this.helper[0]!==this.currentItem[0]&&this.helper.remove(),this.helper=null),!t){for(s=0;n.length>s;s++)n[s].call(this,e);this._trigger("stop",e,this._uiHash())}return this.fromOutside=!1,!this.cancelHelperRemoval},_trigger:function(){e.Widget.prototype._trigger.apply(this,arguments)===!1&&this.cancel()},_uiHash:function(t){var i=t||this;return{helper:i.helper,placeholder:i.placeholder||e([]),position:i.position,originalPosition:i.originalPosition,offset:i.positionAbs,item:i.currentItem,sender:t?t.element:null}}}),e.widget("ui.spinner",{version:"1.11.2",defaultElement:"<input>",widgetEventPrefix:"spin",options:{culture:null,icons:{down:"ui-icon-triangle-1-s",up:"ui-icon-triangle-1-n"},incremental:!0,max:null,min:null,numberFormat:null,page:10,step:1,change:null,spin:null,start:null,stop:null},_create:function(){this._setOption("max",this.options.max),this._setOption("min",this.options.min),this._setOption("step",this.options.step),""!==this.value()&&this._value(this.element.val(),!0),this._draw(),this._on(this._events),this._refresh(),this._on(this.window,{beforeunload:function(){this.element.removeAttr("autocomplete")}})},_getCreateOptions:function(){var t={},i=this.element;return e.each(["min","max","step"],function(e,s){var n=i.attr(s);void 0!==n&&n.length&&(t[s]=n)}),t},_events:{keydown:function(e){this._start(e)&&this._keydown(e)&&e.preventDefault()},keyup:"_stop",focus:function(){this.previous=this.element.val()},blur:function(e){return this.cancelBlur?(delete this.cancelBlur,void 0):(this._stop(),this._refresh(),this.previous!==this.element.val()&&this._trigger("change",e),void 0)},mousewheel:function(e,t){if(t){if(!this.spinning&&!this._start(e))return!1;this._spin((t>0?1:-1)*this.options.step,e),clearTimeout(this.mousewheelTimer),this.mousewheelTimer=this._delay(function(){this.spinning&&this._stop(e)},100),e.preventDefault()}},"mousedown .ui-spinner-button":function(t){function i(){var e=this.element[0]===this.document[0].activeElement;e||(this.element.focus(),this.previous=s,this._delay(function(){this.previous=s}))}var s;s=this.element[0]===this.document[0].activeElement?this.previous:this.element.val(),t.preventDefault(),i.call(this),this.cancelBlur=!0,this._delay(function(){delete this.cancelBlur,i.call(this)}),this._start(t)!==!1&&this._repeat(null,e(t.currentTarget).hasClass("ui-spinner-up")?1:-1,t)},"mouseup .ui-spinner-button":"_stop","mouseenter .ui-spinner-button":function(t){return e(t.currentTarget).hasClass("ui-state-active")?this._start(t)===!1?!1:(this._repeat(null,e(t.currentTarget).hasClass("ui-spinner-up")?1:-1,t),void 0):void 0},"mouseleave .ui-spinner-button":"_stop"},_draw:function(){var e=this.uiSpinner=this.element.addClass("ui-spinner-input").attr("autocomplete","off").wrap(this._uiSpinnerHtml()).parent().append(this._buttonHtml());this.element.attr("role","spinbutton"),this.buttons=e.find(".ui-spinner-button").attr("tabIndex",-1).button().removeClass("ui-corner-all"),this.buttons.height()>Math.ceil(.5*e.height())&&e.height()>0&&e.height(e.height()),this.options.disabled&&this.disable()},_keydown:function(t){var i=this.options,s=e.ui.keyCode;switch(t.keyCode){case s.UP:return this._repeat(null,1,t),!0;case s.DOWN:return this._repeat(null,-1,t),!0;case s.PAGE_UP:return this._repeat(null,i.page,t),!0;case s.PAGE_DOWN:return this._repeat(null,-i.page,t),!0}return!1},_uiSpinnerHtml:function(){return"<span class='ui-spinner ui-widget ui-widget-content ui-corner-all'></span>"},_buttonHtml:function(){return"<a class='ui-spinner-button ui-spinner-up ui-corner-tr'><span class='ui-icon "+this.options.icons.up+"'>&#9650;</span>"+"</a>"+"<a class='ui-spinner-button ui-spinner-down ui-corner-br'>"+"<span class='ui-icon "+this.options.icons.down+"'>&#9660;</span>"+"</a>"},_start:function(e){return this.spinning||this._trigger("start",e)!==!1?(this.counter||(this.counter=1),this.spinning=!0,!0):!1},_repeat:function(e,t,i){e=e||500,clearTimeout(this.timer),this.timer=this._delay(function(){this._repeat(40,t,i)},e),this._spin(t*this.options.step,i)},_spin:function(e,t){var i=this.value()||0;this.counter||(this.counter=1),i=this._adjustValue(i+e*this._increment(this.counter)),this.spinning&&this._trigger("spin",t,{value:i})===!1||(this._value(i),this.counter++)},_increment:function(t){var i=this.options.incremental;return i?e.isFunction(i)?i(t):Math.floor(t*t*t/5e4-t*t/500+17*t/200+1):1},_precision:function(){var e=this._precisionOf(this.options.step);return null!==this.options.min&&(e=Math.max(e,this._precisionOf(this.options.min))),e},_precisionOf:function(e){var t=""+e,i=t.indexOf(".");return-1===i?0:t.length-i-1},_adjustValue:function(e){var t,i,s=this.options;return t=null!==s.min?s.min:0,i=e-t,i=Math.round(i/s.step)*s.step,e=t+i,e=parseFloat(e.toFixed(this._precision())),null!==s.max&&e>s.max?s.max:null!==s.min&&s.min>e?s.min:e},_stop:function(e){this.spinning&&(clearTimeout(this.timer),clearTimeout(this.mousewheelTimer),this.counter=0,this.spinning=!1,this._trigger("stop",e))},_setOption:function(e,t){if("culture"===e||"numberFormat"===e){var i=this._parse(this.element.val());return this.options[e]=t,this.element.val(this._format(i)),void 0}("max"===e||"min"===e||"step"===e)&&"string"==typeof t&&(t=this._parse(t)),"icons"===e&&(this.buttons.first().find(".ui-icon").removeClass(this.options.icons.up).addClass(t.up),this.buttons.last().find(".ui-icon").removeClass(this.options.icons.down).addClass(t.down)),this._super(e,t),"disabled"===e&&(this.widget().toggleClass("ui-state-disabled",!!t),this.element.prop("disabled",!!t),this.buttons.button(t?"disable":"enable"))},_setOptions:h(function(e){this._super(e)}),_parse:function(e){return"string"==typeof e&&""!==e&&(e=window.Globalize&&this.options.numberFormat?Globalize.parseFloat(e,10,this.options.culture):+e),""===e||isNaN(e)?null:e},_format:function(e){return""===e?"":window.Globalize&&this.options.numberFormat?Globalize.format(e,this.options.numberFormat,this.options.culture):e},_refresh:function(){this.element.attr({"aria-valuemin":this.options.min,"aria-valuemax":this.options.max,"aria-valuenow":this._parse(this.element.val())})},isValid:function(){var e=this.value();return null===e?!1:e===this._adjustValue(e)},_value:function(e,t){var i;""!==e&&(i=this._parse(e),null!==i&&(t||(i=this._adjustValue(i)),e=this._format(i))),this.element.val(e),this._refresh()},_destroy:function(){this.element.removeClass("ui-spinner-input").prop("disabled",!1).removeAttr("autocomplete").removeAttr("role").removeAttr("aria-valuemin").removeAttr("aria-valuemax").removeAttr("aria-valuenow"),this.uiSpinner.replaceWith(this.element)},stepUp:h(function(e){this._stepUp(e)}),_stepUp:function(e){this._start()&&(this._spin((e||1)*this.options.step),this._stop())},stepDown:h(function(e){this._stepDown(e)}),_stepDown:function(e){this._start()&&(this._spin((e||1)*-this.options.step),this._stop())},pageUp:h(function(e){this._stepUp((e||1)*this.options.page)}),pageDown:h(function(e){this._stepDown((e||1)*this.options.page)}),value:function(e){return arguments.length?(h(this._value).call(this,e),void 0):this._parse(this.element.val())},widget:function(){return this.uiSpinner}}),e.widget("ui.tabs",{version:"1.11.2",delay:300,options:{active:null,collapsible:!1,event:"click",heightStyle:"content",hide:null,show:null,activate:null,beforeActivate:null,beforeLoad:null,load:null},_isLocal:function(){var e=/#.*$/;return function(t){var i,s;t=t.cloneNode(!1),i=t.href.replace(e,""),s=location.href.replace(e,"");try{i=decodeURIComponent(i)}catch(n){}try{s=decodeURIComponent(s)}catch(n){}return t.hash.length>1&&i===s}}(),_create:function(){var t=this,i=this.options;this.running=!1,this.element.addClass("ui-tabs ui-widget ui-widget-content ui-corner-all").toggleClass("ui-tabs-collapsible",i.collapsible),this._processTabs(),i.active=this._initialActive(),e.isArray(i.disabled)&&(i.disabled=e.unique(i.disabled.concat(e.map(this.tabs.filter(".ui-state-disabled"),function(e){return t.tabs.index(e)}))).sort()),this.active=this.options.active!==!1&&this.anchors.length?this._findActive(i.active):e(),this._refresh(),this.active.length&&this.load(i.active)},_initialActive:function(){var t=this.options.active,i=this.options.collapsible,s=location.hash.substring(1);return null===t&&(s&&this.tabs.each(function(i,n){return e(n).attr("aria-controls")===s?(t=i,!1):void 0}),null===t&&(t=this.tabs.index(this.tabs.filter(".ui-tabs-active"))),(null===t||-1===t)&&(t=this.tabs.length?0:!1)),t!==!1&&(t=this.tabs.index(this.tabs.eq(t)),-1===t&&(t=i?!1:0)),!i&&t===!1&&this.anchors.length&&(t=0),t},_getCreateEventData:function(){return{tab:this.active,panel:this.active.length?this._getPanelForTab(this.active):e()}},_tabKeydown:function(t){var i=e(this.document[0].activeElement).closest("li"),s=this.tabs.index(i),n=!0;if(!this._handlePageNav(t)){switch(t.keyCode){case e.ui.keyCode.RIGHT:case e.ui.keyCode.DOWN:s++;break;case e.ui.keyCode.UP:case e.ui.keyCode.LEFT:n=!1,s--;break;case e.ui.keyCode.END:s=this.anchors.length-1;break;case e.ui.keyCode.HOME:s=0;break;case e.ui.keyCode.SPACE:return t.preventDefault(),clearTimeout(this.activating),this._activate(s),void 0;case e.ui.keyCode.ENTER:return t.preventDefault(),clearTimeout(this.activating),this._activate(s===this.options.active?!1:s),void 0;default:return}t.preventDefault(),clearTimeout(this.activating),s=this._focusNextTab(s,n),t.ctrlKey||(i.attr("aria-selected","false"),this.tabs.eq(s).attr("aria-selected","true"),this.activating=this._delay(function(){this.option("active",s)},this.delay))}},_panelKeydown:function(t){this._handlePageNav(t)||t.ctrlKey&&t.keyCode===e.ui.keyCode.UP&&(t.preventDefault(),this.active.focus())},_handlePageNav:function(t){return t.altKey&&t.keyCode===e.ui.keyCode.PAGE_UP?(this._activate(this._focusNextTab(this.options.active-1,!1)),!0):t.altKey&&t.keyCode===e.ui.keyCode.PAGE_DOWN?(this._activate(this._focusNextTab(this.options.active+1,!0)),!0):void 0},_findNextTab:function(t,i){function s(){return t>n&&(t=0),0>t&&(t=n),t}for(var n=this.tabs.length-1;-1!==e.inArray(s(),this.options.disabled);)t=i?t+1:t-1;return t},_focusNextTab:function(e,t){return e=this._findNextTab(e,t),this.tabs.eq(e).focus(),e},_setOption:function(e,t){return"active"===e?(this._activate(t),void 0):"disabled"===e?(this._setupDisabled(t),void 0):(this._super(e,t),"collapsible"===e&&(this.element.toggleClass("ui-tabs-collapsible",t),t||this.options.active!==!1||this._activate(0)),"event"===e&&this._setupEvents(t),"heightStyle"===e&&this._setupHeightStyle(t),void 0)},_sanitizeSelector:function(e){return e?e.replace(/[!"$%&'()*+,.\/:;<=>?@\[\]\^`{|}~]/g,"\\$&"):""},refresh:function(){var t=this.options,i=this.tablist.children(":has(a[href])");t.disabled=e.map(i.filter(".ui-state-disabled"),function(e){return i.index(e)}),this._processTabs(),t.active!==!1&&this.anchors.length?this.active.length&&!e.contains(this.tablist[0],this.active[0])?this.tabs.length===t.disabled.length?(t.active=!1,this.active=e()):this._activate(this._findNextTab(Math.max(0,t.active-1),!1)):t.active=this.tabs.index(this.active):(t.active=!1,this.active=e()),this._refresh()},_refresh:function(){this._setupDisabled(this.options.disabled),this._setupEvents(this.options.event),this._setupHeightStyle(this.options.heightStyle),this.tabs.not(this.active).attr({"aria-selected":"false","aria-expanded":"false",tabIndex:-1}),this.panels.not(this._getPanelForTab(this.active)).hide().attr({"aria-hidden":"true"}),this.active.length?(this.active.addClass("ui-tabs-active ui-state-active").attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0}),this._getPanelForTab(this.active).show().attr({"aria-hidden":"false"})):this.tabs.eq(0).attr("tabIndex",0)},_processTabs:function(){var t=this,i=this.tabs,s=this.anchors,n=this.panels;this.tablist=this._getList().addClass("ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all").attr("role","tablist").delegate("> li","mousedown"+this.eventNamespace,function(t){e(this).is(".ui-state-disabled")&&t.preventDefault()}).delegate(".ui-tabs-anchor","focus"+this.eventNamespace,function(){e(this).closest("li").is(".ui-state-disabled")&&this.blur()}),this.tabs=this.tablist.find("> li:has(a[href])").addClass("ui-state-default ui-corner-top").attr({role:"tab",tabIndex:-1}),this.anchors=this.tabs.map(function(){return e("a",this)[0]
}).addClass("ui-tabs-anchor").attr({role:"presentation",tabIndex:-1}),this.panels=e(),this.anchors.each(function(i,s){var n,a,o,r=e(s).uniqueId().attr("id"),h=e(s).closest("li"),l=h.attr("aria-controls");t._isLocal(s)?(n=s.hash,o=n.substring(1),a=t.element.find(t._sanitizeSelector(n))):(o=h.attr("aria-controls")||e({}).uniqueId()[0].id,n="#"+o,a=t.element.find(n),a.length||(a=t._createPanel(o),a.insertAfter(t.panels[i-1]||t.tablist)),a.attr("aria-live","polite")),a.length&&(t.panels=t.panels.add(a)),l&&h.data("ui-tabs-aria-controls",l),h.attr({"aria-controls":o,"aria-labelledby":r}),a.attr("aria-labelledby",r)}),this.panels.addClass("ui-tabs-panel ui-widget-content ui-corner-bottom").attr("role","tabpanel"),i&&(this._off(i.not(this.tabs)),this._off(s.not(this.anchors)),this._off(n.not(this.panels)))},_getList:function(){return this.tablist||this.element.find("ol,ul").eq(0)},_createPanel:function(t){return e("<div>").attr("id",t).addClass("ui-tabs-panel ui-widget-content ui-corner-bottom").data("ui-tabs-destroy",!0)},_setupDisabled:function(t){e.isArray(t)&&(t.length?t.length===this.anchors.length&&(t=!0):t=!1);for(var i,s=0;i=this.tabs[s];s++)t===!0||-1!==e.inArray(s,t)?e(i).addClass("ui-state-disabled").attr("aria-disabled","true"):e(i).removeClass("ui-state-disabled").removeAttr("aria-disabled");this.options.disabled=t},_setupEvents:function(t){var i={};t&&e.each(t.split(" "),function(e,t){i[t]="_eventHandler"}),this._off(this.anchors.add(this.tabs).add(this.panels)),this._on(!0,this.anchors,{click:function(e){e.preventDefault()}}),this._on(this.anchors,i),this._on(this.tabs,{keydown:"_tabKeydown"}),this._on(this.panels,{keydown:"_panelKeydown"}),this._focusable(this.tabs),this._hoverable(this.tabs)},_setupHeightStyle:function(t){var i,s=this.element.parent();"fill"===t?(i=s.height(),i-=this.element.outerHeight()-this.element.height(),this.element.siblings(":visible").each(function(){var t=e(this),s=t.css("position");"absolute"!==s&&"fixed"!==s&&(i-=t.outerHeight(!0))}),this.element.children().not(this.panels).each(function(){i-=e(this).outerHeight(!0)}),this.panels.each(function(){e(this).height(Math.max(0,i-e(this).innerHeight()+e(this).height()))}).css("overflow","auto")):"auto"===t&&(i=0,this.panels.each(function(){i=Math.max(i,e(this).height("").height())}).height(i))},_eventHandler:function(t){var i=this.options,s=this.active,n=e(t.currentTarget),a=n.closest("li"),o=a[0]===s[0],r=o&&i.collapsible,h=r?e():this._getPanelForTab(a),l=s.length?this._getPanelForTab(s):e(),u={oldTab:s,oldPanel:l,newTab:r?e():a,newPanel:h};t.preventDefault(),a.hasClass("ui-state-disabled")||a.hasClass("ui-tabs-loading")||this.running||o&&!i.collapsible||this._trigger("beforeActivate",t,u)===!1||(i.active=r?!1:this.tabs.index(a),this.active=o?e():a,this.xhr&&this.xhr.abort(),l.length||h.length||e.error("jQuery UI Tabs: Mismatching fragment identifier."),h.length&&this.load(this.tabs.index(a),t),this._toggle(t,u))},_toggle:function(t,i){function s(){a.running=!1,a._trigger("activate",t,i)}function n(){i.newTab.closest("li").addClass("ui-tabs-active ui-state-active"),o.length&&a.options.show?a._show(o,a.options.show,s):(o.show(),s())}var a=this,o=i.newPanel,r=i.oldPanel;this.running=!0,r.length&&this.options.hide?this._hide(r,this.options.hide,function(){i.oldTab.closest("li").removeClass("ui-tabs-active ui-state-active"),n()}):(i.oldTab.closest("li").removeClass("ui-tabs-active ui-state-active"),r.hide(),n()),r.attr("aria-hidden","true"),i.oldTab.attr({"aria-selected":"false","aria-expanded":"false"}),o.length&&r.length?i.oldTab.attr("tabIndex",-1):o.length&&this.tabs.filter(function(){return 0===e(this).attr("tabIndex")}).attr("tabIndex",-1),o.attr("aria-hidden","false"),i.newTab.attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0})},_activate:function(t){var i,s=this._findActive(t);s[0]!==this.active[0]&&(s.length||(s=this.active),i=s.find(".ui-tabs-anchor")[0],this._eventHandler({target:i,currentTarget:i,preventDefault:e.noop}))},_findActive:function(t){return t===!1?e():this.tabs.eq(t)},_getIndex:function(e){return"string"==typeof e&&(e=this.anchors.index(this.anchors.filter("[href$='"+e+"']"))),e},_destroy:function(){this.xhr&&this.xhr.abort(),this.element.removeClass("ui-tabs ui-widget ui-widget-content ui-corner-all ui-tabs-collapsible"),this.tablist.removeClass("ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all").removeAttr("role"),this.anchors.removeClass("ui-tabs-anchor").removeAttr("role").removeAttr("tabIndex").removeUniqueId(),this.tablist.unbind(this.eventNamespace),this.tabs.add(this.panels).each(function(){e.data(this,"ui-tabs-destroy")?e(this).remove():e(this).removeClass("ui-state-default ui-state-active ui-state-disabled ui-corner-top ui-corner-bottom ui-widget-content ui-tabs-active ui-tabs-panel").removeAttr("tabIndex").removeAttr("aria-live").removeAttr("aria-busy").removeAttr("aria-selected").removeAttr("aria-labelledby").removeAttr("aria-hidden").removeAttr("aria-expanded").removeAttr("role")}),this.tabs.each(function(){var t=e(this),i=t.data("ui-tabs-aria-controls");i?t.attr("aria-controls",i).removeData("ui-tabs-aria-controls"):t.removeAttr("aria-controls")}),this.panels.show(),"content"!==this.options.heightStyle&&this.panels.css("height","")},enable:function(t){var i=this.options.disabled;i!==!1&&(void 0===t?i=!1:(t=this._getIndex(t),i=e.isArray(i)?e.map(i,function(e){return e!==t?e:null}):e.map(this.tabs,function(e,i){return i!==t?i:null})),this._setupDisabled(i))},disable:function(t){var i=this.options.disabled;if(i!==!0){if(void 0===t)i=!0;else{if(t=this._getIndex(t),-1!==e.inArray(t,i))return;i=e.isArray(i)?e.merge([t],i).sort():[t]}this._setupDisabled(i)}},load:function(t,i){t=this._getIndex(t);var s=this,n=this.tabs.eq(t),a=n.find(".ui-tabs-anchor"),o=this._getPanelForTab(n),r={tab:n,panel:o};this._isLocal(a[0])||(this.xhr=e.ajax(this._ajaxSettings(a,i,r)),this.xhr&&"canceled"!==this.xhr.statusText&&(n.addClass("ui-tabs-loading"),o.attr("aria-busy","true"),this.xhr.success(function(e){setTimeout(function(){o.html(e),s._trigger("load",i,r)},1)}).complete(function(e,t){setTimeout(function(){"abort"===t&&s.panels.stop(!1,!0),n.removeClass("ui-tabs-loading"),o.removeAttr("aria-busy"),e===s.xhr&&delete s.xhr},1)})))},_ajaxSettings:function(t,i,s){var n=this;return{url:t.attr("href"),beforeSend:function(t,a){return n._trigger("beforeLoad",i,e.extend({jqXHR:t,ajaxSettings:a},s))}}},_getPanelForTab:function(t){var i=e(t).attr("aria-controls");return this.element.find(this._sanitizeSelector("#"+i))}}),e.widget("ui.tooltip",{version:"1.11.2",options:{content:function(){var t=e(this).attr("title")||"";return e("<a>").text(t).html()},hide:!0,items:"[title]:not([disabled])",position:{my:"left top+15",at:"left bottom",collision:"flipfit flip"},show:!0,tooltipClass:null,track:!1,close:null,open:null},_addDescribedBy:function(t,i){var s=(t.attr("aria-describedby")||"").split(/\s+/);s.push(i),t.data("ui-tooltip-id",i).attr("aria-describedby",e.trim(s.join(" ")))},_removeDescribedBy:function(t){var i=t.data("ui-tooltip-id"),s=(t.attr("aria-describedby")||"").split(/\s+/),n=e.inArray(i,s);-1!==n&&s.splice(n,1),t.removeData("ui-tooltip-id"),s=e.trim(s.join(" ")),s?t.attr("aria-describedby",s):t.removeAttr("aria-describedby")},_create:function(){this._on({mouseover:"open",focusin:"open"}),this.tooltips={},this.parents={},this.options.disabled&&this._disable(),this.liveRegion=e("<div>").attr({role:"log","aria-live":"assertive","aria-relevant":"additions"}).addClass("ui-helper-hidden-accessible").appendTo(this.document[0].body)},_setOption:function(t,i){var s=this;return"disabled"===t?(this[i?"_disable":"_enable"](),this.options[t]=i,void 0):(this._super(t,i),"content"===t&&e.each(this.tooltips,function(e,t){s._updateContent(t.element)}),void 0)},_disable:function(){var t=this;e.each(this.tooltips,function(i,s){var n=e.Event("blur");n.target=n.currentTarget=s.element[0],t.close(n,!0)}),this.element.find(this.options.items).addBack().each(function(){var t=e(this);t.is("[title]")&&t.data("ui-tooltip-title",t.attr("title")).removeAttr("title")})},_enable:function(){this.element.find(this.options.items).addBack().each(function(){var t=e(this);t.data("ui-tooltip-title")&&t.attr("title",t.data("ui-tooltip-title"))})},open:function(t){var i=this,s=e(t?t.target:this.element).closest(this.options.items);s.length&&!s.data("ui-tooltip-id")&&(s.attr("title")&&s.data("ui-tooltip-title",s.attr("title")),s.data("ui-tooltip-open",!0),t&&"mouseover"===t.type&&s.parents().each(function(){var t,s=e(this);s.data("ui-tooltip-open")&&(t=e.Event("blur"),t.target=t.currentTarget=this,i.close(t,!0)),s.attr("title")&&(s.uniqueId(),i.parents[this.id]={element:this,title:s.attr("title")},s.attr("title",""))}),this._updateContent(s,t))},_updateContent:function(e,t){var i,s=this.options.content,n=this,a=t?t.type:null;return"string"==typeof s?this._open(t,e,s):(i=s.call(e[0],function(i){e.data("ui-tooltip-open")&&n._delay(function(){t&&(t.type=a),this._open(t,e,i)})}),i&&this._open(t,e,i),void 0)},_open:function(t,i,s){function n(e){u.of=e,o.is(":hidden")||o.position(u)}var a,o,r,h,l,u=e.extend({},this.options.position);if(s){if(a=this._find(i))return a.tooltip.find(".ui-tooltip-content").html(s),void 0;i.is("[title]")&&(t&&"mouseover"===t.type?i.attr("title",""):i.removeAttr("title")),a=this._tooltip(i),o=a.tooltip,this._addDescribedBy(i,o.attr("id")),o.find(".ui-tooltip-content").html(s),this.liveRegion.children().hide(),s.clone?(l=s.clone(),l.removeAttr("id").find("[id]").removeAttr("id")):l=s,e("<div>").html(l).appendTo(this.liveRegion),this.options.track&&t&&/^mouse/.test(t.type)?(this._on(this.document,{mousemove:n}),n(t)):o.position(e.extend({of:i},this.options.position)),o.hide(),this._show(o,this.options.show),this.options.show&&this.options.show.delay&&(h=this.delayedShow=setInterval(function(){o.is(":visible")&&(n(u.of),clearInterval(h))},e.fx.interval)),this._trigger("open",t,{tooltip:o}),r={keyup:function(t){if(t.keyCode===e.ui.keyCode.ESCAPE){var s=e.Event(t);s.currentTarget=i[0],this.close(s,!0)}}},i[0]!==this.element[0]&&(r.remove=function(){this._removeTooltip(o)}),t&&"mouseover"!==t.type||(r.mouseleave="close"),t&&"focusin"!==t.type||(r.focusout="close"),this._on(!0,i,r)}},close:function(t){var i,s=this,n=e(t?t.currentTarget:this.element),a=this._find(n);a&&(i=a.tooltip,a.closing||(clearInterval(this.delayedShow),n.data("ui-tooltip-title")&&!n.attr("title")&&n.attr("title",n.data("ui-tooltip-title")),this._removeDescribedBy(n),a.hiding=!0,i.stop(!0),this._hide(i,this.options.hide,function(){s._removeTooltip(e(this))}),n.removeData("ui-tooltip-open"),this._off(n,"mouseleave focusout keyup"),n[0]!==this.element[0]&&this._off(n,"remove"),this._off(this.document,"mousemove"),t&&"mouseleave"===t.type&&e.each(this.parents,function(t,i){e(i.element).attr("title",i.title),delete s.parents[t]}),a.closing=!0,this._trigger("close",t,{tooltip:i}),a.hiding||(a.closing=!1)))},_tooltip:function(t){var i=e("<div>").attr("role","tooltip").addClass("ui-tooltip ui-widget ui-corner-all ui-widget-content "+(this.options.tooltipClass||"")),s=i.uniqueId().attr("id");return e("<div>").addClass("ui-tooltip-content").appendTo(i),i.appendTo(this.document[0].body),this.tooltips[s]={element:t,tooltip:i}},_find:function(e){var t=e.data("ui-tooltip-id");return t?this.tooltips[t]:null},_removeTooltip:function(e){e.remove(),delete this.tooltips[e.attr("id")]},_destroy:function(){var t=this;e.each(this.tooltips,function(i,s){var n=e.Event("blur"),a=s.element;n.target=n.currentTarget=a[0],t.close(n,!0),e("#"+i).remove(),a.data("ui-tooltip-title")&&(a.attr("title")||a.attr("title",a.data("ui-tooltip-title")),a.removeData("ui-tooltip-title"))}),this.liveRegion.remove()}})});[build]
build_number = 2.2.22.003233.1755007004
build_time = 1755007016
build_user = SYSTEM
build_host = DESKTOP-NVBGLM7
<?php

namespace cms_autoinstaller;
use \__appbase\utils;

include_once(__DIR__.'/lib/compat.functions.php');
include_once(\dirname(__FILE__, 2) . '/lib/classes/base/class.app.php');

class cms_install extends \__appbase\app
{
    private static $_instance;
    private $_archive;
    private $_dest_version;
    private $_dest_name;
    private $_dest_schema;
    private $_destdir;
    private $_custom_destdir;
    private $_nls;
    private $_orig_tz;
    private $_orig_error_level;
    private $_custom_tmpdir;

    public static function get_tmpdir()
    {
        // because phar uses tmpfile() we need to set the TMPDIR environment variable
        // with whatever directory we find.
        $config = self::get_instance()->get_config();
        return $config['tmpdir'];
    }

    private function fixup_tmpdir_environment()
    {
        // if the system temporary directory is not the same as the config temporary directory
        // then we attempt to putenv the TMPDIR environment variable
        // so that tmpfile() will work as it uses the system temporary directory which can read from environment variables
        $sys_tmpdir = null;
        if( \function_exists('sys_get_temp_dir') ) $sys_tmpdir = \rtrim(\sys_get_temp_dir(), '\\/');
        $config = $this->get_config();
        if((!$sys_tmpdir || !\is_dir($sys_tmpdir) || !\is_writable($sys_tmpdir)) && $sys_tmpdir != $config['tmpdir'] ) {
            @\putenv('TMPDIR=' . $config['tmpdir']);
            $try1 = \getenv('TMPDIR');
            if( $try1 != $config['tmpdir'] ) throw new \RuntimeException('Sorry, putenv does not work on this system, and your system temporary directory is not set properly.');
        }
    }
  
  /**
   * @throws \Exception
   */
  public function __construct()
    {
        parent::__construct(__FILE__);

        // initialize the session.
        $sess = \__appbase\session::get();
        $junk = $sess[__CLASS__]; // this is junk, but triggers session to start.

        // get the request
        $request = \__appbase\request::get();
        if( isset($request['clear']) ) {
            $sess->reset();
        }

        $config = $this->get_config();

        // setup autoload
        \spl_autoload_register(__NAMESPACE__ . '\cms_install::autoload');

        $this->fixup_tmpdir_environment();

        // setup smarty
        $smarty = \__appbase\smarty();
        $smarty->assign('APPNAME','cms_installer');
        $smarty->assign('config',$config);
        $smarty->assign('installer_version',$config['installer_version']);

        $fn = self::get_appdir() . '/build.ini';
        $build = null;
        if( \file_exists($fn) ) $build = \parse_ini_file($fn);
        if( isset($build['build_time']) ) $smarty->assign('build_time',$build['build_time']);
        if( isset($build['build_number']) ) $smarty->assign('build_number',$build['build_number']);

        // handle debug mode
        if( $config['debug'] ) {
            @\ini_set('display_errors', 1);
            @\error_reporting(\E_ALL);
            @\ini_set('error_log', \Phar::running(FALSE) . '/error.log');
        }

        if( $this->in_phar() && !$config['nobase'] ) {
            $base_href = $_SERVER['SCRIPT_NAME'];
            if( \__appbase\endswith($base_href,'.php') ) {
                $base_href = $base_href . '/';
                $smarty->assign('BASE_HREF',$base_href);
            }
        }

        // find our archive, copy it... and rename it securely.
        // we do this because phar data cannot read from a .tar.gz file that is already embedded within a phar
        // (some environments)
        $tmpdir = $this->get_tmpdir().'/m' . \md5(__FILE__ . \session_id());
        $src_archive = $config['archive'] ?? 'data/data.tar.gz';
        $src_archive = \dirname(__DIR__) . \DIRECTORY_SEPARATOR . $src_archive;
        if( !\file_exists($src_archive) ) throw new \RuntimeException('Could not find installation archive at ' . $src_archive);
        $dest_archive = $tmpdir . \DIRECTORY_SEPARATOR . "f" . \md5($src_archive . \session_id()) . '.tgz';
        $src_md5 = \md5_file($src_archive);

        for( $i = 0; $i < 2; $i++ ) {
            if( !\file_exists($dest_archive) ) {
              if(!@\mkdir($tmpdir, 0777, TRUE) && !\is_dir($tmpdir))
              {
                throw new \RuntimeException(\sprintf('Directory "%s" was not created', $tmpdir));
              }
                @\copy($src_archive, $dest_archive);
            }
            $dest_md5 = \md5_file($dest_archive);
            if( $src_md5 == $dest_md5 && \is_readable($dest_archive) ) { break; }
            @\unlink($dest_archive);
        }
        if(2 == $i) throw new \RuntimeException('Checksum of temporary archive does not match... copying/permissions problem');
        $this->_archive = $dest_archive;;

        // get version details (version we are installing)
        // if not in the session, save them there.
        if( isset($sess[__CLASS__.'version']) ) {
            $ver = $sess[__CLASS__.'version'];
            $this->_dest_version = $ver['version'];
            $this->_dest_name = $ver['version_name'];
            $this->_dest_schema = $ver['schema_version'];
        }
        else {
            $verfile = \dirname($src_archive) . '/version.php';
            if( !\is_file($verfile) ) throw new \RuntimeException('Could not find version file');
          
          /**
           * from version.php
           * @var array $CMS_VERSION
           * @var string $CMS_VERSION_NAME ,
           * @var string $CMS_SCHEMA_VERSION
           */
            include_once($verfile);
            $ver = ['version' => $CMS_VERSION, 'version_name' => $CMS_VERSION_NAME, 'schema_version' => $CMS_SCHEMA_VERSION];
            $sess[__CLASS__.'version'] = $ver;
            $this->_dest_version = $CMS_VERSION;
            $this->_dest_name = $CMS_VERSION_NAME;
            $this->_dest_schema = $CMS_SCHEMA_VERSION;
        }
    }

    static public function autoload($classname)
    {
        if( \__appbase\startswith($classname, 'cms_autoinstaller\\') ) $classname = \substr($classname, \strlen('cms_autoinstaller\\'));

        $dirs = [__DIR__, __DIR__ . '/base', __DIR__ . '/lib', __DIR__ . '/wizard'];
        foreach( $dirs as $dir ) {
            $fn = $dir."/class.$classname.php";
            if( \file_exists($fn) ) {
                include_once($fn);
                return;
            }
        }
    }

    protected function set_config_defaults()
    {
        $tmp = [ 'timezone' => null, 'tmpdir' => null, 'dest' => null, 'debug' => false, 'nofiles' => false, 'nobase' => false, 'lang' => null, 'verbose' => false ];
        $config = \array_merge(parent::get_config(), $tmp);
        $this->_orig_tz = $config['timezone'] = @\date_default_timezone_get();
        if( !$this->_orig_tz ) $this->_orig_tz = $config['timezone'] = 'UTC';
        $config['dest'] = \realpath(\getcwd());
        return $config;
    }

    protected function load_config()
    {
        // setup some defaults
        $config = $this->set_config_defaults();

        // override default config with config file
        $config_file = \realpath(\getcwd()) . '/custom_config.ini';
        if(\is_file($config_file) && \is_readable($config_file) ) {
            $tmp = \parse_ini_file($config_file);
            if(\is_array($tmp) && \count($tmp) ) {
                $config = \array_merge($config, $tmp);
                if( isset($tmp['dest']) ) $this->_custom_destdir = $tmp['dest'];
            }
        }

        // override current config with url params
        $request = \__appbase\request::get();
        $list = [ 'TMPDIR', 'tmpdir', 'timezone', 'tz', 'dest', 'destdir', 'debug', 'nofiles', 'no_files', 'nobase' ];
        foreach( $list as $key ) {
	    if( !isset($request[$key]) ) continue;
            $val = $request[$key];
            switch( $key ) {
            case 'TMPDIR':
            case 'tmpdir':
                $config['tmpdir'] = \trim($val);
                break;
            case 'timezone':
            case 'tz':
                $config['timezone'] = \trim($val);
                break;
            case 'dest':
            case 'destdir':
              $this->_custom_destdir = $config['dest'] = \trim($val);
                break;
            case 'debug':
                $config['debug'] = utils::to_bool($val);
                break;
            case 'nobase':
                $config['nobase'] = utils::to_bool($val);
                break;
            case 'nofiles':
            case 'no_files':
                $config['nofiles'] = utils::to_bool($val);
                break;
            }
        }
        return $config;
    }

    protected function check_config($config)
    {
        foreach( $config as $key => $val ) {
            switch( $key ) {
            case 'tmpdir':
                if( !$val ) {
                    // no tmpdir set... gotta find or create one.
                    $val = parent::get_tmpdir();
                }
                if(!\is_dir($val) || !\is_writable($val) ) {
                    // could not find a valid system temporary directory, or none specified. gotta make one
                    $dir = \realpath(\getcwd()) . '/__m' . \md5(\session_id());
                    if(!@\is_dir($dir) && !\mkdir($dir) && !\is_dir($dir)) throw new \RuntimeException('Sorry, problem determining a temporary directory, non specified, and we could not create one.');
                    $txt = 'This is temporary directory created for installing CMSMS in punitively restrictive environments.  You may delete this directory and its files once installation is complete.';
                    if( !@file_put_contents($dir.'/__cmsms',$txt) ) throw new \RuntimeException('We could not create a file in the temporary directory we just created (is safe mode on?).');
                    $config[$key] = $dir;
                    $this->_custom_tmpdir = $dir;
                    $val = $dir;
                }
                $config[$key] = $val;
                break;
            case 'dest':
                if(!\is_dir($val) || !\is_writable($val) ) {
                    throw new \RuntimeException('Invalid config value for '.$key.' - not a directory, or not writable');
                }
                break;
              case 'nobase':
              case 'nofiles':
              case 'debug':
              case 'timezone':
                // do nothing
              break;
            }
        }
        return $config;
    }

    public function get_config()
    {
        $sess = \__appbase\session::get();
        if( isset($sess['config']) ) {
            // already set once... so you must close and re-open the browser to reset it.
            return $sess['config'];
        }

        // gotta load the config, then store it in the session
        $config = $this->load_config();
        $config = $this->check_config($config);
        $sess['config'] = $config;
        return $config;
    }

    private function set_config_val($key,$val)
    {
        $config            = $this->get_config();
      $config[\trim($key)] = $val;

        $sess = \__appbase\session::get();
        $sess['config'] = $config;
    }


    public function get_orig_error_level() { return $this->_orig_error_level; }

    public function get_orig_tz() { return $this->_orig_tz; }

    public function get_destdir() {
        $config = $this->get_config();
        return $config['dest'];
    }

    public function set_destdir($destdir) {
        $this->set_config_val('dest',$destdir);
    }

    public function has_custom_destdir() {
        $p1 = \realpath((string)\getcwd());
        $p2 = \realpath((string)$this->_custom_destdir);
        return ($p1 !== $p2);
    }

    public function get_archive() { return $this->_archive; }

    public function get_dest_version() { return $this->_dest_version; }

    public function get_dest_name() { return $this->_dest_name; }

    public function get_dest_schema() { return $this->_dest_schema; }

    public function get_phar()
    {
        return \Phar::running();
    }

    public function in_phar() {
        $x = $this->get_phar();
        if( !$x ) return FALSE;
        return TRUE;
    }

    public function get_nls()
    {
        if( \is_array($this->_nls) ) return $this->_nls;

        $archive = $this->get_archive();
        $archive = \str_replace('\\', '/', $archive); // for windows
        if( !\file_exists($archive) ) throw new \Exception(\__appbase\lang('error_noarchive'));

        $phardata = new \PharData($archive);
        $nls = [];
        $found = false;
        $pharprefix = "phar://".$archive;
        foreach( new \RecursiveIteratorIterator($phardata) as $file => $it ) {
            if(FALSE === ($p = \strpos($file, '/lib/nls'))) continue;
            $tmp = \substr($file, $p);
            if( !\__appbase\endswith($tmp,'.php') ) continue;
            $found = true;
            if( \preg_match('/\.nls\.php$/', $tmp) ) {
               $tmpdir = $this->get_tmpdir();
               $fn = "$tmpdir/tmp_" . \basename($file);
               @\copy($file, $fn);
               include($fn);
               \unlink($fn);
            }
        }
        if( !$found ) throw new \RuntimeException(\__appbase\lang('error_nlsnotfound'));
        $this->_nls = $nls;
        return $nls;
    }

    public function get_language_list()
    {
        $this->get_nls();
        return $this->_nls['language'];
    }

    public function get_root_url()
    {
        $prefix = null;
        //if( isset($_SERVER['HTTPS']) && !empty($_SERVER['HTTPS']) && strtolower($_SERVER['HTTPS']) != 'off' ) $prefix = 'https';
        $prefix .= '//'.$_SERVER['HTTP_HOST'];

        // if we are putting files somewhere else, we cannot determine the root url of the site
        // via the $_SERVER variables.
        $b = $this->get_destdir();
        if($b != \getcwd() ) {
            if( \__appbase\startswith($b,$_SERVER['DOCUMENT_ROOT']) ) $b = \substr($b, \strlen($_SERVER['DOCUMENT_ROOT']));
            $b = \str_replace('\\', '/', $b); // for windows
            if( !\__appbase\endswith($prefix,'/') && !\__appbase\startswith($b,'/') ) $prefix .= '/';
            return $prefix.$b;
        }

        $b = \dirname($_SERVER['PHP_SELF']);
        if( $this->in_phar() ) {
            $tmp = \basename($_SERVER['SCRIPT_NAME']);
            if(FALSE !== ($p = \strpos($b, $tmp))) $b = \substr($b, 0, $p);
        }

        $b = \str_replace('\\', '/', $b); // cuz windows blows.
        if( !\__appbase\endswith($prefix,'/') && !\__appbase\startswith($b,'/') ) $prefix .= '/';
        return $prefix.$b;
    }
  
  /**
   * @throws \SmartyException
   * @throws \__appbase\langtools_Exception
   */
  public function run()
    {
        // set the languages we're going to support.
        $list = \__appbase\nls()->get_list();
        foreach( $list as &$one ) $one = \substr($one, 0, -4);
        \__appbase\translator()->set_allowed_languages($list);

        // the default language.
        \__appbase\translator()->set_default_language('en_US');

        // get the language preferred by the user (either in the request, in a cookie, or in the session)
        $lang = \__appbase\translator()->get_selected_language();

        if( !$lang ) $lang = \__appbase\translator()->get_default_language(); // get a preferred language

        // set our selected language...
        \__appbase\translator()->set_selected_language($lang);

        // for every request we're gonna make sure it's not cached.
        //session_cache_limiter('private');

        // and make sure we are in UTF-8
        \header('Content-Type:text/html; charset=UTF-8');

        // and do our stuff.
        try {
            $tmp = 'm' . \substr(\md5(\realpath(\getcwd()) . \session_id()), 0, 8);
            $wizard = \__appbase\wizard::get_instance(__DIR__.'/wizard','\cms_autoinstaller');
            // this sets a custom step variable for each instance
            // which is just one more security measure.
            // nobody can guess an installer URL and jump to a specific step to
            // nuke anything (even though database creds are stored in the session
            // so are all the other parameters.
            $wizard->set_step_var($tmp);
            $res = $wizard->process();
        }
        catch( \Exception $e ) {
            $smarty = \__appbase\smarty();
            $smarty->assign('error',$e->GetMessage());
            $smarty->display('error.tpl');
        }
    }

    public function cleanup()
    {
        if( $this->_custom_tmpdir ) {
            utils::rrmdir($this->_custom_tmpdir);
        }
    }
} // end of class
<?php
die('not implemented');
?>[main]
installer_version = '1.4.3';
min_upgrade_version = '1.12'
archive = 'data/data.tar.gz'
dbtype = 'mysqli'
dbhost = 'localhost'
dbprefix = 'cms_'
install_excludes = '/find-mime$/||/scripts\/.*$/||/\/svn.*/||/\/tests\/.*/||/\/build\/.*/||/\/tmp\/.*/'
<?php
global $admin_user;

status_msg(ilang('install_requireddata'));

$query = 'INSERT INTO '.CMS_DB_PREFIX.'version VALUES (202)';
$db->Execute($query);
verbose_msg(ilang('install_setschemaver'));

//
// site preferences
//
verbose_msg(ilang('install_initsiteprefs'));
cms_siteprefs::set('sitedownmessage','<p>Site is currently down for maintenance</p>');
cms_siteprefs::set('metadata',"<meta name=\"Generator\" content=\"CMS Made Simple - Copyright (C) 2004-" . date('Y') . ". All rights reserved.\" />\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\r\n");
cms_siteprefs::set('global_umask','022');
cms_siteprefs::set('auto_clear_cache_age',60); // cache files for only 60 days by default
cms_siteprefs::set('adminlog_lifetime',3600*24*31); // admin log entries only live for 60 days.
cms_siteprefs::set('allow_browser_cache',1); // allow browser to cache cachable pages
cms_siteprefs::set('browser_cache_expiry',60); // browser can cache pages for 60 minutes.

//
// permissions
//
verbose_msg(ilang('install_initsiteperms'));
$all_perms = array();
$perms = array('Add Pages','Manage Groups','Add Templates','Manage Users','Modify Any Page',
	       'Modify Permissions','Modify Templates','Remove Pages',
	       'Modify Modules','Modify Files','Modify Site Preferences',
	       'Manage Stylesheets','Manage Designs','Modify User-defined Tags','Clear Admin Log',
	       'Modify Events','View Tag Help','Manage All Content','Reorder Content','Manage My Settings',
               'Manage My Account', 'Manage My Bookmarks');
foreach( $perms as $one_perm ) {
  $permission = new CmsPermission();
  $permission->source = 'Core';
  $permission->name = $one_perm;
  $permission->text = $one_perm;
  $permission->save();
  $all_perms[$one_perm] = $permission;
}

//
// initial groups
//
verbose_msg(ilang('install_initsitegroups'));
$admin_group = new Group();
$admin_group->name = 'Admin';
$admin_group->description = 'Members of this group can manage the entire site.';
$admin_group->active = 1;
$admin_group->Save();

$editor_group = new Group();
$editor_group->name = 'Editor';
$editor_group->description = 'Members of this group can manage content';
$editor_group->active = 1;
$editor_group->Save();
$editor_group->GrantPermission('Manage All Content');
$editor_group->GrantPermission('Manage My Account');
$editor_group->GrantPermission('Manage My Settings');
$editor_group->GrantPermission('Manage My Bookmarks');

$designer_group = new Group();
$designer_group->name = 'Designer';
$designer_group->description = 'Members of this group can manage stylesheets, templates, and content';
$designer_group->active = 1;
$designer_group->Save();
$designer_group->GrantPermission('Add Templates');
$designer_group->GrantPermission('Manage Designs');
$designer_group->GrantPermission('Modify Templates');
$designer_group->GrantPermission('Manage Stylesheets');
$designer_group->GrantPermission('Manage All Content');
$designer_group->GrantPermission('Manage My Account');
$designer_group->GrantPermission('Manage My Settings');
$designer_group->GrantPermission('Manage My Bookmarks');
$designer_group->GrantPermission('Modify Files');
$designer_group->GrantPermission('Modify User-defined Tags');

//
// initial user account
//
verbose_msg(ilang('install_initsiteusers'));
$sitemask = cms_siteprefs::get('sitemask');
$admin_user = new User;
$admin_user->username = $adminaccount['username'];
if( isset($adminaccount['emailaddr']) && $adminaccount['emailaddr'] ) $admin_user->email = $adminaccount['emailaddr'];
$admin_user->active = 1;
$admin_user->adminaccess = 1;
$admin_user->password = md5($sitemask.$adminaccount['password']);
$admin_user->Save();
UserOperations::get_instance()->AddMemberGroup($admin_user->id,$admin_group->id);
cms_userprefs::set_for_user($admin_user->id,'wysiwyg','MicroTiny'); // the one, and only user preference we need.

//
// User Tags
//
verbose_msg(ilang('install_initsiteusertags'));
UserTagOperations::get_instance()->SetUserTag('user_agent',
  "//Code to show the users user agent information.
echo \$_SERVER['HTTP_USER_AGENT'];",
  'Code to show the user\'s user agent information');

$txt = <<<EOT
//set start to date your site was published\n\$startCopyRight='2004';\n\n// check if start year is this year\nif(date('Y') == \$startCopyRight){\n// it was, just print this year\n    echo \$startCopyRight;\n}else{\n// it wasnt, print startyear and this year delimited with a dash\n    echo \$startCopyRight.'-'. date('Y');\n}
EOT;
UserTagOperations::get_instance()->SetUserTag('custom_copyright',$txt,'Code to output copyright information');

//
// Events
//
verbose_msg(ilang('install_initevents'));
Events::CreateEvent('Core','LoginPost');
Events::CreateEvent('Core','LogoutPost');
Events::CreateEvent('Core','LoginFailed');
Events::CreateEvent('Core','LostPassword');
Events::CreateEvent('Core','LostPasswordReset');

Events::CreateEvent('Core','AddUserPre');
Events::CreateEvent('Core','AddUserPost');
Events::CreateEvent('Core','EditUserPre');
Events::CreateEvent('Core','EditUserPost');
Events::CreateEvent('Core','DeleteUserPre');
Events::CreateEvent('Core','DeleteUserPost');
Events::CreateEvent('Core','AddGroupPre');
Events::CreateEvent('Core','AddGroupPost');
Events::CreateEvent('Core','EditGroupPre');
Events::CreateEvent('Core','EditGroupPost');
Events::CreateEvent('Core','DeleteGroupPre');
Events::CreateEvent('Core','DeleteGroupPost');

Events::CreateEvent('Core','AddStylesheetPre');
Events::CreateEvent('Core','AddStylesheetPost');
Events::CreateEvent('Core','EditStylesheetPre');
Events::CreateEvent('Core','EditStylesheetPost');
Events::CreateEvent('Core','DeleteStylesheetPre');
Events::CreateEvent('Core','DeleteStylesheetPost');
Events::CreateEvent('Core','AddTemplatePre');
Events::CreateEvent('Core','AddTemplatePost');
Events::CreateEvent('Core','EditTemplatePre');

Events::CreateEvent('Core','EditTemplatePost');
Events::CreateEvent('Core','DeleteTemplatePre');
Events::CreateEvent('Core','DeleteTemplatePost');
Events::CreateEvent('Core','AddTemplateTypePre');
Events::CreateEvent('Core','AddTemplateTypePost');
Events::CreateEvent('Core','EditTemplateTypePre');
Events::CreateEvent('Core','EditTemplateTypePost');
Events::CreateEvent('Core','DeleteTemplateTypePre');
Events::CreateEvent('Core','DeleteTemplateTypePost');
Events::CreateEvent('Core','AddDesignPre');
Events::CreateEvent('Core','AddDesignPost');
Events::CreateEvent('Core','EditDesignPre');
Events::CreateEvent('Core','EditDesignPost');
Events::CreateEvent('Core','DeleteDesignPre');
Events::CreateEvent('Core','DeleteDesignPost');

Events::CreateEvent('Core','TemplatePreCompile');
Events::CreateEvent('Core','TemplatePreFetch');
Events::CreateEvent('Core','TemplatePostCompile');

Events::CreateEvent('Core','ContentEditPre');
Events::CreateEvent('Core','ContentEditPost');
Events::CreateEvent('Core','ContentDeletePre');
Events::CreateEvent('Core','ContentDeletePost');

Events::CreateEvent('Core','AddUserDefinedTagPre');
Events::CreateEvent('Core','AddUserDefinedTagPost');
Events::CreateEvent('Core','EditUserDefinedTagPre');
Events::CreateEvent('Core','EditUserDefinedTagPost');
Events::CreateEvent('Core','DeleteUserDefinedTagPre');
Events::CreateEvent('Core','DeleteUserDefinedTagPost');

Events::CreateEvent('Core','ModuleInstalled');
Events::CreateEvent('Core','ModuleUninstalled');
Events::CreateEvent('Core','ModuleUpgraded');
Events::CreateEvent('Core','ContentPreCompile');
Events::CreateEvent('Core','ContentPostCompile');
Events::CreateEvent('Core','ContentPreRender'); // 2.2
Events::CreateEvent('Core','ContentPostRender');
Events::CreateEvent('Core','SmartyPreCompile');
Events::CreateEvent('Core','SmartyPostCompile');
Events::CreateEvent('Core','ChangeGroupAssignPre');
Events::CreateEvent('Core','ChangeGroupAssignPost');
Events::CreateEvent('Core','StylesheetPreCompile');
Events::CreateEvent('Core','StylesheetPostCompile');
Events::CreateEvent('Core','StylesheetPostRender');

$create_private_dir = function($relative_dir) {
    $app = \__appbase\get_app();
    $destdir = $app->get_destdir();
    $relative_dir = trim($relative_dir);
    if( !$relative_dir ) return;

    $dir = $destdir.'/'.$relative_dir;
    if( !is_dir($dir) ) {
        @mkdir($dir,0777,true);
    }
    @touch($dir.'/index.html');
};

/*
$move_directory_files = function($srcdir,$destdir) {
    $srcdir = trim($srcdir);
    $destdir = trim($destdir);
    if( !is_dir($srcdir) ) return;

    $files = glob($srcdir.'/*');
    if( !count($files) ) return;

    foreach( $files as $src ) {
        $bn = basename($src);
        $dest = $destdir.'/'.$bn;
        rename($src,$dest);
    }
    @touch($dir.'/index.html');
};
*/

// create the assets directory structure
verbose_msg(ilang('install_createassets'));
$create_private_dir('assets/templates');
$create_private_dir('assets/configs');
$create_private_dir('assets/admin_custom');
$create_private_dir('assets/module_custom');
$create_private_dir('assets/plugins');
$create_private_dir('assets/images');
$create_private_dir('assets/css');
<?php

if (isset($CMS_INSTALL_CREATE_TABLES)) {
    $table_ids = array(
        'additional_users'          => array('id' => 'additional_users_id'),
        'admin_bookmarks'           => array('id' => 'bookmark_id'),
        'content'                   => array('id' => 'content_id'),
        'content_props'             => array('id' => 'content_id'),
        'events'                    => array('id' => 'event_id'),
        'event_handlers'            => array('id' => 'handler_id', 'seq' => 'event_handler_seq'),
        'group_perms'               => array('id' => 'group_perm_id'),
        'groups'                    => array('id' => 'group_id'),
        'users'                     => array('id' => 'user_id'),
        'userplugins'               => array('id' => 'userplugin_id'),
        'permissions'               => array('id' => 'permission_id')
    );

    status_msg(ilang('install_update_sequences'));
    foreach ($table_ids as $tablename => $tableinfo)
    {
        $sql = 'SELECT COALESCE(MAX(?),0) AS maxid FROM '.CMS_DB_PREFIX.$tablename;
        $max = $db->GetOne($sql,array($tableinfo['id']));
        $tableinfo['seq'] = isset($tableinfo['seq']) ? $tableinfo['seq'] : $tablename . '_seq';
        verbose_msg(ilang('install_updateseq',$tableinfo['seq']));
        $db->CreateSequence(CMS_DB_PREFIX.$tableinfo['seq'], $max);
    }
}

# vim:ts=4 sw=4 noet
?>
<?php
global $admin_user;

//
// Themes
//

// minimal theme has the minimal template, and no stylesheets.
verbose_msg(ilang('install_default_collections'));

$minimal_theme = new CmsLayoutCollection();
$minimal_theme->set_name('Minimal');  // id = 19
$minimal_theme->set_description('Minimal templates and stylesheets');
$minimal_theme->save();

$simplex_theme = new CmsLayoutCollection();
$simplex_theme->set_name('Simplex');
$simplex_theme->set_description('Simplex Template is a HTML5 based theme, introduced with CMSMS 1.11 release and improved with 2.0 release.
Purpose of this theme is to demonstrate what and how can be done with CMSMS Templates using HTML5 and responsive CSS for a better mobile experience.
All Smarty templates which are used by Simplex Theme are prefix with "Simplex", therefore be careful when renaming or deleting these templates.
Theme itself is using jQuery, which is included with {cms_jquery} tag, the functions JavaScript file is minified, in case you wish to change some JavaScript functions, refer to /uploads/simplex/js/functions.js file and replace functions.min.js file.');
$simplex_theme->set_default(TRUE);
$simplex_theme->save();

$css_menuleft_1col_theme = new CmsLayoutCollection();
$css_menuleft_1col_theme->set_name('CSSMenu left + 1 column');
$css_menuleft_1col_theme->set_description('This is basically the same as the last one, CSSMenu top + 2 column, with the menu on the left instead of across the top there isn\'t a whole lot to say about it.');
$css_menuleft_1col_theme->save();

$css_menutop_2col_theme = new CmsLayoutCollection();
$css_menutop_2col_theme->set_name('CSSMenu top + 2 columns');
$css_menutop_2col_theme->set_description('This is a drop-down menu that is using only CSS (although some Javascript is required for Internet Explorer 6, note: IE6 will not let you use 2 of these menu types in a template at the same time as the second one will fail to open). It can be either vertical or horizontal.');
$css_menutop_2col_theme->save();

$leftsimple_1col_theme = new CmsLayoutCollection();
$leftsimple_1col_theme->set_name('Left simple navigation + 1 column');
$leftsimple_1col_theme->set_description('This template has the menu in left sidebar. The menu is using the Simple Navigation menu template. It is styled in the stylesheet called Navigation Simple - Vertical.');
$leftsimple_1col_theme->save();

$ncleanblue_theme = new CmsLayoutCollection();
$ncleanblue_theme->set_name('NCleanBlue');
$ncleanblue_theme->set_description('This one is using a new menu template so we can style the drop down for the children pages, using an image for the second ul going from the top down, it has an extra li at the bottom of the child pages ul <li class="separator once" style="list-style-type: none;">&nbsp; </li> this is used to hold the bottom image.');
$ncleanblue_theme->save();

$shadowmenu_left_1col_theme = new CmsLayoutCollection();
$shadowmenu_left_1col_theme->set_name('ShadowMenu left + 1 column');
$shadowmenu_left_1col_theme->set_description('Using the same menu template as the previous theme. We changed the child ul CSS to use a different top image. This involves changing some of the margin and padding as the images are a different shape. Note the difference in the second level and third level ul images, one has an arrow up and the other has an arrow left.');
$shadowmenu_left_1col_theme->save();

$shadowmenu_tab_2col_theme = new CmsLayoutCollection();
$shadowmenu_tab_2col_theme->set_name('ShadowMenu Tab + 2 columns');
$shadowmenu_tab_2col_theme->set_description('Using the same menu template as the previous theme. We changed the child ul CSS to use a different top image. This involves changing some of the margin and padding as the images are a different shape. Note the difference in the second level and third level ul images, one has an arrow up and the other has an arrow left.');
$shadowmenu_tab_2col_theme->save();

$topsimple_leftsubnav_1col_theme = new CmsLayoutCollection();
$topsimple_leftsubnav_1col_theme->set_name('Top simple navigation + left subnavigation + 1 column');
$topsimple_leftsubnav_1col_theme->set_description('With the Menu Manager you can easily split the navigation in two parts. On this page the top level in the page hierarchy is displayed horizontally and depending on what page is displayed a localized sub-menu is displayed vertically to the left.');
$topsimple_leftsubnav_1col_theme->save();


//
// Types
//
verbose_msg(ilang('install_templatetypes'));
$page_template_type = new CmsLayoutTemplateType();
$page_template_type->set_originator(CmsLayoutTemplateType::CORE);
$page_template_type->set_name('page');
$page_template_type->set_dflt_flag(TRUE);
$page_template_type->set_lang_callback('CmsTemplateResource::page_type_lang_callback');
$page_template_type->set_content_callback('CmsTemplateResource::reset_page_type_defaults');
$page_template_type->reset_content_to_factory();
$page_template_type->set_content_block_flag(TRUE);
$page_template_type->set_help_callback('CmsTemplateResource::template_help_callback');
$page_template_type->save();

$gcb_template_type = new CmsLayoutTemplateType();
$gcb_template_type->set_originator(CmsLayoutTemplateType::CORE);
$gcb_template_type->set_name('generic');
$gcb_template_type->set_lang_callback('CmsTemplateResource::generic_type_lang_callback');
$gcb_template_type->set_help_callback('CmsTemplateResource::template_help_callback');
$gcb_template_type->save();


//
// Template Categories
//


//
// Templates
//
$template_list = array();

verbose_msg(ilang('install_templates'));
$gcb = new CmsLayoutTemplate();
$gcb->set_name('footer');
$gcb->set_type($gcb_template_type);
$gcb->set_owner(1);
$gcb->set_content("<p>&copy; Copyright {custom_copyright} - CMS Made Simple<br />\r\nThis site is powered by <a class=\"external\" href=\"http://www.cmsmadesimple.org\">CMS Made Simple</a> version {cms_version}</p>");
$gcb->save();

$css_menuleft_1col_theme->add_template($gcb);
$css_menutop_2col_theme->add_template($gcb);
$leftsimple_1col_theme->add_template($gcb);
$ncleanblue_theme->add_template($gcb);
$shadowmenu_left_1col_theme->add_template($gcb);
$shadowmenu_tab_2col_theme->add_template($gcb);
$topsimple_leftsubnav_1col_theme->add_template($gcb);
$template_list[$gcb->get_name()] = $gcb->get_id();

$txt = <<<EOT
{process_pagedata}\n<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"\n"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n\n<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">\n{* Change lang="en" to the language of your site *}\n\n<head>\n\n<title>{sitename} - {title}</title>\n{* The sitename is changed in Site Admin/Global settings. {title} is the name of each page *}\n\n{metadata}\n{* Don\'t remove this! Metadata is entered in Site Admin/Global settings. *}\n\n{cms_stylesheet}\n{* This is how all the stylesheets attached to this template are linked to *}\n\n</head>\n\n<body>\n\n      {* Start Navigation *}\n      <div style="float: left; width: 25%;">\n         {Navigator loadprops=0 template='minimal_menu'}\n      </div>\n      {* End Navigation *}\n\n      {* Start Content *}\n      <div>\n         <h2>{title}</h2>\n         {content} \n      </div>\n      {* End Content *}\n\n</body>\n</html>
EOT;
$template = new CmsLayoutTemplate();
$template->set_name('Minimal');
$template->set_owner(1);
$template->set_content($txt);
$template->set_description('A Simple, minimal page template');
$template->set_type($page_template_type);
$template->add_design($minimal_theme);
$template->save();
$template_list[$template->get_name()] = $template->get_id();

$txt = <<<EOT
{process_pagedata}<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">\n{* Change lang="en" to the language of your site *}\n\n{* note: anything inside these are smarty comments, they will not show up in the page source *}\n  <head>\n    <title>{sitename} - {title}</title>\n{* The sitename is changed in Site Admin/Global settings. {title} is the name of each page *}\n\n {metadata}\n{* Don't remove this! Metadata is entered in Site Admin/Global settings. *}\n\n {cms_stylesheet}\n{* This is how all the stylesheets attached to this template are linked to it *}\n\n {cms_selflink dir="start" rellink=1}\n {cms_selflink dir="prev" rellink=1}\n {cms_selflink dir="next" rellink=1}\n{* Relational links for interconnections between pages, good for accessibility and Search Engine Optimization *}\n\n{* the literal below and the /literal at the end are needed whenever there are {"curly brackets"} as smarty will think it's something to process and will throw an error *}\n {literal}\n<script type="text/JavaScript">\n<!--\n//pass min and max - measured against window width\nfunction P7_MinMaxW(a,b){\nvar nw="auto",w=document.documentElement.clientWidth;\nif(w>=b){nw=b+"px";}if(w<=a){nw=a+"px";}return nw;\n}\n//-->\n</script>\n    <!--[if lte IE 6]>\n    <style type="text/css">\n    #pagewrapper {width:expression(P7_MinMaxW(720,950));}\n    #container {height: 1%;}\n    </style>\n    <![endif]-->\n    {/literal}\n{* The min and max page width for Internet Explorer is set here. For other browsers it's in the stylesheet "Layout Top menu + 2 columns" *}\n\n    <!--[if lte IE 6]>\n    <script type="text/javascript" src="modules/MenuManager/CSSMenu.js"></script>\n    <![endif]--> \n{* The above JavaScript is required for CSSMenu to work in IE *}\n\n  </head>\n  <body>\n    <div id="pagewrapper">\n{* first out side div/box *}\n\n{* start accessibility skip links, anything with the class of accessibility is hidden with CSS from visual browsers *}\n      <ul class="accessibility">\n        <li>{anchor anchor='menu_vert' title='Skip to navigation' accesskey='n' text='Skip to navigation'}</li>\n        <li>{anchor anchor='main' title='Skip to content' accesskey='s' text='Skip to content'}</li>\n      </ul>\n{* end accessibility skip links *}\n\n      <hr class="accessibility" />\n{* anything class="accessibility" is hidden for visual browsers by CSS *}\n\n{* Start Header, with logo image that links to the default start page. Logo image is changed in the stylesheet  "Layout Left sidebar + 1 column" *}\n      <div id="header">\n\n{* this holds the name of the site on the right side *}\n        <h2 class="headright">{sitename}</h2>\n\n{* a link back to home page and the header left image/logo, text is hidden using CSS *}\n        <h1>{cms_selflink dir="start" text="\$sitename"}</h1>        \n        <hr class="accessibility" />\n      </div>\n{* End Header *}\n\n{* Start Search, the input "Submit" is using an image, CSS: input.search-button *}\n      <div id="search">\n      {Search}\n      </div>\n{* End Search *}\n\n{* Start Breadcrumbs *}\n      <div class="crbk">\n{* holds the right image, we need 2 divs to be able to make this site fluid, if it was fixed width we could use one div, one image  *}\n\n        <div class="breadcrumbs">\n        {nav_breadcrumbs root='Home'}\n          <hr class="accessibility" />\n        </div>\n      </div>\n{* End Breadcrumbs *}\n\n{* Start Content (Navigation and Content columns) *}\n      <div id="content">\n\n{* Start Sidebar, 2 divs one for top image one for bottom image *}\n        <div id="sidebar">\n          <div id="sidebara">\n\n{* Start Navigation, stylesheet  "Navigation CSSMenu - Vertical" *}\n            <h2 class="accessibility">Navigation</h2>\n            {Navigator loadprops=0 template='cssmenu'}\n            <hr class="accessibility" />\n{* End Navigation *}\n\n{* Start News, stylesheet  "Module News" *}\n            <div id="news">\n              <h2>News</h2>\n              {module_available module='News' assign='havenews'}{if \$havenews}EOT{cms_module module=News number='3' detailpage='news'}{/if} {* You cannot use the short form of the module call, i.e: {News} in this type of expression *}\n            </div>\n{* End News *}\n\n          </div>\n        </div>\n{* End Sidebar *}\n\n{* Start Content Area, the back1, back2, back3, hold the 3 outside images, main holds the 4th one, to make the box complete, if the template were fixed width not fluid we could use just 2 divs and 2 images, 1 top 1 bottom *}\n        <div class="back1">\n          <div class="back2">\n            <div class="back3">\n              <div id="main">\n                <h2>{title}</h2>\n                {content}\n                <br />{* to insure space below the content *}\n\n{* Start relational links *}\n{* note this is the right side, when you float: divs you need to have float: right; divs first *}\n            <div class="right49">\n              <p>{anchor anchor='main' text='^ Top'}</p>\n            </div>\n\n            <div class="left49">\n              <p> {cms_selflink dir="previous"}\n{* The label parameter doesn't need to be there if you're using English, but is here to show how it's used if you don't want the English text "Previous page" *}\n              <br />\n              {cms_selflink dir="next"}\n              </p>\n            </div>\n{* End relational links *}\n\n                <hr class="accessibility" />\n                <div class="clear">\n                </div>\n              </div>\n            </div>\n          </div>\n        </div>\n{* End Content Area *}\n\n      </div>\n{* End Content *}\n\n{* Start Footer. Edit the footer in the Global Content Block called "footer" *}\n      <div class="footback">\n        <div id="footer">\n{* stylesheet  "Navigation FatFootMenu" *}\n          <div id="fooleft">\n          {Navigator loadprops=0}\n          </div>\n          <div id="footrt">\n          {global_content name='footer'}\n          </div>\n          <div class="clear"></div>\n        </div>\n      </div>\n{* End Footer *}\n\n    </div>\n{* end pagewrapper *}\n  </body>\n</html>
EOT;
$template = new CmsLayoutTemplate();
$template->set_name('CSSMenu left + 1 column'); // id = 15
$template->set_owner(1);
$template->set_content($txt);
$template->set_description('This is a drop-down menu that is using only CSS (although some Javascript is required for Internet Explorer 6, note: IE6 will not let you use 2 of these menu types in a template at the same time as the second one will fail to open). It can be either vertical or horizontal.');
$template->set_type($page_template_type);
$template->save();
$css_menuleft_1col_theme->add_template($template);
$template_list[$template->get_name()] = $template->get_id();

$txt = <<<EOT
{process_pagedata}<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">\n{* Change lang="en" to the language of your site *}\n\n{* note: anything inside these are smarty comments, they will not show up in the page source *}\n\n  <head>\n    <title>{sitename} - {title}</title>\n{* The sitename is changed in Site Admin/Global settings. {title} is the name of each page *}\n\n {metadata}\n{* Don't remove this! Metadata is entered in Site Admin/Global settings. *}\n\n {cms_stylesheet}\n{* This is how all the stylesheets attached to this template are linked to it *}\n\n {cms_selflink dir="start" rellink=1}\n {cms_selflink dir="prev" rellink=1}\n {cms_selflink dir="next" rellink=1}\n{* Relational links for interconnections between pages, good for accessibility and Search Engine Optimization *}\n\n{* the literal below and the /literal at the end are needed whenever there are {"curly brackets"} as smarty will think it's something to process and will throw an error *}\n {literal}\n<script type="text/JavaScript">\n<!--\n//pass min and max - measured against window width\nfunction P7_MinMaxW(a,b){\nvar nw="auto",w=document.documentElement.clientWidth;\nif(w>=b){nw=b+"px";}if(w<=a){nw=a+"px";}return nw;\n}\n//-->\n</script>\n    <!--[if lte IE 6]>\n    <style type="text/css">\n    #pagewrapper {width:expression(P7_MinMaxW(720,950));}\n    #container {height: 1%;}\n    </style>\n    <![endif]-->\n    {/literal}\n{* The min and max page width for Internet Explorer is set here. For other browsers it's in the stylesheet "Layout Top menu + 2 columns" *}\n\n    <!--[if lte IE 6]>\n    <script type="text/javascript" src="modules/MenuManager/CSSMenu.js"></script>\n    <![endif]--> \n{* The above JavaScript is required for CSSMenu to work in IE *}\n  </head>\n  <body>\n    <div id="pagewrapper">\n\n{* start accessibility skip links, anything with the class of accessibility is hidden with CSS from visual browsers *}\n      <ul class="accessibility">\n        <li>{anchor anchor='menu_vert' title='Skip to navigation' accesskey='n' text='Skip to navigation'}</li>\n        <li>{anchor anchor='main' title='Skip to content' accesskey='s' text='Skip to content'}</li>\n      </ul>\n{* end accessibility skip links *}\n\n      <hr class="accessibility" />\n{* Horizontal ruler that is hidden for visual browsers by CSS *}\n\n{* Start Header, with logo image that links to the default start page. Logo image is changed in the stylesheet  "Layout Top menu + 2 columns" *}\n      <div id="header">\n\n{* this holds the name of the site on the right side *}\n        <h2 class="headright">{sitename}</h2>\n\n{* a link back to home page and the header left image/logo, text is hidden using CSS *}\n        <h1>{cms_selflink dir="start" text="\$sitename"}</h1>        \n        <hr class="accessibility" />\n      </div>\n{* End Header *}\n\n{* Start Navigation *}\n      <div id="menu_vert">\n{* stylesheet  "Navigation CSSMenu - Horizontal" *}\n        <h2 class="accessibility">Navigation</h2>\n        {Navigator loadprops=0 template='cssmenu'}\n        <hr class="accessibility" />\n      </div>\n{* End Navigation *}\n\n{* Start Search, the input "Submit" is using an image, CSS: input.search-button *}\n      <div id="search">\n      {Search}\n      </div>\n{* End Search *}\n\n{* Start Breadcrumbs *}\n      <div class="crbk">\n{* holds the right image, we need 2 divs to be able to make this site fluid, if it was fixed width we could use one div, one image  *}\n\n        <div class="breadcrumbs">\n        {nav_breadcrumbs root='Home'}\n          <hr class="accessibility" />\n        </div>\n      </div>\n{* End Breadcrumbs *}\n\n{* Start Content *}\n      <div id="content">\n\n{* Start Sidebar *}\n        <div id="sidebar">\n          <div id="sidebarb">\n          {content block='Sidebar'}\n\n{* Start News, stylesheet  "Module News" *}\n            <div id="news">\n              <h2>News</h2>\n              {module_available module='News' assign='havenews'}{if \$havenews}{cms_module module=News  number='3' detailpage='news'}{/if} {* You cannot use the short form of the module call, i.e: {News} in this type of expression *}\n            </div>\n{* End News *}\n\n          </div>\n        </div>\n{* End Sidebar *}\n\n{* Start Content Area, the back1, back2, back3, hold the 3 outside images, main holds the 4th one, to make the box complete, if the template were fixed width not fluid we could use just 2 divs and 2 images, 1 top 1 bottom *}\n        <div class="back1">\n          <div class="back2">\n            <div class="back3">\n              <div id="main">\n                <h2>{title}</h2>\n                {content}\n                <br />{* to insure space below content *}\n\n{* Start relational links *}\n{* note this is the right side, when you float: divs you need to have float: right; divs first *}\n            <div class="right49">\n              <p>{anchor anchor='main' text='^ Top'}</p>\n            </div>\n            <div class="left49">\n              <p>{cms_selflink dir="previous"}\n{* The label parameter doesn't need to be there if you're using English, but is here to show how it's used if you don't want the English text "Previous page" *}\n\n              <br />\n              {cms_selflink dir="next"}\n              </p>\n            </div>\n{* End relational links *}\n\n                <hr class="accessibility" />\n                <div class="clear"></div>\n              </div>\n            </div>\n          </div>\n        </div>\n{* End Content Area *}\n\n      </div>\n{* End Content *}\n\n{* Start Footer. Edit the footer in the Global Content Block called "footer" *}\n      <div class="footback">\n        <div id="footer">\n{* stylesheet  "Navigation FatFootMenu" *}\n          <div id="fooleft">\n          {Navigator loadprops=0}\n          </div>\n          <div id="footrt">\n          {global_content name='footer'}\n          </div>\n          <div class="clear"></div>\n        </div>\n      </div>\n{* End Footer *}\n\n    </div>\n{* end pagewrapper *}\n\n  </body>\n</html>
EOT;
$template = new CmsLayoutTemplate();
$template->set_name('CSSMenu top + 2 columns'); // id = 16
$template->set_owner(1);
$template->set_content($txt);
$template->set_description('This is a drop-down menu that is using only CSS (although some Javascript is required for Internet Explorer 6, note: IE6 will not let you use 2 of these menu types in a template at the same time as the second one will fail to open). It can be either vertical or horizontal.');
$template->set_type($page_template_type);
$template->save();
$css_menutop_2col_theme->add_template($template);
$template_list[$template->get_name()] = $template->get_id();

$txt = <<<EOT
{process_pagedata}<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">\n{* Change lang="en" to the language of your site *}\n\n{* note: anything inside these are smarty comments, they will not show up in the page source *}\n\n  <head>\n    <title>{sitename} - {title}</title>\n{* The sitename is changed in Site Admin/Global settings. {title} is the name of each page *}\n\n {metadata}\n{* Don't remove this! Metadata is entered in Site Admin/Global settings. *}\n\n {cms_stylesheet}\n{* This is how all the stylesheets attached to this template are linked to it *}\n\n {cms_selflink dir="start" rellink=1}\n {cms_selflink dir="prev" rellink=1}\n {cms_selflink dir="next" rellink=1}\n{* Relational links for interconnections between pages, good for accessibility and Search Engine Optimization *}\n\n{* the literal below and the /literal at the end are needed whenever there are {"curly brackets"} as smarty will think it's something to process and will throw an error *}\n {literal}\n<script type="text/JavaScript">\n<!--\n//pass min and max - measured against window width\nfunction P7_MinMaxW(a,b){\nvar nw="auto",w=document.documentElement.clientWidth;\nif(w>=b){nw=b+"px";}if(w<=a){nw=a+"px";}return nw;\n}\n//-->\n</script>\n    <!--[if lte IE 6]>\n    <style type="text/css">\n    #pagewrapper {width:expression(P7_MinMaxW(720,1200));}\n    #container {height: 1%;}\n    </style>\n    <![endif]-->\n    {/literal}\n{* The min and max page width for Internet Explorer is set here. For other browsers it's in the stylesheet "Layout Left sidebar + 1 column" *}\n\n  </head>\n  <body>\n    <div id="pagewrapper">\n\n{* start accessibility skip links, anything with the class of accessibility is hidden with CSS from visual browsers *}\n      <ul class="accessibility">\n        <li>{anchor anchor='menu_vert' title='Skip to navigation' accesskey='n' text='Skip to navigation'}</li>\n        <li>{anchor anchor='main' title='Skip to content' accesskey='s' text='Skip to content'}</li>\n      </ul>\n{* end accessibility skip links *}\n\n      <hr class="accessibility" />\n{* anything with class="accessibility is hidden for visual browsers by CSS *}\n\n{* Start Header, with logo image that links to the default start page. Logo image is changed in the stylesheet  "Layout Left sidebar + 1 column" *}\n      <div id="header">\n\n{* this holds the name of the site on the right side *}\n        <h2 class="headright">{sitename}</h2>\n\n{* this holds a link back to home page and the header left image/logo, text is hidden using CSS *}\n        <h1>{cms_selflink dir="start" text="\$sitename"}</h1> \n       \n        <hr class="accessibility" />\n      </div>\n{* End Header *}\n\n{* Start Search, the input "Submit" is using an image, CSS: input.search-button *}\n      <div id="search">\n      {Search}\n      </div>\n{* End Search *}\n\n{* Start Breadcrumbs *}\n      <div class="crbk">\n{* holds the right image, we need 2 divs to be able to make this site fluid, if it was fixed width we could use one div, one image  *}\n\n        <div class="breadcrumbs">\n        {nav_breadcrumbs root='Home'}\n          <hr class="accessibility" />\n        </div>\n      </div>\n{* End Breadcrumbs *}\n\n{* Start Content (Navigation and Content columns) *}\n      <div id="content">\n\n{* Start Sidebar, 2 divs one for top image one for bottom image *}\n        <div id="sidebar">\n          <div id="sidebara">\n\n{* Start Navigation, stylesheet  "Navigation Simple - Vertical" *}\n            <div id="menu_vert">\n              <h2 class="accessibility">Navigation</h2>\n              {Navigator loadprops=0 template='Simple Navigation' collapse='1'}\n            </div>\n{* End Navigation *}\n\n{* Start News, style sheet "Module News" *}\n            <div id="news">\n              <h2>News</h2>\n              {module_available module='News' assign='havenews'}{if \$havenews}{cms_module module=News number='3' detailpage='news'}{/if} {* You cannot use the short form of the module call, i.e: {News} in this type of expression *}\n            </div>\n{* End News *}\n\n          </div>\n        </div>\n{* End Sidebar *}\n\n{* Start Content Area *}\n{* again 2 divs to hold top and bottom images, back is set to go to the right side then the main is set to come off the right side *}\n        <div class="back">        \n          <div id="main">\n            <h2>{title}</h2>\n            {content}\n            <br />\n{* this break is just to make sure we get space after the content *}\n\n{* Start relational links *}\n{* note this is the right side, when you float: divs you need to have float: right; divs first *}\n            <div class="right49">\n              <p>{anchor anchor='main' text='^ Top'}</p>\n            </div>\n\n            <div class="left49">\n              <p>{cms_selflink dir="previous"}\n{* The label parameter doesn't need to be there if you're using English, but is here to show how it's used if you don't want the English text "Previous page" *}\n\n              <br />\n              {cms_selflink dir="next"}\n              </p>\n            </div>\n{* End relational links *}\n\n            <hr class="accessibility" />\n          </div>\n        </div>\n{* End Content Area *}\n\n        <div class="clear"></div>\n{* this is to make sure the 2 divs stay tight *}\n\n      </div>\n{* End Content *}\n\n{* Start Footer. Edit the footer in the Global Content Block called "footer" *}\n      <div class="footback">\n        <div id="footer">\n{* stylesheet  "Navigation FatFootMenu" *}\n          <div id="fooleft">\n          {Navigator loadprops=0}\n          </div>\n          <div id="footrt">\n          {global_content name='footer'}\n          </div>\n          <div class="clear"></div>\n        </div>\n      </div>\n{* End Footer *}\n\n    </div>\n{* end pagewrapper *}\n  </body>\n</html>
EOT;
$template = new CmsLayoutTemplate();
$template->set_name('Left simple navigation + 1 column'); // id = 17
$template->set_owner(1);
$template->set_content($txt);
$template->set_description('This template has the menu in left sidebar. The menu is using the Simple Navigation menu template. It is styled in the stylesheet called Navigation Simple - Vertical.');
$template->set_type($page_template_type);
$template->save();
$leftsimple_1col_theme->add_template($template);
$template_list[$template->get_name()] = $template->get_id();

$txt = <<<EOT
{process_pagedata}<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">\n{* Change lang="en" to the language of your site *}\n\n{* note: anything inside these are smarty comments, they will not show up in the page source *}\n\n  <head>\n    <title>{sitename} - {title}</title>\n{* The sitename is changed in Site Admin/Global settings. {title} is the name of each page *}\n\n {metadata}\n{* Don't remove this! Metadata is entered in Site Admin/Global settings. *}\n\n {cms_stylesheet}\n{* This is how all the stylesheets attached to this template are linked to it *}\n\n {cms_selflink dir="start" rellink=1}\n {cms_selflink dir="prev" rellink=1}\n {cms_selflink dir="next" rellink=1}\n{* Relational links for interconnections between pages, good for accessibility and Search Engine Optimization *}\n\n{* the literal below and the /literal at the end are needed whenever there are {"curly brackets"} as smarty will think it's something to process and will throw an error *}\n {literal}\n<script type="text/JavaScript">\n<!--\n//pass min and max - measured against window width\nfunction P7_MinMaxW(a,b){\nvar nw="auto",w=document.documentElement.clientWidth;\nif(w>=b){nw=b+"px";}if(w<=a){nw=a+"px";}return nw;\n}\n//-->\n</script>\n    <!--[if lte IE 6]>\n    <style type="text/css">\n    #pagewrapper {width:expression(P7_MinMaxW(720,950));}\n    #container {height: 1%;}\n    </style>\n    <![endif]-->\n    {/literal}\n{* The min and max page width for Internet Explorer is set here. For other browsers it's in the stylesheet "Layout Top menu + 2 columns" *}\n\n  </head>\n  <body>\n    <div id="pagewrapper">\n\n{* start accessibility skip links, anything with the class of accessibility is hidden with CSS from visual browsers *}\n      <ul class="accessibility">\n        <li>{anchor anchor='menu_vert' title='Skip to navigation' accesskey='n' text='Skip to navigation'}</li>\n        <li>{anchor anchor='main' title='Skip to content' accesskey='s' text='Skip to content'}</li>\n      </ul>\n{* end accessibility skip links *}\n\n      <hr class="accessibility" />\n{* Horizontal ruler that is hidden for visual browsers by CSS *\n}\n{* Start Header, with logo image that links to the default start page. Logo image is changed in the stylesheet  "Layout Top menu + 2 columns" *}\n      <div id="header">\n\n{* this holds the name of the site on the right side *}\n        <h2 class="headright">{sitename}</h2>\n\n{* this holds a link back to home page and the header left image/logo, text is hidden using CSS *}\n        <h1>{cms_selflink dir="start" text="\$sitename"}</h1>\n        <hr class="accessibility" />\n      </div>\n{* End Header *}\n\n{* Start Navigation *}\n      <div id="menu_horiz">\n{* stylesheet  "Navigation Simple - Horizontal" *}\n        <h2 class="accessibility">Navigation</h2>\n        {Navigator loadprops=0 template='Simple Navigation' number_of_levels='1'}\n        <hr class="accessibility" />\n      </div>\n{* End Navigation *}\n{* Start Search, the input "Submit" is using an image, CSS: input.search-button *}\n      <div id="search">\n      {Search}\n      </div>\n{* End Search *}\n\n{* Start Breadcrumbs *}\n      <div class="crbk">\n{* holds the right image, we need 2 divs to be able to make this site fluid, if it was fixed width we could use one div, one image  *}\n\n        <div class="breadcrumbs">\n        {nav_breadcrumbs root='Home'}\n          <hr class="accessibility" />\n        </div>\n      </div>\n{* End Breadcrumbs *}\n\n{* Start Content (Navigation and Content columns) *}\n      <div id="content">\n\n{* Start Sidebar, 2 divs one for top image one for bottom image *}\n        <div id="sidebar">\n          <div id="sidebara">\n\n{* Start Sub Navigation, stylesheet  "Navigation Simple - Vertical" *}\n            <div id="menu_vert">\n              <h2 class="accessibility">Sub Navigation</h2>\n              {Navigator loadprops=0 template='Simple Navigation' start_level='2' collapse='1'}\n                <hr class="accessibility" />\n            </div>\n{* End Sub Navigation *}\n\n{* Start News, style sheet "Module News" *}\n            <div id="news">\n              <h2>News</h2>\n              {module_available module='News' assign='havenews'}{if \$havenews}{cms_module module=News number='3' detailpage='news'}{/if} {* You cannot use the short form of the module call, i.e: {News} in this type of expression *}\n            </div>\n{* End News *}\n\n          </div>\n        </div>\n{* End Sidebar *}\n\n{* Start Content Area, the back1, back2, back3, hold the 3 outside images, main holds the 4th one, to make the box complete, if the template were fixed width not fluid we could use just 2 divs and 2 images, 1 top 1 bottom *}\n        <div class="back1">\n          <div class="back2">\n            <div class="back3">\n              <div id="main">\n                <h2>{title}</h2>\n                {content}\n                <br />{* to insure space below content *}\n\n{* Start relational links *}\n{* note this is the right side, when you float: divs you need to have float: right; divs first *}\n            <div class="right49">\n              <p>{anchor anchor='main' text='^ Top'}</p>\n            </div>\n            <div class="left49">\n              <p>{cms_selflink dir="previous"}\n{* The label parameter doesn't need to be there if you're using English, but is here to show how it's used if you don't want the English text "Previous page" *}\n\n              <br />\n              {cms_selflink dir="next"}\n              </p>\n            </div>\n{* End relational links *}\n\n                <hr class="accessibility" />\n                <div class="clear"></div>\n              </div>\n            </div>\n          </div>\n        </div>\n{* End Content Area *}\n\n      </div>\n{* End Content *}\n\n{* Start Footer. Edit the footer in the Global Content Block called "footer" *}\n      <div class="footback">\n        <div id="footer">\n{* stylesheet  "Navigation FatFootMenu" *}\n          <div id="fooleft">\n          {Navigator loadprops=0}\n          </div>\n          <div id="footrt">\n          {global_content name='footer'}\n          </div>\n          <div class="clear"></div>\n        </div>\n      </div>\n{* End Footer  *}\n\n    </div>\n{* end pagewrapper *}\n\n  </body>\n</html>
EOT;
$template = new CmsLayoutTemplate();
$template->set_name('Top simple navigation + left subnavigation + 1 column'); // id = 18
$template->set_owner(1);
$template->set_content($txt);
$template->set_description('With the Menu Manager you can easily split the navigation in two parts. On this page the top level in the page hierarchy is displayed horizontally and depending on what page is displayed a localized sub-menu is displayed vertically to the left.');
$template->set_type($page_template_type);
$template->save();
$topsimple_leftsubnav_1col_theme->add_template($template);
$template_list[$template->get_name()] = $template->get_id();

$txt = <<<EOT
{process_pagedata}<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">\n{* Change lang="en" to the language of your site *}\n\n{* note: anything inside these are smarty comments, they will not show up in the page source *}\n\n  <head>\n    <title>{sitename} - {title}</title>\n{* The sitename is changed in Site Admin/Global settings. {title} is the name of each page *}\n\n {metadata}\n{* Don't remove this! Metadata is entered in Site Admin/Global settings. *}\n\n {cms_stylesheet}\n{* This is how all the stylesheets attached to this template are linked to it *}\n\n {cms_selflink dir="start" rellink=1}\n {cms_selflink dir="prev" rellink=1}\n {cms_selflink dir="next" rellink=1}\n{* Relational links for interconnections between pages, good for accessibility and Search Engine Optimization *}\n\n{* the literal below and the /literal at the end are needed whenever there are {"curly brackets"} as smarty will think it's something to process and will throw an error *}\n {literal}\n<script type="text/JavaScript">\n<!--\n//pass min and max - measured against window width\nfunction P7_MinMaxW(a,b){\nvar nw="auto",w=document.documentElement.clientWidth;\nif(w>=b){nw=b+"px";}if(w<=a){nw=a+"px";}return nw;\n}\n//-->\n</script>\n    <!--[if lte IE 6]>\n    <style type="text/css">\n    #pagewrapper {width:expression(P7_MinMaxW(720,950));}\n    #container {height: 1%;}\n    </style>\n    <![endif]-->\n    {/literal}\n{* The min and max page width for Internet Explorer is set here. For other browsers it's in the stylesheet "Layout Top menu + 2 columns" *}\n\n    <!--[if lte IE 6]>\n    <script type="text/javascript" src="modules/MenuManager/CSSMenu.js"></script>\n    <![endif]--> \n{* The above JavaScript is required for CSSMenu to work in IE *}\n\n  </head>\n  <body>\n    <div id="pagewrapper">\n\n{* start accessibility skip links, anything with the class of accessibility is hidden with CSS from visual browsers *}\n      <ul class="accessibility">\n        <li>{anchor anchor='menu_vert' title='Skip to navigation' accesskey='n' text='Skip to navigation'}</li>\n        <li>{anchor anchor='main' title='Skip to content' accesskey='s' text='Skip to content'}</li>\n      </ul>\n{* end accessibility skip links *}\n\n      <hr class="accessibility" />\n{* Horizontal ruler that is hidden for visual browsers by CSS *}\n\n{* Start Header, with logo image that links to the default start page. Logo image is changed in the stylesheet  "Layout Top menu + 2 columns" *}\n      <div id="header">\n\n{* this holds the name of the site on the right side *}\n        <h2 class="headright">{sitename}</h2>\n\n{* a link back to home page and the header left image/logo, text is hidden using CSS *}\n        <h1>{cms_selflink dir="start" text="\$sitename"}</h1>        \n        <hr class="accessibility" />\n      </div>\n{* End Header *}\n\n{* Start Navigation, stylesheet "Navigation ShadowMenu - Horizontal" *}\n      <div id="menu_vert">\n        <h2 class="accessibility">Navigation</h2>\n        {Navigator loadprops=0 template='cssmenu_ulshadow'}\n        <hr class="accessibility" />\n      </div>\n{* End Navigation *}\n\n{* Start Search, the input "Submit" is using an image, CSS: input.search-button *}\n      <div id="search">\n      {Search}\n      </div>\n{* End Search *}\n\n{* Start Breadcrumbs *}\n      <div class="crbk">\n{* holds the right image, we need 2 divs to be able to make this site fluid, if it was fixed width we could use one div, one image  *}\n\n        <div class="breadcrumbs">\n        {nav_breadcrumbs root='Home'}\n          <hr class="accessibility" />\n        </div>\n      </div>\n{* End Breadcrumbs *}\n\n{* Start Content *}\n      <div id="content">\n\n{* Start Sidebar *}\n        <div id="sidebar">\n          <div id="sidebarb">\n          {content block='Sidebar'}\n\n{* Start News, stylesheet  "Module News" *}\n            <div id="news">\n              <h2>News</h2>\n              {module_available module='News' assign='havenews'}{if \$havenews}{cms_module module=News number='3' detailpage='news'}{/if} {* You cannot use the short form of the module call, i.e: {News} in this type of expression *}\n            </div>\n{* End News *}\n\n          </div>\n        </div>\n{* End Sidebar *}\n\n{* Start Content Area, the back1, back2, back3, hold the 3 outside images, main holds the 4th one, to make the box complete, if the template were fixed width not fluid we could use just 2 divs and 2 images, 1 top 1 bottom *}\n        <div class="back1">\n          <div class="back2">\n            <div class="back3">\n              <div id="main">\n                <h2>{title}</h2>\n                {content}\n                <br />{* to insure space below content *}\n\n{* Start relational links *}\n{* note this is the right side, when you float: divs you need to have float: right; divs first *}\n            <div class="right49">\n              <p>{anchor anchor='main' text='^ Top'}</p>\n            </div>\n            <div class="left49">\n              <p>{cms_selflink dir="previous"}\n{* The label parameter doesn't need to be there if you're using English, but is here to show how it's used if you don't want the English text "Previous page" *}\n\n              <br />\n              {cms_selflink dir="next"}\n              </p>\n            </div>\n{* End relational links *}\n\n                <hr class="accessibility" />\n                <div class="clear"></div>\n              </div>\n            </div>\n          </div>\n        </div>\n{* End Content Area *}\n\n      </div>\n{* End Content *}\n\n{* Start Footer. Edit the footer in the Global Content Block called "footer" *}\n      <div class="footback">\n        <div id="footer">\n{* stylesheet  "Navigation FatFootMenu" *}\n          <div id="fooleft">\n          {Navigator loadprops=0}\n          </div>\n          <div id="footrt">\n          {global_content name='footer'}\n          </div>\n          <div class="clear"></div>\n        </div>\n      </div>\n{* End Footer *}\n\n    </div>\n{* end pagewrapper *}\n\n  </body>\n</html>
EOT;
$template = new CmsLayoutTemplate();
$template->set_name('ShadowMenu Tab + 2 columns'); // id = 20
$template->set_owner(1);
$template->set_content($txt);
$template->set_description('Using the same menu template as the previous theme. We changed the child ul CSS to use a different top image. This involves changing some of the margin and padding as the images are a different shape. Note the difference in the second level and third level ul images, one has an arrow up and the other has an arrow left.');
$template->set_type($page_template_type);
$template->save();
$shadowmenu_tab_2col_theme->add_template($template);
$template_list[$template->get_name()] = $template->get_id();

$txt = <<<EOT
{process_pagedata}<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">\n{* Change lang="en" to the language of your site *}\n\n{* note: anything inside these are smarty comments, they will not show up in the page source *}\n\n  <head>\n    <title>{sitename} - {title}</title>\n{* The sitename is changed in Site Admin/Global settings. {title} is the name of each page *}\n\n {metadata}\n{* Don't remove this! Metadata is entered in Site Admin/Global settings. *}\n\n {cms_stylesheet}\n{* This is how all the stylesheets attached to this template are linked to it *}\n\n {cms_selflink dir="start" rellink=1}\n {cms_selflink dir="prev" rellink=1}\n {cms_selflink dir="next" rellink=1}\n{* Relational links for interconnections between pages, good for accessibility and Search Engine Optimization *}\n\n{* the literal below and the /literal at the end are needed whenever there are {"curly brackets"} as smarty will think it's something to process and will throw an error *}\n {literal}\n<script type="text/JavaScript">\n<!--\n//pass min and max - measured against window width\nfunction P7_MinMaxW(a,b){\nvar nw="auto",w=document.documentElement.clientWidth;\nif(w>=b){nw=b+"px";}if(w<=a){nw=a+"px";}return nw;\n}\n//-->\n</script>\n    <!--[if lte IE 6]>\n    <style type="text/css">\n    #pagewrapper {width:expression(P7_MinMaxW(720,950));}\n    #container {height: 1%;}\n    </style>\n    <![endif]-->\n    {/literal}\n{* The min and max page width for Internet Explorer is set here. For other browsers it's in the stylesheet "Layout Top menu + 2 columns" *}\n\n    <!--[if lte IE 6]>\n    <script type="text/javascript" src="modules/MenuManager/CSSMenu.js"></script>\n    <![endif]--> \n{* The above JavaScript is required for CSSMenu to work in IE *}\n\n  </head>\n  <body>\n    <div id="pagewrapper">\n\n{* start accessibility skip links, anything with the class of accessibility is hidden with CSS from visual browsers *}\n      <ul class="accessibility">\n        <li>{anchor anchor='menu_vert' title='Skip to navigation' accesskey='n' text='Skip to navigation'}</li>\n        <li>{anchor anchor='main' title='Skip to content' accesskey='s' text='Skip to content'}</li>\n      </ul>\n{* end accessibility skip links *}\n\n      <hr class="accessibility" />\n{* Horizontal ruler that is hidden for visual browsers by CSS *}\n\n{* Start Header, with logo image that links to the default start page. Logo image is changed in the stylesheet  "Layout Left sidebar + 1 column" *}\n      <div id="header">\n\n{* this holds the name of the site on the right side *}\n        <h2 class="headright">{sitename}</h2>\n\n{* this holds a link back to home page and the header left image/logo, text is hidden using CSS *}\n        <h1>{cms_selflink dir="start" text="\$sitename"}</h1>        \n        <hr class="accessibility" />\n      </div>\n{* End Header *}\n\n{* Start Search, the input "Submit" is using an image, CSS: input.search-button *}\n      <div id="search">\n      {Search}\n      </div>\n{* End Search *}\n\n{* Start Breadcrumbs *}\n      <div class="crbk">\n{* holds the right image, we need 2 divs to be able to make this site fluid, if it was fixed width we could use one div, one image  *}\n\n        <div class="breadcrumbs">\n        {nav_breadcrumbs root='Home'}\n          <hr class="accessibility" />\n        </div>\n      </div>\n{* End Breadcrumbs *}\n\n{* Start Content (Navigation and Content columns) *}\n      <div id="content">\n\n{* Start Sidebar, 2 divs one for top image one for bottom image *}\n        <div id="sidebar">\n          <div id="sidebara">\n\n{* Start Navigation, stylesheet  "Navigation ShadowMenu - Vertical" *}\n            <h2 class="accessibility">Navigation</h2>\n            {Navigator loadprops=0 template='cssmenu_ulshadow'}\n            <hr class="accessibility" />\n\n{* Start News, stylesheet  "Module News" *}\n            <div id="news">\n              <h2>News</h2>\n              {module_available module='News' assign='havenews'}{if \$havenews}{cms_module module=News number='3' detailpage='news'}{/if} {* You cannot use the short form of the module call, i.e: {News} in this type of expression *}\n            </div>\n{* End News *}\n\n          </div>\n        </div>\n{* End Sidebar *}\n\n{* Start Content Area, the back1, back2, back3, hold the 3 outside images, main holds the 4th one, to make the box complete, if the template were fixed width not fluid we could use just 2 divs and 2 images, 1 top 1 bottom *}\n        <div class="back1">\n          <div class="back2">\n            <div class="back3">\n              <div id="main">\n                <h2>{title}</h2>\n                {content}\n                <br />{* to insure space below content *}\n\n{* Start relational links *}\n{* note this is the right side, when you float: divs you need to have float: right; divs first *}\n            <div class="right49">\n              <p>{anchor anchor='main' text='^ Top'}</p>\n            </div>\n            <div class="left49">\n              <p>{cms_selflink dir="previous"}\n{* The label parameter doesn't need to be there if you're using English, but is here to show how it's used if you don't want the English text "Previous page" *}\n\n              <br />\n              {cms_selflink dir="next"}\n              </p>\n            </div>\n{* End relational links *}\n\n                <hr class="accessibility" />\n                <div class="clear"></div>\n              </div>\n            </div>\n          </div>\n        </div>\n{* End Content Area *}\n\n      </div>\n{* End Content *}\n\n{* Start Footer. Edit the footer in the Global Content Block called "footer" *}\n      <div class="footback">\n        <div id="footer">\n{* stylesheet  "Navigation FatFootMenu" *}\n          <div id="fooleft">\n          {Navigator loadprops=0}\n          </div>\n          <div id="footrt">\n          {global_content name='footer'}\n          </div>\n          <div class="clear"></div>\n        </div>\n      </div>\n{* End Footer *}\n\n    </div>\n{* end pagewrapper *}\n\n  </body>\n</html>
EOT;
$template = new CmsLayoutTemplate();
$template->set_name('ShadowMenu left + 1 column'); // id = 21
$template->set_owner(1);
$template->set_content($txt);
$template->set_description('Using the same menu template as the previous theme. We changed the child ul CSS to use a different top image. This involves changing some of the margin and padding as the images are a different shape. Note the difference in the second level and third level ul images, one has an arrow up and the other has an arrow left.');
$template->set_type($page_template_type);
$template->save();
$shadowmenu_left_1col_theme->add_template($template);
$template_list[$template->get_name()] = $template->get_id();

$txt = <<<EOT
{process_pagedata}<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"\n"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">\n{* Change lang="en" to the language of your site *}\n\n{* note: anything inside these are smarty comments, they will not show up in the page source *}\n  <head>\n{if isset(\$canonical)}<link rel="canonical" href="{\$canonical}" />{elseif isset(\$content_obj)}<link rel="canonical" href="{\$content_obj->GetURL()}" />{/if}\n\n<title>{title} | {sitename}</title>\n{* The sitename is changed in Site Admin/Global settings. {title} is the name of each page *}\n\n{metadata}\n{* Don't remove this! Metadata is entered in Site Admin/Global settings. *}\n\n{cms_stylesheet}\n{* This is how all the stylesheets attached to this template are linked to *}\n\n{cms_selflink dir="start" rellink=1}\n{cms_selflink dir="prev" rellink=1}\n{cms_selflink dir="next" rellink=1}\n{* Relational links for interconnections between pages, good for accessibility and Search Engine Optmization *}\n\n<!--[if IE 6]>\n<script type="text/javascript" src="modules/MenuManager/CSSMenu.js"></script>\n<![endif]-->\n{* The above JavaScript is required for Menu - NCleanBlue-css to work in IE6 *}\n\n{* the literal below and the /literal at the end are needed whenever there are {"curly brackets"} as smarty will think it's something to process and will throw an error *}\n{* IE6 png fix *}\n{literal}\n<!--[if IE 6]>\n<script type="text/javascript"  src="uploads/NCleanBlue/js/ie6fix.js"></script>\n<script type="text/javascript">\n // argument is a CSS selector\n DD_belatedPNG.fix('.sbar-top,.sbar-bottom,.main-top,.main-bottom,#version');\n</script>\n<style type="text/css">\n/* enable background image caching in IE6 */\nhtml {filter:expression(document.execCommand("BackgroundImageCache", false, true));} \n</style>\n<![endif]-->\n{/literal}\n\n  </head>\n  <body>\n    <div id="ncleanblue">\n      <div id="pagewrapper" class="core-wrap-960 core-center">\n{* start accessibility skip links *}\n        <ul class="accessibility">\n          <li>{anchor anchor='menu_vert' title='Skip to navigation' accesskey='n' text='Skip to navigation'}</li>\n          <li>{anchor anchor='main' title='Skip to content' accesskey='s' text='Skip to content'}</li>\n        </ul>\n{* end accessibility skip links *}\n        <hr class="accessibility" />\n{* Horizontal ruler that is hidden for visual browsers by CSS *}\n\n{* Start Header, with logo image that links to the default start page *}\n        <div id="header" class="util-clearfix">\n{* logo image that links to the default start page. Logo image is changed in the style sheet  "Layout NCleanBlue" *}\n          <div id="logo" class="core-float-left">\n            {cms_selflink dir="start" text="\$sitename"}\n          </div>\n          \n{* Start Search, the input "Submit" is using an image, CSS: div#search input.search-button *}\n          <div id="search" class="core-float-right">\n            {Search search_method="post"}\n          </div>\n{* End Search *}\n          <span class="util-clearb">&nbsp;</span>\n          \n{* Start Navigation, style sheet  "Layout NCleanBlue", starting at Menu  ROOT *}\n          <h2 class="accessibility util-clearb">Navigation</h2>\n{* anything class="accessibility" is hidden for visual browsers by CSS *}\n          <div class="page-menu util-clearfix">\n          {Navigator loadprops=0 template='cssmenu_ulshadow'}\n          </div>\n          <hr class="accessibility util-clearb" />\n{* End Navigation *}\n\n        </div>\n{* End Header *}\n\n{* Start Content (Navigation and Content columns) *}\n        <div id="content" class="util-clearfix"> \n\n{* Start Optional tag CMS Version Information, also is a good example how smarty works, the big star that holds the version number, you may remove it here and the style sheet where it is marked. *}\n          <div title="CMS - {cms_version} - {cms_versionname}" id="version">\n          {capture assign='cms_version'}{cms_version|lower}{/capture}{"/-([a-z]).*/"|preg_replace:"":\$cms_version}\n          </div>\n{* End Optional tag  *}\n\n{* Start Bar *}\n          <div id="bar" class="util-clearfix">\n{* Start Breadcrumbs, a bit of letting you know where your at *}\n            <div class="breadcrumbs core-float-right">\n              {nav_breadcrumbs root='Home'}\n            </div>\n{* End Breadcrumbs *}\n\n            <hr class="accessibility util-clearb" />\n          </div>\n{* End Bar *}\n\n{* Start left side *}\n          <div id="left" class="core-float-left">\n            <div class="sbar-top">\n              <h2 class="sbar-title">News</h2>\n            </div>\n            <div class="sbar-main">\n{* Start News *}\n              <div id="news">\n              {module_available module='News' assign='havenews'}{if \$havenews}{cms_module module=News number='3' detailpage='news'}{/if} {* You cannot use the short form of the module call, i.e: {News} in this type of expression *}\n              </div>\n              <img class="screen" src="uploads/NCleanBlue/screen-1.6.jpg" width="139" height="142" title="CMS - {cms_version} - {cms_versionname}" alt="CMS - {cms_version} - {cms_versionname}" />\n{* End News *} \n            </div>\n            <span class="sbar-bottom">&nbsp;</span> \n          </div>\n{* End left side *}\n\n{* Start Content Area, right side *}\n          <div id="main"  class="core-float-right">\n\n{* main top, holds top image *}\n            <div class="main-top">\n              </div> \n            \n{* main content *}\n            <div class="main-main util-clearfix">\n              <h1 class="title">{title}</h1>\n            {content}\n            </div>\n            \n{* Start main bottom and relational links *}\n            <div class="main-bottom">\n              <div class="right49 core-float-right">\n              {anchor anchor='main' text='^&nbsp;&nbsp;Top'}\n              </div>\n              <div class="left49 core-float-left">\n                <span>\n                  {cms_selflink dir="previous"}&nbsp;\n{* The label parameter doesn't need to be there if you're using English, but is here to show how it's used if you don't want the English text "Previous page" *}\n                </span>\n                <span>\n                  {cms_selflink dir="next"}&nbsp;\n                </span>\n              </div>\n{* End relational links *}\n\n              <hr class="accessibility" />\n            </div>\n{* End main bottom *}\n\n          </div>\n{* End Content Area, right side *}\n\n        </div>\n{* End Content *}\n\n      </div>\n{* end pagewrapper *}\n      <span class="util-clearb">&nbsp;</span>\n      \n{* Start Footer *}\n      <div id="footer-wrapper">\n        <div id="footer" class="core-wrap-960">\n{* first foot menu *}\n          <div class="block core-float-left">\n            {Navigator loadprops=0 template='minimal_menu'  number_of_levels='1'}\n          </div>\n          \n{* second foot menu if active page has children *}\n          <div class="block core-float-left">\n            {Navigator loadprops=0 template='minimal_menu'  start_level="2"}\n          </div>\n          \n{* edit the footer in the Global Content Block called "footer" *}\n          <div class="block cms core-float-left">\n            {global_content name='footer'}\n          </div>\n          \n          <span class="util-clearb">&nbsp;</span>\n        </div>\n      </div>\n{* End Footer *}\n    </div>\n{* End Div *}\n  </body>\n</html>
EOT;
$template = new CmsLayoutTemplate();
$template->set_name('NCleanBlue'); // id = 22
$template->set_owner(1);
$template->set_content($txt);
$template->set_description('This one is using a new menu template so we can style the drop down for the children pages, using an image for the second ul going from the top down, it has an extra li at the bottom of the child pages ul <li class="separator once" style="list-style-type: none;">&nbsp; </li> this is used to hold the bottom image.');
$template->set_type($page_template_type);
$template->save();
$ncleanblue_theme->add_template($template);
$template_list[$template->get_name()] = $template->get_id();


$txt = <<<EOT
{strip}\r\n{* used for page specific data or logic in Edit Content -> Logic *}\r\n{process_pagedata}\r\n\r\n{* ================\r\n   THEME LOGIC\r\n   ================ *}\r\n    \r\n{* With cms_lang_info we retrieve current language information, assign gives us \$nls variable we can work with *}\r\n{cms_lang_info assign='nls'}\r\n{* assigned url to theme related folder so we do not have to type full path each time *}\r\n{\$theme_path = "{uploads_url}/simplex"}\r\n{* assigned content tag, now we have all smarty variables available anywhere in template *}\r\n{* assigned title tag to a variable which we can override with a module entry title for example *}\r\n{title assign='main_title'}\r\n{content assign='main_content'}\r\n{* assigned prev and next links so we don't have empty html tags if there is no previous or next page *}\r\n{cms_selflink dir='previous' assign='prev_page'}\r\n{cms_selflink dir='next' assign='next_page'}\r\n\r\n{* ensure that the smarty variables we created are copied to global scope for use elsewhere in the template *}\r\n{share_data scope=parent vars='nls,theme_path,main_title,main_content,prev_page,next_page' scope=global}\r\n\r\n{* using strip as we don't want useless whitespace, especially not before doctype *}\r\n{/strip}<!doctype html>\r\n<!--[if IE 8]>         <html lang='{\$nls->htmlarea()}' dir='{\$nls->direction()}' class='lt-ie9'> <![endif]-->\r\n<!--[if gt IE 8]><!--> <html lang='{\$nls->htmlarea()}' dir='{\$nls->direction()}'> <!--<![endif]-->\r\n    <head>\r\n        <meta charset='{\$nls->encoding()}' />\r\n        {metadata} {* Don't remove this! Metadata is entered in Site Admin/Global settings. *}\r\n        <title>{\$main_title nocache} - {sitename}</title>\r\n        <meta name='HandheldFriendly' content='True' />\r\n        <meta name='MobileOptimized' content='320' />\r\n        <meta name='viewport' content='width=device-width, initial-scale=1' />\r\n        <meta http-equiv='cleartype' content='on' />\r\n        <meta name='msapplication-TileImage' content='{\$theme_path}/images/icons/cmsms-152x152.png' />\r\n        <meta name='msapplication-TileColor' content='#5C5A59' />\r\n        {if isset(\$canonical)}<link rel='canonical' href='{\$canonical}' />{elseif isset(\$content_obj)}<link rel='canonical' href='{\$content_obj->GetURL()}' />{/if} {* See in news detail template how cannonical url can be assigned from module *}\r\n        {cms_stylesheet} {* This is how all the stylesheets attached to this template are linked to *}\r\n        <link href='//fonts.googleapis.com/css?family=Noto+Sans:400,700,400italic|Oswald:700' rel='stylesheet' type='text/css' />\r\n        <link rel='apple-touch-icon-precomposed' sizes='152x152' href='{\$theme_path}/images/icons/cmsms-152x152.png' />\r\n        <link rel='apple-touch-icon-precomposed' sizes='120x120' href='{\$theme_path}/images/icons/cmsms-120x120.png' />\r\n        <link rel='apple-touch-icon-precomposed' sizes='72x72' href='{\$theme_path}/images/icons/cmsms-76x76.png' />\r\n        <link rel='apple-touch-icon-precomposed' href='{\$theme_path}/images/icons/cmsms-60x60.png' />\r\n        <link rel='shortcut icon' sizes='196x196' href='{\$theme_path}/images/icons/cmsms-196x196.png' />\r\n        <link rel='shortcut icon' href='{\$theme_path}/images/icons/cmsms-60x60.png' />\r\n        <link rel='icon' href='{\$theme_path}/images/icons/favicon_cms.ico' type='image/x-icon' />\r\n        {cms_selflink dir='start' rellink='1'} {* Relational links for interconnections between pages, good for accessibility and Search Engine Optmization *}\r\n        {cms_selflink dir='prev' rellink='1'}\r\n        {cms_selflink dir='next' rellink='1'}\r\n        <!--[if lt IE 9]>\r\n            <script src="//html5shiv.googlecode.com/svn/trunk/html5.js"></script>\r\n            <script src="//css3-mediaqueries-js.googlecode.com/svn/trunk/css3-mediaqueries.js"></script>\r\n        <![endif]-->\r\n    </head>\r\n    <body id='boxed' class='container page-wrapper page-{\$page_alias} page-{\$content_id}'>\r\n        <!-- #wrapper (wrapping content in a box) -->\r\n        <div class='row' id='wrapper'>\r\n            <!-- accessibility links, jump to nav or content -->\r\n            <ul class="visuallyhidden">\r\n                <li>{anchor anchor='nav' title='Skip to navigation' accesskey='n' text='Skip to navigation'}</li>\r\n                <li>{anchor anchor='main' title='Skip to content' accesskey='s' text='Skip to content'}</li>\r\n            </ul>\r\n            <!-- accessibility //-->\r\n            <!-- .top (top section of page containing logo, navigation search...) -->\r\n            <header class='top inner-section'>\r\n                <div class='row header'>\r\n                    <!-- .logo (cmsms logo on the left side) -->\r\n                    <div class='logo four-col'>\r\n                        <a href='{root_url}' title='{sitename}'>\r\n                            <img src='{\$theme_path}/images/cmsmadesimple-logo.png' width='227' height='59' alt='{sitename}' />\r\n                            <span class='palm'></span>\r\n                        </a>\r\n                    </div>\r\n                    <!-- .logo //-->\r\n                    <!-- .main-navigation (main navigation on the right side) -->\r\n                    <nav class='main-navigation eight-col cf noprint' id='nav' role='navigation'>\r\n                        {Navigator loadprops='0' template='Simplex Main Navigation'} {* A Navigator module, database Template *}\r\n                    </nav>\r\n                    <!-- .main-navigation //-->\r\n                </div>\r\n                <!-- .header-bottom (bottom part of header containing catchphrase and search field) -->\r\n                <div class='row header-bottom'>\r\n                    <section class='phrase cf'>\r\n                        <span class='seven-col phrase-text'>Power for professionals<br class='lt-768' /> Simplicity for End Users</span>\r\n                        {Search|strip formtemplate='Simplex Search'} {* Search module using custom template in Design Manager, you should use resultpage parameter for search results (see module help) *}\r\n                    </section>\r\n                </div>\r\n                <!-- .header-bottom //-->\r\n                <!-- .banner (banner area for a slider or teaser image) -->\r\n                {global_content name='Simplex Slideshow'}\r\n                <!-- .banner //-->\r\n            </header>\r\n            <!-- .top //-->\r\n            <!-- .content-wrapper (wrapping div for content area) -->\r\n            <main role='main' class='content-wrapper inner-section'>\r\n                <div class='row'>\r\n                    <!-- .content-inner (display content first) -->\r\n                    <div class='content-inner eight-col push-four'>\r\n                        <!-- .content-top (breadcrumbs) -->\r\n                        <div class='content-top cf' itemscope itemtype='http://data-vocabulary.org/Breadcrumb'>\r\n                            {Navigator action='breadcrumbs'} {* you can create own breadcrumbs template as well and include it with template parameter *}\r\n                            <span class='title-border' aria-hidden='true'></span>\r\n                        </div>\r\n                        <!-- .content-top //-->\r\n                        <!-- .content (actual content with title and content tags) -->\r\n                        <article class='content' id='main'>\r\n                            <h1>{\$main_title nocache} </h1> {* title tag *}\r\n                                {\$main_content nocache} {* content entered in page editor area, variable is assigned on top in template logic, using nocache as variables are cached with Smarty cache on *}\r\n                        </article>\r\n                        <!-- .content //-->\r\n                    </div>\r\n                    <!-- .content-inner //-->\r\n                    <!-- .sidebar (then show sidebar) -->\r\n                    <aside class='sidebar four-col pull-eight'>\r\n                        {* sample of using News Module tag for summary of latest two articles, remember if News page is deleted you should change detailpage parameter *}\r\n                        {module_available module='News' assign='havenews'}{if \$havenews}{cms_module module=News summarytemplate='Simplex News Summary' number='2' detailtemplate='Simplex News Detail'}{/if} {* You cannot use the short form of the module call, i.e: {News} in this type of expression *}\r\n                    </aside>\r\n                    <!-- .sidebar //-->\r\n                    <div class='cf eight-col push-four'>\r\n                        {if !empty(\$prev_page)}<span class='previous'>{\$prev_page nocache}</span>{/if}\r\n                        {if !empty(\$next_page)}<span class='next'>{\$next_page nocache}</span>{/if}\r\n                    </div>\r\n                </div>\r\n            </main>\r\n            <!-- .content-wrapper //-->\r\n            <!-- .footer (footer area) -->\r\n            <footer class='footer inner-section'>\r\n                <span class='back-top'><a href='{anchor anchor='main' onlyhref='1'}' id='scroll-top'><i class='icon-arrow-up' aria-hidden='true'></i></a></span>\r\n                <div class='row'>\r\n                    <section class='eight-col push-four noprint'>\r\n                        <nav class='footer-navigation row'>\r\n                            {Navigator template='Simplex Footer Navigation' excludeprefix='home' number_of_levels='2' loadprops='0'}\r\n                        </nav>\r\n                    </section> \r\n                    <section class='four-col pull-eight copyright'>\r\n                        {global_content|strip name='Simplex Footer'} {* generic Design Manager template *}\r\n                    </section>\r\n                </div>\r\n            </footer>\r\n        <!-- #wrapper //--> \r\n        </div>\r\n    {cms_jquery exclude='ui,nestedSortable,json,migrate' append='uploads/simplex/js/jquery.sequence-min.js,uploads/simplex/js/functions.min.js'}{strip}\r\n    {* if you are using some older jQuery plugin that relies on deprecated and removed functions that are no longer supported\r\n       in jQuery 1.11.0 try removing "migrate" from exclude list which will include jQuery Migrate 1.2.1 Plugin.\r\n       For more information about removed functions see: http://jquery.com/upgrade-guide/1.9/ *}{/strip}\r\n    </body>\r\n</html>
EOT;
$template = new CmsLayoutTemplate();
$template->set_name('Simplex');
$template->set_owner($admin_user->id);
$template->set_content($txt);
$template->set_description('A HTML5 based responsive template');
$template->set_type($page_template_type);
$template->set_type_dflt(TRUE);
$template->save();
$simplex_theme->add_template($template);
$template_list[$template->get_name()] = $template->get_id();

$txt = <<<EOT
{strip}\r\n\r\n{* A simple Smarty array for our slideshow *}\r\n{\$slides = []}\r\n\r\n{\$slides.0.heading = 'Power for professionals'}\r\n{\$slides.0.subheading = 'Simplicity for end Users'}\r\n{\$slides.0.image = 'palm-logo.png'}\r\n\r\n{\$slides.1.heading = 'Faster &amp; Easier'}\r\n{\$slides.1.subheading = 'Website management'}\r\n{\$slides.1.image = 'mate-zimple.png'}\r\n\r\n{\$slides.2.heading = 'Flexible &amp; Powerful'}\r\n{\$slides.2.subheading = 'Manage your Website anywhere and anytime'}\r\n{\$slides.2.image = 'mobile-devices-scene.png'}\r\n\r\n{\$slides.3.heading = 'Secure &amp; Robust'}\r\n{\$slides.3.subheading = 'Take control of your application'}\r\n{\$slides.3.image = 'browser-scene.png'}\r\n\r\n{* Markup *}\r\n<section class='banner row noprint' id='sx-slides' role='banner'>\r\n    <ul class="sequence-canvas">\r\n        {foreach \$slides as \$slide}\r\n        <li{if \$slide@first} class='animate-in'{/if}>\r\n            {if !empty(\$slide.heading)}<h2 class='title'>{\$slide.heading}</h2>{/if}\r\n            {if !empty(\$slide.subheading)}<h3 class='subtitle'>{\$slide.subheading}</h3>{/if}\r\n            {if !empty(\$slide.image)}<img class='image' src='{uploads_url}/simplex/teaser/{\$slide.image}' alt='{\$slide.heading|cms_escape:'htmlall'}' />{/if}\r\n        </li>\r\n        {/foreach}\r\n    </ul>\r\n</section>\r\n\r\n{/strip}
EOT;
$gcb_sx_slideshow = new CmsLayoutTemplate();
$gcb_sx_slideshow->set_name('Simplex Slideshow');
$gcb_sx_slideshow->set_type($gcb_template_type);
$gcb_sx_slideshow->set_owner($admin_user->id);
$gcb_sx_slideshow->set_description('A sample slider for Simplex Theme.
Note: required jQuery Framework is already included at the bottom of Simplex Page Template.
If any of Modules that you are going to use requires or adds additional jQuery Framework, remember to either remove jQuery Framework from Module template (for example Gallery module) or to move {cms_jquery} tag in Simplex Page Template to <head> section of template if needed.
All current Browser come with some kind of Developer Tools (usually F12 key) or you can also install Firebug in Firefox or Chrome, if some JavaScript function doesn\'t work your first step would be to open Developer Tools and look into console errors.');
$gcb_sx_slideshow->set_content($txt);
$gcb_sx_slideshow->save();
$simplex_theme->add_template($gcb_sx_slideshow);

$txt = <<<EOT
{* Logic *}\r\n{\$start_year = '2004'}\r\n{\$current_year = \$smarty.now|cms_date_format:'Y'}\r\n\r\n{* Template *}\r\n<ul class='social cf'>\r\n    <li class='twitter'><a title='Twitter' href='http://twitter.com/#!/cmsms'><i class='icon-twitter'></i><span class='visuallyhidden'>Twitter</span></a></li>\r\n    <li class='facebook'><a title='Facebook' href='https://www.facebook.com/cmsmadesimple'><i class='icon-facebook'></i><span class='visuallyhidden'>Facebook</span></a></li>\r\n    <li class='linkedin'><a title='LinkedIn' href='http://www.linkedin.com/groups?gid=1139537'><i class='icon-linkedin'></i><span class='visuallyhidden'>LinkedIn</span></a></li>\r\n    <li class='youtube'><a title='YouTube' href='http://www.youtube.com/user/cmsmadesimple'><i class='icon-youtube'></i><span class='visuallyhidden'>YouTube</span></a></li>\r\n    <li class='google'><a title='Google Plus' href='https://plus.google.com/+cmsmadesimple/posts'><i class='icon-google'></i><span class='visuallyhidden'>Google Plus</span></a></li>\r\n    <li class='pinterest'><a title='Pinterest' href='http://www.pinterest.com/cmsmadesimple/'><i class='icon-pinterest'></i><span class='visuallyhidden'>Pinterest</span></a></li>\r\n</ul>\r\n<p class='copyright-info'>&copy; Copyright {\$start_year}{if \$start_year !== \$current_year} - {\$current_year}{/if} - CMS Made Simple<br /> This site is powered by <a href='http://www.cmsmadesimple.org'>CMS Made Simple</a> version {cms_version}</p>
EOT;
$gcb_sx_footer = new CmsLayoutTemplate();
$gcb_sx_footer->set_name('Simplex Footer');
$gcb_sx_footer->set_type($gcb_template_type);
$gcb_sx_footer->set_owner($admin_user->id);
$gcb_sx_footer->set_description('Custom footer section template for Simplex Theme');
$gcb_sx_footer->set_content($txt);
$gcb_sx_footer->save();
$simplex_theme->add_template($gcb_sx_footer);
//
// Stylesheets
//
$css_list = array();
verbose_msg(ilang('install_stylesheets'));

$txt = <<<EOT
/*********************************************\nSample stylesheet for mobile and small screen handheld devices\n\nJust a simple layout suitable for smaller screens with less \nstyling cabapilities and minimal css\n\nNote: If you dont want to support mobile devices you can\nsafely remove this stylesheet.\n*********************************************/\n/* remove all padding and margins and set width to 100%. This should be default for handheld devices but its good to set these explicitly */\nbody {\nmargin:0;\npadding:0;\nwidth:100%;\n}\n\n/* hide accessibility noprint and definition */\n.accessibility,\n.noprint,\ndfn {\ndisplay:none;\n}\n\n/* dont want to download image for header so just set bg color */\ndiv#header,\ndiv#footer {\nbackground-color: #385C72;  \ncolor: #fff;\ntext-align:center;\n}\n\n/* text colors for header and footer */\ndiv#header a,\ndiv#footer a {\ncolor: #fff;\n}\n\n/* this doesnt look as nice, but takes less space */\ndiv#menu_vert ul li,\ndiv#menu_horiz ul li {\ndisplay:inline;\n}\n\n/* small border at the bottom to have some indicator */\ndiv#menu_vert ul,\ndiv#menu_horiz ul {\nborder-bottom:1px solid #fff;\n}\n\n/* save some space */\ndiv.breadcrumbs {\ndisplay:none;\n}
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Handheld');
$css->set_description('Stylesheet for older mobile devices');
$css->set_content($txt);
$css->set_media_types('handheld');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
/*\nSections that are hidden when printing the page. We only want the content printed.\n*/\n\n\nbody {\ncolor: #000 !important; /* we want everything in black */\nbackground-color:#fff !important; /* on white background */\nfont-family:arial; /* arial is nice to read ;) */\nborder:0 !important; /* no borders thanks */\n}\n\n/* This affects every tag */\n* {\nborder:0 !important; /* again no borders on printouts */\n}\n\n/* \nno need for accessibility on printout. \nMark all your elements in content you \ndont want to get printed with class="noprint"\n*/\n.accessibility,\n.noprint\n {\ndisplay:none !important; \n}\n\n/* \nremove all width constraints from content area\n*/\ndiv#content,\ndiv#main {\ndisplay:block !important;\nwidth:100% !important;\nborder:0 !important;\npadding:1em !important;\n}\n\n/* hide everything else! */\ndiv#header,\ndiv#header h1 a,\ndiv.breadcrumbs,\ndiv#search,\ndiv#footer,\ndiv#menu_vert,\ndiv#news,\ndiv.noprint,\ndiv.right49,\ndiv.left49,\ndiv#sidebar  {\n   display: none !important;\n}\n\nimg {\nfloat:none; /* this makes images cause a pagebreak if it doesnt fit on the page */\n}
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Print');
$css->set_description('Default stylesheet for print devices');
$css->set_content($txt);
$css->set_media_types('print');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
/* accessibility */\n/* menu links accesskeys */\nspan.accesskey {\n	text-decoration: none;\n}\n/* accessibility divs are hidden by default, text, screenreaders and such will show these */\n.accessibility, hr {\n/* position set so the rest can be set out side of visual browser viewport */\n	position: absolute;\n/* takes it out top side */\n	top: -999em;\n/* takes it out left side */\n	left: -999em;\n}\n/* definition tags are also hidden, these are also used for accessibility menu links */\ndfn {\n	position: absolute;\n	left: -1000px;\n	top: -1000px;\n	width: 0;\n	height: 0;\n	overflow: hidden;\n	display: inline;\n}\n/* end accessibility */\n/* wiki style external links */\n/* external links will have "(external link)" text added, lets hide it */\na.external span {\n	position: absolute;\n	left: -5000px;\n	width: 4000px;\n}\na.external {\n/* make some room for the image, css shorthand rules, read: first top padding 0 then right padding 12px then bottom then right */\n	padding: 0 12px 0 0;\n}\n/* colors for external links */\na.external:link {\n	color: #18507C;\n/* background image for the link to show wiki style arrow */\n	background: url([[root_url]]/uploads/NCleanBlue/external.gif) no-repeat 100% -100px;\n}\na.external:visited {\n	color: #18507C;\n/* a different color can be used for visited external links */\n/* Set the last 0 to -100px to use that part of the external.gif image for different color for active links external.gif is actually 300px tall, we can use different positions of the image to simulate rollover image changes.*/\n	background: url([[root_url]]/uploads/NCleanBlue/external.gif) no-repeat 100% -100px;\n}\na.external:hover {\n	color: #18507C;\n/* Set the last 0 to -200px to use that part of the external.gif image for different color on hover */\n	background: url([[root_url]]/uploads/NCleanBlue/external.gif) no-repeat 100% 0;\n	background-color: inherit;\n}\n/* end wiki style external links */\n/* clearing */\n/* clearfix is a hack for divs that hold floated elements. it will force the holding div to span all the way down to last floated item. We strongly recommend against using this as it is a hack and might not render correctly but it is included here for convenience. Do not edit if you dont know what you are doing*/\n.clearfix:after {\n	content: ".";\n	display: block;\n	height: 0;\n	clear: both;\n	visibility: hidden;\n}\n.clear {\n	height: 0;\n	clear: both;\n	width: 90%;\n	visibility: hidden;\n}\n#main .clear {\n	height: 0;\n	clear: right;\n	width: 90%;\n	visibility: hidden;\n}\n* html>body .clearfix {\n	display: inline-block;\n	width: 100%;\n}\n* html .clear {\n/* Hides from IE-mac \\*/\n	height: 1%;\n	clear: right;\n	width: 90%;\n/* End hide from IE-mac */\n}\n/* end clearing */
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Accessibility and cross-browser tools');
$css->set_description('Accessibility and cross-browser CSS rules attached to multiple Themes');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
/* browsers interpret margin and padding a little differently, we'll remove all default padding and margins and set them later on */\n* {\n	margin: 0;\n	padding: 0;\n}\n/*Set initial font styles*/\nbody {\n	text-align: left;\n	font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;\n	font-size: 75.01%;\n	line-height: 1em;\n}\n/*set font size for all divs, this overrides some body rules*/\ndiv {\n	font-size: 1em;\n}\n/*if img is inside "a" it would have borders, we don't want that*/\nimg {\n	border: 0;\n}\n/*default link styles*/\na, a:link a:active {\n/* set all links to have underline */\n	text-decoration: underline;\n/* css validation will give a warning if color is set without background color. this will explicitly tell this element to inherit bg colour from parent element */\n	background-color: inherit;\n/* this is a bluish color, you change this for all default link colors */\n	color: #18507C;\n}\na:visited {\n/* keeps the underline */\n	text-decoration: underline;\n	background-color: inherit;\n/* a different color is used for visited links */\n	color: #18507C;\n}\na:hover {\n/* remove underline on hover */\n	text-decoration: none;\n	background-color: inherit;\n/* using a different color makes the hover obvious */\n	color: #385C72;\n}\n/*****************basic layout *****************/\nbody {\n	margin: 0;\n	padding: 0;\n/* default text color for entire site*/\n	color: #333;\n/* you can set your own image and background color here */\n	background: #f4f4f4 url([[root_url]]/uploads/ngrey/body.png) repeat-x left top;\n}\ndiv#pagewrapper {\n/* min max width, IE wont understand these, so we will use java script magic in the <head> */\n	max-width: 99em;\n	min-width: 60em;\n/* now that width is set this centers wrapper */\n	margin: 0 auto;\n	background-color: #fefefe;\n	color: black;\n}\n/* header, we will hide h1 a text and replace it with an image, we assign a height for it so the image wont cut off */\ndiv#header {\n/* adjust according your image size */\n	height: 100px;\n	margin: 0;\n	padding: 0;\n/* you can set your own image here, will go behind h1 a image */\n	background: #f4f4f4 url([[root_url]]/uploads/ngrey/bg_banner.png) repeat-x left top;\n/* border just the bottom */\n	border-bottom: 1px solid #D9E2E6;\n}\ndiv#header h1 a {\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/logoCMS.png) no-repeat left top;\n/* this will make the "a" link a solid shape */\n	display: block;\n/* adjust according your image size */\n	height: 100px;\n/* this hides the text */\n	text-indent: -999em;\n/* old firefox would have shown underline for the link, this explicitly hides it */\n	text-decoration: none;\n}\ndiv#header h1 {\n	margin: 0;\n	padding: 0;\n/*these keep IE6 from pushing the header to more than the set size*/\n	line-height: 0;\n	font-size: 0;\n/* this will keep IE6 from flickering on hover */\n	background: url([[root_url]]/uploads/ngrey/logoCMS.png) no-repeat left top;\n}\ndiv#header h2 {\n/* this is where the site name is */\n	float: right;\n	line-height: 1.2em;\n/* this keeps IE6 from not showing the whole text */\n	font-size: 1.5em;\n/* keeps the size uniform */\n	margin: 35px 65px 0px 0px;\n/* adjust according your text size */\n	color: #f4f4f4;\n}\ndiv.crbk {\n/* sets all to 0 */\n	margin: 0;\n	padding: 0;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/mainrtup.gif) no-repeat right bottom;\n}\ndiv.breadcrumbs {\n/* CSS short hand rule first value is top then right, bottom and left */\n	padding: 1em 0em 1em 1em;\n/* its good to set font sizes to be relative, this way viewer can change his/her font size */\n	font-size: 90%;\n/* css shorthand rule will be opened to be "0px 0px 0px 0px" */\n	margin: 0px;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/mainleftup.gif) no-repeat left bottom;\n}\ndiv.breadcrumbs span.lastitem {\n	font-weight: bold;\n}\ndiv#search {\n/* position for the search box */\n	float: right;\n/* enough width for the search input box */\n	width: 27em;\n	text-align: right;\n	padding: 0.5em 0 0.2em 0;\n	margin: 0 1em;\n}\n/* a class for Submit button for the search input box */\ninput.search-button {\n	border: none;\n	height: 22px;\n	width: 53px;\n	margin-left: 5px;\n	padding: 0px 2px 2px 0px;\n/* makes the hover cursor show, you can set your own cursor here */\n	cursor: pointer;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/search.gif) no-repeat center center;\n}\ndiv#content {\n/* some air above and under menu and content */\n	margin: 1.5em auto 2em 0;\n	padding: 0px;\n}\n/* this gets all the outside calls that were used on the div#main before  */\ndiv.back1 {\n/* this will give room for sidebar to be on the left side, make sure this number is bigger than sidebar width */\n	margin-left: 29%;\n/* and some air on the right */\n	margin-right: 2%;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/mainrt1.gif) no-repeat right top;\n}\n/* this is an IE6 hack, you may see these through out the CSS */\n* html div.back1 {\n/* unlike other browser IE6 needs float:right and a width */\n	float: right;\n	width: 69%;\n/* and we take this out or it will stop at the bottom  */\n	margin-left: 0%;\n/* and some air on the right */\n	margin-right: 10px;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/mainrt1.gif) no-repeat right top;\n}\ndiv.back2 {\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/mainleft1.gif) no-repeat left top;\n}\ndiv.back3 {\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/wbtmleft.gif) no-repeat left bottom;\n}\ndiv#main {\n/* this is the last inside div so we set the space inside it to keep all content away from the edges of images/box */\n	padding: 10px 15px;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/rtup.gif) no-repeat right bottom;\n}\ndiv.back #main {\n/* this is the last inside div so we set the space inside it to keep all content away from the edges of images/box */\n	padding: 10px 30px 1px 15px;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/wbtmleft.gif) no-repeat left bottom;\n}\ndiv.back {\n/* this will give room for sidebar to be on the left side, make sure this space is bigger than sidebar width */\n	margin-left: 29%;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/wtopleft.gif) no-repeat left top;\n}\ndiv#sidebar {\n/* set sidebar left. Change to right, float: right; instead, but you will need to change the margins. */\n	float: left;\n/* sidebar width, if you change this change div.back and/or div.back1 margins */\n	width: 26%;\n/* FIX IE double margin bug */\n	display: inline;\n/* the 20px is on the bottom, insures space above footer if longer than content */\n	margin: 0px 0px 20px;\n	padding: 0px;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/mainrt1.gif) no-repeat right top;\n}\ndiv#sidebara {\n	padding: 13px 15px 3px 0px;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/mainrtup.gif) no-repeat right bottom;\n}\ndiv#sidebarb {\n	padding: 10px 10px 1px 0px;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/mainrtup.gif) no-repeat right bottom;\n}\ndiv.footback {\n/* keep footer below content and menu */\n	clear: both;\n/* this sets 10px on right to let the right image show, the balance 10px left on next div */\n	padding: 0px 10px 0px 0px;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/wfootrt.gif) no-repeat right top;\n}\ndiv#footer {\n/* this sets 10px on left to balance 10px right on last div */\n	padding: 0px 0px 0px 10px;\n/* color of text, the link color is set below */\n	color: #595959;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/wtopleft.gif) no-repeat left top;\n}\ndiv.leftfoot {\n	float: left;\n	width: 30%;\n	margin-left: 20px\n}\ndiv#footer p {\n/* sets different font size from default */\n	font-size: 0.8em;\n/* some air for footer */\n	padding: 1.5em;\n/* centered text */\n	text-align: center;\n	margin: 0;\n}\ndiv#footer p a {\n/* footer link would be same color as default we want it same as footer text */\n	color: #595959;\n}\n/* as we hid all hr for accessibility we create new hr with div class="hr" element */\ndiv.hr {\n	height: 1px;\n	padding: 1em;\n	border-bottom: 1px dotted black;\n	margin: 1em;\n}\n/* relational links under content */\ndiv.left49 {\n/* combined percentages of left+right equaling 100%  might lead to rounding error on some browser */\n	width: 70%;\n}\ndiv.right49 {\n	float: right;\n	width: 29%;\n/* set right to keep text on right */\n	text-align: right;\n}\n/********************CONTENT STYLING*********************/\n/* HEADINGS */\ndiv#content h1 {\n/* font size for h1 */\n	font-size: 2em;\n	line-height: 1em;\n	margin: 0;\n}\ndiv#content h2 {\n	color: #294B5F;\n/* font size for h2 the higher the h number the smaller the font size, most times */\n	font-size: 1.5em;\n	text-align: left;\n/* some air around the text */\n	padding-left: 0.5em;\n	padding-bottom: 1px;\n/* set borders around header */\n	border-bottom: 1px solid #899092;\n	border-left: 1.1em solid #899092;\n/* a larder than h1 line height */\n	line-height: 1.5em;\n/* and some air under the border */\n	margin: 0 0 0.5em 0;\n}\ndiv#content h3 {\n	color: #294B5F;\n	font-size: 1.3em;\n	line-height: 1.3em;\n	margin: 0 0 0.5em 0;\n}\ndiv#content h4 {\n	color: #294B5F;\n	font-size: 1.2em;\n	line-height: 1.3em;\n	margin: 0 0 0.25em 0;\n}\ndiv#content h5 {\n	color: #294B5F;\n	font-size: 1.1em;\n	line-height: 1.3em;\n	margin: 0 0 0.25em 0;\n}\nh6 {\n	color: #294B5F;\n	font-size: 1em;\n	line-height: 1.3em;\n	margin: 0 0 0.25em 0;\n}\n/* END HEADINGS */\n/* TEXT */\np {\n/* default p font size, this is set different in some other divs */\n	font-size: 1em;\n/* some air around p elements */\n	margin: 0 0 1.5em 0;\n	line-height: 1.4em;\n	padding: 0;\n}\nblockquote {\n	border-left: 10px solid #ddd;\n	margin-left: 10px;\n}\nstrong, b {\n/* explicit setting for these */\n	font-weight: bold;\n}\nem, i {\n/* explicit setting for these */\n	font-style: italic;\n}\n/* Wrapping text in <code> tags. Makes CSS not validate */\ncode, pre {\n/* css-3 */\n	white-space: pre-wrap;\n/* Mozilla, since 1999 */\n	white-space: -moz-pre-wrap;\n/* Opera 4-6 */\n	white-space: -pre-wrap;\n/* Opera 7 */\n	white-space: -o-pre-wrap;\n/* Internet Explorer 5.5+ */\n	word-wrap: break-word;\n	font-family: "Courier New", Courier, monospace;\n	font-size: 1em;\n}\npre {\n/* black border for pre blocks */\n	border: 1px solid #000;\n/* set different from surroundings to stand out */\n	background-color: #ddd;\n	margin: 0 1em 1em 1em;\n	padding: 0.5em;\n	line-height: 1.5em;\n	font-size: 90%;\n}\n/* Separating the divs on the template explanation page */\ndiv.templatecode {\n	margin: 0 0 2.5em;\n}\n/* END TEXT */\n/* LISTS */\n/* lists in content need some margins to look nice */\ndiv#main ul,\ndiv#main ol,\ndiv#main dl {\n	font-size: 1.0em;\n	line-height: 1.4em;\n	margin: 0 0 1.5em 0;\n}\ndiv#main ul li,\ndiv#main ol li {\n	margin: 0 0 0.25em 3em;\n}\n/* definition lists topics on bold */\ndiv#main dl {\n	margin-bottom: 2em;\n	padding-bottom: 1em;\n	border-bottom: 1px solid #c0c0c0;\n}\ndiv#main dl dt {\n	font-weight: bold;\n	margin: 0 0 0 1em;\n}\ndiv#main dl dd {\n	margin: 0 0 1em 1em;\n}\n/* END LISTS */
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Layout Left sidebar + 1 column');
$css->set_description('CSS rules used for Layout Left sidebar + 1 column Design');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
/* Vertical menu for the CMS CSS Menu Module */\r\n/* by Alexander Endresen and mark and Nuno */\r\n/* The wrapper determines the width of the menu elements */\r\n#menuwrapper {\r\n/* just smaller than it\'s containing div */\r\n	width: 95%;\r\n	margin-left: 0px;\r\n/* room at bottom */\r\n	margin-bottom: 10px;\r\n}\r\n/* Unless you know what you do, do not touch this */\r\n#primary-nav, #primary-nav ul {\r\n/* remove any default bullets */\r\n	list-style: none;\r\n	margin: 0px;\r\n	padding: 0px;\r\n/* make sure it fills out */\r\n	width: 100%;\r\n/* just a little bump */\r\n	margin-left: 1px;\r\n}\r\n#primary-nav ul {\r\n/* make the ul stay in place so when we hover it lets the drops go over the content below else it will push everything below out of the way */\r\n	position: absolute;\r\n/* just a little bump down for second level ul */\r\n	top: 5px;\r\n/* keeps the left side of this ul on the right side of the one it came out of */\r\n	left: 100%;\r\n/* keeps it hidden till hover event */\r\n	display: none;\r\n}\r\n#primary-nav ul ul {\r\n/* no bump down for third level ul */\r\n	top: 0px;\r\n}\r\n#primary-nav li {\r\n/* negative bottom margin pulls them together, images look like one border between */\r\n	margin-bottom: -1px;\r\n/* keeps within it\'s container */\r\n	position: relative;\r\n/* bottom padding pushes \"a\" up enough to show our image */\r\n	padding: 0px 0px 4px 0px;\r\n/* you can set your own image here */\r\n	background: url([[root_url]]/uploads/ngrey/liup.gif) no-repeat right bottom;\r\n}\r\n#primary-nav li li {\r\n/* you can set your width here, if no width or set auto it will only be as wide as the text in it  */\r\n	width: 220px;\r\n	padding: 0px;\r\n/* removes first level li image */\r\n	background-image: none;\r\n}\r\n/* Styling the basic apperance of the menu \"a\" elements */\r\nul#primary-nav li a {\r\n/* specific font size, this could be larger or smaller than default font size */\r\n	font-size: 1em;\r\n/* make sure we keep the font normal */\r\n	font-weight: normal;\r\n/* set default link colors */\r\n	color: #595959;\r\n/* pushes li out from the text, sort of like making links a certain size, if you give them a set width and/or height you may limit you ability to have as much text as you need */\r\n	padding: 0.8em 0.5em 0.5em 0.5em;\r\n/* makes it hold a shape */\r\n	display: block;\r\n/* removes underline from default link setting */\r\n	text-decoration: none;\r\n/* you can set your own image here this is tall enough to cover text heavy links */\r\n	background: url([[root_url]]/uploads/ngrey/libk.gif) no-repeat right top;\r\n}\r\nul#primary-nav a span {\r\n/* makes it hold a shape */\r\n	display: block;\r\n/* pushes text to right */\r\n	padding-left: 1.5em;\r\n}\r\nul#primary-nav li a:hover {\r\n/* stops image flicker in some browsers */\r\n	background: url([[root_url]]/uploads/ngrey/libk.gif) no-repeat right top;\r\n/* changes text color on hover */\r\n	color: #899092;\r\n}\r\nul#primary-nav li li a:hover {\r\n/* you can set your own image here, second level \"a\" */\r\n	background:  url([[root_url]]/uploads/ngrey/darknav.png) repeat-x left center;\r\n/* contrast color to image behind it */\r\n	color: #FFF;\r\n}\r\nul#primary-nav li a.menuactive {\r\n/* black and bold to set it off from non active */\r\n	color: #000;\r\n	font-weight: bold;\r\n}\r\nul#primary-nav li li a.menuactive {\r\n/* contrast color to image behind it, set below */\r\n	color: #FFF;\r\n/* not bold as text color and image behind it set it off from non active */\r\n	font-weight: normal;\r\n}\r\nul#primary-nav li ul a {\r\n/* insures alignment */\r\n	text-align: left;\r\n	margin: 0px;\r\n/* relative to it\'s container */\r\n	position: relative;\r\n/* more padding to left than default */\r\n	padding: 6px 3px 6px 15px;\r\n	font-weight: normal;\r\n/* darker than first level \"a\" */\r\n	color: #000;\r\n/* removes any borders that may have been set in first level */\r\n	border-top: 0 none;\r\n	border-right: 0 none;\r\n	border-left: 0 none;\r\n/* removes image set in first level \"a\" */\r\n	background: none;\r\n}\r\nul#primary-nav li ul {\r\n/* very lite grey color, by now you should know what the rest mean */\r\n	background: #F3F5F5;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	position: absolute;\r\n	width: auto;\r\n	height: auto;\r\n	display: none;\r\n	position: absolute;\r\n	z-index: 999;\r\n	border-top: 1px solid #FFFFFF;\r\n	border-bottom: 1px solid #374B51;\r\n	/*Info: The opacity property is  CSS3, however, will be valid just in CSS 3.1) http://jigsaw.w3.org/css-validator2) More Options chose CSS3 3) is full validate;)*/\r\n	opacity: 0.95;\r\n/* CSS 3 */\r\n}\r\n/* Fixes IE7 bug */\r\n#primary-nav li, #primary-nav li.menuparent {\r\n	min-height: 1em;\r\n}\r\n/* Styling the basic apperance of the second level active page elements (shows what page in the menu is being displayed) */\r\n#primary-nav li li.menuactive, #primary-nav li.menuactive.menuparenth li.menuactive {\r\n/* set your image here, dark grey image with white text set above*/\r\n	background:  url([[root_url]]/uploads/ngrey/darknav.png) repeat-x left center;\r\n}\r\n#primary-nav li.menuparent span {\r\n/* padding on left for image */\r\n	padding-left: 1.5em;\r\n/* down arrow to note it has children, left side of text */\r\n	background: url([[root_url]]/uploads/ngrey/active.png) no-repeat left center;\r\n}\r\n#primary-nav li.menuparent:hover li.menuparent span {\r\n/* remove left padding as image is on right side of text */\r\n	padding-left: 0;\r\n/* right arrow to note it has children, right side of text */\r\n	background: url([[root_url]]/uploads/ngrey/parent.png) no-repeat right center;\r\n}\r\n#primary-nav li.menuparenth li.menuparent span,\r\n#primary-nav li.menuparenth li.menuparenth span {\r\n/* same as above but this is for IE6, gif image as it can\'t handle transparent png */\r\n	padding-left: 0;\r\n	background: url([[root_url]]/uploads/ngrey/parent.gif) no-repeat right center;\r\n}\r\n#primary-nav li.menuparenth span,\r\n#primary-nav li.menuparent:hover span,\r\n#primary-nav li.menuparent.menuactive span,\r\n#primary-nav li.menuparent.menuactiveh span, {\r\n/* right arrow to note hover */\r\n	background: url([[root_url]]/uploads/ngrey/parent.png) no-repeat left center;\r\n}\r\n#primary-nav li li span,\r\n#primary-nav li.menuparent li span,\r\n#primary-nav li.menuparent:hover li span,\r\n#primary-nav li.menuparenth li span,\r\n#primary-nav li.menuparenth li.menuparenth li span,\r\n#primary-nav li.menuparent li.menuparent li span,\r\n#primary-nav li.menuparent li.menuparent:hover li span  {\r\n/* removes any images set above unless it\'s a parent or active parent */\r\n	background:  none;\r\n/* removes padding that is used for arrows */\r\n	padding-left: 0px;\r\n}\r\n/* IE6 flicker fix */\r\n#primary-nav li.menuh,\r\n#primary-nav li.mnuparenth,\r\n#primary-nav li.mnuactiveh {\r\n	background: url([[root_url]]/uploads/ngrey/libk.gif) no-repeat right top;\r\n	color: #899092;\r\n}\r\n#primary-nav li:hover li a {\r\n/* removes any images set above unless it\'s a parent or active parent */\r\n	background:  none;\r\n	color: #000;\r\n}\r\n/* The magic - set to work for up to a 3 level menu, but can be increased unlimited, for fourth level add\r\n#primary-nav li:hover ul ul ul,\r\n#primary-nav li.menuparenth ul ul ul,\r\n*/\r\n#primary-nav ul,\r\n#primary-nav li:hover ul,\r\n#primary-nav li:hover ul ul,\r\n#primary-nav li.menuparenth ul,\r\n#primary-nav li.menuparenth ul ul {\r\n	display: none;\r\n}\r\n/* for fourth level add\r\n#primary-nav ul ul ul li:hover ul,\r\n#primary-nav ul ul ul li.menuparenth ul,\r\n*/\r\n#primary-nav li:hover ul,\r\n#primary-nav ul li:hover ul,\r\n#primary-nav ul ul li:hover ul,\r\n#primary-nav li.menuparenth ul,\r\n#primary-nav ul li.menuparenth ul,\r\n#primary-nav ul ul li.menuparenth ul {\r\n	display: block;\r\n}\r\n/* IE Hack, will cause the css to not validate */\r\n#primary-nav li,\r\n#primary-nav li.menuparenth {\r\n	_float: left;\r\n	_height: 1%;\r\n}\r\n#primary-nav li a {\r\n	_height: 1%;\r\n}\r\n/* BIG NOTE: I didn\'t do anything to these 2, never tested */\r\n#primary-nav li.sectionheader {\r\n	border-left: 1px solid #006699;\r\n	border-top: 1px solid #006699;\r\n	font-size: 130%;\r\n	font-weight: bold;\r\n	padding: 1.5em 0 0.8em 0.5em;\r\n	background-color: #fff;\r\n	margin: 0;\r\n	width: 100%;\r\n}\r\n/* separator */\r\n#primary-nav li hr.separator {\r\n	display: block;\r\n	height: 0.5em;\r\n	color: #abb0b6;\r\n	background-color: #abb0b6;\r\n	width: 100%;\r\n	border: 0;\r\n	margin: 0;\r\n	padding: 0;\r\n	border-top: 1px solid #006699;\r\n	border-right: 1px solid #006699;\r\n}
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Navigation CSSMenu - Vertical');
$css->set_description('Navigation CSS rules used in CSSMenu left + 1 column Design');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
/* by Alexander Endresen and mark and Nuno */\r\n#menu_vert {\r\n/* no margin/padding so it fills the whole div */\r\n	margin: 0;\r\n	padding: 0;\r\n}\r\n.clearb {\r\n/* needed for some browsers */\r\n	clear: both;\r\n}\r\n#menuwrapper {\r\n/* set the background color for the menu here */\r\n	background-color: #243135;\r\n/* IE6 Hack */\r\n	height: 1%;\r\n	width: auto;\r\n/* one border at the top */\r\n	border-top: 1px solid #3F565C;\r\n	margin: 0;\r\n	padding: 0;\r\n}\r\nul#primary-nav, ul#primary-nav ul {\r\n/* remove any default bullets */\r\n	list-style-type: none;\r\n	margin: 0;\r\n	padding: 0;\r\n}\r\nul#primary-nav {\r\n/* pushes the menu div up to give room above for background color to show */\r\n	padding-top: 10px;\r\n/* keeps the first menu item off the left side */\r\n	padding-left: 10px;\r\n}\r\nul#primary-nav ul {\r\n/* make the ul stay in place so when we hover it lets the drops go over the content below else it will push everything below out of the way */\r\n	position: absolute;\r\n/* top being the bottom of the li it comes out of */\r\n	top: auto;\r\n/* keeps it hidden till hover event */\r\n	display: none;\r\n/* same size but different color for each border */\r\n	border-top: 1px solid #C8D3D7;\r\n	border-right: 1px solid #C8D3D7;\r\n	border-bottom: 1px solid #ADC0C7;\r\n	border-left: 1px solid #A5B9C0;\r\n}\r\nul#primary-nav ul ul {\r\n/* now we move the next level ul down from the top a little for distinction */\r\n	margin-top: 1px;\r\n/* pull it in on the left, helps us not lose the hover effect when going to next level */\r\n	margin-left: -1px;\r\n/* keeps the left side of this ul on the right side of the one it came out of */\r\n	left: 100%;\r\n/* sets the top of it inline with the li it came out of */\r\n	top: 0px;\r\n}\r\nul#primary-nav li {\r\n/* floating left will set menu items to line up left to right else they will stack top to bottom */\r\n	float: left;\r\n/* no margin/padding keeps them next to each other, the padding will be in the \"a\" */\r\n	margin: 0px;\r\n	padding: 0px;\r\n}\r\n#primary-nav li li {\r\n/* Set the width of the menu elements at second level. Leaving first level flexible. */\r\n	width: 220px;\r\n/* removes any left margin it may have picked up from the first li */\r\n	margin-left: 0px;\r\n/* keeps them tight to the one above, no missed hovers */\r\n	margin-top: -1px;\r\n/* removes the left float set in first li so these will stack from top down */\r\n	float: none;\r\n/* relative to the ul they are in */\r\n	position: relative;\r\n}\r\n/* set the \"a\" link look here */\r\nul#primary-nav li a {\r\n/* specific font size, this could be larger or smaller than default font size */\r\n	font-size: 1em;\r\n/* make sure we keep the font normal */\r\n	font-weight: normal;\r\n/* set default link colors */\r\n	color: #fff;\r\n/* pushes out from the text, sort of like making links a certain size, if you give them a set width and/or height you may limit you ability to have as much text as you need */\r\n	padding: 12px 15px 15px;\r\n	display: block;\r\n/* sets no underline on links */\r\n	text-decoration: none;\r\n}\r\nul#primary-nav li a:hover {\r\n/* kind of obvious */\r\n	background-color: transparent;\r\n}\r\nul#primary-nav li li a:hover {\r\n/* this is set to #000, black, below so hover will be white text */\r\n	color: #FFF;\r\n}\r\nul#primary-nav li a.menuactive {\r\n	color: #000;\r\n/* bold to set it off from non active */\r\n	font-weight: bold;\r\n/* set your image here */\r\n	background:  url([[root_url]]/uploads/ngrey/nav.png) repeat-x left 0px;\r\n}\r\nul#primary-nav li a.menuactive:hover {\r\n	color: #000;\r\n/* keep it the same */\r\n	font-weight: bold;\r\n}\r\n#primary-nav li li a.menuparent span {\r\n/* makes it hold a shape */\r\n	display: block;\r\n/* set your image here, right arrow, 98% over from the left, 100% or \'right\' puts it to far */\r\n	background:  url([[root_url]]/uploads/ngrey/parent.png) no-repeat 98% center;\r\n}\r\n/* gif for IE6, as it can\'t handle transparent png */\r\n* html #primary-nav li li a.menuparent span {\r\n/* set your image here, right arrow, 98% over from the left, 100% or \'right\' puts it to far */\r\n	background:  url([[root_url]]/uploads/ngrey/parent.gif) no-repeat 98% center;\r\n}\r\nul#primary-nav li ul a {\r\n/* insures alignment */\r\n	text-align: left;\r\n	margin: 0px;\r\n/* keeps it relative to it\'s container */\r\n	position: relative;\r\n/* less padding than first level no need for large links here */\r\n	padding: 6px 3px 6px 15px;\r\n/* if first level is set to bold this will reset this level */\r\n	font-weight: normal;\r\n/* first level is #FFF/white, we need black to contrast with light background */\r\n	color: #000;\r\n	border-top: 0 none;\r\n	border-right: 0 none;\r\n	border-left: 0 none;\r\n}\r\nul#primary-nav li ul {\r\n/* very lite grey color, by now you should know what the rest mean */\r\n	background: #F3F5F5;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	position: absolute;\r\n	width: auto;\r\n	height: auto;\r\n	display: none;\r\n	position: absolute;\r\n	z-index: 999;\r\n	border-top: 1px solid #FFFFFF;\r\n	border-bottom: 1px solid #374B51;\r\n/*Info: The opacity property is  CSS3, however, will be valid just in CSS 3.1) http://jigsaw.w3.org/css-validator2) More Options chose CSS3 3) is full validate;)*/\r\n	opacity: 0.95;\r\n/* CSS 3 */\r\n}\r\nul#primary-nav li ul ul {\r\n/*Info: The opacity property is  CSS3, however, will be valid just in CSS 3.1) http://jigsaw.w3.org/css-validator2) More Options chose CSS3 3) is full validate;)*/\r\n	opacity: 95;\r\n/* CSS 3 */\r\n}\r\n/* Styling the appearance of menu items on hover */\r\n#primary-nav li:hover,\r\n#primary-nav li.menuh,\r\n#primary-nav li.menuparenth,\r\n#primary-nav li.menuactiveh {\r\n/* set your image here, dark grey image */\r\n	background:  url([[root_url]]/uploads/ngrey/darknav.png) repeat-x left center;\r\n	color: #000\r\n}\r\n/* The magic - set to work for up to a 3 level menu, but can be increased unlimited, for fourth level add\r\n#primary-nav li:hover ul ul ul,\r\n#primary-nav li.menuparenth ul ul ul,\r\n*/\r\n#primary-nav ul,\r\n#primary-nav li:hover ul,\r\n#primary-nav li:hover ul ul,\r\n#primary-nav li.menuparenth ul,\r\n#primary-nav li.menuparenth ul ul {\r\n	display: none;\r\n}\r\n/* for fourth level add\r\n#primary-nav ul ul ul li:hover ul,\r\n#primary-nav ul ul ul li.menuparenth ul,\r\n*/\r\n#primary-nav li:hover ul,\r\n#primary-nav ul li:hover ul,\r\n#primary-nav ul ul li:hover ul,\r\n#primary-nav li.menuparenth ul,\r\n#primary-nav ul li.menuparenth ul,\r\n#primary-nav ul ul li.menuparenth ul {\r\n	display: block;\r\n}\r\n/* IE6 Hacks */\r\n#primary-nav li li {\r\n	float: left;\r\n	clear: both;\r\n}\r\n#primary-nav li li a {\r\n	height: 1%;\r\n}
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Navigation CSSMenu - Horizontal');
$css->set_description('Navigation CSS rules used in CSSMenu top + 2 columns Design');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
div#news {\n/* margin for the entire div surrounding the news items */\n	margin: 2em 0 1em 1em;\n/* border set here */\n	border: 1px solid #909799;\n/* sets it off from surroundings */\n	background: #f5f5f5;\n}\ndiv#news h2 {\n	line-height: 2em;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/darknav.png) repeat-x left center;\n	color: #f5f5f5;\n	border: none\n}\n.NewsSummary {\n/* padding for the news article summary */\n	padding: 0.5em 0.5em 1em;\n/* margin to the bottom of the news article summary */\n	margin: 0 0.5em 1em 0.5em;\n	border-bottom: 1px solid #ccc;\n}\n.NewsSummaryPostdate {\n/* smaller than default text size */\n	font-size: 90%;\n/* bold to set it off from text */\n	font-weight: bold;\n}\n.NewsSummaryLink {\n/* bold to set it off from text */\n	font-weight: bold;\n/* little more room at top */\n	padding-top: 0.2em;\n}\n.NewsSummaryCategory {\n/* italic to set it off from text */\n	font-style: italic;\n	margin: 5px 0;\n}\n.NewsSummaryAuthor {\n/* italic to set it off from text */\n	font-style: italic;\n	padding-bottom: 0.5em;\n}\n.NewsSummarySummary, .NewsSummaryContent {\n/* larger than default text */\n	line-height: 140%;\n}\n.NewsSummaryMorelink {\n	padding-top: 0.5em;\n}\n#NewsPostDetailDate {\n/* smaller text */\n	font-size: 90%;\n	margin-bottom: 5px;\n/* bold to set it off from text */\n	font-weight: bold;\n}\n#NewsPostDetailSummary {\n/* larger than default text */\n	line-height: 150%;\n}\n#NewsPostDetailCategory {\n/* italic to set it off from text */\n	font-style: italic;\n	border-top: 1px solid #ccc;\n	margin-top: 0.5em;\n	padding: 0.2em 0;\n}\n#NewsPostDetailContent {\n	margin-bottom: 15px;\n/* larger than default text */\n	line-height: 150%;\n}\n#NewsPostDetailAuthor {\n	padding-bottom: 1.5em;\n/* italic to set it off from text */\n	font-style: italic;\n}\n/* more divs, left unstyled, just so you know the IDs of them */ \n#NewsPostDetailTitle {\n}\n#NewsPostDetailHorizRule {\n}\n#NewsPostDetailPrintLink {\n}\n#NewsPostDetailReturnLink {\n}\ndiv#news ul li {\n	padding: 2px 2px 2px 5px;\n	margin-left: 20px;\n}
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Module News');
$css->set_description('Default News module CSS rules used in multiple Designs');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
/********************MENU*********************/\n/* hack for IE6 */\n* html div#menu_horiz {\n/* hide ie/mac \\*/\n	height: 1%;\n/* end hide */\n}\ndiv#menu_horiz {\n/* background color for the entire menu row */\n	background-color: #243135;\n/* insure full width */\n	width: 100%;\n/* set height */\n	height: 49px;\n	margin: 0;\n}\ndiv#menu_horiz ul {\n/* remove any default bullets */\n	list-style-type: none;\n	margin: 0;\n/* pushes the menu div up to give room above for background color to show */\n	padding-top: 10px;\n/* keeps the first menu item off the left side */\n	padding-left: 10px;\n}\n/* menu list items */\ndiv#menu_horiz li {\n/* makes the list horizontal */\n	float: left;\n/* remove any default bullets */\n	list-style: none;\n/* still no margin */\n	margin: 0;\n}\n/* the links, that is each list item */\ndiv#menu_horiz a, div#menu_horiz h3 span, div#menu_horiz .sectionheader span {\n/* pushes li out from the text, sort of like making links a certain size, if you give them a set width and/or height you may limit you ability to have as much text as you need */\n	padding: 12px 15px 15px 0px;\n/* still no margin */\n	margin: 0;\n/* removes default underline */\n	text-decoration: none;\n/* default link color */\n	color: #FFF;\n/* makes it hold a shape, IE has problems with this, fixed above */\n	display: block;\n}\n/* hover state for links */\ndiv#menu_horiz li a:hover {;\n/* set your image here, dark grey image with white text set above*/\n	background:  url([[root_url]]/uploads/ngrey/nav.png) repeat-x left -50px;\n}\ndiv#menu_horiz a span {\n/* compensates for no left padding on the "a" */\n	padding-left: 15px;\n}\ndiv#menu_horiz li.parent a span {\n/* no left padding on the "a" we can set it here, it lets us use the span for an image */\n	padding-left: 20px;\n/* set your image here, down arrow to note it has children, left side of text */\n	background: url([[root_url]]/uploads/ngrey/active.gif) no-repeat 0.3em center;\n}\ndiv#menu_horiz li.parent a:hover span {\n	padding-left: 20px;\n/* hover replaces default with right arrow image */\n	background: url([[root_url]]/uploads/ngrey/parent.gif) no-repeat 0.3em center;\n}\ndiv#menu_horiz li.menuactive a span {\n	padding-left: 20px;\n/* menuactive replaces default with right arrow image */\n	background: url([[root_url]]/uploads/ngrey/parent.gif) no-repeat 0.5em center;\n	color: #000;\n}\ndiv#menu_horiz li.currentpage h3 span {\n	padding-left: 12px;\n/* menuactive replaces default with right arrow image */\n	background: url([[root_url]]/uploads/ngrey/nav.png) repeat-x left 0px;\n	color: #000;\n}\ndiv#menu_horiz .sectionheader span {\n/* compensates for no left padding on the "sectionheader" */\n	padding-left: 15px;\n}\n/* active parent, that is the first level parent of a child page that is the current page */\ndiv#menu_horiz li.menuactive, div#menu_horiz li.menuactive a:hover {\n/* set your image here, light image with #000/black text set below*/\n	background:  url([[root_url]]/uploads/ngrey/nav.png) repeat-x left 0px;\n	color: #000;\n}
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Navigation Simple - Horizontal');
$css->set_description('Navigation CSS rules used in Top simple navigation + left subnavigation + 1 column and Left simple navigation + 1 column Designs');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
/* browsers interpret margin and padding a little differently, we'll remove all default padding and margins and set them later on */\n* {\n	margin: 0;\n	padding: 0;\n}\n/*Set initial font styles*/\nbody {\n	text-align: left;\n	font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;\n	font-size: 75.01%;\n	line-height: 1em;\n}\n/*set font size for all divs, this overrides some body rules*/\ndiv {\n	font-size: 1em;\n}\n/*if img is inside "a" it would have borders, we don't want that*/\nimg {\n	border: 0;\n}\n/*default link styles*/\n/* set all links to have underline and bluish color */\na, a:link a:active {\n	text-decoration: underline;\n/* css validation will give a warning if color is set without background color. this will explicitly tell this element to inherit bg colour from parent element */\n	background-color: inherit;\n	color: #18507C;\n}\na:visited {\n	text-decoration: underline;\n	background-color: inherit;\n	color: #18507C;\n/* a different color can be used for visited links */\n}\n/* remove underline on hover and change color */\na:hover {\n	text-decoration: none;\n	background-color: inherit;\n	color: #385C72;\n}\n/*****************basic layout *****************/\nbody {\n	margin: 0;\n	padding: 0;\n/* default text color for entire site*/\n	color: #333;\n/* you can set your own image and background color here */\n	background: #f4f4f4 url([[root_url]]/uploads/ngrey/body.png) repeat-x left top;\n}\ndiv#pagewrapper {\n/* min max width, IE wont understand these, so we will use java script magic in the <head> */\n	max-width: 99em;\n	min-width: 60em;\n/* now that width is set this centers wrapper */\n	margin: 0 auto;\n	background-color: #fefefe;\n	color: black;\n}\n/* header, we will hide h1 a text and replace it with an image, we assign a height for it so the image wont cut off */\ndiv#header {\n/* adjust according your image size */\n	height: 100px;\n	margin: 0;\n	padding: 0;\n	/* you can set your own image here, will go behind h1 a image */\n	background: #f4f4f4 url([[root_url]]/uploads/ngrey/bg_banner.png) repeat-x left top;\n/* border just the bottom */\n	border-bottom: 1px solid #D9E2E6;\n}\ndiv#header h1 a {\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/logoCMS.png) no-repeat left top;\n/* this will make the "a" link a solid shape */\n	display: block;\n/* adjust according your image size */\n	height: 100px;\n/* this hides the text */\n	text-indent: -999em;\n/* old firefox would have shown underline for the link, this explicitly hides it */\n	text-decoration: none;\n}\ndiv#header h1 {\n	margin: 0;\n	padding: 0;\n/*these keep IE6 from pushing the header to more than the set size*/\n	line-height: 0;\n	font-size: 0;\n/* this will keep IE6 from flickering on hover */\n	background: url([[root_url]]/uploads/ngrey/logoCMS.png) no-repeat left top;\n}\ndiv#header h2 {\n/* this is where the site name is */\n	float: right;\n	line-height: 1.2em;\n/* this keeps IE6 from not showing the whole text */\n	font-size: 1.5em;\n/* keeps the size uniform */\n	margin: 35px 65px 0px 0px;\n/* adjust according your text size */\n	color: #f4f4f4;\n}\ndiv.crbk {\n/* sets all to 0 */\n	margin: 0;\n	padding: 0;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/mainrtup.gif) no-repeat right bottom;\n}\ndiv.breadcrumbs {\n/* CSS short hand rule first value is top then right, bottom and left */\n	padding: 1em 0em 1em 1em;\n/* its good to set font sizes to be relative, this way viewer can change his/her font size */\n	font-size: 90%;\n/* css shorthand rule will be opened to be "0px 0px 0px 0px" */\n	margin: 0px;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/mainleftup.gif) no-repeat left bottom;\n}\ndiv.breadcrumbs span.lastitem {\n	font-weight: bold;\n}\ndiv#search {\n/* position for the search box */\n	float: right;\n/* enough width for the search input box */\n	width: 27em;\n	text-align: right;\n	padding: 0.5em 0 0.2em 0;\n	margin: 0 1em;\n}\n/* a class for Submit button for the search input box */\ninput.search-button {\n	border: none;\n	height: 22px;\n	width: 53px;\n	margin-left: 5px;\n	padding: 0px 2px 2px 0px;\n/* makes the hover cursor show, you can set your own cursor here */\n	cursor: pointer;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/search.gif) no-repeat center center;\n}\ndiv#content {\n/* some air above and under menu and content */\n	margin: 1.5em auto 2em 0;\n	padding: 0px;\n}\n/* this gets all the outside calls that were used on the div#main before  */\ndiv.back1 {\n/* this will give room for sidebar to be on the left side, make sure this number is bigger than sidebar width */\n	margin-left: 29%;\n/* and some air on the right */\n	margin-right: 2%;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/mainrt1.gif) no-repeat right top;\n}\n/* this is an IE6 hack, you may see these through out the CSS */\n* html div.back1 {\n/* unlike other browser IE6 needs float:right and a width */\n	float: right;\n	width: 69%;\n/* and we take this out or it will stop at the bottom  */\n	margin-left: 0%;\n/* and some air on the right */\n	margin-right: 10px;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/mainrt1.gif) no-repeat right top;\n}\ndiv.back2 {\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/mainleft1.gif) no-repeat left top;\n}\ndiv.back3 {\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/wbtmleft.gif) no-repeat left bottom;\n}\ndiv#main {\n/* this is the last inside div so we set the space inside it to keep all content away from the edges of images/box */\n	padding: 10px 15px;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/rtup.gif) no-repeat right bottom;\n}\ndiv#sidebar {\n/* set sidebar left. Change to right, float: right; instead, but you will need to change the margins. */\n	float: left;\n/* sidebar width, if you change this change div.back and/or div.back1 margins */\n	width: 26%;\n/* FIX IE double margin bug */\n	display: inline;\n/* the 20px is on the bottom, insures space above footer if longer than content */\n	margin: 0px 0px 20px;\n	padding: 0px;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/mainrt.gif) no-repeat right top;\n}\ndiv#sidebarb {\n	padding: 10px 15px 10px 20px;\n/* this one is for sidebar with content and no menu */\n	background: url([[root_url]]/uploads/ngrey/mainrtup.gif) no-repeat right bottom;\n}\ndiv#sidebarb div#news {\n/* less margin surrounding the news, sidebarb has enough */\n	margin: 2em 0 1em 0em;\n}\ndiv#sidebara {\n	padding: 10px 15px 15px 0px;\n/* this one is for sidebar with menu and no content */\n	background: url([[root_url]]/uploads/ngrey/mainrtup.gif) no-repeat right bottom;\n}\ndiv.footback {\n/* keep footer below content and menu */\n	clear: both;\n/* this sets 10px on right to let the right image show, the balance 10px left on next div */\n	padding: 0px 10px 0px 0px;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/wfootrt.gif) no-repeat right top;\n}\ndiv#footer {\n/* this sets 10px on left to balance 10px right on last div */\n	padding: 0px 0px 0px 10px;\n/* color of text, the link color is set below */\n	color: #595959;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/wtopleft.gif) no-repeat left top;\n}\ndiv.leftfoot {\n	float: left;\n	width: 30%;\n	margin-left: 20px\n}\ndiv#footer p {\n/* sets different font size from default */\n	font-size: 0.8em;\n/* some air for footer */\n	padding: 1.5em;\n/* centered text */\n	text-align: center;\n	margin: 0;\n}\ndiv#footer p a {\n/* footer link would be same color as default we want it same as footer text */\n	color: #595959;\n}\n/* as we hid all hr for accessibility we create new hr with div class="hr" element */\ndiv.hr {\n	height: 1px;\n	padding: 1em;\n	border-bottom: 1px dotted black;\n	margin: 1em;\n}\n/* relational links under content */\ndiv.left49 {\n/* combined percentages of left+right equaling 100%  might lead to rounding error on some browser */\n	width: 70%;\n}\ndiv.right49 {\n	float: right;\n	width: 29%;\n/* set right to keep text on right */\n	text-align: right;\n}\n/********************CONTENT STYLING*********************/\n/* HEADINGS */\ndiv#content h1 {\n/* font size for h1 */\n	font-size: 2em;\n	line-height: 1em;\n	margin: 0;\n}\ndiv#content h2 {\n	color: #294B5F;\n/* font size for h2 the higher the h number the smaller the font size, most times */\n	font-size: 1.5em;\n	text-align: left;\n/* some air around the text */\n	padding-left: 0.5em;\n	padding-bottom: 1px;\n/* set borders around header */\n	border-bottom: 1px solid #899092;\n	border-left: 1.1em solid #899092;\n/* a larder than h1 line height */\n	line-height: 1.5em;\n/* and some air under the border */\n	margin: 0 0 0.5em 0;\n}\ndiv#content h3 {\n	color: #294B5F;\n	font-size: 1.3em;\n	line-height: 1.3em;\n	margin: 0 0 0.5em 0;\n}\ndiv#content h4 {\n	color: #294B5F;\n	font-size: 1.2em;\n	line-height: 1.3em;\n	margin: 0 0 0.25em 0;\n}\ndiv#content h5 {\n	color: #294B5F;\n	font-size: 1.1em;\n	line-height: 1.3em;\n	margin: 0 0 0.25em 0;\n}\nh6 {\n	color: #294B5F;\n	font-size: 1em;\n	line-height: 1.3em;\n	margin: 0 0 0.25em 0;\n}\n/* END HEADINGS */\n/* TEXT */\np {\n/* default p font size, this is set different in some other divs */\n	font-size: 1em;\n/* some air around p elements */\n	margin: 0 0 1.5em 0;\n	line-height: 1.4em;\n	padding: 0;\n}\nblockquote {\n	border-left: 10px solid #ddd;\n	margin-left: 10px;\n}\nstrong, b {\n/* explicit setting for these */\n	font-weight: bold;\n}\nem, i {\n/* explicit setting for these */\n	font-style: italic;\n}\n/* Wrapping text in <code> tags. Makes CSS not validate */\ncode, pre {\n/* css-3 */\n	white-space: pre-wrap;\n/* Mozilla, since 1999 */\n	white-space: -moz-pre-wrap;\n/* Opera 4-6 */\n	white-space: -pre-wrap;\n/* Opera 7 */\n	white-space: -o-pre-wrap;\n/* Internet Explorer 5.5+ */\n	word-wrap: break-word;\n	font-family: "Courier New", Courier, monospace;\n	font-size: 1em;\n}\npre {\n/* black border for pre blocks */\n	border: 1px solid #000;\n/* set different from surroundings to stand out */\n	background-color: #ddd;\n	margin: 0 1em 1em 1em;\n	padding: 0.5em;\n	line-height: 1.5em;\n	font-size: 90%;\n}\n/* Separating the divs on the template explanation page */\ndiv.templatecode {\n	margin: 0 0 2.5em;\n}\n/* END TEXT */\n/* LISTS */\n/* lists in content need some margins to look nice */\ndiv#main ul,\ndiv#main ol,\ndiv#main dl {\n	font-size: 1.0em;\n	line-height: 1.4em;\n	margin: 0 0 1.5em 0;\n}\ndiv#main ul li,\ndiv#main ol li {\n	margin: 0 0 0.25em 3em;\n}\n/* definition lists topics on bold */\ndiv#main dl {\n	margin-bottom: 2em;\n	padding-bottom: 1em;\n	border-bottom: 1px solid #c0c0c0;\n}\ndiv#main dl dt {\n	font-weight: bold;\n	margin: 0 0 0 1em;\n}\ndiv#main dl dd {\n	margin: 0 0 1em 1em;\n}\n/* END LISTS */
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Layout Top menu + 2 columns');
$css->set_description('Navigation CSS rules used in CSSMenu top + 2 columns, ShadowMenu Tab + 2 columns and Top simple navigation + left subnavigation + 1 column Designs');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
/******************** MENU *********************/\n#menu_vert {\n	margin: 0;\n	padding: 0;\n}\n#menu_vert ul {\n/* remove any bullets */\n	list-style: none;\n/* margin/padding set in li */\n	margin: 0px;\n	padding: 0px;\n}\n#menu_vert ul ul {\n	margin: 0;\n/* padding right sets second level li in on right from first li */\n	padding: 0px 5px 0px 0px;\n/* replaces bottom of li.menuactive menuparent, looks like li below it, set in 5px more, is sitting on top of it */\n	background: transparent url([[root_url]]/uploads/ngrey/liup.gif) no-repeat right -4px;\n}\n#menu_vert li {\n/* remove any bullets */\n	list-style: none;\n/* negative bottom margin pulls them together, images look like one border between */\n	margin: 0px 0px -1px;\n/* bottom padding pushes "a" up enough to show our image */\n	padding: 0px 0px 4px 0px;\n/* you can set your own image here */\n	background: transparent url([[root_url]]/uploads/ngrey/liup.gif) no-repeat right bottom;\n}\n#menu_vert li.currentpage {\n	padding: 0px 0px 3px 0px;\n}\n#menu_vert li.menuactive {\n	margin: 0;\n	padding: 0px;\n/* replaced by image in ul ul */\n	background: none;\n}\n#menu_vert li.menuactive ul {\n	margin: 0;\n}\n#menu_vert li.activeparent {\n	margin: 0;\n	padding: 0px;\n}\n/* fix stupid IE6 bug with display:block; */\n* html #menu_vert li {\n	height: 1%;\n}\n* html #menu_vert li a {\n	height: 1%;\n}\n* html #menu_vert li hr {\n	height: 1%;\n}\n/** end fix **/\n/* first level links */\ndiv#menu_vert a {\n/* IE6 has problems with this, fixed above */\n	display: block;\n/* some air for it */\n	padding: 0.8em 0.3em 0.5em 1.5em;\n/* this will be link color for all levels */\n	color: #18507C;\n/* Fixes IE7 whitespace bug */\n	min-height: 1em;\n/* no underline for links */\n	text-decoration: none;\n/* you can set your own image here this is tall enough to cover text heavy links */\n	background: transparent url([[root_url]]/uploads/ngrey/libk.gif) no-repeat right top;\n}\n/* next level links, more padding and smaller font */\ndiv#menu_vert ul ul a {\n	font-size: 90%;\n	padding: 0.8em 0.3em 0.5em 2.8em;\n}\n/* third level links, more padding */\ndiv#menu_vert ul ul ul a {\n	padding: 0.5em 0.3em 0.3em 3em;\n}\n/* hover state for all links */\ndiv#menu_vert a:hover {\n	background-color: transparent;\n	color: #595959;\n	text-decoration: underline;\n}\ndiv#menu_vert a.activeparent:hover {\n	color: #595959;\n}\n/* active parent, that is the first level parent of a child page that is the current page */\ndiv#menu_vert li.activeparent {\n/* you can set your own image here */\n	background: transparent url([[root_url]]/uploads/ngrey/liup.gif) no-repeat right -65px;\n/* white to contrast with background image */\n	color: #fff;\n}\ndiv#menu_vert li.activeparent a.activeparent {\n/* you can set your own image here */\n	background: transparent url([[root_url]]/uploads/ngrey/libk.gif) no-repeat right top;\n/* to contrast with background image */\n	color: #000;\n}\ndiv#menu_vert li a.parent {\n/* takes left padding out so span image has room on left */\n	padding-left: 0em;\n}\ndiv#menu_vert ul ul li a.parent {\n/* increased padding on left offsets it from one above */\n	padding-left: 0.9em;\n}\ndiv#menu_vert li a.parent span {\n	display: block;\n	margin: 0;\n/* adds left padding taken out of "a.parent" */\n	padding-left: 1.5em;\n/* arrow on left for pages with children, points down, you can set your own image here */\n	background: transparent url([[root_url]]/uploads/ngrey/active.png) no-repeat 2px center;\n}\ndiv#menu_vert li a.parent:hover {\n/* removes underline hover effect */\n	text-decoration: none;\n}\ndiv#menu_vert li a.parent:hover span {\n	display: block;\n	margin: 0;\n	padding-left: 1.5em;\n/* arrow on left for pages with children, points right for hover, you can set your own image here */\n	background: transparent url([[root_url]]/uploads/ngrey/parent.png) no-repeat 2px center;\n}\ndiv#menu_vert li a.menuactive.menuparent {\n/* sets it in a little more than a.parent */\n	padding-left: 0.35em;\n}\ndiv#menu_vert ul ul li a.menuactive.menuparent {\n/* sets it in a little more on next level */\n	padding-left: 0.99em;\n}\ndiv#menu_vert li a.menuactive.menuparent span {\n	display: block;\n	margin: 0;\n/* to contrast with non active pages */\n	font-weight: bold;\n	padding-left: 1.5em;\n/* arrow on left for active pages with children, points right, you can set your own image here */\n	background: transparent url([[root_url]]/uploads/ngrey/parent.png) no-repeat 2px center;\n}\ndiv#menu_vert li a.menuactive.menuparent:hover {\n	text-decoration: none;\n	color: #18507C;\n}\ndiv#menu_vert ul ul li a.activeparent {\n	color: #fff;\n}\n/* current pages in the default Menu Manager template are unclickable. This is for current page on first level */\ndiv#menu_vert ul h3 {\n	display: block;\n/* some air for it */\n	padding: 0.8em 0.5em 0.5em 1.5em;\n/* this will be link color for all levels */\n	color: #000;\n/* instead of the normal font size for <h3> */\n	font-size: 1em;\n/* as <h3> normally has some margin by default */\n	margin: 0;\n/* you can set your own image here, same as "a" */\n	background: transparent url([[root_url]]/uploads/ngrey/libk.gif) no-repeat right top;\n}\n/* next level current pages, more padding, smaller font and no background color or bottom border */\ndiv#menu_vert ul ul h3 {\n	font-size: 90%;\n	padding: 0.8em 0.5em 0.5em 2.8em;\n/* you can set your own image here, same as "a" */\n	background: transparent url([[root_url]]/uploads/ngrey/libk.gif) no-repeat right top;\n	color: #000;\n}\n/* current page on third level, more padding */\ndiv#menu_vert ul ul ul h3 {\n	padding: 0.6em 0.5em 0.2em 3em;\n}\n/* BIG NOTE: I didn''t do anything to these, never tested */\n/* section header */\ndiv#menu_vert li.sectionheader {\n	border-right: none;\n	padding: 0.8em 0.5em 0.5em 1.5em;\n	background: transparent url([[root_url]]/uploads/ngrey/libk.gif) no-repeat right top;\n	line-height: 1em;\n	margin: 0;\n        color: #18507C;\n        cursor:text;\n}\n/* separator */\ndiv#menu_vert .separator {\n	height: 1px !important;\n	margin-top: -1px;\n	margin-bottom: 0;\n	-padding: 2px 0 2px 0;\n	background-color: #000;\n	overflow: hidden !important;\n	line-height: 1px !important;\n	font-size: 1px;\n/* for ie */\n}\ndiv#menu_vert li.separator hr {\n	display: none;\n/* this is for accessibility */\n}
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Navigation Simple - Vertical');
$css->set_description('Navigation CSS rules used in Left simple navigation + 1 column and Top simple navigation + left subnavigation + 1 column Designs');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
/* by Alexander Endresen and mark */\n#menu_vert {\n/* no margin/padding so it fills the whole div */\n	margin: 0;\n	padding: 0;\n}\n.clearb {\n/* needed for some browsers */\n	clear: both;\n}\n#menuwrapper {\n/* set the background color for the menu here */\n	background-color: #243135;\n/* IE6 Hack */\n	height: 1%;\n	width: auto;\n/* one border at the top */\n	border-top: 1px solid #3F565C;\n	margin: 0;\n	padding: 0;\n}\nul#primary-nav {\n	list-style-type: none;\n	margin: 0px;\n	padding-top: 10px;\n	padding-left: 10px;\n}\n#primary-nav ul {\n/* remove any default bullets */\n	list-style-type: none;\n/* sets width of second level ul to background image */\n	width: 210px;\n	margin: 0px;\n	padding: 0px;\n/* make the ul stay in place so when we hover it lets the drops go over the content instead of displacing it */\n	position: absolute;\n/* top being the bottom of the li it comes out of */\n	top: auto;\n/* keeps it hidden till hover event */\n	display: none;\n/* room at top for li so image top shows correct */\n	padding-top: 9px;\n/* set your image here, tall enough for the ul */\n	background: url([[root_url]]/uploads/ngrey/ultopup.png) no-repeat left top;\n}\n/* IE6 hacks on the above code */\n* html #primary-nav ul {\n	padding-top: 13px;\n	background: url([[root_url]]/uploads/ngrey/ultopup.gif) no-repeat left top;\n}\n#primary-nav ul ul {\n/* insures no top margins */\n	margin-top: 0px;\n/* pulls the last ul back over the preceding ul */\n	margin-left: -1px;\n/* keeps the left side of this ul on the right side of the preceding ul */\n	left: 100%;\n/* negative margin pulls the left centered in li next to it */\n	top: -3px;\n/* set your image here, tall enough for the ul, this is the left arrow for third level ul */\n	background: url([[root_url]]/uploads/ngrey/ultoprt.png) no-repeat left top;\n}\n/* IE6 hacks on the above code */\n* html #primary-nav ul ul {\n	margin-top: 0px;\n	padding-left: 5px;\n	left: 100%;\n	top: -7px;\n/* IE6 gets gif as it can''t handle transparent png */\n	background: url([[root_url]]/uploads/ngrey/ultoprt.gif) no-repeat right top;\n}\n#primary-nav li {\n/* a little space to the left of each top level menu item */\n	margin-left: 5px;\n/* floating left will set menu items to line up left to right else they will stack top to bottom */\n	float: left;\n}\n#primary-nav li li {\n/* a little more space to the left of each menu item */\n	margin-left: 8px;\n/* keeps them tight to the one above, no missed hovers */\n	margin-top: -1px;\n/* removes the left float set in first li so these will stack from top down */\n	float: none;\n/* relative to the ul they are in */\n	position: relative;\n}\n/* IE6 hacks on the above code */\n* html #primary-nav li li {\n	margin-left: 6px;\n/* helps hold it inside the ul */\n	width: 171px;\n}\nul#primary-nav li a {\n/* specific font size, this could be larger or smaller than default font size */\n	font-size: 1em;\n/* make sure we keep the font normal */\n	font-weight: normal;\n/* set default link colors */\n	color: #fff;\n/* doing tab menus require a bit different padding, this will give room on right for image to show, adjust to width of your image */\n	padding: 0px 11px 0px 0px;\n/* makes it hold a shape */\n	display: block;\n/* remove default "a" underline */\n	text-decoration: none;\n}\nul#primary-nav li a span {\n/* takes normal "a" padding minus some for right image */\n	padding: 12px 4px 12px 15px;\n/* makes it hold a shape */\n	display: block;\n}\nul#primary-nav li a:hover {\n/* kind of obvious */\n	background-color: transparent;\n}\nul#primary-nav li {\n/* set your image here */\n	background:  url([[root_url]]/uploads/ngrey/navrttest.gif) no-repeat right -51px;\n}\nul#primary-nav li span {\n/* set your image here */\n	background:  url([[root_url]]/uploads/ngrey/navlefttest.gif) repeat-x left -51px;\n/* set text color here also to insure color */\n	color: #fff;\n/* just to be sure */\n	font-weight: normal;\n}\nul#primary-nav li li {\n/* remove any image set in first level li */\n	background:  none;\n}\nul#primary-nav li li span {\n/* remove any image set in first level li span */\n	background:  none;\n/* set text color here also to insure color */\n	color: #fff;\n/* just to be sure */\n	font-weight: normal;\n}\nul#primary-nav li:hover,\nul#primary-nav li.menuh,\nul#primary-nav li.menuparenth {\n/* set hover image, right side */\n	background:  url([[root_url]]/uploads/ngrey/navrttest.gif) no-repeat right 0px;\n}\nul#primary-nav li:hover span,\nul#primary-nav li.menuh span,\nul#primary-nav li.menuparenth span {\n/* set hover image, left side */\n	background:  url([[root_url]]/uploads/ngrey/navlefttest.gif) repeat-x left 0px;\n/* change text color on hover */\n	color: #000;\n	font-weight: normal;\n}\n/* IE6 hacks, the JS used for hover effect in IE6 puts class menuh on li, unless they have a class then just an "h" as seen above and below */\nul#primary-nav li li.menuh {\n	background:  none;\n	font-weight: normal;\n}\n/* IE6 hacks */\nul#primary-nav li.menuparenth li span {\n	background:  none;\n	color: #000;\n	font-weight: normal;\n}\n/* IE6 hacks */\nul#primary-nav li.menuparenth li.menuparent span {\n/* gif for IE6, as it can''t handle transparent png */\n	background:  url([[root_url]]/uploads/ngrey/parent.gif) no-repeat right center;\n	color: #000\n}\n/* IE6 hacks */\nul#primary-nav li.menuparenth li.menuh span {\n	background:  none;\n	color: #FFF;\n	font-weight: normal;\n}\n/* IE6 hacks */\nul#primary-nav li.menuparenth li.menuparenth {\n	background:  none;\n	color: #FFF;\n	font-weight: normal;\n}\nul#primary-nav li.menuactive a {\n/* set your image here for active tab right */\n	background:  url([[root_url]]/uploads/ngrey/navrttest.gif) no-repeat right 0px;\n}\nul#primary-nav li a.menuactive span {\n/* set your image here for active tab left */\n	background:  url([[root_url]]/uploads/ngrey/navlefttest.gif) repeat-x left 0px;\n/* non active is #FFF/white, we need #000/black to contrast with light background */\n	color: #000;\n/* bold to set it off from non active */\n	font-weight: bold;\n}\n#primary-nav li li a {\n/* second level padding, no image and not as big */\n	padding: 5px 10px;\n/* to keep it within li */\n	width: 165px;\n/* space between them */\n	margin: 5px;\n	background: none;\n}\n/* IE6 hacks to above code */\n* html #primary-nav li li a {\n	padding: 5px 10px;\n	width: 165px;\n	margin: 0px;\n	color: #000;\n}\n#primary-nav li li:hover {\n/* remove image set in first level */\n	background: none;\n}\n#primary-nav li li a:hover {\n/* set different image than first level */\n	background:  url([[root_url]]/uploads/ngrey/darknav.png) repeat-x left center;\n/* we need #FFF/white to contrast with dark background */\n	color: #FFF;\n}\n#primary-nav li.menuparent li a:hover span {\n/* insures text color */\n	color: #FFF;\n}\nul#primary-nav li:hover li a span {\n/* first level is #FFF/white, we need #000/black to contrast with light background */\n	color: #000;\n/* just to insure normal */\n	font-weight: normal;\n}\n#primary-nav li li.menuactive a.menuactive, #primary-nav li li.menuactive a.menuactive:hover {\n/* set your image here, lighter than hover */\n	background:  url([[root_url]]/uploads/ngrey/nav.png) repeat-x left 0px;\n/* non active is #FFF/white, we need #000/black to contrast with light background */\n	color: #000;\n}\n#primary-nav li li.menuactive a.menuactive span {\n/* insures text color */\n	color: #000\n}\n#primary-nav li li.menuactive a.menuactive:hover span {\n/* insures text color */\n	color: #000;\n}\n/* IE6 hacks to above code */\n#primary-nav li li.menuparenth a.menuparent span {\n/* right arrow for menu parent, IE6 gif */\n	background:  url([[root_url]]/uploads/ngrey/parent.gif) no-repeat right center;\n	color: #000\n}\n/* IE6 hacks to above code */\n#primary-nav li li.menuparenth a.menuparent:hover span {\n	color: #FFF\n}\n#primary-nav li li.menuparent a.menuparent span {\n/* right arrow for parent item */\n	background:  url([[root_url]]/uploads/ngrey/parent.gif) no-repeat right center;\n}\n#primary-nav li.menuactive li a:hover span {\n/* black text */\n	color: #000\n}\nul#primary-nav li li a.menuactive  span {\n/* remove image set in first level */\n	background:  none;\n	font-weight: normal;\n}\n#primary-nav li.menuactive li a {\n/* second level active link color */\n	color: #0587A9;\n	text-decoration: none;\n	background: none;\n}\n#primary-nav li.menuactive li a:hover {\n/* dark image for hover */\n	background:  url([[root_url]]/uploads/ngrey/darknav.png) repeat-x left center;\n}\n#primary-nav li.menuactive li a:hover span {\n/* white text to contrast with dark background image on hover */\n	color: #FFF;\n}\nul#primary-nav li:hover li a span, ul#primary-nav li.menuparenth li a span {\n	padding: 0px;\n	background:  none;\n}\n/* this is a special li type from the menu template, used to hold the bottom image for ul set above */\n#primary-nav ul li.separator, #primary-nav .separator:hover {\n/* set same as ul */\n	width: 210px;\n/* height of image */\n	height: 9px;\n/* negative margin pulls it down to cover ul image */\n	margin: 0px 0px -8px;\n/* set your image here */\n	background: url([[root_url]]/uploads/ngrey/ulbtmrt.png) no-repeat left bottom;\n}\n/* same as above for next level to insure it shows correct */\n#primary-nav ul ul li.separator, #primary-nav ul ul li.separator:hover {\n	height: 9px;\n	margin: 0px 0px -8px;\n	background: url([[root_url]]/uploads/ngrey/ulbtmrt.png) no-repeat left bottom;\n}\n/* IE6 hacks */\n* html #primary-nav ul li.separator {\n	height: 2px;\n	background: url([[root_url]]/uploads/ngrey/ulbtmrt.gif) no-repeat left bottom;\n}\n/* IE6 hacks */\n* html #primary-nav ul li.separatorh {\n	margin: 0px 0px -8px;\n	height: 2px;\n	background: url([[root_url]]/uploads/ngrey/ultop.gif) no-repeat left top;\n}\n/* The magic - set to work for up to a 3 level menu, but can be increased unlimited, for fourth level add\n#primary-nav li:hover ul ul ul,\n#primary-nav li.menuparenth ul ul ul,\n*/\n#primary-nav ul,\n#primary-nav li:hover ul,\n#primary-nav li:hover ul ul,\n#primary-nav li.menuparenth ul,\n#primary-nav li.menuparenth ul ul {\n	display: none;\n}\n/* for fourth level add\n#primary-nav ul ul ul li:hover ul,\n#primary-nav ul ul ul li.menuparenth ul,\n*/\n#primary-nav li:hover ul,\n#primary-nav ul li:hover ul,\n#primary-nav ul ul li:hover ul,\n#primary-nav li.menuparenth ul,\n#primary-nav ul li.menuparenth ul,\n#primary-nav ul ul li.menuparenth ul {\n	display: block;\n}\n/* IE Hacks */\n#primary-nav li li {\n	float: left;\n	clear: both;\n}\n#primary-nav li li a {\n	height: 1%;\n}
EOT;
$css = new CmslayoutStylesheet;
$css->set_name('Navigation ShadowMenu - Horizontal');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
/* Vertical menu for the CMS CSS Menu Module */\n/* by Alexander Endresen and mark */\n#menuwrapper {\n/* just smaller than it's containing div */\n	width: 95%;\n	margin-left: 0px;\n/* room at bottom */\n	margin-bottom: 10px;\n}\n/* Unless you know what you do, do not touch this */\n#primary-nav, #primary-nav ul {\n/* remove any default bullets */\n	list-style: none;\n	margin: 0px;\n	padding: 0px;\n/* make sure it fills out */\n	width: 100%;\n/* just a little bump */\n	margin-left: 1px;\n}\n#primary-nav li {\n/* negative bottom margin pulls them together, images look like one border between */\n	margin-bottom: -1px;\n/* keeps within it's container */\n	position: relative;\n/* bottom padding pushes "a" up enough to show our image */\n	padding: 0px 0px 4px 0px;\n/* you can set your own image here */\n	background: url([[root_url]]/uploads/ngrey/liup.gif) no-repeat right bottom;\n}\n#primary-nav li li {\n/* you can set your width here, if no width or set auto it will only be as wide as the text in it  */\n	width: 190px;\n/* changes padding inherited from first level */\n	padding: 0px 10px;\n/* removes first level li image */\n	background-image: none;\n}\n/* Styling the basic appearance of the menu "a" elements */\nul#primary-nav li a {\n/* specific font size, this could be larger or smaller than default font size */\n	font-size: 1em;\n/* make sure we keep the font normal */\n	font-weight: normal;\n/* set default link colors */\n	color: #595959;\n/* pushes li out from the text, sort of like making links a certain size, if you give them a set width and/or height you may limit you ability to have as much text as you need */\n	padding: 0.8em 0.5em 0.5em 0.5em;\n/* makes it hold a shape */\n	display: block;\n/* removes underline from default link setting */\n	text-decoration: none;\n/* you can set your own image here this is tall enough to cover text heavy links */\n	background: url([[root_url]]/uploads/ngrey/libk.gif) no-repeat right top;\n}\nul#primary-nav a span {\n/* makes it hold a shape */\n	display: block;\n/* pushes text to right */\n	padding-left: 1.5em;\n}\nul#primary-nav li a:hover {\n/* stops image flicker in some browsers */\n	background: url([[root_url]]/uploads/ngrey/libk.gif) no-repeat right top;\n/* changes text color on hover */\n	color: #899092\n}\nul#primary-nav li li a:hover {\n/* you can set your own image here, second level "a" */\n	background:  url([[root_url]]/uploads/ngrey/darknav.png) repeat-x left center;\n/* contrast color to image behind it */\n	color: #FFF\n}\nul#primary-nav li a.menuactive {\n/* black and bold to set it off from non active */\n	color: #000;\n	font-weight: bold;\n}\nul#primary-nav li ul a {\n/* insure alignment */\n	text-align: left;\n	margin: 0px;\n/* relative to it's container */\n	position: relative;\n/* even padding all 4 sides */\n	padding: 6px;\n/* make sure we keep the font normal */\n	font-weight: normal;\n/* set default link colors from here on */\n	color: #000;\n/* remove any background that may have been set in level above */\n	background: none;\n}\nul#primary-nav li ul {\n/* remove any default bullets */\n	list-style-type: none;\n/* sets width of second level ul to background image */\n	width: 209px;\n	height: auto;\n/* negative margin pulls it over the parent ul */\n	margin: 0px 0px 0px -2px;\n/* top padding gives room for image shadow and pushes li down into image */\n	padding: 10px 0px 0px;\n/* make the ul stay in place so when we hover it lets the drops go over the content instead of displacing it */\n	position: absolute;\n/* keeps the left side of this ul on the right side of the preceding ul */\n	left: 100%;\n/* negative top pulls up so left arrow centered in li next to it */\n	top: -2px;\n	display: none;\n/* set your image here, tall enough for the ul, this is the left arrow for second ul and on */\n	background: url([[root_url]]/uploads/ngrey/ultoprt.png) no-repeat left top;\n}\n/* a lot of the same as above, minor changes */\nul#primary-nav li ul ul {\n	list-style-type: none;\n/* bit more negative left margin */\n	margin: 0px 0px 0px -8px;\n/* you can call a property twice but not a property:'value', this flat lines it */\n	padding: 0px;\n/* now we just change one with 'property'-top:value */\n	padding-top: 10px;\n	position: absolute;\n	width: 209px;\n	height: auto;\n/* negative top pulls up so left arrow centered in li next to it, more on 3rd ul covers default drop increase */\n	top: -5px;\n	left: 100%;\n	display: none;\n/* set your image here */\n	background: url([[root_url]]/uploads/ngrey/ultoprt.png) no-repeat left top;\n}\n* html ul#primary-nav li ul {\n/* gif for IE6, as it can't handle transparent png */\n	background: url([[root_url]]/uploads/ngrey/ultoprt.gif) no-repeat left top;\n}\n* html ul#primary-nav li ul ul {\n/* gif for IE6, as it can't handle transparent png */\n	background: url([[root_url]]/uploads/ngrey/ultoprt.gif) no-repeat left top;\n}\n/* this is a special li type from the menu template, used to hold the bottom image for ul set above */\n#primary-nav ul li.separator, #primary-nav .separator:hover {\n/* set same as ul */\n	width: 209px;\n	padding: 0px;\n/* height of image */\n	height: 9px;\n/* negative margin pulls it down to cover ul image */\n	margin: 0px 0px -9px;\n/* set your image here */\n	background: url([[root_url]]/uploads/ngrey/ulbtmrt.png) no-repeat left bottom;\n}\n/* IE6 'star html' Hack */\n* html #primary-nav  li ul li.separator {\n	height: 2px;\n/* set your image here */\n	background: url([[root_url]]/uploads/ngrey/ulbtmrt.gif) no-repeat left bottom;\n}\n/* Fixes IE7 bug*/\n#primary-nav li, #primary-nav li.menuparent {\n	min-height: 1em;\n}\n/* Styling the basic apperance of the active page elements (shows what page in the menu is being displayed) */\n#primary-nav li li.menuactive a.menuactive {\n/* contrast color to image behind it */\n	color: #FFF;\n/* not bold as text color and image behind it set it off from non active */\n	font-weight: normal;\n/* set your image here, dark grey image with white text set above*/\n	background:  url([[root_url]]/uploads/ngrey/darknav.png) repeat-x left center;\n}\n#primary-nav li.menuparent span {\n/* padding on left for image */\n	padding-left: 1.5em;\n/* down arrow to note it has children, left side of text */\n	background: url([[root_url]]/uploads/ngrey/active.png) no-repeat left center;\n}\n#primary-nav li.menuparent:hover li.menuparent span {\n/* remove left padding as image is on right side of text */\n	padding-left: 0;\n/* right arrow to note it has children, right side of text */\n	background: url([[root_url]]/uploads/ngrey/parent.png) no-repeat right center;\n}\n#primary-nav li.menuparenth li.menuparent span,\n#primary-nav li.menuparenth li.menuparenth span {\n/* same as above but this is for IE6, gif image as it can't handle transparent png */\n	padding-left: 0;\n	background: url([[root_url]]/uploads/ngrey/parent.gif) no-repeat right center;\n}\n#primary-nav li.menuparent:hover span,\n#primary-nav li.menuparent.menuactive span,\n#primary-nav li.menuparent.menuactiveh span,\n#primary-nav li.menuparenth span {\n/* right arrow on hover */\n	background: url([[root_url]]/uploads/ngrey/parent.png) no-repeat left center;\n}\n#primary-nav li li span,\n#primary-nav li.menuparent li span,\n#primary-nav li.menuparent:hover li span,\n#primary-nav li.menuparenth li span,\n#primary-nav li.menuparenth li.menuparenth li span,\n#primary-nav li.menuparent li.menuparent li span,\n#primary-nav li.menuparent li.menuparent:hover li span {\n/* removes any images set above unless it's a parent or active parent */\n	background:  none;\n	padding-left: 0px;\n}\n/* Styling the appearance of menu items on hover */\n#primary-nav li:hover li a,\n#primary-nav li.menuh li a,\n#primary-nav li.menuparenth li a,\n#primary-nav li.menuactiveh li a {\n/* removes any images set above unless it's a parent or active parent */\n	background:  none;\n	color: #000;\n}\n/* The magic - set to work for up to a 3 level menu, but can be increased unlimited, for fourth level add\n#primary-nav li:hover ul ul ul,\n#primary-nav li.menuparenth ul ul ul,\n*/\n#primary-nav ul,\n#primary-nav li:hover ul,\n#primary-nav li:hover ul ul,\n#primary-nav li.menuparenth ul,\n#primary-nav li.menuparenth ul ul {\n	display: none;\n}\n/* for fourth level add\n#primary-nav ul ul ul li:hover ul,\n#primary-nav ul ul ul li.menuparenth ul,\n*/\n#primary-nav li:hover ul,\n#primary-nav ul li:hover ul,\n#primary-nav ul ul li:hover ul,\n#primary-nav li.menuparenth ul,\n#primary-nav ul li.menuparenth ul,\n#primary-nav ul ul li.menuparenth ul {\n	display: block;\n}\n/* IE Hack, will cause the css to not validate */\n#primary-nav li, #primary-nav li.menuparenth {\n	_float: left;\n	_height: 1%;\n}\n#primary-nav li a {\n	_height: 1%;\n}\n/* BIG NOTE: I didn't do anything to these 2, never tested */\n#primary-nav li.sectionheader {\n	border-left: 1px solid #006699;\n	border-top: 1px solid #006699;\n	font-size: 130%;\n	font-weight: bold;\n	padding: 1.5em 0 0.8em 0.5em;\n	background-color: #fff;\n	margin: 0;\n	width: 100%;\n}\n/* separator */\n#primary-nav li hr.separator {\n	display: block;\n	height: 0.5em;\n	color: #abb0b6;\n	background-color: #abb0b6;\n	width: 100%;\n	border: 0;\n	margin: 0;\n	padding: 0;\n	border-top: 1px solid #006699;\n	border-right: 1px solid #006699;\n}
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Navigation ShadowMenu - Vertical');
$css->set_description('Navigation CSS rules used in ShadowMenu left + 1 column Design');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
#footer ul {\n/* some margin is set in the footer padding */\n   margin: 0px;\n/* calling a specific side, left in this case */\n   margin-left: 5px;\n   padding: 0px;\n/* remove any default bullets, image used in li call */\n   list-style: none;\n}\n#footer ul li {\n/* remove any default bullets, image used for consistency */\n   list-style: none;\n/* float left to set first level li items across the top */\n   float:left;\n/* a little margin at top */\n   margin: 5px 0px 0px;\n/* padding all the way around */\n   padding: 5px;\n/* you can set your own image here, used for consistency */\n   background: url([[root_url]]/uploads/ngrey/dot.gif) no-repeat left 10px;\n}\n#footer ul li a {\n/* this will make the "a" link a solid shape */\n   display:block;\n   margin: 2px 0px 4px;\n   padding: 0px 5px 5px 5px;\n}\n/* set h3 to look like "a" */\n#footer li h3 {\n   font-weight:normal;\n   font-size:100%;\n   margin: 2px 0px 2px 0px;\n   padding: 0px 5px 5px 5px;\n}\n/* set h3 to look like "a", less margin at this level */\n#footer li li h3 {\n   font-weight:normal;\n   font-size:100%;\n   margin: 0px;\n   padding: 0px 5px 5px 5px;\n}\n#footer ul li li {\n/* remove any default bullets, image used for consistency */\n   list-style: none;\n/* remove float so they line up under top li */\n   float:none;\n/* less margin/padding */\n   margin: 0px;\n   padding: 0px 0px 0px 5px;\n/* you can set your own image here, used for consistency */\n   background: url([[root_url]]/uploads/ngrey/dot.gif) no-repeat left 3px;\n}\n/* fix for IE6 */\n* html #footer ul li a {\n   margin: 2px 0px 0px;\n   padding: 0px 5px 5px 5px;\n}\n* html #footer ul li li a {\n   margin: 0px 0px 0px;\n   padding: 0px 5px 0px 5px;\n}\n/* End fix for IE6 */\n#footer ul ul {\n/* remove float so they line up under top li */\n   float:none;\n/* a little margin to offset it */\n   margin: 0px 0px 0px 8px;\n   padding: 0;\n}\n#footer ul ul ul {\n/* remove float so they line up under li above it */\n   float:none;\n/* a little margin to offset it */\n   margin: 0px 0px 0px 8px;\n   padding: 0;\n}
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Navigation FatFootMenu');
$css->set_description('Footer navigation CSS rules used in CSSMenu left + 1 column, CSSMenu top + 2 columns, Left simple navigation + 1 column, ShadowMenu left + 1 column, ShadowMenu Tab + 2 columns and Top simple navigation + left subnavigation + 1 column');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
/*\n  @Nuno Costa [criacaoweb.net] Core CSS.\n  @Licensed under GPL and MIT.\n  @Status: Stable\n  @Version: 0.1-20090418\n  \n  @Contributors:\n  \n  --------------------------------------------------------------- \n*/\n/*----------- Global Containers ----------- */\n/* \n.core-wrap-100   =  width - 100% of Browser Fluid\n.core-wrap-960   =  width - 960px  - fixed\n.core-wrap-780   =  width - 780px  - fixed\n.custom-wrap-x   =  width -  custom   - declared in another css (your site css)\n*/\n.core-wrap-100 {\n	width: 100%;\n}\n.core-wrap-960 {\n	width: 960px;\n}\n.core-wrap-780 {\n	width: 780px;\n}\n.core-wrap-100,\n.core-wrap-960,\n.core-wrap-780,\n.custom-wrap-x {\n	margin-left: auto;\n	margin-right: auto;\n}\n/*----------- Global Float ----------- */\n.core-wrap-100  .core-float-left,\n.core-wrap-960  .core-float-left,\n.core-wrap-780  .core-float-left,\n.custom-wrap-x  .core-float-left {\n	float: left;\n	display: inline;\n}\n.core-wrap-100  .core-float-right,\n.core-wrap-960  .core-float-right,\n.core-wrap-780  .core-float-right,\n.custom-wrap-x  .core-float-right {\n	float: right;\n	display: inline;\n}\n/*----------- Global Center ----------- */\n.core-wrap-100   .core-center,\n.core-wrap-960   .core-center,\n.core-wrap-780   .core-center,\n.custom-wrap-x   .core-center {\n	margin-left: auto;\n	margin-right: auto;\n}
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('ncleanbluecore');
$css->set_description('Grid CSS rules used in NCleanBlue Design');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
/*\n  @Nuno Costa [criacaoweb.net] Utils CSS.\n  @Licensed under GPL2 and MIT.\n  @Status: Stable\n  @Version: 0.1-20090418\n  \n  @Contributors:\n        -  http://meyerweb.com/eric/tools/css/reset/index.html \n  \n  --------------------------------------------------------------- \n*/\n/* From: http://meyerweb.com/eric/tools/css/reset/index.html  (Original) */\n/* v1.0 | 20080212 */\nhtml, body, div, span, applet, object, iframe,\nh1, h2, h3, h4, h5, h6, p, blockquote, pre,\na, abbr, acronym, address, big, cite, code,\ndel, dfn, em, font, img, ins, kbd, q, s, samp,\nsmall, strike, strong, sub, sup, tt, var,\nb, u, i, center,\ndl, dt, dd, ol, ul, li,\nfieldset, form, label, legend,\ntable, caption, tbody, tfoot, thead, tr, th, td {\n	margin: 0;\n	padding: 0;\n	border: 0;\n	outline: 0;\n	font-size: 100%;\n	vertical-align: baseline;\n	background: transparent;\n}\n/*\nStantby for nowbody {\n	line-height: 1;\n}\n*/\nol, ul {\n	list-style: none;\n}\nblockquote, q {\n	quotes: none;\n}\nblockquote:before,\nblockquote:after,\nq:before, q:after {\n	content: '';\n	content: none;\n}\n/* remember to define focus styles! */\n:focus {\n	outline: 0;\n}\n/* remember to highlight inserts somehow! */\nins {\n	text-decoration: none;\n}\ndel {\n	text-decoration: line-through;\n}\n/* tables still need 'cellspacing="0"' in the markup */\ntable {\n	border-collapse: collapse;\n	border-spacing: 0;\n}\n/* ------- @Nuno Costa [criacaoweb.net] Utils CSS. ---------- */\n* {\n	font-weight: inherit;\n	font-style: inherit;\n	font-family: inherit;\n}\ndfn {\n	display: none;\n	overflow: hidden;\n}\n/* ----------- Clear Floated Elements ----------- */\nhtml body .util-clearb {\n	background: none;\n	border: 0;\n	clear: both;\n	display: block;\n	float: none;\n	font-size: 0;\n	margin: 0;\n	padding: 0;\n	position: static;\n	overflow: hidden;\n	visibility: hidden;\n	width: 0;\n	height: 0;\n}\n/* ----------- Fix to Clear Floated Elements ----------- */\n.util-clearfix:after {\n	clear: both;\n	content: '.';\n	display: block;\n	visibility: hidden;\n	height: 0;\n}\n.util-clearfix {\n	display: inline-block;\n}\n* html .util-clearfix {\n	height: 1%;\n}\n.util-clearfix {\n	display: block;\n}
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('ncleanblueutils');
$css->set_description('Reset and browser helper CSS style rules used in NCleanBlue Design');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
/*  \n@Nuno Costa [criacaoweb.net]\n@Since [cmsms 1.6]\n@Contributors: Mark and Dev-Team\n*/\nbody {\n/* default text for entire site */\n	font: normal 0.8em Tahoma, Verdana, Arial, Helvetica, sans-serif;\n/* default text color for entire site */\n	color: #3A3A36;\n/* you can set your own image and background color here */\n	background: #fff url([[root_url]]/uploads/NCleanBlue/bg__full.png) repeat-x scroll left top;\n}\n/* Mask helper  for browsers ZOOM, Rezise and Decrease */\n#ncleanblue {\n/* set to width of viewport */\n	width: auto;\n/* you can set your own image and background color here */\n	background: #fff url([[root_url]]/uploads/NCleanBlue/bg__full.png) repeat-x scroll left top;\n}\n/* wiki style external links */\n/* external links will have "(external link)" text added, lets hide it */\na.external span {\n	position: absolute;\n	left: -5000px;\n	width: 4000px;\n}\na.external {\n/* make some room for the image, css shorthand rules, read: first top padding 0 then right padding 12px then bottom then right */\n	padding: 0 12px 0 0;\n}\n/* colors for external links */\na.external:link {\n	color: #679EBC;\n/* background image for the link to show wiki style arrow */\n	background: url([[root_url]]/uploads/NCleanBlue/external.gif) no-repeat 100% -100px;\n}\na.external:visited {\n	color: #18507C;\n/* a different color can be used for visited external links */\n/* Set the last 0 to -100px to use that part of the external.gif image for different color for active links external.gif is actually 300px tall, we can use different positions of the image to simulate rollover image changes.*/\n	background: url([[root_url]]/uploads/NCleanBlue/external.gif) no-repeat 100% -100px;\n}\na.external:hover {\n	color: #18507C;\n/* Set the last 0 to -200px to use that part of the external.gif image for different color on hover */\n	background: url([[root_url]]/uploads/NCleanBlue/external.gif) no-repeat 100% 0;\n	background-color: inherit;\n}\n/* end wiki style external links */\n/* hr and anything with the class of accessibility is hidden with CSS from visual browsers */\n.accessibility, hr {\n/* absolute lets us put it outside the viewport with the indents, the rest is to clear all defaults */\n	position: absolute;\n	top: -9999em;\n	left: -9999em;\n	background: none;\n	border: 0;\n	clear: both;\n	display: block;\n	float: none;\n	font-size: 0;\n	margin: 0;\n	padding: 0;\n	overflow: hidden;\n	visibility: hidden;\n	width: 0;\n	height: 0;\n	border: none;\n}\n/* ------------ Standard  HTML elements and their default settings ------------ */\nb, strong{font-weight: bold;}i, em{	font-style: italic;}\np {\n	padding: 0;\n	margin-top: 0.5em;\n    margin-bottom: 1em;\n   text-align:left;\n}\nh1, h2, h3, h4, h5 {\n	line-height: 1.6em;\n	font-weight: normal;\n	width: auto;\n	font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;\n}\n/*default link styles*/\na {\n	color: #679EBC;\n	text-decoration: none;\n	text-align: left;\n}\na:hover {\n	color: #3A6B85;\n}\na:active {\n	color: #3A6B85;\n}\na:visited {\n	color: #679EBC;\n}\ninput, textarea, select {\n	font-size: 0.95em;\n}\n/* ------------ Wrapper ------------ */\ndiv#pagewrapper {\n	font-size: 95%;\n	position: relative;\n	z-index: 1;\n}\n/* ------------ Header ------------ */\n#header {\n	height: 111px;\n	width: 960px;\n}\n#logo a {\n/* adjust according your image size */\n	height: 75px;\n	width: 215px;\n/* forces full link size */\n	display: block;\n/* this hides the text */\n	text-indent: -9999em;\n	margin-top: 0;\n	margin-left: 0;\n/* you can set your own image here, note size adjustments */\n	background: url([[root_url]]/uploads/NCleanBlue/logo.png) no-repeat left top;\n}\n/* ------------ Header - Search ------------ */\ndiv#search {\n	width: 190px;\n	height: 28px;\n	margin-top: 31px;\n	margin-right: 20px;\n}\ndiv#search label {\n	text-indent: -9999em;\n	height: 0pt;\n	width: 0pt;\n	display: none;\n}\ndiv#search input.search-input {\n/* specific size for image, your image may need these adjusted */\n	width: 143px;\n	height: 17px;\n/* removes default borders, allows use of image */\n	border-style: none;\n/* text color */\n	color: #999;\n/* padding of text */\n	padding: 7px 0px 4px 10px;\n	float: left;\n/* set all font properties at once, weight, size, family */\n	font: bold 0.9em Arial, Helvetica, sans-serif;\n/* left input image, set your own here */\n	background: url([[root_url]]/uploads/NCleanBlue/search.png) no-repeat left top;\n}\ndiv#search input.search-button {\n/* specific size for image, your image may need these adjusted */\n	width: 37px;\n	height: 28px;\n/* removes default borders, allows use of image */\n	border-style: none;\n/* hides text, image has text */\n	text-indent: -9999em;\n	float: left;\n	margin: 0;\n/* provides positive hover effect */\n	cursor: pointer;\n/* removes default size/height */\n	font-size: 0px;\n	line-height: 0px;\n/* submit button image, set your own here */\n	background: transparent url([[root_url]]/uploads/NCleanBlue/search.png) no-repeat right top;\n}\n/* ------------ Content ------------ */\n#content {\n	width: auto;\n/* all text in #content will default align left, changed in other calls */\n	text-align: left;\n}\n#bar {\n	width: auto;\n	height: 40px;\n	padding-right: 1em;\n	padding-left: 1em;\n}\n.print {\n	margin-right: 75px;\n	margin-top: 10px;\n}\n#version {\n	width: 50px;\n	height: 31px;\n	position: absolute;\n	z-index: 5;\n	top: 130px;\n	right: -16px;\n	font-size: 1.6em;\n	font-weight: bold;\n	padding: 28px 15px;\n	color: #FFF;\n	text-align: center;\n	vertical-align: middle;\n	background:  url([[root_url]]/uploads/NCleanBlue/version.png) no-repeat left top;\n}\n/* IE6 fixes */\n* html div#version {\n	top: 150px;\n}\n/* End IE6 fixes */\n/* Site Title */\nh1.title {\n	font-size: 1.8em;\n	color: #666666;\n	margin-bottom: 0.5em;\n}\n/* Breadcrumbs */\ndiv.breadcrumbs {\n	padding: 0.5em 0;\n	font-size: 80%;\n	margin: 0 1em;\n}\ndiv.breadcrumbs span.lastitem {\n	font-weight: bold;\n}\n/* ------------ Side Bar (Left) ------------ */\n#left {\n	width: 250px;\n}\n/* Image that Represents the new CMS design */\n#left .screen {\n	margin: 10px 50px;\n}\n/* End  */\n.sbar-title {\n	font: bold 1.2em Arial, Helvetica, sans-serif;\n	color: #252523;\n}\n.sbar-top {\n	height: 20px;\n	width: auto;\n	padding: 10px;\n	background: url([[root_url]]/uploads/NCleanBlue/bg__content.png) no-repeat left top;\n}\n.sbar-main {\n	width: auto;\n	border-right: 1px solid #E2E2E2;\n	border-left: 1px solid #E2E2E2;\n	background: #F0F0F0;\n}\nspan.sbar-bottom {\n	width: auto;\n	display: block;\n	height: 10px;\n	background: url([[root_url]]/uploads/NCleanBlue/bg__content.png) no-repeat left bottom;\n}\n/* ------------ Main (Right) ------------ */\n#main {\n	width: 690px;\n}\n.main-top {\n	height: 15px;\n	width: auto;\n	background: url([[root_url]]/uploads/NCleanBlue/bg__content.png) no-repeat right top;\n}\n.main-main {\n	width: auto;\n	border-right: 1px solid #E2E2E2;\n	border-left: 1px solid #E2E2E2;\n	background: #F0F0F0;\n	padding: 20px;\n	padding-top: 0px;\n}\n.main-bottom {\n	width: auto;\n	height: 41px;\n	background: url([[root_url]]/uploads/NCleanBlue/bg__content.png) no-repeat right bottom;\n}\n.right49, .left49 {\n	font-size: 0.85em;\n	margin: 7px 5px 5px 10px;\n	font-weight: bold;\n}\n.left49 span {\n	display: block;\n	padding-top: 1px;\n}\n.left49 a {\n	font-weight: normal;\n}\n.right49 {\n	height: 28px;\n	width: 50px;\n	padding-right: 10px;\n	background: url([[root_url]]/uploads/NCleanBlue/bull.png) no-repeat right top;\n}\n.right49 a, .right49 a:visited {\n	padding: 7px 4px;\n	display: block;\n	color: #000;\n	height: 15px;\n	background: url([[root_url]]/uploads/NCleanBlue/bull.png) no-repeat  left top;\n}\n#main h2,\n#main h3,\n#main h4,\n#main h5,\n#main h6 {\n	font-size: 1.4em;\n	color: #301E12;\n}\ndiv#main ul,\ndiv#main ol,\ndiv#main dl,\n#footer ul,\n#footer ol {\n	line-height: 1em;\n	margin: 0 0 1.5em 0;\n}\ndiv#main ul,\n#footer ul {\n	list-style: circle;\n}\ndiv#main ul li,\ndiv#main ol li,\n#footer ul li,\n#footer ol li {\n	padding: 2px 2px 2px 5px;\n	margin-left: 20px;\n}\n/* definition lists topics on bold */\ndiv#main dl dt {\n	font-weight: bold;\n	margin: 0 0 0 1em;\n}\ndiv#main dl dd {\n	margin: 0 0 1em 1em;\n}\ndiv#main dl {\n	margin-bottom: 2em;\n	padding-bottom: 1em;\n	border-bottom: 1px solid #c0c0c0;\n}\n/* ------------ Footer ------------ */\n#footer-wrapper {\n	min-height: 235px;\n	height: auto!important;\n	height: 235px;\n	width: auto;\n	margin-top: 5px;\n	text-align: center;\n	margin-right: 00px;\n	margin-left: 0px;\n	background: #7CA3B5 url([[root_url]]/uploads/NCleanBlue/bg__footer.png) repeat-x left top;\n}\n#footer {\n	color: #FFF;\n	font-size: 0.8em;\n	min-height: 235px;\n	height: auto!important;\n	height: 235px;\n	background: #7CA3B5 url([[root_url]]/uploads/NCleanBlue/bg__footer.png) repeat-x left top;\n}\n#footer .block {\n	width: 300px;\n	margin: 20px 10px 10px;\n}\n#footer .cms {\n	text-align: right;\n}\n/* ------------ Footer Links ------------ */\n#footer ul {\n	width: auto;\n	text-align: left;\n	margin-left: 50px;\n}\n#footer ul ul {\n	margin-left: 0px;\n}\n#footer ul li a {\n	color: #FFF;\n	display: block;\n	font-weight: normal;\n	margin-bottom: 0.5em;\n	text-decoration: none;\n}\n#footer a {\n	color: #DCEDF1;\n	text-decoration: underline;\n	font-weight: bold;\n}\n/* ------------ END LAYOUT ---------------*/\n/* ------------  Menu  ROOT  ------------ */\n.page-menu {\n	width: auto;\n	height: 35px;\n	margin: 3px 0 0 20px;\n}\n.menuwrapper {}\n\nul#primary-nav li hr.menu_separator{\n        position: relative;\n        visibility: hidden;\n        display:block;\n        width:5px;\n       	height: 32px;\n       	margin: 0px 5px 0px;\n}\n.page-menu ul#primary-nav {\n	height: 1%;\n	float: left;\n	list-style: none;\n	padding: 0;\n	margin: 0;\n}\n.page-menu ul#primary-nav li {\n	float: left;\n}\n.page-menu ul#primary-nav li a,\n.page-menu ul#primary-nav li a span {\n	display: block;\n	padding: 0 10px;\n	background-repeat: no-repeat;\n	background-image: url([[root_url]]/uploads/NCleanBlue/tabs.gif);\n}\n.page-menu ul#primary-nav li a {\n	padding-left: 0;\n	color: #000;\n	font-weight: bold;\n	line-height: 2.15em;\n	text-decoration: none;\n	margin-left: 1px;\n	font-size: 0.85em;\n}\n.page-menu ul#primary-nav li a:hover,\n.page-menu ul#primary-nav li a:active {\n	color: #000;\n}\n.page-menu ul#primary-nav li a.menuactive,\n.page-menu ul#primary-nav li a:hover span {\n	color: #000;\n}\n.page-menu ul#primary-nav li a span {\n	padding-top: 6px;\n	padding-right: 0;\n	padding-bottom: 5px;\n}\n.page-menu ul#primary-nav li a.menuparenth,\n.page-menu ul#primary-nav li a.menuactive,\n.page-menu ul#primary-nav li a:hover,\n.page-menu ul#primary-nav li a:focus,\n.page-menu ul#primary-nav li a:active {\n	background-position: 100% -120px;\n}\n.page-menu ul#primary-nav li a {\n	background-position: 100% -80px;\n}\n.page-menu ul#primary-nav li a.menuactive span,\n.page-menu ul#primary-nav li a:hover span,\n.page-menu ul#primary-nav li a:focus span,\n.page-menu ul#primary-nav li a:active span {\n	background-position: 0 -40px;\n}\n.page-menu ul#primary-nav li a span {\n	background-position: 0 0;\n}\n.page-menu ul#primary-nav .sectionheader,\n.page-menu ul#primary-nav li a:link.menuactive,\n.page-menu ul#primary-nav li a:visited.menuactive {\n/* @ Opera, use pseudo classes otherwise it confuses cursor... */\n	cursor: text;\n}\n.page-menu ul#primary-nav li span,\n.page-menu ul#primary-nav li a,\n.page-menu ul#primary-nav li a:hover,\n.page-menu ul#primary-nav li a:focus,\n.page-menu ul#primary-nav li a:active {\n/* @ Opera, we need to be explicit again here now... */\n	cursor: pointer;\n}\n/* Additional IE specific bug fixes... */\n* html .page-menu ul#primary-nav {\n	display: inline-block;\n}\n*:first-child+html .page-menu ul#primary-nav {\n	display: inline-block;\n}\n/* --------------------  menu dropdow  -------------------------\n/* Unless you know what you do, do not touch this */\n/* Reset all ROOT menu styles. */\nul#primary-nav ul.unli li li a span,\nul#primary-nav ul.unli li a span,\nul#primary-nav .menuparent .unli .menuparent .unli li a span {\n	font-weight: normal;\n	background-image: none;\n	display: block;\n	padding-top: 0px;\n	padding-left: 0px;\n	padding-right: 0px;\n	padding-bottom: 0px;\n}\n#primary-nav {\n	margin: 0px;\n	padding: 0px;\n}\n#primary-nav ul {\n	list-style: none;\n	margin: -6px 0px 0px;\n	padding: 0px;\n/* Set the width of the menu elements at second level. Leaving first level flexible. */\n	width: 209px;\n}\n#primary-nav ul {\n	position: absolute;\n	z-index: 1001;\n	top: auto;\n	display: none;\n	padding-top: 9px;\n	background: url([[root_url]]/uploads/NCleanBlue/ultop.png) no-repeat left top;\n}\n* html #primary-nav ul.unli {\n	padding-top: 12px;\n	background: url([[root_url]]/uploads/NCleanBlue/ultop.gif) no-repeat left top;\n}\n#primary-nav ul.unli ul {\n	margin-left: -7px;\n	left: 100%;\n	top: 3px;\n}\n* html #primary-nav ul.unli ul {\n	margin-left: -0px;\n}\n#primary-nav li {\n	margin: 0px;\n	float: left;\n}\n#primary-nav li li {\n	margin-left: 7px;\n	margin-top: -1px;\n	float: none;\n	position: relative;\n}\n/* Styling the basic appearance of the menu elements */\nul#primary-nav ul hr.menu_separator{\n        position: relative;\n        visibility: visible;\n        display:block;\n        width:130px;\n       	height: 1px;\n       	margin: 2px 30px 2px;\n	padding: 0em;\n	border-bottom: 1px solid #ccc;\n	border-top-width: 0px;\n	border-right-width: 0px;\n	border-left-width: 0px;\n	border-top-style: none;\n	border-right-style: none;\n	border-left-style: none;\n}\n#primary-nav .separator,\n#primary-nav .separatorh {\n	height: 9px;\n	width: 209px;\n	margin: 0px 0px -8px;\n	background: url([[root_url]]/uploads/NCleanBlue/ulbtm.png) no-repeat left bottom;\n}\n* html #primary-nav .separator {\n       z-index:-1;\n	background: url([[root_url]]/uploads/NCleanBlue/ulbtm.gif) no-repeat left bottom;\n}\n*:first-child+html #primary-nav .separator {\n       z-index:-1;\n}\n#primary-nav ul.unli li a {\n	padding: 0px 10px;\n	width: 165px;\n	margin: 5px;\n	background-image: none;\n}\n* html #primary-nav ul.unli li a {\n	padding: 0px 10px 0px 5px;\n	width: 165px;\n	margin: 5px 0px;\n}\n#primary-nav li li a:hover {\n	background-color: #DBE7F2;\n}\n/* Styling the basic appearance of the active page elements (shows what page in the menu is being displayed) */\n#primary-nav li.menuactive li a {\n	text-decoration: none;\n	background: none;\n}\n#primary-nav ul.unli li.menuparenth,\n#primary-nav ul.unli a:hover,\n#primary-nav ul.unli a.menuactive {\n	background-color: #DBE7F2;\n}\n/* Styling the basic apperance of the menuparents - here styled the same on hover (fixes IE bug) */\n#primary-nav ul.unli li .menuparent,\n#primary-nav ul.unli li .menuparent:hover,\n#primary-nav ul.unli li .menuparent,\n#primary-nav .menuactive.menuparent .unli .menuactive.menuparent .menuactive.menuparent {\n	background-image: url([[root_url]]/uploads/NCleanBlue/arrow.gif);\n	background-position: center right;\n	background-repeat: no-repeat;\n}\n/* The magic - set to work for up to a 3 level menu, but can be increased unlimited */\n#primary-nav ul,\n#primary-nav li:hover ul,\n#primary-nav li:hover ul ul,\n#primary-nav li:hover ul ul ul,\n#primary-nav li.menuparenth ul,\n#primary-nav li.menuparenth ul ul,\n#primary-nav li.menuparenth ul ul ul {\n	display: none;\n}\n#primary-nav li:hover ul,\n#primary-nav ul li:hover ul,\n#primary-nav ul ul li:hover ul,\n#primary-nav ul ul ul li:hover ul,\n#primary-nav li.menuparenth ul,\n#primary-nav ul li.menuparenth ul,\n#primary-nav ul ul li.menuparenth ul,\n#primary-nav ul ul ul li.menuparenth ul {\n	display: block;\n}\n/* IE Hacks */\n#primary-nav li li {\n	float: left;\n	clear: both;\n}\n#primary-nav li li a {\n	height: 1%;\n}\n/*************** End Menu *****************/\n/* ------------ News Module ------------ */\n#news {\n	padding: 10px;\n}\n.NewsSummary {\n}\n.NewsSummaryPostdate,\n.NewsSummaryCategory,\n.NewsSummaryAuthor {\n	font-style: italic;\n	font-size: 0.8em;\n}\n.NewsSummaryLink {\n	margin: 2px 0;\n}\n.NewsSummaryContent {\n	margin: 10px 0;\n}\n.NewsSummaryMorelink {\n	margin: 5px 0 15px;\n}\n/* ------------ End News Module ------------ */
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Layout NCleanBlue'); // id = 49
$css->set_description('Main layout rules used in NCleanBlue Design');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
[[strip]]\r\n\r\n[[* /*! normalize.css v2.1.3 | MIT License | git.io/normalize */ *]]\r\n\r\n[[* /* ==========================================================================\r\n HTML5 display definitions\r\n ========================================================================== */ *]]\r\n\r\n[[* /**\r\n * Correct `block` display not defined in IE 8/9.\r\n */ *]]\r\n\r\narticle, aside, details, figcaption, figure, footer, header, hgroup, main, nav, section, summary {\r\n	display: block;\r\n}\r\n\r\n[[* /**\r\n * Correct `inline-block` display not defined in IE 8/9.\r\n */ *]]\r\n\r\naudio, canvas, video {\r\n	display: inline-block;\r\n}\r\n\r\n[[* /**\r\n * Prevent modern browsers from displaying `audio` without controls.\r\n * Remove excess height in iOS 5 devices.\r\n */ *]]\r\n\r\naudio:not([controls]) {\r\n	display: none;\r\n	height: 0;\r\n}\r\n\r\n[[* /**\r\n * Address `[hidden]` styling not present in IE 8/9.\r\n * Hide the `template` element in IE, Safari, and Firefox < 22.\r\n */ *]]\r\n\r\n[hidden], template {\r\n	display: none;\r\n}\r\n\r\n[[* /* ==========================================================================\r\n Base\r\n ========================================================================== */ *]]\r\n\r\n[[* /**\r\n * 1. Set default font family to sans-serif.\r\n * 2. Prevent iOS text size adjust after orientation change, without disabling\r\n *    user zoom.\r\n */ *]]\r\n\r\nhtml {\r\n	font-family: sans-serif; [[* /* 1 */ *]]\r\n	-ms-text-size-adjust: 100%; [[* /* 2 */ *]]\r\n	-webkit-text-size-adjust: 100%; [[* /* 2 */ *]]\r\n}\r\n\r\n[[* /**\r\n * Remove default margin.\r\n */ *]]\r\n\r\nbody {\r\n	margin: 0;\r\n}\r\n\r\n[[* /* ==========================================================================\r\n Links\r\n ========================================================================== */ *]]\r\n\r\n[[* /**\r\n * Remove the gray background color from active links in IE 10.\r\n */ *]]\r\n\r\na {\r\n	background: transparent;\r\n}\r\n\r\n[[* /**\r\n * Address `outline` inconsistency between Chrome and other browsers.\r\n */ *]]\r\n\r\na:focus {\r\n	outline: thin dotted;\r\n}\r\n\r\n[[* /**\r\n * Improve readability when focused and also mouse hovered in all browsers.\r\n */ *]]\r\n\r\na:active, a:hover {\r\n	outline: 0;\r\n}\r\n\r\n[[* /* ==========================================================================\r\n Typography\r\n ========================================================================== */ *]]\r\n\r\n[[* /**\r\n * Address variable `h1` font-size and margin within `section` and `article`\r\n * contexts in Firefox 4+, Safari 5, and Chrome.\r\n */ *]]\r\n\r\nh1 {\r\n	font-size: 2em;\r\n	margin: 0.67em 0;\r\n}\r\n\r\n[[* /**\r\n * Address styling not present in IE 8/9, Safari 5, and Chrome.\r\n */ *]]\r\n\r\nabbr[title] {\r\n	border-bottom: 1px dotted;\r\n}\r\n\r\n[[* /**\r\n * Address style set to `bolder` in Firefox 4+, Safari 5, and Chrome.\r\n */ *]]\r\n\r\nb, strong {\r\n	font-weight: bold;\r\n}\r\n\r\n[[* /**\r\n * Address styling not present in Safari 5 and Chrome.\r\n */ *]]\r\n\r\ndfn {\r\n	font-style: italic;\r\n}\r\n\r\n[[* /**\r\n * Address differences between Firefox and other browsers.\r\n */ *]]\r\n\r\nhr {\r\n	-moz-box-sizing: content-box;\r\n	box-sizing: content-box;\r\n	height: 0;\r\n}\r\n\r\n[[* /**\r\n * Address styling not present in IE 8/9.\r\n */ *]]\r\n\r\nmark {\r\n	background: #ff0;\r\n	color: #000;\r\n}\r\n\r\n[[* /**\r\n * Correct font family set oddly in Safari 5 and Chrome.\r\n */ *]]\r\n\r\ncode, kbd, pre, samp {\r\n	font-family: monospace, serif;\r\n	font-size: 1em;\r\n}\r\n\r\n[[* /**\r\n * Improve readability of pre-formatted text in all browsers.\r\n */ *]]\r\n\r\npre {\r\n	white-space: pre-wrap;\r\n}\r\n\r\n[[* /**\r\n * Set consistent quote types.\r\n */ *]]\r\n\r\nq {\r\n	quotes: "\\201C" "\\201D" "\\2018" "\\2019";\r\n}\r\n\r\n[[* /**\r\n * Address inconsistent and variable font size in all browsers.\r\n */ *]]\r\n\r\nsmall {\r\n	font-size: 80%;\r\n}\r\n\r\n[[* /**\r\n * Prevent `sub` and `sup` affecting `line-height` in all browsers.\r\n */ *]]\r\n\r\nsub, sup {\r\n	font-size: 75%;\r\n	line-height: 0;\r\n	position: relative;\r\n	vertical-align: baseline;\r\n}\r\n\r\nsup {\r\n	top: -0.5em;\r\n}\r\n\r\nsub {\r\n	bottom: -0.25em;\r\n}\r\n\r\n[[* /* ==========================================================================\r\n Embedded content\r\n ========================================================================== */ *]]\r\n\r\n[[* /**\r\n * Remove border when inside `a` element in IE 8/9.\r\n */ *]]\r\n\r\nimg {\r\n	border: 0;\r\n}\r\n\r\n[[* /**\r\n * Correct overflow displayed oddly in IE 9.\r\n */ *]]\r\n\r\nsvg:not(:root) {\r\n	overflow: hidden;\r\n}\r\n\r\n[[* /* ==========================================================================\r\n Figures\r\n ========================================================================== */ *]]\r\n\r\n[[* /**\r\n * Address margin not present in IE 8/9 and Safari 5.\r\n */ *]]\r\n\r\nfigure {\r\n	margin: 0;\r\n}\r\n\r\n[[* /* ==========================================================================\r\n Forms\r\n ========================================================================== */ *]]\r\n\r\n[[* /**\r\n * Define consistent border, margin, and padding.\r\n */ *]]\r\n\r\nfieldset {\r\n	border: 1px solid #c0c0c0;\r\n	margin: 0 2px;\r\n	padding: 0.35em 0.625em 0.75em;\r\n}\r\n\r\n[[* /**\r\n * 1. Correct `color` not being inherited in IE 8/9.\r\n * 2. Remove padding so people aren''t caught out if they zero out fieldsets.\r\n */ *]]\r\n\r\nlegend {\r\n	border: 0; [[* /* 1 */ *]]\r\n	padding: 0; [[* /* 2 */ *]]\r\n}\r\n\r\n[[* /**\r\n * 1. Correct font family not being inherited in all browsers.\r\n * 2. Correct font size not being inherited in all browsers.\r\n * 3. Address margins set differently in Firefox 4+, Safari 5, and Chrome.\r\n */ *]]\r\n\r\nbutton, input, select, textarea {\r\n	font-family: inherit; [[* /* 1 */ *]]\r\n	font-size: 100%; [[* /* 2 */ *]]\r\n	margin: 0; [[* /* 3 */ *]]\r\n}\r\n\r\n[[* /**\r\n * Address Firefox 4+ setting `line-height` on `input` using `!important` in\r\n * the UA stylesheet.\r\n */ *]]\r\n\r\nbutton, input {\r\n	line-height: normal;\r\n}\r\n\r\n[[* /**\r\n * Address inconsistent `text-transform` inheritance for `button` and `select`.\r\n * All other form control elements do not inherit `text-transform` values.\r\n * Correct `button` style inheritance in Chrome, Safari 5+, and IE 8+.\r\n * Correct `select` style inheritance in Firefox 4+ and Opera.\r\n */ *]]\r\n\r\nbutton, select {\r\n	text-transform: none;\r\n}\r\n\r\n[[* /**\r\n * 1. Avoid the WebKit bug in Android 4.0.* where (2) destroys native `audio`\r\n *    and `video` controls.\r\n * 2. Correct inability to style clickable `input` types in iOS.\r\n * 3. Improve usability and consistency of cursor style between image-type\r\n *    `input` and others.\r\n */ *]]\r\n\r\nbutton, html input[type="button"], [[* /* 1 */ *]]\r\ninput[type="reset"], input[type="submit"] {\r\n	-webkit-appearance: button; [[* /* 2 */ *]]\r\n	cursor: pointer; [[* /* 3 */ *]]\r\n}\r\n\r\n[[* /**\r\n * Re-set default cursor for disabled elements.\r\n */ *]]\r\n\r\nbutton[disabled], html input[disabled] {\r\n	cursor: default;\r\n}\r\n\r\n[[* /**\r\n * 1. Address box sizing set to `content-box` in IE 8/9/10.\r\n * 2. Remove excess padding in IE 8/9/10.\r\n */ *]]\r\n\r\ninput[type="checkbox"], input[type="radio"] {\r\n	box-sizing: border-box; [[* /* 1 */ *]]\r\n	padding: 0; [[* /* 2 */ *]]\r\n}\r\n\r\n[[* /**\r\n * 1. Address `appearance` set to `searchfield` in Safari 5 and Chrome.\r\n * 2. Address `box-sizing` set to `border-box` in Safari 5 and Chrome\r\n *    (include `-moz` to future-proof).\r\n */ *]]\r\n\r\ninput[type="search"] {\r\n	-webkit-appearance: textfield; [[* /* 1 */ *]]\r\n	-moz-box-sizing: content-box;\r\n	-webkit-box-sizing: content-box; [[* /* 2 */ *]]\r\n	box-sizing: content-box;\r\n}\r\n\r\n[[* /**\r\n * Remove inner padding and search cancel button in Safari 5 and Chrome\r\n * on OS X.\r\n */ *]]\r\n\r\ninput[type="search"]::-webkit-search-cancel-button, input[type="search"]::-webkit-search-decoration {\r\n	-webkit-appearance: none;\r\n}\r\n\r\n[[* /**\r\n * Remove inner padding and border in Firefox 4+.\r\n */ *]]\r\n\r\nbutton::-moz-focus-inner, input::-moz-focus-inner {\r\n	border: 0;\r\n	padding: 0;\r\n}\r\n\r\n[[* /**\r\n * 1. Remove default vertical scrollbar in IE 8/9.\r\n * 2. Improve readability and alignment in all browsers.\r\n */ *]]\r\n\r\ntextarea {\r\n	overflow: auto; [[* /* 1 */ *]]\r\n	vertical-align: top; [[* /* 2 */ *]]\r\n}\r\n\r\n[[* /* ==========================================================================\r\n Tables\r\n ========================================================================== */ *]]\r\n\r\n[[* /**\r\n * Remove most spacing between table cells.\r\n */ *]]\r\n\r\ntable {\r\n	border-collapse: collapse;\r\n	border-spacing: 0;\r\n}\r\n\r\n[[* /*! HTML5 Boilerplate v4.3.0 | MIT License | http://h5bp.com/ */ *]]\r\n\r\n[[* /*\r\n * What follows is the result of much research on cross-browser styling.\r\n * Credit left inline and big thanks to Nicolas Gallagher, Jonathan Neal,\r\n * Kroc Camen, and the H5BP dev community and team.\r\n */ *]]\r\n\r\n[[* /* ==========================================================================\r\n Base styles: opinionated defaults\r\n ========================================================================== */ *]]\r\n\r\nhtml {\r\n	color: #222;\r\n	font-size: 1em;\r\n	line-height: 1.4;\r\n}\r\n\r\n[[* /*\r\n * A better looking default horizontal rule\r\n */ *]]\r\n\r\nhr {\r\n	display: block;\r\n	height: 1px;\r\n	border: 0;\r\n	border-top: 1px solid #ccc;\r\n	margin: 1em 0;\r\n	padding: 0;\r\n}\r\n\r\n[[* /*\r\n * Remove the gap between images, videos, audio and canvas and the bottom of\r\n * their containers: h5bp.com/i/440\r\n */ *]]\r\n\r\naudio, canvas, img, svg, video {\r\n	vertical-align: middle;\r\n}\r\n\r\n[[* /*\r\n * Remove default fieldset styles.\r\n */ *]]\r\n\r\nfieldset {\r\n	border: 0;\r\n	margin: 0;\r\n	padding: 0;\r\n}\r\n\r\n[[* /*\r\n * Allow only vertical resizing of textareas.\r\n */ *]]\r\n\r\ntextarea {\r\n	resize: vertical;\r\n}\r\n\r\n[[* /* ==========================================================================\r\n Helper classes\r\n ========================================================================== */ *]]\r\n\r\n[[* /*\r\n * Hide from both screenreaders and browsers: h5bp.com/u\r\n */ *]]\r\n\r\n.hidden {\r\n	display: none !important;\r\n	visibility: hidden;\r\n}\r\n\r\n[[* /*\r\n * Hide only visually, but have it available for screenreaders: h5bp.com/v\r\n */ *]]\r\n\r\n.visuallyhidden {\r\n	border: 0;\r\n	clip: rect(0 0 0 0);\r\n	height: 1px;\r\n	margin: -1px;\r\n	overflow: hidden;\r\n	padding: 0;\r\n	position: absolute;\r\n	width: 1px;\r\n}\r\n\r\n[[* /*\r\n * Extends the .visuallyhidden class to allow the element to be focusable\r\n * when navigated to via the keyboard: h5bp.com/p\r\n */ *]]\r\n\r\n.visuallyhidden.focusable:active, .visuallyhidden.focusable:focus {\r\n	clip: auto;\r\n	height: auto;\r\n	margin: 0;\r\n	overflow: visible;\r\n	position: static;\r\n	width: auto;\r\n}\r\n\r\n[[* /*\r\n * Hide visually and from screenreaders, but maintain layout\r\n */ *]]\r\n\r\n.invisible {\r\n	visibility: hidden;\r\n}\r\n\r\n[[* /*\r\n * Clearfix: contain floats\r\n *\r\n * For modern browsers\r\n * 1. The space content is one way to avoid an Opera bug when the\r\n *    `contenteditable` attribute is included anywhere else in the document.\r\n *    Otherwise it causes space to appear at the top and bottom of elements\r\n *    that receive the `clearfix` class.\r\n * 2. The use of `table` rather than `block` is only necessary if using\r\n *    `:before` to contain the top-margins of child elements.\r\n */ *]]\r\n\r\n.cf:before, .cf:after {\r\n	content: " "; [[* /* 1 */ *]]\r\n	display: table; [[* /* 2 */ *]]\r\n}\r\n\r\n.cf:after {\r\n	clear: both;\r\n}\r\n\r\n[[* /* =====================================\r\n BASE STYLES\r\n ===================================== */ *]]\r\n\r\n[[* /*\r\n * 1. Remove default vertical scrollbar in IE6/7/8/9\r\n * 2. Allow only vertical resizing\r\n */ *]]\r\ntextarea {\r\n	overflow: auto;\r\n	vertical-align: top;\r\n	resize: vertical\r\n}\r\n\r\nul, ol {\r\n	margin: 1em 0;\r\n	padding: 0 0 0 40px\r\n}\r\n\r\ndd {\r\n	margin: 0 0 0 40px\r\n}\r\n\r\nnav ul, nav ol {\r\n	list-style: none;\r\n	list-style-image: none;\r\n	margin: 0;\r\n	padding: 0\r\n}\r\n\r\n[[* /* Redeclare monospace font family */ *]]\r\npre, code, kbd, samp {\r\n	font-family: monospace, serif;\r\n	_font-family: courier new, monospace;\r\n	font-size: 1em\r\n}\r\n\r\n[[* /* Improve readability of pre-formatted text in all browsers */ *]]\r\npre {\r\n	white-space: pre;\r\n	white-space: pre-wrap;\r\n	word-wrap: break-word\r\n}\r\n\r\nq {\r\n	quotes: none\r\n}\r\n\r\nq:before, q:after {\r\n	content: "";\r\n	content: none\r\n}\r\n\r\nsmall {\r\n	font-size: 85%\r\n}\r\n\r\n[[* /* correct text resizing */ *]]\r\nhtml {\r\n	font-size: 100%;\r\n	-webkit-text-size-adjust: 100%;\r\n	-ms-text-size-adjust: 100%\r\n}\r\n\r\nbody {\r\n	margin: 0;\r\n	font-size: 1em;\r\n	-webkit-font-smoothing: antialiased;\r\n}\r\n\r\n[[* /* =====================================\r\n 12 COLUMN GRID\r\n ===================================== */ *]]\r\n\r\n[[* /* ==========================================================================\r\n 12 Column Grid System based on the 1140px Grid V2\r\n by Andy Taylor http://cssgrid.net\r\n\r\n Extended by Goran Ilic http://www.ich-mach-das.at\r\n https://github.com/Stikki/Yetti/blob/master/static/css/yetti-grid.css\r\n ========================================================================== */ *]]\r\n\r\n.container {\r\n	padding-left: 10px;\r\n	padding-right: 10px;\r\n}\r\n\r\n.row {\r\n	width: 100%;\r\n	max-width: 1440px;\r\n	margin: 0 auto;\r\n	position: relative;\r\n}\r\n\r\n.row:before, .row:after, .form-row:before, .form-row:after {\r\n	content: " ";\r\n	display: table;\r\n}\r\n\r\n.row:after, .form-row:after {\r\n	clear: both;\r\n}\r\n\r\n[[* /* ==========================================================================\r\n Base 12 Column Grid\r\n ========================================================================== */ *]]\r\n\r\n.full {\r\n	width: 100%;\r\n	display: block;\r\n}\r\n\r\n.half, .third, .two-third, .quarter, .three-quarter, .fifth, .two-fifth, .three-fifth, .four-fifth {\r\n	float: left;\r\n}\r\n\r\n.half {\r\n	width: 50%;\r\n}\r\n\r\n.third {\r\n	width: 33.33%;\r\n}\r\n\r\n.two-third {\r\n	width: 66.66%;\r\n}\r\n\r\n.quarter {\r\n	width: 25%;\r\n}\r\n\r\n.three-quarter {\r\n	width: 75%;\r\n}\r\n\r\n.fifth {\r\n	width: 20%;\r\n}\r\n\r\n.two-fifth {\r\n	width: 40%;\r\n}\r\n\r\n.three-fifth {\r\n	width: 60%;\r\n}\r\n\r\n.four-fifth {\r\n	width: 80%\r\n}\r\n\r\n[[* /* Animate position of columns */ *]]\r\n.row [class*="-col"] {\r\n	-webkit-transition:all .4s ease;\r\n	-moz-transition:all .4s ease;\r\n	-o-transition:all .4s ease;\r\n	-ms-transition:all .4s ease;\r\n	transition:all .4s ease;\r\n}\r\n\r\n@media only screen and (min-width: 768px) {\r\n	\r\n	.container {\r\n		padding-left: 20px;\r\n		padding-right: 20px;\r\n	}\r\n\r\n	[[* /* ==========================================================================\r\n	 Base 12 Column Grid\r\n	 ========================================================================== */ *]]\r\n\r\n	.col, .one-col, .two-col, .three-col, .four-col, .five-col, .six-col, .seven-col, .eight-col, .nine-col, .ten-col, .eleven-col {\r\n		margin-left: 3.8%;\r\n		float: left;\r\n		min-height: 1px;\r\n		position: relative;\r\n	}\r\n	.row .one-col {\r\n		width: 4.85%;\r\n	}\r\n	.row .two-col {\r\n		width: 13.45%;\r\n	}\r\n	.row .three-col {\r\n		width: 22.05%;\r\n	}\r\n	.row .four-col {\r\n		width: 30.75%;\r\n	}\r\n	.row .five-col {\r\n		width: 39.45%;\r\n	}\r\n	.row .six-col {\r\n		width: 48.1%;\r\n	}\r\n	.row .seven-col {\r\n		width: 56.75%;\r\n	}\r\n	.row .eight-col {\r\n		width: 65.4%;\r\n	}\r\n	.row .nine-col {\r\n		width: 74.05%;\r\n	}\r\n	.row .ten-col {\r\n		width: 82.7%;\r\n	}\r\n	.row .eleven-col {\r\n		width: 91.35%;\r\n	}\r\n	.row .twelve-col {\r\n		width: 100%;\r\n		margin-left: 0;\r\n	}\r\n	.row [class*="-col"]:first-child, .row [class*="-col"].first {\r\n		margin-left: 0;\r\n	}\r\n\r\n	[[* /* ==========================================================================\r\n	 Offset Space\r\n	 ========================================================================== */ *]]\r\n\r\n	.row .offset-one {\r\n		margin-left: 8.65% !important;\r\n	}\r\n	.row .offset-two {\r\n		margin-left: 17.25% !important;\r\n	}\r\n	.row .offset-three {\r\n		margin-left: 25.85% !important;\r\n	}\r\n	.row .offset-four {\r\n		margin-left: 34.55% !important;\r\n	}\r\n	.row .offset-five {\r\n		margin-left: 43.25% !important;\r\n	}\r\n	.row .offset-six {\r\n		margin-left: 51.8% !important;\r\n	}\r\n	.row .offset-seven {\r\n		margin-left: 60.55% !important;\r\n	}\r\n	.row .offset-eight {\r\n		margin-left: 69.2% !important;\r\n	}\r\n	.row .offset-nine {\r\n		margin-left: 77.85% !important;\r\n	}\r\n	.row .offset-ten {\r\n		margin-left: 86.5% !important;\r\n	}\r\n	.row .offset-eleven {\r\n		margin-left: 95.15% !important;\r\n	}\r\n\r\n	[[* /* ==========================================================================\r\n	 Push & Pull Space\r\n	 ========================================================================== */ *]]\r\n\r\n	.row .push-one, .row .push-two, .row .push-three, .row .push-four, .row .push-five, .row .push-six, .row .push-seven, .row .push-eight,\r\n	.row .push-nine, .row .push-ten, .row .push-eleven, .row .pull-one, .row .pull-two, .row .pull-three, .row .pull-four, .row .pull-five,\r\n	.row .pull-six, .row .pull-seven, .row .pull-eight, .row .pull-nine, .row .pull-ten, .row .pull-eleven {\r\n		position: relative;\r\n		margin-left: 0;\r\n	}\r\n\r\n	.row .push-one {\r\n		left: 8.65%;\r\n	}\r\n	.row .push-two {\r\n		left: 17.25%;\r\n	}\r\n	.row .push-three {\r\n		left: 25.85%;\r\n	}\r\n	.row .push-four {\r\n		left: 34.55%;\r\n	}\r\n	.row .push-five {\r\n		left: 43.25%;\r\n	}\r\n	.row .push-six {\r\n		left: 51.8%;\r\n	}\r\n	.row .push-seven {\r\n		left: 60.55%;\r\n	}\r\n	.row .push-eight {\r\n		left: 69.2%;\r\n	}\r\n	.row .push-nine {\r\n		left: 77.85%;\r\n	}\r\n	.row .push-ten {\r\n		left: 86.5%;\r\n	}\r\n	.row .push-eleven {\r\n		left: 95.15%;\r\n	}\r\n\r\n	.row .pull-one {\r\n		right: 4.85%;\r\n	}\r\n	.row .pull-two {\r\n		right: 13.45%;\r\n	}\r\n	.row .pull-three {\r\n		right: 22.05%;\r\n	}\r\n	.row .pull-four {\r\n		right: 30.75%;\r\n	}\r\n	.row .pull-five {\r\n		right: 39.45%;\r\n	}\r\n	.row .pull-six {\r\n		right: 48%;\r\n	}\r\n	.row .pull-seven {\r\n		right: 56.75%;\r\n	}\r\n	.row .pull-eight {\r\n		right: 65.4%;\r\n	}\r\n	.row .pull-nine {\r\n		right: 74.05%;\r\n	}\r\n	.row .pull-ten {\r\n		right: 82.7%;\r\n	}\r\n	.row .pull-eleven {\r\n		right: 91.35%;\r\n	}\r\n\r\n}\r\n\r\n[[/strip]]
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Simplex Core');
$css->set_description('Simplex Theme core Stylesheet, containing 12 column grid system and HTML5 resets (normalize.css)');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
[[strip]]\r\n\r\n[[* APPEARANCE *]]\r\n[[* \r\n	/**\r\n	 * @copyright CMS Made Simple 2014\r\n	 * @author Goran Ilic (uniqu3e@gmail.com)\r\n	 * @version 1.1 (CMSMS 2.0 Package)\r\n	 * \r\n	 * Simplex Theme comes with 2 predefined Style variations, one is a "boxed" style as seen in\r\n	 * default installation which is controle with "boxed" ID that is set in Simplex Theme <body> tag.\r\n	 * If you remove this ID, a grey background on page body will be removed and layout will no longer \r\n	 * be wrapped inside a "box" but appear in a single background color which is by default white.\r\n	 * \r\n	 * Besides there are also predefined class names and styles that you can use on <body> tag to\r\n	 * change alignment of complete layout/page.\r\n	 * If you rightaligned class to body (example: <body class='rightaligned and other classes'>) \r\n	 * then whole page layout will be positioned to right window side instead of centered position\r\n	 * and with class leftaligned the page layout will be positioned to left.\r\n	 * \r\n	 * Maximum width of page layout is preset to 1440px in Simplex Core stylesheet, you can change this \r\n	 * by adding a new rule in this stylesheet with a class .row (Example: .row { max-width: 1080px; }).\r\n	 * If you prefer a full width layout simply add fullwidth class to body tag of Simplex Template.  \r\n	 * This class will reset max-width limitation and force the page layout to full window width with\r\n	 * spacing on left and right of 30px.\r\n	 * \r\n	 * Browser Support: \r\n	 * Simplex Theme was tested in common modern Browser and IE8 (with gracefull fallback).\r\n	 * \r\n	 * Grid usage:\r\n	 * Simplex is using a custom Yetti Framework 12 column grid (https://github.com/Stikki/Yetti/tree/master)\r\n	 * based on Andy Taylors (http://cssgrid.net) 1140px Grid.\r\n	 * \r\n	 * Using the grid system is fairly simple. Make sure that grid columns\r\n	 * are wrapped inside a element with .row class.\r\n	 * When grid columns are inside a row element, floats are auto cleared,\r\n	 * therefore you do not need anything like some empty clear element ie. <div class="clear"></div>\r\n	 * Grid columns have a spacing (margin-left) of 3.8% of the layout, whereby first column after\r\n	 * .row opening element will have no spacing (margin-left).\r\n	 * Grid columns are only applied to Browser and Screen size which are greater then 768px;\r\n	 * \r\n	 * Example (three column row):\r\n	 * \r\n	 * <!-- container has a preset padding to left and right with 20px -->\r\n	 * <div class="container">\r\n	 *     <!-- clears floating row of columns, sets maximum width of 1440px -->\r\n	 *     <div class="row some-class-to-apply-styles">\r\n	 *         <!-- \r\n	 *             four-col explanation: a simple math, grid is built out of 12 columns, so we say we want\r\n	 *             a grid column in size of four columns width therefore the name four- and to fill \r\n	 *             our .row it is three times four-col column makes twelve columns (3 x 4 = 12)\r\n	 *         -->\r\n	 *         <div class="four-col my-class">\r\n	 *             Some content\r\n	 *         </div>\r\n	 *         <div class="four-col my-class">\r\n	 *             Some content\r\n	 *         </div>\r\n	 *         <div class="four-col my-class">\r\n	 *             Some content\r\n	 *         </div>\r\n	 *     </div>\r\n	 *     <div class="row">\r\n	 *         <div class="six-col">\r\n	 *             Half width content\r\n	 *         </div>\r\n	 *         <div class="six-col">\r\n	 *             Half width content\r\n	 *         </div>\r\n	 *     </div>\r\n	 * </div>\r\n	 * \r\n	 */ \r\n*]]\r\n\r\n[[* /* assign the images path to a variable */ *]]\r\n[[capture assign='path']][[uploads_url]]/simplex/images[[/capture]]\r\n[[capture assign='font']][[uploads_url]]/simplex/fonts[[/capture]]\r\n\r\n[[* /* --- COLORS --- */ *]]\r\n\r\n[[assign var='light_grey' value='#f1f1f1']]\r\n[[assign var='grey' value='#e9e9e9']]\r\n[[assign var='dark_grey' value='#555' scope=global]]\r\n[[assign var='white' value='#fff']]\r\n[[assign var='orange' value='#f39c2c' scope=global]]\r\n[[assign var='dark_orange' value='#e6870e']]\r\n[[assign var='yellow' value='#fdbd34']]\r\n\r\n[[* /* =====================================\r\n ICON FONT\r\n ===================================== */ *]]\r\n[[* /* Will fail on Windows Phone 7, sorry developer life sucks */ *]]\r\n@font-face {\r\n	font-family: 'simplex';\r\n	src: url('[[\$font]]/simplex.eot');\r\n	src: url('[[\$font]]/simplex.eot?#iefix') format('embedded-opentype'),\r\n		url('[[\$font]]/simplex.woff') format('woff'), \r\n		url('[[\$font]]/simplex.ttf') format('truetype'),\r\n		url('[[\$font]]/simplex.svg#simplex') format('svg');\r\n	font-weight: normal;\r\n	font-style: normal;\r\n}\r\n\r\n[class^="icon-"], [class*=" icon-"] {\r\n	font-family: 'simplex';\r\n	speak: none;\r\n	font-style: normal;\r\n	font-weight: normal;\r\n	font-variant: normal;\r\n	text-transform: none;\r\n	line-height: 1;\r\n	-webkit-font-smoothing: antialiased;\r\n	-moz-osx-font-smoothing: grayscale;\r\n}\r\n\r\n.icon-arrow-up:before {\r\n	content: "\\e600";\r\n}\r\n\r\n.icon-arrow-left:before {\r\n	content: "\\e601";\r\n}\r\n\r\n.icon-search:before {\r\n	content: "\\e603";\r\n}\r\n\r\n.icon-printer:before {\r\n	content: "\\e604";\r\n}\r\n\r\n.icon-linkedin:before {\r\n	content: "\\e605";\r\n}\r\n\r\n.icon-pinterest:before {\r\n	content: "\\e606";\r\n}\r\n\r\n.icon-youtube:before {\r\n	content: "\\e607";\r\n}\r\n\r\n.icon-facebook:before {\r\n	content: "\\e608";\r\n}\r\n\r\n.icon-google:before {\r\n	content: "\\e609";\r\n}\r\n\r\n.icon-twitter:before {\r\n	content: "\\e60a";\r\n}\r\n\r\n.icon-link:before {\r\n	content: "\\e602";\r\n}\r\n\r\n[[* /* =====================================\r\n GENERAL STYLES\r\n ===================================== */ *]]\r\nbody {\r\n	background: [[\$white]];\r\n	font-family: 'Noto Sans', sans-serif;\r\n	font-size: 1em; [[* /* base browser font size: 16px, now do math "XX / 16 = ??" where XX is desired font size */ *]] \r\n	color: [[\$dark_grey]];\r\n	line-height: 1.5;\r\n}\r\n\r\n[[* /* add this class to <body> to align the layout to left instead of centered */ *]]\r\n.leftaligned {\r\n	margin-left: 0;\r\n}\r\n\r\n[[* /* add this class to <body> to align the layout to right instead of centered */ *]]\r\n.rightaligned {\r\n	margin-right: 0;\r\n}\r\n\r\n[[* /* you can change appearance of the page by adding or removing #boxed id to <body> tag. \r\n * By removing #boxed ID, page will no longer be wrapped in a wrapper \r\n */ *]]\r\nbody#boxed {\r\n	background: #f2f2f2 url([[\$path]]/body-background.png) repeat;\r\n}\r\n\r\n[[* /* add this class to <body> to make this layout full window width */ *]]\r\nbody.fullwidth .row {\r\n	max-width: none;\r\n}\r\n\r\na img {\r\n	border: none;\r\n}\r\n\r\n[[* /* you can use these classes to align images to left or right */ *]]\r\n.right {\r\n	float: right;\r\n}\r\n\r\n.left {\r\n	float: left;\r\n}\r\n\r\n[[* /* if image needs some space add this class to img tag\r\n * so at the end a left floating image would be <img src='some.jpg' class='left spacing' alt='foo' />\r\n */ *]]\r\n.spacing {\r\n	margin: 15px;\r\n}\r\n\r\n.spacing.left {\r\n	margin-right: 0;\r\n}\r\n\r\n.spacing.right {\r\n	margin-left: 0;\r\n}\r\n\r\n[[* /* or add a 2 px border to image or something, change as you need it */ *]]\r\n.border {\r\n	border: 2px solid [[\$grey]];\r\n}\r\n\r\n[[* /* some styling for code chunks */ *]]\r\npre, code, kbd, samp {\r\n	font-family: Consolas, 'Andale Mono WT', 'Andale Mono', 'Lucida Console', 'Lucida Sans Typewriter', monospace;\r\n	color: [[\$dark_grey]];\r\n}\r\n\r\npre code {\r\n	line-height: 1.4;\r\n	font-size: .8125em;\r\n}\r\n\r\npre {\r\n	padding: 10px;\r\n	margin: 10px 0;\r\n	overflow: auto;\r\n	width: 93%;\r\n	background: [[\$light_grey]];\r\n	border-radius: 6px;\r\n	-webkit-border-radius: 6px;\r\n	-moz-border-radius: 6px;\r\n	-o-border-radius: 6px;\r\n}\r\n\r\n[[* /* target IE7 and IE6 */ *]]\r\n*:first-child+ html pre {\r\n	padding-bottom: 20px;\r\n	overflow-y: hidden;\r\n	overflow: visible;\r\n	overflow-x: auto;\r\n}\r\n\r\n* html pre {\r\n	padding-bottom: 20px;\r\n	overflow: visible;\r\n	overflow-x: auto;\r\n}\r\n\r\n[[* /* horizontal ruler */ *]]\r\nhr {\r\n	border: solid [[\$grey]];\r\n	border-width: 1px 0 0 0;\r\n	clear: both;\r\n	margin: 10px 0 30px 0;\r\n	height: 0;\r\n}\r\n\r\n[[* /* =====================================\r\n COMMON TYPOGRAPHY\r\n ===================================== */ *]]\r\n\r\n[[* /* link default styles */ *]]\r\na {\r\n	color: [[\$orange]];\r\n}\r\n\r\na.external {\r\n	text-decoration: none;\r\n}\r\n\r\na:visited {\r\n	color: [[\$dark_orange]];\r\n}\r\n\r\na:hover {\r\n	color: [[\$dark_grey]];\r\n	transition: transform .3s ease-out;\r\n	-webkit-transition: color .3s ease-out;\r\n	-moz-transition: color .3s ease-out;\r\n	-o-transition: color .3s ease-out;\r\n	text-decoration: underline;\r\n}\r\n\r\na:focus {\r\n	outline: thin dotted;\r\n}\r\n\r\na:hover, a:active {\r\n	outline: 0;\r\n}\r\n\r\n[[* /* add icon to links with class external */ *]]\r\na.external:after {\r\n	content: "\\e602";\r\n	padding-left: 4px;\r\n	font-family: 'simplex';\r\n	text-decoration: none;\r\n}\r\n\r\n[[* /* default heading styles */ *]]\r\nh1, h2 {\r\n	font-family: 'Oswald', Impact, Haettenschweiler, 'Arial Narrow Bold', sans-serif;\r\n	font-weight: 700;\r\n}\r\n\r\nh3, h4, h5, h6 {\r\n	font-weight: 400;\r\n}\r\n\r\nh1 {\r\n	color: [[\$orange]];\r\n	margin: 10px 0;\r\n	font-size: 2em; [[* /* 32px */ *]]\r\n	text-transform: uppercase;\r\n}\r\n\r\nh2 {\r\n	color: [[\$dark_grey]];\r\n	font-size: 1.75em; [[* /* 28px */ *]]\r\n}\r\n\r\nh3 {\r\n	color: [[\$dark_grey]];\r\n	font-size: 1.5em; [[* /* 24px */ *]]\r\n}\r\n\r\nh4 {\r\n	color: [[\$orange]];\r\n	font-size: 1.375em; [[* /* 22px */ *]]\r\n}\r\n\r\nh5 {\r\n	font-size: 1.25em [[* /* 20px */ *]]\r\n}\r\n\r\nh6 {\r\n	font-size: 1.125em; [[* /* 18px */ *]]\r\n}\r\n\r\n[[* /* blockquotes and cites */ *]]\r\nblockquote, blockquote p {\r\n	font-size: 1.0625em;\r\n	line-height: 1.5;\r\n	color: [[\$dark_grey]];\r\n	font-style: italic;\r\n	font-family: Georgia, Times New Roman, serif;\r\n}\r\n\r\nblockquote {\r\n	margin: 0 0 20px 0;\r\n	padding: 9px 10px 10px 19px;\r\n	border-left: 5px solid [[\$light_grey]];\r\n}\r\n\r\nblockquote cite {\r\n	display: block;\r\n	font-size: .941176em;\r\n	color: [[\$dark_grey]];\r\n}\r\n\r\nblockquote cite:before {\r\n	content: "\\2014 \\0020";\r\n}\r\n\r\nblockquote cite a, blockquote cite a:visited, blockquote cite a:visited {\r\n	font-family: Georgia, Times New Roman, serif;\r\n}\r\n\r\n[[* /* =====================================\r\n LAYOUT\r\n ===================================== */ *]]\r\n[[* /* wrapping the page in a box */ *]]\r\n.page-wrapper {\r\n	border-top: 5px solid [[\$orange]];\r\n	margin-bottom: 15px;\r\n}\r\n\r\n[[* /* you can switch appearance of the page by adding or removing id #boxed to body tag */ *]]\r\n#boxed #wrapper {\r\n	margin-top: 15px;\r\n	border-top: 5px solid [[\$orange]];\r\n	background: [[\$white]];\r\n	box-shadow: 0 0 15px 0 #c6c6c6;\r\n}\r\n\r\n#boxed.page-wrapper {\r\n	border-top: none;\r\n}\r\n\r\n[[* /* add some spacing to page wrapper */ *]]\r\n.inner-section {\r\n	padding-left: 20px;\r\n	padding-right: 20px;\r\n}\r\n\r\n[[* /* ------ HEADER SECTION ------ */ *]]\r\n\r\n[[* /* the logo */ *]]\r\n.logo {\r\n	margin-top: 20px;\r\n	text-align: center;\r\n}\r\n\r\n.logo a {\r\n	display: block;\r\n}\r\n\r\n.top .header {\r\n	border-bottom: 1px solid [[\$light_grey]];\r\n}\r\n\r\n[[* /* catchphrase */ *]]\r\n.phrase span {\r\n	font-family: 'Oswald', Impact, Haettenschweiler, 'Arial Narrow Bold', sans-serif;\r\n	text-transform: uppercase;\r\n	color: #ddd;\r\n	font-weight: 700;\r\n	font-size: 1.5em; [[* /* 24px */ *]]\r\n}\r\n\r\n[[* /* search */ *]]\r\n.search {\r\n	text-align: right;\r\n}\r\n\r\n[[* /* webkit browser add icons to input of type search, we dont want it here now */ *]]\r\ninput.search-input::-webkit-search-decoration, input.search-input::-webkit-search-results-button, \r\ninput.search-input::-webkit-search-results-decoration {\r\n	-webkit-appearance: none;\r\n}\r\n\r\n.search .icon-search {\r\n	margin-left: -25px;\r\n	display: inline-block;\r\n	height: 24px;\r\n	line-height: 24px;\r\n	text-align: center;\r\n	width: 24px;\r\n	position: relative;\r\n	z-index: 10;\r\n	color: #ddd;\r\n	top: 3px;\r\n}\r\n\r\n.search ::-webkit-input-placeholder,\r\n.search ::-moz-placeholder,\r\n.search input[placeholder] { \r\n	line-height: normal;\r\n}\r\n\r\n[[* /* styling the search input field */ *]]\r\ninput.search-input {\r\n	border: 1px solid [[\$light_grey]];\r\n	line-height: normal;\r\n	outline: 0;\r\n	padding: 6px 0 6px .5%;\r\n	font-size: .6875em; [[* /* 11px */ *]]\r\n	color: [[\$dark_grey]];\r\n	transition: all .35s ease-in-out;\r\n	-webkit-transition: all .35s ease-in-out;\r\n	-moz-transition: all .35s ease-in-out;\r\n	-o-transition: all .35s ease-in-out;\r\n	max-width: 99.5%;\r\n}\r\n\r\ninput.search-input:focus {\r\n	border: 1px solid [[\$orange]];\r\n	box-shadow: 0 0 3px [[\$orange]];\r\n	-webkit-box-shadow: 0 0 3px [[\$orange]];\r\n	-moz-box-shadow: 0 0 3px [[\$orange]];\r\n	-o-box-shadow: 0 0 3px [[\$orange]];\r\n}\r\n\r\n[[* /* ------ NAVIGATION ------ */ *]]\r\n#main-menu {\r\n	margin-top: 25px;\r\n}\r\n\r\n[[* /* --- FIRST LEVEL --- */ *]]\r\n#main-menu > li {\r\n	display: block;\r\n	border-bottom: 1px dotted [[\$light_grey]];\r\n	position: relative;\r\n}\r\n\r\n#main-menu > li:last-child {\r\n	border-bottom: none;\r\n}\r\n\r\n#main-menu > li > a,\r\n#main-menu > li.sectionheader > span {\r\n	font-family: 'Oswald', Impact, Haettenschweiler, 'Arial Narrow Bold', sans-serif;\r\n	text-transform: uppercase;\r\n	color: [[\$dark_grey]];\r\n	text-decoration: none;\r\n	font-size: 1.0625em; [[* /* 17px */ *]]\r\n	font-weight: 700;\r\n	cursor: pointer;\r\n	padding: 8px 0;\r\n	display: block;\r\n	position: relative;\r\n}\r\n\r\n#main-menu > li.current > a,\r\n#main-menu > li.current.sectionheader > span,\r\n#main-menu > li:hover > a,\r\n#main-menu > li.sectionheader:hover > span {\r\n	color: [[\$dark_orange]];\r\n}\r\n\r\n[[* /* --- SECOND LEVEL --- */ *]]\r\n#main-menu > li > ul,\r\n#main-menu > li > ul > li > ul [[* /* third level */ *]] {\r\n	position: absolute;\r\n	left: -999em;\r\n}\r\n\r\n#main-menu > li:hover > ul,\r\n#main-menu > li.active > ul,\r\n#main-menu > li > ul > li:hover > ul, [[* /* third level */ *]]\r\n#main-menu > li > ul > li.active > ul {\r\n	position: relative;\r\n	left: 0;\r\n}\r\n\r\n#main-menu > li > ul > li > a,\r\n#main-menu > li > ul > li.sectionheader > span,\r\n#main-menu > li > ul > li > ul > li > a, [[* /* third level */ *]]\r\n#main-menu > li > ul > li > ul > li.sectionheader > span {\r\n	text-decoration: none;\r\n	color: [[\$dark_grey]];\r\n	text-transform: uppercase;\r\n	display: block;\r\n	padding: 4px 0;\r\n}\r\n\r\n#main-menu > li > ul > li:hover > a,\r\n#main-menu > li > ul > li.sectionheader:hover > span,\r\n#main-menu > li > ul > li > ul > li:hover > a,\r\n#main-menu > li > ul > li > ul > li.sectionheader:hover > span {\r\n	color: #999;\r\n}\r\n\r\n[[* /* --- THIRD LEVEL --- */ *]]\r\n#main-menu > li > ul > li > ul > li > a,\r\n#main-menu > li > ul > li > ul > li.sectionheader > span {\r\n	padding-left: 15px;\r\n	font-size: .875em;\r\n	text-transform: none;\r\n}\r\n\r\n[[* /* --- PARENT INDICATOR --- */ *]]\r\n#main-menu > li > a i,\r\n#main-menu > li > ul > li > a i,\r\n#main-menu > li.sectionheader > span i,\r\n#main-menu > li > ul > li.sectionheader > span i {\r\n	float: right;\r\n	position: relative;\r\n	padding-top: 6px;\r\n	-webkit-transform: rotate(0deg);\r\n	-moz-transform: rotate(0deg);\r\n	-ms-transform: rotate(0deg);\r\n	-o-transform: rotate(0deg);\r\n	transform: rotate(0deg);\r\n	-webkit-transition: -webkit-transform 250ms ease-out 0s;\r\n	-moz-transition: -moz-transform 250ms ease-out 0s;\r\n	-o-transition: -o-transform 250ms ease-out 0s;\r\n	transition: transform 250ms ease-out 0s;\r\n}\r\n\r\n#main-menu > li:hover > a i,\r\n#main-menu > li.active > a i,\r\n#main-menu > li > ul > li:hover > a i,\r\n#main-menu > li > ul > li.active > a i,\r\n#main-menu > li.sectionheader:hover > span i,\r\n#main-menu > li.active.sectionheader > span i,\r\n#main-menu > li > ul > li.sectionheader:hover > span i,\r\n#main-menu > li > ul > li.active.sectionheader > span i {\r\n	-webkit-transform: rotate(-90deg);\r\n	-moz-transform: rotate(-90deg);\r\n	-ms-transform: rotate(-90deg);\r\n	-o-transform: rotate(-90deg);\r\n	transform: rotate(-90deg);\r\n}\r\n\r\n[[* /* ------ CONTENT AREA ------ */ *]]\r\n.content-wrapper {\r\n	padding-top: 20px;\r\n}\r\n\r\n.content-top {\r\n	font-family: Georgia, Times New Roman, serif;\r\n	color: [[\$dark_grey]];\r\n	font-style: italic;\r\n	line-height: 20px;\r\n	position: relative;\r\n}\r\n\r\n.content-top .title-border {\r\n	content: '';\r\n	height: 1px;\r\n	display: block;\r\n	width: 100%;\r\n	border-bottom: 1px dotted #ddd;\r\n	position: absolute;\r\n	top: 50%;\r\n}\r\n\r\n[[* /* breadcrumbs */ *]]\r\n.breadcrumb {\r\n	display: inline-block;\r\n	background: [[\$white]];\r\n	width: auto;\r\n	padding-right: 6px;\r\n	z-index: 1;\r\n	position: relative;\r\n}\r\n\r\n.breadcrumb a {\r\n	color: [[\$dark_grey]];\r\n	display: inline-block;\r\n	width: auto;\r\n	background: [[\$white]];\r\n}\r\n\r\n[[* /* print button */ *]]\r\na.printbutton {\r\n	display: none;\r\n}\r\n\r\n\r\n[[* /* news module summary -> content */ *]]\r\n.content .news-summary span.heading {\r\n	display: none;\r\n}\r\n\r\n.content .news-article {\r\n	margin-bottom: 15px;\r\n	padding-bottom: 15px;\r\n	border-bottom: 1px dotted [[\$grey]];\r\n}\r\n\r\n.content .news-summary ul.category-list {\r\n	margin: 15px 0;\r\n}\r\n\r\n.content .news-summary ul.category-list li a, .news-summary ul.category-list li span {\r\n	border-radius: 4px;\r\n}\r\n\r\n.news-summary ul.category-list li span {\r\n	opacity: .4;\r\n}\r\n\r\n[[* /* news module summary -> sitewide (content + sidebar) */ *]]\r\n[[* /* article heading */ *]]\r\n.news-article h2 {\r\n	margin: 0 0 15px 0;\r\n}\r\n\r\n.news-article h2 a {\r\n	font-family: 'Oswald', Impact, Haettenschweiler, 'Arial Narrow Bold', sans-serif;\r\n	text-transform: uppercase;\r\n	color: [[\$dark_grey]];\r\n	font-size: 16px;\r\n	text-decoration: none;\r\n	font-weight: 700;\r\n}\r\n\r\n[[* /* date circle, well square for IE  */ *]]\r\n.news-article .date {\r\n	background: [[\$orange]];\r\n	color: [[\$white]];\r\n	display: block;\r\n	float: left;\r\n	width: 40px;\r\n	padding: 6px;\r\n	height: 40px;\r\n	border-radius: 26px;\r\n	text-align: center;\r\n	font-family: Georgia, Times New Roman, serif;\r\n}\r\n\r\n.news-article .day {\r\n	font-size: 20px;\r\n	line-height: 1;\r\n	padding-bottom: 2px;\r\n	font-style: italic;\r\n	display: block;\r\n}\r\n\r\n.news-article.month {\r\n	font-size: 11px;\r\n	display: block\r\n}\r\n\r\n[[* /* author and category */ *]]\r\n.news-article .author, .news-article .category {\r\n	font-family: Georgia, Times New Roman, serif;\r\n	display: block;\r\n	padding-left: 60px;\r\n	font-size: 11px;\r\n	font-style: italic;\r\n}\r\n\r\n[[* /* category list on top of summary */ *]]\r\n.news-summary ul.category-list {\r\n	margin: 15px 0 -1px 0;\r\n	padding: 0;\r\n	list-style: none;\r\n}\r\n\r\n.news-summary ul.category-list li {\r\n	float: left;\r\n	display: block;\r\n	width: auto;\r\n	margin-right: 5px;\r\n}\r\n\r\n.news-summary ul.category-list li a, .news-summary ul.category-list li span {\r\n	display: block;\r\n	color: [[\$dark_grey]];\r\n	padding: 4px 8px;\r\n	background: [[\$light_grey]];\r\n	border-radius: 4px 4px 0 0;\r\n	text-decoration: none;\r\n	font-size: 11px;\r\n	text-transform: uppercase;\r\n}\r\n\r\n.news-summary ul.category-list li a:hover {\r\n	color: [[\$orange]];\r\n}\r\n\r\n.news-summary .paginate {\r\n	font: italic 11px/1.2 Georgia, Times New Roman, serif;\r\n}\r\n\r\n.news-summary .paginate a {\r\n	padding: 0 3px;\r\n}\r\n\r\n.news-meta {\r\n	background: [[\$light_grey]];\r\n	padding: 10px;\r\n	margin: 10px 0;\r\n}\r\n\r\n[[* /* more link */ *]]\r\n.more, .more a,\r\n[[* /* back link */ *]]\r\n.back, .back a,\r\n[[* /* previous, next links */ *]]\r\n.previous a, .next a, .previous, .next {\r\n	font: italic 12px/1.3 Georgia, Times New Roman, serif;\r\n	color: [[\$dark_grey]];\r\n	text-decoration: none;\r\n}\r\n\r\n[[* /* hover behavior of more, next, previous links */ *]]\r\n.more a:hover, .back a:hover, .previous a:hover, .next a:hover {\r\n	text-decoration: underline;\r\n}\r\n\r\n.previous, .next {\r\n	padding: 6px 0;\r\n}\r\n\r\n[[* /* align next link to right */ *]]\r\n.previous {\r\n	float: left;\r\n}\r\n\r\n.next {\r\n	float: right;\r\n}\r\n\r\n[[* /* ------ SIDEBAR AREA ------ */ *]]\r\n\r\n[[* /* news module summary -> sidebar */ *]]\r\n.sidebar .news-summary span.heading {\r\n	position: relative;\r\n	color: [[\$dark_grey]];\r\n	font: normal 1em/1.25 Georgia, Times New Roman, serif;\r\n	margin: 0 0 15px 0;\r\n	display: block;\r\n}\r\n\r\n.sidebar .news-summary span.heading:after {\r\n	content: '';\r\n	height: 1px;\r\n	display: block;\r\n	width: 100%;\r\n	border-bottom: 1px dotted #ddd;\r\n	position: absolute;\r\n	top: 50%;\r\n}\r\n\r\n.sidebar .news-summary .heading span {\r\n	display: inline-block;\r\n	width: auto;\r\n	background: [[\$white]];\r\n	padding-right: 6px;\r\n	position: relative;\r\n	z-index: 10;\r\n}\r\n\r\n.sidebar .news-article {\r\n	padding: 15px;\r\n	position: relative;\r\n	background: [[\$light_grey]];\r\n	margin-bottom: 20px;\r\n	border-radius: 0 0 6px 0;\r\n	font-size: .8125em; [[* /* 13px */ *]]\r\n}\r\n\r\n[[* /* creating a bubble box with css3 */ *]]\r\n.sidebar .news-article:before {\r\n	content: '';\r\n	position: absolute;\r\n	bottom: -15px;\r\n	right: 25px;\r\n	width: 10px;\r\n	height: 35px;\r\n	-webkit-transform: rotate(55deg) skewY(55deg);\r\n	-moz-transform: rotate(55deg) skewY(55deg);\r\n	-o-transform: rotate(55deg) skewY(55deg);\r\n	-ms-transform: rotate(55deg) skewY(55deg);\r\n	transform: rotate(55deg) skewY(55deg);\r\n	background: [[\$light_grey]];\r\n}\r\n\r\n.lt-ie9 .sidebar .news-article:before {\r\n	display: none;\r\n}\r\n\r\n[[* /* ------ FOOTER AREA ------ */ *]]\r\n[[* /* footer wrapper */ *]]\r\n.footer {\r\n	position: relative;\r\n	border-top: 8px solid [[\$light_grey]];\r\n	margin: 25px 0 10px 0;\r\n	padding-top: 20px;\r\n	padding-bottom: 20px;\r\n}\r\n\r\n.footer:before {\r\n	content: ' ';\r\n	border-top: 2px dotted [[\$white]];\r\n	border-bottom: 2px dotted [[\$white]];\r\n	height: 4px;\r\n	display: block;\r\n	position: absolute;\r\n	width: 100%;\r\n	top: -8px;\r\n	left: 0;\r\n}\r\n\r\n[[* /* copyright text */ *]]\r\n.copyright {\r\n	padding-top: 15px;\r\n}\r\n\r\n.copyright-info {\r\n	color: [[\$dark_grey]];\r\n	font-size: .6875em; [[* /* 11px */ *]]\r\n}\r\n\r\n[[* /* social icons */ *]]\r\n.footer ul.social {\r\n	padding: 0;\r\n	margin: 0;\r\n	list-style: none;\r\n	text-align: center;\r\n}\r\n\r\n.footer .social li {\r\n	display: inline;\r\n	margin: 0;\r\n	padding: 0;\r\n	margin-right: 6px;\r\n}\r\n\r\n.footer .social li a {\r\n	display: inline-block;\r\n	text-decoration: none;\r\n	font-size: 2.625em;\r\n	line-height: 1;\r\n	color: [[\$dark_grey]];\r\n}\r\n\r\n.footer .social li a:hover {\r\n	color: [[\$orange]];\r\n}\r\n\r\n.footer .social li a i {\r\n	display: inline-block;\r\n}\r\n\r\n[[* /* back to top anchor */ *]]\r\n.back-top a {\r\n	display: inline-block;\r\n	width: 16px;\r\n	height: 16px;\r\n	line-height: 16px;\r\n	padding: 8px;\r\n	border: 5px solid [[\$white]];\r\n	text-decoration: none;\r\n	color: [[\$dark_grey]];\r\n	background-color: [[\$light_grey]];\r\n	border-radius: 500px;\r\n	-webkit-border-radius: 500px;\r\n	-moz-border-radius: 500px;\r\n	-o-border-radius: 500px;\r\n	position: absolute;\r\n	top: -24px;\r\n	left: 50%;\r\n	margin-left: -12px;\r\n	-webkit-transition: all 200ms ease-in-out;\r\n	-moz-transition: all 200ms ease-in-out;\r\n	-ms-transition: all 200ms ease-in-out;\r\n	-o-transition: all 200ms ease-in-out;\r\n	transition: all 200ms ease-in-out;\r\n}\r\n\r\n.back-top a:hover {\r\n	background-color: [[\$orange]];\r\n	color: [[\$white]];\r\n	-webkit-transform: scale(1.1);\r\n	-moz-transform: scale(1.1);\r\n	-ms-transform: scale(1.1);\r\n	-o-transform: scale(1.1);\r\n	transform: scale(1.1);\r\n}\r\n\r\n[[* /* Footer navigation */ *]]\r\n.footer-navigation {\r\n	padding-top: 15px;\r\n	border-bottom: 1px solid [[\$light_grey]];\r\n}\r\n\r\n#footer-menu li > a,\r\n#footer-menu li.sectionheader > span {\r\n	color: [[\$dark_grey]];\r\n	display: block;\r\n	text-decoration: none;\r\n}\r\n\r\n#footer-menu li > a:hover,\r\n#footer-menu li > a.current,\r\n#footer-menu li.sectionheader > span:hover,\r\n#footer-menu li.sectionheader > span.current {\r\n	color: [[\$orange]];\r\n} \r\n\r\n#footer-menu > li > a,\r\n#footer-menu > li.sectionheader > span {\r\n	font-family: 'Oswald', Impact, Haettenschweiler, 'Arial Narrow Bold', sans-serif;\r\n	text-transform: uppercase;\r\n	text-decoration: none;\r\n	display: block;\r\n}\r\n\r\n#footer-menu > li > ul > li > a,\r\n#footer-menu > li > ul > li.sectionheader > span {\r\n	font-size: .875em; [[* /* 14px */ *]]\r\n	padding: 2px 0;\r\n}\r\n\r\n#footer-menu > li > ul {\r\n	margin: 15px 0;\r\n}\r\n\r\n[[* /* =====================================\r\n SCREENS BIGGER THAN 768px\r\n ===================================== */ *]]\r\n\r\n@media screen and (min-width: 768px) {\r\n\r\n	.lt-768 {\r\n		display: none;\r\n	}\r\n\r\n	.logo {\r\n		margin-top: 12px;\r\n		position: relative;\r\n		text-align: left;\r\n	}\r\n\r\n	[[* /* having some fun with palm, rotating with css3, will not work in IE */ *]]\r\n	.logo .palm {\r\n		position: absolute;\r\n		top: 5px;\r\n		left: 45px;\r\n		background: url([[\$path]]/palm-circle.png) no-repeat;\r\n		display: block;\r\n		width: 48px;\r\n		height: 48px;\r\n		transition: transform 0.6s ease-out;\r\n		-webkit-transition: -webkit-transform 0.6s ease-out;\r\n		-moz-transition: -moz-transform 0.6s ease-out;\r\n		-o-transition: -o-transform 0.6s ease-out;\r\n		-webkit-perspective: 1000;\r\n		-webkit-backface-visibility: hidden;\r\n	}\r\n\r\n	[[* /* css3 transform rotating palm on hover */ *]]\r\n	.logo a:hover .palm {\r\n		transform: rotate(360deg);\r\n		-webkit-transform: rotate(360deg);\r\n		-moz-transform: rotate(360deg);\r\n		-o-transform: rotate(360deg);\r\n	}\r\n\r\n	[[* /* ------ NAVIGATION ------ */ *]]\r\n\r\n	nav.main-navigation {\r\n		z-index: 990;\r\n		height: 55px;\r\n		line-height: 37px;\r\n		margin-top: 20px;\r\n	}\r\n\r\n	#main-menu {\r\n		float: right;\r\n		margin-top: 0;\r\n	}\r\n	\r\n	[[* /* --- FIRST LEVEL --- */ *]]\r\n	#main-menu > li {\r\n		display: inline-block;\r\n		padding: 0;\r\n		margin: 0 4px;\r\n		border: none;\r\n		position: relative;\r\n	}\r\n	\r\n	[[* /* PARENT INICATOR */ *]]\r\n	#main-menu > li i {\r\n		display: none;\r\n	}\r\n	\r\n	.touch-device #main-menu > li i {\r\n		display: inline-block;\r\n		float: none;\r\n	}\r\n	\r\n	.touch-device #main-menu > li li i {\r\n		float: left;\r\n		display: inline-block;\r\n		margin-right: 8px;\r\n		padding-top: 2px;\r\n		text-align: left;\r\n	}\r\n	\r\n	.touch-device #main-menu > li:first-child li i {\r\n		float: right;\r\n	}\r\n\r\n	#main-menu > li:first-child, #main-menu > li.first {\r\n		margin-left: 0;\r\n	}\r\n\r\n	#main-menu > li:last-child, #main-menu > li.last {\r\n		margin-right: 0;\r\n	}\r\n\r\n	#main-menu > li > a, \r\n	#main-menu > li.sectionheader span {\r\n		padding: 0 6px 0 10px;\r\n		line-height: 37px;\r\n		font-size: 1em;\r\n	}\r\n\r\n	#main-menu > li.parent:hover > a, \r\n	#main-menu > li.sectionheader.parent:hover > span,\r\n	#main-menu > li.parent.active > a, \r\n	#main-menu > li.parent.active > span {\r\n		color: [[\$white]];\r\n		background-color: [[\$dark_grey]];\r\n		background-color: rgba(85, 85, 85, .95);\r\n	}\r\n\r\n	[[* /* --- SECOND LEVEL --- */ *]]\r\n	#main-menu > li > ul,\r\n	#main-menu > li > ul > li > ul [[* /* third level */ *]] {\r\n		display: block;\r\n		width: 260px;\r\n	}\r\n\r\n	#main-menu > li:hover > ul,\r\n	#main-menu > li.active > ul,\r\n	#main-menu > li > ul > li:hover > ul,\r\n	#main-menu > li > ul > li.active > ul {\r\n		height: auto;\r\n		position: absolute;\r\n		z-index: 9999;\r\n		top: 37px;\r\n		right: 0;\r\n		left: auto;\r\n		display: block;\r\n		border-radius: 3px;\r\n	}\r\n	\r\n	#main-menu > li:first-child:hover > ul,\r\n	#main-menu > li:first-child.active > ul {\r\n		right: auto;\r\n		left: 0;\r\n	}\r\n	\r\n	#main-menu > li > ul > li {\r\n		position: relative;\r\n		line-height: 1;\r\n		margin: 0;\r\n		padding-left: 10px;\r\n	}\r\n	\r\n	#main-menu > li:first-child > ul > li {\r\n		padding-right: 10px;\r\n		padding-left: 0;\r\n	}\r\n	\r\n	#main-menu > li > ul > li > a,\r\n	#main-menu > li > ul > li.sectionheader > span,\r\n	#main-menu > li > ul > li > ul > li > a,\r\n	#main-menu > li > ul > li > ul > li.sectionheader > span {\r\n		color: [[\$white]];\r\n		display: block;\r\n		text-transform: none;\r\n		line-height: 1.2;\r\n		border-bottom: 1px dotted #858585;\r\n		background-color: [[\$dark_grey]];\r\n		background-color: rgba(90, 90, 90, .98);\r\n		padding: 8px 12px;\r\n		font-size: .875em; [[* /* 14px */ *]]\r\n		text-decoration: none;\r\n	}\r\n	\r\n	#main-menu > li > ul > li.current > a, \r\n	#main-menu > li > ul > li.current.sectionheader > span,\r\n	#main-menu > li > ul > li > ul > li.current > a, \r\n	#main-menu > li > ul > ul > li > li.current.sectionheader > span {\r\n		color: [[\$orange]];\r\n	}\r\n\r\n	[[* /* THIRD LEVEL */ *]]\r\n	#main-menu > li > ul > li:hover > ul,\r\n	#main-menu > li > ul > li.active > ul {\r\n		width: 250px;\r\n		height: auto;\r\n		top: 0;\r\n		right: auto;\r\n		left: -250px;\r\n	}\r\n	\r\n	#main-menu > li:first-child > ul > li:hover > ul,\r\n	#main-menu > li:first-child > ul > li.active > ul {\r\n		left: auto;\r\n		right: -250px;\r\n	}\r\n	\r\n	.lt-ie9 #main-menu > li > ul > li:hover > ul,\r\n	.lt-ie9 #main-menu > li > ul > li.active > ul {\r\n		left: -247px;\r\n	}\r\n\r\n	#main-menu > li > ul > li:hover > ul:after,\r\n	#main-menu > li > ul > li.active > ul:after {\r\n		content: ' ';\r\n		width: 0px;\r\n		height: 0px;\r\n		border-style: solid;\r\n		border-width: 7px 0 7px 6px;\r\n		border-color: transparent transparent transparent [[\$dark_grey]];\r\n		border-color: transparent transparent transparent rgba(85, 85, 85, .95);\r\n		position: absolute;\r\n		right: -6px;\r\n		top: 12px;\r\n	}\r\n	\r\n	.lt-ie9 #main-menu > li:first-child > ul > li:hover > ul,\r\n	.lt-ie9 #main-menu > li:first-child > ul > li.active > ul {\r\n		left: auto;\r\n		right: -247px;\r\n	}\r\n	\r\n	#main-menu > li:first-child > ul > li:hover > ul:after,\r\n	#main-menu > li:first-child > ul > li.active > ul:after {\r\n		left: -10px;\r\n		right: auto;\r\n	}\r\n\r\n	#main-menu li ul li a:hover, \r\n	#main-menu li ul li span.sectionheader:hover {\r\n		box-shadow: 0 0 5px rgba(85, 85, 85, .9);\r\n		z-index: 2;\r\n	}\r\n\r\n	#main-menu > ul > li:last-child > a,\r\n	#main-menu > ul > li.sectionheader:last-child > span,\r\n	#main-menu > ul > li > ul > li:last-child > a,\r\n	#main-menu > ul > li > ul > li.sectionheader:last-child > span {\r\n		border-bottom: none;\r\n	}\r\n\r\n	.header-bottom {\r\n		height: 55px;\r\n		line-height: 55px;\r\n		padding: 8px 0;\r\n	}\r\n	\r\n	.phrase-text {\r\n		text-align: left;\r\n	}\r\n\r\n	input.search-input {\r\n		height: 17px;\r\n		line-height: 17px;\r\n		width: 100%;\r\n		max-width: 320px;\r\n	}\r\n	\r\n	input.search-input:focus {\r\n		max-width: 90%;\r\n	}\r\n	\r\n	[[* /* print button */ *]]\r\n	a.printbutton {\r\n		display: block;\r\n		padding-left: 6px;\r\n		width: 16px;\r\n		height: 16px;\r\n		float: right;\r\n		text-decoration: none;\r\n		color: [[\$dark_grey]];\r\n		background-color: [[\$white]];\r\n		z-index: 1;\r\n		position: relative;\r\n	}\r\n	\r\n	a.printbutton i {\r\n		display: inline-block;\r\n		-webkit-transform: rotateY(0deg);\r\n		-moz-transform: rotateY(0deg);\r\n		-ms-transform: rotateY(0deg);\r\n		-o-transform: rotateY(0deg);\r\n		transform: rotateY(0deg);\r\n		-webkit-transition: -webkit-transform 250ms ease-out 0s;\r\n		-moz-transition: -moz-transform 250ms ease-out 0s;\r\n		-o-transition: -o-transform 250ms ease-out 0s;\r\n		transition: transform 250ms ease-out 0s;\r\n	}\r\n	\r\n	a.printbutton:hover {\r\n		color: [[\$orange]];\r\n	}\r\n	\r\n	a.printbutton:hover i {\r\n		-webkit-transform: rotateY(360deg);\r\n		-moz-transform: rotateY(180deg);\r\n		-ms-transform: rotateY(360deg);\r\n		-o-transform: rotateY(360deg);\r\n		transform: rotateY(360deg);\r\n	}\r\n	\r\n	[[* /* --- FOOTER --- */ *]]\r\n	\r\n	.footer ul.social {\r\n		text-align: left;\r\n	}\r\n	\r\n	.footer .social li a i {\r\n		display: inline-block;\r\n		-webkit-transform: rotateY(0deg);\r\n		-moz-transform: rotateY(0deg);\r\n		-ms-transform: rotateY(0deg);\r\n		-o-transform: rotateY(0deg);\r\n		transform: rotateY(0deg);\r\n		-webkit-transition: -webkit-transform 250ms ease-out 0s;\r\n		-moz-transition: -moz-transform 250ms ease-out 0s;\r\n		-ms-transition: -moz-transform 250ms ease-out 0s;\r\n		-o-transition: -o-transform 250ms ease-out 0s;\r\n		transition: transform 250ms ease-out 0s;\r\n	}\r\n	\r\n	.footer .social li a:hover i {\r\n		-webkit-transform: rotateY(360deg);\r\n		-moz-transform: rotateY(180deg);\r\n		-ms-transform: rotateY(360deg);\r\n		-o-transform: rotateY(360deg);\r\n		transform: rotateY(360deg);\r\n	}\r\n	\r\n	[[* /* --- Footer Navigation --- */ *]]\r\n	\r\n	.footer-navigation {\r\n		border-bottom: none;\r\n	}\r\n	\r\n	#footer-menu > li {\r\n		float: left;\r\n		display: block;\r\n		position: relative;\r\n		margin-left: 3.8%;\r\n		width: 30.75%;\r\n	}\r\n	\r\n	#footer-menu > li:first-child {\r\n		margin-left: 0;\r\n	} \r\n}\r\n\r\n[[* /* ================================================\r\n WHEN LAYOUT BREAKS IT'S TIME FOR NEW MEDIA QUERY\r\n ================================================== */ *]]\r\n@media only screen and (max-width: 780px) {\r\n\r\n	.search {\r\n		margin-top: 15px;\r\n	}\r\n	\r\n	input.search-input {\r\n		width: 100%;\r\n		max-width: 100%;\r\n		float: left;\r\n	}\r\n	\r\n	input.search-input:focus {\r\n		max-width: none;\r\n	}\r\n	\r\n	.header-bottom {\r\n		padding-top: 20px;\r\n		text-align: center;\r\n		line-height: inherit;\r\n		padding: 20px 0;\r\n	}\r\n\r\n	\r\n}\r\n\r\n@media only screen and (min-width: 940px) and (max-width: 1110px) {\r\n	\r\n	#main-menu > li {\r\n		margin: 0;\r\n	}\r\n	\r\n	#main-menu > li > a, \r\n	#main-menu > li.sectionheader span {\r\n		padding: 0 6px;\r\n	}\r\n}\r\n\r\n@media only screen and (min-width: 768px) and (max-width: 1050px) {\r\n	\r\n	.row nav.main-navigation {\r\n		height: auto;\r\n		float: none;\r\n		display: block;\r\n		margin-left: 0;\r\n		width: 100%;\r\n		clear: left;\r\n	}\r\n	\r\n	#main-menu {\r\n		margin-top: 15px;\r\n		margin-bottom: 15px;\r\n		border-bottom: 1px solid [[\$light_grey]];\r\n		float: none;\r\n		display: block;\r\n		\r\n	}\r\n	\r\n	#main-menu > li {\r\n		margin: 0;\r\n		bottom: -1px;\r\n		text-align: center;\r\n		border-bottom: 1px solid [[\$light_grey]];\r\n		border-right: 1px solid [[\$light_grey]];\r\n		border-top: 1px solid [[\$light_grey]];\r\n	}\r\n	\r\n	#main-menu > li.current {\r\n		border-bottom-color: [[\$white]];\r\n		border-top-color: [[\$orange]];\r\n	}\r\n	\r\n	#main-menu > li.current > a {\r\n		border-top: 1px solid [[\$orange]];\r\n		line-height: 45px;\r\n	}\r\n	\r\n	#main-menu > li:first-child {\r\n		border-left: 1px solid [[\$light_grey]];\r\n	}\r\n	\r\n	#main-menu > li > a,\r\n	#main-menu > li > span {\r\n		line-height: 46px;\r\n		padding-left: 12px;\r\n		padding-right: 6px;\r\n	}\r\n	\r\n	#main-menu > li:hover > ul,\r\n	#main-menu > li.active > ul {\r\n		top: 45px;\r\n	}\r\n\r\n	.header-bottom {\r\n		height: auto;\r\n	}\r\n	\r\n	.row .seven-col.phrase-text,\r\n	.row .five-col.search {\r\n		display: block;\r\n		float: none;\r\n		width: 100%;\r\n		margin-left: 0;\r\n		text-align: center;\r\n	}\r\n}\r\n\r\n[[* /* ================================================\r\n WINDOWS 8 SNAP VIEW (yeah yeah W3C blah blah)\r\n ================================================== */ *]]\r\n@-ms-viewport {\r\n	width: device-width;\r\n}\r\n\r\n@-o-viewport {\r\n	width: device-width;\r\n}\r\n\r\n@-moz-viewport {\r\n	width: device-width;\r\n}\r\n\r\n@-webkit-viewport {\r\n	width: device-width;\r\n}\r\n\r\n@viewport {\r\n	width: device-width;\r\n}\r\n[[/strip]]
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Simplex Layout');
$css->set_description('Simplex Theme main layout Stylesheet');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
[[strip]]\r\n\r\n[[* /* ------ BANNER AREA ------ */  *]]\r\n.banner {\r\n	background: #fefefe; \r\n	background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZlZmVmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjQ3JSIgc3RvcC1jb2xvcj0iI2YxZjFmMSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlOWU5ZTkiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);\r\n	background: -moz-linear-gradient(top,  #fefefe 0%, #f1f1f1 47%, #e9e9e9 100%);\r\n	background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#fefefe), color-stop(47%,#f1f1f1), color-stop(100%,#e9e9e9)); \r\n	background: -webkit-linear-gradient(top,  #fefefe 0%,#f1f1f1 47%,#e9e9e9 100%);\r\n	background: -o-linear-gradient(top,  #fefefe 0%,#f1f1f1 47%,#e9e9e9 100%); \r\n	background: -ms-linear-gradient(top,  #fefefe 0%,#f1f1f1 47%,#e9e9e9 100%);\r\n	background: linear-gradient(to bottom,  #fefefe 0%,#f1f1f1 47%,#e9e9e9 100%); \r\n}\r\n\r\n.lt-ie9 .banner {\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#fefefe', endColorstr='#e9e9e9',GradientType=0 );\r\n}\r\n\r\n#sx-slides {\r\n	position: relative;\r\n	overflow: hidden;\r\n	width: 100%;\r\n	margin: 0 auto;\r\n	position: relative;\r\n	height: 380px;\r\n}\r\n\r\n#sx-slides > .sequence-canvas {\r\n	height: 100%;\r\n	width: 100%;\r\n	margin: 0;\r\n	padding: 0;\r\n	list-style: none;\r\n}\r\n\r\n#sx-slides > .sequence-canvas > li {\r\n	position: absolute;\r\n	width: 100%;\r\n	height: 100%;\r\n	z-index: 1;\r\n	top: -50%;\r\n}\r\n\r\n#sx-slides > .sequence-canvas > li img {\r\n	height: 96%;\r\n}\r\n\r\n#sx-slides > .sequence-canvas li > * {\r\n	position: absolute;\r\n	-webkit-transition-property: left, bottom, right, top, -webkit-transform, opacity;\r\n	-moz-transition-property: left, bottom, right, top, -moz-opacity;\r\n	-ms-transition-property: left, bottom, right, top, -ms-opacity;\r\n	-o-transition-property: left, bottom, right, top, -o-opacity;\r\n	transition-property: left, bottom, right, top, transform, opacity;\r\n}\r\n\r\n#sx-slides .title {\r\n	color: [[\$orange]];\r\n	font-size: 2.25em;\r\n	line-height: 1.1;\r\n	font-weight: 700;\r\n	left: 65%;\r\n	opacity: 0;\r\n	bottom: 22%;\r\n	z-index: 50;\r\n	margin-top: 0;\r\n}\r\n\r\n#sx-slides .animate-in .title {\r\n	left: 12%;\r\n	opacity: 1;\r\n	-webkit-transition-duration: 0.8s;\r\n	-moz-transition-duration: 0.8s;\r\n	-ms-transition-duration: 0.8s;\r\n	-o-transition-duration: 0.8s;\r\n	transition-duration: 0.8s;\r\n}\r\n\r\n#sx-slides .animate-out .title {\r\n	left: 35%;\r\n	opacity: 0;\r\n	-webkit-transition-duration: 0.3s;\r\n	-moz-transition-duration: 0.3s;\r\n	-ms-transition-duration: 0.3s;\r\n	-o-transition-duration: 0.3s;\r\n	transition-duration: 0.3s;\r\n}\r\n\r\n#sx-slides .subtitle {\r\n	margin-top: 0;\r\n	z-index: 5;\r\n	color: [[\$dark_grey]];\r\n	font-family: 'Oswald', Impact, Haettenschweiler, 'Arial Narrow Bold', sans-serif;\r\n	font-weight: 700;\r\n	font-size: 1.8125em;\r\n	left: 35%;\r\n	opacity: 0;\r\n	top: 72%;\r\n}\r\n\r\n#sx-slides .animate-in .subtitle {\r\n	left: 20%;\r\n	opacity: 1;\r\n	-webkit-transition-duration: 1.3s;\r\n	-moz-transition-duration: 1.3s;\r\n	-ms-transition-duration: 1.3s;\r\n	-o-transition-duration: 1.3s;\r\n	transition-duration: 1.3s;\r\n}\r\n\r\n#sx-slides .animate-out .subtitle {\r\n	left: 65%;\r\n	opacity: 0;\r\n	-webkit-transition-duration: 0.8s;\r\n	-moz-transition-duration: 0.8s;\r\n	-ms-transition-duration: 0.8s;\r\n	-o-transition-duration: 0.8s;\r\n	transition-duration: 0.8s;\r\n}\r\n\r\n\r\n#sx-slides .image {\r\n	left: -10px;\r\n	position: absolute;\r\n	bottom: 800px;\r\n	-webkit-transform: rotate(-90deg);\r\n	-moz-transform: rotate(-90deg);\r\n	-ms-transform: rotate(-90deg);\r\n	-o-transform: rotate(-90deg);\r\n	transform: rotate(-90deg);\r\n	opacity: 0;\r\n	max-width: 70%;\r\n	height: auto !important;\r\n	max-height: 275px !important;\r\n}\r\n\r\n#sx-slides .animate-in .image {\r\n	left: 14%;\r\n	bottom: -49%;\r\n	opacity: 1;\r\n	-webkit-transform: rotate(0deg);\r\n	-moz-transform: rotate(0deg);\r\n	-ms-transform: rotate(0deg);\r\n	-o-transform: rotate(0deg);\r\n	transform: rotate(0deg);\r\n	-webkit-transition-duration: 2s;\r\n	-moz-transition-duration: 2s;\r\n	-ms-transition-duration: 2s;\r\n	-o-transition-duration: 2s;\r\n	transition-duration: 2s;\r\n}\r\n\r\n#sx-slides .animate-out .image {\r\n	left: -10px;\r\n	bottom: -800px;\r\n	opacity: 0;\r\n	-webkit-transform: rotate(-90deg);\r\n	-moz-transform: rotate(-90deg);\r\n	-ms-transform: rotate(-90deg);\r\n	-o-transform: rotate(-90deg);\r\n	transform: rotate(-90deg);\r\n	-webkit-transition-duration: 1s;\r\n	-moz-transition-duration: 1s;\r\n	-ms-transition-duration: 1s;\r\n	-o-transition-duration: 1s;\r\n	transition-duration: 1s;\r\n}\r\n\r\n@media only screen and (min-width: 768px) {\r\n	\r\n	#sx-slides .title {\r\n		font-size: 3em;\r\n	}\r\n\r\n	#sx-slides .animate-in .title {\r\n		left: 3%;\r\n	}\r\n	\r\n	#sx-slides .subtitle {\r\n		font-size: 2.5em;\r\n	}\r\n	\r\n	#sx-slides .animate-in .subtitle {\r\n		left: 8%;\r\n	}\r\n\r\n	#sx-slides .image {\r\n		left: auto;\r\n		right: -10px;\r\n		position: absolute;\r\n		max-width: 70%;\r\n		height: auto !important;\r\n		max-height: 300px !important;\r\n	}\r\n	\r\n	#sx-slides .animate-in .image {\r\n		left: auto;\r\n		right: 5%;\r\n		bottom: -45%;\r\n	}\r\n	\r\n	#sx-slides .animate-out .image {\r\n		left: auto;\r\n		bottom: -800px;\r\n	}\r\n}\r\n\r\n@media only screen and (min-width: 1050px) {\r\n	\r\n	#sx-slides {\r\n		height: 440px;\r\n	}\r\n	\r\n	#sx-slides .title {\r\n		font-size: 3.25em;\r\n		bottom: 15%;\r\n	}\r\n\r\n	#sx-slides .animate-in .title {\r\n		left: 8%;\r\n	}\r\n	\r\n	#sx-slides .subtitle {\r\n		font-size: 2.875em;\r\n		top: 78%\r\n	}\r\n	\r\n	#sx-slides .animate-in .subtitle {\r\n		left: 12%;\r\n	}\r\n\r\n	#sx-slides .image {\r\n		max-width: 90%;\r\n		height: auto !important;\r\n		max-height: 400px !important;\r\n	}\r\n}\r\n\r\n[[/strip]]
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Simplex Slideshow');
$css->set_description('Simplex Theme Stylesheet for header slideshow');
$css->set_content($txt);
$css->set_media_types('screen');
$css->save();
$css_list[$css->get_name()] = $css;

$txt = <<<EOT
[[strip]]\r\n\r\n[[* /* reset body background and color, just in case */ *]]\r\nbody {\r\n    background: #fff;\r\n    color: #000;\r\n    font-family: Georgia, Times New Roman, serif;\r\n    font-size: 12pt\r\n}\r\n[[* /* any element with class noprint or listed below should not be printed */ *]]\r\n.noprint,\r\n.visuallyhidden {\r\n    display: none\r\n}\r\n[[* /* display image as block */ *]]\r\nimg {\r\n    display: block;\r\n    float: none\r\n}\r\n[[* /* links arent clickable on paper, lets display url */ *]]\r\na:link:after {\r\n    content: " (" attr(href) ") ";\r\n}\r\na {\r\n    text-decoration: underline\r\n}\r\n\r\n[[/strip]]
EOT;
$css = new CmsLayoutStylesheet;
$css->set_name('Simplex Print'); // id = 52
$css->set_description('Default Print style rules attached to Simplex Design');
$css->set_content($txt);
$css->set_media_types('print');
$css->save();
$css_list[$css->get_name()] = $css;


// now attach stylesheets to the themes.
verbose_msg(ilang('install_attachstylesheets'));
$css_menuleft_1col_theme->add_stylesheet($css_list['Layout Left sidebar + 1 column']->get_id());
$css_menuleft_1col_theme->add_stylesheet($css_list['Navigation CSSMenu - Vertical']->get_id());
$css_menuleft_1col_theme->add_stylesheet($css_list['Accessibility and cross-browser tools']->get_id());
$css_menuleft_1col_theme->add_stylesheet($css_list['Print']->get_id());
$css_menuleft_1col_theme->add_stylesheet($css_list['Module News']->get_id());
$css_menuleft_1col_theme->add_stylesheet($css_list['Navigation FatFootMenu']->get_id());
$css_menuleft_1col_theme->save();

$css_menutop_2col_theme->add_stylesheet($css_list['Layout Top menu + 2 columns']->get_id());
$css_menutop_2col_theme->add_stylesheet($css_list['Navigation CSSMenu - Horizontal']->get_id());
$css_menutop_2col_theme->add_stylesheet($css_list['Module News']->get_id());
$css_menutop_2col_theme->add_stylesheet($css_list['Print']->get_id());
$css_menutop_2col_theme->add_stylesheet($css_list['Navigation FatFootMenu']->get_id());
$css_menutop_2col_theme->add_stylesheet($css_list['Accessibility and cross-browser tools']->get_id());
$css_menutop_2col_theme->save();

$leftsimple_1col_theme->add_stylesheet($css_list['Layout Left sidebar + 1 column']->get_id());
$leftsimple_1col_theme->add_stylesheet($css_list['Navigation Simple - Vertical']->get_id());
$leftsimple_1col_theme->add_stylesheet($css_list['Module News']->get_id());
$leftsimple_1col_theme->add_stylesheet($css_list['Handheld']->get_id());
$leftsimple_1col_theme->add_stylesheet($css_list['Print']->get_id());
$leftsimple_1col_theme->add_stylesheet($css_list['Accessibility and cross-browser tools']->get_id());
$leftsimple_1col_theme->add_stylesheet($css_list['Navigation FatFootMenu']->get_id());
$leftsimple_1col_theme->save();

$ncleanblue_theme->add_stylesheet($css_list['ncleanblueutils']->get_id());
$ncleanblue_theme->add_stylesheet($css_list['ncleanbluecore']->get_id());
$ncleanblue_theme->add_stylesheet($css_list['Layout NCleanBlue']->get_id());
$ncleanblue_theme->save();

$shadowmenu_left_1col_theme->add_stylesheet($css_list['Layout Left sidebar + 1 column']->get_id());
$shadowmenu_left_1col_theme->add_stylesheet($css_list['Navigation ShadowMenu - Vertical']->get_id());
$shadowmenu_left_1col_theme->add_stylesheet($css_list['Accessibility and cross-browser tools']->get_id());
$shadowmenu_left_1col_theme->add_stylesheet($css_list['Print']->get_id());
$shadowmenu_left_1col_theme->add_stylesheet($css_list['Module News']->get_id());
$shadowmenu_left_1col_theme->add_stylesheet($css_list['Navigation FatFootMenu']->get_id());
$shadowmenu_left_1col_theme->save();

$shadowmenu_tab_2col_theme->add_stylesheet($css_list['Layout Top menu + 2 columns']->get_id());
$shadowmenu_tab_2col_theme->add_stylesheet($css_list['Navigation ShadowMenu - Horizontal']->get_id());
$shadowmenu_tab_2col_theme->add_stylesheet($css_list['Module News']->get_id());
$shadowmenu_tab_2col_theme->add_stylesheet($css_list['Accessibility and cross-browser tools']->get_id());
$shadowmenu_tab_2col_theme->add_stylesheet($css_list['Print']->get_id());
$shadowmenu_tab_2col_theme->add_stylesheet($css_list['Navigation FatFootMenu']->get_id());
$shadowmenu_tab_2col_theme->save();

$simplex_theme->add_stylesheet($css_list['Simplex Print']->get_id());
$simplex_theme->add_stylesheet($css_list['Simplex Core']->get_id());
$simplex_theme->add_stylesheet($css_list['Simplex Layout']->get_id());
$simplex_theme->add_stylesheet($css_list['Simplex Slideshow']->get_id());
$simplex_theme->save();

$topsimple_leftsubnav_1col_theme->add_stylesheet($css_list['Layout Top menu + 2 columns']);
$topsimple_leftsubnav_1col_theme->add_stylesheet($css_list['Navigation Simple - Horizontal']);
$topsimple_leftsubnav_1col_theme->add_stylesheet($css_list['Navigation Simple - Vertical']);
$topsimple_leftsubnav_1col_theme->add_stylesheet($css_list['Accessibility and cross-browser tools']);
$topsimple_leftsubnav_1col_theme->add_stylesheet($css_list['Module News']);
$topsimple_leftsubnav_1col_theme->add_stylesheet($css_list['Print']);
$topsimple_leftsubnav_1col_theme->add_stylesheet($css_list['Navigation FatFootMenu']);
$topsimple_leftsubnav_1col_theme->save();

$content_list = array();
ContentOperations::get_instance()->LoadContentType('content');

/////////////////////////
//  //  HOME PAGE  //  //
/////////////////////////

verbose_msg(ilang('install_createcontentpages'));
// Home / -1 / NCleanBlue  DEFAULT
$contentobj = new Content;
$contentobj->SetName('Home');
$contentobj->SetAlias();
$contentobj->SetMenuText('Home');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$simplex_theme->get_id());
$contentobj->SetTemplateId($template_list['Simplex']);
$contentobj->SetDefaultContent(TRUE); // this is the default page.
$contentobj->SetOwner(1);
$contentobj->SetParentId(-1);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>Congratulations! The installation worked. You now have a fully functional installation of CMS Made Simple and you are <em>almost</em> ready to start building your site.</p><p>If you chose to install the default content, you will see numerous pages available to read.  You should read them thoroughly  as these default pages are devoted to showing you the basics of how to begin working with CMS Made Simple.  On these example pages, templates, and stylesheets many of the features of the default installation of CMS Made Simple are described and demonstrated. You can learn much about the power of CMS Made Simple by absorbing this information.</p><p>To get to the Administration Console you have to login as the administrator (with the username/password you mentioned during the installation process) on your site at http://yourwebsite.com/cmsmspath/admin.  If this is your site click <a title="CMSMS Demo Admin Panel" href="admin">here</a> to login.</p><p>Read about how to use CMS Made Simple in the <a class="external" href="http://docs.cmsmadesimple.org/" title="CMS Made Simple Documentation" target="_blank">documentation</a>. In case you need any help the community is always at your service, in the  <a class="external" href="http://forum.cmsmadesimple.org" title="CMS Made Simple Forum" target="_blank">forum</a> or the <a class="external" href="http://www.cmsmadesimple.org/support/irc" title="Information about the CMS Made Simple IRC channel" target="_blank">IRC</a>.</p><h3>License</h3><p>CMS Made Simple is released under the <a class="external" href="http://www.gnu.org/licenses/licenses.html#GPL" title="General Public License" target="_blank">GPL</a> license and as such you don\'t have to leave a link back to us in these templates or on your site as much as we would like it.</p><p> Some third party add-on modules may include additional license restrictions.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

///////////////////////////////
//  //  HOW CMSMS WORKS  //  //
///////////////////////////////

// How CMSMS Works / -1 / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('How CMSMS Works');
$contentobj->SetAlias();
$contentobj->SetMenuText('How CMSMS Works');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId(-1);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>So how is a web-site created with CMS Made Simple? There are a couple of terms that are central to understanding this.</p><p>You first need to have templates, which is the HTML code for your pages. This is styled with CSS in one or more style sheets that are attached to each template. You then create pages that contain your websites content using one of these templates.</p><p>That doesn\'t sound too hard, does it? Basically you don\'t need to know any HTML or CSS to get a site up with CMS Made Simple. But if you want to customize it to your liking, consider learning some <a class="external" href="http://www.w3schools.com/css/" target="_blank">CSS</a>.</p><p>In the menu to the left you can read more about this, as well as more advanced features like the Menu Manager, additional extensions for adding many kinds of functionality to your site and the Event Manager for managing work flow. Last is a summary of the basic work flow when creating a site with CMS Made Simple.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// Templates and stylesheets / How CMSMS Works / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Templates and stylesheets');
$contentobj->SetAlias();
$contentobj->SetMenuText('Templates and stylesheets');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['How CMSMS Works']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>A <em>template</em> is basically the HTML layout, or the design, of a page.  This is the work of the designer. Whatever is in a template is used on every  page that uses that template, meaning that the person editing the content  doesn\'t need any web design skills.</p><p>In the template there are placeholders for content and navigation areas. When  a user is visiting your site the page is automatically generated from the  template and the placeholders are filled with the content.</p><p>The template is the HTML structure. It is then styled in one or more  <em>style sheets</em> that are attached to each template. This styling is done  with CSS. So to get a site look the way you want you should be familiar with HTML and CSS on at least a basic level. But don\'t worry, there are themes with  ready-made templates and style sheets for you to download!</p><p>When you first install CMS Made Simple there are some basic templates that  you can use and customize to your needs. Those templates are described in the section {cms_selflink page=default_templates text=\'Default Templates Explained\'}. The designer of your site can also add new templates to make the site look any way you want. The CMSMS community also shares themes for anyone to download and use at <a class="external" href="http://themes.cmsmadesimple.org" target="_blank">The CMSMS Themes site</a>.</p><h3>Templates and style sheets in the CMSMS Admin Panel</h3><p>In the CMSMS Admin Panel you will find the templates and style sheets in the <strong>Layout</strong> menu.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// Pages and navigation / How CMSMS Works / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Pages and navigation');
$contentobj->SetAlias();
$contentobj->SetMenuText('Pages and navigation');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['How CMSMS Works']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>Pages determine the structure of your web-site as seen in the admin Content &raquo; Pages page. Think of a web-site as a set  of pages. These pages are accessed through a menu. You can also link to a page  from within another page.</p><h3>Navigation/Menu</h3><p>The navigation, or the menu, is a set of links that help the user to navigate through  the pages on your web site. These links are automatically created by CMS Made  Simple from the page structure. This hierarchy is what drives the menu you see  on the left of this page.</p><p>Pages can be in several levels, like a tree of generations. The top level in  the menu are the parent pages. Each parent page can have children pages, which  in turn can be parents to other children.</p><p>The page template determines where on a page the navigation is placed.</p><p>You can create any kind of navigation you can dream of by customizing a menu  template for <em>Menu Manager</em>. However, the default templates should work  for most situations as the menu basically is just an unordered list that you  style to your liking with CSS. The web is full of good articles about styling a list of links, one of the best is <a class="external" href="http://css.maxdesign.com.au/listutorial/index.htm" target="_blank">listutorial at maxdesign</a></p><h3>Pages in the CMSMS Admin Panel</h3><p>You add pages, as well as other content (see next chapter), in the CMSMS Admin Panel from the Content &raquo; Pages menu.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// Content / How CMSMS Works / Left simple navigation + 1 column
// Pages and navigation / How CMSMS Works / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Content');
$contentobj->SetAlias();
$contentobj->SetMenuText('Content');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['How CMSMS Works']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>The content is the information for the page. We have already mentioned that for each page on your site you  choose what template to use. When you add content to a page, it is automatically  placed in the placeholders of the template selected for that page.</p><p>A template can define one or several content areas, or content blocks. To add more content blocks to your template, use <code>{ldelim}content block=\'block name\'}</code>. These blocks will then appear as text areas when you edit or add a page that uses that template.</p><p>You can make a content block use only one line, instead of a full text area, by using the parameter oneline=true. That is, the full tag being: <code>{ldelim}content block=\'block name\' oneline=true}</code>. Read about more parameters in the help for the Content tag in the CMSMS Admin Panel, under Extensions &raquo; Tags.</p><h3>Content Types</h3><p>There are currently 6 main content types in version {cms_version} "{cms_versionname}". These content types determine the type of content for each menu item.</p><ul><li>Content</li><li>Error Page</li><li>External Page Link</li><li>Internal Page Link</li><li>Section Header</li><li>Separator</li></ul><p>The <strong>Content</strong> type is simply a regular page. Normally this is the only one you will use. That is what this page you are reading is. Here you can put any content that you would put on a regular page. The layout of these types of pages are controlled by the templates. For each <strong>content</strong> page you create you must add the title, menu text, choose if it is going to have a parent and choose a template for it.  If you login as admin and change the template of this page, you will see exactly how it works.</p><p>The <strong>Error Page</strong> type is just what it sounds like, a page you set for "404 page not found" errors, where you can add the content that shows when a 404 error occurs, a target type and title, you can also choose the template it uses, it has no parent as it is not part of the menu.</p><p>The <strong>External Page Link</strong> type is just what it sounds like, a link to another external page and you add the title, menu text, choose if it is going to have a parent and a destination page along with the target setting and other options that a content type page has. This <strong>external page link</strong> type also shows up in the menu following the same hierarchy rules as the <strong>content</strong> type.</p><p>The <strong>Internal Page Link</strong> type is also just what it sounds like, a link to another internal page. This <strong>internal page link</strong> type also shows up in the menu following the same hierarchy rules as the <strong>content</strong> type and you add the title, menu text, choose if it is going to have a parent and a destination page along with the target setting and other options that a content type page has.</p><p>The <strong>Section Header</strong> type is used to break up menus into groupings (sections). This is unrelated to the hierarchy, as the section headers have no associated pages with them but can be used to group a set of links of similar content under them. They are just a little bit of text to say what the next few links are in reference to.</p><p>The <strong>Separator</strong> type is just what it sounds like, a separator that appears on the menus. This type follows the hierarchy set in content management pages.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// Menu Manager / How CMSMS Works / Left simple navigation + 1 column17
$contentobj = new Content;
$contentobj->SetName('Menu Manager');
$contentobj->SetAlias();
$contentobj->SetMenuText('Menu Manager');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['How CMSMS Works']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>The Menu Manager is a module that reads your page hierarchy and builds a navigation using a \'Menu Manager Template\'. By default a few sample menu manager templates are included with your default installation. For most users these are enough, as a menu basically is just an unordered list that is styled with CSS.</p><p>The Menu Manager module also accepts various optional attributes (parameters) in the {ldelim}menu{rdelim} tag to allow you to customize its behavior. You can see the list and explanation of these parameters in the Menu Manager Help which can be found on the right side of the screen when you click on "Layout &raquo; Menu Manager" in the administration console.</p><p>Customizing templates in the Menu Manager is as simple as clicking the \'Import Template to Database\' button, which will then allow you to create a template with a new name, and modify the layout of the template. You can use your new navigation template by specifying the new name in the call to {ldelim}menu{rdelim} in your page template. i.e: {ldelim}menu template=\'mynewtemplate\'{rdelim}.</p><h3>Menu Manager in the CMSMS Admin Panel</h3><p>Read more about how to do this in the <strong>Help</strong> for the Menu Manager in the CMSMS Admin Panel. It can be found in the Layout menu.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// Extensions / How CMSMS Works / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Extensions');
$contentobj->SetAlias();
$contentobj->SetMenuText('Extensions');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['How CMSMS Works']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>There are three kinds of extensions, that can add many kinds of functionality to your default CMS Made Simple install. They are called tags, user defined tags, and modules.</p><h3>Tags</h3><p>Tags are the simplest form of extensions. They are designed to accomplish just one small and specific task.</p><p>There are a number of custom tags available with CMS Made Simple. To find what kind of tags are available look in Extensions &raquo; Tags in the Admin Panel.</p><p>To insert any of these in a template or a page, simply type e.g. <code>{ldelim}content}</code>. Many of these Smarty tags are used as placeholders in a template, i.e. placeholders for content, navigation, breadcrumbs etc.</p><p>Website developers who have a bit of PHP experience will find it easy to create and share their own custom tags.</p><h3>User defined tags</h3><p>Users can also create their own tags to insert in templates or pages., these are called user defined tags. They are snippets of php code (but without the &lt;?php and ?&gt; surrounding them), providing the ability to add re-usable pieces of php functionality to your site. User defined tags are inserted in templates and pages just like tags: <code>{ldelim}tagname}</code>.</p><p>Typically, user defined tags provide a utility that is special to a website, and likely won\'t need to be re-used on another site. Also they are typically small and used for simple tasks.</p><h3>Modules</h3><p>Modules are the highest level of plugin in the CMS Made Simple environment. They are designed to allow developers to implement complex tasks within CMSMS. A module typically provides advanced functionality, usually interacts with the database in complex ways, and may provide numerous reports or forms on the website. Additionally, a module may have an administrative interface to allow manipulating its data and its settings.</p><p>An extremely well defined API <em>(Application Programming Interface)</em> has been written to allow module developers to write complex, intricate, and fully functioning applications for use within a CMSMS powered website.</p><p>There are {cms_selflink page=\'modules\' text=\'a few modules included\'} with the default installation of CMS Made Simple. Other popular modules are Frontend Users, Album, Calendar, Guestbook and Form Builder.</p><p>The ModuleManager module (included with CMS Made Simple) allows browsing a list of available modules, reading about them, and then installing them on your website.</p><p>To insert modules in a template or a page, you actually use the module name as a parameter to the <code>{ldelim}cms_module}</code> tag. It looks like this: <code>{ldelim}cms_module module=\'modulename\' parameter1=\'this\' parameter2=5 parameter3=\'that\'}</code>. It is normal for modules to accept parameters to effect changes to their default behavior, though it is not always required.</p><h3>Read more</h3><p>You can read more about extensions in the <a class="external" href="http://docs.cmsmadesimple.org/modules/add-ons">CMSMS documentation</a>.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// Event Manager / How CMSMS Works / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Event Manager');
$contentobj->SetAlias();
$contentobj->SetMenuText('Event Manager');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['How CMSMS Works']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>Events are a new powerful way of assigning actions to events. For example if you would like to send an email to the site administrator when a new file is uploaded or a new page is created by another user you could add some code to those events to be executed when that event happens.</p><p>In brief here\'s how it works:</p><p>a) A module, or the core, can register, and then Send Events such as "newNews", or "newFronteEndUser" or "fileUploaded", "editPage", etc, etc, etc. there\'s some 50 events in the core at the moment, and then uploads and frontend users have been configured to send events, We still have to do selfreg, etc, etc, etc.</p><p>b) There are pages in the admin to allow you to specify which modules, and/or user tags should handle those events, and the order that each of those handlers should be called in.</p><p>c) If one of the handlers of an event is a module, then.... the modules DoEvent method is called with the name of the event, and whatever data it wants to send. Each triggered event needs to be documented, but as of this moment, most are.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// Workflow / How CMSMS Works / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Workflow');
$contentobj->SetAlias();
$contentobj->SetMenuText('Workflow');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['How CMSMS Works']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>These are the basic steps when creating a website with CMS Made Simple:</p><ol><li><em>Plan</em> -- Determine what pages you want (structure) and how you want  these pages to look (design). </li><li><em>Create Templates</em> -- Create one or several template(s) that  determine the layout of your pages. </li><li><em>Style the Templates</em> -- Attach one or more stylesheets to each  template and style the layout and content with CSS. </li><li><em>Create Pages</em> -- Then you create pages, add content to them and  select what template to use for each page. </li></ol><p>When a user navigates to your site the page is created from the template,  adding the content where the placeholder(s) are in the template.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// Where do I get Help / How CMSMS Works / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Where do I get help?');
$contentobj->SetAlias();
$contentobj->SetMenuText('Where do i get help?');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['How CMSMS Works']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>The CMS Made Simple community is always at your service if you need some help with your site. Here is where you find more information and support:</p><ul><li><a class="external" href="http://docs.cmsmadesimple.org/">The CMSMS Documentation Website</a> -- Start here, the documentation is maintained by the CMSMS Dev-team</li><li><a class="external" href="http://forum.cmsmadesimple.org/">The CMSMS Forums</a> -- here you can search for answers to your questions or ask just about anything.</li><li><a class="external" href="http://cmsmadesimple.org/main/support/IRC">IRC</a> -- IRC is short for Internet Relay Chat and is like a community chat. Many developers hang out here and others that are ready to discuss and give support.</li></ul><p>Please remember that people involved in developing and supporting CMSMS have day jobs and other duties and might not be available 24/7. Be patient and polite and you will get better answers.</p><p>Hope you will enjoy using CMS Made Simple for creating your web sites! If you want to contribute to the development yourself, you are very welcome to do so. You can contact us on <a class="external" href="http://cmsmadesimple.org/main/support/IRC">IRC</a> or hit the <a class="external" href="http://forum.cmsmadesimple.org/">forums</a> to get involved.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

///////////////////////////////////////////
//  //  DEFAULT TEMPLATES EXPLAINED  //  //
///////////////////////////////////////////

// Default Templates Explained / -1 / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Default Templates Explained');
$contentobj->SetAlias();
$contentobj->SetMenuText('Default Templates Explained');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetAlias('default_templates');
$contentobj->SetParentId(-1);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
			      '<p>CMS Made Simple {cms_version} was installed with numerous default templates (you choose this during the installation process). These are to display some of the features of CMS Made Simple and to give you a head start when creating your own web sites.</p><p>The tags that are unique to templates in CMS Made Simple are described on the page {cms_selflink page=\'cmsms_tags\' text=\'CMSMS tags in the templates\'} (see menu to the left). Click on any link beneath that page in the menu to the left to see what the default templates look like.</p><h4>Changing the style of Default Templates</h4><p>All of the templates and style sheets have comments throughout them to help you find where to change the look of them.</p><h3>Menus/navigation</h3><p>Two kinds of navigation are used in these templates. For each there is a menu template in the Menu Manager. <strong>CSSMenu </strong>is a dropdown menu using only CSS. Well, for Internet Explorer 6 some JavaScript has to be used... Two of the page templates are using CSSMenu for navigation, {cms_selflink page=\'cssmenu_horizontal\' text=\'one with the menu horizontally at the top\'} and the other {cms_selflink page=\'cssmenu_vertical\' text=\'with the menu vertically to the left\'}.</p><p>The other navigation type is what we call <strong>Simple Navigation</strong>. That is just an unordered list that gets its style and appearance from the style sheets (CSS). Also here {cms_selflink page=\'top_left\' text=\'one page template is using a horizontal simple navigation\'} and the other {cms_selflink page=\'navleft\' text=\'a vertical menu\'}.</p><p>The menu tag in each template is used like this: <code>{ldelim}menu template=\'cssmenu\'}</code>, where the <code>cssmenu</code> is the name of the Menu Manager template, if you make a custom menu template you don\'t need to use the  on the end. More parameters can be used, for example to start a menu from the second level, collapse the children pages until the parent is clicked etc. Read more about that in the Menu Manager Help in the Admin Panel.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// CMSMS tags in the templates / Default Templates Exlplained / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('CMSMS tags in the templates');
$contentobj->SetAlias();
$contentobj->SetMenuText('CMSMS tags in the templates');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetAlias('cms_tags');
$contentobj->SetParentId($content_list['Default Templates Explained']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>Here we explain the tags that are used in the default templates that are specific to templates in CMS Made Simple. The rest of the templates are just pure HTML. You can read more about that in the <a class="external" href="http://docs.cmsmadesimple.org/layout/create-your-own-template">documentation website</a>.</p><div class="templatecode"><h3>Page title</h3><pre>&lt;title&gt;{ldelim}sitename} - {ldelim}title}&lt;/title&gt;</pre><p>For each page using these tags in a template the tags are replaced with the site name you specify in Site Admin &raquo; Global settings and the title you specify when you add/edit each page.</p><p><em>Read more</em> about the <code>{ldelim}sitename}</code> and <code>{ldelim}title}</code> tags in Extensions &raquo; Tags in the Admin Panel.</p></div><div class="templatecode"><h3>Metadata</h3><pre>{ldelim}metadata}</pre><p>This tag adds to your page any metadata that you have specified in Site Admin &raquo; Global settings and also page specific metadata that you can add under the Options tab when adding/editing a page.</p><p>It is also used for knowing the base folder for your site when using pretty URLs. So don\'t remove this if you use Pretty URLs!</p><p><em>Read more</em> about the <code>{ldelim}metadata}</code>tag in Extensions &raquo; Tags in the Admin Panel.</p></div><div class="templatecode"><h3>Stylesheets (deprecated)</h3><pre>{ldelim}stylesheet}</pre><p>This tag links to all style sheets (CSS) that you have attached to a template. It means that you only have to add this tag once and all attached style sheets will be linked automatically.</p><p><em>Read more</em> about the <code>{ldelim}stylesheet}</code> tag in Extensions &raquo; Tags in the Admin Panel.</p></div><div class="templatecode"><h3>Stylesheets</h3><pre>{ldelim}cms_stylesheet}</pre><p>This tag is the newer version of the tag above. The tag links to all style sheets (CSS) that you have attached to a template. It means that you only have to add this tag once and all attached style sheets will be linked automatically.</p><p>The new tag allows you to use smarty variables like [[$red]] to indicate a color, and one change will change it througout your layout. The new tag requires that [[root_url]]/ be put in front of images, as the stylesheets are cached.</p><p><em>Read more</em> about the <code>{ldelim}cms_stylesheet}</code> tag in Extensions &raquo; Tags in the Admin Panel.</p></div><div class="templatecode"><h3>Relational links</h3><pre>{ldelim}cms_selflink dir="start" rellink=1}{ldelim}cms_selflink dir="prev" rellink=1}{ldelim}cms_selflink dir="next" rellink=1}</pre><p>These are relational links for interconnections between pages, which is good for accessibility and Search Engine Optmization</p><p><em>Read more</em> about the <code>{ldelim}cms_selflink}</code> tag in Extensions &raquo; Tags in the Admin Panel.</p></div><div class="templatecode"><h3>Page width in Internet Explorer 6</h3><pre>{ldelim}literal}&lt;script type="text/JavaScript"&gt;&lt;!--//pass min and max -measured against window widthfunction P7_MinMaxW(a,b){ldelim}	var nw="auto",w=document.documentElement.clientWidth;	if(w&gt;=b){ldelim}nw=b+"px";}if(w&lt;=a){ldelim}nw=a+"px";}return nw;}//--&gt;&lt;/script&gt;&lt;!--[if lte IE 6]&gt;&lt;style type="text/css"&gt;#pagewrapper {ldelim}width:expression(P7_MinMaxW(720,950));}#container {ldelim}height: 1%;}&lt;/style&gt;&lt;![endif]--&gt;{ldelim}/literal}</pre><p>This isn\'t a tag really, but displays how to insert JavaScript in a CMSMS template.</p><p>The default templates use fluid page width. But Internet Explorer 6 doesn\'t understand min-width and max-width, so for that browser the min and max page width is set with this JavaScript. For other browsers the page width is set in the style sheets beginning with "Layout ..."</p></div><div class="templatecode"><h3>Skip links for accessibility</h3><pre>{ldelim}anchor anchor=\'main\' title=\'Skip to content\' accesskey=\'s\' text=\'Skip to content\'}</pre><p>Anchor links (links to an anchor in the same page) are inserted with the <code>{ldelim}anchor}</code> tag. In the default templates this is used for skip links that are visible to screen readers, but hidden with CSS to visual browsers.</p><p><em>Read more</em> about the <code>{ldelim}anchor}</code> tag in Extensions &raquo; Tags in the Admin Panel.</p></div><div class="templatecode"><h3>Header with logo image that links to default page</h3><pre>{ldelim}cms_selflink dir="start" text="$sitename"}</pre><p>In the header the &lt;h1&gt; tag (hidden by CSS) is a link to the page that is selected as the default page. The <code>dir="start"</code> parameter in the {ldelim}cms_selflink} tag is used for this. To get the site name as the text for the link, the <code>$sitename</code> variable is used.</p><p><em>Read more</em> about the <code>{ldelim}cms_selflink}</code> tag in Extensions &raquo; Tags in the Admin Panel.</p></div><div class="templatecode"><h3>Search</h3><pre>{ldelim}search}</pre><p>To insert a search form on your site, simply use the {ldelim}search} tag. Search is actually a module and should therefore be called as a parameter in the {ldelim}cms_module} tag, like this: <code>{ldelim}cms_module module=\'search\'}</code>. But to simplify matters, we did a wrapper tag so that it\'s easier to remember.</p><p><em>Read more</em> about the Search module in Extensions &raquo; Modules in the Admin Panel.</p></div><div class="templatecode"><h3>Breadcrumbs</h3><pre>{ldelim}breadcrumbs starttext=\'You are here\' root=\'Home\' delimiter=\'&raquo;\'}</pre><p>Breadcrumbs is a path to the current page. In the default templates we have chosen to put the text \'You are here\' before the path and force \'Home\' to always be the root in the path, even if it isn\'t. With the delimiter parameter you can select the delimiter that separates entries in the path.</p><p><em>Read more</em> about the <code>{ldelim}breadcrumbs}</code> tag in Extensions &raquo; Tags in the Admin Panel.</p></div><div class="templatecode"><h3>Navigation</h3><pre>{ldelim}menu template=\'simple navigation\' collapse=\'1\'}</pre><p>This is how you insert a menu where you want it to appear. Like the <code>{ldelim}search}</code> tag, this is actually just a wrapper tag, as the Menu Manager is a module.</p><p>In the default templates the menu manager template that is used for the menus are stored in files. That\'s why you see the .tpl extension in the template parameter. But you can easily import menu templates to the database and edit them directly in the Admin Panel. Then you simply omit the .tpl extension in the template parameter.</p><p><em>Read more</em> about the Menu Manager module in Extensions &raquo; Modules in the Admin Panel.</p></div><div class="templatecode"><h3>News</h3><pre>{ldelim}news number=\'3\' detailpage=\'news\'}</pre><p>This tag will display the last three news articles. When clicking a news article to read the details, it is opened on the page with the page alias \'news\'. That\'s what the detailpage parameter is doing.</p><p>Like all core modules there is a wrapper tag for the News module, to make it easier to use.</p><p><em>Read more</em> about the News module tag in Extensions &raquo; News in the Admin Panel.</p></div><div class="templatecode"><h3>Print button</h3><pre>{ldelim}print showbutton=true script=true}</pre><p>The <code>{ldelim}print}</code> tag is used to insert a print link. With the showbutton parameter set to true we have told the tag to output a button instead of text. The script parameter set to true means the print dialog window opens when clicking the button, for immediate printing.</p><p>The <code>{ldelim}print}</code> tag prints everything that is in your <code>{ldelim}content}</code> tag, that is only the content for a page.</p><p><em>Read more</em> about the <code>{ldelim}print}</code> tag in Extensions &raquo; Tags in the Admin Panel.</p></div><div class="templatecode"><h3>Page content</h3><pre>&lt;h2&gt;{ldelim}title}&lt;/h2&gt;{ldelim}content}</pre><p>Maybe the most important tag in your template. Where you put the <code>{ldelim}content}</code> is where the content for your page will appear.</p><p>We have also chosen to put the page title on every page (the <code>{ldelim}title}</code> tag), so that you don\'t have to put that in the content for every page.</p><p>The default <code>{ldelim}content}</code> tag is <strong>required</strong> for all templates.</p><p><em>Read more</em> about the <code>{ldelim}content}</code> and <code>{ldelim}title}</code> tags in Extensions &raquo; Tags in the Admin Panel.</p></div><div class="templatecode"><h3>Previous/next links</h3><pre>{ldelim}anchor anchor=\'main\' text=\'^ Top\'}{ldelim}cms_selflink dir="previous"}{ldelim}cms_selflink dir="next"}</pre><p>Some more internal links. These are using the dir parameter to link to the previous and next pages in the page hierarchy (separators and section headers will be omitted as they are no pages).</p></div><div class="templatecode"><h3>Page footer</h3><pre>{ldelim}global_content name=\'footer\'}</pre><p>Instead of bloating your template with lots of code you can put some code in a Global Content Block. Then call that Global Content Block with the <code>{ldelim}global_content}</code> tag. It\'s also useful for content or HTML code that is reused on several pages or templates.</p><p>In the default templates we have put the footer text in a Global Content Block with the name \'footer\'. You find the Global Content Blocks in the Content menu in the Admin Panel.</p><p><em>Read more</em> about the <code>{ldelim}global_content}</code> tag in Extensions &raquo; Tags in the Admin Panel.</p></div>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// Left simple navigation + 1 column / Default Templates Explained / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Left simple navigation + 1 column');
$contentobj->SetAlias();
$contentobj->SetMenuText('Left simple navigation + 1 column');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetAlias('navleft');
$contentobj->SetParentId($content_list['Default Templates Explained']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>This template has the menu in left sidebar. The menu is using the <strong>Simple Navigation</strong> menu template. It is styled in the stylesheet called <strong>Navigation Simple - Vertical</strong>.</p><p>You can easily float the sidebar with the menu to the right instead. Look in the <strong>Layout Left sidebar + 1 column</strong> style sheet for the <code>float:left;</code> property in the <code>div#sidebar</code> element. Change that to <code>float:right;</code> and the sidebar with the menu will instead be on the right side of the content, of course you will also have to adjust the margins for the sidebar and the div#main, basically just swap the left and right margins.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// Top simple navigation + left subnavigation + 1 column / Default Templates Explained / Top simple navigation + left subnavigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Top simple navigation + left subnavigation + 1 column');
$contentobj->SetAlias();
$contentobj->SetMenuText('Top simple navigation + left subnavigation + 1 column');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$topsimple_leftsubnav_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Top simple navigation + left subnavigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetAlias('top_left');
$contentobj->SetParentId($content_list['Default Templates Explained']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>With the Menu Manager you can easily split the navigation in two parts. On this page the top level in the page hierarchy is displayed horizontally and depending on what page is displayed a localized sub-menu is displayed vertically to the left. In this case the sub-menu to the left displays the sub-levels (children) to <strong>Default Templates Explained</strong>.</p><h3>The {ldelim}menu} tag</h3><p>The <code>{ldelim}menu}</code> tag is inserted twice in the page template. First where the main navigation is, which should only show the top level. It looks like this: <code>{ldelim}menu template=\'Simple Navigation\' number_of_levels=\'1\'}</code>.</p><p>The sub navigation should only contain the second level and down, depending on what is selected on the first level. Also, the third level links should only display when its parent on the second level is clicked, otherwise they are hidden. That is, the second level is collapsed unless the current page has sub pages.</p><p>The tag for the sub navigation looks like this: <code>{ldelim}menu template=\'simple_navigation.tpl\' start_level=\'2\' collapse=\'1\'}</code>.</p><h3>Attached style sheets for the menu</h3><p>As the main navigation and the sub navigation need to be styled differently (one horizontal, the other vertical), two navigation style sheets are attached to this page template. <strong>Navigation Simple - Horizontal</strong> is for styling the horizontal main menu. <strong>Navigation Simple - Vertical</strong> on the other hand, contains the style for the sub navigation to the left.</p><h3>Both using the same Menu Manager template</h3><p>However, as you could see, both parts of the navigation are using the same menu manager template. That is because the output code is the same. It is only through CSS that the two parts get styled differently.</p><h3>Floating the sidebar to the right</h3><p>You can easily float the sidebar with the sub navigation to the right instead. Look in the <strong>Layout Top menu + 2 columns</strong> style sheet for the <code>float:left;</code> property in the <code>div#sidebar</code> element. Change that to <code>float:right;</code> and the sidebar with the menu will instead be on the right side of the content, of course you will also have to adjust the margins for the sidebar and the div#main, basically just swap the left and right margins.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// CSSMenu top + 2 columns / Default Templates Explained / CSSMenu top + 2 columns
$contentobj = new Content;
$contentobj->SetName('CSSMenu top + 2 columns');
$contentobj->SetAlias();
$contentobj->SetMenuText('CSSMenu top + 2 columns');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$css_menutop_2col_theme->get_id());
$contentobj->SetTemplateId($template_list['CSSMenu top + 2 columns']);
$contentobj->SetOwner(1);
$contentobj->SetAlias('cssmenu_horizontal');
$contentobj->SetParentId($content_list['Default Templates Explained']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>This is a drop-down menu that is using only CSS (although some Javascript is required for Internet Explorer 6, note: IE6 will not let you use 2 of these menu types in a template at the same time as the second one will fail to open). It can be either vertical or horizontal.</p><p>The code we have inserted in the template that this page is using is simply <code>{ldelim}menu template=\'cssmenu.tpl\'}</code>.  You style the menu in the stylesheet <strong>Navigation CSSMenu - Horizontal</strong> or <strong>Navigation CSSMenu - Vertical</strong> for the vertical CSSMenu.</p><p>But to be on the safe side, copy this style sheet and attach your new style sheet to the template instead (and make your changes in your new style sheet). Then you can always revert to the default style sheet if something goes wrong.</p>');
$contentobj->SetPropertyValue('Sidebar',
	'<p>Just some test content goes here as an example of a very long sentence that probably should have been divided into several smaller sentences, were it not for this just being a test sentence on one of the default pages of CMS Made Simple, an excellent Content Management System for easily creating web sites, this sentence is added when adding/editing a page in the Sidebar: text area, this comes from the template place holder {ldelim}content block=\'Sidebar\'}.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// CSSMenu left + 1 column / Default Templates Explained / CSSMenu left + 1 column
$contentobj = new Content;
$contentobj->SetName('CSSMenu left + 1 column');
$contentobj->SetAlias();
$contentobj->SetMenuText('CSSMenu left + 1 column');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$css_menuleft_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['CSSMenu left + 1 column']);
$contentobj->SetAlias('cssmenu_vertical');
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Default Templates Explained']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>This is basically the same as the last one, CSSMenu top + 2 column, with the menu on the left instead of across the top there isn\'t a whole lot to say about it.</p><h3>Filler Text</h3><p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Ut ac leo in lorem ultricies sollicitudin. Vivamus molestie elit nec nulla. Suspendisse potenti. Suspendisse at lorem. Donec pulvinar, magna eget molestie pretium, justo sem iaculis urna, eget condimentum nibh augue pellentesque arcu. Integer tristique tempor mauris. Sed justo orci, commodo volutpat, sagittis vitae, varius vitae, massa. Maecenas pede ligula, iaculis sit amet, pharetra eu, adipiscing consectetuer, eros. Duis ullamcorper nisl ac magna. Nunc neque dolor, posuere dapibus, convallis non, tristique sed, nibh. Suspendisse quis leo. Phasellus pretium erat ut purus. Duis facilisis consectetuer sapien. Nulla eget pede ut nisl faucibus consequat. Quisque erat lectus, luctus in, pellentesque ac, adipiscing eu, enim. Donec ultrices laoreet urna.</p><h3>Subheading</h3><p>Vestibulum vitae tellus. Fusce quis ligula. Cras mi. Mauris congue, lacus eget rhoncus venenatis, mi nunc volutpat nisl, ut ornare erat augue quis mauris. Nulla in sem. Donec semper odio ac ante. Cras a libero in risus mattis commodo. Phasellus pellentesque lectus. Donec a mi. Integer euismod neque at arcu. Morbi ligula nulla, dapibus nec, fermentum ut, tristique vel, pede. Morbi at diam. Vestibulum quam. Cras consectetuer wisi id neque. Etiam dictum vulputate ligula. Aliquam erat volutpat. Proin vitae lorem in justo imperdiet nonummy. Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Suspendisse leo. Sed in eros ut lectus lacinia condimentum.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// Minimal template / Default Templates Explained / Minimal template
$contentobj = new Content;
$contentobj->SetName('Minimal template');
$contentobj->SetAlias();
$contentobj->SetMenuText('Minimal template');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$minimal_theme->get_id());
$contentobj->SetTemplateId($template_list['Minimal']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Default Templates Explained']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>This is an example of the very minimal that needs to be in a CMSMS template. No stylesheet is attached to the template, which is why it doesn\'t look very nice...</p><p>However, to make it slightly more appealing, some inline styling was used, for floating the content to the right of the menu.</p><p>The menu in this page template is using the <strong>Minimal Navigation</strong> template for Menu Manager. No accessibility stuff is in there, so it\'s recommended that the <strong>Simple Navigation</strong> menu template is rather used.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// Higher End / Default Templates Explained / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Higher End');
$contentobj->SetAlias();
$contentobj->SetMenuText('Higher End');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Default Templates Explained']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>These are more complex then some of the other templates, especially the menus, they all 3 use the same menu template. Which shows you the power of CSS.</p><p>Be forewarned, if you use IE6 you won\'t see the best effects in any of the shadow menus that you see using a more standards compliant browser. I mean it\'s still nice grant you but... just upgrade your browser if you can.</p><h3>The Differences</h3><p>Starting with NCleanBlue you get a really nice, subtle Tabbed menu, then it goes on to have a real nice drop down effect.</p><p>You get a real nice 2.0 header and footer, great color scheme and the search is way cool, it\'s just a great theme, what can I say, thanks Nuno.</p><p>Then the next 2 submenus have another version of the shadowed drop, the first step will point up for the top sub menu and to the right for the left sub menus.</p><p>These 2 are the same layout as CSSMenu top + 2 columns and CSSMenu left + 1 column,  respectively, except for the menu template and some CSS.</p><p>We hope you enjoy these, for any changes you want to make it\'s always best to copy the original style sheet for safe keeping, you never know when you may need it.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// NCleanBlue / Higher End / NCleanBlue
$contentobj = new Content;
$contentobj->SetName('NCleanBlue');
$contentobj->SetAlias();
$contentobj->SetMenuText('NCleanBlue');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$ncleanblue_theme->get_id());
$contentobj->SetTemplateId($template_list['NCleanBlue']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Higher End']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
      '<p>Nuno has graciously supplied us with another of his great looking designs.</p><p>This one is using a new menu template so we can style the drop down for the children pages, using an image for the second ul going from the top down, it has an extra li at the bottom of the child pages ul &lt;li class="separator once" style="list-style-type: none;"&gt;&amp;nbsp; &lt;/li&gt; this is used to hold the bottom image.</p><h3>Filler Text</h3><p>Maecenas tristique, tortor nec eleifend luctus, nibh leo imperdiet wisi, et accumsan est lectus in orci. Proin facilisis, odio auctor feugiat accumsan, sapien purus iaculis dui, a volutpat augue pede ut sem. Nulla facilisi. Aliquam suscipit elementum ipsum. Morbi urna. Nam eros justo, varius sit amet, euismod eu, dictum nec, neque. Nullam id mi eu odio tempor adipiscing. Quisque hendrerit euismod nunc. Ut erat nulla, pellentesque nec, luctus eu, dictum nec, augue. Aliquam tincidunt sodales arcu. Nam porta sagittis quam. Vivamus eget purus egestas velit congue consectetuer.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// ShadowMenu Tab + 2 columns / Higher End / ShadowMenu Tab + 2 columns
$contentobj = new Content;
$contentobj->SetName('ShadowMenu Tab + 2 columns');
$contentobj->SetAlias();
$contentobj->SetMenuText('ShadowMenu Tab + 2 columns');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$shadowmenu_tab_2col_theme->get_id());
$contentobj->SetTemplateId($template_list['ShadowMenu Tab + 2 columns']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Higher End']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>Using the same menu template as the previous theme. We changed the child ul CSS to use a different top image. This involves changing some of the margin and padding as the images are a different shape. Note the difference in the second level and third level ul images, one has an arrow up and the other has an arrow left.</p><h3>Filler Text</h3><p>Curabitur ornare velit molestie nulla. Fusce fermentum facilisis mi. Maecenas volutpat, eros ac pellentesque mollis, urna elit rutrum turpis, congue convallis nibh erat nec purus. Sed malesuada consectetuer turpis. Nulla sollicitudin placerat augue. Vestibulum ut sem eget turpis laoreet cursus. Vestibulum ante urna, mollis eget, cursus eget, viverra non, lectus. Aliquam erat volutpat. Aenean gravida tempor nulla. Sed sem lorem, pulvinar non, placerat non, vestibulum sed, tellus. Phasellus fermentum velit id dui. Praesent vulputate. Nam in dui.</p><p>Maecenas tristique, tortor nec eleifend luctus, nibh leo imperdiet wisi, et accumsan est lectus in orci. Proin facilisis, odio auctor feugiat accumsan, sapien purus iaculis dui, a volutpat augue pede ut sem. Nulla facilisi. Aliquam suscipit elementum ipsum. Morbi urna. Nam eros justo, varius sit amet, euismod eu, dictum nec, neque. Nullam id mi eu odio tempor adipiscing. Quisque hendrerit euismod nunc. Ut erat nulla, pellentesque nec, luctus eu, dictum nec, augue. Aliquam tincidunt sodales arcu. Nam porta sagittis quam. Vivamus eget purus egestas velit congue consectetuer.</p>');
$contentobj->SetPropertyValue('Sidebar',
	'<h4>Filler Text</h4><p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Cras sodales gravida est. Nullam enim ipsum, convallis quis, iaculis quis, facilisis eu, felis. Proin euismod hendrerit tortor. Aliquam erat volutpat. Morbi tempus diam sit amet neque. Sed sem metus, sagittis vel, lobortis ac, tempus sit amet, wisi. Phasellus in diam. Maecenas ultrices rutrum mauris. Vestibulum dolor justo, blandit a, posuere quis, varius at, tellus. Vestibulum convallis. Nulla ut leo sed elit eleifend varius. Aenean eget est id lorem posuere laoreet.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// ShadowMenu left + 1 column / Higher End / ShadowMenu left + 1 column
$contentobj = new Content;
$contentobj->SetName('ShadowMenu Left + 1 column');
$contentobj->SetAlias();
$contentobj->SetMenuText('ShadowMenu Left + 1 column');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$shadowmenu_left_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['ShadowMenu left + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Higher End']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
      '<p>Again using the same menu template as the two previous themes. We changed the child ul CSS to use a different top image. This involves changing some of the margin and padding as the images are a different shape. Note the second level and third level ul are now using the same image that has an arrow left.</p><h3>Filler Text</h3><p>Curabitur ornare velit molestie nulla. Fusce fermentum facilisis mi. Maecenas volutpat, eros ac pellentesque mollis, urna elit rutrum turpis, congue convallis nibh erat nec purus. Sed malesuada consectetuer turpis. Nulla sollicitudin placerat augue. Vestibulum ut sem eget turpis laoreet cursus. Vestibulum ante urna, mollis eget, cursus eget, viverra non, lectus. Aliquam erat volutpat. Aenean gravida tempor nulla. Sed sem lorem, pulvinar non, placerat non, vestibulum sed, tellus. Phasellus fermentum velit id dui. Praesent vulputate. Nam in dui.</p><p>Maecenas tristique, tortor nec eleifend luctus, nibh leo imperdiet wisi, et accumsan est lectus in orci. Proin facilisis, odio auctor feugiat accumsan, sapien purus iaculis dui, a volutpat augue pede ut sem. Nulla facilisi. Aliquam suscipit elementum ipsum. Morbi urna. Nam eros justo, varius sit amet, euismod eu, dictum nec, neque. Nullam id mi eu odio tempor adipiscing. Quisque hendrerit euismod nunc. Ut erat nulla, pellentesque nec, luctus eu, dictum nec, augue. Aliquam tincidunt sodales arcu. Nam porta sagittis quam. Vivamus eget purus egestas velit congue consectetuer.</p>');


// Welcome to Simplex / Default Templates Explained / Higher End / Simplex
$contentobj = new Content;
$contentobj->SetName('Welcome to Simplex');
$contentobj->SetAlias();
$contentobj->SetMenuText('Simplex Theme');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$simplex_theme->get_id());
$contentobj->SetTemplateId($template_list['Simplex']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Higher End']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
     '<p>Simplex Theme has been created to demonstrate HTML5 and CSS3 functionality within CMS Made Simple&trade;.<br />It is shipped with a CSS Framework making it possible for you to create Responsive and Mobile capabale layouts with ease.</p><h2>What is included?</h2><p>With this Template you will find four Stylesheets attached to it.</p><ul><li>Simplex Core</li><li>Simplex Layout</li><li>Simplex Mobile</li><li>Simplex Print</li></ul><p>Main Functionality of this Template is included in Core Stylesheet. It contains a simple Fluid Grid Framework based on <a class="external" href="http://960.gs/" title="960 Grid System" target="_blank">960 Grid System</a>.<br />In this same Stylesheet CSS <a class="external" href="http://www.w3.org/TR/css3-mediaqueries/" title="W3C Media Queries" target="_blank">Media Queries</a> are being used that make it possible for a flexible layout based on Screen width.<br /><br />With Simplex Theme it is very easy to quickly change appearance of complete Site at once. If you look at Page Template code you will find "boxed" id in the <code>&lt;body&gt;</code> tag.<br />When this id is removed the Layout of the Site is changed and you would face a simple layout with White background.<br />You can also quickly change allignement of the complete Site. If you change the class of "wrapper" div to leftaligned or rightaligned, whole Page will be aligned to left or right.</p><h2>Support for Mobile Devices</h2><p>As mentioned above this Theme is shipped with Stylesheet Framework that gives you a starting point for easy developement of Responsive Layout.<br />Mobile world is very versatile and Framework itself is by no means perfect, it is only a starting point but as a Developer you should decide which technique you should use for your current Project.<br />Responsive Template is only one small step towards Mobile support.</p><p>This Theme requires <a class="external" href="http://jquery.org/" title="jQuery" target="_blank">jQuery</a> which is included with <code>{ldelim}cms_jquery{rdelim}</code> tag.</p><p><cite>Note: {ldelim}cms_jquery{rdelim} tag is included at the bottom of the Template. You should be carefull with it when you are using Modules that include jQuery in &lt;head&gt; section.</cite></p><p>In file functions.js a section is included that makes it possible of Navigating through site with some Mobile Devices. This part of the code, covers only few devices and it is only meant as an example and a starting point for Developer.</p><h2>This and that</h2><p>As an example of <a class="external" href="http://www.smarty.net/" title="Smarty" target="_blank">Smarty</a> power within CMS Made Simple&trade; Templates a very simple Slider has been included, which demonstartes how easy it is to quickly create a Slideshow without a single Module.</p><pre><code>{ldelim}assign var=\'teaser\' value=\'uploads/simplex/teaser/*.jpg\'|glob{rdelim}<br />{ldelim}foreach from=$teaser item=\'one\'{rdelim}<br /> &lt;div&gt;&lt;img src=\'{ldelim}root_url{rdelim}/{ldelim}$one{rdelim}\' width=\'852\' height=\'275\' alt=\'\' /&gt;&lt;/div&gt;<br />{ldelim}/foreach{rdelim}<br /> {/strip}</code></pre><p><cite>If you would like to make this Slider responsive you should include a additional jQuery Plugin like for example <a class="external" href="http://swipejs.com" target="_blank" title="SwipeJS">SwipeJS</a></cite></p><p>In included Stylesheets, Smarty has been used as well. This should make it possible for you, to quickly change Color scheme of the theme by simply changing HEX code within assign Tags.</p><pre><code>[[assign var=\'boxed_bg\' value="#d1d1d1 url(`$path`/boxed-bg.gif)"]][[assign var=\'light_grey\' value=\'#f1f1f1\']]<br />[[assign var=\'grey\' value=\'#e9e9e9\']]<br />[[assign var=\'dark_grey\' value=\'#555\']]<br />[[assign var=\'white\' value=\'#fff\']]<br />[[assign var=\'orange\' value=\'#f39c2c\']]<br />[[assign var=\'dark_orange\' value=\'#e6870e\']]<br />[[assign var=\'yellow\' value=\'#fdbd34\']]</code></pre><p>If you are using a modern Browser, you will notice that the Theme is using some of <a class="external" href="http://www.w3.org/TR/CSS/#css3" title="CSS3" target="_blank">CSS3</a> techniques. There are no Internet Explorer fallbacks included but this doesn\'t mean that it does not work in Internet Explorer.<br />A Visitor that is using Internet Explorer will simply see a Layout with gracefull fallback, meaning animations will not animate, rounded corners will be edges...</p><p><em>Note from Theme Develper Goran Ilic (uniqu3e):</em></p><blockquote><cite>The Simplex Theme was kept simplistic which should make it possible for a Developer to easily read code used in Theme and either create a new Layout from it or editing this Theme.<br /><br />A full Internet Explorer or Mobile support was intentionally not included, as each Developer should decide how far a old Browser like Internet Explorer (7,8) or which Mobile devices he wants to support and which Technique he will use.<br />Each Project is different and with each Project there is a need for different techniques.</cite></blockquote>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

//////////////////////////////////
//  //  DEFAULT EXTENSIONS  //  //
//////////////////////////////////

// Default Extensions / -1 / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Default Extensions');
$contentobj->SetAlias();
$contentobj->SetMenuText('Default Extensions');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId(-1);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>With the default installation of CMS Made Simple come six modules and a number of tags. The features of these are described and displayed on the following pages.</p><p>To find out more about the core modules, click {cms_selflink page=\'modules\' text=\'Modules\'}. For an explanation the core tags, simply click {cms_selflink page=\'tags\' text=\'Tags\'}.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// Modules / 24 / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Modules');
$contentobj->SetAlias();
$contentobj->SetMenuText('Modules');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Default Extensions']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>There are six modules that come with the default installation of CMS Made Simple. On the following pages we explain how these are used. Click on each module name in the menu to the left or in the list below.</p><p>To insert a module in a template or a page you normally use the <code>{ldelim}cms_module}</code> tag with the module name as one of the parameters. But to simplify things, all core modules also have a tag wrapper, so that they are called simple by their name, like <code>{ldelim}news}</code>.</p><ul><li>{cms_selflink page=\'news\' text=\'News\'}</li><li>{cms_selflink page=\'menu-manager-2\' text=\'Menu Manager\'}</li><li>{cms_selflink page=\'theme-manager\' text=\'Theme Manager\'}</li><li>{cms_selflink page=\'microtiny\' text=\'MicroTiny\'}</li><li>{cms_selflink page=\'search\' text=\'Search\'}</li><li>{cms_selflink page=\'module-manager\' text=\'Module Manager\'}</li></ul>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// News / Modules / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('News');
$contentobj->SetAlias();
$contentobj->SetMenuText('News');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Modules']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>Most web sites have a section for the latest news. In CMS Made Simple the best way to accomplish that is by using the News module.</p><p>To display a list of news items you insert the tag <code>{ldelim}news number=\'5\' category=\'General\'}</code>. On this page the tag is inserted in the template. But it can also be inserted on a page. You can see the News module in use in the sidebar to the left.</p><p>There are a number of parameters that can be used in conjunction with this tag. To read about how a module is used, navigate to Extensions &raquo; Modules in the Admin Panel and click on "Help" for the module you want to read about.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// Menu Manager / Modules / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Menu Manager');
$contentobj->SetAlias();
$contentobj->SetMenuText('Menu Manager');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Modules']);
$contentobj->SetAlias('menu-manager-2');
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>The Menu Manager has already been explained on the How CMSMS Works » {cms_selflink page=\'menu-manager\' text=\'Menu Manager\'} page. It is a very powerful module that can be used for any kind of navigation system on your web site.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// Theme Manager / Modules / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Theme Manager');
$contentobj->SetAlias();
$contentobj->SetMenuText('Theme Manager');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Modules']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>The Theme Manager module allows you to import and export templates and their attached stylesheets, including any images they use, as "themes". This allows you to share your look and feel with other CMSMS users.</p><p>It is very easy to convert any kind of template to be used with CMS Made Simple. Many templates like this have already been converted and can be installed using the Theme Manager, the CMSMS community also shares themes for anyone to download and use at the <a class="external" target="_blank" href="http://themes.cmsmadesimple.org">CMSMS Themes site</a>.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// MicroTiny / Modules / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('MicroTiny');
$contentobj->SetAlias();
$contentobj->SetMenuText('MicroTiny');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Modules']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>MicroTiny is a so called WYSIWYG editor for editing pages. WYSIWYG stands for What You See Is What You Get. It works similar to a word processor, where you can select the style for the content and see how it is going to look on the page.</p><p>Among available WYSIWYG editors CMS Made Simple has decided to use MicroTiny (the stripped down version of TinyMCE). TinyMCE is among the most developed WYSIWYG editors, with regular updates, a large following and customizable features.</p><p>However, it is very difficult to create a cross-browser online editor that works in all different kinds of environments. If you are familiar with HTML you can select no WYSIWYG in My Preferences &raquo; User Preferences in the Admin Panel. That gives you more control over the code that will be on the page.</p><p>There are also other WYSIWYG editor modules available for download.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();


// Search / Modules / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Search');
$contentobj->SetAlias();
$contentobj->SetMenuText('Search');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Modules']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>Search is a module for searching "core" content along with certain registered modules. You put in a word or two and it gives you back matching, relevant results.</p><p>You can see the search module in use in the default templates, like on this page. Simply put <code>{ldelim}search}</code> in your template, where you want the search form to appear. If you want the results of a search to appear on a different page, you can specify this with the parameter <code>resultpage=\'page alias\'</code>.</p><p>For more information, see the Search module in the Admin Panel, in the Extensions menu.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();


// Module Manager / Modules / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Module Manager');
$contentobj->SetAlias();
$contentobj->SetMenuText('Module Manager');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Modules']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>A client for the ModuleRepository, this module allows you to see what modules are available, the version number, size, and Status/Action (whether it is already installed or not), read the Help and About for each module, letting you install modules from remote sites without the need for FTP\'ing, or unzipping archives. Module XML files are downloaded using SOAP, integrity verified, and then expanded automatically.</p><p>ModuleManager now checks dependencies. When dependencies are set, the module wont install until dependencies are met. Also a new tab is available, that shows newer versions of installed modules.</p><p>In short, this means that you can download and install modules directly from the Admin Panel. Any module that has been released as an XML file can be downloaded and installed. Go to Extensions &raquo; Module Manager in the Admin Panel to see the list of modules from the official CMSMS repository in the CMSMS Development Forge.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();


// Tags / Default Extensions / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Tags');
$contentobj->SetAlias();
$contentobj->SetMenuText('Tags');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Default Extensions']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>There are a number of custom tags included with the default CMS Made Simple installation. They are all described and demonstrated in the following page, and user defined tags are in the next one.</p><p>To use a tag, simply put it in the template or page like this: {ldelim}nameoftag}. Some tags can also take parameters, which are described in the Help that is accessible for each tag in Extensions &raquo; Tags in the Admin Panel.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// Tags in the core / Tags / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('Tags in the core');
$contentobj->SetAlias('cms_tags');
$contentobj->SetMenuText('Tags in the core');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Tags']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>There are plenty of tags included with the CMSMS core. Some of them are demonstrated here, for any questions as to the parameters they can take or anything else please see the Tags Help.</p><h3>{ldelim}anchor}</h3><dl> <dt>Syntax used</dt> <dd><code>{ldelim}anchor anchor=\'here\' text=\'Scroll Down\' class=\'myclass\' title=\'mytitle\' tabindex=\'1\' accesskey=\'s\'}</code></dd> <dt>Display</dt> <dd>Creates a link to an anchor on the same page. Used for example for the ^Top link at the bottom of this page.</dd> </dl><h3>{ldelim}cms_breadcrumbs{rdelim}</h3><dl> <dt>Syntax used</dt> <dd><code>{ldelim}cms_breadcrumbs root=\'Home\'{rdelim}</code></dd> <dt>Display</dt> <dd>Breadcrumbs are a navigational technique displaying all visited pages leading from the home page to the currently viewed page. You find it under the header on this page.</dd></dl><h3>{ldelim}cms_module}</h3><dl> <dt>Syntax used</dt> <dd><code>{ldelim}cms_module module=\'somemodulename\' param1=\'something\' param2=true}</code></dd> <dt>Display</dt> <dd>This tag is used to insert modules into your templates and pages.  Used for any module that you download. In the default templates, wrapper tags are used for inserting modules though. That is, a tag is made to insert a cms_module tag.</dd> </dl><h3>{ldelim}cms_selflink}</h3><dl> <dt>Syntax used</dt> <dd><code>{ldelim}cms_selflink page="1"}</code> or <code>{ldelim}cms_selflink page="alias"}</code></dd> <dt>Display</dt> <dd>Creates a link to another CMSMS content page inside your template or content. Can also be used for external links with the ext parameter. </dd> <dt>Example</dt> <dd>{cms_selflink page=\'modules\' text=\'Link to the modules page\'} </dd> <dd><a class="external" href="http://www.cmsmadesimple.org">This is an external link to the CMS Made Simple website</a></dd> </dl><h3>{ldelim}cms_version}</h3><dl> <dt>Syntax used</dt> <dd><code>{ldelim}cms_version}</code></dd> <dt>Display</dt> <dd>Displays current version number of CMS Made Simple. </dd> <dt>Example</dt> <dd>See the footer on this page.</dd> </dl><h3>{ldelim}cms_versionname}</h3><dl> <dt>Syntax used</dt> <dd><code>{ldelim}cms_versionname}</code></dd> <dt>Display</dt> <dd>Displays current version name of CMS Made Simple. </dd> <dt>Example</dt> <dd>See the footer on this page.</dd> </dl><h3>{ldelim}current_date}</h3><dl> <dt>Syntax used</dt> <dd><code>{ldelim}current_date format="%A %d-%b-%y %T %Z"}</code></dd> <dt>Display</dt> <dd>Prints the current date and time.</dd> <dt>Example</dt> <dd>{current_date format="%A %d-%b-%y %T %Z"}</dd> </dl><h3>{ldelim}embed}</h3><dl> <dt>Syntax used</dt> <dd><code>{ldelim}embed url="http://www.cmsmadesimple.org"}</code></dd> <dt>Display</dt> <dd>Enable inclusion (embeding) of any other application into the CMS. The most usual use could be a forum. </dd> </dl><h3>{ldelim}global_content}</h3><dl> <dt>Syntax used</dt> <dd><code>{ldelim}global_content name=\'footer\'}</code></dd> <dt>Display</dt> <dd>Inserts a Global Content Block (previously known as HTML blob) into your template or page. The code for the footer of this page is in a Global Content Block. </dd> </dl><h3>{ldelim}menu_text}</h3><dl> <dt>Syntax used</dt> <dd><code>{ldelim}menu_text}</code></dd> <dt>Display</dt> <dd>Prints the menu text of the page.</dd> <dt>Example</dt> <dd>{menu_text}</dd> </dl><h3>{ldelim}modified_date}</h3><dl> <dt>Syntax used</dt> <dd><code>{ldelim}modified_date format="%A %d-%b-%y %T %Z"}</code></dd> <dt>Display</dt> <dd>Prints the date and time the page was last modified. </dd> <dt>Example</dt> <dd>{modified_date format="%A %d-%b-%y %T %Z"}</dd> </dl><h3>{ldelim}print}</h3><dl> <dt>Syntax used</dt> <dd><code>{ldelim}CMSPrinting}</code></dd> <dt>Display</dt> <dd>Creates a link to only the content of the page.</dd> <dt>Example</dt> <dd>{ldelim}CMSPrinting}</dd> </dl><h3>{ldelim}site_mapper}</h3><dl> <dt>Syntax used</dt> <dd><code>{ldelim}site_mapper}</code></dd> <dt>Display</dt> <dd>Prints out a sitemap.</dd> <dt>Example</dt> <dd>{site_mapper}</dd> </dl>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

// User Defined Tags / Tags / Left simple navigation + 1 column
$contentobj = new Content;
$contentobj->SetName('User Defined Tags');
$contentobj->SetAlias();
$contentobj->SetMenuText('User Defined Tags');
$contentobj->SetPropertyValue('searchable',1);
$contentobj->SetPropertyValue('design_id',$leftsimple_1col_theme->get_id());
$contentobj->SetTemplateId($template_list['Left simple navigation + 1 column']);
$contentobj->SetOwner(1);
$contentobj->SetParentId($content_list['Tags']);
$contentobj->SetActive(TRUE);
$contentobj->SetShowInMenu(TRUE);
$contentobj->SetCachable(TRUE);
$contentobj->SetPropertyValue('content_en',
	'<p>One of the little known features of CMS Made Simple is the User Defined tag.  Basically, this allows you to write PHP code inside the Admin Panel.  Use the \'Add User Defined Tag\' button in Extension &raquo; User Defined Tags in the Admin Panel, write some code, and then insert into a template or page with {literal}{newpluginname}{/literal}.  Simple!</p><p>As an example, I\'ve put together a one line plugin/tag that will show your current User Agent information (which browser you\'re using).  The output is right here: <strong>{user_agent}</strong>.</p><p>If you\'re not looking at the source, all that is in the page is {literal}{user_agent}{/literal}.  To see how this code works, edit the user_agent tag in the Extensions &raquo; User Defined Tags page of the admin.</p><p>This is a VERY powerful feature if used right.  Remember, user defined tags do not get cached, therefore, scripts to rotate ad banners and such will work just fine. Note also that tag code has to be written <em>without</em> opening &lt; ? php  and ending  ? &gt; tags.</p>');
$contentobj->Save();
$content_list[$contentobj->Name()] = $contentobj->Id();

?>
<?php
global $admin_user;

//
// Stylesheets
//
# no stylesheets for a no sample content option

//
// Designs
//
$design = new CmsLayoutCollection();
$design->set_name('Default');
$design->set_description('Default design with just the default template.');
$design->set_default(TRUE);
$design->save();
$design->save();

//
// Types
//
$page_template_type = new CmsLayoutTemplateType();
$page_template_type->set_originator(CmsLayoutTemplateType::CORE);
$page_template_type->set_name('page');
$page_template_type->set_dflt_flag(TRUE);
$page_template_type->set_lang_callback('CmsTemplateResource::page_type_lang_callback');
$page_template_type->set_content_callback('CmsTemplateResource::reset_page_type_defaults');
$page_template_type->set_help_callback('CmsTemplateResource::template_help_callback');
$page_template_type->reset_content_to_factory();
$page_template_type->set_content_block_flag(TRUE);
$page_template_type->save();

$gcb_template_type = new CmsLayoutTemplateType();
$gcb_template_type->set_originator(CmsLayoutTemplateType::CORE);
$gcb_template_type->set_name('generic');
$gcb_template_type->set_lang_callback('CmsTemplateResource::generic_type_lang_callback');
$gcb_template_type->set_help_callback('CmsTemplateResource::template_help_callback');
$gcb_template_type->save();

//
// Template Categories
//

//
// Templates
//
$app = \__appbase\get_app();

$fn = $app->get_destdir()
    . DIRECTORY_SEPARATOR . 'admin'
    . DIRECTORY_SEPARATOR . 'templates'
    . DIRECTORY_SEPARATOR . 'orig_page_template.tpl';

$txt = file_get_contents($fn);
$template = new CmsLayoutTemplate();
$template->set_name('Default');
$template->set_description('This is the default minimal template. A simple starting point to build templates from.');
$template->set_type($page_template_type);
$template->set_content($txt);
$template->set_type($page_template_type);
$template->set_type_dflt(TRUE);
$template->add_design($design);
$template->set_owner(1);
$template->save();

//
// Extra global templates
//

#

//
// Default Content Object
//
ContentOperations::get_instance()->LoadContentType('content');
$content = new Content;
$content->SetName('Home');
$content->SetAlias();
$content->SetOwner(1);
$content->SetMenuText('Home Page');
$content->SetTemplateId($template->get_id());
$content->SetParentId(-1);
$content->SetActive(TRUE);
$content->SetShowInMenu(TRUE);
$content->SetCachable(TRUE);
$content->SetDefaultContent(TRUE);
$content->SetPropertyValue('searchable',1);
$content->SetPropertyValue('design_id',$design->get_id());
$content->SetPropertyValue('content_en',
			   '<p>Congratulations! The installation worked. You now have a fully functional installation of CMS Made Simple and you are <em>almost</em> ready to start building your site.</p><p>If you chose to install the default content, you will see numerous pages available to read.  You should read them thoroughly  as these default pages are devoted to showing you the basics of how to begin working with CMS Made Simple.  On these example pages, templates, and stylesheets many of the features of the default installation of CMS Made Simple are described and demonstrated. You can learn much about the power of CMS Made Simple by absorbing this information.</p><p>To get to the Administration Console you have to login as the administrator (with the username/password you specified during the installation process) on your site at http://yourwebsite.com/cmsmspath/admin.  If this is your site click <a title="CMSMS Demo Admin Panel" href="admin">here</a> to login.</p><p>Read about how to use CMS Made Simple in the <a class="external" href="http://docs.cmsmadesimple.org/" title="CMS Made Simple Documentation" target="_blank">documentation</a>. In case you need any help the community is always at your service, in the  <a class="external" href="http://forum.cmsmadesimple.org" title="CMS Made Simple Forum" target="_blank">forum</a> or the <a class="external" href="http://www.cmsmadesimple.org/support/irc" title="Information about the CMS Made Simple IRC channel" target="_blank">IRC</a>.</p><h3>License</h3><p>CMS Made Simple is released under the <a class="external" href="http://www.gnu.org/licenses/licenses.html#GPL" title="General Public License" target="_blank">GPL</a> license and as such you don\'t have to leave a link back to us in these templates or on your site as much as we would like it.</p><p>Some third party addon modules may include additional license restrictions.</p>');
$content->Save();
?>
<?php

if (isset($CMS_INSTALL_DROP_TABLES)) {

 status_msg(ilang('install_dropping_tables'));
 $db->DropSequence(CMS_DB_PREFIX."additional_users_seq");
 $db->DropSequence(CMS_DB_PREFIX."admin_bookmarks_seq");
 $db->DropSequence(CMS_DB_PREFIX."additional_users_seq");
 $db->DropSequence(CMS_DB_PREFIX."content_seq");
 $db->DropSequence(CMS_DB_PREFIX."content_props_seq");
 $db->DropSequence(CMS_DB_PREFIX."events_seq");
 $db->DropSequence(CMS_DB_PREFIX."event_handler_seq");
 $db->DropSequence(CMS_DB_PREFIX."group_perms_seq");
 $db->DropSequence(CMS_DB_PREFIX."groups_seq");
 $db->DropSequence(CMS_DB_PREFIX."module_deps_seq");
 $db->DropSequence(CMS_DB_PREFIX."module_templates_seq");
 $db->DropSequence(CMS_DB_PREFIX."permissions_seq");
 $db->DropSequence(CMS_DB_PREFIX."users_seq");
 $db->DropSequence(CMS_DB_PREFIX."userplugins_seq");

 $dbdict = NewDataDictionary($db);

 $sqlarray = $dbdict->DropIndexSQL("idx_template_id_modified_date");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropIndexSQL(CMS_DB_PREFIX."idx_template_id_modified_date");
 $dbdict->ExecuteSQLArray($sqlarray);

 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."additional_users");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."adminlog");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."admin_bookmarks");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."content");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."content_props");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."events");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."event_handlers");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."group_perms");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL("`".CMS_DB_PREFIX."groups`");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."modules");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."module_deps");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."module_templates");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."permissions");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."siteprefs");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."user_groups");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."userprefs");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."users");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."userplugins");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."version");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."module_smarty_plugins");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX."routes");
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX.CmsLayoutTemplateType::TABLENAME);
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX.CmsLayoutTemplateCategory::TABLENAME);
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX.CmsLayoutTemplate::TABLENAME);
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX.CmsLayoutTemplate::ADDUSERSTABLE);
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX.CmsLayoutStylesheet::TABLENAME);
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX.CmsLayoutCollection::TABLENAME);
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX.CmsLayoutCollection::TPLTABLE);
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX.CmsLayoutCollection::CSSTABLE);
 $dbdict->ExecuteSQLArray($sqlarray);
 $sqlarray = $dbdict->DropTableSQL(CMS_DB_PREFIX.CmsLock::LOCK_TABLE);
 $dbdict->ExecuteSQLArray($sqlarray);
}

if (isset($CMS_INSTALL_CREATE_TABLES)) {

 status_msg(ilang('install_createtablesindexes'));
 if ($db->dbtype == 'mysql' || $db->dbtype == 'mysqli') {
	@$db->Execute("ALTER DATABASE `" . $db->database . "` DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci");
 }

 $dbdict = NewDataDictionary($db);
 $taboptarray = array('mysql' => 'ENGINE MyISAM CHARACTER SET utf8 COLLATE utf8_general_ci', 'mysqli' => 'ENGINE MyISAM CHARACTER SET utf8 COLLATE utf8_general_ci');

	$flds = "
		additional_users_id I KEY,
		user_id I,
		page_id I,
		content_id I
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."additional_users", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'additional_users', $ado_ret));



	$flds = "
		bookmark_id I KEY,
		user_id I,
		title C(255),
		url C(255)
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."admin_bookmarks", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'admin_bookmarks', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'index_admin_bookmarks_by_user_id', CMS_DB_PREFIX."admin_bookmarks", 'user_id');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'admin_bookmarks', $ado_ret));


	$flds = "
		timestamp I,
		user_id I,
		username C(25),
		item_id I,
		item_name C(50),
		action C(255),
		ip_addr C(40)
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."adminlog", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	if( $return == 2 )
	 {
		$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'index_adminlog1',CMS_DB_PREFIX."adminlog",'timestamp');
		$return = $dbdict->ExecuteSQLArray($sqlarray);
	 }
	verbose_msg(ilang('install_created_table', 'adminlog', $ado_ret));

	$flds = "
		content_id I KEY,
		content_name C(255),
		type C(25),
		owner_id I,
		parent_id I,
		template_id I,
		item_order I,
		hierarchy C(255),
		default_content I1,
		menu_text C(255),
		content_alias C(255),
		show_in_menu I1,
		active I1,
		cachable I1,
		id_hierarchy C(255),
		hierarchy_path X,
		prop_names X,
		metadata X,
		titleattribute C(255),
		tabindex C(10),
		accesskey C(5),
		last_modified_by I,
		create_date DT,
		modified_date DT,
		secure I1,
		page_url C(255)
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."content", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'content', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_content_by_alias_active', CMS_DB_PREFIX."content", 'content_alias, active');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'idx_content_by_alias_active', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_content_default_content', CMS_DB_PREFIX."content", 'default_content');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'idx_content_default_content', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_content_by_parent_id', CMS_DB_PREFIX."content", 'parent_id');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'idx_content_by_parent_id', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_content_by_hier', CMS_DB_PREFIX."content", 'hierarchy');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'idx_content_by_hier', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'index_content_by_idhier', CMS_DB_PREFIX."content", 'content_id, hierarchy');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'idx_content_by_idhier', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_content_by_modified', CMS_DB_PREFIX."content", 'modified_date');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'idx_content_by_modified', $ado_ret));

	$flds = "
		content_id I,
		type C(25),
		prop_name C(255),
		param1 C(255),
		param2 C(255),
		param3 C(255),
		content X2,
		create_date DT,
		modified_date DT
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."content_props", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'content_props', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_content_props_by_content', CMS_DB_PREFIX."content_props", 'content_id');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'idx_content_props_by_content', $ado_ret));

	$flds = "
		event_id I,
		tag_name C(255),
		module_name C(160),
		removable I,
		handler_order I,
		handler_id I KEY
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."event_handlers", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'event_handlers', $ado_ret));



	$flds = "
		originator C(200) NOTNULL,
		event_name C(200) NOTNULL,
		event_id I KEY
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."events", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'events', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'originator', CMS_DB_PREFIX."events", 'originator');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'originator', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'event_name', CMS_DB_PREFIX."events", 'event_name');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'event_name', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'event_id', CMS_DB_PREFIX."events", 'event_id');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'event_id', $ado_ret));

	$flds = "
		group_perm_id I KEY,
		group_id I,
		permission_id I,
		create_date DT,
		modified_date DT
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."group_perms", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'group_perms', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_grp_perms_by_grp_id_perm_id', CMS_DB_PREFIX."group_perms", 'group_id, permission_id');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'idx_grp_perms_by_grp_id_perm_id', $ado_ret));

	$flds = "
		group_id I KEY,
		group_name C(25),
		group_desc C(255),
		active I1,
		create_date DT,
		modified_date DT
	";
	$sqlarray = $dbdict->CreateTableSQL("`".CMS_DB_PREFIX."groups`", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'groups', $ado_ret));



	$flds = "
		module_name C(160) KEY,
		status C(255),
		version C(255),
		admin_only I1 DEFAULT 0,
		active I1,
		allow_fe_lazyload I1,
		allow_admin_lazyload I1
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."modules", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'modules', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_modules_by_name', CMS_DB_PREFIX."modules", 'module_name');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'idx_modules_by_name', $ado_ret));



	$flds = "
		parent_module C(25),
		child_module C(25),
		minimum_version C(25),
		create_date DT,
		modified_date DT
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."module_deps", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'module_deps', $ado_ret));


	// deprecated
	$flds = "
		module_name C(160),
		template_name C(160),
		content X,
		create_date DT,
		modified_date DT
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."module_templates", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'module_templates', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_module_templates_by_module_and_tpl_name', CMS_DB_PREFIX."module_templates", 'module_name, template_name');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'idx_module_templates_by_module_and_tpl_name', $ado_ret));


	$flds = "
		permission_id I KEY,
		permission_name C(255),
		permission_text C(255),
		permission_source C(255),
		create_date DT,
		modified_date DT
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."permissions", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'permissions', $ado_ret));


	$flds = "
		sitepref_name C(255) KEY,
		sitepref_value text,
		create_date DT,
		modified_date DT
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."siteprefs", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'siteprefs', $ado_ret));



	$flds = "
		group_id I KEY,
		user_id I KEY,
		create_date DT,
		modified_date DT
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."user_groups", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'user_groups', $ado_ret));


	$flds = "
		user_id I KEY,
		preference C(50) KEY,
		value X,
		type C(25)
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."userprefs", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'userprefs', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_userprefs_by_user_id', CMS_DB_PREFIX."userprefs", 'user_id');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'idx_userprefs_by_user_id', $ado_ret));



	$flds = "
		user_id I KEY,
		username C(25),
		password C(40),
		admin_access I1,
		first_name C(50),
		last_name C(50),
		email C(255),
		active I1,
		create_date DT,
		modified_date DT
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."users", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'users', $ado_ret));



	$flds = "
		userplugin_id I KEY,
		userplugin_name C(255),
		code X,
		description X,
		create_date DT,
		modified_date DT
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."userplugins", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'userplugins', $ado_ret));



	$flds = "
		version I
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."version", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'version', $ado_ret));



	$flds = "
		sig C(80) KEY NOTNULL,
		name C(80) NOTNULL,
		module C(160) NOTNULL,
		type C(40) NOTNULL,
		callback C(255) NOTNULL,
		available I,
		cachable I1
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."module_smarty_plugins", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'module_smarty_plugins', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_smp_module', CMS_DB_PREFIX."module_smarty_plugins", 'module');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'idx_smp_module', $ado_ret));


	$flds = "
		term C(255) KEY NOTNULL,
		key1 C(50) KEY NOTNULL,
		key2 C(50),
		key3 C(50),
		data X,
		created ".CMS_ADODB_DT;
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX."routes", $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', 'routes', $ado_ret));

	$flds = "
		id I KEY AUTO,
		originator C(50) NOTNULL,
		name C(100) NOTNULL,
		has_dflt I1,
		dflt_contents X2,
		description X,
		lang_cb C(255),
		dflt_content_cb C(255),
		requires_contentblocks I1,
		help_content_cb C(255),
		one_only I1,
		owner  I,
		created I,
		modified I";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX.CmsLayoutTemplateType::TABLENAME, $flds,
					 $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', CmsLayoutTemplateType::TABLENAME, $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_layout_tpl_type_1', CMS_DB_PREFIX.CmsLayoutTemplateType::TABLENAME,
										'originator,name',array('UNIQUE'));
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'idx_layout_tpl_type_1', $ado_ret));


	$flds = "
		id I KEY AUTO,
		name C(100) NOTNULL,
		description X,
		item_order X,
		modified I";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX.CmsLayoutTemplateCategory::TABLENAME, $flds,
					 $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	verbose_msg(ilang('install_created_table', CmsLayoutTemplateCategory::TABLENAME, $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_layout_tpl_cat_1', CMS_DB_PREFIX.CmsLayoutTemplateCategory::TABLENAME,
										'name',array('UNIQUE'));
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'idx_layout_tpl_type_1', $ado_ret));

	$flds = "
		id I KEY AUTO,
		name C(100) NOTNULL,
		content X2,
		description X,
		type_id I NOTNULL,
		type_dflt I1,
		category_id I,
		owner_id I NOTNULL,
		listable I1 DEFAULT 1,
		created I,
		modified I";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX.CmsLayoutTemplate::TABLENAME, $flds,
					 $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', CmsLayoutTemplate::TABLENAME, $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_layout_tpl_1', CMS_DB_PREFIX.CmsLayoutTemplate::TABLENAME, 'name',array('UNIQUE'));
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'idx_layout_tpl_1', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_layout_tpl_2', CMS_DB_PREFIX.CmsLayoutTemplate::TABLENAME, 'type_id,type_dflt');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_creating_index', 'idx_layout_tpl_2', $ado_ret));

	$flds = "
		id I KEY AUTO,
		name C(100) NOTNULL,
		content X2,
		description X,
 		media_type C(255),
		media_query X,
		created I,
		modified I";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX.CmsLayoutStylesheet::TABLENAME, $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', CmsLayoutStylesheet::TABLENAME, $ado_ret));
	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_layout_css_1',CMS_DB_PREFIX.CmsLayoutStylesheet::TABLENAME, 'name', array('UNIQUE'));
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_index', 'idx_layout_css_1', $ado_ret));

	$flds = "
		tpl_id I KEY,
		user_id I KEY
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX.CmsLayoutTemplate::ADDUSERSTABLE, $flds,
					 $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	verbose_msg(ilang('install_created_table', CmsLayoutTemplate::ADDUSERSTABLE, $ado_ret));


	$flds = "
		id I KEY AUTO,
		name C(100) NOTNULL,
		description X,
		dflt I1,
		created I,
		modified I
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX.CmsLayoutCollection::TABLENAME, $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', CmsLayoutCollection::TABLENAME, $ado_ret));
	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'idx_layout_dsn_1',CMS_DB_PREFIX.CmsLayoutCollection::TABLENAME, 'name', array('UNIQUE'));
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_index', 'idx_layout_dsn_1', $ado_ret));


	$flds = "
		design_id I KEY NOTNULL,
		tpl_id  I KEY NOTNULL
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX.CmsLayoutCollection::TPLTABLE, $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', CmsLayoutCollection::TPLTABLE, $ado_ret));
	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'index_dsnassoc1', CMS_DB_PREFIX.CmsLayoutCollection::TPLTABLE, 'tpl_id');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_index', 'index_dsnassoc1', $ado_ret));

	$flds = "
		design_id I KEY NOTNULL,
		css_id  I KEY NOTNULL,
		item_order I NOTNULL
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX.CmsLayoutCollection::CSSTABLE, $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', CmsLayoutCollection::CSSTABLE, $ado_ret));

	$flds = "
		id I AUTO KEY NOTNULL,
		type C(20) NOTNULL,
		oid I NOTNULL,
		uid I NOTNULL,
		created I NOTNULL,
		modified I NOTNULL,
		lifetime I NOTNULL,
		expires I NOTNULL
	";
	$sqlarray = $dbdict->CreateTableSQL(CMS_DB_PREFIX.CmsLock::LOCK_TABLE, $flds, $taboptarray);
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	$ado_ret = ($return == 2) ? ilang('done') : ilang('failed');
	verbose_msg(ilang('install_created_table', CmsLock::LOCK_TABLE, $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'index_locks1', CMS_DB_PREFIX."locks", 'type,oid', array('UNIQUE'));
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	verbose_msg(ilang('install_created_index', 'index_locks1', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'index_locks2', CMS_DB_PREFIX."locks", 'expires');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	verbose_msg(ilang('install_created_index', 'index_locks2', $ado_ret));

	$sqlarray = $dbdict->CreateIndexSQL(CMS_DB_PREFIX.'index_locks3', CMS_DB_PREFIX."locks", 'uid');
	$return = $dbdict->ExecuteSQLArray($sqlarray);
	verbose_msg(ilang('install_created_index', 'index_locks3', $ado_ret));

}

# vim:ts=4 sw=4 noet
?>
<?php
# A
$lang['action_freshen'] = 'Freshening / Repairing a CMSMS %s installation';
$lang['action_install'] = 'Creating a new CMSMS %s website';
$lang['action_upgrade'] = 'Upgrading a CMSMS Website to version %s';
$lang['advanced_mode'] = 'Enable advanced mode';
$lang['apptitle'] = 'Installation and upgrade assistant';
$lang['assets_dir_exists'] = 'Assets directory exists';
$lang['available_languages'] = 'Available languages';

# B
$lang['build_date'] = 'Build Date';
$lang['build_reference'] = 'Build';

# C
$lang['changelog_uc'] = 'CHANGELOG';
$lang['cleaning_files'] = 'Cleaning files that are no longer applicable to the release';
$lang['config_writable'] = 'Check for writeable config file';
$lang['confirm_freshen'] = 'Are you sure you want to freshen (repair) the existing installation of CMSMS? Use with extreme caution!';
$lang['confirm_upgrade'] = 'Are you sure you want to begin the upgrade process';
$lang['curl_extension'] = 'Checking for the Curl extension';
$lang['create_assets_structure'] = 'Creating a location for file resources';

# D
$lang['database_support'] = 'Check for compatible database drivers';
$lang['desc_wizard_step1'] = 'Start the installation or upgrade process';
$lang['desc_wizard_step2'] = 'Analyze destination directory to find existing software';
$lang['desc_wizard_step3'] = 'Check to make sure everything is OK to install the CMSMS core';
$lang['desc_wizard_step4'] = 'For new installs, and freshen operation, enter basic configuration info';
$lang['desc_wizard_step5'] = 'For new installs, enter Admin account info';
$lang['desc_wizard_step6'] = 'For new installs enter some basic site details';
$lang['desc_wizard_step7'] = 'Extract files';
$lang['desc_wizard_step8'] = 'Create or update the database schema, set initial events, permissions, user accounts, templates, stylesheets and content';
$lang['desc_wizard_step9'] = 'Install and/or Upgrade modules as necessary, write the config file, and clean up.';
$lang['destination_directory'] = 'Destination Directory';
$lang['dest_writable'] = 'Write permission in destination directory';
$lang['disable_functions'] = 'Checking disabled functions';
$lang['done'] = 'Done';

# E
$lang['email_accountinfo_message'] = <<<EOT
Your installation of CMS Made Simple is complete.

This email contains sensitive information and should be stored in a secure location.

Here are the details of your installation.
username: %s
password: %s
install directory: %s
root url: %s

EOT;
$lang['email_accountinfo_message_exp'] = <<<EOT
Your installation of CMS Made Simple is complete.

This email contains sensitive information and should be stored in a secure location.

Here are the details of your installation.
username: %s
password: %s
install directory: %s

EOT;
$lang['email_accountinfo_subject'] = 'CMS Made Simple Installation Successful';
$lang['emailaccountinfo'] = 'Email the account information';
$lang['emailaddr'] = 'Email Address';
$lang['error_adminacct_emailaddr'] = 'The email address you specified is invalid';
$lang['error_adminacct_emailaddrrequired'] = 'You have selected to email the account information, but have not entered a valid email address';
$lang['error_adminacct_password'] = 'The password you specified is invalid (must be at least six characters long)';
$lang['error_adminacct_repeatpw'] = 'The passwords you entered did not match.';
$lang['error_adminacct_username'] = 'The username you specified is invalid. Please try again';
$lang['error_admindirrenamed'] = 'It appears that, for security reasons, you may have renamed your CMSMS Admin directory. You must reverse <a href="https://docs.cmsmadesimple.org/general-information/securing-cmsms#renaming-admin-folder" target="_blank" class="external">this process</a> in order to proceed!<br/><br/>Once you have reverted the admin directory name to its original location, please reload this page.';
$lang['error_backupconfig'] = 'We could not properly backup the config file';
$lang['error_checksum'] = 'Extracted file checksum does not match original';
$lang['error_cmstablesexist'] = 'It appears that there is already a CMS installation on this database. Please enter different database information. If you would like to use a different table prefix you may need to restart the installation process and enable advanced mode.';
$lang['error_createtable'] = 'Problem creating database table... perhaps this is a permissions issue';
$lang['error_dbconnect'] = 'We could not connect to the database. Please double check the credentials you have supplied';
$lang['error_dirnotvalid'] = 'The directory %s does not exist (or is not writeable)';
$lang['error_droptable'] = 'Problem dropping database table... perhaps this is a permissions issue';
$lang['error_filenotwritable'] = 'The file %s could not be overwritten (permissions problem)';
$lang['error_internal'] = 'Sorry, something has gone wrong... (internal error) (%s)';
$lang['error_invalid_directory'] = 'It appears that the directory you have selected to install in is a working directory for the installer itself';
$lang['error_invalidconfig'] = 'Error in the config file, or config file missing';
$lang['error_invaliddbpassword'] = 'Database password contains invalid characters that cannot be safely saved.';
$lang['error_invalidkey'] = 'Invalid member variable or key %s for class %s';
$lang['error_invalidparam'] = 'Invalid parameter or value for parameter: %s';
$lang['error_invalidtimezone'] = 'The timezone specified is invalid';
$lang['error_invalidqueryvar'] = 'The query variable entered contains invalid characters.  Please use only alphanumerics and underscore.';
$lang['error_missingconfigvar'] = 'The key &quot;%s&quot; is either missing or invalid in the config.ini file';
$lang['error_noarchive'] = 'Problem finding archive file... please restart';
$lang['error_nlsnotfound'] = 'Problem finding NLS files in archive';
$lang['error_nodatabases'] = 'No compatible database extensions could be found';
$lang['error_nodbhost'] = 'Please enter a valid hostname (or IP address) for the database connection';
$lang['error_nodbname'] = 'Please enter the name of a valid database on the host specified above';
$lang['error_nodbpass'] = 'Please enter a valid password for authenticating to the database';
$lang['error_nodbprefix'] = 'Please enter a valid prefix for database tables';
$lang['error_nodbtype'] = 'Please select a database type';
$lang['error_nodbuser'] = 'Please enter a valid username for authenticating to the database';
$lang['error_nodestdir'] = 'Destination directory not set';
$lang['error_nositename'] = 'Sitename is a required parameter. Please enter a suitable name for your website.';
$lang['error_notimezone'] = 'Please enter a valid timezone for this server';
$lang['error_overwrite'] = 'Permissions problem: cannot overwrite %s';
$lang['error_sendingmail'] = 'Error sending mail';
$lang['error_tzlist'] = 'A problem occurred retrieving the timezone identifiers list';
$lang['errorlevel_estrict'] = 'Checking for E_STRICT';
$lang['errorlevel_edeprecated'] = 'Checking for E_DEPRECATED';
$lang['edeprecated_enabled'] = 'E_DEPRECATED is enabled in the PHPs error_reporting.  Though this will not prevent CMSMS from operating, it may result in warnings being displayed in the output screen, particularly from older, third party modules';
$lang['estrict_enabled'] = 'E_STRICT is enabled in the PHPs error_reporting. Though this will not prevent CMSMS from operating, it may result in warnings being displayed in the HTML output, particularly from older, third party modules';

# F
$lang['fail_assets_dir'] = 'An assets directory already exists.  This application may write to this directory to rationalize the location of files.  Please ensure that you have a backup';
$lang['fail_assets_msg'] = 'An assets directory already exists.  This application may write to this directory to rationalize the location of files.  Please ensure that you have a backup';
$lang['fail_config_writable'] = 'The HTTP process cannot write to the config.php file. Please try to change the permissions on this file to 777 until the upgrade process is complete';
$lang['fail_curl_extension'] = 'The curl extension was not found. Though not a critical issue, this may cause problems with some third party modules';
$lang['fail_database_support'] = 'No compatible database drivers found';
$lang['fail_file_get_contents'] = 'The file_get_contents function does not exist, or is disabled. CMSMS Cannot continue (even the installer will probably fail)';
$lang['fail_file_uploads'] = 'File upload capabilities are disabled in this environment. Several functions of CMSMS will not function in this environment';
$lang['fail_func_json'] = 'json functionality was not found';
$lang['fail_func_gzopen'] = 'gzopen function was not found';
$lang['fail_func_md5'] = 'md5 functionality was not found';
$lang['fail_func_tempnam'] = 'The tempnam function does not exist. It is a required function for CMSMS functionality';
$lang['fail_func_ziparchive'] = 'ZipArchive functionality was not found.  This may limit functionality';
$lang['fail_ini_set'] = 'It appears that we cannot change ini settings. This could cause problems in third party modules (or when enabling debug mode)';
$lang['fail_intl_support'] = 'PHP\'s internationalization extension is not available';
$lang['fail_magic_quotes_runtime'] = 'It appears that magic quotes are enabled in your configuration. Please disable them and retry';
$lang['fail_max_execution_time'] = 'Your max execution time of %s does not meet the minimum value of %s.  We recommend you increase it to %s or greater';
$lang['fail_memory_limit'] = 'Your memory limit value is too low. You had %s, however a minimum of %s is required, and %s is recommended';
$lang['fail_multibyte_support'] = 'Multibyte support is not enabled in your configuration';
$lang['fail_output_buffering'] = 'Output buffering is not enabled.';
$lang['fail_open_basedir'] = 'Open basedir restrictions are in effect. CMSMS requires that this be disabled';
$lang['fail_php_version'] = 'The version of PHP available to CMSMS is critically important. The minimum accepted version is %s, though we recommend %s or greater. You have %s';
$lang['fail_post_max_size'] = 'Your post_max_size of %s does not meet the minimum value of %s. A value of %s or greater is recommended, and ensure that it is larger than the upload_max_filesize';
$lang['fail_pwd_writable2'] = 'The HTTP process must be able to write to the destination directory (and to all files and directories beneath it) in order to install files. We do not have write permission to (at least) %s';
$lang['fail_register_globals'] = 'Please disable register globals in your PHP configuration';
$lang['fail_remote_url'] = 'We encountered problems connecting to a remote URL.  This will limit some of the functionality of CMS Made Simple';
$lang['fail_safe_mode'] = 'CMSMS will not operate properly in an environment where safe mode is enabled. Safe mode is deprecated as a failed mechanism, and will be removed in future versions of PHP';
$lang['fail_session_save_path_exists'] = 'The session save path variable value is invalid or the directory does not exist';
$lang['fail_session_save_path_writable'] = 'The session save path directory is not writeable';
$lang['fail_session_use_cookies'] = 'CMSMS requires that PHP be configured to store the session key in a cookie';
$lang['fail_tmpfile'] = 'The system tmpfile() function is not functioning. This is required to allow us to extract archives. The optional TMPDIR url argument can be provided to the installer to specify a writeable directory. See the README file that should be in included in this directory.';
$lang['fail_tmp_dirs_empty'] = 'The CMSMS temporary directories <em>(tmp/cache and tmp/templates_c) exist, and are not empty.  Please remove or empty them';
$lang['fail_xml_functions'] = 'The XML extension was not found. Please enable this in your PHP environment';
$lang['failed'] = 'failed';
$lang['file_get_contents'] = 'Testing for the file_get_contents function';
$lang['file_installed'] = 'Installed %s';
$lang['file_uploads'] = 'Checking for file upload support';
$lang['finished_custom_freshen_msg'] = 'Your installation has been freshened! The core files have been updated, and a new config file created. Please visit your website to ensure that everything is functioning correctly';
$lang['finished_custom_install_msg'] = 'Done! Please visit your website and login to the Admin panel.';
$lang['finished_custom_upgrade_msg'] = 'Done!  Please visit your CMSMS Admin panel, and frontend, to ensure that everything is working properly.<br/><strong>Hint:</strong> Now is a good time to create another backup.';
$lang['finished_freshen_msg'] = 'Your installation has been freshened! The core files have been updated, and a new config file created.  You can now <a href="%s">visit your website</a> or login to the <a href="%s">CMSMS Admin panel</a>.';
$lang['finished_install_msg'] = 'We are done! You can now <a href="%s">visit your website</a> or login to the <a href="%s">CMSMS admin panel</a>.';
$lang['finished_upgrade_msg'] = 'All done! Please visit your <a href="%s">website frontend</a> and the <a href="%s">Admin panel</a> to verify correct behaviour. You may also need to upgrade some third party modules.<br/><strong>Hint:</strong> Remember to create another backup after verifying correct behaviour.';
$lang['freshen'] = 'Freshen (repair) installation';
$lang['func_json'] = 'Checking for json encoding and decoding functionality';
$lang['func_md5'] = 'Checking for md5 functionality';
$lang['func_tempnam'] = 'Check for tempnam function';
$lang['func_gzopen'] = 'Check for gzopen function';
$lang['func_ziparchive'] = 'Check for ziparchive function';

# G
$lang['gd_version'] = 'GD Version';
$lang['goback'] = 'Back';

# H

# I
$lang['info_addlanguages'] = 'Select languages (in addition to English) to install. <strong>Note:</strong> not all translations are complete.';
$lang['info_adminaccount'] = 'Please provide credentials for the initial administrator account. This account will have access to all of the functionality of the CMSMS Admin console.';
$lang['info_advanced'] = 'Advanced mode enables more options in the installation procedure.';
$lang['info_dbinfo'] = 'CMS Made Simple stores a great deal of data in the database. A database connection is mandatory. Additionally, the user credentials you supply should have ALL PRIVILEGES on the specified database to allow creating, dropping and modifying tables, indexes and views.';
$lang['info_errorlevel_edeprecated'] = 'E_DEPRECATED is a flag for PHP&quot;s error reporting that indicates that warnings should be displayed about code that is using deprecated techniques.  Although the CMSMS core attempts to ensure that we no longer use deprecated techniques, some modules may not.  We recommend that this setting be disabled in the PHP configuration';
$lang['info_errorlevel_estrict'] = 'E_STRICT is a flag for PHP&#39;s error reporting which indicates that strict coding standards should be respected. Although the CMSMS core attempts to conform to E_STRICT standards, some modules may not. We recommend that this setting be disabled in the PHP configuration';
$lang['info_installcontent'] = 'By default, this installer will create a series of sample pages, stylesheets and templates in CMSMS. The sample content provides extensive information and tips to aid in building websites with CMSMS and is useful to read. However, if you are already familiar with CMS Made Simple, disabling this option will result in a minimal set of templates, stylesheets and content pages.';
$lang['info_open_basedir_session_save_path'] = 'open_basedir is enabled in your PHP configuration. We could not properly test session capabilities. However, getting to this point in the installation process probably indicates that sessions are working okay.';
$lang['info_optional_modules'] = 'The following modules can be installed or left out of the installation if you do not wish to use them. Sample content is provided for each module.';
$lang['info_pwd_writable'] = 'This application needs write permission to the current working directory';
$lang['info_queryvar'] = 'The query variable is used internally by CMSMS to identify the page requested. In most circumstances you should not need to adjust this.';
$lang['info_sitename'] = 'The website name is used in default templates as part of the title. Please enter a human readable name for the website';
$lang['info_timezone'] = 'The timezone information is needed for time calculations and time/date displays. Please select the server timezone';
$lang['info_directory_not_created'] = 'Directory "%s" was not created';
$lang['ini_set'] = 'Testing if we can change INI settings';
$lang['install'] = 'Install';
$lang['install_attachstylesheets'] = 'Attach stylesheets to themes';
$lang['install_backupconfig'] = 'Backing up the config file';
$lang['install_createassets'] = 'Create assets structure';
$lang['install_created_index'] = 'Created index %s ... %s';
$lang['install_create_tables'] = 'Create database tables';
$lang['install_createconfig'] = 'Create new config file';
$lang['install_createcontentpages'] = 'Create default content pages';
$lang['install_created_table'] = 'Created table %s: .... %s';
$lang['install_createtablesindexes'] = 'Creating tables and indexes';
$lang['install_createtmpdirs'] = 'Create temporary directories';
$lang['install_creating_index'] = 'Created index %s';
$lang['install_default_collections'] = 'Install default collections';
$lang['install_defaultcontent'] = 'Install default content';
$lang['install_detectlanguages'] = 'Detect installed languages';
$lang['install_dropping_tables'] = 'Dropping tables';
$lang['install_dummyindexhtml'] = 'Create dummy index.html files';
$lang['install_extractfiles'] = 'Extract files from archive';
$lang['install_initevents'] = 'Create events';
$lang['install_initsitegroups'] = 'Create initial groups';
$lang['install_initsiteperms'] = 'Set initial permissions';
$lang['install_initsiteprefs'] = 'Set initial site preferences';
$lang['install_initsiteusers'] = 'Create initial user account';
$lang['install_initsiteusertags'] = 'Initial user defined tags';
$lang['install_module'] = 'Install module %s';
$lang['install_modules'] = 'Install available modules';
$lang['install_passwordsalt'] = 'Set password salt';
$lang['install_requireddata'] = 'Set initial required data';
$lang['install_schema'] = 'Create database schema';
$lang['install_setschemaver'] = 'Set schema version';
$lang['install_setsequence'] = 'Reset sequence tables';
$lang['install_setsitename'] = 'Set site name';
$lang['install_stylesheets'] = 'Create default stylesheets';
$lang['install_templates'] = 'Create default templates';
$lang['install_templatetypes'] = 'Create standard template types';
$lang['install_update_sequences'] = 'Update sequence tables';
$lang['install_updatehierarchy'] = 'Update content hierarchy positions';
$lang['install_updateseq'] = 'Update sequence for %s';
$lang['installer_ver'] = 'Installer Version';
$lang['intl_support'] = 'Check for internationalization capabilities';

# J

# K

# L
$lang['legend'] = 'Legend';

# M
$lang['magic_quotes_runtime'] = 'Ensure magic quotes are disabled';
$lang['max_execution_time'] = 'Checking PHP script max execution time';
$lang['meaning'] = 'Meaning';
$lang['memory_limit'] = 'Checking for a sufficient PHP memory limit';
$lang['msg_clearedcache'] = 'Cleared server cache';
$lang['msg_configsaved'] = 'Existing config file saved to %s';
$lang['msg_upgrade_module'] = 'Upgrading module %s';
$lang['msg_upgrademodules'] = 'Upgrading modules';
$lang['msg_yourvalue'] = 'You have: %s';
$lang['multibyte_support'] = 'Check for multibyte support';

# N
$lang['next'] = 'Next';
$lang['no'] = 'No';
$lang['none'] = 'None';

# O
$lang['open_basedir'] = 'open_basedir restrictions';
$lang['open_basedir_session_save_path'] = 'open_basedir is in enabled. Cannot test session save path.';
$lang['output_buffering'] = 'Ensuring that output buffering is enabled';

# P
$lang['pass_config_writable'] = 'The HTTP process has write permission to the config.php file';
$lang['pass_database_support'] = 'At least one compatible database driver found';
$lang['pass_func_json'] = 'json functionality detected';
$lang['pass_func_md5'] = 'md5 functionality was detected';
$lang['pass_func_tempnam'] = 'The tempnam function exists';
$lang['pass_intl_support'] = 'Internationalization capabilities appear to be enabled';
$lang['pass_memory_limit_nolimit'] = 'There is no preset PHP memory limit';
$lang['pass_multibyte_support'] = 'Multibyte support appears to be enabled';
$lang['pass_php_version'] = 'The PHP version currently configured does not meet minimum requirements. At a minimum, PHP %s is required, though we recommend %s or higher';
$lang['pass_pwd_writable'] = 'The HTTP process can write into the destination directory. This is necessary for extracting files';
$lang['password'] = 'Password';
$lang['ph_sitename'] = 'Enter a Site Name';
$lang['php_version'] = 'PHP Version';
$lang['post_max_size'] = 'Checking maximum amount of data that can be posted in one request';
$lang['prompt_addlanguages'] = 'Additional Languages';
$lang['prompt_createtables'] = 'Create Database Tables';
$lang['prompt_dbhost'] = 'Database Hostname';
$lang['prompt_dbinfo'] = 'Database Information';
$lang['prompt_dbname'] = 'Database Name';
$lang['prompt_dbpass'] = 'Password';
$lang['prompt_dbport'] = 'Database Port Number';
$lang['prompt_dbprefix'] = 'Database Table Name Prefix';
$lang['prompt_dbtype'] = 'Database Type';
$lang['prompt_dbuser'] = 'Username';
$lang['prompt_dir'] = 'Installation Directory';
$lang['prompt_installcontent'] = 'Install Sample Content';
$lang['prompt_optional_modules'] = 'Install Optional Modules';
$lang['prompt_queryvar'] = 'Query Variable';
$lang['prompt_sitename'] = 'Web Site Name';
$lang['prompt_timezone'] = 'Server Timezone';
$lang['pwd_writable'] = 'Directory Writeable';

# Q
$lang['queue_for_upgrade'] = 'Queued non core module %s for upgrade at the next step.';

# R
$lang['readme_uc'] = 'README';
$lang['register_globals'] = 'Ensuring &quot;register globals&quot; is disabled';
$lang['remote_url'] = 'Test if we can make outgoing HTTP connections';
$lang['repeatpw'] = 'Repeat password';
$lang['reset_site_preferences'] = 'Reset some site preferences';
$lang['reset_user_settings'] = 'Reset user preferences';
$lang['retry'] = 'Retry';

# S
$lang['safe_mode'] = 'Testing to ensure &quot;safe mode&quot; is disabled';
$lang['saltpasswords'] = 'Salt Passwords';
$lang['select_language'] = 'The first thing we will ask you to do is to select your preferred language from the list below. This will be used to enhance your experience during this installation sequence, but will not affect your CMSMS installation.';
$lang['send_admin_email'] = 'Send Admin login credentials email';
$lang['session_capabilities'] = 'Testing for proper session capabilities (sessions are using cookies and session save path is writeable, etc)';
$lang['session_save_path_exists'] = 'Session_save_path exists';
$lang['session_save_path_writable'] = 'Session_save_path is writeable';
$lang['session_use_cookies'] = 'Ensuring that PHP sessions use cookies';
$lang['sometests_failed'] = 'We have performed numerous tests of your current web environment. Although no critical issues were found, we recommend that the following items be corrected before continuing.';
$lang['step1_advanced'] = 'Advanced Mode';
$lang['step1_destdir'] = 'Select Directory';
$lang['step1_info_destdir'] = '<strong>Warning:</strong> This program can install or upgrade multiple installations of CMS Made Simple. It is important that you select the correct directory for installation or upgrading.';
$lang['step1_language'] = 'Select Language';
$lang['step1_title'] = 'Select Language';
$lang['step2_cmsmsfound'] = 'An installation of CMS Made Simple was found. It is possible to upgrade this installation. However, before proceeding, ensure that you have a current, VERIFIED backup of all files and of the database';
$lang['step2_cmsmsfoundnoupgrade'] = 'Although an installation of CMS Made Simple was found, it is not possible to upgrade this version using this application. The version may be too old.';
$lang['step2_confirminstall'] = 'Are you sure you would like to install CMS Made Simple';
$lang['step2_confirmupgrade'] = 'Are you sure you would like to upgrade CMS Made Simple';
$lang['step2_errorsamever'] = 'The selected directory appears to contain a CMSMS installation with the same version that is included in this script. Continuing will freshen the installation.';
$lang['step2_errortoonew'] = 'The selected directory appears to contain a CMSMS installation with a newer version than what is included in this script. Unable to proceed';
$lang['step2_info_freshen'] = 'Freshening the installation involves replacing all core files and recreating the configuration. You will be asked basic configuration information, however the database will not be touched.';
$lang['step2_installdate'] = 'Approximate installation date';
$lang['step2_install_dirnotempty2'] = 'This folder already contains some files and/or subfolders.  Though it is possible to install CMSMS here, it may inadvertently corrupt an existing application.  Please double check the contents of this folder.  For reference purposes some of the files are listed below.  Please ensure that this is correct.';
$lang['step2_hdr_upgradeinfo'] = 'Version information';
$lang['step2_info_upgradeinfo'] = 'Below are the available release notes and changelog information for each release. The buttons below will display detailed information as to what has changed in each version of CMS Made Simple. There may be further instructions or warnings in each version that could affect the upgrade process.';
$lang['step2_minupgradever'] = 'The minimum version that this application can upgrade from is: %s. You may need to upgrade your application to a newer version in stages, using another method before completing the upgrade process. Please ensure that you have a complete, verified backup before using any upgrade method.';
$lang['step2_nocmsms'] = 'We did not find an installation of CMS Made Simple in this directory. It looks like this is a new installation';
$lang['step2_nofiles'] = 'As requested, CMSMS Core files will not be processed during this process';
$lang['step2_passed'] = 'Passed';
$lang['step2_pwd'] = 'Your current working directory';
$lang['step2_schemaver'] = 'Database Schema version';
$lang['step2_version'] = 'Your version';
$lang['step3_failed'] = 'This package has performed numerous tests of your PHP environment, and one or more of those tests have failed. You will need to rectify these errors in your configuration before continuing. Once you have rectified the errors, click &quot;Retry&quot; below.';
$lang['step3_passed'] = 'This package has performed numerous tests of your PHP environment, and they have all passed. This is great news! Although this is not an all-encompassing test, you should have no difficulty running the core installation of CMSMS.';
$lang['step9_get_help'] = 'Connect with other CMSMS developers and get help in the following ways';
$lang['step9_get_support'] = 'Support channels';
$lang['step9_join_community'] = 'Join our community';
$lang['step9_love_cmsms'] = 'Love CMS Made Simple';
$lang['step9_removethis'] = '<strong>Warning</strong> For security reasons it is important that you remove the installation assistant from your browseable website as soon as you have verified that the operation has succeeded.';
$lang['step9_support_us'] = 'Click here to find out how you can support us';
$lang['symbol'] = 'Symbol';
$lang['social_message'] = 'I have successfully installed CMS Made Simple!';

# T
$lang['test_failed'] = 'A required test failed';
$lang['test_passed'] = 'A test passed <em>(passed tests are only displayed in advanced mode)</em>';
$lang['test_warning'] = 'A setting is above the required value, but below the recommended value, or...<br />A capability that may be required for some optional functionality is unavailable';
$lang['th_status'] = 'Status';
$lang['th_testname'] = 'Test';
$lang['th_value'] = 'Value';
$lang['title_error'] = 'Houston, We have a problem!';
$lang['title_step2'] = 'Step 2 - Detect existing software';
$lang['title_step3'] = 'Step 3 - Tests';
$lang['title_step4'] = 'Step 4 - Basic Configuration Information';
$lang['title_step5'] = 'Step 5 - Admin Account Information';
$lang['title_step6'] = 'Step 6 - Site Settings';
$lang['title_step7'] = 'Step 7 - Install Application Files';
$lang['title_step8'] = 'Step 8 - Database Work';
$lang['title_step9'] = 'Step 9 - Finish';
$lang['title_welcome'] = 'Welcome';
$lang['title_forum'] = 'Support Forum';
$lang['title_docs'] = 'Official Documentation';
$lang['title_api_docs'] = 'Official API Documentation';
$lang['to'] = 'to';
$lang['title_share'] = 'Share your experience with your friends.';
$lang['tmpfile'] = 'Checking for working tmpfile()';
$lang['tmp_dirs_empty'] = 'Ensure that temporary directories are empty or do not exist';

# U
$lang['upgrade'] = 'Upgrade';
$lang['upgrade_deleteoldevents'] = 'Deleting old events';
$lang['upgrading_schema'] = 'Updating database schema';
$lang['upload_max_filesize'] = 'Checking maximum size of uploaded files';
$lang['username'] = 'Username';

# V

# W
$lang['warn_disable_functions'] = 'Note: one or more PHP core functions are disabled. This can have a negative impact on your CMSMS installation, particularly with third party extensions. Please keep an eye on your error log. Your disabled functions are: <br /><br />%s';
$lang['warn_max_execution_time'] = 'Although your max execution time of %s meets or exceeds the minimum value of %s, we recommend you increase it to %s or greater';
$lang['warn_memory_limit'] = 'Your memory limit value is %s, which is above the minimum of %s. However, %s is recommended';
$lang['warn_open_basedir'] = 'open_basedir is enabled in your php configuration.  Although you may continue, CMSMS will not support installs with open_basedir restrictions.';
$lang['warn_post_max_size'] = 'Your post max size value is %s, which is above the minimum of %s, however %s is recommended. Also, please ensure that this value is larger than the upload_max_filesize';
$lang['warn_tests'] = '<strong>Note:</strong> passing all of these tests should ensure that CMSMS functions properly for most sites. However, as the site grows and more functionality is added, these minimal values may become insufficient. Additionally, third party modules may have further requirements to function properly';
$lang['warn_upload_max_filesize'] = 'Although your setting of %s is sufficient, we recommend you increase the upload_max_filesize setting in PHP to at least %s';
$lang['welcome_message'] = 'Welcome! This is the CMS Made Simple Automatic Installation Mechanism. This package will allow you to quickly and easily confirm that your web host is compatible with CMSMS and to install or upgrade to the latest version of CMS Made Simple.<br />We know that you will enjoy it.';
$lang['wizard_step1'] = 'Welcome';
$lang['wizard_step2'] = 'Detect Existing Software';
$lang['wizard_step3'] = 'Compatibility Tests';
$lang['wizard_step4'] = 'Configuration Info';
$lang['wizard_step5'] = 'Admin Account Info';
$lang['wizard_step6'] = 'Site Settings';
$lang['wizard_step7'] = 'Files';
$lang['wizard_step8'] = 'Database work';
$lang['wizard_step9'] = 'Finish';

# X
$lang['xml_functions'] = 'Checking for XML functionality';

# Y
$lang['yes'] = 'Yes';

# Z

?>
12
12
SQLite format 3   @     0                                                              0 .j       H

@?
	o@                                                  ''QviewNODES_CURRENTNODES_CURRENTCREATE VIEW NODES_CURRENT AS   SELECT * FROM nodes AS n     WHERE op_depth = (SELECT MAX(op_depth) FROM nodes AS n2                       WHERE n2.wc_id = n.wc_id                         AND n2.local_relpath = n.local_relpath)e'indexI_NODES_MOVEDNODESCREATE UNIQUE INDEX I_NODES_MOVED ON NODES (wc_id, moved_to, op_depth)))indexI_NODES_PARENTNODESCREATE UNIQUE INDEX I_NODES_PARENT ON NODES (wc_id, parent_relpath,                                              local_relpath, op_depth)U	tableNODESNODESCREATE TABLE NODES (   wc_id  INTEGER NOT NULL REFERENCES WCROOT (id),   local_relpath  TEXT NOT NULL,   op_depth INTEGER NOT NULL,   parent_relpath  TEXT,   repos_id  INTEGER REFERENCES REPOSITORY (id),   repos_path  TEXT,   revision  INTEGER,   presence  TEXT NOT NULL,   moved_here  INTEGER,   moved_to  TEXT,   kind  TEXT NOT NULL,   properties  BLOB,   depth  TEXT,   checksum  TEXT REFERENCES PRISTINE (checksum),   symlink_target  TEXT,   changed_revision  INTEGER,   changed_date      INTEGER,   changed_author    TEXT,   translated_size  INTEGER,   last_mod_time  INTEGER,   dav_cache  BLOB,   file_external  INTEGER,   inherited_props  BLOB,   PRIMARY KEY (wc_id, local_relpath, op_depth)   ))= indexsqlite_autoindex_NODES_1NODESbtableWC_LOCKWC_LOCKCREATE TABLE WC_LOCK (   wc_id  INTEGER NOT NULL  REFERENCES WCROOT (id),   local_dir_relpath  TEXT NOT NULL,   locked_levels  INTEGER NOT NULL DEFAULT -1,   PRIMARY KEY (wc_id, local_dir_relpath)  )-A indexsqlite_autoindex_WC_LOCK_1WC_LOCK}!!EtableWORK_QUEUEWORK_QUEUECREATE TABLE WORK_QUEUE (   id  INTEGER PRIMARY KEY AUTOINCREMENT,   work  BLOB NOT NULL   )
wtableLOCKLOCKCREATE TABLE LOCK (   repos_id  INTEGER NOT NULL REFERENCES REPOSITORY (id),   repos_relpath  TEXT NOT NULL,   lock_token  TEXT NOT NULL,   lock_owner  TEXT,   lock_comment  TEXT,   lock_date  INTEGER,   PRIMARY KEY (repos_id, repos_relpath)   )'; indexsqlite_autoindex_LOCK_1LOCK4+#'indexI_ACTUAL_PARENTACTUAL_NODECREATE UNIQUE INDEX I_ACTUAL_PARENT ON ACTUAL_NODE (wc_id, parent_relpath,                                                     local_relpath)<##?tableACTUAL_NODEACTUAL_NODE
CREATE TABLE ACTUAL_NODE (   wc_id  INTEGER NOT NULL REFERENCES WCROOT (id),   local_relpath  TEXT NOT NULL,   parent_relpath  TEXT,   properties  BLOB,   conflict_old  TEXT,   conflict_new  TEXT,   conflict_working  TEXT,   prop_reject  TEXT,   changelist  TEXT,   text_mod  TEXT,   tree_conflict_data  TEXT,   conflict_data  BLOB,   older_checksum  TEXT REFERENCES PRISTINE (checksum),   left_checksum  TEXT REFERENCES PRISTINE (checksum),   right_checksum  TEXT REFERENCES PRISTINE (checksum),   PRIMARY KEY (wc_id, local_relpath)   )5
I# indexsqlite_autoindex_ACTUAL_NODE_1ACTUAL_NODEX)yindexI_PRISTINE_MD5PRISTINECREATE INDEX I_PRISTINE_MD5 ON PRISTINE (md5_checksum)M	mtablePRISTINEPRISTINE
CREATE TABLE PRISTINE (   checksum  TEXT NOT NULL PRIMARY KEY,   compression  INTEGER,   size  INTEGER NOT NULL,   refcount  INTEGER NOT NULL,   md5_checksum  TEXT NOT NULL   )/
C indexsqlite_autoindex_PRISTINE_1PRISTINE_+indexI_LOCAL_ABSPATHWCROOT	CREATE UNIQUE INDEX I_LOCAL_ABSPATH ON WCROOT (local_abspath)xKtableWCROOTWCROOTCREATE TABLE WCROOT (   id  INTEGER PRIMARY KEY AUTOINCREMENT,   local_abspath  TEXT UNIQUE   )+? indexsqlite_autoindex_WCROOT_1WCROOTD!]indexI_ROOTREPOSITORYCREATE INDEX I_ROOT ON REPOSITORY (root)D!]indexI_UUIDREPOSITORYCREATE INDEX I_UUID ON REPOSITORY (uuid)P++Ytablesqlite_sequencesqlite_sequenceCREATE TABLE sqlite_sequence(name,seq)!!tableREPOSITORYREPOSITORYCREATE TABLE REPOSITORY (   id INTEGER PRIMARY KEY AUTOINCREMENT,   root  TEXT UNIQUE NOT NULL,   uuid  TEXT NOT NULL   )3G! indexsqlite_autoindex_REPOSITORY_1REPOSITORY      
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                X mUhttp://svn.cmsmadesimple.org/svn/translatecenterffbaec8b-0406-0410-bd6f-d8cd2f59f08d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      3m	http://svn.cmsmadesimple.org/svn/translatecenter
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !WORK_QUEUE
		WCROOT
!	REPOSITORY
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  'U	ffbaec8b-0406-0410-bd6f-d8cd2f59f08d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      3m	http://svn.cmsmadesimple.org/svn/translatecenter
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	
   
4 D(

l

P4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ]
i 	Y$sha1$9b2b574de894fa79f34e6c3360c3d5883bdaa036 $md5 $2171893565d659adfc771c47933936d9]i 	Y$sha1$452579cb34b89e5ff99f063aa235d91503c761e1 F$md5 $9ac71c7065f613774e783af12e0a5d97\i 	Y$sha1$917fe7efbbc9b437dedb7c8d8441afaa95cd4878~$md5 $c709e8eaf965708c8ca3f4bb5f6aff10]
i 	Y$sha1$0ed15864535f3e96695d4dc733fa656ff2c43c8a P$md5 $a2e2046bed1a6bc27c8c42860d65e46e\	i 	Y$sha1$61a52da0736de969cfb0b08a37d125d05adcc5d0jq$md5 $3b6bf70a3ce396587ee86a80f7d3ea85]i 	Y$sha1$ecc1227d43ac759d7a6dd6ef9e062012972d3384 F$md5 $7b3611e2f29004cd7c0ba560ff036584\i 	Y$sha1$0358b59d9dfb528bb88372ee5a718edbf9ea6e85($md5 $f8a52e773dceda649d3e986b8931e131\i 	Y$sha1$bb02def8058a0a1760e2742d965bd107f815b556$md5 $9ace92ba25a9e38ca8e6551047e37530]i Y$sha1$48b537b95f22edeef9e2a1c1c2511a9e470a159b $md5 $4e638c327bf688c7956f92f60342da2f]i 	Y$sha1$9d59440f77fb0d01e65647c5afe6d20d351fe468 $md5 $3eca85fae5db43ab9e3c870718935a9c\i 	Y$sha1$460cd0290e2dd2d49df60e9784ffd227f05f1622{$md5 $49330428dce1d872094ab43f6ecbbca3\i 	Y$sha1$2ad3871308764a429d9c31413a238dac20fb6eefC$md5 $c8597239c374c0ace280f4b1134bd1d7\i 	Y$sha1$3c489ef91f90807823975bd3d737e0d334453dcf$md5 $3322024c5d5cf7214593754f34e9d1e8
   

j 
h6

j5i                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        2i$sha1$9b2b574de894fa79f34e6c3360c3d5883bdaa036
2i$sha1$452579cb34b89e5ff99f063aa235d91503c761e12i$sha1$917fe7efbbc9b437dedb7c8d8441afaa95cd48782i$sha1$0ed15864535f3e96695d4dc733fa656ff2c43c8a
2i$sha1$61a52da0736de969cfb0b08a37d125d05adcc5d0	2i$sha1$ecc1227d43ac759d7a6dd6ef9e062012972d33842i$sha1$0358b59d9dfb528bb88372ee5a718edbf9ea6e852i$sha1$bb02def8058a0a1760e2742d965bd107f815b5562i$sha1$48b537b95f22edeef9e2a1c1c2511a9e470a159b2i$sha1$9d59440f77fb0d01e65647c5afe6d20d351fe4682i$sha1$460cd0290e2dd2d49df60e9784ffd227f05f16222i$sha1$2ad3871308764a429d9c31413a238dac20fb6eef1i	$sha1$3c489ef91f90807823975bd3d737e0d334453dcf
   

 
~U*
S(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *Y$md5 $2171893565d659adfc771c47933936d9
*Y$md5 $9ac71c7065f613774e783af12e0a5d97*Y$md5 $c709e8eaf965708c8ca3f4bb5f6aff10*Y$md5 $a2e2046bed1a6bc27c8c42860d65e46e
*Y$md5 $3b6bf70a3ce396587ee86a80f7d3ea85	*Y$md5 $7b3611e2f29004cd7c0ba560ff036584*Y$md5 $f8a52e773dceda649d3e986b8931e131*Y$md5 $9ace92ba25a9e38ca8e6551047e37530*Y$md5 $4e638c327bf688c7956f92f60342da2f*Y$md5 $3eca85fae5db43ab9e3c870718935a9c*Y$md5 $49330428dce1d872094ab43f6ecbbca3*Y$md5 $c8597239c374c0ace280f4b1134bd1d7)Y	$md5 $3322024c5d5cf7214593754f34e9d1e8
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
      DDDDDDDDDDD                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      L(file-install it_IT.php 1 0 1 1)  L(file-install pt_PT.php 1 0 1 1)  rL(file-install uk_UA.php 1 0 1 1)  ML(file-install nl_NL.php 1 0 1 1)  (L(file-install da_DK.php 1 0 1 1)  L(file-install de_DE.php 1 0 1 1)   L(file-install sv_SE.php 1 0 1 1)   L(file-install fr_FR.php 1 0 1 1)   L(file-install ru_RU.php 1 0 1 1)   oL(file-install nb_NO.php 1 0 1 1)   JL(file-install sk_SK.php 1 0 1 1)#
 L(file-install fr_FR.php 1 0 1 1)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     	

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	
	
 
 
	r^I5 
                                                                                                                                                                                                                                                                                                                                                                                                                             		
	_   i !d  da_DK.phpmodules/cmspharinstall/lang/ext/da_DK.php_normalfile()$sha1$ecc1227d43ac759d7a6dd6ef9e062012972d3384[o uDBtranslator F #(svn:wc:ra_dav:version-url 77 /svn/translatecenter/!svn/ver/23407/modules/cmspharinstall/lang/ext/da_DK.php)   
 	K    !    modules/cmspharinstall/lang/ext_normaldir()infinity_ 
translator()   	
	_   i !  d  it_IT.phpmodules/cmspharinstall/lang/ext/it_IT.php_normalfile()$sha1$452579cb34b89e5ff99f063aa235d9f	b	
 	K    !    modules/cmspharinstall/lang/ext_normaldir()infinity_ {translator()
	
	_   i !d  it_IT.phpmodules/cmspharinstall/lang/ext/it_IT.php_normalfile()$sha1$452579cb34b89e5ff99f063aa235d91503c761e1] $KXtranslator F #(svn:wc:ra_dav:version-url 77 /svn/translatecenter/!svn/ver/24057/modules/cmspharinstall/lang/ext/it_IT.php)	
	_   i !d  pt_PT.phpmodules/cmspharinstall/lang/ext/pt_PT.php_normalfile()$sha1$917fe7efbbc9b437dedb7c8d8441afaa95cd4878Y& Iw0ptranslator~ #(svn:wc:ra_dav:version-url 77 /svn/translatecenter/!svn/ver/22822/modules/cmspharinstall/lang/ext/pt_PT.php)	
	_   i !d  uk_UA.phpmodules/cmspharinstall/lang/ext/uk_UA.php_normalfile()$sha1$0ed15864535f3e96695d4dc733fa656ff2c43c8a\ z|Ztranslator P #N>(svn:wc:ra_dav:version-url 77 /svn/translatecenter/!svn/ver/23713/modules/cmspharinstall/lang/ext/uk_UA.php)
	
	_   i !d  nl_NL.phpmodules/cmspharinstall/lang/ext/nl_NL.php_normalfile()$sha1$61a52da0736de969cfb0b08a37d125d05adcc5d0_ 
translatorjq #(svn:wc:ra_dav:version-url 77 /svn/translatecenter/!svn/ver/24485/modules/cmspharinstall/lang/ext/nl_NL.php)	
	_   i !d  de_DE.phpmodules/cmspharinstall/lang/ext/de_DE.php_normalfile()$sha1$0358b59d9dfb528bb88372ee5a718edbf9ea6e85_ ׽	translator( #<(svn:wc:ra_dav:version-url 77 /svn/translatecenter/!svn/ver/24347/modules/cmspharinstall/lang/ext/de_DE.php)	
	_   i !d  sv_SE.phpmodules/cmspharinstall/lang/ext/sv_SE.php_normalfile()$sha1$bb02def8058a0a1760e2742d965bd107f815b556VP Urtranslator #o(svn:wc:ra_dav:version-url 77 /svn/translatecenter/!svn/ver/22096/modules/cmspharinstall/lang/ext/sv_SE.php)	
	_   i !d  fr_FR.phpmodules/cmspharinstall/lang/ext/fr_FR.php_normalfile()$sha1$9b2b574de894fa79f34e6c3360c3d5883bdaa036_ {translator  >TD(svn:wc:ra_dav:version-url 77 /svn/translatecenter/!svn/ver/24515/modules/cmspharinstall/lang/ext/fr_FR.php)	
	_   i !d  ru_RU.phpmodules/cmspharinstall/lang/ext/ru_RU.php_normalfile()$sha1$9d59440f77fb0d01e65647c5afe6d20d351fe468_4 ڋtranslator  ##(svn:wc:ra_dav:version-url 77 /svn/translatecenter/!svn/ver/24372/modules/cmspharinstall/lang/ext/ru_RU.php)	
	_   i !d  nb_NO.phpmodules/cmspharinstall/lang/ext/nb_NO.php_normalfile()$sha1$460cd0290e2dd2d49df60e9784ffd227f05f1622_  %6Đtranslator{ #q(svn:wc:ra_dav:version-url 77 /svn/translatecenter/!svn/ver/24465/modules/cmspharinstall/lang/ext/nb_NO.php)	
	_   i !d  sk_SK.phpmodules/cmspharinstall/lang/ext/sk_SK.php_normalfile()$sha1$2ad3871308764a429d9c31413a238dac20fb6eefW +
translatorC #(svn:wc:ra_dav:version-url 77 /svn/translatecenter/!svn/ver/22485/modules/cmspharinstall/lang/ext/sk_SK.php)	
	_   i !d  ca_ES.phpmodules/cmspharinstall/lang/ext/ca_ES.php_normalfile()$sha1$3c489ef91f90807823975bd3d737e0d334453dcf^ ȫzAtranslator #^	(svn:wc:ra_dav:version-url 77 /svn/translatecenter/!svn/ver/24226/modules/cmspharinstall/lang/ext/ca_ES.php)
 
3 3z:jJZ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 	
	it_IT.php
	pt_PT.php	uk_UA.php	nl_NL.php
	da_DK.php		de_DE.php	sv_SE.php	fr_FR.php	ru_RU.php	nb_NO.php	sk_SK.php	ca_ES.php   	
 
% %q-`>O                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    