<?php
/**
 * WebsiteCloneResponse
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.7.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.14.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Model;

use \ArrayAccess;
use \OpenAPI\Client\ObjectSerializer;

/**
 * WebsiteCloneResponse Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class WebsiteCloneResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'WebsiteCloneResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'source_website_id' => 'string',
        'dest_website_id' => 'string',
        'exclude_paths' => 'string[]',
        'include_databases' => 'string[]',
        'include_database_users' => 'string[]',
        'delete_files_from_destination' => 'bool',
        'status' => '\OpenAPI\Client\Model\WebsiteCloneEnumStatus',
        'sync_php_version' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'source_website_id' => 'uuid',
        'dest_website_id' => 'uuid',
        'exclude_paths' => null,
        'include_databases' => null,
        'include_database_users' => null,
        'delete_files_from_destination' => null,
        'status' => null,
        'sync_php_version' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'source_website_id' => false,
        'dest_website_id' => false,
        'exclude_paths' => false,
        'include_databases' => false,
        'include_database_users' => false,
        'delete_files_from_destination' => false,
        'status' => false,
        'sync_php_version' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'source_website_id' => 'sourceWebsiteId',
        'dest_website_id' => 'destWebsiteId',
        'exclude_paths' => 'excludePaths',
        'include_databases' => 'includeDatabases',
        'include_database_users' => 'includeDatabaseUsers',
        'delete_files_from_destination' => 'deleteFilesFromDestination',
        'status' => 'status',
        'sync_php_version' => 'syncPhpVersion'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'source_website_id' => 'setSourceWebsiteId',
        'dest_website_id' => 'setDestWebsiteId',
        'exclude_paths' => 'setExcludePaths',
        'include_databases' => 'setIncludeDatabases',
        'include_database_users' => 'setIncludeDatabaseUsers',
        'delete_files_from_destination' => 'setDeleteFilesFromDestination',
        'status' => 'setStatus',
        'sync_php_version' => 'setSyncPhpVersion'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'source_website_id' => 'getSourceWebsiteId',
        'dest_website_id' => 'getDestWebsiteId',
        'exclude_paths' => 'getExcludePaths',
        'include_databases' => 'getIncludeDatabases',
        'include_database_users' => 'getIncludeDatabaseUsers',
        'delete_files_from_destination' => 'getDeleteFilesFromDestination',
        'status' => 'getStatus',
        'sync_php_version' => 'getSyncPhpVersion'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('source_website_id', $data ?? [], null);
        $this->setIfExists('dest_website_id', $data ?? [], null);
        $this->setIfExists('exclude_paths', $data ?? [], null);
        $this->setIfExists('include_databases', $data ?? [], null);
        $this->setIfExists('include_database_users', $data ?? [], null);
        $this->setIfExists('delete_files_from_destination', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('sync_php_version', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['source_website_id'] === null) {
            $invalidProperties[] = "'source_website_id' can't be null";
        }
        if ($this->container['exclude_paths'] === null) {
            $invalidProperties[] = "'exclude_paths' can't be null";
        }
        if ($this->container['include_databases'] === null) {
            $invalidProperties[] = "'include_databases' can't be null";
        }
        if ($this->container['include_database_users'] === null) {
            $invalidProperties[] = "'include_database_users' can't be null";
        }
        if ($this->container['delete_files_from_destination'] === null) {
            $invalidProperties[] = "'delete_files_from_destination' can't be null";
        }
        if ($this->container['status'] === null) {
            $invalidProperties[] = "'status' can't be null";
        }
        if ($this->container['sync_php_version'] === null) {
            $invalidProperties[] = "'sync_php_version' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets source_website_id
     *
     * @return string
     */
    public function getSourceWebsiteId()
    {
        return $this->container['source_website_id'];
    }

    /**
     * Sets source_website_id
     *
     * @param string $source_website_id source_website_id
     *
     * @return self
     */
    public function setSourceWebsiteId($source_website_id)
    {
        if (is_null($source_website_id)) {
            throw new \InvalidArgumentException('non-nullable source_website_id cannot be null');
        }
        $this->container['source_website_id'] = $source_website_id;

        return $this;
    }

    /**
     * Gets dest_website_id
     *
     * @return string|null
     */
    public function getDestWebsiteId()
    {
        return $this->container['dest_website_id'];
    }

    /**
     * Sets dest_website_id
     *
     * @param string|null $dest_website_id dest_website_id
     *
     * @return self
     */
    public function setDestWebsiteId($dest_website_id)
    {
        if (is_null($dest_website_id)) {
            throw new \InvalidArgumentException('non-nullable dest_website_id cannot be null');
        }
        $this->container['dest_website_id'] = $dest_website_id;

        return $this;
    }

    /**
     * Gets exclude_paths
     *
     * @return string[]
     */
    public function getExcludePaths()
    {
        return $this->container['exclude_paths'];
    }

    /**
     * Sets exclude_paths
     *
     * @param string[] $exclude_paths exclude_paths
     *
     * @return self
     */
    public function setExcludePaths($exclude_paths)
    {
        if (is_null($exclude_paths)) {
            throw new \InvalidArgumentException('non-nullable exclude_paths cannot be null');
        }
        $this->container['exclude_paths'] = $exclude_paths;

        return $this;
    }

    /**
     * Gets include_databases
     *
     * @return string[]
     */
    public function getIncludeDatabases()
    {
        return $this->container['include_databases'];
    }

    /**
     * Sets include_databases
     *
     * @param string[] $include_databases include_databases
     *
     * @return self
     */
    public function setIncludeDatabases($include_databases)
    {
        if (is_null($include_databases)) {
            throw new \InvalidArgumentException('non-nullable include_databases cannot be null');
        }
        $this->container['include_databases'] = $include_databases;

        return $this;
    }

    /**
     * Gets include_database_users
     *
     * @return string[]
     */
    public function getIncludeDatabaseUsers()
    {
        return $this->container['include_database_users'];
    }

    /**
     * Sets include_database_users
     *
     * @param string[] $include_database_users include_database_users
     *
     * @return self
     */
    public function setIncludeDatabaseUsers($include_database_users)
    {
        if (is_null($include_database_users)) {
            throw new \InvalidArgumentException('non-nullable include_database_users cannot be null');
        }
        $this->container['include_database_users'] = $include_database_users;

        return $this;
    }

    /**
     * Gets delete_files_from_destination
     *
     * @return bool
     */
    public function getDeleteFilesFromDestination()
    {
        return $this->container['delete_files_from_destination'];
    }

    /**
     * Sets delete_files_from_destination
     *
     * @param bool $delete_files_from_destination delete_files_from_destination
     *
     * @return self
     */
    public function setDeleteFilesFromDestination($delete_files_from_destination)
    {
        if (is_null($delete_files_from_destination)) {
            throw new \InvalidArgumentException('non-nullable delete_files_from_destination cannot be null');
        }
        $this->container['delete_files_from_destination'] = $delete_files_from_destination;

        return $this;
    }

    /**
     * Gets status
     *
     * @return \OpenAPI\Client\Model\WebsiteCloneEnumStatus
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param \OpenAPI\Client\Model\WebsiteCloneEnumStatus $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets sync_php_version
     *
     * @return bool
     */
    public function getSyncPhpVersion()
    {
        return $this->container['sync_php_version'];
    }

    /**
     * Sets sync_php_version
     *
     * @param bool $sync_php_version sync_php_version
     *
     * @return self
     */
    public function setSyncPhpVersion($sync_php_version)
    {
        if (is_null($sync_php_version)) {
            throw new \InvalidArgumentException('non-nullable sync_php_version cannot be null');
        }
        $this->container['sync_php_version'] = $sync_php_version;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


