<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * DeviceCode Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 * Note: This endpoint is in beta.
 */
class DeviceCode implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'code' => 'string',
        'device_id' => 'string',
        'product_type' => 'string',
        'location_id' => 'string',
        'status' => 'string',
        'pair_by' => 'string',
        'created_at' => 'string',
        'status_changed_at' => 'string',
        'paired_at' => 'string'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'code' => 'code',
        'device_id' => 'device_id',
        'product_type' => 'product_type',
        'location_id' => 'location_id',
        'status' => 'status',
        'pair_by' => 'pair_by',
        'created_at' => 'created_at',
        'status_changed_at' => 'status_changed_at',
        'paired_at' => 'paired_at'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'code' => 'setCode',
        'device_id' => 'setDeviceId',
        'product_type' => 'setProductType',
        'location_id' => 'setLocationId',
        'status' => 'setStatus',
        'pair_by' => 'setPairBy',
        'created_at' => 'setCreatedAt',
        'status_changed_at' => 'setStatusChangedAt',
        'paired_at' => 'setPairedAt'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'code' => 'getCode',
        'device_id' => 'getDeviceId',
        'product_type' => 'getProductType',
        'location_id' => 'getLocationId',
        'status' => 'getStatus',
        'pair_by' => 'getPairBy',
        'created_at' => 'getCreatedAt',
        'status_changed_at' => 'getStatusChangedAt',
        'paired_at' => 'getPairedAt'
    );
  
    /**
      * $id The unique id for this device code.
      * @var string
      */
    protected $id;
    /**
      * $name An optional user-defined name for the device code.
      * @var string
      */
    protected $name;
    /**
      * $code The unique code that can be used to login.
      * @var string
      */
    protected $code;
    /**
      * $device_id The unique id of the device that used this code. Populated when the device is paired up.
      * @var string
      */
    protected $device_id;
    /**
      * $product_type The targeting product type of the device code. See [ProductType](#type-producttype) for possible values
      * @var string
      */
    protected $product_type;
    /**
      * $location_id The location assigned to this code.
      * @var string
      */
    protected $location_id;
    /**
      * $status The pairing status of the device code. See [DeviceCodeStatus](#type-devicecodestatus) for possible values
      * @var string
      */
    protected $status;
    /**
      * $pair_by When this DeviceCode will expire and no longer login. Timestamp in RFC 3339 format.
      * @var string
      */
    protected $pair_by;
    /**
      * $created_at When this DeviceCode was created. Timestamp in RFC 3339 format.
      * @var string
      */
    protected $created_at;
    /**
      * $status_changed_at When this DeviceCode's status was last changed. Timestamp in RFC 3339 format.
      * @var string
      */
    protected $status_changed_at;
    /**
      * $paired_at When this DeviceCode was paired. Timestamp in RFC 3339 format.
      * @var string
      */
    protected $paired_at;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["id"])) {
              $this->id = $data["id"];
            } else {
              $this->id = null;
            }
            if (isset($data["name"])) {
              $this->name = $data["name"];
            } else {
              $this->name = null;
            }
            if (isset($data["code"])) {
              $this->code = $data["code"];
            } else {
              $this->code = null;
            }
            if (isset($data["device_id"])) {
              $this->device_id = $data["device_id"];
            } else {
              $this->device_id = null;
            }
            if (isset($data["product_type"])) {
              $this->product_type = $data["product_type"];
            } else {
              $this->product_type = null;
            }
            if (isset($data["location_id"])) {
              $this->location_id = $data["location_id"];
            } else {
              $this->location_id = null;
            }
            if (isset($data["status"])) {
              $this->status = $data["status"];
            } else {
              $this->status = null;
            }
            if (isset($data["pair_by"])) {
              $this->pair_by = $data["pair_by"];
            } else {
              $this->pair_by = null;
            }
            if (isset($data["created_at"])) {
              $this->created_at = $data["created_at"];
            } else {
              $this->created_at = null;
            }
            if (isset($data["status_changed_at"])) {
              $this->status_changed_at = $data["status_changed_at"];
            } else {
              $this->status_changed_at = null;
            }
            if (isset($data["paired_at"])) {
              $this->paired_at = $data["paired_at"];
            } else {
              $this->paired_at = null;
            }
        }
    }
    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
  
    /**
     * Sets id
     * @param string $id The unique id for this device code.
     * @return $this
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
  
    /**
     * Sets name
     * @param string $name An optional user-defined name for the device code.
     * @return $this
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Gets code
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }
  
    /**
     * Sets code
     * @param string $code The unique code that can be used to login.
     * @return $this
     */
    public function setCode($code)
    {
        $this->code = $code;
        return $this;
    }
    /**
     * Gets device_id
     * @return string
     */
    public function getDeviceId()
    {
        return $this->device_id;
    }
  
    /**
     * Sets device_id
     * @param string $device_id The unique id of the device that used this code. Populated when the device is paired up.
     * @return $this
     */
    public function setDeviceId($device_id)
    {
        $this->device_id = $device_id;
        return $this;
    }
    /**
     * Gets product_type
     * @return string
     */
    public function getProductType()
    {
        return $this->product_type;
    }
  
    /**
     * Sets product_type
     * @param string $product_type The targeting product type of the device code. See [ProductType](#type-producttype) for possible values
     * @return $this
     */
    public function setProductType($product_type)
    {
        $this->product_type = $product_type;
        return $this;
    }
    /**
     * Gets location_id
     * @return string
     */
    public function getLocationId()
    {
        return $this->location_id;
    }
  
    /**
     * Sets location_id
     * @param string $location_id The location assigned to this code.
     * @return $this
     */
    public function setLocationId($location_id)
    {
        $this->location_id = $location_id;
        return $this;
    }
    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
  
    /**
     * Sets status
     * @param string $status The pairing status of the device code. See [DeviceCodeStatus](#type-devicecodestatus) for possible values
     * @return $this
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Gets pair_by
     * @return string
     */
    public function getPairBy()
    {
        return $this->pair_by;
    }
  
    /**
     * Sets pair_by
     * @param string $pair_by When this DeviceCode will expire and no longer login. Timestamp in RFC 3339 format.
     * @return $this
     */
    public function setPairBy($pair_by)
    {
        $this->pair_by = $pair_by;
        return $this;
    }
    /**
     * Gets created_at
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->created_at;
    }
  
    /**
     * Sets created_at
     * @param string $created_at When this DeviceCode was created. Timestamp in RFC 3339 format.
     * @return $this
     */
    public function setCreatedAt($created_at)
    {
        $this->created_at = $created_at;
        return $this;
    }
    /**
     * Gets status_changed_at
     * @return string
     */
    public function getStatusChangedAt()
    {
        return $this->status_changed_at;
    }
  
    /**
     * Sets status_changed_at
     * @param string $status_changed_at When this DeviceCode's status was last changed. Timestamp in RFC 3339 format.
     * @return $this
     */
    public function setStatusChangedAt($status_changed_at)
    {
        $this->status_changed_at = $status_changed_at;
        return $this;
    }
    /**
     * Gets paired_at
     * @return string
     */
    public function getPairedAt()
    {
        return $this->paired_at;
    }
  
    /**
     * Sets paired_at
     * @param string $paired_at When this DeviceCode was paired. Timestamp in RFC 3339 format.
     * @return $this
     */
    public function setPairedAt($paired_at)
    {
        $this->paired_at = $paired_at;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
