/*
 * Hello Bar JavaScript Solo 1.0
 *
 * Copyright (c) 2011, digital-telepathy. All rights reserved.
 *
 * 1. Redistribution and modification
 * Redistribution and use in source and binary forms, without the express
 * consent of digital-telepathy is strictly prohibited.
 *
 * 2. Disclaimer of Warranties
 * YOU EXPRESSLY ACKNOWLEDGE AND AGREE THAT THE USE OF THE HELLO BAR SOFTWARE
 * IS AT YOUR SOLE RISK AND THAT RISK IS ACCEPTABLE TO YOU. THE SOFTWARE IS
 * PROVIDED "AS IS," WITH ALL FAULTS AND WITHOUT WARRANTY OF ANY KIND.
 * DIGITAL-TELEPATHY HEREBY DISCLAIM ALL WARRANTIES AND CONDITIONS WITH RESPECT
 * TO THE HELLO BAR SOFTWARE, EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES AND/OR CONDITIONS OF MERCHANTABILITY,
 * OF SATISFACTORY QUALITY , OF FITNESS FOR A PARTICULAR PURPOSE, OF ACCURACY AND
 * NON-INFRIGEMENT OF THIRD-PARTY RIGHTS. DT DOES NOT WARRANT THAT THE HELLO BAR
 * SOFTWARE WILL MEET YOUR REQUIREMENTS, WILL BE UNINTERRUPTED OR ERROR-FREE,
 * OR THAT THE SOFTWARE WILL BE COMPATIBLE WITH OTHER THIRD PARTY SOFTWARE,
 * SERVERS OR PLATFORMS. THIS AGREEMENT SUPERCEDES ALL CLAIMS MADE ORALLY OR IN
 * WRITING OUTSIDE OF THIS AGREEMENT.
 *
 * 3. Limitation on Liability
 * TO THE EXTENT NOT PROHIBITED BY LAW, IN NO EVENT SHALL DIGITAL-TELEPATHY BE
 * LIABLE FOR PERSONAL INJURY, OR ANY INCIDENTAL, SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES WHATSOEVER, INCLUDING, WITHOUT LIMITATION, DAMAGES FOR
 * LOSS OF PROFITS, LOSS OF DATA, BUSINESS INTERRUPTION OR ANY OTHER COMMERCIAL
 * DAMAGES OR LOSSES, ARISING OUT OF OR RELATED TO YOUR USE OR INABILITY TO USE
 * THE HELLO BAR SOFTWARE, HOWEVER CAUSED, REGARDLESS OF THE THEORY OF LIABILITY
 * (CONTRACT, TORT OR OTHERWISE). Some jurisdictions do not allow for the
 * limitation of liability for personal injury or of incidental or consequential
 * damages, so this limitation may not apply to you. In no event shall
 * digital-telepathy's aggregate liability to you for all damages exceed the
 * amount paid for the software license (other than as may be required by
 * applicable law in certain jurisdictions).
 *
 * Settings format:
 * positioning string [sticky] (sticky | overlap | fixed | push)
 * tabSide string [right] ('left | right')
 * barColor string [#eb593c] (CSS String: #ff0000 | rgb(255,0,0) )
 * textColor string [#ffffff] (CSS String: #ff0000 | rgb(255,0,0) )
 * linkColor string [#80ccff] (CSS String: #ff0000 | rgb(255,0,0) )
 * borderColor string [#ffffff] (CSS String: #ff0000 | rgb(255,0,0) )
 * borderSize integer [3] (pixels)
 * texture string (noise | hard-shine | light-gradient | dark-gradient | carbon | paper | diagonal | linen | stitch | diamond)
 * height integer [30] (pixels)
 * showWait integer [0] (milliseconds)
 * hideAfter integer [-1] (milliseconds)
 * wiggleWait integer [15000] (milliseconds)
 * fontSize string (CSS String: 20px, 2em, etc)
 * lineHeight string (CSS String: 20px, 2em, etc)
 * fontWeight string (CSS String: normal | bold | 100 | 400 | 900 )
 * fontStyle string (CSS String: normal | italic | oblique )
 * fontFamily string (CSS Font Stack: 'Georgia, Times New Roman, serif')
 * googleFont string (Font Name, takes priority: 'Ubuntu' | 'Lobster+Two:400,700')
 * tabRadius string [from CSS] (CSS String: 20px, 2em, etc)
 * speed integer [500] (milliseconds)
 * helloBarLogo boolean [true]
 * shadow boolean [true]
 * forgetful boolean [false]
 * transition string [bouncy] (An animator.js[http://berniesumption.com/software/animator/] Transition: easeInOut | linear | easeIn | strongEaseIn | easeOut | strongEaseOut | elastic | veryElastic | bouncy | veryBouncy )
 *
 */
var HelloBar=function(message,atts,version_id){var self=this,_url="http://www.hellobar.com",_tagline="The HelloBar - a little bar that gets noticed!",_ns="hellobar",_sessionBegin,_opts={},_defaultBarHeight=30,_defaultBarBorderSize=3,_shadowSize=5,_defaults={afterOpen:null,afterClose:null,onOpen:null,onClose:null,onReady:null,height:_defaultBarHeight,borderSize:_defaultBarBorderSize,showWait:0,hideAfter:-1,wiggleWait:15000,barColor:'#eb593c',shadow:true,textColor:'#ffffff',linkColor:'#80ccff',linkStyle:'button',forgetful:false,positioning:'sticky',transition:'bouncy',speed:500,closable:true,helloBarLogo:true,tabSide:'right',showTabInstantly:false,texture:''};var _show=true,_alreadyShown=false,_isOpen=self.isOpen=true,_els=['wrapper','container','content','shadow','logo','close','open','pusher'],_ids={},_atts={wrapper:{type:'DIV',style:'display:none;'},container:{type:'DIV'},content:{type:'DIV'},shadow:{type:'DIV'},close:{type:'A',href:"#close",text:"Close",onclick:function(){self.close();return false},onmouseover:function(){openCloseOver()},onmouseout:function(){openCloseOut()}},open:{type:'A',href:"#close",text:"Open",onclick:function(){self.open();return false},onmouseover:function(){openCloseOver()},onmouseout:function(){openCloseOut()}},pusher:{type:'DIV'}};var UA=navigator.userAgent.toLowerCase(),Browser={chrome:UA.match(/chrome/)?true:false,firefox:UA.match(/firefox/)?true:false,firefox2:UA.match(/firefox\/2/)?true:false,firefox30:UA.match(/firefox\/3\.[0-9]/)?true:false,firefox40:UA.match(/firefox\/4\.[0-9]/)?true:false,msie:UA.match(/msie/)?true:false,msie6:(UA.match(/msie 6/)&&!UA.match(/msie 7|8/))?true:false,msie7:UA.match(/msie 7/)?true:false,msie8:UA.match(/msie 8/)?true:false,chromeFrame:(UA.match(/msie/)&&UA.match(/chrome/))?true:false,opera:UA.match(/opera/)?true:false,safari:(UA.match(/safari/)&&!UA.match(/chrome/))?true:false};function build(){var elements={};for(var i=0;i<_els.length;i++){var el=_els[i],valid=true;if(_opts.closable===false){if(el=='close'||el=='open'){valid=false}}if(typeof(_opts.helloBarLogo)!='undefined'){if(_opts.helloBarLogo){if(el=='logo'){valid=true}}}if(valid===true){var element;for(var a in _atts[el]){var val=_atts[el][a];switch(a){case "type":element=document.createElement(val);break;case "text":element.appendChild(document.createTextNode(val));break;case "onclick":element.onclick=val;break;case "onmouseover":element.onmouseover=val;break;case "onmouseout":element.onmouseout=val;break;default:element.setAttribute(a,val);break}}element.id=_ids[el];elements[el]=element}}if(_show===false){elements.container.style.top=(0-(_opts.height+_opts.borderSize))+"px"}if(_opts.positioning=='fixed'||_opts.positioning=='sticky'){if(Browser.msie6){_opts.positioning='overlap';elements.pusher.style.display="none"}}switch(_opts.positioning){case 'push':break;case 'overlap':elements.wrapper.style.position="absolute";elements.wrapper.style.width="100%";elements.wrapper.style.top="0";elements.wrapper.style.left="0";elements.wrapper.style.zIndex="5000";break;case 'fixed':elements.wrapper.style.position="fixed";elements.wrapper.style.width="100%";elements.wrapper.style.top="0";elements.wrapper.style.left="0";elements.wrapper.style.zIndex="5000";break;case 'sticky':elements.wrapper.style.position="fixed";elements.wrapper.style.width="100%";elements.wrapper.style.top="0";elements.wrapper.style.left="0";elements.wrapper.style.zIndex="5000";break}elements.container.style.height=_opts.height+"px";elements.wrapper.style.height=_opts.height+"px";elements.pusher.style.height=_opts.height+"px";if(_opts.height<60){if(typeof(_opts.helloBarLogo)!='undefined'){if(_opts.helloBarLogo){elements.logo.style.marginTop='-11px';elements.logo.style.top='50%'}}if(elements.close){elements.close.style.marginTop='-10px';elements.close.style.top='50%'}}if(typeof(_opts.texture)!='undefined'){if(_opts.texture!==""){var containerClasses=elements.container.className.split(" ");containerClasses.push('texture');containerClasses.push(_opts.texture);elements.container.className=containerClasses.join(" ")}}if(typeof(_opts.tabRadius)!='undefined'){if(_opts.tabRadius!==""){var browsers=['borderRadius','mozBorderRadius','webkitBorderRadius','oBorderRadius','khtmlBorderRadius'];for(var k in browsers){if(typeof(document.body.style[browsers[k]])!=='undefined'){elements.open.style[browsers[k]]=_opts.tabRadius}}}}if(typeof(_opts.borderSize)!='undefined'){if(_opts.borderSize!==""){elements.container.style.borderBottomWidth=_opts.borderSize+'px';elements.shadow.style.bottom=(0-(_opts.borderSize+_shadowSize))+'px';if(elements.open){elements.open.style.borderWidth=_opts.borderSize+'px'}}}if(typeof(_opts.borderColor)!='undefined'){if(_opts.borderColor!==""){elements.container.style.borderBottomColor=_opts.borderColor;elements.open.style.borderColor=_opts.borderColor}}if(typeof(_opts.shadow)!='undefined'){if(!_opts.shadow){elements.shadow.style.display='none'}}if(typeof(_opts.barColor)!='undefined'){if(_opts.barColor!==""){brightnessCheck(_opts.barColor);elements.container.style.backgroundColor=_opts.barColor;if(elements.open){elements.open.style.backgroundColor=_opts.barColor}}}if(typeof(_opts.textColor)!='undefined'){if(_opts.textColor!==""){elements.container.style.color=_opts.textColor}}if(typeof(_opts.fontWeight)!='undefined'){if(_opts.fontWeight!==""){elements.container.style.fontWeight=_opts.fontWeight}}if(typeof(_opts.fontStyle)!='undefined'){if(_opts.fontStyle!==""){elements.container.style.fontStyle=_opts.fontStyle}}if(typeof(_opts.lineHeight)!='undefined'){if(_opts.lineHeight!==""){elements.container.style.lineHeight=_opts.lineHeight}}else{elements.container.style.lineHeight=_opts.height+"px"}if(typeof(_opts.fontSize)!='undefined'){if(_opts.fontSize!==""){elements.container.style.fontSize=_opts.fontSize}}if(typeof(_opts.fonts)!='undefined'){if(_opts.fonts!==""){elements.container.style.fontFamily=_opts.fonts}}if(typeof(_opts.googleFont)!='undefined'){if(_opts.googleFont!==""){if(typeof(WebFontConfig)=='undefined'){WebFontConfig={google:{families:[_opts.googleFont]}};(function(){var hb_wf=document.createElement('script');hb_wf.src=('https:'==document.location.protocol?'https':'http')+'://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';hb_wf.type='text/javascript';hb_wf.async='true';var s=document.getElementsByTagName('script')[0];s.parentNode.insertBefore(hb_wf,s)})()}elements.container.style.fontFamily=_opts.googleFont.split(':')[0].replace(/\+/g,' ')}}var wrapperClasses=elements.wrapper.className.split(" ");wrapperClasses.push(_ns+'-'+_opts.tabSide);wrapperClasses.push(_ns+'-'+_opts.imageStyle);if(_opts.linkStyle!='link'){wrapperClasses.push(_ns+'-'+_opts.linkStyle)}elements.wrapper.className=wrapperClasses.join(" ");elements.content.innerHTML=unescape(self.message.replace(/\+/g," "));elements.container.appendChild(elements.content);if(typeof(_opts.helloBarLogo)!='undefined'){if(_opts.helloBarLogo){elements.container.appendChild(elements.logo)}}if(typeof(elements.logo)!='undefined'){elements.logo.href=elements.logo.href+="?utm_source="+document.location.hostname+"&utm_medium=hellobar&utm_campaign=HBSolo"}if(_opts.closable===true){elements.container.appendChild(elements.close)}elements.container.appendChild(elements.shadow);elements.wrapper.appendChild(elements.container);if(_opts.closable===true){elements.wrapper.appendChild(elements.open)}document.body.children[0].parentNode.insertBefore(elements.wrapper,document.body.children[0]);if(_opts.positioning=='sticky'){document.body.children[0].parentNode.insertBefore(elements.pusher,document.body.children[0])}var links=document.getElementById('hellobar-container').getElementsByTagName('A');for(var l in links){var link=links[l],oldOnClick=null;if(typeof(oldOnClick)=='function'){oldOnClick()}if(link.id===""){if(typeof(_opts.linkColor)!='undefined'){if(_opts.linkColor!==""){link.style.color=_opts.linkColor}}link.onclick=function(){if(typeof(oldOnClick)=='function'){oldOnClick()}}}else if(link.id==_ns+'-logo'){link.onclick=function(){if(typeof(oldOnClick)=='function'){oldOnClick()}return false}}}}function getCookie(){var cookies=document.cookie.split("; ");for(var i=0;i<cookies.length;i++){var key=cookies[i].split('=')[0],val=cookies[i].split('=')[1];if(key==_ns+"_"+version_id+"_hide"){_show=val==1?false:true}if(key==_ns+"_"+version_id+"_shown"){_alreadyShown=val==1?true:false}}}function setCookie(cookiename,val,clearCookie){if(_opts.forgetful===true){return false}var expireOnSessionClose=false,date=new Date(),days=['Sun','Mon','Tue','Wed','Thu','Fri','Sat'],months=['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Nov','Dec'],D=new Date(date.getTime()+(365*86400000));if(typeof(clearCookie)!='undefined'){if(clearCookie===true){D=new Date(date.getTime()-(1*86400000))}if(clearCookie=='this_session'){expireOnSessionClose=true}}var dateStr=days[D.getUTCDay()]+", "+D.getUTCDate()+" "+months[D.getUTCMonth()]+" "+D.getUTCFullYear()+" "+D.getUTCHours()+":"+D.getUTCMinutes()+":"+D.getUTCSeconds()+" UTC";if(expireOnSessionClose){document.cookie=cookiename+"="+val+"; path=/"}else{document.cookie=cookiename+"="+val+"; expires="+dateStr+"; path=/"}}function close(callback){if(_isOpen){setCookie(_ns+"_"+version_id+"_hide",1);setCookie(_ns+"_"+version_id+"_shown",0,'this_session');if(typeof(_opts.onClose)=='function'){_opts.onClose(self,_opts,"onClose")}showTab(hideBar(function(){if(typeof(_opts.afterClose)=='function'){_opts.afterClose(self,_opts,"afterClose")}if(typeof(callback)=='function'){callback(self,_opts,"afterClose")}}));_isOpen=self.isOpen=false}}function open(callback){if(!_isOpen){if(_opts.hideAfter<_opts.showWait){clearInterval(window._hellobar_wiggleWaitTimer);clearTimeout(window._hellobar_hideAfterTimer)}setCookie(_ns+"_"+version_id+"_hide",0,true);setCookie(_ns+"_"+version_id+"_shown",1,'this_session');if(typeof(_opts.onOpen)=='function'){_opts.onOpen(self,_opts,"onOpen")}hideTab(showBar(function(){if(typeof(_opts.afterOpen)=='function'){_opts.afterOpen(self,_opts,"afterOpen")}if(typeof(callback)=='function'){callback(self,_opts,"afterOpen")}}));_isOpen=self.isOpen=true}}function openCloseOver(){self.elements.open.style.backgroundColor=brightenAndReturnRGB(_opts.barColor)}function openCloseOut(){self.elements.open.style.backgroundColor=_opts.barColor}function wiggleMe(){var wiggles=3;return function(pos){return((-Math.cos(pos*Math.PI*((1+(2*wiggles))*pos))/2)+0.5)}}function wiggle(){var animator=new Animator({transition:wiggleMe(),duration:500}).addSubject(new NumericalStyleSubject(self.elements.open,'right',10,13));animator.play()}function startWiggling(){if(_opts.wiggleWait>0){window._hellobar_wiggleWaitTimer="";window._hellobar_wiggleWaitTimer=setInterval(function(){wiggle()},_opts.wiggleWait)}}function showTab(callback){var animator=new Animator({transition:Animator.tx[_opts.transition],duration:_opts.speed,onComplete:function(){if(typeof(callback)=='function'){callback()}}}).addSubject(new NumericalStyleSubject(self.elements.open,'top',-96,-50));animator.play()}function showTabInstantly(){self.elements.open.style.top='-50px'}function hideTab(callback){var animator=new Animator({transition:Animator.tx[_opts.transition],duration:_opts.speed,onComplete:function(){if(typeof(callback)=='function'){callback()}}}).addSubject(new NumericalStyleSubject(self.elements.open,'top',-50,-96));animator.play()}function showBar(callback){var animator=new Animator({transition:Animator.tx[_opts.transition],duration:_opts.speed,onComplete:function(){callback(self,_opts,"afterOpen")}}).addSubject(new NumericalStyleSubject(self.elements.wrapper,'height',0,(_opts.height+_opts.borderSize))).addSubject(new NumericalStyleSubject(self.elements.container,'top',(0-(_opts.height+_opts.borderSize+_shadowSize)),0));if(_opts.positioning=='sticky'){animator.addSubject(new NumericalStyleSubject(self.elements.pusher,'height',0,(_opts.height+_opts.borderSize)))}animator.play()}function hideBar(callback){var animator=new Animator({transition:Animator.tx.easeOut,duration:_opts.speed,onComplete:function(){callback(self,_opts,"afterClose")}}).addSubject(new NumericalStyleSubject(self.elements.wrapper,'height',(_opts.height+_opts.borderSize),0)).addSubject(new NumericalStyleSubject(self.elements.container,'top',0,(0-(_opts.height+_opts.borderSize+_shadowSize))));if(_opts.positioning=='sticky'){animator.addSubject(new NumericalStyleSubject(self.elements.pusher,'height',(_opts.height+_opts.borderSize),0))}animator.play()}function cleanHexColor(hex){if(!hex.match('^#')){hex='#'+hex}if(hex.length==4){return'#'+hex.substr(1,3)+hex.substr(1,3)}return hex}function hex2rgb(hex){return new RGBColor(hex)}function isRGB(color){if(color.match('^rgb')){return true}else{return false}}function cleanRGB(rgba){var parts=rgba.match(/((\d+)?\.?\d+)/g);return{r:parts[0],g:parts[1],b:parts[2]};}function darkImages(color){if(isRGB(color)){rgb=cleanRGB(color)}else{hex=cleanHexColor(color);rgb=hex2rgb(hex)}if(rgb){var result=((rgb.r*299)+(rgb.g*587)+(rgb.b*114))/1000;if(result>125){return true}else{return false}}}function brightnessCheck(color){if(darkImages(color)){_opts.imageStyle='dark-images'}else{_opts.imageStyle='light-images'}}function brightenAndReturnRGB(color){if(isRGB(color)){rgb=cleanRGB(color)}else{hex=cleanHexColor(color);rgb=hex2rgb(hex)}if(darkImages(color)){var boost=38;return "rgb("+Math.min(rgb.r+boost,255)+","+Math.min(rgb.g+boost,255)+","+Math.min(rgb.b+boost,255)+")"}else{var boost=(0-38);return "rgb("+Math.max(rgb.r+boost,0)+","+Math.max(rgb.g+boost,0)+","+Math.max(rgb.b+boost,0)+")"}var boost=38;return "rgb("+Math.min(rgb.r+boost,255)+","+Math.min(rgb.g+boost,255)+","+Math.min(rgb.b+boost,255)+")"}function generateTimestamp(){var timestamp=Math.floor(new Date().getTime()/1000);return timestamp}this.close=function(callback){close(callback);return false};this.open=function(callback){open(callback);clearTimeout(window._hellobar_wiggleWaitTimer);return false};function initialize(message,atts,version_id){self.message=message;if(document.getElementById('hellobar-wrapper')){document.getElementById('hellobar-wrapper').parentNode.removeChild(document.getElementById('hellobar-wrapper'))}if(document.getElementById('hellobar-pusher')){document.getElementById('hellobar-pusher').parentNode.removeChild(document.getElementById('hellobar-pusher'))}clearTimeout(window._hellobar_showWaitTimer);clearTimeout(window._hellobar_hideAfterTimer);clearTimeout(window._hellobar_wiggleWaitTimer);var currentCookieMatch=document.cookie.match(/hellobar_current\=([0-9]+)/);if(currentCookieMatch){var currentCookieId=currentCookieMatch[1];if(parseInt(currentCookieId,10)!=parseInt(version_id,10)){var oldCookies=document.cookie.match(/hellobar_([0-9]+)_(variation|hide|shown)/g);for(var cookie in oldCookies){var oldCookie=oldCookies[cookie];setCookie(oldCookie,0,true)}setCookie('hellobar_current',0,true)}}setCookie('hellobar_current',version_id);_sessionBegin=generateTimestamp();for(var i in _els){keyname=_els[i];_ids[keyname]=[_ns,keyname].join('-')}for(var k in _defaults){_opts[k]=_defaults[k]}if(typeof(atts)!='undefined'){for(var k in atts){_opts[k]=atts[k]}}if(typeof(_opts.hideDestination)!='undefined'){if(_opts.hideDestination==1&&document.location.href==_opts.destinationUrl){return false}}if(_opts.forgetful===false){getCookie()}else{startWiggling()}_opts.height=Math.max(_opts.height,_defaultBarHeight);if(_opts.height>_defaultBarHeight){_opts.texture=''}if(!document.getElementById(_ids.wrapper)){build();self.elements={};for(var i=0;i<_els.length;i++){var _slug=_els[i];self.elements[_slug]=document.getElementById(_ids[_slug])}document.getElementById(_ids.wrapper).hellobar=self;if(typeof(_opts.onReady)=='function'){_opts.onReady(self,_opts,"onReady")}}if(_show===true&&_alreadyShown===true){self.elements.wrapper.style.display="block";self.elements.container.style.top="0px";self.elements.wrapper.style.height=(_opts.height+_opts.borderSize)+"px";if(_opts.positioning=='sticky'){self.elements.pusher.style.height=(0-(_opts.height+_opts.borderSize))+"px"}}self.elements.wrapper.style.display="block";if(_show===true){if(self.elements.open){self.elements.open.style.top="-96px"}if(_alreadyShown!==true){if(_opts.showWait>0){if((_opts.showWait<_opts.hideAfter)||(_opts.hideAfter<0)){self.elements.container.style.top=(0-(_opts.height+_opts.borderSize+_shadowSize))+"px";self.elements.wrapper.style.height="0px";if(_opts.positioning=='sticky'){self.elements.pusher.style.height="0px"}if(_opts.showTabInstantly){showTabInstantly()}else{showTab()}_isOpen=self.isOpen=false}window._hellobar_showWaitTimer="";window._hellobar_showWaitTimer=setTimeout(function(){open()},_opts.showWait)}else{open()}}if(_opts.hideAfter>0){_opts.hideAfter=_opts.hideAfter+_opts.showWait;window._hellobar_hideAfterTimer="";window._hellobar_hideAfterTimer=setTimeout(function(){close()},_opts.hideAfter)}}else{self.elements.container.style.top=(0-(_opts.height+_opts.borderSize+_shadowSize))+"px";self.elements.wrapper.style.height="0px";if(_opts.positioning=='sticky'){self.elements.pusher.style.height="0px"}showTab();_isOpen=self.isOpen=false;startWiggling()}}initialize(message,atts,version_id)};

/*
    Animator.js 1.1.11

    This library is released under the BSD license:

    Copyright (c) 2006, Bernard Sumption. All rights reserved.

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this
    list of conditions and the following disclaimer. Redistributions in binary
    form must reproduce the above copyright notice, this list of conditions and
    the following disclaimer in the documentation and/or other materials
    provided with the distribution. Neither the name BernieCode nor
    the names of its contributors may be used to endorse or promote products
    derived from this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
    ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
    DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
    SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
    OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
    DAMAGE.

*/
function Animator(a){this.setOptions(a);var b=this;this.timerDelegate=function(){b.onTimerEvent()};this.subjects=[];this.state=this.target=0;this.lastTime=null} Animator.prototype={setOptions:function(a){this.options=Animator.applyDefaults({interval:20,duration:400,onComplete:function(){},onStep:function(){},transition:Animator.tx.easeInOut},a)},seekTo:function(a){this.seekFromTo(this.state,a)},seekFromTo:function(a,b){this.target=Math.max(0,Math.min(1,b));this.state=Math.max(0,Math.min(1,a));this.lastTime=(new Date).getTime();if(!this.intervalId)this.intervalId=window.setInterval(this.timerDelegate,this.options.interval)},jumpTo:function(a){this.target= this.state=Math.max(0,Math.min(1,a));this.propagate()},toggle:function(){this.seekTo(1-this.target)},addSubject:function(a){this.subjects[this.subjects.length]=a;return this},clearSubjects:function(){this.subjects=[]},propagate:function(){for(var a=this.options.transition(this.state),b=0;b<this.subjects.length;b++)if(this.subjects[b].setState)this.subjects[b].setState(a);else this.subjects[b](a)},onTimerEvent:function(){var a=(new Date).getTime(),b=a-this.lastTime;this.lastTime=a;a=b/this.options.duration* (this.state<this.target?1:-1);Math.abs(a)>=Math.abs(this.state-this.target)?this.state=this.target:this.state+=a;try{this.propagate()}finally{this.options.onStep.call(this),this.target==this.state&&this.stop()}},stop:function(){if(this.intervalId)window.clearInterval(this.intervalId),this.intervalId=null,this.options.onComplete.call(this)},play:function(){this.seekFromTo(0,1)},reverse:function(){this.seekFromTo(1,0)},inspect:function(){for(var a="#<Animator:\n",b=0;b<this.subjects.length;b++)a+=this.subjects[b].inspect(); a+=">";return a}};Animator.applyDefaults=function(a,b){var b=b||{},c,d={};for(c in a)d[c]=b[c]!==void 0?b[c]:a[c];return d};Animator.makeArrayOfElements=function(a){if(a==null)return[];if("string"==typeof a)return[document.getElementById(a)];if(!a.length)return[a];for(var b=[],c=0;c<a.length;c++)b[c]="string"==typeof a[c]?document.getElementById(a[c]):a[c];return b}; Animator.camelize=function(a){var b=a.split("-");if(b.length==1)return b[0];for(var a=a.indexOf("-")==0?b[0].charAt(0).toUpperCase()+b[0].substring(1):b[0],c=1,d=b.length;c<d;c++){var e=b[c];a+=e.charAt(0).toUpperCase()+e.substring(1)}return a};Animator.apply=function(a,b,c){if(b instanceof Array)return(new Animator(c)).addSubject(new CSSStyleSubject(a,b[0],b[1]));return(new Animator(c)).addSubject(new CSSStyleSubject(a,b))};Animator.makeEaseIn=function(a){return function(b){return Math.pow(b,a*2)}}; Animator.makeEaseOut=function(a){return function(b){return 1-Math.pow(1-b,a*2)}};Animator.makeElastic=function(a){return function(b){b=Animator.tx.easeInOut(b);return(1-Math.cos(b*Math.PI*a))*(1-b)+b}};Animator.makeADSR=function(a,b,c,d){d==null&&(d=0.5);return function(e){if(e<a)return e/a;if(e<b)return 1-(e-a)/(b-a)*(1-d);if(e<c)return d;return d*(1-(e-c)/(1-c))}};Animator.makeBounce=function(a){var b=Animator.makeElastic(a);return function(a){a=b(a);return a<=1?a:2-a}}; Animator.tx={easeInOut:function(a){return-Math.cos(a*Math.PI)/2+0.5},linear:function(a){return a},easeIn:Animator.makeEaseIn(1.5),easeOut:Animator.makeEaseOut(1.5),strongEaseIn:Animator.makeEaseIn(2.5),strongEaseOut:Animator.makeEaseOut(2.5),elastic:Animator.makeElastic(1),veryElastic:Animator.makeElastic(3),bouncy:Animator.makeBounce(1),veryBouncy:Animator.makeBounce(3)}; function NumericalStyleSubject(a,b,c,d,e){this.els=Animator.makeArrayOfElements(a);this.property=b=="opacity"&&window.ActiveXObject?"filter":Animator.camelize(b);this.from=parseFloat(c);this.to=parseFloat(d);this.units=e!=null?e:"px"} NumericalStyleSubject.prototype={setState:function(a){for(var a=this.getStyle(a),b=0,c=0;c<this.els.length;c++){try{this.els[c].style[this.property]=a}catch(d){if(this.property!="fontWeight")throw d;}if(b++>20)break}},getStyle:function(a){a=this.from+(this.to-this.from)*a;if(this.property=="filter")return"alpha(opacity="+Math.round(a*100)+")";if(this.property=="opacity")return a;return Math.round(a)+this.units},inspect:function(){return"\t"+this.property+"("+this.from+this.units+" to "+this.to+this.units+ ")\n"}};function ColorStyleSubject(a,b,c,d){this.els=Animator.makeArrayOfElements(a);this.property=Animator.camelize(b);this.to=this.expandColor(d);this.from=this.expandColor(c);this.origFrom=c;this.origTo=d} ColorStyleSubject.prototype={expandColor:function(a){var b,c;if(b=ColorStyleSubject.parseColor(a))return a=parseInt(b.slice(1,3),16),c=parseInt(b.slice(3,5),16),b=parseInt(b.slice(5,7),16),[a,c,b];window.ANIMATOR_DEBUG&&alert("Invalid colour: '"+a+"'")},getValueForState:function(a,b){return Math.round(this.from[a]+(this.to[a]-this.from[a])*b)},setState:function(a){for(var a="#"+ColorStyleSubject.toColorPart(this.getValueForState(0,a))+ColorStyleSubject.toColorPart(this.getValueForState(1,a))+ColorStyleSubject.toColorPart(this.getValueForState(2, a)),b=0;b<this.els.length;b++)this.els[b].style[this.property]=a},inspect:function(){return"\t"+this.property+"("+this.origFrom+" to "+this.origTo+")\n"}}; ColorStyleSubject.parseColor=function(a){var b="#",c;if(c=ColorStyleSubject.parseColor.rgbRe.exec(a)){for(var d=1;d<=3;d++)a=Math.max(0,Math.min(255,parseInt(c[d]))),b+=ColorStyleSubject.toColorPart(a);return b}if(c=ColorStyleSubject.parseColor.hexRe.exec(a)){if(c[1].length==3){for(d=0;d<3;d++)b+=c[1].charAt(d)+c[1].charAt(d);return b}return"#"+c[1]}return!1};ColorStyleSubject.toColorPart=function(a){a>255&&(a=255);var b=a.toString(16);if(a<16)return"0"+b;return b}; ColorStyleSubject.parseColor.rgbRe=/^rgb\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)$/i;ColorStyleSubject.parseColor.hexRe=/^\#([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/;function DiscreteStyleSubject(a,b,c,d,e){this.els=Animator.makeArrayOfElements(a);this.property=Animator.camelize(b);this.from=c;this.to=d;this.threshold=e||0.5} DiscreteStyleSubject.prototype={setState:function(a){for(var b=0;b<this.els.length;b++)this.els[b].style[this.property]=a<=this.threshold?this.from:this.to},inspect:function(){return"\t"+this.property+"("+this.from+" to "+this.to+" @ "+this.threshold+")\n"}}; function CSSStyleSubject(a,b,c){a=Animator.makeArrayOfElements(a);this.subjects=[];if(a.length!=0){var d;if(c)b=this.parseStyle(b,a[0]),c=this.parseStyle(c,a[0]);else for(d in c=this.parseStyle(b,a[0]),b={},c)b[d]=CSSStyleSubject.getStyle(a[0],d);for(d in b)b[d]==c[d]&&(delete b[d],delete c[d]);var e,f,h,j;for(d in b){var i=String(b[d]),g=String(c[d]);if(c[d]==null)window.ANIMATOR_DEBUG&&alert("No to style provided for '"+d+'"');else{if(h=ColorStyleSubject.parseColor(i))j=ColorStyleSubject.parseColor(g), f=ColorStyleSubject;else if(i.match(CSSStyleSubject.numericalRe)&&g.match(CSSStyleSubject.numericalRe))h=parseFloat(i),j=parseFloat(g),f=NumericalStyleSubject,e=CSSStyleSubject.numericalRe.exec(i),g=CSSStyleSubject.numericalRe.exec(g),e=e[1]!=null?e[1]:g[1]!=null?g[1]:g;else if(i.match(CSSStyleSubject.discreteRe)&&g.match(CSSStyleSubject.discreteRe))h=i,j=g,f=DiscreteStyleSubject,e=0;else{window.ANIMATOR_DEBUG&&alert("Unrecognised format for value of "+d+": '"+b[d]+"'");continue}this.subjects[this.subjects.length]= new f(a,d,h,j,e)}}}} CSSStyleSubject.prototype={parseStyle:function(a,b){var c={};if(a.indexOf(":")!=-1)for(var d=a.split(";"),e=0;e<d.length;e++){var f=CSSStyleSubject.ruleRe.exec(d[e]);f&&(c[f[1]]=f[2])}else{var h;h=b.className;b.className=a;for(e=0;e<CSSStyleSubject.cssProperties.length;e++)d=CSSStyleSubject.cssProperties[e],f=CSSStyleSubject.getStyle(b,d),f!=null&&(c[d]=f);b.className=h}return c},setState:function(a){for(var b=0;b<this.subjects.length;b++)this.subjects[b].setState(a)},inspect:function(){for(var a="", b=0;b<this.subjects.length;b++)a+=this.subjects[b].inspect();return a}};CSSStyleSubject.getStyle=function(a,b){var c;if(document.defaultView&&document.defaultView.getComputedStyle&&(c=document.defaultView.getComputedStyle(a,"").getPropertyValue(b)))return c;b=Animator.camelize(b);a.currentStyle&&(c=a.currentStyle[b]);return c||a.style[b]};CSSStyleSubject.ruleRe=/^\s*([a-zA-Z\-]+)\s*:\s*(\S(.+\S)?)\s*$/;CSSStyleSubject.numericalRe=/^-?\d+(?:\.\d+)?(%|[a-zA-Z]{2})?$/;CSSStyleSubject.discreteRe=/^\w+$/; CSSStyleSubject.cssProperties=["azimuth","background","background-attachment","background-color","background-image","background-position","background-repeat","border-collapse","border-color","border-spacing","border-style","border-top","border-top-color","border-right-color","border-bottom-color","border-left-color","border-top-style","border-right-style","border-bottom-style","border-left-style","border-top-width","border-right-width","border-bottom-width","border-left-width","border-width","bottom", "clear","clip","color","content","cursor","direction","display","elevation","empty-cells","css-float","font","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","height","left","letter-spacing","line-height","list-style","list-style-image","list-style-position","list-style-type","margin","margin-top","margin-right","margin-bottom","margin-left","max-height","max-width","min-height","min-width","orphans","outline","outline-color","outline-style","outline-width", "overflow","padding","padding-top","padding-right","padding-bottom","padding-left","pause","position","right","size","table-layout","text-align","text-decoration","text-indent","text-shadow","text-transform","top","vertical-align","visibility","white-space","width","word-spacing","z-index","opacity","outline-offset","overflow-x","overflow-y"]; function AnimatorChain(a,b){this.animators=a;this.setOptions(b);for(var c=0;c<this.animators.length;c++)this.listenTo(this.animators[c]);this.forwards=!1;this.current=0} AnimatorChain.prototype={setOptions:function(a){this.options=Animator.applyDefaults({resetOnPlay:!0},a)},play:function(){this.forwards=!0;this.current=-1;if(this.options.resetOnPlay)for(var a=0;a<this.animators.length;a++)this.animators[a].jumpTo(0);this.advance()},reverse:function(){this.forwards=!1;this.current=this.animators.length;if(this.options.resetOnPlay)for(var a=0;a<this.animators.length;a++)this.animators[a].jumpTo(1);this.advance()},toggle:function(){this.forwards?this.seekTo(0):this.seekTo(1)}, listenTo:function(a){var b=a.options.onComplete,c=this;a.options.onComplete=function(){b&&b.call(a);c.advance()}},advance:function(){this.forwards?this.animators[this.current+1]!=null&&(this.current++,this.animators[this.current].play()):this.animators[this.current-1]!=null&&(this.current--,this.animators[this.current].reverse())},seekTo:function(a){a<=0?(this.forwards=!1,this.animators[this.current].seekTo(0)):(this.forwards=!0,this.animators[this.current].seekTo(1))}};

/**
 * A class to parse color values
 * @author Stoyan Stefanov <sstoo@gmail.com>
 * @link   http://www.phpied.com/rgb-color-parser-in-javascript/
 * @license Use it if you like it
 */
function RGBColor(color_string){this.ok=false;if(color_string.charAt(0)=='#'){color_string=color_string.substr(1,6)}color_string=color_string.replace(/ /g,'');color_string=color_string.toLowerCase();var simple_colors={aliceblue:'f0f8ff',antiquewhite:'faebd7',aqua:'00ffff',aquamarine:'7fffd4',azure:'f0ffff',beige:'f5f5dc',bisque:'ffe4c4',black:'000000',blanchedalmond:'ffebcd',blue:'0000ff',blueviolet:'8a2be2',brown:'a52a2a',burlywood:'deb887',cadetblue:'5f9ea0',chartreuse:'7fff00',chocolate:'d2691e',coral:'ff7f50',cornflowerblue:'6495ed',cornsilk:'fff8dc',crimson:'dc143c',cyan:'00ffff',darkblue:'00008b',darkcyan:'008b8b',darkgoldenrod:'b8860b',darkgray:'a9a9a9',darkgreen:'006400',darkkhaki:'bdb76b',darkmagenta:'8b008b',darkolivegreen:'556b2f',darkorange:'ff8c00',darkorchid:'9932cc',darkred:'8b0000',darksalmon:'e9967a',darkseagreen:'8fbc8f',darkslateblue:'483d8b',darkslategray:'2f4f4f',darkturquoise:'00ced1',darkviolet:'9400d3',deeppink:'ff1493',deepskyblue:'00bfff',dimgray:'696969',dodgerblue:'1e90ff',feldspar:'d19275',firebrick:'b22222',floralwhite:'fffaf0',forestgreen:'228b22',fuchsia:'ff00ff',gainsboro:'dcdcdc',ghostwhite:'f8f8ff',gold:'ffd700',goldenrod:'daa520',gray:'808080',green:'008000',greenyellow:'adff2f',honeydew:'f0fff0',hotpink:'ff69b4',indianred:'cd5c5c',indigo:'4b0082',ivory:'fffff0',khaki:'f0e68c',lavender:'e6e6fa',lavenderblush:'fff0f5',lawngreen:'7cfc00',lemonchiffon:'fffacd',lightblue:'add8e6',lightcoral:'f08080',lightcyan:'e0ffff',lightgoldenrodyellow:'fafad2',lightgrey:'d3d3d3',lightgreen:'90ee90',lightpink:'ffb6c1',lightsalmon:'ffa07a',lightseagreen:'20b2aa',lightskyblue:'87cefa',lightslateblue:'8470ff',lightslategray:'778899',lightsteelblue:'b0c4de',lightyellow:'ffffe0',lime:'00ff00',limegreen:'32cd32',linen:'faf0e6',magenta:'ff00ff',maroon:'800000',mediumaquamarine:'66cdaa',mediumblue:'0000cd',mediumorchid:'ba55d3',mediumpurple:'9370d8',mediumseagreen:'3cb371',mediumslateblue:'7b68ee',mediumspringgreen:'00fa9a',mediumturquoise:'48d1cc',mediumvioletred:'c71585',midnightblue:'191970',mintcream:'f5fffa',mistyrose:'ffe4e1',moccasin:'ffe4b5',navajowhite:'ffdead',navy:'000080',oldlace:'fdf5e6',olive:'808000',olivedrab:'6b8e23',orange:'ffa500',orangered:'ff4500',orchid:'da70d6',palegoldenrod:'eee8aa',palegreen:'98fb98',paleturquoise:'afeeee',palevioletred:'d87093',papayawhip:'ffefd5',peachpuff:'ffdab9',peru:'cd853f',pink:'ffc0cb',plum:'dda0dd',powderblue:'b0e0e6',purple:'800080',red:'ff0000',rosybrown:'bc8f8f',royalblue:'4169e1',saddlebrown:'8b4513',salmon:'fa8072',sandybrown:'f4a460',seagreen:'2e8b57',seashell:'fff5ee',sienna:'a0522d',silver:'c0c0c0',skyblue:'87ceeb',slateblue:'6a5acd',slategray:'708090',snow:'fffafa',springgreen:'00ff7f',steelblue:'4682b4',tan:'d2b48c',teal:'008080',thistle:'d8bfd8',tomato:'ff6347',turquoise:'40e0d0',violet:'ee82ee',violetred:'d02090',wheat:'f5deb3',white:'ffffff',whitesmoke:'f5f5f5',yellow:'ffff00',yellowgreen:'9acd32'};for(var key in simple_colors){if(color_string==key){color_string=simple_colors[key]}}var color_defs=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,example:['rgb(123, 234, 45)','rgb(255,234,245)'],process:function(bits){return[parseInt(bits[1]),parseInt(bits[2]),parseInt(bits[3])]}},{re:/^(\w{2})(\w{2})(\w{2})$/,example:['#00ff00','336699'],process:function(bits){return[parseInt(bits[1],16),parseInt(bits[2],16),parseInt(bits[3],16)]}},{re:/^(\w{1})(\w{1})(\w{1})$/,example:['#fb0','f0f'],process:function(bits){return[parseInt(bits[1]+bits[1],16),parseInt(bits[2]+bits[2],16),parseInt(bits[3]+bits[3],16)]}}];for(var i=0;i<color_defs.length;i++){var re=color_defs[i].re,processor=color_defs[i].process,bits=re.exec(color_string);if(bits){channels=processor(bits);this.r=channels[0];this.g=channels[1];this.b=channels[2];this.ok=true}}this.r=(this.r<0||isNaN(this.r))?0:((this.r>255)?255:this.r);this.g=(this.g<0||isNaN(this.g))?0:((this.g>255)?255:this.g);this.b=(this.b<0||isNaN(this.b))?0:((this.b>255)?255:this.b);this.toRGB=function(){return 'rgb('+this.r+', '+this.g+', '+this.b+')'};this.toHex=function(){var r=this.r.toString(16),g=this.g.toString(16),b=this.b.toString(16);if(r.length==1)r='0'+r;if(g.length==1)g='0'+g;if(b.length==1)b='0'+b;return'#'+r+g+b};this.getHelpXML=function(){var examples=new Array();for(var i=0;i<color_defs.length;i++){var example=color_defs[i].example;for(var j=0;j<example.length;j++){examples[examples.length]=example[j]}}for(var sc in simple_colors){examples[examples.length]=sc}var xml=document.createElement('ul');xml.setAttribute('id','rgbcolor-examples');for(var i=0;i<examples.length;i++){try{var list_item=document.createElement('li'),list_color=new RGBColor(examples[i]),example_div=document.createElement('div');example_div.style.cssText='margin: 3px; border: 1px solid black; background:'+list_color.toHex()+'; color:'+list_color.toHex();example_div.appendChild(document.createTextNode('test'));var list_item_value=document.createTextNode(' '+examples[i]+' -> '+list_color.toRGB()+' -> '+list_color.toHex());list_item.appendChild(example_div);list_item.appendChild(list_item_value);xml.appendChild(list_item)}catch(e){}}return xml};}