<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program. 
 * https://github.com/swagger-api/swagger-codegen 
 * Do not edit the class manually.
 */

namespace SquareConnect\Api;

use \SquareConnect\Configuration;
use \SquareConnect\ApiClient;
use \SquareConnect\ApiException;
use \SquareConnect\ObjectSerializer;

/**
 * LoyaltyApi Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://squareup.com/developers
 */
class LoyaltyApi
{

    /**
     * API Client
     * @var \SquareConnect\ApiClient instance of the ApiClient
     */
    protected $apiClient;
  
    /**
     * Constructor
     * @param \SquareConnect\ApiClient|null $apiClient The api client to use
     */
    function __construct($apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://connect.squareup.com');
        }
  
        $this->apiClient = $apiClient;
    }
  
    /**
     * Get API client
     * @return \SquareConnect\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }
  
    /**
     * Set the API client
     * @param \SquareConnect\ApiClient $apiClient set the API client
     * @return LoyaltyApi
     */
    public function setApiClient(ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }
  
    /**
     * accumulateLoyaltyPoints
     *
     * AccumulateLoyaltyPoints
     * Note: This endpoint is in beta.
     *
     * @param string $account_id The &#x60;loyalty account&#x60; ID to which to add the points. (required)
     * @param \SquareConnect\Model\AccumulateLoyaltyPointsRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return \SquareConnect\Model\AccumulateLoyaltyPointsResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function accumulateLoyaltyPoints($account_id, $body)
    {
        list($response, $statusCode, $httpHeader) = $this->accumulateLoyaltyPointsWithHttpInfo ($account_id, $body);
        return $response; 
    }


    /**
     * accumulateLoyaltyPointsWithHttpInfo
     *
     * AccumulateLoyaltyPoints
     *
     * @param string $account_id The &#x60;loyalty account&#x60; ID to which to add the points. (required)
     * @param \SquareConnect\Model\AccumulateLoyaltyPointsRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return Array of \SquareConnect\Model\AccumulateLoyaltyPointsResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function accumulateLoyaltyPointsWithHttpInfo($account_id, $body)
    {
        
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling accumulateLoyaltyPoints');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling accumulateLoyaltyPoints');
        }
  
        // parse inputs
        $resourcePath = "/v2/loyalty/accounts/{account_id}/accumulate";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "account_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\AccumulateLoyaltyPointsResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\AccumulateLoyaltyPointsResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\AccumulateLoyaltyPointsResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * adjustLoyaltyPoints
     *
     * AdjustLoyaltyPoints
     * Note: This endpoint is in beta.
     *
     * @param string $account_id The ID of the &#x60;loyalty account&#x60; in which to adjust the points. (required)
     * @param \SquareConnect\Model\AdjustLoyaltyPointsRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return \SquareConnect\Model\AdjustLoyaltyPointsResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function adjustLoyaltyPoints($account_id, $body)
    {
        list($response, $statusCode, $httpHeader) = $this->adjustLoyaltyPointsWithHttpInfo ($account_id, $body);
        return $response; 
    }


    /**
     * adjustLoyaltyPointsWithHttpInfo
     *
     * AdjustLoyaltyPoints
     *
     * @param string $account_id The ID of the &#x60;loyalty account&#x60; in which to adjust the points. (required)
     * @param \SquareConnect\Model\AdjustLoyaltyPointsRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return Array of \SquareConnect\Model\AdjustLoyaltyPointsResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function adjustLoyaltyPointsWithHttpInfo($account_id, $body)
    {
        
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling adjustLoyaltyPoints');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling adjustLoyaltyPoints');
        }
  
        // parse inputs
        $resourcePath = "/v2/loyalty/accounts/{account_id}/adjust";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "account_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\AdjustLoyaltyPointsResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\AdjustLoyaltyPointsResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\AdjustLoyaltyPointsResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * calculateLoyaltyPoints
     *
     * CalculateLoyaltyPoints
     * Note: This endpoint is in beta.
     *
     * @param string $program_id The &#x60;loyalty program&#x60; ID, which defines the rules for accruing points. (required)
     * @param \SquareConnect\Model\CalculateLoyaltyPointsRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return \SquareConnect\Model\CalculateLoyaltyPointsResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function calculateLoyaltyPoints($program_id, $body)
    {
        list($response, $statusCode, $httpHeader) = $this->calculateLoyaltyPointsWithHttpInfo ($program_id, $body);
        return $response; 
    }


    /**
     * calculateLoyaltyPointsWithHttpInfo
     *
     * CalculateLoyaltyPoints
     *
     * @param string $program_id The &#x60;loyalty program&#x60; ID, which defines the rules for accruing points. (required)
     * @param \SquareConnect\Model\CalculateLoyaltyPointsRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return Array of \SquareConnect\Model\CalculateLoyaltyPointsResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function calculateLoyaltyPointsWithHttpInfo($program_id, $body)
    {
        
        // verify the required parameter 'program_id' is set
        if ($program_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $program_id when calling calculateLoyaltyPoints');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling calculateLoyaltyPoints');
        }
  
        // parse inputs
        $resourcePath = "/v2/loyalty/programs/{program_id}/calculate";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        // path params
        if ($program_id !== null) {
            $resourcePath = str_replace(
                "{" . "program_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($program_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\CalculateLoyaltyPointsResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\CalculateLoyaltyPointsResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\CalculateLoyaltyPointsResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * createLoyaltyAccount
     *
     * CreateLoyaltyAccount
     * Note: This endpoint is in beta.
     *
     * @param \SquareConnect\Model\CreateLoyaltyAccountRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return \SquareConnect\Model\CreateLoyaltyAccountResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function createLoyaltyAccount($body)
    {
        list($response, $statusCode, $httpHeader) = $this->createLoyaltyAccountWithHttpInfo ($body);
        return $response; 
    }


    /**
     * createLoyaltyAccountWithHttpInfo
     *
     * CreateLoyaltyAccount
     *
     * @param \SquareConnect\Model\CreateLoyaltyAccountRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return Array of \SquareConnect\Model\CreateLoyaltyAccountResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function createLoyaltyAccountWithHttpInfo($body)
    {
        
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling createLoyaltyAccount');
        }
  
        // parse inputs
        $resourcePath = "/v2/loyalty/accounts";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\CreateLoyaltyAccountResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\CreateLoyaltyAccountResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\CreateLoyaltyAccountResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * createLoyaltyReward
     *
     * CreateLoyaltyReward
     * Note: This endpoint is in beta.
     *
     * @param \SquareConnect\Model\CreateLoyaltyRewardRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return \SquareConnect\Model\CreateLoyaltyRewardResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function createLoyaltyReward($body)
    {
        list($response, $statusCode, $httpHeader) = $this->createLoyaltyRewardWithHttpInfo ($body);
        return $response; 
    }


    /**
     * createLoyaltyRewardWithHttpInfo
     *
     * CreateLoyaltyReward
     *
     * @param \SquareConnect\Model\CreateLoyaltyRewardRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return Array of \SquareConnect\Model\CreateLoyaltyRewardResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function createLoyaltyRewardWithHttpInfo($body)
    {
        
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling createLoyaltyReward');
        }
  
        // parse inputs
        $resourcePath = "/v2/loyalty/rewards";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\CreateLoyaltyRewardResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\CreateLoyaltyRewardResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\CreateLoyaltyRewardResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * deleteLoyaltyReward
     *
     * DeleteLoyaltyReward
     * Note: This endpoint is in beta.
     *
     * @param string $reward_id The ID of the &#x60;loyalty reward&#x60; to delete. (required)
     * @return \SquareConnect\Model\DeleteLoyaltyRewardResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function deleteLoyaltyReward($reward_id)
    {
        list($response, $statusCode, $httpHeader) = $this->deleteLoyaltyRewardWithHttpInfo ($reward_id);
        return $response; 
    }


    /**
     * deleteLoyaltyRewardWithHttpInfo
     *
     * DeleteLoyaltyReward
     *
     * @param string $reward_id The ID of the &#x60;loyalty reward&#x60; to delete. (required)
     * @return Array of \SquareConnect\Model\DeleteLoyaltyRewardResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function deleteLoyaltyRewardWithHttpInfo($reward_id)
    {
        
        // verify the required parameter 'reward_id' is set
        if ($reward_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $reward_id when calling deleteLoyaltyReward');
        }
  
        // parse inputs
        $resourcePath = "/v2/loyalty/rewards/{reward_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        // path params
        if ($reward_id !== null) {
            $resourcePath = str_replace(
                "{" . "reward_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($reward_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'DELETE',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\DeleteLoyaltyRewardResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\DeleteLoyaltyRewardResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\DeleteLoyaltyRewardResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * listLoyaltyPrograms
     *
     * ListLoyaltyPrograms
     * Note: This endpoint is in beta.
     *
     * @return \SquareConnect\Model\ListLoyaltyProgramsResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function listLoyaltyPrograms()
    {
        list($response, $statusCode, $httpHeader) = $this->listLoyaltyProgramsWithHttpInfo ();
        return $response; 
    }


    /**
     * listLoyaltyProgramsWithHttpInfo
     *
     * ListLoyaltyPrograms
     *
     * @return Array of \SquareConnect\Model\ListLoyaltyProgramsResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function listLoyaltyProgramsWithHttpInfo()
    {
        
  
        // parse inputs
        $resourcePath = "/v2/loyalty/programs";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'GET',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\ListLoyaltyProgramsResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\ListLoyaltyProgramsResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\ListLoyaltyProgramsResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * redeemLoyaltyReward
     *
     * RedeemLoyaltyReward
     * Note: This endpoint is in beta.
     *
     * @param string $reward_id The ID of the &#x60;loyalty reward&#x60; to redeem. (required)
     * @param \SquareConnect\Model\RedeemLoyaltyRewardRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return \SquareConnect\Model\RedeemLoyaltyRewardResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function redeemLoyaltyReward($reward_id, $body)
    {
        list($response, $statusCode, $httpHeader) = $this->redeemLoyaltyRewardWithHttpInfo ($reward_id, $body);
        return $response; 
    }


    /**
     * redeemLoyaltyRewardWithHttpInfo
     *
     * RedeemLoyaltyReward
     *
     * @param string $reward_id The ID of the &#x60;loyalty reward&#x60; to redeem. (required)
     * @param \SquareConnect\Model\RedeemLoyaltyRewardRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return Array of \SquareConnect\Model\RedeemLoyaltyRewardResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function redeemLoyaltyRewardWithHttpInfo($reward_id, $body)
    {
        
        // verify the required parameter 'reward_id' is set
        if ($reward_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $reward_id when calling redeemLoyaltyReward');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling redeemLoyaltyReward');
        }
  
        // parse inputs
        $resourcePath = "/v2/loyalty/rewards/{reward_id}/redeem";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        // path params
        if ($reward_id !== null) {
            $resourcePath = str_replace(
                "{" . "reward_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($reward_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\RedeemLoyaltyRewardResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\RedeemLoyaltyRewardResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\RedeemLoyaltyRewardResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * retrieveLoyaltyAccount
     *
     * RetrieveLoyaltyAccount
     * Note: This endpoint is in beta.
     *
     * @param string $account_id The ID of the &#x60;loyalty account&#x60; to retrieve. (required)
     * @return \SquareConnect\Model\RetrieveLoyaltyAccountResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function retrieveLoyaltyAccount($account_id)
    {
        list($response, $statusCode, $httpHeader) = $this->retrieveLoyaltyAccountWithHttpInfo ($account_id);
        return $response; 
    }


    /**
     * retrieveLoyaltyAccountWithHttpInfo
     *
     * RetrieveLoyaltyAccount
     *
     * @param string $account_id The ID of the &#x60;loyalty account&#x60; to retrieve. (required)
     * @return Array of \SquareConnect\Model\RetrieveLoyaltyAccountResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function retrieveLoyaltyAccountWithHttpInfo($account_id)
    {
        
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling retrieveLoyaltyAccount');
        }
  
        // parse inputs
        $resourcePath = "/v2/loyalty/accounts/{account_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "account_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'GET',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\RetrieveLoyaltyAccountResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\RetrieveLoyaltyAccountResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\RetrieveLoyaltyAccountResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * retrieveLoyaltyReward
     *
     * RetrieveLoyaltyReward
     * Note: This endpoint is in beta.
     *
     * @param string $reward_id The ID of the &#x60;loyalty reward&#x60; to retrieve. (required)
     * @return \SquareConnect\Model\RetrieveLoyaltyRewardResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function retrieveLoyaltyReward($reward_id)
    {
        list($response, $statusCode, $httpHeader) = $this->retrieveLoyaltyRewardWithHttpInfo ($reward_id);
        return $response; 
    }


    /**
     * retrieveLoyaltyRewardWithHttpInfo
     *
     * RetrieveLoyaltyReward
     *
     * @param string $reward_id The ID of the &#x60;loyalty reward&#x60; to retrieve. (required)
     * @return Array of \SquareConnect\Model\RetrieveLoyaltyRewardResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function retrieveLoyaltyRewardWithHttpInfo($reward_id)
    {
        
        // verify the required parameter 'reward_id' is set
        if ($reward_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $reward_id when calling retrieveLoyaltyReward');
        }
  
        // parse inputs
        $resourcePath = "/v2/loyalty/rewards/{reward_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        // path params
        if ($reward_id !== null) {
            $resourcePath = str_replace(
                "{" . "reward_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($reward_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'GET',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\RetrieveLoyaltyRewardResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\RetrieveLoyaltyRewardResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\RetrieveLoyaltyRewardResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * searchLoyaltyAccounts
     *
     * SearchLoyaltyAccounts
     * Note: This endpoint is in beta.
     *
     * @param \SquareConnect\Model\SearchLoyaltyAccountsRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return \SquareConnect\Model\SearchLoyaltyAccountsResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function searchLoyaltyAccounts($body)
    {
        list($response, $statusCode, $httpHeader) = $this->searchLoyaltyAccountsWithHttpInfo ($body);
        return $response; 
    }


    /**
     * searchLoyaltyAccountsWithHttpInfo
     *
     * SearchLoyaltyAccounts
     *
     * @param \SquareConnect\Model\SearchLoyaltyAccountsRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return Array of \SquareConnect\Model\SearchLoyaltyAccountsResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function searchLoyaltyAccountsWithHttpInfo($body)
    {
        
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling searchLoyaltyAccounts');
        }
  
        // parse inputs
        $resourcePath = "/v2/loyalty/accounts/search";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\SearchLoyaltyAccountsResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\SearchLoyaltyAccountsResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\SearchLoyaltyAccountsResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * searchLoyaltyEvents
     *
     * SearchLoyaltyEvents
     * Note: This endpoint is in beta.
     *
     * @param \SquareConnect\Model\SearchLoyaltyEventsRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return \SquareConnect\Model\SearchLoyaltyEventsResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function searchLoyaltyEvents($body)
    {
        list($response, $statusCode, $httpHeader) = $this->searchLoyaltyEventsWithHttpInfo ($body);
        return $response; 
    }


    /**
     * searchLoyaltyEventsWithHttpInfo
     *
     * SearchLoyaltyEvents
     *
     * @param \SquareConnect\Model\SearchLoyaltyEventsRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return Array of \SquareConnect\Model\SearchLoyaltyEventsResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function searchLoyaltyEventsWithHttpInfo($body)
    {
        
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling searchLoyaltyEvents');
        }
  
        // parse inputs
        $resourcePath = "/v2/loyalty/events/search";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\SearchLoyaltyEventsResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\SearchLoyaltyEventsResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\SearchLoyaltyEventsResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * searchLoyaltyRewards
     *
     * SearchLoyaltyRewards
     * Note: This endpoint is in beta.
     *
     * @param \SquareConnect\Model\SearchLoyaltyRewardsRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return \SquareConnect\Model\SearchLoyaltyRewardsResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function searchLoyaltyRewards($body)
    {
        list($response, $statusCode, $httpHeader) = $this->searchLoyaltyRewardsWithHttpInfo ($body);
        return $response; 
    }


    /**
     * searchLoyaltyRewardsWithHttpInfo
     *
     * SearchLoyaltyRewards
     *
     * @param \SquareConnect\Model\SearchLoyaltyRewardsRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return Array of \SquareConnect\Model\SearchLoyaltyRewardsResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function searchLoyaltyRewardsWithHttpInfo($body)
    {
        
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling searchLoyaltyRewards');
        }
  
        // parse inputs
        $resourcePath = "/v2/loyalty/rewards/search";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\SearchLoyaltyRewardsResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\SearchLoyaltyRewardsResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\SearchLoyaltyRewardsResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
}
