/**
 * Bootbox.js — alert, confirm, prompt, and flexible dialogs for the Bootstrap framework 
 * @version: 6.0.3
 * @project: https://github.com/bootboxjs/bootbox
 * @license: MIT http://bootboxjs.com/license.txt
 */
((t,e)=>{'function'==typeof define&&define.amd?define(['jquery'],e):'object'==typeof exports?module.exports=e(require('jquery')):t.bootbox=e(t.jQuery)})(this,function e(s,p){let r={};r.VERSION='6.0.3';let l={en:{OK:'OK',CANCEL:'Cancel',CONFIRM:'OK'}},c={dialog:'<div class="bootbox modal" tabindex="-1" role="dialog" aria-hidden="true"><div class="modal-dialog"><div class="modal-content"><div class="modal-body"><div class="bootbox-body"></div></div></div></div></div>',header:'<div class="modal-header"><h5 class="modal-title"></h5></div>',footer:'<div class="modal-footer"></div>',closeButton:'<button type="button" class="bootbox-close-button close btn-close" aria-hidden="true" aria-label="Close"></button>',form:'<form class="bootbox-form"></form>',button:'<button type="button" class="btn"></button>',option:'<option value=""></option>',promptMessage:'<div class="bootbox-prompt-message"></div>',inputs:{text:'<input class="bootbox-input bootbox-input-text form-control" autocomplete="off" type="text" />',textarea:'<textarea class="bootbox-input bootbox-input-textarea form-control"></textarea>',email:'<input class="bootbox-input bootbox-input-email form-control" autocomplete="off" type="email" />',select:'<select class="bootbox-input bootbox-input-select form-select"></select>',checkbox:'<div class="form-check checkbox"><label class="form-check-label"><input class="form-check-input bootbox-input bootbox-input-checkbox" type="checkbox" /></label></div>',radio:'<div class="form-check radio"><label class="form-check-label"><input class="form-check-input bootbox-input bootbox-input-radio" type="radio" name="bootbox-radio" /></label></div>',date:'<input class="bootbox-input bootbox-input-date form-control" autocomplete="off" type="date" />',time:'<input class="bootbox-input bootbox-input-time form-control" autocomplete="off" type="time" />',number:'<input class="bootbox-input bootbox-input-number form-control" autocomplete="off" type="number" />',password:'<input class="bootbox-input bootbox-input-password form-control" autocomplete="off" type="password" />',range:'<input class="bootbox-input bootbox-input-range form-control-range" autocomplete="off" type="range" />'}},u={locale:'en',backdrop:'static',animate:!0,className:null,closeButton:!0,show:!0,container:'body',value:'',inputType:'text',errorMessage:null,swapButtonOrder:!1,centerVertical:!1,multiple:!1,scrollable:!1,reusable:!1,relatedTarget:null,size:null,id:null};function i(t,e,o){return s.extend(!0,{},t,((t,e)=>{var o=t.length;let a={};if(o<1||2<o)throw new Error('Invalid argument length');return 2===o||'string'==typeof t[0]?(a[e[0]]=t[0],a[e[1]]=t[1]):a=t[0],a})(e,o))}function d(t,e,a,r){let o;t={className:'bootbox-'+t,buttons:((o,a)=>{var r={};for(let t=0,e=o.length;t<e;t++){var n=o[t],i=n.toLowerCase(),n=n.toUpperCase();r[i]={label:((t,e)=>((e=l[e])||l.en)[t])(n,a)}}return r})(e=r&&r[0]&&(o=r[0].locale||u.locale,r[0].swapButtonOrder||u.swapButtonOrder)?e.reverse():e,o)};{t=i(t,r,a);var n=e;let o={};return f(n,function(t,e){o[e]=!0}),f(t.buttons,function(t){if(o[t]===p)throw new Error('button key "'+t+'" is not allowed (options are '+n.join(' ')+')')}),t}}function b(t){return Object.keys(t).length}function f(t,o){let a=0;s.each(t,function(t,e){o(t,e,a++)})}function m(t){t.data.dialog.find('.bootbox-accept').first().trigger('focus')}function h(t){t.target===t.data.dialog[0]&&t.data.dialog.remove()}function w(t){t.target===t.data.dialog[0]&&(t.data.dialog.off('escape.close.bb'),t.data.dialog.off('click'))}function g(t,e,o){t.stopPropagation(),t.preventDefault(),'function'==typeof o&&!1===o.call(e,t)||e.modal('hide')}function y(t){return/([01][0-9]|2[0-3]):[0-5][0-9]?:[0-5][0-9]/.test(t)}function v(t){return/(\d{4})-(\d{2})-(\d{2})/.test(t)}return r.locales=function(t){return t?l[t]:l},r.addLocale=function(t,o){return s.each(['OK','CANCEL','CONFIRM'],function(t,e){if(!o[e])throw new Error('Please supply a translation for "'+e+'"')}),l[t]={OK:o.OK,CANCEL:o.CANCEL,CONFIRM:o.CONFIRM},r},r.removeLocale=function(t){if('en'===t)throw new Error('"en" is used as the default and fallback locale and cannot be removed.');return delete l[t],r},r.setLocale=function(t){return r.setDefaults('locale',t)},r.setDefaults=function(){let t={};return 2===arguments.length?t[arguments[0]]=arguments[1]:t=arguments[0],s.extend(u,t),r},r.hideAll=function(){return s('.bootbox').modal('hide'),r},r.init=function(t){return e(t||s)},r.dialog=function(t){if(s.fn.modal===p)throw new Error('"$.fn.modal" is not defined; please double check you have included the Bootstrap JavaScript library. See https://getbootstrap.com/docs/5.1/getting-started/introduction/ for more details.');t=(a=>{let r,n;if('object'!=typeof a)throw new Error('Please supply an object of options');if(a.message)return(a=s.extend({},u,a)).backdrop?a.backdrop='string'!=typeof a.backdrop||'static'!==a.backdrop.toLowerCase()||'static':a.backdrop=!1!==a.backdrop&&0!==a.backdrop&&'static',a.buttons||(a.buttons={}),r=a.buttons,n=b(r),f(r,function(t,e,o){if('object'!=typeof(e='function'==typeof e?r[t]={callback:e}:e))throw new Error('button with key "'+t+'" must be an object');if(e.label||(e.label=t),!e.className){let t=!1;t=a.swapButtonOrder?0===o:o===n-1,n<=2&&t?e.className='btn-primary':e.className='btn-secondary btn-default'}}),a;throw new Error('"message" option must not be null or an empty string.')})(t),s.fn.modal.Constructor.VERSION?(t.fullBootstrapVersion=s.fn.modal.Constructor.VERSION,a=t.fullBootstrapVersion.indexOf('.'),t.bootstrap=t.fullBootstrapVersion.substring(0,a)):(t.bootstrap='2',t.fullBootstrapVersion='2.3.2',console.warn('Bootbox will *mostly* work with Bootstrap 2, but we do not officially support it. Please upgrade, if possible.'));let o=s(c.dialog);var e=o.find('.modal-dialog'),a=o.find('.modal-body'),r=s(c.header);let n=s(c.footer);var i=t.buttons;let l={onEscape:t.onEscape};if(a.find('.bootbox-body').html(t.message),0<b(t.buttons)&&(f(i,function(t,e){var o=s(c.button);switch(o.data('bb-handler',t),o.addClass(e.className),t){case'ok':case'confirm':o.addClass('bootbox-accept');break;case'cancel':o.addClass('bootbox-cancel')}o.html(e.label),e.id&&o.attr({id:e.id}),!0===e.disabled&&o.prop({disabled:!0}),n.append(o),l[t]=e.callback}),a.after(n)),!0===t.animate&&o.addClass('fade'),t.className&&o.addClass(t.className),t.id&&o.attr({id:t.id}),t.size)switch(t.fullBootstrapVersion.substring(0,3)<'3.1'&&console.warn('"size" requires Bootstrap 3.1.0 or higher. You appear to be using '+t.fullBootstrapVersion+'. Please upgrade to use this option.'),t.size){case'small':case'sm':e.addClass('modal-sm');break;case'large':case'lg':e.addClass('modal-lg');break;case'extra-large':case'xl':e.addClass('modal-xl'),t.fullBootstrapVersion.substring(0,3)<'4.2'&&console.warn('Using size "xl"/"extra-large" requires Bootstrap 4.2.0 or higher. You appear to be using '+t.fullBootstrapVersion+'. Please upgrade to use this option.')}if(t.scrollable&&(e.addClass('modal-dialog-scrollable'),t.fullBootstrapVersion.substring(0,3)<'4.3')&&console.warn('Using "scrollable" requires Bootstrap 4.3.0 or higher. You appear to be using '+t.fullBootstrapVersion+'. Please upgrade to use this option.'),(t.title||t.closeButton)&&(t.title?r.find('.modal-title').html(t.title):r.addClass('border-0'),t.closeButton&&(i=s(c.closeButton),t.bootstrap<5&&i.html('&times;'),t.bootstrap<4?r.prepend(i):r.append(i)),a.before(r)),t.centerVertical&&(e.addClass('modal-dialog-centered'),t.fullBootstrapVersion<'4.0.0')&&console.warn('"centerVertical" requires Bootstrap 4.0.0-beta.3 or higher. You appear to be using '+t.fullBootstrapVersion+'. Please upgrade to use this option.'),t.reusable||(o.one('hide.bs.modal',{dialog:o},w),o.one('hidden.bs.modal',{dialog:o},h)),t.onHide){if('function'!=typeof t.onHide)throw new Error('Argument supplied to "onHide" must be a function');o.on('hide.bs.modal',t.onHide)}if(t.onHidden){if('function'!=typeof t.onHidden)throw new Error('Argument supplied to "onHidden" must be a function');o.on('hidden.bs.modal',t.onHidden)}if(t.onShow){if('function'!=typeof t.onShow)throw new Error('Argument supplied to "onShow" must be a function');o.on('show.bs.modal',t.onShow)}if(o.one('shown.bs.modal',{dialog:o},m),t.onShown){if('function'!=typeof t.onShown)throw new Error('Argument supplied to "onShown" must be a function');o.on('shown.bs.modal',t.onShown)}if(!0===t.backdrop){let e=!1;o.on('mousedown','.modal-content',function(t){t.stopPropagation(),e=!0}),o.on('click.dismiss.bs.modal',function(t){e||t.target!==t.currentTarget||o.trigger('escape.close.bb')})}return o.on('escape.close.bb',function(t){l.onEscape&&g(t,o,l.onEscape)}),o.on('click','.modal-footer button:not(.disabled)',function(t){var e=s(this).data('bb-handler');e!==p&&g(t,o,l[e])}),o.on('click','.bootbox-close-button',function(t){g(t,o,l.onEscape)}),o.on('keyup',function(t){27===t.which&&o.trigger('escape.close.bb')}),s(t.container).append(o),o.modal({backdrop:t.backdrop,keyboard:!1,show:!1}),t.show&&o.modal('show',t.relatedTarget),o},r.alert=function(){let t;if((t=d('alert',['ok'],['message','callback'],arguments)).callback&&'function'!=typeof t.callback)throw new Error('alert requires the "callback" property to be a function when provided');return t.buttons.ok.callback=t.onEscape=function(){return'function'!=typeof t.callback||t.callback.call(this)},r.dialog(t)},r.confirm=function(){let t;if('function'!=typeof(t=d('confirm',['cancel','confirm'],['message','callback'],arguments)).callback)throw new Error('confirm requires a callback');return t.buttons.cancel.callback=t.onEscape=function(){return t.callback.call(this,!1)},t.buttons.confirm.callback=function(){return t.callback.call(this,!0)},r.dialog(t)},r.prompt=function(){let n,e;var t,o,a;let i,l;if(t=s(c.form),(n=d('prompt',['cancel','confirm'],['title','callback'],arguments)).value||(n.value=u.value),n.inputType||(n.inputType=u.inputType),o=(n.show===p?u:n).show,n.show=!1,n.buttons.cancel.callback=n.onEscape=function(){return n.callback.call(this,null)},n.buttons.confirm.callback=function(){let t;if('checkbox'===n.inputType){if(0===(t=i.find('input:checked').map(function(){return s(this).val()}).get()).length&&!0===n.required)return!1}else if('radio'===n.inputType)t=i.find('input:checked').val();else{var e=i[0];if(e.checkValidity&&!e.checkValidity())return n.errorMessage&&e.setCustomValidity(n.errorMessage),e.reportValidity&&e.reportValidity(),!1;t='select'===n.inputType&&!0===n.multiple?i.find('option:selected').map(function(){return s(this).val()}).get():i.val()}return n.callback.call(this,t)},!n.title)throw new Error('prompt requires a title');if('function'!=typeof n.callback)throw new Error('prompt requires a callback');if(!c.inputs[n.inputType])throw new Error('Invalid prompt type');switch(i=s(c.inputs[n.inputType]),n.inputType){case'text':case'textarea':case'email':case'password':i.val(n.value),n.placeholder&&i.attr('placeholder',n.placeholder),n.pattern&&i.attr('pattern',n.pattern),n.maxlength&&i.attr('maxlength',n.maxlength),n.required&&i.prop({required:!0}),n.rows&&!isNaN(parseInt(n.rows))&&'textarea'===n.inputType&&i.attr({rows:n.rows});break;case'date':case'time':case'number':case'range':if(i.val(n.value),n.placeholder&&i.attr('placeholder',n.placeholder),n.pattern?i.attr('pattern',n.pattern):'date'===n.inputType?i.attr('pattern','d{4}-d{2}-d{2}'):'time'===n.inputType&&i.attr('pattern','d{2}:d{2}'),n.required&&i.prop({required:!0}),'date'!==n.inputType&&n.step){if(!('any'===n.step||!isNaN(n.step)&&0<parseFloat(n.step)))throw new Error('"step" must be a valid positive number or the value "any". See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-step for more information.');i.attr('step',n.step)}((t,e,o)=>{let a=!1,r=!0,n=!0;if('date'===t)e===p||(r=v(e))?o===p||(n=v(o))||console.warn('Browsers which natively support the "date" input type expect date values to be of the form "YYYY-MM-DD" (see ISO-8601 https://www.iso.org/iso-8601-date-and-time-format.html). Bootbox does not enforce this rule, but your max value may not be enforced by this browser.'):console.warn('Browsers which natively support the "date" input type expect date values to be of the form "YYYY-MM-DD" (see ISO-8601 https://www.iso.org/iso-8601-date-and-time-format.html). Bootbox does not enforce this rule, but your min value may not be enforced by this browser.');else if('time'===t){if(e!==p&&!(r=y(e)))throw new Error('"min" is not a valid time. See https://www.w3.org/TR/2012/WD-html-markup-20120315/datatypes.html#form.data.time for more information.');if(o!==p&&!(n=y(o)))throw new Error('"max" is not a valid time. See https://www.w3.org/TR/2012/WD-html-markup-20120315/datatypes.html#form.data.time for more information.')}else{if(e!==p&&isNaN(e))throw r=!1,new Error('"min" must be a valid number. See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-min for more information.');if(o!==p&&isNaN(o))throw n=!1,new Error('"max" must be a valid number. See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-max for more information.')}if(r&&n){if(o<e)throw new Error('"max" must be greater than or equal to "min". See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-max for more information.');a=!0}return a})(n.inputType,n.min,n.max)&&(n.min!==p&&i.attr('min',n.min),n.max!==p)&&i.attr('max',n.max);break;case'select':let r={};if(l=n.inputOptions||[],!Array.isArray(l))throw new Error('Please pass an array of input options');if(!l.length)throw new Error('prompt with "inputType" set to "select" requires at least one option');n.required&&i.prop({required:!0}),n.multiple&&i.prop({multiple:!0}),f(l,function(t,e){let o=i;if(e.value===p||e.text===p)throw new Error('each option needs a "value" property and a "text" property');e.group&&(r[e.group]||(r[e.group]=s('<optgroup />').attr('label',e.group)),o=r[e.group]);var a=s(c.option);a.attr('value',e.value).text(e.text),o.append(a)}),f(r,function(t,e){i.append(e)}),i.val(n.value),n.bootstrap<5&&i.removeClass('form-select').addClass('form-control');break;case'checkbox':let e=Array.isArray(n.value)?n.value:[n.value];if(!(l=n.inputOptions||[]).length)throw new Error('prompt with "inputType" set to "checkbox" requires at least one option');i=s('<div class="bootbox-checkbox-list"></div>'),f(l,function(t,o){if(o.value===p||o.text===p)throw new Error('each option needs a "value" property and a "text" property');let a=s(c.inputs[n.inputType]);a.find('input').attr('value',o.value),a.find('label').append('\n'+o.text),f(e,function(t,e){e===o.value&&a.find('input').prop('checked',!0)}),i.append(a)});break;case'radio':if(n.value!==p&&Array.isArray(n.value))throw new Error('prompt with "inputType" set to "radio" requires a single, non-array value for "value"');if(!(l=n.inputOptions||[]).length)throw new Error('prompt with "inputType" set to "radio" requires at least one option');i=s('<div class="bootbox-radiobutton-list"></div>');let a=!0;f(l,function(t,e){if(e.value===p||e.text===p)throw new Error('each option needs a "value" property and a "text" property');var o=s(c.inputs[n.inputType]);o.find('input').attr('value',e.value),o.find('label').append('\n'+e.text),n.value!==p&&e.value===n.value&&(o.find('input').prop('checked',!0),a=!1),i.append(o)}),a&&i.find('input[type="radio"]').first().prop('checked',!0)}return t.append(i),t.on('submit',function(t){t.preventDefault(),t.stopPropagation(),e.find('.bootbox-accept').trigger('click')}),n.message&&''!==n.message.trim()&&(a=s(c.promptMessage).html(n.message),t.prepend(a)),n.message=t,(e=r.dialog(n)).off('shown.bs.modal',m),e.on('shown.bs.modal',function(){i.focus()}),!0===o&&e.modal('show'),e},r});