<?php

/*
 * Copyright (C) 2020 Manuela v.d.Decken <manuela@isteam.de>
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License 2 for more details.
 *
 * You should have received a copy of the GNU General Public License 2
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Helpers
 *
 * @category     name
 * @package      Core package
 * @copyright    Manuela v.d.Decken <manuela@isteam.de>
 * @author       Manuela v.d.Decken <manuela@isteam.de>
 * @license      GNU General Public License 2.0
 * @version      0.0.1 $Rev: 4 $
 * @revision     $Id: Helpers.php 4 2025-08-08 07:53:04Z Uwe $
 * @since        File available since 21.11.2020
 * @deprecated   no / since 0000/00/00
 * @description  xxx
 */
declare(strict_types = 1);
//declare(encoding = 'UTF-8');

namespace App\Utils;

use bin\{WbAdaptor};

class Helpers
{

/**
 * make sure that an integer value is between min and max
 * or set to default, if value is out of range
 * @param int $iValue
 * @param int $iMin
 * @param int $iMax
 * @param int|null $iDefault  null = result inside the range,
 *                            int  = result default if out of range
 *                                   default can not be out of range
 * @return int
 */
    public static function sanitizeMinMax(int $iValue, int $iMin, int $iMax, $iDefault = null): int
    {
        if (\is_null($iDefault)) {
            $iRetval = ($iValue < $iMin ? $iMin : ($iValue > $iMax ? $iMax : $iValue));
        } else {
            $iDefault = ($iDefault < $iMin ? $iMin : ($iDefault > $iMax ? $iMax : $iDefault));
            $iRetval = (($iValue > $iMax || $iValue < $iMin) ? $iDefault : $iValue);
        }
        return $iRetval;
    }

/**
 * @param  abs path of hiddenfile
 * @param  extension inc as default orsection_id
 * @return int
 */
    public static function setFrontendHiddenFile (string $path = '',string $ext='inc'):?int
    {
        $mFile = null;
        if (!empty($path)) {
            $oReg     = WbAdaptor::getInstance();
            $sAddonPath = trim(str_replace('\\','/',$path),'/').'/';
            $sCallingScript = $_SERVER["SCRIPT_NAME"];
            $sAddonHiddenFile = $oReg->AppPath.'account/'.'.setFrontend.'.$ext;
            $sTmp = '<?php header($_SERVER[\'SERVER_PROTOCOL\'].\' 404 Not Found\');echo \'404 Not Found\'; flush(); exit; ?>'."\n"
                  . 'created: ['.date('r').']'."\n"
                  . 'script: '.$sCallingScript."\n";
            $aDebugArray = [
            'path' => $path,
            'ext' => $ext,
            'AddonPath' => $sAddonPath,
            'AddonHiddenFile' => $sAddonHiddenFile,
            'Tmp' => $sTmp,
            ];
            if ( !\str_contains($path,'account')){
                $mFile = \file_put_contents($sAddonHiddenFile, $sTmp);
                $aDebugArray = array_merge($aDebugArray,['mFile'=>$mFile]);
//print '<!-- '."\n".'function '.__FUNCTION__.'( '.''.' );'."\n".'filename: '.basename(__FILE__)."\n".'line: '.__LINE__.' -> '."\n";
//print_r( $aDebugArray ); print "\n".'-->'."\n"; \flush (); //  ob_flush();;sleep(10); die();
            }
        }
        return (($mFile > 0) ? $mFile : null );
    }
}

