<?php

declare(strict_types=1);


use bin\{WbAdaptor,SecureTokens,Sanitize};

// Must include code to stop this file being access directly
if (!\defined('SYSTEM_RUN')) {\header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found'); echo '404 Not Found'; \flush(); exit;}

// Recursive implementation accepting multiple n-level-arrays as parameters:
// https://www.php.net/manual/en/function.array-diff-assoc.php#127005
// https://www.php.net/manual/en/function.array-diff-assoc.php#122579
/*
 * Recursively diff two arrays. This function expects the leaf levels to be
 * arrays of strings or null
 */
function diff_recursive(array $array1, array $array2,$bRetval = true) {
    $difference = [];
    foreach($array1 as $key => $value) {
        if (is_array($value) && isset($array2[$key])){ // it's an array and both have the key
            $new_diff = diff_recursive($value, $array2[$key],$bRetval);
            if ( !empty($new_diff) )
                $difference[$key] = $new_diff;
            } else if(is_string($value) && !in_array($value, $array2)) { // the value is a string and it's not in array B
                $difference[$key] = $value . " is missing from the second array";
                $bRetval = false;
            } else if (!is_numeric($key) && !array_key_exists($key, $array2)) { // the key is not numberic and is missing from array B
                $difference[$key] = "Missing from the second array";
                $bRetval = false;
            }

    }// end foreach
    return $difference;
}

function __unserialize($sObject) {
    $aRetval = [];
    $sObject = \stripslashes($sObject);
    if ($sObject){
        $_ret = preg_replace_callback(  //'!s:(\d+):"(.*?)";!',
                        '!s:\d+:"(.*?)";!s',
                        function($matches) {return 's:'.strlen($matches[1]).':"'.$matches[1].'";';},
                        $sObject
                 );
        if ($_ret) {$aRetval = @unserialize($_ret);}
    }

    return $aRetval;
}

function updateMediaSettings():bool
{
    $oReg =  WbAdaptor::getInstance();
    $bRetval = false;
    $bCanUpgrade = false;
    if (
        //
            (version_compare(MEDIA_VERSION, VERSION.'.'.REVISION, '<') || preg_match('/dev/', VERSION))
    ) {
          // true to compare mediasettings
          $bCanUpgrade = true;
          $cfg = ['media_version' => VERSION.'.'.REVISION];
          if (false === ($bRetval = db_update_key_value('settings', $cfg))){
                //$bRetval = true;
          }
    } // compare media_version not equal

    if ((defined('MEDIASETTINGS') && !empty(trim(MEDIASETTINGS))) || $bCanUpgrade)
    {
        $aOldSettings = [];
        $aNewSettings = [];
        if (defined('MEDIASETTINGS') && !empty(MEDIASETTINGS)){
            $aOldSettings = __unserialize(MEDIASETTINGS);
        }
        foreach($aOldSettings as $index => $aName) {
            $r = $index;
            if (($r !== 'global')) {
                $w = ($aName['width'] ?: 0);
                $h = ($aName['height'] ?: 0);
            }
//echo \nl2br(\sprintf("---- [%04d] %s %s %s \n",__LINE__,$r,$w, $h));
            if (isset($w) && ($w !==0) || isset($h) && ($h !==0) && ($r !== 'global')){
              $aNewSettings[$r]['width'] =$w;
              $aNewSettings[$r]['height']=$h;
            }
        }// end foreach
        $aNewSettings['global']['admin_only']  = ($aOldSettings['global']['admin_only'] ?? 0);
        $aNewSettings['global']['show_thumbs'] = ($aOldSettings['global']['show_thumbs'] ?? 0);
        $aNewSettings['global']['resize_up']   = ($aOldSettings['global']['resize_up'] ?? 0);
        $aTmpOption = diff_recursive($aOldSettings,$aNewSettings);
        if (!empty($aTmpOption)) {
            $sValueToSave = serialize($aNewSettings);
            $cfg = ['mediasettings' => $sValueToSave];
            //$cfg = ['mediasettings' => $sValueToSave, 'media_version' => VERSION.'.'.REVISION];
            if (false === ($bRetval = db_update_key_value('settings', $cfg))){
                //$bRetval = true;
            }
        }
        unset($sValueToSave, $aOldSettings, $aNewSettings);
        } // c$bCanUpgrade or  mediasettings not empty
    return ($bRetval);
}
/* end of script */
