<?php

return [
    'customers' => [
        'forgot-password' => [
            'already-sent'         => 'Mail de réinitialisation de mot de passe déjà envoyé.',
            'back'                 => 'Retour à la connexion ?',
            'bagisto'              => 'Bagisto',
            'email'                => 'E-mail',
            'email-not-exist'      => 'Nous ne pouvons pas trouver d\'utilisateur avec cette adresse e-mail',
            'footer'               => '© Droits d’auteur 2010 - :current_year, Webkul Software (enregistré en Inde). Tous droits réservés.',
            'forgot-password-text' => 'Si vous avez oublié votre mot de passe, récupérez-le en entrant votre adresse e-mail.',
            'page-title'           => 'Vous avez oublié votre mot de passe ?',
            'reset-link-sent'      => 'Nous vous avons envoyé par e-mail le lien de réinitialisation de votre mot de passe.',
            'sign-in-button'       => 'Se connecter',
            'submit'               => 'Réinitialiser le mot de passe',
            'title'                => 'Récupérer le mot de passe',
        ],

        'reset-password' => [
            'back-link-title'  => 'Retour à la connexion',
            'bagisto'          => 'Bagisto',
            'confirm-password' => 'Confirmer le mot de passe',
            'email'            => 'E-mail enregistré',
            'footer'           => '© Droits d’auteur 2010 - :current_year, Webkul Software (enregistré en Inde). Tous droits réservés.',
            'password'         => 'Mot de passe',
            'submit-btn-title' => 'Réinitialiser le mot de passe',
            'title'            => 'Réinitialiser le mot de passe',
        ],

        'login-form' => [
            'bagisto'             => 'Bagisto',
            'button-title'        => 'Se connecter',
            'create-your-account' => 'Créez votre compte',
            'email'               => 'E-mail',
            'footer'              => '© Droits d’auteur 2010 - :current_year, Webkul Software (enregistré en Inde). Tous droits réservés.',
            'forgot-pass'         => 'Mot de passe oublié ?',
            'form-login-text'     => 'Si vous avez un compte, connectez-vous avec votre adresse e-mail.',
            'invalid-credentials' => "Veuillez vérifier vos informations d'identification et réessayer.",
            'new-customer'        => 'Nouveau client ?',
            'not-activated'       => "Votre activation nécessite l'approbation de l'administrateur",
            'page-title'          => 'Connexion client',
            'password'            => 'Mot de passe',
            'show-password'       => 'Afficher le mot de passe',
            'title'               => 'Se connecter',
            'verify-first'        => 'Vérifiez d\'abord votre compte e-mail.',
        ],

        'signup-form' => [
            'account-exists'              => 'Vous avez déjà un compte ?',
            'bagisto'                     => 'Bagisto',
            'button-title'                => 'S\'inscrire',
            'click-here'                  => 'Cliquez ici',
            'confirm-pass'                => 'Confirmer le mot de passe',
            'email'                       => 'E-mail',
            'first-name'                  => 'Prénom',
            'footer'                      => '© Droits d’auteur 2010 - :current_year, Webkul Software (enregistré en Inde). Tous droits réservés.',
            'form-signup-text'            => 'Si vous êtes nouveau dans notre magasin, nous sommes ravis de vous avoir comme membre.',
            'last-name'                   => 'Nom de famille',
            'page-title'                  => 'Devenir utilisateur',
            'password'                    => 'Mot de passe',
            'sign-in-button'              => 'Se connecter',
            'subscribe-to-newsletter'     => 'Souscrire à la newsletter',
            'success'                     => 'Compte créé avec succès.',
            'success-verify'              => 'Compte créé avec succès, un e-mail de vérification a été envoyé.',
            'success-verify-email-unsent' => 'Compte créé avec succès, mais l\'e-mail de vérification n\'a pas été envoyé.',
            'terms-conditions'            => 'Termes et conditions',
            'verification-not-sent'       => 'Erreur ! Problème d\'envoi de l\'e-mail de vérification, veuillez réessayer plus tard.',
            'verification-sent'           => 'E-mail de vérification envoyé',
            'verified'                    => 'Votre compte a été vérifié, essayez de vous connecter maintenant.',
            'verify-failed'               => 'Nous ne pouvons pas vérifier votre compte e-mail.',
        ],

        'account' => [
            'home' => 'Accueil',

            'profile' => [
                'index' => [
                    'delete'         => 'Supprimer',
                    'delete-failed'  => 'Erreur rencontrée lors de la suppression du client.',
                    'delete-profile' => 'Supprimer le profil',
                    'delete-success' => 'Client supprimé avec succès',
                    'dob'            => 'Date de naissance',
                    'edit'           => 'Modifier',
                    'edit-success'   => 'Profil mis à jour avec succès',
                    'email'          => 'Email',
                    'enter-password' => 'Entrez votre mot de passe',
                    'first-name'     => 'Prénom',
                    'gender'         => 'Genre',
                    'last-name'      => 'Nom de famille',
                    'order-pending'  => 'Impossible de supprimer le compte client car certaines commandes sont en attente ou en cours de traitement.',
                    'title'          => 'Profil',
                    'unmatched'      => 'L\'ancien mot de passe ne correspond pas.',
                    'wrong-password' => 'Mauvais mot de passe !',
                ],

                'edit' => [
                    'confirm-password'        => 'Confirmer le mot de passe',
                    'current-password'        => 'Mot de passe actuel',
                    'dob'                     => 'Date de naissance',
                    'edit'                    => 'Modifier',
                    'edit-profile'            => 'Modifier le profil',
                    'email'                   => 'Email',
                    'female'                  => 'Femme',
                    'first-name'              => 'Prénom',
                    'gender'                  => 'Genre',
                    'last-name'               => 'Nom de famille',
                    'male'                    => 'Homme',
                    'new-password'            => 'Nouveau mot de passe',
                    'other'                   => 'Autre',
                    'phone'                   => 'Téléphone',
                    'save'                    => 'Enregistrer',
                    'subscribe-to-newsletter' => 'S\'abonner à la newsletter',
                ],
            ],

            'addresses' => [
                'index' => [
                    'add-address'      => 'Ajouter une adresse',
                    'create-success'   => 'L\'adresse a été ajoutée avec succès.',
                    'default-address'  => 'Adresse par défaut',
                    'default-delete'   => 'L\'adresse par défaut ne peut pas être modifiée.',
                    'delete'           => 'Supprimer',
                    'delete-success'   => 'Adresse supprimée avec succès',
                    'edit'             => 'Modifier',
                    'edit-success'     => 'Adresse mise à jour avec succès.',
                    'empty-address'    => 'Vous n\'avez pas encore ajouté d\'adresse à votre compte.',
                    'security-warning' => 'Activité suspecte détectée !!!',
                    'set-as-default'   => 'Définir comme adresse par défaut',
                    'title'            => 'Adresse',
                    'update-success'   => 'L\'adresse a été mise à jour avec succès.',
                ],

                'create' => [
                    'add-address'    => 'Ajouter une adresse',
                    'city'           => 'Ville',
                    'company-name'   => 'Nom de l\'entreprise',
                    'country'        => 'Pays',
                    'email'          => 'E-mail',
                    'first-name'     => 'Prénom',
                    'last-name'      => 'Nom de famille',
                    'phone'          => 'Téléphone',
                    'post-code'      => 'Code postal',
                    'save'           => 'Enregistrer',
                    'select-country' => 'Sélectionner le pays',
                    'set-as-default' => 'Définir comme adresse par défaut',
                    'state'          => 'État',
                    'street-address' => 'Adresse',
                    'title'          => 'Adresse',
                    'vat-id'         => 'Numéro de TVA',
                ],

                'edit' => [
                    'city'           => 'Ville',
                    'company-name'   => 'Nom de l\'entreprise',
                    'country'        => 'Pays',
                    'edit'           => 'Modifier',
                    'email'          => 'E-mail',
                    'first-name'     => 'Prénom',
                    'last-name'      => 'Nom de famille',
                    'phone'          => 'Téléphone',
                    'post-code'      => 'Code postal',
                    'select-country' => 'Sélectionner le pays',
                    'state'          => 'État',
                    'street-address' => 'Adresse',
                    'title'          => 'Adresse',
                    'update-btn'     => 'Mettre à jour',
                    'vat-id'         => 'Numéro de TVA',
                ],
            ],

            'orders' => [
                'action'      => 'Action',
                'action-view' => 'Voir',
                'empty-order' => 'Vous n\'avez encore commandé aucun produit',
                'order'       => 'Commande',
                'order-date'  => 'Date de commande',
                'order-id'    => 'ID de commande',
                'subtotal'    => 'Sous-total',
                'title'       => 'Commandes',
                'total'       => 'Total',

                'status' => [
                    'title' => 'Statut',

                    'options' => [
                        'canceled'        => 'Annulée',
                        'closed'          => 'Fermée',
                        'completed'       => 'Terminée',
                        'fraud'           => 'Fraude',
                        'pending'         => 'En attente',
                        'pending-payment' => 'En attente de paiement',
                        'processing'      => 'En cours de traitement',
                    ],
                ],

                'view' => [
                    'billing-address'      => 'Adresse de facturation',
                    'cancel-btn-title'     => 'Annuler',
                    'cancel-confirm-msg'   => 'Êtes-vous sûr de vouloir annuler cette commande ?',
                    'cancel-error'         => 'Votre commande ne peut pas être annulée.',
                    'cancel-success'       => 'Votre commande a été annulée',
                    'contact'              => 'Contact',
                    'item-invoiced'        => 'Article facturé',
                    'item-refunded'        => 'Article remboursé',
                    'item-shipped'         => 'Article expédié',
                    'item-ordered'         => 'Article commandé',
                    'order-id'             => 'ID de commande',
                    'page-title'           => 'Commande #:order_id',
                    'payment-method'       => 'Moyen de paiement',
                    'reorder-btn-title'    => 'Recommander',
                    'shipping-address'     => 'Adresse de livraison',
                    'shipping-method'      => 'Méthode de livraison',
                    'shipping-and-payment' => 'Détails de livraison et de paiement',
                    'status'               => 'Statut',
                    'title'                => 'Voir',
                    'total'                => 'Total',

                    'information' => [
                        'discount'                   => 'Réduction',
                        'excl-tax'                   => 'Hors taxe :',
                        'grand-total'                => 'Total général',
                        'info'                       => 'Information',
                        'item-canceled'              => 'Annulé (:qty_canceled)',
                        'item-refunded'              => 'Remboursé (:qty_refunded)',
                        'invoiced-item'              => 'Facturé (:qty_invoiced)',
                        'item-shipped'               => 'expédié (:qty_shipped)',
                        'item-status'                => 'Statut de l\'article',
                        'ordered-item'               => 'Commandé (:qty_ordered)',
                        'placed-on'                  => 'Passé le',
                        'price'                      => 'Prix',
                        'product-name'               => 'Nom',
                        'shipping-handling'          => 'Expédition et manutention',
                        'shipping-handling-excl-tax' => 'Expédition et manutention (hors taxe)',
                        'shipping-handling-incl-tax' => 'Expédition et manutention (incl. taxe)',
                        'sku'                        => 'SKU',
                        'subtotal'                   => 'Sous-total',
                        'subtotal-excl-tax'          => 'Sous-total (hors taxe)',
                        'subtotal-incl-tax'          => 'Sous-total (incl. taxe)',
                        'order-summary'              => 'Résumé de la commande',
                        'tax'                        => 'Taxe',
                        'tax-amount'                 => 'Montant de la taxe',
                        'tax-percent'                => 'Pourcentage de taxe',
                        'total-due'                  => 'Total dû',
                        'total-paid'                 => 'Total payé',
                        'total-refunded'             => 'Total remboursé',
                    ],

                    'invoices' => [
                        'discount'                   => 'Réduction',
                        'excl-tax'                   => 'Hors taxe :',
                        'grand-total'                => 'Total général',
                        'individual-invoice'         => 'Facture #:invoice_id',
                        'invoices'                   => 'Factures',
                        'price'                      => 'Prix',
                        'print'                      => 'Imprimer',
                        'product-name'               => 'Nom',
                        'products-ordered'           => 'Produits commandés',
                        'qty'                        => 'Qté',
                        'shipping-handling-excl-tax' => 'Expédition et manutention (hors taxe)',
                        'shipping-handling-incl-tax' => 'Expédition et manutention (incl. taxe)',
                        'shipping-handling'          => 'Expédition et manutention',
                        'sku'                        => 'SKU',
                        'subtotal-excl-tax'          => 'Sous-total (hors taxe)',
                        'subtotal-incl-tax'          => 'Sous-total (incl. taxe)',
                        'subtotal'                   => 'Sous-total',
                        'tax'                        => 'Taxe',
                        'tax-amount'                 => 'Montant de la taxe',
                    ],

                    'shipments' => [
                        'individual-shipment' => 'Expédition #:shipment_id',
                        'product-name'        => 'Nom',
                        'qty'                 => 'Qté',
                        'shipments'           => 'Expéditions',
                        'sku'                 => 'SKU',
                        'subtotal'            => 'Sous-total',
                        'tracking-number'     => 'Numéro de suivi',
                    ],

                    'refunds' => [
                        'adjustment-fee'             => 'Frais d\'ajustement',
                        'adjustment-refund'          => 'Remboursement d\'ajustement',
                        'discount'                   => 'Réduction',
                        'grand-total'                => 'Total général',
                        'individual-refund'          => 'Remboursement #:refund_id',
                        'no-result-found'            => 'Nous n\'avons trouvé aucun enregistrement.',
                        'order-summary'              => 'Résumé de la commande',
                        'price'                      => 'Prix',
                        'product-name'               => 'Nom',
                        'qty'                        => 'Qté',
                        'refunds'                    => 'Remboursements',
                        'shipping-handling'          => 'Expédition et manutention',
                        'shipping-handling-excl-tax' => 'Expédition et manutention (hors taxe)',
                        'shipping-handling-incl-tax' => 'Expédition et manutention (incl. taxe)',
                        'sku'                        => 'SKU',
                        'subtotal'                   => 'Sous-total',
                        'subtotal-excl-tax'          => 'Sous-total (hors taxe)',
                        'subtotal-incl-tax'          => 'Sous-total (incl. taxe)',
                        'tax'                        => 'Taxe',
                        'tax-amount'                 => 'Montant de la taxe',
                    ],
                ],

                'invoice-pdf' => [
                    'bank-details'               => 'Coordonnées bancaires',
                    'bill-to'                    => 'Facturé à',
                    'contact-number'             => 'Numéro de contact',
                    'contact'                    => 'Contact',
                    'date'                       => 'Date de la facture',
                    'discount'                   => 'Remise',
                    'excl-tax'                   => 'Hors taxe:',
                    'grand-total'                => 'Total général',
                    'invoice-id'                 => 'ID de la facture',
                    'invoice'                    => 'Facture',
                    'order-date'                 => 'Date de la commande',
                    'order-id'                   => 'ID de la commande',
                    'payment-method'             => 'Méthode de paiement',
                    'payment-terms'              => 'Conditions de paiement',
                    'price'                      => 'Prix',
                    'product-name'               => 'Nom du produit',
                    'qty'                        => 'Quantité',
                    'ship-to'                    => 'Expédier à',
                    'shipping-handling-excl-tax' => 'Frais de port et de manutention (Hors taxe)',
                    'shipping-handling-incl-tax' => 'Frais de port et de manutention (TTC)',
                    'shipping-handling'          => 'Frais de port et de manutention',
                    'shipping-method'            => 'Méthode d\'expédition',
                    'sku'                        => 'SKU',
                    'subtotal-excl-tax'          => 'Sous-total (Hors taxe)',
                    'subtotal-incl-tax'          => 'Sous-total (TTC)',
                    'subtotal'                   => 'Sous-total',
                    'tax-amount'                 => 'Montant de la taxe',
                    'tax'                        => 'Taxe',
                    'vat-number'                 => 'Numéro de TVA',
                ],
            ],

            'reviews' => [
                'empty-review' => 'Vous n\'avez pas encore examiné de produit',
                'title'        => 'Avis',
            ],

            'downloadable-products' => [
                'available'           => 'Disponible',
                'completed'           => 'Complété',
                'date'                => 'Date',
                'download-error'      => 'Le lien de téléchargement a expiré.',
                'expired'             => 'Expiré',
                'empty-product'       => 'Vous n\'avez pas de produit à télécharger',
                'name'                => 'Produits téléchargeables',
                'orderId'             => 'ID de commande',
                'pending'             => 'En attente',
                'payment-error'       => 'Le paiement n\'a pas été effectué pour ce téléchargement.',
                'records-found'       => 'Enregistrement(s) trouvé(s)',
                'remaining-downloads' => 'Téléchargements restants',
                'status'              => 'Statut',
                'title'               => 'Titre',
            ],

            'wishlist' => [
                'color'              => 'Couleur',
                'delete-all'         => 'Tout supprimer',
                'empty'              => 'Aucun produit n\'a été ajouté à la liste de souhaits.',
                'move-to-cart'       => 'Déplacer vers le panier',
                'moved'              => 'Article déplacé avec succès dans le panier',
                'moved-success'      => 'Article déplacé avec succès dans le panier',
                'page-title'         => 'Liste de souhaits',
                'product-removed'    => 'Le produit n\'est plus disponible car il a été supprimé par l\'administrateur.',
                'profile'            => 'Profil',
                'remove'             => 'Supprimer',
                'remove-all-success' => 'Tous les articles de votre liste de souhaits ont été supprimés',
                'remove-fail'        => 'L\'article ne peut pas être supprimé de la liste de souhaits.',
                'removed'            => 'Article supprimé avec succès de la liste de souhaits',
                'see-details'        => 'Voir les détails',
                'success'            => 'Article ajouté avec succès à la liste de souhaits',
                'title'              => 'Liste de souhaits',
            ],

            'gdpr' => [
                'create-success'              => 'Demande créée avec succès',
                'revoked-successfully'        => 'Demande révoquée avec succès',
                'success-verify'              => 'Succès ! L\'e-mail de vérification a été envoyé.',
                'success-verify-email-unsent' => 'Succès ! L\'e-mail de vérification n\'a pas été envoyé.',
                'unable-to-sent'              => 'Impossible d\'envoyer l\'e-mail.',

                'index'   => [
                    'create-btn' => 'Créer une demande',
                    'html'       => 'HTML',
                    'pdf'        => 'PDF',
                    'title'      => 'Demandes de données GDPR',

                    'modal' => [
                        'message' => 'Message',
                        'save'    => 'Enregistrer',
                        'title'   => 'Créer une nouvelle demande',

                        'type'    => [
                            'choose' => 'Choisir',
                            'delete' => 'Supprimer',
                            'title'  => 'Type',
                            'update' => 'Mettre à jour',
                        ],
                    ],

                    'datagrid' => [
                        'completed'  => 'Terminé',
                        'date'       => 'Date',
                        'declined'   => 'Refusé',
                        'delete'     => 'Supprimer',
                        'id'         => 'ID',
                        'message'    => 'Message',
                        'pending'    => 'En attente',
                        'processing' => 'En traitement',
                        'revoke-btn' => 'Révoquer',
                        'revoked'    => 'Révoqué',
                        'status'     => 'Statut',
                        'type'       => 'Type',
                        'update'     => 'Mettre à jour',
                    ],
                ],

                'pdf' => [
                    'title' => 'Vue par défaut du magasin',

                    'account-info' => [
                        'dob'          => 'Date de naissance',
                        'email'        => 'E-mail',
                        'first-name'   => 'Prénom',
                        'gender'       => 'Genre',
                        'last-name'    => 'Nom de famille',
                        'phone'        => 'Téléphone',
                        'title'        => 'Informations du compte',
                    ],

                    'address-info' => [
                        'address'    => 'Adresse',
                        'address1'   => 'Adresse 1',
                        'address2'   => 'Adresse 2',
                        'city'       => 'Ville',
                        'company'    => 'Entreprise',
                        'country'    => 'Pays',
                        'first-name' => 'Prénom',
                        'last-name'  => 'Nom de famille',
                        'phone'      => 'Téléphone',
                        'postcode'   => 'Code postal',
                        'state'      => 'État',
                        'title'      => 'Informations de l\'adresse',
                        'vat-id'     => 'ID TVA',
                    ],

                    'order-info' => [
                        'amount'       => 'Montant',
                        'order-id'     => 'ID de commande',
                        'product-name' => 'Nom du produit',
                        'qty'          => 'Quantité',
                        'shipping'     => 'Livraison',
                        'sku'          => 'SKU',
                        'status'       => 'Statut',
                        'title'        => 'Informations de commande',
                        'type'         => 'Type',
                    ],
                ],
            ],
        ],
    ],

    'components' => [
        'accordion' => [
            'default-content' => 'Contenu par défaut',
            'default-header'  => 'En-tête par défaut',
        ],

        'drawer' => [
            'default-toggle' => 'Basculer par défaut',
        ],

        'media' => [
            'index' => [
                'add-attachments' => 'Ajouter des pièces jointes',
                'add-image'       => 'Ajouter une image/vidéo',
            ],
        ],

        'layouts' => [
            'header' => [
                'desktop' => [
                    'top' => [
                        'default-locale' => 'Langue par défaut',
                    ],

                    'bottom' => [
                        'all'           => 'Tout',
                        'back-button'   => 'Retour au menu principal',
                        'bagisto'       => 'Bagisto',
                        'categories'    => 'Catégories',
                        'compare'       => 'Comparer',
                        'dropdown-text' => 'Gérer le panier, les commandes et la liste de souhaits',
                        'logout'        => 'Se déconnecter',
                        'orders'        => 'Commandes',
                        'profile'       => 'Profil',
                        'search'        => 'Recherche',
                        'search-text'   => 'Recherchez des produits ici',
                        'sign-in'       => 'Connexion',
                        'sign-up'       => 'S’inscrire',
                        'submit'        => 'Soumettre',
                        'welcome'       => 'Bienvenue',
                        'welcome-guest' => 'Bienvenue invité',
                        'wishlist'      => 'Liste de souhaits',
                    ],
                ],

                'mobile' => [
                    'account'       => 'Compte',
                    'back-button'   => 'Retour au menu principal',
                    'bagisto'       => 'Bagisto',
                    'compare'       => 'Comparer',
                    'currencies'    => 'Devises',
                    'dropdown-text' => 'Gérer le panier, les commandes et la liste de souhaits',
                    'locales'       => 'Langues',
                    'login'         => 'Connexion ou inscription',
                    'logout'        => 'Se déconnecter',
                    'orders'        => 'Commandes',
                    'profile'       => 'Profil',
                    'search'        => 'Recherche',
                    'search-text'   => 'Recherchez des produits ici',
                    'sign-in'       => 'Connexion',
                    'sign-up'       => 'S’inscrire',
                    'welcome'       => 'Bienvenue',
                    'welcome-guest' => 'Bienvenue invité',
                    'wishlist'      => 'Liste de souhaits',
                ],
            ],

            'footer' => [
                'about-us'               => 'À propos de nous',
                'contact-us'             => 'Contactez-nous',
                'currency'               => 'Devise',
                'customer-service'       => 'Service client',
                'email'                  => 'E-mail',
                'footer-content'         => 'Contenu du pied de page',
                'footer-text'            => '© Copyright 2010 - :current_year, Webkul Software (enregistré en Inde). Tous droits réservés.',
                'locale'                 => 'Langue',
                'newsletter-text'        => 'Préparez-vous pour notre newsletter amusante !',
                'order-return'           => 'Commande et retours',
                'payment-policy'         => 'Politique de paiement',
                'privacy-cookies-policy' => 'Politique de confidentialité et de cookies',
                'shipping-policy'        => 'Politique d\'expédition',
                'subscribe'              => 'Souscrire',
                'subscribe-newsletter'   => 'Souscrire à la newsletter',
                'subscribe-stay-touch'   => 'Abonnez-vous pour rester en contact.',
                'whats-new'              => 'Quoi de neuf',
            ],

            'cookie' => [
                'index' => [
                    'privacy-policy'           => 'Politique de confidentialité',
                    'reject'                   => 'Rejeter',
                    'accept'                   => 'Accepter',
                    'learn-more-and-customize' => 'En savoir plus et personnaliser',
                ],

                'consent' => [
                    'your-cookie-consent-preferences'         => 'Vos préférences de consentement aux cookies',
                    'save-and-continue'                       => 'Enregistrer et continuer',
                    'strictly-necessary'                      => 'Strictement nécessaire',
                    'basic-interactions'                      => 'Interactions et fonctionnalités de base',
                    'experience-enhancement'                  => 'Amélioration de l\'expérience',
                    'measurements'                            => 'Mesure',
                    'targeting-and-advertising'               => 'Ciblage et publicité',
                ],
            ],
        ],

        'datagrid' => [
            'toolbar' => [
                'length-of' => ':length de',
                'results'   => ':total Résultats',
                'selected'  => ':total Sélectionné',

                'mass-actions' => [
                    'must-select-a-mass-action'        => 'Vous devez sélectionner une action de masse.',
                    'must-select-a-mass-action-option' => 'Vous devez sélectionner une option d\'action de masse.',
                    'no-records-selected'              => 'Aucun enregistrement n\'a été sélectionné.',
                    'select-action'                    => 'Sélectionner une action',
                ],

                'search' => [
                    'title' => 'Rechercher',
                ],

                'filter' => [
                    'apply-filter' => 'Appliquer les filtres',
                    'title'        => 'Filtrer',

                    'dropdown' => [
                        'select' => 'Sélectionner',

                        'searchable' => [
                            'at-least-two-chars' => 'Saisissez au moins 2 caractères...',
                            'no-results'         => 'Aucun résultat trouvé...',
                        ],
                    ],

                    'custom-filters' => [
                        'clear-all' => 'Effacer tout',
                    ],
                ],
            ],

            'table' => [
                'actions'              => 'Actions',
                'next-page'            => 'Page suivante',
                'no-records-available' => 'Aucun enregistrement disponible.',
                'of'                   => 'de :total entrées',
                'page-navigation'      => 'Navigation de page',
                'page-number'          => 'Numéro de page',
                'previous-page'        => 'Page précédente',
                'showing'              => 'Affichage de :firstItem',
                'to'                   => 'à :lastItem',
            ],
        ],

        'modal' => [
            'default-content' => 'Contenu par défaut',
            'default-header'  => 'En-tête par défaut',

            'confirm' => [
                'agree-btn'    => 'D\'accord',
                'disagree-btn' => 'Pas d\'accord',
                'message'      => 'Êtes-vous sûr de vouloir effectuer cette action ?',
                'title'        => 'Êtes-vous sûr ?',
            ],
        ],

        'products' => [
            'card' => [
                'add-to-cart'            => 'Ajouter au panier',
                'add-to-compare'         => 'Ajouter à la liste de comparaison',
                'add-to-compare-success' => 'Article ajouté avec succès à la liste de comparaison.',
                'add-to-wishlist'        => 'Ajouter à la liste de souhaits',
                'already-in-compare'     => 'L\'article est déjà ajouté à la liste de comparaison.',
                'new'                    => 'Nouveau',
                'review-description'     => 'Soyez le premier à évaluer ce produit',
                'sale'                   => 'En solde',
            ],

            'carousel' => [
                'next'     => 'Suivant',
                'previous' => 'Précédent',
                'view-all' => 'Voir tout',
            ],

            'ratings' => [
                'title' => 'Évaluations',
            ],
        ],

        'range-slider' => [
            'min-range' => 'Plage minimale',
            'max-range' => 'Plage maximale',
            'range'     => 'Plage :',
        ],

        'carousel' => [
            'image-slide' => 'Diapositive d\'image',
            'next'        => 'Suivant',
            'previous'    => 'Précédent',
        ],

        'quantity-changer' => [
            'decrease-quantity' => 'Diminuer la quantité',
            'increase-quantity' => 'Augmenter la quantité',
        ],
    ],

    'products' => [
        'prices' => [
            'grouped' => [
                'starting-at' => 'À partir de',
            ],

            'configurable' => [
                'as-low-as' => 'À partir de',
            ],
        ],

        'sort-by' => [
            'title'   => 'Trier par',
        ],

        'view' => [
            'type' => [
                'simple' => [
                    'customizable-options' => [
                        'none'         => 'Aucun',
                        'total-amount' => 'Montant total',
                    ],
                ],

                'configurable' => [
                    'select-options'       => 'Veuillez sélectionner une option',
                    'select-above-options' => 'Veuillez sélectionner les options ci-dessus',
                ],

                'bundle' => [
                    'none'         => 'Aucun',
                    'total-amount' => 'Montant total',
                ],

                'downloadable' => [
                    'links'   => 'Liens',
                    'sample'  => 'Échantillon',
                    'samples' => 'Échantillons',
                ],

                'grouped' => [
                    'name' => 'Nom',
                ],

                'booking' => [
                    'location'    => 'Emplacement',
                    'view-on-map' => 'Voir sur la carte',

                    'default' => [
                        'slot-duration-in-minutes' => ':minutes Minutes',
                        'slot-duration'            => 'Durée du créneau',
                    ],

                    'appointment' => [
                        'closed'                   => 'Fermé',
                        'see-details'              => 'Voir les détails',
                        'slot-duration'            => 'Durée du créneau',
                        'slot-duration-in-minutes' => ':minutes Minutes',
                        'today-availability'       => 'Disponibilité aujourd\'hui',
                    ],

                    'event' => [
                        'book-your-ticket' => 'Réservez votre billet',
                        'title'            => 'Événement le :',
                    ],

                    'rental'      => [
                        'choose-rent-option' => 'Choisissez l\'option de location',
                        'daily-basis'        => 'Base quotidienne',
                        'from'               => 'De',
                        'hourly-basis'       => 'Base horaire',
                        'rent-an-item'       => 'Louer un article',
                        'select-date'        => 'Sélectionner une date',
                        'select-rent-time'   => 'Sélectionner l\'heure de location',
                        'select-slot'        => 'Sélectionner un créneau',
                        'select-time-slot'   => 'Sélectionner un créneau horaire',
                        'slot'               => 'Créneau',
                        'no-slots-available' => 'Aucun créneau disponible',
                        'to'                 => 'À',
                    ],

                    'table'       => [
                        'book-a-table'             => 'Réserver une table',
                        'closed'                   => 'Fermé',
                        'slot-duration'            => 'Durée du créneau',
                        'slot-duration-in-minutes' => ':minutes Minutes',
                        'slots-for-all-days'       => 'Afficher pour tous les jours',
                        'special-notes'            => 'Demande/Notes spéciales',
                        'today-availability'       => 'Disponibilité aujourd\'hui',
                    ],

                    'slots' => [
                        'book-an-appointment' => 'Prendre un rendez-vous',
                        'date'                => 'Date',
                        'no-slots-available'  => 'Aucun créneau disponible',
                        'select-slot'         => 'Sélectionner un créneau',
                        'title'               => 'Créneau',
                    ],
                ],
            ],

            'gallery' => [
                'product-image'   => 'Image du produit',
                'thumbnail-image' => 'Image miniature',
            ],

            'reviews' => [
                'attachments'      => 'Pièces jointes',
                'cancel'           => 'Annuler',
                'comment'          => 'Commentaire',
                'customer-review'  => 'Avis clients',
                'empty-review'     => 'Aucun avis trouvé, soyez le premier à évaluer ce produit.',
                'failed-to-upload' => 'Échec du téléchargement de l\'image',
                'load-more'        => 'Charger plus',
                'name'             => 'Nom',
                'rating'           => 'Évaluation',
                'ratings'          => 'Notes',
                'submit-review'    => 'Envoyer un avis',
                'success'          => 'Avis soumis avec succès.',
                'title'            => 'Titre',
                'translate'        => 'Traduire',
                'translating'      => 'En cours de traduction...',
                'write-a-review'   => 'Rédiger un avis',
            ],

            'add-to-cart'            => 'Ajouter au panier',
            'add-to-compare'         => 'Produit ajouté à la liste de comparaison.',
            'add-to-wishlist'        => 'Ajouter à la liste de souhaits',
            'additional-information' => 'Informations complémentaires',
            'already-in-compare'     => 'Le produit est déjà ajouté à la liste de comparaison.',
            'buy-now'                => 'Acheter maintenant',
            'compare'                => 'Comparer',
            'description'            => 'Description',
            'related-product-title'  => 'Produits connexes',
            'review'                 => 'Avis',
            'tax-inclusive'          => 'Taxes incluses',
            'up-sell-title'          => 'Nous avons trouvé d\'autres produits qui pourraient vous plaire !',
        ],

        'type' => [
            'abstract' => [
                'offers' => 'Achetez :qty pour :price chacun et économisez :discount',
            ],
        ],

        'booking' => [
            'closed' => 'Fermé',

            'cart'             => [
                'booking-from' => 'Réservation de',
                'booking-till' => 'Réservation jusqu\'à',
                'daily'        => 'Base quotidienne',
                'event-from'   => 'Événement de',
                'event-ticket' => 'Billet d\'événement',
                'event-till'   => 'Événement jusqu\'à',
                'hourly'       => 'Base horaire',

                'integrity'    => [
                    'event'                  => [
                        'expired' => 'Cet événement a expiré.',
                    ],

                    'missing_options'        => 'Les options sont manquantes pour ce produit.',
                    'inventory_warning'      => 'La quantité demandée n\'est pas disponible, veuillez réessayer plus tard.',
                    'select_hourly_duration' => 'Sélectionnez une durée de créneau d\'une heure.',
                ],

                'rent-from'    => 'Louer de',
                'rent-till'    => 'Louer jusqu\'à',
                'rent-type'    => 'Type de location',
                'renting_type' => 'Type de location',
                'special-note' => 'Demande/Notes spéciales',
            ],

            'per-ticket-price' => ':price Par Billet',
        ],
    ],

    'categories' => [
        'filters' => [
            'clear-all' => 'Tout effacer',
            'filter'    => 'Filtre',
            'filters'   => 'Filtres :',

            'search' => [
                'load-more'            => 'Charger plus',
                'loading'              => 'Chargement...',
                'no-options-available' => 'Aucune option disponible.',
                'results-info'         => 'Affichage de :currentCount sur :totalCount options',
                'title'                => 'Recherche',
            ],

            'sort'      => 'Trier',
        ],

        'toolbar' => [
            'grid' => 'Grille',
            'list' => 'Liste',
            'show' => 'Afficher',
        ],

        'view' => [
            'empty'     => 'Aucun produit disponible dans cette catégorie',
            'load-more' => 'Charger plus',
        ],
    ],

    'search' => [
        'title'   => 'Résultats de recherche pour : :query',
        'results' => 'Résultats de recherche',

        'images' => [
            'index' => [
                'only-images-allowed'  => 'Seules les images (.jpeg, .jpg, .png, ..) sont autorisées.',
                'search'               => 'Rechercher',
                'size-limit-error'     => 'Erreur de limite de taille',
                'something-went-wrong' => 'Quelque chose s\'est mal passé, veuillez réessayer ultérieurement.',
            ],

            'results' => [
                'analyzed-keywords' => 'Mots-clés analysés :',
            ],
        ],
    ],

    'compare' => [
        'already-added'      => 'L\'article est déjà ajouté à la liste de comparaison',
        'delete-all'         => 'Tout supprimer',
        'empty-text'         => 'Vous n\'avez aucun article dans votre liste de comparaison',
        'item-add-success'   => 'L\'article a été ajouté avec succès à la liste de comparaison',
        'product-compare'    => 'Comparaison de produits',
        'remove-all-success' => 'Tous les articles ont été supprimés avec succès.',
        'remove-error'       => 'Une erreur s\'est produite, veuillez réessayer ultérieurement.',
        'remove-success'     => 'L\'article a été supprimé avec succès.',
        'title'              => 'Comparaison de produits',
    ],

    'checkout' => [
        'success' => [
            'info'          => 'Nous vous enverrons par e-mail les détails de votre commande ainsi que les informations de suivi.',
            'order-id-info' => 'Votre numéro de commande est le #:order_id',
            'thanks'        => 'Merci pour votre commande !',
            'title'         => 'Commande passée avec succès',
        ],

        'cart' => [
            'continue-to-checkout'      => 'Continuer vers la caisse',
            'illegal'                   => 'La quantité ne peut pas être inférieure à un.',
            'inactive-add'              => 'L\'article inactif ne peut pas être ajouté au panier.',
            'inactive'                  => 'L\'article a été désactivé et retiré du panier.',
            'inventory-warning'         => 'La quantité demandée n\'est pas disponible, veuillez réessayer ultérieurement.',
            'item-add-to-cart'          => 'Article ajouté avec succès',
            'minimum-order-message'     => 'Le montant minimum de commande est de',
            'missing-fields'            => 'Certains champs obligatoires sont manquants pour ce produit.',
            'missing-options'           => 'Les options sont manquantes pour ce produit.',
            'paypal-payment-cancelled'  => 'Le paiement Paypal a été annulé.',
            'qty-missing'               => 'Au moins un produit doit avoir une quantité supérieure à 1.',
            'return-to-shop'            => 'Retourner à la boutique',
            'rule-applied'              => 'Règle du panier appliquée',
            'select-hourly-duration'    => 'Sélectionnez une durée d\'une heure.',
            'success-remove'            => 'L\'article a été supprimé avec succès du panier.',
            'suspended-account-message' => 'Votre compte a été suspendu.',

            'index' => [
                'bagisto'                  => 'Bagisto',
                'cart'                     => 'Panier',
                'continue-shopping'        => 'Continuer vos achats',
                'empty-product'            => 'Vous n\'avez pas de produit dans votre panier.',
                'excl-tax'                 => 'Hors taxes :',
                'home'                     => 'Accueil',
                'items-selected'           => ':count éléments sélectionnés',
                'move-to-wishlist'         => 'Déplacer dans la liste de souhaits',
                'move-to-wishlist-success' => 'Les articles sélectionnés ont été déplacés avec succès dans la liste de souhaits.',
                'price'                    => 'Prix',
                'product-name'             => 'Nom du produit',
                'quantity'                 => 'Quantité',
                'quantity-update'          => 'Quantité mise à jour avec succès',
                'remove'                   => 'Supprimer',
                'remove-selected-success'  => 'Les articles sélectionnés ont été supprimés avec succès du panier.',
                'see-details'              => 'Voir les détails',
                'select-all'               => 'Sélectionner tout',
                'select-cart-item'         => 'Sélectionner l\'article du panier',
                'tax'                      => 'Taxes',
                'total'                    => 'Total',
                'update-cart'              => 'Mettre à jour le panier',
                'view-cart'                => 'Voir le panier',

                'cross-sell' => [
                    'title' => 'Plus de choix',
                ],
            ],

            'mini-cart' => [
                'continue-to-checkout' => 'Continuer la commande',
                'empty-cart'           => 'Votre panier est vide',
                'excl-tax'             => 'Hors taxes :',
                'offer-on-orders'      => 'Bénéficiez de jusqu\'à 30% de réduction sur votre 1ère commande',
                'remove'               => 'Supprimer',
                'see-details'          => 'Voir les détails',
                'shopping-cart'        => 'Panier d\'achat',
                'subtotal'             => 'Sous-total',
                'view-cart'            => 'Voir le panier',
            ],

            'summary' => [
                'cart-summary'              => 'Résumé du panier',
                'delivery-charges'          => 'Frais de livraison',
                'delivery-charges-excl-tax' => 'Frais de livraison (Hors taxes)',
                'delivery-charges-incl-tax' => 'Frais de livraison (TTC)',
                'discount-amount'           => 'Montant de réduction',
                'grand-total'               => 'Total général',
                'place-order'               => 'Passer la commande',
                'proceed-to-checkout'       => 'Passer à la caisse',
                'sub-total'                 => 'Sous-total',
                'sub-total-excl-tax'        => 'Sous-total (Hors taxes)',
                'sub-total-incl-tax'        => 'Sous-total (TTC)',
                'tax'                       => 'Taxe',

                'estimate-shipping' => [
                    'country'        => 'Pays',
                    'info'           => 'Entrez votre destination pour obtenir une estimation des frais de livraison et des taxes.',
                    'postcode'       => 'Code postal',
                    'select-country' => 'Sélectionner le pays',
                    'select-state'   => 'Sélectionner l\'état',
                    'state'          => 'État',
                    'title'          => 'Estimation des frais de livraison et des taxes',
                ],
            ],
        ],

        'onepage' => [
            'address' => [
                'add-new'                => 'Ajouter une nouvelle adresse',
                'add-new-address'        => 'Ajouter une nouvelle adresse',
                'back'                   => 'Retour',
                'billing-address'        => 'Adresse de facturation',
                'check-billing-address'  => 'L\'adresse de facturation est manquante.',
                'check-shipping-address' => 'L\'adresse de livraison est manquante.',
                'city'                   => 'Ville',
                'company-name'           => 'Nom de l\'entreprise',
                'confirm'                => 'Confirmer',
                'country'                => 'Pays',
                'email'                  => 'E-mail',
                'first-name'             => 'Prénom',
                'last-name'              => 'Nom de famille',
                'postcode'               => 'Code postal',
                'proceed'                => 'Continuer',
                'same-as-billing'        => 'Utiliser la même adresse pour la livraison ?',
                'save'                   => 'Enregistrer',
                'save-address'           => 'Enregistrer dans le carnet d\'adresses',
                'select-country'         => 'Sélectionner le pays',
                'select-state'           => 'Sélectionner l\'état',
                'shipping-address'       => 'Adresse de livraison',
                'state'                  => 'État',
                'street-address'         => 'Adresse de rue',
                'telephone'              => 'Téléphone',
                'title'                  => 'Adresse',
                'vat-id'                 => 'Numéro de TVA',
            ],

            'index' => [
                'checkout' => 'Caisse',
                'home'     => 'Accueil',
            ],

            'payment' => [
                'payment-method' => 'Méthode de paiement',
            ],

            'shipping' => [
                'shipping-method' => 'Méthode d\'expédition',
            ],

            'summary' => [
                'cart-summary'              => 'Résumé du panier',
                'delivery-charges'          => 'Frais de livraison',
                'delivery-charges-excl-tax' => 'Frais de livraison (Hors taxes)',
                'delivery-charges-incl-tax' => 'Frais de livraison (TTC)',
                'discount-amount'           => 'Montant de réduction',
                'excl-tax'                  => 'Hors taxes :',
                'grand-total'               => 'Total général',
                'place-order'               => 'Passer la commande',
                'price_&_qty'               => ':price × :qty',
                'processing'                => 'En cours de traitement',
                'sub-total'                 => 'Sous-total',
                'sub-total-excl-tax'        => 'Sous-total (Hors taxes)',
                'sub-total-incl-tax'        => 'Sous-total (TTC)',
                'tax'                       => 'Taxe',
            ],
        ],

        'coupon' => [
            'already-applied' => 'Le code de coupon a déjà été appliqué.',
            'applied'         => 'Coupon appliqué',
            'apply'           => 'Appliquer le coupon',
            'apply-issue'     => 'Le code de coupon ne peut pas être appliqué.',
            'button-title'    => 'Appliquer',
            'code'            => 'Code de coupon',
            'discount'        => 'Remise du coupon',
            'enter-your-code' => 'Entrez votre code',
            'error'           => 'Une erreur s\'est produite',
            'invalid'         => 'Le code de coupon est invalide.',
            'remove'          => 'Supprimer le coupon',
            'subtotal'        => 'Sous-total',
            'success-apply'   => 'Le code de coupon a été appliqué avec succès.',
        ],

        'login' => [
            'email'    => 'E-mail',
            'password' => 'Mot de passe',
            'title'    => 'Connexion',
        ],
    ],

    'home' => [
        'contact' => [
            'about'         => 'Laissez-nous une note et nous vous répondrons dès que possible',
            'desc'          => 'Qu\'est-ce qui vous préoccupe ?',
            'describe-here' => 'Décrivez ici',
            'email'         => 'E-mail',
            'message'       => 'Message',
            'name'          => 'Nom',
            'phone-number'  => 'Numéro de téléphone',
            'submit'        => 'Envoyer',
            'title'         => 'Contactez-nous',
        ],

        'index' => [
            'categories-carousel' => 'Carrousel de catégories',
            'image-carousel'      => 'Carrousel d\'images',
            'offer'               => 'Obtenez JUSQU\'À 40% DE RÉDUCTION sur votre 1ère commande, ACHETEZ MAINTENANT',
            'product-carousel'    => 'Carrousel de produits',
            'resend-verify-email' => 'Renvoyer l\'e-mail de vérification',
            'verify-email'        => 'Vérifiez votre compte e-mail',
        ],

        'thanks-for-contact' => 'Merci de nous contacter avec vos commentaires et questions. Nous vous répondrons très bientôt.',
    ],

    'partials' => [
        'pagination' => [
            'next-page'          => 'Page suivante',
            'pagination-showing' => 'Affichage de :firstItem à :lastItem sur :total entrées',
            'prev-page'          => 'Page précédente',
        ],
    ],

    'errors' => [
        'go-to-home' => 'Aller à la page d\'accueil',

        '404' => [
            'description' => 'Oups ! La page que vous recherchez est en vacances. Il semble que nous n\'ayons pas pu trouver ce que vous cherchiez.',
            'title'       => '404 Page non trouvée',
        ],

        '401' => [
            'description' => 'Oups ! Il semble que vous n\'ayez pas l\'autorisation d\'accéder à cette page. Vous semblez manquer des informations d\'identification nécessaires.',
            'title'       => '401 Non autorisé',
        ],

        '403' => [
            'description' => 'Oups ! Cette page est interdite. Il semble que vous n\'ayez pas les autorisations nécessaires pour afficher ce contenu.',
            'title'       => '403 Interdit',
        ],

        '500' => [
            'description' => 'Oups ! Quelque chose s\'est mal passé. Il semble que nous ayons des problèmes pour charger la page que vous recherchez.',
            'title'       => '500 Erreur interne du serveur',
        ],

        '503' => [
            'description' => 'Oups ! Il semble que nous soyons temporairement en maintenance. Veuillez revenir un peu plus tard.',
            'title'       => '503 Service non disponible',
        ],
    ],

    'layouts' => [
        'address'               => 'Adresse',
        'downloadable-products' => 'Produits téléchargeables',
        'gdpr-request'          => 'Demandes GDPR',
        'my-account'            => 'Mon compte',
        'orders'                => 'Commandes',
        'profile'               => 'Profil',
        'reviews'               => 'Avis',
        'wishlist'              => 'Liste de souhaits',
    ],

    'subscription' => [
        'already'             => 'Vous êtes déjà abonné à notre newsletter.',
        'subscribe-success'   => 'Vous vous êtes abonné avec succès à notre newsletter.',
        'unsubscribe-success' => 'Vous vous êtes désabonné avec succès de notre newsletter.',
    ],

    'emails' => [
        'dear'   => 'Cher :customer_name',
        'thanks' => 'Si vous avez besoin d\'aide de quelque nature que ce soit, veuillez nous contacter à l\'adresse <a href=":link" style=":style">:email</a>.<br/>Merci !',

        'customers' => [
            'registration' => [
                'credentials-description' => 'Votre compte a été créé. Les détails de votre compte sont ci-dessous :',
                'description'             => 'Votre compte a été créé avec succès et vous pouvez vous connecter en utilisant votre adresse e-mail et vos informations d\'identification par mot de passe. Après vous être connecté, vous pourrez accéder à d\'autres services, y compris la consultation de commandes passées, de listes de souhaits et la modification de vos informations de compte.',
                'greeting'                => 'Bienvenue et merci de vous être inscrit chez nous !',
                'password'                => 'Mot de passe',
                'sign-in'                 => 'Se connecter',
                'subject'                 => 'Nouvelle inscription de client',
                'username-email'          => 'Nom d\'utilisateur/Email',
            ],

            'forgot-password' => [
                'description'    => 'Vous recevez cet e-mail car nous avons reçu une demande de réinitialisation de mot de passe pour votre compte.',
                'greeting'       => 'Mot de passe oublié !',
                'reset-password' => 'Réinitialiser le mot de passe',
                'subject'        => 'E-mail de réinitialisation de mot de passe',
            ],

            'update-password' => [
                'description' => 'Vous recevez cet e-mail car vous avez mis à jour votre mot de passe.',
                'greeting'    => 'Mot de passe mis à jour !',
                'subject'     => 'Mot de passe mis à jour',
            ],

            'verification' => [
                'description'  => 'Veuillez cliquer sur le bouton ci-dessous pour vérifier votre adresse e-mail.',
                'greeting'     => 'Bienvenue !',
                'subject'      => 'E-mail de vérification du compte',
                'verify-email' => 'Vérifier l\'adresse e-mail',
            ],

            'commented' => [
                'description' => 'Note : :note',
                'subject'     => 'Nouveau commentaire ajouté',
            ],

            'subscribed' => [
                'description' => 'Félicitations et bienvenue dans notre communauté de newsletter ! Nous sommes ravis de vous avoir à bord et de vous tenir informé des dernières actualités, tendances et offres exclusives.',
                'greeting'    => 'Bienvenue à notre newsletter !',
                'subject'     => 'Vous êtes abonné à notre newsletter',
                'unsubscribe' => 'Se désabonner',
            ],

            'gdpr' => [
                'new-delete-request' => 'Nouvelle demande de suppression de données',
                'new-update-request' => 'Nouvelle demande de mise à jour des données',

                'new-request' => [
                    'delete-summary' => 'Résumé de la demande de suppression',
                    'message'        => 'Message : ',
                    'request-status' => 'Statut de la demande : ',
                    'request-type'   => 'Type de demande : ',
                    'update-summary' => 'Résumé de la demande de mise à jour',
                ],

                'status-update' => [
                    'subject'        => 'Votre demande GDPR a été mise à jour',
                    'summary'        => 'Le statut de votre demande GDPR a été mis à jour',
                    'request-status' => 'Statut de la demande:',
                    'request-type'   => 'Type de demande:',
                    'message'        => 'Message:',
                ],
            ],

            'reminder' => [
                'already-paid'    => 'Si vous avez déjà effectué le paiement, veuillez ignorer ce message.',
                'invoice-overdue' => 'Ceci est un rappel amical que votre facture est maintenant en retard. Nous vous prions de bien vouloir effectuer le paiement dès que possible.',
                'subject'         => 'Rappel de facture',
            ],
        ],

        'contact-us' => [
            'contact-from'    => 'via Formulaire de contact du site',
            'reply-to-mail'   => 'veuillez répondre à cet e-mail.',
            'reach-via-phone' => 'Alternativement, vous pouvez nous joindre par téléphone au',
            'inquiry-from'    => 'Demande de',
            'to'              => 'Pour contacter',
        ],

        'orders' => [
            'created' => [
                'greeting' => 'Merci pour votre commande :order_id passée le :created_at',
                'subject'  => 'Nouvelle confirmation de commande',
                'summary'  => 'Résumé de la commande',
                'title'    => 'Confirmation de commande !',
            ],

            'invoiced' => [
                'greeting' => 'Votre facture #:invoice_id pour la commande :order_id créée le :created_at',
                'subject'  => 'Nouvelle confirmation de facture',
                'summary'  => 'Résumé de la facture',
                'title'    => 'Confirmation de facture !',
            ],

            'shipped' => [
                'greeting' => 'Votre commande :order_id passée le :created_at a été expédiée',
                'subject'  => 'Nouvelle confirmation d\'expédition',
                'summary'  => 'Résumé de l\'expédition',
                'title'    => 'Commande expédiée !',
            ],

            'refunded' => [
                'greeting' => 'Le remboursement a été initié pour la commande :order_id passée le :created_at',
                'subject'  => 'Nouvelle confirmation de remboursement',
                'summary'  => 'Résumé du remboursement',
                'title'    => 'Commande remboursée !',
            ],

            'canceled' => [
                'greeting' => 'Votre commande :order_id passée le :created_at a été annulée',
                'subject'  => 'Nouvelle annulation de commande',
                'summary'  => 'Résumé de la commande',
                'title'    => 'Commande annulée !',
            ],

            'commented' => [
                'subject' => 'Nouveau commentaire ajouté',
                'title'   => 'Nouveau commentaire ajouté à votre commande :order_id passée le :created_at',
            ],

            'billing-address'            => 'Adresse de facturation',
            'carrier'                    => 'Transporteur',
            'contact'                    => 'Contact',
            'discount'                   => 'Remise',
            'excl-tax'                   => 'Hors taxes : ',
            'grand-total'                => 'Total général',
            'name'                       => 'Nom',
            'payment'                    => 'Paiement',
            'price'                      => 'Prix',
            'qty'                        => 'Quantité',
            'shipping'                   => 'Livraison',
            'shipping-address'           => 'Adresse de livraison',
            'shipping-handling'          => 'Frais de livraison',
            'shipping-handling-excl-tax' => 'Frais de livraison (Hors taxes)',
            'shipping-handling-incl-tax' => 'Frais de livraison (TTC)',
            'sku'                        => 'SKU',
            'subtotal'                   => 'Sous-total',
            'subtotal-excl-tax'          => 'Sous-total (Hors taxes)',
            'subtotal-incl-tax'          => 'Sous-total (TTC)',
            'tax'                        => 'Taxe',
            'tracking-number'            => 'Numéro de suivi : :tracking_number',
        ],
    ],
];
