
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `akaunting3119`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]accounts`
--

CREATE TABLE `[[dbprefix]]accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'bank',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `opening_balance` double(15,4) NOT NULL DEFAULT '0.0000',
  `bank_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_address` text COLLATE utf8mb4_unicode_ci,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]accounts_company_id_index` (`company_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]accounts`
--

INSERT INTO `[[dbprefix]]accounts` VALUES
(1, 1, 'bank', 'Cash', '1', 'USD', 0.0000, 'Cash', NULL, NULL, 1, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `parent_id` int(10) unsigned DEFAULT NULL,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]categories_company_id_index` (`company_id`),
  KEY `[[dbprefix]]categories_parent_id_foreign` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(1, 1, 'Transfer', 'other', '#3c3f72', 1, NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(2, 1, 'Deposit', 'income', '#efad32', 1, NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(3, 1, 'Sales', 'income', '#6da252', 1, NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(4, 1, 'Other', 'expense', '#e5e5e5', 1, NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(5, 1, 'General', 'item', '#328aef', 1, NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]companies`
--

CREATE TABLE `[[dbprefix]]companies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]companies`
--

INSERT INTO `[[dbprefix]]companies` VALUES
(1, '', 1, 'core::ui', NULL, '[[regtime]]', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contacts`
--

CREATE TABLE `[[dbprefix]]contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `tax_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `reference` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]contacts_company_id_type_email_deleted_at_unique` (`company_id`,`type`,`email`,`deleted_at`),
  KEY `[[dbprefix]]contacts_company_id_type_index` (`company_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_persons`
--

CREATE TABLE `[[dbprefix]]contact_persons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]contact_persons_company_id_index` (`company_id`),
  KEY `[[dbprefix]]contact_persons_type_index` (`type`),
  KEY `[[dbprefix]]contact_persons_contact_id_index` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]currencies`
--

CREATE TABLE `[[dbprefix]]currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate` double(15,8) NOT NULL,
  `precision` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `symbol` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `symbol_first` int(11) NOT NULL DEFAULT '1',
  `decimal_mark` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `thousands_separator` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enabled` tinyint(4) NOT NULL DEFAULT '1',
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]currencies_company_id_code_deleted_at_unique` (`company_id`,`code`,`deleted_at`),
  KEY `[[dbprefix]]currencies_company_id_index` (`company_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]currencies`
--

INSERT INTO `[[dbprefix]]currencies` VALUES
(1, 1, 'US Dollar', 'USD', 1.00000000, '2', '$', 1, '.', ',', 1, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dashboards`
--

CREATE TABLE `[[dbprefix]]dashboards` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]dashboards_company_id_index` (`company_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]dashboards`
--

INSERT INTO `[[dbprefix]]dashboards` VALUES
(1, 1, 'Dashboard', 1, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]documents`
--

CREATE TABLE `[[dbprefix]]documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `document_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `issued_at` datetime NOT NULL,
  `due_at` datetime NOT NULL,
  `amount` double(15,4) NOT NULL,
  `currency_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_rate` double(15,8) NOT NULL,
  `discount_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_rate` double(15,4) DEFAULT NULL,
  `category_id` int(10) unsigned NOT NULL DEFAULT '1',
  `contact_id` int(10) unsigned NOT NULL,
  `contact_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_tax_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_address` text COLLATE utf8mb4_unicode_ci,
  `contact_city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_zip_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subheading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `footer` text COLLATE utf8mb4_unicode_ci,
  `template` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]documents_document_number_deleted_at_company_id_type_unique` (`document_number`,`deleted_at`,`company_id`,`type`),
  KEY `[[dbprefix]]documents_company_id_index` (`company_id`),
  KEY `[[dbprefix]]documents_type_index` (`type`),
  KEY `[[dbprefix]]documents_contact_id_index` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]document_histories`
--

CREATE TABLE `[[dbprefix]]document_histories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `document_id` int(10) unsigned NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notify` tinyint(1) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]document_histories_company_id_index` (`company_id`),
  KEY `[[dbprefix]]document_histories_type_index` (`type`),
  KEY `[[dbprefix]]document_histories_document_id_index` (`document_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]document_items`
--

CREATE TABLE `[[dbprefix]]document_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `document_id` int(10) unsigned NOT NULL,
  `item_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quantity` double(7,2) NOT NULL,
  `price` double(15,4) NOT NULL,
  `tax` double(15,4) NOT NULL DEFAULT '0.0000',
  `discount_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'normal',
  `discount_rate` double(15,4) NOT NULL DEFAULT '0.0000',
  `total` double(15,4) NOT NULL,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]document_items_company_id_index` (`company_id`),
  KEY `[[dbprefix]]document_items_type_index` (`type`),
  KEY `[[dbprefix]]document_items_document_id_index` (`document_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]document_item_taxes`
--

CREATE TABLE `[[dbprefix]]document_item_taxes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `document_id` int(10) unsigned NOT NULL,
  `document_item_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(15,4) NOT NULL DEFAULT '0.0000',
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]document_item_taxes_company_id_index` (`company_id`),
  KEY `[[dbprefix]]document_item_taxes_type_index` (`type`),
  KEY `[[dbprefix]]document_item_taxes_document_id_index` (`document_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]document_totals`
--

CREATE TABLE `[[dbprefix]]document_totals` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `document_id` int(10) unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(15,4) NOT NULL,
  `sort_order` int(11) NOT NULL,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]document_totals_company_id_index` (`company_id`),
  KEY `[[dbprefix]]document_totals_type_index` (`type`),
  KEY `[[dbprefix]]document_totals_document_id_index` (`document_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_templates`
--

CREATE TABLE `[[dbprefix]]email_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `alias` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]email_templates_company_id_alias_deleted_at_unique` (`company_id`,`alias`,`deleted_at`),
  KEY `[[dbprefix]]email_templates_company_id_index` (`company_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=13 ;

--
-- Dumping data for table `[[dbprefix]]email_templates`
--

INSERT INTO `[[dbprefix]]email_templates` VALUES
(1, 1, 'invoice_new_customer', 'App\\Notifications\\Sale\\Invoice', 'settings.email.templates.invoice_new_customer', '{invoice_number} invoice created', 'Dear {customer_name},<br /><br />We have prepared the following invoice for you: <strong>{invoice_number}</strong>.<br /><br />You can see the invoice details and proceed with the payment from the following link: <a href="{invoice_guest_link}">{invoice_number}</a>.<br /><br />Feel free to contact us with any questions.<br /><br />Best Regards,<br />{company_name}', NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(2, 1, 'invoice_remind_customer', 'App\\Notifications\\Sale\\Invoice', 'settings.email.templates.invoice_remind_customer', '{invoice_number} invoice overdue notice', 'Dear {customer_name},<br /><br />This is an overdue notice for <strong>{invoice_number}</strong> invoice.<br /><br />The invoice total is {invoice_total} and was due <strong>{invoice_due_date}</strong>.<br /><br />You can see the invoice details and proceed with the payment from the following link: <a href="{invoice_guest_link}">{invoice_number}</a>.<br /><br />Best Regards,<br />{company_name}', NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(3, 1, 'invoice_remind_admin', 'App\\Notifications\\Sale\\Invoice', 'settings.email.templates.invoice_remind_admin', '{invoice_number} invoice overdue notice', 'Hello,<br /><br />{customer_name} has received an overdue notice for <strong>{invoice_number}</strong> invoice.<br /><br />The invoice total is {invoice_total} and was due <strong>{invoice_due_date}</strong>.<br /><br />You can see the invoice details from the following link: <a href="{invoice_admin_link}">{invoice_number}</a>.<br /><br />Best Regards,<br />{company_name}', NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(4, 1, 'invoice_recur_customer', 'App\\Notifications\\Sale\\Invoice', 'settings.email.templates.invoice_recur_customer', '{invoice_number} recurring invoice created', 'Dear {customer_name},<br /><br />Based on your recurring circle, we have prepared the following invoice for you: <strong>{invoice_number}</strong>.<br /><br />You can see the invoice details and proceed with the payment from the following link: <a href="{invoice_guest_link}">{invoice_number}</a>.<br /><br />Feel free to contact us for any question.<br /><br />Best Regards,<br />{company_name}', NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(5, 1, 'invoice_recur_admin', 'App\\Notifications\\Sale\\Invoice', 'settings.email.templates.invoice_recur_admin', '{invoice_number} recurring invoice created', 'Hello,<br /><br />Based on {customer_name} recurring circle, <strong>{invoice_number}</strong> invoice has been automatically created.<br /><br />You can see the invoice details from the following link: <a href="{invoice_admin_link}">{invoice_number}</a>.<br /><br />Best Regards,<br />{company_name}', NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(6, 1, 'invoice_view_admin', 'App\\Notifications\\Sale\\Invoice', 'settings.email.templates.invoice_view_admin', '{invoice_number} invoice viewed', 'Hello,<br /><br />{customer_name} has viewed the <strong>{invoice_number}</strong> invoice.<br /><br />You can see the invoice details from the following link: <a href="{invoice_admin_link}">{invoice_number}</a>.<br /><br />Best Regards,<br />{company_name}', NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(7, 1, 'invoice_payment_customer', 'App\\Notifications\\Portal\\PaymentReceived', 'settings.email.templates.invoice_payment_customer', 'Payment received for {invoice_number} invoice', 'Dear {customer_name},<br /><br />Thank you for the payment. Find the payment details below:<br /><br />-------------------------------------------------<br />Amount: <strong>{transaction_total}</strong><br />Date: <strong>{transaction_paid_date}</strong><br />Invoice Number: <strong>{invoice_number}</strong><br />-------------------------------------------------<br /><br />You can always see the invoice details from the following link: <a href="{invoice_guest_link}">{invoice_number}</a>.<br /><br />Feel free to contact us for any question.<br /><br />Best Regards,<br />{company_name}', NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(8, 1, 'invoice_payment_admin', 'App\\Notifications\\Portal\\PaymentReceived', 'settings.email.templates.invoice_payment_admin', 'Payment received for {invoice_number} invoice', 'Hello,<br /><br />{customer_name} recorded a payment for <strong>{invoice_number}</strong> invoice.<br /><br />You can see the invoice details from the following link: <a href="{invoice_admin_link}">{invoice_number}</a>.<br /><br />Best Regards,<br />{company_name}', NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(9, 1, 'bill_remind_admin', 'App\\Notifications\\Purchase\\Bill', 'settings.email.templates.bill_remind_admin', '{bill_number} bill reminding notice', 'Hello,<br /><br />This is a reminding notice for <strong>{bill_number}</strong> bill to {vendor_name}.<br /><br />The bill total is {bill_total} and is due <strong>{bill_due_date}</strong>.<br /><br />You can see the bill details from the following link: <a href="{bill_admin_link}">{bill_number}</a>.<br /><br />Best Regards,<br />{company_name}', NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(10, 1, 'bill_recur_admin', 'App\\Notifications\\Purchase\\Bill', 'settings.email.templates.bill_recur_admin', '{bill_number} recurring bill created', 'Hello,<br /><br />Based on {vendor_name} recurring circle, <strong>{bill_number}</strong> invoice has been automatically created.<br /><br />You can see the bill details from the following link: <a href="{bill_admin_link}">{bill_number}</a>.<br /><br />Best Regards,<br />{company_name}', NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(11, 1, 'payment_received_customer', 'App\\Notifications\\Banking\\Transaction', 'settings.email.templates.payment_received_customer', 'Your receipt from {company_name}', 'Dear {contact_name},<br /><br />Thank you for the payment. <br /><br />You can see the payment details from the following link: <a href="{payment_guest_link}">{payment_date}</a>.<br /><br />Feel free to contact us with any questions.<br /><br />Best Regards,<br />{company_name}', NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(12, 1, 'payment_made_vendor', 'App\\Notifications\\Banking\\Transaction', 'settings.email.templates.payment_made_vendor', 'Payment made by {company_name}', 'Dear {contact_name},<br /><br />We have made the following payment. <br /><br />You can see the payment details from the following link: <a href="{payment_guest_link}">{payment_date}</a>.<br /><br />Feel free to contact us with any questions.<br /><br />Best Regards,<br />{company_name}', NULL, 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]failed_jobs`
--

CREATE TABLE `[[dbprefix]]failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]firewall_ips`
--

CREATE TABLE `[[dbprefix]]firewall_ips` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_id` int(11) DEFAULT NULL,
  `blocked` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]firewall_ips_ip_deleted_at_unique` (`ip`,`deleted_at`),
  KEY `[[dbprefix]]firewall_ips_ip_index` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]firewall_logs`
--

CREATE TABLE `[[dbprefix]]firewall_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `level` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'medium',
  `middleware` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `request` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]firewall_logs_ip_index` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]items`
--

CREATE TABLE `[[dbprefix]]items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'product',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `sale_price` double DEFAULT NULL,
  `purchase_price` double DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]items_company_id_index` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]item_taxes`
--

CREATE TABLE `[[dbprefix]]item_taxes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]item_taxes_company_id_item_id_index` (`company_id`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]jobs`
--

CREATE TABLE `[[dbprefix]]jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]jobs_queue_reserved_at_index` (`queue`,`reserved_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]media`
--

CREATE TABLE `[[dbprefix]]media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned NOT NULL DEFAULT '0',
  `disk` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `directory` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `extension` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `aggregate_type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `variant_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `original_media_id` int(10) unsigned DEFAULT NULL,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]media_disk_directory_filename_extension_unique` (`disk`,`directory`,`filename`,`extension`),
  UNIQUE KEY `[[dbprefix]]media_disk_directory_filename_extension_deleted_at_unique` (`disk`,`directory`,`filename`,`extension`,`deleted_at`),
  KEY `[[dbprefix]]media_aggregate_type_index` (`aggregate_type`),
  KEY `[[dbprefix]]media_disk_directory_index` (`disk`,`directory`),
  KEY `[[dbprefix]]media_company_id_index` (`company_id`),
  KEY `original_media_id` (`original_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mediables`
--

CREATE TABLE `[[dbprefix]]mediables` (
  `media_id` int(10) unsigned NOT NULL,
  `company_id` int(10) unsigned NOT NULL DEFAULT '0',
  `mediable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mediable_id` int(10) unsigned NOT NULL,
  `tag` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int(10) unsigned NOT NULL,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`media_id`,`mediable_type`,`mediable_id`,`tag`),
  KEY `[[dbprefix]]mediables_mediable_id_mediable_type_index` (`mediable_id`,`mediable_type`),
  KEY `[[dbprefix]]mediables_tag_index` (`tag`),
  KEY `[[dbprefix]]mediables_order_index` (`order`),
  KEY `[[dbprefix]]mediables_company_id_index` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]migrations`
--

CREATE TABLE `[[dbprefix]]migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=15 ;

--
-- Dumping data for table `[[dbprefix]]migrations`
--

INSERT INTO `[[dbprefix]]migrations` VALUES
(1, '2016_06_27_000000_create_mediable_tables', 1),
(2, '2017_09_14_000000_core_v1', 1),
(3, '2019_11_16_000000_core_v2', 1),
(4, '2020_10_12_000000_add_variants_to_media', 1),
(5, '2022_05_10_000000_core_v300', 1),
(6, '2022_06_28_000000_core_v304', 1),
(7, '2022_07_21_000000_core_v305', 1),
(8, '2022_08_29_000000_core_v3015', 1),
(9, '2022_08_29_000000_core_v307', 1),
(10, '2023_06_22_000000_core_v3016', 1),
(11, '2023_08_14_000000_core_v3017', 1),
(12, '2023_10_03_000000_core_v310', 1),
(13, '2024_09_26_000000_core_v3112', 1),
(14, '2024_12_29_000000_core_v3115', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]modules`
--

CREATE TABLE `[[dbprefix]]modules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `alias` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int(11) NOT NULL,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]modules_company_id_alias_deleted_at_unique` (`company_id`,`alias`,`deleted_at`),
  KEY `[[dbprefix]]modules_company_id_index` (`company_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]modules`
--

INSERT INTO `[[dbprefix]]modules` VALUES
(1, 1, 'offline-payments', 1, '::ui', NULL, '[[regtime]]', '[[regtime]]', NULL),
(2, 1, 'paypal-standard', 1, '::ui', NULL, '[[regtime]]', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]module_histories`
--

CREATE TABLE `[[dbprefix]]module_histories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `version` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]module_histories_company_id_module_id_index` (`company_id`,`module_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]module_histories`
--

INSERT INTO `[[dbprefix]]module_histories` VALUES
(1, 1, 1, '3.0.4', 'offline-payments installed', '::ui', NULL, '[[regtime]]', '[[regtime]]', NULL),
(2, 1, 2, '3.0.1', 'paypal-standard installed', '::ui', NULL, '[[regtime]]', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notifications`
--

CREATE TABLE `[[dbprefix]]notifications` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]password_resets`
--

CREATE TABLE `[[dbprefix]]password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `[[dbprefix]]password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permissions`
--

CREATE TABLE `[[dbprefix]]permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]permissions_name_unique` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=132 ;

--
-- Dumping data for table `[[dbprefix]]permissions`
--

INSERT INTO `[[dbprefix]]permissions` VALUES
(1, 'read-admin-panel', 'Read Admin Panel', 'Read Admin Panel', '[[regtime]]', '[[regtime]]'),
(2, 'read-api', 'Read Api', 'Read Api', '[[regtime]]', '[[regtime]]'),
(3, 'read-auth-profile', 'Read Auth Profile', 'Read Auth Profile', '[[regtime]]', '[[regtime]]'),
(4, 'update-auth-profile', 'Update Auth Profile', 'Update Auth Profile', '[[regtime]]', '[[regtime]]'),
(5, 'create-auth-users', 'Create Auth Users', 'Create Auth Users', '[[regtime]]', '[[regtime]]'),
(6, 'read-auth-users', 'Read Auth Users', 'Read Auth Users', '[[regtime]]', '[[regtime]]'),
(7, 'update-auth-users', 'Update Auth Users', 'Update Auth Users', '[[regtime]]', '[[regtime]]'),
(8, 'delete-auth-users', 'Delete Auth Users', 'Delete Auth Users', '[[regtime]]', '[[regtime]]'),
(9, 'create-banking-accounts', 'Create Banking Accounts', 'Create Banking Accounts', '[[regtime]]', '[[regtime]]'),
(10, 'read-banking-accounts', 'Read Banking Accounts', 'Read Banking Accounts', '[[regtime]]', '[[regtime]]'),
(11, 'update-banking-accounts', 'Update Banking Accounts', 'Update Banking Accounts', '[[regtime]]', '[[regtime]]'),
(12, 'delete-banking-accounts', 'Delete Banking Accounts', 'Delete Banking Accounts', '[[regtime]]', '[[regtime]]'),
(13, 'create-banking-reconciliations', 'Create Banking Reconciliations', 'Create Banking Reconciliations', '[[regtime]]', '[[regtime]]'),
(14, 'read-banking-reconciliations', 'Read Banking Reconciliations', 'Read Banking Reconciliations', '[[regtime]]', '[[regtime]]'),
(15, 'update-banking-reconciliations', 'Update Banking Reconciliations', 'Update Banking Reconciliations', '[[regtime]]', '[[regtime]]'),
(16, 'delete-banking-reconciliations', 'Delete Banking Reconciliations', 'Delete Banking Reconciliations', '[[regtime]]', '[[regtime]]'),
(17, 'create-banking-transactions', 'Create Banking Transactions', 'Create Banking Transactions', '[[regtime]]', '[[regtime]]'),
(18, 'read-banking-transactions', 'Read Banking Transactions', 'Read Banking Transactions', '[[regtime]]', '[[regtime]]'),
(19, 'update-banking-transactions', 'Update Banking Transactions', 'Update Banking Transactions', '[[regtime]]', '[[regtime]]'),
(20, 'delete-banking-transactions', 'Delete Banking Transactions', 'Delete Banking Transactions', '[[regtime]]', '[[regtime]]'),
(21, 'create-banking-transfers', 'Create Banking Transfers', 'Create Banking Transfers', '[[regtime]]', '[[regtime]]'),
(22, 'read-banking-transfers', 'Read Banking Transfers', 'Read Banking Transfers', '[[regtime]]', '[[regtime]]'),
(23, 'update-banking-transfers', 'Update Banking Transfers', 'Update Banking Transfers', '[[regtime]]', '[[regtime]]'),
(24, 'delete-banking-transfers', 'Delete Banking Transfers', 'Delete Banking Transfers', '[[regtime]]', '[[regtime]]'),
(25, 'create-common-companies', 'Create Common Companies', 'Create Common Companies', '[[regtime]]', '[[regtime]]'),
(26, 'read-common-companies', 'Read Common Companies', 'Read Common Companies', '[[regtime]]', '[[regtime]]'),
(27, 'update-common-companies', 'Update Common Companies', 'Update Common Companies', '[[regtime]]', '[[regtime]]'),
(28, 'delete-common-companies', 'Delete Common Companies', 'Delete Common Companies', '[[regtime]]', '[[regtime]]'),
(29, 'create-common-dashboards', 'Create Common Dashboards', 'Create Common Dashboards', '[[regtime]]', '[[regtime]]'),
(30, 'read-common-dashboards', 'Read Common Dashboards', 'Read Common Dashboards', '[[regtime]]', '[[regtime]]'),
(31, 'update-common-dashboards', 'Update Common Dashboards', 'Update Common Dashboards', '[[regtime]]', '[[regtime]]'),
(32, 'delete-common-dashboards', 'Delete Common Dashboards', 'Delete Common Dashboards', '[[regtime]]', '[[regtime]]'),
(33, 'create-common-import', 'Create Common Import', 'Create Common Import', '[[regtime]]', '[[regtime]]'),
(34, 'create-common-items', 'Create Common Items', 'Create Common Items', '[[regtime]]', '[[regtime]]'),
(35, 'read-common-items', 'Read Common Items', 'Read Common Items', '[[regtime]]', '[[regtime]]'),
(36, 'update-common-items', 'Update Common Items', 'Update Common Items', '[[regtime]]', '[[regtime]]'),
(37, 'delete-common-items', 'Delete Common Items', 'Delete Common Items', '[[regtime]]', '[[regtime]]'),
(38, 'create-common-reports', 'Create Common Reports', 'Create Common Reports', '[[regtime]]', '[[regtime]]'),
(39, 'read-common-reports', 'Read Common Reports', 'Read Common Reports', '[[regtime]]', '[[regtime]]'),
(40, 'update-common-reports', 'Update Common Reports', 'Update Common Reports', '[[regtime]]', '[[regtime]]'),
(41, 'delete-common-reports', 'Delete Common Reports', 'Delete Common Reports', '[[regtime]]', '[[regtime]]'),
(42, 'read-common-search', 'Read Common Search', 'Read Common Search', '[[regtime]]', '[[regtime]]'),
(43, 'read-common-uploads', 'Read Common Uploads', 'Read Common Uploads', '[[regtime]]', '[[regtime]]'),
(44, 'delete-common-uploads', 'Delete Common Uploads', 'Delete Common Uploads', '[[regtime]]', '[[regtime]]'),
(45, 'create-common-widgets', 'Create Common Widgets', 'Create Common Widgets', '[[regtime]]', '[[regtime]]'),
(46, 'read-common-widgets', 'Read Common Widgets', 'Read Common Widgets', '[[regtime]]', '[[regtime]]'),
(47, 'update-common-widgets', 'Update Common Widgets', 'Update Common Widgets', '[[regtime]]', '[[regtime]]'),
(48, 'delete-common-widgets', 'Delete Common Widgets', 'Delete Common Widgets', '[[regtime]]', '[[regtime]]'),
(49, 'create-purchases-bills', 'Create Purchases Bills', 'Create Purchases Bills', '[[regtime]]', '[[regtime]]'),
(50, 'read-purchases-bills', 'Read Purchases Bills', 'Read Purchases Bills', '[[regtime]]', '[[regtime]]'),
(51, 'update-purchases-bills', 'Update Purchases Bills', 'Update Purchases Bills', '[[regtime]]', '[[regtime]]'),
(52, 'delete-purchases-bills', 'Delete Purchases Bills', 'Delete Purchases Bills', '[[regtime]]', '[[regtime]]'),
(53, 'create-purchases-vendors', 'Create Purchases Vendors', 'Create Purchases Vendors', '[[regtime]]', '[[regtime]]'),
(54, 'read-purchases-vendors', 'Read Purchases Vendors', 'Read Purchases Vendors', '[[regtime]]', '[[regtime]]'),
(55, 'update-purchases-vendors', 'Update Purchases Vendors', 'Update Purchases Vendors', '[[regtime]]', '[[regtime]]'),
(56, 'delete-purchases-vendors', 'Delete Purchases Vendors', 'Delete Purchases Vendors', '[[regtime]]', '[[regtime]]'),
(57, 'create-sales-customers', 'Create Sales Customers', 'Create Sales Customers', '[[regtime]]', '[[regtime]]'),
(58, 'read-sales-customers', 'Read Sales Customers', 'Read Sales Customers', '[[regtime]]', '[[regtime]]'),
(59, 'update-sales-customers', 'Update Sales Customers', 'Update Sales Customers', '[[regtime]]', '[[regtime]]'),
(60, 'delete-sales-customers', 'Delete Sales Customers', 'Delete Sales Customers', '[[regtime]]', '[[regtime]]'),
(61, 'create-sales-invoices', 'Create Sales Invoices', 'Create Sales Invoices', '[[regtime]]', '[[regtime]]'),
(62, 'read-sales-invoices', 'Read Sales Invoices', 'Read Sales Invoices', '[[regtime]]', '[[regtime]]'),
(63, 'update-sales-invoices', 'Update Sales Invoices', 'Update Sales Invoices', '[[regtime]]', '[[regtime]]'),
(64, 'delete-sales-invoices', 'Delete Sales Invoices', 'Delete Sales Invoices', '[[regtime]]', '[[regtime]]'),
(65, 'read-install-updates', 'Read Install Updates', 'Read Install Updates', '[[regtime]]', '[[regtime]]'),
(66, 'update-install-updates', 'Update Install Updates', 'Update Install Updates', '[[regtime]]', '[[regtime]]'),
(67, 'create-modules-api-key', 'Create Modules Api Key', 'Create Modules Api Key', '[[regtime]]', '[[regtime]]'),
(68, 'update-modules-api-key', 'Update Modules Api Key', 'Update Modules Api Key', '[[regtime]]', '[[regtime]]'),
(69, 'read-modules-home', 'Read Modules Home', 'Read Modules Home', '[[regtime]]', '[[regtime]]'),
(70, 'create-modules-item', 'Create Modules Item', 'Create Modules Item', '[[regtime]]', '[[regtime]]'),
(71, 'read-modules-item', 'Read Modules Item', 'Read Modules Item', '[[regtime]]', '[[regtime]]'),
(72, 'update-modules-item', 'Update Modules Item', 'Update Modules Item', '[[regtime]]', '[[regtime]]'),
(73, 'delete-modules-item', 'Delete Modules Item', 'Delete Modules Item', '[[regtime]]', '[[regtime]]'),
(74, 'read-modules-my', 'Read Modules My', 'Read Modules My', '[[regtime]]', '[[regtime]]'),
(75, 'read-modules-tiles', 'Read Modules Tiles', 'Read Modules Tiles', '[[regtime]]', '[[regtime]]'),
(76, 'read-notifications', 'Read Notifications', 'Read Notifications', '[[regtime]]', '[[regtime]]'),
(77, 'update-notifications', 'Update Notifications', 'Update Notifications', '[[regtime]]', '[[regtime]]'),
(78, 'read-reports-expense-summary', 'Read Reports Expense Summary', 'Read Reports Expense Summary', '[[regtime]]', '[[regtime]]'),
(79, 'read-reports-income-summary', 'Read Reports Income Summary', 'Read Reports Income Summary', '[[regtime]]', '[[regtime]]'),
(80, 'read-reports-income-expense-summary', 'Read Reports Income Expense Summary', 'Read Reports Income Expense Summary', '[[regtime]]', '[[regtime]]'),
(81, 'read-reports-profit-loss', 'Read Reports Profit Loss', 'Read Reports Profit Loss', '[[regtime]]', '[[regtime]]'),
(82, 'read-reports-tax-summary', 'Read Reports Tax Summary', 'Read Reports Tax Summary', '[[regtime]]', '[[regtime]]'),
(83, 'read-reports-discount-summary', 'Read Reports Discount Summary', 'Read Reports Discount Summary', '[[regtime]]', '[[regtime]]'),
(84, 'create-settings-categories', 'Create Settings Categories', 'Create Settings Categories', '[[regtime]]', '[[regtime]]'),
(85, 'read-settings-categories', 'Read Settings Categories', 'Read Settings Categories', '[[regtime]]', '[[regtime]]'),
(86, 'update-settings-categories', 'Update Settings Categories', 'Update Settings Categories', '[[regtime]]', '[[regtime]]'),
(87, 'delete-settings-categories', 'Delete Settings Categories', 'Delete Settings Categories', '[[regtime]]', '[[regtime]]'),
(88, 'read-settings-company', 'Read Settings Company', 'Read Settings Company', '[[regtime]]', '[[regtime]]'),
(89, 'update-settings-company', 'Update Settings Company', 'Update Settings Company', '[[regtime]]', '[[regtime]]'),
(90, 'create-settings-currencies', 'Create Settings Currencies', 'Create Settings Currencies', '[[regtime]]', '[[regtime]]'),
(91, 'read-settings-currencies', 'Read Settings Currencies', 'Read Settings Currencies', '[[regtime]]', '[[regtime]]'),
(92, 'update-settings-currencies', 'Update Settings Currencies', 'Update Settings Currencies', '[[regtime]]', '[[regtime]]'),
(93, 'delete-settings-currencies', 'Delete Settings Currencies', 'Delete Settings Currencies', '[[regtime]]', '[[regtime]]'),
(94, 'read-settings-defaults', 'Read Settings Defaults', 'Read Settings Defaults', '[[regtime]]', '[[regtime]]'),
(95, 'update-settings-defaults', 'Update Settings Defaults', 'Update Settings Defaults', '[[regtime]]', '[[regtime]]'),
(96, 'read-settings-email', 'Read Settings Email', 'Read Settings Email', '[[regtime]]', '[[regtime]]'),
(97, 'update-settings-email', 'Update Settings Email', 'Update Settings Email', '[[regtime]]', '[[regtime]]'),
(98, 'read-settings-email-templates', 'Read Settings Email Templates', 'Read Settings Email Templates', '[[regtime]]', '[[regtime]]'),
(99, 'update-settings-email-templates', 'Update Settings Email Templates', 'Update Settings Email Templates', '[[regtime]]', '[[regtime]]'),
(100, 'read-settings-invoice', 'Read Settings Invoice', 'Read Settings Invoice', '[[regtime]]', '[[regtime]]'),
(101, 'update-settings-invoice', 'Update Settings Invoice', 'Update Settings Invoice', '[[regtime]]', '[[regtime]]'),
(102, 'read-settings-localisation', 'Read Settings Localisation', 'Read Settings Localisation', '[[regtime]]', '[[regtime]]'),
(103, 'update-settings-localisation', 'Update Settings Localisation', 'Update Settings Localisation', '[[regtime]]', '[[regtime]]'),
(104, 'read-settings-modules', 'Read Settings Modules', 'Read Settings Modules', '[[regtime]]', '[[regtime]]'),
(105, 'update-settings-modules', 'Update Settings Modules', 'Update Settings Modules', '[[regtime]]', '[[regtime]]'),
(106, 'read-settings-schedule', 'Read Settings Schedule', 'Read Settings Schedule', '[[regtime]]', '[[regtime]]'),
(107, 'update-settings-schedule', 'Update Settings Schedule', 'Update Settings Schedule', '[[regtime]]', '[[regtime]]'),
(108, 'create-settings-taxes', 'Create Settings Taxes', 'Create Settings Taxes', '[[regtime]]', '[[regtime]]'),
(109, 'read-settings-taxes', 'Read Settings Taxes', 'Read Settings Taxes', '[[regtime]]', '[[regtime]]'),
(110, 'update-settings-taxes', 'Update Settings Taxes', 'Update Settings Taxes', '[[regtime]]', '[[regtime]]'),
(111, 'delete-settings-taxes', 'Delete Settings Taxes', 'Delete Settings Taxes', '[[regtime]]', '[[regtime]]'),
(112, 'read-widgets-account-balance', 'Read Widgets Account Balance', 'Read Widgets Account Balance', '[[regtime]]', '[[regtime]]'),
(113, 'read-widgets-bank-feeds', 'Read Widgets Bank Feeds', 'Read Widgets Bank Feeds', '[[regtime]]', '[[regtime]]'),
(114, 'read-widgets-cash-flow', 'Read Widgets Cash Flow', 'Read Widgets Cash Flow', '[[regtime]]', '[[regtime]]'),
(115, 'read-widgets-currencies', 'Read Widgets Currencies', 'Read Widgets Currencies', '[[regtime]]', '[[regtime]]'),
(116, 'read-widgets-expenses-by-category', 'Read Widgets Expenses By Category', 'Read Widgets Expenses By Category', '[[regtime]]', '[[regtime]]'),
(117, 'read-widgets-payables', 'Read Widgets Payables', 'Read Widgets Payables', '[[regtime]]', '[[regtime]]'),
(118, 'read-widgets-profit-loss', 'Read Widgets Profit Loss', 'Read Widgets Profit Loss', '[[regtime]]', '[[regtime]]'),
(119, 'read-widgets-receivables', 'Read Widgets Receivables', 'Read Widgets Receivables', '[[regtime]]', '[[regtime]]'),
(120, 'read-client-portal', 'Read Client Portal', 'Read Client Portal', '[[regtime]]', '[[regtime]]'),
(121, 'read-portal-invoices', 'Read Portal Invoices', 'Read Portal Invoices', '[[regtime]]', '[[regtime]]'),
(122, 'update-portal-invoices', 'Update Portal Invoices', 'Update Portal Invoices', '[[regtime]]', '[[regtime]]'),
(123, 'read-portal-payments', 'Read Portal Payments', 'Read Portal Payments', '[[regtime]]', '[[regtime]]'),
(124, 'update-portal-payments', 'Update Portal Payments', 'Update Portal Payments', '[[regtime]]', '[[regtime]]'),
(125, 'read-portal-profile', 'Read Portal Profile', 'Read Portal Profile', '[[regtime]]', '[[regtime]]'),
(126, 'update-portal-profile', 'Update Portal Profile', 'Update Portal Profile', '[[regtime]]', '[[regtime]]'),
(127, 'read-offline-payments-settings', 'Read Offline Payments Settings', 'Read Offline Payments Settings', '[[regtime]]', '[[regtime]]'),
(128, 'update-offline-payments-settings', 'Update Offline Payments Settings', 'Update Offline Payments Settings', '[[regtime]]', '[[regtime]]'),
(129, 'delete-offline-payments-settings', 'Delete Offline Payments Settings', 'Delete Offline Payments Settings', '[[regtime]]', '[[regtime]]'),
(130, 'read-paypal-standard-settings', 'Read PayPal Standard Settings', 'Read PayPal Standard Settings', '[[regtime]]', '[[regtime]]'),
(131, 'update-paypal-standard-settings', 'Update PayPal Standard Settings', 'Update PayPal Standard Settings', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]personal_access_tokens`
--

CREATE TABLE `[[dbprefix]]personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]personal_access_tokens_token_unique` (`token`),
  KEY `[[dbprefix]]personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reconciliations`
--

CREATE TABLE `[[dbprefix]]reconciliations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `started_at` datetime NOT NULL,
  `ended_at` datetime NOT NULL,
  `closing_balance` double(15,4) NOT NULL DEFAULT '0.0000',
  `transactions` text COLLATE utf8mb4_unicode_ci,
  `reconciled` tinyint(1) NOT NULL,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]reconciliations_company_id_index` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]recurring`
--

CREATE TABLE `[[dbprefix]]recurring` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `recurable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recurable_id` bigint(20) unsigned NOT NULL,
  `frequency` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `interval` int(11) NOT NULL DEFAULT '1',
  `started_at` datetime NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `limit_by` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'count',
  `limit_count` int(11) NOT NULL DEFAULT '0',
  `limit_date` datetime DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT '1',
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]recurring_recurable_type_recurable_id_index` (`recurable_type`,`recurable_id`),
  KEY `[[dbprefix]]recurring_company_id_index` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports`
--

CREATE TABLE `[[dbprefix]]reports` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `class` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]reports_company_id_index` (`company_id`),
  KEY `[[dbprefix]]reports_class_index` (`class`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]reports`
--

INSERT INTO `[[dbprefix]]reports` VALUES
(1, 1, 'App\\Reports\\IncomeSummary', 'Income Summary', 'Monthly income summary by category.', '{"group":"category","period":"monthly","basis":"accrual"}', NULL, 'core::seed', '[[regtime]]', '[[regtime]]', NULL),
(2, 1, 'App\\Reports\\ExpenseSummary', 'Expense Summary', 'Monthly expense summary by category.', '{"group":"category","period":"monthly","basis":"accrual"}', NULL, 'core::seed', '[[regtime]]', '[[regtime]]', NULL),
(3, 1, 'App\\Reports\\IncomeExpenseSummary', 'Income vs Expense', 'Monthly income vs expense by category.', '{"group":"category","period":"monthly","basis":"accrual"}', NULL, 'core::seed', '[[regtime]]', '[[regtime]]', NULL),
(4, 1, 'App\\Reports\\ProfitLoss', 'Profit & Loss', 'Quarterly profit & loss by category.', '{"group":"category","period":"quarterly","basis":"accrual"}', NULL, 'core::seed', '[[regtime]]', '[[regtime]]', NULL),
(5, 1, 'App\\Reports\\TaxSummary', 'Tax Summary', 'Quarterly tax summary.', '{"period":"quarterly","basis":"accrual"}', NULL, 'core::seed', '[[regtime]]', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]roles`
--

CREATE TABLE `[[dbprefix]]roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]roles_name_unique` (`name`),
  KEY `[[dbprefix]]roles_name_index` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]roles`
--

INSERT INTO `[[dbprefix]]roles` VALUES
(1, 'admin', 'Admin', 'They get full access to your Akaunting including customers, invoices, reports, settings, and apps.', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(2, 'manager', 'Manager', 'They get full access to your Akaunting, but can''t manage users and apps.', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(3, 'customer', 'Customer', 'They can access the Client Portal and pay their invoices online through the payment methods you set up.', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(4, 'accountant', 'Accountant', 'They can access invoices, transactions, reports, and create journal entries.', NULL, NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_permissions`
--

CREATE TABLE `[[dbprefix]]role_permissions` (
  `role_id` int(10) unsigned NOT NULL,
  `permission_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`permission_id`),
  KEY `[[dbprefix]]role_permissions_permission_id_foreign` (`permission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `[[dbprefix]]role_permissions`
--

INSERT INTO `[[dbprefix]]role_permissions` VALUES
(1, 1),
(2, 1),
(4, 1),
(1, 2),
(4, 2),
(1, 3),
(2, 3),
(4, 3),
(1, 4),
(2, 4),
(4, 4),
(1, 5),
(1, 6),
(1, 7),
(1, 8),
(1, 9),
(2, 9),
(1, 10),
(2, 10),
(4, 10),
(1, 11),
(2, 11),
(1, 12),
(2, 12),
(1, 13),
(2, 13),
(1, 14),
(2, 14),
(4, 14),
(1, 15),
(2, 15),
(1, 16),
(2, 16),
(1, 17),
(2, 17),
(1, 18),
(2, 18),
(4, 18),
(1, 19),
(2, 19),
(1, 20),
(2, 20),
(1, 21),
(2, 21),
(1, 22),
(2, 22),
(4, 22),
(1, 23),
(2, 23),
(1, 24),
(2, 24),
(1, 25),
(2, 25),
(1, 26),
(2, 26),
(1, 27),
(2, 27),
(1, 28),
(2, 28),
(1, 29),
(2, 29),
(1, 30),
(2, 30),
(4, 30),
(1, 31),
(2, 31),
(1, 32),
(2, 32),
(1, 33),
(2, 33),
(1, 34),
(2, 34),
(1, 35),
(2, 35),
(4, 35),
(1, 36),
(2, 36),
(1, 37),
(2, 37),
(1, 38),
(2, 38),
(1, 39),
(2, 39),
(4, 39),
(1, 40),
(2, 40),
(1, 41),
(2, 41),
(1, 42),
(2, 42),
(1, 43),
(2, 43),
(1, 44),
(1, 45),
(2, 45),
(1, 46),
(2, 46),
(1, 47),
(2, 47),
(1, 48),
(2, 48),
(1, 49),
(2, 49),
(1, 50),
(2, 50),
(4, 50),
(1, 51),
(2, 51),
(1, 52),
(2, 52),
(1, 53),
(2, 53),
(1, 54),
(2, 54),
(4, 54),
(1, 55),
(2, 55),
(1, 56),
(2, 56),
(1, 57),
(2, 57),
(1, 58),
(2, 58),
(4, 58),
(1, 59),
(2, 59),
(1, 60),
(2, 60),
(1, 61),
(2, 61),
(1, 62),
(2, 62),
(4, 62),
(1, 63),
(2, 63),
(1, 64),
(2, 64),
(1, 65),
(2, 65),
(1, 66),
(2, 66),
(1, 67),
(1, 68),
(1, 69),
(4, 69),
(1, 70),
(1, 71),
(4, 71),
(1, 72),
(1, 73),
(1, 74),
(4, 74),
(1, 75),
(4, 75),
(1, 76),
(2, 76),
(1, 77),
(2, 77),
(1, 78),
(2, 78),
(4, 78),
(1, 79),
(2, 79),
(4, 79),
(1, 80),
(2, 80),
(4, 80),
(1, 81),
(2, 81),
(4, 81),
(1, 82),
(2, 82),
(4, 82),
(1, 83),
(2, 83),
(4, 83),
(1, 84),
(2, 84),
(1, 85),
(2, 85),
(1, 86),
(2, 86),
(1, 87),
(2, 87),
(1, 88),
(2, 88),
(1, 89),
(2, 89),
(1, 90),
(2, 90),
(1, 91),
(2, 91),
(1, 92),
(2, 92),
(1, 93),
(2, 93),
(1, 94),
(2, 94),
(1, 95),
(2, 95),
(1, 96),
(2, 96),
(1, 97),
(2, 97),
(1, 98),
(2, 98),
(1, 99),
(2, 99),
(1, 100),
(2, 100),
(1, 101),
(2, 101),
(1, 102),
(2, 102),
(1, 103),
(2, 103),
(1, 104),
(2, 104),
(1, 105),
(2, 105),
(1, 106),
(2, 106),
(1, 107),
(2, 107),
(1, 108),
(2, 108),
(1, 109),
(2, 109),
(1, 110),
(2, 110),
(1, 111),
(2, 111),
(1, 112),
(2, 112),
(4, 112),
(1, 113),
(2, 113),
(4, 113),
(1, 114),
(2, 114),
(4, 114),
(1, 115),
(2, 115),
(4, 115),
(1, 116),
(2, 116),
(4, 116),
(1, 117),
(2, 117),
(4, 117),
(1, 118),
(2, 118),
(4, 118),
(1, 119),
(2, 119),
(4, 119),
(3, 120),
(3, 121),
(3, 122),
(3, 123),
(3, 124),
(3, 125),
(3, 126),
(1, 127),
(2, 127),
(1, 128),
(2, 128),
(1, 129),
(2, 129),
(1, 130),
(2, 130),
(1, 131),
(2, 131);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  UNIQUE KEY `[[dbprefix]]sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]settings_company_id_key_deleted_at_unique` (`company_id`,`key`,`deleted_at`),
  KEY `[[dbprefix]]settings_company_id_index` (`company_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]settings`
--

INSERT INTO `[[dbprefix]]settings` VALUES
(1, 1, 'invoice.title', 'Invoice', NULL),
(2, 1, 'default.locale', '[[language]]', NULL),
(3, 1, 'default.account', '1', NULL),
(4, 1, 'default.income_category', '2', NULL),
(5, 1, 'default.expense_category', '4', NULL),
(6, 1, 'wizard.completed', '0', NULL),
(7, 1, 'offline-payments.methods', '[{"code":"offline-payments.cash.1","name":"Cash","customer":"0","order":"1","description":null},{"code":"offline-payments.bank_transfer.2","name":"Bank Transfer","customer":"0","order":"2","description":null}]', NULL),
(8, 1, 'company.name', '[[site_name]]', NULL),
(9, 1, 'company.email', '[[site_email]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]taxes`
--

CREATE TABLE `[[dbprefix]]taxes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate` double(15,4) NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'normal',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]taxes_company_id_index` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]transactions`
--

CREATE TABLE `[[dbprefix]]transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `paid_at` datetime NOT NULL,
  `amount` double(15,4) NOT NULL,
  `currency_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_rate` double(15,8) NOT NULL,
  `account_id` int(11) NOT NULL,
  `document_id` int(11) DEFAULT NULL,
  `contact_id` int(11) DEFAULT NULL,
  `category_id` int(11) NOT NULL DEFAULT '1',
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `split_id` int(10) unsigned DEFAULT NULL,
  `reconciled` tinyint(1) NOT NULL DEFAULT '0',
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]transactions_company_id_type_index` (`company_id`,`type`),
  KEY `[[dbprefix]]transactions_account_id_index` (`account_id`),
  KEY `[[dbprefix]]transactions_category_id_index` (`category_id`),
  KEY `[[dbprefix]]transactions_contact_id_index` (`contact_id`),
  KEY `[[dbprefix]]transactions_document_id_index` (`document_id`),
  KEY `[[dbprefix]]transactions_split_id_foreign` (`split_id`),
  KEY `[[dbprefix]]transactions_number_index` (`number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]transaction_taxes`
--

CREATE TABLE `[[dbprefix]]transaction_taxes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(15,4) NOT NULL DEFAULT '0.0000',
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]transaction_taxes_company_id_index` (`company_id`),
  KEY `[[dbprefix]]transaction_taxes_type_index` (`type`),
  KEY `[[dbprefix]]transaction_taxes_transaction_id_index` (`transaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]transfers`
--

CREATE TABLE `[[dbprefix]]transfers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `expense_transaction_id` int(11) NOT NULL,
  `income_transaction_id` int(11) NOT NULL,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]transfers_company_id_index` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_logged_in_at` timestamp NULL DEFAULT NULL,
  `locale` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[[language]]',
  `landing_page` varchar(70) COLLATE utf8mb4_unicode_ci DEFAULT 'dashboard',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]users_email_deleted_at_unique` (`email`,`deleted_at`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '', '[[admin_email]]', '[[admin_pass]]', NULL, NULL, '[[language]]', 'dashboard', 1, 'core::ui', NULL, '[[regtime]]', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_companies`
--

CREATE TABLE `[[dbprefix]]user_companies` (
  `user_id` int(10) unsigned NOT NULL,
  `company_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`user_id`,`company_id`),
  KEY `[[dbprefix]]user_companies_user_id_index` (`user_id`),
  KEY `[[dbprefix]]user_companies_company_id_index` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `[[dbprefix]]user_companies`
--

INSERT INTO `[[dbprefix]]user_companies` VALUES
(1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_dashboards`
--

CREATE TABLE `[[dbprefix]]user_dashboards` (
  `user_id` int(10) unsigned NOT NULL,
  `dashboard_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`user_id`,`dashboard_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `[[dbprefix]]user_dashboards`
--

INSERT INTO `[[dbprefix]]user_dashboards` VALUES
(1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_invitations`
--

CREATE TABLE `[[dbprefix]]user_invitations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_permissions`
--

CREATE TABLE `[[dbprefix]]user_permissions` (
  `user_id` int(10) unsigned NOT NULL,
  `permission_id` int(10) unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`,`permission_id`,`user_type`),
  KEY `[[dbprefix]]user_permissions_permission_id_foreign` (`permission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_roles`
--

CREATE TABLE `[[dbprefix]]user_roles` (
  `user_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  KEY `[[dbprefix]]user_roles_user_id_index` (`user_id`),
  KEY `[[dbprefix]]user_roles_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `[[dbprefix]]user_roles`
--

INSERT INTO `[[dbprefix]]user_roles` VALUES
(1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]widgets`
--

CREATE TABLE `[[dbprefix]]widgets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `dashboard_id` int(11) NOT NULL,
  `class` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort` int(11) NOT NULL DEFAULT '0',
  `settings` text COLLATE utf8mb4_unicode_ci,
  `created_from` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]widgets_company_id_dashboard_id_index` (`company_id`,`dashboard_id`),
  KEY `[[dbprefix]]widgets_class_index` (`class`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]widgets`
--

INSERT INTO `[[dbprefix]]widgets` VALUES
(1, 1, 1, 'App\\Widgets\\Receivables', 'Receivables', 1, '{"width":"50"}', 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(2, 1, 1, 'App\\Widgets\\Payables', 'Payables', 2, '{"width":"50"}', 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(3, 1, 1, 'App\\Widgets\\CashFlow', 'Cash Flow', 3, '{"width":"100"}', 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(4, 1, 1, 'App\\Widgets\\ProfitLoss', 'Profit & Loss', 4, '{"width":"50"}', 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(5, 1, 1, 'App\\Widgets\\ExpensesByCategory', 'Expenses By Category', 5, '{"width":"50"}', 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(6, 1, 1, 'App\\Widgets\\AccountBalance', 'Account Balance', 6, '{"width":"50"}', 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL),
(7, 1, 1, 'App\\Widgets\\BankFeeds', 'Connect Bank Accounts', 7, '{"width":"50"}', 'core::seed', NULL, '[[regtime]]', '[[regtime]]', NULL);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]categories`
--
ALTER TABLE `[[dbprefix]]categories`
  ADD CONSTRAINT `[[dbprefix]]categories_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `[[dbprefix]]categories` (`id`);

--
-- Constraints for table `[[dbprefix]]media`
--
ALTER TABLE `[[dbprefix]]media`
  ADD CONSTRAINT `original_media_id` FOREIGN KEY (`original_media_id`) REFERENCES `[[dbprefix]]media` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]mediables`
--
ALTER TABLE `[[dbprefix]]mediables`
  ADD CONSTRAINT `[[dbprefix]]mediables_media_id_foreign` FOREIGN KEY (`media_id`) REFERENCES `[[dbprefix]]media` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]role_permissions`
--
ALTER TABLE `[[dbprefix]]role_permissions`
  ADD CONSTRAINT `[[dbprefix]]role_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `[[dbprefix]]permissions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]role_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `[[dbprefix]]roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]transactions`
--
ALTER TABLE `[[dbprefix]]transactions`
  ADD CONSTRAINT `[[dbprefix]]transactions_split_id_foreign` FOREIGN KEY (`split_id`) REFERENCES `[[dbprefix]]transactions` (`id`);

--
-- Constraints for table `[[dbprefix]]user_permissions`
--
ALTER TABLE `[[dbprefix]]user_permissions`
  ADD CONSTRAINT `[[dbprefix]]user_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `[[dbprefix]]permissions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]user_roles`
--
ALTER TABLE `[[dbprefix]]user_roles`
  ADD CONSTRAINT `[[dbprefix]]user_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `[[dbprefix]]roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
