<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 5.3.0
*/namespace
Adminer;const
VERSION="5.3.0";error_reporting(24575);set_error_handler(function($Fc,$Hc){return!!preg_match('~^Undefined (array key|offset|index)~',$Hc);},E_WARNING|E_NOTICE);$cd=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($cd||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$sj=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($sj)$$X=$sj;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection($h=null){return($h?:Db::$instance);}function
adminer(){return
Adminer::$instance;}function
driver(){return
Driver::$instance;}function
connect(){$Hb=adminer()->credentials();$J=Driver::connect($Hb[0],$Hb[1],$Hb[2]);return(is_object($J)?$J:null);}function
idf_unescape($v){if(!preg_match('~^[`\'"[]~',$v))return$v;$Ke=substr($v,-1);return
str_replace($Ke.$Ke,$Ke,substr($v,1,-1));}function
q($Q){return
connection()->quote($Q);}function
escape_string($X){return
substr(q($X),1,-1);}function
idx($xa,$y,$l=null){return($xa&&array_key_exists($y,$xa)?$xa[$y]:$l);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes(array$ah,$cd=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($y,$X)=each($ah)){foreach($X
as$Be=>$W){unset($ah[$y][$Be]);if(is_array($W)){$ah[$y][stripslashes($Be)]=$W;$ah[]=&$ah[$y][stripslashes($Be)];}else$ah[$y][stripslashes($Be)]=($cd?$W:stripslashes($W));}}}}function
bracket_escape($v,$Ea=false){static$bj=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($v,($Ea?array_flip($bj):$bj));}function
min_version($Ij,$Ze="",$h=null){$h=connection($h);$Uh=$h->server_info;if($Ze&&preg_match('~([\d.]+)-MariaDB~',$Uh,$A)){$Uh=$A[1];$Ij=$Ze;}return$Ij&&version_compare($Uh,$Ij)>=0;}function
charset(Db$g){return(min_version("5.5.3",0,$g)?"utf8mb4":"utf8");}function
ini_bool($le){$X=ini_get($le);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$J;if($J===null)$J=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$J;}function
set_password($Hj,$N,$V,$F){$_SESSION["pwds"][$Hj][$N][$V]=($_COOKIE["adminer_key"]&&is_string($F)?array(encrypt_string($F,$_COOKIE["adminer_key"])):$F);}function
get_password(){$J=get_session("pwds");if(is_array($J))$J=($_COOKIE["adminer_key"]?decrypt_string($J[0],$_COOKIE["adminer_key"]):false);return$J;}function
get_val($H,$n=0,$vb=null){$vb=connection($vb);$I=$vb->query($H);if(!is_object($I))return
false;$K=$I->fetch_row();return($K?$K[$n]:false);}function
get_vals($H,$d=0){$J=array();$I=connection()->query($H);if(is_object($I)){while($K=$I->fetch_row())$J[]=$K[$d];}return$J;}function
get_key_vals($H,$h=null,$Xh=true){$h=connection($h);$J=array();$I=$h->query($H);if(is_object($I)){while($K=$I->fetch_row()){if($Xh)$J[$K[0]]=$K[1];else$J[]=$K[0];}}return$J;}function
get_rows($H,$h=null,$m="<p class='error'>"){$vb=connection($h);$J=array();$I=$vb->query($H);if(is_object($I)){while($K=$I->fetch_assoc())$J[]=$K;}elseif(!$I&&!$h&&$m&&(defined('Adminer\PAGE_HEADER')||$m=="-- "))echo$m.error()."\n";return$J;}function
unique_array($K,array$x){foreach($x
as$w){if(preg_match("~PRIMARY|UNIQUE~",$w["type"])){$J=array();foreach($w["columns"]as$y){if(!isset($K[$y]))continue
2;$J[$y]=$K[$y];}return$J;}}}function
escape_key($y){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$y,$A))return$A[1].idf_escape(idf_unescape($A[2])).$A[3];return
idf_escape($y);}function
where(array$Z,array$o=array()){$J=array();foreach((array)$Z["where"]as$y=>$X){$y=bracket_escape($y,true);$d=escape_key($y);$n=idx($o,$y,array());$ad=$n["type"];$J[]=$d.(JUSH=="sql"&&$ad=="json"?" = CAST(".q($X)." AS JSON)":(JUSH=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):(JUSH=="mssql"&&strpos($ad,"datetime")===false?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($n,q($X)))));if(JUSH=="sql"&&preg_match('~char|text~',$ad)&&preg_match("~[^ -@]~",$X))$J[]="$d = ".q($X)." COLLATE ".charset(connection())."_bin";}foreach((array)$Z["null"]as$y)$J[]=escape_key($y)." IS NULL";return
implode(" AND ",$J);}function
where_check($X,array$o=array()){parse_str($X,$Ya);remove_slashes(array(&$Ya));return
where($Ya,$o);}function
where_link($t,$d,$Y,$Xf="="){return"&where%5B$t%5D%5Bcol%5D=".urlencode($d)."&where%5B$t%5D%5Bop%5D=".urlencode(($Y!==null?$Xf:"IS NULL"))."&where%5B$t%5D%5Bval%5D=".urlencode($Y);}function
convert_fields(array$e,array$o,array$M=array()){$J="";foreach($e
as$y=>$X){if($M&&!in_array(idf_escape($y),$M))continue;$ya=convert_field($o[$y]);if($ya)$J
.=", $ya AS ".idf_escape($y);}return$J;}function
cookie($B,$Y,$Se=2592000){header("Set-Cookie: $B=".urlencode($Y).($Se?"; expires=".gmdate("D, d M Y H:i:s",time()+$Se)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).(HTTPS?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
get_settings($Db){parse_str($_COOKIE[$Db],$Yh);return$Yh;}function
get_setting($y,$Db="adminer_settings"){$Yh=get_settings($Db);return$Yh[$y];}function
save_settings(array$Yh,$Db="adminer_settings"){$Y=http_build_query($Yh+get_settings($Db));cookie($Db,$Y);$_COOKIE[$Db]=$Y;}function
restart_session(){if(!ini_bool("session.use_cookies")&&(!function_exists('session_status')||session_status()==1))session_start();}function
stop_session($kd=false){$_j=ini_bool("session.use_cookies");if(!$_j||$kd){session_write_close();if($_j&&@ini_set("session.use_cookies",'0')===false)session_start();}}function&get_session($y){return$_SESSION[$y][DRIVER][SERVER][$_GET["username"]];}function
set_session($y,$X){$_SESSION[$y][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($Hj,$N,$V,$k=null){$wj=remove_from_uri(implode("|",array_keys(SqlDriver::$drivers))."|username|ext|".($k!==null?"db|":"").($Hj=='mssql'||$Hj=='pgsql'?"":"ns|").session_name());preg_match('~([^?]*)\??(.*)~',$wj,$A);return"$A[1]?".(sid()?SID."&":"").($Hj!="server"||$N!=""?urlencode($Hj)."=".urlencode($N)."&":"").($_GET["ext"]?"ext=".urlencode($_GET["ext"])."&":"")."username=".urlencode($V).($k!=""?"&db=".urlencode($k):"").($A[2]?"&$A[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($Ve,$mf=null){if($mf!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($Ve!==null?$Ve:$_SERVER["REQUEST_URI"]))][]=$mf;}if($Ve!==null){if($Ve=="")$Ve=".";header("Location: $Ve");exit;}}function
query_redirect($H,$Ve,$mf,$jh=true,$Mc=true,$Vc=false,$Oi=""){if($Mc){$ni=microtime(true);$Vc=!connection()->query($H);$Oi=format_time($ni);}$hi=($H?adminer()->messageQuery($H,$Oi,$Vc):"");if($Vc){adminer()->error
.=error().$hi.script("messagesPrint();")."<br>";return
false;}if($jh)redirect($Ve,$mf.$hi);return
true;}class
Queries{static$queries=array();static$start=0;}function
queries($H){if(!Queries::$start)Queries::$start=microtime(true);Queries::$queries[]=(preg_match('~;$~',$H)?"DELIMITER ;;\n$H;\nDELIMITER ":$H).";";return
connection()->query($H);}function
apply_queries($H,array$T,$Ic='Adminer\table'){foreach($T
as$R){if(!queries("$H ".$Ic($R)))return
false;}return
true;}function
queries_redirect($Ve,$mf,$jh){$eh=implode("\n",Queries::$queries);$Oi=format_time(Queries::$start);return
query_redirect($eh,$Ve,$mf,$jh,false,!$jh,$Oi);}function
format_time($ni){return
lang(0,max(0,microtime(true)-$ni));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($ug=""){return
substr(preg_replace("~(?<=[?&])($ug".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
get_file($y,$Tb=false,$Zb=""){$bd=$_FILES[$y];if(!$bd)return
null;foreach($bd
as$y=>$X)$bd[$y]=(array)$X;$J='';foreach($bd["error"]as$y=>$m){if($m)return$m;$B=$bd["name"][$y];$Wi=$bd["tmp_name"][$y];$_b=file_get_contents($Tb&&preg_match('~\.gz$~',$B)?"compress.zlib://$Wi":$Wi);if($Tb){$ni=substr($_b,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$ni))$_b=iconv("utf-16","utf-8",$_b);elseif($ni=="\xEF\xBB\xBF")$_b=substr($_b,3);}$J
.=$_b;if($Zb)$J
.=(preg_match("($Zb\\s*\$)",$_b)?"":$Zb)."\n\n";}return$J;}function
upload_error($m){$hf=($m==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($m?lang(1).($hf?" ".lang(2,$hf):""):lang(3));}function
repeat_pattern($Gg,$Qe){return
str_repeat("$Gg{0,65535}",$Qe/65535)."$Gg{0,".($Qe%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
format_number($X){return
strtr(number_format($X,0,".",lang(4)),preg_split('~~u',lang(5),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~\W~i','-',$X);}function
table_status1($R,$Wc=false){$J=table_status($R,$Wc);return($J?reset($J):array("Name"=>$R));}function
column_foreign_keys($R){$J=array();foreach(adminer()->foreignKeys($R)as$q){foreach($q["source"]as$X)$J[$X][]=$q;}return$J;}function
fields_from_edit(){$J=array();foreach((array)$_POST["field_keys"]as$y=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$y];$_POST["fields"][$X]=$_POST["field_vals"][$y];}}foreach((array)$_POST["fields"]as$y=>$X){$B=bracket_escape($y,true);$J[$B]=array("field"=>$B,"privileges"=>array("insert"=>1,"update"=>1,"where"=>1,"order"=>1),"null"=>1,"auto_increment"=>($y==driver()->primary),);}return$J;}function
dump_headers($Sd,$wf=false){$J=adminer()->dumpHeaders($Sd,$wf);$qg=$_POST["output"];if($qg!="text")header("Content-Disposition: attachment; filename=".adminer()->dumpFilename($Sd).".$J".($qg!="file"&&preg_match('~^[0-9a-z]+$~',$qg)?".$qg":""));session_write_close();if(!ob_get_level())ob_start(null,4096);ob_flush();flush();return$J;}function
dump_csv(array$K){foreach($K
as$y=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$K[$y]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$K)."\r\n";}function
apply_sql_function($s,$d){return($s?($s=="unixepoch"?"DATETIME($d, '$s')":($s=="count distinct"?"COUNT(DISTINCT ":strtoupper("$s("))."$d)"):$d);}function
get_temp_dir(){$J=ini_get("upload_tmp_dir");if(!$J){if(function_exists('sys_get_temp_dir'))$J=sys_get_temp_dir();else{$p=@tempnam("","");if(!$p)return'';$J=dirname($p);unlink($p);}}return$J;}function
file_open_lock($p){if(is_link($p))return;$r=@fopen($p,"c+");if(!$r)return;chmod($p,0660);if(!flock($r,LOCK_EX)){fclose($r);return;}return$r;}function
file_write_unlock($r,$Nb){rewind($r);fwrite($r,$Nb);ftruncate($r,strlen($Nb));file_unlock($r);}function
file_unlock($r){flock($r,LOCK_UN);fclose($r);}function
first(array$xa){return
reset($xa);}function
password_file($i){$p=get_temp_dir()."/adminer.key";if(!$i&&!file_exists($p))return'';$r=file_open_lock($p);if(!$r)return'';$J=stream_get_contents($r);if(!$J){$J=rand_string();file_write_unlock($r,$J);}else
file_unlock($r);return$J;}function
rand_string(){return
md5(uniqid(strval(mt_rand()),true));}function
select_value($X,$_,array$n,$Ni){if(is_array($X)){$J="";foreach($X
as$Be=>$W)$J
.="<tr>".($X!=array_values($X)?"<th>".h($Be):"")."<td>".select_value($W,$_,$n,$Ni);return"<table>$J</table>";}if(!$_)$_=adminer()->selectLink($X,$n);if($_===null){if(is_mail($X))$_="mailto:$X";if(is_url($X))$_=$X;}$J=adminer()->editVal($X,$n);if($J!==null){if(!is_utf8($J))$J="\0";elseif($Ni!=""&&is_shortable($n))$J=shorten_utf8($J,max(0,+$Ni));else$J=h($J);}return
adminer()->selectVal($J,$_,$n,$X);}function
is_mail($wc){$za='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$ic='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$Gg="$za+(\\.$za+)*@($ic?\\.)+$ic";return
is_string($wc)&&preg_match("(^$Gg(,\\s*$Gg)*\$)i",$wc);}function
is_url($Q){$ic='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($ic?\\.)+$ic(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$Q);}function
is_shortable(array$n){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$n["type"]);}function
count_rows($R,array$Z,$ve,array$yd){$H=" FROM ".table($R).($Z?" WHERE ".implode(" AND ",$Z):"");return($ve&&(JUSH=="sql"||count($yd)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$yd).")$H":"SELECT COUNT(*)".($ve?" FROM (SELECT 1$H GROUP BY ".implode(", ",$yd).") x":$H));}function
slow_query($H){$k=adminer()->database();$Pi=adminer()->queryTimeout();$ci=driver()->slowQuery($H,$Pi);$h=null;if(!$ci&&support("kill")){$h=connect();if($h&&($k==""||$h->select_db($k))){$Ee=get_val(connection_id(),0,$h);echo
script("const timeout = setTimeout(() => { ajax('".js_escape(ME)."script=kill', function () {}, 'kill=$Ee&token=".get_token()."'); }, 1000 * $Pi);");}}ob_flush();flush();$J=@get_key_vals(($ci?:$H),$h,false);if($h){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$J;}function
get_token(){$hh=rand(1,1e6);return($hh^$_SESSION["token"]).":$hh";}function
verify_token(){list($Xi,$hh)=explode(":",$_POST["token"]);return($hh^$_SESSION["token"])==$Xi;}function
lzw_decompress($Ka){$ec=256;$La=8;$ib=array();$uh=0;$vh=0;for($t=0;$t<strlen($Ka);$t++){$uh=($uh<<8)+ord($Ka[$t]);$vh+=8;if($vh>=$La){$vh-=$La;$ib[]=$uh>>$vh;$uh&=(1<<$vh)-1;$ec++;if($ec>>$La)$La++;}}$dc=range("\0","\xFF");$J="";$Rj="";foreach($ib
as$t=>$hb){$vc=$dc[$hb];if(!isset($vc))$vc=$Rj.$Rj[0];$J
.=$vc;if($t)$dc[]=$Rj.$vc[0];$Rj=$vc;}return$J;}function
script($ei,$aj="\n"){return"<script".nonce().">$ei</script>$aj";}function
script_src($xj,$Wb=false){return"<script src='".h($xj)."'".nonce().($Wb?" defer":"")."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
input_hidden($B,$Y=""){return"<input type='hidden' name='".h($B)."' value='".h($Y)."'>\n";}function
input_token(){return
input_hidden("token",get_token());}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($Q){return
str_replace("\0","&#0;",htmlspecialchars($Q,ENT_QUOTES,'utf-8'));}function
nl_br($Q){return
str_replace("\n","<br>",$Q);}function
checkbox($B,$Y,$bb,$Ge="",$Wf="",$fb="",$Ie=""){$J="<input type='checkbox' name='$B' value='".h($Y)."'".($bb?" checked":"").($Ie?" aria-labelledby='$Ie'":"").">".($Wf?script("qsl('input').onclick = function () { $Wf };",""):"");return($Ge!=""||$fb?"<label".($fb?" class='$fb'":"").">$J".h($Ge)."</label>":$J);}function
optionlist($bg,$Mh=null,$Aj=false){$J="";foreach($bg
as$Be=>$W){$cg=array($Be=>$W);if(is_array($W)){$J
.='<optgroup label="'.h($Be).'">';$cg=$W;}foreach($cg
as$y=>$X)$J
.='<option'.($Aj||is_string($y)?' value="'.h($y).'"':'').($Mh!==null&&($Aj||is_string($y)?(string)$y:$X)===$Mh?' selected':'').'>'.h($X);if(is_array($W))$J
.='</optgroup>';}return$J;}function
html_select($B,array$bg,$Y="",$Vf="",$Ie=""){static$Ge=0;$He="";if(!$Ie&&substr($bg[""],0,1)=="("){$Ge++;$Ie="label-$Ge";$He="<option value='' id='$Ie'>".h($bg[""]);unset($bg[""]);}return"<select name='".h($B)."'".($Ie?" aria-labelledby='$Ie'":"").">".$He.optionlist($bg,$Y)."</select>".($Vf?script("qsl('select').onchange = function () { $Vf };",""):"");}function
html_radios($B,array$bg,$Y="",$Qh=""){$J="";foreach($bg
as$y=>$X)$J
.="<label><input type='radio' name='".h($B)."' value='".h($y)."'".($y==$Y?" checked":"").">".h($X)."</label>$Qh";return$J;}function
confirm($mf="",$Nh="qsl('input')"){return
script("$Nh.onclick = () => confirm('".($mf?js_escape($mf):lang(6))."');","");}function
print_fieldset($u,$Pe,$Lj=false){echo"<fieldset><legend>","<a href='#fieldset-$u'>$Pe</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$u');",""),"</legend>","<div id='fieldset-$u'".($Lj?"":" class='hidden'").">\n";}function
bold($Na,$fb=""){return($Na?" class='active $fb'":($fb?" class='$fb'":""));}function
js_escape($Q){return
addcslashes($Q,"\r\n'\\/");}function
pagination($D,$Kb){return" ".($D==$Kb?$D+1:'<a href="'.h(remove_from_uri("page").($D?"&page=$D".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($D+1)."</a>");}function
hidden_fields(array$ah,array$Wd=array(),$Sg=''){$J=false;foreach($ah
as$y=>$X){if(!in_array($y,$Wd)){if(is_array($X))hidden_fields($X,array(),$y);else{$J=true;echo
input_hidden(($Sg?$Sg."[$y]":$y),$X);}}}return$J;}function
hidden_fields_get(){echo(sid()?input_hidden(session_name(),session_id()):''),(SERVER!==null?input_hidden(DRIVER,SERVER):""),input_hidden("username",$_GET["username"]);}function
enum_input($U,$_a,array$n,$Y,$zc=null){preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$cf);$J=($zc!==null?"<label><input type='$U'$_a value='$zc'".((is_array($Y)?in_array($zc,$Y):$Y===$zc)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($cf[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$bb=(is_array($Y)?in_array($X,$Y):$Y===$X);$J
.=" <label><input type='$U'$_a value='".h($X)."'".($bb?' checked':'').'>'.h(adminer()->editVal($X,$n)).'</label>';}return$J;}function
input(array$n,$Y,$s,$Da=false){$B=h(bracket_escape($n["field"]));echo"<td class='function'>";if(is_array($Y)&&!$s){$Y=json_encode($Y,128|64|256);$s="json";}$th=(JUSH=="mssql"&&$n["auto_increment"]);if($th&&!$_POST["save"])$s=null;$td=(isset($_GET["select"])||$th?array("orig"=>lang(8)):array())+adminer()->editFunctions($n);$fc=stripos($n["default"],"GENERATED ALWAYS AS ")===0?" disabled=''":"";$_a=" name='fields[$B]'$fc".($Da?" autofocus":"");$Ec=driver()->enumLength($n);if($Ec){$n["type"]="enum";$n["length"]=$Ec;}echo
driver()->unconvertFunction($n)." ";$R=$_GET["edit"]?:$_GET["select"];if($n["type"]=="enum")echo
h($td[""])."<td>".adminer()->editInput($R,$n,$_a,$Y);else{$Fd=(in_array($s,$td)||isset($td[$s]));echo(count($td)>1?"<select name='function[$B]'$fc>".optionlist($td,$s===null||$Fd?$s:"")."</select>".on_help("event.target.value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($td))).'<td>';$ne=adminer()->editInput($R,$n,$_a,$Y);if($ne!="")echo$ne;elseif(preg_match('~bool~',$n["type"]))echo"<input type='hidden'$_a value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$_a value='1'>";elseif($n["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$cf);foreach($cf[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$bb=in_array($X,explode(",",$Y),true);echo" <label><input type='checkbox' name='fields[$B][$t]' value='".h($X)."'".($bb?' checked':'').">".h(adminer()->editVal($X,$n)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$B'>";elseif($s=="json"||preg_match('~^jsonb?$~',$n["type"]))echo"<textarea$_a cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';elseif(($Li=preg_match('~text|lob|memo~i',$n["type"]))||preg_match("~\n~",$Y)){if($Li&&JUSH!="sqlite")$_a
.=" cols='50' rows='12'";else{$L=min(12,substr_count($Y,"\n")+1);$_a
.=" cols='30' rows='$L'";}echo"<textarea$_a>".h($Y).'</textarea>';}else{$mj=driver()->types();$jf=(!preg_match('~int~',$n["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$n["length"],$A)?((preg_match("~binary~",$n["type"])?2:1)*$A[1]+($A[3]?1:0)+($A[2]&&!$n["unsigned"]?1:0)):($mj[$n["type"]]?$mj[$n["type"]]+($n["unsigned"]?0:1):0));if(JUSH=='sql'&&min_version(5.6)&&preg_match('~time~',$n["type"]))$jf+=7;echo"<input".((!$Fd||$s==="")&&preg_match('~(?<!o)int(?!er)~',$n["type"])&&!preg_match('~\[\]~',$n["full_type"])?" type='number'":"")." value='".h($Y)."'".($jf?" data-maxlength='$jf'":"").(preg_match('~char|binary~',$n["type"])&&$jf>20?" size='".($jf>99?60:40)."'":"")."$_a>";}echo
adminer()->editHint($R,$n,$Y);$dd=0;foreach($td
as$y=>$X){if($y===""||!$X)break;$dd++;}if($dd&&count($td)>1)echo
script("qsl('td').oninput = partial(skipOriginal, $dd);");}}function
process_input(array$n){if(stripos($n["default"],"GENERATED ALWAYS AS ")===0)return;$v=bracket_escape($n["field"]);$s=idx($_POST["function"],$v);$Y=$_POST["fields"][$v];if($n["type"]=="enum"||driver()->enumLength($n)){if($Y==-1)return
false;if($Y=="")return"NULL";}if($n["auto_increment"]&&$Y=="")return
null;if($s=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?idf_escape($n["field"]):false);if($s=="NULL")return"NULL";if($n["type"]=="set")$Y=implode(",",(array)$Y);if($s=="json"){$s="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads")){$bd=get_file("fields-$v");if(!is_string($bd))return
false;return
driver()->quoteBinary($bd);}return
adminer()->processInput($n,$Y,$s);}function
search_tables(){$_GET["where"][0]["val"]=$_POST["query"];$Ph="<ul>\n";foreach(table_status('',true)as$R=>$S){$B=adminer()->tableName($S);if(isset($S["Engine"])&&$B!=""&&(!$_POST["tables"]||in_array($R,$_POST["tables"]))){$I=connection()->query("SELECT".limit("1 FROM ".table($R)," WHERE ".implode(" AND ",adminer()->selectSearchProcess(fields($R),array())),1));if(!$I||$I->fetch_row()){$Wg="<a href='".h(ME."select=".urlencode($R)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$B</a>";echo"$Ph<li>".($I?$Wg:"<p class='error'>$Wg: ".error())."\n";$Ph="";}}}echo($Ph?"<p class='message'>".lang(9):"</ul>")."\n";}function
on_help($ob,$ai=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $ob, $ai) }, onmouseout: helpMouseout});","");}function
edit_form($R,array$o,$K,$vj,$m=''){$zi=adminer()->tableName(table_status1($R,true));page_header(($vj?lang(10):lang(11)),$m,array("select"=>array($R,$zi)),$zi);adminer()->editRowPrint($R,$o,$K,$vj);if($K===false){echo"<p class='error'>".lang(12)."\n";return;}echo"<form action='' method='post' enctype='multipart/form-data' id='form'>\n";if(!$o)echo"<p class='error'>".lang(13)."\n";else{echo"<table class='layout'>".script("qsl('table').onkeydown = editingKeydown;");$Da=!$_POST;foreach($o
as$B=>$n){echo"<tr><th>".adminer()->fieldName($n);$l=idx($_GET["set"],bracket_escape($B));if($l===null){$l=$n["default"];if($n["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$l,$qh))$l=$qh[1];if(JUSH=="sql"&&preg_match('~binary~',$n["type"]))$l=bin2hex($l);}$Y=($K!==null?($K[$B]!=""&&JUSH=="sql"&&preg_match("~enum|set~",$n["type"])&&is_array($K[$B])?implode(",",$K[$B]):(is_bool($K[$B])?+$K[$B]:$K[$B])):(!$vj&&$n["auto_increment"]?"":(isset($_GET["select"])?false:$l)));if(!$_POST["save"]&&is_string($Y))$Y=adminer()->editVal($Y,$n);$s=($_POST["save"]?idx($_POST["function"],$B,""):($vj&&preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$vj&&$Y==$n["default"]&&preg_match('~^[\w.]+\(~',$Y))$s="SQL";if(preg_match("~time~",$n["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$s="now";}if($n["type"]=="uuid"&&$Y=="uuid()"){$Y="";$s="uuid";}if($Da!==false)$Da=($n["auto_increment"]||$s=="now"||$s=="uuid"?null:true);input($n,$Y,$s,$Da);if($Da)$Da=false;echo"\n";}if(!support("table")&&!fields($R))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",adminer()->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($o){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"]))echo"<input type='submit' name='insert' value='".($vj?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($vj?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}echo($vj?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":"");if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo
input_hidden("referer",(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"])),input_hidden("save",1),input_token(),"</form>\n";}function
shorten_utf8($Q,$Qe=80,$ti=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$Qe).")($)?)u",$Q,$A))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$Qe).")($)?)",$Q,$A);return
h($A[1]).$ti.(isset($A[2])?"":"<i>…</i>");}function
icon($Rd,$B,$Qd,$Ri){return"<button type='submit' name='$B' title='".h($Ri)."' class='icon icon-$Rd'><span>$Qd</span></button>";}if(isset($_GET["file"])){if(substr(VERSION,-4)!='-dev'){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");}@ini_set("zlib.output_compression",'1');if($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgб\"PimcQCa	2ód<fa:;NBqR;1Lf9u7&)l;3J/CQXr2Mai0)e:LuÝh-923li7mZw4њ<-̴!U,Févt2S,a҇FVXaNq)-ǜh:n59Y;j-_9krٓ;.tTqo0{y\rHnGSZh;i^uxWΒC@k=b/A0+(l\\x:\rb8\00!\0F\nB͎(3\r\\Ȅa'I|(i\n\r4Og@4C@@!QB	°c¯q,\r1Eh&2PZiGH9G\"v4rDR\npJ-A|/.cDu:,=R]U5mVkLLQ@-\\@9%SrMPDIa\r(YY\\@Xp:plLC O,\r2]7?m06pTaҥC;_˗yȴd>bnnܣ3X8\r[ˀ-)i>V[Yy&L3#X|	X\\ù`C#H22.#Z`<sÒ\0uh־M_\niZeO/CӒ_`31>=k3R/;/d\0ڵm7/AXq.sL :\$Fw8߾~Hj\"Գ7gSFLίQ_O'W]c=51X~7;i\r*\nJS1ZctAV86fdy;Y]zIpc3Y]}@\$.+1'>ZcpdGL#k8PzYAuv]s9_Aq:\nKhB;XbAHq,CI`jS[ˌ1Vr;pB)#鐉;4H/*<3L;lf\ns\$K`}Ք7jx`d%j]4YHbYJ`GG.KfI)2MfָXRC̱V,~g\0g6:[j1H:AlIqu3\"q|8<9s'Q]J|\0`pjfObq\$1J>RH(ǔq\n#r@e(yVJ0Q҈6P[C:G伞4^PZ\\(\n)~9R%Sj{70_s	z|8H	\"@#9DVL\$H5WJ@zaJ ^	)2\nQv]j (ABB056b˰][kAwvkgƴ+k[jmzc}MyDZi\$5eʷ	ACY%.Wb*뮼.q/%}BXZV337ʻawW[LQ޲_2`1Ii,曣Mf&(s-Aİ*DwTNɻjX\$x+;F93JkS;qR{>l;B1AIb)(6r\r\rڇZR^SOy/M#9{kv\"KCJrEo\0\\,|fa͚hI/o4k^p1H^phǡVvox@`g&(;~Ǎz68*5EpӘ3ņgrDL)4g{峩L&>脻Z7\0̊@ffRVh֝Iۈrw)=x^,k2ݓjbl0u\"fp1RIz[]wpN6dIzn.7X{;3-I	7pjÝR#,_-[>3\\WqqJ֘uhFbLKyVľѕVf{K}SޝM̀.M\\ixb1+α?<3~H\$\\2\$ e6tÖ\$sxxCnSkV=z6'æNaָhR噣8gw:_ҒIRKÝ.nkVU+dwj%`#,{醳Y(oվ.c0gDXOk7Klhx;؏ ݃L\$09*9 hNrM.>\0rP9\$g	\0\$\\F*d'L:b429@Hnb-E #ĜrPY t \n5.\$oplX\n@`\r	\r  	 	@@\n  	\0j@Q@1\r@ 	\$p	 V\0``\n\0\n \n@'\n\0`\r	\r\0r	\0`	{	,\"^P0\n4\n0.0p\rp\rppqQ0%1Q8\n \0kȼ\0^\0`@>\no1w,Y	h*=P:іVи.q\r\rp1Q	1 `/17\r^\"y`\n #\0	 p\n\n` r Qb13\n##1\$q\$ѱ%0%q%&&q &'1\rR}16	 @b\r``\r	d	j\n``\n`dcсP,1R\$rIO 	Q	Y32b1&01  f\0\0f\0j\nf`	 \n`@\$n=`\0v nI\$P(d'g6--C7R 	4-1&2t\r\"\n 	H*@	`\n  	l2,z\r~ \rFthmz~\0]GF\\I\\}ItC\nT}IEJ\rx>MpIH~fht.bxYEiKoj\nLtr.~dH2U4G\\A4uPt谐L/P	\"G!RMtO-<#APuIR\$cDƊ-GO`Pv^W@tH;QRę\$gKF<\rR*\$4'[IUmh:+5@/lI2^\0OD\rR'\rTЭ[ĪMCMZ4E B\"`euN,䙬]t\r`@h*\r.V%!MBlPF\"&/@v\\C:mMgni8I2\rpvj+Z mTuefv>fCTM.M3Pv'ktdO\rdkyW߂V6Uʖ-~XBGd\$i%qjErLJPr%n=H\"\"\"h_\$b@t\0f\"nH*Bv\$\$B@\"@r(\r` CX(0&.`Nk9B\n&#(@䂯d^Z @`I-u0\nBu4sGutNbu ub}O~)uBw{Ł5=w9[ɫs	8=\0\r%`]x&^3sc݃.\$̓Z44u`Ǆۅ 8;wTMeх݇8XzlKU`^XOm@M⋀WXj߈ؽXGTEHxYa,ÍŊo|t%Ujq7wX=ػdxU8\rOiyc.&Y%9AkdDz9Dċģ[Y<xX^VςDGgwǏCI`Ƨ=ٗzYO 6|x)ߋ8#لeٙ8QxYߛ&K͝(%r-ٝJ @Z xDz!Wǝۣy \0rYy|b|!Yy9yzC+=٦ç:]swaxf*qzӧ`[#sy+uXTٌc࿎C18U95ݭǖ`ͬZygz ڧ࿰#e˱Z+Րp>ǡL)űO+IxR ˯yByI{z\0\rᜄ{k^=:ΓA2;7\$;c;]XXkY#5vT\\Q:>ɓk'[aħ0xI[;\0[AZe?ecp΄Ճ:#fCZSDv.\r#ߔU ");}elseif($_GET["file"]=="dark.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgh0LЁd91S!	F!\"-6NbdGg:;Nr)c7\r(Hb81s9k\rc)m8OVAc1c34Of*-P1r416d2ցo#3Bf#	g9Φ،fc\rIb6EC&,bum7aVs#m!hrv\\3\rL:SAdk5naF3e6fSyr!L-K,3L@J˲*J쵣	bc99@H8\\6>`Ŏ;A<T'p&qqE4\rlh<5#pR #I%fBIܲ>ʫ29<Cj27j8jc(n?(a\0@5*3:δ60-AlLP4@ɰ\$H4n311t0͙9WO!rH9Q96F<7\r-xC\n @:\$iضm4Kid{\n6\rxhˋ#^'4V@a<#h0S-c9+pa2cyhBO\$9wiXɔVY9*rHtm	@b|@/l\$z+%p2l.7;&{mXC<l96x9m7R0\\4P)AoxqO#f[;6~P\raTGT0uޟ\n3\\ \\ʎJudCGPZ>d8ҨC?VdLL.(ti>,֜R+9iޞC\$#\"AChVb\n6T2ew\nf6m	!1'c;*eLRn\rG\$2S\$0a'l6&~Ad\$J\$s ȃB4j.RC̔Qj\"7\nXs!6=BȀ}");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("':̢i11	4Q6a&:OAIe:NFD|!Cym2\"r<̱/C#:DbqSeJ˦Cܺ\n\nǱS\rZH\$RAܞS+XKvtdg:6EvXŞjmҩej2MB&ʮLC3Q0L-x\nDyNaPn:s͐(cL/(5{Qy4g-i4ڃf(bUko7&ä*ACb`.\r\nCh<\r)`إ`7CʒZX<Q1X@0dp9EQfF\r!(h)\np'#ČH(i*r&<#7K~# A:N6l,\rJP3!@2>CrhN](a0M326UE2'!<#3R<XCH7#n+a\$!2P0.wdr:YE!]<j@\\pl_\rZғTͩZs3\"~9jP)QYbݕDYc`zcѨ'#tBOh*2<ŒOfg-Z#8a^+r2b\\~0Wnp!#`Z612@ky9\rB3pޅ6<!pG9no6s#F3bA69Z#6%?s\"|؂)bJc\rNsih8ݟ:;HތuI5@1APaH^\$Hv@ÛL~b9'S?P-0C\nRm4ȓ:Ը24h(k\njI6\"EY#Wr\rG8@tXԓBS\nc0kC I\rʰ<u`A!)2C\0= P1ӢK!!pIs,6di1+k<^	\n20Fԉ_\$)f\0C8E^/3W!א)u*&\$2Y\n]EkDV\$JxTse!RY R`=Lޫ\nl_.!V!\r\nHk\$א`{1	|i<jRrPTG|w4b\r4d,E6<h[Nq@Oi>'ѩ\r;]#}0ASIJdA/Q⸵@t\rUG_G<<y-Iz򄤝\"PB\0q`vAa̡JRʮ)JB.TLyCpp\0(7cYYaM1em4crS)opC!ISb0m(dEH߳X/PyX85\$+֖gdyϝJ lEur,dCX}em]2̽(-zZ;I\\) ,\n>)\rVS\njx*w`ⴷSFid,ZJFM}Њ \\ZP`zZE]dɟOcmԁ] %\"w4\n\$zVSQD:6GwMS0B-s)Zcǁ2δA;nWz/AZhG~cc%[D&lFR77|I3g0Lac0RJ2%F S L^ trtʩ;.喚Ł>[aN^(!g@1Nz<bݖO,CuDtj޹I;)݀\nncȂW<s	\0hNP9{ueut뵕3=gJWQ0w9p-	'5\nOe)M)_kz\0V;jl\nxPf-`C.@&]#\0ڶpy͖ƛtd b}	G1mru*_xD3qBsQus%\n5sut{syN4,J{4@\0P^=l`e~F١h3o\"qR<iUT[QUM6T. 0'pe\\5pCe	ٕ\"*M	D?h2zU@7C4aiE!f\$B<9o*\$lH\$ @P\rNYn<\$	Q=F&*@]\0 W'd z\$jP[\$0#&_`+B)wv%	LcJRSi`Ů	FW	\nBP\n\r\0}	瑩0Z/`j\$: 8ieφxa GnsgOU%VU@Nϐd+(oJ@XzM'F٣WhVI^٢1>@\" QR!\\`[.0fbF;Fpp/t`(VbȲ(Hlԯ1vH1T3q1Ѫf\nT\$Nq+`ލvǜ\rVmr'ϸg%\"Lm((CLz\"hXm=\\H\n0U f&M\$g\$U`a\rP>`#gh`R4H'GK;\"MۨThBEn\"b>\r#\0N:#_	QQ1{	f:BR&)JBr+K.\$Pq-rS%TIT&Q{#2o(*P5`1H'	<Tds,N ^\r%3\r&4B/\0kLH\$4d>/ඵH*3JА<Hhp'O/&2I.x3V.s5e3ێZ(9Eg;R;JQ@vgz@'dZ&,UFb*DH! \r;%x'G#͠w#֠2;#BvXa\nb{4KG%GuE`\\\rB\r\0-mW\rM\"#EcFbFnz@4J[\$%2V%&TVd4hemN-;Eľ%EEr<\"@FPL ߭4Ez`u7N4\0F:hKh/:\"MZ\r+P4\r?SO;B0\$FCEpM\"%H4D|LNFtEg5=J\r\"޼54KP\rbZ\r\"pEQ'DwKW0g'l\"hQFC,CcIHPhF]5& fTiSTUS[4[uNe\$oKO b\" 5\0D)E%\"]/ЌJ6Ud`a)V-0DӔbM)`%ELt+6C7jd:V4ơ3 -R\rGIT#<4-CgCP{V\$'gR@'S=%Fk:k9e]aOG9;-68W*x\"UYlB	\nplZm\05Oq̨bW1s@K-pESpw\nGWoQqG}vpw}qq\\7RZ@tt;pG}w׀/%\"LE\0th)\rJ\\W@	|D#SƃVRz2v	}(\0y<X\rxq<Isk1S-Q4Yq8#vd.ֹS;q!,'(<.J7H\".u#Q\rerXv[h\${-YJBgiM8'\nƘtDZ~/b8\$DbROO`O5S>[Dꔸ_3X)'Jd\rXUDUX8x-旅PN`	\nZ@Ra48:\0xN\\0%f\\>\"@^\0ZxZ\0ZaBr#X\r{˕flFb\0[ވ\0[6	 =\nWB\$'kG(\$ye9(8& hRܔoȼ ǇY47_d9'z\r  vGO8MOh'XS0\0\0	9s?IMY8 9HO,4	xsP*Gc8QɠwB|z	@	9cKQGbFjXoS\$dFHĂP@ѧ<嶴,}mr\"'k`cxeCC::X T^dÆqhsLvҮ0\r,4\r_vLjjMb[  lsZ@;f`2Yce'MerF\$!\n	*0\rANLPjٓ;ƣVQ|(3[p8|^\rBf/DҞ B_N5M \$\naZЦ~UlerŧrZaZգs8RGZwN_ƱYϣm];ƚLcŰIQ3O|y*` 54;&v8#R8+`XbV6ƫi3FEoc82M\"GWb\rOCVdӭw\\ͯ*cSiQүR`d7}	)ϴ,+bd۹FN3L\\eRn\$&\\r+d]O5kq,&\"DCU6jp\\'@o~5N=|&!BwHyyz7(Ǎb5(3փ_\0`zbУr8	Zv8L˓)SM<*7\$\rRbB%ƴDszR>[Q&Q'\rppz/<}L#ΕZ\"t\n.4gPpDnʹNFd\0`^\rnȂ׳#_ w(2<7-X޹\0s,^hC,!:\rK.ӢŢ\\+vZ\0Q9eʛ˞Ew?>\$}D#c0MV3%Y\rtj57{ŝLz=<8IMGL\$2{(pe?u,Rd*X4\0\"@}<.@	N\$XUjs/<>\"* #\$&CPI	t? 	O\\_Q5YH@bch뱖O0T'8wj+Hv_#06w֎Xd+ܓ\\\n\0	\\>sA	PFd8m'@\nH\0cOwSY`RDna\"~?m|@6+GxV\0WӰnw.؃b9ÍE|E\rЈr\"x-\rN6n\$Ҭ-BH^)y&ךWǧbvR	N\0n	T`8XA\r:{O@\" !\$KqojY֪Jh}d<1IxdTT4NeeC0䥿:DF5L*::HjZFRMրnS\n>PO[\$V8;#K\\'BRدR_8j*Ej\\~vvp@TX\0002dE	HVD\"Q'EDJB~AAIl*'\nY.+9pg/\"180IAFCȨV*aPdУ5H\"A6sY;訞/0v}y\rץ1u\"ˋm_0焄`\\B1^\nk\r]lh}]HBW`0꨹rFf)W,ҧ]sm9'OxԽ,9J8?4\"҅۽<-SM;v6y|Z%a#8TC!p\nCZ(wa?9|0<BL\r\n]PB0&+tHօDx^,L}[Bx}ru\0\0005S@\"Uؔ@\0\$ސ\"Ҡ]l/	IB4.6d7\r@=߬*G jf`:HnbĀ71)C<@AY#eoY!IDM\nlt/)\\43)2ɸ)f[ ppp1#Ðp\0œl^{ATH6\n\0PH.\r|TFD0Sy'1KdBC&)Ws Hee+@4 rۚ*Lp1<fNY'-	XKVaL\"\"lq.YJHm HV/lC&H)o&\\2%z\n^Q(6D Jq\00a#6\0vr,M&A9%YdBh!W\0b\r{@1I22A)Ha@r0G7Dd.LM<2,k/Me}Ғ3=\0&B\nPd.\"F3XSd(*J6 F:)11?lQ&h<J͋fdEպ*x\n\0.\"B -#ΗtIΫ	I8 8dh	x~	L!K(BX-hc/rPIN2|׶|\"M'K,\\He5*o]4FP	2<)To\nIڢ!(_8Xr;uNJ[rDC:@ͳl\0e\\*x@Aȡ&(5,#1x !TD(QDJ|D D:\0Aй baE?rnWkxX=i,\$3[r9BƱd\0H4<(z?sIbJg U\n(}J\"AB19~I#\$%d  e\"`t'O=@\$O\nmTo+Z-PF?_IJX ģ2-V;?20*P3_T<EJ\\(2)IQ鬩RL&!ȯKiцtKHRlȬEsDxǴi!faBFe>V-QjI7\"%Rh gM-b58R*9ꊰ92Q0IR[ZN\020\\[@Q\0JxEC{\$lp1=\0Rо>E~:0%R+)\0	ƑQ@(\"_jTX\0\r1\0P9#\0H;B|LZ6/B\nB{|H,	*;(`2@6>	?P\0/\0|\\eB`jqU/\rc҆6(N\0/\$\n8j*U\$y*=;\$f8XBCEr\"/kځ%\\9kB0F('UƮm@kT\0EsEhye\n))b7(W%,Jr2DrhE\n0Q3 U9TPO8j|}R<0Zl T*\$U\r\". Ts~~(3a@+l`:`:OiBX?ʄ7Lj|:nK:ز}\0UMc`P%nn\n,4Q'%+H.\"#G3`\n1fg\0М'kqxD<\",a|{~C<SiB\nkNG}k:g)JDhÛf\"kV~mM`HOkD^0/tjl\r!f<GTv#@ek@2w0ܭtį1uyvː%8?1lxtmpfK3ZJ=\0@^pۑ]Ҳ't١@Cb\r[V-o-ݠe}Y	--mI\0+VD[B+(-4>qi>=/0-cLpJ b\nd)#Gs\"QN`.ȍyȐEtPqI]J8rWTIfaG.떄7ylA7'1	S-xImL:eΉAWζEIWz3W)*/)Cx*c]%}_IvͲ'\$US4k5WʏJC7*b%<WC@	c{޴3)X&&eLI,N 2k#p5f4Ǻz#\\NbUoyS4`q~1=8厉*OOJC'Dd,@kL\\j2ͩ<@_q2\0ձ)`sF\0\nF<*x*`-\r|@7H@wH]\0_wh0!s1ϏǬhW.=WR*A_EDԷ?1,Ub9=t4èW^;@(1<DÊHxT()0z`_;AL)\nK[fHWo@bBKiMd+>vI(z:.݀9uiѤDYO`]I\0RĆ,K,6L\"\"1g(|T.,9vb+\rk]u&|bSd[,gaJ(Ck\rF+	9L))UABUhgc3x-n9x2qibrY7kyf,)٪J:N8Rcly\n2W;.>v6Q#A0{έi7~@VX^11-+v|]Vf.{	\r;1lp/uFd\$PЮ0=@kS0hɈ@/*(OV.G>(r!6Y=XZ@:'&06kE|'|H;Ng%W+4;̓'x|f9(Odw%9]f}Gs¾XM0gQ8̄+O}͝0}9Nh/mgDs\n74勳P~}O)Ug9j8Pݸ(%j7oABi)Ku }s1=odV[Ĵ\nzlMзr:F#{*#xܰ<Dsk/mw :^1ύD2z*n%iÙ *!8-tH'\rк48`\"i]ZZ>Z\0ަ9+䟂~\$ޭLP\\쇁XAizh\$SMT'1D	5E\0Ğ\$ttԮ:\rMƷSӖlsAfKk,NlD^zzdS/rtN>o%i\0JBpoR/֘٫x\ny+,e4q5Q'JD]B@mRSki~t0[ 1z	&^\nOVGV@T*H9ωG0\0'`Ѱ\rbQKsLd*;\n.ĔUNp,L@TRebFyn> IKrG	@?cIݓu%GO1Ch5TyI:\\0X>ʊ0޾QBEI/-LBT!b6k`jp\0K>kd/ISk.+*R|gRW\\wt.)^Zc8Z~FSǵSm̕;b>\0jz=T'>qy}:u&WDQc-6<[exؠ[L\0wmltz<S&dbxoigK\r`µ?D5u@bNO𤷤Y[{Nr鉞t\0tMscBW?*D.p'2Ge\rp*#eC\"QI\nhiQ@\rl	_.t*^s9Whq~,YθdQs¦\rBjDǡ<<T)C\n&D{\rl-R\r@rkϢ+ZPu8Ȩsوo#gu\$F&\n-v\"Pjnnt1VAwbx߄D5-0a\0\r/!I|/hnGf-Mdna^(ea¨YZ,SEN\\=4~Mʹ\rFtŦu\"|`ERzD`{@k/KY3sJ䃿5XGͪ%9)Q Q1th!TRHQ\rCE0#wG2//=^ /ԺΐE\0{+t+qбIt|vqԈƌ&\r\\Vߠ=EbnOrnX({ɹuzK`=:\n\0[%:pq+RldY\"[Vu{H-H_8jV5\"\0\"N?E;+O~wN];L'SOF䁻D-!#sN< ¯muG8Tn]:zIMn O8z5o\\57<Ų#8?sNL	}x&4?[z󳷶<*We}{HZ,(<ooxWt2#A*o\\R}xH>NP|Qɚ|x'- 2\0?ƾ2*\r|]tp\"ڲJuuXybD\nZ|H7_WGuXyH>T\rGQln!u'*C5>U2!b	9Pw4}yW|a\$gTU&~9(\\*!b_w7\\]=\\*@#N7ͪ5QN`@<\06!9l\$wI\$42\$&.RZYuyᤳp&SI@EJiLcV1F1Z\r\rhkHH˿K?x-0\ndN3KC59)ľ:B#dN5A1ƉOd[3ڠh[s~)9DNy>X'ȽϐH,)ڂ\"e0;\0qeo>=|2G+B@z@]}rQ k/|G:ѯW\0a4>^|goXE9pLrgA6pe1*7[>]#?jB~/}3:U\$?<Ga\n>0#!i>.{A}'hQLw~W_Th#dûdFQ*{\"\"P{}4Ni\r_e?l42?\nF	qUĽ_`_j{_k_o~c*#(/!DnF`?@sB!?;E\0k	*ND;+d\nZZdB `B5P\n8c#oukˊMݯw.FJ!|Ĉ2FcY).XHy[~#/&[Y@(|\r\0,O0YbβŬ\$0aˑ A\$0,@Ӱ>>9\\ti<\0q\0}@`\0fVjdߠ'(	!_n0+ciig8a]'=-B!(8_xj)\rH5HYn	,fr}-d\$H2n鴆ܛ=-dFE-daN_z4@[n\$x!!i0Tu8ɸ\0PZ8Zc+ЊAAF(`mg*vS, ǆKcA۬ &9c0w+n=)\$Q~Aa\0004\0u{(\$y	!B A<aAz ZA4\$ZY9.aX\rdALv|oOz|Z(eZĆ");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0<d4E'\n#\r.C!^t(bqH.s2Nq٤9#{c3nӸ2r:<+9CȨ\n<\r`/b\\!H2SڙF#8ЈI78K*ں!鎑+:+&2|:9:NpA/# 0D\\'12a@+J.c,1@^.Bь`OK=`BP6>(eK%! ^!ϬBHSs8^93O1.Xj+M	#+F:7S\$0V(FQ\r!I*X/̊67=۪X3݆؇^gf#Wg8ߋh7Ek\rŹG)tWe4V؝&7\0RN!01WyCP!i|gn.\r09Aݸ۶^8vl\"b|yHY290߅.:y6:ؿn\0Q7bk<\0湸-B{;W&/nw2A׵A0yu)kLƹtk\0;d=%m.ŏc5f*@4 cƸ܆|\"맳h\\fPNqsf~PpHp\n~>T_QOQ\$VSpn1ʚ}=LJeucaA|;ȓN-Z@Rͳ 	.2`RE^iP1&ވ(\$CY5؃axh@=Ʋ+>`ע\r!br2p(=!esX4GHhc MS.|YjHzBSV0j\nf\rDo%\\1MI`(:!-3=0SgWe5z(hdrӫKi@Y.\$@sѱEI&DfSR}rڽ?x\"@ngPI\\U<5X\"E0t8Y=`=>Q4Bk+p`(8/NqSKriO*[JRJY&u7#>Xû?APCDD\$Y<X[dd:a\$ΠW/ɂ!+eYIw=9i;q\r\n1x0]Q<zI9~W9RDKI6LCz\"0NWWzH4xgתx&FaӃ\\x=^ԓKHxٓ0EÝ҂ɚXk,R~	̛NySz6\0D	؏hs|.=Ix}/uN'Rn'|so8rta\05P֠dẘ̕q5(XHp|K2`]FU~!= |,up\\CoTe╙C}*f#shp5mZxfn~v)DH4evVbyT̥,<y,̫֞2z^K2xo	 2 Iah~cej6)]5͍dG׊Et'N=Vɜ@b^p:k1StTԙFF``{{47pcPطV9ىLt	M{Cln47sPL!9{l a!pG%)<2*<9rV\\]Wtn\r<ė0vJ栱Ii1Ys{uHհ?ۖUoAߒr`SCcv˳Jc=-H/q'Ew|N{\r};>xru5B*\0Ma\0{HUCW廳yB'<6[sy@{Q>?/<K@ B|aH\" R	@>~@BhEL\$[Sa \"Ђ0Fe`b\0@\n`=n.*̔OϘn<jOlM\"mR/*&T肙T _E48|R0*oBo>S%\$ N<|ξy7\n޴,鯢쐬Pt\"l&ToE05norv֣Bpp\nP.-,q3\r/pPb%mP2?P@0(/gpz0`gυϑ\\嬳q>p@\\u@\$NeQ0(A(mcL'`Bh\r-!b`k``N0	ЯnN`D\0@~`K] \r|ʾA#iYxf\r4 ,v\0ދQɠNXo q'tr\$np6%%lyMbʕ(S)L')ޯLMIs {& KH@dlwf0x6~3Xh0\"D+A\$`b\$%2VL Q\"%RFVNy+F\n	 %fz+1ZMɾR%@ڝ6\"bN5.\0Wd4'l|9.#`e憀أj6Τvvڥ\rh\rs7\"@\\DŰi8cq8Ğ	\0ֶbL. \rdTb@E  \\2`P( B'0/|3&R.Ss+-cAi4K}:\0O9,B@CCA'B@N=;7S<3DIMW7ED\rŨv@DȺ9 l~\rd5z^r!}IsB\0eTK!KUH/2i%<=^ g8r7s%NE@vsl5\rp\$@P\r\$=%4nX\\Xdz٬~Ox:m\"&g5Qn(ൕ5&rs N\r9.IY63g6]Qsvb/O |@y^ur\"UvI{V-MVuODh`5t\0T,	(qRG.l6[S0@%C}T785mY)8Cr;ئ)M+4	 4|Ϊ1ZJ`׉5X,L\07T\rxHdR*JЦ\r52-Cm1SRT`Ne@'Ʀ**`>\0|I!E,ag.cupÝ9`Baap`m6R~\0g-cmO1\reINQNqo\rnqR6nSntwæ\r]a-a*\\5Wpv^ OV`AF3#82pH'J'nM('M=j9kZbBn<@< \0fe:\0K(Nv-!1ލH(Qgµy< d\\c\\s,u˃q0~i~eѶ*~Ƞ~Mm}Wؘ\r @\"i\$Bcg5b?6!w+xl1``	s .vCnhEd Qid\"6`\"&fx(\"2Qz\$[0%0lw u>w%ر%wZ\"-u%Yg>x\\-פ-v\\x^'M	PYP)8%C@DF \r@\0\\0N.S\$YICI i>xP͸͒:ͷ=T,'LٞqQ2͌\rdΔ@ђ9F`OfOw\\h=}SjGGWALRJ\$JP+7Lv,ә(̵ZPg&z+j˘7ͷ-vAwh ^9TODZCm`ORyӒ!GvzsG\$IhY58xFY9iݍ8UC[eZquA1?و9!:ړb0{\rQh`Md7{2 ۲8H`%Ƹ{-lCXkHӞ|\0}X`ShխXց\rOyX :w7n鲌#/:4(M;cDz;Z3]砛?.\robO^`Ϻ|/X׎]|^!%Xٽ8\$;zTxK-~ 8X)<!yx9: ىFxz+U຃AE;'%cYߪw<{9V:`ʇ<GءY\0ZUZq\nmx)_}YǏ_zy\rY,ۚ3L٪Yٸϻ>M	M	)P\0u8 S!Z{Y9θfV3oOϼE`CЭ࿿XU}lw0}͙7Y3ӬӔ4GJ&äͭ(-AV=f|@E/%\0r}ޮnn\0Ly<+_|#A\"C[yEWrWf(\0Л>)_U,U\\#e*r`NY *=a\\&^g4müe#^|ނQXNI>\0rƉ4^YV#)k>׾ΙԚFW^%ݒ\$+ՍPkY*u~,MW͂hhGK\\C7HmZSZ_U%\rb)gg	q@@΅t\rJ۔7sUK_1tj&SBi\0 &\r`:jF~=T̪g侑!^h^ו/[{B(/|gj/d\\ޖSɗ9G`u1M?3}Q\$qIm~G=oVz\0_p!tr{^Z&	uX1@G{Ь	NI\$=0Bu82S\"6Qpjov\r<ɶU\0.EM\n8VoQ\\`?L6=\rl\"B2pu&\05\rj0VA;v\0eH;ʇTJ6pH?/\\H@!ppC+5\\+a8;\r(*TƢ;O|^Ld&/NIT|#G`j%ǗDZġ4nii4]@t#5cľ	ZRyR`@ँ\$I{z胇4| ׉܀@=hCEH, ,ZiKàP|,gz*E)AjknK\nC\"J79}4f*465׏Q\\cM\r{*1jlFm4M*`XGDA-qqab19RHbg8+l/ń (ʀL\" 80(Dc#ihc`8A1\\uK(4!d38шƮ4j;#Øs85,ucncFNpPa8G8rKύki˕4A	8TҨ26 ;*iX2%MBJG &C*1T\n4	-#.%'z#8A+@S.0׀II`UQUdd\$)*]TC9M*	\$b+ѽΑydt\0-L8\$e\$<Aɍ!d\$p@]d&M+2Ey߈((_|MdvU9!eD	(W=#_'bN;'\0O<LiA РT\0QJ# }Ba(/uGB%-)hu~\0IUPr+1%51ɒL`ܞE'(/QÔ%T)9OrT],?<a	/|\$O@ZIXN|%,SK:]ha%)kP\0,'0J:	&V0jهJM*xP)jKR \\\ru\r(ÐWF: k\0NJP!Q2 'H *\0gT|~g`D,Ͼ\0#	;(\0 Lf5'`'&t(LgA\0'ksi&dmP\"Ng`O& X@	%shg_sbf5M>s3@T77+nSdӧ5'6s\0\\\0O:NLS@ P{;9ͶpF@78_l9\n)Rg9@a:i\0vSDg\0S\0sM\0B\0+Oq`>4	 T97=Mv=q'y;'LfFf)ϖwPTf>\0O|?0)O~|`#N\0>'Ϫ}ՠ>~e	\0?*P3\\@͌5\r'CP OE\nMB#кT;=jPރ49Ez#NƉ٢FY\\\0CAQJTV7 \nv0@_QLRRc!V|z6KKюeS4\$aI|PA+.qKD-S EvbCO>H<\r#LPܘs⥺P֭20 =*WL2dt \0!<	bq\\pa@Rd ofKMp \0}z\02Ձ3\" )@\\*grM#!8dP4%>KmA\$CjtqP9ƸYjP:vTu 䆀T`=pcj*xdm\0MJjFmpAFQR6FQlDjEMSȖ4\"\"m@JQH@(h`Of8>P8	{;57,)䌆mSvgAᓋ|PdOx2.S,᦯86q,Nz:L\n(%>O N%'>\0U9aÏPIOH	9\ne5@\0ALS!mqv(N7==YANR)ϊ4XJgSmZu\"N:*4*,:		рL5Q2VXR5ש%a@vJ򋈵aXv(ujT6\$X胙Vا&H8z~y^k`?l wuuz@lS~@.\"ES*ebM5Z{l{a/XU1֡񎅦aXUl1ʢ\\6s:§Y}ިe<,s9.!SV\nb\nhK#l%g[;̤X>˙gQ\0ӳlvDAuX=B*dsaڊԕEZFl~b{\$_r\0Mkw/~y|Cj^5D2%[Duxo{Dڶݶg1\0Ƭ>/Zҙa\n!E Ad*e@}U0 7}h\\+1U5\09RVanhm b	  =έb4IO_[@Ju`}N@ܳ()xS\0 z\r\\jW 'Mw>[.KNxv\0 \$) z}(Z]bẼ+Xz־Gh?EQbvKWQRKqE~IT5)n\nT-yDK{`P/V:I]ni3X^~L\"(S2k\r?clU,;M\n7ꦖRfRyԔzV.ko >bs(!ۋ^=F\0.סMJI.Hiً8A3 `(\$ړ\0Uр?(\$~D/paTp\0CZ2.,.} ѰuD4X	p3x+i\rEx	lј2)0pr\$>% z3!P(1PpL\"\rs\$	7%Ɍ612Bl0|.Z(?DrZ@<m{fC,an#>2A8` N\0Uf1<A+8Zqja?}Fp:\"8ɇ9`0݄a\0nB7=n\"o.iJ0Gb\\l:bkdXPˊ<)\r\"K;1Udb8LV 70HQ*c*˙WYXḳ-ѱ7|R8KܓWtL2<{5ٍ>e{ʟ3\"Jā*RBcлVq<+q̅'##>2F0\"XfE{|ctM5ȷ>D\\XMgc	gU'5\r9%QW'dNOW#~ueWߧ;\\S&,}_| !vx ]m1|Dx.Bo,Y	tø ]Yl/;YA[˄u`7q?F\rv-@٘\n3hj#K 6N^H\$(|\$e'H%pğ%	l\nK cgB\0%{EzYjic&5nGg/Z} 7G\\KK-Qfpl㘾w8aL*}]@R}JQqg^a<\\ gC[PR*4_YVv\"eq0?YwV\nݛ2Z&m2@hn\"&@H4OU,;˘#L[(T].v{|\$\06{+\0\n/\0tITŶ1dI	@*96tSziMr숁(\rӱX\":AބO\0(	Mwӆ4JKV92jf~@L\rCjyz\n^KR԰WVڸ7WЋF5cGP=n;&8+-C\rzqfT@SАCͅ5kyk/bEŠ8}t餎foH{內I%aod\$qzJN!oP6dFH\rqivcEPE	4p)}+fwI͓U	f{Y0u=Mw`U*Nci4+. m+lL!\0ro};a!'l]bYv%\rZ}m\r'p˷NiOIWUay\rsܨvn++mdLp\nU\nC\rwqc>Q7c\rۙBUϚv[7Ŵ`Q\$gYT9PU@v[ܦōLPNξn7p&\r/w=~혃rp<@e-K/eV=*_a;ڈ5e5y%JBb-08 .֦V	 Dg\$U54Am?@\$\"'{h85c׶BP\0&L+C\0P0'0P?&ϐ#͒\nB\rX's`!rNhx1dBdɿ;rJa+CF.6)},&Q/L?	ƬWkp`Q,UF5=h{ZOeWfWe\0ѯoPi<Q&\$07{Jebw4,[j?Y\\ ]#K.Z=\0Z%&Q2]rBm|<>/k/JVkl\"Aao۫suo99cG\\Ξmp_RVE pR@\\^bmҸ&g_.A(40wN~K|xr(r|'#GDkWB\\[=ScRc[78i1/m^\"w}zy\np`6(m\0u#NecT\0xGZ:87WV!ˮhBEBeے/&,GڍBft쎓耷z&b2֐}a׏Bގ܀Կ |\nt\0t(kPpWi	Ͻ;4vNt@qʣI\\՟?;=WtVH)\0'Bq[1v3zn#Nc}IS99|#3\"43p68F'9X}^ove6C뗎6B[9B1ŵqNy&rY\\\"\"v;p=&a\nT\naC\\\0002DH0<R\"Rc=.7U|FS>iZ1Lƾ_O!!D4.fe౷,Z@\0<F.c>_}ʠpC<I=Z05ь)ގNz,u\\p6ޟy-=5!T#G\0*mInʩ:*i`7h罈EB.֜Xʉ`Uqssl[S+{	0{7<pn͹.]xmb}<[ݻWVhkY>e5\raaFSx̶OcÐ[Le𗂤 7>@+|;.@Y'>E@0@@H=C`րb-Ozmt>==3n!8DM&Jw.]\0O?[4D#~<O\"	otBcLK1	YĉIx8Qe)`ǐL6+جBwboL]+VPBE幊_Vxr|[\"_~HGspC\n\$R`Ǯ` \"@F?	Qq^`W\";\"IPDǆ2oCn}sx2iwc%\rN\0IC8pYP!)F5 	c.o7dZ`<*74w(Or0n9'tX6g6\"V:V`\rZZA&!_O\rOD	 ,34/om)#}yĤ҈[n4\0<D. B>\"\rC;@\0D0Zb\rV%\nRRA}\".P>n14=&:>\$^RMpQ\$L\01𥀔}mHB		Ah1V=&L	AT!\\)^2è.Wp.CQؔ\0\n`(.	9@`(|\0ʦ>#@2D@֒\$E\0frv\n*`.Ws\\|>H*ArQjP;D<|IN0UAX=)kX0v1ݐAU,#DAc@(PAZtp[A/	00_B5Ik4dbQgT1%{ѩ=\$PI=KH\"0\\A;	aҢ]&7A\n:Y\$)\n.k§	Ps\$\nRp+Ј/'O#\$,𡥰*dЀB` B	AHTD1)IQtLNC=\0e\n{,<4BIi%\"P\$BWh%SP30MAE\n(pA|c)\n#Ǯ'\r8X'[5C0B<BS0iBfLx	1f	@ДC	;CU,8b\0ޖt)\"2AiRC\n/:ì;	_X(\rC\r;C_(B,-dC\n\\9PC.=B-t]Po\0N	ֳHh^F@/<\nDj`れl|/ !*G3^\n@'	C(H'&\"\rLF2Dx!jDI@<vQ0 CXH\0002^;i~TH65  CH5(49I ,SF_TSFB5\0Cq!`\0OPDEWQPEE?Y<S1]EYQ_HKX8|X\\7QqOx,GJ\\I20SQ#a\n,<\\ =\\]+%I\n\\\n\\FiTĪ+,DK/1\$'Z1TUPE |R@/({Q`0\\WE9Uщ+c <9DX^E|R!lF, q\"H,dbŧ<eqF]ɎFkUQFClRq(	DgF!DeFw0ܱ]le1F%\$eŸmM]ğۓۀxx\0)Xm`[K`]mP:iSM=@9pSFĘxB.t\0p\0U\rNA;hx~ w҅x8s`!_k\0P1@\$4w1nª*\0#R0?	'\0d 	(HxG\$\0H`(xGDtH!\nɁ ǞFJJ|6>?XBQFQ\$`\0>06T\rZ\\:	(+ FJQdf`>\0d1hPpK\0T@0BH>5 i 6ƖjB8Z ?4 7꼀D*<lH1 75%?leQFȝ\n`<bĊmrd\0\"ȼ91+VG\0ɒ1?#lHAl\0̈'3iBD٦ocZXMJ\\#2mbJ\nk@GikQf)(&\\~k!*E(B&T-`R݃\n\"iH\n\n=W<@ *Jz7,z!&\$C.H\rF`+?t֟u]-~b%xd)\"|^BWL3S(\nb#AR\"&HCTؙiWfIX!qD	^HT	9(̚\0҇4)) \$~06#\$*t#;<DڤRx}*#3ʐgCc4`@&[#da?Yn;x:LF-C_rk 	\$2#\\K\nH+\rT;+TR2\0r*D<rp!@IZҙ(oChO넚`2\0,]\rx@:@\"(H+R-ܡ텱+b Ib(aHH# I@)ҙ\0X.@Ɍ\\i̵3-`<& Ҟ\r#`ҍ*H\0L K.	i\nv\0/Xe0\0/T@6K)\0́!c힬\n5Ev\0\0LҸ')Vҍ;:&X@,\0Jo,ळ1Lbʎs(ǓK:ɴb#I-؉RJ\"@JWs:)Ltʁ6̬*\\;!F9	0VG;,So]L34:53GL1h`h'ÿK02Cjo\$N|HY1#\$3I\"ԚKJq1ԺJ0BW1\$0伮\\\$&TՀL_5\"p45HH0ҌMR[6\0i7~	\0iB͇6@#͎@`M*MKLF	%AYh\r!jsp,)-(`,M}#>¤Q\rԌWTҐ\n(MAil><ދs{(H\"M萤iSN M\r+6zZ@? 7M9\0BKJIjlq*RM#T'n쇒k)9!\"D/JO/+3\r˗.P[H\n\r%#X8m1ZX66zxn\0HT|J4ms) K<̜lCP.\0006@\$\rKH>K;p5D\0;t-#\$I0f83;3ʦ/=@?g-kA\"i4H82a%R2+Fpa@pmI>\$*?(\0|\rϩ5 1(\r2˶`OqmMJ\\	>|O8,:8,cr_Yc4D&\0dBe0\$T~S&Z\nR\n	 Kr:<%|9oPM95 6PQ=:51@9m\rE`,\rTmF	P2Q+}3^f )Lnd`\0+Ь\$DR\0'J\rd~j\0қ:\\\nJ[?: L:/+>(!%1fg/;;3v%|t<MCDLCJo: \n@9P+Ȯ`ջ/P5t1J0 OȌu5HRMRղ:D*ȞDToD\$36z=TFT졵R\r\\F\r@<)o<S\$GL	\$t4-XZ]Έf2is\$Q%6+GcSFz4+LlA=W.lG,\reR\0˔)3eQfPV.xyHbDIHx{G4GԎR\0 TR\n%@\nKI}%TS3\0MAEI\$QM't\"E'AI(;JHbwH䂡9ITGJT\0J5%QgJ)s.RJu#tRE%Qq.cKt4`˂	UNS\r'ՆFE6IK(\\\n@%H<IL<s\"(%@(L	Pq\nC:aRL3&rC&SFZY0>ĸ@:53MdԻR-4x 2I9G9iaGQg)(T\0FQtK	LDeӔDkqArAN@wDB&5l;ۉ8sA\$,h'!U\nA\r`(\$#@N	\nJx04O|o\$YD\r)JƌϠׇ\"(5BD'9F0`I5Nc?E/`=K0!c0\0Ҽ|\$H́F0IFJG&\">\0u!p4m\0FrL%HOD)A\0@bX	bd/Akl)АOU@6cMb`:U:ӲO8I\ng#T )O\0\0`	\0(i \\D\nu>'T ?jb~`&\0`4IBu	LSAzCi~8z`!?RK-%;53TeL@T,9qU\\ )=\0DA`ɏ<&@Tzc(\n;\04QU5ԩU+ԲWu.KV-M5`'IVs5(e	alUd?pU_X\nZYyUJtsWeK^[\0B	_fMWJU~Cp_5T2\0 yX;iPB̕'qDW-cQ9*LF^>p<\0Ć6f3\\H,YQ}<JuYf%Yg`6V{LMM4)0Cj`9F갡լZxYVZi<oZڜ5NHjOVm[aHPTmm:j'\0<V[^ռ0!?\\ou[g^mmUƀ[CuDmjVR\$zgaZsࢫn\r&+\0.]x̆ɽvc@Wk[u\0[[P݃]v׉]Z:+Vey^OhV<UL^tM\0O	%\\\\`Q[T5|5]Aj2%[S\0mT[P8o+u\nMVUA4)\\x<5W&Z)4UO\0],`CTppd? 7\0\\x͢\n\rX4>}jJoXfWSJitb\rvnɀa{4@Ta=vf\0Ea5jXa\rس`틑ugaEjXՌmX`ŋYvh]XI`͍-aѓD\0݊XcV5~2@\r\r&dVAc݅Ɔc6G]\05DvF4aEVLWbJXaU6gi^MdXHoYGd଱ȷeXevY%[UgC\nN!%6\0G0eaM	(gdUvS9d0\"QyN_gSf]aW3+af r)MY[xa!zRAY\nv+4Yg9zLݠv6\0nmVxiwu/\rUbP#cꝖ?afvXUAg)hHeY\rfxCRiY\reM`2FeͧV*Yi]aTړbͨj}vXYfکj]uٲ6Xj\"@\nB\nEX	jgv1F} 7J+͢,\0Q\0;`BZmkZ~bŮm&lVYl=}c5k5g`Y8O6lղ-d\\bZl]vmv5mؐ\r#?	gVT@)]\rxk>k%\0;dٮM65bLX֭SshE֛\n`S%h'Z kZ=5jmfZ|oQ<|`U߂(76,ق:֛]dpVamm!l\$Ep\0֨6EAd/5u79,miZpzȗ	Y:Ģ>b\\ip77f{q܃p\\0c546_cv\\;d5ė+\\.!۟r5ܧoʷ\"9h	XQr 70\\q53Ir9M WA]\r\\t|o\\_rʗ!rWF7s6]%tSW>\0swWOEj\\mhZQʣsWS9q]_r`CW'^u7\\]ժ]qn-y(Yt\"^a]aVgrmط^]sUήOݣZw]Wwl]2XZtu\0	tl6օANQVcpͿv3pj Pvd]w%# \\<^v{v5]U;qXij^~W@l1SRv>\n@`ɞ`,PSfX*\"V#?@BW^|E\0\"y	)z2\0@:f^Oy3r:n)h,D\n.yr8C!^z=귕ƻf\n Qcq\"\n,嗗\n'!r(«f> -\0yn\0/L/I\\D\0>z0ս|7yy_\\U^^\rԀ{\ng \$	}_c{	S}*\08{}m#{yס(z-\0{	 (z`&^v!rTzW^Zg\0~En  7ލ~7[}_}Q2#|f\0_\nn!rȚެe^{`^}^(^z6W`~m7`'{^|@}'_|]_|~	ע߽z%ꚨkX#\07aU kC\0|\"=8\$ǩzˀkXyM76}\rzv §KyPDz@)uI}T'ʞ	U/*ɛn`kCy8N_	*yz7}MZ#\\%VXU_	uar	UNC}MWaBz8`aW{EaTv7ԧ?2ea@X,^ܜfUvEaoWWanI\0?Hy\nWǩyjfr?exz~@_ O%&cT?wM}=U<g{@\\'y}J	x&oS\$\0)MWݏY\0U 	P{\0&a?8? 8__E>bSiР?HCD?@@(bY{n?*oy8\nj/\\bߪL*XmIق؀Fm⋈>.`~/\0\r/ jɬ&zR=Oxޭf`wbӅ.J.X	8\rTw*{xyDzxˇf68鈖6r2XLǩ2b}%a8QVNc?b?\"tb7p)_ܚm~&?&9`z* ~P5AB?˴0?\nS,a=T*4wx=ǩ(wU-ⳘHX*.LT&V?iⷉBG\$y	d3FR/NDaߑ89_n\0V?\0Xi2 *du5^!}Vaϒrj*C8n\0fdpݒ^I\0'M1ᩒ\0Y7d/d''\0w)^icb{M\n_1w.&0aUVfB*yB	K\0\$ 	eE[oeĹ~&XAɄAbTbIب?nB\0^B_Xe\r'ݖ2	e/@;*DU=d'i(u_OX*_ƺT		J˒	嗖[jT{@87\n0\0&T7d<zckI*S[leZF* *\0-Z\0^ifG.1ifP\ng\0lޥ02eۀkY/B:dJqKf?gLj {Bjm)f.e͜+h8ov\n9-\n֓(?p\n/\$?m_<%9Nק\"/ǯoiHnJgx!oٮ\n(_\$B~|͜L@HyU*zX5rfND	N?5'>A=?#aTE[Ra-NS+q-z5=呐ҹW5\n8bx~YcձfF,\n)|Ǟg	+k\0H*@ @Vy|ז\0[~)cbyF~J,?FXhzq.V?(yRUVy+j\rn? #Vh3h	\0if4*\0qf{\0>\"bjXf<>(b?b'zH	\0/z)(b~\$՟}')~c͢n+bp.鞨b\nig\nhszh`fhL瓢2j z-(hL?\0cTY⁤͏J܅@\$\"fdg埦9{*gTiW!S9QH_C._E^~x䡦\$CBd'>	:~yã>n&pB-c_~{Xޏ匎k68򀉃&mR?vm3V9q0	)c#:#d  	[iS}Vu8US<Nynt{j^ِiϨO'@#ƀ\"gYc{撣_թzp:?V(?jk #`P~I+kVU'*~Q.^U`Fe]8\nقjaKǫn?'pµga(evՇ<1>9P\"@<ш\$`d9g\0F&\rq\r1b\r\$;@ڃ-@IL܂TP#;%aj\r}2rMeLaRӃL3Ikardkzs#LISVz\0ۮikB&ψ#X.lf{F :S03Ζj`W濺kCef*8i|أ}oY㧘`\"\0!P)!Pd\n͜hnFKc^݈H́>)	R&zXKPlqURF\\uBxROFHv*}lo;'ll@H	)J)^{%DO\0Ø>HJ0>;hUTBP#{8\0?:kqIa]HкH{4Jj]\"&F)\$E54!e	\0\$JޕKx0C,RAK/˿0%Q6yrP،\\%R	01Έ]/(8dF\0ƀdؙ^TۘL)5sL\nmG##\n+ 4kMD9]N	{R*>\0뵈5{UkAƿĳA9TT~\0O\0asπy*ȕ\"|rOcy:G	rz><D&\r2H\rC\$rWm)R]eIkZa)L0Tؤ&;8mI.}IEn+4@JeMY򯄔P1݂Y\0IT/*Mha4z\r[낉R!on/v`4TDQVWTM)&ۖnZϼIk}VgƸ3#9^DQ9kkfN\0o9JDgYG*՛n5núkkBE{RHkZǌ<FZ=jK/%|3}'Ro')Sۖi@6f8nVZY^\0?8o׷W\rM0\r XbށLL\r70rDWlLT80k;K\"+Q\n\$uy=vC[1 %Lm_ 6	!.[[ʵvL,}	8raxg%\$v#5a6R\"!pO6z}I\">ҿܙAOq9MlkTԢ@\$ȋtFDmb&|IDl@IpoW9uرF5A[۴&ZnI{85qe4Yl¬h@qb%[yCc6T'6t\\Zk0q)/q:;AE\0֫|qőƶΗf@F6:\03#\\FLcnmb(-Ql`2k#TmG%{}=k2'\"9S2\"+7!!,.|#\"WU	\$7>frP&6km{kl'Zar\0<58@2/g)\\ʏ)kl'6qO\rr+5ЉrE}ܵr%|ˏ-|\0*<\rt|r&<pdHsSD0:I)<`kB\n;@WO-;/xN5y(NEõy\\	P&3H^w?P6fuC.)vͼc#Yu'!Z\0¡(p8`0,osyQE':WrqOrs!_[Vaz#:	zMq	9kT wR2a	Wu 4]\rf\\\ntC\0I!Ϗ=P('C\\sӕM~#D(!+X\r]gII|5s_JGK;\\vN¶tlG@WmDOA7m8 \"\0Q|,t 5=3ԳiU>}E7A#)D=a	\r{OBOQ2+s:g=J6uMO=t	>iѼ\0b`Y[Y \$&i~\0e\r`1bXg5 bG)GD{0o`7S\r?8%ѝf\0quXͿY%5y6pe8脀0`e:8xO9d\n!.~F=jo%O֣;PP֧Vᬐ+F;Vd*rXՅuЅt3Go\rQg\\ub>qs1m5LrCt҇`vֺ=%rKvo\rgK`?[QK49|mUڀ<0/Z%58`5ïY}b]+YFW\$\\CQ5\0qbppjudнui}p#'mW8oFWqQ|1TotdAG\\&&07Eќt}f)Uҡ,l=ʂ.\nuvn=UWpy!s%wu+ektvvFW]wU<Éu_ek\rk	P\"\nY=qwy`J4PjT5qG)gpRgnbp&җzP(п=7wI\$!Xv\\Y]{Gߠn]];'X4Hy߸ϢJ8'nrvg'p^({>	\0bW\\EvHqV,yb^P\rЇWmflkA>(37R|Es#Q;Fr2xresQ8A@PtR	]bmq uժޕw]qpLLi\nEօ>3Gy}Nlw<3wݵjF0p*u,}~,hWXTs8}qs/wUYHR]\rOpLQvC@֘s^<[3T#.A|^j~ \0`i\0Ǟi+ldxMmI<HOI{C%h`twu%Q:4\\8ݔHu>)/u>Z3@oSb@/Ѽrןx!v_\$H(I]3=IiOqY\\}BtG6\rp]Ҷ=,lf\\+Pݺv7αpDv/yoeeY&ba9#O{SiwoTL(ot^7_T[ΗiNk]D>	謑A.k) YiKm&WƓxzM4̂[I%MgwX17J؛NmzZ]tfX-ui͞pd<ə.IdM.66(bUv\rzp)O(NMUzhY2g;?<M<Z?>Jq짴>\0D՝TEߗ{b-t2gw߹P%/BoT{Ӄ\\{xZYKY[!.:ހY(.h+)]|Kv.{=t?gKz4w>elW>ƾ?Pvb냵吤\0i>>wu;a6k)?Žmdm6SUanCz^!4=|~M?K?#OOM83ۯcmN6bgI&tO\",\r9=Ap#'^wM)8T%wv^<Ŷ\\O}\n3?Яh?EYє!EaQC3o^gA,WE10%XK4L.	^|)oauSo=i?@y4w4>\nM[lFcx~տE}2:4	#,|tqa^!̘i\"..rbg\\K|#g}vYX]!w,r^vݝIH!;qJ긒?zWח{`I7D}\0uӘ+2~U,~~]O 7ܜ3EW_K:^s_P~=ʵr`6-TaH	tOS1Hyn\ntwK=p&?vu>M2n\$?LO9_2AⲓiI2|WKуw]eϿu_]?=]Jv\$EU#ܷ?Lufi\nlpmX>tf\rxs.*O(AP?4]x\r^E8nJRo\0¦%[\0004w%_K[SJ^nOKVUTPޅ9܁?uFSx DW&Cxr;.8KyUB\0CJ	!HeWJIf\0o/V 5Z\0UKY;EjwD%`n@4FI*o\0` Vq)8c5WzEF\0B~DFŧPAYA]f*-+Yf<ŷ/_°:DPyA,mbq8XHڷ\0@u\\!d^Oڄ}%l>׊VmY\rڽ21P\$5rHDHh	Ee!@[Z4(`QF5\\(`O*@9\0fD~k \"JQBD\0@\$DN\$k1	}`(R|`P6\"KX5*\0Pԙ[(\"fy,1\$;\"8\nLYX7ƞV9gX\niHapSIY,!V3\0C8|,N!Iqj)҈ZX9+jȬZs,FIgŸK9QI˜9c٫;M[0U*Dr0hRca)L&pGFC_\0@94̄F3.}{5f^T׿0lA2l(+0Yь2,xȉB]vd-ݟ0ނ8m%g=ٓ&-#,Z:c:x/e9d͍Xe`@(*݃-FEeA.`X(<\r<UUDJ&#I\rF	/cl~Aw_˨lZA\020QA'W*xY2'٘a\\<	AԙP6tpg\0B&U>AW3v/pz7\0V :kCA'2O[\0EexQ)[;	pQYbR9bY_&8pA#\$0]!x@͞\"xP^2'[\"qPh3T|a[b	\nFH ԲB\0\rXH&τ<'pH0 maT#]0惊U|s#(LLO5gxhE,Pi	Lv]P!<V	8PrڃA <(fl!Ah!x>`5}2@S`0\n	C`	!B\0&	 0Q핈994ƙ8gIc\"zSc\nD\")J1c͋;X/~Y1~\$\$1laa!\$G,aa*^f00aLBㄱ6#0X_pŵ\$qcBhdbB	|h9!bBq\0O+Na=A.0aBc\n(rpz\".>(X}aIc9,) мC¡&\n hd01I^d )aXð[c?951En'VͣBn0VarCc4K2V4\"Kl8?/<,˚L2j&ؚ8	ky݅P~F,v`1_Ӎ@ACUETiCf={XZd\"¨(&VװDfJV]胓; k\"B;`)!!ql:m)T\nz\n\0Czc)˔ضK[| ټ\0NiZv陑[Vl\$Y*fHU+5ҶZeWs\\k2-KֆDG7@lˊf5XfНcf_:6@,'<2Xسl'<z,IBg\nFx̯JiC<'N\0f3s(Avop\"\r3qgu{8`KhLyc\$mYҳh 9\nƄ	46hi\r{CdJh])AK3iO#FR,ߴxf4OAR\$iOɤ	xC3xg\0+9-R.Gݗ(Bݣ<G \$\0(&X`0Oɦ`4i,P(npW'\0_JO?pCZj;?Hf)MSO&Uuڮd,Յ<BRrgΕ/E[\r^Wj١B#f|%bn2\\IVz%TkT\r7!5(tF)qˈF%̔c66Gr?&)2<H7> m)K`܏6R4am[oGߵ:MtZ\0	DtFoM9=KL	q:]W(tP7@BMqkMTs\\Y2%?586\r\nMὁ·okN]oT߾tJMsJ!{8u-]-4*Xh1IۤӀ0c48\09% &Rv+#n7*\re^:ۣ?ޱ,]wL]5ȠY9Io(}> (&`	^Ŭ_0\"{HN'_2m6Bb\$~\$vՑj|T'\rEkZgQ丈sG=*SSr01q_2<1\\8p]X=RK\"%p}Q;(d1D\\EGYĽN:\rd(`~bvpTC1\\]VQTM<F^:0@0#yI@gg\0:8N	fA\\Orn/n^=e	1>2tr)-xAct`2c	R>Qm5Y%7kq\\lCXXl\"Wc-9r-KdL\r1xp_Pmn^3χVB?S3\\dŧ/:#1z3|ghHy~[632hHk<\\Y]1ԈkF(jѶԡDƐCYti0qEf4EJ\r[94X6Ձ]xtHk}_5zxǲ#\\8JTPGQ_\0W\r5Kcč6B6C⤹C6YPBtP'lW^S6mfw8`ltep>'DVxjDoↅopM5oӯ5vexK\0<:Kmt\"8\\9ᮔ@ 8wBAW3m-\$p\".IJNĺ\rdgcTnr\"OEE\r~; dP&>OR: H*ɿ4oTtUQE\rE*:\\\\\nGIݭJbxԟ6LQ:hqңf? :\\ѓ\r|W376twתKջ!|	cMa7cǁ,A߇##EwG-V1v4_ǜf<x.)G<!?1m\$)qB=0dJOJcCg_i:\0KܨIajgF@&Qfu2'-	McGwIV=[?\n+sWc\0edy!LDQ\$)SY<*.MqآNʇol%l16_q/]ѶIp1DR\ny(Vf\nY\\鵄9P-	;uVKD<0N@@&-z+Dd+nl\n@J*l7DM=q\r!sqQ¦8^xPTaI\r7h5ȣt`yN9MA#dң@Nܢ)/\"T&A`\rig!HNҋ(]\0ϟS. J OBDw	Nn>y0)2u3)1\n00/yہ3H}ԊnȯPLI`dZ}iO6S={B+##_Kg~?2Q`S'l\0![ǶR	בQ@ݸWIlĊp愤ǧ]v|(O_Zu<E`Q6.h,&N]3Kn[ȅLMNj:Q*YxG3}@6{\0hbQ`	kNSǶp>4c0\rcv=R8e@I#L=k֨(G\"ҁdav`|sԒU	^+TD.7D2T=t.*]ϲTco+3~!gMD5*Gu\$tKlJ\$R 0Q%1\rc!>~9RDNϝxTDIgD\$D_	J#i#ua㠫%b2[R[7&Uf~)zΚu|\$*Wm+}OsR@A#iY+##UڂNd\0_5	06FA)'lnY;Oەwm<Rw߷u4NvdIQm';0*\0=,JS?*:SJ0~IIA<Ad&-	&Rj@59+C@}\n=cCA(<POXɎNkmnMDo[0!q\0E\09R=Nݘ2Z'5\"Ez)-oa&g2Ǿ<TқVQF,x`%GIw\$)_uS!P뺈d5ϏQ\"OF.?||\")dPJO5~;*FjLt!cJ&MޥI2=MIBg\\ۂBuI1՚J3?*caU!u攎U&AwFJHRi\$ց~	ClE\n3FsP8\"ǣ.'.T|BQ٥>s24SIN\\W%ru&U}k>:޷=JsnvW\$RiRJH0ɁCFKHj3?\$Kpz\"\0		.?1,y?I\0¥@XuVUc,EXDEa걐\"%D\n<Yed @(D\0Xȇgѕ@V,Z 4eBDR/E`\"0-TCu zA\"+W-H`Ae\\wJ&[<`ê%Kh:aĶInF+0긥mKƲXP[h09qeì,ڲ\$pdˑXܻj00e_V\"ZC0+eˮDz\$M楥E.v<	t+Y-]Q)0;@?_.0U_#T|\r\0T^f<0W-؇eP!\r #2?Z1c[Á\0+,\n\\\"\"Q&2ˇi{JDWK2J%l\0000a/ŀ+5s*{`6f\nCB-06JP\\\n h6pҌ@.33gJ#1PpgZPsP^JgN KI\"Dl\"=ApQ=q>BhLCbh9y\\g)6bC?lxZ1oݡCXA*ʍ>bYxavVԙDeQ\0'sc8}CG8'&XcF\"G?[tf#LFr)iHfDyi1<枅\">4e<Q#~HiNt!\n&Dz.H\")	(%\"0muYzg&E6~[2b\0U	\nFEJVbJ62k0Pȑ<]\$KZAs[Cl3	g\r8.5H8\$Dr&}.kܭ|LQE&FLI\"0kox#7D!V9\rq\ny[Z*mȔÚ\\K	dzdo*\"yQٻ0-#+'h]/ȦFĊ7y(S\$aMI\$\$uMI+93/ʎ\r9NL!ː* By!4c\\X8 u_60;O&:&.Sd00eEѵȗp>FaGz	mP=tiV}|}MP(%e8u=62Iqff^MK>В\r^7dvRm	IH9>>]sR `sgU;԰q%!8rD+,nx͔5Ȁ]:JԴIvVr!ͦ3Vm)\$@E`,\0\0II؜\0@sf8\0p\0󁍷\0005\0d\0pd\0\0\00052\0pD	\00072m	\0N%38\rN&8p|ۀ\09f\0)NB\0`\0d\0k4ȓ&;8󒍷N;\0o8pT0s'	R\0g8q3\n\0s9Fp<Pd)893N4d9s}9ig2N\0r\0NH\0i9s,L1\0b\0t<3;Nf94S@\0005:pӒg%\0p	\0Υq8t3gY^\0I3g&Ni9:p`\r pc \0rLΜg8pISoN\r8:qyf\0u	g[N:q|Sg\rΔ:2qӮ^\0s:qI޳'E\0006:t	,\0\0	\$YN\0i:w,sg\n\09\0i:qePG\0i8*wllsO29qSgN8y0i\0O!Q8Fq|ӓ@Ω=;u\\3gyQ\0qYSN:s4)'48s	g\0i8s	;y	3g\\N9 9'?\0i;u)3giV:^{T3g\"c\0y3'N+=\"w\\yɳS΢=r|gκ;qީg5o=2zlNq:\"w	%OB;rq	se5:vvLf#:Fui峥gN8{49S'IN :x9'/Ü8|\$9J@<x<3'DNn!=jq,bOrmt)'0+p8{d%ϽI>nush\0P:	,sg&w>vP\07=v(9,\0xtyfϚ<y3;6\\YӣOa9Vut(!N	>{,ͤq\$PY<vsi3ЧN㞱>rS'ϫ@~x	sgπ#A\ns\\Z'?J}녒4N9*{Is'Tϛ*;rlytN!Avt93gNIBZx*EP},m\\Ӗ(UL@qLVΝ>*sr;^xt33.AV\$tgΤ\rBL:gг;>u΂9.|iȳ'OZQ@tDY@1P>is'iи8~u(eл)Bʅf'|>vtZKB?uE)h::Ô8gH@fx3 Ψ*:YƓʧ*_9pL%PoCZ-*OTn!>.zy)Oh3:fqD=7C*w!O_DvrTyӜw9shM7Q;ugNʝ;8M\$ZP\0h\0ƀ('[>Rt4	'>-'т<|zԧdO9<r(\$g^aDV~u3g\\Q@%@RS(,QYF}T:[OBrhYM(i)>{	HHP.GF&siTXgOCFsبN)=XQ͠8um;3N?pL3'Q;9B0g~QJ5<Vsh;|\\:NE>6\n>r}֫k\0CS'O9.gi	Fp\$ygOC<Jj@ϋ/=v0S4:~tT&'R:	abmgxN[IC45YhNOHw;N9**s;Βe=&s}KI':\n`I㳓0Izl:NI֎JI|yOϞ@53'NEV(N4={+3hғ>:<\\QW<uZb'5Fn:vѠ?	\$49%p?=\$sjN,:QAm4Pģ?*q,B0gP@V|\nWR)^؜Iti^=t%\"4)Oo\0m\nG'^O❟>|J\nhѮBړzW'O-9Q=8pyC\r&O̿/:Vљ\0	~BYS#e-7fLP2˦Q	.Vɘ2&YI6\\ِBfc/ޙ%Yj[#f͚_.8!ޱcfW%?F6R%2a\nښ4@f)v;k@R\0L\0{6,%e\r@y\nV鱁\0L/=Mc24\nanN\$d>2̚=4_N&\$u8Əy.+.iPVi1nŞ9lgʁeL9E@o<(Bln\"_\nҝ@mn`\n	;pM	H~͘i9TiU*n+\00ZOA-zz\rH4DKcM3DISu\0uO\nt3W0ftɬ3r\$?jNMѶ 	\0В5Vi4bT60	T\ndPYckQA1X0KT4\"eB<T\$IS]V--]p)!*g&M?qA1fp\00	!5RXҳ\0jL(&i6+e@!w!䭒TCRb}P5v^f̝<[vmmL؁P}8&#*8 ډu\\5QH#X7*`+elVdLŗi8ꑌy1@qQʙI*\$T*cMٕC0Yaeqhl[,U)GԨaǵ2\n칃)D^UE(j35YO4l	f@§+{6Î0\rje5Fd%w^\0M^'\$3)P09YY\0P,-^Pd`̷jO)b%R%Y%A9y5eZ\nOZ\"nMTN85E\0BԾ.;I̃)TF3;sP/8T|*rh(6\$\0py?~L\0Ϫ\r`\0LLuOeTB\$#0\0*0[U)-P\\aT*M(jt2%M2Ƈ`Uc&0m*ff#T.`9LU<_GL3I5&jBTU, &_]QKXՋ	eSa*3fORUIv?aՑfNzF-,Y Vv#Y<uO!BUXTJ]rUC'VTz]EU`3Vq=(>Um*77W036i8UԘ3WReSui!<c.]@d`X_ȝL7*\0G'F%POtjׁTPmQj`ӈNF}_hXGh(vS˅BU`AKK/Wrzd=:VȖ[jH TJyFΪ}̏UWaW-dĬ\$%c[*2X=d,*7bUª+(j_Yrueʯ\n:mYB	#L\\F}dZYY˕f;=	Zem*hVLh&K5k+\rj%eoU=a8[\\۱WUuk>6(cCYx0kխj<{kGۭWv],*V\\F\rYՉ^l]lڿ~AW`5a4ƪ[m%`JWVF]bT_+\n/rS:ÕMV!f3x25S+OV+^Xe+V3~z̴k}1&nv#Ug\0\\5%qI+WUȬZWgYV&45*LVgVZאs*6`IRڹK%e9Va~sϕ+CRZSևHZ% \$+{ޭ݉*>VƺjkLUT˚}i,V\\t̄+W-}wx3׮sZl\n5Dg%\\8Y\nV_iPtCJY/U᦯g!^l:+ԃ\0I\0^3WA_^iZ&bU+E^Ba\0\n#^Zc2gښS{\0Ę7DP/hum}ѯ2Ȟ\0|Ҋ5!_\"V`SЂ59f5	Ua*|AZף10ez)Će^ѐ@X-kY&áz*3\0β-|ʅ,Th1Lb-1*\0_^.ffOF9QbKX*fZ u<z(AiON}5}k1:%qXy2XGUSc	X;`\n\nS¬hPemzg+xaz>d,/j'0m{jTl2Y+Ea=_k\raSjX,7,=uj^VΥs<)YP4f;,<5+b>5@0͡@n5&ءdTsVV((3X٭ƑXd )6)ړX&òxv'acW1,\\bXhae@X&ocT)vlШW0a_P\0?%P\\lqV(ˬ>=K+RXب}<WSҝ5VʁDz'';k5T<&Nx5*{	r\n5f,ܙa36 %P~\0	IXe@DA>:53q-c5	6V٘l+0eca͓\"V>бQb57ٚ/f3_;lYGP3*\nv+\ni>t:V,@'d	w\\YKVO_F+\nf&VEP+³l`L\"UN@+80j/zRk+\nʞp(7Y/slv̑6k\nPXɳ8%VfIس?aˡCJ;+XV	+*A3ڙU=fz`\0\$;aZ(Mc[dsX`?'Qv2@(\0W\0fc{;&s/?c%SV\"I?dĭ{F25+sTePQ-rp`lWAWCR*O`2:`0b͚ͥ1vokk@u=k462CAʯgTv[HĒah%:N~a:(AZ06kmB!jy:	Gn+@l\0M0	IͫóʹTC	RMV0aMih:vhZa'^+IK*vqAGʜNr'\nӅP	ت׹ęHͧ{N HX}d}2W0н5NWIZsitZLMMµX4Ubl/8pM25ʜVev+,I'8CTlF@m\nr8XSj Xnh XBRpMՖg7]ĮW%MhU<`4p1\\*]k^cGi]|	\$*p0!Qx\0ؖHyw\0002\0^Yk\$FK3n,3lRݱ`@\rm*,kd_[\0ol=-(J\0٢cI\0[9^:g:%!^ZbQ,[HMl-i-[AImNٍeV-[A_mrU\0\$[?l-Cm-mYš[Imm[i@/΂mصn-fmյKbn͸KqAÀ4l={q6m[7mB=sۗ9nE;pӲ\0[-Jpcm[D)nr-Rq<+f3-[¶<%v۬}Kp([ple+r`[mez([me{(۸Yo&=y-[ηHn޵}-P>k}v'd[klpW-[oz=ˁ6)ok(\\lK6Ũ\\#p	-kl[)oc\"n\n(o.prvE+`O\\&WpUnDp\\Gy9S.!\\V:ěf3&\\Cp\nT[ڶcB\$n6[B\nn/PqߝÀf5;\"]+܂\0rȫgO۸	q\r.&[r0țj`\\MIqYv.R\\SquK6.R\\|Xpn{vӮ]\\]uq«W-,[ysm[!`Fs*-Ȼ74n\\˹}sFW4nb,s3)4>{9/τsw\r.v'	snۜu\\4\0Fz7	~~=bp	-A\\>buvDnv))svp7s\0ss}ϫW?.bƺ;8;χ[s]{w6n =mKw'*tp3@iu7P.]Dyt,䫤Юҹo:+ӇnI:*ۜ.s,Ps_ums.b=6<7Z.oOum7\\.r=8kۮcut`.{O&vjHvΣu=cX+.τKvP\rKFi'ݥ2zW7in,XOt%z=nһsvڑ;o&ɻvp+Wonڬvm˔7hu*Y=bD7q(Ի_9>ܻWsn\rtB=kEݫ4Hڙh3v{5;w.]>u)~8w}e{OOGumnx>(0>Pw:X,[N3^Cv*;w)Qx\"x;Ww.^4w:K7jn^4_uw.^D!vUK[\"^vK^.]~w[Ӈ.݈v:{d/-y~uwg/\n&Om#N];x5L3ܯ=ݱvvןf]=YrtM/ܡw7nP݆Cy5L78Hލzv};o9ޒy=/U/z3mSk^^EoD]%%qפ\0%Yƻ5X\\Պ(\"0p3C_B|&X^qk6Y=#+\0b-g0t*2bME{ 2RY{BkW|5ZkrGW\$L8j*\"_sNZiLvX|K	V'O/_UN})3ڕH/`A|ѧ6f/b^ƫM{\"\"p^ΫM{@W*^Խٌ3#+鷶^܅ȅ}S*4g|,;/sW1d\np-Y{uiUƿJ]\nU#ECaTJTYl\r}V֮COxbv!C\0P\n8J֕u&~UkO/_`E]Ew/Xz']O9T\n6+Uʭ[Xbk>o֏[:e0YBJ~?!3u\"^bY*zuExE(];}Vx*̷!3`_!{zLX}Uk)uᕤ{_U{_Zˌ2C#k]Zְ/\0D3Kɯdڟ8\$0Roؠr*kRV̨	VlnӉETbR}jܙm^\n-uP1`R}MJej#K4,t\r֜: k .lOl(8q%rYFOtN2WWT\"uj}T@7kSVwڀ姮\\G<I\rp:/'0s{M%\"G%:ڔuZjYgJ>,WT|&5bX3XJvsTSI6M FI&hYq蒨PY&Ƽx!I6\n4!)&07Q10 nъ7X3Hru\00053Cڊ`@<S_p<j\\@TĨt*G+P@M{8CtGMV&ڭz0@;:Ł?4Qa{\rH7˓Hأ`|uL\"s\"\0fPTlFG.\n3u.X+TvND\r\\̇*tb}݀3 l[\0c!ague)mF,Y=Du-ӬqMyͅ7\00<wnEF'K>ab]\n&䮘Y|ZvpZcuT[.Mx7O+Nk	Ki:05b\rw'2<A3\\%60Vu7ͦjk|w1r'um%@I:dl\\R	5@֦pi)5W;H`Ä0pǁZd3s*mV_:sRi)oDpolqfHaQbtx 5\0rG/_`4X-Ť9<@s;{ \"jj£0ah6LFy%\n孾p8ی^k:cV\$2V'\rA?8X=CGζ#c_='@VcbB,(\$I(JWF%\\+`:n#Gч1\"gmbax{q5mmS؉8uBh&POxVpݬ&&&`V<Q*;E]݊N' 6THXv	Ȫ-aEBvQ{>Ciڝ7Topf#LV0Hu>)E]44uB:[pR*T:0)xM=Jb#*쪠8(@=;V1cSkP\n`a]g`PSh.UqX\\:`\0v|M`ֱE+>_JvŤ\nV0l`mN*HFHT\0?,b%ұ-6\n-ld+ʬT/:^RfK:LXBmrIvKV,RepqD^&\0Ea&.\0B]#b\$@6Efo9L,	M\0SJgx҉cYY_{P)\ny\"Y-r]#8ۖcd4^36!\\(ˑwא\\ۀ捰\rjfƗk`\03l䙅kI/݇nN@:'p\0");}elseif($_GET["file"]=="logo.png"){header("Content-Type: image/png");echo"PNG\r\n\n\0\0\0\rIHDR\0\0\09\0\0\09\0\0\0~6\0\0\0000PLTE\0\0\0+NvYtssuIJ/.C\0\0\0tRNS\0@f\0\0\0	pHYs\0\0\0\0\0\0\0IDAT8ՔN@El϶p6G.\$=>	w5r}z7>P#\$Kj7ݶ?4mt&~3!00^Af0\",*4oEX(*Y	6	PcOW܊mr0~/L\rXj#mjC]Gm\0}ߑuA9X\n8VY+D#iqnKQ8J1Q6Y0`PbQ\\h~>:pSɀGEQ=I{*327\neLB~/R(\$) HQni6J	<-.wɪjVmm?SHvƩ\0^q)]U92,;Ǎ'p!X˃LD.tæ/wR	wdr2Ƥ4[=E5S+c\0\0\0\0IENDB`";}exit;}if($_GET["script"]=="version"){$p=get_temp_dir()."/adminer.version";@unlink($p);$r=file_open_lock($p);if($r)file_write_unlock($r,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];define('Adminer\HTTPS',($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure"));@ini_set("session.use_trans_sid",'0');if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");session_set_cookie_params(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",HTTPS,true);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$cd);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("precision",'15');function
lang($v,$Jf=null){if(is_string($v)){$Ng=array_search($v,get_translations("en"));if($Ng!==false)$v=$Ng;}$wa=func_get_args();$wa[0]=Lang::$translations[$v]?:$v;return
call_user_func_array('Adminer\lang_format',$wa);}function
lang_format($cj,$Jf=null){if(is_array($cj)){$Ng=($Jf==1?0:(LANG=='cs'||LANG=='sk'?($Jf&&$Jf<5?1:2):(LANG=='fr'?(!$Jf?0:1):(LANG=='pl'?($Jf%10>1&&$Jf%10<5&&$Jf/10%10!=1?1:2):(LANG=='sl'?($Jf%100==1?0:($Jf%100==2?1:($Jf%100==3||$Jf%100==4?2:3))):(LANG=='lt'?($Jf%10==1&&$Jf%100!=11?0:($Jf%10>1&&$Jf/10%10!=1?1:2)):(LANG=='lv'?($Jf%10==1&&$Jf%100!=11?0:($Jf?1:2)):(in_array(LANG,array('bs','ru','sr','uk'))?($Jf%10==1&&$Jf%100!=11?0:($Jf%10>1&&$Jf%10<5&&$Jf/10%10!=1?1:2)):1))))))));$cj=$cj[$Ng];}$cj=str_replace("'",'’',$cj);$wa=func_get_args();array_shift($wa);$od=str_replace("%d","%s",$cj);if($od!=$cj)$wa[0]=format_number($Jf);return
vsprintf($od,$wa);}function
langs(){return
array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hi'=>'हिन्दी','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','lv'=>'Latviešu','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','uz'=>'Oʻzbekcha','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);}function
switch_lang(){echo"<form action='' method='post'>\n<div id='lang'>","<label>".lang(19).": ".html_select("lang",langs(),LANG,"this.form.submit();")."</label>"," <input type='submit' value='".lang(20)."' class='hidden'>\n",input_token(),"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];redirect(remove_from_uri());}$ba="en";if(idx(langs(),$_COOKIE["adminer_lang"])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ba=$_COOKIE["adminer_lang"];}elseif(idx(langs(),$_SESSION["lang"]))$ba=$_SESSION["lang"];else{$ja=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$cf,PREG_SET_ORDER);foreach($cf
as$A)$ja[$A[1]]=(isset($A[3])?$A[3]:1);arsort($ja);foreach($ja
as$y=>$dh){if(idx(langs(),$y)){$ba=$y;break;}$y=preg_replace('~-.*~','',$y);if(!isset($ja[$y])&&idx(langs(),$y)){$ba=$y;break;}}}define('Adminer\LANG',$ba);class
Lang{static$translations;}Lang::$translations=(array)$_SESSION["translations"];if($_SESSION["translations_version"]!=LANG.
3533312954){Lang::$translations=array();$_SESSION["translations_version"]=LANG.
3533312954;}if(!Lang::$translations){Lang::$translations=get_translations(LANG);$_SESSION["translations"]=Lang::$translations;}function
get_translations($Je){switch($Je){case"en":$f="%(n0Q :\r	@a0p(a<MSl\\;bѨ\\zNb)̅#FCyfn7Y	h5\rQ<ΰC\\~\n2NC(r40`(:Bag8i:&㙔yFY\r2 8Zӣ<'Ha2܌Ҟ0\nb豌n:ZΰUQŭwDmfpQqacqw7PX3to	ZB9Nzs;̑҄/:|<4j'J:0rH1/+7(jDӊc栢0K(25B87\$B/h8'@,-BƎQEP#O7Ct\r`j[z0c|9h\$>\0\r\n҄=Û\0x\r\nC@:t\"~8_)9xDjΘ2(-xx!H㌣.-D;W+863@Ɍ^F+u\0ᠡ*,1,i8cxؒI¤fۣlZ*/cs.00~0YWB07U\":3xuc@#пC`2'3XIl*83ʮ߷ 553#\r9{5Uwxj0B͡.'(ǧh\$FJŋļC.!n(hڂ߉@N*㢺칈05=RtP5&ĻɓEĄ:ew%8beUz+q3dɓ*\r|7([Ӱzʲcw<]0|]G]MvXl̳?wG핷W:*1ngQW 2<1_OlT@PT%PwQG\"p/'!RD[	9Ufi*<&xޫx{ApEh*P*\rBukI)G2zSj/i\rYuLOjPJF\nzS	m!&hbd]IF\",C3DwIBܜlcgAlW\r!+Oz=G\0\n@QXj\n[16\":9\\5reH_qIy9s	Kn4lL|L@FLQH7J12h匳uDX!0O)8kxDI\rF'F8d&e3[#-k^Y+e܋r	9ɠ*ٷ`+QD4ʾwbKL	L*4\0*Vv10K1?R4s	50G]#4o\$DTHSfDe20fFhH)vbz7F\$p \n@\"@Up\"]J\\0PbJ1H&26J <Q樞LT2ЋSd_Nl/Ś !L2r_j#KB%I((+\"	r*3g6yӐ3:p#sP\\#OѻƋkl\ruȋ&Aɶ\$`lYJ꛰JN%ͩj˚}/\\`E\n`޵,ex}tbXZ1-xy25뇈J0g6&ZܷSWZ.ra&d*l9(E#~Qկ+FfrKd\"`Id@PC	\0(L1Ka\0vͨlAsH_@B\nM(`D]_HZtA~v,1A0P3ih`YRN<:3ޛv&l9hkˮy,u--AI-Q#lDfpݞ,x	G(+PŶ,)/P9r'dda7Xly!\0>5>U[BI\$,D%(lL<,6	ɻ//9F*q½l('㬶Ŗ,1^mQSlI_%D2T|R-a\rޞQF\r<l\n\rJ-cw	˭d\\Ե\"Wq~}}pI7*!M{GF	OIWR[~!rULWipӓME4^m*Vd:O幑VPb&mZh{M.FHK&y}boe~ły(bmG>O,J\\:+(fI&X/&(0V~ND*bll\"L.;PS#BW,i˔/D5\\J9.2\"|GcNB0.(	Cc	V0&#Oab2_ŨPd*nlgv`(2 LW+>DeͯUpp\$unaN\nB/+up0,\rC:\\fǰ(Z\rp\"1Cdhǧ^c	@|`WW(1/3|\n/\nyNGK0H	bd\n~E*]\nbމ\0L\rb6!c0ظ,+M\"'qb.\"	qpmLNt4\rV\rMNz3d`j/%Ћ\nZ&59^O\$L\$ a%I\"qmk蚐\"⓬,/1(rJ\",\"g\"'X<l	c:):`N\"Z*W,.r^!@V\0.Y,Bk,*53..NA-r6\$g,+lLP42Ka\"^#\nH+#00b-&=5i7\"G\"?|	0,v@6o&\r\"-LBZ";break;case"ar":$f="%)l*C(Xl\"qd+aN.6d^\"(<elV&,lS\nA#RNd|X\nFC1l7`ӄ\$F`!2\rl'E<>!!%9J*\rrSUTe#}J*d*V́il(nTIdu'c(oFe3Nbp2NSӳ:LZ&\\b\\uZuJ+ωBHdNl#d2ޯR\n)&<:\\%7%aSpl|0~(7\rm87(9\r@\"7N9 4x6x;#\"~2ѰW,\nNlERv9j\nV:Οh\\pO*Xs')ir*&V3J;l1B+l>j\\z1,t*4܅NA/ډH%-=lLHBPG)\n\$R2Et,]4R25 k(3\r1C351A(4.00@9`@Y@2D49Ax^;܁pVT3(ã?x\rKJH\r#x|1mNR*))U8I\"TL\"8I[R3Qӌ>,j\$WB9\r\n0!VPH9CMyRSDBY({*QT:0E\$D)*0)0kZJJI16HRY.\nGKk\$#kch5 05+\$&-k[96]MTlZT=&gNĈX[1r/tّQ!oݏ#ۦRJBǕ{!LP!N}sYth9ki\\C`ā0|f\r!X =h(i_	@4(x7a_0\$x΃RPA:g343`ث)TJm\"ĘE`\n\n/A\0u]\0l\r5H!08&0RaI1cSrHΌ}-CD\rQ%_@pn@H1`4+]l\n\\@`\\jBPp:0`^9aF&#\nHx|2ȋ:S0*U>Hj7qx5Cp\r+]-5#[ˁq.@D]Av.t%\$kj>ΕM!}\rS.ʑFR.d#\r*,p=NrC4C5yD%XPgH s2u	ѩ\nF⼈bDBhOA'`jC@p\0ZI#N A9;5Vra7Ue?a|N&hБٳY\$\r\r1w74Fη˿0Oa@!07\",GE*(qhĭIj %\$ʚ8Rb:F:޼`L6>g,AK-MZ3yI2K(I&}XzAt7k\0fA?͕a`P cHB4:lmhFT\"řj`.\"5>sZA3\"\$({Rd917\\YpD4W. (gn@).uX s2@kV`F\nA39Ƚ7#HqG%VrJXj_yLQpp \n@\"ra&\\ΞKe\$aK6{)¾\\NI\0T̶yjX\$~Ih.T LQ>ԼK[ʹ,#lTDi` r,=ؾzdu-3]O{0lcBցF/+-|c~\0D]Li'g{nD'>v	uom^q,m裊8S\r!SUCH\n	sRi	t2Ѕx6W;K0\r߂3ZC(-́cCu5a<޷6#GY4Gz	YgS*L@t,J4)I\"*9c0@PC5PM*a;Њ?'챎FRrpDhMAڥך+2\rasuI,C	\0r)ݢ\$ʥ'%<\0\0\\φ݆UC,?~B/q}dA?2\"]]yz\0akN4kXjHGF+o|v^Y`D\0SV?&~j~LO2o.\$A\0 \$T(bB*OV-,C(-OP\"#g%IdOB\"R0l\"MV\$\"`0k%dh)AV\"'c\$/dwJ&Gt3\"\$!\\xM6hDTB6fT!vNSRq`-ac(dO\nb]Cgwĕg\$SBFb湮#˂ļ|Bx&D·GpM\\QPHdH\$N@\rA%\r\0 kڄϣq?@\r`a`	Tqb%RT!XQF0j-q!0LAאPEqO?zdHOةblCZGX6.Mlη\0QcqRv#DhH8R1}#\")l :epEH\rX!P8fpZB'C(djpInq'ct,\rea+*RΊU#..rN<ar\nEFN橌)=2@\"c\"rR<2VS ws%<b,M6S\$r>vs<EAUK4s1#3,|2W5͖ch2%#;:L8 0F-W/ Ch9M29SS.C1G/2So6;%5:-*SK78вyD޲%23:𠏯9?T3?\$A38hd?)Q]5sE><+CNcBA\"&o\\@B6j\"]rk*E4@4T]DTZ\$fKEnBS4\$\"]H:sH):tsO:NphbR-\r>\"TP!HON4) L/:\rt(:&	'v>B!<MhlC*Oi-	8o޷MEo|g0nhPαOO>Feo\"\"Bn;pH\rV@EYkx̉\$\0\$`\npi{\"3ܷFzHSmhK	^\r5bgrj'c/sRr\0E@2M]/VM\$&Z8.\$╄=\"-,/n\"c36JGqm1L0QaI('HSZsb`f4CIDt`\r\\{v\$u.F)Nhmc1\$1/o*w,>v6P\nF-3%Q@W@r}F1B\$gtI/aMZ:c#KRm#Pn\"M#b3\r@fFJ3.Nn&Dt?\$f\0	\0t	@\n`";break;case"bg":$f="%)h-Z(6Q\rA| P\rAtX4P)	EVLh.du\r4eܞ/-O!AH#8:ʥ4lcZ2͠.(\nY(\$\$1`(`1ƃQp9(g+8]*OqJ_\rGiTh~McN\\4P򂞴[1UkINq呺6}rZ״)\"Qr#Y]7O㬸2]f,D5(7'1|F'7QLs*ns0,{ ī(H4ʴ\0\np7\r7I00c(@2\r(D:Q;\">P!\$p9r낏02Pb&٩;BҫC2izꤨRF-\"؅-KAOłJ<\$i؃,ߚJ)(fl ĚhQ̴-r:Hz-;RƵ*4l\nԍK\$6h=?TavW)\n7(OƁ\"OLf\$hii̝;P;l# 4,gw\01qpTgEфd;#7H#\"Ɂ4C(C@:t,6@p_cJ|63ElX4px!\\&Nze7iCT.)>6N8:bztjJh4Sbʰ((B9\rׂ\nO4N%*M)뎕THhpңH1 )<SHd6t,m?\"h&I%.gх\"⊿	qYKo<\"Ups봷4IrA,4K-htz֋ s;j)Ϋ;z%v|kչ(İh925=mdƢZwBgTuZk@T\nsV`Ԅw\$b\n9BA'4T<A;'	<(~ BVP6z!8\n+`6P掘3*a!:Ԉxr!図gC>l3C,mɔ.ʊHsEEPtCŰ!]3*O#\r98RPcy%ɭBޡpaE;;@taHq(sRLD#ihʤSe}1}Ju*p\\U}]ʕ	g-K<TlɘJc{2ynI,J5ʘ'-܉Xr]\"|L h(y\0\"uo\r!q0`@SaA1F,t91BѤё }LYn\$9QXI432>.B)HIIRdZ=>2\"A\\( al5&Xq2E#ntՕ &iQJ>=;'L*=LIU\\TA̰KT8#-]Nw!-DX\"Q@hFKP@`lKChen3Iê]:۠<~_/e  l&fCd 2A'(\$+Vi[)hdJP	B3ХSlzg[\"9: L	#o Qo_#S=d\rTT@\rOYr7_ ?\$\$ɭh\r!4Eí2!0ˉ6)Ti%[WkhEY}T*dMTJ!tQYlHq9;\0j.ohG{8bkhI%cH+eyǥ\r(TL0NuΑJz'J,)S)iPNE9Մ'WFi+崲)CaqB֕-CVKER1t(eFÝ(o^3YW\$M\njڛgVyI)nJi*V\0/3>[h,X q	m2}E;Rno/`QlL ŕ+sk88BP_2.u?ˁ)B!<FO7|G	7t&B[=iAJ:ʩBשFYA#q ﭛŊcZ;JuVfי\r_F>\$Xe6tU]>]?^dĠų	Vb@A~㨿\"\n40&bҍ+dw<B/rx)Bt^p7B!O*ы!078`u5;dG<Uh C@-^UzhB\rzO\rd衤N\rv\"ݭP/u/-0K L)~(2P(8).Hkd` a\$XFLtx)P\\(s-ţ4\"%n5_0ho[\\{\"(Lq+j4h~8\nȌ\nOhHƎEtR(~ \n`\0J\r\$l]F\$tI\"H2(jgɆ-TFAK8n*O<u\0C\"w'֕`Ij\"(	C0QTcl(aCTڙëBK9f#1XOj91<q/ѯm	ɮoq\0q10 6'.#g'A<\$p*\\PRqQ P iJpEJ;'V-+Vr2ǈ΂LQZG!bGA.#к(ubƇ%\"\"n<Jr3eC/|`{LhiGT`x\$n<B)mDK\0͸@BBI*ʵ+\"όQg+qiz6Bb.novю2/0,rv**0hls\r/*w/2p.bhFƉDbg>t+&!huc%eN1\nH(vK@HDs4P6P+7p0m\r.\rIYFnO\rE\r(o\rؾR6~_*hhdO+O.gSr1ǈ3u?)?dh+2=s30)^Th/s,gzP+%23g2CT;9/ H)XJ;!f\r+4iAq>Qm01rX!Gj-E}4R->h2N;CT[CCCz:9SB)LTK#O8,q4LJO<Pt|cD^'\$pĘi7œ:0>g!?֛(PfI/A@K%&21%+H8Nl\0MBLQF[LYUY!N'OC2P);Xp#RՌ>>\r|CuAEuԲ5ؠ5A5Ar)FRw0uZ4\\)Q\$I\\Kr77>J/^..&4LIIu0F4{dTdYՎTT\rtZZePV2vm?2kXvkJo[g!	hj?VVV5lX<0βuQc7|AK>eA\n4{v|1>ƖvgvVWvCY-h5_͉o5opQo~h97mocr합m\n\n#uP\"s5K^MgDN07h\">rY)FPq@֣`&BFsZ!vpuvnre7jWF˵y7p\$4,eMf1{t_R_uPz7q`|bUQ`%g}ahIm7Z2e0ҒsKpx}VsnO'5VieDg9\"1?B!q41l9)-Xep=)Ҡr맔'x,HԷtiqx*1<&8\rV-d#N+47SU4	p2LJ,&PbFN\0@\nZ,ug18z	z18:֮\"찜J\n\"g؈g]c\"po}uG̈́\"w8)Q>3(I✀`O6\0N4]h8M<RYlM;@e+HVN\\7LXz!Τx2>բ,Vuc3sD11ߒ\$3Ri\"qy՞\r>x}Z\n.,a.-yy׮Y\0U{n>x%mbclt\rqVMUV4p ~}`*3:e\\Qby>OE({)!ĠTQ2:%6䁠q\rx}:\"KQD)гN Oho	(//֔kOC\"cn\rD\0mq7+qw.V-֑!jV9};WA#l";break;case"bn":$f="%)Ut<d sNb\nda\n 6#k:jKMŐD)RA%4}O&S+&e<Jаy#Fj4IjhjV\0B`ULcqؽ2`S4C- dOTSTLZ(JyBHW΢Jhj_\rmyioCZNr,N%Dn৮еU8O2nŭr`(:NS7]|􆇵88:>n<LuCO觽g~S+~j<.yL/M0NBS:l9F'1PB¥4/jr..j6ԫmTd\n7-D-Ilj'@Ep\03mP0 aL?	24̙oKa3P	|2jpLJ`@}0A/2\r,S=jq\$i&&1\\N,O+cmFJz7VHp{~;#s0P-0J6SMo\"vsK6|SSx?\rhSStM..JNͦ\n<uE7y_BHڋ	p\\/I]O?'J^V^\nxz'J?\nuFyelKرTONv`;B6#p9R-oc*4(tm5#*UH9%nĪk+`U+H_\0x0@2D49Ax^;pß:\\7C8^2x0cxDȍ\$*=Eixv/=4@+mNivPTlBN}:+mO,;TC_N\$ɋu/>U\n'\"9kT;':]Oﭫ|%˶_	*es8VM	q29*e僋N\\Jo(#\\]Ctb!L\"ϥ ͊;\rf\rv10JPȖC6\r'J.y 	fa_Ot[\"^w-TP=;AL(ZBd#dKYD/F5\"1dcI}<Sw,\$Q_n:~V!2Fr!QQѼ(\$Q\n6EۊgfEYaU:VJi*b=dl4K#zN2J:.M:BZv[f6BABvH*TF*dĤ\\˛0s<9ggi!(sU̙AIzv4]\$|\nh~zU'fNRFŁ'pf|DTmf\\Aٛb@R\$H6x5,F{1R2e|o}Q !;Wc~Yy)Ri)  CXx	g4E\0crAMT;)Kkm6{8' o\r:1G}MZ-(IsT[+`ֳ.Wba#s2[eS3uTPΌ2VV=5i7iBt֬{]pJ'j/詞(oS˅_fshmM7xVV\\:8@c+2&V]sQZ{\\Bm	\rqP5WC%h̸\\+q\r6^))4_;AVOUuMNY0M{@A\n&28Q0ӏDUV2gB[P(5_E^bpX(,.r%5!l(-8rUN*1RςL	{)fP!M@\\iҋ22My=/cT27<y[]7pxekٻf@N[\np@Rǡ\0stsLJאd0Qz]hLNj=zJVyS)	F5r\$o!SS\rKXvN#)3#P -&,L=OM\rcouűB7fⴖghOK)gM%Km\0T#ldi'F5l\0Of:0]Qjmm\0i󕝿h S+LPUtQiHL+G4T]l)p+b'ቫ\nWx<iN^bCv\"VU*.Ϗ/Ʊe\n=k.>YFbq#sY	16JkF>ޏ5^v'ИdR<S\$K5n9+yv0zڛv2,_,ujM꾎+8*Ξ(+ۏɑ+F??L+htbbo\\'˼wvFrH4@`L|W'z,t*LLh|㠴@E6D&@al\\\nP#\"t\"ëF}n,fJApOOhQ`B\rI\"},,Lgm*\r6T*Y-hᏎCബPj@|)>NBpY	Ad'G.b~j+mJ\"fd#l+nn\\\"LrO,C	'F.,\nN1T5Owd\n@	hL*D\0/DG9\0l<|lCm5NJCplTG^@-	N:BwtǃX*QH\\O\0 \n 	PRh4*^-Ad\rELhDA\$G{zHUG[~(d`j〨R\\R`gД*-\$#j/>9tTre(V]2/x뤢,}*/JJΌT\\4\0YlN.LlV-ҾʣbJү'̏%A.3/R<?dL\$VœY''*k+,.ҸB_21C;6	@N&*HLT<q\"t%8Ƥ%,i:FŪM.cl82TfI@b=EΗNcvX_F2-g8P6q,Üc	GQ#g\$P[eA'xǪ&]޹L,23eBkT4Nф-#DS=BCAB4&Ig){aBS;1	4P\"F,')I3p^d6\"fO2N)츧K(P5EevƋw%rk{M]c`Pq	JLtG2\r@F4CJ28I/BZ`OhN1?`~CK @\r+POȒqBGk3GU[\01JyJAհFT0ñ!	oQ]JT}F\0ՓHGqCL]5kH)M5d3G%[sA[Tt ~Fj7uPt\nTLOY;p>CXuDa+N[&&QP̑5+(\\ҙSwv[+Y<P%{bbU_b^V5Vu[5V丑I	YGT4HkRf옺=?\rLDζˬ6U\\&T+Hm\\evjT+`EaԢT=\"ENKbx,?W.c;r.(j*C#[hjbjהlx/rvp_|ψ_4'kZxw4\\hWIfSclGiYRo]WX#u!3XfBjjf5v7s\\ԵxT`9y5Ҋvԝ_5z#x*4W.syw{7{Yj?ONn6Jn~18x˞]7ĄDa%Gx_B7Uh4i=yHei!`7vg#N'sV{	/d5t7g5%F}Ni%w~-]wه8tV\"jZ@6]uufu6X-@݉6鷧lvxmQ7@qwX/X|uQwDlBX}՘aYXЮ8#A{xa%HwQfU*DW>zfÃP\ru\\=yQ)9_Xϕ@EttH\\H}34sfJLigyuti׆؃vyx_o7١*l|{ J \nzTvjhOy;aNGhY29'i8%M63-\rb\$%~↭RUa2BP'vGMny\"q1Z9kq3'dKj٥U/3dfM\n2*Eb(,yDvABoAPAXRi㝴Tyg键j0\rVQw~Y\\->\nZ3Kl8Jsa36#bOAIZ,(oK_Hn?0_.kK8]9E,ǲ5^bCLc>zHKcY|32^h9¤ʔ6(PeXbf[(Jj2CPլX+hIbbN8)~<㧱ػiSަ\">C;إy=|NpaG%:vWr@T=M@HW </#쨵p.T	TcKC?o5h;.\nxSAa|?,Z@O(KudΈ?ާ,'Srio¹EUlvV(pO\\w׿Q+%≆RECj92*Ԑ";break;case"bs":$f="%(l0FQt7aNg).&0M磱7JdKia20%9IH)7C@iCf4* A\"PCIrGn7+,lbdѶ.e)zCy\n,΢AJ -e3Nw|d\r]ŧ3cXݣw1@ay2Go7X搳\$eiMpVtbM Uk{Cn59.jc(4:\nX:4N@;c\"@&H\ro4n\r#8@@H;*\0ߨ\rò腱P.\"k\$b#{:Gshl5ϪҠϠ6J9>0Fî,&%iJ3*5'-I)#U.AЀ1mPS<P(@;C5IB#'\n\0xC@:tt4:p˘x	BJ\0|6hbp3.cj4px!=/;=ʃC ɋ8?C;N2^w|6'2LQ9\nL ,MNC!>ãdvCH4r4# kkҿG(0d c	pP:\rpb^p58ɤ&!\"V:5;#'֜M5T5HChӱfӠJHJnz]_^:=3w\"9|kwjĆF)A1<zsખO*X#\n/<]GkCMg\0@6PWg2WKhm۩93,gEmZqm1%|g#(\rԽ9dfC2fQ\r3BH{SP7լ~J)`K\0o9CM|o(TA@s\$*zI%PfXC:~\rZQDiLo4V\nZ+epW%`%L1>ef貵\$Yu\nj)#	5RQcn.rXdgʩVDbժW*^\0bnX?i\$^InƝGRDA㧕r :!rC,ĝ.4JKEF\rCARql*\0J?\"`̂=*/;4w^K*O	'r*2&`H\nԒPPI0䨦Hn)!3Xh4)jj;\"BLL;05lcS\r\r*UNsue2fldjB/aL)g\0\0;SGC*kf`u\$\r)k9FkRX6f*S% 4r&lޝ48I a؊Tqfՙ MR\r~dz9ͳhMM[2D`TNC\$)'XRvb\$1NS\\\0n{%\n4?0oWiP@ {Ғ'ۂMDث/Cg7)Ph	 =aLbiA	8PT2hQ s\$1B\n@U\"~=Jl\r	z4ҒpvB%)Ҽمv!V!2u%s#]8 GeŎLdmtѹ3.slͼ#υ+;xU4v^ɩ'9\0ql\rW4.{aq/d#j>P`IfP\"~AWD3;\$0P0N^eQ\n7xvȿyAI^3DǦs2UDQc.et.}P2i	\$	tPwk_t5RݓA*/85b^Dn!n3%,'>=.lzV\rPaTO䒮Fͣ>Z<&T7m\\e'LMGy@BHq `Z\r.dI\$(QQAy1@^\0SL`N '1R5 \\05	USеq]N3t\\BL;uBhzsừnl&v.!gdLs?:upG^vӁeAD戀Ξa{O)e=djދ'UO!\0)\$4Lk|Б́<(3\n/}9Px:N\n\roQZfqK?7\\ˠ\r:G\$CO}cL3Z@&+\0OTO&.\nbTxόX260o5\0\r؆C@f<\r\r~i|hG&+\0-Pd	l<N<\0\0C;,0&j\nDĈPm\r{L:~PI4Nx@uJ`\rɐpG\npTtMtp0P,AQ\nBaʶ%nBƢY8^*.P8g,qB'\"1&T뢡YQbc(2RmC&E-ΑSb.b:%c>!O6i8BdQL\r'1SJ.:Roq麞l	g\$\"5QĨ!-R٧J,a^ODMѩAp=>_qj)m\$2i8\$Rf۲EQurdVb@%R~kE%ҌfkrcOE#R\$dc<h+3\$.Kry,r(0U(\"-E+IU(m/_2b#*-F& \$s1wc(o\nۢ,v23fCKۤ+d'\0=\$dM3#!z#jm6V0r.}68pM撆f3.	SG\0:22󨈣40뒊s&<P0'Ҙ76-93K,-;?C<@	2B,Tuj=`)`)0#VĹ#Z\$'T*@t7Blۀ]4&1F7(`%C\0BQ<¤`QJh@.	Pu+P\ngMǒ\nZ\rȆ\$\$/,jCT1>x43kPxFxLgsE0&	b=q\n>z/c61#H3j;)`=,N`RL)e	fd f)\";G,׮(ِ5V\n LnkkUGF?S4Ψ}Wӎ\r>\rAmn:\$iK]l!C7 G!`\\LR'\"p#DC+MĜvux@\$\0g&\"hRr\\n-2L|C37@,̺r6V01b]bLC1Q>\nCA͖\n/) ";break;case"ca":$f="%(m8g3IeLa9t<NBQ0 6Lsk\r@x4d	s#q2T\0Bc@n7Ʀ3xCf4(TPfS9?Qi3M`(Q4D9pEΦ\r\$0ֳX~`6#+yedya;D*i+p4(8\$\"M<kXXēYNT^y=E\n)joM|*u4r9]֡횠: 9@9Ȓ\nl`6=:*z2\n&4욊9*Zz\rI<H4H*̈;I!/HȈ+2\"*\r#&!<&:Oh\"D׌06r0.Pʯ<\".(r\"\n\$H4bfQM&P2%434C|	7<0c7>44Y8ʌD49Ax^;r%LAr3_!uJ0|6Ȃ3.ɓxBR j:`Nʣ:-̍ǣ5ꓵ7\nLc0]I+\rP @1*x9ڽRĴx/8+\"0З=22ш}\"2+A((3%Ei\$6-cގ\r`ߝ	0ܝ9aV474#KK]Pl,H 0l#*\nbZ%81Oj\"WxWӀзHϲo=+?Y`x2sr06dh!.C7vK7G,J2Q	ʹ߃I\"/<ܷ:Ia7#k+[(ir/|'Q\$LCi\$	qPؕ@Q4`81&Ҹo*\$7*-zdU3+S(h2\n`sIO\"*CPBgx)u;!茫XKc,zY=h^KFwd\$嬅3NTiGetT\n#\0ISOU#+Q *Y]ȲVX%e\"G;P5]*}E`ƃ!o \"ȱ\$Hdq^DT%\$t #P U1hI6cA3HH\\#l\\n8&pʶ_&bC1`х0'JP	A%AF%\roQ2Xpldw	<D[oF]Nӵ Ĺ/3]h)SC	\\rZA*GsA(/\nngkZ`FT@#'FAב4R	IH@_Œ^LS!3f	; <ZƐmfꎙWHUM:ONu(lݭ	L*E}\$AIW@\$ZW^a?^\".UZ\rqE/~5^UH>ٱ%TÌq@RLh#5PԒ4䅢BARd\nXm	8PT\"@-MsµL\\#(9ZeI)PŰîvNriI<&dy/TPR+T1]-bQfSCS5DSHŜPHHE`rW%qآP*Q-=قY[K>DI=4F[N\"fhT2ŉO+sHi\nXNAaѕjJ 1e-\$4%35;k~\$X0kkDń9WoF\\#'FvZnrD 3ejgv\$)[,u.cAM!ɧlcEHI(s@0nl!aywĩD\",2;|BAa :BleSRB~v1I@cO8ІV?%e7%ֆ0a!A[:|FD1Vg\"pFtxϻtəNDFA:._>>of]\\dBa1';&EH'49RfQG(0\"2(8\\Ĥ,Rjȼ&vCaw\n	{5lğ1WВrKJ>n\0JC.N`a)\\`fz@وw\n/wr˫!:d*EώzIgRa_Mg_-pMR[blMDeh?#(fi暿bP(PL\0 Դ0#mrv\0NBt2\r0.\\\rdN#Фp&#j̊vN#nnvЌ0v00.琸J\nƏum/	\r't3nvL&JJސfMBP4s0?}7bQ\01R\"n/P͔4ȒRP0,و/pqHq?J6h+KM/40G4_QO(BPӫT=VC8Nv=(De.b8V(K3L&2ܐJFi~ZJ1uHjIm]b#,gb`5	 AB3	{\"S \"ͅ2.\"bM؃s02#.4Pe!\"oP\rk'7hq<t\neL1\\2r2,J9TKg/#aQ({H,o(R-R,(-v2.r*r/2.	&o\"w'\"0Zere\rcN(IG\rB2.4/3@00^n-iڭ0P	\$?R%.hm16ƻrO8n>SfRt,E!ssdN\07:\$?ɜЭ'NRNki_d(X0F\"/W>-?%L!bFe@Ib\"/W:?JN{>c@oRB\0Jk PET\0'\0\$6~z\0\np*1Q	˪w&4T!vA{g&H!-lx]PǏ#`-#f2w==Cݤ*ќt2+h7\rEUn\r\$;\neV(e%<DjRGn:ꐲuHt0JcfaP\"BsQQRyR1B0Q\0D(C53D>8=R5L1lU!h\nNF'+ZIQi\0bK쟋XsU|nHyD0F\r\"hVH̠L\\C@RC2+N\",;\$RRKD(Ȑ\$x&R56.l2/HH\$/[h*	\0@	t\n`";break;case"cs":$f="%(e8̆*dl7qraNCyo9D	m\r5hv7e6MflTLJs!Ht	PeONY0cAn8d:VH+TتX\nbc7eHa1M̈dNA^/J{HLlPDܮZe2bclu:Do\rbʻP.7Dn[6j1F7761T7r{āE3iǓ^0b穦p@c4{2\"&\0cr!*\r(\$B%k:CP艨z=	1c((R99*^F!Ac~()LH=c(!\r)<iaRB874BB`5k<<񌣒n99ZBDFo\0B4B9*MCI l4HhL\rx[f!\02ÐLb~0z\r8a^\\04Bx9r9\0J8|;%A\"1^00n=EC{P#57CkH77L^w޶l:[\\d+0}P(S0bc*:.o :(\n\0%	F P\"\"L>9Ŋz^d\rzW@:\\HWQCX&#H4!#A*CFMBbNȈ@WZt.z' LB&%̹[@V23:-{4;#Ӝ(^?6<\rЕ/-C;O0@6X<w/wJvbWr=\n8@6WZC x@o\\	9pH:пDBƆпڧ#`6~xvPQĵ '\"1?\"D\"OE=)ZNNh˘ )?(L'~CVRA`Id &SaL+!ja4\"F'́!B 	'.%C\0{цdF)XtM1\"}\"!s(,0ߐ(nZi:\\²V\\+xXabp^yP\0|Hs=6g5%	6LF«%B}!tGd +PmA:4Rz%%UKtY%UH5jʻW_&*\\7Kܴɝ\"+z=!E\0It!E2e-x<Г{&RHvTխbn	]JHv1LX\"XRQ>KqTH{\0\n\04u\raRSH\n\0\0h((3hH5C=UgԨ74\$i/Ci\\ç\r\n1PʃcBA'DCBJNdM(~L5ĿfS\nA0N2~d9=Z&aE!8c8Jz&V:&wmO,?b1Гs\r\"_tF1\0\"%*O%92)aK|4'ͦÇ\0et3xS\n&t_LHH[1C|KMK8^\rz?\0N	<Sl`؊r3Dho #Jo;8n0Y\$a\"a=Vp]TF:W4=CˑkP > :xN˄#m-ĘzufeHa#x0H:ɰT\$Ő|QxUT]=F943Ӫ4L1(n9(/rx_pt\nj/JQiGFFpQo'+u2Q4a *<3c	:',)K	1\"Ŗ*b]N*/RDISPb%L\"jk.i8y<.%5#i& xjA =r9Xq\\]1.7~2A%0Np'w>n d)BÿS1zyA*\0o3Ln?PmsCLF=` @BH)x\$\\#?,xJ#YGS&[!Lh&!>9o򋵊Զ]G.\rԯ|:Ʀ+xbF痹c:d̪]=Ia\"ck!Ϗ=ˏg@??~'D)1{lF\"zm&#oDM̲#N^GMhLL((R\rDB&PL^B >ZZ`EDG-b_,?e]g4`l#bJf#C\"0zq^f7N7운9\n/t75J\"&'\"aG\nbl7f\r6hT^K\nK|:H03L`#LJH7fzgH円,P]07-@^\"'*&MH>`hLN**\n\0xJFRS8* خ\$ dlHNfqB^e\"%FNp?`P gP´@yn- Ѭ}\rGtO1(v5'q\n\\^b&#Վ°\"Lk\roZψcQ Q  ~2h \",r+qO!RL^u^U\\%&rY&\\u n@\r|>\0\"	%Z'.|DX\")%EJH9zBZBV\$%\r-(<&)NELw'NZr<1	#,FJd8jq!P1|&N_g&e_(%-%&14.̙!K@\n\"U0'*#j94PB7s5#~Ced~d<ܦ<K 2A\rJe# 볿Ҁ@@&9M=K:	7:#siÝ>q>2>`@z[*eH\rbnCӲvA@Z6jAEA7oRP4*&s?MDPT\rCÝr_As)D}BS4rs+-A>bgnw<a;SO8fWTvQ9670sFb`)21'4҂紜E}'4!YJs6ΏF.p贴M\\G3Q6tMĳDGTJ Kq1NtNWHаCX=<c\"~Ds#з~Nr o_QR	Bܲ3?U\"544u\$hWSϬeb Gol@g#R##QT:R#r51Vr4O|o@\"5uՅ%Re\rV;tlXc%vUM*?\"t6MRT|#hKf\"%\np*-rU.҅wr3XoW_trM#OU\"R! i'\r	K\n/FI	c\"	uKhK&B.\$9c\\M8aZ㰨fm*#PM`!\$5bq*hobm-|\$Ppt\nxK֝\"vXa̛Vjr6i3F<smvZƮj?Ñ0\"2?\0a55M'vl=>'7r*B\nb'/03#	\rv~\$=GF\"*v=ef&j-M(.Od3l6tmsbDtO2\n1^p ";break;case"da":$f="%(u7I:\r	f4is4N2l\"ц9Ü,r	Nd(2e7Lo7C\0(`1ƃQp9gC9GCyo9Lq\n\$	)36Me#)76遹NXZQ6DL7+dtD 0\\AΗk6G2ٶCy@f0as܁[1Z7bm8rGS8(n5z߯47cNo2-\"p܈ә2#nӸ\0ص%0h&i'#z(!BrFOKB7L2B.C+02b5,h.ۀ:#<0-܃\r5c	2\n	\$\r&6@>O#1)4\\H4\rD0O9`@PBd3t4\"B-8^xDjЅ\$x|(X+(\$V:cd3JH;Vmx<M\n&(J227=uXމ P אL7\0 Q\"1W\"0:uzSWPY#Ml7ځu;-ͦraCcPBbC?^Z64>h\$2c\$b\"k,5ڤ*'v24+V懲@PF&0ʏbk;`+	#k9%Ql>x!E;]I@A4eXp\\#q]#|u03c/6B<*ǨԭW\\ݏ2	PܐVlD8lB,-L760\n|I/!Ns͆9Q_0\n]2R-/ʔ:#bɣbSLxCI'\n0(TtR]L:U\0rTJ5jP>r:r6;L<x.@܁)Kd0đ:Q\\K.Qj5G(q3\\U wBV6%tѤB+#@h9/k!+3'!:uI88[\"1!a͞\nVgɛ4w?DYЃo{*PS\$(9a\r%\"\"JȳBȖ0g\0P	@dJ@('@R3E2-1К	*\$:R	X0_HU\"I\"9>J9\rA(UN@w\r1Z5R):a4A) K!(0OSPD5pDI3ᘙXoI-6fa8A\$荄^)~]	Iqb(\$3rI\0ģ.|sԶ`ɫ8|+Мzj\rk֓/I24X˄l7̛\"DR\\BZBN9J@PD12CIƱf%XT2MO	*\0BEl\"Pn\nP^𠸥3}I<&Wv\$[Ș3Jl[20j&>NՀ4^P):d,5}{5l͠WoN\0]:&e.cNP:u+EBL)1LB438u<YPmDRfx)(TgF20k\$\r!:`\\8<*_Ol;~ʂi7eZǋh70&loU	#k5#,&1J[i2^d3ՙy}6GPC&FSdpN%(6gqYj8\0*\n]Ɂ1p_\r4,X+@A K<z^p/C	\0[]LN\0001`VG8G\"-j5wLRj4|<%cyD9B^nݸHڢzojJQ_mC]AnBX. npɿ7_ ɚsDuù'|2*Ů-6BgfUC	=\$բCI6nE%8?JSz>A~ih!ؗj_v9+!-q!#aDRpÃ^(oz[8K;#ZkO/o{cqdD()bK\n-:IjKBؚZH}M5\nI:./.L'\\mĮ{DGN39W,]\nGp23|ɛ|n=w_]ٽϿjbh.z-ޯ\0-`\$\0&\0\0,^FJnt p</g&=p:o	lf8梹bli\0d\n ::\n4%QH>FL4Kfu\0؈0p\r8 7(d>C=(y5PHE&f(l[ZoO%aŤZhI1Bdfֱq!`pfq(oRC	Xl\"C.D0M1Y%pP]4Ƕ<#:+Ef2Vt/JhYdHDR(d\nwqso/H\rq B7k#Gv^迥HOѲEј\$nmڢBkHM >B( \"ʫm%M)2\"\"8 KYpN^O%#U&\$C m2DB\nqBD%@-zEt2)3c\\''ƙJ1MAPNc,EN)	e,ȦOp0[p0q/E``@		Th)#NnV(0Vx\n\n@J%#m)Bp.SJ15+M\"+堿T\r/P\0007G81h2bB/hCXOZ\nlB9&bhK&7&̯()4FW=>./4?O4N\$\$@\$,¯FˮRde\"ph	FF| #@f4b\\\0>úl-0\0Dp\"ڼL/&DB =+@BHŸJ0\n@̤\\H{;\$i@-jpP!@";break;case"de":$f="%(o1\r! ;C	i9	MQ4x4L&:Xg904@i9S\nI5eLn4NA\0(`1ƃQp9& >9M(e)V\n%⡄e6[`rbQfa\$Wn9ԇCіIg/* )jFQ`M94x 0·Y]rgxLSڸ@wŎBx(6nBh:KC%-|iz9#A:W7/X7=p@##kx䣩*P@ȳL9Cx䩰Rfʡk1Cˆ:)J\0ߨHЉ\$6(R[74ã!,l	+8CX#x-.+	ƣ3,q=#(,6)p츰th@;Co&\r:PQF;O[ j9.^C-sH-3 cꁴ\$\rBhx0.\0CD8a^H\\SKz	5LcC\$4DGh|\r\":Ct:p:;K`%&K(2*=B?\r̘JC,a: BV`r1Losƃx[p\rn[C\nփG.(H҂lA}H\$kt4ԸΜ:+/n8ⱘ:1&ժK~,>76\n2ف#,/5N/33N-&^Y~ô\"4\\	QSXNϭ}\n\\-*T5-X\$\n߽(D}:- VF#k9ݶ:ȌcZ:EԒzC}\\)2ASJX,lb7M\r'9Kotzb,(4ުb\$1&0CLb\"4七`g\r؂p-\nΝ\\ȑ1>oὮHh?F&4hOq\rL\"~\0Q\na>CC\rҢRA@P!łBb`nn\04W8v%Xk'afbD|]ʯ\nXduTKEiȒ BLke8>bHgaU bGI\rƵF(L^ѡQGIrEk\$tnURF+Ž#c,\$.ZH2bL[OFLtiH0JB65Ht22Č@PLN1A{GqMIƃ\$s!4}b\\V\r=0x~*K\rU2:y\$/*l@HtI,ee*#S	D(F:0!@PQI?(-9&`\"\rf v2\r/ݠ&+Й@Bb`L;20E~S\n\rTWq9/OAc&j5\nkeЀ@*jPZk'H@FP7c`B|u!ivfP	*6ڐPBNJI]~UDAKgb\$p_#\\	k0a\\l.f>,&C\$tذ9h\$4C\0m(kBO!3F;'7p)ܞr)4bM|X^OP@al\nY^r`\rJ!rHђEX;wFf6x+06,H A\n2@.k;,Ɩ3(x&5<ۂf	r\0Xͱ2a:+#S1hݹ  w_4yjLuA\r%X0EOθtQAR @u[!-ر_{r7fB+6z\nl\rw	3\n|udLSS2Y'@6*ZhC7dϯEn*#k;\\=䘝d\r:Ӑh\nͿ4	\0Peds,\r!U&[ \0!7@T.<nGN;m*q0c^|[?ȫ\rM8)1>\r&j\n!ahrS_RTе\nTX t\nyxAyUd,EL5>{O̍A5mD1#8'Uݻ#~;#\"F@dЀOIࢬ'm@{P/*Pd>M{_CU,=_ZGGϹS&UN\"\$M˚In#΄Hg,OB⽀6,b\$pCDC	@(lGDD-\0ZR:oF&9F'p'D|[DMPd:)؝&F0r!D*I	\"}	k0aM^xh\"\$Lg\nmLH9I҈`Lrfv)|gj'z\rJ-1F,ZeȂ#zJmZ\nT(RDC\rd0n0L\"C^-]\nP	sp|=~OqlsE_\nQ\nJWl0h*C>`IG]c\nqDEV=\0dvVpt(oy^/bBF1푩1%sD6)\\˂@b%E	Dnnwo  PBH\n&0 ZI @HH!H\"\$C4.\\ 5y@B(0-%G\"\$e|9\r3!)l2.^0\r~\$NifM_\0r-,+,Gr,1+r1(#D&.-,ÎF=@\nшor\"1GbIq2+TD4iM\n\n\rg17/4͉0\rd\r:6QDz\0{\r\$d&mM8R?8s9:S58q\$qzmXP<-.73wG6N{ČSBs++\\3<>=f\nn-R	@3A#4r@n@\\Ι6=sM.R M4ID%8D?H\$C'3r\nEE@d3U6+\nb\rЏ,~ֈZH/VlBk d'GcL%Dle\rV	h3>lI\n:Y7`Ab<q%\nZJy\$?G_\nBRyHO Jv޺\n2A+\$.f#R=T:EKH	{T0VRN@\$#dV]1!ȫbKJLb@:N(u5\nb)@\rAS	GN!(xFРpb!TYcY.=բ\\C\\%`ЂS\\\"EJ|C=0ن2Sn'\r'D~dH|-N31\rCdvSM5C#G%dݣRZ\"=\0Zu\"R)EC,ue^|ke[nvq˽gH:t4:)@dd#BC`/b";break;case"el":$f="%)g-Vrg/x\"ZАzgcLK=[QeDXŢJr͜F1z#@Cf+Y.SD,ZO.DS\nlΜ/*	D+9YXfad3\rFqck[)>Hj!uq*?#BWe<\$]b^2n>z< TM5'Q+^rJU)qs+4,er5-3J7g?g+1]_CFx|-UtLꢻ)9n?O+;)IjtP#0\nQ!s'\n|W+IHsH<?5RP9~%3ٞG(-4COT\np7\r7I00c(@2\r(K:9@;\"P#K[Dr())JNO1~+LR0=8*ªqt.:Mcδizbm\n:ĺQnIr\"MUqљĤ E>FH	>!dhӷkAFv%PQwKjOzިOT:gE[4L]DӃhTAr,֍	z]jh2N)uw.Jb6#t5ͳ|9γ@0c9#>g5̓45H4\r0=ϡ`@i@2D49Ax^;pÓ2]0x7V9xDl5e#46̃H7x6+]|\"ᇬ1A^œEz/{&DTFͼ|/t^'<	C[j3W(1;r|PH+#ݜ(C2>7Mإ\$^d=b\$}Vv5ʍæ)v6ޥ۔F̊\"\$ap\n'|he]y(AM):E\"32vfE'/hL0GM*2.\n78!\\,\\=J\$Ԓu`i[!°1(fP{L(\r~Kd@QuGϠgBȳ	YՕXUGĆIA{RL#af5ZH%҅q(\"FqHr9#~Dx BzQwW9d:4S34Ca.i`Co4yhe>TTCf\rU&MZUPs8ob8lɄsg:&+\\Ϝňsu5:6PL%}*ȕ8c@)qr5*zӜїcI]jOQ1L.Q	r.\" bhڋzȧ\$u}ƞzDE!VRJE-#bY!RJtWSo\"Cɂ&P4rLPriqڀ jMQ5`퉲WKklF>7yYĺ!؄,O)i\"I\0I\"W0zb!Ijq	IiEVZ]k텱׆SlӂqY\$(jQǡ|1Q*=Lv5ET=\n5?fɓ^xν<a65Z2bB4&ie h!6<q\rs՛`C`o50@T`1:a\rg, D	nkQR|*BWsY=e\0\0(,RQM^%P(.-ɴ\r̨1k;{IA;cINh'\0\"YŎ5\$b )H*]zN޺3Éu&6o k0њJzODcc;#)4P̹S<03\nd&,\$\$%km8.@TI	vSp,1-gAp;l(Zr=ԚҬBAp8<kS0\0\\ƥV|))3z*\"GUC*sZ\0¦څJD!me!G3xb|FF).d>!gcVwБ䘨,0RxDG[=?U0&)LI\0F\n#=D'6P:^{ȍcTwߕ{+\0U|črZ9'\nNbF_p\$}Pδ1Lth(}<!\$<o_'rN2cp/|)ʑ^se5-t9}ݛ~Nt+	\$)<~bAXEؑ<>h*ܧ̐ML\$.Wg}qJKE	22B|P85	RˎCp9\"Dn\",\"6OLbx2utϠAzD*zL,q\$W	Nh~OF\0܇'fPhbxdD9+0.=Vn^ w8`\r \ri@Ƞm`h耨Ԏ|mEʎ0Jrn8aHu;&	 íKZʰƋheF\n\$p\\bq:)]P&\\HuG\$O>pYbD::ªl:` jdMMb8\\iÒQ5./bp\"Hcc\"*2i*j\"\$P π2\"6vp[l!w%9<0@&E,_О\$ \n`\0\r\$ffFbGOǤH-0X47g@Gb)!Xy)u\"'(%,Sé%5-4\nx%.D?)D(Q']*q*ۇ?+A+.&0s,c)'̾b+3.j2.FHT-\0_g3%..ҹ-Bq*1*3s\"&3,p++l쪵\n]E\0H(-^pb#>|-!krrQh=~*\"d8/F\$\$OCb+ԥo@Cy62\rY/o\$.X3X:@\\'o.\0\"Q*\"\"QD'G 2RNZC2ɤK\0i\r*B6l*M\"INW,wdw2\$S)G}/jcF9,~v\$P\\*uGGĊ=*VTc=BaHFx&?CAKb8S#h8DHe擇eMI`9L\n2~ϠCKT~|-󴪔Q?D\"`5#*?zXU@`\0 h@g6^ORv@hK/F=T}S>#@PWk_B%/HX܎TX(<T՗Gh1\$)K#G5U!R8C5NRAHFQKN51(>'<a+X#()թ+R,caaBa5s25\"ubb)/2}2D&Z!_YYUU-;rgP<\"t\\5\\\$1hf.Wi5Szv2>\$8DH,#]J\\UQD\0B%1CZ\",cBe<WmK\0/,Z\0d&3lvړ/i}i>F#XF6mI=9S\"q,8Q\nFH<@ULGkOF+Y5iWhu[{MBאt6y!\"gKw_bwC7Wshygb{W{z5j]T!AS25~#-7Q),&4@@fw8s^\$tAkv:(V<|c9!?|_5Q?_~e`d:r:X7LGZDHChzX\0d,,!	%~8F؈|\$#-\$uUovwB5xvsxJT..Ն6#Y|8zmxӀU`7挖qld͏9Wze-8r<ьG?M{.Ìtؕ6~=dnc1\rkMLmdQQ'lQՙ}oyȑ&mV`șk]#,}RGIY9Y;gDYXms 	z\"[1aX\"W,_]9B^8ۛ@=hwy١z5ie`ixk!Or8J4\nfCY.Tx9V?\nb'^pMdvSS#n5Y\\F86.N/A%	\rv',Z|i|Io,:H)0}er:<1``\rRP(qC:;s'7kmwr\$TdR\0\np&I,VJUIXt\$AHÒB.s/0EtteÔuZ]5cާQÒX#}{ 2m/[B㯹Ţ%\\O, M;<@B-'z'rA!1t~bT&Nh3S\$@ϹO*Y \rTAԽCSDN`UXJ3Z0b[Y»r25<Z`A%8rKֱJzS)v^T\"=XdbW2*%|~BSObTVa.buxSU\"#,1RG8E7#5E5CcKuvЍT|]O:ӂ?3mWSp\"ۏAo]%)HAFr\rK ʁWU\\OںǪtK.ztG6%]N4\$` ";break;case"es":$f="%(oNbi1gBMi;,la6XkA<M\$N;abS\nFE9͎Q 2NgC,@\nFC1l7AL%\0/LS~\n7M:8(r4FdJx#&̆1*rL+Z	oX˕.ifS {4gCcpt:\r'*O{0dd}ɎE!(o7-[NNn2\\AjH}C2f5Hl\\S9㈧+/js1\r3OFF&5~:5L7Z8/Ø3ȷ\0s[ B'@+Z,F'e2P2k4-!)DOP\nL2(9el*\r(jK<9x'D,<QLnDr0  `޹\rΛzH@202\rTx!\\ی#ƅ##DN%\rD R),:5C3:xaM27Gr3_p(I|+SiN6\"Cx!F+F81:L,ڲë^H°Lެ#+J*s(K.\$/PJΌCʘuF,Hx:\\ےMBH14B\\PO\"6ht3 S)\$Γ\r&gF.&{|1ϽGJ`&=;-;Zgi3r >.)\"`ܮB1׵|sW:qW8xr|r*SB\$C΂JӬRz\n\$<uG.2;\"\$:Dsik1lDT\r}p~8i*I^}!l^#>\nPC҅\nIC1_.y<l>mz= 00a!IFYj/*F*dM1Hq#\nd)lR ab	T\r7-A)u!+@@ʹWj_*SAeu{UPjr[ބPDHaC\rBa5WETg)!BE	@JMe243񕪷J_,4S1g?3\$bz8&\\^X :GD#Jk7@m1RPd\n?#BK 3ҡCp`|ó|N n\$XB}ѩ)!l0]&gKt;TȌ0HXP	@ I(P25!A!HHAri-Zʠ\$=2Ayj;bBQyN3!HAHZFƹ d?MBo\ro!0nļHpCcFH\$#p3LO£0pDc/&.}W[Esi?!sPadu ҧ*JTzj!bE:|Z+?\"/V)P	L* e=': BjQ=TII+!Ş\n*@}H#-3E0*a/N\0&[E&ե0`?&AV{\$Fw->܏?(70wBC\nVB' mF1_@>(b^Sc9ɵ\0;1&,Ƙ^qp@M%=/-&:'YYo1БVe@r1&rFt	̂<rlnCK(Ve\rݎrDkS[3Ry/	]7il3 8Pc(*;b\n͙oIB<u>K1AEcGIt˻5HF\\Nuuю2ѭC7,1A^\0%q2RȥڿiX:XCuӸ)('9	;:vH\$9]\r%6FR6_0je@NJt#`AIK|9	\"cCaT\n\$Y=?a\$>\$̹vԏ\$H΂]\r`~gs;6ԋ9Dp3\\KNHftX҇yJw3&4oz6SftT慅u\0Aw;?/!	aA3	Ǧ}v!;!׾>cX*P>R6myc蓷YIAK{^_x@/7.4-p\$;\\bb \")H+w%,~K&{,֋+;k\r_HK7G?^4s݄M`I.L[KDMD,f#\$/t	O碚\\6\rKrZ\r-\r\r,.LFm \$19ǧ#T,T1Oʂ(sg	'8sOϽ\n<5'u\nФrO	J%'dn7&@h?Σ\r:.\ro5PBHXC\$*jq\0005q\nvj@	c.D|C>)h/CP6S &c@!:&h2|C͞(,d18	cL|EnGi\$hڣ	rܾD6ͬPLX1vIeȴk.=en\0a.\"ϸe\"ـAdעh|-D\0#m#&/\$xʮCP-\"9#1o20\0ƌq_,\$m쬰[j!<rf:FG'@hFp(\nei\$O%2(2)č'2)  )O,2QMv,M`@܈Ke.2ܥP.\"P\"2#&n݉C6s\n8]2%18ޑis-0#g<d\n.\nHM\nME/L\nn`b.nR*>13&*^Pn<Ai7EL7C:|D[ie\"#G=PbD瓤eO3\0JjV0q}(\$12k6\"9GxN?1..\np\$n\r`?5BduD tbRׇ\"/M\$D9K0Z߉Tt>=G0/T?ޯfk^Dm%PءtgdJ\r-\0= m07!hgg dLG<3DB,TE-AS 3\"D>_09h/lI\"m(\ny4c@T dL6mH@MDTP 1hSiOCSΐ\rҲ+Fsj\$	\0@	t\n`";break;case"et":$f="%(a4\r\"e9&!i7D|<@vabQ\\\n&Mg92 3B!G3u92	apIdCf4(aLA0d2ࣤ4iF<b&l&+\r\nBQ(ԉDa'89\rfupNI9du'hѸ&S<@@tϝNhgP9NI9;|)@jjC,@m\"ٳq|F=ZqF̶`*y㹸@e9Rr!eX\rl#8+/H:Zh,\$4k§C|7[־Hēè1-i5N;:*-\"#HKp9BB9\ra\0P<B87走\n0)xQ >\"xHH.1>H2:\n&\rjP¹*+2;@?[8@/1hX\rX\04p|4C(C@:t㽄\"-C8_\n#Wv\rR4P\r#x|țR'8j+|ܦZ-j2h\"죷͒䚭`P5P!΂>8A@ˊ\n*41\rhB\"V뜣^*%L\0^IdՌzHBxL}jDk#,r\nH90ycH5J;nX64<9lc(h@Pvf-h(7-b\r3z\$^xm\08Zm=<5chabq#lB*Wݭ8@+\"LGH&'n;X6jOsP#p\\I=eivV\0}2b\r5O3}2\rhӟ'aeC#A3bF`!dRÀ\\SQ1fhe	?`a >Dv8eC\$R\$0Z2nI'\nN *@`,,jʻW`5V:Ya2VљnmT[9΃\n:@BBi^u0!BRNJMʒYY[UZ+epX;HFc	֌k-X\0V=G\rpA`P[delGIXt(	rolCU+3بM!M6BUL\r<riT5jXi\$iޔ2^BމI#DPQ\\\n (O(IID,ω28FiL{`'&BxwNԭZi[sD3@u^q@jFrA-jN4]\rm`@R8L4j@9Jb%j\nC\r!4s;V6?9Hy2MRU,al養8*\$mR}IS)TpTXS#\nMWjG[k`H<uL\"Vj,7Ʉ3\0	#`CWCwM\\\"A'H#jr(3Rem\0\0U\n @oD0\"\"!^\nNɺUIJ;bx!@5;{8ʶa.(1HLfLXVQ\$?TPI]O:Lnqh>M^8[[<#̊3')-tUNsի,g'fBQ\n\n2Bp.Z1 _+3^\"PSVTFU1sv0yjN+2tk.\$75TZа\"\$~_G V3辰L4\$,5J貵>?kp=npa\0iCPf8nIPT\nA\$#pxd^`&'/	d\nhAIO闈jev\"`SJmdRN\n0^@@ @ΐ`nRMe2 ^\\-x˚skHh@j6\r](H a9RI(x-bN@1m5E]&[!1#Őf]ԫw-\$ȉ\"S5\\8q6:^ÑrN!!4w,LD/ka?iMS9b'KVLӕٮs\"w\"O%أ=ݽ>=3YqY%>;(MS:JVJǹ6jNXH:E>@C\"B̦2mv1x(4ohj.א64VZؠ-EPvGʏ	 nf	*XOς8~VRLBBO0ǧD^'J!pFv6t0Ȯa	)\rGI\r\"\0\nؾOn鎜GΨ'BHjK!p쏿	mjM=\rn-q8PKb5ZFXWC8>I.D\$J[djflc|eVVZ:o.iԃ؟\r2TDGΣq2qd%h-eڃW@Zv0\r#P;_D_\01F?,>B4_`1+&֭\r.>qJ\0% #695r\"\r2+\"AI ;\"LG\$.\n6t	Bt	(Vaj#8%H!ml\"nʎR1#p)#2-&߆G8)ɮ@C,2)ąnTP(73)q)/9+P//1*+31&TKU)QS3\$R.!-0ڪ2I/r*Rpm30~.BJo4O3T5g%\$:JI22/7X,-+ FnS]2Q-7m\rލGR\$ r*N/!<>rA0=Á f \"Ο\0P	k`2as,\\*q	'@`\\,.AB1#4=\r]Ϊ#sQB\$b|m7dv<zJ`\$F'˥\".z Z*;ND(dNԯІ!Hv\"P`ck\0b9ORQ#9n\r(\"V'D\"	kn!ûivb]cNhl_*Г0Pb64* =>PɬD!U8u'\nqooL3C94\rd.HUj_3hj+:}M<IXBz_iDn0lHBj`\r^ujv\"P-\0[Į#ObI&OmSd4\$xMATF]U&\rnb/0V\r:8yȟ辇`.\0	\0t	@\n`";break;case"fa":$f="%)l)\n@T6PD&چ,\"0@@c\$}\rl,\nB\\\n	Nd(z	m*[\nl=NCMK(~B%	2ID6MB\0Sm`ێ,k6Ѷmkvᶹ![vM@2ka>\nl+2H#0\n]SPU!uxd)cZ\"%zB1C2o\r*u\\o1g{-PsW㤵>--#JK<֋TsFT/\nS0&>l`Q\r{US!\\8(7\rcp;\09Cx䗈0C2 2a: 8AP	c2)d\"rԢŒ>_%,r6N\"|%mT\$͊S%楨J>BM[&%ES<HPW;'ﲲZ%nS,+>'.r%!R@ȩbҥҡ',2Ϣ8N\$#F0ҒЪ@XO,P2\r\\\n7@0c09c=o\nЄ%\nH4\r80`@Y@2D49Ax^;܁pVU\\3(ր2d\rT(P\r#x})ǒCHIAhHS,sH3\$̻8~Ƒ	#\0Q%<^\n7W(J2<nTSB?9+2KʨLZ)3TD%D2嶘HQ,O/,kJ,/EM\r/,.j\n+bMyjV.2E˭<8ڟy2oA*(p(*Ll3#u-'NXdK--'⭦0Н߇S1sa%3wY̐P!x7ǸZ &A\0:p{.dy`p3\0F# ЀlB ``2軕H\$B@PrDC \$4T`0q&4WQ&8@r(J5&yHEel&TTB{cɵ:g5* 2X yjDl8AVhW{ab1׺4;)!ѐc(\n\n02C ~*Z:p4E^[in- w\\ˢP.p/B|:0`37Ib~KeУ%QQ&^2\"!3Vp|Z!IDHTXGRU-V\\ksZ]S/׻Y%5#;{LbtVB0x%HOaFELVόQdK	.A\n+z\r\$(<\r	s]`O`oQbp@Ф`1yLa\r'fdcjG\"*N+tQ\n (L>J@Fd\nd9QIYX S/!P9z{*oY44\"D(f޲MJ6଍eDK_hef4F8,2!40bܧR0-\naH#YֻQ<.βW;Y%!PPR\"u(IEԲ]F)&6828U5\r3!I adYKi\rcUCC;-}X@:s#\$6\rb=G%0ldR`=wfnE:t.Ck_ɢFhr\"M&HуA>)\$JfB\$li|NRަCKwѥBO^hE6!)[*I,qQ\0PO	*\0BE:L\"Ptֆ|Q,VgWLUMɅ2\\E\"Ձ➥ɌdRSL7iţ{|5`DNi뫅%\rPSqG\$-#?GWWG/n;d1oTT l㘁QL< :*tyG;H>3iDf=::]dG~ռvQH3oMgok\0_BvLִyaXRvq:yI*Mk \rk)s/KFEQݒx!?j*`&We=F-񺨈y`'yR]Pכ7W/|婕٦Aa bP·ZaZ\"ej8܇')cg\0ESLCYy\rͲ>vbu4Dק^(&Tk=~opԑB6#CLsP#\$#M\0T>%ORO?DMLlJ!<hϰ(0O .f:phS`xN'/{.Iem90eP`2IL~2Rԏ<P1fHc87w0ꭎ݋*s.#\$EI|pǐkbBkA H~0Ṟ4PQ#i xxFLwk\"颢q*teT\rAE\r\0H^dЀvcp0typc7m%8.erSîpwG6k^x.xp!{,bP2oxk\"fQbbOk\"-e5Mr\$q.|Nog.B*2jsG'FP#jBLмlF_\"A#.E\rloLԤlP#p3pM#I++*L\"\rS3,o,}1*,jќI?fOc#n&K&p☥?Q* K9203-I*RLlPG	ݱ30IDHyO`:n2<\00012_7Q5c)**e8q7SO3h?,Q8o7s7W+\0\riRBK\0JE32J==no\n ة\n;Q9ѠG\0Sj򑤏S6j\"4CHM.\\xT8QfХ4k\$rp̈́L'لEAt:gJ{&zޭN1]@aT6&,zR2+(³G򊰢ԃcQT!5Dr8Ou+\rVŋ;ࣰJ3&r \nZ	,#1PG:\$\\Gf\$\r&\$R6@PlDV\rA8{TSA·MP4?\"LC,Sl*!AT\$գBYO\"7V'7\"ChQ	cGȉ`(2yZNO׳/\$9[5)ZkQJe\\uC;]Rd\"CzU5\$:rO<MXmVF\r/c`.u~,G#YmS0J8tUd,tш1'4|u 0(wF /Qb<*ؖdW#mN\r@@X^[4.LT-c6";break;case"fi":$f="%(i2\r3 2Dcy6bHyl;MlegSnGgC@tB\\ 72	aR,#!j6 |=NFt<\rL5 *>k:+dnbQéj0IYa\r';eHmjIIN_}\"F=\0k2f۩4Ʃ&ånap0i݈*mMqza͸C^m6>㞄;n7F,px(Ea\\\"F\n%:iPn:lنhA7*bn%#\rCz8\nZ#Sl:c٨&0p*R'(BJm@0@L7E^ԥ+G	#zJ:%#`#N	K`!\nBKJI ҕ#\$;<`2PI<c\\53D C93I\rM'&Hز&,	!`@~M\0G4C(CBh8a^\\Q˘\\7C8^J; ^(aض\r`x!R+#;#l@'λ@݌S!r52^ر\r&\\[O:x:8fMU*2II++-æ`\nH	p7hiX =j3LY=ݬ3?B#P\nN9+Mb*q?`Ұvidd5XT(j{!s#cm%2Nl=ݼ6İ;?s1{>Sܠ\"	* [ÁNfqV#\rZ`c<vSYZ3\r#:Z2#\nRu=[!r׳w5[d<,<˻E;\03L(Z@3B/[4=\nZ7h:E7(EMNB%šELOM@D7`ĔsyBCdI!\0\$\r S_,<5\0{ <\"&vX<Pl!4PcfCa\$AH`u\r(!{z(ŊKb\"Ԃhº_,rX%e^B6kP\rq-DTj\$x\$\$œOn?H/_6ػ\$H|C-TIDD\"mq\"hպWj_lyk)fP|Cr(+MjDhHx`%DSjŵV\0v^hjJIb#L![!CRsaFk3	T2<Ɇ@]!Q`eO( &/Oa&qb9)/@\n=fxqHţH\nM!z+IAC*FW\r2% (,\\&T'B LЦ%DLɩ[iU\":E'\$*e3g2!mM@rZE;j#\rճNc&) ZyEH\0[죌?IHnAݒIw\$ůdk3|aƄHvW-!ρ,½G,ぇH/e)Z\rhGM=bP4%H(jJPͱ\\=`l}!<x3S(x #(8Ԗ+R`cﬤ`00T2.A,Ix\"HH[.l.l8@BD!P\"P@(LfA9sqjEdf@e-\\rm \"va\ry8 Q<Tܚ`ۊhk37ZΪ%SmptL̠tM+ǆ+%[49CrʴÈq#4phy34H5C\r3\n.4\"];\$YSJtdf+{\0)6a7&4\\ Ȭ6P\n_\$<dMkrCǒI!]^hg|+S\ro4\$|!S\n\n\n\0<*8K\$K%\\ܑtt\0DndcXT!\$6mŠɪu\0H=)|ϴmq1HLib=B憝=W ~z%%֢\\T`v:c1}=A|{\0ے\$:Oh&oki2Ә|opn,}/|F8Q1v/&bŅ+v16ZChێDؓRxDU&O~Ny+-l&t?g>t}\rV>qDr{ɸ-4xqӊa3CâfNu\\J3=U2pM/ҩoބ6Xo*\0b\"A,v!\\XB(L֟#,, g\$J+&tM`Xz( @8j\0ͼNc c`\r`ۧt/ڙ Jjk@GtNgOKy7Ltk,kHPo 0Pt͐&soM~\"\rDH\nTκbN@0\"BU1nn4ތ:Fr6qx\nD:Bq0HݠZFBzݤ\n]H2k/)2@ȼJ-:Ǭn &N@Nr\rʛ\$7Tׯ8T=f3gQG#bbbϮ1Ox5Pq\0\rqd'\nr6L002\r0\$0G\0005#nY#. m ^.Bj NBT.>>.Ay'G#Pmfl9R!+g2')I*%))lx#%!c`jB&\rr\rrR2-d4r#-Mw.\"*.c4\"Q+%/Ϧ0*ьcmXLpW\"%3#2`2ph3mS(F3,rSiP2NN\06'.bo	#s#7\$.8b\$k!RFI^5S:\"21\$J{1Omx!2o%ܯb~bLme)؊2U)4#b;A(&hG)13N\$od2fAd\rV6xKCo#Jdq\np'GRD\n%1\rS\0#dR(&&f^T|#0<#]I\$&	J4H0L/cX4D|+9cE8%KO.\$LԅVmD/DH['\"-Clp(4LCLOOpQ\"77PH\nb'\nQFR^ϼ\$fƤҔ\r2 B8k iL%\n\\`-\nN1̠\"\$\"hӊ@#neTMfNOCwVT!Mc\0i#&-djsdЭ4\nM\"";break;case"fr":$f="%(m8g3IeAt2c4c\"Q0 :M&xcC);fSF %9ȄzA\"Oqo:0,X\nFC1l7AL4T`-;T&8̦(2DQ4E&zdA:Φ脦\$&̆fn9',vnG3RtBpv262S'I\$6N\r@ 5T#VMKxrrB@c7iXȃ%:{=_SL\n|Tns\r<36΄3P\"Ln7;N15h#s\$88!(V֣p7FP2Z\$\r;C(2 (\n)`Ep6L\n\"(ê(c@a\"\n!/L\nL0PI쒜B8CVʲ).qT7326l9ϴKdXPT2C0\n˴J\r@-Z20hʿj \"ҵ\$A`B9}42OH\"N420z\r\r9Ax^;܁pXn,3(C,2`\"cp̋%@|/pŔTa;^ılj51Hؓx'*#(#c\$Pv6h @7h 6C5|<K~hKbL9A6}B8\"e-Dh?Q!:3;4Ϭ)M*)y\\ΣlH!vnj&\"^&;02D|/)vlUƨN8~eT)\"bN>vI#p-dS8A2h' E]]a׌\nR>\"8ֹM^!V6ۚ\0ھ^Q#0\n	!0bI\0>iK!6)dC6~7,\0n}wPϙfFx%w\rX	L0BTBGDvT&0<oqP5	lU#\0`J'u\\U5FEC\$^H0-)ꗃpk&\nnQhF [m-żI5ֻWzoKTxO\$N)\$2Z!Eb\rdv:EZ3EiNX:fMպ\\ksLb]%C2k+._rh]<f2حVgaFBhDV1!	JS<<DjXxukA2Ml4JMk7&r!ɜTj28\\H\n\n\\u\n\nr4(Ň2i\$*jɵ|D6i9JWmpZ&Ѷ(1HYxyk`SX[\"C%-HՌuJkX\r4ՃoD͝}պUBo\rk02*HD^IdVe*TE:(y\$Nq2KHYhh(uTae64++i)JQC|63x9-Be꫊Ihii6\n<)BQwY?*\\5NZ}Kz*\rn\\KIۛ'=XӲG`HBhͱF7wf\n&@A\0F\nBb˃W't]H\"KT2uDRShgPic4A<'\0 A\n%ЈB`El'n\\qR*\r%s'qDu6՞ԼS\0T+nk^mY>BN?)GM&EաǶl4&d*FaSRͶ7'R!D5SD\"E\$4\njEʟv\$SC1`ʣS;(JJm;d=`(ANuԸLlmlS66\n)OPI>_7?al;fY7\r`&Ii:̋T-Y,Rxm1<\0LĹTXيg@ -]Giʉ}O95f(^y\$=oJ7z.7#(B	<9ZYDf\nj:7.SGQVda#;:jq]Z:(CAa!M8#gEI}t\r\0P(g0yĚ-JJ1s)1Wjy|D;\r(n2w<D=#B7m@swҎdGYd`6/=ɂđn/_}GWzg}IOc7>r*E#''s>.(  \0 QI6:P \0Jq`A/n)#0t#\$:#X:aPKB\n	b/FU?,:\"FOࣦbfiخm</qJR\"kBO	0ڰ\$`=)gX*\"Mb9\np	Oc\nVe[q\$UO!m.ߐb&pց0\"N5TQFGЪRB`\r/E:F_@2fdIP;#TP-2{9\rмQjYqtijQ|xJQpX0&pp*zGz	QxP~OpRJyQ%ѻog\nD\\ Ekϰtb6\rbOQ/v4DϏ\"jBCP笄_I8ёP猂%\"A\"G#I!Ci6:Ő'e0^̊RCr%!e~'4ސQ43L-l&0`d(ŗ'P(IK-\$N}%Nl_+#	FE%\$ѡ/#0mQNb\r^d\$	P0Q	2S)2ͳS3&a2]1p.3HS3Y2J>%V]\$Krj# B4lOR\n\r319p439%gPETueA\"bo\r'8Ks_1tM[1pZ#;4NEH8P=0rA9)??S&@?p\"0;f,2S=	AX33Q)@p53Δ0j\"z4J	4D	E`EmE(&Mi7nGF^|a<;+Xꎘ5CDABΖΝJ2]4)I԰l&DnKΚOj/LԠN`[ZS\$OD\nQ0Ar9\rNO4044TOD\n?q2UjoҲo.C1\n3Gd9<u4gSES:ǃ1Ɗ%-5<.f4U@hDRs\nb\rV#U*\$\$6p\$L\$q֑p\$؄1(JvK^(\nZdT/uK9& *PBf<G<dtoN땦:OegT\$C07ȼBlcoF|4re57v76fj'q2~M63>8~UӳvHmfIfмq\nbg}gN\$k%\r\r5i|a\\VJ֎: o-h¨xPO0?lŎՖsD1BGâA\n=-i!\n\n(lr\$E(b\rdP#(1g#:\rd\$k_b7/*'pB,BD洣G>g; ";break;case"gl":$f="%(o7js4Q9'!@f4SI.iXjZ<dH\$RI44r6N\$z 2U:c@59\0(`1ƃQp9k38!uF#N\n73Sue7[ƃfb7eS%\n6\n\$s-]BNFS z;bsX|670·[VpL>&PG1\n9llhE]PӒq^k0&uQT*uC&&9JӐ: @9c2%#&:¸M22CIYJP#\n*4*\r?hҬ\r!)!:C*p(V҇4@7(j6#ç#B`%*~ԨJ0\\6<Z(Co9+dǊ	[@i@1@#\"@M:64L0ȠG8As\n43c0z\r8a^] i\\{\0UlJX|6.3/)jx%ʉcүn ڏz8J#d=hƧMRW\rB=<,\"q?B7.0((J28+T6jJv='#7O\rU'j\nˬ&)(G<ws!x\r\\\$#;631lzqjRzp9.~R2BdbxDN\\8\"y`lNOC☢&U\"7j\r78!OYu \$܎#4l۪9صto-Rn(5\rT_(6ǈ#.޽ u/c'b\r	YZLf9!/\rB9<ͻoP	aL*[T	먒)~\\>\"DOXgqnF(jҐ0h4p鈃Q4uғQ{JVQnE\n0))6fHD	>@A`\$zM I\"\r`S'Q#z!\$-vHa[q*\"C@dW*^:d,)}[qS%	\0002/(KlH\rd*JC7dQS/ӝûU0:b\nWJ_,#Y-o~>R:Z~m-t(S>(\ri;tD1B5n b5F9H	\\S)3fSFP0bqגaμUlj8ap6?\nxD4aOe`\r\0PRI`E!^DH{!\n VG\"a%7ԸoSx7tɀ\\QdĜJ/@\"FNv&a.Oα)D赃U5Њ`i劑@6D50F}(PB(nB=H#ӈ'IoM#ipM	jPlBDrC!b8YcDˆFj	7DLzإW%Y|Hu̾q`BO\naQ\"qky\$nGŔDZ8fvq)/F_P\nBM}(BJ<#&9ki	-%zP(veZGrM=@_7x>y(ɽ@)i 0BL	!h *,p \n@\"pA%A' q>)&\\_<oY<_A\0P#d(fuIa<8]^Z;G*z.{^ELǹC<:f,uə&;\n*Xbjy\rɹTй@#sjM)\ryXjQ\$L9<(T@qIDzH[\$c6pX=|%\r`7a(T\$1*nhJ+֑SsjH4Y:<G<MKK+?ט6	?H2)`9䅎\0GSlHTVNr2FYwE֎(Mge8QM(zZaͮeu\0)trV*N@B@ t\0#4ܴabٞ#@)@XnPl>v\"]aVk~(Pth<\$-P!?\r:%_@|y%kA<z{Im\n4UFzKO~;&AeF%J9S*g?FrSpFI`G)bD2v]!-T9ihvb\n:#/LcM18L⨈n\\ihPh9xa(*%\"\$#d,Rp`^\"\$0>B7I7g4FPr\0`ZMrL\r\$͂ \$DZЊ\\0bo% 3~'\"Z#SɬJic \rF\\9\00XI\"FOM\rwbѧ[\ru#8}(3e!LM<0N-n5OΏ1JZT/	ʤ0\r2\"/9<тlY.JBqi\r@dO(vkJ!,G3%pV	\$9d4!AZH@\"Gk\0\0@V\rw&{*c\r)dpRq*\rwZȥu#C#.3r8_MPB72\\1&r`&pV7@\"<Q.opP=\$04ЪNM*a&I*R'-z 	:7,Rk8i.NrI,Ptg,32mHY&0=-#Ru2'0\$RA!>\0p3d<P@G(F!!Y5F.VpFe|+Sk*'nA*'TҲbMC9R<:g6SQ<;d>d/U:~er=ΦH%>	\$`nҨMĒB(cR>\r6'4.@ZbA2c14d#DRC0\$+N+wDd\rVjj\$C6go>ICLPbzJCpQm\n@ZG\"/]I(\"(Ap`!BK\n@\"ڇfpSJ6# teD޺ʘ+l)4t.by),\"o G{\rO:KxH\0C>&)fa'o)!P40@DACSS͑#R;Lt% (bUG,USw\$B\njmqKiV̽\r̢O̠mEnBnޣO\$ʕ`6xobL.)'[bM&\$^ʐN]~dBjl3Jw\n9\n#!B\r";break;case"he":$f="%)kƺAAvUkb*m(]'mu]2וC!ɘ2\nAB)̅E\"ш6\\׎%b1I|:\nh5\r;*bJu<UBk0i]?F'1eTk&G~_&0EAd4U¤MBi~ŕ\"U hn2\\+][vGbҥE(ŷMƳqnNG#y\\\n\"Ne\rStN/c2<\$\rC6\"iJ\$\"k'*V*Z9гw3rk(@s5K%L-LRk{0ͬ<Z\$\$3iH/4v-ry0b>%zZHiR[!1S3i|ľ# 4\01o<=s;#7?\0yK3:xW<<As3(42z\r+<(\r#x}z6\"ݡRT#Ap+\$4ɲ#J9\rB\nr!MrO!B&hBHJ9f9/s4(%z	|dkw!S#\$),\$ˋ5E\nH0P,ȢZL]JJdlN]6ͧ7R,H(L7mJ{\"#\rs[c78R!\$2Kf\"z^2_8q9CjI[t\rI@6Ou:{ChZO?@93\r#?H22O\"\r#6><gp+,:\rk\$f#ۿT飏,|*\"9Z8\$e:Q%(d\"'.		0hBp!\$4Ȋ	GI\$dradTjSVUxwV*`/>O\$:,v!,F0NX%F\$2M3@PZ3mNSʁQ*ELRUC̭ʻyD7=8~i1)7rDI}\$ԉ3rXMKkkcQ:d).VlGQ%@|=YHd WaF00f6T\nH<)^LqvTk3`E|(A=2%`ryp7(r\r!4@,>-)@̛_\$<x9RWxx&%\nUL  h\r!49jA!0ʁ_(@8_N,t\$E4CN8 x fZ48 2(@tLqbAT7zb-N='nIy\"hNLC\\%ҎIam-	?\\\$\n<)JDf12\"`|DJfi2`38d\"}	\"a8:\$8KHCnoq|%t95HfHQ!MJ395ceI+6	P7TZ0NB&3N jHRa1#Br!o)۲A]˛xL\"240DQ!7UԔm35n\"`QJrXA3|g2}QỀd3nf꛳~Ғ_,CE̆	\rvfO]d(\\b9.!]&e>l:2C+Raќ6)/9t\nlH +IlBHn:Pyl#)\"\"Eˮ%oњPmL\$%p)|5O0AB=G]=oSvNI6(ÔX,N'L4Ю9\"Lrc.k56`6vSW3@ @BHa}STG[8˔y`@/P#[gbk#Y8\"DdS&Z,b|+\\8*DNpٸӛ^]4\$0TKQKBhWԠQ;ᖭ`uJ7 C52w+uҡEnҍXJ>%i*ܑ1*Bĭ!f]oĽy}d#bRlWđ4C8do}gHdu=Z껝BXk#Ɍ4f<!HH%Md΢MmhrѨo\"جtm0A\rѠ]Z\rw#^/;9pdR0`;Ρ&D_♯:p8Wav꾡%|y&\nnk_z2s;w;c#S}-/̉\n+T.3K\0ȜLҐ3\"Pb\r\0C6.64I!LTG(r^g\"nʄKh΂NJl8K\"\$nJpD<)I F@Ȧ%DmXHiFHp٨f͚8ͭ(K2\"B-̘\"\0o\\q#~ β.@ې\$/\"C؆c8ґ:'g嫪]noeFKQH\$\"ào\$.҄eq\0NqCL+\rfQ[C^1F,\r#Ӡօ#ܥ%t>/&d	mMS)=c\rGdMaO!()\"b_\"dP)q#RdPI2-%\$1n4:om/6\ncجBB/Zi`#xs.\"G!:)^^/\0n:`V8А|7*4x8Rld\"Rq*ڡ0Rq\$r-8x`7ViC1_&q&ē\r@*\$-4)3^Ɣ1/oDDHĢ<\$EJbM\$<0tc/0n7#O\"77T4r͈TsHX69\r'\nF\\0@̋7\rkPdل=Ll虜7l/Npf '<g֧.Vq,Bs%9\r8\r<@πg;9\$~!.>!";break;case"hi":$f="%pRX*\n\nAUpUYAX*\n\"baTBtA4!RO_IQ@q*`j:\n	Nd(O)!\"5)RW	|`Rő*?RTDyKR!\nDJCu\"))Q:PTi5@ݫ-ueQI[W8mR[#knHU)a%&;RdE\"qqo3/%+x/!>覭ToϦ#̣#o[S䧎Bh(49<|6BAQ\"\n튜:bAík\n;hNG+#zjx9(/,	\"zRCL<\nJϻQ7)T6@\nZLF)HE̢sB	[ȊΌ/25*e):h+IS2ĨM6*.ϲ1R5豢RBւsO(J\nrPɣ!)%Kd{RE͚;(JJd)EKRG=%ya\"ىMʓ^5szV&ݩONazEDOQj|@#XdH-9 4d7\r:댹ۏUӬ:w}~75F@ЍAi.z(\r3:x﵅6#p9x3(9J}q+@^0O8ԓ.\0Im>W9_d×-=/Հȓ6}{7c1\\:y͢n'js\0OA_VD2YF'dE)Q`*ixz|9iIͳ<DRoTf	8[d^QRv҇u5O\nv	:aj9h/}l?sr`OIm V+Nwh94\0()!9\"ćP)FoE1>*؂;ˋgf =HL͎p)q39tک*h\"KG0\n9&v\n)vj\rƦ]#sO1a7\n\r1HiIYM=G֜4<\$hH(|#{;I5X掺Q4IT\0가\0R?6Ed9PVS\0%LQL1e+92%ѐDqM?7S-H8r=t>aH	 Cʘ`3*OӆgjgŸ>SO\0d>a;Xyᚥ'(j\"'9ꐔ=<\$\0)]ob5۱)(\"HKD'F_G^JW wϞ#Q]VZky6&ٛCjm7&ݛz7MepVsh0sD)Ԯg:(bM/<ma)vg+R?FVg\rS]gb,sϬd![2GIRk}6Kk[yoa<FK{pg}JaW:MP3\\r!\\{,ztYA͕S ﻷ1CQSc!g|#[+8U4=<FS2՝gj-w\0DXjWT\n\n)#Jte BNWg@K8+MI(r9R\$S\rzz\"Sڕra.3ڪ&r_M!'8ē\rX(Ԓ	01adP뗒T,<&(-h<6Kʔ:Sɤ\$LMדN:Aw(,5MX@SW҇iw1gj#NyIr4Q3Phy̴[\nz\r*<)D	.dꉤi=z7ωquj276-:aU8R	^kxFB0T5GVQp%Ƭ/#%\rmwvδ#6rX[Ľ^9oD2=19{hh{3i)|Ik%=s<xGg/]!c G_1Q}oi@WⴓOky\$E5*^ww_,w27LtLy3 !cO]]AsZSb~7[қ}[.:SMNUTI\\7UIrQ\"h8{/quK\"MTI!}l^%_Pd *Ml).XbhRNwMJPV-n`	'F/nj.8HTx-\"H>\$\\;VzjtFWpx~G8xd}	ܙw<p+VZ'_L҇*LEtBxE? 0\ra-jae^ojW.\\\",DMH5&,xNy|\\/Ǎ,@y>\"؅dyBOFMﶦQ*6L\n0bSf<DKO:&(j50<J\$)j/!(^hͱnK9z9~_x9\nVxI\rZvJKb=-:T<@U`F YbhkdM̅\$fN^U!QwCyQf1V%RpW\r8.Dv,C,nv?jP烑#.Zh..][&+RtyD%qC6b++OTtD4Dg\0)\09?.nsJ-tTMV32(Rzd	0kՌzxJa\\D)0Xd]&ę012Gd*s<>o\$9I0#3}5H:_3s\rS>.:1ΞﾙS\0H#Zul:#QPD\$ÇF`8OmDsY\$3O-2.y<0NTF_E8^lE3~h_?'-;C7jҭ\ncO99k4fm4HG,+\\obRBBS84,hB\rmB3aBEAt.94<tA703E *T:I6GOGٔvHB;G\rhu\r	86%E%LDa:\"`2e\rzԳ7\n]1=LQXpvNt3T}'N}OT_IuJh 7΁GTUJ/m1FЎ?sC+1'I⳪ܽF	ư_WM.T#8CpXZ9SEKbGH1zCMUI_Xt\rR/]V\$Sb1wz0(Jaa5QMzuU/5CSH䵌yRt_5Xu_L^I6*Wg{Z3WCa Jv%_ûRc5bgn6AUoI`s`VJ3c4D>/oLO1a6N~zT<)^e`L֔96!bU5LM2&hSӹc2vӻ*̳ŨvE/0U^Ll7FvnpSdUi5jwQlh#rG9o7mMqUOGmF7h֣Ls>tn]qsӥ`.<WfKIFqp/wijrwx.Z>!G71Y6P4Wizwz{MyoזP{w`w7s^caElCt5|thfaIpqhvee7ie脏,Jahs>F2\$9e{3`9[P{Q!gXY%UjcFS>#'e.am&)NNxB#?=1%4K92Ig6R|@ xqKZ*C\nZL1/Zt\"wRwxqU)x3)ܡ.ȅS*gBlT(&8\\͡K(T/S3!j-Rq9WXeՋJPŪhi7XGoxd9D-\r\$a@B%s Ӧ|c?9:M	aG0Lx<+(y96oDmp?\rs^wßYݟ0͠[Oso:`.y/H>{ӾD	{uy8/7CT9\"00-9TH#H'pdXUs:g&U=Htg3H9Y&(Vn6>]147chFfٓQqY0XTDPÙ\$iGpD:P?\\j^A&D`z*\nط&3g#fvyJ2f\"\0";break;case"hu":$f="%k\rBs7SN2DC3MF6e7DjD!iMNlNFSK5!Je@n\r5Iz4B\0Pb2ar\n!OGC| L5\nLL<n1c*))`k56Lԁ:'Td2ɼ 4NZ9@p9NƓfKNC\r:&hD7, *msw&kLxtl<7cVAgb=U\n*GNTT<;16B5x73Ð7IP޸oX6*z9C;\"TʑR&XҧLlR*\nh\" Ȣ\$\r##9EV/BحCacz*.6.51*e,\$HZ8x-\nձ2RYBR4{{93\"=A\0 mk\rI1l(\$t 1BA\0\r5L\02\0x\r	C@:t㽜4ґ8^!xDl.46H7x%BR#b/5c')zh˯n/&	aaCR'@Py#pη#ΓNC.OD\rC'װsk28>]6V- 3#6ר2B[dì12֕:v3>9V\0V@zl %pbP5+ktr80&W0LEL󛃇\njeЂK1GH_#-juD:=(6-3#ű#mHkx<zxZGJjw ܕ7@g\$ڞvPG0CvWC]a4pN>EMh0\"kl}<ܪXs%A0Fi4H%MYF(r4@!P3N)AAzC#NK?9\0T[` E/RɪPU@W8BXd,ZD0-Uy	u} K'dJA=6*Uze\rRjT1t?\\-tȠp\r\$+*Y+-fc~[rB	\0HH̉!&Hd:96H	e@hEETr+\$ðS\\Z#HL|#r+0؎dQȲ \$>U+n ȉU7@a\r+yFMhE̔I#E1:^K,\0(0gTVȉ*AO5XY\r{6ّ=2jpU^ܹ\"C&IFz>\nhjIU01bW(Y\0\$XǜVjiNJTRČ=.ZŘ.,ȏ#Ɵ0+%3 S+2tSk\0p886:(\$0iI5]NËSd3 %c 1jqoţhP	L*UszA\0C`پ?<zYEssRݹ0tP76IjP`#J`0zs<eB.s)	g5g8\\Rhݹp&4ct1[/f!8pj:b1pPze6&щ3%Je>(&4L]TJe}שᨒhPNzsCȵ&N̹=PF:Gڲ,(Y1 g\r-?W(i0p5zy%LQ+:D0bj	E\$~egrX1e@޴K\r\"D) j՗evkwRQ2f`܇ |^	!\"qn.amn-\rq)v1vɭ6H\"&-Gpc\re!zk+xeGضR ,|'pgBȺ4#ztU&ah LR0\n\nLpN\ryxMq252c @BHo-ڡC(nV\$o@Nʣ'!ɓ2.U\nʝdubnI;ZPRrp	ʡĪ'rApIfkbݿ6S;y(No%TxǵAYi#ι+ػ6+EOP\",xF&䔍bܲrCyKX\$k)&ag\0WU8Q\n1?kMKu0L7a`	p>,\\9)\"al\\iŶ0C0@049*b\\#5dm4¬Na8G1#*H#MyBX/fi30X{zlc#\"QN#C\"`Bz0Ƣ~-N@Tlm\"j)@F|j	%*.֛D}\"dcGMAhHH`ڃB `Jv^V,x\rK8\$q(̌8,y;\0wQ\"Tv'wdv'qF1`vgXCRf\r.?.fhDtQ|(/\01nc%\"161-6:QZ8 آsL5ܢClM9iFd(,\n@21o)JB\0WIRG2 k\r86u\"z<Oj \r&T t)ܝI%Q=d/Le Lh.:wY&u2]r(#}ҡg|R11q)+rQi*K2#,rˣ-'x )'/j#G222o3*4_Q+1QrFA2kr.;6-G-\r=sM.\nNKCR\$P)`A<ҙC7Se4Gs!FAs-DvR5ü>&k7iZU:9;Ɖ.x.KL\0\nbDQ3?~>u>CQ>\rH.'.*SS)%92|\ns\0t+;sPD.R³LO~{On|JiAO-DF?5/1Q<*>b5PmFN\\ðЩ\$BІ!Ԓ3IHԠd@#dd.J-(dPMdU\rVUj\"\r ̉\$^%@)j謀@\nZ*cU(zD6?S%SbeSSKS\"\$\",\"G}BsD\$nHP5JF.FOCD?W<C\$P;J0D6S\0 ˢwFD\\JN	=:x@~:PX&g.4N0\"Ԥ/<g3Ii_-__&\"uD5CY?Ɔ\r_c(lr-E^5 V2	&@]8q0xEBKEa/3Tẏb,C	30zG5F^kim<V*+V6G m@O\06\"8\rz8\"XI#8m0T`t\r";break;case"id":$f="%(i2MbItL9(g0#)a9D#)rc1M'I>na&ȀJs!H\0Na2)b2ar\n 2T~\n5f*@l4цa\$E8S4'	ldu'c(oFe3htƝ\ry/s4aUU/l'Q!7nS>S/W95&n/x\n\$NX)\n3 Щx(6ǝӑ\"\"CiߚyӇ!9c\$9:A*7;#I0X\r|iR(ڑ+#:>%:068!\0AmhɬjBS;87QZ%\"m N}kZ(H)\"8m	\05Rڗj6>1`3XƎKDâs?`@-@2D49Ax^;ru4\r\\z&o2~\r34ƣ^0\r(	Er%\n5+Ldtt+sx\"7?9X6Gzį%	)w\$H@'B%0b ;@%׃@#\":Z1q,MXJ(Q\n:}i#.#ㄖ4)\"`1Knb׵4J\rr+!mni%~(2l/=BKTZs%jh6_C'苨Q]c\rO\05po|!0Ҋ|0}		&/+/<'1; ,3]V%0BNƍ0̴SP7r\"Ϝ:AtCEcrrܵaJKID*1IYXx3<9PRMTCEѴ}\"ԪS*mU@7*}rE̒cʆ|H%^i\"Kƀ*SvQgCRYLu4T\nWNK\"Um8u䜢9\rq/0\\#CЖiOhH1XHf|Ɔ1DpȑDau'CYoy>\" a\"@1¸P::bRdHE{\0\n0JA,\0POL/@8ܧc;Hc0Wk&C8yFIDc#/B84J73H\"Dƌ1ԁ)41{Q') (L%&^!7\\êya+P@ c1S?JD̚y\n\r!v@ɇ&+7'\",C<MS,5О,!d@xS\n9JI1睌dNRL\$r9,!9E6utr@	W*[0T	EʶpD&G\$)Ȱc^ԲxxNT(@(\n \"Pl@\n	Wd\$2D\rRe*H%]\r9vH02X:gUzʏ/I(V+5Q\"R1V]0OQ#jAky<lc\\*!R\$OӔ\02%?Kh/\r\nf`_%n=0wjG2Xw`o'RȾXACL9İ͸IZ/2;l^1:䑗Azӓ\\dAKm869\r蜧cz ca\rERLMmZ\\tOQS[L<2âZ!()bja=)^,4~E\n!AHvf87\$[\naK<o\r&`L'e30Zfgr0f	~)%1z]R1e&·i}#>!YjX)PAN\"'(HӤ:&K鮜Oa\$RK6ID	M2 \"CPյDOEQk\nA.Ph/k>ZZ߾\"cpΡ\"Z_\\cRi\\,4+Ò/zҗ;~B~,|r\0y\"\$^	ЈyC+p&@p;YuJ,X8,,yhH1\"me`*S%(HGrrwr[dc(r^]<ܼ4R߂7y.Pqs>3+>Eqٕͥj'ˋQHIΩo5|ȕyNa}ܷtIlzN\"\")^]21λN\0d\$Z>薣kE~_)u޼H\$ϮƂ2zČ6o~MOS imnl,\"XN',PB4i06s\\	\$hb:Fvjkg,&\$P'Дs\04y\"(a2BĖCaĦki8INGĀH-k\n\rw\rEoLƞf0D%TШ0_e\0C(9~?'&p&q5\$|\"S\$41B%	,n\"gl,8@q\npEmEEI@hBH1	oMU	9\r/HM\rJ&`zJݎ\n/8	JE`j]b,`4'zD\$@r\npṡ (\$MD0q=7\$MDoz4	͆j^>n\n,@*2L-`.x#p\"N[x^jEEU'C:\"xx@4dg:2R寘,\"g\0n^R揘\$pnMG,\r(\rH揪<Mz	*5N6Tc0R&sHi+E./9L+-cb\\CúWr΢(s2dI Ŧ\0F@DdD1HBR1";break;case"it":$f="%(a9Lfit7S`i6DyA	:fL0č0qL'9t%F#L5@Js!I1Xf7e3M&FC1l7AE8QoS|@o&dN&(fLM7\r1xX(-2dF}(uG&s4M\"vZgZ-(J.WCa[;fʒ 1Ņƭg<	 gJerKDSd׳&ZQT\"H&9:oS!W3G#sѩ8Lg{AL%,BRP%&J\"tjh@e:H\"=@7c4PBʦB87f*\r#&rI`Nb(?\rã2#^7D`޵#Ll2\r[: #1Ȍ*\"=%/i(`@%#CH3:xK7Ar3 _A?o^'laL3-	x\$³޺\0=%tíM|:+͚/K0Y.5Kى 숢,7/ġ(CʚWeܥ x؎Th^jXK(\\1+-B4֒\\Y\"30@1J!+ޱ4J'N\$Hr'5;3lX&1<IcME ^Z9%-]~#pȈb,ﶶl={YĒ0Yl,I̻2	#k9.NˢMkf\"J#8(٧\0ڐ8T`i,05nQHIWt0.hH35=#\\LJLȀS9HL	ޓ7l\\3YTȗ%A2P{K-=xͣs\"g(}-~ŗZ	cɾbl!k'˭|wL3\"MH0<`dCpkt9\\8 *m0%yq (&TzRjUKu3\nJ[\rT#P	3&T0aKF셇'^yd@fHn\$g1SC\$W:pRaM>؂t<\$:n!4!)\".0&͘АJq'#G)n8֝W(IAc\$!(Pe;nr߁F괸30eM&i0α^bDw80È)4@D	A\0P	A86{('क7t˱'3r4OmdNGtL׷^,AntfoPUf)EU5'Y!5P7S\nAL@*-f`كIoɐ	o0_KH(ș:vOqqxPVhȍB	Cd|:*OS%CѬ:y8BxS\n曕\r3=I8^ՀЬf\0PPF%rC;DiDh+\$h#ILG{+*&u~4)o'@BD!P\"z E	a3[>V4VsY(f052e1XL9[椵PZ0qSZs>\$ՃX_mw魷!4S!27tHww'b-nHnlhй3f_MC>uOH#lY_)MZS!\$F=ad@CELlk\rq~\rȐHFWnb/D-e^S;8,VmjEQ#Ը<dHlI臞b:JϹۢw'U0.u(R\r9046/![C	\0BIɼNxUoӇ-\nAx KĴJ\$n1Yf\$ '\rY)hT!\\^nSpŹ741L4:SLq984Lc.e٤\${thqnwz3qM4xyf6}Ob'%\r,]\n\n1[\n|\0JN4dίI<xTSdkf)ɂyUeHTglH}qqOV_(=	Hmؚqypm\0Q+^&4Lr.G0n=L{CpiD(5\"%5`t\r!Zۺd5z8\\_FJ0*߹>&=셞\rqGwkBՄd̶^,o'n?Z`ŢO݃\rL `/^H@@Ї\0p\0\0`\r(n\"b:P\\	<I#TCn\$iN@V#C`ktG좂`6GQjL\r7bMl%   vcfhPfʮN*.\r00enny\"/Z#TeF)0M4\\Mˍ\02\"ҽV\r0&/O\r1@5kbe%+&SpMf|bYEb##8HM	^bQWNG\$Oџ4)~at`C5~֫\r_b# |ihch&aG΍f7q͸\"t~fM Bf]ʥȤ \r =RK3\rmK~M 3--\"Ҳ[dIFP`RH=RwRR'	fD/D,]rr+P:qցB .B/l=cl.\"}M\\&-{-`^2H(\$\rVc\"\nf%\$.;<~\npo|Vد\r3H&\$Њޥ\n\$\"j\\6d\0002*:COƠSZ#d\")aKdUeZ\r9R!3U/\"V6r0\"\"0R԰75m ^ ,Sě%BI>)`#O(7\$m=s>>'=<CM\0N䛢5f>d\"RL	@N g\\߆qD#&:E/\r1f	X˸s+\n&FCf:7nmrkt\r^Mƈl tZ\$g&HZb\0#";break;case"ja":$f="%:\$\nqҮ4(b*JqTl}!Mn4N I*ADq\$]HU)̄ )dt'*0N*\$1)AJ堡`(`1ƃQp99UB[Hi[x9+AFCw@~UM^_PPU! F^!UМR<I'2mhK,/P[PtRW^XEvu:kL[&|	W~G*)Am4TO;%~sC\\10G\$%ReK8myCd~\\#%{A	Vr_L(Ce\$\$i	\\se	^1Re&r@I	Fd		\n@ư'HFĺ-:´@򘱜ĩ`y.R\\DNK,U1	)dDK)<EpAF%U%J!1<AMSOG\rp<A'9PW%\0'H1f[Du_5l3XVPNAiy`\\<g95Hk'VȂ2\rH2QMD-KM]Y@@GC1R1l_͒x2\n@4C(C@:tL7Evx3(9pJ(|t%Z^0MW9tze,2I&dKzZ1\rnܧI7QP97{ҁ8sV)\"EA(ȤW'JhM7ѻ1\0Q2U9@?GN\0sPKSa3.sQ;%vs}+'WF[hd\"^KOi/?*[KJOHMeH)\0P(gO!<E2w9\"zηJNO}[,IW=n;\nPn+nspX!>􍻚re5Y53%FiBL Na2fU7J\$HEÒn\0sgVxT!J,a:7cB\$aLO 2HII0^HtB	{bIJa-#,K\r9)U2BЌ([a\nJT5ZkED\\uAbD1B5oICQ|dX\0ShlO3j#^+uҺÒB\$\"Q?t1Mf(@cWlMA.Bb]:#dX˙27Lg @p\"b;J!싐ǈ ɫ`BpOw%Iڅ:;Y(y\"tR(%\"T g4Sm18Ǚ\"d;U0k/f,2̃fl!]EA\"0)8UD	CG.mΧ\"'1znb\n~(Bh	&+Ղeu_%b	 '(D9jSaHů@DRF\\uI\"tBM3%@PHQF;2/K(Ϲ+ů+@%Ut\rq.\$\\d%!!`)\r0j:@=QJæbEI,%\nD)Oi)B40Bs*b\$<#ʮФ^\$0#q5 #\$o:HX!TR%G*5IhM@@B`UW*Ur}ABC\"HM-]~T(Ђ\\%b**+%/U;4y\"xs!(	 R͢}cLQBτϓx@Y< e2H_9~ 	%bIw\"\"Wӝ3KșXrfRzd	`P(qj# Ƴ25aVdIH.v4K5QJw \"\r!E;v]:\0U\n @x &].\"<A9励Kx1SS{OyoJf%eWuFLϛX}̹;{\"؟PVoIAb5zԟL)ˋcsBHe(QTR5\" BF+0c4ZآBEdS}ٰ5*O&0\"߈sØØ\\7?´ty0BWiraɷp.Z\"'P1-LclbPu`B\r!`iD^	_Eخ~-p;6U]Fjx` |oS'.b!</xHJ#W(A%>}%EWܟCׄHrkC*|ڠ 	~ \"aD`Kn5)ϤCvD &o@@@o&4+\0Vk.KP4C}	ĐL2\rGPjNDpoo\0殨\"M3.J.46Gnw#Kl)ծBО&MXQ\$້<5f6\n!	\0WO<L'\raR.BoTL!&QP0AbOZkv!_3C83m&}.\"%f6cvkc8QS\$pqY^4xBƼtkOhycmh.:(%p\"-(RǺ4L\$r:?/YN\ng'&?GNHlQpbOGp`\re6\rBxH.% >i6OGQ,_n#	KBBQTH.\nr`RfmC ./?=ҍ~zkr.!\"(\$1f6f*BLw{OR&Ȯ(/1-N\r-G'p-.<ֲ-p H'\"mZTP\n߅S_2då\$G13 EQt5MC2JML\$32\$37s=/͌E|bSqlj}hK)GjA0#.N9R9-:F*oj0%*'O(-_<&=V@/l,ait3D\0.Dn)L|+/;BTt%+b+;2S	hfkDOm>ʻFCH4L!PHSnFQ @fO㓥n80qGHHS;TTCHԟIT/TJU%VRr:tE!J6OLS-8BTT?GKGMrL,NRto~#<tCC/H/L-PuCt#HQjP8O.R\n,¨Q0TrIuSYS)EG5KnOG6s&oOELTOOuO9XTRmXf2Dd[y.B2GHAx?-`R\$Z]w?<&x7c*`lor䆺fPL\nZAc(pzX\"rco\\c.P<.tX:u;bV(,JOu^Hh3%a\$bCjJB9n~>c!,D^&-Lj8+֭cfl\"\nax%81{B)Yq걃HrAn-pŇ,Ua\rqB#q^tOi1f[3XCMOJ0#\$L\\&*>0grrMQOQ\0XEUuR#pGn|w0xzwm7XJԐUWV3ĤDf\\";break;case"ka":$f="%)RAt5BPt2'K¢:R>5-%A(:<PSsE,I5AdNi=	  2i?cXM\")v@\nFC1l7fIɥ	'\"1UdJ	.eiJ\"|:\r]GR1tYg0<SWµK{!feMs'Im&K=e\"r'Q+˿}-<^}nnZ,:K<թ;SV\"zq=o۳*#\0LDζS:-JsL\"4Mi(N\".@9Z7BŴϻ&Vl7RRrF\nKt-Y(˰KpDLΣ*x#	Sj2S!RL,*ʐiDO/ۊj\r1ЧK(N#VJsR(TOTS)HHE:1	%iRՎM%jtfG,>C*^͵LYP\\t6\$\$5;b6#p9J:'TtYRoe\\]J[@4C(C@:tD7{x3(9PJ|(W||MQjxTӧ dwmN	=kRzM;cڮ@CMHh<McJrө*m\"+q(!1lmNQ/O.U/]03a\$?VͭsDj6j7ZNC-]%:o;먿yoGں(Ḩt=I,	Bh!f ĥiEJV{5fоꚋtzܥBb-<u:ގ!?<+\$L\$j(6TUs샇jfnYVS^!+q5|I2#%	^7&	[Z-,̦!8mFX0eD 7\nQ4dBT\0m:1\0Θt7\0CrA<LX:a7`e1ꘒI4Q<%mi+L>CX]¢+EeV`tNбh}d(](G1 !4xfH&D^1>R8\"N+K%gܕe T\n6|CWƄ*fW *N	Dā+\nro)an}\n8i)vJ{Q^K{/3l?ӭ`JNDM\n>LEV.Xc셑YS,e2G@Ltg· mm6=c%b-Q4MSiz،vB+pޥ!4,%zSz4h\$\"F(Lގ\061F,ćvHɧ)elPps,:HީC=b&Rby-ԙZ鳒SYgfI@IũBCT4˧g&E&dN#xYqX,-)xPxv=\$LIM\$3H	4Gt㐶F`2O\0L_bmۻCN뙪V\"+M׼uwj.\ninzs\0L'[H?`[VOv܉QI>&jiAC\naH#/T {#6H܋'A7W^%iڒx)U15ymE\"K?v2X7P[PGB@%{R-Yp\$0^xʽ&l{	Ph\$ַs? ¢4(\0ɭjUt,bKtSWdJ_MQ@e%Oe+sձTS`a^mD9:\\?JD3M<&B5oM7MA(`ޫֹ\\Sa%lIKcc+zI4nQkQw ʽ뮮2oHS>E	2Y\"p'%\$x2.~DJК)>t<0KְiU#XZE|P6@>0SH'2Xu;^઄w5Qqߖ0uBHo;nV]B+j]|ql^a+|Zb	#E:t<`od\0C: 1Zxt<C	Y\n^si^QLrR1SI\r{\0fA6çaMwc(~&v*f'-GHJj-V	4/N_Ba6*\0@&N>(	Ǘ\0,L*!i\"Fz\nBɶ򋌄CZbdGv|uX\$mWJVrrNƪ@\n 	´CVyIĤnZ+n;ֲ	\nG@DhG\0^-\nm֐8@Z:2)J&Sp7,'T'b7H~koK>AS@'.|i=n:.ۈ+KBNnb<LVfdz4Q`=f¸!ChtV&-M1yUoLhͦ/K1C&΁ȆDn`I*np)dʆ4'4( C!r8F D4No\rd	#c\r#l\\ƈ*¼'UL%gfUlu+:Ƣ`l*0'K\"è-%4MtRN꺃4L\n# T\r\nD~/,TH\rb=3(DjAZ&.01#Q11Ms+#%Op,'r4:&nDj3b2XN:-M`VWprj+B 3A!#q\$CI21x0@+\n:&}0d	ZӪD(;O\$\"7R4s&IFT/v#u۲h\"3)nZ'&,l*3@+?QzϸAQf,0}\"eEd?m&kJPʣ5S%Sq؜A?\n0S('چʰs+8/6LS'4H͒񇰂]=cJnWphv =0@&TҳaS5N4hrlMؽsT,NEOO	OUQ\noQT7':Z.,TR,\\>oqc(4a DI8;8UZ]4\$4s-Uh]<\"3KBu\$lTUEU|lL%qSC\"\"2Rz=~u&ҋ=\nGA&4lݧmUlcJb7RX#PsYuW2vAUYZa\\KA'!_/?`]/K5RU#Y;b[Ld f&f@@@e@\0cfd\rifp)2^}/P	foh\0\0&2Я\0\0P	R^75P@=S-54Ke7d]=k5Kg9eQkQ4X,5kcq`S3TmbFX/9VS:ռ]2̦'=cI^0u]z2L{uUwJM2O#9f3ll.-JsZ2ki4\rWfF|\":o\$T0\"7:pH\nȠp\\ZSDB!8ѱ(PN'\"4¿M}ab5Էeit4'N3bמ=zDJX02u@@GQd4AvV\"n`4Z`lt嫇/{ox[A:tu:FRȍ\$;+[UG1\$ni!xLZ7vncGr_J\$w\$hMDWc]kָ\"qALXFX4x|!YJ0z(:UCTDGٓL]XEQO@O8Bef+':lzX0RSn~sy	ft[7\$جroE&q.*\\.̥!\\U{ `^#u!SST4`";break;case"ko":$f="%b\nv%Ю\nq֓NU)ЈT2;db4V:\0BapbZ;aا;O)Cf4)؋R;RȘVN:J\n\\ZKRSȈb2̛H:kBuY\r֯h!a/\"]dێri؆&XQ]n:[##i.-(Y\nRO)igC#cYNw	NL-\0S0&>yZP',l<VR\np7\r7IX00c(@2\r(A@9DC09Ƞ\$aHHAGE)xPv	RX3bW#gaUD̸=\"V3d bSYa6'0JI`SA\0<7D!`uj*FRO+9:e/T-M4[Di0t#ZvBk*u:I	Zv(d# ;1KQ1p\0\r1\rH4\r㭤ECY\0ym3:x\rdB0p_tcI|63Bl(4px!WR5=S !@vdE\$:aB/i;<\0kh:eeiU/!NF\"\$:n@#X6ewZ-E:BQG(!LNpy#:WQ+1NHpdJUY@V,ĻD?OÈJ\\Lb@VS*δ`P\r,6CC0x&<R&P<\\年KU4MXEQVgiRe97{UCOVo:.;!Z^̓RjM\0-/]qʙb'6P戗{^A:\$!史WC>lt3C,%4hHsvj	4L2VlEÑfI#JAQ5G%`_؃AP7( -E \r30Cr!3m\r>k2\nYV02E.hw X7 Pi%wת_+~X`Ƀ^\"\0tc(Ϥ2%p<͈Rk`mPH/%J%Gu\"/f/ܕ1E9W/]y/E_JD3aQ#ɆI\r!4ˌ7kbȥJ4ܘ͢@HB*m1nL46;PĆr9:tn]Q8\nO᥿DNi5dDRiSX(jʁ*iP°)C>3\0Oᕯ-\0 \rJ2:Bu	\\b%red>Ú*Z6,]uHc\r3pAOwpX2ً5g, aL)b4!X7\"xp]7\$h&@Aԑf9HȘ>>\"#\$Țb7Gqf/\$|dR:@HS axRI+	\$<T7*\"C![>3 (ɵ,143T*d(\"yAJa\"]vHɹ9'x\nBkGPP@(/!XN<B. \nnذM0T\n2ia\"dTĈ%LREK5#y`3bc861f\"ukssxo 0<	: u)ڰ\"	i!aER=:Q:#u,r+R#]W(ͮݝXT>V:73\">i#/h[8@|̛clګf(L\nzN 1QP|k=iRB7uzWTNoDJ8cZBDlLXPsWN9\n	XxsNyD5Dǵ\nӢݞ\0A\$7Skcޢ'>Yf-҄=zzBhb5@=Z!`'\0PC^HRwB\r':O;=vs3f+fXPΣUid&ـVA\nP 00\r\r(z2(_\n\"I&@@!#%ϛⶍ mZf	d=4O͠]#?!(^W蕵ߴ &/-o/v/ *FϏ E~ͬj)N cOvoR-ˤ%/AJVidn҈{fB4gIL49`?'&r\"=;pj^M#ƚi0#\"epVp\n\nRR@>Ӄ%\n0\r#V6lhOIP2ڥ'k90i4R.2dN1cHAF,1.&-8a,숳ip91B@\rB\r\0 oڍuĘm٧ێ\nGEٍǞ+l7Pq4%\rQM̏|\"Q0h.=q{Q{Tn?Ia)*RTC6q\"44HzqЭ?/\"2&r!\"N\"\$1G&,\"# lm2%Æ1Pa:QC*J`ǭg+u, \"['G\")B](jd7\"lb|1Nͣͩ\$W-l<an'#%-2M.ICbK\$TH<3B&m>z!d2/\"4cjy2	 Bפ0qOX0W4_6p,817A/oq/70b@}7a/5\".:r-,sk5I;]5<JÈtӲӎA8ed\rя;g>;lNs|.0o90a\$7EECA@T)AlHhBZu@\n#6E,#6E,6\\Дa/QyF1(`?LTW:?m#iITIj\r	04X~CLrnpk<7:FC (T)1:t1Aj\"@OGOOs-P\"!p lJ \nt[fo4(\\BVw(Dl\nZ~|>-E!ERgB#'06eԣLjh,>s:	\$sG#][>q-VJ&eL\0/\r_O o[iL܁({'\$i*c~Lh6Or/6.b060!;>h5H3mYR>RJd>@CT*A`	XBL=k<c仲܇G )^R5Vgub\"@4oCM?\rXʾH8Af-<,@V0ҐnjR\r.Q<6&VPOhPa\\li8<.It!*tM\$";break;case"lt":$f="%(e8NǓY@W̦á@f0Mp(a5&	scb!iDS\n:Fe)zQ: #!j6 rT&*4AFi7IgPf\"^ 6MHC	1Պ\0NE\r:Y7DQ@n,h(:C@t4L4:I'S9P춛hb&NqQ}H؈PVuof,k49`\$gYnfQ.JbfM(n5rGHt=. 9c2#P;\r389aPCbڊ˱fir'5*?o4ߍ`*B 2C+&\n5((2lP0MB5.8҄2!,,\")#bz_ r.\nH5\0('MTkX2\rC\r1p4#ϤN@?#AxXD49Ax^;pJRÐ\\zu2h\r#,\"Hpx!: \$S]bc/x2_>.+&͚1c\nB(=t239&?\rKX(O갂#B	#pOC\"`(2We(1c~x3F*#*:9B4\"I:-RF(BbGG#K<2ÚH`յ1#s(\0:Id?J9:T6罸ϸ8h4Lا}d1k\"uS?Gg2,T.+8խ9l,b*Cq.Ly%	@6Msmr507=Ҏ|(f,2|&!-.6Ct\rĉrSraDQ\$o6)e	\0*Ipyrl:%HYp\r\ruAh\$͏Pσ((`J1PhCLhC(|	B7䜴p@qV.LWa,EYg-y-+D }\"߀ȸϵP!iDR\$ǊAp yQhWL#yDuCIkaUV\\qh81[a%BR5	r@K2PHbHJ9*ÚwrE8B\$\0cV@ejJL|0bo>Aő=q)^a\rxd\"7,e#\r%J]\n (!>(&P@\0O'm5^R%Mü F,fmԳs1[`GB\r+4,w5.e=Qr2TN:) 5HiD!9Z\\r\"v\$]q5S,:H\"HIAqsаԺىuKa	B	y/L,s\rN&>j\rQ-<sc|R26Q!4._\r	L*Xcm%k#\rdAglo)!uVND3ma5~N5r\\%d-i)qLוȒ\$	N\$Q:\"\\i]|6`̤ʳ`4:Yi!Ü3<F;wY9+r+*\"(Ed.ID1xZxYt'~xe˜dP>,jnb5Y2~|\n70i,ش* Bȱ>C:jQR]u&GEJ_Zvb\\`f'ȅ&=2ASzjE\\g{yJ@]@дWqsUK9\$#~ ӰYXu9Xan:foCv\$\$Q@IQI*&uck+Vyn1jqrぬcO8^wrh(gC?\\BU\$F*0}ށ!gb<\nv8-CBT!\$(8=|rar(/)pʎ!\r=㺘f{cVDCkA]i\"tHU\$\na46/w!O4DTL:HQiJ#r/FQǺ;{\r>5/{A';TC\"4~m\rprMp}tt+},FӶAc>r\$s'<ߥbn-`o,Cp`t-u*Cĝ0oί7/S\nz<%fق(VoP;F-Όǌn¬\n/B+|xfr&wØH+D^7Æ^\$aB3\"dBȰ\rp΍ߊ)A\rBnjgP(\0\$ڃgDQvb\n^[LGM+OM{+Gm\rq0`\ng\$ZlHwe:EJDt./kJ/;hv	1nO>B!0j\"!qrNf>D\"P6!0]q+j<Q]P#p~\"Ifd	\"~!\"*@B*@pδP\"H\$&M-6J7\0ON!'m:1qf0taVO,TvR\"\rį'Rz`OЍ\"'BR=)ñ5Q&`on_)+lP%?,C QF6c&-K?1R.-^(/jƾ;seީ/98>2Υ2S*La/RS0YR#8Vs9dGö*5R< SpKNF2jBz>\ndB\nk9(N6;9Ӵ.J:\".|:[*,*Ϋ(=6r?.\\{S&GB+\$Kbn(,gA#b#v+/AA\r B-qS\"F._Gc5.1	EbB6s\"KG#>KyF6B6_ADj:	}HBQbATKC]k\r3\\Oe%̇C&}:\nZ\$d;J&b\"ρPB,K\"`  VCjb-%r ND&\"`. 	-R8В'|2\$BT3\"N,o-UXP<\0\$I\$ЮMH`F?\r~d\0KB/B\r*U	C0e	!hP]P	ƫ@C(Hi<NFo]r2i|<lfBS~jp\$h2.p\02u%/]0:M`	\0R=6<-([eHt \\\$@P],*C6Mg<C\rj\0Gǡ4I*Jv0\$M\nB=\0";break;case"lv":$f="%(e4SsLq:I :SHaa@m0fl:ZiBf3AĀJ2WYCf4(#Y9\"F3It9GCF\"67C8'ab:ǥ%#)DdHobٸuN21	i@ S0Mө_ni2|9q#{o5Mat5_6̆Q32b)V,HC%À9\rRR\$I7Lsu		jCj\$6C\"\nbf*\r40mZ 	d\r#֥ Pbc\\7(轶O5Lh׷r.7\"LL(	²l:& H̢H`7Gb)CAЂL#Nb\\4C(C@:t\\4Zڒp_	cxDò89!Z\"7j@ x!.=!(PNP+(#/p于(U/\n	ݲ%.RrK!YPa(A؂8:\r8!\n%ʞ@c]C,07C̡9)\\x[0%NPhsPv|)C(5˻-!P3A	CV*FLp@3qx90(#UȶaJ~(8Mvn3_qGxCW4LC@I4 <ѐ#h`*e睥~B ϢК\"=bT+ď6c|!`3/E\\[}5AsA>猣IEİTv@H1\\fkm?7B=9Crihܸ)Z4rڇ8e	p	46C|/A(HD'\"FJ^1lV/Dў\rND'!^\$!4T,pDEcm^\n Is&Dj;(A\"a\0Әl2ltz\n)FE8K:\";\nTTZՌJ9+ur	caePb}d)@Ҵ	&DEG)`%sS!\r%̧JW\$\$Sh[	n\0ND2UJWu`l\0U|NVa5PZ}d7dZ	>sLDI9#dϙiy/\nlH!k|3ځPuAa)IPR\\J>7ٙ!\"Q3rk\n%(0 \n (uF4\"DL*+\0c&a<R!J!wKQ}yUUc\0`&8xBѴKP#`h4(܋oҧ\rY`/\n\ru23\0F77yÜ7C49B4\r}P/\rm5MͣhG@ޥ(&rHC%,Z*18tXݰ8a,6 #C{谡<)J	E]eq,RX*Eu&@OC3k+B_ۤWP@b1H \nn>HI%\$jlɍ\rbCG]#%bF\\DM9%{2c.9ܬ1KN&efk\0PGn9'L6\$L3wEFp6M(p:zD!2ha.XGzQ}0PB9,BH*/(V\$\"tc5KZՄx\n\"w. uP(5*ӰN7R!@7JIza>XRGaaP\0ѳH>3*J!&fb\n_\$IB͚de׎#%&lñ\$]drp ۖ/r\r\$tA4	A!^?ͧr<.qά3=ٲr^G4vqoNZʮ3Fl͌evxx\$fg~ T!\$M%wo)5Šʺ-^@n[]b1SJ|Ѥ|߀Ը[9#bJsy~\"ϛ`ŗ}*?9\r(cѐ_\"u\ri`rRpqGG\r~Gl3GM}Re5Yz\0jmD \\(CĄ-~ȫ@6f\$>A\0MBN^~2#b:t@F@fnE&\nEr,@0,-\"zĚ넠a#42,LN;JvV,Bf\"ِnOt\r' OvFJb\\ʤ%0hCA	P) \n&\"0U,fn#zgZ.C>b(rxJ˫\0di.\n	Ћd%оG\0#ڞnQ\n|LG\0|xѤDDڮ:-beTAQ\nm;3Ѕ\r\ng	F8𪣧Hgr=cD`\0F{u!1NB1oZ@PQl/kqǌ|6&r0lb]D!Lउ{-}DęX,#*\"VSBC\"\r\0&r%g2\$ee eえ		*Nv\$D싄F2O=(zyqbg!b^Dzqs EA)()\0κF2+GD\nen@0e-g΋\":q## kR!NTs4I~tS_g.]zs\rƏ1)S#/Oib\$B3H(QI2~;PsNH00\$3P25ĎGfBU3Ts*1+tSY4nj\0o,W%B*%.X]:)gI; ;s:\"!:c݄% <E擸80?q'=8S8[s?72\"c\"N'?Ѐt.d@R	\rf\r/q3@FVOD1*z,it`|0:R	c-0ֆm?(8PJ2G!36gb7@K`\0V,&u&.\0j9\"JB\nZ.R<D.#\\J54gQyQL<aQ%pM&(: C1H;1GvB>X2Β OTplrh-8d!\$HcOƺ\np\"3#nR!&{U-,>\nhcQp[8U\rcT=Y~9mcj,rxc\"/'CJ vjㄒa*\$>Qb&&̵t`0O-U8jۓI%ͬ>@\$BK>V9Z3U:{qcu5\n\$feĤq#k\"";break;case"ms":$f="%(u0	 3CM9*lpB\$ 6Mg3ImL&8i1a#\\@a2M@Js!FHs;MGS\$dX\nFC1l7ADt@p0Qs7VaT4\"TLS5ki9k-@e6Q@k2()6ɝ/fBk4S%A4Jr[gNMC	œofs6!e9NyCdy`#h(<H>Tk7r!&.7Np|+8zc*v<vhH7lH\"p=xÍit<(íBSV3#ÁBRd+3*BʝLޮc\"!P	؄;QjiꉃzZT3{1/c Ժ?ì&\$bn>o;#7T@X90z\r8a^(\\Ncs=8^%\"9xDk#3ސHx!2(\r+lL#\n&5CtF'@P0\nT (C˞ׅJ|R\n%L!`FPdt6HI\$H0lI|P)L\rë		Ĭ2X9K|rZ9<\rئ(S~I#p/Vka\rB!{K<ǙI+:ϰY9P{\\[m\"HJŪݦ<v*3aLLr|=>c=1u]A(\"ģX&\rZot0̶HhE*:&|9n,Cɩj*i\$xp')PwSD1-w]IQzrރHo!FrRolͽn	RK6TTj;x UBBCIiVCH]	?FXka6>7iJ鍇?0,=[l@\\SJqO*D2*9*`ú̞2`] kmA*_0'P\$9%\\\\ViC7j 62c!r30c uO\0003R&3Q\n((LrS7RtrB@{/\n (fA?2GZcI Ce1cy~٘+ی(Dg#܂F9tx?w+U[(IHc'3+dtr'H2(L\0C\naH#N;bAa9@|>|FQr`&=*(bbfZ.9]hVBNbG88BRɱPN_U=Q0M=\n>Q0(%k'O\\\"894'Ot9=1WL*\r\nGM;iA#(2*LTNm呭fY)\$Wq&3ƾܒA<'\0 A\nЈB`El)(uIJHq5Fkqd,%ޛO#HM=1[4f{3!%Jv`P2h0oKj-ohD蹰!ڏ7;tctT(V:efٖ\0L9OSMb\0SVP5[@S%iIX4t*ʻÂ[}娆50LnQkO:ځV13#XeԪ	ugfHn:{iOlAYA:ǭƸ=\rv@rpcgA\rL@.@%h-)K㤳[)uFd޸tgz+le~B@PRQyg:rPNyȑFiHg#(ԭv\0r )zAy1\0+_\0/'d\"V׮?r|5R.%Ei,GiЌo`m\rLC|`&Ll\nAM!#qC8\$R\rդ~ΆsPPX%5ƱB::ZEY<ou*.a6&P!rV|K9\rq}Hqf\\E.tr0ik/g!	#)>U×'t[~*s,oP#Hu?6];vQ^l{Hh;ȓ1r%ګ/Ut	v|=j\$Hrwϧ~~*E;!_6MಯeOWjwqa[BOg@KЖCkD_iBI@D\"Ϧz&3\"2c*.BlBRcR{d9.bPՅJnǢ4iA/-N\"pRB-;eg\r/PpO\0PEc:ڜ/	o~IMl(\nn\n:v{p L:bL9\rr~CuBFH:`B\$l-fMo\0001Δ-\\;Х\0b1,ZH\00@eKc]1ZRl#:X3έ_t!Qm\"&* @#1J ʢt- 'N M*	eO8ӭ11q\n\"hQ/\"ְ\$0%\"-{!b,mhDx;h(^fzKcn&B߅ݏwE``-\rꖣG>\$2#8	BD\np#-φ蚤v&êYc\0Qh4JU\"5O'(%f'[D*2dz2j[nfLkn2LB'?126\$3N6[>t~#zoĻ8)r%fl%FgS\0\n 	5c0܃t1\r;-ӱ3bj '/|z04;SBǘ@àw0+7꽠";break;case"nl":$f="%(n6Sak3do0p(a<MSlde1tF'#yNb)̅%!MуqtBK%FC1l7AEs->8 4YFSY?,pQi3MS`(ebF˔I;ۍ`0߰\n*͍\nmm0K`-Z&.O8Qh6w5m9[Mֿ5!uYqoEkqȕ5u4.T@f7NR\$Y8C)6,ûBю)ϛ\$=b6h9ØtjBȣ^K(HȾX8- 21b(ïC,7 r1kN,+rt2C24e[Qkc2P8cs_2Ѥ1?\0P\rbDHhԁ=jԜ?ʂ:,3ʀO\0@=Q4Np0´D0z4crx[\rAr3^ٶ,J(}>ы94\r |FːƍD[ o+)û\\X!xx\"r:J585_Ӱ8B#˂Xޏ̢%m<37rY>r)YZD	p#?dLK0p2\"̏h2nLj5\n3Sm.f#V1.H \nbF 9.K\"7tN?mUP2;\r{;80BR2\"H8hks\"\"^mkEͻ4\0Pי(VTKIaͩk\$Hc#t3VC\nj¶Ш.ް/#zүI(?Xs3ט3hZKOdw)􌜂\$u@\"TfgW/EᑅvO	\nXⴟOك?@{8}\0PȘs:&3(gIB\rBgN\0AQ*,9*UU*4*^UV\\õxXA0U@>2gfL`#[AV\0q6.?rNrN3(I\"XºB)傅W%۸<	-|JCh\rӠM*dm^	)Hc{\rF\"SU-rhq\"_2d18M\n!S~qԚ	;/`f=-\$B@[MI_~o(\$@zI\0((ȼ&|Ci.E䲠sdA(fvURE)&!uĘ[f>[d\"dDLсfi<)LTʡmMN&^D\n\0F%(	EI-%AgÄp\$ZsTg}G\"S|qnD)>pPìח]U\\:Wj0%\$r&/čd_SfeO\naP+D;'^h1𴆒1e[֏LIx]QX2S2́D6g)#xL0TW\rwV54Je/Զ \$V*'\0 A\n\0B`ElzB+2_p	TIFiPКX1Xk0m7e7j!rucH}'\nC[m?7r<\n	fW^}\"Tܟ,ӶȇҗV2,f#Y5RY[L*wܑ	(Ap_`hm AEpޭ2^ik#\$2srA\$7\nf'F Ju/#OXD%=}:dnfp2\\Bim@4Kvf0rxߗ.P-ҦL1TfoސP+q7T\n!@C3\$EUX\"^[\nap\"0eXo!D(嫞\\8UA	bN\$\n2m,D:	ll༸̻<L'\n֘pÓ5is6t,)pjDk=)(>HLSe<ukˆzlIcCp+KacIA aR)	B,eOVPȒDqfIBOP3{>R ӈ^oCۻA^_K`\$a㗙њ(cCHU3KdLYv2FXz:E˕	b@.8߭Oȼn-?a=\rh+O:s&n\0\0!fo`\0IجdJz>TDzld筲p.v#(;\rMX\0n+`@\"Wp[\0>`mF\rk\r6p\"^ 6\n-`؛K\n>ϰKe>!UB2bkFش\"ֻ0ĮË/0fkpjդc!-+b:\"]؃2\0Q90oAQD*nngPmJid\$8F&\0\r&*ۄyIMyqElf[mN6Q)1#q邞]C\$܅51D!\$qnQܕb&-\nM#r;\"p-'\"&lJK#\rf-h&ÂhE#RJjmn#N-d1`׭'MO'-'M҉)%D\$֛\rM(*!z/6-\$h\nH-F\\g	G(m-+j!r҅\\*hf0EL1`(qA@\\k<=&ȥ\"jH5	o\"1C.	AH*\0\nq(~8pNR&C\$*!<#a^.̳C8SOR bke([\0ԱXqBd4f+ =͞\"\0O<\04U3ı\"Q jUb&GԪ_?\rr.\$F?bbC(\"`{FL7.B`0:#Bc6{)ю9T,OQBCB<!r%F(SA(8-\ngrvdpKƤҤ+HfLj\n*q.]\$`!m0'r\\&MLT4\0;	Cff5\n,XIT7mbTC\0D2K\nۂ7`\"2;/bF";break;case"no":$f="%(u7I6NgHYp&p(a5&ө@tNHn&\\FSae92t2Y	'8C!X0cAn8!	\r࣡\n7&sIlMzb'ґkfY\\2qNF%DL7;g+0Y'qH16:]40gۈHr:Mqt醡B傽JG\n!n7S:D0LQ(Ye93^;#\":+(#pصa\0\rmH@0j&i#M|:	((@\$H-L܉ ;'2\"B	<<;9Gp7B7Nc|p!Cs69h jڤ@ c\$K&ϚlH4\r㫞0`@RBf3ЕtL19H!}%JC ^'aڴkh̴I@7x@|2KP :52հ6Cb'.+\n7-:\np7 X65P\$2WS z5x ǌ0:x췎6P\$#U%#n	b&;-,&x5R0Xc&\"'h\$2c\$\\Ah1l&^SN8!@R\"[[B̂\rcPBz.˿{n0˯9ۀ[K#l0\"*Ci!gvgI/jL&#͋cv43ڣ/NC48˺ڴtqZs(7\$VF&(ȣy`Z4&r,ѽ*3Z0\rxA4\\C?P6(MgKF7+n0쪔peЪ7qT\rѫrT	N\n)`qIS\0M1:âTjSr\r>v2:0k986\0sh z)&t\r\$j@SpP*%HN0V%^^+y0\\P^q8vhISoݬ4Ơ3`kj\0LLXt&ӈo2/iODBHrȝxRo6?DPJ\$9R4\r%\"Pr1Հb\riBJG-0f!PNL\\Eq]5ጔ(\$TwKOFoMܿ@`CaPI*ȓ\"\r҄FOEr@HZCh}fd痉w/ؙ6Fz`TPoX0B!MV(3bӃ14e(P&>/BsZˉ/tZ8i&p ƛ=b4ht1JD*6,O .bR̜r^LI݊&\\Z֭	yE)`Ly^\rntVEЕx'!M5-VҐP(\"Ĉ.PB3\rPgAjea<'\0 A\nЈB`El	~&WTyY,_Vqoc4~\rRӇ}R/͹u?	kP7\\'!PvHUck-f܅zlY\n˪aĔlVD9Рtm fm̵N!t9鐂l_<\"´c+.Hz`.@xD=]0C`u~2cvGHΘh/)/r[S'4Z	& ƒ6`i˃j93=]-!!H@PC&g_Z)H7ZR#֌((`\$k(-\0*|kIGBv:CtAa VRpy f<H7Ol\\/)ņEwi	s(!xO	j[v&\0'yߛ/>)x#85L\nIkG&;%8gR\r!\$j(➒\nOaiI,pmP0!\\2+mv/^2+^5\$F|g\\.!斕&mXC\0Ng\nYxs5Ӌ!פ_cA]JOwW>5/8fVh<iy)]ҌJD%xVy^m+Uu˖3Ao_sXocEw[CklW:7O\r/)+	CW}O+L\nmO@؉\r-e̓N+0No*`\"\r.p)om4&\0U@MO\":	mzkl}m ˺)),5& JD>&\0RPn&-pzƵ RXOvfCb\"&cFІ(b(f'WpZ.\r~kвXfY\0BsP 0-\rNO\";	{\"n&0 6#;aJ%h\rD%/.:*M)nرu\0q2}>#&@IP=l`'n<ѕQ;</ѢZI#(CQw\rqGL%&Qr`EI.AN10mL\$5lC!&ʙ*)\rӠ#\0ԍ26'*C#NxP9%&r_ q R:9|F`EƎ\$2`\$,1	RH1<i0 R'\0(:ਲ਼\"zhL>Wr\0)\$)-<	eE,a-;M!\$6\0F `Ab\nC\0f<CI2\nc\rZ#BFq15p(p)lVc񼴭h:B39\0Zh3Q3C\\5Vʂ6D6#\rC+y	]-|%oQkGs|Cs2q==.%,6d7ns\"P2LB7ҁl 4C䱂<\r:9CCDF<-F;Na--IF!-b@#M?!M2qtOH&_@J ,D\\\"\"L-(E^!@";break;case"pl":$f="%(g9MƓ(l4΢劂7!fSi̢Q4k9Ma ;\rmD\"BdJs!I\n0@i9#f(@\nFC1l7AD35/8Nxp:L =M0Q\nkm!y:M@!aݤhr20gy&*u8Blp*@do3Qxe5^of!hp[73qiy7pB\rHL>\ry\r+ry;¡\\b@t0.\"D)*a=KS拎;A*7N@@n) 2Mt'5B:p6n3޵藴򂊌r7KҗP)#|h:K*#\n0	65 P?-H6FN?.Ȉ[\$AH޺\rP7H4¹92cU\n 69?;+CMpAcXxƌD49Ax^;ׁpH\\7C8^P;؃ ^'bmB7\"V\r!^00#)ʃ-Pʈ6J,#n\n-^L6Pt1x	LH\\\0:8\$⸌ωC%dfJ?)a#z̫z#zb@6[0B07\rm\" çIcC8=!ؘ]iX>&\r+@yrɹ2V3)\rètH9#_K;Hh(P:V/]38	?s 9;4}Va%Q@0̌,sx/NX\$.tB*Qlo2YW\n!9>~\rKMV#92CGc 1}|)0ҁ~2aI W\"	ȃ0>bވC#.2X\"@Sl)&6%C£<R37CP\$B\\gС#aҪC2d2HiUH~,h(^Ŕ.9\0pO<Tg#r^\$D\n1EF(;r2E:˜b4;.	ő-!\"5ÐDc@\nǂ#UZՂV\\+xeK\rbp.3|h0&Køyp\nUdpiE>N0r.\\!3X\nV\\{*VXdPCrAC)K~yq|D\$OYzKe%޾0CIqGd\\ByL)*Y7^a@\$HWB#0M!)4ZJt;DM%1?Cr)2A4j\r\nYA	>HK4|l5YP(A?*VE6/C@ЧރBtp*5u?2ΌHc&!;%CjIs3JDD`ad4BKݩ/T/OQ>[\$l\$q@R8jf\nBd9>PK|w:9%d!AAe\"\$2H-\"\nV`ɻE!SuPIR3&'LE?!5ROT\r\rqFM\\v|;\nY8L[pWи/&@\$1yAІ\"iL|zb B\n49&fxF\nq1=`!EY,l#iI;\n~N͚{ ٱ,&ZZ\\5}Ʉ'#6r\$n	TÃT0Ԓ8u\rPp|y.'yi\",ȹԂF\\v{'q[e\"/<*yIo9'^\$[%!`޵Cs5sAB#8!}'/k >	d2fKfz]1ߐiG(:X Yb[GKBjYR^052!K[^ߝ6,_}]s\r\\4Ȑ_J.c%N\rwuay\ry|jl{ɁZ~	ybSMhBpu#-Yyexf{\n0葇B:N	}0 T\n!	@w^ǙX&t᧌`^SسYd}2H<iU؍\\]-0B7\\QgD4/Ha_)8ȟlb>SMZ>k_>9[9/OB|/\0\0:\nb0fmj`\$ 6'KI) ֓N^(pVD#JJ25Ĩ+V'`>a2\\x'b&䁐6مJ&yl`7@).\"ߏZd&;Q/LP.\"]`%\$`ͽ\r9J\$/b^*&JAiI%B^eŘ=O%]q	4	,gt&9>.'\n8qG\"=6!b[H箊%1lĲZ~ \r:C\0\rNd@:ѰЎ\\\nrifDN̆wM\nq1\rlOC1(Bg0XMq\ngj\r NBvq-\n#`!+JR\0ϲ#r3\$bRMS/29%'C&2I&o&ˮ,\rP׬K\r,#.Lk\"\"k))R.2NL4O1BtkжC2hp~-Vhb#`EIp脄+-\$Z؉?-ق6B!`DfƬn)6]2Ս&:.b1['1`s\\ҭ_5A+!\0uκ!|\nK#2`h60Cf9ӯ8Q0NӠ;b6뇪3;mGnd6c7mN48s9hؠFRL2w#a4\r72 #g@;gPƘN_3AfPzgCODSz?B@_gjd	@Ic\$@4)Q2F2!GFqAұTGQDaGnĆJA(J\r4/3->G3uyLL.LK/C<9n;.6RKtһ+O\"YPRB/IinDmQbAC=\"\nx#Jw)ISD*xi/PCSuK+AUFqb@&;%/Ĭ%35WD!P1V.ba=#XYUc3ty,ü^N^D\r+-(嚍g(o]RNUr+d\rVb\"`\"0C'&0̴ǵ1\",'Gbb\nZHP`Jȩc!)q>y,VVFp°SA`DJh!3(j<0`gTLl\$'c[rNn\$;1JoრE5-\n]d0#=5b÷4&*¼\r莙)+Ǽ#iVnB&`dM/wP~lp#qÚ^6<tj렳йmIhFO6LH..FsXѐHLd*^@v\"m|L\nza\$Ny3K(FXyW0u#hT4CdT-z8fN6%siI-d身	r|AC#`";break;case"pt":$f="%(Q5Ho9jӱ 2Ɠ	A\n3Lf)oihXj\n2H\$RI4* R4K',t2D\0d3\rFqTe6\"P=Gࣱi7#In0 Ը:a:LQc	RM7\r2tI7k&i#-ڟMQHٳ:e9al])#cs+Î,qX̸q9W|=:IE==\n\"&|q'o<qTk7N9%\"#p0(@\rH6z·0H3O@:;\nZ*\n'\0ԙRCj̈P&cȒ錮0\n8\r({c!#pҜ#,9RҜCfHa\03o.<k272 ҄#Lƹ)|6M3|p\"ʰ.sӒS j@|ccƲ/20#;#`:Ӱ#	C XD49Ax^;؁tI\r0\\z2`2&@˚Z9^0HMp)21xՃ|1Sj||i<7'\r%͘+3(Cʠ4Hx:l1pe-@ Տfk2CsS#ӥ(w8CfJ\r{	2Hy{`h	RX&dZH؋ԭrƍB\\&L_hP7r`Ha\"過|~\"#<7rV4b	#l(۱8T\$r!=/N3lpl;ֶ8:^\\?q\\O9(\r,}y1oߊ=nuVֿ+?80f=K\$B̲I\"'\\*bK2!O\0 kȫ3Cg/Ր((`sAT6,@A*4ح<UYY\"Ԣ4]+|H4\0pn.d7X&ehp\$04PۚP԰aa®BHP#8U^*ǋ,9,՞byZ]ڇ\\_;yD1vdKCZU\$:2	HA60H5EKQg8ШIcT70rً a?^P>زHy^Gc X4#	0DN#!:G9a\n ( xm͈(( yD`bKDT6LTLջ\0k9!q0X:dMQwxIѼQDPn\nA-9n.c͒PQ%ATFԌPRP!9\$o3:\\#,(#&DЛ:c]TSK)K!r<QDmMKh(Ln͉ke=r?ToB<)EIYk]3ܐKԴzKIy\n5gPI,7>FH+ڵԄup\rT\0F\n҃Xf9T\0\r16,QAY{g0P*[{ E	YK\$G\"`GFFǄ`L/hpj\r44eCdԛ>,]!0i	)D]ꓺ}DjVR꒻K`C\rZ*98ʧ}:GVנ8\n\\S0L	9AXNPAԢ7t%z>]m9&^TQ|A0`\ni&'mE*\$o`o,^OXHACfD:<WER9phF.F(wfa(U1\0#m9\"d`Ƒ'U.D6]ˎ1;xP5%י{+Ⳓ@Vâ!Ȃ̄7futa6+VḮEpB&m7ũT9dg?{8*[.&XE4=x?cגf\rb퓙M]*:+>LgyA\nEwAhyf:W9ibiֈ!5Dw5WpJXN\$8~eգ?}t8lYc0=q[ZAd;Y:I'|uiE\$3/#!Gu9Hcr򕸏ps7ּэ	ܳ%x`Pm'P0tg9b{ѽ!c^5yO4İXg9ypW==WϘnϹa\0(|^K	5i2CIÃ-x-΢cDi.,k8 n&@dp@~¤ UMd@2 f./d-r^\$Dood3b2J#g(NsȐtH^hgLD&^ЎxC-mB6ll%\nbвnyCc,͠(o\ncPF'_o^-d9fF/r###Ü?)n3CnDlbn6D\rfHp/LCt#,NdL!NXfEp,2]KGMw#\"l*d\n\"SǐGqn0#OO&/QB<He&h&Ā]dQq>	<烊ߪ&Bƨ:rp( R籁\"<i\"\0*r,0a̎#RC#(NCy0kF\\#q& &rj,q'%&RiRsK(R{)2w(b8 o*0s1,dJ9Ҽ4F0qK*\r,c,Ǭga-mܘl͹-p4/0.*(\n#ѕ!0&20Mh=2\0b1 %sQ\":L4S=4Ҳ@0Ѡ~I;!Cc)!\"\"S}f]c6c/O1:U#5\rMDEN&c\rVkqA(E!RV#B:O ZkVoǜ\nqFr1F&+r}K/~J\n3(Toϒ6/ύף(c40:%-\"uE<&hHGF~&X'Qa2Df\ne\0QH*hQcH.bX5c\r9hQx-C43B}4\rKRS-t9Q0\\s`}qJ'[PbN@,Z#!F8TDN-\\˂r%/1ė=0IDCP}9V\0.(2'ʢ+OGA\0004MSJ";break;case"pt-br":$f="%(Q5Ho9jӱ 2Ɠ	A\nN\\\n*MqmaOl( 9Hm4\r3x\\4Js!I3@nB3'h5\rQXcach>#Qz4Fi7MjblLQc	NE2PcI>41e!',΢A+O_cfkNC\rZhbL[I9OvqŸnD,\\(ǵGM7k]3c/_4Iț`&U7094ÒN\"7S`: 9A9ȓ@35˄V72k(RRbγ:]\r @j\\9. \0Ф2(#ھ\"҇h(h7#\$/.<H\"|12KPĐ@+ 3B`޿~#* \0ܟD|Ʒ/@@0Đ(<\n\\:(t'\nC X\0D49Ax^;tG'r3_	\"5`J8|N3/Z燁x8`Ƽ(y>Bj :T6*\0@HMzݭ-y	z%\"+t @1*lcx:)Dc1ˡ2/LdC bkt\\n{&#cOb`ӡh(w&0I 6,'ը'&IbhJV<eT^}hb.n1!B&LS>[& މ;mCtq<jO*rc+ sd=]ZH4b#m0Ɉ^r=1Ps	q\\\rXMxe?\0#ͻo@c6x|xl=L|h&L5r|ƁW4Եh0f\r\0c2Jy/%`Ͱs5Ey䁁3U0RqC	7< dM'\nuGQ9*beV&Z+epXa(:\r>=DL)Se=^#Y@~˳)4ƯUTPfeUWj_0rY)єҎC.a̩wJ\n_P<St_\r2kq5\"oASQ\\*V%7G,80h옠d^>%K&Mv%GuӠGc p4#9yNP\"S@\$0((ऌTfdC*Pw'PmXr6J)a'>\n\$4QQ.VHHiR<sC/`IP\nOFZlPL:*a3VHl#DuwI2&伡BO:\$zG'Dy5HFd6扩T6il;D6\$BA\0¢:䕿4B:@\r4r#%>QRSJsgib[qjJ߂b܎\0'q;ywDU1ZEQ1%22Vbܢ	8PT^@- IP6X\n9O31E&+f%+TYg1fLɪ`JAMU%u\r!%&f\\zQJP .;`T<=\";v-<b.A_qAvG\$T;vB>_\$(oR)ePM;'qGJ\nFbMrb/,)hk蔘nĬvh\nLQx@s\"\\2sx[zf3hzl2rg(1N\r\0\nb6͆8Q\"zWhR0 w\\z\0005W.tn!5`r D	\n\nt`v.	gQ0TmS\nF[&%):.vG{\$QaP*R/)We,(@(Ľe&\niɜlS\n2:h! Ƕ˂yF]]ȹK'm8ngo nxGI;/ʚo=T\0sHͺ'f\\۹e6qM6cG,P-`Ad:[uWii\0)BH@̩E8 GeOw\nY:\$ޒc[I<攛Ga!3s4nPA`oiI3W<~|Sztrҿs13T c>&0\"͌}G~nJzI*3Y!#nB@F=CL.#kpܬ/O/.	nmhAHn%OqNcmfDq\0/L\rc`2:J/OoMZLz,\\\0OK4CG,g0ůd90wp{䀣πw>T8毕AO	н\n=/0O-%C&\nM0t||>o065팳MP}Q1ث\0ʌq01؊	cF81K?F*vO\"*-rbj-f>U䚖D!a[b0OuXC9nh'2\\k/*d3)q.^OеC\"MO 9q5	/\r1 10<pI9p0 j!QE	]Qè%d1!22ghcQb&p=.+ кQ29%F)Q#&*&ȂIi#(*0c7(e\"JFqyBMBD- &rs+R¸y	-Rq'\$-\$ /.R!lc&r?\"0ץ(B)mm5P1b2D\n'.͙2Co2N#2\03Y231\rْ,l0`5!.PA6Si(o16b-o7\"P4#\rNN\"6ʼĩm\n90*	\r\0&:{(^)%)4b^B\"0/== jafT:'a-Sb2ψH~\rVjB\rZ*4l:\$D}\nqfb2-0/Ni46!B! \"I\".Ʀ|ă\"*31 =(O?#2P\r*o27<OCm\rF\nbPat^hîr%&#o4>cDP:-jMGAQ=3Ün#PԢ1-=F66*\r(BS3QlD?MP)QQ\$MElDoS\\I:BF!FEJ,4Dj`&\"4#c3DD56u2e@G.&2/-/\rcy\$~";break;case"ro":$f="%(uM0r1DcK!2i2a	!;HE4v?!\ra2M'1\0@%9dtˤ!eұ`(`1ƃQp9Φ㡕4\r&sQFsyo9Z&\rن7Fh&2lAH:LFSaVE2lH(n9Lf;̄+,o^NƜ :nN,h2YYYN)Xy3XAK׬eNZ>A#\ry۳qLYN[Q2lBz2B5x#𕈌S\$0!\07J;\"V#.x掭/qp6JҠDR`*	0P.B,Դ?JD229#\nH/q),#x2h2J`¸+#j\$-4.ύ/\0P!03@ΉxÂB*Έ)y\r <9)\n9oBL*;CCe\\H9`@#CC3:xouTAr3P_זXJ\0|6	23/	퇁x91:d#*:E1-7(*c=UOɇ#N&2cbF/XKҊܽ(J2~:9k,H!#H럼hƍ(t3 3j#b;/)X##,c{#;Qy,T?[ƴ3cѳ-	\r#\"1G-^\"`@8Ðo#n\r8cuVP	Ixu*=t&|\$ǝ`O&J|4vSBO@&Cg7ƇLS\0~]yhr8<|O1H	@L:/RڪEgl9Q#Z@(ؐHC0fOʤGhT\rT\\hcWa3بzN04c\0!0RP \$`3O1+\nS30\nqv)@-&V[kuou«\"?k7._u@;`V&&4|ʀpKF)g Av:сfL*%a5\nQ*:zIhVh[in-z\\tyyʧ22Nײ T	\nu`u/'BSi;`b9IWNl0i<cC9ECI}AE-(,o/eA{5wa\0уr*c1`n4yYrPTQL	F K!5B3jhwxQ<#AX`N:\r5,BC&Eky%a) p|0)Y%2lNiԒQ\$DRȓ&5蝡_[1_?	M'Qx1&M\r,Z1NA<<nrB䱫1t*qJ!7lLBO\naR,቙PZIi!TNzE)^`l5+4x	)Gݗp8W>G72RQɻ#A*gSC(kNIÑ)\\\"P!ڧE,c}a~mj8UK>IҞ]dYLpn\0ƔP	X&i.cZ\\rGD0ùxŗ%E4)B,YHiĆ `ˮSPf[K)Hi3beVi&I4\\< (PI/i^lA1VF\r&I(60ўlCPC~I	T\$E=+zIc8{;WI8^Kզ2tm,*ig9֜Y[YckXKl47pN4C	}t!+ɉ{{n#Afug4pօ)PCcu23ҥmEiQC&JdmrsE%,_f=6O\rC	mΒ\nR,C#2hf5V>6hV56	3i`[KgEۀtY2sDLCj\0H{0xGjr\\[c&n+g]S|eٗ^APWBd}ð!bdc^ M@n\$!:0%\n>EMTKsc(vko FSGQg崋s:f+e8.*EEYhLｈn*'ΰ\$/у|)\$.M&0C6no.N\$\"6`çzDdF|JKbjL.M\"lUPF`fz|RdNlNڣG&n&\"P/#Pƀd@4\0dCp,LdJ@<)\r.,б0SK\r̲09\0BWlġ޻#װ7	=vF&qA)#O\nT*: /:0a:1נͮQn5̯1<S~Bhc1\"ާQ/	e\r@I--!*:`@>JPڇC;1g^Q5F:ðJU*|\0q\r4d*;MLn!\0hC:Mi=05DbHpјG% F4j1wbTfETp!%2g(Bх7(hc2pmF7).jzGRN(, aDHfn#<Ҿ ^t\$%/w/rL0W0Ro#IaҴ=1u0m'C҆(q2)\"H}bBgcBnf,Aw/%J4S5a75_̙6sP`sm7aq	16|UOs]3s7U96\"ӖLA6(86+,&;0T6}\r(TBfTL\rs''=bLs<6kYjd@I<vND:Ҍk-l3*q\$@)3BOC6Lz,\nOP4!/\nPW3	+N u`B\r/C:\nN<@m\\mgS&jHhULhnU#d2\"HfdJY)N:2ԣLgJ|#^g\rV=>O7#T\$E~H\$r\r)&@\nZ;I0\$f&hp4U8,!\"0dv'>M0G<4n0YOɴ9FPh<T\$8\"\0A4=:Av>%Z&`RHzM \$d&d&u1FG\"	T|O6]\"QIα58d53˲*2x6m>ܵS\\s ry&f2F~j*6ǐLLfJIcc\np|#D0~JQ&KH`	af0:'N/vDF3ӒGkGV̰ih|@@	49Mӗ/!O;MB\$c 	\0@	t\n`";break;case"ru":$f="%)h-D\rAhX4mEFxAf@C#mE#i{a2fAZH^GWqh.ahhh)-IhyL%0q )̅9h(HRDLD)Cf4%Gf\nb֬{R\r%m5!s,kPtv_hn]#Pօ'[\$!&chK'FAIE\$e6jllѬ2\"\\횩mKV7ťs6PhNCh@zP<l:\n,c;jA0p9m#)Đ~ZĎc(1^Ӕ07Ϛ8ŪGHE *8C`*c	..80	9\"\\ҫZH8M\"?>jRʴvȚkKLd ģEQc*\$|z2qR*JC<h|5J~͑o\"ء(SςZ9Ԫ#A	 Y*Wzi8(vI>6\r.רOOJ/=N9w#П4# 4(B5'k֢D_ERs/C\rS,[ӅG\0x0@2D49Ax^;pÇb\\7C8^2x0cxDMF*+~%H2~\\x-|%H&RũD	pv,Q׊zֳ9@7&IK.QiP/U(ɑ	0v\nKb=՟-OzhKb?IxNp&RӋ3yRRFrhq̷\$J+d)#;R\$Iz{>uYfj[9漱J(nd<JK\\J\$P+l\rR6`Q[01#Yd+]\"pv؋AL(Zu\\I\"zHDZK')9U[A/J8pLDhMstrm4jSiLK-7g\r3Yv 0I\0IE.^l\$@)yYedUmBdZ&Lrɒlm9BBAN(U-#@Xd?7'zKpsϤQ'aUT0OQ	`tIҐțe!6U\$Fe+bJpQ2)q1%)h)ҥɔ4;-鸦X\n AgdŁnO3CgYK0\$Y9M.ET>D#VY*ҔQtFgptOZ@qtk~z\0,)Tv8Lg顋z\nuD3%u;?aYEfǕ08<e̅0C1ID\\G`68psH3fݜzChӚ/7m#ZkKGj]d?B:gNrQ!Dr\nf5>J^!C@Z	ܱ]d S}43fpΙ>h\r	v,Ki=Ps\rE6oL/':k<CX-VYrE&A4ED|s)_AMC˖M\nm;53 \"ɿEʌ)du-Yv!˙*ntbdƫ|59|%DKA<v\rDi\"@,xz|-{*(31N=Dl#UJ\0CoǚAd2d1Mm1H\"?(D%^zaK@;S8M4՝\"2%`%E|hAl#ZW-b9bf\0!0m%KGƨȂsvA]lռf\$T9m]m	⬚9&}d.[B}˴-cF?Uy4>rZn2\\Y>m~~i6A.jdo%sH (!5E3UFPQT|r_%2M Hck#83&l5cLnSƤ[]QM_!%E0@PU'Uh}; zq;,fAnɢP<zlU1qzNՊq1<aV}~Εc=	^TdoPcׅ,	ub)vFt#HMZQzQdǋr\rS?XNQ\"\\y9Χ,G>ē&G鿙;d&dƮ)o\"FԷdwUg(W(D:_c(h	nȀ	\0)ʬGi,V|@tkfFӯ<LqFŔ?g20j+HinGG\$D{\"\"DR̞|n j\$(`f\r\02.E썦кGDЮz7OoSJUprϢ-P	(	 \r\$\r \0@\r%Vr'M[tr,}[LZeEL-0o&o,Q! IF7%'-'-1CtEq\$oL.{ZLH..)&o0ǰ\$\"iNJ:*Pp,8En~)'|PTȰɐ&-8MhkFsF\n 	~\$9hшdͅbNivʦo)r, GhvV\" wFI&Z[b\r\nc:zp\$t.j ~,q\$vRz*~.w2q)2\"o*R(TLv)-cjdhdH,'2#.I.d*-.+G2ʬlpl#02/=]0b/}9bV2n#!8nRCSG\n4 -+\$C\"\$SR?XR.RiI\"dGtr6v_q~QRBxzī\$\$\0車PlL.Cq:\"#5D9fJB)rfqķ>\"(,+>q+:4.E(,b!uB҂41Bi\04Or}#ExHGCM';\r>|bWJO(D0%3!7ZF\$IgF.DJN\\oB\\Q,)*RĴ!Fσ|\ri\r(`\r\r Z(]J^yNooDdôBDeKQP=SUoGG=?OUBȗEu<&BWA,sg\ri?TTK4X.Z#bcD\$uDpI^t?AbYUw'4&Cg\"c0S@[Q*s~#Y'ZEZPqnZ\$P.))5U՜)9-\\O]!aZ:;U\"uV*s1|R_'3#[**'v#Tt(eB.P/|F\$ÀD܄g`V\"g25(HU+Uf!56Y17TCc0pebDZS6iFo#	Q+s 8Y0VTj^5c^qqo/]%oAv2Ud2u;77wC-V*ʙs]`X:WcYqLwHr5Us9W1|rst86x&a\rx:uQAҚu|F	V\"ZO\\OqT[{5]`_uu|2'{u|vnuEQ~T&}Wmn71{Qw	~	;5P\\6%:%X4lWAVNV<Rw@U O=Jfs5UohŠXGs8>8B1DUO~qVC8^xy>8A\r]rxZe0׈I:jWqKT{W?#WaQ燁NophGE2с[O{3'x}%QwBbb27p!srvQ-w4\\}WrцxAdEb8+Vq gTy:B>`=թ_ם\rR2XC+}]ut7,!KuRzS+@-`PUs-(u+YwXձ@u\\*ۜ7S埶[#|;s4	!@@a1PWzlbGz8DRT6X>6>N5\n\0q(a%=%ʠũ(P-4%\$oڙ2jo\rJES3qӅm8Dq\0:>1S'yfkrI\$gQCd_a4Fm*u+y4b\$qA	d}4'Kx|E6o{l\nT7D4P+=V4mG72mB4f2|ѪD\$;{GvSOh㸇Mp7\0`e#b.V<}**DjHO5>^C3H0b3xϻ	I'n[I9<=+~P]|P.Ppm'.&븦W/3xw{&:CءIO%T0|A";break;case"sk":$f="%(](!@n2\rC	l7&P\rl25q\$\"r:\rFQ\0B0y%990cAn8yj)AB&sLR\nbM&}a1f̄k01QZ0_bԷ  _0qN:Q\rA n4%b	a6OR5#7\n\n*8	!\"Fo;GA#v8.D8ܞ1*͗ə\n-L6la+y5O&(3:=.ϐ@1xȂ\$2\"J\r(\$\"<jhBz=	1\rH֢jJ|)J	F<\"%\n<9\n\n)1P),`2h:3. -\nn9fR<ʣ3\r4B@P7[0\$Be\n;\"@ؔnC\nEXEQR# ں*lRVR\"(C,Q\n`@!3:xc>Ar3 ^8HØxDP1̅|TzU-\r<!\n-5	\$4&M'Nȫ0xJ2:8;997.:2t	rb:J4LV93ٽɂ\n\"cp޿Cè5h3;hX!|:@P2n7Ԍ='J	0:Pyk!\n{t;S\rfB'40[\n\"eLc:%ȳ::uk\0᳸Q\$ݼ}QR6ᢟetC6	!BSOx6;<x]:xS\r۽Tl*0A*5nh\n\r`䎏7EԐ72:P}\\?*MjPd6ɺ#Cavj\n\$&Jjl\rq \$!<2)BLb<DKxk20sSA[&BTK@\\b[;¡[.`C@\r2Qp.hM(RȢJi:(E&!5&-è!#g2hДtp:õM*#1]a5:#\$/5 NBUB^+倰\"Y)P,՞CX/ඁl܆WF5,_-gm##=ʙ\n=:v=aѥI2.\n(=`J5vUXkcujK@10^߉\rin<0LR-PJ20M.FIZ\\Rac:!{p̽;FLĄ \"4޲*bfҐS\$VC0t	Ze~,i:>HK̎2.tBrT#e\"(Td-!z)<Xp@\n\n0)C\$X8 Ա&*rBL*Lth\$f.j]MG&63Jq9PDBih2*:q&dZaIΙ8AUfA\0FQrvlMB|9 Fz!&%#3Eաy_%T=Sk/d܂Go\r1l&NYr|,ɝ\\z!BZf.(S\0P	L*/@\rǖbk B7PQS0wZOtR\ndP\0Sr\$<0(KfRCz,(!*I+'DfCvMnB.jɤQ5يjTEJt͌r[aQe1\$a44tؤ6f(xOl9\"^ghThwBKm^;LCA)Ѩj(BҳwJr5NAD!L̬ĘB)FO&\"2uTu^\\nq';L\0#nNo2;̤iui/0'K80dx_-7Wb(ovM CBp\$Й_n{`;'7!R, m8f9כȆP\nfvdrylܽ&f.\\E]T60\"\\:!Ѥ[G,\nuB|?Mʘل@PF\\DdJS`U\"`WY^L&YP*|d\"!ǝlGB@xK2S\"Yf1r\"sé#LԠc%ӓȳn\rS\"=._߯S?-`ߚ|܉23\"\0a#_΅P2Ɋ+E\r]1B3iL>hBVFE\0`o)&&n>d3FT,b8z)eL;(7jkȥ+2E\$Fb{CV=\r`Qt>/`B,@oFI^͠'?d	lgfKڵ\n89\0<'.JbB	>B.2%oL6J0\r㾾*7VD֑\$.S%(P\r\$CPjypM;\rG.`- ,ȅ.펺Oid^Q(MG د^\r}\rQpWFT}m~Dy8PZmVU0=q4s1\r&*v2vq19 5qz8l\$4_,&.l+E\"1!R8!\$O*I.B;%6%;?%`NΞjBK;(̾2# ҟ(*c)R>~\ra!ƪ&̽IFQ>Bx݊\0%ZaM VVce'~HΫ炞9.>jL.ޤj*,\$*2da&0f^f\$NAse)Q)6G+},	-~d8ޣs*Ca91	9'739'9'^:s:<š/ct?&jb	b</'JUb~\r@.ofm s +?k&*PrM?;A3T'jGau	_α<.eBj׳\$7&aw:o/D\rbjEjK9N kl^6+BoEcGS%tPvqH#m<ԁF=@2Ԥ8.JE7IY=n@g7Q+LD7:BCM3:.:nM.79T26!OK)\"D4KNvHӍ;ROOJt@TNOdOAS/T53P{Q\r<3*I?Jhc\0@_s칫ddKzES&9Xd-yW>~#1DI'\$\n<Yp82:\n'	)\rV=@\rcPDcVVrt-@Dt#e1P:if:*x\0\np|\02H0V4DS+cރ5#x7b'(9c,yTB&\".FsԎ2`J#d'6e,JiDҀ.ó&E#39^	\$ABs.i![	^=FR\"K2-G\0+mcf:|-kU18gt!+o!L7X\\7'#F3d^;f@bq:urњ)XJDS,7@\nOgtprL6:-Ny&\"V\rwmob5d,=>iYPҗ1kqml/qcԓF\n\r(*&0:\rH\n\0";break;case"sl":$f="%(eM#)@n0\rUi'Cyk2QF\"	1k7Αv?5B25fA2dB\0Pb2ar\n)Ǆep(0#Upz7PI6AC	laCH(H;_Iуdi1ȋ&aCl2̧1p@u8FGCA9t1f\$E3A}kB|<6?&Ʒ_7K08ʱDы*PIFSԼU8Bҩi;L#.}Np!7c2\$B9#hXϿ2:V7(@	T<ˌ R~:sj Kx9,@P\"Ȏ2h:IDr<C\rk86\r2<+1|\rn%\r2c'T~9QJT\rH)52H2\r{>Ki1l7V>/@;CA+p9Xx(C@:tT6ʈ9X{90^'a926cH7x\$NʫpBޡ\"3 ĵ\nj#!6mB	|5qO+ĒM_R_\0ӄ`#`2`P'B\\.,ɼ)2P2\nsS6&yH:6s־ë1S2CnPi%4+n\r8&A(R\"\re9(*FXy630k7&-c\"n4spb1Wr B\nSho<;|:+;\rF|HŮk\\}\r.n'hHzEpdid93-8ÑSM'LBz}h<#tcm[O Va1lln2\\\$Bx5,7v <0fe缂#(Hڼ*S*[bg` c1XAϨuqAaC	َ!}P5JJUX+%hy\"]c}*yrJl)@Y-!ش\"	ȏBEnT	@b!TJS*Tbx9+5j߈\n!#H\$B4ޒ\"a DkՃE8rTg`!(Faє?\n hHC;+aH@18HF0SDH1FBa\nCHhB]yIب 0\r+Nf\\̆Y^YO)?%G*HXXECND!8A*1\$S1:kdpFX,B%/F pt\$v8i\"HZx8	'І2('T@^,\"N#XY<3m\rTQBYǴByFHc\"J:f0%hD4XP	L*FQح5P7\"+BD澚XrM6T1@܂` x'IaB\$2-nmDX1cvFYVʓ	^Z!K*:<^	B	]\r̳kqEMuDҹ1\"̍RM\rI9Nǐ3<`LT1ȦrD=2v@tU,!#vFP7nj_Y݉=uc&%vBsΒv`G\$L{xs\$djlXTtF`:<L!LB<BѐH&o?39ʄ L''#f=gCՔˠnDZW\"CZ]M0A7K\\t݂nFpL2fK-U\$Pes^ıpzd\$Ϲ9.XX-d)\$+5yt.(#,27HpISMƵī@\$T!\$\nϻ'8\\ZHB%EԒe_X/)v8ig@q 8v,KE\$NQ?qSRJkzOUK]|rKBD]C3;>Cy%<5Љg.PrN9bqu9F1t>BHun\"twwd \\R\"}a.mz?ɨZ_><%޹\"&OtًXO\$tc4C}xv=6\r}B)9i\$FrK@#OH\"D`|Ӈg&&m	}Z`Idȇgەy#m8\nA6|?wu7d^f» u\0h<bV8L<)F-x%ت,.p8Y]̸\\Ŏ,Т0-/,-ږB\"L/	*9<I\rR#xFf\rLF;e\rȐ\$P*L,0,'>FG@ԕGM0'\r0_Xr3	pb\\%9(\0b8b`|zx\$!(q.#5cf<N1C/y,\r106Bb,1fQMQQr:Zy}\07%o\\QNsp#jgsf\"b`!#6B	B)\"/]	6ɘԱ&\$g6)UB\rC&cBr%pLE,`o\$F(ED!RP]\re%\$+%<t&B?&,;&b|ҀrWQk(2qѩ\$'>K2v-*&N(&2XO&rl6r4\rc\rK!2R-K20FvMG+I//'\0\rfy\"+k+0]0̀\$mg-3\n1)>BC.ѵ3b?4I5L-F/(q6R0:cZ.\rdbv18.ɶhlbd	8h1i\"(S9,-nD&`OjK86ؤ(mx[-%CVؓ=3E%ҥs\"*~ü>R~H/\$?Q>5Ĺ/Q'1\"`/d-Rk/\n|4o=~Z,/FC7FГF,Z3q_F^1Ō\\E厺L\nr?x_EHHΏ?p8\"WG/HnaKcLb/KH2^IHk>IkǌdK\$@B\rCj\nZ3\$(:\"s+Hm#RRfQ]RB9<'UF1,죬X¾@mOBCJ;!.ol0DͫfW>Q 6RE .@-<mtWL?\\]l\n!]Bln.55#1#9C.O-96ц&Oc%R\n~&`a0tÚMC,X\"\nδ/Z@\nu4/.hj%,+\n\$4XfNaG&4*#S2LL\"4#OFBH";break;case"sr":$f="%)h.i4	|Ez\\4S֊\rh/PHPnv0G h\r\n)EȄ:%9>/M}H`(`1ƃQp9WhtuO`J\re;ьF\rgKB`X42]nG<^PdeCRFtɼ 4NQ 8'cIg2N9d08CAt0ոD1%Co-'3Do8eAZA)@{b0*;p&\0\r#p΃4\rY] s(>X7\rn07(9\r\\\";/9 踣x:Äk!;ƣ\"N\"\\:C*	zE<E-¶-н\"#JҐ+d*{^@51DK0jF9AhuPڬXD**L@2^@-8R6U45z'QƎT8ЧVG3RD=Oi1 l+Hc#1#*3ݷ,r1Gn 40T9`@`@2D49Ax^;ppqj3(#&\r\nѨ#x|2\rGYA,¯*77ҰeýM:	+YJ\"oVˡMƦۢZS:'Oږx0Cu悄\"\"ѽHiѻM=5(T2_Mz01 *jSO1a=b&0d;#`26fH#IKCDj?3N%Ѱib\"ˢpOI2k+Cf\$L4#L[/_bE-Fu2٣פ6D*zk0Z&JS/k*n\nTFyY9j))I\$/L*/#O ПhM`k!pt^ck&jǶvԂ B ЉB-S]:E`el,:VڻQlA<tKs\r`eD+C7;ǄG\0@Qn&GC\rɛG~\0\nsfq<D\n0A\0uawA\0l\r\n6!0nh0RV(%F&O.\n&b\nBpKd\r!r0kb,Mv2L}5d`NhY[ycE5HlKeW\$Brji?kJ\$vv%dXZN`&p0 Ęcݍ1܌sd,@H)	<XI\rD#\\vHC[/IOSVidSiDblZ\niuh!(4E<Y _a6\0q2F\$dҞʩX:u|!emZC.jz_FL,	@\$dR\0e99in̒xc3NsNxenI9Cw\n;\"L\n2gRs!\rZdFL0\0W q.&`m;\"lgb@#WI F)bkb!\0\$xFE _*Н#M	\n6M=k#u@(4!*J\$(uW\$& ӤË\03#@5)r伈1ʤy`BI:UJTGP	L*Yc1JJ;5y,q&-(&DԂn/	cE\"Q#\r2`,p%t`uS^3\0e1`innA2vCG\r*q&]<(^H܄P*[WB^4M\nm0*Lg! +c\0B`Eٻ>Tdmn\nXdba4\r!N-Ւ5aY\n`k-w:TBc/f]nxflFJAjLfsMǋrmNo,=7<OgO˄\r-Mΰ^Gubn W4OΑhO\n\rIp2ZlOV-CJ!:\"a=a;>~()#%;n)Sn3E!09PbC+\"a!D<.^\\>JrSwEŌ=օTBxB\0PI\rՔ\\m`k#!%|F)fRWmG	>ᠨvI8\nu1\nY82^TR)O΁bL\0zxZ8LY\$0PH2) '|!-O:|nn1(Vـ 	\0@\$d\r\$m];Dzdn&@fj60fʂ0J*LBh.Whb`j(?Z%D\r20h	Q\r#cK\r)P,RF01\nQ+2.XD-ïh*🭲]i1q1!,W\rU\neqaeQm	Vmy}5o:@Ս^F )ʢX.ez'J&Uq%?MXhVqZ*M#b#AbV5C|N.\"Hv[c*xe&xN@r-\$x0QGL<C'o\0x̀>f106< M?vhMN΢'N(. ֳ#vZz4q(#UO)'\nO+3AA*p4%aDzޢmK\0h1r'J5-R,Sr?\r)gWB*h[j_(t@ڐb\0{\$e\n쀭\06YPRm*kg,ŎP)+2\$#Lk(NY6`|Fѳ9St{n2\"A'q*DQ*<I)){9\\2a(S0y\nJ(i<j\"LU#p7~j5\rp7s]@H'ΒB1sA39s\$t)\rB'y.y<R7E>oE>OF2FtV,E):ty-@rgInKfN	-ET!f\rI\"B(	}>,TrM3,TN)TĪy8f7഼twMtiE KN2R^C<z;I>lN.kEQ3kg|dF_*d¯Sԁ:mpCBS5</T{TTc\rCV1G!zMoVUwHU~s0OU\"T`YKJL N<1|&,v3A;uk<\\3;5(aU5O9ʘ&?!uണY47/:=_uz2c98!n/&\0qΈ1'2?XF'pN=jIWHo6Hm,V&ge*Ud'UC_2=xUD6\r\nT;KRO\rcGkdE0*8#t*0֭lVlRʏ\\'<\\\0006FQoBKfv\0i]Tvh\"uop[a#q@SR\n+WBDVWguomeMspuetGq+aK25CsHZ<t3?c\$oaF0`ΧD	Jd'wܶ2ꗇyNhƕi%Qn(ay\$ClB;ЦLt*K}.s}rz},\"l\0jt!1\"Ml(@Hj޼D`\nZ,BS	i1k\np}tB74FLo,8fY1-Ol.	\0/C17<t.gxg\nOc/_'b0#%x5<u<}B.~4++*JP}P&	~HO#3X\$d)t1\0C!sP4\rS<ժz܁Z6޴M.g@S'55M<݄ރFhqc31*p ]o''.h0#LH >9S%i.؍.f@\$R5R\rhtS>Y^5\nyl`";break;case"sv":$f="%(e:5)@i7	 6ELp&)\\\n\$0s8t!CtrZo9I\rb%9iC7,X\nFC1l7AL4\$8uOMfSt7ASI a6&<b2\$)9Hd7#qu]D(ND0(r4\$U0!1n%(Ɖ:]xId3O\r3Dpt9tQN!ݾr#-+/5&d~hI':4Td5gb(ī7'\"N+<c7\"#̋죦E#μj(\n\$Crů\nL	è63C7M@=9<˫!\"\rh8C*҄3	#c<H<*)C&p&?,5ñH(,lD(4\r̫2\r:/I8LD9]!>JU\r?\0\0x\r0CCD8a^(\\#szJ;!xDlSr`7^0z6\rMK\nHFc:¸򭐖.\"p/-7`Aw\"H(7в&WO8]B\r6rvF :R\\c\$95Ve5B07ZcM#8.)O\nU+.dv)3X2o0<d(腧F4E6c\\E9BkL,mn[Tʂ\0 M4m%9t3I#8	#hᘹ\"(Yz!9[,Z6m,05A(6`\$C=20\"f:FQMv}ϐDKre '3@RN&M\r\0چ.Y\rǩ5J\\gXÓ['p;t6Rp	υWr}O\$C}ւKCX\rh uvC~P)=AA4\$,lVgM		RLU6TTj;xhUEVZ(bl*c d-?ޚPB\$ :`#:b\"\"5#a\"q#Tʢ褫)1[+	\"()1ؼRAo@>G\rQ	I7fi\r+ 93;R77/RviA\re(aJƝE ȫȉ~T9B9'.mzȌIAƤ\0l-82}d)@kH.0sơ3<Q\r0˙6LqBD0\"AГˋl\rѽM?7	u҃#!*ca#,d% nQ\$QFL)C\naH#OX0 qahzP!^9Xšdʍ!x&)t'+51*TBPՒOK\\&l+RT9aD3U&tPAOMI`>HL(eDa@'0Tb3 <*HQX-s1}G Rd=?`I\nmX \rIP(\"Ӝ%=\"Y\$3	N@2v1dő;`\0U\n@\"BI	f^p@xR\nP p|_(x0PD[R,.vL?cGL1hp˾\"FF#|9dB񕦖おRƭ'g[= @9h2w\$1+<X/gtXdH4gmʹt&8ZW#70Ӵs'@)`8l=\$cHq(s\r⪐B[tMĜ&\\ul+-㋛t3jdj\n	0}V`4y\$5YyA\r>\n6\r Y~s8ɬɓؚl!-P诚F'\n%\r\r@PEGE^<W 0qL!ZS\naC/4dp+\nY*HF6oyqCp	*dƐyLo+6=3U)O[Wwc^]^cI8K3ќ0G8vf2H%pB &|U+Y.3#&G0Q.+5g3sމC-u}qYfzXk6)Y_N1\0ٮWy-Qpxjq\$}y׬z?dmф'((\$`}D9㤯I\$Tzo4hy֧+ 	Ajux z0:ug|qqĻ|<`M\\~tkHz[pb/**r-\$SPc~6g\$`/]\0Nt	oa\0jKh4nG0HviNJNpBצj\"m}nƐ(0.c0|,ofϮn	~B\0Z։ibA	p?\$lBIؼ\$L.9@=ÌJ*X'Mh5Ò,5EӯG0*Ř\\oh[MbQBN#NQQoDQ#MPv\\?,\r\"5Ji4\"mL1RG1q`[nf8dT5.¾;<#cf:lbZhĪAjJIlDJb/P5-o`Ѵ5 rE\$~q\"-p\n 18qbEqm^`Ql#\$T2O'%\$.O%I&M&bm\"HNك-M8\"-&)P?u)B'#*q+`\r#K\r*Hɪ!/(-D--4!/(\$ҳ-\r/*N	2Cò&\"fDjN+1VOLy.1VK\\,QF	dl\"%]#^E\$0/PrQ\\;56P5R\\F``@ʪP&\0001x\"j~Ջ\ncB\$n\"h\r+q23.!ӻ;OP(\rG1CmFe.D͢X܂9n\"{nEYlʷ,Z%D	e,Goe66ƲICpxh{I7<k [E!EoL\r;J3[De0Цwdg>/D&K\r\r'6=4wACMb<bJd/í?4@7>PvAAl@4^q@o\$rG1AF\0U@";break;case"ta":$f="%)J::u>8@#\"\0p6&ALQ\\!_ FKh3Xҽ.B!Pt9_`\$RTmq?5MN%urι@WDS\n4;(pP0cAn8U_\\dj?&JGFMSIXrJ΢_'JuC^ʽp i4=xS/Q*Adu'c(oFe3NbNd0;CAt0l,WKɨNCR,H\0k7S*RޢjMY`,#esrʢ\rBB4;2)(|\nD@\0P7\rn7(9\r㒐\">/9 ;x\$9X;̣#wI@k6G\"I uW(R0,d\rØ7j*+]!1%n,Lk\n.uHY3V7drڱĪ\\)Kz0\\W+q1ezwv櫖J)ӮdBH=Ͷ\nZ̫kF87-8l2=u@)uLWbDh:a	;@@<orR\nh)R_9dMtFa@6f\nMilƪl\"֫\n@ۓa۷J*4I+qj8Jښ#A5kEy# \"LA8;:\01oU=\"t1Mn4039`@q@2D49Ax^;rW]2x7=ϡxDlȃ464}?MV=*bZv±SXUU+c0_Y䀫F@2x2y.lP*V-	VdҐW!7\$@AA(dE͍v#޸zi4W[U5\"jW`=sͅKDav!:WƵ\"8/8WunaT4̉` p;TAAe+`:i-qlRH'oƵ\r]t]R}KU\$x{l9b\0a<1ܐBL%z3YHFF\"HsP2ƞB*GP+\"N~ZCꗏ_FygF:c\0rq	GdL+Y03|.cCW)xuHt+402VP(	&;Hi3!ѡtAO-_RMו\\,A!4Ltŝ3V#zHL\\xavL:XݓA<Rj3O-FŬJϴ;e2V d2V\0s7pb\nco66vfD@@xn (6ރ4?3@v5ZAwHO(`',[rn(Тm6ҵi	H\ni.tc{Di\r!ܫs.mιBbfu&yޤZ\$f,3b4ץ\0ٕE@-\$+54UUW!\nyH	\\\\ba44Nn{ra9<mWeӇ'RUfS;JJ\rJh w'bq\"ekqeVy&\n;Bzsva\"A{o!K쌘YCٗ a` 1ldbj3%j[\n+*gDW(bCz:F.Kq,iQ\na8{<X\$ti.þ?5r(2>\rG5961;yo Gpq. }ChU9f3\$7 !0qU9@xf\$k/U).Qʿ,Fh\$p{	WNI&yAq5Kȝˎŧ:Ԫ{Fxi{񲍤+9Z*N\\錒)*_6Z}-QZ<eHy:=nL8Zp m\r)M8n<F!UH%O\naQV8ՇAJJ4lgg~ȋe~k	hRhE\r6<;Few:Diru0rRJb)ASdq*i=M;q9\0Asr(*ŧz%ţSUWO	*\0BE_@/HB=a<nRا(vpbabꀍ\nFLM\"f摥p_/ҧ|knxGD*X/^[C>!Za.)jRjnJ^0:ㄘhj	fȮpx潃y̢biHtc	%o4<wԌlG\0iқ\n<hd)\nb(Z+K޵/g m\0?CdVj\$\ny<?\nz`鍖 t#L2*wʨ`fɹ%bÎ9NV(\"J\nG(r`\rHp'p ,	 \r ʖ4k@Ίmm)@%K舲:@ϠʬNJL\0jV\ny,J\rȄ\$\nm4@´l\n(\$<)qP7i5g˃O~*MXϲJ	 ܹ%?\n)6%XDB{\"/\n\nm&DpC\r0l` rc;*'s{+N	J^'\nJ0h@&kH1ކ/3p\"pBdfY6g wcdCjb2\$P2	\"fJ6lR0'\0 	\0@\r\$NO/S8**F9Q:I9&\\,P)83,F}Sq/:pE(}̟h\rg1=E;;M3E<>p3:FJCß:\n1]@NF?%.>2(I.,3-7\r-Ct(EI\$3Fs0\\E3HB̍C];<ID8@'BEfNjDrmT8¥-E3IPKM\"V)IfRFU)J\r)k%6DS6EQAQ(TqoMv6'l\r)n*@%uS̑zUJJGNk>T\0[ڿeYTg=KV(sܙt&\0<d\"ltC\n5E\$|B0v	SYF/sD7sLRYux5cK\\UO\$DԨQWI*xtu><w\\6];+tXe`̧aGs~4TU`_sb;v1JH)(,i VrЉ'(x|Xu2G\nFLઃ0AR+U5c=rPʅUӯ\0\$9Zrb A>{_7k:ԖXM%\0@\nN p\rT\r\r[p QqeSHDmVwп3s0P\n]1aPyF~e3B6\"EGV+s)j,4uqZHjAs7Sm6GsMvUq^V)dS4/`Qd]Vydu\\wm557zP7ו03l=bvC{1lklmPp9=xW-\"fQ>I1c~\n7~7sP3P-tR~W(W4.\$+J,y#bTwWBM=;(O29afׯ^3Q~}3Rw'4'Ъ]O9'aCv%nRNz5rkz|[&suӂ|ͪMl-\"+UԾQr)n,+D4RVL>\"Fm*h\r<	k[2rq6 \"XX~8}xXk6Ia6SIt\"xإ,-0G{pW\r\"N;\"75d{!t7\r׉GٙBXv[|_-iFv?{JE.,hx\0;#`~wsv\\%9RglŚ6:\nhV68cuPwzFM2bX:|h#zKe5.7yX7a0BR~8<\$d-IjImշNIfEmX}c؏z87wuCa2(uuL]qNݦxq&M\\T3{:rTd&;TxcV%k=V␶{#yìՒ|[E9v=YArCg)wWOmxؕXz_aY=mS}Z{/`4:ś{h8Տ@˦+ّ|zyi([˲{Y[-5R;\$Vmֈy{;C̛lMU)׾.*v)Ͳ\rrWJسqzM|+a/<3׷},USzqû,<,\\Yiě<joݧZ	&kFaGědO3=ty1[4\\ٮaW	ˀ}w<΢V/K-X98)J*g9d'+n3D4v/W?@{{7aQe%'JdB5/ӘeCӑE]}{l֨QyҼ}2uiBuN504ޅ\rV Ӿq`@q̱g)\0֌t̍L\0\np˓qĊ)}yt3z݆Tgc5%k,xp\$&\r]W;̣pЦ^4#;4Vj`ܩ}-IQE:ZwE0?jwf>hZhYe=i3T䰵4%`Qlrf?̼aIH6ڔ8檎;Qe5c^\\ߌeJJ\\(w 	s~AW%q}uGAm?/SB)T6̤|ui`nw\n=c;L\04!Cw>ZH0aiTyH'or_ѰeecUJm_չvEnj˅X?\0@&ہ~lX`͘%W|AJ	dmqf=)\0e\\,ͺ3bIe菞}\$¼POJV3Q`:>sBo>(gu/N4ťX\rh^tmQ*Ursٗ)kO\"!U%F\$\0	M";break;case"th":$f="%OZAS0U/Z\$CDAUPȴqp*\n*\nW	lM1\"T!R4\\K3umpPUq\\-c8UR\n%bh9\\EY*uq2[S\ny8\\E1BH#'\0Pb2as=UW	8{#+&\\K#[[=-O5,%&ݶ\\&TJ}'[AC\\k%'TLWȽg+!'MbC ɼ 4NQ 8'cI3@:>2#:\rL:#-ڀ EM˘a9~NsL^\\.-R\\\"CCEÚΩMR:()E<)CH3srR7!pbLB5ø7I#|@9ÄC;\$(θ(34#mSAJsت,pA\0b)>֪m/:\$JR\n;~&uU*9l\\S,?#NDN\\MGR\\Ə6\nH#\nj&4ŵ̝{8R!*L1	pNY52-SR<+/օ\\f)i_H.!؜ϊ8؅P'VŶeJ)7z)zx4/cWzF7ȢR2\rP4CQ9P1#3>S;0cݶu 9`@n@2D49Ax^;pðlS3(ѣH\r-#x|:RJ3+|ΩɃX\\铎TKS{a2I7=nzfLÑnW쳺\\;`P0Cv9A(A\r!씂#ȗF1H%	#ʜ#.IGgu/4∅*d!hO	݄ GClP0W]>[iLd&h4bh#2IN9ZdAҬ0WEᄣv|(MJ~D׼P(gtJX')2@\nI(#C؀ЉP0 A`ND0ߍmDGoedd[k__;f^S\"Q\"@evd.%aJ\\5`x-	<YxBB\"tQS;Ch}*\$^hBsa1tt:5[Ta.Cv4yh >X@-,\$II:3D(oGdan,cbBUSC*py֓VC417t0tU(0pEhih:PM;t)BP~/\$ŚR)'PCKnIl5t4Fq=ȹ7*˛9B\rт }h][\$)H FtW>+pRr?MjѪI)s7it:\\Zp&8 䜣s9烓tN:*Oi]XI\rD(IC[Q֤_u]Ya0<̩䭮v\\Phݰ oC#0ksptFCJ@xT9پҒv)Cm*jȱ#\\+<eTvd@@P\0`V%N2yeQ(Pb0s@g+ma po\nL~l;\$HƠlzuu	5(sA7\n]3J܀ H]n8=cJ\0C\naH#@\rj[@3џKrZ.0\\LNINF [я@[,[\nBKBd69#; -ja\$MDEA\$d,nPÌ73'pao3ci1D@<DeD;\$f=\nE-\r4\n2\$K(\0ުdAkPrDtsq'恪nY/3 ?#L#_ij.(nzG<a2E~{ ŉU&p \n@\"|?&_YA<@/Qu</xތ#6hYl\"W~ɓxdd'vlCYg-?047ZZl#j^)mZ<lO'ߗfRz̏Fh&6/|e5)jEjiTD@MGa2NawD\"~(XI4h*ȴc'7~4MƜ͞\0FD/\n`HpK欨pKx@\r6#^ ʽP\ni͞JMGM*+A\$Ǌs?POt\rr?Ld,d\")`|IF^dC\"W-%JIHDΊM&HgGeir`qpR\rbz+3V&2,@c\0̂%Hf.FEH-+qEg,xh\$3q(ͺiOi-VYTSN\n`lPmEЎM~͆^0D\rjú\\FTFBe &yoZe`XJc#aR>-/cF#DKVy\"o]#ѱ!m3RV-̶ŦBva#P0h F]?PZ6[g+SD&EЖѧE|gd(:F>A&J\nNPV(<bA/ZOZ4G2G,±1/úֆ@:JxG-yBp:S?\"{V:&IDY4R9Wp-bd-dc`HҠ}H5t{~)ӌ'GԶIa8Q;\$38ps:S:\n6\$&B~s4s<\0	~p<BO3Dg=O]/̑Q5Nxg\0NX@~'L+[DH3<sBapb\"5Q2{iNC)@1E o\r\rl\rL@=\"^S>\0	@Fw)FSc;#T-e/Jq]>ŨI>	Q@ox`87=EKdMt@K3\ni3!LYP)\$OPQROR{7Q3DlqVƀA;Cs@2c\$\0003+RB)ZB@b%(пKBY/]MRRS[XhXBJ549C;ҋ&nM&C\\`AeT5J)CyU{:d_3cEԗFcTM_iW\0H]́EKuTWWUZ|.GZ.;W<[=wA\$`JǴ@TAYuY3ZGfeXTSvzdU_ZSeKfodc9sV)-	h=\\\0)l6r=NvkRZ8g}vTYfljkGiJ#'IDaAo)ì7۩6+G3&Rz-qm%j->@oPrP'>CVTgnvwt=ttUmv,W[IN	\n\rv/cNoqwʙx4T7\rysab\na]QJ/;	+[w>~UJ}\r1mQ|o}7iSuw~~XYgUh7~Հ~uL({֮7qf摂h~pZ3nEwcySNa%.vf1PT>PN`A@RL8l@L<tFM%gXr\\AX}GLOP1T@/ӃLuWwWEv~X?8Cu*|]w8QzN*k6oKoS*UR8߀되^bRlץoWcJu	\raȴͺ\"`ļTyU*{p2dy<-Ag!Fx{rf\\q+^U]<US֫)#?j~X3)\rr@n*\r8j%DQ<{')mV\np(2LZ5c:(5iLe12`NLE\0dSF&L@\r\0H<;é]ɥpC;vUqU<ESTAC97WD`	nuhA!	PWLh}ȗ#q :Secv)mւjyȭ0ᙂJw1/cpڞ63gJX`\$>#\rf\rpnFF5iDWeBFu\0005u(Ȏv^:Ε]H`#bo`w3Ee.\"d\nHiC*5EH+	{(a=im<ibcBX3>/0&q;NTJZMd<}=	 @Ї'DPe*pDǽH5C:D(( 	\0@	t\n`";break;case"tr":$f="%(o9L\";\rln2NFai<BS`z4hP\"2B!Bu:`Ehr2r	LcAb'\0(`1ƃQp9b(Bi=R*|4&`(a1\rɮ|^ZɮK0fK\n!Lx7̦ȭ 4k|\"tit3-z7eLlDa63ڜI7FӺAE=FqH7PuMn7Q#j|aŘ'=sx03=g3hȎ'a\0=;Ch6)j2;I`҉\0A	j%H\\:\$&0@A#H :#\04B\n(ޡS\n;IƜB9Ãk:ê!0XB7\0P{GxҲ	;4=	 \$σ>#\$9p!pc:\rzT#9`@!c@2D49Ax^;Ձp:(\\zNүI|6MjB3#Qx4!^0Ɖ+4#Dym(\"Q92ڼ(*5<O31,U7BL!PTL\"XM-@08+tj#C'4PH{DmnvN֯#-L,b43%8Ô)fd &\r(P&&:X,Pܽ+@Ÿqx9b	Gh0c[Y=B-xQO\"x];纄\0x>ӫ)b,.#cn z,Jsrbp8!n[^=660b9\$Pl6USH|>vIc[\0Myꌣ87+h\ra&6>qp}	|;a \"y^.YbpNWr#ɡ#A3PPy]hGvzM,M3Fq8Q\"\$L)@TT*XrmZ+`KX^\rŉea^*B8nCJ=Tl/3!9IMQ-t.^)AObEE⟁Q;@`bF')jg\"4HT*RuRjJ9+Un^݊9Vs|wJ	\$F)\"+qs>g\$l&8Eсm6s.`g\$NN'бD,7)k1r>f<\"S\$Py\n7 g]H1V Ƞ&>A;1u)]-P//+?1hJc),pOR.Ffj=rAȯ)5tٛa@DDn\\u٠cEd\\3BXkj 2u<i`) DQ8!K2P ԀzdM	-zO@}#Qt@#}\$HJPLAA11\nP *9zCH|C(G<<Ìh2ca~/1^P	L*&W5#s9@&@D8<2DIČhLpG0T5@z/-)P,U9&l3~}EAӈЭ6>\"	_m9X:I	8PT@\$A90`\".fQ +\r.\"Ę3b.\"NF\\f˓v>2\\J:ȉ<[\$ Yrʳadrce}s!#̱ZMp\"Jc+˩dn@8w@\\ΤX#uWoᬽЉ0W^t'-OԞq6oM'! b%2ysZƻ'<Y/5avG&^si:Ƨ8sR&*{\"	:ߍIKtm8(.!QȘt>1!Û#zy[ͤq{q8\"Cፓ%byX*45\n9AG:ĚpHH,pzn+̵[@Ac2L:I9j:Ȏz5dHX0{>B؀j\nK׳dlI	ONS?u]\$g+3TG\\5]Po;>/^X!M_x~x15u}^,{EQQ[_#w9Fb\"J[(bO֮22[>Y;I,}sMN2Z9M\nčC\\/-*7jT#!2C(ԬF*֍\".sc0.e^kb'cF8B\"GG,Lj\\/X\\70RKZ)0dr`N7픯Ў\" L/r\"Rw\r@liÂ9;mpP/\r,&p/ԓlt0JZ\ra	JoHQ,\\vN07P\"h10Ar:t_D0&\$6rV,k:fqj/Q'xQ}#C~lD&D# \"-VETSQT8\$LÞqX;r7ѐA/Tz,jn\"D8.T[q,ݭ\\QrϒH!P \r;gfƎ!r;	p,##QL\"9\$&1\0j&döħE`-^p!o;\":KOQ#R[\$q	)2Q\"dL!%JZ,^FJ;Q Rb2J2Š>jb8.2\"\$QJf2g,\02=sz'.\n\\n3,48@C<991\"N'2j|?<s\$:ܓH3Dz2H2䥎2!\n3*3l\r)7\"7`R~;rVKsK.72II|{רZr^i<@c]*8΁\"	=M*rR\r!Db-EsIO^CW`g++\$]C,C6\$C^Zd\rVct\nZ(ljBB1F=>Tm>jv+Gmg&^9\rCgin,D\074.QId_⒤r&NK/ȾJ:\$NDgu0(e,|]1l,Og?QCξ\"i3uPI7Q!n^[ 	:GCc>i\n:P#\rm00e\nÈa	X55Z\0/!o7qXjs'&TMp\rPE`gΦ#/@|b\r`hodEAfc";break;case"uk":$f="%)h-ZƂh. h-mhĆ& h#˘.(.<h#v_Ps94R\\h%p	NmcL4PҒ\0(`1ƃQp9\$&;dH5}Q\$C˩ZB	D8(iyA~Gt(ygY1~Қ(BdׯKmJI\r.(VV1>#\$:-r%CǴ)/tp^\r>[73'6SP5dZ{h>/Ѡz0)28?v(P|\"oKB\"i{* 5ϲ:㹉вH8ޣ\"JBZ薉(F)ZY(\$&Y6,X\\Nz#DZ9)ĵ+;DLh1(3 (1@ݷlhQɠMH>K X Ě!аqQ&1d3WH\\C%PnTxH\$D-hU͋^5OR\"\"9#:hƁGQ8mn#NO*# 4(&Ԥ!rްX_ܥ0\\kUsɐ;(~\r3:x\r`Ap9x79cv2Fn=,@Mn;GB^0jXƐ/Q Ѭ+\rbe^V8<\nvxZnz	\nO[D_qNliRI!7`PJ2biZBʫ\rs5hZ~H(5h|\$`K ąDUDΐ':)Y:%<N3u^j\"Se#Yj/pf<Ǒr\rAS\0Zޖ|)zP8FFVTz\$,bdÛV.5'EJ,4V@PS\n!11hA>&IF_:НnB\\1%!DBIUġ35b<NX+x[*S]HaM2[\n׍*o\$+\$-hj\"((k0fҰ dM-%JZP&=5] ÛL!q1M׊20II0Eb!RQ{\$NĤqi%&A@)Y1'F[T0uG\$eB렟9LDTEaI2V\\2ȭC4&T'5M	NQ6&\$6C@\npDj\r9zqCӨN#;DCY>w5	mЩ7\r!ӕwiқcsD9Gf4PO4bu]&WI&E4DI<MILذQ\n_9&yK<8Ӎ2&HəC*e3&hͫ9glpa4Elh,Ea)<FDIT2#+4L	J+aU%DJ/RlO+Nha:b?|İ;6ԊAe8+s%d쥕^Ywf޲3xϚ\0eџ;TICPU5jڪ麟Yil0Ksх.jBi_'Qx%UnDxPim󾩇'v'fPOsRٻsڴQIC<<;y,̲BF,@*PP	@ㆡ,ݡ9\0O\nU 1)\n \0_L^A\\E;@')|<]1,JhyƆ9a70ue[r\04ɦTI\068-CDGg#h2JS!0Kgv6Iϼ4.JmWGUP1d>ykL&moF,\\R1X	\$#uu̥PWƋԚrBFĆV&qYlZGRDɚS=}2:BsyxO\naQuCaIW%bF ܯFImӣ`\$ML D9-\$uiON\$Rf`BIڄF\nBhb4pUB-u!TxeQT[LL\"7&wBn3#mت5uep)EW#E[F)?y~	EY~DM3\$>%!1bIzu}\ny^qLAǗLG\$Q&7jǵBZDf#6;fFz>_u-BșKDⴘ)R\nBdEMyNViNCRa\"Fl(PFÆFm0OzhlA\0I(rmc|~6fL\r6P脩ĄEcÀ#D&g;\"zS=*	 \r\r `@\rڋv'lOn*ЍnGD\$1\\\n@0/NC/&2[OXBDr14:D:qЂ!DGT6\$^̦&6*00O\rlEh(Mޅc]\rwZ\0DDB\nCF59(Ⱥ0Yϵ//jWI.\"U\0\n 	GnJd\\,vk*Nm-t,s\0^-4m'tt#u5aEQ z(bh&;J\0Cy7>1 GW 1 !G	2\"	\"Y\n2!#pc%	!%;*o%R2²Zϑ(K(/(ī#Mn;(2p6t!ң)6!(ʀbm\$<r QV\"F΢w vx,/LZ<!j=\nT{bPR͞f&Z\"(*>&d¡n0R[.}md\\iRDq3HZH*d&p|A)0% 	v##BRr88nk]ೕ:8?;0po5;)<0\n;g:o4MZ=m>A甝zJ!@zpx6+Cp2~/c<Lq@\$}\r4^9a9(vDbD w\r\r\"\",\$`F\"Fv\rˮ\\\$s̙Ӿ3ILc4RGZ8TЊ	Jo'hϔ4T5=J茛U8JE4<(WKZ5OTU=4\$\$\\4</\rhLqEQ;QRAD\"(o0.2R5NTU\"H'QQRф(gSGE*:CW,풦M[S<X:!5X!EFY=PfPI,\0j].&qPbY<M%6UA]^~&?DD-)>*`Q[#]ؕ3MPDq	Yu[SU	spSy<5%`-HoB{Z9ՑQ{gAiZpouʩ;!io\n3Ihhl֭g_NָPVPfj3AlGvl>_QSuE=&gP1\$>o0l,q0@g]UqZ4EKQ}qeSirWWih\\epvrr#m2N&WSif;riEE?1ؑRQZ3hrQZv<t,wgdjy3XAgVazl{qM?z7z\\V\"g^(@v[j(gcdIsr7qWsb7݂x\\׳Mm61,g]E~igq[VQq2aF*TуxYpwQDVGR [1ؓydq{XZAklEEJ?\$	d>[wwS\r2c,7RH'2#\\*&j?Ts	btX	Î};wue7m(\$0K!қX\"79VyK\$JrH+_2ji~\rV\nq4D:D!sWno/V6hӮYA\$,\nZ\$2flL	\nLVeUcn!m).E-GMn~ Lb ǵ5	\rx\"75\$ESxEQ%f\"i@m|yI3cȦ@R}8RM	2\"=.[,esf4aD5^D٥SeZU?Uq(Ei<zkB,ጔY3sV~V(8è:\ra	օ5Pm/CHRī?s*/a4c#a5GnQ8cYApIһ@EpwGz{S_l6rAʛ8yiPn0ЙLȰ[ܱ;b ڪP9V4GUsS==\n%VRx\0";break;case"uz":$f="%(a<\rƑk6LBNl6Lp(a51`u<'Ai6&%4MF`B\"u2Kc'80cAn8'3Ac4MsI@k7#**''3`(;M6,q&ƙ}ģ+77:B:\rW.3b\r4q/|\0(a8ۍ :`*{VvN-o)dgxiw7MX('b%Iyawu:D50K82cz(\n2#ؗCX:\$VL[<&{♺\nn*2M47csX߯#%ct\$n5L P2)s\n</s&c\$+*F6ј1Lr4BCc7+@S ޑ#;Ȟ\rhAPsS@t\rAID3Њ.P\"07c2D49cx_)6̈ġ|9c\"2|-8L4x@/O2l%:2=&KZTȳ\n,=&Cw;˸ȼ~눲!(2,'xa8&L<N:D\09=9+C,#79;Wи:CF`3C*d:\$R(('#j2FRn9L\r!(:!* 7@]m;f	\$	\r67H&J(<8O<\rJ:?9%!;'!`=F/S	)s6%##}.K.u<!uHsQcii\0004۶I@Ea9Øݴ|а:*D́reYcG(`S,3Y#R\rb1M\\jM39¸_#5l8fAc{BL}0NnD+,CRa}Ƣk\r\$DzxRJ ='R:},¢bϑ2%bhC@V\nɦUnUڽW`2ı2\r2VJ4zW{t\$3PNHS2KҐjze&J@;8*T{TS* \nEϏ\\40é3lW`,)(rX\$2IZOY,~RQXBʰsL#g\"mI?dm9L!Т\$#sv)bȉ#-(kjhIT*/	\r4( (i.r|\nMhe,\$£tR]L+NF\n(Ю*\"NJIYM\":}Y'qH\0a>2Ql#2J9-\$@vu_PZFDwLNH{\$4:Y@(^g*E\\W_Ep43) 	(|bm,ɸq'ہ~7-@kKa]!\r\$P-b!%r((k{@:dd?z@n3n%Ie]5ēb\0F\nXCx9q#^FR)b0'Erch,HL@y8C	\$)bXp\nd줚'bxLKO;ݏ\n\nhHuTZ0^di!\"ǥP\\yA<3M`|VUT\n\\5ӷKe\"Ip	Pg#ˉwlUt2	\rOӒtXR\0HAĭ`H֛*MN|A:/N')t~#],	it@PH]1I0Y[bhdѠ(96:\nGU6;7FuQqp\$aZ5S;vF]}:fHn@ 8Ɍ40Es3K6U;S{8!ƏC@aC8gM>D_xa.!	Ԁb'' #Jzp()C%:w4\0Fk:W:T\n[u2R}B3S^Y/)̎0ȊOm2)[D5QCL1&@H)	^\"g}{^=l2\\y:epY':P1FgxWYnw{0A<),\r'C*7-`SbnM%US~}чYc<)(,Xg2 ߃'oh<7nBvctb %;\0 bC>fP\0@*m`ׇ0#4x%)).gG>hF\r˄Bx-Xib&\\\r#?L|O`e\$/0P;	'ƍ\"b\0 d?  IL>H01!έS\0nϭ\nB&Pd)'J0:y~\nghBD;W\"rg̺&Q#\0*O	\r	6`?\0	8^cubf@|5244PnǴ\$sXiXj:Dqѐǂ}\"BL*cZG-66I:\"\\J(<oI7l<	`'@cNgM^JG!EPR)!n.-4#bU\"Q#!?!͂?\";\$BT߱XyRYii`ϣւAM('*;D-lR/M)nT(&]'*\rү!*-#rjgQO\nH@Z\$M-3-].2P].?HR1/`.\n?\$0S	/=d.P(\n/3\$%2n*R N2i)#32L`N@>CJ%-4A5-2m2u3c5d\$<K)\$;8/+)9NsD@f4,f2,(yFF+À\":84-6O83ܤ`ش\rvCBz=<ʑ\00006df0sPhW3J5h`0V\"l(`\npft+\n-<\$w]>86T^gFP*3|):*drN%24!94t' 0m6\$HΖF<kP(->D<n,\"l@o0Ǉ\r '6L;OjN`?P4\$D4SQ\r6C\"cu}1StgƬy@PaΏ\"'\"vv0Up Ɓ~f7?] QGR%4.6J#?K>yIpr+V.S4T,g;](guZ/e?<hHPKR ";break;case"vi":$f="%(ha\rq]Ҍ]c\rTnAjhc,\"	b5H؉q	Nd)	R!/5!PäA&n&0cAn8QE\r Y\$Eyt9D0Q(Vh<&b-[no\n(U`+~daH8iD\\Pnpu<4k{C3	2Rum]/tUږ[]7;qqwN(a;m{\rB\n'ٻ_2[aTk7)o9HH0c+767 88@@ \\j L+@ƻl7)vOIvL:I枧fakjc]/P!\0d! K P k<M\0\r@h4AN!c3(7\$Xb,(R-2j]2<!iJ NA1[(Rf1B\"\rAZ8B<&u=SI#qtI>(0P2\r<9ph#n\0@C҇\r㭘B%\n\0x3:x{\ra?/p_pcI|63?k4^02T.́BED\",9e9):&Y^\";\n7ZH(J2/C2S)cs2R̩JVJ\"!7\"]q:V6qJćeJZ7k,2 JGV\n5Hƈ3Q7tWcéVI~;U6Ê4J4YfBΓF\n#TĮ@-џR|[46'h(PCcn\r)+uߢ\$\n)C4{au!FTz~ص%WhUH*]RTs/5ux %JaK:V~>91C>h3,t~J6A@	8nZ(C)\r\$\0`\r3*Ih;\\F BnEP.)],\\ Qz^Qfi.Hn2T	3ŕx3@ @WK1@u޼W^|4\0`A4N\rL¢B&~KQAC:G4ċY3oČEғKuK\$t.ػ^|/2}er_D	&BIfmOd9SCNa\"[ȹ{Hq1B@X-IfhMd, \r'C:FԘ.@fԡ*.]Sצ8u['p&i	wD	%|D\"xw8 vag hb>TycHMCY\\E	j:(뾐Ӓč	!KitA5zaH#X)f1&4Ыec6i\0(;(v(Msrsj-DȚ6BI>腦mRu\$\$0\$74B]Q@\$3s&9+\0դ+2| M/\n<)Hws\$LpjĘ\\XK݀:M+C3\$<R3~Gr\"RH(!p*ζ3dҜE2ti-b^f,+N ^EGB\$yQ+ jgF\$X\rE)w8I)>12Y;'zzdqv\"m(YhDӱ^h?#taL_(#/L\00*:G04Uzm(bz\rPLܓsٟwY\n^#\$7Z--\\Ãg95=N\np%ވ#6PكHzgd2s\r1W<Ã]qYYmC\"㌒GRDjCYl3֤Jk@T.H<ãQ_L;ŔU\rpP#BK릜1 i@()-ҁR:oe^LƱ<aF|Aa\"6pϐX%WzXxRX}2082!}@ dWĖ^dbg^]A)ϐXE(,'VPOGY!\$1n	6,e*;nIC-o<PIdKbJ!\\LԮTb~u#7a%#vot/\"V.̢.~Fdl2KrNJ\09Zތp\"KT K#lЛ I*cbLC`0V{H8!J&klX+<o6a~#-*s,1	Nn#bt!D+@5(&rD6F˦UТFAZ\"|ЀC6||\rzmlڈNg\n2GJDdNJmGD-\r;nMGB{qCG{MQ^bQLyn.ߧZDO[ń\\O\"h2/l1h<dMWy0m#5B ˉѷ|*Fk.c7G殡Ekl\\VCDLc̬NΆޫq#il	 0fd){[f&grA%I\$FG¯BNGNdqkq(x1c'#(2Hm)r)F*/0a^A/bpCD,\"p\$i룠eEY']n(r4\"XRdb#'{o1G.q\002/OSp\"5H%ЧoD(r2`Eũ3ԑ	4|STLq[M|Sjre 5M>֔d\0&=Pd+8n8@9&̥oJ:+Έh&XgE\"4nU<'=2}3=S=5>N8+Qeti** Qe@3dQ4ﱚp:N|J#cN~#V0؍DWcrF2h=p,X'P\ntb*Ա/	8bФp\rk%4xs\"B6/p4R\nZETrT4ep\"Gr7n}&4/&!3	I!6&hmF8j	7@Tx6BUR-Ҥ\nlw뒾s4;CDdbCUK&mFf\r@%U1V,l8boW!edPXoN@&E\r0	v\$Qį\\(%bZPpN3[,H]\\AroXvMKL\0046j4Pa^0ʙ,U0pE<4I#&d:l \r>LI\"Aj3qAvfkCD(`";break;case"zh":$f="%:\$\nr.r/dȻ[8 S8rNT*Ю\\9HHZ1!SVJ@%9Ql]m	FU*qQ;Cf4usUUt w:t\nrU:.:PǑ.\r7d^%u)cxU`Fjrs'PnA̛ZEf]EvitUλSծ{Pg5	EPN1	V\nW]\n!zsΟRRVI:(s#.UzΠ@:w'_T\$pVLD')bJ\$pŢ[MZ\n.>sKAZKaLHAtF3D!zHC*re^K#sXg)<v׬hE')2Anrj\n:1'+ֲ2izJsͲ h7]	9HN_esK?	RY4=DF@4C(C@:tT3>x3(9I|1B:LΝ\$=0!tIE'5(RMy&s#SE͒CH]K:KC%um0KV)\"EA(CGAFpܗ&fTYCG)\0DGSW)\0^cTewa D#8s*.]\"h^9zW#s\0]c9a Dj<V]2gC\$CCm8)\"entI4}|=3Q''1Q,g^nKsSL̋&eȜ:ϿC34;.Ml`#@6S6::=9CZ\\u|!p4Z)M=?pA\$_Kz<O66ҙt_No-6MHX:+3.~ɻFbt\"\$r!bJՄP~T]'@Gr[\0 @\$\$C1v+ʛS}P5JJUX+%hxdx:2°_:X%PQ'Ea/1ir\"&B\rBoM ~pOrTJS*Tb*YUnCtV'+uABV2>,E\$\$W1,\"r,E4H=I>ŊH9kdvd\$?M#9# 9t,Ǩ4zZ) @@Pz\"MQ-DV':HIAØG\nTf,8o&Hs_;0hDM#bʹ{mR NAr@a(3WT&(8LZ((-I\0PP\n\"\0C\naH#.)(#g8/I\$V&.FR:E=9)%hhs\nj;?ca@+\\p ZлНW*RdȱQ4G4\\р\0£RAOXcHUt*!Y?l 	EL#@CȈ&	8E@OIy\"9+1dϣR	c(YP*[s E	a/WE`LSA/DMBsFQB.QwEߢ)0t7gʅ2Ş\rna#/-/)&dF@&g@DCOA^|\n|JIas4GEʹnٓ3+n<ArV\n907Àl=\r:1;>t/vJֻNx] B}\r!`idf8E.YЄt]	&Ptg	\r\0!CS02\0ǧ^q_<Hz-#EpM&/ႢPs 9&Í!0Ip##erP 09F/p`,\r&ܢlM#4Rx\n;C#`hHMD͝R7.;<v,l1|g1*^d%\"\\(U4vXLU[ԱPW[Qn63B7J Ô@Zͅ؅j+ypnZrsez/tt=_Yͽ0~*fkY_C܅rݣ)顗~hTDm?G\r\rГ\0G1\0\$'5m+W\nL_\\xFZ]:'B?M/a6ueFxh6xg&\n,\0S\r=_A2	6{tC<y/\nW7#аgdl#d!gk}98{)i6ͧ\0N'a!I\n>)bbH	%k,DR+F!aBgc~App8pPItBܸ\"6гke/H/9|sLEM#/٢}	0]0kP--e.CJ*P,(Mo\0ha[rrTPmOV9A6<-a1]#fpa.9S1<^шӠ6W@@@V@\0\rѠ'O-QgMf\0ԀwX@PJ]1Ց0-h4FqANnpDFDq|ڡo!с\"B	t i	#\$-t߃>F-^.F,w%D\$8\0>,g\rv~p 3\"F) NPRC\nZhЮC!deJH.!6ì6̀dgʳT3\n1䊪#\\J\"ZQ!5BF-4*2fM1oҽ+MAt:,FEB \r!d,#G3C\$\$3B9{4'\niJ>=Ʈ9L>7<vCo8B>(+Dz";break;case"zh-tw":$f="%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	aJe R)ܫ{	Nd(vQDCѮUjaʜTOABPb2ar\nr/TuʮM9Rz?Tא9>SNeI̜Dhw2Y2PcмW*=s7B9J\"XQ2M/J2@\"WrTD{utspS\\=\0Vp\"R )ЪOHΔT\\ӊ:}JF+JV*rEZs!ZyV꽯yPA.yZ6YI)\ns	Z̢[2̒KdJ12A\$&Y+;ZY+\$j[GAn%Jst)P)<?\0Uw*x].2ft+<Kd(A2]*X!rB\n# 4(tE\rl	Tr{:OpbJBO:F@4C(C@:t㽄4)Kx3(9PI|t(B1֯B|\$	q/9H]D̸et\\K6?஋LQ\\1H@PJ2:@ea	&s2So1Qd0ם3Mewd:<C)xGdrBHreBi^1I@\"ZP@fg1pM	j^B<JLf*83(ڰ:s (&^)Dr\n淘1(\\մ	_ܾ7&]>Tt734ҥr</hCHHs,o7|u+wxbØ@6XU:Cp@09#uW97H}U1	~1KTNFQ8)HTKPs3cM#& )FGpXa*%)FG4B',a\na\$\n0Cո)Ȉ%)(pfD N*R:a\0(&D	`\$UV\\z\nXId,xd|:ζV\"@XCt	e/0ʴE#Ȫ髃dpO­WJ_,\"Ɗk%e՞nrEl-b(f\0CG@e}!]>]w/U\$fEhC51QB'!!&Ѱ9sa\"CQ>-0d\$TD2(2xDv\0 \r\$BGu\"#䄑Fօ*DM?!PD*\$G@&d͘tl!E*U)\r\$8lG9i^*hЃL\nf#@A\n/8F[(4ZjI\0C\naH#\0Z')E\$&ra\\E^0\nG0\\Ck=&ȵ4tXEP,S!'BbS*r?QXʼW~9KĂ\"G4N\"xS\nVEFLIfdΜ;&/Uiਪ\r@50T\n;&8L%DޜG*sp,96ԹBLpO	*\0BEX@.	d,^1 #G9##=V0sn黳ba:XVAEX/OD堔qhTػޛE\0*0H P\"`\$ӣR\"\0\0R]aeP\0ֈYEhD4nAj՘q]	9ӑbL!\"J%܆E<07PlJ0Y4B+-gU\r:EH,b*`d\nCphR:<xm!Q4\$3g9А!9	,.qEaO5k( {5aN.+N0o}GsLIԱxК&A.Ŷ2ҡt1@K@@>r>T)yex=|TyX 1G4H\\^'26Hv)*^0F&^cO-7F/2\\EB˭IANIa&:&\"roQ|txNGCIA@ orp[ֺ-#,]sT| -轼?dӈ\".b/caAASh~n#E5F-N}Q\n5Y,D< k6Td=e6>#Ȋ\r/N##sm*d \rYM\r\r|4\rt^fn<l4|.4L̄FϮσql>uon;'<!W'Nxjߐts\rXuh.LF.|2鮞/kAk	rߐܫ(\$9\r^Bʛ0>\$\$Uͺ	pJLU%B俑\nˏ#4(I'	&`cm%utcnxCqxp~,jm\r\rn1n;0pArB.GB^h+B^~(7q\n)(!Q쓰!h 0%Ѳ\0hr cy L\"'G'\$-.P#R/\"<Ѳ(R%#d\"R% efZF2\0\0\r.|2i&'\0'G-(-ޒnyR'mB2MޑFV2#0RU+0-Rmr,CHq\r\$K/\r/{s\0	@!k4tCj*\0ƚPRD<caz!ph!\n.CFrCAB12h \r8:T%bg\$0E93\0\nZuhʠ*d!bxz[	m^kj\\K)9C[0lP?j	>K\$C@g\"t+AQz,aBB:t45!`^0PjF		owq)VƘi=!2PAMGIG, &ʨ\n`ڑT++EMnN^+>MRt w4)BnD0Lj=5&rrK1\$B<),HPB";break;}$dj=array();foreach(explode("\n",lzw_decompress($f))as$X)$dj[]=(strpos($X,"\t")?explode("\t",$X):$X);return$dj;}abstract
class
SqlDb{static$instance;var$extension;var$flavor='';var$server_info;var$affected_rows=0;var$info='';var$errno=0;var$error='';protected$multi;abstract
function
attach($N,$V,$F);abstract
function
quote($Q);abstract
function
select_db($Pb);abstract
function
query($H,$nj=false);function
multi_query($H){return$this->multi=$this->query($H);}function
store_result(){return$this->multi;}function
next_result(){return
false;}}if(extension_loaded('pdo')){abstract
class
PdoDb
extends
SqlDb{protected$pdo;function
dsn($pc,$V,$F,array$bg=array()){$bg[\PDO::ATTR_ERRMODE]=\PDO::ERRMODE_SILENT;$bg[\PDO::ATTR_STATEMENT_CLASS]=array('Adminer\PdoResult');try{$this->pdo=new
\PDO($pc,$V,$F,$bg);}catch(\Exception$Kc){return$Kc->getMessage();}$this->server_info=@$this->pdo->getAttribute(\PDO::ATTR_SERVER_VERSION);return'';}function
quote($Q){return$this->pdo->quote($Q);}function
query($H,$nj=false){$I=$this->pdo->query($H);$this->error="";if(!$I){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($I);return$I;}function
store_result($I=null){if(!$I){$I=$this->multi;if(!$I)return
false;}if($I->columnCount()){$I->num_rows=$I->rowCount();return$I;}$this->affected_rows=$I->rowCount();return
true;}function
next_result(){$I=$this->multi;if(!is_object($I))return
false;$I->_offset=0;return@$I->nextRowset();}}class
PdoResult
extends
\PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch_array(\PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch_array(\PDO::FETCH_NUM);}private
function
fetch_array($uf){$J=$this->fetch($uf);return($J?array_map(array($this,'unresource'),$J):$J);}private
function
unresource($X){return(is_resource($X)?stream_get_contents($X):$X);}function
fetch_field(){$K=(object)$this->getColumnMeta($this->_offset++);$U=$K->pdo_type;$K->type=($U==\PDO::PARAM_INT?0:15);$K->charsetnr=($U==\PDO::PARAM_LOB||(isset($K->flags)&&in_array("blob",(array)$K->flags))?63:0);return$K;}function
seek($C){for($t=0;$t<$C;$t++)$this->fetch();}}}function
add_driver($u,$B){SqlDriver::$drivers[$u]=$B;}function
get_driver($u){return
SqlDriver::$drivers[$u];}abstract
class
SqlDriver{static$instance;static$drivers=array();static$extensions=array();static$jush;protected$conn;protected$types=array();var$insertFunctions=array();var$editFunctions=array();var$unsigned=array();var$operators=array();var$functions=array();var$grouping=array();var$onActions="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";var$partitionBy=array();var$inout="IN|OUT|INOUT";var$enumLength="'(?:''|[^'\\\\]|\\\\.)*'";var$generated=array();static
function
connect($N,$V,$F){$g=new
Db;return($g->attach($N,$V,$F)?:$g);}function
__construct(Db$g){$this->conn=$g;}function
types(){return
call_user_func_array('array_merge',array_values($this->types));}function
structuredTypes(){return
array_map('array_keys',$this->types);}function
enumLength(array$n){}function
unconvertFunction(array$n){}function
select($R,array$M,array$Z,array$yd,array$dg=array(),$z=1,$D=0,$Wg=false){$ve=(count($yd)<count($M));$H=adminer()->selectQueryBuild($M,$Z,$yd,$dg,$z,$D);if(!$H)$H="SELECT".limit(($_GET["page"]!="last"&&$z&&$yd&&$ve&&JUSH=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$M)."\nFROM ".table($R),($Z?"\nWHERE ".implode(" AND ",$Z):"").($yd&&$ve?"\nGROUP BY ".implode(", ",$yd):"").($dg?"\nORDER BY ".implode(", ",$dg):""),$z,($D?$z*$D:0),"\n");$ni=microtime(true);$J=$this->conn->query($H);if($Wg)echo
adminer()->selectQuery($H,$ni,!$J);return$J;}function
delete($R,$fh,$z=0){$H="FROM ".table($R);return
queries("DELETE".($z?limit1($R,$H,$fh):" $H$fh"));}function
update($R,array$O,$fh,$z=0,$Qh="\n"){$Fj=array();foreach($O
as$y=>$X)$Fj[]="$y = $X";$H=table($R)." SET$Qh".implode(",$Qh",$Fj);return
queries("UPDATE".($z?limit1($R,$H,$fh,$Qh):" $H$fh"));}function
insert($R,array$O){return
queries("INSERT INTO ".table($R).($O?" (".implode(", ",array_keys($O)).")\nVALUES (".implode(", ",$O).")":" DEFAULT VALUES").$this->insertReturning($R));}function
insertReturning($R){return"";}function
insertUpdate($R,array$L,array$G){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($H,$Pi){}function
convertSearch($v,array$X,array$n){return$v;}function
convertOperator($Xf){return$Xf;}function
value($X,array$n){return(method_exists($this->conn,'value')?$this->conn->value($X,$n):$X);}function
quoteBinary($Dh){return
q($Dh);}function
warnings(){}function
tableHelp($B,$ze=false){}function
inheritsFrom($R){return
array();}function
inheritedTables($R){return
array();}function
partitionsInfo($R){return
array();}function
hasCStyleEscapes(){return
false;}function
engines(){return
array();}function
supportsIndex(array$S){return!is_view($S);}function
indexAlgorithms(array$xi){return
array();}function
checkConstraints($R){return
get_key_vals("SELECT c.CONSTRAINT_NAME, CHECK_CLAUSE
FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS c
JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS t ON c.CONSTRAINT_SCHEMA = t.CONSTRAINT_SCHEMA AND c.CONSTRAINT_NAME = t.CONSTRAINT_NAME
WHERE c.CONSTRAINT_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
AND t.TABLE_NAME = ".q($R)."
AND CHECK_CLAUSE NOT LIKE '% IS NOT NULL'",$this->conn);}function
allFields(){$J=array();if(DB!=""){foreach(get_rows("SELECT TABLE_NAME AS tab, COLUMN_NAME AS field, IS_NULLABLE AS nullable, DATA_TYPE AS type, CHARACTER_MAXIMUM_LENGTH AS length".(JUSH=='sql'?", COLUMN_KEY = 'PRI' AS `primary`":"")."
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
ORDER BY TABLE_NAME, ORDINAL_POSITION",$this->conn)as$K){$K["null"]=($K["nullable"]=="YES");$J[$K["tab"]][]=$K;}}return$J;}}add_driver("sqlite","SQLite");if(isset($_GET["sqlite"])){define('Adminer\DRIVER',"sqlite");if(class_exists("SQLite3")&&$_GET["ext"]!="pdo"){abstract
class
SqliteDb
extends
SqlDb{var$extension="SQLite3";private$link;function
attach($p,$V,$F){$this->link=new
\SQLite3($p);$Ij=$this->link->version();$this->server_info=$Ij["versionString"];return'';}function
query($H,$nj=false){$I=@$this->link->query($H);$this->error="";if(!$I){$this->errno=$this->link->lastErrorCode();$this->error=$this->link->lastErrorMsg();return
false;}elseif($I->numColumns())return
new
Result($I);$this->affected_rows=$this->link->changes();return
true;}function
quote($Q){return(is_utf8($Q)?"'".$this->link->escapeString($Q)."'":"x'".first(unpack('H*',$Q))."'");}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;}function
fetch_assoc(){return$this->result->fetchArray(SQLITE3_ASSOC);}function
fetch_row(){return$this->result->fetchArray(SQLITE3_NUM);}function
fetch_field(){$d=$this->offset++;$U=$this->result->columnType($d);return(object)array("name"=>$this->result->columnName($d),"type"=>($U==SQLITE3_TEXT?15:0),"charsetnr"=>($U==SQLITE3_BLOB?63:0),);}function
__destruct(){$this->result->finalize();}}}elseif(extension_loaded("pdo_sqlite")){abstract
class
SqliteDb
extends
PdoDb{var$extension="PDO_SQLite";function
attach($p,$V,$F){$this->dsn(DRIVER.":$p","","");$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return'';}}}if(class_exists('Adminer\SqliteDb')){class
Db
extends
SqliteDb{function
attach($p,$V,$F){parent::attach($p,$V,$F);$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return'';}function
select_db($p){if(is_readable($p)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$p)?$p:dirname($_SERVER["SCRIPT_FILENAME"])."/$p")." AS a"))return!self::attach($p,'','');return
false;}}}class
Driver
extends
SqlDriver{static$extensions=array("SQLite3","PDO_SQLite");static$jush="sqlite";protected$types=array(array("integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0));var$insertFunctions=array();var$editFunctions=array("integer|real|numeric"=>"+/-","text"=>"||",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("hex","length","lower","round","unixepoch","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($N,$V,$F){if($F!="")return
lang(22);return
parent::connect(":memory:","","");}function
__construct(Db$g){parent::__construct($g);if(min_version(3.31,0,$g))$this->generated=array("STORED","VIRTUAL");}function
structuredTypes(){return
array_keys($this->types[0]);}function
insertUpdate($R,array$L,array$G){$Fj=array();foreach($L
as$O)$Fj[]="(".implode(", ",$O).")";return
queries("REPLACE INTO ".table($R)." (".implode(", ",array_keys(reset($L))).") VALUES\n".implode(",\n",$Fj));}function
tableHelp($B,$ze=false){if($B=="sqlite_sequence")return"fileformat2.html#seqtab";if($B=="sqlite_master")return"fileformat2.html#$B";}function
checkConstraints($R){preg_match_all('~ CHECK *(\( *(((?>[^()]*[^() ])|(?1))*) *\))~',get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R),0,$this->conn),$cf);return
array_combine($cf[2],$cf[2]);}function
allFields(){$J=array();foreach(tables_list()as$R=>$U){foreach(fields($R)as$n)$J[$R][]=$n;}return$J;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($jd){return
array();}function
limit($H,$Z,$z,$C=0,$Qh=" "){return" $H$Z".($z?$Qh."LIMIT $z".($C?" OFFSET $C":""):"");}function
limit1($R,$H,$Z,$Qh="\n"){return(preg_match('~^INTO~',$H)||get_val("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($H,$Z,1,0,$Qh):" $H WHERE rowid = (SELECT rowid FROM ".table($R).$Z.$Qh."LIMIT 1)");}function
db_collation($k,$lb){return
get_val("PRAGMA encoding");}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($j){return
array();}function
table_status($B=""){$J=array();foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($B!=""?"AND name = ".q($B):"ORDER BY name"))as$K){$K["Rows"]=get_val("SELECT COUNT(*) FROM ".idf_escape($K["Name"]));$J[$K["Name"]]=$K;}foreach(get_rows("SELECT * FROM sqlite_sequence".($B!=""?" WHERE name = ".q($B):""),null,"")as$K)$J[$K["name"]]["Auto_increment"]=$K["seq"];return$J;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return!get_val("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($R){$J=array();$G="";foreach(get_rows("PRAGMA table_".(min_version(3.31)?"x":"")."info(".table($R).")")as$K){$B=$K["name"];$U=strtolower($K["type"]);$l=$K["dflt_value"];$J[$B]=array("field"=>$B,"type"=>(preg_match('~int~i',$U)?"integer":(preg_match('~char|clob|text~i',$U)?"text":(preg_match('~blob~i',$U)?"blob":(preg_match('~real|floa|doub~i',$U)?"real":"numeric")))),"full_type"=>$U,"default"=>(preg_match("~^'(.*)'$~",$l,$A)?str_replace("''","'",$A[1]):($l=="NULL"?null:$l)),"null"=>!$K["notnull"],"privileges"=>array("select"=>1,"insert"=>1,"update"=>1,"where"=>1,"order"=>1),"primary"=>$K["pk"],);if($K["pk"]){if($G!="")$J[$G]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$U))$J[$B]["auto_increment"]=true;$G=$B;}}$hi=get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));$v='(("[^"]*+")+|[a-z0-9_]+)';preg_match_all('~'.$v.'\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$hi,$cf,PREG_SET_ORDER);foreach($cf
as$A){$B=str_replace('""','"',preg_replace('~^"|"$~','',$A[1]));if($J[$B])$J[$B]["collation"]=trim($A[3],"'");}preg_match_all('~'.$v.'\s.*GENERATED ALWAYS AS \((.+)\) (STORED|VIRTUAL)~i',$hi,$cf,PREG_SET_ORDER);foreach($cf
as$A){$B=str_replace('""','"',preg_replace('~^"|"$~','',$A[1]));$J[$B]["default"]=$A[3];$J[$B]["generated"]=strtoupper($A[4]);}return$J;}function
indexes($R,$h=null){$h=connection($h);$J=array();$hi=get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R),0,$h);if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$hi,$A)){$J[""]=array("type"=>"PRIMARY","columns"=>array(),"lengths"=>array(),"descs"=>array());preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$A[1],$cf,PREG_SET_ORDER);foreach($cf
as$A){$J[""]["columns"][]=idf_unescape($A[2]).$A[4];$J[""]["descs"][]=(preg_match('~DESC~i',$A[5])?'1':null);}}if(!$J){foreach(fields($R)as$B=>$n){if($n["primary"])$J[""]=array("type"=>"PRIMARY","columns"=>array($B),"lengths"=>array(),"descs"=>array(null));}}$li=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($R),$h);foreach(get_rows("PRAGMA index_list(".table($R).")",$h)as$K){$B=$K["name"];$w=array("type"=>($K["unique"]?"UNIQUE":"INDEX"));$w["lengths"]=array();$w["descs"]=array();foreach(get_rows("PRAGMA index_info(".idf_escape($B).")",$h)as$Ch){$w["columns"][]=$Ch["name"];$w["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($B).' ON '.idf_escape($R),'~').' \((.*)\)$~i',$li[$B],$qh)){preg_match_all('/("[^"]*+")+( DESC)?/',$qh[2],$cf);foreach($cf[2]as$y=>$X){if($X)$w["descs"][$y]='1';}}if(!$J[""]||$w["type"]!="UNIQUE"||$w["columns"]!=$J[""]["columns"]||$w["descs"]!=$J[""]["descs"]||!preg_match("~^sqlite_~",$B))$J[$B]=$w;}return$J;}function
foreign_keys($R){$J=array();foreach(get_rows("PRAGMA foreign_key_list(".table($R).")")as$K){$q=&$J[$K["id"]];if(!$q)$q=$K;$q["source"][]=$K["from"];$q["target"][]=$K["to"];}return$J;}function
view($B){return
array("select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',get_val("SELECT sql FROM sqlite_master WHERE type = 'view' AND name = ".q($B))));}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):array());}function
information_schema($k){return
false;}function
error(){return
h(connection()->error);}function
check_sqlite_name($B){$Sc="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($Sc)\$~",$B)){connection()->error=lang(23,str_replace("|",", ",$Sc));return
false;}return
true;}function
create_database($k,$c){if(file_exists($k)){connection()->error=lang(24);return
false;}if(!check_sqlite_name($k))return
false;try{$_=new
Db();$_->attach($k,'','');}catch(\Exception$Kc){connection()->error=$Kc->getMessage();return
false;}$_->query('PRAGMA encoding = "UTF-8"');$_->query('CREATE TABLE adminer (i)');$_->query('DROP TABLE adminer');return
true;}function
drop_databases($j){connection()->attach(":memory:",'','');foreach($j
as$k){if(!@unlink($k)){connection()->error=lang(24);return
false;}}return
true;}function
rename_database($B,$c){if(!check_sqlite_name($B))return
false;connection()->attach(":memory:",'','');connection()->error=lang(24);return@rename(DB,$B);}function
auto_increment(){return" PRIMARY KEY AUTOINCREMENT";}function
alter_table($R,$B,$o,$ld,$qb,$_c,$c,$Ba,$E){$zj=($R==""||$ld);foreach($o
as$n){if($n[0]!=""||!$n[1]||$n[2]){$zj=true;break;}}$b=array();$og=array();foreach($o
as$n){if($n[1]){$b[]=($zj?$n[1]:"ADD ".implode($n[1]));if($n[0]!="")$og[$n[0]]=$n[1][0];}}if(!$zj){foreach($b
as$X){if(!queries("ALTER TABLE ".table($R)." $X"))return
false;}if($R!=$B&&!queries("ALTER TABLE ".table($R)." RENAME TO ".table($B)))return
false;}elseif(!recreate_table($R,$B,$b,$og,$ld,$Ba))return
false;if($Ba){queries("BEGIN");queries("UPDATE sqlite_sequence SET seq = $Ba WHERE name = ".q($B));if(!connection()->affected_rows)queries("INSERT INTO sqlite_sequence (name, seq) VALUES (".q($B).", $Ba)");queries("COMMIT");}return
true;}function
recreate_table($R,$B,array$o,array$og,array$ld,$Ba="",$x=array(),$lc="",$la=""){if($R!=""){if(!$o){foreach(fields($R)as$y=>$n){if($x)$n["auto_increment"]=0;$o[]=process_field($n,$n);$og[$y]=idf_escape($y);}}$Vg=false;foreach($o
as$n){if($n[6])$Vg=true;}$nc=array();foreach($x
as$y=>$X){if($X[2]=="DROP"){$nc[$X[1]]=true;unset($x[$y]);}}foreach(indexes($R)as$Ce=>$w){$e=array();foreach($w["columns"]as$y=>$d){if(!$og[$d])continue
2;$e[]=$og[$d].($w["descs"][$y]?" DESC":"");}if(!$nc[$Ce]){if($w["type"]!="PRIMARY"||!$Vg)$x[]=array($w["type"],$Ce,$e);}}foreach($x
as$y=>$X){if($X[0]=="PRIMARY"){unset($x[$y]);$ld[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($R)as$Ce=>$q){foreach($q["source"]as$y=>$d){if(!$og[$d])continue
2;$q["source"][$y]=idf_unescape($og[$d]);}if(!isset($ld[" $Ce"]))$ld[]=" ".format_foreign_key($q);}queries("BEGIN");}$Wa=array();foreach($o
as$n){if(preg_match('~GENERATED~',$n[3]))unset($og[array_search($n[0],$og)]);$Wa[]="  ".implode($n);}$Wa=array_merge($Wa,array_filter($ld));foreach(driver()->checkConstraints($R)as$Ya){if($Ya!=$lc)$Wa[]="  CHECK ($Ya)";}if($la)$Wa[]="  CHECK ($la)";$Ji=($R==$B?"adminer_$B":$B);if(!queries("CREATE TABLE ".table($Ji)." (\n".implode(",\n",$Wa)."\n)"))return
false;if($R!=""){if($og&&!queries("INSERT INTO ".table($Ji)." (".implode(", ",$og).") SELECT ".implode(", ",array_map('Adminer\idf_escape',array_keys($og)))." FROM ".table($R)))return
false;$jj=array();foreach(triggers($R)as$hj=>$Qi){$gj=trigger($hj,$R);$jj[]="CREATE TRIGGER ".idf_escape($hj)." ".implode(" ",$Qi)." ON ".table($B)."\n$gj[Statement]";}$Ba=$Ba?"":get_val("SELECT seq FROM sqlite_sequence WHERE name = ".q($R));if(!queries("DROP TABLE ".table($R))||($R==$B&&!queries("ALTER TABLE ".table($Ji)." RENAME TO ".table($B)))||!alter_indexes($B,$x))return
false;if($Ba)queries("UPDATE sqlite_sequence SET seq = $Ba WHERE name = ".q($B));foreach($jj
as$gj){if(!queries($gj))return
false;}queries("COMMIT");}return
true;}function
index_sql($R,$U,$B,$e){return"CREATE $U ".($U!="INDEX"?"INDEX ":"").idf_escape($B!=""?$B:uniqid($R."_"))." ON ".table($R)." $e";}function
alter_indexes($R,$b){foreach($b
as$G){if($G[0]=="PRIMARY")return
recreate_table($R,$R,array(),array(),array(),"",$b);}foreach(array_reverse($b)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($R,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($T){return
apply_queries("DELETE FROM",$T);}function
drop_views($Kj){return
apply_queries("DROP VIEW",$Kj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
move_tables($T,$Kj,$Hi){return
false;}function
trigger($B,$R){if($B=="")return
array("Statement"=>"BEGIN\n\t;\nEND");$v='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$ij=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$v\\s*(".implode("|",$ij["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($v))?\\s+ON\\s*$v\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",get_val("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($B)),$A);$Lf=$A[3];return
array("Timing"=>strtoupper($A[1]),"Event"=>strtoupper($A[2]).($Lf?" OF":""),"Of"=>idf_unescape($Lf),"Trigger"=>$B,"Statement"=>$A[4],);}function
triggers($R){$J=array();$ij=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R))as$K){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$ij["Timing"]).')\s*(.*?)\s+ON\b~i',$K["sql"],$A);$J[$K["name"]]=array($A[1],$A[2]);}return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
begin(){return
queries("BEGIN");}function
last_id($I){return
get_val("SELECT LAST_INSERT_ROWID()");}function
explain($g,$H){return$g->query("EXPLAIN QUERY PLAN $H");}function
found_rows($S,$Z){}function
types(){return
array();}function
create_sql($R,$Ba,$ri){$J=get_val("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($R));foreach(indexes($R)as$B=>$w){if($B=='')continue;$J
.=";\n\n".index_sql($R,$w['type'],$B,"(".implode(", ",array_map('Adminer\idf_escape',$w['columns'])).")");}return$J;}function
truncate_sql($R){return"DELETE FROM ".table($R);}function
use_sql($Pb){}function
trigger_sql($R){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R)));}function
show_variables(){$J=array();foreach(get_rows("PRAGMA pragma_list")as$K){$B=$K["name"];if($B!="pragma_list"&&$B!="compile_options"){$J[$B]=array($B,'');foreach(get_rows("PRAGMA $B")as$K)$J[$B][1].=implode(", ",$K)."\n";}}return$J;}function
show_status(){$J=array();foreach(get_vals("PRAGMA compile_options")as$ag)$J[]=explode("=",$ag,2)+array('','');return$J;}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Xc){return
preg_match('~^(check|columns|database|drop_col|dump|indexes|descidx|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$Xc);}}add_driver("pgsql","PostgreSQL");if(isset($_GET["pgsql"])){define('Adminer\DRIVER',"pgsql");if(extension_loaded("pgsql")&&$_GET["ext"]!="pdo"){class
PgsqlDb
extends
SqlDb{var$extension="PgSQL";var$timeout=0;private$link,$string,$database=true;function
_error($Fc,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
attach($N,$V,$F){$k=adminer()->database();set_error_handler(array($this,'_error'));$this->string="host='".str_replace(":","' port='",addcslashes($N,"'\\"))."' user='".addcslashes($V,"'\\")."' password='".addcslashes($F,"'\\")."'";$mi=adminer()->connectSsl();if(isset($mi["mode"]))$this->string
.=" sslmode='".$mi["mode"]."'";$this->link=@pg_connect("$this->string dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->link&&$k!=""){$this->database=false;$this->link=@pg_connect("$this->string dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->link)pg_set_client_encoding($this->link,"UTF8");return($this->link?'':$this->error);}function
quote($Q){return(function_exists('pg_escape_literal')?pg_escape_literal($this->link,$Q):"'".pg_escape_string($this->link,$Q)."'");}function
value($X,array$n){return($n["type"]=="bytea"&&$X!==null?pg_unescape_bytea($X):$X);}function
select_db($Pb){if($Pb==adminer()->database())return$this->database;$J=@pg_connect("$this->string dbname='".addcslashes($Pb,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($J)$this->link=$J;return$J;}function
close(){$this->link=@pg_connect("$this->string dbname='postgres'");}function
query($H,$nj=false){$I=@pg_query($this->link,$H);$this->error="";if(!$I){$this->error=pg_last_error($this->link);$J=false;}elseif(!pg_num_fields($I)){$this->affected_rows=pg_affected_rows($I);$J=true;}else$J=new
Result($I);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$J;}function
warnings(){return
h(pg_last_notice($this->link));}function
copyFrom($R,array$L){$this->error='';set_error_handler(function($Fc,$m){$this->error=(ini_bool('html_errors')?html_entity_decode($m):$m);return
true;});$J=pg_copy_from($this->link,$R,$L);restore_error_handler();return$J;}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;$this->num_rows=pg_num_rows($I);}function
fetch_assoc(){return
pg_fetch_assoc($this->result);}function
fetch_row(){return
pg_fetch_row($this->result);}function
fetch_field(){$d=$this->offset++;$J=new
\stdClass;$J->orgtable=pg_field_table($this->result,$d);$J->name=pg_field_name($this->result,$d);$U=pg_field_type($this->result,$d);$J->type=(preg_match(number_type(),$U)?0:15);$J->charsetnr=($U=="bytea"?63:0);return$J;}function
__destruct(){pg_free_result($this->result);}}}elseif(extension_loaded("pdo_pgsql")){class
PgsqlDb
extends
PdoDb{var$extension="PDO_PgSQL";var$timeout=0;function
attach($N,$V,$F){$k=adminer()->database();$pc="pgsql:host='".str_replace(":","' port='",addcslashes($N,"'\\"))."' client_encoding=utf8 dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'";$mi=adminer()->connectSsl();if(isset($mi["mode"]))$pc
.=" sslmode='".$mi["mode"]."'";return$this->dsn($pc,$V,$F);}function
select_db($Pb){return(adminer()->database()==$Pb);}function
query($H,$nj=false){$J=parent::query($H,$nj);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$J;}function
warnings(){}function
copyFrom($R,array$L){$J=$this->pdo->pgsqlCopyFromArray($R,$L);$this->error=idx($this->pdo->errorInfo(),2)?:'';return$J;}function
close(){}}}if(class_exists('Adminer\PgsqlDb')){class
Db
extends
PgsqlDb{function
multi_query($H){if(preg_match('~\bCOPY\s+(.+?)\s+FROM\s+stdin;\n?(.*)\n\\\\\.$~is',str_replace("\r\n","\n",$H),$A)){$L=explode("\n",$A[2]);$this->affected_rows=count($L);return$this->copyFrom($A[1],$L);}return
parent::multi_query($H);}}}class
Driver
extends
SqlDriver{static$extensions=array("PgSQL","PDO_PgSQL");static$jush="pgsql";var$operators=array("=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","ILIKE","ILIKE %%","IN","IS NULL","NOT LIKE","NOT ILIKE","NOT IN","IS NOT NULL");var$functions=array("char_length","lower","round","to_hex","to_timestamp","upper");var$grouping=array("avg","count","count distinct","max","min","sum");var$nsOid="(SELECT oid FROM pg_namespace WHERE nspname = current_schema())";static
function
connect($N,$V,$F){$g=parent::connect($N,$V,$F);if(is_string($g))return$g;$Ij=get_val("SELECT version()",0,$g);$g->flavor=(preg_match('~CockroachDB~',$Ij)?'cockroach':'');$g->server_info=preg_replace('~^\D*([\d.]+[-\w]*).*~','\1',$Ij);if(min_version(9,0,$g))$g->query("SET application_name = 'Adminer'");if($g->flavor=='cockroach')add_driver(DRIVER,"CockroachDB");return$g;}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20),lang(26)=>array("date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0),lang(27)=>array("character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0),lang(28)=>array("bit"=>0,"bit varying"=>0,"bytea"=>0),lang(29)=>array("cidr"=>43,"inet"=>43,"macaddr"=>17,"macaddr8"=>23,"txid_snapshot"=>0),lang(30)=>array("box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0),);if(min_version(9.2,0,$g)){$this->types[lang(27)]["json"]=4294967295;if(min_version(9.4,0,$g))$this->types[lang(27)]["jsonb"]=4294967295;}$this->insertFunctions=array("char"=>"md5","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",);if(min_version(12,0,$g))$this->generated=array("STORED");$this->partitionBy=array("RANGE","LIST");if(!$g->flavor)$this->partitionBy[]="HASH";}function
enumLength(array$n){$Bc=$this->types[lang(31)][$n["type"]];return($Bc?type_values($Bc):"");}function
setUserTypes($mj){$this->types[lang(31)]=array_flip($mj);}function
insertReturning($R){$Ba=array_filter(fields($R),function($n){return$n['auto_increment'];});return(count($Ba)==1?" RETURNING ".idf_escape(key($Ba)):"");}function
insertUpdate($R,array$L,array$G){foreach($L
as$O){$vj=array();$Z=array();foreach($O
as$y=>$X){$vj[]="$y = $X";if(isset($G[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$vj)." WHERE ".implode(" AND ",$Z))&&connection()->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
slowQuery($H,$Pi){$this->conn->query("SET statement_timeout = ".(1000*$Pi));$this->conn->timeout=1000*$Pi;return$H;}function
convertSearch($v,array$X,array$n){$Mi="char|text";if(strpos($X["op"],"LIKE")===false)$Mi
.="|date|time(stamp)?|boolean|uuid|inet|cidr|macaddr|".number_type();return(preg_match("~$Mi~",$n["type"])?$v:"CAST($v AS text)");}function
quoteBinary($Dh){return"'\\x".bin2hex($Dh)."'";}function
warnings(){return$this->conn->warnings();}function
tableHelp($B,$ze=false){$Ue=array("information_schema"=>"infoschema","pg_catalog"=>($ze?"view":"catalog"),);$_=$Ue[$_GET["ns"]];if($_)return"$_-".str_replace("_","-",$B).".html";}function
inheritsFrom($R){return
get_vals("SELECT relname FROM pg_class JOIN pg_inherits ON inhparent = oid WHERE inhrelid = ".$this->tableOid($R)." ORDER BY 1");}function
inheritedTables($R){return
get_vals("SELECT relname FROM pg_inherits JOIN pg_class ON inhrelid = oid WHERE inhparent = ".$this->tableOid($R)." ORDER BY 1");}function
partitionsInfo($R){$K=connection()->query("SELECT * FROM pg_partitioned_table WHERE partrelid = ".driver()->tableOid($R))->fetch_assoc();if($K){$_a=get_vals("SELECT attname FROM pg_attribute WHERE attrelid = $K[partrelid] AND attnum IN (".str_replace(" ",", ",$K["partattrs"]).")");$Qa=array('h'=>'HASH','l'=>'LIST','r'=>'RANGE');return
array("partition_by"=>$Qa[$K["partstrat"]],"partition"=>implode(", ",array_map('Adminer\idf_escape',$_a)),);}return
array();}function
tableOid($R){return"(SELECT oid FROM pg_class WHERE relnamespace = $this->nsOid AND relname = ".q($R)." AND relkind IN ('r', 'm', 'v', 'f', 'p'))";}function
indexAlgorithms(array$xi){static$J=array();if(!$J)$J=get_vals("SELECT amname FROM pg_am".(min_version(9.6)?" WHERE amtype = 'i'":"")." ORDER BY amname = 'btree' DESC, amname");return$J;}function
supportsIndex(array$S){return$S["Engine"]!="view";}function
hasCStyleEscapes(){static$Sa;if($Sa===null)$Sa=(get_val("SHOW standard_conforming_strings",0,$this->conn)=="off");return$Sa;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($jd){return
get_vals("SELECT datname FROM pg_database
WHERE datallowconn = TRUE AND has_database_privilege(datname, 'CONNECT')
ORDER BY datname");}function
limit($H,$Z,$z,$C=0,$Qh=" "){return" $H$Z".($z?$Qh."LIMIT $z".($C?" OFFSET $C":""):"");}function
limit1($R,$H,$Z,$Qh="\n"){return(preg_match('~^INTO~',$H)?limit($H,$Z,1,0,$Qh):" $H".(is_view(table_status1($R))?$Z:$Qh."WHERE ctid = (SELECT ctid FROM ".table($R).$Z.$Qh."LIMIT 1)"));}function
db_collation($k,$lb){return
get_val("SELECT datcollate FROM pg_database WHERE datname = ".q($k));}function
logged_user(){return
get_val("SELECT user");}function
tables_list(){$H="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support("materializedview"))$H
.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$H
.="
ORDER BY 1";return
get_key_vals($H);}function
count_tables($j){$J=array();foreach($j
as$k){if(connection()->select_db($k))$J[$k]=count(tables_list());}return$J;}function
table_status($B=""){static$Hd;if($Hd===null)$Hd=get_val("SELECT 'pg_table_size'::regproc");$J=array();foreach(get_rows("SELECT
	relname AS \"Name\",
	CASE relkind WHEN 'v' THEN 'view' WHEN 'm' THEN 'materialized view' ELSE 'table' END AS \"Engine\"".($Hd?",
	pg_table_size(oid) AS \"Data_length\",
	pg_indexes_size(oid) AS \"Index_length\"":"").",
	obj_description(oid, 'pg_class') AS \"Comment\",
	".(min_version(12)?"''":"CASE WHEN relhasoids THEN 'oid' ELSE '' END")." AS \"Oid\",
	reltuples as \"Rows\",
	inhparent AS inherited,
	current_schema() AS nspname
FROM pg_class
LEFT JOIN pg_inherits ON inhrelid = oid
WHERE relkind IN ('r', 'm', 'v', 'f', 'p')
AND relnamespace = ".driver()->nsOid."
".($B!=""?"AND relname = ".q($B):"ORDER BY relname"))as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return
in_array($S["Engine"],array("view","materialized view"));}function
fk_support($S){return
true;}function
fields($R){$J=array();$ta=array('timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',);foreach(get_rows("SELECT
	a.attname AS field,
	format_type(a.atttypid, a.atttypmod) AS full_type,
	pg_get_expr(d.adbin, d.adrelid) AS default,
	a.attnotnull::int,
	col_description(a.attrelid, a.attnum) AS comment".(min_version(10)?",
	a.attidentity".(min_version(12)?",
	a.attgenerated":""):"")."
FROM pg_attribute a
LEFT JOIN pg_attrdef d ON a.attrelid = d.adrelid AND a.attnum = d.adnum
WHERE a.attrelid = ".driver()->tableOid($R)."
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$K){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$K["full_type"],$A);list(,$U,$Qe,$K["length"],$ma,$xa)=$A;$K["length"].=$xa;$ab=$U.$ma;if(isset($ta[$ab])){$K["type"]=$ta[$ab];$K["full_type"]=$K["type"].$Qe.$xa;}else{$K["type"]=$U;$K["full_type"]=$K["type"].$Qe.$ma.$xa;}if(in_array($K['attidentity'],array('a','d')))$K['default']='GENERATED '.($K['attidentity']=='d'?'BY DEFAULT':'ALWAYS').' AS IDENTITY';$K["generated"]=($K["attgenerated"]=="s"?"STORED":"");$K["null"]=!$K["attnotnull"];$K["auto_increment"]=$K['attidentity']||preg_match('~^nextval\(~i',$K["default"])||preg_match('~^unique_rowid\(~',$K["default"]);$K["privileges"]=array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1);if(preg_match('~(.+)::[^,)]+(.*)~',$K["default"],$A))$K["default"]=($A[1]=="NULL"?null:idf_unescape($A[1]).$A[2]);$J[$K["field"]]=$K;}return$J;}function
indexes($R,$h=null){$h=connection($h);$J=array();$_i=driver()->tableOid($R);$e=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $_i AND attnum > 0",$h);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption, (indpred IS NOT NULL)::int as indispartial, pg_am.amname as algorithm, pg_get_expr(pg_index.indpred, pg_index.indrelid, true) AS partial
FROM pg_index
JOIN pg_class ON indexrelid = oid
JOIN pg_am ON pg_am.oid = pg_class.relam
WHERE indrelid = $_i
ORDER BY indisprimary DESC, indisunique DESC",$h)as$K){$rh=$K["relname"];$J[$rh]["type"]=($K["indispartial"]?"INDEX":($K["indisprimary"]?"PRIMARY":($K["indisunique"]?"UNIQUE":"INDEX")));$J[$rh]["columns"]=array();$J[$rh]["descs"]=array();$J[$rh]["algorithm"]=$K["algorithm"];$J[$rh]["partial"]=$K["partial"];if($K["indkey"]){foreach(explode(" ",$K["indkey"])as$ge)$J[$rh]["columns"][]=$e[$ge];foreach(explode(" ",$K["indoption"])as$he)$J[$rh]["descs"][]=(intval($he)&1?'1':null);}$J[$rh]["lengths"]=array();}return$J;}function
foreign_keys($R){$J=array();foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = ".driver()->tableOid($R)."
AND contype = 'f'::char
ORDER BY conkey, conname")as$K){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$K['definition'],$A)){$K['source']=array_map('Adminer\idf_unescape',array_map('trim',explode(',',$A[1])));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$A[2],$af)){$K['ns']=idf_unescape($af[2]);$K['table']=idf_unescape($af[4]);}$K['target']=array_map('Adminer\idf_unescape',array_map('trim',explode(',',$A[3])));$K['on_delete']=(preg_match("~ON DELETE (".driver()->onActions.")~",$A[4],$af)?$af[1]:'NO ACTION');$K['on_update']=(preg_match("~ON UPDATE (".driver()->onActions.")~",$A[4],$af)?$af[1]:'NO ACTION');$J[$K['conname']]=$K;}}return$J;}function
view($B){return
array("select"=>trim(get_val("SELECT pg_get_viewdef(".driver()->tableOid($B).")")));}function
collations(){return
array();}function
information_schema($k){return
get_schema()=="information_schema";}function
error(){$J=h(connection()->error);if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$J,$A))$J=$A[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($A[3]).'})(.*)~','\1<b>\2</b>',$A[2]).$A[4];return
nl_br($J);}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).($c?" ENCODING ".idf_escape($c):""));}function
drop_databases($j){connection()->close();return
apply_queries("DROP DATABASE",$j,'Adminer\idf_escape');}function
rename_database($B,$c){connection()->close();return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($B));}function
auto_increment(){return"";}function
alter_table($R,$B,$o,$ld,$qb,$_c,$c,$Ba,$E){$b=array();$eh=array();if($R!=""&&$R!=$B)$eh[]="ALTER TABLE ".table($R)." RENAME TO ".table($B);$Rh="";foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$b[]="DROP $d";else{$Ej=$X[5];unset($X[5]);if($n[0]==""){if(isset($X[6]))$X[1]=($X[1]==" bigint"?" big":($X[1]==" smallint"?" small":" "))."serial";$b[]=($R!=""?"ADD ":"  ").implode($X);if(isset($X[6]))$b[]=($R!=""?"ADD":" ")." PRIMARY KEY ($X[0])";}else{if($d!=$X[0])$eh[]="ALTER TABLE ".table($B)." RENAME $d TO $X[0]";$b[]="ALTER $d TYPE$X[1]";$Sh=$R."_".idf_unescape($X[0])."_seq";$b[]="ALTER $d ".($X[3]?"SET".preg_replace('~GENERATED ALWAYS(.*) STORED~','EXPRESSION\1',$X[3]):(isset($X[6])?"SET DEFAULT nextval(".q($Sh).")":"DROP DEFAULT"));if(isset($X[6]))$Rh="CREATE SEQUENCE IF NOT EXISTS ".idf_escape($Sh)." OWNED BY ".idf_escape($R).".$X[0]";$b[]="ALTER $d ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}if($n[0]!=""||$Ej!="")$eh[]="COMMENT ON COLUMN ".table($B).".$X[0] IS ".($Ej!=""?substr($Ej,9):"''");}}$b=array_merge($b,$ld);if($R==""){$P="";if($E){$gb=(connection()->flavor=='cockroach');$P=" PARTITION BY $E[partition_by]($E[partition])";if($E["partition_by"]=='HASH'){$Cg=+$E["partitions"];for($t=0;$t<$Cg;$t++)$eh[]="CREATE TABLE ".idf_escape($B."_$t")." PARTITION OF ".idf_escape($B)." FOR VALUES WITH (MODULUS $Cg, REMAINDER $t)";}else{$Ug="MINVALUE";foreach($E["partition_names"]as$t=>$X){$Y=$E["partition_values"][$t];$zg=" VALUES ".($E["partition_by"]=='LIST'?"IN ($Y)":"FROM ($Ug) TO ($Y)");if($gb)$P
.=($t?",":" (")."\n  PARTITION ".(preg_match('~^DEFAULT$~i',$X)?$X:idf_escape($X))."$zg";else$eh[]="CREATE TABLE ".idf_escape($B."_$X")." PARTITION OF ".idf_escape($B)." FOR$zg";$Ug=$Y;}$P
.=($gb?"\n)":"");}}array_unshift($eh,"CREATE TABLE ".table($B)." (\n".implode(",\n",$b)."\n)$P");}elseif($b)array_unshift($eh,"ALTER TABLE ".table($R)."\n".implode(",\n",$b));if($Rh)array_unshift($eh,$Rh);if($qb!==null)$eh[]="COMMENT ON TABLE ".table($B)." IS ".q($qb);foreach($eh
as$H){if(!queries($H))return
false;}return
true;}function
alter_indexes($R,$b){$i=array();$kc=array();$eh=array();foreach($b
as$X){if($X[0]!="INDEX")$i[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$kc[]=idf_escape($X[1]);else$eh[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R).($X[3]?" USING $X[3]":"")." (".implode(", ",$X[2]).")".($X[4]?" WHERE $X[4]":"");}if($i)array_unshift($eh,"ALTER TABLE ".table($R).implode(",",$i));if($kc)array_unshift($eh,"DROP INDEX ".implode(", ",$kc));foreach($eh
as$H){if(!queries($H))return
false;}return
true;}function
truncate_tables($T){return
queries("TRUNCATE ".implode(", ",array_map('Adminer\table',$T)));}function
drop_views($Kj){return
drop_tables($Kj);}function
drop_tables($T){foreach($T
as$R){$P=table_status1($R);if(!queries("DROP ".strtoupper($P["Engine"])." ".table($R)))return
false;}return
true;}function
move_tables($T,$Kj,$Hi){foreach(array_merge($T,$Kj)as$R){$P=table_status1($R);if(!queries("ALTER ".strtoupper($P["Engine"])." ".table($R)." SET SCHEMA ".idf_escape($Hi)))return
false;}return
true;}function
trigger($B,$R){if($B=="")return
array("Statement"=>"EXECUTE PROCEDURE ()");$e=array();$Z="WHERE trigger_schema = current_schema() AND event_object_table = ".q($R)." AND trigger_name = ".q($B);foreach(get_rows("SELECT * FROM information_schema.triggered_update_columns $Z")as$K)$e[]=$K["event_object_column"];$J=array();foreach(get_rows('SELECT trigger_name AS "Trigger", action_timing AS "Timing", event_manipulation AS "Event", \'FOR EACH \' || action_orientation AS "Type", action_statement AS "Statement"
FROM information_schema.triggers'."
$Z
ORDER BY event_manipulation DESC")as$K){if($e&&$K["Event"]=="UPDATE")$K["Event"].=" OF";$K["Of"]=implode(", ",$e);if($J)$K["Event"].=" OR $J[Event]";$J=$K;}return$J;}function
triggers($R){$J=array();foreach(get_rows("SELECT * FROM information_schema.triggers WHERE trigger_schema = current_schema() AND event_object_table = ".q($R))as$K){$gj=trigger($K["trigger_name"],$R);$J[$gj["Trigger"]]=array($gj["Timing"],$gj["Event"]);}return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE","INSERT OR UPDATE","INSERT OR UPDATE OF","DELETE OR INSERT","DELETE OR UPDATE","DELETE OR UPDATE OF","DELETE OR INSERT OR UPDATE","DELETE OR INSERT OR UPDATE OF"),"Type"=>array("FOR EACH ROW","FOR EACH STATEMENT"),);}function
routine($B,$U){$L=get_rows('SELECT routine_definition AS definition, LOWER(external_language) AS language, *
FROM information_schema.routines
WHERE routine_schema = current_schema() AND specific_name = '.q($B));$J=idx($L,0,array());$J["returns"]=array("type"=>$J["type_udt_name"]);$J["fields"]=get_rows('SELECT parameter_name AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
FROM information_schema.parameters
WHERE specific_schema = current_schema() AND specific_name = '.q($B).'
ORDER BY ordinal_position');return$J;}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_type AS "ROUTINE_TYPE", routine_name AS "ROUTINE_NAME", type_udt_name AS "DTD_IDENTIFIER"
FROM information_schema.routines
WHERE routine_schema = current_schema()
ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($B,$K){$J=array();foreach($K["fields"]as$n){$Qe=$n["length"];$J[]=$n["type"].($Qe?"($Qe)":"");}return
idf_escape($B)."(".implode(", ",$J).")";}function
last_id($I){$K=(is_object($I)?$I->fetch_row():array());return($K?$K[0]:0);}function
explain($g,$H){return$g->query("EXPLAIN $H");}function
found_rows($S,$Z){if(preg_match("~ rows=([0-9]+)~",get_val("EXPLAIN SELECT * FROM ".idf_escape($S["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$qh))return$qh[1];}function
types(){return
get_key_vals("SELECT oid, typname
FROM pg_type
WHERE typnamespace = ".driver()->nsOid."
AND typtype IN ('b','d','e')
AND typelem = 0");}function
type_values($u){$Ec=get_vals("SELECT enumlabel FROM pg_enum WHERE enumtypid = $u ORDER BY enumsortorder");return($Ec?"'".implode("', '",array_map('addslashes',$Ec))."'":"");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){return
get_val("SELECT current_schema()");}function
set_schema($Fh,$h=null){if(!$h)$h=connection();$J=$h->query("SET search_path TO ".idf_escape($Fh));driver()->setUserTypes(types());return$J;}function
foreign_keys_sql($R){$J="";$P=table_status1($R);$hd=foreign_keys($R);ksort($hd);foreach($hd
as$gd=>$fd)$J
.="ALTER TABLE ONLY ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." ADD CONSTRAINT ".idf_escape($gd)." $fd[definition] ".($fd['deferrable']?'DEFERRABLE':'NOT DEFERRABLE').";\n";return($J?"$J\n":$J);}function
create_sql($R,$Ba,$ri){$wh=array();$Th=array();$P=table_status1($R);if(is_view($P)){$Jj=view($R);return
rtrim("CREATE VIEW ".idf_escape($R)." AS $Jj[select]",";");}$o=fields($R);if(count($P)<2||empty($o))return
false;$J="CREATE TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." (\n    ";foreach($o
as$n){$xg=idf_escape($n['field']).' '.$n['full_type'].default_value($n).($n['null']?"":" NOT NULL");$wh[]=$xg;if(preg_match('~nextval\(\'([^\']+)\'\)~',$n['default'],$cf)){$Sh=$cf[1];$gi=first(get_rows((min_version(10)?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q(idf_unescape($Sh)):"SELECT * FROM $Sh"),null,"-- "));$Th[]=($ri=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $Sh;\n":"")."CREATE SEQUENCE $Sh INCREMENT $gi[increment_by] MINVALUE $gi[min_value] MAXVALUE $gi[max_value]".($Ba&&$gi['last_value']?" START ".($gi["last_value"]+1):"")." CACHE $gi[cache_value];";}}if(!empty($Th))$J=implode("\n\n",$Th)."\n\n$J";$G="";foreach(indexes($R)as$ee=>$w){if($w['type']=='PRIMARY'){$G=$ee;$wh[]="CONSTRAINT ".idf_escape($ee)." PRIMARY KEY (".implode(', ',array_map('Adminer\idf_escape',$w['columns'])).")";}}foreach(driver()->checkConstraints($R)as$wb=>$yb)$wh[]="CONSTRAINT ".idf_escape($wb)." CHECK $yb";$J
.=implode(",\n    ",$wh)."\n)";$zg=driver()->partitionsInfo($P['Name']);if($zg)$J
.="\nPARTITION BY $zg[partition_by]($zg[partition])";$J
.="\nWITH (oids = ".($P['Oid']?'true':'false').");";if($P['Comment'])$J
.="\n\nCOMMENT ON TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." IS ".q($P['Comment']).";";foreach($o
as$Zc=>$n){if($n['comment'])$J
.="\n\nCOMMENT ON COLUMN ".idf_escape($P['nspname']).".".idf_escape($P['Name']).".".idf_escape($Zc)." IS ".q($n['comment']).";";}foreach(get_rows("SELECT indexdef FROM pg_catalog.pg_indexes WHERE schemaname = current_schema() AND tablename = ".q($R).($G?" AND indexname != ".q($G):""),null,"-- ")as$K)$J
.="\n\n$K[indexdef];";return
rtrim($J,';');}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
trigger_sql($R){$P=table_status1($R);$J="";foreach(triggers($R)as$fj=>$ej){$gj=trigger($fj,$P['Name']);$J
.="\nCREATE TRIGGER ".idf_escape($gj['Trigger'])." $gj[Timing] $gj[Event] ON ".idf_escape($P["nspname"]).".".idf_escape($P['Name'])." $gj[Type] $gj[Statement];;\n";}return$J;}function
use_sql($Pb){return"\connect ".idf_escape($Pb);}function
show_variables(){return
get_rows("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(min_version(9.2)?"pid":"procpid"));}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Xc){return
preg_match('~^(check|columns|comment|database|drop_col|dump|descidx|indexes|kill|partial_indexes|routine|scheme|sequence|sql|table|trigger|type|variables|view'.(min_version(9.3)?'|materializedview':'').(min_version(11)?'|procedure':'').(connection()->flavor=='cockroach'?'':'|processlist').')$~',$Xc);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){return
get_val("SHOW max_connections");}}add_driver("oracle","Oracle (beta)");if(isset($_GET["oracle"])){define('Adminer\DRIVER',"oracle");if(extension_loaded("oci8")&&$_GET["ext"]!="pdo"){class
Db
extends
SqlDb{var$extension="oci8";var$_current_db;private$link;function
_error($Fc,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
attach($N,$V,$F){$this->link=@oci_new_connect($V,$F,$N,"AL32UTF8");if($this->link){$this->server_info=oci_server_version($this->link);return'';}$m=oci_error();return$m["message"];}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($Pb){$this->_current_db=$Pb;return
true;}function
query($H,$nj=false){$I=oci_parse($this->link,$H);$this->error="";if(!$I){$m=oci_error($this->link);$this->errno=$m["code"];$this->error=$m["message"];return
false;}set_error_handler(array($this,'_error'));$J=@oci_execute($I);restore_error_handler();if($J){if(oci_num_fields($I))return
new
Result($I);$this->affected_rows=oci_num_rows($I);oci_free_statement($I);}return$J;}}class
Result{var$num_rows;private$result,$offset=1;function
__construct($I){$this->result=$I;}private
function
convert($K){foreach((array)$K
as$y=>$X){if(is_a($X,'OCILob')||is_a($X,'OCI-Lob'))$K[$y]=$X->load();}return$K;}function
fetch_assoc(){return$this->convert(oci_fetch_assoc($this->result));}function
fetch_row(){return$this->convert(oci_fetch_row($this->result));}function
fetch_field(){$d=$this->offset++;$J=new
\stdClass;$J->name=oci_field_name($this->result,$d);$J->type=oci_field_type($this->result,$d);$J->charsetnr=(preg_match("~raw|blob|bfile~",$J->type)?63:0);return$J;}function
__destruct(){oci_free_statement($this->result);}}}elseif(extension_loaded("pdo_oci")){class
Db
extends
PdoDb{var$extension="PDO_OCI";var$_current_db;function
attach($N,$V,$F){return$this->dsn("oci:dbname=//$N;charset=AL32UTF8",$V,$F);}function
select_db($Pb){$this->_current_db=$Pb;return
true;}}}class
Driver
extends
SqlDriver{static$extensions=array("OCI8","PDO_OCI");static$jush="oracle";var$insertFunctions=array("date"=>"current_date","timestamp"=>"current_timestamp",);var$editFunctions=array("number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("length","lower","round","upper");var$grouping=array("avg","count","count distinct","max","min","sum");function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("number"=>38,"binary_float"=>12,"binary_double"=>21),lang(26)=>array("date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28),lang(27)=>array("char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295),lang(28)=>array("raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296),);}function
begin(){return
true;}function
insertUpdate($R,array$L,array$G){foreach($L
as$O){$vj=array();$Z=array();foreach($O
as$y=>$X){$vj[]="$y = $X";if(isset($G[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$vj)." WHERE ".implode(" AND ",$Z))&&connection()->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
hasCStyleEscapes(){return
true;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($jd){return
get_vals("SELECT DISTINCT tablespace_name FROM (
SELECT tablespace_name FROM user_tablespaces
UNION SELECT tablespace_name FROM all_tables WHERE tablespace_name IS NOT NULL
)
ORDER BY 1");}function
limit($H,$Z,$z,$C=0,$Qh=" "){return($C?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $H$Z) t WHERE rownum <= ".($z+$C).") WHERE rnum > $C":($z?" * FROM (SELECT $H$Z) WHERE rownum <= ".($z+$C):" $H$Z"));}function
limit1($R,$H,$Z,$Qh="\n"){return" $H$Z";}function
db_collation($k,$lb){return
get_val("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
logged_user(){return
get_val("SELECT USER FROM DUAL");}function
get_current_db(){$k=connection()->_current_db?:DB;unset(connection()->_current_db);return$k;}function
where_owner($Sg,$rg="owner"){if(!$_GET["ns"])return'';return"$Sg$rg = sys_context('USERENV', 'CURRENT_SCHEMA')";}function
views_table($e){$rg=where_owner('');return"(SELECT $e FROM all_views WHERE ".($rg?:"rownum < 0").")";}function
tables_list(){$Jj=views_table("view_name");$rg=where_owner(" AND ");return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."$rg
UNION SELECT view_name, 'view' FROM $Jj
ORDER BY 1");}function
count_tables($j){$J=array();foreach($j
as$k)$J[$k]=get_val("SELECT COUNT(*) FROM all_tables WHERE tablespace_name = ".q($k));return$J;}function
table_status($B=""){$J=array();$Jh=q($B);$k=get_current_db();$Jj=views_table("view_name");$rg=where_owner(" AND ");foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q($k).$rg.($B!=""?" AND table_name = $Jh":"")."
UNION SELECT view_name, 'view', 0, 0 FROM $Jj".($B!=""?" WHERE view_name = $Jh":"")."
ORDER BY 1")as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return
true;}function
fields($R){$J=array();$rg=where_owner(" AND ");foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($R)."$rg ORDER BY column_id")as$K){$U=$K["DATA_TYPE"];$Qe="$K[DATA_PRECISION],$K[DATA_SCALE]";if($Qe==",")$Qe=$K["CHAR_COL_DECL_LENGTH"];$J[$K["COLUMN_NAME"]]=array("field"=>$K["COLUMN_NAME"],"full_type"=>$U.($Qe?"($Qe)":""),"type"=>strtolower($U),"length"=>$Qe,"default"=>$K["DATA_DEFAULT"],"null"=>($K["NULLABLE"]=="Y"),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1),);}return$J;}function
indexes($R,$h=null){$J=array();$rg=where_owner(" AND ","aic.table_owner");foreach(get_rows("SELECT aic.*, ac.constraint_type, atc.data_default
FROM all_ind_columns aic
LEFT JOIN all_constraints ac ON aic.index_name = ac.constraint_name AND aic.table_name = ac.table_name AND aic.index_owner = ac.owner
LEFT JOIN all_tab_cols atc ON aic.column_name = atc.column_name AND aic.table_name = atc.table_name AND aic.index_owner = atc.owner
WHERE aic.table_name = ".q($R)."$rg
ORDER BY ac.constraint_type, aic.column_position",$h)as$K){$ee=$K["INDEX_NAME"];$nb=$K["DATA_DEFAULT"];$nb=($nb?trim($nb,'"'):$K["COLUMN_NAME"]);$J[$ee]["type"]=($K["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($K["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$J[$ee]["columns"][]=$nb;$J[$ee]["lengths"][]=($K["CHAR_LENGTH"]&&$K["CHAR_LENGTH"]!=$K["COLUMN_LENGTH"]?$K["CHAR_LENGTH"]:null);$J[$ee]["descs"][]=($K["DESCEND"]&&$K["DESCEND"]=="DESC"?'1':null);}return$J;}function
view($B){$Jj=views_table("view_name, text");$L=get_rows('SELECT text "select" FROM '.$Jj.' WHERE view_name = '.q($B));return
reset($L);}function
collations(){return
array();}function
information_schema($k){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){return
h(connection()->error);}function
explain($g,$H){$g->query("EXPLAIN PLAN FOR $H");return$g->query("SELECT * FROM plan_table");}function
found_rows($S,$Z){}function
auto_increment(){return"";}function
alter_table($R,$B,$o,$ld,$qb,$_c,$c,$Ba,$E){$b=$kc=array();$kg=($R?fields($R):array());foreach($o
as$n){$X=$n[1];if($X&&$n[0]!=""&&idf_escape($n[0])!=$X[0])queries("ALTER TABLE ".table($R)." RENAME COLUMN ".idf_escape($n[0])." TO $X[0]");$jg=$kg[$n[0]];if($X&&$jg){$Nf=process_field($jg,$jg);if($X[2]==$Nf[2])$X[2]="";}if($X)$b[]=($R!=""?($n[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($R!=""?")":"");else$kc[]=idf_escape($n[0]);}if($R=="")return
queries("CREATE TABLE ".table($B)." (\n".implode(",\n",$b)."\n)");return(!$b||queries("ALTER TABLE ".table($R)."\n".implode("\n",$b)))&&(!$kc||queries("ALTER TABLE ".table($R)." DROP (".implode(", ",$kc).")"))&&($R==$B||queries("ALTER TABLE ".table($R)." RENAME TO ".table($B)));}function
alter_indexes($R,$b){$kc=array();$eh=array();foreach($b
as$X){if($X[0]!="INDEX"){$X[2]=preg_replace('~ DESC$~','',$X[2]);$i=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");array_unshift($eh,"ALTER TABLE ".table($R).$i);}elseif($X[2]=="DROP")$kc[]=idf_escape($X[1]);else$eh[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R)." (".implode(", ",$X[2]).")";}if($kc)array_unshift($eh,"DROP INDEX ".implode(", ",$kc));foreach($eh
as$H){if(!queries($H))return
false;}return
true;}function
foreign_keys($R){$J=array();$H="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($R);foreach(get_rows($H)as$K)$J[$K['NAME']]=array("db"=>$K['DEST_DB'],"table"=>$K['DEST_TABLE'],"source"=>array($K['SRC_COLUMN']),"target"=>array($K['DEST_COLUMN']),"on_delete"=>$K['ON_DELETE'],"on_update"=>null,);return$J;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($Kj){return
apply_queries("DROP VIEW",$Kj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
last_id($I){return
0;}function
schemas(){$J=get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX')) ORDER BY 1");return($J?:get_vals("SELECT DISTINCT owner FROM all_tables WHERE tablespace_name = ".q(DB)." ORDER BY 1"));}function
get_schema(){return
get_val("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($Hh,$h=null){if(!$h)$h=connection();return$h->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($Hh));}function
show_variables(){return
get_rows('SELECT name, display_value FROM v$parameter');}function
show_status(){$J=array();$L=get_rows('SELECT * FROM v$instance');foreach(reset($L)as$y=>$X)$J[]=array($y,$X);return$J;}function
process_list(){return
get_rows('SELECT
	sess.process AS "process",
	sess.username AS "user",
	sess.schemaname AS "schema",
	sess.status AS "status",
	sess.wait_class AS "wait_class",
	sess.seconds_in_wait AS "seconds_in_wait",
	sql.sql_text AS "sql_text",
	sess.machine AS "machine",
	sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Xc){return
preg_match('~^(columns|database|drop_col|indexes|descidx|processlist|scheme|sql|status|table|variables|view)$~',$Xc);}}add_driver("mssql","MS SQL");if(isset($_GET["mssql"])){define('Adminer\DRIVER',"mssql");if(extension_loaded("sqlsrv")&&$_GET["ext"]!="pdo"){class
Db
extends
SqlDb{var$extension="sqlsrv";private$link,$result;private
function
get_error(){$this->error="";foreach(sqlsrv_errors()as$m){$this->errno=$m["code"];$this->error
.="$m[message]\n";}$this->error=rtrim($this->error);}function
attach($N,$V,$F){$xb=array("UID"=>$V,"PWD"=>$F,"CharacterSet"=>"UTF-8");$mi=adminer()->connectSsl();if(isset($mi["Encrypt"]))$xb["Encrypt"]=$mi["Encrypt"];if(isset($mi["TrustServerCertificate"]))$xb["TrustServerCertificate"]=$mi["TrustServerCertificate"];$k=adminer()->database();if($k!="")$xb["Database"]=$k;$this->link=@sqlsrv_connect(preg_replace('~:~',',',$N),$xb);if($this->link){$ie=sqlsrv_server_info($this->link);$this->server_info=$ie['SQLServerVersion'];}else$this->get_error();return($this->link?'':$this->error);}function
quote($Q){$oj=strlen($Q)!=strlen(utf8_decode($Q));return($oj?"N":"")."'".str_replace("'","''",$Q)."'";}function
select_db($Pb){return$this->query(use_sql($Pb));}function
query($H,$nj=false){$I=sqlsrv_query($this->link,$H);$this->error="";if(!$I){$this->get_error();return
false;}return$this->store_result($I);}function
multi_query($H){$this->result=sqlsrv_query($this->link,$H);$this->error="";if(!$this->result){$this->get_error();return
false;}return
true;}function
store_result($I=null){if(!$I)$I=$this->result;if(!$I)return
false;if(sqlsrv_field_metadata($I))return
new
Result($I);$this->affected_rows=sqlsrv_rows_affected($I);return
true;}function
next_result(){return$this->result?!!sqlsrv_next_result($this->result):false;}}class
Result{var$num_rows;private$result,$offset=0,$fields;function
__construct($I){$this->result=$I;}private
function
convert($K){foreach((array)$K
as$y=>$X){if(is_a($X,'DateTime'))$K[$y]=$X->format("Y-m-d H:i:s");}return$K;}function
fetch_assoc(){return$this->convert(sqlsrv_fetch_array($this->result,SQLSRV_FETCH_ASSOC));}function
fetch_row(){return$this->convert(sqlsrv_fetch_array($this->result,SQLSRV_FETCH_NUMERIC));}function
fetch_field(){if(!$this->fields)$this->fields=sqlsrv_field_metadata($this->result);$n=$this->fields[$this->offset++];$J=new
\stdClass;$J->name=$n["Name"];$J->type=($n["Type"]==1?254:15);$J->charsetnr=0;return$J;}function
seek($C){for($t=0;$t<$C;$t++)sqlsrv_fetch($this->result);}function
__destruct(){sqlsrv_free_stmt($this->result);}}function
last_id($I){return
get_val("SELECT SCOPE_IDENTITY()");}function
explain($g,$H){$g->query("SET SHOWPLAN_ALL ON");$J=$g->query($H);$g->query("SET SHOWPLAN_ALL OFF");return$J;}}else{abstract
class
MssqlDb
extends
PdoDb{function
select_db($Pb){return$this->query(use_sql($Pb));}function
lastInsertId(){return$this->pdo->lastInsertId();}}function
last_id($I){return
connection()->lastInsertId();}function
explain($g,$H){}if(extension_loaded("pdo_sqlsrv")){class
Db
extends
MssqlDb{var$extension="PDO_SQLSRV";function
attach($N,$V,$F){return$this->dsn("sqlsrv:Server=".str_replace(":",",",$N),$V,$F);}}}elseif(extension_loaded("pdo_dblib")){class
Db
extends
MssqlDb{var$extension="PDO_DBLIB";function
attach($N,$V,$F){return$this->dsn("dblib:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$N)),$V,$F);}}}}class
Driver
extends
SqlDriver{static$extensions=array("SQLSRV","PDO_SQLSRV","PDO_DBLIB");static$jush="mssql";var$insertFunctions=array("date|time"=>"getdate");var$editFunctions=array("int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");var$functions=array("len","lower","round","upper");var$grouping=array("avg","count","count distinct","max","min","sum");var$generated=array("PERSISTED","VIRTUAL");var$onActions="NO ACTION|CASCADE|SET NULL|SET DEFAULT";static
function
connect($N,$V,$F){if($N=="")$N="localhost:1433";return
parent::connect($N,$V,$F);}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20),lang(26)=>array("date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10),lang(27)=>array("char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823),lang(28)=>array("binary"=>8000,"varbinary"=>8000,"image"=>2147483647),);}function
insertUpdate($R,array$L,array$G){$o=fields($R);$vj=array();$Z=array();$O=reset($L);$e="c".implode(", c",range(1,count($O)));$Ra=0;$oe=array();foreach($O
as$y=>$X){$Ra++;$B=idf_unescape($y);if(!$o[$B]["auto_increment"])$oe[$y]="c$Ra";if(isset($G[$B]))$Z[]="$y = c$Ra";else$vj[]="$y = c$Ra";}$Fj=array();foreach($L
as$O)$Fj[]="(".implode(", ",$O).")";if($Z){$Td=queries("SET IDENTITY_INSERT ".table($R)." ON");$J=queries("MERGE ".table($R)." USING (VALUES\n\t".implode(",\n\t",$Fj)."\n) AS source ($e) ON ".implode(" AND ",$Z).($vj?"\nWHEN MATCHED THEN UPDATE SET ".implode(", ",$vj):"")."\nWHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($Td?$O:$oe)).") VALUES (".($Td?$e:implode(", ",$oe)).");");if($Td)queries("SET IDENTITY_INSERT ".table($R)." OFF");}else$J=queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES\n".implode(",\n",$Fj));return$J;}function
begin(){return
queries("BEGIN TRANSACTION");}function
tableHelp($B,$ze=false){$Ue=array("sys"=>"catalog-views/sys-","INFORMATION_SCHEMA"=>"information-schema-views/",);$_=$Ue[get_schema()];if($_)return"relational-databases/system-$_".preg_replace('~_~','-',strtolower($B))."-transact-sql";}}function
idf_escape($v){return"[".str_replace("]","]]",$v)."]";}function
table($v){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($v);}function
get_databases($jd){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb')");}function
limit($H,$Z,$z,$C=0,$Qh=" "){return($z?" TOP (".($z+$C).")":"")." $H$Z";}function
limit1($R,$H,$Z,$Qh="\n"){return
limit($H,$Z,1,0,$Qh);}function
db_collation($k,$lb){return
get_val("SELECT collation_name FROM sys.databases WHERE name = ".q($k));}function
logged_user(){return
get_val("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($j){$J=array();foreach($j
as$k){connection()->select_db($k);$J[$k]=get_val("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$J;}function
table_status($B=""){$J=array();foreach(get_rows("SELECT ao.name AS Name, ao.type_desc AS Engine, (SELECT value FROM fn_listextendedproperty(default, 'SCHEMA', schema_name(schema_id), 'TABLE', ao.name, null, null)) AS Comment
FROM sys.all_objects AS ao
WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($B!=""?"AND name = ".q($B):"ORDER BY name"))as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return$S["Engine"]=="VIEW";}function
fk_support($S){return
true;}function
fields($R){$sb=get_key_vals("SELECT objname, cast(value as varchar(max)) FROM fn_listextendedproperty('MS_DESCRIPTION', 'schema', ".q(get_schema()).", 'table', ".q($R).", 'column', NULL)");$J=array();$yi=get_val("SELECT object_id FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') AND name = ".q($R));foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, d.definition [default], d.name default_constraint, i.is_primary_key
FROM sys.all_columns c
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.object_id
LEFT JOIN sys.index_columns ic ON c.object_id = ic.object_id AND c.column_id = ic.column_id
LEFT JOIN sys.indexes i ON ic.object_id = i.object_id AND ic.index_id = i.index_id
WHERE c.object_id = ".q($yi))as$K){$U=$K["type"];$Qe=(preg_match("~char|binary~",$U)?intval($K["max_length"])/($U[0]=='n'?2:1):($U=="decimal"?"$K[precision],$K[scale]":""));$J[$K["name"]]=array("field"=>$K["name"],"full_type"=>$U.($Qe?"($Qe)":""),"type"=>$U,"length"=>$Qe,"default"=>(preg_match("~^\('(.*)'\)$~",$K["default"],$A)?str_replace("''","'",$A[1]):$K["default"]),"default_constraint"=>$K["default_constraint"],"null"=>$K["is_nullable"],"auto_increment"=>$K["is_identity"],"collation"=>$K["collation_name"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1),"primary"=>$K["is_primary_key"],"comment"=>$sb[$K["name"]],);}foreach(get_rows("SELECT * FROM sys.computed_columns WHERE object_id = ".q($yi))as$K){$J[$K["name"]]["generated"]=($K["is_persisted"]?"PERSISTED":"VIRTUAL");$J[$K["name"]]["default"]=$K["definition"];}return$J;}function
indexes($R,$h=null){$J=array();foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($R),$h)as$K){$B=$K["name"];$J[$B]["type"]=($K["is_primary_key"]?"PRIMARY":($K["is_unique"]?"UNIQUE":"INDEX"));$J[$B]["lengths"]=array();$J[$B]["columns"][$K["key_ordinal"]]=$K["column_name"];$J[$B]["descs"][$K["key_ordinal"]]=($K["is_descending_key"]?'1':null);}return$J;}function
view($B){return
array("select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',get_val("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($B))));}function
collations(){$J=array();foreach(get_vals("SELECT name FROM fn_helpcollations()")as$c)$J[preg_replace('~_.*~','',$c)][]=$c;return$J;}function
information_schema($k){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){return
nl_br(h(preg_replace('~^(\[[^]]*])+~m','',connection()->error)));}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).(preg_match('~^[a-z0-9_]+$~i',$c)?" COLLATE $c":""));}function
drop_databases($j){return
queries("DROP DATABASE ".implode(", ",array_map('Adminer\idf_escape',$j)));}function
rename_database($B,$c){if(preg_match('~^[a-z0-9_]+$~i',$c))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $c");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($B));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($R,$B,$o,$ld,$qb,$_c,$c,$Ba,$E){$b=array();$sb=array();$kg=fields($R);foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$b["DROP"][]=" COLUMN $d";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);$sb[$n[0]]=$X[5];unset($X[5]);if(preg_match('~ AS ~',$X[3]))unset($X[1],$X[2]);if($n[0]=="")$b["ADD"][]="\n  ".implode("",$X).($R==""?substr($ld[$X[0]],16+strlen($X[0])):"");else{$l=$X[3];unset($X[3]);unset($X[6]);if($d!=$X[0])queries("EXEC sp_rename ".q(table($R).".$d").", ".q(idf_unescape($X[0])).", 'COLUMN'");$b["ALTER COLUMN ".implode("",$X)][]="";$jg=$kg[$n[0]];if(default_value($jg)!=$l){if($jg["default"]!==null)$b["DROP"][]=" ".idf_escape($jg["default_constraint"]);if($l)$b["ADD"][]="\n $l FOR $d";}}}}if($R=="")return
queries("CREATE TABLE ".table($B)." (".implode(",",(array)$b["ADD"])."\n)");if($R!=$B)queries("EXEC sp_rename ".q(table($R)).", ".q($B));if($ld)$b[""]=$ld;foreach($b
as$y=>$X){if(!queries("ALTER TABLE ".table($B)." $y".implode(",",$X)))return
false;}foreach($sb
as$y=>$X){$qb=substr($X,9);queries("EXEC sp_dropextendedproperty @name = N'MS_Description', @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($B).", @level2type = N'Column', @level2name = ".q($y));queries("EXEC sp_addextendedproperty
@name = N'MS_Description',
@value = $qb,
@level0type = N'Schema',
@level0name = ".q(get_schema()).",
@level1type = N'Table',
@level1name = ".q($B).",
@level2type = N'Column',
@level2name = ".q($y));}return
true;}function
alter_indexes($R,$b){$w=array();$kc=array();foreach($b
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$kc[]=idf_escape($X[1]);else$w[]=idf_escape($X[1])." ON ".table($R);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R):"ALTER TABLE ".table($R)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$w||queries("DROP INDEX ".implode(", ",$w)))&&(!$kc||queries("ALTER TABLE ".table($R)." DROP ".implode(", ",$kc)));}function
found_rows($S,$Z){}function
foreign_keys($R){$J=array();$Uf=array("CASCADE","NO ACTION","SET NULL","SET DEFAULT");foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($R).", @fktable_owner = ".q(get_schema()))as$K){$q=&$J[$K["FK_NAME"]];$q["db"]=$K["PKTABLE_QUALIFIER"];$q["ns"]=$K["PKTABLE_OWNER"];$q["table"]=$K["PKTABLE_NAME"];$q["on_update"]=$Uf[$K["UPDATE_RULE"]];$q["on_delete"]=$Uf[$K["DELETE_RULE"]];$q["source"][]=$K["FKCOLUMN_NAME"];$q["target"][]=$K["PKCOLUMN_NAME"];}return$J;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($Kj){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$Kj)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables($T,$Kj,$Hi){return
apply_queries("ALTER SCHEMA ".idf_escape($Hi)." TRANSFER",array_merge($T,$Kj));}function
trigger($B,$R){if($B=="")return
array();$L=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($B));$J=reset($L);if($J)$J["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$J["text"]);return$J;}function
triggers($R){$J=array();foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($R))as$K)$J[$K["name"]]=array($K["Timing"],$K["Event"]);return$J;}function
trigger_options(){return
array("Timing"=>array("AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("AS"),);}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){if($_GET["ns"]!="")return$_GET["ns"];return
get_val("SELECT SCHEMA_NAME()");}function
set_schema($Fh){$_GET["ns"]=$Fh;return
true;}function
create_sql($R,$Ba,$ri){if(is_view(table_status1($R))){$Jj=view($R);return"CREATE VIEW ".table($R)." AS $Jj[select]";}$o=array();$G=false;foreach(fields($R)as$B=>$n){$X=process_field($n,$n);if($X[6])$G=true;$o[]=implode("",$X);}foreach(indexes($R)as$B=>$w){if(!$G||$w["type"]!="PRIMARY"){$e=array();foreach($w["columns"]as$y=>$X)$e[]=idf_escape($X).($w["descs"][$y]?" DESC":"");$B=idf_escape($B);$o[]=($w["type"]=="INDEX"?"INDEX $B":"CONSTRAINT $B ".($w["type"]=="UNIQUE"?"UNIQUE":"PRIMARY KEY"))." (".implode(", ",$e).")";}}foreach(driver()->checkConstraints($R)as$B=>$Ya)$o[]="CONSTRAINT ".idf_escape($B)." CHECK ($Ya)";return"CREATE TABLE ".table($R)." (\n\t".implode(",\n\t",$o)."\n)";}function
foreign_keys_sql($R){$o=array();foreach(foreign_keys($R)as$ld)$o[]=ltrim(format_foreign_key($ld));return($o?"ALTER TABLE ".table($R)." ADD\n\t".implode(",\n\t",$o).";\n\n":"");}function
truncate_sql($R){return"TRUNCATE TABLE ".table($R);}function
use_sql($Pb){return"USE ".idf_escape($Pb);}function
trigger_sql($R){$J="";foreach(triggers($R)as$B=>$gj)$J
.=create_trigger(" ON ".table($R),trigger($B,$R)).";";return$J;}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Xc){return
preg_match('~^(check|comment|columns|database|drop_col|dump|indexes|descidx|scheme|sql|table|trigger|view|view_trigger)$~',$Xc);}}class
Adminer{static$instance;var$error='';function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'><img src='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.3.0")."' width='24' height='24' alt='' id='logo'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($i=false){return
password_file($i);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($N){return
h($N);}function
database(){return
DB;}function
databases($jd=true){return
get_databases($jd);}function
pluginsLinks(){}function
operators(){return
driver()->operators;}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
headers(){}function
csp(array$Ib){return$Ib;}function
head($Mb=null){return
true;}function
bodyClass(){echo" adminer";}function
css(){$J=array();foreach(array("","-dark")as$uf){$p="adminer$uf.css";if(file_exists($p)){$bd=file_get_contents($p);$J["$p?v=".crc32($bd)]=($uf?"dark":(preg_match('~prefers-color-scheme:\s*dark~',$bd)?'':'light'));}}return$J;}function
loginForm(){echo"<table class='layout'>\n",adminer()->loginFormField('driver','<tr><th>'.lang(32).'<td>',html_select("auth[driver]",SqlDriver::$drivers,DRIVER,"loginDriver(this);")),adminer()->loginFormField('server','<tr><th>'.lang(33).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'),adminer()->loginFormField('username','<tr><th>'.lang(34).'<td>','<input name="auth[username]" id="username" autofocus value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("const authDriver = qs('#username').form['auth[driver]']; authDriver && authDriver.onchange();")),adminer()->loginFormField('password','<tr><th>'.lang(35).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'),adminer()->loginFormField('db','<tr><th>'.lang(36).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'),"</table>\n","<p><input type='submit' value='".lang(37)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(38))."\n";}function
loginFormField($B,$Jd,$Y){return$Jd.$Y."\n";}function
login($We,$F){if($F=="")return
lang(39,target_blank());return
true;}function
tableName(array$xi){return
h($xi["Name"]);}function
fieldName(array$n,$dg=0){$U=$n["full_type"];$qb=$n["comment"];return'<span title="'.h($U.($qb!=""?($U?": ":"").$qb:'')).'">'.h($n["field"]).'</span>';}function
selectLinks(array$xi,$O=""){$B=$xi["Name"];echo'<p class="links">';$Ue=array("select"=>lang(40));if(support("table")||support("indexes"))$Ue["table"]=lang(41);$ze=false;if(support("table")){$ze=is_view($xi);if($ze)$Ue["view"]=lang(42);else$Ue["create"]=lang(43);}if($O!==null)$Ue["edit"]=lang(44);foreach($Ue
as$y=>$X)echo" <a href='".h(ME)."$y=".urlencode($B).($y=="edit"?$O:"")."'".bold(isset($_GET[$y])).">$X</a>";echo
doc_link(array(JUSH=>driver()->tableHelp($B,$ze)),"?"),"\n";}function
foreignKeys($R){return
foreign_keys($R);}function
backwardKeys($R,$wi){return
array();}function
backwardKeysPrint(array$Fa,array$K){}function
selectQuery($H,$ni,$Vc=false){$J="</p>\n";if(!$Vc&&($Nj=driver()->warnings())){$u="warnings";$J=", <a href='#$u'>".lang(45)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."$J<div id='$u' class='hidden'>\n$Nj</div>\n";}return"<p><code class='jush-".JUSH."'>".h(str_replace("\n"," ",$H))."</code> <span class='time'>(".format_time($ni).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($H)."'>".lang(10)."</a>":"").$J;}function
sqlCommandQuery($H){return
shorten_utf8(trim($H),1000);}function
sqlPrintAfter(){}function
rowDescription($R){return"";}function
rowDescriptions(array$L,array$md){return$L;}function
selectLink($X,array$n){}function
selectVal($X,$_,array$n,$ng){$J=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$n["type"])&&!preg_match("~var~",$n["type"])?"<code>$X</code>":(preg_match('~json~',$n["type"])?"<code class='jush-js'>$X</code>":$X)));if(preg_match('~blob|bytea|raw|file~',$n["type"])&&!is_utf8($X))$J="<i>".lang(46,strlen($ng))."</i>";return($_?"<a href='".h($_)."'".(is_url($_)?target_blank():"").">$J</a>":$J);}function
editVal($X,array$n){return$X;}function
config(){return
array();}function
tableStructurePrint(array$o,$xi=null){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr><th>".lang(47)."<td>".lang(48).(support("comment")?"<td>".lang(49):"")."</thead>\n";$qi=driver()->structuredTypes();foreach($o
as$n){echo"<tr><th>".h($n["field"]);$U=h($n["full_type"]);$c=h($n["collation"]);echo"<td><span title='$c'>".(in_array($U,(array)$qi[lang(31)])?"<a href='".h(ME.'type='.urlencode($U))."'>$U</a>":$U.($c&&isset($xi["Collation"])&&$c!=$xi["Collation"]?" $c":""))."</span>",($n["null"]?" <i>NULL</i>":""),($n["auto_increment"]?" <i>".lang(50)."</i>":"");$l=h($n["default"]);echo(isset($n["default"])?" <span title='".lang(51)."'>[<b>".($n["generated"]?"<code class='jush-".JUSH."'>$l</code>":$l)."</b>]</span>":""),(support("comment")?"<td>".h($n["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint(array$x,array$xi){$yg=false;foreach($x
as$B=>$w)$yg|=!!$w["partial"];echo"<table>\n";$Ub=first(driver()->indexAlgorithms($xi));foreach($x
as$B=>$w){ksort($w["columns"]);$Wg=array();foreach($w["columns"]as$y=>$X)$Wg[]="<i>".h($X)."</i>".($w["lengths"][$y]?"(".$w["lengths"][$y].")":"").($w["descs"][$y]?" DESC":"");echo"<tr title='".h($B)."'>","<th>$w[type]".($Ub&&$w['algorithm']!=$Ub?" ($w[algorithm])":""),"<td>".implode(", ",$Wg);if($yg)echo"<td>".($w['partial']?"<code class='jush-".JUSH."'>WHERE ".h($w['partial']):"");echo"\n";}echo"</table>\n";}function
selectColumnsPrint(array$M,array$e){print_fieldset("select",lang(52),$M);$t=0;$M[""]=array();foreach($M
as$y=>$X){$X=idx($_GET["columns"],$y,array());$d=select_input(" name='columns[$t][col]'",$e,$X["col"],($y!==""?"selectFieldChange":"selectAddRow"));echo"<div>".(driver()->functions||driver()->grouping?html_select("columns[$t][fun]",array(-1=>"")+array_filter(array(lang(53)=>driver()->functions,lang(54)=>driver()->grouping)),$X["fun"]).on_help("event.target.value && event.target.value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($y!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($d)":$d)."</div>\n";$t++;}echo"</div></fieldset>\n";}function
selectSearchPrint(array$Z,array$e,array$x){print_fieldset("search",lang(55),$Z);foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT")echo"<div>(<i>".implode("</i>, <i>",array_map('Adminer\h',$w["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$t]' value='".h(idx($_GET["fulltext"],$t))."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$t]",1,isset($_GET["boolean"][$t]),"BOOL"),"</div>\n";}$Va="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$t=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],adminer()->operators())))echo"<div>".select_input(" name='where[$t][col]'",$e,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(56).")"),html_select("where[$t][op]",adminer()->operators(),$X["op"],$Va),"<input type='search' name='where[$t][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $Va }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}echo"</div></fieldset>\n";}function
selectOrderPrint(array$dg,array$e,array$x){print_fieldset("sort",lang(57),$dg);$t=0;foreach((array)$_GET["order"]as$y=>$X){if($X!=""){echo"<div>".select_input(" name='order[$t]'",$e,$X,"selectFieldChange"),checkbox("desc[$t]",1,isset($_GET["desc"][$y]),lang(58))."</div>\n";$t++;}}echo"<div>".select_input(" name='order[$t]'",$e,"","selectAddRow"),checkbox("desc[$t]",1,false,lang(58))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($z){echo"<fieldset><legend>".lang(59)."</legend><div>","<input type='number' name='limit' class='size' value='".intval($z)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($Ni){if($Ni!==null)echo"<fieldset><legend>".lang(60)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($Ni)."'>","</div></fieldset>\n";}function
selectActionPrint(array$x){echo"<fieldset><legend>".lang(61)."</legend><div>","<input type='submit' value='".lang(52)."'>"," <span id='noindex' title='".lang(62)."'></span>","<script".nonce().">\n","const indexColumns = ";$e=array();foreach($x
as$w){$Lb=reset($w["columns"]);if($w["type"]!="FULLTEXT"&&$Lb)$e[$Lb]=1;}$e[""]=1;foreach($e
as$y=>$X)json_row($y);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint(array$xc,array$e){}function
selectColumnsProcess(array$e,array$x){$M=array();$yd=array();foreach((array)$_GET["columns"]as$y=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],driver()->functions)||in_array($X["fun"],driver()->grouping)))){$M[$y]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],driver()->grouping))$yd[]=$M[$y];}}return
array($M,$yd);}function
selectSearchProcess(array$o,array$x){$J=array();foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT"&&idx($_GET["fulltext"],$t)!="")$J[]="MATCH (".implode(", ",array_map('Adminer\idf_escape',$w["columns"])).") AGAINST (".q($_GET["fulltext"][$t]).(isset($_GET["boolean"][$t])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$y=>$X){$jb=$X["col"];if("$jb$X[val]"!=""&&in_array($X["op"],adminer()->operators())){$ub=array();foreach(($jb!=""?array($jb=>$o[$jb]):$o)as$B=>$n){$Sg="";$tb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Yd=process_length($X["val"]);$tb
.=" ".($Yd!=""?$Yd:"(NULL)");}elseif($X["op"]=="SQL")$tb=" $X[val]";elseif(preg_match('~^(I?LIKE) %%$~',$X["op"],$A))$tb=" $A[1] ".adminer()->processInput($n,"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$Sg="$X[op](".q($X["val"]).", ";$tb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$tb
.=" ".adminer()->processInput($n,$X["val"]);if($jb!=""||(isset($n["privileges"]["where"])&&(preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$n["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$n["type"]))&&(!preg_match('~date|timestamp~',$n["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"]))))$ub[]=$Sg.driver()->convertSearch(idf_escape($B),$X,$n).$tb;}$J[]=(count($ub)==1?$ub[0]:($ub?"(".implode(" OR ",$ub).")":"1 = 0"));}}return$J;}function
selectOrderProcess(array$o,array$x){$J=array();foreach((array)$_GET["order"]as$y=>$X){if($X!="")$J[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$y])?" DESC":"");}return$J;}function
selectLimitProcess(){return(isset($_GET["limit"])?intval($_GET["limit"]):50);}function
selectLengthProcess(){return(isset($_GET["text_length"])?"$_GET[text_length]":"100");}function
selectEmailProcess(array$Z,array$md){return
false;}function
selectQueryBuild(array$M,array$Z,array$yd,array$dg,$z,$D){return"";}function
messageQuery($H,$Oi,$Vc=false){restart_session();$Ld=&get_session("queries");if(!idx($Ld,$_GET["db"]))$Ld[$_GET["db"]]=array();if(strlen($H)>1e6)$H=preg_replace('~[\x80-\xFF]+$~','',substr($H,0,1e6))."\n…";$Ld[$_GET["db"]][]=array($H,time(),$Oi);$ji="sql-".count($Ld[$_GET["db"]]);$J="<a href='#$ji' class='toggle'>".lang(63)."</a>\n";if(!$Vc&&($Nj=driver()->warnings())){$u="warnings-".count($Ld[$_GET["db"]]);$J="<a href='#$u' class='toggle'>".lang(45)."</a>, $J<div id='$u' class='hidden'>\n$Nj</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $J<div id='$ji' class='hidden'><pre><code class='jush-".JUSH."'>".shorten_utf8($H,1000)."</code></pre>".($Oi?" <span class='time'>($Oi)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($Ld[$_GET["db"]])-1)).'">'.lang(10).'</a>':'').'</div>';}function
editRowPrint($R,array$o,$K,$vj){}function
editFunctions(array$n){$J=($n["null"]?"NULL/":"");$vj=isset($_GET["select"])||where($_GET);foreach(array(driver()->insertFunctions,driver()->editFunctions)as$y=>$td){if(!$y||(!isset($_GET["call"])&&$vj)){foreach($td
as$Gg=>$X){if(!$Gg||preg_match("~$Gg~",$n["type"]))$J
.="/$X";}}if($y&&$td&&!preg_match('~set|blob|bytea|raw|file|bool~',$n["type"]))$J
.="/SQL";}if($n["auto_increment"]&&!$vj)$J=lang(50);return
explode("/",$J);}function
editInput($R,array$n,$_a,$Y){if($n["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$_a value='-1' checked><i>".lang(8)."</i></label> ":"").($n["null"]?"<label><input type='radio'$_a value=''".($Y!==null||isset($_GET["select"])?"":" checked")."><i>NULL</i></label> ":"").enum_input("radio",$_a,$n,$Y,$Y===0?0:null);return"";}function
editHint($R,array$n,$Y){return"";}function
processInput(array$n,$Y,$s=""){if($s=="SQL")return$Y;$B=$n["field"];$J=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$s))$J="$s()";elseif(preg_match('~^current_(date|timestamp)$~',$s))$J=$s;elseif(preg_match('~^([+-]|\|\|)$~',$s))$J=idf_escape($B)." $s $J";elseif(preg_match('~^[+-] interval$~',$s))$J=idf_escape($B)." $s ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$J);elseif(preg_match('~^(addtime|subtime|concat)$~',$s))$J="$s(".idf_escape($B).", $J)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$s))$J="$s($J)";return
unconvert_field($n,$J);}function
dumpOutput(){$J=array('text'=>lang(64),'file'=>lang(65));if(function_exists('gzencode'))$J['gz']='gzip';return$J;}function
dumpFormat(){return(support("dump")?array('sql'=>'SQL'):array())+array('csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($k){}function
dumpTable($R,$ri,$ze=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($ri)dump_csv(array_keys(fields($R)));}else{if($ze==2){$o=array();foreach(fields($R)as$B=>$n)$o[]=idf_escape($B)." $n[full_type]";$i="CREATE TABLE ".table($R)." (".implode(", ",$o).")";}else$i=create_sql($R,$_POST["auto_increment"],$ri);set_utf8mb4($i);if($ri&&$i){if($ri=="DROP+CREATE"||$ze==1)echo"DROP ".($ze==2?"VIEW":"TABLE")." IF EXISTS ".table($R).";\n";if($ze==1)$i=remove_definer($i);echo"$i;\n\n";}}}function
dumpData($R,$ri,$H){if($ri){$ef=(JUSH=="sqlite"?0:1048576);$o=array();$Ud=false;if($_POST["format"]=="sql"){if($ri=="TRUNCATE+INSERT")echo
truncate_sql($R).";\n";$o=fields($R);if(JUSH=="mssql"){foreach($o
as$n){if($n["auto_increment"]){echo"SET IDENTITY_INSERT ".table($R)." ON;\n";$Ud=true;break;}}}}$I=connection()->query($H,1);if($I){$oe="";$Pa="";$De=array();$ud=array();$ti="";$Yc=($R!=''?'fetch_assoc':'fetch_row');$Eb=0;while($K=$I->$Yc()){if(!$De){$Fj=array();foreach($K
as$X){$n=$I->fetch_field();if(idx($o[$n->name],'generated')){$ud[$n->name]=true;continue;}$De[]=$n->name;$y=idf_escape($n->name);$Fj[]="$y = VALUES($y)";}$ti=($ri=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$Fj):"").";\n";}if($_POST["format"]!="sql"){if($ri=="table"){dump_csv($De);$ri="INSERT";}dump_csv($K);}else{if(!$oe)$oe="INSERT INTO ".table($R)." (".implode(", ",array_map('Adminer\idf_escape',$De)).") VALUES";foreach($K
as$y=>$X){if($ud[$y]){unset($K[$y]);continue;}$n=$o[$y];$K[$y]=($X!==null?unconvert_field($n,preg_match(number_type(),$n["type"])&&!preg_match('~\[~',$n["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$Dh=($ef?"\n":" ")."(".implode(",\t",$K).")";if(!$Pa)$Pa=$oe.$Dh;elseif(JUSH=='mssql'?$Eb%1000!=0:strlen($Pa)+4+strlen($Dh)+strlen($ti)<$ef)$Pa
.=",$Dh";else{echo$Pa.$ti;$Pa=$oe.$Dh;}}$Eb++;}if($Pa)echo$Pa.$ti;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",connection()->error)."\n";if($Ud)echo"SET IDENTITY_INSERT ".table($R)." OFF;\n";}}function
dumpFilename($Sd){return
friendly_url($Sd!=""?$Sd:(SERVER!=""?SERVER:"localhost"));}function
dumpHeaders($Sd,$wf=false){$qg=$_POST["output"];$Qc=(preg_match('~sql~',$_POST["format"])?"sql":($wf?"tar":"csv"));header("Content-Type: ".($qg=="gz"?"application/x-gzip":($Qc=="tar"?"application/x-tar":($Qc=="sql"||$qg!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($qg=="gz"){ob_start(function($Q){return
gzencode($Q);},1e6);}return$Qc;}function
dumpFooter(){if($_POST["format"]=="sql")echo"-- ".gmdate("Y-m-d H:i:s e")."\n";}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(66)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(67):lang(68))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(69)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(70)."</a>\n":"");return
true;}function
navigation($tf){echo"<h1>".adminer()->name()." <span class='version'>".VERSION;$Df=$_COOKIE["adminer_version"];echo" <a href='https://www.adminer.org/#download'".target_blank()." id='version'>".(version_compare(VERSION,$Df)<0?h($Df):"")."</a>","</span></h1>\n";switch_lang();if($tf=="auth"){$qg="";foreach((array)$_SESSION["pwds"]as$Hj=>$Vh){foreach($Vh
as$N=>$Cj){$B=h(get_setting("vendor-$Hj-$N")?:get_driver($Hj));foreach($Cj
as$V=>$F){if($F!==null){$Sb=$_SESSION["db"][$Hj][$N][$V];foreach(($Sb?array_keys($Sb):array(""))as$k)$qg
.="<li><a href='".h(auth_url($Hj,$N,$V,$k))."'>($B) ".h($V.($N!=""?"@".adminer()->serverName($N):"").($k!=""?" - $k":""))."</a>\n";}}}}if($qg)echo"<ul id='logins'>\n$qg</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$T=array();if($_GET["ns"]!==""&&!$tf&&DB!=""){connection()->select_db(DB);$T=table_status('',true);}adminer()->syntaxHighlighting($T);adminer()->databasesPrint($tf);$ka=array();if(DB==""||!$tf){if(support("sql")){$ka[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(63)."</a>";$ka[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(71)."</a>";}$ka[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(72)."</a>";}$Zd=$_GET["ns"]!==""&&!$tf&&DB!="";if($Zd)$ka[]='<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(73)."</a>";echo($ka?"<p class='links'>\n".implode("\n",$ka)."\n":"");if($Zd){if($T)adminer()->tablesPrint($T);else
echo"<p class='message'>".lang(9)."</p>\n";}}}function
syntaxHighlighting(array$T){echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=5.3.0",true);if(support("sql")){echo"<script".nonce().">\n";if($T){$Ue=array();foreach($T
as$R=>$U)$Ue[]=preg_quote($R,'/');echo"var jushLinks = { ".JUSH.": [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$Ue).")\\b/g ] };\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.".JUSH.";\n";if(isset($_GET["sql"])||isset($_GET["trigger"])||isset($_GET["check"])){$Di=array_fill_keys(array_keys($T),array());foreach(driver()->allFields()as$R=>$o){foreach($o
as$n)$Di[$R][]=$n["field"];}echo"addEventListener('DOMContentLoaded', () => { autocompleter = jush.autocompleteSql('".idf_escape("")."', ".json_encode($Di)."); });\n";}}echo"</script>\n";}echo
script("syntaxHighlighting('".preg_replace('~^(\d\.?\d).*~s','\1',connection()->server_info)."', '".connection()->flavor."');");}function
databasesPrint($tf){$j=adminer()->databases();if(DB&&$j&&!in_array(DB,$j))array_unshift($j,DB);echo"<form action=''>\n<p id='dbs'>\n";hidden_fields_get();$Qb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<label title='".lang(36)."'>".lang(74).": ".($j?html_select("db",array(""=>"")+$j,DB).$Qb:"<input name='db' value='".h(DB)."' autocapitalize='off' size='19'>\n")."</label>","<input type='submit' value='".lang(20)."'".($j?" class='hidden'":"").">\n";if(support("scheme")){if($tf!="db"&&DB!=""&&connection()->select_db(DB)){echo"<br><label>".lang(75).": ".html_select("ns",array(""=>"")+adminer()->schemas(),$_GET["ns"])."$Qb</label>";if($_GET["ns"]!="")set_schema($_GET["ns"]);}}foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo
input_hidden($X);break;}}echo"</p></form>\n";}function
tablesPrint(array$T){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($T
as$R=>$P){$R="$R";$B=adminer()->tableName($P);if($B!=""&&!$P["inherited"])echo'<li><a href="'.h(ME).'select='.urlencode($R).'"'.bold($_GET["select"]==$R||$_GET["edit"]==$R,"select")." title='".lang(40)."'>".lang(76)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($R).'"'.bold(in_array($R,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"],$_GET["check"],$_GET["view"])),(is_view($P)?"view":"structure"))." title='".lang(41)."'>$B</a>":"<span>$B</span>")."\n";}echo"</ul>\n";}}class
Plugins{private
static$append=array('dumpFormat'=>true,'dumpOutput'=>true,'editRowPrint'=>true,'editFunctions'=>true,'config'=>true);var$plugins;var$error='';private$hooks=array();function
__construct($Lg){if($Lg===null){$Lg=array();$Ja="adminer-plugins";if(is_dir($Ja)){foreach(glob("$Ja/*.php")as$p)$ae=include_once"./$p";}$Kd=" href='https://www.adminer.org/plugins/#use'".target_blank();if(file_exists("$Ja.php")){$ae=include_once"./$Ja.php";if(is_array($ae)){foreach($ae
as$Kg)$Lg[get_class($Kg)]=$Kg;}else$this->error
.=lang(77,"<b>$Ja.php</b>",$Kd)."<br>";}foreach(get_declared_classes()as$fb){if(!$Lg[$fb]&&preg_match('~^Adminer\w~i',$fb)){$oh=new
\ReflectionClass($fb);$zb=$oh->getConstructor();if($zb&&$zb->getNumberOfRequiredParameters())$this->error
.=lang(78,$Kd,"<b>$fb</b>","<b>$Ja.php</b>")."<br>";else$Lg[$fb]=new$fb;}}}$this->plugins=$Lg;$na=new
Adminer;$Lg[]=$na;$oh=new
\ReflectionObject($na);foreach($oh->getMethods()as$rf){foreach($Lg
as$Kg){$B=$rf->getName();if(method_exists($Kg,$B))$this->hooks[$B][]=$Kg;}}}function
__call($B,array$vg){$wa=array();foreach($vg
as$y=>$X)$wa[]=&$vg[$y];$J=null;foreach($this->hooks[$B]as$Kg){$Y=call_user_func_array(array($Kg,$B),$wa);if($Y!==null){if(!self::$append[$B])return$Y;$J=$Y+(array)$J;}}return$J;}}abstract
class
Plugin{protected$translations=array();function
description(){return$this->lang('');}function
screenshot(){return"";}protected
function
lang($v,$Jf=null){$wa=func_get_args();$wa[0]=idx($this->translations[LANG],$v)?:$v;return
call_user_func_array('Adminer\lang_format',$wa);}}Adminer::$instance=(function_exists('adminer_object')?adminer_object():(is_dir("adminer-plugins")||file_exists("adminer-plugins.php")?new
Plugins(null):new
Adminer));SqlDriver::$drivers=array("server"=>"MySQL / MariaDB")+SqlDriver::$drivers;if(!defined('Adminer\DRIVER')){define('Adminer\DRIVER',"server");if(extension_loaded("mysqli")&&$_GET["ext"]!="pdo"){class
Db
extends
\MySQLi{static$instance;var$extension="MySQLi",$flavor='';function
__construct(){parent::init();}function
attach($N,$V,$F){mysqli_report(MYSQLI_REPORT_OFF);list($Od,$Mg)=explode(":",$N,2);$mi=adminer()->connectSsl();if($mi)$this->ssl_set($mi['key'],$mi['cert'],$mi['ca'],'','');$J=@$this->real_connect(($N!=""?$Od:ini_get("mysqli.default_host")),($N.$V!=""?$V:ini_get("mysqli.default_user")),($N.$V.$F!=""?$F:ini_get("mysqli.default_pw")),null,(is_numeric($Mg)?intval($Mg):ini_get("mysqli.default_port")),(is_numeric($Mg)?null:$Mg),($mi?($mi['verify']!==false?2048:64):0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return($J?'':$this->error);}function
set_charset($Xa){if(parent::set_charset($Xa))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $Xa");}function
next_result(){return
self::more_results()&&parent::next_result();}function
quote($Q){return"'".$this->escape_string($Q)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Db
extends
SqlDb{private$link;function
attach($N,$V,$F){if(ini_bool("mysql.allow_local_infile"))return
lang(79,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");$this->link=@mysql_connect(($N!=""?$N:ini_get("mysql.default_host")),("$N$V"!=""?$V:ini_get("mysql.default_user")),("$N$V$F"!=""?$F:ini_get("mysql.default_password")),true,131072);if(!$this->link)return
mysql_error();$this->server_info=mysql_get_server_info($this->link);return'';}function
set_charset($Xa){if(function_exists('mysql_set_charset')){if(mysql_set_charset($Xa,$this->link))return
true;mysql_set_charset('utf8',$this->link);}return$this->query("SET NAMES $Xa");}function
quote($Q){return"'".mysql_real_escape_string($Q,$this->link)."'";}function
select_db($Pb){return
mysql_select_db($Pb,$this->link);}function
query($H,$nj=false){$I=@($nj?mysql_unbuffered_query($H,$this->link):mysql_query($H,$this->link));$this->error="";if(!$I){$this->errno=mysql_errno($this->link);$this->error=mysql_error($this->link);return
false;}if($I===true){$this->affected_rows=mysql_affected_rows($this->link);$this->info=mysql_info($this->link);return
true;}return
new
Result($I);}}class
Result{var$num_rows;private$result;private$offset=0;function
__construct($I){$this->result=$I;$this->num_rows=mysql_num_rows($I);}function
fetch_assoc(){return
mysql_fetch_assoc($this->result);}function
fetch_row(){return
mysql_fetch_row($this->result);}function
fetch_field(){$J=mysql_fetch_field($this->result,$this->offset++);$J->orgtable=$J->table;$J->charsetnr=($J->blob?63:0);return$J;}function
__destruct(){mysql_free_result($this->result);}}}elseif(extension_loaded("pdo_mysql")){class
Db
extends
PdoDb{var$extension="PDO_MySQL";function
attach($N,$V,$F){$bg=array(\PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$mi=adminer()->connectSsl();if($mi){if($mi['key'])$bg[\PDO::MYSQL_ATTR_SSL_KEY]=$mi['key'];if($mi['cert'])$bg[\PDO::MYSQL_ATTR_SSL_CERT]=$mi['cert'];if($mi['ca'])$bg[\PDO::MYSQL_ATTR_SSL_CA]=$mi['ca'];if(isset($mi['verify']))$bg[\PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT]=$mi['verify'];}return$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$N)),$V,$F,$bg);}function
set_charset($Xa){return$this->query("SET NAMES $Xa");}function
select_db($Pb){return$this->query("USE ".idf_escape($Pb));}function
query($H,$nj=false){$this->pdo->setAttribute(\PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$nj);return
parent::query($H,$nj);}}}class
Driver
extends
SqlDriver{static$extensions=array("MySQLi","MySQL","PDO_MySQL");static$jush="sql";var$unsigned=array("unsigned","zerofill","unsigned zerofill");var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");var$functions=array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($N,$V,$F){$g=parent::connect($N,$V,$F);if(is_string($g)){if(function_exists('iconv')&&!is_utf8($g)&&strlen($Dh=iconv("windows-1250","utf-8",$g))>strlen($g))$g=$Dh;return$g;}$g->set_charset(charset($g));$g->query("SET sql_quote_show_create = 1, autocommit = 1");$g->flavor=(preg_match('~MariaDB~',$g->server_info)?'maria':'mysql');add_driver(DRIVER,($g->flavor=='maria'?"MariaDB":"MySQL"));return$g;}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(26)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(27)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(80)=>array("enum"=>65535,"set"=>64),lang(28)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(30)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),);$this->insertFunctions=array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",);if(min_version('5.7.8',10.2,$g))$this->types[lang(27)]["json"]=4294967295;if(min_version('',10.7,$g)){$this->types[lang(27)]["uuid"]=128;$this->insertFunctions['uuid']='uuid';}if(min_version(9,'',$g)){$this->types[lang(25)]["vector"]=16383;$this->insertFunctions['vector']='string_to_vector';}if(min_version(5.1,'',$g))$this->partitionBy=array("HASH","LINEAR HASH","KEY","LINEAR KEY","RANGE","LIST");if(min_version(5.7,10.2,$g))$this->generated=array("STORED","VIRTUAL");}function
unconvertFunction(array$n){return(preg_match("~binary~",$n["type"])?"<code class='jush-sql'>UNHEX</code>":($n["type"]=="bit"?doc_link(array('sql'=>'bit-value-literals.html'),"<code>b''</code>"):(preg_match("~geometry|point|linestring|polygon~",$n["type"])?"<code class='jush-sql'>GeomFromText</code>":"")));}function
insert($R,array$O){return($O?parent::insert($R,$O):queries("INSERT INTO ".table($R)." ()\nVALUES ()"));}function
insertUpdate($R,array$L,array$G){$e=array_keys(reset($L));$Sg="INSERT INTO ".table($R)." (".implode(", ",$e).") VALUES\n";$Fj=array();foreach($e
as$y)$Fj[$y]="$y = VALUES($y)";$ti="\nON DUPLICATE KEY UPDATE ".implode(", ",$Fj);$Fj=array();$Qe=0;foreach($L
as$O){$Y="(".implode(", ",$O).")";if($Fj&&(strlen($Sg)+$Qe+strlen($Y)+strlen($ti)>1e6)){if(!queries($Sg.implode(",\n",$Fj).$ti))return
false;$Fj=array();$Qe=0;}$Fj[]=$Y;$Qe+=strlen($Y)+2;}return
queries($Sg.implode(",\n",$Fj).$ti);}function
slowQuery($H,$Pi){if(min_version('5.7.8','10.1.2')){if($this->conn->flavor=='maria')return"SET STATEMENT max_statement_time=$Pi FOR $H";elseif(preg_match('~^(SELECT\b)(.+)~is',$H,$A))return"$A[1] /*+ MAX_EXECUTION_TIME(".($Pi*1000).") */ $A[2]";}}function
convertSearch($v,array$X,array$n){return(preg_match('~char|text|enum|set~',$n["type"])&&!preg_match("~^utf8~",$n["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($v USING ".charset($this->conn).")":$v);}function
warnings(){$I=$this->conn->query("SHOW WARNINGS");if($I&&$I->num_rows){ob_start();print_select_result($I);return
ob_get_clean();}}function
tableHelp($B,$ze=false){$Ye=($this->conn->flavor=='maria');if(information_schema(DB))return
strtolower("information-schema-".($Ye?"$B-table/":str_replace("_","-",$B)."-table.html"));if(DB=="mysql")return($Ye?"mysql$B-table/":"system-schema.html");}function
partitionsInfo($R){$rd="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($R);$I=connection()->query("SELECT PARTITION_METHOD, PARTITION_EXPRESSION, PARTITION_ORDINAL_POSITION $rd ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");$J=array();list($J["partition_by"],$J["partition"],$J["partitions"])=$I->fetch_row();$Cg=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $rd AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$J["partition_names"]=array_keys($Cg);$J["partition_values"]=array_values($Cg);return$J;}function
hasCStyleEscapes(){static$Sa;if($Sa===null){$ki=get_val("SHOW VARIABLES LIKE 'sql_mode'",1,$this->conn);$Sa=(strpos($ki,'NO_BACKSLASH_ESCAPES')===false);}return$Sa;}function
engines(){$J=array();foreach(get_rows("SHOW ENGINES")as$K){if(preg_match("~YES|DEFAULT~",$K["Support"]))$J[]=$K["Engine"];}return$J;}function
indexAlgorithms(array$xi){return(preg_match('~^(MEMORY|NDB)$~',$xi["Engine"])?array("HASH","BTREE"):array());}}function
idf_escape($v){return"`".str_replace("`","``",$v)."`";}function
table($v){return
idf_escape($v);}function
get_databases($jd){$J=get_session("dbs");if($J===null){$H="SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME";$J=($jd?slow_query($H):get_vals($H));restart_session();set_session("dbs",$J);stop_session();}return$J;}function
limit($H,$Z,$z,$C=0,$Qh=" "){return" $H$Z".($z?$Qh."LIMIT $z".($C?" OFFSET $C":""):"");}function
limit1($R,$H,$Z,$Qh="\n"){return
limit($H,$Z,1,0,$Qh);}function
db_collation($k,array$lb){$J=null;$i=get_val("SHOW CREATE DATABASE ".idf_escape($k),1);if(preg_match('~ COLLATE ([^ ]+)~',$i,$A))$J=$A[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$i,$A))$J=$lb[$A[1]][-1];return$J;}function
logged_user(){return
get_val("SELECT USER()");}function
tables_list(){return
get_key_vals("SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME");}function
count_tables(array$j){$J=array();foreach($j
as$k)$J[$k]=count(get_vals("SHOW TABLES IN ".idf_escape($k)));return$J;}function
table_status($B="",$Wc=false){$J=array();foreach(get_rows($Wc?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($B!=""?"AND TABLE_NAME = ".q($B):"ORDER BY Name"):"SHOW TABLE STATUS".($B!=""?" LIKE ".q(addcslashes($B,"%_\\")):""))as$K){if($K["Engine"]=="InnoDB")$K["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$K["Comment"]);if(!isset($K["Engine"]))$K["Comment"]="";if($B!="")$K["Name"]=$B;$J[$K["Name"]]=$K;}return$J;}function
is_view(array$S){return$S["Engine"]===null;}function
fk_support(array$S){return
preg_match('~InnoDB|IBMDB2I'.(min_version(5.6)?'|NDB':'').'~i',$S["Engine"]);}function
fields($R){$Ye=(connection()->flavor=='maria');$J=array();foreach(get_rows("SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ".q($R)." ORDER BY ORDINAL_POSITION")as$K){$n=$K["COLUMN_NAME"];$U=$K["COLUMN_TYPE"];$vd=$K["GENERATION_EXPRESSION"];$Tc=$K["EXTRA"];preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$Tc,$ud);preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$U,$bf);$l=$K["COLUMN_DEFAULT"];if($l!=""){$ye=preg_match('~text|json~',$bf[1]);if(!$Ye&&$ye)$l=preg_replace("~^(_\w+)?('.*')$~",'\2',stripslashes($l));if($Ye||$ye){$l=($l=="NULL"?null:preg_replace_callback("~^'(.*)'$~",function($A){return
stripslashes(str_replace("''","'",$A[1]));},$l));}if(!$Ye&&preg_match('~binary~',$bf[1])&&preg_match('~^0x(\w*)$~',$l,$A))$l=pack("H*",$A[1]);}$J[$n]=array("field"=>$n,"full_type"=>$U,"type"=>$bf[1],"length"=>$bf[2],"unsigned"=>ltrim($bf[3].$bf[4]),"default"=>($ud?($Ye?$vd:stripslashes($vd)):$l),"null"=>($K["IS_NULLABLE"]=="YES"),"auto_increment"=>($Tc=="auto_increment"),"on_update"=>(preg_match('~\bon update (\w+)~i',$Tc,$A)?$A[1]:""),"collation"=>$K["COLLATION_NAME"],"privileges"=>array_flip(explode(",","$K[PRIVILEGES],where,order")),"comment"=>$K["COLUMN_COMMENT"],"primary"=>($K["COLUMN_KEY"]=="PRI"),"generated"=>($ud[1]=="PERSISTENT"?"STORED":$ud[1]),);}return$J;}function
indexes($R,$h=null){$J=array();foreach(get_rows("SHOW INDEX FROM ".table($R),$h)as$K){$B=$K["Key_name"];$J[$B]["type"]=($B=="PRIMARY"?"PRIMARY":($K["Index_type"]=="FULLTEXT"?"FULLTEXT":($K["Non_unique"]?($K["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$J[$B]["columns"][]=$K["Column_name"];$J[$B]["lengths"][]=($K["Index_type"]=="SPATIAL"?null:$K["Sub_part"]);$J[$B]["descs"][]=null;$J[$B]["algorithm"]=$K["Index_type"];}return$J;}function
foreign_keys($R){static$Gg='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$J=array();$Fb=get_val("SHOW CREATE TABLE ".table($R),1);if($Fb){preg_match_all("~CONSTRAINT ($Gg) FOREIGN KEY ?\\(((?:$Gg,? ?)+)\\) REFERENCES ($Gg)(?:\\.($Gg))? \\(((?:$Gg,? ?)+)\\)(?: ON DELETE (".driver()->onActions."))?(?: ON UPDATE (".driver()->onActions."))?~",$Fb,$cf,PREG_SET_ORDER);foreach($cf
as$A){preg_match_all("~$Gg~",$A[2],$ei);preg_match_all("~$Gg~",$A[5],$Hi);$J[idf_unescape($A[1])]=array("db"=>idf_unescape($A[4]!=""?$A[3]:$A[4]),"table"=>idf_unescape($A[4]!=""?$A[4]:$A[3]),"source"=>array_map('Adminer\idf_unescape',$ei[0]),"target"=>array_map('Adminer\idf_unescape',$Hi[0]),"on_delete"=>($A[6]?:"RESTRICT"),"on_update"=>($A[7]?:"RESTRICT"),);}}return$J;}function
view($B){return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',get_val("SHOW CREATE VIEW ".table($B),1)));}function
collations(){$J=array();foreach(get_rows("SHOW COLLATION")as$K){if($K["Default"])$J[$K["Charset"]][-1]=$K["Collation"];else$J[$K["Charset"]][]=$K["Collation"];}ksort($J);foreach($J
as$y=>$X)sort($J[$y]);return$J;}function
information_schema($k){return($k=="information_schema")||(min_version(5.5)&&$k=="performance_schema");}function
error(){return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",connection()->error));}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).($c?" COLLATE ".q($c):""));}function
drop_databases(array$j){$J=apply_queries("DROP DATABASE",$j,'Adminer\idf_escape');restart_session();set_session("dbs",null);return$J;}function
rename_database($B,$c){$J=false;if(create_database($B,$c)){$T=array();$Kj=array();foreach(tables_list()as$R=>$U){if($U=='VIEW')$Kj[]=$R;else$T[]=$R;}$J=(!$T&&!$Kj)||move_tables($T,$Kj,$B);drop_databases($J?array(DB):array());}return$J;}function
auto_increment(){$Ca=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$w){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$w["columns"],true)){$Ca="";break;}if($w["type"]=="PRIMARY")$Ca=" UNIQUE";}}return" AUTO_INCREMENT$Ca";}function
alter_table($R,$B,array$o,array$ld,$qb,$_c,$c,$Ba,$E){$b=array();foreach($o
as$n){if($n[1]){$l=$n[1][3];if(preg_match('~ GENERATED~',$l)){$n[1][3]=(connection()->flavor=='maria'?"":$n[1][2]);$n[1][2]=$l;}$b[]=($R!=""?($n[0]!=""?"CHANGE ".idf_escape($n[0]):"ADD"):" ")." ".implode($n[1]).($R!=""?$n[2]:"");}else$b[]="DROP ".idf_escape($n[0]);}$b=array_merge($b,$ld);$P=($qb!==null?" COMMENT=".q($qb):"").($_c?" ENGINE=".q($_c):"").($c?" COLLATE ".q($c):"").($Ba!=""?" AUTO_INCREMENT=$Ba":"");if($E){$Cg=array();if($E["partition_by"]=='RANGE'||$E["partition_by"]=='LIST'){foreach($E["partition_names"]as$y=>$X){$Y=$E["partition_values"][$y];$Cg[]="\n  PARTITION ".idf_escape($X)." VALUES ".($E["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$P
.="\nPARTITION BY $E[partition_by]($E[partition])";if($Cg)$P
.=" (".implode(",",$Cg)."\n)";elseif($E["partitions"])$P
.=" PARTITIONS ".(+$E["partitions"]);}elseif($E===null)$P
.="\nREMOVE PARTITIONING";if($R=="")return
queries("CREATE TABLE ".table($B)." (\n".implode(",\n",$b)."\n)$P");if($R!=$B)$b[]="RENAME TO ".table($B);if($P)$b[]=ltrim($P);return($b?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$b)):true);}function
alter_indexes($R,$b){$Wa=array();foreach($b
as$X)$Wa[]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($R).implode(",",$Wa));}function
truncate_tables(array$T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views(array$Kj){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$Kj)));}function
drop_tables(array$T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables(array$T,array$Kj,$Hi){$sh=array();foreach($T
as$R)$sh[]=table($R)." TO ".idf_escape($Hi).".".table($R);if(!$sh||queries("RENAME TABLE ".implode(", ",$sh))){$Yb=array();foreach($Kj
as$R)$Yb[table($R)]=view($R);connection()->select_db($Hi);$k=idf_escape(DB);foreach($Yb
as$B=>$Jj){if(!queries("CREATE VIEW $B AS ".str_replace(" $k."," ",$Jj["select"]))||!queries("DROP VIEW $k.$B"))return
false;}return
true;}return
false;}function
copy_tables(array$T,array$Kj,$Hi){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($T
as$R){$B=($Hi==DB?table("copy_$R"):idf_escape($Hi).".".table($R));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $B"))||!queries("CREATE TABLE $B LIKE ".table($R))||!queries("INSERT INTO $B SELECT * FROM ".table($R)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K){$gj=$K["Trigger"];if(!queries("CREATE TRIGGER ".($Hi==DB?idf_escape("copy_$gj"):idf_escape($Hi).".".idf_escape($gj))." $K[Timing] $K[Event] ON $B FOR EACH ROW\n$K[Statement];"))return
false;}}foreach($Kj
as$R){$B=($Hi==DB?table("copy_$R"):idf_escape($Hi).".".table($R));$Jj=view($R);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $B"))||!queries("CREATE VIEW $B AS $Jj[select]"))return
false;}return
true;}function
trigger($B,$R){if($B=="")return
array();$L=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($B));return
reset($L);}function
triggers($R){$J=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K)$J[$K["Trigger"]]=array($K["Timing"],$K["Event"]);return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($B,$U){$ta=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$fi="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Bc=driver()->enumLength;$lj="((".implode("|",array_merge(array_keys(driver()->types()),$ta)).")\\b(?:\\s*\\(((?:[^'\")]|$Bc)++)\\))?"."\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$Gg="$fi*(".($U=="FUNCTION"?"":driver()->inout).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$lj";$i=get_val("SHOW CREATE $U ".idf_escape($B),2);preg_match("~\\(((?:$Gg\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$lj\\s+":"")."(.*)~is",$i,$A);$o=array();preg_match_all("~$Gg\\s*,?~is",$A[1],$cf,PREG_SET_ORDER);foreach($cf
as$ug)$o[]=array("field"=>str_replace("``","`",$ug[2]).$ug[3],"type"=>strtolower($ug[5]),"length"=>preg_replace_callback("~$Bc~s",'Adminer\normalize_enum',$ug[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$ug[8] $ug[7]"))),"null"=>true,"full_type"=>$ug[4],"inout"=>strtoupper($ug[1]),"collation"=>strtolower($ug[9]),);return
array("fields"=>$o,"comment"=>get_val("SELECT ROUTINE_COMMENT FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE() AND ROUTINE_NAME = ".q($B)),)+($U!="FUNCTION"?array("definition"=>$A[11]):array("returns"=>array("type"=>$A[12],"length"=>$A[13],"unsigned"=>$A[15],"collation"=>$A[16]),"definition"=>$A[17],"language"=>"SQL",));}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE()");}function
routine_languages(){return
array();}function
routine_id($B,array$K){return
idf_escape($B);}function
last_id($I){return
get_val("SELECT LAST_INSERT_ID()");}function
explain(Db$g,$H){return$g->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$H);}function
found_rows(array$S,array$Z){return($Z||$S["Engine"]!="InnoDB"?null:$S["Rows"]);}function
create_sql($R,$Ba,$ri){$J=get_val("SHOW CREATE TABLE ".table($R),1);if(!$Ba)$J=preg_replace('~ AUTO_INCREMENT=\d+~','',$J);return$J;}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
use_sql($Pb){return"USE ".idf_escape($Pb);}function
trigger_sql($R){$J="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")),null,"-- ")as$K)$J
.="\nCREATE TRIGGER ".idf_escape($K["Trigger"])." $K[Timing] $K[Event] ON ".table($K["Table"])." FOR EACH ROW\n$K[Statement];;\n";return$J;}function
show_variables(){return
get_rows("SHOW VARIABLES");}function
show_status(){return
get_rows("SHOW STATUS");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
convert_field(array$n){if(preg_match("~binary~",$n["type"]))return"HEX(".idf_escape($n["field"]).")";if($n["type"]=="bit")return"BIN(".idf_escape($n["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($n["field"]).")";}function
unconvert_field(array$n,$J){if(preg_match("~binary~",$n["type"]))$J="UNHEX($J)";if($n["type"]=="bit")$J="CONVERT(b$J, UNSIGNED)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"])){$Sg=(min_version(8)?"ST_":"");$J=$Sg."GeomFromText($J, $Sg"."SRID($n[field]))";}return$J;}function
support($Xc){return
preg_match('~^(comment|columns|copy|database|drop_col|dump|indexes|kill|privileges|move_col|procedure|processlist|routine|sql|status|table|trigger|variables|view'.(min_version(5.1)?'|event':'').(min_version(8)?'|descidx':'').(min_version('8.0.16','10.2.1')?'|check':'').')$~',$Xc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){return
get_val("SELECT @@max_connections");}function
types(){return
array();}function
type_values($u){return"";}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($Fh,$h=null){return
true;}}define('Adminer\JUSH',Driver::$jush);define('Adminer\SERVER',$_GET[DRIVER]);define('Adminer\DB',$_GET["db"]);define('Adminer\ME',preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').($_GET["ext"]?"ext=".urlencode($_GET["ext"]).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));function
page_header($Ri,$m="",$Oa=array(),$Si=""){page_headers();if(is_ajax()&&$m){page_messages($m);exit;}if(!ob_get_level())ob_start('ob_gzhandler',4096);$Ti=$Ri.($Si!=""?": $Si":"");$Ui=strip_tags($Ti.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".adminer()->name());echo'<!DOCTYPE html>
<html lang="',LANG,'" dir="',lang(81),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>',$Ui,'</title>
<link rel="stylesheet" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=5.3.0"),'">
';$Jb=adminer()->css();if(is_int(key($Jb)))$Jb=array_fill_keys($Jb,'light');$Gd=in_array('light',$Jb)||in_array('',$Jb);$Ed=in_array('dark',$Jb)||in_array('',$Jb);$Mb=($Gd?($Ed?null:false):($Ed?:null));$kf=" media='(prefers-color-scheme: dark)'";if($Mb!==false)echo"<link rel='stylesheet'".($Mb?"":$kf)." href='".h(preg_replace("~\\?.*~","",ME)."?file=dark.css&version=5.3.0")."'>\n";echo"<meta name='color-scheme' content='".($Mb===null?"light dark":($Mb?"dark":"light"))."'>\n",script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=5.3.0");if(adminer()->head($Mb))echo"<link rel='icon' href='data:image/gif;base64,R0lGODlhEAAQAJEAAAQCBPz+/PwCBAROZCH5BAEAAAAALAAAAAAQABAAAAI2hI+pGO1rmghihiUdvUBnZ3XBQA7f05mOak1RWXrNq5nQWHMKvuoJ37BhVEEfYxQzHjWQ5qIAADs='>\n","<link rel='apple-touch-icon' href='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.3.0")."'>\n";foreach($Jb
as$xj=>$uf){$_a=($uf=='dark'&&!$Mb?$kf:($uf=='light'&&$Ed?" media='(prefers-color-scheme: light)'":""));echo"<link rel='stylesheet'$_a href='".h($xj)."'>\n";}echo"\n<body class='".lang(81)." nojs";adminer()->bodyClass();echo"'>\n";$p=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($p)&&filemtime($p)+86400>time()){$Ij=unserialize(file_get_contents($p));$ch="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($Ij["version"],base64_decode($Ij["signature"]),$ch)==1)$_COOKIE["adminer_version"]=$Ij["version"];}echo
script("mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick".(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '".VERSION."', '".js_escape(ME)."', '".get_token()."')")."});
document.body.classList.replace('nojs', 'js');
const offlineMessage = '".js_escape(lang(82))."';
const thousandsSeparator = '".js_escape(lang(4))."';"),"<div id='help' class='jush-".JUSH." jsonly hidden'></div>\n",script("mixin(qs('#help'), {onmouseover: () => { helpOpen = 1; }, onmouseout: helpMouseout});"),"<div id='content'>\n","<span id='menuopen' class='jsonly'>".icon("move","","menu","")."</span>".script("qs('#menuopen').onclick = event => { qs('#foot').classList.toggle('foot'); event.stopPropagation(); }");if($Oa!==null){$_=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($_?:".").'">'.get_driver(DRIVER).'</a> » ';$_=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$N=adminer()->serverName(SERVER);$N=($N!=""?$N:lang(33));if($Oa===false)echo"$N\n";else{echo"<a href='".h($_)."' accesskey='1' title='Alt+Shift+1'>$N</a> » ";if($_GET["ns"]!=""||(DB!=""&&is_array($Oa)))echo'<a href="'.h($_."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> » ';if(is_array($Oa)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> » ';foreach($Oa
as$y=>$X){$ac=(is_array($X)?$X[1]:h($X));if($ac!="")echo"<a href='".h(ME."$y=").urlencode(is_array($X)?$X[0]:$X)."'>$ac</a> » ";}}echo"$Ri\n";}}echo"<h2>$Ti</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($m);$j=&get_session("dbs");if(DB!=""&&$j&&!in_array(DB,$j,true))$j=null;stop_session();define('Adminer\PAGE_HEADER',1);}function
page_headers(){header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach(adminer()->csp(csp())as$Ib){$Id=array();foreach($Ib
as$y=>$X)$Id[]="$y $X";header("Content-Security-Policy: ".implode("; ",$Id));}adminer()->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$Ff;if(!$Ff)$Ff=base64_encode(rand_string());return$Ff;}function
page_messages($m){$wj=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$qf=idx($_SESSION["messages"],$wj);if($qf){echo"<div class='message'>".implode("</div>\n<div class='message'>",$qf)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$wj]);}if($m)echo"<div class='error'>$m</div>\n";if(adminer()->error)echo"<div class='error'>".adminer()->error."</div>\n";}function
page_footer($tf=""){echo"</div>\n\n<div id='foot' class='foot'>\n<div id='menu'>\n";adminer()->navigation($tf);echo"</div>\n";if($tf!="auth")echo'<form action="" method="post">
<p class="logout">
<span>',h($_GET["username"])."\n",'</span>
<input type="submit" name="logout" value="',lang(83),'" id="logout">
',input_token(),'</form>
';echo"</div>\n\n",script("setupSubmitHighlight(document);");}function
int32($yf){while($yf>=2147483648)$yf-=4294967296;while($yf<=-2147483649)$yf+=4294967296;return(int)$yf;}function
long2str(array$W,$Mj){$Dh='';foreach($W
as$X)$Dh
.=pack('V',$X);if($Mj)return
substr($Dh,0,end($W));return$Dh;}function
str2long($Dh,$Mj){$W=array_values(unpack('V*',str_pad($Dh,4*ceil(strlen($Dh)/4),"\0")));if($Mj)$W[]=strlen($Dh);return$W;}function
xxtea_mx($Tj,$Sj,$ui,$Be){return
int32((($Tj>>5&0x7FFFFFF)^$Sj<<2)+(($Sj>>3&0x1FFFFFFF)^$Tj<<4))^int32(($ui^$Sj)+($Be^$Tj));}function
encrypt_string($pi,$y){if($pi=="")return"";$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($pi,true);$yf=count($W)-1;$Tj=$W[$yf];$Sj=$W[0];$dh=floor(6+52/($yf+1));$ui=0;while($dh-->0){$ui=int32($ui+0x9E3779B9);$rc=$ui>>2&3;for($sg=0;$sg<$yf;$sg++){$Sj=$W[$sg+1];$xf=xxtea_mx($Tj,$Sj,$ui,$y[$sg&3^$rc]);$Tj=int32($W[$sg]+$xf);$W[$sg]=$Tj;}$Sj=$W[0];$xf=xxtea_mx($Tj,$Sj,$ui,$y[$sg&3^$rc]);$Tj=int32($W[$yf]+$xf);$W[$yf]=$Tj;}return
long2str($W,false);}function
decrypt_string($pi,$y){if($pi=="")return"";if(!$y)return
false;$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($pi,false);$yf=count($W)-1;$Tj=$W[$yf];$Sj=$W[0];$dh=floor(6+52/($yf+1));$ui=int32($dh*0x9E3779B9);while($ui){$rc=$ui>>2&3;for($sg=$yf;$sg>0;$sg--){$Tj=$W[$sg-1];$xf=xxtea_mx($Tj,$Sj,$ui,$y[$sg&3^$rc]);$Sj=int32($W[$sg]-$xf);$W[$sg]=$Sj;}$Tj=$W[$yf];$xf=xxtea_mx($Tj,$Sj,$ui,$y[$sg&3^$rc]);$Sj=int32($W[0]-$xf);$W[0]=$Sj;$ui=int32($ui-0x9E3779B9);}return
long2str($W,true);}$Ig=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($y)=explode(":",$X);$Ig[$y]=$X;}}function
add_invalid_login(){$Ha=get_temp_dir()."/adminer.invalid";foreach(glob("$Ha*")?:array($Ha)as$p){$r=file_open_lock($p);if($r)break;}if(!$r)$r=file_open_lock("$Ha-".rand_string());if(!$r)return;$te=unserialize(stream_get_contents($r));$Oi=time();if($te){foreach($te
as$ue=>$X){if($X[0]<$Oi)unset($te[$ue]);}}$se=&$te[adminer()->bruteForceKey()];if(!$se)$se=array($Oi+30*60,0);$se[1]++;file_write_unlock($r,serialize($te));}function
check_invalid_login(array&$Ig){$te=array();foreach(glob(get_temp_dir()."/adminer.invalid*")as$p){$r=file_open_lock($p);if($r){$te=unserialize(stream_get_contents($r));file_unlock($r);break;}}$se=idx($te,adminer()->bruteForceKey(),array());$Ef=($se[1]>29?$se[0]-time():0);if($Ef>0)auth_error(lang(84,ceil($Ef/60)),$Ig);}$Aa=$_POST["auth"];if($Aa){session_regenerate_id();$Hj=$Aa["driver"];$N=$Aa["server"];$V=$Aa["username"];$F=(string)$Aa["password"];$k=$Aa["db"];set_password($Hj,$N,$V,$F);$_SESSION["db"][$Hj][$N][$V][$k]=true;if($Aa["permanent"]){$y=implode("-",array_map('base64_encode',array($Hj,$N,$V,$k)));$Xg=adminer()->permanentLogin(true);$Ig[$y]="$y:".base64_encode($Xg?encrypt_string($F,$Xg):"");cookie("adminer_permanent",implode(" ",$Ig));}if(count($_POST)==1||DRIVER!=$Hj||SERVER!=$N||$_GET["username"]!==$V||DB!=$k)redirect(auth_url($Hj,$N,$V,$k));}elseif($_POST["logout"]&&(!$_SESSION["token"]||verify_token())){foreach(array("pwds","db","dbs","queries")as$y)set_session($y,null);unset_permanent($Ig);redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(85).' '.lang(86));}elseif($Ig&&!$_SESSION["pwds"]){session_regenerate_id();$Xg=adminer()->permanentLogin();foreach($Ig
as$y=>$X){list(,$eb)=explode(":",$X);list($Hj,$N,$V,$k)=array_map('base64_decode',explode("-",$y));set_password($Hj,$N,$V,decrypt_string(base64_decode($eb),$Xg));$_SESSION["db"][$Hj][$N][$V][$k]=true;}}function
unset_permanent(array&$Ig){foreach($Ig
as$y=>$X){list($Hj,$N,$V,$k)=array_map('base64_decode',explode("-",$y));if($Hj==DRIVER&&$N==SERVER&&$V==$_GET["username"]&&$k==DB)unset($Ig[$y]);}cookie("adminer_permanent",implode(" ",$Ig));}function
auth_error($m,array&$Ig){$Wh=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$Wh]||$_GET[$Wh])&&!$_SESSION["token"])$m=lang(87);else{restart_session();add_invalid_login();$F=get_password();if($F!==null){if($F===false)$m
.=($m?'<br>':'').lang(88,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent($Ig);}}if(!$_COOKIE[$Wh]&&$_GET[$Wh]&&ini_bool("session.use_only_cookies"))$m=lang(89);$vg=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?:rand_string()),$vg["lifetime"]);if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);page_header(lang(37),$m,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(90)."\n";echo"</div>\n";adminer()->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists('Adminer\Db')){unset($_SESSION["pwds"][DRIVER]);unset_permanent($Ig);page_header(lang(91),lang(92,implode(", ",Driver::$extensions)),false);page_footer("auth");exit;}$g='';if(isset($_GET["username"])&&is_string(get_password())){list($Od,$Mg)=explode(":",SERVER,2);if(preg_match('~^\s*([-+]?\d+)~',$Mg,$A)&&($A[1]<1024||$A[1]>65535))auth_error(lang(93),$Ig);check_invalid_login($Ig);$Hb=adminer()->credentials();$g=Driver::connect($Hb[0],$Hb[1],$Hb[2]);if(is_object($g)){Db::$instance=$g;Driver::$instance=new
Driver($g);if($g->flavor)save_settings(array("vendor-".DRIVER."-".SERVER=>get_driver(DRIVER)));}}$We=null;if(!is_object($g)||($We=adminer()->login($_GET["username"],get_password()))!==true){$m=(is_string($g)?nl_br(h($g)):(is_string($We)?$We:lang(94))).(preg_match('~^ | $~',get_password())?'<br>'.lang(95):'');auth_error($m,$Ig);}if($_POST["logout"]&&$_SESSION["token"]&&!verify_token()){page_header(lang(83),lang(96));page_footer("db");exit;}if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);stop_session(true);if($Aa&&$_POST["token"])$_POST["token"]=get_token();$m='';if($_POST){if(!verify_token()){$le="max_input_vars";$if=ini_get($le);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$y){$X=ini_get($y);if($X&&(!$if||$X<$if)){$le=$y;$if=$X;}}}$m=(!$_POST["token"]&&$if?lang(97,"'$le'"):lang(96).' '.lang(98));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$m=lang(99,"'post_max_size'");if(isset($_GET["sql"]))$m
.=' '.lang(100);}function
print_select_result($I,$h=null,array$hg=array(),$z=0){$Ue=array();$x=array();$e=array();$Ma=array();$mj=array();$J=array();for($t=0;(!$z||$t<$z)&&($K=$I->fetch_row());$t++){if(!$t){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr>";for($_e=0;$_e<count($K);$_e++){$n=$I->fetch_field();$B=$n->name;$gg=(isset($n->orgtable)?$n->orgtable:"");$fg=(isset($n->orgname)?$n->orgname:$B);if($hg&&JUSH=="sql")$Ue[$_e]=($B=="table"?"table=":($B=="possible_keys"?"indexes=":null));elseif($gg!=""){if(isset($n->table))$J[$n->table]=$gg;if(!isset($x[$gg])){$x[$gg]=array();foreach(indexes($gg,$h)as$w){if($w["type"]=="PRIMARY"){$x[$gg]=array_flip($w["columns"]);break;}}$e[$gg]=$x[$gg];}if(isset($e[$gg][$fg])){unset($e[$gg][$fg]);$x[$gg][$fg]=$_e;$Ue[$_e]=$gg;}}if($n->charsetnr==63)$Ma[$_e]=true;$mj[$_e]=$n->type;echo"<th".($gg!=""||$n->name!=$fg?" title='".h(($gg!=""?"$gg.":"").$fg)."'":"").">".h($B).($hg?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($B),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr>";foreach($K
as$y=>$X){$_="";if(isset($Ue[$y])&&!$e[$Ue[$y]]){if($hg&&JUSH=="sql"){$R=$K[array_search("table=",$Ue)];$_=ME.$Ue[$y].urlencode($hg[$R]!=""?$hg[$R]:$R);}else{$_=ME."edit=".urlencode($Ue[$y]);foreach($x[$Ue[$y]]as$jb=>$_e)$_
.="&where".urlencode("[".bracket_escape($jb)."]")."=".urlencode($K[$_e]);}}elseif(is_url($X))$_=$X;if($X===null)$X="<i>NULL</i>";elseif($Ma[$y]&&!is_utf8($X))$X="<i>".lang(46,strlen($X))."</i>";else{$X=h($X);if($mj[$y]==254)$X="<code>$X</code>";}if($_)$X="<a href='".h($_)."'".(is_url($_)?target_blank():'').">$X</a>";echo"<td".($mj[$y]<=9||$mj[$y]==246?" class='number'":"").">$X";}}echo($t?"</table>\n</div>":"<p class='message'>".lang(12))."\n";return$J;}function
referencable_primary($Oh){$J=array();foreach(table_status('',true)as$zi=>$R){if($zi!=$Oh&&fk_support($R)){foreach(fields($zi)as$n){if($n["primary"]){if($J[$zi]){unset($J[$zi]);break;}$J[$zi]=$n;}}}}return$J;}function
textarea($B,$Y,$L=10,$mb=80){echo"<textarea name='".h($B)."' rows='$L' cols='$mb' class='sqlarea jush-".JUSH."' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
select_input($_a,array$bg,$Y="",$Vf="",$Jg=""){$Gi=($bg?"select":"input");return"<$Gi$_a".($bg?"><option value=''>$Jg".optionlist($bg,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$Jg'>").($Vf?script("qsl('$Gi').onchange = $Vf;",""):"");}function
json_row($y,$X=null){static$dd=true;if($dd)echo"{";if($y!=""){echo($dd?"":",")."\n\t\"".addcslashes($y,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$dd=false;}else{echo"\n}\n";$dd=true;}}function
edit_type($y,array$n,array$lb,array$nd=array(),array$Uc=array()){$U=$n["type"];echo"<td><select name='".h($y)."[type]' class='type' aria-labelledby='label-type'>";if($U&&!array_key_exists($U,driver()->types())&&!isset($nd[$U])&&!in_array($U,$Uc))$Uc[]=$U;$qi=driver()->structuredTypes();if($nd)$qi[lang(101)]=$nd;echo
optionlist(array_merge($Uc,$qi),$U),"</select><td>","<input name='".h($y)."[length]' value='".h($n["length"])."' size='3'".(!$n["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"")." aria-labelledby='label-length'>","<td class='options'>",($lb?"<input list='collations' name='".h($y)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'")." value='".h($n["collation"])."' placeholder='(".lang(102).")'>":''),(driver()->unsigned?"<select name='".h($y)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist(driver()->unsigned,$n["unsigned"]).'</select>':''),(isset($n['on_update'])?"<select name='".h($y)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(103).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"CURRENT_TIMESTAMP":$n["on_update"])).'</select>':''),($nd?"<select name='".h($y)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(104).")".optionlist(explode("|",driver()->onActions),$n["on_delete"])."</select> ":" ");}function
process_length($Qe){$Dc=driver()->enumLength;return(preg_match("~^\\s*\\(?\\s*$Dc(?:\\s*,\\s*$Dc)*+\\s*\\)?\\s*\$~",$Qe)&&preg_match_all("~$Dc~",$Qe,$cf)?"(".implode(",",$cf[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$Qe)));}function
process_type(array$n,$kb="COLLATE"){return" $n[type]".process_length($n["length"]).(preg_match(number_type(),$n["type"])&&in_array($n["unsigned"],driver()->unsigned)?" $n[unsigned]":"").(preg_match('~char|text|enum|set~',$n["type"])&&$n["collation"]?" $kb ".(JUSH=="mssql"?$n["collation"]:q($n["collation"])):"");}function
process_field(array$n,array$kj){if($n["on_update"])$n["on_update"]=str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",$n["on_update"]);return
array(idf_escape(trim($n["field"])),process_type($kj),($n["null"]?" NULL":" NOT NULL"),default_value($n),(preg_match('~timestamp|datetime~',$n["type"])&&$n["on_update"]?" ON UPDATE $n[on_update]":""),(support("comment")&&$n["comment"]!=""?" COMMENT ".q($n["comment"]):""),($n["auto_increment"]?auto_increment():null),);}function
default_value(array$n){$l=$n["default"];$ud=$n["generated"];return($l===null?"":(in_array($ud,driver()->generated)?(JUSH=="mssql"?" AS ($l)".($ud=="VIRTUAL"?"":" $ud")."":" GENERATED ALWAYS AS ($l) $ud"):" DEFAULT ".(!preg_match('~^GENERATED ~i',$l)&&(preg_match('~char|binary|text|json|enum|set~',$n["type"])||preg_match('~^(?![a-z])~i',$l))?(JUSH=="sql"&&preg_match('~text|json~',$n["type"])?"(".q($l).")":q($l)):str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",(JUSH=="sqlite"?"($l)":$l)))));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$y=>$X){if(preg_match("~$y|$X~",$U))return" class='$y'";}}function
edit_fields(array$o,array$lb,$U="TABLE",array$nd=array()){$o=array_values($o);$Vb=(($_POST?$_POST["defaults"]:get_setting("defaults"))?"":" class='hidden'");$rb=(($_POST?$_POST["comments"]:get_setting("comments"))?"":" class='hidden'");echo"<thead><tr>\n",($U=="PROCEDURE"?"<td>":""),"<th id='label-name'>".($U=="TABLE"?lang(105):lang(106)),"<td id='label-type'>".lang(48)."<textarea id='enum-edit' rows='4' cols='12' wrap='off' style='display: none;'></textarea>".script("qs('#enum-edit').onblur = editingLengthBlur;"),"<td id='label-length'>".lang(107),"<td>".lang(108);if($U=="TABLE")echo"<td id='label-null'>NULL\n","<td><input type='radio' name='auto_increment_col' value=''><abbr id='label-ai' title='".lang(50)."'>AI</abbr>",doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",'sqlite'=>"autoinc.html",'pgsql'=>"datatype-numeric.html#DATATYPE-SERIAL",'mssql'=>"t-sql/statements/create-table-transact-sql-identity-property",)),"<td id='label-default'$Vb>".lang(51),(support("comment")?"<td id='label-comment'$rb>".lang(49):"");echo"<td>".icon("plus","add[".(support("move_col")?0:count($o))."]","+",lang(109)),"</thead>\n<tbody>\n",script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($o
as$t=>$n){$t++;$ig=$n[($_POST?"orig":"field")];$gc=(isset($_POST["add"][$t-1])||(isset($n["field"])&&!idx($_POST["drop_col"],$t)))&&(support("drop_col")||$ig=="");echo"<tr".($gc?"":" style='display: none;'").">\n",($U=="PROCEDURE"?"<td>".html_select("fields[$t][inout]",explode("|",driver()->inout),$n["inout"]):"")."<th>";if($gc)echo"<input name='fields[$t][field]' value='".h($n["field"])."' data-maxlength='64' autocapitalize='off' aria-labelledby='label-name'>";echo
input_hidden("fields[$t][orig]",$ig);edit_type("fields[$t]",$n,$lb,$nd);if($U=="TABLE")echo"<td>".checkbox("fields[$t][null]",1,$n["null"],"","","block","label-null"),"<td><label class='block'><input type='radio' name='auto_increment_col' value='$t'".($n["auto_increment"]?" checked":"")." aria-labelledby='label-ai'></label>","<td$Vb>".(driver()->generated?html_select("fields[$t][generated]",array_merge(array("","DEFAULT"),driver()->generated),$n["generated"])." ":checkbox("fields[$t][generated]",1,$n["generated"],"","","","label-default")),"<input name='fields[$t][default]' value='".h($n["default"])."' aria-labelledby='label-default'>",(support("comment")?"<td$rb><input name='fields[$t][comment]' value='".h($n["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");echo"<td>",(support("move_col")?icon("plus","add[$t]","+",lang(109))." ".icon("up","up[$t]","↑",lang(110))." ".icon("down","down[$t]","↓",lang(111))." ":""),($ig==""||support("drop_col")?icon("cross","drop_col[$t]","x",lang(112)):"");}}function
process_fields(array&$o){$C=0;if($_POST["up"]){$Ke=0;foreach($o
as$y=>$n){if(key($_POST["up"])==$y){unset($o[$y]);array_splice($o,$Ke,0,array($n));break;}if(isset($n["field"]))$Ke=$C;$C++;}}elseif($_POST["down"]){$pd=false;foreach($o
as$y=>$n){if(isset($n["field"])&&$pd){unset($o[key($_POST["down"])]);array_splice($o,$C,0,array($pd));break;}if(key($_POST["down"])==$y)$pd=$n;$C++;}}elseif($_POST["add"]){$o=array_values($o);array_splice($o,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum(array$A){$X=$A[0];return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($X[0].$X[0],$X[0],substr($X,1,-1))),'\\'))."'";}function
grant($wd,array$Zg,$e,$Sf){if(!$Zg)return
true;if($Zg==array("ALL PRIVILEGES","GRANT OPTION"))return($wd=="GRANT"?queries("$wd ALL PRIVILEGES$Sf WITH GRANT OPTION"):queries("$wd ALL PRIVILEGES$Sf")&&queries("$wd GRANT OPTION$Sf"));return
queries("$wd ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$e, ",$Zg).$e).$Sf);}function
drop_create($kc,$i,$mc,$Ki,$oc,$Ve,$pf,$nf,$of,$Pf,$Bf){if($_POST["drop"])query_redirect($kc,$Ve,$pf);elseif($Pf=="")query_redirect($i,$Ve,$of);elseif($Pf!=$Bf){$Gb=queries($i);queries_redirect($Ve,$nf,$Gb&&queries($kc));if($Gb)queries($mc);}else
queries_redirect($Ve,$nf,queries($Ki)&&queries($oc)&&queries($kc)&&queries($i));}function
create_trigger($Sf,array$K){$Qi=" $K[Timing] $K[Event]".(preg_match('~ OF~',$K["Event"])?" $K[Of]":"");return"CREATE TRIGGER ".idf_escape($K["Trigger"]).(JUSH=="mssql"?$Sf.$Qi:$Qi.$Sf).rtrim(" $K[Type]\n$K[Statement]",";").";";}function
create_routine($_h,array$K){$O=array();$o=(array)$K["fields"];ksort($o);foreach($o
as$n){if($n["field"]!="")$O[]=(preg_match("~^(".driver()->inout.")\$~",$n["inout"])?"$n[inout] ":"").idf_escape($n["field"]).process_type($n,"CHARACTER SET");}$Xb=rtrim($K["definition"],";");return"CREATE $_h ".idf_escape(trim($K["name"]))." (".implode(", ",$O).")".($_h=="FUNCTION"?" RETURNS".process_type($K["returns"],"CHARACTER SET"):"").($K["language"]?" LANGUAGE $K[language]":"").(JUSH=="pgsql"?" AS ".q($Xb):"\n$Xb;");}function
remove_definer($H){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$H);}function
format_foreign_key(array$q){$k=$q["db"];$Gf=$q["ns"];return" FOREIGN KEY (".implode(", ",array_map('Adminer\idf_escape',$q["source"])).") REFERENCES ".($k!=""&&$k!=$_GET["db"]?idf_escape($k).".":"").($Gf!=""&&$Gf!=$_GET["ns"]?idf_escape($Gf).".":"").idf_escape($q["table"])." (".implode(", ",array_map('Adminer\idf_escape',$q["target"])).")".(preg_match("~^(".driver()->onActions.")\$~",$q["on_delete"])?" ON DELETE $q[on_delete]":"").(preg_match("~^(".driver()->onActions.")\$~",$q["on_update"])?" ON UPDATE $q[on_update]":"");}function
tar_file($p,$Vi){$J=pack("a100a8a8a8a12a12",$p,644,0,0,decoct($Vi->size),decoct(time()));$db=8*32;for($t=0;$t<strlen($J);$t++)$db+=ord($J[$t]);$J
.=sprintf("%06o",$db)."\0 ";echo$J,str_repeat("\0",512-strlen($J));$Vi->send();echo
str_repeat("\0",511-($Vi->size+511)%512);}function
ini_bytes($le){$X=ini_get($le);switch(strtolower(substr($X,-1))){case'g':$X=(int)$X*1024;case'm':$X=(int)$X*1024;case'k':$X=(int)$X*1024;}return$X;}function
doc_link(array$Fg,$Li="<sup>?</sup>"){$Uh=connection()->server_info;$Ij=preg_replace('~^(\d\.?\d).*~s','\1',$Uh);$yj=array('sql'=>"https://dev.mysql.com/doc/refman/$Ij/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/".(connection()->flavor=='cockroach'?"current":$Ij)."/",'mssql'=>"https://learn.microsoft.com/en-us/sql/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$Uh)."&id=",);if(connection()->flavor=='maria'){$yj['sql']="https://mariadb.com/kb/en/";$Fg['sql']=(isset($Fg['mariadb'])?$Fg['mariadb']:str_replace(".html","/",$Fg['sql']));}return($Fg[JUSH]?"<a href='".h($yj[JUSH].$Fg[JUSH].(JUSH=='mssql'?"?view=sql-server-ver$Ij":""))."'".target_blank().">$Li</a>":"");}function
db_size($k){if(!connection()->select_db($k))return"?";$J=0;foreach(table_status()as$S)$J+=$S["Data_length"]+$S["Index_length"];return
format_number($J);}function
set_utf8mb4($i){static$O=false;if(!$O&&preg_match('~\butf8mb4~i',$i)){$O=true;echo"SET NAMES ".charset(connection()).";\n\n";}}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?connection()->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(36).": ".h(DB),lang(113),true);}else{if($_POST["db"]&&!$m)queries_redirect(substr(ME,0,-1),lang(114),drop_databases($_POST["db"]));page_header(lang(115),$m,false);echo"<p class='links'>\n";foreach(array('database'=>lang(116),'privileges'=>lang(70),'processlist'=>lang(117),'variables'=>lang(118),'status'=>lang(119),)as$y=>$X){if(support($y))echo"<a href='".h(ME)."$y='>$X</a>\n";}echo"<p>".lang(120,get_driver(DRIVER),"<b>".h(connection()->server_info)."</b>","<b>".connection()->extension."</b>")."\n","<p>".lang(121,"<b>".h(logged_user())."</b>")."\n";$j=adminer()->databases();if($j){$Hh=support("scheme");$lb=collations();echo"<form action='' method='post'>\n","<table class='checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(36).(get_session("dbs")!==null?" - <a href='".h(ME)."refresh=1'>".lang(122)."</a>":"")."<td>".lang(123)."<td>".lang(124)."<td>".lang(125)." - <a href='".h(ME)."dbsize=1'>".lang(126)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$j=($_GET["dbsize"]?count_tables($j):array_flip($j));foreach($j
as$k=>$T){$zh=h(ME)."db=".urlencode($k);$u=h("Db-".$k);echo"<tr>".(support("database")?"<td>".checkbox("db[]",$k,in_array($k,(array)$_POST["db"]),"","","",$u):""),"<th><a href='$zh' id='$u'>".h($k)."</a>";$c=h(db_collation($k,$lb));echo"<td>".(support("database")?"<a href='$zh".($Hh?"&amp;ns=":"")."&amp;database=' title='".lang(66)."'>$c</a>":$c),"<td align='right'><a href='$zh&amp;schema=' id='tables-".h($k)."' title='".lang(69)."'>".($_GET["dbsize"]?$T:"?")."</a>","<td align='right' id='size-".h($k)."'>".($_GET["dbsize"]?db_size($k):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(127)." <span id='selected'></span></legend><div>\n".input_hidden("all").script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(128)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),input_token(),"</form>\n",script("tableCheck();");}if(!empty(adminer()->plugins)){echo"<div class='plugins'>\n","<h3>".lang(129)."</h3>\n<ul>\n";foreach(adminer()->plugins
as$Kg){$bc=(method_exists($Kg,'description')?$Kg->description():"");if(!$bc){$oh=new
\ReflectionObject($Kg);if(preg_match('~^/[\s*]+(.+)~',$oh->getDocComment(),$A))$bc=$A[1];}$Ih=(method_exists($Kg,'screenshot')?$Kg->screenshot():"");echo"<li><b>".get_class($Kg)."</b>".h($bc?": $bc":"").($Ih?" (<a href='".h($Ih)."'".target_blank().">".lang(130)."</a>)":"")."\n";}echo"</ul>\n";adminer()->pluginsLinks();echo"</div>\n";}}page_footer("db");exit;}if(support("scheme")){if(DB!=""&&$_GET["ns"]!==""){if(!isset($_GET["ns"]))redirect(preg_replace('~ns=[^&]*&~','',ME)."ns=".get_schema());if(!set_schema($_GET["ns"])){header("HTTP/1.1 404 Not Found");page_header(lang(75).": ".h($_GET["ns"]),lang(131),true);page_footer("ns");exit;}}}class
TmpFile{private$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($Ab){$this->size+=strlen($Ab);fwrite($this->handler,$Ab);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$o=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$M=array(idf_escape($_GET["field"]));$I=driver()->select($a,$M,array(where($_GET,$o)),$M);$K=($I?$I->fetch_row():array());echo
driver()->value($K[0],$o[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$o=fields($a);if(!$o)$m=error()?:lang(9);$S=table_status1($a);$B=adminer()->tableName($S);page_header(($o&&is_view($S)?$S['Engine']=='materialized view'?lang(132):lang(133):lang(134)).": ".($B!=""?$B:h($a)),$m);$yh=array();foreach($o
as$y=>$n)$yh+=$n["privileges"];adminer()->selectLinks($S,(isset($yh["insert"])||!support("table")?"":null));$qb=$S["Comment"];if($qb!="")echo"<p class='nowrap'>".lang(49).": ".h($qb)."\n";function
tables_links($T){echo"<ul>\n";foreach($T
as$R)echo"<li><a href='".h(ME."table=".urlencode($R))."'>".h($R)."</a>";echo"</ul>\n";}$ke=driver()->inheritsFrom($a);if($ke){echo"<h3>".lang(135)."</h3>\n";tables_links($ke);}elseif($o)adminer()->tableStructurePrint($o,$S);if(support("indexes")&&driver()->supportsIndex($S)){echo"<h3 id='indexes'>".lang(136)."</h3>\n";$x=indexes($a);if($x)adminer()->tableIndexesPrint($x,$S);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(137)."</a>\n";}if(!is_view($S)){if(fk_support($S)){echo"<h3 id='foreign-keys'>".lang(101)."</h3>\n";$nd=foreign_keys($a);if($nd){echo"<table>\n","<thead><tr><th>".lang(138)."<td>".lang(139)."<td>".lang(104)."<td>".lang(103)."<td></thead>\n";foreach($nd
as$B=>$q){echo"<tr title='".h($B)."'>","<th><i>".implode("</i>, <i>",array_map('Adminer\h',$q["source"]))."</i>";$_=($q["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($q["db"]),ME):($q["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($q["ns"]),ME):ME));echo"<td><a href='".h($_."table=".urlencode($q["table"]))."'>".($q["db"]!=""&&$q["db"]!=DB?"<b>".h($q["db"])."</b>.":"").($q["ns"]!=""&&$q["ns"]!=$_GET["ns"]?"<b>".h($q["ns"])."</b>.":"").h($q["table"])."</a>","(<i>".implode("</i>, <i>",array_map('Adminer\h',$q["target"]))."</i>)","<td>".h($q["on_delete"]),"<td>".h($q["on_update"]),'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($B)).'">'.lang(140).'</a>',"\n";}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(141)."</a>\n";}if(support("check")){echo"<h3 id='checks'>".lang(142)."</h3>\n";$Za=driver()->checkConstraints($a);if($Za){echo"<table>\n";foreach($Za
as$y=>$X)echo"<tr title='".h($y)."'>","<td><code class='jush-".JUSH."'>".h($X),"<td><a href='".h(ME.'check='.urlencode($a).'&name='.urlencode($y))."'>".lang(140)."</a>","\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'check='.urlencode($a).'">'.lang(143)."</a>\n";}}if(support(is_view($S)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(144)."</h3>\n";$jj=triggers($a);if($jj){echo"<table>\n";foreach($jj
as$y=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($y)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($y))."'>".lang(140)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(145)."</a>\n";}$je=driver()->inheritedTables($a);if($je){echo"<h3 id='partitions'>".lang(146)."</h3>\n";$zg=driver()->partitionsInfo($a);if($zg)echo"<p><code class='jush-".JUSH."'>BY ".h("$zg[partition_by]($zg[partition])")."</code>\n";tables_links($je);}}elseif(isset($_GET["schema"])){page_header(lang(69),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$Ai=array();$Bi=array();$da=($_GET["schema"]?:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$da,$cf,PREG_SET_ORDER);foreach($cf
as$t=>$A){$Ai[$A[1]]=array($A[2],$A[3]);$Bi[]="\n\t'".js_escape($A[1])."': [ $A[2], $A[3] ]";}$Yi=0;$Ia=-1;$Fh=array();$nh=array();$Oe=array();$ua=driver()->allFields();foreach(table_status('',true)as$R=>$S){if(is_view($S))continue;$Ng=0;$Fh[$R]["fields"]=array();foreach($ua[$R]as$n){$Ng+=1.25;$n["pos"]=$Ng;$Fh[$R]["fields"][$n["field"]]=$n;}$Fh[$R]["pos"]=($Ai[$R]?:array($Yi,0));foreach(adminer()->foreignKeys($R)as$X){if(!$X["db"]){$Me=$Ia;if(idx($Ai[$R],1)||idx($Ai[$X["table"]],1))$Me=min(idx($Ai[$R],1,0),idx($Ai[$X["table"]],1,0))-1;else$Ia-=.1;while($Oe[(string)$Me])$Me-=.0001;$Fh[$R]["references"][$X["table"]][(string)$Me]=array($X["source"],$X["target"]);$nh[$X["table"]][$R][(string)$Me]=$X["target"];$Oe[(string)$Me]=true;}}$Yi=max($Yi,$Fh[$R]["pos"][0]+2.5+$Ng);}echo'<div id="schema" style="height: ',$Yi,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = () => false;
const tablePos = {',implode(",",$Bi)."\n",'};
const em = qs(\'#schema\').offsetHeight / ',$Yi,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($Fh
as$B=>$R){echo"<div class='table' style='top: ".$R["pos"][0]."em; left: ".$R["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($B).'"><b>'.h($B)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($R["fields"]as$n){$X='<span'.type_class($n["type"]).' title="'.h($n["type"].($n["length"]?"($n[length])":"").($n["null"]?" NULL":'')).'">'.h($n["field"]).'</span>';echo"<br>".($n["primary"]?"<i>$X</i>":$X);}foreach((array)$R["references"]as$Ii=>$ph){foreach($ph
as$Me=>$kh){$Ne=$Me-idx($Ai[$B],1);$t=0;foreach($kh[0]as$ei)echo"\n<div class='references' title='".h($Ii)."' id='refs$Me-".($t++)."' style='left: $Ne"."em; top: ".$R["fields"][$ei]["pos"]."em; padding-top: .5em;'>"."<div style='border-top: 1px solid gray; width: ".(-$Ne)."em;'></div></div>";}}foreach((array)$nh[$B]as$Ii=>$ph){foreach($ph
as$Me=>$e){$Ne=$Me-idx($Ai[$B],1);$t=0;foreach($e
as$Hi)echo"\n<div class='references arrow' title='".h($Ii)."' id='refd$Me-".($t++)."' style='left: $Ne"."em; top: ".$R["fields"][$Hi]["pos"]."em;'>"."<div style='height: .5em; border-bottom: 1px solid gray; width: ".(-$Ne)."em;'></div>"."</div>";}}echo"\n</div>\n";}foreach($Fh
as$B=>$R){foreach((array)$R["references"]as$Ii=>$ph){foreach($ph
as$Me=>$kh){$sf=$Yi;$gf=-10;foreach($kh[0]as$y=>$ei){$Og=$R["pos"][0]+$R["fields"][$ei]["pos"];$Pg=$Fh[$Ii]["pos"][0]+$Fh[$Ii]["fields"][$kh[1][$y]]["pos"];$sf=min($sf,$Og,$Pg);$gf=max($gf,$Og,$Pg);}echo"<div class='references' id='refl$Me' style='left: $Me"."em; top: $sf"."em; padding: .5em 0;'><div style='border-right: 1px solid gray; margin-top: 1px; height: ".($gf-$sf)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($da)),'" id="schema-link">',lang(147),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$m){save_settings(array_intersect_key($_POST,array_flip(array("output","format","db_style","types","routines","events","table_style","auto_increment","triggers","data_style"))),"adminer_export");$T=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Qc=dump_headers((count($T)==1?key($T):DB),(DB==""||count($T)>1));$xe=preg_match('~sql~',$_POST["format"]);if($xe){echo"-- Adminer ".VERSION." ".get_driver(DRIVER)." ".str_replace("\n"," ",connection()->server_info)." dump\n\n";if(JUSH=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";connection()->query("SET time_zone = '+00:00'");connection()->query("SET sql_mode = ''");}}$ri=$_POST["db_style"];$j=array(DB);if(DB==""){$j=$_POST["databases"];if(is_string($j))$j=explode("\n",rtrim(str_replace("\r","",$j),"\n"));}foreach((array)$j
as$k){adminer()->dumpDatabase($k);if(connection()->select_db($k)){if($xe&&preg_match('~CREATE~',$ri)&&($i=get_val("SHOW CREATE DATABASE ".idf_escape($k),1))){set_utf8mb4($i);if($ri=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($k).";\n";echo"$i;\n";}if($xe){if($ri)echo
use_sql($k).";\n\n";$pg="";if($_POST["types"]){foreach(types()as$u=>$U){$Ec=type_values($u);if($Ec)$pg
.=($ri!='DROP+CREATE'?"DROP TYPE IF EXISTS ".idf_escape($U).";;\n":"")."CREATE TYPE ".idf_escape($U)." AS ENUM ($Ec);\n\n";else$pg
.="-- Could not export type $U\n\n";}}if($_POST["routines"]){foreach(routines()as$K){$B=$K["ROUTINE_NAME"];$_h=$K["ROUTINE_TYPE"];$i=create_routine($_h,array("name"=>$B)+routine($K["SPECIFIC_NAME"],$_h));set_utf8mb4($i);$pg
.=($ri!='DROP+CREATE'?"DROP $_h IF EXISTS ".idf_escape($B).";;\n":"")."$i;\n\n";}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$K){$i=remove_definer(get_val("SHOW CREATE EVENT ".idf_escape($K["Name"]),3));set_utf8mb4($i);$pg
.=($ri!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($K["Name"]).";;\n":"")."$i;;\n\n";}}echo($pg&&JUSH=='sql'?"DELIMITER ;;\n\n$pg"."DELIMITER ;\n\n":$pg);}if($_POST["table_style"]||$_POST["data_style"]){$Kj=array();foreach(table_status('',true)as$B=>$S){$R=(DB==""||in_array($B,(array)$_POST["tables"]));$Nb=(DB==""||in_array($B,(array)$_POST["data"]));if($R||$Nb){$Vi=null;if($Qc=="tar"){$Vi=new
TmpFile;ob_start(array($Vi,'write'),1e5);}adminer()->dumpTable($B,($R?$_POST["table_style"]:""),(is_view($S)?2:0));if(is_view($S))$Kj[]=$B;elseif($Nb){$o=fields($B);adminer()->dumpData($B,$_POST["data_style"],"SELECT *".convert_fields($o,$o)." FROM ".table($B));}if($xe&&$_POST["triggers"]&&$R&&($jj=trigger_sql($B)))echo"\nDELIMITER ;;\n$jj\nDELIMITER ;\n";if($Qc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$k/")."$B.csv",$Vi);}elseif($xe)echo"\n";}}if(function_exists('Adminer\foreign_keys_sql')){foreach(table_status('',true)as$B=>$S){$R=(DB==""||in_array($B,(array)$_POST["tables"]));if($R&&!is_view($S))echo
foreign_keys_sql($B);}}foreach($Kj
as$Jj)adminer()->dumpTable($Jj,$_POST["table_style"],1);if($Qc=="tar")echo
pack("x512");}}}adminer()->dumpFooter();exit;}page_header(lang(72),$m,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table class="layout">
';$Rb=array('','USE','DROP+CREATE','CREATE');$Ci=array('','DROP+CREATE','CREATE');$Ob=array('','TRUNCATE+INSERT','INSERT');if(JUSH=="sql")$Ob[]='INSERT+UPDATE';$K=get_settings("adminer_export");if(!$K)$K=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($K["events"])){$K["routines"]=$K["events"]=($_GET["dump"]=="");$K["triggers"]=$K["table_style"];}echo"<tr><th>".lang(148)."<td>".html_radios("output",adminer()->dumpOutput(),$K["output"])."\n","<tr><th>".lang(149)."<td>".html_radios("format",adminer()->dumpFormat(),$K["format"])."\n",(JUSH=="sqlite"?"":"<tr><th>".lang(36)."<td>".html_select('db_style',$Rb,$K["db_style"]).(support("type")?checkbox("types",1,$K["types"],lang(31)):"").(support("routine")?checkbox("routines",1,$K["routines"],lang(150)):"").(support("event")?checkbox("events",1,$K["events"],lang(151)):"")),"<tr><th>".lang(124)."<td>".html_select('table_style',$Ci,$K["table_style"]).checkbox("auto_increment",1,$K["auto_increment"],lang(50)).(support("trigger")?checkbox("triggers",1,$K["triggers"],lang(144)):""),"<tr><th>".lang(152)."<td>".html_select('data_style',$Ob,$K["data_style"]),'</table>
<p><input type="submit" value="',lang(72),'">
',input_token(),'
<table>
',script("qsl('table').onclick = dumpClick;");$Tg=array();if(DB!=""){$bb=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$bb>".lang(124)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(152)."<input type='checkbox' id='check-data'$bb></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$Kj="";$Ei=tables_list();foreach($Ei
as$B=>$U){$Sg=preg_replace('~_.*~','',$B);$bb=($a==""||$a==(substr($a,-1)=="%"?"$Sg%":$B));$Wg="<tr><td>".checkbox("tables[]",$B,$bb,$B,"","block");if($U!==null&&!preg_match('~table~i',$U))$Kj
.="$Wg\n";else
echo"$Wg<td align='right'><label class='block'><span id='Rows-".h($B)."'></span>".checkbox("data[]",$B,$bb)."</label>\n";$Tg[$Sg]++;}echo$Kj;if($Ei)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(36)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$j=adminer()->databases();if($j){foreach($j
as$k){if(!information_schema($k)){$Sg=preg_replace('~_.*~','',$k);echo"<tr><td>".checkbox("databases[]",$k,$a==""||$a=="$Sg%",$k,"","block")."\n";$Tg[$Sg]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$dd=true;foreach($Tg
as$y=>$X){if($y!=""&&$X>1){echo($dd?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$y%")."'>".h($y)."</a>";$dd=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(70));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(153)."</a>";$I=connection()->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$wd=$I;if(!$I)$I=connection()->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo
input_hidden("db",DB),($wd?"":input_hidden("grant")),"<table class='odds'>\n","<thead><tr><th>".lang(34)."<th>".lang(33)."<th></thead>\n";while($K=$I->fetch_assoc())echo'<tr><td>'.h($K["User"])."<td>".h($K["Host"]).'<td><a href="'.h(ME.'user='.urlencode($K["User"]).'&host='.urlencode($K["Host"])).'">'.lang(10)."</a>\n";if(!$wd||DB!="")echo"<tr><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(10)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$m&&$_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers("sql");adminer()->dumpTable("","");adminer()->dumpData("","table",$_POST["query"]);adminer()->dumpFooter();exit;}restart_session();$Md=&get_session("queries");$Ld=&$Md[DB];if(!$m&&$_POST["clear"]){$Ld=array();redirect(remove_from_uri("history"));}stop_session();page_header((isset($_GET["import"])?lang(71):lang(63)),$m);$Te='--'.(JUSH=='sql'?' ':'');if(!$m&&$_POST){$r=false;if(!isset($_GET["import"]))$H=$_POST["query"];elseif($_POST["webfile"]){$ii=adminer()->importServerPath();$r=@fopen((file_exists($ii)?$ii:"compress.zlib://$ii.gz"),"rb");$H=($r?fread($r,1e6):false);}else$H=get_file("sql_file",true,";");if(is_string($H)){if(function_exists('memory_get_usage')&&($lf=ini_bytes("memory_limit"))!="-1")@ini_set("memory_limit",max($lf,strval(2*strlen($H)+memory_get_usage()+8e6)));if($H!=""&&strlen($H)<1e6){$dh=$H.(preg_match("~;[ \t\r\n]*\$~",$H)?"":";");if(!$Ld||first(end($Ld))!=$dh){restart_session();$Ld[]=array($dh,time());set_session("queries",$Md);stop_session();}}$fi="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|$Te)[^\n]*\n?|--\r?\n)";$Zb=";";$C=0;$zc=true;$h=connect();if($h&&DB!=""){$h->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$h);}$pb=0;$Gc=array();$wg='[\'"'.(JUSH=="sql"?'`#':(JUSH=="sqlite"?'`[':(JUSH=="mssql"?'[':''))).']|/\*|'.$Te.'|$'.(JUSH=="pgsql"?'|\$[^$]*\$':'');$Zi=microtime(true);$oa=get_settings("adminer_import");$qc=adminer()->dumpFormat();unset($qc["sql"]);while($H!=""){if(!$C&&preg_match("~^$fi*+DELIMITER\\s+(\\S+)~i",$H,$A)){$Zb=preg_quote($A[1]);$H=substr($H,strlen($A[0]));}elseif(!$C&&JUSH=='pgsql'&&preg_match("~^($fi*+COPY\\s+)[^;]+\\s+FROM\\s+stdin;~i",$H,$A)){$Zb="\n\\\\\\.\r?\n";$C=strlen($A[0]);}else{preg_match("($Zb\\s*|$wg)",$H,$A,PREG_OFFSET_CAPTURE,$C);list($pd,$Ng)=$A[0];if(!$pd&&$r&&!feof($r))$H
.=fread($r,1e5);else{if(!$pd&&rtrim($H)=="")break;$C=$Ng+strlen($pd);if($pd&&!preg_match("(^$Zb)",$pd)){$Ta=driver()->hasCStyleEscapes()||(JUSH=="pgsql"&&($Ng>0&&strtolower($H[$Ng-1])=="e"));$Gg=($pd=='/*'?'\*/':($pd=='['?']':(preg_match("~^$Te|^#~",$pd)?"\n":preg_quote($pd).($Ta?'|\\\\.':''))));while(preg_match("($Gg|\$)s",$H,$A,PREG_OFFSET_CAPTURE,$C)){$Dh=$A[0][0];if(!$Dh&&$r&&!feof($r))$H
.=fread($r,1e5);else{$C=$A[0][1]+strlen($Dh);if(!$Dh||$Dh[0]!="\\")break;}}}else{$zc=false;$dh=substr($H,0,$Ng+($Zb[0]=="\n"?3:0));$pb++;$Wg="<pre id='sql-$pb'><code class='jush-".JUSH."'>".adminer()->sqlCommandQuery($dh)."</code></pre>\n";if(JUSH=="sqlite"&&preg_match("~^$fi*+ATTACH\\b~i",$dh,$A)){echo$Wg,"<p class='error'>".lang(154)."\n";$Gc[]=" <a href='#sql-$pb'>$pb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$Wg;ob_flush();flush();}$ni=microtime(true);if(connection()->multi_query($dh)&&$h&&preg_match("~^$fi*+USE\\b~i",$dh))$h->query($dh);do{$I=connection()->store_result();if(connection()->error){echo($_POST["only_errors"]?$Wg:""),"<p class='error'>".lang(155).(connection()->errno?" (".connection()->errno.")":"").": ".error()."\n";$Gc[]=" <a href='#sql-$pb'>$pb</a>";if($_POST["error_stops"])break
2;}else{$Oi=" <span class='time'>(".format_time($ni).")</span>".(strlen($dh)<1000?" <a href='".h(ME)."sql=".urlencode(trim($dh))."'>".lang(10)."</a>":"");$qa=connection()->affected_rows;$Nj=($_POST["only_errors"]?"":driver()->warnings());$Oj="warnings-$pb";if($Nj)$Oi
.=", <a href='#$Oj'>".lang(45)."</a>".script("qsl('a').onclick = partial(toggle, '$Oj');","");$Oc=null;$hg=null;$Pc="explain-$pb";if(is_object($I)){$z=$_POST["limit"];$hg=print_select_result($I,$h,array(),$z);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$If=$I->num_rows;echo"<p class='sql-footer'>".($If?($z&&$If>$z?lang(156,$z):"").lang(157,$If):""),$Oi;if($h&&preg_match("~^($fi|\\()*+SELECT\\b~i",$dh)&&($Oc=explain($h,$dh)))echo", <a href='#$Pc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$Pc');","");$u="export-$pb";echo", <a href='#$u'>".lang(72)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."<span id='$u' class='hidden'>: ".html_select("output",adminer()->dumpOutput(),$oa["output"])." ".html_select("format",$qc,$oa["format"]).input_hidden("query",$dh)."<input type='submit' name='export' value='".lang(72)."'>".input_token()."</span>\n"."</form>\n";}}else{if(preg_match("~^$fi*+(CREATE|DROP|ALTER)$fi++(DATABASE|SCHEMA)\\b~i",$dh)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h(connection()->info)."'>".lang(158,$qa)."$Oi\n";}echo($Nj?"<div id='$Oj' class='hidden'>\n$Nj</div>\n":"");if($Oc){echo"<div id='$Pc' class='hidden explain'>\n";print_select_result($Oc,$h,$hg);echo"</div>\n";}}$ni=microtime(true);}while(connection()->next_result());}$H=substr($H,$C);$C=0;}}}}if($zc)echo"<p class='message'>".lang(159)."\n";elseif($_POST["only_errors"])echo"<p class='message'>".lang(160,$pb-count($Gc))," <span class='time'>(".format_time($Zi).")</span>\n";elseif($Gc&&$pb>1)echo"<p class='error'>".lang(155).": ".implode("",$Gc)."\n";}else
echo"<p class='error'>".upload_error($H)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$Mc="<input type='submit' value='".lang(161)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$dh=$_GET["sql"];if($_POST)$dh=$_POST["query"];elseif($_GET["history"]=="all")$dh=$Ld;elseif($_GET["history"]!="")$dh=idx($Ld[$_GET["history"]],0);echo"<p>";textarea("query",$dh,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>";adminer()->sqlPrintAfter();echo"$Mc\n",lang(162).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(163)."</legend><div>";$Bd=(extension_loaded("zlib")?"[.gz]":"");echo(ini_bool("file_uploads")?"SQL$Bd (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n$Mc":lang(164)),"</div></fieldset>\n";$Xd=adminer()->importServerPath();if($Xd)echo"<fieldset><legend>".lang(165)."</legend><div>",lang(166,"<code>".h($Xd)."$Bd</code>"),' <input type="submit" name="webfile" value="'.lang(167).'">',"</div></fieldset>\n";echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(168))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(169))."\n",input_token();if(!isset($_GET["import"])&&$Ld){print_fieldset("history",lang(170),$_GET["history"]!="");for($X=end($Ld);$X;$X=prev($Ld)){$y=key($Ld);list($dh,$Oi,$uc)=$X;echo'<a href="'.h(ME."sql=&history=$y").'">'.lang(10)."</a>"." <span class='time' title='".@date('Y-m-d',$Oi)."'>".@date("H:i:s",$Oi)."</span>"." <code class='jush-".JUSH."'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace("~^(#|$Te).*~m",'',$dh)))),80,"</code>").($uc?" <span class='time'>($uc)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(171)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(172)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$o=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$o):""):where($_GET,$o));$vj=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($o
as$B=>$n){if(!isset($n["privileges"][$vj?"update":"insert"])||adminer()->fieldName($n)==""||$n["generated"])unset($o[$B]);}if($_POST&&!$m&&!isset($_GET["select"])){$Ve=$_POST["referer"];if($_POST["insert"])$Ve=($vj?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$Ve))$Ve=ME."select=".urlencode($a);$x=indexes($a);$qj=unique_array($_GET["where"],$x);$gh="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($Ve,lang(173),driver()->delete($a,$gh,$qj?0:1));else{$O=array();foreach($o
as$B=>$n){$X=process_input($n);if($X!==false&&$X!==null)$O[idf_escape($B)]=$X;}if($vj){if(!$O)redirect($Ve);queries_redirect($Ve,lang(174),driver()->update($a,$O,$gh,$qj?0:1));if(is_ajax()){page_headers();page_messages($m);exit;}}else{$I=driver()->insert($a,$O);$Le=($I?last_id($I):0);queries_redirect($Ve,lang(175,($Le?" $Le":"")),$I);}}}$K=null;if($_POST["save"])$K=(array)$_POST["fields"];elseif($Z){$M=array();foreach($o
as$B=>$n){if(isset($n["privileges"]["select"])){$ya=($_POST["clone"]&&$n["auto_increment"]?"''":convert_field($n));$M[]=($ya?"$ya AS ":"").idf_escape($B);}}$K=array();if(!support("table"))$M=array("*");if($M){$I=driver()->select($a,$M,array($Z),$M,array(),(isset($_GET["select"])?2:1));if(!$I)$m=error();else{$K=$I->fetch_assoc();if(!$K)$K=false;}if(isset($_GET["select"])&&(!$K||$I->fetch_assoc()))$K=null;}}if(!support("table")&&!$o){if(!$Z){$I=driver()->select($a,array("*"),array(),array("*"));$K=($I?$I->fetch_assoc():false);if(!$K)$K=array(driver()->primary=>"");}if($K){foreach($K
as$y=>$X){if(!$Z)$K[$y]=null;$o[$y]=array("field"=>$y,"null"=>($y!=driver()->primary),"auto_increment"=>($y==driver()->primary));}}}edit_form($a,$o,$K,$vj,$m);}elseif(isset($_GET["create"])){$a=$_GET["create"];$Ag=driver()->partitionBy;$Dg=driver()->partitionsInfo($a);$mh=referencable_primary($a);$nd=array();foreach($mh
as$zi=>$n)$nd[str_replace("`","``",$zi)."`".str_replace("`","``",$n["field"])]=$zi;$kg=array();$S=array();if($a!=""){$kg=fields($a);$S=table_status1($a);if(count($S)<2)$m=lang(9);}$K=$_POST;$K["fields"]=(array)$K["fields"];if($K["auto_increment_col"])$K["fields"][$K["auto_increment_col"]]["auto_increment"]=true;if($_POST)save_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($K["fields"])&&!$m){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(176),drop_tables(array($a)));else{$o=array();$ua=array();$zj=false;$ld=array();$jg=reset($kg);$sa=" FIRST";foreach($K["fields"]as$y=>$n){$q=$nd[$n["type"]];$kj=($q!==null?$mh[$q]:$n);if($n["field"]!=""){if(!$n["generated"])$n["default"]=null;$bh=process_field($n,$kj);$ua[]=array($n["orig"],$bh,$sa);if(!$jg||$bh!==process_field($jg,$jg)){$o[]=array($n["orig"],$bh,$sa);if($n["orig"]!=""||$sa)$zj=true;}if($q!==null)$ld[idf_escape($n["field"])]=($a!=""&&JUSH!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$nd[$n["type"]],'source'=>array($n["field"]),'target'=>array($kj["field"]),'on_delete'=>$n["on_delete"],));$sa=" AFTER ".idf_escape($n["field"]);}elseif($n["orig"]!=""){$zj=true;$o[]=array($n["orig"]);}if($n["orig"]!=""){$jg=next($kg);if(!$jg)$sa="";}}$E=array();if(in_array($K["partition_by"],$Ag)){foreach($K
as$y=>$X){if(preg_match('~^partition~',$y))$E[$y]=$X;}foreach($E["partition_names"]as$y=>$B){if($B==""){unset($E["partition_names"][$y]);unset($E["partition_values"][$y]);}}$E["partition_names"]=array_values($E["partition_names"]);$E["partition_values"]=array_values($E["partition_values"]);if($E==$Dg)$E=array();}elseif(preg_match("~partitioned~",$S["Create_options"]))$E=null;$mf=lang(177);if($a==""){cookie("adminer_engine",$K["Engine"]);$mf=lang(178);}$B=trim($K["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($B),$mf,alter_table($a,$B,(JUSH=="sqlite"&&($zj||$ld)?$ua:$o),$ld,($K["Comment"]!=$S["Comment"]?$K["Comment"]:null),($K["Engine"]&&$K["Engine"]!=$S["Engine"]?$K["Engine"]:""),($K["Collation"]&&$K["Collation"]!=$S["Collation"]?$K["Collation"]:""),($K["Auto_increment"]!=""?number($K["Auto_increment"]):""),$E));}}page_header(($a!=""?lang(43):lang(73)),$m,array("table"=>$a),h($a));if(!$_POST){$mj=driver()->types();$K=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($mj["int"])?"int":(isset($mj["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$K=$S;$K["name"]=$a;$K["fields"]=array();if(!$_GET["auto_increment"])$K["Auto_increment"]="";foreach($kg
as$n){$n["generated"]=$n["generated"]?:(isset($n["default"])?"DEFAULT":"");$K["fields"][]=$n;}if($Ag){$K+=$Dg;$K["partition_names"][]="";$K["partition_values"][]="";}}}$lb=collations();if(is_array(reset($lb)))$lb=call_user_func_array('array_merge',array_values($lb));$Ac=driver()->engines();foreach($Ac
as$_c){if(!strcasecmp($_c,$K["Engine"])){$K["Engine"]=$_c;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(179).": <input name='name'".($a==""&&!$_POST?" autofocus":"")." data-maxlength='64' value='".h($K["name"])."' autocapitalize='off'>\n",($Ac?html_select("Engine",array(""=>"(".lang(180).")")+$Ac,$K["Engine"]).on_help("event.target.value",1).script("qsl('select').onchange = helpClose;")."\n":"");if($lb)echo"<datalist id='collations'>".optionlist($lb)."</datalist>\n",(preg_match("~sqlite|mssql~",JUSH)?"":"<input list='collations' name='Collation' value='".h($K["Collation"])."' placeholder='(".lang(102).")'>\n");echo"<input type='submit' value='".lang(14)."'>\n";}if(support("columns")){echo"<div class='scrollable'>\n","<table id='edit-fields' class='nowrap'>\n";edit_fields($K["fields"],$lb,"TABLE",$nd);echo"</table>\n",script("editFields();"),"</div>\n<p>\n",lang(50).": <input type='number' name='Auto_increment' class='size' value='".h($K["Auto_increment"])."'>\n",checkbox("defaults",1,($_POST?$_POST["defaults"]:get_setting("defaults")),lang(181),"columnShow(this.checked, 5)","jsonly");$sb=($_POST?$_POST["comments"]:get_setting("comments"));echo(support("comment")?checkbox("comments",1,$sb,lang(49),"editingCommentsClick(this, true);","jsonly").' '.(preg_match('~\n~',$K["Comment"])?"<textarea name='Comment' rows='2' cols='20'".($sb?"":" class='hidden'").">".h($K["Comment"])."</textarea>":'<input name="Comment" value="'.h($K["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'"'.($sb?"":" class='hidden'").'>'):''),'<p>
<input type="submit" value="',lang(14),'">
';}echo'
';if($a!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(182,$a));if($Ag&&(JUSH=='sql'||$a=="")){$Bg=preg_match('~RANGE|LIST~',$K["partition_by"]);print_fieldset("partition",lang(183),$K["partition_by"]);echo"<p>".html_select("partition_by",array_merge(array(""),$Ag),$K["partition_by"]).on_help("event.target.value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),"(<input name='partition' value='".h($K["partition"])."'>)\n",lang(146).": <input type='number' name='partitions' class='size".($Bg||!$K["partition_by"]?" hidden":"")."' value='".h($K["partitions"])."'>\n","<table id='partition-table'".($Bg?"":" class='hidden'").">\n","<thead><tr><th>".lang(184)."<th>".lang(185)."</thead>\n";foreach($K["partition_names"]as$y=>$X)echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($y==count($K["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h(idx($K["partition_values"],$y)).'">';echo"</table>\n</div></fieldset>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$fe=array("PRIMARY","UNIQUE","INDEX");$S=table_status1($a,true);$ce=driver()->indexAlgorithms($S);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$S["Engine"]))$fe[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$S["Engine"]))$fe[]="SPATIAL";$x=indexes($a);$G=array();if(JUSH=="mongo"){$G=$x["_id_"];unset($fe[0]);unset($x["_id_"]);}$K=$_POST;if($K)save_settings(array("index_options"=>$K["options"]));if($_POST&&!$m&&!$_POST["add"]&&!$_POST["drop_col"]){$b=array();foreach($K["indexes"]as$w){$B=$w["name"];if(in_array($w["type"],$fe)){$e=array();$Re=array();$cc=array();$de=(support("partial_indexes")?$w["partial"]:"");$be=(in_array($w["algorithm"],$ce)?$w["algorithm"]:"");$O=array();ksort($w["columns"]);foreach($w["columns"]as$y=>$d){if($d!=""){$Qe=idx($w["lengths"],$y);$ac=idx($w["descs"],$y);$O[]=idf_escape($d).($Qe?"(".(+$Qe).")":"").($ac?" DESC":"");$e[]=$d;$Re[]=($Qe?:null);$cc[]=$ac;}}$Nc=$x[$B];if($Nc){ksort($Nc["columns"]);ksort($Nc["lengths"]);ksort($Nc["descs"]);if($w["type"]==$Nc["type"]&&array_values($Nc["columns"])===$e&&(!$Nc["lengths"]||array_values($Nc["lengths"])===$Re)&&array_values($Nc["descs"])===$cc&&$Nc["partial"]==$de&&(!$ce||$Nc["algorithm"]==$be)){unset($x[$B]);continue;}}if($e)$b[]=array($w["type"],$B,$O,$be,$de);}}foreach($x
as$B=>$Nc)$b[]=array($Nc["type"],$B,"DROP");if(!$b)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(186),alter_indexes($a,$b));}page_header(lang(136),$m,array("table"=>$a),h($a));$o=array_keys(fields($a));if($_POST["add"]){foreach($K["indexes"]as$y=>$w){if($w["columns"][count($w["columns"])]!="")$K["indexes"][$y]["columns"][]="";}$w=end($K["indexes"]);if($w["type"]||array_filter($w["columns"],'strlen'))$K["indexes"][]=array("columns"=>array(1=>""));}if(!$K){foreach($x
as$y=>$w){$x[$y]["name"]=$y;$x[$y]["columns"][]="";}$x[]=array("columns"=>array(1=>""));$K["indexes"]=$x;}$Re=(JUSH=="sql"||JUSH=="mssql");$Zh=($_POST?$_POST["options"]:get_setting("index_options"));echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap">
<thead><tr>
<th id="label-type">',lang(187);$Vd=" class='idxopts".($Zh?"":" hidden")."'";if($ce)echo"<th id='label-algorithm'$Vd>".lang(188).doc_link(array('sql'=>'create-index.html#create-index-storage-engine-index-types','mariadb'=>'storage-engine-index-types/','pgsql'=>'indexes-types.html',));echo'<th><input type="submit" class="wayoff">',lang(189).($Re?"<span$Vd> (".lang(190).")</span>":"");if($Re||support("descidx"))echo
checkbox("options",1,$Zh,lang(108),"indexOptionsShow(this.checked)","jsonly")."\n";echo'<th id="label-name">',lang(191);if(support("partial_indexes"))echo"<th id='label-condition'$Vd>".lang(192);echo'<th><noscript>',icon("plus","add[0]","+",lang(109)),'</noscript>
</thead>
';if($G){echo"<tr><td>PRIMARY<td>";foreach($G["columns"]as$y=>$d)echo
select_input(" disabled",$o,$d),"<label><input disabled type='checkbox'>".lang(58)."</label> ";echo"<td><td>\n";}$_e=1;foreach($K["indexes"]as$w){if(!$_POST["drop_col"]||$_e!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$_e][type]",array(-1=>"")+$fe,$w["type"],($_e==count($K["indexes"])?"indexesAddRow.call(this);":""),"label-type");if($ce)echo"<td$Vd>".html_select("indexes[$_e][algorithm]",array_merge(array(""),$ce),$w['algorithm'],"label-algorithm");echo"<td>";ksort($w["columns"]);$t=1;foreach($w["columns"]as$y=>$d){echo"<span>".select_input(" name='indexes[$_e][columns][$t]' title='".lang(47)."'",($o?array_combine($o,$o):$o),$d,"partial(".($t==count($w["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape(JUSH=="sql"?"":$_GET["indexes"]."_")."')"),"<span$Vd>",($Re?"<input type='number' name='indexes[$_e][lengths][$t]' class='size' value='".h(idx($w["lengths"],$y))."' title='".lang(107)."'>":""),(support("descidx")?checkbox("indexes[$_e][descs][$t]",1,idx($w["descs"],$y),lang(58)):""),"</span> </span>";$t++;}echo"<td><input name='indexes[$_e][name]' value='".h($w["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n";if(support("partial_indexes"))echo"<td$Vd><input name='indexes[$_e][partial]' value='".h($w["partial"])."' autocapitalize='off' aria-labelledby='label-condition'>\n";echo"<td>".icon("cross","drop_col[$_e]","x",lang(112)).script("qsl('button').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$_e++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(14),'">
',input_token(),'</form>
';}elseif(isset($_GET["database"])){$K=$_POST;if($_POST&&!$m&&!$_POST["add"]){$B=trim($K["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(193),drop_databases(array(DB)));}elseif(DB!==$B){if(DB!=""){$_GET["db"]=$B;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($B),lang(194),rename_database($B,$K["collation"]));}else{$j=explode("\n",str_replace("\r","",$B));$si=true;$Ke="";foreach($j
as$k){if(count($j)==1||$k!=""){if(!create_database($k,$K["collation"]))$si=false;$Ke=$k;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($Ke),lang(195),$si);}}else{if(!$K["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($B).(preg_match('~^[a-z0-9_]+$~i',$K["collation"])?" COLLATE $K[collation]":""),substr(ME,0,-1),lang(196));}}page_header(DB!=""?lang(66):lang(116),$m,array(),h(DB));$lb=collations();$B=DB;if($_POST)$B=$K["name"];elseif(DB!="")$K["collation"]=db_collation(DB,$lb);elseif(JUSH=="sql"){foreach(get_vals("SHOW GRANTS")as$wd){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$wd,$A)&&$A[1]){$B=stripcslashes(idf_unescape("`$A[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add"]||strpos($B,"\n")?'<textarea autofocus name="name" rows="10" cols="40">'.h($B).'</textarea><br>':'<input name="name" autofocus value="'.h($B).'" data-maxlength="64" autocapitalize="off">')."\n".($lb?html_select("collation",array(""=>"(".lang(102).")")+$lb,$K["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",'mssql'=>"relational-databases/system-functions/sys-fn-helpcollations-transact-sql",)):""),'<input type="submit" value="',lang(14),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(128)."'>".confirm(lang(182,DB))."\n";elseif(!$_POST["add"]&&$_GET["db"]=="")echo
icon("plus","add[0]","+",lang(109))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["scheme"])){$K=$_POST;if($_POST&&!$m){$_=preg_replace('~ns=[^&]*&~','',ME)."ns=";if($_POST["drop"])query_redirect("DROP SCHEMA ".idf_escape($_GET["ns"]),$_,lang(197));else{$B=trim($K["name"]);$_
.=urlencode($B);if($_GET["ns"]=="")query_redirect("CREATE SCHEMA ".idf_escape($B),$_,lang(198));elseif($_GET["ns"]!=$B)query_redirect("ALTER SCHEMA ".idf_escape($_GET["ns"])." RENAME TO ".idf_escape($B),$_,lang(199));else
redirect($_);}}page_header($_GET["ns"]!=""?lang(67):lang(68),$m);if(!$K)$K["name"]=$_GET["ns"];echo'
<form action="" method="post">
<p><input name="name" autofocus value="',h($K["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($_GET["ns"]!="")echo"<input type='submit' name='drop' value='".lang(128)."'>".confirm(lang(182,$_GET["ns"]))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["call"])){$ca=($_GET["name"]?:$_GET["call"]);page_header(lang(200).": ".h($ca),$m);$_h=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Yd=array();$pg=array();foreach($_h["fields"]as$t=>$n){if(substr($n["inout"],-3)=="OUT"&&JUSH=='sql')$pg[$t]="@".idf_escape($n["field"])." AS ".idf_escape($n["field"]);if(!$n["inout"]||substr($n["inout"],0,2)=="IN")$Yd[]=$t;}if(!$m&&$_POST){$Ua=array();foreach($_h["fields"]as$y=>$n){$X="";if(in_array($y,$Yd)){$X=process_input($n);if($X===false)$X="''";if(isset($pg[$y]))connection()->query("SET @".idf_escape($n["field"])." = $X");}if(isset($pg[$y]))$Ua[]="@".idf_escape($n["field"]);elseif(in_array($y,$Yd))$Ua[]=$X;}$H=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($ca)."(".implode(", ",$Ua).")";$ni=microtime(true);$I=connection()->multi_query($H);$qa=connection()->affected_rows;echo
adminer()->selectQuery($H,$ni,!$I);if(!$I)echo"<p class='error'>".error()."\n";else{$h=connect();if($h)$h->select_db(DB);do{$I=connection()->store_result();if(is_object($I))print_select_result($I,$h);else
echo"<p class='message'>".lang(201,$qa)." <span class='time'>".@date("H:i:s")."</span>\n";}while(connection()->next_result());if($pg)print_select_result(connection()->query("SELECT ".implode(", ",$pg)));}}echo'
<form action="" method="post">
';if($Yd){echo"<table class='layout'>\n";foreach($Yd
as$y){$n=$_h["fields"][$y];$B=$n["field"];echo"<tr><th>".adminer()->fieldName($n);$Y=idx($_POST["fields"],$B);if($Y!=""){if($n["type"]=="set")$Y=implode(",",$Y);}input($n,$Y,idx($_POST["function"],$B,""));echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(200),'">
',input_token(),'</form>

<pre>
';function
pre_tr($Dh){return
preg_replace('~^~m','<tr>',preg_replace('~\|~','<td>',preg_replace('~\|$~m',"",rtrim($Dh))));}$R='(\+--[-+]+\+\n)';$K='(\| .* \|\n)';echo
preg_replace_callback("~^$R?$K$R?($K*)$R?~m",function($A){$ed=pre_tr($A[2]);return"<table>\n".($A[1]?"<thead>$ed</thead>\n":$ed).pre_tr($A[4])."\n</table>";},preg_replace('~(\n(    -|mysql)&gt; )(.+)~',"\\1<code class='jush-sql'>\\3</code>",preg_replace('~(.+)\n---+\n~',"<b>\\1</b>\n",h($_h['comment']))));echo'</pre>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$B=$_GET["name"];$K=$_POST;if($_POST&&!$m&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){if(!$_POST["drop"]){$K["source"]=array_filter($K["source"],'strlen');ksort($K["source"]);$Hi=array();foreach($K["source"]as$y=>$X)$Hi[$y]=$K["target"][$y];$K["target"]=$Hi;}if(JUSH=="sqlite")$I=recreate_table($a,$a,array(),array(),array(" $B"=>($K["drop"]?"":" ".format_foreign_key($K))));else{$b="ALTER TABLE ".table($a);$I=($B==""||queries("$b DROP ".(JUSH=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($B)));if(!$K["drop"])$I=queries("$b ADD".format_foreign_key($K));}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(202):($B!=""?lang(203):lang(204))),$I);if(!$K["drop"])$m=lang(205);}page_header(lang(206),$m,array("table"=>$a),h($a));if($_POST){ksort($K["source"]);if($_POST["add"])$K["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$K["target"]=array();}elseif($B!=""){$nd=foreign_keys($a);$K=$nd[$B];$K["source"][]="";}else{$K["table"]=$a;$K["source"]=array("");}echo'
<form action="" method="post">
';$ei=array_keys(fields($a));if($K["db"]!="")connection()->select_db($K["db"]);if($K["ns"]!=""){$lg=get_schema();set_schema($K["ns"]);}$lh=array_keys(array_filter(table_status('',true),'Adminer\fk_support'));$Hi=array_keys(fields(in_array($K["table"],$lh)?$K["table"]:reset($lh)));$Vf="this.form['change-js'].value = '1'; this.form.submit();";echo"<p><label>".lang(207).": ".html_select("table",$lh,$K["table"],$Vf)."</label>\n";if(support("scheme")){$Gh=array_filter(adminer()->schemas(),function($Fh){return!preg_match('~^information_schema$~i',$Fh);});echo"<label>".lang(75).": ".html_select("ns",$Gh,$K["ns"]!=""?$K["ns"]:$_GET["ns"],$Vf)."</label>";if($K["ns"]!="")set_schema($lg);}elseif(JUSH!="sqlite"){$Sb=array();foreach(adminer()->databases()as$k){if(!information_schema($k))$Sb[]=$k;}echo"<label>".lang(74).": ".html_select("db",$Sb,$K["db"]!=""?$K["db"]:$_GET["db"],$Vf)."</label>";}echo
input_hidden("change-js"),'<noscript><p><input type="submit" name="change" value="',lang(208),'"></noscript>
<table>
<thead><tr><th id="label-source">',lang(138),'<th id="label-target">',lang(139),'</thead>
';$_e=0;foreach($K["source"]as$y=>$X){echo"<tr>","<td>".html_select("source[".(+$y)."]",array(-1=>"")+$ei,$X,($_e==count($K["source"])-1?"foreignAddRow.call(this);":""),"label-source"),"<td>".html_select("target[".(+$y)."]",$Hi,idx($K["target"],$y),"","label-target");$_e++;}echo'</table>
<p>
<label>',lang(104),': ',html_select("on_delete",array(-1=>"")+explode("|",driver()->onActions),$K["on_delete"]),'</label>
<label>',lang(103),': ',html_select("on_update",array(-1=>"")+explode("|",driver()->onActions),$K["on_update"]),'</label>
',doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",'pgsql'=>"sql-createtable.html#SQL-CREATETABLE-REFERENCES",'mssql'=>"t-sql/statements/create-table-transact-sql",'oracle'=>"SQLRF01111",)),'<p>
<input type="submit" value="',lang(14),'">
<noscript><p><input type="submit" name="add" value="',lang(209),'"></noscript>
';if($B!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(182,$B));echo
input_token(),'</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$K=$_POST;$mg="VIEW";if(JUSH=="pgsql"&&$a!=""){$P=table_status1($a);$mg=strtoupper($P["Engine"]);}if($_POST&&!$m){$B=trim($K["name"]);$ya=" AS\n$K[select]";$Ve=ME."table=".urlencode($B);$mf=lang(210);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$B&&JUSH!="sqlite"&&$U=="VIEW"&&$mg=="VIEW")query_redirect((JUSH=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($B).$ya,$Ve,$mf);else{$Ji=$B."_adminer_".uniqid();drop_create("DROP $mg ".table($a),"CREATE $U ".table($B).$ya,"DROP $U ".table($B),"CREATE $U ".table($Ji).$ya,"DROP $U ".table($Ji),($_POST["drop"]?substr(ME,0,-1):$Ve),lang(211),$mf,lang(212),$a,$B);}}if(!$_POST&&$a!=""){$K=view($a);$K["name"]=$a;$K["materialized"]=($mg!="VIEW");if(!$m)$m=error();}page_header(($a!=""?lang(42):lang(213)),$m,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(191),': <input name="name" value="',h($K["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$K["materialized"],lang(132)):""),'<p>';textarea("select",$K["select"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($a!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(182,$a));echo
input_token(),'</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$re=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$oi=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$K=$_POST;if($_POST&&!$m){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(214));elseif(in_array($K["INTERVAL_FIELD"],$re)&&isset($oi[$K["STATUS"]])){$Eh="\nON SCHEDULE ".($K["INTERVAL_VALUE"]?"EVERY ".q($K["INTERVAL_VALUE"])." $K[INTERVAL_FIELD]".($K["STARTS"]?" STARTS ".q($K["STARTS"]):"").($K["ENDS"]?" ENDS ".q($K["ENDS"]):""):"AT ".q($K["STARTS"]))." ON COMPLETION".($K["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(215):lang(216)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$Eh.($aa!=$K["EVENT_NAME"]?"\nRENAME TO ".idf_escape($K["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($K["EVENT_NAME"]).$Eh)."\n".$oi[$K["STATUS"]]." COMMENT ".q($K["EVENT_COMMENT"]).rtrim(" DO\n$K[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(217).": ".h($aa):lang(218)),$m);if(!$K&&$aa!=""){$L=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$K=reset($L);}echo'
<form action="" method="post">
<table class="layout">
<tr><th>',lang(191),'<td><input name="EVENT_NAME" value="',h($K["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(219),'<td><input name="STARTS" value="',h("$K[EXECUTE_AT]$K[STARTS]"),'">
<tr><th title="datetime">',lang(220),'<td><input name="ENDS" value="',h($K["ENDS"]),'">
<tr><th>',lang(221),'<td><input type="number" name="INTERVAL_VALUE" value="',h($K["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$re,$K["INTERVAL_FIELD"]),'<tr><th>',lang(119),'<td>',html_select("STATUS",$oi,$K["STATUS"]),'<tr><th>',lang(49),'<td><input name="EVENT_COMMENT" value="',h($K["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$K["ON_COMPLETION"]=="PRESERVE",lang(222)),'</table>
<p>';textarea("EVENT_DEFINITION",$K["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($aa!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(182,$aa));echo
input_token(),'</form>
';}elseif(isset($_GET["procedure"])){$ca=($_GET["name"]?:$_GET["procedure"]);$_h=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$K=$_POST;$K["fields"]=(array)$K["fields"];if($_POST&&!process_fields($K["fields"])&&!$m){$ig=routine($_GET["procedure"],$_h);$Ji="$K[name]_adminer_".uniqid();foreach($K["fields"]as$y=>$n){if($n["field"]=="")unset($K["fields"][$y]);}drop_create("DROP $_h ".routine_id($ca,$ig),create_routine($_h,$K),"DROP $_h ".routine_id($K["name"],$K),create_routine($_h,array("name"=>$Ji)+$K),"DROP $_h ".routine_id($Ji,$K),substr(ME,0,-1),lang(223),lang(224),lang(225),$ca,$K["name"]);}page_header(($ca!=""?(isset($_GET["function"])?lang(226):lang(227)).": ".h($ca):(isset($_GET["function"])?lang(228):lang(229))),$m);if(!$_POST){if($ca=="")$K["language"]="sql";else{$K=routine($_GET["procedure"],$_h);$K["name"]=$ca;}}$lb=get_vals("SHOW CHARACTER SET");sort($lb);$Ah=routine_languages();echo($lb?"<datalist id='collations'>".optionlist($lb)."</datalist>":""),'
<form action="" method="post" id="form">
<p>',lang(191),': <input name="name" value="',h($K["name"]),'" data-maxlength="64" autocapitalize="off">
',($Ah?"<label>".lang(19).": ".html_select("language",$Ah,$K["language"])."</label>\n":""),'<input type="submit" value="',lang(14),'">
<div class="scrollable">
<table class="nowrap">
';edit_fields($K["fields"],$lb,$_h);if(isset($_GET["function"])){echo"<tr><td>".lang(230);edit_type("returns",(array)$K["returns"],$lb,array(),(JUSH=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$K["definition"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($ca!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(182,$ca));echo
input_token(),'</form>
';}elseif(isset($_GET["sequence"])){$ea=$_GET["sequence"];$K=$_POST;if($_POST&&!$m){$_=substr(ME,0,-1);$B=trim($K["name"]);if($_POST["drop"])query_redirect("DROP SEQUENCE ".idf_escape($ea),$_,lang(231));elseif($ea=="")query_redirect("CREATE SEQUENCE ".idf_escape($B),$_,lang(232));elseif($ea!=$B)query_redirect("ALTER SEQUENCE ".idf_escape($ea)." RENAME TO ".idf_escape($B),$_,lang(233));else
redirect($_);}page_header($ea!=""?lang(234).": ".h($ea):lang(235),$m);if(!$K)$K["name"]=$ea;echo'
<form action="" method="post">
<p><input name="name" value="',h($K["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($ea!="")echo"<input type='submit' name='drop' value='".lang(128)."'>".confirm(lang(182,$ea))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["type"])){$fa=$_GET["type"];$K=$_POST;if($_POST&&!$m){$_=substr(ME,0,-1);if($_POST["drop"])query_redirect("DROP TYPE ".idf_escape($fa),$_,lang(236));else
query_redirect("CREATE TYPE ".idf_escape(trim($K["name"]))." $K[as]",$_,lang(237));}page_header($fa!=""?lang(238).": ".h($fa):lang(239),$m);if(!$K)$K["as"]="AS ";echo'
<form action="" method="post">
<p>
';if($fa!=""){$mj=driver()->types();$Ec=type_values($mj[$fa]);if($Ec)echo"<code class='jush-".JUSH."'>ENUM (".h($Ec).")</code>\n<p>";echo"<input type='submit' name='drop' value='".lang(128)."'>".confirm(lang(182,$fa))."\n";}else{echo
lang(191).": <input name='name' value='".h($K['name'])."' autocapitalize='off'>\n",doc_link(array('pgsql'=>"datatype-enum.html",),"?");textarea("as",$K["as"]);echo"<p><input type='submit' value='".lang(14)."'>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["check"])){$a=$_GET["check"];$B=$_GET["name"];$K=$_POST;if($K&&!$m){if(JUSH=="sqlite")$I=recreate_table($a,$a,array(),array(),array(),"",array(),"$B",($K["drop"]?"":$K["clause"]));else{$I=($B==""||queries("ALTER TABLE ".table($a)." DROP CONSTRAINT ".idf_escape($B)));if(!$K["drop"])$I=queries("ALTER TABLE ".table($a)." ADD".($K["name"]!=""?" CONSTRAINT ".idf_escape($K["name"]):"")." CHECK ($K[clause])");}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(240):($B!=""?lang(241):lang(242))),$I);}page_header(($B!=""?lang(243).": ".h($B):lang(143)),$m,array("table"=>$a));if(!$K){$cb=driver()->checkConstraints($a);$K=array("name"=>$B,"clause"=>$cb[$B]);}echo'
<form action="" method="post">
<p>';if(JUSH!="sqlite")echo
lang(191).': <input name="name" value="'.h($K["name"]).'" data-maxlength="64" autocapitalize="off"> ';echo
doc_link(array('sql'=>"create-table-check-constraints.html",'mariadb'=>"constraint/",'pgsql'=>"ddl-constraints.html#DDL-CONSTRAINTS-CHECK-CONSTRAINTS",'mssql'=>"relational-databases/tables/create-check-constraints",'sqlite'=>"lang_createtable.html#check_constraints",),"?"),'<p>';textarea("clause",$K["clause"]);echo'<p><input type="submit" value="',lang(14),'">
';if($B!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(182,$B));echo
input_token(),'</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$B="$_GET[name]";$ij=trigger_options();$K=(array)trigger($B,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$m&&in_array($_POST["Timing"],$ij["Timing"])&&in_array($_POST["Event"],$ij["Event"])&&in_array($_POST["Type"],$ij["Type"])){$Sf=" ON ".table($a);$kc="DROP TRIGGER ".idf_escape($B).(JUSH=="pgsql"?$Sf:"");$Ve=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($kc,$Ve,lang(244));else{if($B!="")queries($kc);queries_redirect($Ve,($B!=""?lang(245):lang(246)),queries(create_trigger($Sf,$_POST)));if($B!="")queries(create_trigger($Sf,$K+array("Type"=>reset($ij["Type"]))));}}$K=$_POST;}page_header(($B!=""?lang(247).": ".h($B):lang(248)),$m,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table class="layout">
<tr><th>',lang(249),'<td>',html_select("Timing",$ij["Timing"],$K["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(250),'<td>',html_select("Event",$ij["Event"],$K["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$ij["Event"])?" <input name='Of' value='".h($K["Of"])."' class='hidden'>":""),'<tr><th>',lang(48),'<td>',html_select("Type",$ij["Type"],$K["Type"]),'</table>
<p>',lang(191),': <input name="Trigger" value="',h($K["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$K["Statement"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($B!="")echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(182,$B));echo
input_token(),'</form>
';}elseif(isset($_GET["user"])){$ga=$_GET["user"];$Zg=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$K){foreach(explode(",",($K["Privilege"]=="Grant option"?"":$K["Context"]))as$Bb)$Zg[$Bb][$K["Privilege"]]=$K["Comment"];}$Zg["Server Admin"]+=$Zg["File access on server"];$Zg["Databases"]["Create routine"]=$Zg["Procedures"]["Create routine"];unset($Zg["Procedures"]["Create routine"]);$Zg["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$Zg["Columns"][$X]=$Zg["Tables"][$X];unset($Zg["Server Admin"]["Usage"]);foreach($Zg["Tables"]as$y=>$X)unset($Zg["Databases"][$y]);$Af=array();if($_POST){foreach($_POST["objects"]as$y=>$X)$Af[$X]=(array)$Af[$X]+idx($_POST["grants"],$y,array());}$xd=array();$Qf="";if(isset($_GET["host"])&&($I=connection()->query("SHOW GRANTS FOR ".q($ga)."@".q($_GET["host"])))){while($K=$I->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$K[0],$A)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$A[1],$cf,PREG_SET_ORDER)){foreach($cf
as$X){if($X[1]!="USAGE")$xd["$A[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$K[0]))$xd["$A[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$K[0],$A))$Qf=$A[1];}}if($_POST&&!$m){$Rf=(isset($_GET["host"])?q($ga)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $Rf",ME."privileges=",lang(251));else{$Cf=q($_POST["user"])."@".q($_POST["host"]);$Eg=$_POST["pass"];if($Eg!=''&&!$_POST["hashed"]&&!min_version(8)){$Eg=get_val("SELECT PASSWORD(".q($Eg).")");$m=!$Eg;}$Gb=false;if(!$m){if($Rf!=$Cf){$Gb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $Cf IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($Eg));$m=!$Gb;}elseif($Eg!=$Qf)queries("SET PASSWORD FOR $Cf = ".q($Eg));}if(!$m){$xh=array();foreach($Af
as$Kf=>$wd){if(isset($_GET["grant"]))$wd=array_filter($wd);$wd=array_keys($wd);if(isset($_GET["grant"]))$xh=array_diff(array_keys(array_filter($Af[$Kf],'strlen')),$wd);elseif($Rf==$Cf){$Of=array_keys((array)$xd[$Kf]);$xh=array_diff($Of,$wd);$wd=array_diff($wd,$Of);unset($xd[$Kf]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$Kf,$A)&&(!grant("REVOKE",$xh,$A[2]," ON $A[1] FROM $Cf")||!grant("GRANT",$wd,$A[2]," ON $A[1] TO $Cf"))){$m=true;break;}}}if(!$m&&isset($_GET["host"])){if($Rf!=$Cf)queries("DROP USER $Rf");elseif(!isset($_GET["grant"])){foreach($xd
as$Kf=>$xh){if(preg_match('~^(.+)(\(.*\))?$~U',$Kf,$A))grant("REVOKE",array_keys($xh),$A[2]," ON $A[1] FROM $Cf");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(252):lang(253)),!$m);if($Gb)connection()->query("DROP USER $Cf");}}page_header((isset($_GET["host"])?lang(34).": ".h("$ga@$_GET[host]"):lang(153)),$m,array("privileges"=>array('',lang(70))));$K=$_POST;if($K)$xd=$Af;else{$K=$_GET+array("host"=>get_val("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$K["pass"]=$Qf;if($Qf!="")$K["hashed"]=true;$xd[(DB==""||$xd?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table class="layout">
<tr><th>',lang(33),'<td><input name="host" data-maxlength="60" value="',h($K["host"]),'" autocapitalize="off">
<tr><th>',lang(34),'<td><input name="user" data-maxlength="80" value="',h($K["user"]),'" autocapitalize="off">
<tr><th>',lang(35),'<td><input name="pass" id="pass" value="',h($K["pass"]),'" autocomplete="new-password">
',($K["hashed"]?"":script("typePassword(qs('#pass'));")),(min_version(8)?"":checkbox("hashed",1,$K["hashed"],lang(254),"typePassword(this.form['pass'], this.checked);")),'</table>

',"<table class='odds'>\n","<thead><tr><th colspan='2'>".lang(70).doc_link(array('sql'=>"grant.html#priv_level"));$t=0;foreach($xd
as$Kf=>$wd){echo'<th>'.($Kf!="*.*"?"<input name='objects[$t]' value='".h($Kf)."' size='10' autocapitalize='off'>":input_hidden("objects[$t]","*.*")."*.*");$t++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(33),"Databases"=>lang(36),"Tables"=>lang(134),"Columns"=>lang(47),"Procedures"=>lang(255),)as$Bb=>$ac){foreach((array)$Zg[$Bb]as$Yg=>$qb){echo"<tr><td".($ac?">$ac<td":" colspan='2'").' lang="en" title="'.h($qb).'">'.h($Yg);$t=0;foreach($xd
as$Kf=>$wd){$B="'grants[$t][".h(strtoupper($Yg))."]'";$Y=$wd[strtoupper($Yg)];if($Bb=="Server Admin"&&$Kf!=(isset($xd["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$B><option><option value='1'".($Y?" selected":"").">".lang(256)."<option value='0'".($Y=="0"?" selected":"").">".lang(257)."</select>";else
echo"<td align='center'><label class='block'>","<input type='checkbox' name=$B value='1'".($Y?" checked":"").($Yg=="All privileges"?" id='grants-$t-all'>":">".($Yg=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$t-all'); };"))),"</label>";$t++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(14),'">
';if(isset($_GET["host"]))echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(182,"$ga@$_GET[host]"));echo
input_token(),'</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$m){$Fe=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$Fe++;}queries_redirect(ME."processlist=",lang(258,$Fe),$Fe||!$_POST["kill"]);}}page_header(lang(117),$m);echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap checkable odds">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$t=-1;foreach(process_list()as$t=>$K){if(!$t){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($K
as$y=>$X)echo"<th>$y".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($y),'pgsql'=>"monitoring-stats.html#PG-STAT-ACTIVITY-VIEW",'oracle'=>"REFRN30223",));echo"</thead>\n";}echo"<tr>".(support("kill")?"<td>".checkbox("kill[]",$K[JUSH=="sql"?"Id":"pid"],0):"");foreach($K
as$y=>$X)echo"<td>".((JUSH=="sql"&&$y=="Info"&&preg_match("~Query|Killed~",$K["Command"])&&$X!="")||(JUSH=="pgsql"&&$y=="current_query"&&$X!="<IDLE>")||(JUSH=="oracle"&&$y=="sql_text"&&$X!="")?"<code class='jush-".JUSH."'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($K["db"]!=""?"db=".urlencode($K["db"])."&":"")."sql=".urlencode($X)).'">'.lang(259).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill"))echo($t+1)."/".lang(260,max_connections()),"<p><input type='submit' value='".lang(261)."'>\n";echo
input_token(),'</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$S=table_status1($a);$x=indexes($a);$o=fields($a);$nd=column_foreign_keys($a);$Mf=$S["Oid"];$pa=get_settings("adminer_import");$yh=array();$e=array();$Kh=array();$eg=array();$Ni="";foreach($o
as$y=>$n){$B=adminer()->fieldName($n);$zf=html_entity_decode(strip_tags($B),ENT_QUOTES);if(isset($n["privileges"]["select"])&&$B!=""){$e[$y]=$zf;if(is_shortable($n))$Ni=adminer()->selectLengthProcess();}if(isset($n["privileges"]["where"])&&$B!="")$Kh[$y]=$zf;if(isset($n["privileges"]["order"])&&$B!="")$eg[$y]=$zf;$yh+=$n["privileges"];}list($M,$yd)=adminer()->selectColumnsProcess($e,$x);$M=array_unique($M);$yd=array_unique($yd);$ve=count($yd)<count($M);$Z=adminer()->selectSearchProcess($o,$x);$dg=adminer()->selectOrderProcess($o,$x);$z=adminer()->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$rj=>$K){$ya=convert_field($o[key($K)]);$M=array($ya?:idf_escape(key($K)));$Z[]=where_check($rj,$o);$J=driver()->select($a,$M,$Z,$M);if($J)echo
first($J->fetch_row());}exit;}$G=$tj=array();foreach($x
as$w){if($w["type"]=="PRIMARY"){$G=array_flip($w["columns"]);$tj=($M?$G:array());foreach($tj
as$y=>$X){if(in_array(idf_escape($y),$M))unset($tj[$y]);}break;}}if($Mf&&!$G){$G=$tj=array($Mf=>0);$x[]=array("type"=>"PRIMARY","columns"=>array($Mf));}if($_POST&&!$m){$Qj=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$cb=array();foreach($_POST["check"]as$Ya)$cb[]=where_check($Ya,$o);$Qj[]="((".implode(") OR (",$cb)."))";}$Qj=($Qj?"\nWHERE ".implode(" AND ",$Qj):"");if($_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers($a);adminer()->dumpTable($a,"");$rd=($M?implode(", ",$M):"*").convert_fields($e,$o,$M)."\nFROM ".table($a);$_d=($yd&&$ve?"\nGROUP BY ".implode(", ",$yd):"").($dg?"\nORDER BY ".implode(", ",$dg):"");$H="SELECT $rd$Qj$_d";if(is_array($_POST["check"])&&!$G){$pj=array();foreach($_POST["check"]as$X)$pj[]="(SELECT".limit($rd,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o).$_d,1).")";$H=implode(" UNION ALL ",$pj);}adminer()->dumpData($a,"table",$H);adminer()->dumpFooter();exit;}if(!adminer()->selectEmailProcess($Z,$nd)){if($_POST["save"]||$_POST["delete"]){$I=true;$qa=0;$O=array();if(!$_POST["delete"]){foreach($_POST["fields"]as$B=>$X){$X=process_input($o[$B]);if($X!==null&&($_POST["clone"]||$X!==false))$O[idf_escape($B)]=($X!==false?$X:idf_escape($B));}}if($_POST["delete"]||$O){$H=($_POST["clone"]?"INTO ".table($a)." (".implode(", ",array_keys($O)).")\nSELECT ".implode(", ",$O)."\nFROM ".table($a):"");if($_POST["all"]||($G&&is_array($_POST["check"]))||$ve){$I=($_POST["delete"]?driver()->delete($a,$Qj):($_POST["clone"]?queries("INSERT $H$Qj".driver()->insertReturning($a)):driver()->update($a,$O,$Qj)));$qa=connection()->affected_rows;if(is_object($I))$qa+=$I->num_rows;}else{foreach((array)$_POST["check"]as$X){$Pj="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o);$I=($_POST["delete"]?driver()->delete($a,$Pj,1):($_POST["clone"]?queries("INSERT".limit1($a,$H,$Pj)):driver()->update($a,$O,$Pj,1)));if(!$I)break;$qa+=connection()->affected_rows;}}}$mf=lang(262,$qa);if($_POST["clone"]&&$I&&$qa==1){$Le=last_id($I);if($Le)$mf=lang(175," $Le");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$mf,$I);if(!$_POST["delete"]){$Qg=(array)$_POST["fields"];edit_form($a,array_intersect_key($o,$Qg),$Qg,!$_POST["clone"],$m);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$m=lang(263);else{$I=true;$qa=0;foreach($_POST["val"]as$rj=>$K){$O=array();foreach($K
as$y=>$X){$y=bracket_escape($y,true);$O[idf_escape($y)]=(preg_match('~char|text~',$o[$y]["type"])||$X!=""?adminer()->processInput($o[$y],$X):"NULL");}$I=driver()->update($a,$O," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($rj,$o),($ve||$G?0:1)," ");if(!$I)break;$qa+=connection()->affected_rows;}queries_redirect(remove_from_uri(),lang(262,$qa),$I);}}elseif(!is_string($bd=get_file("csv_file",true)))$m=upload_error($bd);elseif(!preg_match('~~u',$bd))$m=lang(264);else{save_settings(array("output"=>$pa["output"],"format"=>$_POST["separator"]),"adminer_import");$I=true;$mb=array_keys($o);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$bd,$cf);$qa=count($cf[0]);driver()->begin();$Qh=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$L=array();foreach($cf[0]as$y=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$Qh]*)$Qh~",$X.$Qh,$df);if(!$y&&!array_diff($df[1],$mb)){$mb=$df[1];$qa--;}else{$O=array();foreach($df[1]as$t=>$jb)$O[idf_escape($mb[$t])]=($jb==""&&$o[$mb[$t]]["null"]?"NULL":q(preg_match('~^".*"$~s',$jb)?str_replace('""','"',substr($jb,1,-1)):$jb));$L[]=$O;}}$I=(!$L||driver()->insertUpdate($a,$L,$G));if($I)driver()->commit();queries_redirect(remove_from_uri("page"),lang(265,$qa),$I);driver()->rollback();}}}$zi=adminer()->tableName($S);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(52).": $zi",$m);$O=null;if(isset($yh["insert"])||!support("table")){$vg=array();foreach((array)$_GET["where"]as$X){if(isset($nd[$X["col"]])&&count($nd[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&(is_array($X["val"])||!preg_match('~[_%]~',$X["val"])))))$vg["set"."[".bracket_escape($X["col"])."]"]=$X["val"];}$O=$vg?"&".http_build_query($vg):"";}adminer()->selectLinks($S,$O);if(!$e&&support("table"))echo"<p class='error'>".lang(266).($o?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?input_hidden("db",DB).(isset($_GET["ns"])?input_hidden("ns",$_GET["ns"]):""):""),input_hidden("select",$a),"</div>\n";adminer()->selectColumnsPrint($M,$e);adminer()->selectSearchPrint($Z,$Kh,$x);adminer()->selectOrderPrint($dg,$eg,$x);adminer()->selectLimitPrint($z);adminer()->selectLengthPrint($Ni);adminer()->selectActionPrint($x);echo"</form>\n";$D=$_GET["page"];$qd=null;if($D=="last"){$qd=get_val(count_rows($a,$Z,$ve,$yd));$D=floor(max(0,intval($qd)-1)/$z);}$Lh=$M;$zd=$yd;if(!$Lh){$Lh[]="*";$Cb=convert_fields($e,$o,$M);if($Cb)$Lh[]=substr($Cb,2);}foreach($M
as$y=>$X){$n=$o[idf_unescape($X)];if($n&&($ya=convert_field($n)))$Lh[$y]="$ya AS $X";}if(!$ve&&$tj){foreach($tj
as$y=>$X){$Lh[]=idf_escape($y);if($zd)$zd[]=idf_escape($y);}}$I=driver()->select($a,$Lh,$Z,$zd,$dg,$z,$D,true);if(!$I)echo"<p class='error'>".error()."\n";else{if(JUSH=="mssql"&&$D)$I->seek($z*$D);$yc=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$L=array();while($K=$I->fetch_assoc()){if($D&&JUSH=="oracle")unset($K["RNUM"]);$L[]=$K;}if($_GET["page"]!="last"&&$z&&$yd&&$ve&&JUSH=="sql")$qd=get_val(" SELECT FOUND_ROWS()");if(!$L)echo"<p class='message'>".lang(12)."\n";else{$Ga=adminer()->backwardKeys($a,$zi);echo"<div class='scrollable'>","<table id='table' class='nowrap checkable odds'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$yd&&$M?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(267)."</a>");$_f=array();$td=array();reset($M);$ih=1;foreach($L[0]as$y=>$X){if(!isset($tj[$y])){$X=idx($_GET["columns"],key($M))?:array();$n=$o[$M?($X?$X["col"]:current($M)):$y];$B=($n?adminer()->fieldName($n,$ih):($X["fun"]?"*":h($y)));if($B!=""){$ih++;$_f[$y]=$B;$d=idf_escape($y);$Pd=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($y);$ac="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($y))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});","");$sd=apply_sql_function($X["fun"],$B);$di=isset($n["privileges"]["order"])||$sd;echo($di?"<a href='".h($Pd.($dg[0]==$d||$dg[0]==$y||(!$dg&&$ve&&$yd[0]==$d)?$ac:''))."'>$sd</a>":$sd),"<span class='column hidden'>";if($di)echo"<a href='".h($Pd.$ac)."' title='".lang(58)."' class='text'> ↓</a>";if(!$X["fun"]&&isset($n["privileges"]["where"]))echo'<a href="#fieldset-search" title="'.lang(55).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($y)."');");echo"</span>";}$td[$y]=$X["fun"];next($M);}}$Re=array();if($_GET["modify"]){foreach($L
as$K){foreach($K
as$y=>$X)$Re[$y]=max($Re[$y],min(40,strlen(utf8_decode($X))));}}echo($Ga?"<th>".lang(268):"")."</thead>\n";if(is_ajax())ob_end_clean();foreach(adminer()->rowDescriptions($L,$nd)as$yf=>$K){$qj=unique_array($L[$yf],$x);if(!$qj){$qj=array();reset($M);foreach($L[$yf]as$y=>$X){if(!preg_match('~^(COUNT|AVG|GROUP_CONCAT|MAX|MIN|SUM)\(~',current($M)))$qj[$y]=$X;next($M);}}$rj="";foreach($qj
as$y=>$X){$n=(array)$o[$y];if((JUSH=="sql"||JUSH=="pgsql")&&preg_match('~char|text|enum|set~',$n["type"])&&strlen($X)>64){$y=(strpos($y,'(')?$y:idf_escape($y));$y="MD5(".(JUSH!='sql'||preg_match("~^utf8~",$n["collation"])?$y:"CONVERT($y USING ".charset(connection()).")").")";$X=md5($X);}$rj
.="&".($X!==null?urlencode("where[".bracket_escape($y)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($y));}echo"<tr>".(!$yd&&$M?"":"<td>".checkbox("check[]",substr($rj,1),in_array(substr($rj,1),(array)$_POST["check"])).($ve||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$rj)."' class='edit'>".lang(269)."</a>"));reset($M);foreach($K
as$y=>$X){if(isset($_f[$y])){$d=current($M);$n=(array)$o[$y];$X=driver()->value($X,$n);if($X!=""&&(!isset($yc[$y])||$yc[$y]!=""))$yc[$y]=(is_mail($X)?$_f[$y]:"");$_="";if(preg_match('~blob|bytea|raw|file~',$n["type"])&&$X!="")$_=ME.'download='.urlencode($a).'&field='.urlencode($y).$rj;if(!$_&&$X!==null){foreach((array)$nd[$y]as$q){if(count($nd[$y])==1||end($q["source"])==$y){$_="";foreach($q["source"]as$t=>$ei)$_
.=where_link($t,$q["target"][$t],$L[$yf][$ei]);$_=($q["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($q["db"]),ME):ME).'select='.urlencode($q["table"]).$_;if($q["ns"])$_=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($q["ns"]),$_);if(count($q["source"])==1)break;}}}if($d=="COUNT(*)"){$_=ME."select=".urlencode($a);$t=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$qj))$_
.=where_link($t++,$W["col"],$W["val"],$W["op"]);}foreach($qj
as$Be=>$W)$_
.=where_link($t++,$Be,$W);}$Qd=select_value($X,$_,$n,$Ni);$u=h("val[$rj][".bracket_escape($y)."]");$Rg=idx(idx($_POST["val"],$rj),bracket_escape($y));$tc=!is_array($K[$y])&&is_utf8($Qd)&&$L[$yf][$y]==$K[$y]&&!$td[$y]&&!$n["generated"];$U=(preg_match('~^(AVG|MIN|MAX)\((.+)\)~',$d,$A)?$o[idf_unescape($A[2])]["type"]:$n["type"]);$Li=preg_match('~text|json|lob~',$U);$we=preg_match(number_type(),$U)||preg_match('~^(CHAR_LENGTH|ROUND|FLOOR|CEIL|TIME_TO_SEC|COUNT|SUM)\(~',$d);echo"<td id='$u'".($we&&($X===null||is_numeric(strip_tags($Qd))||$U=="money")?" class='number'":"");if(($_GET["modify"]&&$tc&&$X!==null)||$Rg!==null){$Cd=h($Rg!==null?$Rg:$K[$y]);echo">".($Li?"<textarea name='$u' cols='30' rows='".(substr_count($K[$y],"\n")+1)."'>$Cd</textarea>":"<input name='$u' value='$Cd' size='$Re[$y]'>");}else{$Xe=strpos($Qd,"<i>…</i>");echo" data-text='".($Xe?2:($Li?1:0))."'".($tc?"":" data-warning='".h(lang(270))."'").">$Qd";}}next($M);}if($Ga)echo"<td>";adminer()->backwardKeysPrint($Ga,$L[$yf]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($L||$D){$Lc=true;if($_GET["page"]!="last"){if(!$z||(count($L)<$z&&($L||!$D)))$qd=($D?$D*$z:0)+count($L);elseif(JUSH!="sql"||!$ve){$qd=($ve?false:found_rows($S,$Z));if(intval($qd)<max(1e4,2*($D+1)*$z))$qd=first(slow_query(count_rows($a,$Z,$ve,$yd)));else$Lc=false;}}$tg=($z&&($qd===false||$qd>$z||$D));if($tg)echo(($qd===false?count($L)+1:$qd-$D*$z)>$z?'<p><a href="'.h(remove_from_uri("page")."&page=".($D+1)).'" class="loadmore">'.lang(271).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, $z, '".lang(272)."…');",""):''),"\n";echo"<div class='footer'><div>\n";if($tg){$ff=($qd===false?$D+(count($L)>=$z?2:1):floor(($qd-1)/$z));echo"<fieldset>";if(JUSH!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(273)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(273)."', '".($D+1)."')); return false; };"),pagination(0,$D).($D>5?" …":"");for($t=max(1,$D-4);$t<min($ff,$D+5);$t++)echo
pagination($t,$D);if($ff>0)echo($D+5<$ff?" …":""),($Lc&&$qd!==false?pagination($ff,$D):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$ff'>".lang(274)."</a>");}else
echo"<legend>".lang(273)."</legend>",pagination(0,$D).($D>1?" …":""),($D?pagination($D,$D):""),($ff>$D?pagination($D+1,$D).($ff>$D+1?" …":""):"");echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(275)."</legend>";$hc=($Lc?"":"~ ").$qd;$Wf="const checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$hc' : checked); selectCount('selected2', this.checked || !checked ? '$hc' : checked);";echo
checkbox("all",1,0,($qd!==false?($Lc?"":"~ ").lang(157,$qd):""),$Wf)."\n","</fieldset>\n";if(adminer()->selectCommandPrint())echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(267),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(263).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(127),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(259),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';$od=adminer()->dumpFormat();foreach((array)$_GET["columns"]as$d){if($d["fun"]){unset($od['sql']);break;}}if($od){print_fieldset("export",lang(72)." <span id='selected2'></span>");$qg=adminer()->dumpOutput();echo($qg?html_select("output",$qg,$pa["output"])." ":""),html_select("format",$od,$pa["format"])," <input type='submit' name='export' value='".lang(72)."'>\n","</div></fieldset>\n";}adminer()->selectEmailPrint(array_filter($yc,'strlen'),$e);echo"</div></div>\n";}if(adminer()->selectImportPrint())echo"<p>","<a href='#import'>".lang(71)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import'".($_POST["import"]?"":" class='hidden'").">: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$pa["format"])," <input type='submit' name='import' value='".lang(71)."'>","</span>";echo
input_token(),"</form>\n",(!$yd&&$M?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$P=isset($_GET["status"]);page_header($P?lang(119):lang(118));$Gj=($P?show_status():show_variables());if(!$Gj)echo"<p class='message'>".lang(12)."\n";else{echo"<table>\n";foreach($Gj
as$K){echo"<tr>";$y=array_shift($K);echo"<th><code class='jush-".JUSH.($P?"status":"set")."'>".h($y)."</code>";foreach($K
as$X)echo"<td>".nl_br(h($X));}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$vi=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$B=>$S){json_row("Comment-$B",h($S["Comment"]));if(!is_view($S)){foreach(array("Engine","Collation")as$y)json_row("$y-$B",h($S[$y]));foreach($vi+array("Auto_increment"=>0,"Rows"=>0)as$y=>$X){if($S[$y]!=""){$X=format_number($S[$y]);if($X>=0)json_row("$y-$B",($y=="Rows"&&$X&&$S["Engine"]==(JUSH=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($vi[$y]))$vi[$y]+=($S["Engine"]!="InnoDB"||$y!="Data_free"?$S[$y]:0);}elseif(array_key_exists($y,$S))json_row("$y-$B","?");}}}foreach($vi
as$y=>$X)json_row("sum-$y",format_number($X));json_row("");}elseif($_GET["script"]=="kill")connection()->query("KILL ".number($_POST["kill"]));else{foreach(count_tables(adminer()->databases())as$k=>$X){json_row("tables-$k",$X);json_row("size-$k",db_size($k));}json_row("");}exit;}else{$Fi=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($Fi&&!$m&&!$_POST["search"]){$I=true;$mf="";if(JUSH=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$I=truncate_tables($_POST["tables"]);$mf=lang(276);}elseif($_POST["move"]){$I=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$mf=lang(277);}elseif($_POST["copy"]){$I=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$mf=lang(278);}elseif($_POST["drop"]){if($_POST["views"])$I=drop_views($_POST["views"]);if($I&&$_POST["tables"])$I=drop_tables($_POST["tables"]);$mf=lang(279);}elseif(JUSH=="sqlite"&&$_POST["check"]){foreach((array)$_POST["tables"]as$R){foreach(get_rows("PRAGMA integrity_check(".q($R).")")as$K)$mf
.="<b>".h($R)."</b>: ".h($K["integrity_check"])."<br>";}}elseif(JUSH!="sql"){$I=(JUSH=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$mf=lang(280);}elseif(!$_POST["tables"])$mf=lang(9);elseif($I=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('Adminer\idf_escape',$_POST["tables"])))){while($K=$I->fetch_assoc())$mf
.="<b>".h($K["Table"])."</b>: ".h($K["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$mf,$I);}page_header(($_GET["ns"]==""?lang(36).": ".h(DB):lang(75).": ".h($_GET["ns"])),$m,true);if(adminer()->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(281)."</h3>\n";$Ei=tables_list();if(!$Ei)echo"<p class='message'>".lang(9)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(282)." <span id='selected2'></span></legend><div>","<input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(55)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=driver()->convertOperator("LIKE %%");search_tables();}}echo"<div class='scrollable'>\n","<table class='nowrap checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(134),'<td>'.lang(283).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(123).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(284).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT','oracle'=>'REFRN20286')),'<td>'.lang(285).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT')),'<td>'.lang(286).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(50).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(287).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'catalog-pg-class.html#CATALOG-PG-CLASS','oracle'=>'REFRN20286')),(support("comment")?'<td>'.lang(49).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-info.html#FUNCTIONS-INFO-COMMENT-TABLE')):''),"</thead>\n";$T=0;foreach($Ei
as$B=>$U){$Jj=($U!==null&&!preg_match('~table|sequence~i',$U));$u=h("Table-".$B);echo'<tr><td>'.checkbox(($Jj?"views[]":"tables[]"),$B,in_array("$B",$Fi,true),"","","",$u),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($B)."' title='".lang(41)."' id='$u'>".h($B).'</a>':h($B));if($Jj)echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($B).'" title="'.lang(42).'">'.(preg_match('~materialized~i',$U)?lang(132):lang(133)).'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($B).'" title="'.lang(40).'">?</a>';else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(43)),"Index_length"=>array("indexes",lang(137)),"Data_free"=>array("edit",lang(44)),"Auto_increment"=>array("auto_increment=1&create",lang(43)),"Rows"=>array("select",lang(40)),)as$y=>$_){$u=" id='$y-".h($B)."'";echo($_?"<td align='right'>".(support("table")||$y=="Rows"||(support("indexes")&&$y!="Data_length")?"<a href='".h(ME."$_[0]=").urlencode($B)."'$u title='$_[1]'>?</a>":"<span$u>?</span>"):"<td id='$y-".h($B)."'>");}$T++;}echo(support("comment")?"<td id='Comment-".h($B)."'>":""),"\n";}echo"<tr><td><th>".lang(260,count($Ei)),"<td>".h(JUSH=="sql"?get_val("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$y)echo"<td align='right' id='sum-$y'>";echo"\n","</table>\n","</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$Dj="<input type='submit' value='".lang(288)."'> ".on_help("'VACUUM'");$Zf="<input type='submit' name='optimize' value='".lang(289)."'> ".on_help(JUSH=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(127)." <span id='selected'></span></legend><div>".(JUSH=="sqlite"?$Dj."<input type='submit' name='check' value='".lang(290)."'> ".on_help("'PRAGMA integrity_check'"):(JUSH=="pgsql"?$Dj.$Zf:(JUSH=="sql"?"<input type='submit' value='".lang(291)."'> ".on_help("'ANALYZE TABLE'").$Zf."<input type='submit' name='check' value='".lang(290)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(292)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(293)."'> ".on_help(JUSH=="sqlite"?"'DELETE'":"'TRUNCATE".(JUSH=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(128)."'>".on_help("'DROP TABLE'").confirm()."\n";$j=(support("scheme")?adminer()->schemas():adminer()->databases());if(count($j)!=1&&JUSH!="sqlite"){$k=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p><label>".lang(294).": ",($j?html_select("target",$j,$k):'<input name="target" value="'.h($k).'" autocapitalize="off">'),"</label> <input type='submit' name='move' value='".lang(295)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(296)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(297)):""),"\n";}echo"<input type='hidden' name='all' value=''>",script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $T);":"")." }"),input_token(),"</div></fieldset>\n","</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo"<p class='links'><a href='".h(ME)."create='>".lang(73)."</a>\n",(support("view")?"<a href='".h(ME)."view='>".lang(213)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(150)."</h3>\n";$Bh=routines();if($Bh){echo"<table class='odds'>\n",'<thead><tr><th>'.lang(191).'<td>'.lang(48).'<td>'.lang(230)."<td></thead>\n";foreach($Bh
as$K){$B=($K["SPECIFIC_NAME"]==$K["ROUTINE_NAME"]?"":"&name=".urlencode($K["ROUTINE_NAME"]));echo'<tr>','<th><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($K["SPECIFIC_NAME"]).$B).'">'.h($K["ROUTINE_NAME"]).'</a>','<td>'.h($K["ROUTINE_TYPE"]),'<td>'.h($K["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($K["SPECIFIC_NAME"]).$B).'">'.lang(140)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(229).'</a>':'').'<a href="'.h(ME).'function=">'.lang(228)."</a>\n";}if(support("sequence")){echo"<h3 id='sequences'>".lang(298)."</h3>\n";$Th=get_vals("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = current_schema() ORDER BY sequence_name");if($Th){echo"<table class='odds'>\n","<thead><tr><th>".lang(191)."</thead>\n";foreach($Th
as$X)echo"<tr><th><a href='".h(ME)."sequence=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."sequence='>".lang(235)."</a>\n";}if(support("type")){echo"<h3 id='user-types'>".lang(31)."</h3>\n";$Bj=types();if($Bj){echo"<table class='odds'>\n","<thead><tr><th>".lang(191)."</thead>\n";foreach($Bj
as$X)echo"<tr><th><a href='".h(ME)."type=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."type='>".lang(239)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(151)."</h3>\n";$L=get_rows("SHOW EVENTS");if($L){echo"<table>\n","<thead><tr><th>".lang(191)."<td>".lang(299)."<td>".lang(219)."<td>".lang(220)."<td></thead>\n";foreach($L
as$K)echo"<tr>","<th>".h($K["Name"]),"<td>".($K["Execute at"]?lang(300)."<td>".$K["Execute at"]:lang(221)." ".$K["Interval value"]." ".$K["Interval field"]."<td>$K[Starts]"),"<td>$K[Ends]",'<td><a href="'.h(ME).'event='.urlencode($K["Name"]).'">'.lang(140).'</a>';echo"</table>\n";$Jc=get_val("SELECT @@event_scheduler");if($Jc&&$Jc!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($Jc)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(218)."</a>\n";}if($Ei)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}}page_footer();